import spacy
from spacy.tokens import Span

nlp = spacy.blank("de")

# Definiere die Methode
def to_html(span, tag):
    # Verpacke den Text der Span in einem HTML-Tag und gebe ihn zurück
    return f"<{tag}>{span.text}</{tag}>"


# Registriere die Span-Erweiterung "to_html" mit der Methode to_html
Span.set_extension("to_html", method=to_html)

# Verarbeite den Text und rufe die Methode to_html mit dem Tag "strong" auf
doc = nlp("Hallo Welt, dies ist ein Satz.")
span = doc[0:2]
print(span._.to_html("strong"))
