---
type: slides
---

# 总结

Notes: 恭喜你！我们已经学习到这门课程的尾声了！

---

# 你的新spaCy技能

- 抽取**语言学特征**：词性识别，依存关系，命名实体
- 学会使用训练好的的**流程**
- 用`Matcher`和`PhraseMatcher`来**匹配规则**寻找目标词汇和短语
- 使用**数据结构**`Doc`、`Token`、`Span`、`Vocab`和`Lexeme`的最佳实践
- 使用**词向量**来计算**语义相似度**
- 编写定制化的**流程组件**来生成**扩展属性**
- **规模化**你的spaCy流程使其运行速度更快
- 为spaCy的统计模型创建**训练数据**
- 用新数据**训练和更新**spaCy的神经网络模型

Notes: 这里我们总结一下我们已经学过的所有新技能：

第一章中我们学习了如何抽取语言学特征，比如词性标注的标签、依存句法关系和命名实体等，
以及如何使用训练好的流程。

我们还学习了书写一些非常强大的匹配模板来用spaCy的匹配器`Matcher`和`PhraseMatcher`
抽取目标词汇和短语。

第二章是关于信息提取，我们学习到如何使用数据结构`Doc`、`Token`和`Span`，以及`Vocab`
和词条(lexical entries)。

我们还用spaCy读取词向量来计算语义相似度。

第三章中我们深入研究了spaCy的流程，学习如何书写我们自己定制化的流程组件来更改输入的doc。

我们还为doc、token和span创建了我们自己的定制化扩展属性，还学习到了流处理的方法来让我们
的流程跑得更快。

最后，在第四章中我们学习了如何训练和更新spaCy的统计模型，特别是命名实体识别器。

我们学习了不少有用的技巧来创建训练数据，以及如何设计我们的标注内容来得到最好的结果。

---

# spaCy还能做更多(1)

- [训练和更新](https://spacy.io/usage/training)其它流程组件
  - 词性标注器
  - 依存关系解析器
  - 文本分类器

Notes: 当然spaCy还能做很多其它的东西，我们这门课还没有讲到。

我们之前一直专注在训练命名实体识别器，我们其实也可以训练和更新其它的统计流程组件，
比如词性标注器和依存关系解析器。

另一个有用的流程组件是文本分类器，可以学习到对整个文本的类别预测。这不是预训练模型
的一部分，但我们可以把它加到已有模型中然后用我们自己的数据去训练它。

---

# spaCy还能做更多(2)

- [定制化分词器](https://spacy.io/usage/linguistic-features#tokenization)
  - 增加规则和异常来用不同的方法分割文本
- [增加或者改进对其它语种的支持](https://spacy.io/usage/adding-languages)
  - 现在支持60+种语言
  - 已有语种的支持还有很大改进空间，还有更多语种有待添加支持
  - 允许对其它语种训练模型

Notes: 这门课程中我们一直默认使用了spaCy自带的分词器。但我们其实也可以定制分词器。

spaCy允许我们定制化规则来决定在哪里和怎样分隔文本。

我们还可以加入和优化对其它语种的支持。

spaCy已经支持很多种不同语言的分词，但仍有很大的改进空间。

对一个新语种开发分词支持是训练该语种统计模型的第一步。

---

# 更多信息和文档请参见我们的网站！

<img src="/website.png" alt="展示spacy.io网站的笔记本电脑" width="50%" />

👉 [spacy.io](https://spacy.io)

Notes: 更多示例、教程和详细的API文档，请参见spaCy网站。


---

# 谢谢，再见！ 👋

Notes: 非常感谢你学习这门课程！我希望你觉得从中发现乐趣，我也很想了解你用
spaCy打造了那些酷毙了的应用？
