---
type: slides
---

# 训练spaCy模型的最佳实践

Notes: 当我们开始跑自己实验的时候，我们可能发现很多东西并不像我们想象的那样
运作完美。这是很正常的。

训练模型是一个迭代的过程，我们需要试很多不同的东西来看怎样才能有最好的结果。

本节课中，我们分享一些训练自己模型的最佳实践和需要铭记在心的要点。

让我们来看看可能遇到的一些问题。

---

# 问题一：模型“忘记”了东西

- 已有的模型可能会在新数据上过拟合
  - 举个例子：如果我们只是想给模型更新一个`"WEBSITE"`的类别，模型有可能会“忘记”
    之前`"PERSON"`这个类别。
- 这也被称为“灾难性遗忘”的问题。

Notes: 统计模型可以学会很多东西，但它们也会忘记东西。

如果我们用新的数据更新已有模型，特别是更新一些新的标注，模型可能会过拟合，针对新的
例子做出了 _过多_ 调整。

举个例子，我们想用"WEBSITE"的例子来更新模型，结果模型就可能“忘记”了之前本来可以预测
正确的诸如"PERSON"这样的类别。

这也被称作“灾难性遗忘”的问题。

---

# 解决方法一：将之前的正确预测结果混合进来

- 举个例子，我们要训练`"WEBSITE"`，但我们也把`"PERSON"`的例子加进来。
- 在数据上跑已有的spaCy模型然后抽取所有其它相关的实体。

Note: 要预防灾难性遗忘问题，我们要确保总是在训练数据中混入一些之前模型预测
正确的例子。

如果我们要训练一个新的类别`"WEBSITE"`，我们就也要把旧的类别`"PERSON"`的例子
包括进来。

spaCy可以帮我们做到这点。我们可以在数据上先跑已有的模型，抽取我们感兴趣的实体，
然后把结果做为新增的训练例子。

然后我们可以把这些例子与我们已有的数据混合起来，用所有类别的标注数据来更新模型。

---

# 问题二：模型不能学会所有东西

- spaCy的模型基于**本地语境**作出预测。
- 如果基于语境本身就很难做出判断，那模型也很难学得会
- 标签种类最好前后一致，也不要过于特殊
  - 比如，`"CLOTHING"`这个类别就要比`"ADULT_CLOTHING"`和`"CHILDRENS_CLOTHING"`更
好。

Notes: 另一个常见的问题是我们的模型不见得就能学到我们想让它学到的东西。

spaCy的模型是基于本地语境作出预测，比如对命名实体来说，目标词符周围的词是最重要的。

如果基于语境本身就很难做出判断，那模型也很难学得会。

标签种类最好前后一致，也不要过于特殊。

举个例子，可能模型很难学会基于语境预测一段文本是成人服饰还是儿童服饰，但如果
只是预测“服饰”模型就能表现得好很多。

---

# 解决方法二：仔细计划标签种类

- 选择那些能从本地语境中反映出来的类别
- 更通用的标签要好过更特定的标签
- 我们可以用规则把通用标签转化为特定种类

**不好的做法：**

```python
LABELS = ["ADULT_SHOES", "CHILDRENS_SHOES", "BANDS_I_LIKE"]
```

**好的做法：**

```python
LABELS = ["CLOTHING", "BAND"]
```

Notes: 我们在训练和更新模型之前，值得先暂停一下，先计划好我们的标签内容。

尽量选择那些能从本地语境中反映出来的类别，而且越通用越好。

我们可以最后再添加基于规则的系统把通用标签转化为特定种类。

通用标签如“服饰”或者“乐队”更容易被标注也更容易被模型学习。

---

# 上手练习吧！

Notes: 让我们来看一些语境中的问题并解决它们。
