---
type: slides
---

# まとめ

Notes: おめでとうございます！コースの最後までやり遂げましたね！

---

# あなたが学んだ新しいspaCyのスキル

- **言語的特徴**の抽出：品詞タグ、依存関係、固有表現
- 事前に訓練された**機械学習モデル**を使用した作業
- Matcherと`PhraseMatcher`による**ルールベースマッチ**を使った単語やフレーズの検索
- `Doc`、`Token`、`Span`、`Vocab`、`Lexeme` **データ構造**を扱うためのベストプラクティス
- **単語ベクトル**を使った**類似度**の計算
- **拡張属性**を使ったカスタム**パイプラインコンポーネント**の作成
- spaCyパイプラインの**スケールアップ**と高速化
- spaCyの機械学習モデルのための**トレーニングデータ**の作成
- 新しいデータを使用したspaCyのニューラルネットワークモデルの**トレーニングとアップデート**

Notes: 

ここでは、これまでに学んだ新しいスキルをおさらいします。

最初の章では、品詞タグ、依存関係、固有表現などの言語的特徴を抽出する方法と、事前学習の機械学習モデルを使用する方法を学びました。

また、spaCyのMatcherとPhraseMatcherを使用して、単語やフレーズを抽出するための強力なマッチパターンを書くことも学びました。

第2章では、情報抽出について学び、データ構造である`Doc`、`Token`、`Span`、`Vocab`や語彙エントリの扱い方を学びました。

また、単語ベクトルを用いて意味的類似度を予測する方法を学びました。

第3章では、spapCyのパイプラインについてさらに詳しく学び、docを変更するカスタムパイプラインコンポーネントを書くことを学びました。

また、Doc、Token、Spanの独自のカスタム拡張属性の作成法と、パイプラインを高速化する処理ストリームについても学びました。

最後に第4章で、固有表現抽出器を使い、spaCyの機械学習モデルのトレーニングとアップデートの方法を学びました。

また、トレーニングデータを作成する方法のためのいくつかの有用なトリックや、よりよい結果を得るためのラベルスキームの設計法も学びました。

---

# spaCyができるその他のこと(1)

- その他のパイプラインコンポーネントの[トレーニングとアップデート](https://spacy.io/usage/training)
  - 品詞タグ付け器
  - 依存関係解析器
  - 文書分類器

Notes: もちろん、spaCyができることは、このコースで紹介したこと以外にもたくさんあります。

これまでは主に固有表現抽出器に焦点を当てていましたが、品詞タグ付けと依存関係解析のような他の機械学習パイプラインコンポーネントを訓練して更新することができます。

もう一つ、テキスト分類器という、テキスト全体に適用されるラベルを予測するための有用なパイプラインコンポーネントがあります。
これは事前学習パイプラインには含まれていませんが、既存のモデルに追加して、用意したデータで訓練することができます。

---

# spaCyができるその他のこと(2)

- [トークナイザーのカスタマイズ](https://spacy.io/usage/linguistic-features#tokenization)
  - テキストを分割するためのルールや例外を追加
- [その他の言語を追加したり、改善したりする](https://spacy.io/usage/adding-languages)
  - 現在は55以上の言語をサポート
  - まだまだ改善の余地があります
  - 他の言語でトレーニングすることができます

Notes: この講座では、基本的にデフォルトのトークナイザーそのまま使いました。しかし、必ずしもそうしなくてもよいです！

spaCyでは、テキストをどこでどのように分割するかを決定するために使用されるルールをカスタマイズすることができます。

また、他の言語のサポートを追加したり、改善したりすることもできます。

spaCyはすでに多くの言語のトークナイザーをサポートしていますが、改善の余地がまだたくさんあります。

新しい言語のトークナイザーをサポートすることは、機械学習モデルをトレーニングできるようになるための第一歩です。

---

# より詳しい情報や、ドキュメントはウェブサイトを見てください！

<img src="/website.png" alt="spacy.io のウェブサイト" width="50%" />

👉 [spacy.io](https://spacy.io)

Notes: より多くの例、チュートリアルおよび詳細なAPIドキュメントについては、spaCyのウェブサイトを御覧ください。

---

# Thanks and see you soon! 👋

Notes: このコースを受講してくださり、本当にありがとうございます！楽しんでいただけたでしょうか？spaCyでクールなものを作りあげる日を楽しみにしています！
