---
type: slides
---

# spaCyモデルのトレーニングのベストプラクティス

Notes: 実験を始めると、多くのことが自分の思い通りにいかないことに気づくかもしれません。しかし、それでいいのです。

モデルのトレーニングは反復的なプロセスであり、何が一番うまくいくのかを見つけるまで、さまざまなことを試していく必要があります。

このレッスンでは、モデルをトレーニングする際のベストプラクティスと留意点をいくつか紹介します。

あなたが遭遇するかもしれない問題のいくつかを見てみましょう。

---

# 問題点1: モデルは忘れ得る

- 既存のモデルは新しいデータにオーバーフィットしてしまうことがあります
  - 例：`"WEBSITE"`を学習し、`"PERSON"`が何であるかを「忘れてしまう」ことがあります
- 別名「壊滅的な物忘れ（catastrophic forgetting）」問題

Notes: 機械学習モデルは多くのことを学習することができますが、それは忘れないということではありません。

既存のモデルを新しいデータ、特に新しいラベルで更新している場合、モデルはオーバーフィットして、新しい例に対して適応しすぎることがあります。

例えば、「ウェブサイト」のデータだけで更新している場合、以前に正しく予測していた他のラベル（例えば「人」のラベル）を「忘れる」ことがあります。

これは壊滅的な忘却問題としても知られています。

---

# 解決策1: 以前の正解データを混ぜる

- 例えば、`"WEBSITE"`を学習する場合は、`"PERSON"`の例も含めます
- 既存のspaCyモデルをデータ上で実行し、他のすべての関連する固有表現を抽出します

Note: 忘却を防ぐためには、モデルが以前に正しいと判断した例を混ぜるようにしてください。

新しいカテゴリ `"WEBSITE"` を学習する場合は、`"PERSON"` の例も含めてください。

spaCyはこれをサポートしてくれます。
既存のモデルをデータ上で実行し、注目すべき固有表現スパンを抽出することで、
これらの追加のデータを作成することができます。

そしてそれらの例を既存のデータと混ぜると、すべてのラベルでモデルを更新することができます。

---

# 問題2: モデルはすべてを学習できるわけではありません

- spaCyのモデルは、**ローカルな文脈**に基づいて予測を行います
- 文脈に基づいた決定が困難な場合、モデルは学習に苦労することができます
- ラベルスキームは一貫している必要があります
  - 例えば`"CLOTHING"` は `"ADULT_CLOTHING"` や `"CHILDRENS_CLOTHING"` よりも良いです

Notes: もう一つのよくある問題は、モデルはあなたの望むとおりに学習するわけではない、ということです。

spaCyのモデルは、ローカルコンテキストに基づいて予測を行います。
例えば固有表現の場合、周囲の単語が最も重要です。

文脈に基づいた判断が難しい場合、モデルはそれを学習するのに苦労することがあります。

また、ラベルスキームは一貫性があり、細かくしすぎないことも重要です。

例えば、大人の服なのか、子供の服なのかを文脈に基づいて予測することをモデルに教えるのは非常に難しいかもしれません。
しかし「服」というラベルを予測するだけなら、もっとうまくいくかもしれません。

---

# 解決策2: 慎重なラベル定義を

- ローカルな文脈を反映したカテゴリを選びます
- 細かすぎるものよりも、一般的なものがよいです
- 一般的なラベルから、細かいラベルを得るためにはルールを使います

**悪い例:**

```python
LABELS = ["ADULT_SHOES", "CHILDRENS_SHOES", "BANDS_I_LIKE"]
```

**良い例:**

```python
LABELS = ["CLOTHING", "BAND"]
```

Notes: 
モデルのトレーニングや更新を始める前に、一旦冷静になってラベルスキームを定義してみましょう。

ローカルコンテキストに反映されるカテゴリを選び、可能であればより汎用的なものを選んでさい。

後からルールベースのシステムを追加して、汎用的なものから細かいものにすることもできます。

「洋服」や「バンド」のような一般的なカテゴリーは、ラベル付けが簡単で学習しやすいです。

---

# Let's practice!

Notes: では、ここで述べた問題のうちいくつかを見ていき、修正してみましょう！
