---
sidebar_position: 1
---

# Contributing

If you're using Bracket and would like to help support its development, that would be greatly
appreciated!

Several areas that we need a bit of help with at the moment are:

- ⭐ **Star Bracket** on GitHub
- 🌐 **Translating**: Help make Bracket available to non-native English speakers by adding your
  language. See [Translating](#translating) below.
- 📣 **Spread the word** by sharing Bracket to help new users discover it
- 🖥️ **Submit a PR** to add a new feature, fix a bug, extend/update the docs or something else

## Translating

### Adding translations (via crowdin)

Bracket uses [crowdin](https://crowdin.com/project/bracket) for translations. You can add/improve
translations here in your language.

If you want to add a new language, please create an issue and I will add the language to Crowdin.

### Manually adding translations

You can add a translation by copying the English `en` locale
([here](https://github.com/evroon/bracket/tree/master/frontend/public/locales)) directory.
Rename the directory to the name of your locale, and start translating the `common.json` file inside
the directory. It might be useful to use an online tool (Google `translate json file`) to do the
translation for you, and then carefully check and correct any mistakes.

## Contributors
<!-- markdownlint-disable line-length no-inline-html -->
<!-- readme: collaborators,contributors,dependabot/- -start -->
<table>
<tr>
    <td align="center">
        <a href="https://github.com/evroon">
            <img src="https://avatars.githubusercontent.com/u/11857441?v=4" width="100;" alt="evroon"/>
            <br />
            <sub><b>Erik Vroon</b></sub>
        </a>
    </td>
    <td align="center">
        <a href="https://github.com/robigan">
            <img src="https://avatars.githubusercontent.com/u/35210888?v=4" width="100;" alt="robigan"/>
            <br />
            <sub><b>Null</b></sub>
        </a>
    </td>
    <td align="center">
        <a href="https://github.com/BachErik">
            <img src="https://avatars.githubusercontent.com/u/75324423?v=4" width="100;" alt="BachErik"/>
            <br />
            <sub><b>BachErik</b></sub>
        </a>
    </td>
    <td align="center">
        <a href="https://github.com/djpiper28">
            <img src="https://avatars.githubusercontent.com/u/13609136?v=4" width="100;" alt="djpiper28"/>
            <br />
            <sub><b>Danny Piper</b></sub>
        </a>
    </td>
    <td align="center">
        <a href="https://github.com/Sevichecc">
            <img src="https://avatars.githubusercontent.com/u/91365763?v=4" width="100;" alt="Sevichecc"/>
            <br />
            <sub><b>SevicheCC</b></sub>
        </a>
    </td>
    <td align="center">
        <a href="https://github.com/IzStriker">
            <img src="https://avatars.githubusercontent.com/u/44909896?v=4" width="100;" alt="IzStriker"/>
            <br />
            <sub><b>IzStriker</b></sub>
        </a>
    </td></tr>
<tr>
    <td align="center">
        <a href="https://github.com/babeuh">
            <img src="https://avatars.githubusercontent.com/u/60193302?v=4" width="100;" alt="babeuh"/>
            <br />
            <sub><b>Raphael Le Goaller</b></sub>
        </a>
    </td></tr>
</table>
<!-- readme: collaborators,contributors,dependabot/- -end -->

## Star History

[![stargazers](https://img.shields.io/github/stars/evroon/bracket)](https://github.com/evroon/bracket/stargazers)

<a href="https://star-history.com/#evroon/bracket&Date">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=evroon/bracket&type=Date&theme=dark" />
    <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=evroon/bracket&type=Date" />
    <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=evroon/bracket&type=Date" />
  </picture>
</a>

<!-- markdownlint-enable line-length no-inline-html -->
