!(function() {
    "use strict";
    // Определение плагина
    tinymce.PluginManager.add('imageEditor', function(editor) {
        // Функция для открытия модального окна
        function openImageEditor() {
            var modalHTML = `
                <div class="modal fade" id="imageEditorModal" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Редактирование изображения</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <img id="imageToEdit" src="" alt="Редактируемое изображение" class="img-fluid">
                                <!-- Здесь могут быть элементы управления для вращения и масштабирования -->
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Закрыть</button>
                                <button type="button" class="btn btn-primary" id="saveEditedImage">Сохранить</button>
                            </div>
                        </div>
                    </div>
                </div>
            `;

            // Добавление модального окна на страницу, если еще не добавлено
            if (!document.querySelector('#imageEditorModal')) {
                document.body.insertAdjacentHTML('beforeend', modalHTML);
                var modal = new bootstrap.Modal(document.querySelector('#imageEditorModal'));
                modal.show();
            }

            // Обработчик кнопки "Сохранить"
            document.querySelector('#saveEditedImage').addEventListener('click', function() {
                // Здесь должна быть логика сохранения измененного изображения
                // Например, вставка измененного изображения в редактор:
                // editor.insertContent('<img src="path/to/edited/image.jpg">');
                modal.hide();
            });
        }

        // Добавление кнопки на тулбар редактора
        editor.ui.registry.addButton('imageEditor', {
            icon: 'image',
            tooltip: 'Редактировать изображение',
            onAction: function() {
                openImageEditor();
            }
        });
    });
})();
