// @flow

export const NEW_CONNECTION_SUCCESS = { type: 'NEW_CONNECTION_SUCCESS' }
export const INVITATION_REJECTED = { type: 'INVITATION_REJECTED' }
export const CLAIM_REQUEST_SUCCESS = { type: 'CLAIM_REQUEST_SUCCESS' }
export const DENY_CLAIM_OFFER_SUCCESS = { type: 'DENY_CLAIM_OFFER_SUCCESS' }
export const SEND_PROOF_SUCCESS = { type: 'SEND_PROOF_SUCCESS' }
export const INVITE_ACTION = { type: 'INVITE ACTION' }
export const SEND_ANSWER_TO_QUESTION = { type: 'ANSWER TO QUESTION' }
export const SIDE_MENU_BUTTON = { type: 'SIDE_MENU_BUTTON' }
export const TAPPING_ON_A_CREDENTIAL = { type: 'TAPPING_ON_A_CREDENTIAL' }
export const TAKE_TO_CONNECTION_DETAILS = { type: 'TAKE_TO_CONNECTION_DETAILS' }
export const TAPPING_ON_THE_BACK_ARROW = (route: string) => ({
  type: 'TAPPING_ON_THE_BACK_ARROW',
  route,
})
export const TAPPING_ON_THE_3_DOTS = (route: string) => ({
  type: 'TAPPING_ON_THE_3_DOTS',
  route,
})
export const DELETE_BUTTON = (route: string) => ({
  type: 'DELETE_BUTTON',
  route,
})
export const VIEW_CREDENTIAL_BUTTON = { type: 'VIEW_CREDENTIAL_BUTTON' }
export const VIEW_REQUEST_DETAILS_BUTTON = {
  type: 'VIEW_REQUEST_DETAILS_BUTTON',
}
export const SETTINGS_MENU_BUTTON = { type: 'SETTINGS_MENU_BUTTON' }
export const SCAN_QR_BUTTON = { type: 'SCAN_QR_BUTTON' }
export const SCAN_QR_CLOSE_X_BUTTON = { type: 'SCAN_QR_CLOSE_X_BUTTON' }
export const BIOMETRICS_SWITCH_ON = { type: 'BIOMETRICS_SWITCH_ON' }
export const BIOMETRICS_SWITCH_OFF = { type: 'BIOMETRICS_SWITCH_OFF' }
export const CHANGE_PASSCODE_BUTTON_IN_SETTINGS = {
  type: 'CHANGE_PASSCODE_BUTTON_IN_SETTINGS',
}
export const BACK_ARROW_IN_THE_CHANGE_PASSCODE_VIEW = {
  type: 'BACK_ARROW_IN_THE_CHANGE_PASSCODE_VIEW',
}
export const ABOUT_BUTTON_IN_SETTINGS = { type: 'ABOUT_BUTTON_IN_SETTINGS' }
export const GIVE_APP_FEEDBACK_BUTTON_IN_SETTINGS = {
  type: 'GIVE_APP_FEEDBACK_BUTTON_IN_SETTINGS',
}
export const OPENING_THE_SIDE_MENU = { type: 'OPENING_THE_SIDE_MENU' }
export const CLOSING_THE_SIDE_MENU = { type: 'CLOSING_THE_SIDE_MENU' }


export const APPTENTIVE_EVENTS = {
  // Middleware events
  INVITATION_ACCEPTED: 'INVITATION_ACCEPTED',
  INVITATION_REJECTED: 'DENY CONNECTION',
  CLAIM_REQUEST_SUCCESS: 'ACCEPT CREDENTIAL',
  DENY_CLAIM_OFFER_SUCCESS: 'DENY CREDENTIAL',
  SEND_PROOF_SUCCESS: 'SHARE PROOF',
  DENY_PROOF_REQUEST_SUCCESS: 'DENY PROOF',
  INVITE_ACTION: 'INVITE ACTION',
  SEND_ANSWER_TO_QUESTION: 'ANSWER TO QUESTION',

  // UI events
  SIDE_MENU_BUTTON: 'SIDE MENU BUTTON',

  TAPPING_ON_A_CREDENTIAL: 'TAPPING ON A CREDENTIAL',
  TAPPING_ON_THE_BACK_ARROW_CredentialDetailsRoute:
    'TAPPING ON THE BACK ARROW BUTTON TO GET OUT OF A CREDENTIAL DETAILS VIEW',
  TAPPING_ON_THE_3_DOTS_CredentialDetailsRoute:
    'TAPPING ON THE 3 DOTS IN THE CREDENTIAL DETAILS MENU',
  DELETE_BUTTON_CredentialDetailsRoute: 'DELETE CREDENTIAL BUTTON',

  TAKE_TO_CONNECTION_DETAILS: 'TAKE TO CONNECTION DETAILS',
  TAPPING_ON_THE_BACK_ARROW_ConnectionHistRoute:
    'TAPPING ON THE BACK ARROW BUTTON TO GET OUT OF CONNECTION DETAILS VIEW',
  VIEW_CREDENTIAL_BUTTON: 'VIEW CREDENTIAL BUTTON',
  VIEW_REQUEST_DETAILS_BUTTON: 'VIEW REQUEST DETAILS BUTTON',
  TAPPING_ON_THE_3_DOTS_ConnectionHistRoute:
    'TAPPING ON THE 3 DOTS IN THE CONNECTION DETAILS BUTTON',
  DELETE_BUTTON_ConnectionHistRoute: 'DELETE CONNECTION BUTTON',

  SETTINGS_MENU_BUTTON: 'SETTINGS MENU BUTTON',

  SCAN_QR_BUTTON: 'SCAN QR BUTTON',
  SCAN_QR_CLOSE_X_BUTTON: 'SCAN QR CLOSE X BUTTON',

  OPENING_THE_SIDE_MENU: 'OPENING THE SIDE MENU',
  CLOSING_THE_SIDE_MENU: 'CLOSING THE SIDE MENU',

  BIOMETRICS_SWITCH_ON: 'BIOMETRICS SWITCH ON',
  BIOMETRICS_SWITCH_OFF: 'BIOMETRICS SWITCH OFF',

  CHANGE_PASSCODE_BUTTON_IN_SETTINGS: 'CHANGE PASSCODE BUTTON IN SETTINGS',
  BACK_ARROW_IN_THE_CHANGE_PASSCODE_VIEW:
    'BACK ARROW IN THE CHANGE PASSCODE VIEW',
  ABOUT_BUTTON_IN_SETTINGS: 'ABOUT BUTTON IN SETTINGS',
  GIVE_APP_FEEDBACK_BUTTON_IN_SETTINGS: 'GIVE APP FEEDBACK BUTTON IN SETTINGS',
}
