// @flow
import React from 'react'
import SvgIcon from 'react-native-svg-icon'
import { Path, G, Use, ClipPath, Defs, Rect, Mask } from 'react-native-svg'

import { colors } from '../common/styles/constant'

export const svgIcons = {
  Connections: {
    svg: (
      <Path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M18 10C18 9.449 17.552 9 17 9C16.448 9 16 9.449 16 10C16 10.551 16.448 11 17 11C17.552 11 18 10.551 18 10ZM20 10C20 11.654 18.654 13 17 13C15.346 13 14 11.654 14 10C14 8.346 15.346 7 17 7C18.654 7 20 8.346 20 10ZM11 7C11 5.897 10.103 5 9 5C7.897 5 7 5.897 7 7C7 8.103 7.897 9 9 9C10.103 9 11 8.103 11 7ZM13 7C13 9.206 11.206 11 9 11C6.794 11 5 9.206 5 7C5 4.794 6.794 3 9 3C11.206 3 13 4.794 13 7ZM13.94 15.046C14.809 14.374 15.879 14 17 14C19.757 14 22 16.243 22 19C22 19.552 21.553 20 21 20C20.447 20 20 19.552 20 19C20 17.346 18.654 16 17 16C16.317 16 15.668 16.234 15.144 16.649C15.688 17.645 16 18.787 16 20C16 20.552 15.553 21 15 21C14.447 21 14 20.552 14 20C14 17.243 11.757 15 9 15C6.243 15 4 17.243 4 20C4 20.552 3.553 21 3 21C2.447 21 2 20.552 2 20C2 16.14 5.141 13 9 13C10.927 13 12.673 13.783 13.94 15.046Z"
        fill="#777777"
      />
    ),
    viewBox: '0 0 24 24',
  },
  Credentials: {
    svg: (
      <G>
        <Path
          d="M15.792 5.703a.222.222 0 0 1 .033.092c0 .02-.011.051-.033.092l-4.085 4.891c-.066.061-.093.092-.148.092-.054 0-.109-.026-.164-.077L9.082 8.714l-.049-.046A.278.278 0 0 1 9 8.577c0-.01.011-.036.033-.077l.033-.03c.306-.306.546-.54.721-.703.066-.061.088-.092.132-.092.043 0 .098.031.164.092l1.312 1.192 3.282-3.928c.021-.021.065-.031.098-.031s.071.01.115.031z"
          fill="rgba(119,119,119,1)"
        />
        <Defs>
          <Path d="M7 14v10l5-2 5 2V14l-5 1.5z" id="a" />
          <ClipPath id="b">
            <Use href="#a" />
          </ClipPath>
        </Defs>
        <ClipPath id="b">
          <Path d="M7 14v10l5-2 5 2V14l-5 1.5z" id="a" />
        </ClipPath>
        <Use
          href="#a"
          fill="transparent"
          clipPath="url(#b)"
          strokeWidth={4}
          stroke="rgba(119, 119, 119, 1.00)"
          strokeLinecap="square"
          strokeLinejoin="round"
        />
        <G>
          <Defs>
            <Path d="M12 0a8 8 0 1 1 0 16 8 8 0 0 1 0-16z" id="c" />
            <ClipPath id="d">
              <Use href="#c" />
            </ClipPath>
          </Defs>

          <ClipPath id="d">
            <Path d="M12 0a8 8 0 1 1 0 16 8 8 0 0 1 0-16z" id="c" />
          </ClipPath>
          <Use
            href="#c"
            fill="transparent"
            clipPath="url(#d)"
            strokeWidth={4}
            stroke="rgba(119, 119, 119, 1.00)"
          />
        </G>
      </G>
    ),
    viewBox: '0 0 24 24',
  },
  CredentialsOn: {
    svg: (
      <G>
        <Path
          d="M15.792 5.703a.222.222 0 0 1 .033.092c0 .02-.011.051-.033.092l-4.085 4.891c-.066.061-.093.092-.148.092-.054 0-.109-.026-.164-.077L9.082 8.714l-.049-.046A.278.278 0 0 1 9 8.577c0-.01.011-.036.033-.077l.033-.03c.306-.306.546-.54.721-.703.066-.061.088-.092.132-.092.043 0 .098.031.164.092l1.312 1.192 3.282-3.928c.021-.021.065-.031.098-.031s.071.01.115.031z"
          fill={colors.main}
        />
        <Defs>
          <Path d="M7 14v10l5-2 5 2V14l-5 1.5z" id="a" />
          <ClipPath id="b">
            <Use href="#a" />
          </ClipPath>
        </Defs>
        <ClipPath id="b">
          <Path d="M7 14v10l5-2 5 2V14l-5 1.5z" id="a" />
        </ClipPath>
        <Use
          href="#a"
          fill="transparent"
          clipPath="url(#b)"
          strokeWidth={4}
          stroke={colors.main}
          strokeLinecap="square"
          strokeLinejoin="round"
        />
        <G>
          <Defs>
            <Path d="M12 0a8 8 0 1 1 0 16 8 8 0 0 1 0-16z" id="c" />
            <ClipPath id="d">
              <Use href="#c" />
            </ClipPath>
          </Defs>

          <ClipPath id="d">
            <Path d="M12 0a8 8 0 1 1 0 16 8 8 0 0 1 0-16z" id="c" />
          </ClipPath>
          <Use
            href="#c"
            fill="transparent"
            clipPath="url(#d)"
            strokeWidth={4}
            stroke={colors.main}
          />
        </G>
      </G>
    ),
    viewBox: '0 0 24 24',
  },
  Discover: {
    svg: (
      <Path
        d="M 0.115 8.291 C 0.513 7.116 1.828 6.471 3.056 6.854 C 4.151 7.196 4.804 8.245 4.642 9.306 L 8.629 10.544 C 8.518 10.778 8.434 11.028 8.378 11.287 L 4.387 10.047 C 3.863 10.984 2.702 11.456 1.612 11.116 C 0.386 10.732 -0.282 9.467 0.115 8.291 Z M 0.115 15.708 C -0.283 14.531 0.386 13.268 1.612 12.885 C 2.713 12.543 3.882 13.026 4.4 13.979 L 8.381 12.726 C 8.437 12.986 8.522 13.234 8.633 13.47 L 4.647 14.724 C 4.792 15.775 4.143 16.808 3.056 17.148 C 1.828 17.531 0.514 16.884 0.115 15.708 Z M 4.654 21.709 C 3.612 20.981 3.38 19.58 4.138 18.58 C 4.82 17.68 6.068 17.41 7.069 17.894 L 9.519 14.633 C 9.72 14.808 9.94 14.961 10.178 15.091 L 7.721 18.359 C 8.481 19.127 8.585 20.327 7.914 21.214 C 7.156 22.215 5.696 22.437 4.654 21.709 Z M 19.344 2.292 C 20.388 3.019 20.619 4.42 19.862 5.421 C 19.181 6.322 17.934 6.591 16.931 6.108 L 14.48 9.368 C 14.279 9.194 14.06 9.04 13.821 8.91 L 16.279 5.644 C 15.519 4.876 15.414 3.676 16.086 2.788 C 16.843 1.785 18.3 1.564 19.344 2.292 Z M 23.885 8.291 C 24.284 9.469 23.613 10.732 22.387 11.116 C 21.289 11.457 20.117 10.975 19.6 10.024 L 15.618 11.275 C 15.563 11.015 15.478 10.766 15.365 10.531 L 19.354 9.277 C 19.208 8.228 19.858 7.193 20.945 6.854 C 22.171 6.471 23.485 7.114 23.885 8.291 Z M 23.885 15.708 C 23.487 16.883 22.171 17.531 20.945 17.148 C 19.847 16.804 19.197 15.755 19.358 14.696 L 15.371 13.458 C 15.482 13.222 15.566 12.973 15.622 12.714 L 19.614 13.954 C 20.137 13.017 21.297 12.545 22.387 12.885 C 23.613 13.268 24.282 14.532 23.885 15.708 Z M 19.344 21.709 C 18.304 22.436 16.843 22.215 16.086 21.214 C 15.408 20.318 15.521 19.104 16.3 18.337 L 13.834 15.084 C 14.071 14.954 14.291 14.8 14.491 14.624 L 16.957 17.879 C 17.954 17.415 19.185 17.688 19.862 18.58 C 20.619 19.58 20.384 20.982 19.344 21.709 Z M 12 0 C 13.289 0 14.333 1.001 14.333 2.241 C 14.333 3.346 13.502 4.261 12.407 4.446 L 12.407 8.473 C 12.273 8.457 12.136 8.45 11.999 8.45 C 11.861 8.45 11.727 8.457 11.592 8.473 L 11.592 4.446 C 10.498 4.261 9.667 3.346 9.667 2.241 C 9.667 1.001 10.711 0 12 0 Z M 12.407 19.555 C 13.502 19.741 14.333 20.656 14.333 21.762 C 14.333 23 13.289 24 12 24 C 10.711 24 9.667 23 9.667 21.762 C 9.667 20.656 10.498 19.741 11.592 19.555 L 11.592 15.529 C 11.727 15.543 11.86 15.551 11.999 15.551 C 12.137 15.551 12.273 15.543 12.407 15.529 Z M 12 9.76 C 13.288 9.76 14.332 10.763 14.332 12.001 C 14.332 13.24 13.289 14.244 12 14.242 C 10.711 14.24 9.667 13.24 9.667 12.001 C 9.667 10.763 10.712 9.76 12 9.76 Z M 4.655 2.292 C 5.695 1.565 7.156 1.785 7.913 2.788 C 8.591 3.683 8.478 4.898 7.699 5.665 L 10.165 8.917 C 9.929 9.047 9.709 9.202 9.509 9.377 L 7.041 6.121 C 6.044 6.586 4.813 6.314 4.138 5.421 C 3.38 4.42 3.615 3.019 4.655 2.292 Z"
        fill="rgba(119,119,119,1)"
      />
    ),
    viewBox: '0 0 24 24',
  },
  Scan: {
    svg: (
      <G>
        <Path
          d="M0 0h.924v.924H0zM0 .924h.924v.924H0zM0 1.848h.924v.924H0z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M0 2.772h.924v.924H0zM0 3.696h.924v.924H0zM0 4.62h.924v.924H0z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M0 5.544h.924v.924H0zM0 8.316h.924v.924H0zM0 16.632h.924v.924H0zM0 17.556h.924v.924H0zM0 18.48h.924v.924H0zM0 19.404h.924v.924H0zM0 20.328h.924v.924H0zM0 21.252h.924v.924H0zM0 22.176h.924v.924H0zM.924 0h.924v.924H.924zM.924 5.544h.924v.924H.924zM.924 7.392h.924v.924H.924zM.924 8.316h.924v.924H.924zM.924 9.24h.924v.924H.924zM.924 12.012h.924v.924H.924zM.924 13.86h.924v.924H.924zM.924 14.784h.924v.924H.924zM.924 16.632h.924v.924H.924zM.924 22.176h.924v.924H.924zM1.848 0h.924v.924h-.924zM1.848 1.848h.924v.924h-.924z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M1.848 2.772h.924v.924h-.924zM1.848 3.696h.924v.924h-.924zM1.848 5.544h.924v.924h-.924zM1.848 8.316h.924v.924h-.924zM1.848 9.24h.924v.924h-.924zM1.848 10.164h.924v.924h-.924zM1.848 11.088h.924v.924h-.924zM1.848 12.012h.924v.924h-.924zM1.848 14.784h.924v.924h-.924zM1.848 16.632h.924v.924h-.924zM1.848 18.48h.924v.924h-.924zM1.848 19.404h.924v.924h-.924zM1.848 20.328h.924v.924h-.924zM1.848 22.176h.924v.924h-.924zM2.772 0h.924v.924h-.924z"
          fill="rgba(119,119,119,1)"
        />
        <Path d="M2.772 1.848h.924v.924h-.924z" fill="rgba(119,119,119,1)" />
        <Path
          d="M2.772 2.772h.924v.924h-.924zM2.772 3.696h.924v.924h-.924zM2.772 5.544h.924v.924h-.924zM2.772 7.392h.924v.924h-.924zM2.772 8.316h.924v.924h-.924zM2.772 9.24h.924v.924h-.924zM2.772 10.164h.924v.924h-.924zM2.772 12.012h.924v.924h-.924zM2.772 14.784h.924v.924h-.924zM2.772 16.632h.924v.924h-.924zM2.772 18.48h.924v.924h-.924zM2.772 19.404h.924v.924h-.924zM2.772 20.328h.924v.924h-.924zM2.772 22.176h.924v.924h-.924zM3.696 0h.924v.924h-.924zM3.696 1.848h.924v.924h-.924z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M3.696 2.772h.924v.924h-.924zM3.696 3.696h.924v.924h-.924zM3.696 5.544h.924v.924h-.924zM3.696 7.392h.924v.924h-.924zM3.696 11.088h.924v.924h-.924zM3.696 12.012h.924v.924h-.924zM3.696 13.86h.924v.924h-.924zM3.696 14.784h.924v.924h-.924zM3.696 16.632h.924v.924h-.924zM3.696 18.48h.924v.924h-.924zM3.696 19.404h.924v.924h-.924zM3.696 20.328h.924v.924h-.924zM3.696 22.176h.924v.924h-.924zM4.62 0h.924v.924H4.62zM4.62 5.544h.924v.924H4.62zM4.62 7.392h.924v.924H4.62zM4.62 11.088h.924v.924H4.62zM4.62 16.632h.924v.924H4.62zM4.62 22.176h.924v.924H4.62z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M5.544 0h.924v.924h-.924zM5.544.924h.924v.924h-.924zM5.544 1.848h.924v.924h-.924z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M5.544 2.772h.924v.924h-.924zM5.544 3.696h.924v.924h-.924zM5.544 4.62h.924v.924h-.924z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M5.544 5.544h.924v.924h-.924zM5.544 7.392h.924v.924h-.924zM5.544 9.24h.924v.924h-.924zM5.544 11.088h.924v.924h-.924zM5.544 12.936h.924v.924h-.924zM5.544 14.784h.924v.924h-.924zM5.544 16.632h.924v.924h-.924zM5.544 17.556h.924v.924h-.924zM5.544 18.48h.924v.924h-.924zM5.544 19.404h.924v.924h-.924zM5.544 20.328h.924v.924h-.924zM5.544 21.252h.924v.924h-.924zM5.544 22.176h.924v.924h-.924zM6.468 8.316h.924v.924h-.924zM6.468 10.164h.924v.924h-.924zM6.468 11.088h.924v.924h-.924zM6.468 12.936h.924v.924h-.924zM6.468 14.784h.924v.924h-.924zM7.392.924h.924v.924h-.924zM7.392 2.772h.924v.924h-.924zM7.392 3.696h.924v.924h-.924zM7.392 5.544h.924v.924h-.924zM7.392 6.468h.924v.924h-.924zM7.392 7.392h.924v.924h-.924zM7.392 8.316h.924v.924h-.924zM7.392 9.24h.924v.924h-.924zM7.392 10.164h.924v.924h-.924zM7.392 11.088h.924v.924h-.924zM7.392 12.936h.924v.924h-.924zM7.392 13.86h.924v.924h-.924zM7.392 14.784h.924v.924h-.924zM7.392 15.708h.924v.924h-.924zM7.392 17.556h.924v.924h-.924zM7.392 18.48h.924v.924h-.924zM7.392 19.404h.924v.924h-.924zM7.392 21.252h.924v.924h-.924zM8.316 0h.924v.924h-.924zM8.316 1.848h.924v.924h-.924z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M8.316 2.772h.924v.924h-.924zM8.316 4.62h.924v.924h-.924zM8.316 7.392h.924v.924h-.924zM8.316 8.316h.924v.924h-.924zM8.316 10.164h.924v.924h-.924zM8.316 12.012h.924v.924h-.924zM8.316 14.784h.924v.924h-.924zM8.316 16.632h.924v.924h-.924zM8.316 17.556h.924v.924h-.924zM8.316 18.48h.924v.924h-.924zM8.316 19.404h.924v.924h-.924zM8.316 20.328h.924v.924h-.924zM9.24 2.772h.924v.924H9.24zM9.24 3.696h.924v.924H9.24zM9.24 4.62h.924v.924H9.24z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M9.24 5.544h.924v.924H9.24zM9.24 8.316h.924v.924H9.24zM9.24 9.24h.924v.924H9.24zM9.24 10.164h.924v.924H9.24zM9.24 11.088h.924v.924H9.24zM9.24 12.936h.924v.924H9.24zM9.24 13.86h.924v.924H9.24zM9.24 14.784h.924v.924H9.24zM9.24 16.632h.924v.924H9.24zM9.24 17.556h.924v.924H9.24zM9.24 19.404h.924v.924H9.24zM9.24 20.328h.924v.924H9.24zM9.24 22.176h.924v.924H9.24zM10.164 4.62h.924v.924h-.924zM10.164 9.24h.924v.924h-.924zM10.164 11.088h.924v.924h-.924zM10.164 12.012h.924v.924h-.924zM10.164 16.632h.924v.924h-.924zM10.164 19.404h.924v.924h-.924zM10.164 20.328h.924v.924h-.924zM10.164 21.252h.924v.924h-.924zM10.164 22.176h.924v.924h-.924zM11.088.924h.924v.924h-.924zM11.088 1.848h.924v.924h-.924zM11.088 3.696h.924v.924h-.924zM11.088 5.544h.924v.924h-.924zM11.088 6.468h.924v.924h-.924zM11.088 7.392h.924v.924h-.924zM11.088 8.316h.924v.924h-.924zM11.088 9.24h.924v.924h-.924zM11.088 12.012h.924v.924h-.924zM11.088 12.936h.924v.924h-.924zM11.088 13.86h.924v.924h-.924zM11.088 14.784h.924v.924h-.924zM11.088 16.632h.924v.924h-.924zM11.088 18.48h.924v.924h-.924zM11.088 20.328h.924v.924h-.924zM11.088 21.252h.924v.924h-.924zM11.088 22.176h.924v.924h-.924zM12.012 0h.924v.924h-.924zM12.012.924h.924v.924h-.924zM12.012 1.848h.924v.924h-.924zM12.012 3.696h.924v.924h-.924zM12.012 4.62h.924v.924h-.924zM12.012 7.392h.924v.924h-.924zM12.012 11.088h.924v.924h-.924zM12.012 12.012h.924v.924h-.924zM12.012 12.936h.924v.924h-.924zM12.012 13.86h.924v.924h-.924zM12.012 16.632h.924v.924h-.924zM12.012 18.48h.924v.924h-.924zM12.012 20.328h.924v.924h-.924zM12.012 21.252h.924v.924h-.924zM12.012 22.176h.924v.924h-.924zM12.936 0h.924v.924h-.924zM12.936.924h.924v.924h-.924zM12.936 1.848h.924v.924h-.924z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M12.936 2.772h.924v.924h-.924zM12.936 4.62h.924v.924h-.924z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M12.936 5.544h.924v.924h-.924zM12.936 6.468h.924v.924h-.924zM12.936 7.392h.924v.924h-.924zM12.936 8.316h.924v.924h-.924zM12.936 9.24h.924v.924h-.924zM12.936 10.164h.924v.924h-.924zM12.936 11.088h.924v.924h-.924zM12.936 12.936h.924v.924h-.924zM12.936 13.86h.924v.924h-.924zM12.936 15.708h.924v.924h-.924zM12.936 16.632h.924v.924h-.924zM12.936 17.556h.924v.924h-.924zM12.936 20.328h.924v.924h-.924zM12.936 21.252h.924v.924h-.924zM13.86 0h.924v.924h-.924zM13.86.924h.924v.924h-.924zM13.86 2.772h.924v.924h-.924zM13.86 3.696h.924v.924h-.924zM13.86 7.392h.924v.924h-.924zM13.86 10.164h.924v.924h-.924zM13.86 12.936h.924v.924h-.924zM13.86 14.784h.924v.924h-.924zM13.86 17.556h.924v.924h-.924zM13.86 18.48h.924v.924h-.924zM13.86 19.404h.924v.924h-.924zM14.784 5.544h.924v.924h-.924zM14.784 7.392h.924v.924h-.924zM14.784 11.088h.924v.924h-.924zM14.784 14.784h.924v.924h-.924zM14.784 15.708h.924v.924h-.924zM14.784 16.632h.924v.924h-.924zM14.784 17.556h.924v.924h-.924zM14.784 18.48h.924v.924h-.924zM14.784 19.404h.924v.924h-.924zM14.784 20.328h.924v.924h-.924zM14.784 22.176h.924v.924h-.924zM15.708 7.392h.924v.924h-.924zM15.708 9.24h.924v.924h-.924zM15.708 12.012h.924v.924h-.924zM15.708 12.936h.924v.924h-.924zM15.708 14.784h.924v.924h-.924zM15.708 18.48h.924v.924h-.924zM15.708 20.328h.924v.924h-.924zM15.708 22.176h.924v.924h-.924zM16.632 0h.924v.924h-.924zM16.632.924h.924v.924h-.924zM16.632 1.848h.924v.924h-.924z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M16.632 2.772h.924v.924h-.924zM16.632 3.696h.924v.924h-.924zM16.632 4.62h.924v.924h-.924z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M16.632 5.544h.924v.924h-.924zM16.632 7.392h.924v.924h-.924zM16.632 9.24h.924v.924h-.924zM16.632 11.088h.924v.924h-.924zM16.632 12.936h.924v.924h-.924zM16.632 13.86h.924v.924h-.924zM16.632 14.784h.924v.924h-.924zM16.632 16.632h.924v.924h-.924zM16.632 18.48h.924v.924h-.924zM16.632 19.404h.924v.924h-.924zM17.556 0h.924v.924h-.924zM17.556 5.544h.924v.924h-.924zM17.556 8.316h.924v.924h-.924zM17.556 9.24h.924v.924h-.924zM17.556 10.164h.924v.924h-.924zM17.556 11.088h.924v.924h-.924zM17.556 12.936h.924v.924h-.924zM17.556 13.86h.924v.924h-.924zM17.556 14.784h.924v.924h-.924zM17.556 18.48h.924v.924h-.924zM17.556 20.328h.924v.924h-.924zM18.48 0h.924v.924h-.924zM18.48 1.848h.924v.924h-.924z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M18.48 2.772h.924v.924h-.924zM18.48 3.696h.924v.924h-.924zM18.48 5.544h.924v.924h-.924zM18.48 7.392h.924v.924h-.924zM18.48 8.316h.924v.924h-.924zM18.48 9.24h.924v.924h-.924zM18.48 12.012h.924v.924h-.924zM18.48 12.936h.924v.924h-.924zM18.48 14.784h.924v.924h-.924zM18.48 15.708h.924v.924h-.924zM18.48 16.632h.924v.924h-.924zM18.48 17.556h.924v.924h-.924zM18.48 18.48h.924v.924h-.924zM18.48 20.328h.924v.924h-.924zM18.48 21.252h.924v.924h-.924zM19.404 0h.924v.924h-.924zM19.404 1.848h.924v.924h-.924z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M19.404 2.772h.924v.924h-.924zM19.404 3.696h.924v.924h-.924zM19.404 5.544h.924v.924h-.924zM19.404 7.392h.924v.924h-.924zM19.404 8.316h.924v.924h-.924zM19.404 11.088h.924v.924h-.924zM19.404 12.012h.924v.924h-.924zM19.404 12.936h.924v.924h-.924zM19.404 13.86h.924v.924h-.924zM19.404 14.784h.924v.924h-.924zM19.404 17.556h.924v.924h-.924zM19.404 18.48h.924v.924h-.924zM19.404 19.404h.924v.924h-.924zM19.404 21.252h.924v.924h-.924zM19.404 22.176h.924v.924h-.924zM20.328 0h.924v.924h-.924zM20.328 1.848h.924v.924h-.924z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M20.328 2.772h.924v.924h-.924zM20.328 3.696h.924v.924h-.924zM20.328 5.544h.924v.924h-.924zM20.328 8.316h.924v.924h-.924zM20.328 9.24h.924v.924h-.924zM20.328 10.164h.924v.924h-.924zM20.328 12.012h.924v.924h-.924zM20.328 13.86h.924v.924h-.924zM20.328 14.784h.924v.924h-.924zM20.328 15.708h.924v.924h-.924zM20.328 20.328h.924v.924h-.924zM20.328 21.252h.924v.924h-.924zM21.252 0h.924v.924h-.924zM21.252 5.544h.924v.924h-.924zM21.252 7.392h.924v.924h-.924zM21.252 8.316h.924v.924h-.924zM21.252 12.012h.924v.924h-.924zM21.252 12.936h.924v.924h-.924zM21.252 13.86h.924v.924h-.924zM21.252 18.48h.924v.924h-.924zM21.252 20.328h.924v.924h-.924zM21.252 21.252h.924v.924h-.924zM22.176 0h.924v.924h-.924zM22.176.924h.924v.924h-.924zM22.176 1.848h.924v.924h-.924z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M22.176 2.772h.924v.924h-.924zM22.176 3.696h.924v.924h-.924zM22.176 4.62h.924v.924h-.924z"
          fill="rgba(119,119,119,1)"
        />
        <Path
          d="M22.176 5.544h.924v.924h-.924zM22.176 9.24h.924v.924h-.924zM22.176 11.088h.924v.924h-.924zM22.176 12.936h.924v.924h-.924zM22.176 14.784h.924v.924h-.924zM22.176 16.632h.924v.924h-.924zM22.176 19.404h.924v.924h-.924zM22.176 20.328h.924v.924h-.924zM22.176 21.252h.924v.924h-.924zM22.176 22.176h.924v.924h-.924z"
          fill="rgba(119,119,119,1)"
        />
      </G>
    ),

    viewBox: '0 0 24 24',
  },
  ScanOn: {
    svg: (
      <G>
        <Path
          d="M0 0h.924v.924H0zM0 .924h.924v.924H0zM0 1.848h.924v.924H0z"
          fill={colors.main}
        />
        <Path
          d="M0 2.772h.924v.924H0zM0 3.696h.924v.924H0zM0 4.62h.924v.924H0z"
          fill={colors.main}
        />
        <Path
          d="M0 5.544h.924v.924H0zM0 8.316h.924v.924H0zM0 16.632h.924v.924H0zM0 17.556h.924v.924H0zM0 18.48h.924v.924H0zM0 19.404h.924v.924H0zM0 20.328h.924v.924H0zM0 21.252h.924v.924H0zM0 22.176h.924v.924H0zM.924 0h.924v.924H.924zM.924 5.544h.924v.924H.924zM.924 7.392h.924v.924H.924zM.924 8.316h.924v.924H.924zM.924 9.24h.924v.924H.924zM.924 12.012h.924v.924H.924zM.924 13.86h.924v.924H.924zM.924 14.784h.924v.924H.924zM.924 16.632h.924v.924H.924zM.924 22.176h.924v.924H.924zM1.848 0h.924v.924h-.924zM1.848 1.848h.924v.924h-.924z"
          fill={colors.main}
        />
        <Path
          d="M1.848 2.772h.924v.924h-.924zM1.848 3.696h.924v.924h-.924zM1.848 5.544h.924v.924h-.924zM1.848 8.316h.924v.924h-.924zM1.848 9.24h.924v.924h-.924zM1.848 10.164h.924v.924h-.924zM1.848 11.088h.924v.924h-.924zM1.848 12.012h.924v.924h-.924zM1.848 14.784h.924v.924h-.924zM1.848 16.632h.924v.924h-.924zM1.848 18.48h.924v.924h-.924zM1.848 19.404h.924v.924h-.924zM1.848 20.328h.924v.924h-.924zM1.848 22.176h.924v.924h-.924zM2.772 0h.924v.924h-.924z"
          fill={colors.main}
        />
        <Path d="M2.772 1.848h.924v.924h-.924z" fill={colors.main} />
        <Path
          d="M2.772 2.772h.924v.924h-.924zM2.772 3.696h.924v.924h-.924zM2.772 5.544h.924v.924h-.924zM2.772 7.392h.924v.924h-.924zM2.772 8.316h.924v.924h-.924zM2.772 9.24h.924v.924h-.924zM2.772 10.164h.924v.924h-.924zM2.772 12.012h.924v.924h-.924zM2.772 14.784h.924v.924h-.924zM2.772 16.632h.924v.924h-.924zM2.772 18.48h.924v.924h-.924zM2.772 19.404h.924v.924h-.924zM2.772 20.328h.924v.924h-.924zM2.772 22.176h.924v.924h-.924zM3.696 0h.924v.924h-.924zM3.696 1.848h.924v.924h-.924z"
          fill={colors.main}
        />
        <Path
          d="M3.696 2.772h.924v.924h-.924zM3.696 3.696h.924v.924h-.924zM3.696 5.544h.924v.924h-.924zM3.696 7.392h.924v.924h-.924zM3.696 11.088h.924v.924h-.924zM3.696 12.012h.924v.924h-.924zM3.696 13.86h.924v.924h-.924zM3.696 14.784h.924v.924h-.924zM3.696 16.632h.924v.924h-.924zM3.696 18.48h.924v.924h-.924zM3.696 19.404h.924v.924h-.924zM3.696 20.328h.924v.924h-.924zM3.696 22.176h.924v.924h-.924zM4.62 0h.924v.924H4.62zM4.62 5.544h.924v.924H4.62zM4.62 7.392h.924v.924H4.62zM4.62 11.088h.924v.924H4.62zM4.62 16.632h.924v.924H4.62zM4.62 22.176h.924v.924H4.62z"
          fill={colors.main}
        />
        <Path
          d="M5.544 0h.924v.924h-.924zM5.544.924h.924v.924h-.924zM5.544 1.848h.924v.924h-.924z"
          fill={colors.main}
        />
        <Path
          d="M5.544 2.772h.924v.924h-.924zM5.544 3.696h.924v.924h-.924zM5.544 4.62h.924v.924h-.924z"
          fill={colors.main}
        />
        <Path
          d="M5.544 5.544h.924v.924h-.924zM5.544 7.392h.924v.924h-.924zM5.544 9.24h.924v.924h-.924zM5.544 11.088h.924v.924h-.924zM5.544 12.936h.924v.924h-.924zM5.544 14.784h.924v.924h-.924zM5.544 16.632h.924v.924h-.924zM5.544 17.556h.924v.924h-.924zM5.544 18.48h.924v.924h-.924zM5.544 19.404h.924v.924h-.924zM5.544 20.328h.924v.924h-.924zM5.544 21.252h.924v.924h-.924zM5.544 22.176h.924v.924h-.924zM6.468 8.316h.924v.924h-.924zM6.468 10.164h.924v.924h-.924zM6.468 11.088h.924v.924h-.924zM6.468 12.936h.924v.924h-.924zM6.468 14.784h.924v.924h-.924zM7.392.924h.924v.924h-.924zM7.392 2.772h.924v.924h-.924zM7.392 3.696h.924v.924h-.924zM7.392 5.544h.924v.924h-.924zM7.392 6.468h.924v.924h-.924zM7.392 7.392h.924v.924h-.924zM7.392 8.316h.924v.924h-.924zM7.392 9.24h.924v.924h-.924zM7.392 10.164h.924v.924h-.924zM7.392 11.088h.924v.924h-.924zM7.392 12.936h.924v.924h-.924zM7.392 13.86h.924v.924h-.924zM7.392 14.784h.924v.924h-.924zM7.392 15.708h.924v.924h-.924zM7.392 17.556h.924v.924h-.924zM7.392 18.48h.924v.924h-.924zM7.392 19.404h.924v.924h-.924zM7.392 21.252h.924v.924h-.924zM8.316 0h.924v.924h-.924zM8.316 1.848h.924v.924h-.924z"
          fill={colors.main}
        />
        <Path
          d="M8.316 2.772h.924v.924h-.924zM8.316 4.62h.924v.924h-.924zM8.316 7.392h.924v.924h-.924zM8.316 8.316h.924v.924h-.924zM8.316 10.164h.924v.924h-.924zM8.316 12.012h.924v.924h-.924zM8.316 14.784h.924v.924h-.924zM8.316 16.632h.924v.924h-.924zM8.316 17.556h.924v.924h-.924zM8.316 18.48h.924v.924h-.924zM8.316 19.404h.924v.924h-.924zM8.316 20.328h.924v.924h-.924zM9.24 2.772h.924v.924H9.24zM9.24 3.696h.924v.924H9.24zM9.24 4.62h.924v.924H9.24z"
          fill={colors.main}
        />
        <Path
          d="M9.24 5.544h.924v.924H9.24zM9.24 8.316h.924v.924H9.24zM9.24 9.24h.924v.924H9.24zM9.24 10.164h.924v.924H9.24zM9.24 11.088h.924v.924H9.24zM9.24 12.936h.924v.924H9.24zM9.24 13.86h.924v.924H9.24zM9.24 14.784h.924v.924H9.24zM9.24 16.632h.924v.924H9.24zM9.24 17.556h.924v.924H9.24zM9.24 19.404h.924v.924H9.24zM9.24 20.328h.924v.924H9.24zM9.24 22.176h.924v.924H9.24zM10.164 4.62h.924v.924h-.924zM10.164 9.24h.924v.924h-.924zM10.164 11.088h.924v.924h-.924zM10.164 12.012h.924v.924h-.924zM10.164 16.632h.924v.924h-.924zM10.164 19.404h.924v.924h-.924zM10.164 20.328h.924v.924h-.924zM10.164 21.252h.924v.924h-.924zM10.164 22.176h.924v.924h-.924zM11.088.924h.924v.924h-.924zM11.088 1.848h.924v.924h-.924zM11.088 3.696h.924v.924h-.924zM11.088 5.544h.924v.924h-.924zM11.088 6.468h.924v.924h-.924zM11.088 7.392h.924v.924h-.924zM11.088 8.316h.924v.924h-.924zM11.088 9.24h.924v.924h-.924zM11.088 12.012h.924v.924h-.924zM11.088 12.936h.924v.924h-.924zM11.088 13.86h.924v.924h-.924zM11.088 14.784h.924v.924h-.924zM11.088 16.632h.924v.924h-.924zM11.088 18.48h.924v.924h-.924zM11.088 20.328h.924v.924h-.924zM11.088 21.252h.924v.924h-.924zM11.088 22.176h.924v.924h-.924zM12.012 0h.924v.924h-.924zM12.012.924h.924v.924h-.924zM12.012 1.848h.924v.924h-.924zM12.012 3.696h.924v.924h-.924zM12.012 4.62h.924v.924h-.924zM12.012 7.392h.924v.924h-.924zM12.012 11.088h.924v.924h-.924zM12.012 12.012h.924v.924h-.924zM12.012 12.936h.924v.924h-.924zM12.012 13.86h.924v.924h-.924zM12.012 16.632h.924v.924h-.924zM12.012 18.48h.924v.924h-.924zM12.012 20.328h.924v.924h-.924zM12.012 21.252h.924v.924h-.924zM12.012 22.176h.924v.924h-.924zM12.936 0h.924v.924h-.924zM12.936.924h.924v.924h-.924zM12.936 1.848h.924v.924h-.924z"
          fill={colors.main}
        />
        <Path
          d="M12.936 2.772h.924v.924h-.924zM12.936 4.62h.924v.924h-.924z"
          fill={colors.main}
        />
        <Path
          d="M12.936 5.544h.924v.924h-.924zM12.936 6.468h.924v.924h-.924zM12.936 7.392h.924v.924h-.924zM12.936 8.316h.924v.924h-.924zM12.936 9.24h.924v.924h-.924zM12.936 10.164h.924v.924h-.924zM12.936 11.088h.924v.924h-.924zM12.936 12.936h.924v.924h-.924zM12.936 13.86h.924v.924h-.924zM12.936 15.708h.924v.924h-.924zM12.936 16.632h.924v.924h-.924zM12.936 17.556h.924v.924h-.924zM12.936 20.328h.924v.924h-.924zM12.936 21.252h.924v.924h-.924zM13.86 0h.924v.924h-.924zM13.86.924h.924v.924h-.924zM13.86 2.772h.924v.924h-.924zM13.86 3.696h.924v.924h-.924zM13.86 7.392h.924v.924h-.924zM13.86 10.164h.924v.924h-.924zM13.86 12.936h.924v.924h-.924zM13.86 14.784h.924v.924h-.924zM13.86 17.556h.924v.924h-.924zM13.86 18.48h.924v.924h-.924zM13.86 19.404h.924v.924h-.924zM14.784 5.544h.924v.924h-.924zM14.784 7.392h.924v.924h-.924zM14.784 11.088h.924v.924h-.924zM14.784 14.784h.924v.924h-.924zM14.784 15.708h.924v.924h-.924zM14.784 16.632h.924v.924h-.924zM14.784 17.556h.924v.924h-.924zM14.784 18.48h.924v.924h-.924zM14.784 19.404h.924v.924h-.924zM14.784 20.328h.924v.924h-.924zM14.784 22.176h.924v.924h-.924zM15.708 7.392h.924v.924h-.924zM15.708 9.24h.924v.924h-.924zM15.708 12.012h.924v.924h-.924zM15.708 12.936h.924v.924h-.924zM15.708 14.784h.924v.924h-.924zM15.708 18.48h.924v.924h-.924zM15.708 20.328h.924v.924h-.924zM15.708 22.176h.924v.924h-.924zM16.632 0h.924v.924h-.924zM16.632.924h.924v.924h-.924zM16.632 1.848h.924v.924h-.924z"
          fill={colors.main}
        />
        <Path
          d="M16.632 2.772h.924v.924h-.924zM16.632 3.696h.924v.924h-.924zM16.632 4.62h.924v.924h-.924z"
          fill={colors.main}
        />
        <Path
          d="M16.632 5.544h.924v.924h-.924zM16.632 7.392h.924v.924h-.924zM16.632 9.24h.924v.924h-.924zM16.632 11.088h.924v.924h-.924zM16.632 12.936h.924v.924h-.924zM16.632 13.86h.924v.924h-.924zM16.632 14.784h.924v.924h-.924zM16.632 16.632h.924v.924h-.924zM16.632 18.48h.924v.924h-.924zM16.632 19.404h.924v.924h-.924zM17.556 0h.924v.924h-.924zM17.556 5.544h.924v.924h-.924zM17.556 8.316h.924v.924h-.924zM17.556 9.24h.924v.924h-.924zM17.556 10.164h.924v.924h-.924zM17.556 11.088h.924v.924h-.924zM17.556 12.936h.924v.924h-.924zM17.556 13.86h.924v.924h-.924zM17.556 14.784h.924v.924h-.924zM17.556 18.48h.924v.924h-.924zM17.556 20.328h.924v.924h-.924zM18.48 0h.924v.924h-.924zM18.48 1.848h.924v.924h-.924z"
          fill={colors.main}
        />
        <Path
          d="M18.48 2.772h.924v.924h-.924zM18.48 3.696h.924v.924h-.924zM18.48 5.544h.924v.924h-.924zM18.48 7.392h.924v.924h-.924zM18.48 8.316h.924v.924h-.924zM18.48 9.24h.924v.924h-.924zM18.48 12.012h.924v.924h-.924zM18.48 12.936h.924v.924h-.924zM18.48 14.784h.924v.924h-.924zM18.48 15.708h.924v.924h-.924zM18.48 16.632h.924v.924h-.924zM18.48 17.556h.924v.924h-.924zM18.48 18.48h.924v.924h-.924zM18.48 20.328h.924v.924h-.924zM18.48 21.252h.924v.924h-.924zM19.404 0h.924v.924h-.924zM19.404 1.848h.924v.924h-.924z"
          fill={colors.main}
        />
        <Path
          d="M19.404 2.772h.924v.924h-.924zM19.404 3.696h.924v.924h-.924zM19.404 5.544h.924v.924h-.924zM19.404 7.392h.924v.924h-.924zM19.404 8.316h.924v.924h-.924zM19.404 11.088h.924v.924h-.924zM19.404 12.012h.924v.924h-.924zM19.404 12.936h.924v.924h-.924zM19.404 13.86h.924v.924h-.924zM19.404 14.784h.924v.924h-.924zM19.404 17.556h.924v.924h-.924zM19.404 18.48h.924v.924h-.924zM19.404 19.404h.924v.924h-.924zM19.404 21.252h.924v.924h-.924zM19.404 22.176h.924v.924h-.924zM20.328 0h.924v.924h-.924zM20.328 1.848h.924v.924h-.924z"
          fill={colors.main}
        />
        <Path
          d="M20.328 2.772h.924v.924h-.924zM20.328 3.696h.924v.924h-.924zM20.328 5.544h.924v.924h-.924zM20.328 8.316h.924v.924h-.924zM20.328 9.24h.924v.924h-.924zM20.328 10.164h.924v.924h-.924zM20.328 12.012h.924v.924h-.924zM20.328 13.86h.924v.924h-.924zM20.328 14.784h.924v.924h-.924zM20.328 15.708h.924v.924h-.924zM20.328 20.328h.924v.924h-.924zM20.328 21.252h.924v.924h-.924zM21.252 0h.924v.924h-.924zM21.252 5.544h.924v.924h-.924zM21.252 7.392h.924v.924h-.924zM21.252 8.316h.924v.924h-.924zM21.252 12.012h.924v.924h-.924zM21.252 12.936h.924v.924h-.924zM21.252 13.86h.924v.924h-.924zM21.252 18.48h.924v.924h-.924zM21.252 20.328h.924v.924h-.924zM21.252 21.252h.924v.924h-.924zM22.176 0h.924v.924h-.924zM22.176.924h.924v.924h-.924zM22.176 1.848h.924v.924h-.924z"
          fill={colors.main}
        />
        <Path
          d="M22.176 2.772h.924v.924h-.924zM22.176 3.696h.924v.924h-.924zM22.176 4.62h.924v.924h-.924z"
          fill={colors.main}
        />
        <Path
          d="M22.176 5.544h.924v.924h-.924zM22.176 9.24h.924v.924h-.924zM22.176 11.088h.924v.924h-.924zM22.176 12.936h.924v.924h-.924zM22.176 14.784h.924v.924h-.924zM22.176 16.632h.924v.924h-.924zM22.176 19.404h.924v.924h-.924zM22.176 20.328h.924v.924h-.924zM22.176 21.252h.924v.924h-.924zM22.176 22.176h.924v.924h-.924z"
          fill={colors.main}
        />
      </G>
    ),

    viewBox: '0 0 24 24',
  },
  Menu: {
    svg: (
      <Path
        d="M 0 8 L 0 6 L 24 6 L 24 8 Z M 0 0 L 24 0 L 24 2 L 0 2 Z M 0 12 L 24 12 L 24 14 L 0 14 Z"
        fill="rgba(119,119,119,1)"
      />
    ),
    viewBox: '0 0 24 24',
  },
  Settings: {
    svg: (
      <Path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M11.3745 20H12.6255V19.233C12.6255 18.298 13.2005 17.458 14.0895 17.091C15.0095 16.708 16.0145 16.896 16.6765 17.562L17.2155 18.103L18.1035 17.215L17.5585 16.671C16.8955 16.009 16.7085 15.005 17.0815 14.114C17.0815 14.114 17.0825 14.113 17.0825 14.112L17.0935 14.084C17.4575 13.201 18.2985 12.625 19.2335 12.625H19.9995V11.375H19.2335C18.2985 11.375 17.4575 10.8 17.0915 9.911C16.7065 8.991 16.8955 7.986 17.5615 7.323L18.1025 6.784L17.2155 5.897L16.6705 6.442C16.0085 7.104 15.0055 7.291 14.1145 6.919C13.2015 6.542 12.6255 5.702 12.6255 4.767V4H11.3745V4.767C11.3745 5.702 10.7995 6.542 9.91051 6.909C8.99151 7.294 7.98651 7.105 7.32351 6.438L6.78451 5.897L5.89651 6.785L6.44151 7.329C7.10351 7.991 7.29151 8.995 6.91851 9.886C6.54251 10.799 5.70151 11.375 4.76651 11.375H3.99951V12.625H4.76651C5.70151 12.625 6.54251 13.2 6.90851 14.089C7.29351 15.009 7.10451 16.014 6.43851 16.677L5.89751 17.216L6.78451 18.103L7.32951 17.558C7.99151 16.896 8.99451 16.709 9.88551 17.081C10.7985 17.458 11.3745 18.298 11.3745 19.233V20ZM12.9425 22H11.0505C10.1265 22 9.37451 21.248 9.37451 20.324V19.233C9.37451 19.086 9.25751 18.985 9.14751 18.94C9.00351 18.881 8.84951 18.869 8.74351 18.972L7.97351 19.743C7.31751 20.397 6.25151 20.399 5.59651 19.743L4.25651 18.403C3.93851 18.085 3.76451 17.663 3.76451 17.213C3.76551 16.764 3.94051 16.342 4.25951 16.024L5.02751 15.259C5.13251 15.154 5.12151 15 5.07451 14.889C5.01451 14.742 4.91451 14.625 4.76651 14.625H3.68251C2.75451 14.625 1.99951 13.871 1.99951 12.943V11.051C1.99951 10.126 2.75151 9.375 3.67651 9.375H4.76651C4.91351 9.375 5.01451 9.257 5.05951 9.147C5.11951 9.003 5.13151 8.848 5.02751 8.744L4.25651 7.974C3.60251 7.317 3.60251 6.251 4.25651 5.597L5.59651 4.257C5.91451 3.939 6.33551 3.765 6.78451 3.765H6.78651C7.23551 3.765 7.65851 3.94 7.97551 4.259L8.74051 5.028C8.84551 5.134 9.00051 5.122 9.11151 5.075C9.25751 5.014 9.37451 4.914 9.37451 4.767V3.683C9.37451 2.755 10.1295 2 11.0575 2H12.9495C13.8735 2 14.6255 2.752 14.6255 3.676V4.767C14.6255 4.914 14.7425 5.015 14.8525 5.06C14.9975 5.12 15.1515 5.133 15.2565 5.028L16.0265 4.257C16.6825 3.603 17.7485 3.601 18.4035 4.257L19.7445 5.598C20.0625 5.915 20.2365 6.337 20.2355 6.787C20.2355 7.235 20.0605 7.658 19.7415 7.975L18.9725 8.741C18.8675 8.846 18.8785 9 18.9255 9.111C18.9855 9.258 19.0855 9.375 19.2335 9.375H20.3175C21.2455 9.375 21.9995 10.129 21.9995 11.057V12.949C21.9995 13.874 21.2485 14.625 20.3235 14.625H19.2335C19.0865 14.625 18.9855 14.743 18.9405 14.853C18.9395 14.854 18.9275 14.884 18.9265 14.886C18.8805 14.997 18.8685 15.152 18.9725 15.256L19.7435 16.026C20.3975 16.683 20.3975 17.749 19.7435 18.403L18.4035 19.743C18.0855 20.061 17.6645 20.235 17.2155 20.235H17.2135C16.7645 20.235 16.3415 20.06 16.0245 19.741L15.2595 18.972C15.1545 18.867 14.9985 18.879 14.8885 18.925C14.7425 18.986 14.6255 19.086 14.6255 19.233V20.317C14.6255 21.245 13.8705 22 12.9425 22ZM12 10.5C11.173 10.5 10.5 11.173 10.5 12C10.5 12.827 11.173 13.5 12 13.5C12.827 13.5 13.5 12.827 13.5 12C13.5 11.173 12.827 10.5 12 10.5ZM12 15.5C10.07 15.5 8.50001 13.93 8.50001 12C8.50001 10.07 10.07 8.5 12 8.5C13.93 8.5 15.5 10.07 15.5 12C15.5 13.93 13.93 15.5 12 15.5Z"
        fill="#777777"
      />
    ),
    viewBox: '0 0 24 24',
  },
  About: {
    svg: (
      <Path
        d="M12 24c-1.105 0-2.169-.143-3.193-.429a12.172 12.172 0 0 1-2.871-1.207c-.89-.519-1.7-1.143-2.429-1.871a11.883 11.883 0 0 1-1.871-2.429 12.172 12.172 0 0 1-1.207-2.871A11.823 11.823 0 0 1 0 12c0-1.105.143-2.169.429-3.193a12.172 12.172 0 0 1 1.207-2.871c.519-.89 1.143-1.7 1.871-2.429A12.087 12.087 0 0 1 5.936 1.63C6.826 1.105 7.783.702 8.807.42A12.01 12.01 0 0 1 12 0c1.105 0 2.169.14 3.193.421 1.024.281 1.98.684 2.871 1.208a12.087 12.087 0 0 1 4.307 4.307c.524.89.927 1.847 1.208 2.871A12.01 12.01 0 0 1 24 12c0 1.105-.14 2.169-.421 3.193a11.788 11.788 0 0 1-1.208 2.871c-.523.89-1.15 1.7-1.878 2.429a11.883 11.883 0 0 1-2.429 1.871c-.89.52-1.847.922-2.871 1.207A11.823 11.823 0 0 1 12 24zm0-22.4c-.962 0-1.883.124-2.764.371A10.429 10.429 0 0 0 4.65 4.65a10.226 10.226 0 0 0-1.621 2.107c-.448.772-.798 1.6-1.05 2.486A10.012 10.012 0 0 0 1.6 12c0 .952.126 1.871.379 2.757.252.886.602 1.714 1.05 2.486.447.771.988 1.474 1.621 2.107a10.226 10.226 0 0 0 2.107 1.621c.772.448 1.598.798 2.479 1.05.88.253 1.8.379 2.757.379.957 0 1.878-.126 2.764-.379a10.861 10.861 0 0 0 2.486-1.05 10.226 10.226 0 0 0 2.107-1.621 10.429 10.429 0 0 0 2.679-4.586c.247-.88.371-1.8.371-2.757 0-.957-.124-1.878-.371-2.764A10.429 10.429 0 0 0 19.35 4.65a10.429 10.429 0 0 0-4.593-2.679A10.192 10.192 0 0 0 12 1.6zm-.8 8h1.6v8h-1.6v-8zm0-3.2h1.6V8h-1.6V6.4z"
        fill="rgba(119, 119, 119, 1)"
      />
    ),
    viewBox: '0 0 24 24',
  },
  Chat: {
    svg: (
      <Path
        d="M11.223 15.562a8.304 8.304 0 0 1 2.163 1.246 8.19 8.19 0 0 1 1.66 1.788c.46.674.818 1.406 1.072 2.196.255.79.382 1.61.382 2.458V24H15v-.75c0-.929-.179-1.804-.536-2.625a6.872 6.872 0 0 0-1.446-2.143 6.872 6.872 0 0 0-2.143-1.446A6.512 6.512 0 0 0 8.25 16.5c-.929 0-1.804.179-2.625.536a6.872 6.872 0 0 0-2.143 1.446 6.872 6.872 0 0 0-1.446 2.143A6.512 6.512 0 0 0 1.5 23.25V24H0v-.75c0-.848.127-1.667.382-2.458a8.499 8.499 0 0 1 1.071-2.196 8.19 8.19 0 0 1 1.66-1.788 8.304 8.304 0 0 1 2.164-1.246 4.936 4.936 0 0 1-.958-.843 5.216 5.216 0 0 1-.71-1.038 5.626 5.626 0 0 1-.448-1.172c-.107-.41-.161-.83-.161-1.259 0-.723.138-1.404.415-2.042A5.331 5.331 0 0 1 4.54 7.54a5.332 5.332 0 0 1 1.668-1.125A5.079 5.079 0 0 1 8.25 6c.723 0 1.404.138 2.042.415A5.331 5.331 0 0 1 11.96 7.54a5.332 5.332 0 0 1 1.125 1.668c.277.638.415 1.319.415 2.042 0 .429-.054.848-.16 1.259-.108.41-.257.801-.45 1.172-.191.37-.428.716-.71 1.038-.28.321-.6.602-.957.843zM8.25 15c.518 0 1.002-.098 1.453-.295A3.813 3.813 0 0 0 11.7 12.71c.2-.456.301-.942.301-1.46s-.1-1.002-.301-1.453a3.91 3.91 0 0 0-.81-1.185 3.91 3.91 0 0 0-1.186-.81A3.53 3.53 0 0 0 8.25 7.5c-.518 0-1.004.1-1.46.301a3.813 3.813 0 0 0-1.996 1.996c-.196.45-.294.935-.294 1.453s.098 1.004.295 1.46c.196.455.464.852.803 1.192.34.34.737.607 1.192.803.456.197.942.295 1.46.295zM24 0v12h-3l-4.5 4.5V12H15v-1.5h3v2.384l2.384-2.384H22.5v-9h-15v2.692c-.25.036-.502.078-.757.127-.254.05-.502.119-.743.208V0h18z"
        fill="rgba(119, 119, 119, 1)"
      />
    ),
    viewBox: '0 0 24 24',
  },
  Passcode: {
    svg: (
      <Path
        d="M24 18.429V24h-6v-3h-3v-3h-3v-2.424a8.003 8.003 0 0 1-3.75.924 8.076 8.076 0 0 1-2.19-.295 8.222 8.222 0 0 1-3.643-2.123A8.222 8.222 0 0 1 .295 10.44 8.076 8.076 0 0 1 0 8.25c0-.759.098-1.489.295-2.19a8.222 8.222 0 0 1 2.123-3.643A8.222 8.222 0 0 1 6.06.295C6.761.098 7.491 0 8.25 0c.759 0 1.489.098 2.19.295a8.222 8.222 0 0 1 3.643 2.123 8.222 8.222 0 0 1 2.122 3.642 8.076 8.076 0 0 1 .201 3.375 8.36 8.36 0 0 1-.268 1.145L24 18.43zm-1.5.642l-8.09-8.089c.18-.446.322-.895.43-1.346a6.512 6.512 0 0 0-.375-4.011 6.872 6.872 0 0 0-1.447-2.143 6.872 6.872 0 0 0-2.143-1.446A6.512 6.512 0 0 0 8.25 1.5c-.929 0-1.804.179-2.625.536a6.872 6.872 0 0 0-2.143 1.446 6.872 6.872 0 0 0-1.446 2.143A6.512 6.512 0 0 0 1.5 8.25c0 .929.179 1.804.536 2.625.357.821.839 1.536 1.446 2.143a6.872 6.872 0 0 0 2.143 1.446A6.512 6.512 0 0 0 8.25 15c.759 0 1.504-.13 2.237-.388a6.384 6.384 0 0 0 1.968-1.112H13.5v3h3v3h3v3h3v-3.429zM6 4.5c.214 0 .41.038.59.114.178.076.336.183.475.321.138.139.245.297.321.476.076.178.114.375.114.589 0 .214-.038.41-.114.59a1.417 1.417 0 0 1-.321.468 1.654 1.654 0 0 1-.476.321A1.42 1.42 0 0 1 6 7.5c-.214 0-.41-.04-.59-.12a1.564 1.564 0 0 1-.79-.79A1.42 1.42 0 0 1 4.5 6c0-.214.04-.41.12-.59.08-.178.188-.336.322-.475.134-.138.29-.245.469-.321.178-.076.375-.114.589-.114z"
        fill="rgba(119, 119, 119, 1)"
      />
    ),
    viewBox: '0 0 24 24',
  },
  Biometrics: {
    svg: (
      <Path
        d="M3.658 22.5a.838.838 0 0 1-.604-.245.818.818 0 0 1-.253-.612c0-.184.048-.347.145-.49a.874.874 0 0 1 .421-.321 7.58 7.58 0 0 0 1.845-1.11 8.917 8.917 0 0 0 1.477-1.53c.428-.567.803-1.18 1.125-1.837.321-.659.589-1.324.803-1.998.062-.184.161-.337.299-.459.138-.122.319-.184.543-.184.225 0 .421.087.59.26a.85.85 0 0 1 .252.613c0 .367-.107.819-.321 1.354-.215.536-.5 1.095-.858 1.676A18.065 18.065 0 0 1 7.89 19.37c-.464.587-.941 1.11-1.43 1.569-.49.459-.98.834-1.47 1.125-.49.29-.934.436-1.332.436zM7.73 24a.825.825 0 0 1-.605-.253.825.825 0 0 1-.253-.604c0-.296.128-.536.383-.72a8.035 8.035 0 0 0 1.01-.872c.357-.357.712-.755 1.064-1.194.352-.439.694-.9 1.026-1.385.331-.485.622-.975.872-1.47.25-.494.449-.976.597-1.446.148-.47.222-.908.222-1.316 0-.49-.036-.908-.107-1.255-.072-.347-.204-.63-.398-.85-.194-.22-.462-.38-.804-.482-.342-.102-.773-.153-1.293-.153-.357 0-.666.074-.926.222-.26.148-.487.344-.681.59-.194.244-.378.53-.551.856l-.505 1.056c-.184.368-.383.745-.597 1.133-.215.388-.47.76-.766 1.117a6.664 6.664 0 0 1-1.056 1.01 5.99 5.99 0 0 1-1.454.812c-.122.04-.235.061-.337.061a.825.825 0 0 1-.604-.252.825.825 0 0 1-.253-.605c0-.184.051-.344.153-.482a.968.968 0 0 1 .398-.314 6.28 6.28 0 0 0 1.661-1.14 5.192 5.192 0 0 0 1.156-1.66c.224-.521.454-1.029.688-1.524.235-.495.513-.936.835-1.324a3.636 3.636 0 0 1 1.155-.926c.45-.23 1.01-.344 1.684-.344 1.52 0 2.62.372 3.298 1.117.679.745 1.018 1.857 1.018 3.337 0 .47-.087.984-.26 1.546-.173.56-.4 1.14-.681 1.737-.28.597-.607 1.196-.98 1.798a17.555 17.555 0 0 1-1.178 1.684c-.414.52-.834.985-1.263 1.393a7.66 7.66 0 0 1-1.21.964.703.703 0 0 1-.458.138zm5.142 0a.825.825 0 0 1-.604-.253.825.825 0 0 1-.253-.604c0-.133.026-.253.077-.36.05-.107.127-.212.23-.314a9.47 9.47 0 0 0 1.385-1.691c.413-.638.773-1.314 1.079-2.028.306-.714.54-1.444.704-2.189.163-.745.245-1.47.245-2.173 0-.735-.14-1.452-.421-2.15a6.168 6.168 0 0 0-1.156-1.86 5.827 5.827 0 0 0-1.73-1.31 4.693 4.693 0 0 0-2.127-.497c-.837 0-1.523.057-2.059.169-.535.112-.977.27-1.324.474a2.82 2.82 0 0 0-.85.75c-.219.296-.435.628-.65.995-.214.368-.456.773-.727 1.217-.27.444-.625.91-1.063 1.4a7.938 7.938 0 0 1-1.133 1.095 4.136 4.136 0 0 1-1.393.727.247.247 0 0 1-.107.03H.888a.855.855 0 0 1-.628-.26.838.838 0 0 1-.26-.612c0-.204.061-.372.184-.505.122-.133.27-.235.444-.306.52-.204.951-.454 1.293-.75.342-.296.635-.625.88-.987.245-.363.47-.74.673-1.133.205-.393.421-.78.651-1.163.23-.383.5-.748.811-1.095a4.331 4.331 0 0 1 1.171-.903c.47-.255 1.044-.461 1.722-.62.679-.158 1.503-.237 2.472-.237a6.3 6.3 0 0 1 1.913.291 7.118 7.118 0 0 1 1.715.804c.53.341 1.012.75 1.446 1.224.434.475.806.992 1.117 1.554.312.56.549 1.153.712 1.775a7.51 7.51 0 0 1 .245 1.913c0 .46-.046.97-.138 1.531a15.507 15.507 0 0 1-.398 1.753 18.33 18.33 0 0 1-.627 1.821 16.862 16.862 0 0 1-.812 1.73 10.22 10.22 0 0 1-.971 1.484 5.726 5.726 0 0 1-1.095 1.08 1.549 1.549 0 0 1-.26.13.755.755 0 0 1-.276.053zm5.97-13.714c-.347 0-.607-.164-.78-.49-.848-1.54-1.914-2.702-3.2-3.482-1.285-.78-2.816-1.171-4.592-1.171-.724 0-1.415.038-2.074.115a8.177 8.177 0 0 0-1.867.436 6.017 6.017 0 0 0-1.638.91c-.505.393-.967.901-1.385 1.524-.092.132-.196.24-.314.321a.745.745 0 0 1-.436.122.825.825 0 0 1-.604-.252.825.825 0 0 1-.253-.605c0-.132.036-.27.107-.413A5.736 5.736 0 0 1 3.36 5.403a8.067 8.067 0 0 1 2.089-1.186c.755-.291 1.548-.495 2.38-.612a17.463 17.463 0 0 1 2.441-.176c.97 0 1.926.122 2.87.367.944.245 1.832.605 2.664 1.079a9.561 9.561 0 0 1 2.234 1.76 8.346 8.346 0 0 1 1.584 2.426c.051.133.077.255.077.368a.825.825 0 0 1-.253.604.825.825 0 0 1-.604.253zm-1.714-6.812a.923.923 0 0 1-.414-.107 16.483 16.483 0 0 0-3.122-1.224 12.498 12.498 0 0 0-3.322-.429c-1.01 0-1.972.107-2.885.322-.913.214-1.829.52-2.747.918a.819.819 0 0 1-.383.092.8.8 0 0 1-.597-.253.838.838 0 0 1-.245-.604c0-.255.14-.487.421-.697.28-.209.643-.395 1.087-.558A11.32 11.32 0 0 1 6.383.513a23.105 23.105 0 0 1 2.954-.46C9.755.019 10.07 0 10.286 0c.214 0 .556.026 1.025.077.47.05.99.127 1.561.23.572.101 1.161.226 1.768.374s1.158.319 1.653.513c.495.194.9.408 1.217.643.317.234.475.495.475.78a.825.825 0 0 1-.253.605.825.825 0 0 1-.604.252z"
        fill="rgba(119, 119, 119, 1)"
      />
    ),
    viewBox: '0 0 24 24',
  },
  Backup: {
    svg: (
      <Path
        d="M12 6v6.429l4.272 4.299-1.044 1.044-4.728-4.7V6H12zm6 1.5h3.482a10.598 10.598 0 0 0-3.877-4.373 10.569 10.569 0 0 0-2.665-1.205A10.31 10.31 0 0 0 12 1.5c-.964 0-1.893.125-2.786.375s-1.727.603-2.504 1.058A10.537 10.537 0 0 0 4.58 4.58a10.536 10.536 0 0 0-1.647 2.13 10.558 10.558 0 0 0-1.058 2.504c-.25.893-.375 1.822-.375 2.786s.125 1.893.375 2.786.603 1.727 1.058 2.504a10.537 10.537 0 0 0 1.647 2.13 10.536 10.536 0 0 0 2.13 1.647c.777.455 1.611.808 2.504 1.058s1.822.375 2.786.375c1.17 0 2.3-.19 3.388-.57a10.59 10.59 0 0 0 2.967-1.586 10.686 10.686 0 0 0 2.31-2.431 10.185 10.185 0 0 0 1.447-3.114l1.446.402a11.703 11.703 0 0 1-1.654 3.562 12.025 12.025 0 0 1-6.027 4.594A11.756 11.756 0 0 1 12 24c-1.098 0-2.16-.143-3.188-.429a12.139 12.139 0 0 1-2.872-1.205 11.9 11.9 0 0 1-2.431-1.875 11.9 11.9 0 0 1-1.875-2.43 12.168 12.168 0 0 1-1.205-2.867A11.787 11.787 0 0 1 0 12.007c0-1.103.143-2.168.429-3.195A12.139 12.139 0 0 1 1.634 5.94a11.9 11.9 0 0 1 1.875-2.431 11.9 11.9 0 0 1 2.43-1.875c.89-.518 1.844-.92 2.867-1.205A11.787 11.787 0 0 1 11.993 0c1.103 0 2.17.145 3.201.435a12.11 12.11 0 0 1 5.39 3.188c.75.763 1.39 1.627 1.916 2.591V3H24v6h-6V7.5z"
        fill="rgba(227, 227, 227, 0.6)"
      />
    ),
    viewBox: '0 0 24 24',
  },
  Search: {
    svg: (
      <Path
        d="M23.5598 21.5557L16.9889 14.9822C18.1667 13.3758 18.7977 11.4336 18.7889 9.44161C18.7664 4.24189 14.5608 0.0301279 9.36111 9.55172e-05C6.87276 -0.0111628 4.48327 0.97323 2.72494 2.73398C0.966601 4.49473 -0.0145114 6.88557 0.000162259 9.3739C0.0226363 14.5741 4.22866 18.7862 9.42882 18.8163C11.4289 18.8249 13.3782 18.1866 14.9857 16.9965L14.9926 16.9914L21.5575 23.5597C21.9125 23.9321 22.4413 24.0828 22.9393 23.9535C23.4372 23.8242 23.8259 23.4352 23.9548 22.9371C24.0837 22.4391 23.9325 21.9104 23.5598 21.5557ZM9.42196 16.934C5.26206 16.91 1.8973 13.5407 1.87904 9.38076C1.86781 7.39035 2.65276 5.47806 4.05917 4.06957C5.46557 2.66107 7.37669 1.87327 9.36711 1.88154C13.527 1.90547 16.8918 5.27483 16.91 9.43476C16.9213 11.4252 16.1363 13.3374 14.7299 14.7459C13.3235 16.1544 11.4124 16.9422 9.42196 16.934Z"
        fill="#777777"
      />
    ),
    viewBox: '0 0 24 24',
  },
  Add: {
    svg: (
      <Path
        d="M13.2 6H10.8V10.8H6V13.2H10.8V18H13.2V13.2H18V10.8H13.2V6ZM12 0C5.388 0 0 5.388 0 12C0 18.612 5.388 24 12 24C18.612 24 24 18.612 24 12C24 5.388 18.612 0 12 0ZM12 21.6C6.708 21.6 2.4 17.292 2.4 12C2.4 6.708 6.708 2.4 12 2.4C17.292 2.4 21.6 6.708 21.6 12C21.6 17.292 17.292 21.6 12 21.6Z"
        fill="#777777"
      />
    ),
    viewBox: '0 0 24 24',
  },
  ChevronRight: {
    svg: (
      <Path
        d="M0.726927 1.65272C0.101979 1.05463 0.525321 0 1.39035 0C1.63754 0 1.87519 0.0953964 2.05378 0.266306L6.24511 4.27754C6.65655 4.67131 6.65655 5.32869 6.24511 5.72246L2.05378 9.73369C1.87519 9.9046 1.63754 10 1.39035 10C0.525321 10 0.10198 8.94537 0.726928 8.34727L3.46959 5.72246C3.88104 5.32869 3.88104 4.67131 3.46959 4.27754L0.726927 1.65272Z"
        fill="#a5a5a5"
      />
    ),
    viewBox: '0 -7 20 25',
  },
  ChevronLeft: {
    svg: (
      <Path
        d="M20 2.50303L17.5596 0L4 14L17.5733 28L20 25.497L8.85347 14L20 2.50303Z"
        fill="#777777"
      />
    ),
    viewBox: '0 0 24 36',
  },
  CheckmarkBadge: {
    svg: (
      <Path
        d="M6.875 21.2004V28.4852L10.9705 25.2123L15.125 28.4852V21.2004C13.8512 21.7161 12.4587 22 11 22C9.54126 22 8.14884 21.7161 6.875 21.2004ZM4.12496 19.5874C1.61021 17.5714 0 14.4738 0 11C0 4.92487 4.92487 0 11 0C17.0751 0 22 4.92487 22 11C22 14.5008 20.3646 17.6197 17.8161 19.6343L17.816 32.527L10.9705 28.4315L4.125 32.527L4.12496 19.5874ZM11 19.25C15.5563 19.25 19.25 15.5563 19.25 11C19.25 6.44365 15.5563 2.75 11 2.75C6.44365 2.75 2.75 6.44365 2.75 11C2.75 15.5563 6.44365 19.25 11 19.25ZM16.2142 7.8418C16.2443 7.89785 16.2594 7.93988 16.2594 7.9679C16.2594 7.99593 16.2443 8.03796 16.2142 8.09401L10.5972 14.8196C10.5069 14.9036 10.4393 14.9457 10.3941 14.9457C10.3189 14.9457 10.2438 14.9106 10.1686 14.8406L6.98779 11.9822L6.92012 11.9192C6.89004 11.8631 6.875 11.8211 6.875 11.7931C6.875 11.779 6.89004 11.744 6.92012 11.688L6.96523 11.6459C7.38633 11.2256 7.71719 10.9033 7.95781 10.6791C8.04804 10.5951 8.1082 10.553 8.13828 10.553C8.19844 10.553 8.27363 10.5951 8.36387 10.6791L10.1686 12.3185L14.6803 6.91704C14.7104 6.88901 14.7555 6.875 14.8156 6.875C14.8608 6.875 14.9134 6.88901 14.9736 6.91704L16.2142 7.8418Z"
        fill="#505050"
      />
    ),
    viewBox: '0 0 22 33',
  },
  Check: {
    svg: (
      <G>
        <Path
          d="M20.997 10.9741H21C21.551 10.9741 21.999 11.4201 22 11.9711C22.008 14.6421 20.975 17.1571 19.091 19.0511C17.208 20.9451 14.7 21.9921 12.029 22.0001H12C9.339 22.0001 6.836 20.9681 4.949 19.0911C3.055 17.2081 2.008 14.7001 2 12.0291C1.992 9.3571 3.025 6.8431 4.909 4.9491C6.792 3.0551 9.3 2.0081 11.971 2.0001C12.766 2.0121 13.576 2.0921 14.352 2.2781C14.888 2.4081 15.219 2.9481 15.089 3.4851C14.96 4.0211 14.417 4.3511 13.883 4.2231C13.262 4.0731 12.603 4.0101 11.977 4.0001C9.84 4.0061 7.833 4.8441 6.327 6.3591C4.82 7.8741 3.994 9.8861 4 12.0231C4.006 14.1601 4.844 16.1661 6.359 17.6731C7.869 19.1741 9.871 20.0001 12 20.0001H12.023C14.16 19.9941 16.167 19.1561 17.673 17.6411C19.18 16.1251 20.006 14.1141 20 11.9771C19.999 11.4251 20.445 10.9751 20.997 10.9741ZM8.293 11.293C8.684 10.902 9.316 10.902 9.707 11.293L11.951 13.537L18.248 6.341C18.612 5.928 19.243 5.884 19.659 6.248C20.074 6.611 20.116 7.243 19.752 7.659L12.752 15.659C12.57 15.867 12.31 15.99 12.033 16H12C11.735 16 11.481 15.895 11.293 15.707L8.293 12.707C7.902 12.316 7.902 11.684 8.293 11.293Z"
          fill="#FFFFFF"
        />
        <Mask id="mask0" x="2" y="2" width="20" height="20">
          <Path
            d="M20.997 10.9741H21C21.551 10.9741 21.999 11.4201 22 11.9711C22.008 14.6421 20.975 17.1571 19.091 19.0511C17.208 20.9451 14.7 21.9921 12.029 22.0001H12C9.339 22.0001 6.836 20.9681 4.949 19.0911C3.055 17.2081 2.008 14.7001 2 12.0291C1.992 9.3571 3.025 6.8431 4.909 4.9491C6.792 3.0551 9.3 2.0081 11.971 2.0001C12.766 2.0121 13.576 2.0921 14.352 2.2781C14.888 2.4081 15.219 2.9481 15.089 3.4851C14.96 4.0211 14.417 4.3511 13.883 4.2231C13.262 4.0731 12.603 4.0101 11.977 4.0001C9.84 4.0061 7.833 4.8441 6.327 6.3591C4.82 7.8741 3.994 9.8861 4 12.0231C4.006 14.1601 4.844 16.1661 6.359 17.6731C7.869 19.1741 9.871 20.0001 12 20.0001H12.023C14.16 19.9941 16.167 19.1561 17.673 17.6411C19.18 16.1251 20.006 14.1141 20 11.9771C19.999 11.4251 20.445 10.9751 20.997 10.9741ZM8.293 11.293C8.684 10.902 9.316 10.902 9.707 11.293L11.951 13.537L18.248 6.341C18.612 5.928 19.243 5.884 19.659 6.248C20.074 6.611 20.116 7.243 19.752 7.659L12.752 15.659C12.57 15.867 12.31 15.99 12.033 16H12C11.735 16 11.481 15.895 11.293 15.707L8.293 12.707C7.902 12.316 7.902 11.684 8.293 11.293Z"
            fill="white"
          />
        </Mask>
        <G mask="url(#mask0)">
          <G>
            <Rect width="24" height="24" fill="white" />
          </G>
        </G>
      </G>
    ),
    viewBox: '0 0 24 24',
  },
  Send: {
    svg: (
      <G>
        <Path
          id="Mask"
          fillRule="evenodd"
          clipRule="evenodd"
          d="M15 17.8379L13.144 12.2709L18.712 6.7019L15 17.8379ZM17.298 5.2879L11.73 10.8559L6.162 8.9999L17.298 5.2879ZM21.99 2.9479C21.985 2.8549 21.968 2.7649 21.937 2.6779C21.927 2.6469 21.916 2.6169 21.902 2.5869C21.854 2.4799 21.793 2.3789 21.707 2.2929C21.621 2.2069 21.52 2.1459 21.412 2.0979C21.383 2.0839 21.354 2.0729 21.323 2.0629C21.234 2.0319 21.143 2.0139 21.048 2.0089C21.026 2.0079 21.006 2.0029 20.983 2.0029C20.883 2.0049 20.782 2.0189 20.684 2.0509L2.684 8.0509C2.275 8.1879 2 8.5689 2 8.9999C2 9.4309 2.275 9.8129 2.684 9.9489L11.209 12.7909L14.052 21.3169C14.188 21.7249 14.569 21.9999 15 21.9999C15.431 21.9999 15.812 21.7249 15.948 21.3169L21.948 3.3169C21.98 3.2179 21.995 3.1179 21.996 3.0179C21.997 2.9939 21.991 2.9719 21.99 2.9479Z"
          fill="#FFFFFF"
        />
        <Mask
          id="mask0"
          mask-type="alpha"
          maskUnits="userSpaceOnUse"
          x="2"
          y="2"
          width="20"
          height="20"
        >
          <Path
            id="Mask_2"
            fillRule="evenodd"
            clipRule="evenodd"
            d="M15 17.8379L13.144 12.2709L18.712 6.7019L15 17.8379ZM17.298 5.2879L11.73 10.8559L6.162 8.9999L17.298 5.2879ZM21.99 2.9479C21.985 2.8549 21.968 2.7649 21.937 2.6779C21.927 2.6469 21.916 2.6169 21.902 2.5869C21.854 2.4799 21.793 2.3789 21.707 2.2929C21.621 2.2069 21.52 2.1459 21.412 2.0979C21.383 2.0839 21.354 2.0729 21.323 2.0629C21.234 2.0319 21.143 2.0139 21.048 2.0089C21.026 2.0079 21.006 2.0029 20.983 2.0029C20.883 2.0049 20.782 2.0189 20.684 2.0509L2.684 8.0509C2.275 8.1879 2 8.5689 2 8.9999C2 9.4309 2.275 9.8129 2.684 9.9489L11.209 12.7909L14.052 21.3169C14.188 21.7249 14.569 21.9999 15 21.9999C15.431 21.9999 15.812 21.7249 15.948 21.3169L21.948 3.3169C21.98 3.2179 21.995 3.1179 21.996 3.0179C21.997 2.9939 21.991 2.9719 21.99 2.9479Z"
            fill="#FFFFFF"
          />
        </Mask>
        <G mask="url(#mask0)">
          <G>
            <Rect id="Base" width="24" height="24" fill="#FFFFFF" />
          </G>
        </G>
      </G>
    ),
    viewBox: '0 0 24 24',
  },
  Arrow: {
    svg: (
      <Path
        d="M24 10.1765C24 9.62418 23.5523 9.17647 23 9.17647H5.79765L11.878 2.65449C12.2454 2.2605 12.2346 1.64636 11.8537 1.26547L11.2953 0.707107C10.9048 0.316583 10.2717 0.316582 9.88113 0.707107L0.707107 9.88113C0.316582 10.2717 0.316583 10.9048 0.707107 11.2953L9.88113 20.4694C10.2717 20.8599 10.9048 20.8599 11.2953 20.4694L11.8537 19.911C12.2346 19.5301 12.2454 18.916 11.878 18.522L5.79765 12H23C23.5523 12 24 11.5523 24 11V10.1765Z"
        fill="#777777"
      />
    ),
    viewBox: '0 0 24 22',
  },
  ThreeDots: {
    svg: (
      <Path
        d="M10 2H14V6H10V2ZM10 10H14V14H10V10ZM10 18H14V22H10V18Z"
        fill="#777777"
      />
    ),
    viewBox: '0 0 24 24',
  },
  TrashCan: {
    svg: (
      <Path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M15.6667 0L17 1.33333H21.6667V4H3V1.33333H7.66667L9 0H15.6667ZM12.3333 12.7867L15.1599 9.96L17.0399 11.84L14.2133 14.6667L17.0399 17.4933L15.1599 19.3733L12.3333 16.5467L9.50661 19.3733L7.62661 17.4933L10.4533 14.6667L7.61328 11.84L9.49328 9.96L12.3333 12.7867ZM4.33333 21.3333C4.33333 22.8 5.53333 24 7 24H17.6667C19.1333 24 20.3333 22.8 20.3333 21.3333V5.33333H4.33333V21.3333ZM17.6667 8H7V21.3333H17.6667V8Z"
        fill="#236BAE"
      />
    ),
    viewBox: '0 0 24 24',
  },
  CloseIcon: {
    svg: (
      <Path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M9.88567 8.00033L15.6097 2.27633C16.131 1.755 16.131 0.912333 15.6097 0.391C15.0883 -0.130333 14.2457 -0.130333 13.7243 0.391L8.00033 6.115L2.27633 0.391C1.755 -0.130333 0.912333 -0.130333 0.391 0.391C-0.130333 0.912333 -0.130333 1.755 0.391 2.27633L6.115 8.00033L0.391 13.7243C-0.130333 14.2457 -0.130333 15.0883 0.391 15.6097C0.651 15.8697 0.992333 16.0003 1.33367 16.0003C1.675 16.0003 2.01633 15.8697 2.27633 15.6097L8.00033 9.88567L13.7243 15.6097C13.9843 15.8697 14.3257 16.0003 14.667 16.0003C15.0083 16.0003 15.3497 15.8697 15.6097 15.6097C16.131 15.0883 16.131 14.2457 15.6097 13.7243L9.88567 8.00033Z"
        fill="#777777"
      />
    ),
    viewBox: '0 0 16 16',
  },
  Cloud: {
    svg: (
      <Path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M7.12338 10.7202C8.78935 7.52016 12.148 5.3335 15.9997 5.3335C20.851 5.3335 24.8893 8.78683 25.8089 13.3868C29.2608 13.6268 31.993 16.4802 31.993 20.0002C31.993 23.6802 29.0076 26.6668 25.3291 26.6668H8.00302C3.59152 26.6668 0.00634766 23.0802 0.00634766 18.6668C0.00634766 14.5468 3.12505 11.1468 7.12338 10.7202ZM23.1967 13.9068C22.517 10.4802 19.4782 8.00016 15.9997 8.00016C13.2542 8.00016 10.7619 9.52016 9.50906 11.9602L8.84267 13.2268L7.41659 13.3735C4.71105 13.6535 2.6719 15.9335 2.6719 18.6668C2.6719 21.6135 5.05758 24.0002 8.00302 24.0002H25.3291C27.5282 24.0002 29.3275 22.2002 29.3275 20.0002C29.3275 17.9335 27.7015 16.2002 25.6223 16.0535L23.5965 15.9068L23.1967 13.9068Z"
        fill="#777777"
      />
    ),
    viewBox: '0 0 26 26',
  },
  BurgerMenu: {
    svg: (
      <Path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M5.264 8H26.7347C27.4307 8 28 8.56933 28 9.26533V9.40133C28 10.0973 27.4307 10.6667 26.7347 10.6667H5.264C4.568 10.6667 4 10.0973 4 9.40133V9.26533C4 8.56933 4.568 8 5.264 8ZM26.7347 14.6667H5.264C4.568 14.6667 4 15.236 4 15.932V16.068C4 16.764 4.568 17.3333 5.264 17.3333H26.7347C27.4307 17.3333 28 16.764 28 16.068V15.932C28 15.236 27.4307 14.6667 26.7347 14.6667ZM26.7347 21.3333H5.264C4.568 21.3333 4 21.9027 4 22.5987V22.7347C4 23.4307 4.568 24 5.264 24H26.7347C27.4307 24 28 23.4307 28 22.7347V22.5987C28 21.9027 27.4307 21.3333 26.7347 21.3333Z"
        fill="#777777"
      />
    ),
    viewBox: '0 0 32 32',
  },
  Home: {
    svg: (
      <Path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M18.9902 20H16.0002V13C16.0002 12.447 15.5522 12 15.0002 12H9.00024C8.44724 12 8.00024 12.447 8.00024 13V20H5.00024L5.00624 11.583L11.9982 4.43199L19.0002 11.624L18.9902 20ZM10.0002 20H14.0002V14H10.0002V20ZM20.4242 10.185L12.7152 2.30099C12.3382 1.91599 11.6622 1.91599 11.2852 2.30099L3.57524 10.186C3.21024 10.561 3.00024 11.085 3.00024 11.624V20C3.00024 21.103 3.84724 22 4.88824 22H9.00024H15.0002H19.1112C20.1522 22 21.0002 21.103 21.0002 20V11.624C21.0002 11.085 20.7902 10.561 20.4242 10.185Z"
        fill="#777777"
      />
    ),
    viewBox: '0 0 24 24',
  },
  Camera: {
    svg: (
      <Path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M16.83 5H20C21.1 5 22 5.9 22 7V19C22 20.1 21.1 21 20 21H4C2.9 21 2 20.1 2 19V7C2 5.9 2.9 5 4 5H7.17L9 3H15L16.83 5ZM4 19H20V7H15.95L14.12 5H9.88L8.05 7H4V19ZM12 8C9.24 8 7 10.24 7 13C7 15.76 9.24 18 12 18C14.76 18 17 15.76 17 13C17 10.24 14.76 8 12 8ZM9 13C9 14.65 10.35 16 12 16C13.65 16 15 14.65 15 13C15 11.35 13.65 10 12 10C10.35 10 9 11.35 9 13Z"
        fill="#777777"
      />
    ),
    viewBox: '0 0 24 24',
  },
  Image: {
    svg: (
      <G>
        <G>
          <Path
            id="Mask"
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8 10C8.828 10 9.5 9.328 9.5 8.5C9.5 7.672 8.828 7 8 7C7.172 7 6.5 7.672 6.5 8.5C6.5 9.328 7.172 10 8 10ZM18 19H6.561L13.566 13.155C13.812 12.946 14.258 12.947 14.499 13.154L19 16.994V18C19 18.552 18.552 19 18 19ZM6 5H18C18.552 5 19 5.448 19 6V14.364L15.797 11.632C14.807 10.79 13.258 10.79 12.277 11.626L5 17.698V6C5 5.448 5.448 5 6 5ZM18 3H6C4.346 3 3 4.346 3 6V18C3 19.654 4.346 21 6 21H18C19.654 21 21 19.654 21 18V6C21 4.346 19.654 3 18 3Z"
            fill="#231F20"
          />
          <Mask
            id="mask0"
            mask-type="alpha"
            maskUnits="userSpaceOnUse"
            x="3"
            y="3"
            width="24"
            height="24"
          >
            <Path
              id="Mask_2"
              fillRule="evenodd"
              clipRule="evenodd"
              d="M8 10C8.828 10 9.5 9.328 9.5 8.5C9.5 7.672 8.828 7 8 7C7.172 7 6.5 7.672 6.5 8.5C6.5 9.328 7.172 10 8 10ZM18 19H6.561L13.566 13.155C13.812 12.946 14.258 12.947 14.499 13.154L19 16.994V18C19 18.552 18.552 19 18 19ZM6 5H18C18.552 5 19 5.448 19 6V14.364L15.797 11.632C14.807 10.79 13.258 10.79 12.277 11.626L5 17.698V6C5 5.448 5.448 5 6 5ZM18 3H6C4.346 3 3 4.346 3 6V18C3 19.654 4.346 21 6 21H18C19.654 21 21 19.654 21 18V6C21 4.346 19.654 3 18 3Z"
              fill="white"
            />
          </Mask>
          <G mask="url(#mask0)">
            <G id="&#240;&#159;&#142;&#168; Color_2">
              <Rect id="Base" width="24" height="24" fill="#0D1C2E" />
            </G>
          </G>
        </G>
      </G>
    ),
    viewBox: '0 0 24 24',
  },
  Attachment: {
    svg: (
      <G>
        <Path
          id="Mask"
          fillRule="evenodd"
          clipRule="evenodd"
          d="M12 22C8.691 22 6 19.443 6 16.302V6.132C6 3.854 7.944 2 10.333 2C12.723 2 14.667 3.854 14.667 6.132L14.661 16.309C14.661 17.723 13.464 18.874 11.994 18.874C10.524 18.874 9.328 17.723 9.328 16.308L9.333 6.917C9.334 6.365 9.782 5.918 10.333 5.918H10.334C10.886 5.918 11.334 6.366 11.333 6.919L11.328 16.309C11.328 16.62 11.626 16.874 11.994 16.874C12.362 16.874 12.661 16.62 12.661 16.308L12.667 6.131C12.667 4.956 11.62 4 10.333 4C9.047 4 8 4.956 8 6.132V16.302C8 18.341 9.794 20 12 20C14.206 20 16 18.341 16 16.302V6.132C16 5.579 16.448 5.132 17 5.132C17.552 5.132 18 5.579 18 6.132V16.302C18 19.443 15.309 22 12 22Z"
          fill="#231F20"
        />
        <Mask
          id="mask0"
          mask-type="alpha"
          maskUnits="userSpaceOnUse"
          x="6"
          y="2"
          width="12"
          height="20"
        >
          <Path
            id="Mask_2"
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12 22C8.691 22 6 19.443 6 16.302V6.132C6 3.854 7.944 2 10.333 2C12.723 2 14.667 3.854 14.667 6.132L14.661 16.309C14.661 17.723 13.464 18.874 11.994 18.874C10.524 18.874 9.328 17.723 9.328 16.308L9.333 6.917C9.334 6.365 9.782 5.918 10.333 5.918H10.334C10.886 5.918 11.334 6.366 11.333 6.919L11.328 16.309C11.328 16.62 11.626 16.874 11.994 16.874C12.362 16.874 12.661 16.62 12.661 16.308L12.667 6.131C12.667 4.956 11.62 4 10.333 4C9.047 4 8 4.956 8 6.132V16.302C8 18.341 9.794 20 12 20C14.206 20 16 18.341 16 16.302V6.132C16 5.579 16.448 5.132 17 5.132C17.552 5.132 18 5.579 18 6.132V16.302C18 19.443 15.309 22 12 22Z"
            fill="white"
          />
        </Mask>
        <G mask="url(#mask0)">
          <G>
            <Rect id="Base" width="24" height="24" fill="#0D1C2E" />
          </G>
        </G>
      </G>
    ),
    viewBox: '0 0 24 24',
  },
  Download: {
    svg: (
      <G>
        <Path
          d="M11.0028 12.0759C11.001 12.0508 11 12.0255 11 12V4C11 3.448 11.447 3 12 3C12.553 3 13 3.448 13 4V11.9998L15.4 10.2C15.842 9.867 16.469 9.958 16.8 10.4C17.132 10.842 17.042 11.469 16.6 11.8L12.6 14.8C12.423 14.933 12.211 15 12 15C11.799 15 11.598 14.939 11.425 14.818L7.425 12.004C6.973 11.686 6.864 11.062 7.182 10.611C7.5 10.159 8.123 10.05 8.575 10.368L11.0028 12.0759ZM6 17V18H18V17C18 16.45 18.45 16 19 16C19.55 16 20 16.45 20 17V19C20 19.55 19.55 20 19 20H5C4.45 20 4 19.55 4 19V17C4 16.45 4.45 16 5 16C5.55 16 6 16.45 6 17Z"
          fill="#FFFFFF"
        />
        <Mask
          id="mask0"
          mask-type="alpha"
          maskUnits="userSpaceOnUse"
          x="4"
          y="3"
          width="16"
          height="17"
        >
          <Path
            d="M11.0028 12.0759C11.001 12.0508 11 12.0255 11 12V4C11 3.448 11.447 3 12 3C12.553 3 13 3.448 13 4V11.9998L15.4 10.2C15.842 9.867 16.469 9.958 16.8 10.4C17.132 10.842 17.042 11.469 16.6 11.8L12.6 14.8C12.423 14.933 12.211 15 12 15C11.799 15 11.598 14.939 11.425 14.818L7.425 12.004C6.973 11.686 6.864 11.062 7.182 10.611C7.5 10.159 8.123 10.05 8.575 10.368L11.0028 12.0759ZM6 17V18H18V17C18 16.45 18.45 16 19 16C19.55 16 20 16.45 20 17V19C20 19.55 19.55 20 19 20H5C4.45 20 4 19.55 4 19V17C4 16.45 4.45 16 5 16C5.55 16 6 16.45 6 17Z"
            fill="#FFFFFF"
          />
        </Mask>
        <G mask="url(#mask0)">
          <G>
            <Rect id="Base" width="24" height="24" fill="#FFFFFF" />
          </G>
        </G>
      </G>
    ),
    viewBox: '0 0 24 24',
  },
  DocumentVerification: {
    svg: (
      <G>
        <Path fill-rule="evenodd" clip-rule="evenodd" d="M10 5C11.103 5 12 5.897 12 7C12 8.103 11.103 9 10 9C8.897 9 8 8.103 8 7C8 5.897 8.897 5 10 5ZM10 11C12.206 11 14 9.206 14 7C14 4.794 12.206 3 10 3C7.794 3 6 4.794 6 7C6 9.206 7.794 11 10 11ZM21.6562 4.2456C21.2392 3.8836 20.6082 3.9266 20.2452 4.3436L18.3792 6.4886L17.7452 5.7796C17.3782 5.3676 16.7462 5.3326 16.3332 5.7016C15.9222 6.0696 15.8862 6.7026 16.2552 7.1136L17.6442 8.6666C17.8342 8.8786 18.1052 8.9996 18.3892 8.9996H18.3962C18.6832 8.9976 18.9562 8.8726 19.1442 8.6566L21.7552 5.6566C22.1172 5.2396 22.0732 4.6076 21.6562 4.2456ZM3 20C3 16.14 6.141 13 10 13C13.859 13 17 16.14 17 20C17 20.552 16.553 21 16 21C15.447 21 15 20.552 15 20C15 17.243 12.757 15 10 15C7.243 15 5 17.243 5 20C5 20.552 4.553 21 4 21C3.447 21 3 20.552 3 20Z" fill="#777777"/>
        <Mask id="mask0" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="3" y="3" width="20" height="18">
          <Path fill-rule="evenodd" clip-rule="evenodd" d="M10 5C11.103 5 12 5.897 12 7C12 8.103 11.103 9 10 9C8.897 9 8 8.103 8 7C8 5.897 8.897 5 10 5ZM10 11C12.206 11 14 9.206 14 7C14 4.794 12.206 3 10 3C7.794 3 6 4.794 6 7C6 9.206 7.794 11 10 11ZM21.6562 4.2456C21.2392 3.8836 20.6082 3.9266 20.2452 4.3436L18.3792 6.4886L17.7452 5.7796C17.3782 5.3676 16.7462 5.3326 16.3332 5.7016C15.9222 6.0696 15.8862 6.7026 16.2552 7.1136L17.6442 8.6666C17.8342 8.8786 18.1052 8.9996 18.3892 8.9996H18.3962C18.6832 8.9976 18.9562 8.8726 19.1442 8.6566L21.7552 5.6566C22.1172 5.2396 22.0732 4.6076 21.6562 4.2456ZM3 20C3 16.14 6.141 13 10 13C13.859 13 17 16.14 17 20C17 20.552 16.553 21 16 21C15.447 21 15 20.552 15 20C15 17.243 12.757 15 10 15C7.243 15 5 17.243 5 20C5 20.552 4.553 21 4 21C3.447 21 3 20.552 3 20Z" fill="white"/>
        </Mask>
        <G mask="url(#mask0)">
          <Rect width="24" height="24" fill="#777777"/>
        </G>
      </G>
    ),
    viewBox: '0 0 24 24',
  },
}

export const SvgCustomIcon = (props: {
  name: string,
  fill?: string,
  height?: number,
  width?: number,
}) => {
  const { height = '24', width } = props
  return <SvgIcon {...props} height={height} width={width} svgs={svgIcons} />
}

export default SvgCustomIcon
