// @flow

declare module 'react-native-device-info' {
  declare type DeviceType = 'Handset' | 'Tablet' | 'Tv' | 'unknown'

  declare type BatteryState = 'unknown' | 'unplugged' | 'charging' | 'full'

  declare type PowerState = {
    batteryLevel: number,
    batteryState: BatteryState,
    lowPowerMode: boolean,
    [key: string]: any,
  }

  declare type LocationProviderInfo = {
    [key: string]: boolean,
  }

  declare type AsyncHookResult<T> = {
    loading: boolean,
    result: T | -1 | false | 'unknown',
  }

  declare module.exports: {
    getUniqueId: () => string,
    getManufacturer: () => Promise<string>,
    getManufacturerSync: () => string,
    getBrand: () => string,
    getModel: () => string,
    getDeviceId: () => string,
    getSystemName: () => string,
    getSystemVersion: () => string,
    getBuildId: () => Promise<string>,
    getBuildIdSync: () => string,
    getBundleId: () => string,
    getApplicationName: () => string,
    getBuildNumber: () => string,
    getVersion: () => string,
    getReadableVersion: () => string,
    getDeviceName: () => Promise<string>,
    getDeviceNameSync: () => string,
    getUsedMemory: () => Promise<number>,
    getUsedMemorySync: () => number,
    getUserAgent: () => Promise<string>,
    getUserAgentSync: () => string,
    getInstanceId: () => Promise<string>,
    getInstanceIdSync: () => string,
    getInstallReferrer: () => Promise<string>,
    getInstallReferrerSync: () => string,
    isEmulator: () => Promise<boolean>,
    isEmulatorSync: () => boolean,
    isTablet: () => boolean,
    getFontScale: () => Promise<number>,
    getFontScaleSync: () => number,
    getBootloader: () => Promise<string>,
    getBootloaderSync: () => string,
    getDevice: () => Promise<string>,
    getDeviceSync: () => string,
    getDisplay: () => Promise<string>,
    getDisplaySync: () => string,
    getFingerprint: () => Promise<string>,
    getFingerprintSync: () => string,
    getHardware: () => Promise<string>,
    getHardwareSync: () => string,
    getHost: () => Promise<string>,
    getHostSync: () => string,
    getProduct: () => Promise<string>,
    getProductSync: () => string,
    getTags: () => Promise<string>,
    getTagsSync: () => string,
    getType: () => Promise<string>,
    getTypeSync: () => string,
    getBaseOs: () => Promise<string>,
    getBaseOsSync: () => string,
    getPreviewSdkInt: () => Promise<number>,
    getPreviewSdkIntSync: () => number,
    getSecurityPatch: () => Promise<string>,
    getSecurityPatchSync: () => string,
    getCodename: () => Promise<string>,
    getCodenameSync: () => string,
    getIncremental: () => Promise<string>,
    getIncrementalSync: () => string,
    isPinOrFingerprintSet: () => Promise<boolean>,
    isPinOrFingerprintSetSync: () => boolean,
    hasNotch: () => boolean,
    hasNotchSync: () => boolean,
    getFirstInstallTime: () => Promise<number>,
    getFirstInstallTimeSync: () => number,
    getLastUpdateTime: () => Promise<number>,
    getLastUpdateTimeSync: () => number,
    getSerialNumber: () => Promise<string>,
    getSerialNumberSync: () => string,
    getAndroidId: () => Promise<string>,
    getAndroidIdSync: () => string,
    getApiLevel: () => Promise<number>,
    getApiLevelSync: () => number,
    getIpAddress: () => Promise<string>,
    getIpAddressSync: () => string,
    isCameraPresent: () => Promise<boolean>,
    isCameraPresentSync: () => boolean,
    getMacAddress: () => Promise<string>,
    getMacAddressSync: () => string,
    getPhoneNumber: () => Promise<?string>,
    getPhoneNumberSync: () => ?string,
    getCarrier: () => Promise<string>,
    getCarrierSync: () => string,
    getTotalMemory: () => Promise<number>,
    getTotalMemorySync: () => number,
    getMaxMemory: () => Promise<number>,
    getMaxMemorySync: () => number,
    getTotalDiskCapacity: () => Promise<number>,
    getTotalDiskCapacitySync: () => number,
    getFreeDiskStorage: () => Promise<number>,
    getFreeDiskStorageSync: () => number,
    getBatteryLevel: () => Promise<number>,
    getBatteryLevelSync: () => number,
    getPowerState: () => Promise<PowerState>,
    getPowerStateSync: () => PowerState,
    isBatteryCharging: () => Promise<boolean>,
    isBatteryChargingSync: () => boolean,
    isLandscape: () => Promise<boolean>,
    isLandscapeSync: () => boolean,
    isAirplaneMode: () => Promise<boolean>,
    isAirplaneModeSync: () => boolean,
    getDeviceType: () => DeviceType,
    supportedAbis: () => Promise<Array<string>>,
    supportedAbisSync: () => Array<string>,
    supported32BitAbis: () => Promise<Array<string>>,
    supported32BitAbisSync: () => Array<string>,
    supported64BitAbis: () => Promise<Array<string>>,
    supported64BitAbisSync: () => Array<string>,
    hasSystemFeature: (feature: string) => Promise<boolean>,
    hasSystemFeatureSync: (feature: string) => boolean,
    getSystemAvailableFeatures: () => Promise<Array<string>>,
    getSystemAvailableFeaturesSync: () => Array<string>,
    isLocationEnabled: () => Promise<boolean>,
    isLocationEnabledSync: () => boolean,
    isHeadphonesConnected: () => Promise<boolean>,
    isHeadphonesConnectedSync: () => boolean,
    getAvailableLocationProviders: () => Promise<Object>,
    getAvailableLocationProvidersSync: () => Object,
    useBatteryLevel: () => number | null,
    useBatteryLevelIsLow: () => number | null,
    usePowerState: () => PowerState | {},
    useFirstInstallTime: () => AsyncHookResult<number>,
    useDeviceName: () => AsyncHookResult<string>,
    useHasSystemFeature: (feature: string) => AsyncHookResult<boolean>,
    useIsEmulator: () => AsyncHookResult<boolean>,
  }
}
