/**
 * Copyright (c) 2016 DeepCortex GmbH <legal@eventql.io>
 * Authors:
 *   - Paul Asmuth <paul@eventql.io>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License ("the license") as
 * published by the Free Software Foundation, either version 3 of the License,
 * or any later version.
 *
 * In accordance with Section 7(e) of the license, the licensing of the Program
 * under the license does not imply a trademark license. Therefore any rights,
 * title and interest in our trademarks remain entirely with us.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the license for more details.
 *
 * You can be released from the requirements of the license by purchasing a
 * commercial license. Buying such a license is mandatory as soon as you develop
 * commercial activities involving this program without disclosing the source
 * code of your own applications
 */
#ifndef _STX_BASE_BUFFERUTIL_H_
#define _STX_BASE_BUFFERUTIL_H_

#include <stdlib.h>
#include <stdint.h>
#include "eventql/util/buffer.h"

class BufferUtil {
public:

  /**
   * Remove trailing bytes from the pointed to buffer
   *
   * @param str the string to remove trailing slashes from
   */
  static void stripTrailingBytes(Buffer* buf, unsigned char byte);

  /**
   * Remove trailing slashes from the pointed to buffer
   *
   * @param str the string to remove trailing slashes from
   */
  static void stripTrailingSlashes(Buffer* buf);

  /**
   * Print the contents of the pointed to memory as a series of hexadecimal
   * bytes (hexdump):
   *
   * Example:
   *   StringUtil::hexPrint("\x17\x23\x42\x01", 4);
   *   // returns "17 23 42 01"
   *
   * @param data the data to print
   * @param size the size of the data in bytes
   * @param separate_bytes if true, insert a whitespace character between bytes
   * @param reverse_byte_order if true, print the data from last to first byte
   * @return the data formatted as a human readable hex string
   */
  static std::string hexPrint(
      Buffer* buf,
      bool separate_bytes = true,
      bool reverse_byte_order = false);

};

#endif
