/**
 * Copyright (c) 2016 DeepCortex GmbH <legal@eventql.io>
 * Authors:
 *   - Paul Asmuth <paul@eventql.io>
 *   - Laura Schlimmer <laura@eventql.io>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License ("the license") as
 * published by the Free Software Foundation, either version 3 of the License,
 * or any later version.
 *
 * In accordance with Section 7(e) of the license, the licensing of the Program
 * under the license does not imply a trademark license. Therefore any rights,
 * title and interest in our trademarks remain entirely with us.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the license for more details.
 *
 * You can be released from the requirements of the license by purchasing a
 * commercial license. Buying such a license is mandatory as soon as you develop
 * commercial activities involving this program without disclosing the source
 * code of your own applications
 */
#pragma once
#include "eventql/eventql.h"
#include "eventql/sql/svalue.h"
#include <eventql/sql/table_expression.h>
#include <eventql/auth/internal_auth.h>
#include <eventql/db/partition_map.h>
#include <eventql/sql/transaction.h>
#include <eventql/sql/scheduler/execution_context.h>
#include <eventql/sql/qtree/SequentialScanNode.h>

namespace eventql {

struct ReplicaRef {
  ReplicaRef(
      SHA1Hash _unique_id,
      String _addr);

  SHA1Hash unique_id;
  String addr;
  String name;
  bool is_local;
};

class TableScan : public csql::TableExpression {
public:

  struct PartitionLocation {
    SHA1Hash partition_id;
    Vector<ReplicaRef> servers;
    Option<SHA1Hash> cache_key;
    RefPtr<csql::SequentialScanNode> qtree;
  };

  TableScan(
    csql::Transaction* txn,
    csql::ExecutionContext* execution_context,
    const String& tsdb_namespace,
    const String& table_name,
    const Vector<PartitionLocation>& partitions,
    RefPtr<csql::SequentialScanNode> seqscan,
    Option<SHA1Hash> cache_key,
    PartitionMap* partition_map,
    InternalAuth* auth);

  virtual ReturnCode execute() override;

  size_t getColumnCount() const override;
  csql::SType getColumnType(size_t idx) const override;

  ReturnCode nextBatch(csql::SVector* columns, size_t* len) override;

  Option<SHA1Hash> getCacheKey() const override;

protected:

  ScopedPtr<csql::TableExpression> openPartition(
      const PartitionLocation& partition);

  ScopedPtr<csql::TableExpression> openLocalPartition(
      const SHA1Hash& partition_id,
      RefPtr<csql::SequentialScanNode> qtree);

  ScopedPtr<csql::TableExpression> openRemotePartition(
      const SHA1Hash& partition_id,
      RefPtr<csql::SequentialScanNode> qtree,
      const Vector<ReplicaRef> servers);

  csql::Transaction* txn_;
  csql::ExecutionContext* execution_context_;
  csql::ExecutionContext child_execution_context_;
  String tsdb_namespace_;
  String table_name_;
  Vector<PartitionLocation> partitions_;
  RefPtr<csql::SequentialScanNode> seqscan_;
  Option<SHA1Hash> cache_key_;
  PartitionMap* partition_map_;
  InternalAuth* auth_;
  ScopedPtr<csql::TableExpression> cur_cursor_;
  size_t cur_partition_;
};

}
