/*
 * Wolfenstein: Enemy Territory GPL Source Code
 * Copyright (C) 1999-2010 id Software LLC, a ZeniMax Media company.
 *
 * ET: Legacy
 * Copyright (C) 2012-2018 ET:Legacy team <mail@etlegacy.com>
 *
 * This file is part of ET: Legacy - http://www.etlegacy.com
 *
 * ET: Legacy is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ET: Legacy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ET: Legacy. If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, Wolfenstein: Enemy Territory GPL Source Code is also
 * subject to certain additional terms. You should have received a copy
 * of these additional terms immediately following the terms and conditions
 * of the GNU General Public License which accompanied the source code.
 * If not, please request a copy in writing from id Software at the address below.
 *
 * id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.
 */
/**
 * @file sdl_splash.h
 * @brief GIMP RGBA C-Source image dump 1-byte-run-length-encoded (sdl_splash.h)
 */

#ifndef INCLUDE_SDL_SPLASH_H
#define INCLUDE_SDL_SPLASH_H

#define SPLASH_IMAGE_RUN_LENGTH_DECODE(image_buf, rle_data, size, bpp) do \
{ unsigned int __bpp; unsigned char *__ip; const unsigned char *__il, *__rd; \
  __bpp = (bpp); __ip = (image_buf); __il = __ip + (size) * __bpp; \
  __rd = (rle_data); if (__bpp > 3) { /* RGBA */ \
    while (__ip < __il) { unsigned int __l = *(__rd++); \
      if (__l & 128) { __l = __l - 128; \
        do { memcpy (__ip, __rd, 4); __ip += 4; } while (--__l); __rd += 4; \
      } else { __l *= 4; memcpy (__ip, __rd, __l); \
               __ip += __l; __rd += __l; } } \
  } else if (__bpp == 3) { /* RGB */ \
    while (__ip < __il) { unsigned int __l = *(__rd++); \
      if (__l & 128) { __l = __l - 128; \
        do { memcpy (__ip, __rd, 3); __ip += 3; } while (--__l); __rd += 3; \
      } else { __l *= 3; memcpy (__ip, __rd, __l); \
               __ip += __l; __rd += __l; } } \
  } else { /* RGB16 */ \
    while (__ip < __il) { unsigned int __l = *(__rd++); \
      if (__l & 128) { __l = __l - 128; \
        do { memcpy (__ip, __rd, 2); __ip += 2; } while (--__l); __rd += 2; \
      } else { __l *= 2; memcpy (__ip, __rd, __l); \
               __ip += __l; __rd += __l; } } \
  } } while (0)

static const struct
{
	unsigned int  width;
	unsigned int  height;
	unsigned int  bytes_per_pixel; /* 2:RGB16, 3:RGB, 4:RGBA */
	unsigned char rle_pixel_data[47439 + 1];
} CLIENT_WINDOW_SPLASH = {
		300, 120, 4,
		"\310\000\000\000\377\010\000\004\000\377\000\005\000\377\006\000\000\377\000\000\002\377\000\003\000\377\002\001\000"
		"\377\000\001\004\377\004\000\000\377\377\000\000\000\377\377\000\000\000\377\246\000\000\000\377\010\010"
		"\000\002\377\000\000\000\377\010\000\015\377\006\000\017\377\000\003\002\377\000\001\002\377\003\000\007\377\000"
		"\001\000\377\377\000\000\000\377\377\000\000\000\377\246\000\000\000\377\004\004\000\000\377\000\003\000\377"
		"\000\004\000\377\000\001\000\377\202\010\000\000\377\002\004\000\006\377\000\002\005\377\377\000\000\000\377\377"
		"\000\000\000\377\246\000\000\000\377\010\000\001\000\377\000\004\000\377\000\000\002\377\000\000\005\377\001\000\006"
		"\377\004\000\005\377\000\000\004\377\000\001\000\377\377\000\000\000\377\377\000\000\000\377\246\000\000\000"
		"\377\010\010\000\014\377\000\004\005\377\004\000\000\377\000\003\000\377\000\004\000\377\010\000\002\377\003"
		"\000\000\377\001\001\000\377\377\000\000\000\377\377\000\000\000\377\246\000\000\000\377\010\004\000\002\377"
		"\006\001\007\377\007\000\000\377\000\001\000\377\002\000\003\377\004\000\006\377\000\004\004\377\000\003\012\377\377"
		"\000\000\000\377\377\000\000\000\377\246\000\000\000\377\010\000\003\000\377\005\003\010\377\000\002\004\377"
		"\002\003\000\377\000\002\000\377\000\004\000\377\011\000\000\377\001\000\007\377\377\000\000\000\377\377\000\000"
		"\000\377\246\000\000\000\377\010\000\003\000\377\000\002\000\377@\007\000\377\333\033\020\377\360\032"
		"\000\377\344\035\000\377\305\027\016\377\026\003\000\377\377\000\000\000\377\335\000\000\000\377"
		"\001\004\000\002\377\202\003\000\002\377\202\001\000\002\377\203\000\000\002\377\300\000\000\000\377\010\000"
		"\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033"
		"\002\377\024\002\000\377\377\000\000\000\377\335\000\000\000\377\001\000\002\000\377\203\000\001\000\377\202"
		"\000\000\002\377\202\001\000\005\377\300\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375"
		"\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\377\000\000\000\377"
		"\335\000\000\000\377\202\003\000\000\377\202\001\000\000\377\202\000\001\000\377\202\000\002\000\377\300"
		"\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377"
		"\035\000\377\335\033\002\377\024\002\000\377\377\000\000\000\377\335\000\000\000\377\203\000\002\005\377"
		"\202\000\000\004\377\003\001\000\002\377\003\000\002\377\004\000\002\377\202\000\000\000\377\202\001\001\001\377"
		"\274\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377"
		"\377\035\000\377\335\033\002\377\024\002\000\377\377\000\000\000\377\335\000\000\000\377\203\000\002"
		"\000\377\005\000\001\000\377\000\000\002\377\000\000\004\377\000\000\005\377\000\000\007\377\202\000\000\000\377"
		"\203\001\001\001\377\273\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377"
		"\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\377\000\000\000\377\335\000\000"
		"\000\377\202\005\000\005\377\202\005\000\003\377\001\004\000\001\377\202\004\000\000\377\001\003\000\000\377"
		"\203\000\000\000\377\202\001\001\001\377\273\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377"
		"\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\377\000\000\000"
		"\377\335\000\000\000\377\005\004\000\000\377\003\000\000\377\001\000\000\377\000\000\000\377\000\001\000\377\202"
		"\000\002\000\377\003\000\003\000\377\002\002\002\377\001\001\001\377\276\000\000\000\377\010\000\001\000\377\001\000"
		"\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002"
		"\000\377\377\000\000\000\377\335\000\000\000\377\012\231\024\001\377\221\024\002\377\177\021\000"
		"\377g\016\000\377P\012\002\377\071\007\000\377)\003\000\377\037\001\000\377\004\004\004\377\002\002\002\377"
		"\276\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377"
		"\377\035\000\377\335\033\002\377\024\002\000\377\377\000\000\000\377\335\000\000\000\377\024\360"
		"\035\000\377\377\037\003\377\377\034\000\377\376\035\000\377\375\040\003\377\374\034\002\377"
		"\367\032\000\377\357\031\000\377\322\030\000\377\307\027\000\377\264\025\000\377\232\023"
		"\000\377\200\022\001\377e\017\002\377O\013\000\377B\010\000\377,\006\003\377\035\001\000\377\020"
		"\000\003\377\006\002\003\377\202\001\000\000\377\202\000\003\004\377\010\000\002\000\377\002\001\000\377\000\002"
		"\000\377\000\003\002\377\000\001\000\377\000\011\000\377\007\000\000\377\003\000\014\377\250\000\000\000\377"
		"\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335"
		"\033\002\377\024\002\000\377\377\000\000\000\377\335\000\000\000\377\011\354\031\000\377\375\035\001"
		"\377\377\034\000\377\376\035\000\377\375\040\003\377\376\036\004\377\375\035\001\377\370"
		"\037\000\377\377\034\002\377\202\377\033\001\377\025\377\034\002\377\377\036\003\377\377"
		"\037\003\377\377\036\002\377\376\035\001\377\362\034\000\377\353\031\000\377\331\034\000\377"
		"\300\033\000\377\262\027\001\377\240\023\012\377k\014\010\377+\002\000\377\010\000\003\377\000"
		"\000\014\377\000\001\012\377\007\000\005\377\015\000\017\377\000\000\005\377\001\000\000\377\003\003\003\377"
		"\250\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377"
		"\377\035\000\377\335\033\002\377\024\002\000\377\377\000\000\000\377\335\000\000\000\377\016\352"
		"\032\000\377\374\037\002\377\377\035\000\377\376\035\000\377\376\036\002\377\376\034\003\377"
		"\377\036\002\377\374!\001\377\372!\002\377\373\040\002\377\373\037\000\377\375\036\000\377"
		"\376\035\000\377\377\036\000\377\202\377\034\000\377\020\377\040\001\377\375\036\000\377"
		"\372\036\000\377\372\037\000\377\377\034\000\377\377\035\000\377\376\037\000\377\352\036"
		"\000\377s\014\000\377\005\000\000\377\000\001\000\377\001\001\000\377\000\000\014\377\000\003\013\377\001\002"
		"\000\377\000\002\000\377\250\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377"
		"\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\377\000\000\000\377\335\000\000"
		"\000\377\011\351\034\000\377\374!\005\377\377\037\000\377\376\035\000\377\376\036\002\377"
		"\377\034\003\377\377\035\002\377\374\040\000\377\377\040\000\377\202\377\036\000\377\025"
		"\375\035\001\377\375\035\003\377\376\036\005\377\374\036\007\377\375\037\010\377\377\036"
		"\000\377\377\034\000\377\377\037\007\377\377#\011\377\373\040\004\377\370\035\000\377\376"
		"\035\000\377\377\034\002\377\375\036\000\377x\022\000\377\011\000\000\377\003\000\000\377\000\001\002"
		"\377\000\006\002\377\002\001\000\377\001\000\000\377\250\000\000\000\377\010\000\001\000\377\001\000\000\377A"
		"\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\377"
		"\000\000\000\377\335\000\000\000\377\010\350\033\000\377\373\040\004\377\377\035\000\377\376\035"
		"\000\377\376\036\002\377\377\034\002\377\377\035\000\377\376\037\000\377\203\377\034\000\377"
		"\202\376\035\000\377\001\375\036\000\377\202\376\037\000\377\020\365&\000\377\377\036\001"
		"\377\377\033\004\377\375\033\002\377\377\034\001\377\377\034\003\377\377\036\005\377\366"
		"\040\004\377\377\"\000\377\362\040\017\377\067\014\000\377\003\000\005\377\010\001\010\377\000\001"
		"\000\377\000\000\002\377\010\000\006\377\250\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377"
		"\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\377\000\000\000"
		"\377\335\000\000\000\377\015\352\032\000\377\373\036\003\377\377\034\000\377\376\035\000\377"
		"\377\037\003\377\377\034\002\377\377\035\000\377\375\036\000\377\377\033\006\377\377\033"
		"\004\377\376\034\004\377\376\034\003\377\375\035\001\377\202\373\037\000\377\021\374\040"
		"\000\377\375\037\000\377\377\033\000\377\377\033\004\377\376\036\005\377\373\036\001\377\377"
		"\035\000\377\377\037\000\377\372\"\000\377\367\030\000\377\377\036\000\377\247\024\002\377"
		"\000\001\000\377\011\000\005\377\000\001\000\377\000\001\004\377\002\002\002\377\250\000\000\000\377\010\000\001"
		"\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002"
		"\377\024\002\000\377\377\000\000\000\377\335\000\000\000\377\010\354\032\001\377\374\037\004\377"
		"\377\035\000\377\376\035\000\377\376\036\002\377\377\034\001\377\377\034\000\377\372\036"
		"\000\377\202\374\"\000\377\004\374\040\000\377\376\040\000\377\377\037\000\377\377\036\000"
		"\377\202\377\035\000\377\016\377\033\001\377\376\034\004\377\373\037\011\377\375!\011"
		"\377\375\040\005\377\372\036\000\377\375\037\000\377\377!\000\377\377\"\021\377\370\040"
		"\000\377\350\027\020\377\020\004\000\377\006\000\002\377\001\001\000\377\202\000\001\000\377\250\000\000"
		"\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000"
		"\377\335\033\002\377\024\002\000\377\377\000\000\000\377\335\000\000\000\377\002\354\030\000\377\376"
		"\036\005\377\202\377\034\000\377\005\376\036\002\377\377\034\001\377\377\036\000\377\375!"
		"\000\377\377\034\004\377\202\377\033\003\377\004\377\034\001\377\377\035\002\377\377\036\002"
		"\377\377\036\000\377\202\376\037\000\377\017\377\"\000\377\371!\000\377\370\037\000\377"
		"\377\035\000\377\377\034\010\377\326\030\010\377\236\023\000\377\177\020\000\377\215\017"
		"\000\377\204\017\006\377\007\002\000\377\000\000\007\377\003\000\000\377\003\002\000\377\007\000\004\377\250"
		"\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377"
		"\035\000\377\335\033\002\377\024\002\000\377\377\000\000\000\377\335\000\000\000\377\007\347\034\000"
		"\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376"
		"\037\000\377\211\377\036\000\377\010\374\040\000\377\372\037\000\377\377\034\005\377\377"
		"\031\000\377\304\032\011\377S\003\004\377\006\004\000\377\002\002\012\377\260\000\000\000\377\010\000"
		"\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033"
		"\002\377\024\002\000\377\377\000\000\000\377\335\000\000\000\377\007\347\034\000\377\377\036\002\377"
		"\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377"
		"\036\000\377\007\377\034\012\377\375\040\000\377\377\037\014\377\214\017\000\377\012\003\000"
		"\377\004\000\005\377\000\003\000\377\261\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375"
		"\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\377\000\000\000\377"
		"\335\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377"
		"\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\010\377\035\000\377\377"
		"\037\003\377\211\016\000\377\002\005\000\377\000\002\007\377\000\002\006\377\001\001\001\377\000\000\005\377"
		"\260\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377"
		"\377\035\000\377\335\033\002\377\024\002\000\377\377\000\000\000\377\335\000\000\000\377\007\347\034"
		"\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376"
		"\037\000\377\211\377\036\000\377\010\374\"\000\377\307\025\013\377\010\006\000\377\001\000\002"
		"\377\013\006\003\377\015\000\000\377\000\004\000\377\006\000\007\377\260\000\000\000\377\010\000\001\000\377"
		"\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024"
		"\002\000\377\377\000\000\000\377\335\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000"
		"\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377"
		"\010\377\031\000\377R\016\005\377\000\007\000\377\002\002\000\377\001\000\000\377\000\001\000\377\000\005\000"
		"\377\001\000\000\377\260\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377"
		"\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\377\000\000\000\377\335\000\000"
		"\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377"
		"\377\034\002\377\376\037\000\377\211\377\036\000\377\010\347\024\011\377\030\003\002\377\000"
		"\003\004\377\000\000\000\377\000\000\014\377\013\002\007\377\000\006\000\377\002\002\000\377\260\000\000\000\377"
		"\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335"
		"\033\002\377\024\002\000\377\377\000\000\000\377\335\000\000\000\377\007\347\034\000\377\377\036\002"
		"\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211"
		"\377\036\000\377\010\263\026\003\377\003\000\000\377\012\000\011\377\005\002\011\377\007\000\010\377"
		"\000\004\000\377\012\000\000\377\001\000\007\377\260\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003"
		"\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\377\000"
		"\000\000\377\335\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000"
		"\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\010\227\023\000"
		"\377\006\000\000\377\000\005\004\377\000\003\000\377\010\000\000\377\000\003\000\377\000\005\002\377\001\000\006\377"
		"\260\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377"
		"\377\035\000\377\335\033\002\377\024\002\000\377\377\000\000\000\377\335\000\000\000\377\007\347\034"
		"\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376"
		"\037\000\377\211\377\036\000\377\002\234\023\001\377\000\000\000\377\202\003\000\000\377\003\000\002\001"
		"\377\004\000\002\377\001\000\000\377\253\001\000\002\377\001\001\000\000\377\203\000\000\000\377\203\000\001"
		"\000\377\007\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033"
		"\002\377\024\002\000\377\202\000\000\000\377\202\001\001\001\377\202\000\000\000\377\001\001\001\001\377\212"
		"\000\000\000\377\001\001\001\001\377\203\000\000\000\377\001\001\001\001\377\213\000\000\000\377\001\001\001\001\377"
		"\202\000\000\000\377\001\001\001\001\377\233\000\000\000\377\202\001\001\001\377\203\000\000\000\377\001\001"
		"\001\001\377\216\000\000\000\377\001\001\001\001\377\234\000\000\000\377\202\001\001\001\377\002\000\000\000\377"
		"\001\001\001\377\202\000\000\000\377\001\001\001\001\377\213\000\000\000\377\001\002\002\002\377\202\000\000\000"
		"\377\001\001\001\001\377\234\000\000\000\377\202\001\001\001\377\202\000\000\000\377\001\001\001\001\377\204"
		"\000\000\000\377\001\001\001\001\377\205\000\000\000\377\202\001\001\001\377\202\000\000\000\377\001\001\001\001"
		"\377\212\000\000\000\377\001\001\001\001\377\202\000\000\000\377\202\001\001\001\377\213\000\000\000\377"
		"\001\002\002\002\377\202\000\000\000\377\001\001\001\001\377\207\000\000\000\377\007\347\034\000\377\377\036"
		"\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211"
		"\377\036\000\377\010\230\023\002\377\000\002\000\377\000\001\000\377\000\000\002\377\000\003\000\377\001\000"
		"\002\377\000\001\000\377\000\001\004\377\250\000\001\000\377\203\001\001\001\377\205\000\000\000\377\010\000"
		"\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033"
		"\002\377\024\002\000\377\203\000\000\000\377\001\001\001\001\377\202\000\000\000\377\001\001\001\001\377\216"
		"\000\000\000\377\202\001\001\001\377\212\000\000\000\377\001\001\001\001\377\243\000\000\000\377\001\001\001\001"
		"\377\212\000\000\000\377\202\001\001\001\377\205\000\000\000\377\001\001\001\001\377\231\000\000\000\377"
		"\001\001\001\001\377\205\000\000\000\377\001\001\001\001\377\210\000\000\000\377\001\001\001\001\377\205\000\000"
		"\000\377\001\002\002\002\377\241\000\000\000\377\203\001\001\001\377\204\000\000\000\377\001\002\002\002\377"
		"\203\000\000\000\377\001\001\001\001\377\202\000\000\000\377\001\001\001\001\377\215\000\000\000\377\001\001\001"
		"\001\377\202\000\000\000\377\001\003\003\003\377\211\000\000\000\377\004\002\002\002\377\000\000\000\377\001\001"
		"\001\377\002\002\002\377\207\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373"
		"\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\010\233"
		"\023\003\377\000\002\003\377\002\001\000\377\000\000\002\377\000\003\003\377\001\000\002\377\000\002\000\377\000\001"
		"\005\377\250\000\002\000\377\204\000\001\000\377\204\000\000\000\377\011\000\001\000\377\001\000\000\377A"
		"\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\001"
		"\001\001\377\202\000\000\000\377\001\001\001\001\377\204\000\000\000\377\210\001\001\001\377\002\000\000\000\377"
		"\001\001\001\377\204\000\000\000\377\202\001\001\001\377\211\000\000\000\377\204\001\001\001\377\202\000"
		"\000\000\377\001\002\002\002\377\230\001\001\001\377\202\000\000\000\377\203\001\001\001\377\202\000\000\000"
		"\377\001\001\001\001\377\217\000\000\000\377\001\001\001\001\377\231\000\000\000\377\001\001\001\001\377\202"
		"\000\000\000\377\003\002\002\002\377\001\001\001\377\000\000\000\377\211\001\001\001\377\001\000\000\000\377\202"
		"\001\001\001\377\203\000\000\000\377\001\001\001\001\377\240\000\000\000\377\001\001\001\001\377\210\000\000\000"
		"\377\001\001\001\001\377\202\000\000\000\377\001\001\001\001\377\204\000\000\000\377\211\001\001\001\377\203"
		"\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\205\000\000\000\377\205\001\001\001"
		"\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377"
		"\034\002\377\376\037\000\377\211\377\036\000\377\010\235\021\002\377\000\000\002\377\004\000\000\377"
		"\003\000\002\377\000\000\002\377\006\000\002\377\001\000\000\377\001\000\004\377\250\003\000\000\377\202\000\002"
		"\000\377\202\000\001\000\377\204\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036"
		"\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\204\001\001\001\377\203"
		"\000\000\000\377\001\001\001\001\377\211\000\000\000\377\202\001\001\001\377\217\000\000\000\377\001\001\001\001"
		"\377\255\000\000\000\377\002\002\002\002\377\001\001\001\377\202\000\000\000\377\202\001\001\001\377\204"
		"\000\000\000\377\202\001\001\001\377\304\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001"
		"\377\202\000\000\000\377\204\001\001\001\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377"
		"\202\001\001\001\377\212\000\000\000\377\202\001\001\001\377\212\000\000\000\377\007\347\034\000\377\377"
		"\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377"
		"\211\377\036\000\377\010\233\022\002\377\000\002\001\377\004\000\000\377\001\000\002\377\000\001\000\377"
		"\004\000\002\377\000\001\000\377\000\000\004\377\250\001\000\002\377\203\000\002\000\377\001\001\001\000\377\204"
		"\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377"
		"\035\000\377\335\033\002\377\024\002\000\377\205\000\000\000\377\002\002\002\002\377\001\001\001\377\236"
		"\000\000\000\377\203\001\001\001\377\230\000\000\000\377\002\002\002\002\377\001\001\001\377\202\000\000\000\377"
		"\202\001\001\001\377\224\000\000\000\377\203\001\001\001\377\231\000\000\000\377\202\001\001\001\377\210"
		"\000\000\000\377\003\002\002\002\377\001\001\001\377\000\000\000\377\202\001\001\001\377\202\000\000\000\377\001"
		"\001\001\001\377\231\000\000\000\377\003\001\001\001\377\002\002\002\377\001\001\001\377\202\000\000\000\377\202"
		"\001\001\001\377\202\002\002\002\377\001\001\001\001\377\212\000\000\000\377\002\002\002\002\377\001\001\001\377"
		"\211\000\000\000\377\003\001\001\001\377\002\002\002\377\001\001\001\377\202\000\000\000\377\202\001\001\001\377"
		"\215\000\000\000\377\003\001\001\001\377\002\002\002\377\001\001\001\377\205\000\000\000\377\007\347\034\000\377"
		"\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037"
		"\000\377\211\377\036\000\377\007\230\023\000\377\000\002\000\377\001\002\000\377\000\001\000\377\000\003"
		"\000\377\001\000\000\377\000\002\000\377\251\000\001\002\377\205\001\000\000\377\203\000\000\000\377\010\000"
		"\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033"
		"\002\377\024\002\000\377\204\000\000\000\377\202\002\002\002\377\216\000\000\000\377\001\001\001\001\377\213"
		"\000\000\000\377\001\001\001\001\377\202\000\000\000\377\001\001\001\001\377\240\000\000\000\377\203\001\001\001"
		"\377\212\000\000\000\377\202\001\001\001\377\204\000\000\000\377\001\001\001\001\377\203\000\000\000\377"
		"\202\001\001\001\377\225\000\000\000\377\202\001\001\001\377\220\000\000\000\377\001\002\002\002\377\246"
		"\000\000\000\377\001\001\001\001\377\203\000\000\000\377\001\001\001\001\377\204\000\000\000\377\202\002\002\002"
		"\377\214\000\000\000\377\002\002\002\002\377\001\001\001\377\214\000\000\000\377\001\002\002\002\377\204\000"
		"\000\000\377\001\001\001\001\377\206\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377"
		"\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\010"
		"\233\020\000\377\000\000\000\377\005\000\000\377\003\000\000\377\000\002\000\377\006\000\000\377\001\001\000\377"
		"\002\000\001\377\250\004\000\000\377\001\005\000\000\377\202\004\000\000\377\001\003\000\000\377\202\001\000\000"
		"\377\012\000\000\000\377\000\000\002\377\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374"
		"\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\202\001\001\001\377\202\000\000\000\377"
		"\001\001\001\001\377\202\000\000\000\377\001\003\003\003\377\210\000\000\000\377\002\003\003\003\377\001\001\001\377"
		"\202\000\000\000\377\202\001\001\001\377\002\000\000\000\377\001\001\001\377\210\000\000\000\377\003\002\002\002"
		"\377\000\000\000\377\001\001\001\377\203\000\000\000\377\202\001\001\001\377\231\000\000\000\377\002\002\002"
		"\002\377\003\003\003\377\203\000\000\000\377\202\001\001\001\377\213\000\000\000\377\001\001\001\001\377\202"
		"\002\002\002\377\004\001\001\001\377\000\000\000\377\002\002\002\377\001\001\001\377\226\000\000\000\377\001\002\002"
		"\002\377\203\001\001\001\377\202\000\000\000\377\202\002\002\002\377\211\000\000\000\377\002\002\002\002\377"
		"\001\001\001\377\202\000\000\000\377\001\001\001\001\377\232\000\000\000\377\001\001\001\001\377\204\000\000\000"
		"\377\202\002\002\002\377\002\000\000\000\377\002\002\002\377\202\000\000\000\377\202\001\001\001\377\203"
		"\000\000\000\377\202\001\001\001\377\202\000\000\000\377\001\001\001\001\377\202\000\000\000\377\001\003\003\003"
		"\377\210\000\000\000\377\001\003\003\003\377\202\000\000\000\377\202\001\001\001\377\001\000\000\000\377\202"
		"\001\001\001\377\212\000\000\000\377\002\003\003\003\377\002\002\002\377\210\000\000\000\377\007\347\034\000\377"
		"\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037"
		"\000\377\211\377\036\000\377\010\250\021\000\377\015\001\001\377\024\002\000\377\022\002\003\377"
		"\017\005\004\377\024\000\004\377\022\003\000\377\021\002\005\377\250\022\003\000\377\020\020\006\005\377"
		"\016\004\003\377\013\003\001\377\006\000\000\377\003\000\000\377\001\000\000\377\000\000\000\377\000\000\002\377"
		"\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335"
		"\033\002\377\024\002\000\377\203\000\000\000\377\001\001\001\001\377\202\000\000\000\377\002\003\003\003\377"
		"\020\020\020\377\210\031\031\031\377\002\007\007\007\377\003\003\003\377\223\000\000\000\377\003\010\010"
		"\010\377\024\024\024\377\032\032\032\377\230\031\031\031\377\004\030\030\030\377\032\032\032"
		"\377\025\025\025\377\011\011\011\377\216\000\000\000\377\010\002\002\002\377\012\012\012\377\024"
		"\024\024\377\031\031\031\377\027\027\027\377\023\023\023\377\004\004\004\377\002\002\002\377\226"
		"\000\000\000\377\001\001\001\001\377\203\000\000\000\377\004\001\001\001\377\012\012\012\377\025\025\025\377"
		"\033\033\033\377\211\031\031\031\377\004\032\032\032\377\020\020\020\377\003\003\003\377\000\000"
		"\000\377\202\001\001\001\377\234\000\000\000\377\007\004\004\004\377\015\015\015\377\025\025\025\377"
		"\030\030\030\377\027\027\027\377\021\021\021\377\007\007\007\377\202\000\000\000\377\202\001\001\001"
		"\377\002\000\000\000\377\001\001\001\377\203\000\000\000\377\001\001\001\001\377\202\000\000\000\377\002\003\003"
		"\003\377\020\020\020\377\210\031\031\031\377\002\027\027\027\377\010\010\010\377\217\000\000"
		"\000\377\002\004\004\004\377\023\023\023\377\202\031\031\031\377\003\032\032\032\377\031\031\031"
		"\377\032\032\032\377\204\031\031\031\377\007\347\034\000\377\377\036\002\377\377\036\000\377"
		"\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\005\347"
		"\040\003\377\344\035\000\377\341\032\000\377\340\031\000\377\341\032\000\377\202\342\033"
		"\000\377\001\341\032\000\377\240\342\033\000\377\030\345\031\000\377\334\031\003\377\342\034"
		"\002\377\336\031\000\377\343\032\000\377\343\035\000\377\340\032\000\377\347\025\010\377"
		"\357\032\000\377\303\020\011\377-\000\000\377\000\000\005\377\013\000\011\377\000\003\000\377\001\004"
		"\000\377\000\000\000\377\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377"
		"\035\000\377\335\033\002\377\024\002\000\377\202\000\000\000\377\001\001\001\001\377\202\000\000\000\377"
		"\003\003\003\003\377\000\000\000\377\257\257\257\377\210\344\344\344\377\001bbb\377\203\000"
		"\000\000\377\001\001\001\001\377\216\000\000\000\377\003\002\002\002\377\001\001\001\377###\377\203\342\342"
		"\342\377\007\347\347\347\377\344\344\344\377\343\343\343\377\350\350\350\377"
		"\341\341\341\377\347\347\347\377\343\343\343\377\220\344\344\344\377\010\346"
		"\346\346\377\343\343\343\377\344\344\344\377FFF\377\000\000\000\377\002\002\002\377\000"
		"\000\000\377\001\001\001\377\204\000\000\000\377\023\003\003\003\377\000\000\000\377\002\002\002\377,,,\377"
		"eee\377\232\232\232\377\302\302\302\377\326\326\326\377\343\343\343\377\344"
		"\344\344\377\342\342\342\377\341\341\341\377\323\323\323\377\263\263\263"
		"\377\210\210\210\377OOO\377\031\031\031\377\000\000\000\377\003\003\003\377\203\000\000\000\377"
		"\003\001\001\001\377\000\000\000\377\001\001\001\377\215\000\000\000\377\202\001\001\001\377\003\000\000\000\377"
		"rrr\377\342\342\342\377\211\344\344\344\377\010\342\342\342\377\343\343\343"
		"\377\307\307\307\377\011\011\011\377\000\000\000\377\003\003\003\377\000\000\000\377\001\001\001\377"
		"\213\000\000\000\377\202\001\001\001\377\002\000\000\000\377\002\002\002\377\202\000\000\000\377\003\003\003\003"
		"\377\000\000\000\377\004\004\004\377\203\000\000\000\377\020\005\005\005\377\063\063\063\377lll\377\240"
		"\240\240\377\304\304\304\377\333\333\333\377\342\342\342\377\343\343\343"
		"\377\345\345\345\377\341\341\341\377\315\315\315\377\257\257\257\377\202"
		"\202\202\377HHH\377\024\024\024\377\004\004\004\377\202\000\000\000\377\013\002\002\002\377\000\000"
		"\000\377\002\002\002\377\001\001\001\377\002\002\002\377\000\000\000\377YYY\377\350\350\350\377\342"
		"\342\342\377\344\344\344\377\345\345\345\377\202\343\343\343\377\010\346\346"
		"\346\377\343\343\343\377\341\341\341\377\203\203\203\377\000\000\000\377\003\003\003"
		"\377\000\000\000\377\001\001\001\377\203\000\000\000\377\001\002\002\002\377\202\000\000\000\377\003\003\003\003"
		"\377\000\000\000\377\002\002\002\377\202\000\000\000\377\001CCC\377\202\341\341\341\377\004\347"
		"\347\347\377\345\345\345\377\343\343\343\377\346\346\346\377\202\343\343"
		"\343\377\011\345\345\345\377\222\222\222\377\347\034\000\377\377\036\002\377\377"
		"\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036"
		"\000\377\006\377\040\007\377\376\036\005\377\375\035\004\377\374\034\003\377\375\035\004\377"
		"\376\036\005\377\202\375\035\004\377\240\376\036\005\377\030\363\040\005\377\377\036\002"
		"\377\373\036\003\377\372#\006\377\372\040\000\377\375\033\002\377\374\033\005\377\376\040"
		"\000\377\324\031\024\377\062\021\000\377\000\003\000\377\002\002\004\377\000\004\003\377\003\000\000\377"
		"\000\001\000\377\005\000\003\377\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377"
		"\377\035\000\377\335\033\002\377\024\002\000\377\205\000\000\000\377\003\002\002\002\377\004\004\004\377"
		"\300\300\300\377\210\377\377\377\377\003fff\377\000\000\000\377\001\001\001\377\215\000\000"
		"\000\377\202\001\001\001\377\202\000\000\000\377\003\001\001\001\377---\377\371\371\371\377\202"
		"\377\377\377\377\002\372\372\372\377\376\376\376\377\202\377\377\377\377\001"
		"\375\375\375\377\222\377\377\377\377\005\374\374\374\377\376\376\376\377\377"
		"\377\377\377QQQ\377\003\003\003\377\205\000\000\000\377\202\003\003\003\377\005\007\007\007\377[[["
		"\377\277\277\277\377\363\363\363\377\376\376\376\377\203\377\377\377\377"
		"\202\375\375\375\377\004\377\377\377\377\375\375\375\377\377\377\377\377\375"
		"\375\375\377\202\377\377\377\377\003\351\351\351\377\233\233\233\377;;;\377"
		"\202\000\000\000\377\003\005\005\005\377\000\000\000\377\001\001\001\377\202\000\000\000\377\202\001\001\001\377"
		"\210\000\000\000\377\002\001\001\001\377\002\002\002\377\202\000\000\000\377\002\003\003\003\377\255\255\255"
		"\377\214\377\377\377\377\002\366\366\366\377\070\070\070\377\215\000\000\000\377\002\004"
		"\004\004\377\002\002\002\377\203\000\000\000\377\005\001\001\001\377\000\000\000\377\001\001\001\377\000\000\000\377"
		"\003\003\003\377\202\000\000\000\377\004\025\025\025\377lll\377\304\304\304\377\372\372\372"
		"\377\202\377\377\377\377\001\376\376\376\377\203\377\377\377\377\001\375\375"
		"\375\377\202\377\377\377\377\001\376\376\376\377\202\377\377\377\377\003\335"
		"\335\335\377\213\213\213\377\061\061\061\377\202\000\000\000\377\001\004\004\004\377\203\000"
		"\000\000\377\004\003\003\003\377\022\022\022\377\336\336\336\377\377\377\377\377\202\376"
		"\376\376\377\002\377\377\377\377\375\375\375\377\202\376\376\376\377\003\377"
		"\377\377\377\340\340\340\377\035\035\035\377\203\000\000\000\377\001\001\001\001\377\204\000"
		"\000\000\377\001\001\001\001\377\202\000\000\000\377\010\002\002\002\377\000\000\000\377\003\003\003\377\255\255"
		"\255\377\376\376\376\377\377\377\377\377\376\376\376\377\375\375\375\377"
		"\205\377\377\377\377\010>>>\377\347\034\000\377\377\036\002\377\377\036\000\377\373"
		"\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\001\377\036"
		"\001\377\203\377\035\000\377\203\377\036\001\377\241\377\035\000\377\004\377\040\000\377"
		"\377\034\000\377\377\032\000\377\377\034\000\377\202\377\032\000\377\005\374!\001\377\325"
		"\037\000\377\060\007\001\377\000\002\000\377\004\003\000\377\202\000\002\000\377\015\010\002\002\377\000\003"
		"\000\377\003\000\004\377\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377"
		"\035\000\377\335\033\002\377\024\002\000\377\002\002\002\377\000\000\000\377\202\002\002\002\377\202\000"
		"\000\000\377\002\001\001\001\377\302\302\302\377\210\377\377\377\377\003iii\377\002\002\002\377"
		"\001\001\001\377\216\000\000\000\377\001\002\002\002\377\202\001\001\001\377\003\000\000\000\377)))\377\366"
		"\366\366\377\204\377\377\377\377\001\375\375\375\377\202\377\377\377\377\001"
		"\376\376\376\377\223\377\377\377\377\006\375\375\375\377LLL\377\002\002\002\377\000"
		"\000\000\377\002\002\002\377\000\000\000\377\202\002\002\002\377\003\000\000\000\377FFF\377\311\311\311"
		"\377\204\377\377\377\377\005\374\374\374\377\375\375\375\377\377\377\377\377"
		"\376\376\376\377\375\375\375\377\202\377\377\377\377\011\376\376\376\377\377"
		"\377\377\377\376\376\376\377\377\377\377\377\371\371\371\377\377\377\377"
		"\377\366\366\366\377\242\242\242\377!!!\377\202\000\000\000\377\004\001\001\001\377\005\005"
		"\005\377\000\000\000\377\004\004\004\377\212\000\000\000\377\001\001\001\001\377\202\000\000\000\377\004\020\020"
		"\020\377\336\336\336\377\377\377\377\377\374\374\374\377\210\377\377\377\377"
		"\001\375\375\375\377\202\377\377\377\377\001fff\377\202\000\000\000\377\001\004\004\004\377"
		"\212\000\000\000\377\001\002\002\002\377\202\000\000\000\377\202\001\001\001\377\202\000\000\000\377\001\002"
		"\002\002\377\202\000\000\000\377\003\001\001\001\377XXX\377\320\320\320\377\202\377\377\377"
		"\377\202\376\376\376\377\001\375\375\375\377\204\377\377\377\377\202\375\375"
		"\375\377\202\377\377\377\377\002\374\374\374\377\376\376\376\377\202\377\377"
		"\377\377\012\360\360\360\377\222\222\222\377\026\026\026\377\001\001\001\377\000\000\000"
		"\377\002\002\002\377\000\000\000\377\004\004\004\377\001\001\001\377uuu\377\202\377\377\377\377\001"
		"\376\376\376\377\204\377\377\377\377\004\375\375\375\377\377\377\377\377pp"
		"p\377\000\000\000\377\202\002\002\002\377\001\001\001\001\377\203\000\000\000\377\016\002\002\002\377\001\001"
		"\001\377\000\000\000\377\002\002\002\377\000\000\000\377\003\003\003\377\060\060\060\377\367\367\367\377"
		"\376\376\376\377\377\377\377\377\376\376\376\377\377\377\377\377\376\376"
		"\376\377\374\374\374\377\202\375\375\375\377\011\271\271\271\377\000\000\000\377"
		"\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034"
		"\002\377\376\037\000\377\211\377\036\000\377\210\373\037\000\377\240\374\040\000\377\002"
		"\373\034\000\377\377!\005\377\202\377\034\000\377\024\377\035\004\377\377\034\001\377\326"
		"\033\012\377\066\006\000\377\000\000\005\377\007\000\002\377\000\005\000\377\000\002\000\377\004\000\001\377\000"
		"\001\003\377\004\000\002\377\002\002\002\377\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374"
		"\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\203\000\000\000\377\001\002\002\002\377"
		"\203\000\000\000\377\001\277\277\277\377\210\377\377\377\377\002iii\377\001\001\001\377\202"
		"\000\000\000\377\203\001\001\001\377\216\000\000\000\377\006(((\377\365\365\365\377\377\377\377"
		"\377\373\373\373\377\377\377\377\377\374\374\374\377\202\377\377\377\377"
		"\002\376\376\376\377\374\374\374\377\221\377\377\377\377\001\373\373\373\377"
		"\202\377\377\377\377\004NNN\377\000\000\000\377\003\003\003\377\001\001\001\377\202\000\000\000\377"
		"\004\005\005\005\377\204\204\204\377\376\376\376\377\374\374\374\377\202\377\377"
		"\377\377\002\374\374\374\377\376\376\376\377\205\377\377\377\377\001\376\376"
		"\376\377\202\375\375\375\377\204\377\377\377\377\006\375\375\375\377\377\377"
		"\377\377\376\376\376\377\334\334\334\377JJJ\377\004\004\004\377\202\000\000\000\377\003"
		"\002\002\002\377\000\000\000\377\001\001\001\377\214\000\000\000\377\002\067\067\067\377\373\373\373\377"
		"\215\377\377\377\377\003\236\236\236\377\001\001\001\377\003\003\003\377\212\000\000\000\377"
		"\001\001\001\001\377\203\000\000\000\377\001\001\001\001\377\203\000\000\000\377\004\001\001\001\377\000\000\000\377"
		"\015\015\015\377\225\225\225\377\202\377\377\377\377\002\376\376\376\377\374\374"
		"\374\377\211\377\377\377\377\002\373\373\373\377\375\375\375\377\202\377\377"
		"\377\377\001\373\373\373\377\202\377\377\377\377\012\374\374\374\377\320\320"
		"\320\377\062\062\062\377\000\000\000\377\002\002\002\377\000\000\000\377\001\001\001\377\000\000\000\377\032"
		"\032\032\377\342\342\342\377\202\377\377\377\377\001\375\375\375\377\205\377"
		"\377\377\377\002\325\325\325\377\017\017\017\377\203\000\000\000\377\002\001\001\001\377\000\000"
		"\000\377\202\001\001\001\377\205\000\000\000\377\002\232\232\232\377\377\377\377\377\202"
		"\375\375\375\377\206\377\377\377\377\011JJJ\377\001\001\001\377\347\034\000\377\377"
		"\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377"
		"\221\377\036\000\377\240\376\035\000\377\017\374\037\004\377\376\040\000\377\377\035\000"
		"\377\375!\001\377\373\"\001\377\334\027\017\377*\002\000\377\000\001\004\377\016\000\011\377"
		"\000\000\002\377\000\004\000\377\005\001\002\377\010\000\004\377\001\000\004\377\002\002\002\377\202\000\001\000\377"
		"\007\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377"
		"\024\002\000\377\205\000\000\000\377\202\001\001\001\377\001\301\301\301\377\210\377\377\377"
		"\377\001hhh\377\203\000\000\000\377\203\001\001\001\377\211\000\000\000\377\002\001\001\001\377\002\002\002"
		"\377\203\000\000\000\377\002)))\377\366\366\366\377\203\377\377\377\377\001\374\374"
		"\374\377\204\377\377\377\377\001\375\375\375\377\221\377\377\377\377\003\373"
		"\373\373\377\376\376\376\377NNN\377\203\000\000\000\377\003\001\001\001\377\004\004\004\377\240"
		"\240\240\377\203\377\377\377\377\001\375\375\375\377\202\377\377\377\377\001"
		"\376\376\376\377\202\377\377\377\377\002\376\376\376\377\375\375\375\377\204"
		"\377\377\377\377\003\376\376\376\377\375\375\375\377\376\376\376\377\202\377"
		"\377\377\377\202\375\375\375\377\010\377\377\377\377\366\366\366\377VVV\377"
		"\003\003\003\377\000\000\000\377\003\003\003\377\000\000\000\377\003\003\003\377\210\000\000\000\377\007\002\002\002"
		"\377\000\000\000\377\001\001\001\377\000\000\000\377mmm\377\377\377\377\377\375\375\375\377"
		"\212\377\377\377\377\005\375\375\375\377\376\376\376\377\323\323\323\377\010"
		"\010\010\377\001\001\001\377\212\000\000\000\377\002\001\001\001\377\000\000\000\377\202\001\001\001\377\202"
		"\000\000\000\377\005\001\001\001\377\002\002\002\377\000\000\000\377\017\017\017\377\265\265\265\377\203"
		"\377\377\377\377\003\375\375\375\377\377\377\377\377\375\375\375\377\204\377"
		"\377\377\377\003\376\376\376\377\374\374\374\377\376\376\376\377\203\377\377"
		"\377\377\001\375\375\375\377\203\377\377\377\377\005\375\375\375\377\376\376"
		"\376\377\377\377\377\377\353\353\353\377EEE\377\203\000\000\000\377\005\004\004\004\377"
		"\001\001\001\377\210\210\210\377\377\377\377\377\375\375\375\377\205\377\377\377"
		"\377\006\374\374\374\377\377\377\377\377]]]\377\002\002\002\377\004\004\004\377\001\001\001\377"
		"\202\000\000\000\377\001\003\003\003\377\203\000\000\000\377\005\001\001\001\377\003\003\003\377%%%\377\360"
		"\360\360\377\375\375\375\377\202\377\377\377\377\202\376\376\376\377\015\375"
		"\375\375\377\377\377\377\377\374\374\374\377\313\313\313\377\007\007\007\377\000"
		"\000\000\377\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377"
		"\377\034\002\377\376\037\000\377\211\377\036\000\377\203\377\036\002\377\203\376\035\001"
		"\377\242\377\036\002\377\033\376\"\000\377\377\032\000\377\377\034\000\377\376\040\000\377"
		"\334\027\006\377'\002\000\377\000\002\005\377\005\000\013\377\000\005\000\377\004\000\000\377\007\001\001\377"
		"\003\000\002\377\006\000\004\377\000\001\005\377\000\005\002\377\004\000\000\377\000\001\000\377\001\000\000\377A\007"
		"\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\000\000"
		"\000\377\002\002\002\377\001\001\001\377\204\000\000\000\377\001\277\277\277\377\210\377\377\377"
		"\377\002hhh\377\001\001\001\377\202\000\000\000\377\001\001\001\001\377\217\000\000\000\377\010\001\001\001"
		"\377+++\377\366\366\366\377\376\376\376\377\374\374\374\377\375\375\375\377"
		"\377\377\377\377\375\375\375\377\202\377\377\377\377\001\374\374\374\377\222"
		"\377\377\377\377\003\374\374\374\377\377\377\377\377LLL\377\203\000\000\000\377\007"
		"\002\002\002\377\221\221\221\377\374\374\374\377\377\377\377\377\376\376\376\377"
		"\377\377\377\377\374\374\374\377\203\377\377\377\377\001\375\375\375\377\205"
		"\377\377\377\377\202\375\375\375\377\003\377\377\377\377\376\376\376\377\377"
		"\377\377\377\202\375\375\375\377\204\377\377\377\377\004\363\363\363\377??"
		"?\377\000\000\000\377\001\001\001\377\215\000\000\000\377\002\002\002\002\377\247\247\247\377\214\377"
		"\377\377\377\007\376\376\376\377\377\377\377\377\366\366\366\377(((\377\001\001"
		"\001\377\002\002\002\377\001\001\001\377\212\000\000\000\377\001\001\001\001\377\202\000\000\000\377\017\002\002"
		"\002\377\001\001\001\377\000\000\000\377\001\001\001\377\250\250\250\377\377\377\377\377\376"
		"\376\376\377\377\377\377\377\376\376\376\377\377\377\377\377\373\373\373"
		"\377\377\377\377\377\376\376\376\377\375\375\375\377\374\374\374\377\202"
		"\377\377\377\377\002\376\376\376\377\377\377\377\377\202\376\376\376\377\002"
		"\377\377\377\377\375\375\375\377\203\377\377\377\377\006\376\376\376\377\377"
		"\377\377\377\372\372\372\377\377\377\377\377\354\354\354\377,,,\377\204\000"
		"\000\000\377\007$$$\377\354\354\354\377\375\375\375\377\377\377\377\377\373\373"
		"\373\377\377\377\377\377\375\375\375\377\203\377\377\377\377\002\302\302\302"
		"\377\006\006\006\377\202\000\000\000\377\001\002\002\002\377\203\000\000\000\377\203\001\001\001\377\005\000"
		"\000\000\377\213\213\213\377\376\376\376\377\375\375\375\377\376\376\376\377"
		"\202\377\377\377\377\016\376\376\376\377\377\377\377\377\376\376\376\377\377"
		"\377\377\377[[[\377\000\000\000\377\001\001\001\377\347\034\000\377\377\036\002\377\377\036"
		"\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377"
		"\001\375\040\003\377\247\374\037\002\377\030\374!\000\377\377\033\004\377\367!\007\377\325"
		"\034\010\377,\003\000\377\000\003\000\377\011\003\007\377\003\000\002\377\010\003\000\377\000\002\000\377\000"
		"\003\000\377\000\000\002\377\000\005\002\377\000\006\002\377\004\000\000\377\006\000\002\377\000\001\000\377\001\000"
		"\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002"
		"\000\377\202\000\000\000\377\001\001\001\001\377\204\000\000\000\377\001\300\300\300\377\210\377"
		"\377\377\377\001hhh\377\202\001\001\001\377\002\000\000\000\377\001\001\001\377\213\000\000\000\377\202"
		"\002\002\002\377\203\000\000\000\377\002)))\377\366\366\366\377\202\377\377\377\377\007\376"
		"\376\376\377\377\377\377\377\376\376\376\377\377\377\377\377\373\373\373"
		"\377\377\377\377\377\371\371\371\377\220\377\377\377\377\005\376\376\376\377"
		"\377\377\377\377\373\373\373\377OOO\377\002\002\002\377\202\001\001\001\377\002PPP\377"
		"\374\374\374\377\202\377\377\377\377\001\373\373\373\377\202\377\377\377\377"
		"\001\376\376\376\377\204\377\377\377\377\202\375\375\375\377\002\377\377\377"
		"\377\375\375\375\377\202\377\377\377\377\001\376\376\376\377\202\377\377\377"
		"\377\005\375\375\375\377\377\377\377\377\375\375\375\377\377\377\377\377\374"
		"\374\374\377\202\377\377\377\377\003\325\325\325\377\021\021\021\377\002\002\002\377"
		"\212\000\000\000\377\202\001\001\001\377\004\000\000\000\377\020\020\020\377\322\322\322\377\375"
		"\375\375\377\213\377\377\377\377\001\375\375\375\377\202\376\376\376\377\003"
		"aaa\377\000\000\000\377\002\002\002\377\211\000\000\000\377\002\002\002\002\377\001\001\001\377\202\000\000\000"
		"\377\202\001\001\001\377\004\000\000\000\377\003\003\003\377jjj\377\377\377\377\377\202\376\376"
		"\376\377\002\377\377\377\377\372\372\372\377\203\377\377\377\377\001\374\374"
		"\374\377\202\377\377\377\377\001\376\376\376\377\204\377\377\377\377\004\376"
		"\376\376\377\377\377\377\377\376\376\376\377\377\377\377\377\202\376\376"
		"\376\377\002\377\377\377\377\375\375\375\377\202\377\377\377\377\010\373\373"
		"\373\377\304\304\304\377\007\007\007\377\002\002\002\377\000\000\000\377\001\001\001\377\000\000\000\377"
		"\235\235\235\377\202\377\377\377\377\004\376\376\376\377\377\377\377\377\376"
		"\376\376\377\377\377\377\377\202\376\376\376\377\002\377\377\377\377NNN\377"
		"\202\000\000\000\377\001\001\001\001\377\202\000\000\000\377\011\003\003\003\377\000\000\000\377\001\001\001\377"
		"\000\000\000\377\037\037\037\377\341\341\341\377\375\375\375\377\377\377\377\377\374"
		"\374\374\377\204\377\377\377\377\003\373\373\373\377\326\326\326\377\016\016"
		"\016\377\202\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377"
		"\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\204\377\034\000\377"
		"\202\377\035\000\377\202\377\034\000\377\241\377\035\000\377\027\377\036\000\377\314\033"
		"\013\377\061\005\000\377\000\002\002\377\004\002\005\377\001\000\000\377\000\005\000\377\000\000\000\377\000\001"
		"\003\377\006\000\004\377\000\003\002\377\000\002\000\377\006\000\000\377\002\002\002\377\000\003\005\377\000\001\000"
		"\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377"
		"\024\002\000\377\202\001\001\001\377\202\000\000\000\377\202\001\001\001\377\002\000\000\000\377\301\301"
		"\301\377\210\377\377\377\377\002hhh\377\001\001\001\377\202\000\000\000\377\003\001\001\001\377"
		"\000\000\000\377\001\001\001\377\214\000\000\000\377\004\001\001\001\377\000\000\000\377)))\377\365\365\365"
		"\377\203\377\377\377\377\001\376\376\376\377\203\377\377\377\377\002\356\356"
		"\356\377___\377\210GGG\377\210HHH\377\004III\377EEE\377KKK\377\026\026\026\377"
		"\202\000\000\000\377\007\015\015\015\377\330\330\330\377\377\377\377\377\375\375\375"
		"\377\374\374\374\377\377\377\377\377\376\376\376\377\202\377\377\377\377"
		"\202\376\376\376\377\015\377\377\377\377\330\330\330\377\223\223\223\377a"
		"aa\377III\377OOO\377ooo\377\252\252\252\377\360\360\360\377\377\377\377\377"
		"\376\376\376\377\377\377\377\377\376\376\376\377\202\377\377\377\377\005\376"
		"\376\376\377\377\377\377\377\375\375\375\377\377\377\377\377\210\210\210"
		"\377\202\000\000\000\377\001\002\002\002\377\211\000\000\000\377\202\001\001\001\377\004+++\377\366\366"
		"\366\377\377\377\377\377\375\375\375\377\211\377\377\377\377\001\376\376\376"
		"\377\203\377\377\377\377\001\224\224\224\377\202\000\000\000\377\001\001\001\001\377\214"
		"\000\000\000\377\007\002\002\002\377\000\000\000\377\003\003\003\377\036\036\036\377\351\351\351\377\377"
		"\377\377\377\376\376\376\377\203\377\377\377\377\001\375\375\375\377\203\377"
		"\377\377\377\013\375\375\375\377\323\323\323\377\213\213\213\377YYY\377KK"
		"K\377NNN\377rrr\377\262\262\262\377\364\364\364\377\377\377\377\377\375\375"
		"\375\377\204\377\377\377\377\002\374\374\374\377\375\375\375\377\202\377\377"
		"\377\377\001jjj\377\202\000\000\000\377\202\001\001\001\377\015\061\061\061\377\364\364\364"
		"\377\374\374\374\377\377\377\377\377\374\374\374\377\377\377\377\377\376"
		"\376\376\377\377\377\377\377\373\373\373\377\377\377\377\377\262\262\262"
		"\377\002\002\002\377\001\001\001\377\202\000\000\000\377\006\002\002\002\377\001\001\001\377\000\000\000\377\002"
		"\002\002\377\001\001\001\377vvv\377\203\377\377\377\377\007\376\376\376\377\377\377\377"
		"\377\375\375\375\377\377\377\377\377\375\375\375\377\377\377\377\377ppp\377"
		"\203\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377"
		"\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\010\271\025\000\377G\016"
		"\007\377P\005\002\377I\014\000\377N\011\002\377H\011\000\377W\013\000\377N\010\000\377\230N\012"
		"\000\377\020T\005\000\377J\012\000\377Q\017\000\377G\012\000\377D\013\002\377Z\006\004\377R\004\000"
		"\377M\013\000\377R\010\011\377E\011\011\377%\002\000\377\010\000\000\377\000\002\001\377\000\002\002"
		"\377\000\000\002\377\004\002\003\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375"
		"\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377"
		"\001\300\300\300\377\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377"
		"\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366\366\366\377\204\377"
		"\377\377\377\001\376\376\376\377\202\377\377\377\377\002\351\351\351\377\030\030"
		"\030\377\222\000\000\000\377\001\001\001\001\377\202\000\000\000\377\002\001\001\001\377ggg\377\203\377"
		"\377\377\377\021\376\376\376\377\377\377\377\377\376\376\376\377\377\377\377"
		"\377\376\376\376\377\377\377\377\377\370\370\370\377{{{\377\017\017\017\377"
		"\000\000\000\377\003\003\003\377\000\000\000\377\003\003\003\377\000\000\000\377\001\001\001\377,,,\377\255\255"
		"\255\377\202\377\377\377\377\001\376\376\376\377\202\377\377\377\377\001\376"
		"\376\376\377\203\377\377\377\377\003\355\355\355\377\"\"\"\377\001\001\001\377\212"
		"\000\000\000\377\006\004\004\004\377\000\000\000\377eee\377\376\376\376\377\377\377\377\377\376"
		"\376\376\377\203\377\377\377\377\001\376\376\376\377\202\377\377\377\377\001"
		"\376\376\376\377\203\377\377\377\377\007\373\373\373\377\377\377\377\377\375"
		"\375\375\377\312\312\312\377\011\011\011\377\000\000\000\377\001\001\001\377\210\000\000\000\377"
		"\003\001\001\001\377\000\000\000\377\002\002\002\377\202\000\000\000\377\003\001\001\001\377\000\000\000\377\215"
		"\215\215\377\202\377\377\377\377\003\375\375\375\377\377\377\377\377\375\375"
		"\375\377\202\377\377\377\377\006\376\376\376\377\377\377\377\377\351\351\351"
		"\377jjj\377\007\007\007\377\006\006\006\377\202\000\000\000\377\001\002\002\002\377\202\000\000\000\377\004"
		"\065\065\065\377\300\300\300\377\377\377\377\377\373\373\373\377\203\377\377"
		"\377\377\001\375\375\375\377\203\377\377\377\377\003\333\333\333\377\020\020\020"
		"\377\001\001\001\377\202\000\000\000\377\002\003\003\003\377\250\250\250\377\203\377\377\377"
		"\377\001\376\376\376\377\203\377\377\377\377\004\374\374\374\377\376\376\376"
		"\377\067\067\067\377\000\000\000\377\203\001\001\001\377\001\002\002\002\377\202\000\000\000\377\002\023"
		"\023\023\377\334\334\334\377\202\377\377\377\377\001\376\376\376\377\203\377"
		"\377\377\377\004\375\375\375\377\377\377\377\377\340\340\340\377\024\024\024\377"
		"\203\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377"
		"\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\007\224\017\006\377\000\003\004"
		"\377\001\000\002\377\000\001\000\377\001\000\005\377\000\002\002\377\006\000\002\377\231\000\000\002\377\020\000"
		"\003\006\377\000\001\000\377\001\000\000\377\004\003\013\377\007\000\001\377\000\002\000\377\004\000\006\377\000\005"
		"\002\377\006\000\000\377\006\003\000\377\000\001\000\377\000\002\000\377\000\003\003\377\000\002\003\377\001\000\000"
		"\377\004\000\000\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377"
		"\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300"
		"\300\377\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000"
		"\377\001\001\001\001\377\203\000\000\000\377\003)))\377\366\366\366\377\377\377\377\377\202"
		"\376\376\376\377\002\377\377\377\377\376\376\376\377\202\377\377\377\377\002"
		"\354\354\354\377\033\033\033\377\220\000\000\000\377\202\001\001\001\377\012\000\000\000\377\005"
		"\005\005\377\000\000\000\377\012\012\012\377\310\310\310\377\377\377\377\377\376\376\376"
		"\377\375\375\375\377\377\377\377\377\372\372\372\377\203\377\377\377\377"
		"\016\366\366\366\377XXX\377\002\002\002\377\000\000\000\377\003\003\003\377\000\000\000\377\004\004\004"
		"\377\000\000\000\377\004\004\004\377\000\000\000\377\002\002\002\377\010\010\010\377\244\244\244\377"
		"\375\375\375\377\202\377\377\377\377\004\376\376\376\377\377\377\377\377\375"
		"\375\375\377\374\374\374\377\202\377\377\377\377\003vvv\377\005\005\005\377\001\001\001"
		"\377\212\000\000\000\377\004\001\001\001\377\227\227\227\377\377\377\377\377\376\376\376"
		"\377\203\377\377\377\377\001\376\376\376\377\202\377\377\377\377\002\374\374"
		"\374\377\375\375\375\377\206\377\377\377\377\002\354\354\354\377###\377\216"
		"\000\000\000\377\004\001\001\001\377\000\000\000\377\026\026\026\377\333\333\333\377\206\377\377"
		"\377\377\005\374\374\374\377\377\377\377\377\354\354\354\377BBB\377\002\002\002\377"
		"\202\000\000\000\377\202\002\002\002\377\202\000\000\000\377\004\003\003\003\377\000\000\000\377\020\020\020"
		"\377\273\273\273\377\202\377\377\377\377\002\373\373\373\377\376\376\376\377"
		"\202\377\377\377\377\004\375\375\375\377\377\377\377\377\375\375\375\377__"
		"_\377\202\000\000\000\377\007\003\003\003\377\000\000\000\377@@@\377\377\377\377\377\373\373"
		"\373\377\375\375\375\377\377\377\377\377\202\376\376\376\377\011\377\377\377"
		"\377\376\376\376\377\377\377\377\377\244\244\244\377\000\000\000\377\001\001\001\377"
		"\000\000\000\377\001\001\001\377\000\000\000\377\202\001\001\001\377\007jjj\377\377\377\377\377\376"
		"\376\376\377\377\377\377\377\376\376\376\377\377\377\377\377\374\374\374"
		"\377\203\377\377\377\377\014\202\202\202\377\001\001\001\377\000\000\000\377\001\001\001\377"
		"\000\000\000\377\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377"
		"\377\034\002\377\376\037\000\377\211\377\036\000\377\010\255\020\013\377\003\000\000\377\000"
		"\002\000\377\007\000\000\377\006\000\005\377\000\004\004\377\006\000\002\377\000\001\003\377\230\000\000\004\377"
		"\016\000\001\005\377\006\000\002\377\000\003\000\377\000\001\002\377\001\001\011\377\000\000\002\377\006\000\000\377"
		"\003\001\004\377\000\004\000\377\000\003\002\377\000\001\004\377\000\000\004\377\005\000\006\377\004\000\003\377\202"
		"\003\000\000\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374"
		"\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300"
		"\377\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377"
		"\001\001\001\001\377\203\000\000\000\377\002)))\377\366\366\366\377\202\377\377\377\377\003"
		"\376\376\376\377\377\377\377\377\376\376\376\377\202\377\377\377\377\002\355"
		"\355\355\377\036\036\036\377\221\000\000\000\377\007\002\002\002\377\000\000\000\377\001\001\001\377\000"
		"\000\000\377\067\067\067\377\377\377\377\377\376\376\376\377\203\377\377\377\377"
		"\006\374\374\374\377\377\377\377\377\376\376\376\377\375\375\375\377\211\211"
		"\211\377\001\001\001\377\204\000\000\000\377\001\001\001\001\377\202\000\000\000\377\006\002\002\002\377\000"
		"\000\000\377\002\002\002\377\023\023\023\377\333\333\333\377\377\377\377\377\202\376\376"
		"\376\377\001\377\377\377\377\202\376\376\376\377\202\377\377\377\377\002\310"
		"\310\310\377\007\007\007\377\211\000\000\000\377\020\002\002\002\377\000\000\000\377\011\011\011\377"
		"\316\316\316\377\377\377\377\377\376\376\376\377\377\377\377\377\376\376"
		"\376\377\377\377\377\377\375\375\375\377\377\377\377\377\376\376\376\377"
		"\377\377\377\377\375\375\375\377\377\377\377\377\376\376\376\377\202\377"
		"\377\377\377\001\376\376\376\377\202\377\377\377\377\001NNN\377\212\000\000\000\377"
		"\003\002\002\002\377\000\000\000\377\002\002\002\377\203\000\000\000\377\001QQQ\377\206\377\377\377\377"
		"\013\375\375\375\377\377\377\377\377\376\376\376\377nnn\377\003\003\003\377\000\000"
		"\000\377\003\003\003\377\000\000\000\377\001\001\001\377\000\000\000\377\002\002\002\377\203\000\000\000\377\003"
		"\004\004\004\377\"\"\"\377\346\346\346\377\206\377\377\377\377\003\376\376\376\377"
		"\377\377\377\377\253\253\253\377\202\000\000\000\377\004\003\003\003\377\000\000\000\377\004\004"
		"\004\377\300\300\300\377\202\377\377\377\377\001\373\373\373\377\202\377\377"
		"\377\377\007\375\375\375\377\377\377\377\377\373\373\373\377\360\360\360\377"
		"'''\377\000\000\000\377\002\002\002\377\203\000\000\000\377\002\012\012\012\377\320\320\320\377"
		"\204\377\377\377\377\006\376\376\376\377\373\373\373\377\377\377\377\377\374"
		"\374\374\377\347\347\347\377%%%\377\202\000\000\000\377\011\002\002\002\377\000\000\000\377"
		"\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034"
		"\002\377\376\037\000\377\211\377\036\000\377\010\214\020\004\377\001\001\000\377\000\005\000\377"
		"\002\001\000\377\006\000\004\377\000\005\000\377\000\000\000\377\000\002\000\377\230\000\001\000\377\013\010\000"
		"\000\377\001\000\005\377\015\002\010\377\004\000\000\377\000\002\001\377\001\001\003\377\000\003\002\377\000\003"
		"\015\377\003\001\004\377\004\000\003\377\006\000\004\377\202\007\000\004\377\003\004\000\000\377\002\001\000\377"
		"\000\002\000\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374"
		"\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300"
		"\377\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377"
		"\001\001\001\001\377\203\000\000\000\377\002)))\377\366\366\366\377\205\377\377\377\377\004"
		"\376\376\376\377\377\377\377\377\354\354\354\377\036\036\036\377\221\000\000\000\377"
		"\021\001\001\001\377\003\003\003\377\000\000\000\377\001\001\001\377{{{\377\376\376\376\377\377\377"
		"\377\377\376\376\376\377\377\377\377\377\372\372\372\377\377\377\377\377"
		"\374\374\374\377\377\377\377\377\341\341\341\377\026\026\026\377\000\000\000\377\003"
		"\003\003\377\202\000\000\000\377\005\001\001\001\377\000\000\000\377\002\002\002\377\000\000\000\377\001\001\001\377"
		"\202\000\000\000\377\003\001\001\001\377kkk\377\371\371\371\377\202\377\377\377\377\001\376"
		"\376\376\377\202\377\377\377\377\005\376\376\376\377\375\375\375\377\365\365"
		"\365\377%%%\377\002\002\002\377\210\000\000\000\377\004\001\001\001\377\000\000\000\377'''\377\360"
		"\360\360\377\210\377\377\377\377\001\376\376\376\377\202\377\377\377\377\007"
		"\375\375\375\377\377\377\377\377\376\376\376\377\377\377\377\377\373\373"
		"\373\377\377\377\377\377\206\206\206\377\212\000\000\000\377\010\001\001\001\377\000\000\000"
		"\377\001\001\001\377\000\000\000\377\001\001\001\377\000\000\000\377\230\230\230\377\376\376\376"
		"\377\203\377\377\377\377\001\376\376\376\377\203\377\377\377\377\004\317\317"
		"\317\377\006\006\006\377\000\000\000\377\003\003\003\377\206\000\000\000\377\001\002\002\002\377\202\000\000"
		"\000\377\010\001\001\001\377\202\202\202\377\377\377\377\377\374\374\374\377\377\377"
		"\377\377\375\375\375\377\376\376\376\377\377\377\377\377\202\375\375\375"
		"\377\002\342\342\342\377\031\031\031\377\202\000\000\000\377\003\001\001\001\377\002\002\002\377N"
		"NN\377\203\377\377\377\377\007\376\376\376\377\377\377\377\377\374\374\374"
		"\377\377\377\377\377\373\373\373\377\377\377\377\377\220\220\220\377\205"
		"\000\000\000\377\007\\\\\\\377\375\375\375\377\376\376\376\377\377\377\377\377\375"
		"\375\375\377\377\377\377\377\375\375\375\377\203\377\377\377\377\001\226\226"
		"\226\377\202\000\000\000\377\001\001\001\001\377\202\000\000\000\377\007\347\034\000\377\377\036\002"
		"\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211"
		"\377\036\000\377\010\332\033\000\377\227\022\001\377\222\025\000\377\226\024\004\377\236"
		"\016\006\377\227\023\000\377\225\022\000\377\227\023\000\377\230\231\022\000\377\010\227"
		"\026\000\377\231\021\001\377\212\020\005\377\235\026\003\377\243\016\000\377j\016\003\377\000"
		"\001\000\377\006\000\000\377\206\000\001\000\377\002\000\002\001\377\000\001\000\377\210\000\000\000\377\010\000"
		"\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033"
		"\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300\377\210\377\377\377\377\001h"
		"hh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377"
		"\002)))\377\366\366\366\377\205\377\377\377\377\202\376\376\376\377\002\353\353"
		"\353\377\036\036\036\377\220\000\000\000\377\001\002\002\002\377\202\000\000\000\377\202\002\002\002\377"
		"\004\256\256\256\377\376\376\376\377\377\377\377\377\374\374\374\377\202\376"
		"\376\376\377\013\377\377\377\377\376\376\376\377\377\377\377\377\234\234\234"
		"\377\000\000\000\377\002\002\002\377\000\000\000\377\003\003\003\377\002\002\002\377\000\000\000\377\001\001\001\377"
		"\203\000\000\000\377\010\001\001\001\377\003\003\003\377\000\000\000\377\035\035\035\377\360\360\360"
		"\377\373\373\373\377\377\377\377\377\376\376\376\377\205\377\377\377\377"
		"\001UUU\377\212\000\000\000\377\016\001\001\001\377ZZZ\377\377\377\377\377\376\376\376\377"
		"\375\375\375\377\376\376\376\377\377\377\377\377\376\376\376\377\377\377"
		"\377\377\376\376\376\377\346\346\346\377\276\276\276\377\377\377\377\377"
		"\374\374\374\377\202\377\377\377\377\001\376\376\376\377\202\377\377\377\377"
		"\003\375\375\375\377\302\302\302\377\002\002\002\377\212\000\000\000\377\001\002\002\002\377\202"
		"\000\000\000\377\202\004\004\004\377\003\305\305\305\377\377\377\377\377\375\375\375\377"
		"\203\377\377\377\377\005\376\376\376\377\377\377\377\377\376\376\376\377\177"
		"\177\177\377\004\004\004\377\203\000\000\000\377\002\001\001\001\377\002\002\002\377\203\000\000\000\377"
		"\001\002\002\002\377\203\000\000\000\377\002\063\063\063\377\367\367\367\377\204\377\377\377"
		"\377\001\376\376\376\377\203\377\377\377\377\013===\377\000\000\000\377\002\002\002\377"
		"\000\000\000\377\001\001\001\377\011\011\011\377\314\314\314\377\376\376\376\377\377\377"
		"\377\377\375\375\375\377\377\377\377\377\202\375\375\375\377\202\377\377"
		"\377\377\003\350\350\350\377\034\034\034\377\000\000\000\377\202\001\001\001\377\004\003\003\003\377"
		"\310\310\310\377\374\374\374\377\377\377\377\377\202\374\374\374\377\202"
		"\377\377\377\377\004\376\376\376\377\372\372\372\377\363\363\363\377\061\061"
		"\061\377\204\000\000\000\377\010\001\001\001\377\347\034\000\377\377\036\002\377\377\036\000\377"
		"\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\010"
		"\377\035\000\377\371\034\011\377\371\035\003\377\372\037\011\377\377\033\011\377\377"
		"\035\000\377\375\040\006\377\377\037\003\377\230\377\035\004\377\015\372!\002\377\364\035"
		"\000\377\377!\001\377\366\"\000\377\325\036\014\377:\014\000\377\002\002\004\377\000\003\004\377"
		"\001\002\000\377\000\002\000\377\000\003\000\377\000\004\000\377\000\002\000\377\202\000\001\000\377\211\000\000"
		"\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000"
		"\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300\377\210\377\377"
		"\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203"
		"\000\000\000\377\003)))\377\366\366\366\377\377\377\377\377\202\376\376\376\377\204"
		"\377\377\377\377\002\354\354\354\377\036\036\036\377\220\000\000\000\377\001\001\001\001\377"
		"\202\000\000\000\377\003\002\002\002\377\010\010\010\377\313\313\313\377\205\377\377\377\377"
		"\007\376\376\376\377\377\377\377\377\375\375\375\377\\\\\\\377\003\003\003\377\000"
		"\000\000\377\004\004\004\377\202\000\000\000\377\202\001\001\001\377\001\000\000\000\377\202\001\001\001\377"
		"\006\000\000\000\377\001\001\001\377\002\002\002\377\004\004\004\377\305\305\305\377\375\375\375\377"
		"\203\377\377\377\377\202\376\376\376\377\003\377\377\377\377\373\373\373\377"
		"zzz\377\211\000\000\000\377\005\001\001\001\377\000\000\000\377\217\217\217\377\377\377\377\377"
		"\376\376\376\377\204\377\377\377\377\006\375\375\375\377\376\376\376\377\270"
		"\270\270\377eee\377\377\377\377\377\373\373\373\377\205\377\377\377\377\003"
		"\376\376\376\377\353\353\353\377\031\031\031\377\211\000\000\000\377\002\001\001\001\377\003"
		"\003\003\377\203\000\000\000\377\004\025\025\025\377\333\333\333\377\377\377\377\377\376"
		"\376\376\377\203\377\377\377\377\011\375\375\375\377\377\377\377\377\375\375"
		"\375\377DDD\377\000\000\000\377\003\003\003\377\002\002\002\377\000\000\000\377\001\001\001\377\202\000\000"
		"\000\377\004\003\003\003\377\002\002\002\377\000\000\000\377\001\001\001\377\202\000\000\000\377\004\025\025\025"
		"\377\327\327\327\377\377\377\377\377\376\376\376\377\202\377\377\377\377"
		"\007\375\375\375\377\377\377\377\377\374\374\374\377\377\377\377\377]]]\377"
		"\000\000\000\377\001\001\001\377\202\000\000\000\377\010\001\001\001\377```\377\377\377\377\377\372"
		"\372\372\377\377\377\377\377\375\375\375\377\377\377\377\377\376\376\376"
		"\377\203\377\377\377\377\006www\377\000\000\000\377\003\003\003\377\000\000\000\377KKK\377\372"
		"\372\372\377\204\377\377\377\377\011\376\376\376\377\377\377\377\377\372\372"
		"\372\377\377\377\377\377\247\247\247\377\000\000\000\377\002\002\002\377\001\001\001\377\002"
		"\002\002\377\202\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000"
		"\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\005\372\040\000\377"
		"\377\037\005\377\377\037\000\377\377\040\001\377\376\035\000\377\202\377\036\000\377\001\375"
		"\036\000\377\230\377\037\000\377\202\377\035\000\377\007\377\034\000\377\340\020\003\377\""
		"\007\000\377\000\003\004\377\001\000\000\377\003\003\003\377\005\000\000\377\202\004\000\000\377\001\003\000\000\377"
		"\202\001\000\000\377\002\000\000\000\377\001\001\001\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377"
		"A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377"
		"\207\000\000\000\377\001\300\300\300\377\210\377\377\377\377\001hhh\377\203\000\000\000\377"
		"\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366\366\366"
		"\377\202\377\377\377\377\001\375\375\375\377\204\377\377\377\377\002\354\354"
		"\354\377\036\036\036\377\221\000\000\000\377\001\001\001\001\377\202\000\000\000\377\003\021\021\021"
		"\377\325\325\325\377\376\376\376\377\203\377\377\377\377\002\375\375\375\377"
		"\376\376\376\377\202\377\377\377\377\003HHH\377\000\000\000\377\003\003\003\377\202\000\000"
		"\000\377\010\003\003\003\377\004\004\004\377\002\002\002\377\000\000\000\377\003\003\003\377\001\001\001\377\000\000"
		"\000\377\001\001\001\377\202\000\000\000\377\005\262\262\262\377\377\377\377\377\376\376"
		"\376\377\377\377\377\377\376\376\376\377\203\377\377\377\377\003\373\373\373"
		"\377\212\212\212\377\002\002\002\377\210\000\000\000\377\004\001\001\001\377\010\010\010\377\305"
		"\305\305\377\376\376\376\377\203\377\377\377\377\011\376\376\376\377\377\377"
		"\377\377\376\376\376\377\377\377\377\377\204\204\204\377)))\377\366\366\366"
		"\377\377\377\377\377\373\373\373\377\202\377\377\377\377\005\375\375\375\377"
		"\377\377\377\377\376\376\376\377\373\373\373\377NNN\377\213\000\000\000\377\001\001"
		"\001\001\377\202\000\000\000\377\003\"\"\"\377\351\351\351\377\375\375\375\377\204\377"
		"\377\377\377\006\376\376\376\377\377\377\377\377\375\375\375\377\060\060\060\377"
		"\000\000\000\377\003\003\003\377\204\000\000\000\377\001\001\001\001\377\202\000\000\000\377\001\002\002\002\377"
		"\202\000\000\000\377\202\001\001\001\377\005\312\312\312\377\377\377\377\377\375\375\375"
		"\377\377\377\377\377\376\376\376\377\202\377\377\377\377\004\374\374\374\377"
		"\376\376\376\377rrr\377\001\001\001\377\202\000\000\000\377\202\001\001\001\377\002\020\020\020"
		"\377\327\327\327\377\202\377\377\377\377\001\375\375\375\377\202\377\377\377"
		"\377\011\375\375\375\377\377\377\377\377\376\376\376\377\335\335\335\377\024"
		"\024\024\377\000\000\000\377\004\004\004\377\266\266\266\377\376\376\376\377\202\377\377"
		"\377\377\003\376\376\376\377\377\377\377\377\376\376\376\377\202\377\377\377"
		"\377\002\366\366\366\377CCC\377\204\000\000\000\377\011\001\001\001\377\000\000\000\377\347\034"
		"\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376"
		"\037\000\377\211\377\036\000\377\010\377\035\005\377\376\034\004\377\377\035\000\377\377"
		"\034\000\377\372\036\000\377\376\040\000\377\377\032\006\377\374\036\007\377\230\376\037"
		"\000\377\020\375\034\000\377\377!\001\377\302\030\011\377&\003\000\377\000\000\011\377\004\003\010"
		"\377\003\000\000\377\000\002\000\377\000\001\005\377\000\001\004\377\001\000\002\377\004\000\002\377\006\000\002\377"
		"\003\000\000\377\000\000\000\377\000\002\001\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003"
		"\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000"
		"\000\000\377\001\300\300\300\377\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001"
		"\001\001\377\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366\366\366\377"
		"\202\377\377\377\377\001\376\376\376\377\204\377\377\377\377\002\353\353\353"
		"\377\036\036\036\377\221\000\000\000\377\001\002\002\002\377\202\000\000\000\377\002\022\022\022\377"
		"\324\324\324\377\203\377\377\377\377\001\376\376\376\377\202\377\377\377\377"
		"\007\375\375\375\377\377\377\377\377EEE\377\001\001\001\377\000\000\000\377\003\003\003\377\001"
		"\001\001\377\203\000\000\000\377\001\004\004\004\377\205\000\000\000\377\002\001\001\001\377\256\256\256"
		"\377\203\377\377\377\377\001\376\376\376\377\204\377\377\377\377\001\207\207"
		"\207\377\212\000\000\000\377\015\037\037\037\377\362\362\362\377\377\377\377\377\375"
		"\375\375\377\377\377\377\377\376\376\376\377\377\377\377\377\375\375\375"
		"\377\377\377\377\377\375\375\375\377PPP\377\002\002\002\377\325\325\325\377\206"
		"\377\377\377\377\003\376\376\376\377\377\377\377\377\200\200\200\377\211\000"
		"\000\000\377\007\001\001\001\377\000\000\000\377\002\002\002\377\000\000\000\377\005\005\005\377\035\035\035\377"
		"\347\347\347\377\202\377\377\377\377\001\374\374\374\377\203\377\377\377\377"
		"\003\376\376\376\377\371\371\371\377...\377\202\000\000\000\377\202\001\001\001\377\004\000"
		"\000\000\377\003\003\003\377\000\000\000\377\001\001\001\377\202\000\000\000\377\006\001\001\001\377\000\000\000\377"
		"\001\001\001\377\003\003\003\377\315\315\315\377\375\375\375\377\202\377\377\377\377"
		"\011\376\376\376\377\377\377\377\377\375\375\375\377\377\377\377\377\373\373"
		"\373\377ppp\377\000\000\000\377\002\002\002\377\001\001\001\377\202\000\000\000\377\007\001\001\001\377s"
		"ss\377\377\377\377\377\375\375\375\377\377\377\377\377\375\375\375\377\376"
		"\376\376\377\204\377\377\377\377\006hhh\377\001\001\001\377>>>\377\370\370\370\377"
		"\377\377\377\377\376\376\376\377\204\377\377\377\377\202\376\376\376\377"
		"\002\267\267\267\377\001\001\001\377\202\000\000\000\377\001\002\002\002\377\202\000\000\000\377\010\001"
		"\001\001\377\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377"
		"\377\034\002\377\376\037\000\377\211\377\036\000\377\010\377\033\004\377\376\040\000\377"
		"\366\"\000\377\375\"\002\377\377\034\002\377\377\033\000\377\377\040\000\377\370\036\000"
		"\377\220\376\036\000\377\020\377\036\005\377\377\035\004\377\377\034\001\377\377\032\000"
		"\377\377\031\000\377\377\035\000\377\374\"\000\377\375!\000\377\370#\000\377\311\024\013"
		"\377\061\003\003\377\000\001\007\377\010\000\005\377\000\004\000\377\004\005\000\377\003\000\005\377\220\000"
		"\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035"
		"\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300\377\210\377\377"
		"\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203"
		"\000\000\000\377\002)))\377\366\366\366\377\202\377\377\377\377\001\376\376\376\377"
		"\204\377\377\377\377\002\354\354\354\377\036\036\036\377\224\000\000\000\377\002\021\021"
		"\021\377\325\325\325\377\206\377\377\377\377\003\376\376\376\377\377\377\377"
		"\377EEE\377\211\000\000\000\377\204\001\001\001\377\002\000\000\000\377\266\266\266\377\204\377"
		"\377\377\377\001\376\376\376\377\203\377\377\377\377\001\212\212\212\377\202"
		"\000\000\000\377\202\001\001\001\377\206\000\000\000\377\007WWW\377\374\374\374\377\377\377\377"
		"\377\374\374\374\377\377\377\377\377\376\376\376\377\377\377\377\377\202"
		"\376\376\376\377\010\361\361\361\377###\377\004\004\004\377\237\237\237\377\377"
		"\377\377\377\376\376\376\377\377\377\377\377\374\374\374\377\203\377\377"
		"\377\377\004\376\376\376\377\263\263\263\377\003\003\003\377\001\001\001\377\203\000\000\000"
		"\377\003\003\003\003\377\000\000\000\377\001\001\001\377\206\000\000\000\377\002\040\040\040\377\345\345"
		"\345\377\207\377\377\377\377\002\370\370\370\377///\377\210\000\000\000\377\010\002"
		"\002\002\377\000\000\000\377\001\001\001\377\000\000\000\377\003\003\003\377\002\002\002\377\321\321\321\377"
		"\376\376\376\377\202\377\377\377\377\002\375\375\375\377\376\376\376\377\203"
		"\377\377\377\377\013ooo\377\001\001\001\377\000\000\000\377\002\002\002\377\000\000\000\377\001\001\001"
		"\377\002\002\002\377\026\026\026\377\347\347\347\377\377\377\377\377\376\376\376\377"
		"\204\377\377\377\377\012\376\376\376\377\377\377\377\377\314\314\314\377\011"
		"\011\011\377\244\244\244\377\373\373\373\377\377\377\377\377\375\375\375\377"
		"\377\377\377\377\375\375\375\377\202\377\377\377\377\005\374\374\374\377\376"
		"\376\376\377NNN\377\000\000\000\377\003\003\003\377\205\000\000\000\377\007\347\034\000\377\377"
		"\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377"
		"\211\377\036\000\377\010\377\032\005\377\377\033\001\377\376\032\000\377\376\035\001\377"
		"\377\036\005\377\376\034\003\377\377\036\002\377\377\040\004\377\220\377\035\002\377\020"
		"\373\036\001\377\372\036\000\377\374\034\000\377\377\040\000\377\377\040\007\377\371\035"
		"\003\377\371\037\003\377\377\034\000\377\311\024\013\377(\011\000\377\000\001\000\377\006\000\007"
		"\377\000\001\000\377\004\000\000\377\000\003\000\377\001\000\005\377\220\000\000\000\377\010\000\001\000\377\001"
		"\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024"
		"\002\000\377\207\000\000\000\377\001\300\300\300\377\210\377\377\377\377\001hhh\377\203"
		"\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366"
		"\366\366\377\202\377\377\377\377\001\376\376\376\377\204\377\377\377\377\002"
		"\354\354\354\377\036\036\036\377\224\000\000\000\377\002\021\021\021\377\325\325\325\377"
		"\206\377\377\377\377\003\376\376\376\377\377\377\377\377EEE\377\215\000\000\000\377"
		"\013\005\005\005\377\243\243\243\377\365\365\365\377\361\361\361\377\360\360\360"
		"\377\363\363\363\377\360\360\360\377\357\357\357\377\364\364\364\377\363"
		"\363\363\377\204\204\204\377\202\001\001\001\377\205\000\000\000\377\004\001\001\001\377\002\002"
		"\002\377\001\001\001\377\204\204\204\377\202\377\377\377\377\003\376\376\376\377\377"
		"\377\377\377\376\376\376\377\203\377\377\377\377\016\310\310\310\377\012\012"
		"\012\377\000\000\000\377nnn\377\374\374\374\377\377\377\377\377\376\376\376\377"
		"\377\377\377\377\376\376\376\377\375\375\375\377\376\376\376\377\377\377"
		"\377\377\342\342\342\377\024\024\024\377\202\000\000\000\377\001\002\002\002\377\212\000\000\000"
		"\377\002\040\040\040\377\345\345\345\377\207\377\377\377\377\002\370\370\370\377"
		"///\377\211\000\000\000\377\002\004\004\004\377\002\002\002\377\202\000\000\000\377\013\012\012\012\377"
		"\276\276\276\377\367\367\367\377\356\356\356\377\357\357\357\377\365\365"
		"\365\377\361\361\361\377\355\355\355\377\364\364\364\377\356\356\356\377"
		"ooo\377\202\000\000\000\377\001\001\001\001\377\203\000\000\000\377\002\004\004\004\377\210\210\210\377"
		"\202\377\377\377\377\001\375\375\375\377\202\377\377\377\377\010\374\374\374"
		"\377\375\375\375\377\377\377\377\377\373\373\373\377\204\204\204\377\344"
		"\344\344\377\377\377\377\377\373\373\373\377\203\377\377\377\377\001\376\376"
		"\376\377\202\377\377\377\377\002\313\313\313\377\005\005\005\377\207\000\000\000\377\007"
		"\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034"
		"\002\377\376\037\000\377\211\377\036\000\377\010\375\036\000\377\374!\003\377\377\034\001"
		"\377\377\034\000\377\375!\000\377\373\037\000\377\376\033\000\377\377\037\003\377\220\375"
		"\036\000\377\020\375\035\004\377\377\"\010\377\371\040\001\377\370\037\000\377\372\040\000"
		"\377\375\040\003\377\371!\010\377\322\025\000\377\061\003\003\377\000\001\000\377\002\004\003\377"
		"\000\005\003\377\000\005\000\377\005\005\000\377\000\003\000\377\006\000\002\377\220\000\000\000\377\010\000\001\000"
		"\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377"
		"\024\002\000\377\207\000\000\000\377\001\300\300\300\377\210\377\377\377\377\001hhh\377"
		"\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377\002)))\377"
		"\366\366\366\377\202\377\377\377\377\001\376\376\376\377\204\377\377\377\377"
		"\002\354\354\354\377\036\036\036\377\224\000\000\000\377\002\021\021\021\377\325\325\325"
		"\377\206\377\377\377\377\003\376\376\376\377\377\377\377\377EEE\377\211\000\000"
		"\000\377\001\003\003\003\377\204\000\000\000\377\005\034\034\034\377---\377&&&\377'''\377%%%\377"
		"\202(((\377\005%%%\377(((\377\025\025\025\377\000\000\000\377\001\001\001\377\202\000\000\000\377"
		"\001\001\001\001\377\204\000\000\000\377\006\006\006\006\377\275\275\275\377\377\377\377\377\376"
		"\376\376\377\377\377\377\377\376\376\376\377\202\377\377\377\377\011\375\375"
		"\375\377\377\377\377\377\226\226\226\377\003\003\003\377\000\000\000\377\066\066\066\377"
		"\366\366\366\377\377\377\377\377\376\376\376\377\204\377\377\377\377\003\375"
		"\375\375\377\377\377\377\377AAA\377\205\000\000\000\377\002\002\002\002\377\001\001\001\377\206"
		"\000\000\000\377\002\040\040\040\377\345\345\345\377\207\377\377\377\377\002\370\370\370"
		"\377///\377\210\000\000\000\377\001\002\002\002\377\203\000\000\000\377\007\001\001\001\377\000\000\000\377"
		"\"\"\"\377'''\377+++\377'''\377(((\377\202&&&\377\003%%%\377...\377\017\017\017"
		"\377\203\000\000\000\377\001\002\002\002\377\203\000\000\000\377\005(((\377\361\361\361\377\376"
		"\376\376\377\377\377\377\377\375\375\375\377\203\377\377\377\377\003\374\374"
		"\374\377\377\377\377\377\367\367\367\377\204\377\377\377\377\001\374\374\374"
		"\377\204\377\377\377\377\003^^^\377\000\000\000\377\007\007\007\377\206\000\000\000\377\007\347"
		"\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377"
		"\376\037\000\377\211\377\036\000\377\010\376\036\000\377\356!\002\377\377\036\010\377\377"
		"\033\000\377\376\035\000\377\377\040\002\377\377\034\000\377\374\037\005\377\220\374\037"
		"\002\377\020\377\"\000\377\377\025\001\377\374\040\010\377\377\040\006\377\377\033\000\377"
		"\377\035\015\377\315\016\023\377!\007\000\377\000\001\007\377\006\000\007\377\000\005\003\377\000\002\000"
		"\377\004\000\000\377\000\002\001\377\001\000\000\377\000\004\000\377\220\000\000\000\377\010\000\001\000\377\001"
		"\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024"
		"\002\000\377\207\000\000\000\377\001\300\300\300\377\210\377\377\377\377\001hhh\377\203"
		"\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366"
		"\366\366\377\202\377\377\377\377\001\376\376\376\377\204\377\377\377\377\002"
		"\354\354\354\377\036\036\036\377\224\000\000\000\377\002\021\021\021\377\325\325\325\377"
		"\206\377\377\377\377\003\376\376\376\377\377\377\377\377EEE\377\212\000\000\000\377"
		"\001\001\001\001\377\202\000\000\000\377\001\006\006\006\377\203\000\000\000\377\001\002\002\002\377\203\000\000"
		"\000\377\002\003\003\003\377\001\001\001\377\204\000\000\000\377\202\001\001\001\377\204\000\000\000\377\006"
		"\031\031\031\377\351\351\351\377\377\377\377\377\376\376\376\377\377\377\377"
		"\377\376\376\376\377\202\377\377\377\377\003\375\375\375\377\377\377\377\377"
		"ZZZ\377\202\000\000\000\377\002\016\016\016\377\336\336\336\377\202\377\377\377\377"
		"\001\376\376\376\377\203\377\377\377\377\003\373\373\373\377\377\377\377\377"
		"{{{\377\203\000\000\000\377\001\002\002\002\377\203\000\000\000\377\001\001\001\001\377\205\000\000\000\377"
		"\002\040\040\040\377\345\345\345\377\207\377\377\377\377\002\370\370\370\377///"
		"\377\211\000\000\000\377\001\001\001\001\377\205\000\000\000\377\001\002\002\002\377\204\000\000\000\377\001"
		"\003\003\003\377\202\000\000\000\377\012\001\001\001\377\000\000\000\377\001\001\001\377\000\000\000\377\001\001\001"
		"\377\000\000\000\377\002\002\002\377\001\001\001\377\000\000\000\377\231\231\231\377\202\377\377"
		"\377\377\002\373\373\373\377\376\376\376\377\203\377\377\377\377\001\374\374"
		"\374\377\203\377\377\377\377\003\375\375\375\377\377\377\377\377\376\376\376"
		"\377\202\377\377\377\377\006\373\373\373\377\330\330\330\377\015\015\015\377\002"
		"\002\002\377\000\000\000\377\001\001\001\377\205\000\000\000\377\007\347\034\000\377\377\036\002\377\377"
		"\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036"
		"\000\377\010\353\032\000\377\247\022\000\377\265\022\003\377\256\025\000\377\256\022\000\377"
		"\264\024\000\377\271\020\000\377\253\022\000\377\220\257\023\000\377\020\254\023\000\377"
		"\256\030\000\377\260\020\000\377\241\024\000\377\273\025\000\377\230\021\000\377\036\016\000"
		"\377\000\002\000\377\010\000\005\377\000\001\000\377\000\005\000\377\004\000\000\377\012\000\006\377\000\000\007"
		"\377\000\001\005\377\000\002\000\377\220\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375"
		"\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377"
		"\001\300\300\300\377\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377"
		"\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366\366\366\377\202\377"
		"\377\377\377\001\376\376\376\377\204\377\377\377\377\002\354\354\354\377\036\036"
		"\036\377\224\000\000\000\377\002\021\021\021\377\325\325\325\377\206\377\377\377\377"
		"\003\376\376\376\377\377\377\377\377EEE\377\211\000\000\000\377\003\001\001\001\377\000\000\000"
		"\377\002\002\002\377\203\000\000\000\377\001\001\001\001\377\202\000\000\000\377\002\001\001\001\377\002\002\002"
		"\377\204\000\000\000\377\001\002\002\002\377\205\000\000\000\377\001\001\001\001\377\202\002\002\002\377\001"
		"DDD\377\210\377\377\377\377\002\366\366\366\377(((\377\202\000\000\000\377\007\003\003"
		"\003\377\260\260\260\377\376\376\376\377\377\377\377\377\376\376\376\377\377"
		"\377\377\377\374\374\374\377\202\377\377\377\377\006\374\374\374\377\256\256"
		"\256\377\001\001\001\377\002\002\002\377\000\000\000\377\002\002\002\377\211\000\000\000\377\002\040\040\040"
		"\377\345\345\345\377\207\377\377\377\377\002\370\370\370\377///\377\214\000\000"
		"\000\377\002\003\003\003\377\001\001\001\377\202\000\000\000\377\001\001\001\001\377\204\000\000\000\377\202"
		"\003\003\003\377\002\000\000\000\377\001\001\001\377\205\000\000\000\377\004\002\002\002\377\000\000\000\377\067\067"
		"\067\377\371\371\371\377\202\377\377\377\377\003\376\376\376\377\377\377\377"
		"\377\373\373\373\377\202\377\377\377\377\002\373\373\373\377\374\374\374\377"
		"\204\377\377\377\377\001\376\376\376\377\202\377\377\377\377\002ttt\377\003\003\003"
		"\377\202\000\000\000\377\002\001\001\001\377\002\002\002\377\204\000\000\000\377\007\347\034\000\377\377"
		"\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377"
		"\211\377\036\000\377\010\211\024\015\377\006\000\000\377\001\000\005\377\000\010\000\377\000\004\000\377"
		"\000\003\000\377\003\000\000\377\000\002\004\377\220\000\001\000\377\020\000\006\006\377\000\001\004\377\010\002"
		"\004\377\003\002\000\377\000\001\000\377\000\002\001\377\000\000\005\377\007\000\016\377\000\004\000\377\004\000\000"
		"\377\005\005\000\377\000\002\001\377\000\000\007\377\000\002\013\377\000\003\006\377\006\000\000\377\220\000\000"
		"\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000"
		"\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300\377\210\377\377"
		"\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203"
		"\000\000\000\377\002)))\377\366\366\366\377\202\377\377\377\377\001\376\376\376\377"
		"\204\377\377\377\377\002\354\354\354\377\036\036\036\377\224\000\000\000\377\002\021\021"
		"\021\377\325\325\325\377\206\377\377\377\377\003\376\376\376\377\377\377\377"
		"\377EEE\377\211\000\000\000\377\001\001\001\001\377\202\000\000\000\377\006\003\003\003\377\001\001\001\377"
		"\002\002\002\377\000\000\000\377\003\003\003\377\001\001\001\377\202\000\000\000\377\002\001\001\001\377\005\005\005"
		"\377\207\000\000\000\377\202\001\001\001\377\202\000\000\000\377\003|||\377\377\377\377\377\376"
		"\376\376\377\205\377\377\377\377\003\375\375\375\377\322\322\322\377\012\012"
		"\012\377\202\000\000\000\377\002\001\001\001\377rrr\377\203\377\377\377\377\003\376\376\376"
		"\377\377\377\377\377\375\375\375\377\202\377\377\377\377\002\336\336\336\377"
		"\021\021\021\377\202\000\000\000\377\001\001\001\001\377\202\000\000\000\377\001\003\003\003\377\206\000\000"
		"\000\377\002\040\040\040\377\345\345\345\377\207\377\377\377\377\002\370\370\370\377"
		"///\377\210\000\000\000\377\003\001\001\001\377\000\000\000\377\003\003\003\377\202\000\000\000\377\004\002\002"
		"\002\377\000\000\000\377\003\003\003\377\002\002\002\377\202\000\000\000\377\001\003\003\003\377\203\000\000\000"
		"\377\002\002\002\002\377\001\001\001\377\203\000\000\000\377\001\002\002\002\377\202\000\000\000\377\202\002"
		"\002\002\377\001\250\250\250\377\202\377\377\377\377\002\376\376\376\377\377\377"
		"\377\377\202\376\376\376\377\202\377\377\377\377\004\376\376\376\377\375\375"
		"\375\377\377\377\377\377\376\376\376\377\202\377\377\377\377\006\375\375\375"
		"\377\342\342\342\377\027\027\027\377\001\001\001\377\000\000\000\377\006\006\006\377\206\000\000\000"
		"\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377"
		"\034\002\377\376\037\000\377\211\377\036\000\377\010\241\023\007\377\003\000\000\377\001\000\013"
		"\377\000\002\000\377\000\000\004\377\000\002\004\377\003\000\000\377\000\002\010\377\220\000\000\002\377\011"
		"\012\000\000\377\003\000\000\377\000\003\000\377\000\001\000\377\000\000\002\377\003\001\006\377\003\000\002\377\000"
		"\002\000\377\004\005\000\377\202\000\003\000\377\005\001\000\000\377\000\001\005\377\000\003\006\377\003\000\002\377"
		"\003\002\000\377\220\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374"
		"\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300"
		"\377\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377"
		"\001\001\001\001\377\203\000\000\000\377\002)))\377\366\366\366\377\202\377\377\377\377\001"
		"\376\376\376\377\204\377\377\377\377\002\354\354\354\377\036\036\036\377\224\000"
		"\000\000\377\002\021\021\021\377\325\325\325\377\206\377\377\377\377\003\376\376\376"
		"\377\377\377\377\377EEE\377\212\000\000\000\377\001\002\002\002\377\202\000\000\000\377\004\002\002"
		"\002\377\003\003\003\377\000\000\000\377\001\001\001\377\202\002\002\002\377\203\000\000\000\377\002\002\002\002"
		"\377\001\001\001\377\202\000\000\000\377\001\001\001\001\377\202\000\000\000\377\001\002\002\002\377\202\000"
		"\000\000\377\005\003\003\003\377\267\267\267\377\375\375\375\377\376\376\376\377\377"
		"\377\377\377\202\376\376\376\377\005\377\377\377\377\376\376\376\377\377\377"
		"\377\377\235\235\235\377\002\002\002\377\203\000\000\000\377\002>>>\377\375\375\375\377"
		"\202\376\376\376\377\203\377\377\377\377\004\373\373\373\377\377\377\377\377"
		"\374\374\374\377===\377\205\000\000\000\377\001\002\002\002\377\206\000\000\000\377\002\040\040\040"
		"\377\345\345\345\377\207\377\377\377\377\002\370\370\370\377///\377\211\000\000"
		"\000\377\003\003\003\003\377\000\000\000\377\001\001\001\377\202\000\000\000\377\001\002\002\002\377\202\000\000"
		"\000\377\001\001\001\001\377\202\000\000\000\377\202\002\002\002\377\205\000\000\000\377\013\001\001\001\377"
		"\002\002\002\377\001\001\001\377\000\000\000\377\002\002\002\377\000\000\000\377BBB\377\367\367\367\377"
		"\377\377\377\377\376\376\376\377\374\374\374\377\203\377\377\377\377\001\371"
		"\371\371\377\202\377\377\377\377\001\372\372\372\377\202\377\377\377\377\011"
		"\376\376\376\377\377\377\377\377\204\204\204\377\002\002\002\377\000\000\000\377\001\001"
		"\001\377\000\000\000\377\003\003\003\377\001\001\001\377\204\000\000\000\377\007\347\034\000\377\377\036"
		"\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211"
		"\377\036\000\377\010\226\025\000\377\000\006\000\377\003\000\011\377\010\000\000\377\013\000\004\377"
		"\001\002\004\377\004\000\000\377\000\000\004\377\220\000\000\000\377\003\000\001\004\377\002\001\006\377\000\001\000"
		"\377\202\000\002\000\377\013\006\000\000\377\012\000\000\377\000\003\000\377\003\000\005\377\001\000\005\377"
		"\006\000\002\377\000\004\000\377\000\002\000\377\006\000\000\377\003\002\000\377\000\002\000\377\220\000\000\000\377"
		"\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335"
		"\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300\377\210\377\377\377\377"
		"\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377"
		"\002)))\377\366\366\366\377\202\377\377\377\377\001\376\376\376\377\204\377\377"
		"\377\377\002\354\354\354\377\036\036\036\377\224\000\000\000\377\002\021\021\021\377\325"
		"\325\325\377\206\377\377\377\377\003\376\376\376\377\377\377\377\377EEE\377"
		"\211\000\000\000\377\001\002\002\002\377\202\000\000\000\377\001\001\001\001\377\202\000\000\000\377\001\004\004"
		"\004\377\204\000\000\000\377\003\002\002\002\377\000\000\000\377\001\001\001\377\203\000\000\000\377\001\002\002"
		"\002\377\202\000\000\000\377\005\002\002\002\377\000\000\000\377\003\003\003\377\024\024\024\377\340\340"
		"\340\377\204\377\377\377\377\005\375\375\375\377\377\377\377\377\375\375\375"
		"\377\376\376\376\377jjj\377\202\000\000\000\377\005\002\002\002\377\000\000\000\377\030\030\030"
		"\377\341\341\341\377\376\376\376\377\202\377\377\377\377\001\373\373\373\377"
		"\202\377\377\377\377\003\375\375\375\377\377\377\377\377jjj\377\214\000\000\000\377"
		"\002\040\040\040\377\345\345\345\377\207\377\377\377\377\002\370\370\370\377///"
		"\377\213\000\000\000\377\003\001\001\001\377\000\000\000\377\003\003\003\377\202\000\000\000\377\004\001\001\001"
		"\377\000\000\000\377\004\004\004\377\001\001\001\377\202\000\000\000\377\001\003\003\003\377\202\000\000\000\377"
		"\001\001\001\001\377\203\000\000\000\377\001\001\001\001\377\203\000\000\000\377\003\003\003\003\377\301\301"
		"\301\377\376\376\376\377\203\377\377\377\377\004\376\376\376\377\375\375\375"
		"\377\377\377\377\377\374\374\374\377\202\377\377\377\377\202\376\376\376"
		"\377\010\377\377\377\377\355\355\355\377\040\040\040\377\002\002\002\377\000\000\000\377"
		"\002\002\002\377\000\000\000\377\001\001\001\377\205\000\000\000\377\007\347\034\000\377\377\036\002\377"
		"\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377"
		"\036\000\377\010\250\024\022\377H\007\000\377(\015\000\377<\006\004\377>\001\000\377\070\011\001\377"
		"\066\007\000\377=\006\001\377\210\070\010\000\377\030\067\016\000\377\061\004\001\377;\007\011\377"
		";\005\003\377\071\004\000\377\067\011\000\377\067\007\000\377\071\006\005\377G\011\000\377\025\001\000\377"
		"\002\002\000\377\000\001\004\377\000\004\000\377\003\002\000\377\010\000\000\377\000\001\000\377\000\004\007\377\010"
		"\000\006\377\000\003\001\377\000\001\000\377\006\004\011\377\000\003\004\377\000\000\000\377\006\000\000\377\220"
		"\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377"
		"\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300\377\210\377"
		"\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377"
		"\203\000\000\000\377\002)))\377\366\366\366\377\203\377\377\377\377\006\374\374\374"
		"\377\377\377\377\377\375\375\375\377\377\377\377\377\351\351\351\377\031\031"
		"\031\377\210\000\000\000\377\010\001\001\001\377\002\002\002\377\000\000\000\377\002\002\002\377\000\000\000\377"
		"\003\003\003\377\000\000\000\377\001\001\001\377\204\000\000\000\377\002\021\021\021\377\325\325\325\377"
		"\206\377\377\377\377\005\376\376\376\377\377\377\377\377EEE\377\000\000\000\377\001"
		"\001\001\377\205\000\000\000\377\203\001\001\001\377\207\000\000\000\377\001\001\001\001\377\202\000\000\000"
		"\377\003\002\002\002\377\000\000\000\377\003\003\003\377\202\000\000\000\377\001\002\002\002\377\202\000\000\000"
		"\377\002\001\001\001\377\002\002\002\377\202\000\000\000\377\002>>>\377\371\371\371\377\202\377"
		"\377\377\377\001\375\375\375\377\202\377\377\377\377\006\374\374\374\377\377"
		"\377\377\377\373\373\373\377\063\063\063\377\000\000\000\377\001\001\001\377\202\000\000\000\377"
		"\006\002\002\002\377\266\266\266\377\377\377\377\377\374\374\374\377\377\377\377"
		"\377\375\375\375\377\203\377\377\377\377\002\376\376\376\377\247\247\247\377"
		"\202\000\000\000\377\001\001\001\001\377\202\000\000\000\377\202\001\001\001\377\205\000\000\000\377\002\040"
		"\040\040\377\345\345\345\377\207\377\377\377\377\002\370\370\370\377///\377\241"
		"\000\000\000\377\002\003\003\003\377QQQ\377\202\377\377\377\377\001\373\373\373\377\202\377"
		"\377\377\377\001\376\376\376\377\204\377\377\377\377\001\374\374\374\377\202"
		"\377\377\377\377\010\226\226\226\377\001\001\001\377\000\000\000\377\001\001\001\377\000\000\000\377"
		"\001\001\001\377\000\000\000\377\002\002\002\377\204\000\000\000\377\007\347\034\000\377\377\036\002\377"
		"\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377"
		"\036\000\377\010\377\034\000\377\355\033\000\377\363\"\004\377\377\036\010\377\372\035\003"
		"\377\366$\003\377\366\040\000\377\374\037\002\377\210\373\036\003\377\030\366\032\002\377"
		"\377#\003\377\374\032\001\377\372\037\001\377\365$\000\377\373\040\002\377\366\040\006\377"
		"\377\034\000\377\302\022\034\377\061\006\000\377\000\004\000\377\010\000\010\377\001\000\010\377\000"
		"\002\005\377\004\000\005\377\002\001\011\377\005\000\000\377\015\000\000\377\000\003\000\377\004\000\000\377\007"
		"\000\000\377\004\000\000\377\001\000\000\377\000\000\002\377\220\000\000\000\377\010\000\001\000\377\001\000\000\377"
		"A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377"
		"\207\000\000\000\377\001\300\300\300\377\210\377\377\377\377\001hhh\377\203\000\000\000\377"
		"\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377\004)))\377\366\366\366"
		"\377\377\377\377\377\374\374\374\377\202\377\377\377\377\002\375\375\375\377"
		"\377\377\377\377\202\375\375\375\377\001\275\275\275\377\210\267\267\267\377"
		"\002\271\271\271\377\266\266\266\377\202\270\270\270\377\003\274\274\274\377"
		"\253\253\253\377$$$\377\205\000\000\000\377\002\021\021\021\377\325\325\325\377\206"
		"\377\377\377\377\003\376\376\376\377\377\377\377\377EEE\377\203\000\000\000\377\001"
		"\001\001\001\377\203\000\000\000\377\004\001\001\001\377\177\177\177\377\273\273\273\377\272"
		"\272\272\377\205\271\271\271\377\011\270\270\270\377\267\267\267\377\271\271"
		"\271\377\267\267\267\377\264\264\264\377\271\271\271\377\272\272\272\377"
		"fff\377\001\001\001\377\206\000\000\000\377\005\002\002\002\377ppp\377\377\377\377\377\376\376"
		"\376\377\374\374\374\377\205\377\377\377\377\002\327\327\327\377\021\021\021\377"
		"\203\000\000\000\377\202\001\001\001\377\001\177\177\177\377\210\377\377\377\377\006\324"
		"\324\324\377\017\017\017\377\002\002\002\377\000\000\000\377\002\002\002\377\001\001\001\377\207\000\000"
		"\000\377\002\040\040\040\377\345\345\345\377\207\377\377\377\377\002\370\370\370\377"
		"///\377\242\000\000\000\377\003\020\020\020\377\312\312\312\377\375\375\375\377\202"
		"\377\377\377\377\005\373\373\373\377\376\376\376\377\377\377\377\377\376\376"
		"\376\377\375\375\375\377\203\377\377\377\377\004\366\366\366\377\062\062\062\377"
		"\000\000\000\377\002\002\002\377\203\000\000\000\377\001\003\003\003\377\205\000\000\000\377\007\347\034\000\377"
		"\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037"
		"\000\377\211\377\036\000\377\010\363!\000\377\372!\002\377\377\034\007\377\377\027\002\377"
		"\377\033\000\377\376\040\000\377\377\034\000\377\377\036\000\377\210\377\035\000\377\030"
		"\377\033\005\377\377\026\002\377\374\033\000\377\377\"\000\377\377\031\000\377\377\032\000"
		"\377\377\"\013\377\304\026\000\377!\002\000\377\000\001\000\377\000\000\002\377\010\000\004\377\000"
		"\001\000\377\002\003\000\377\005\000\000\377\000\001\000\377\000\005\000\377\006\000\000\377\000\005\002\377\004\000"
		"\003\377\000\001\004\377\000\002\005\377\000\001\004\377\002\000\005\377\220\000\000\000\377\010\000\001\000\377"
		"\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024"
		"\002\000\377\207\000\000\000\377\001\300\300\300\377\210\377\377\377\377\001hhh\377\203"
		"\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366"
		"\366\366\377\202\377\377\377\377\003\373\373\373\377\377\377\377\377\374\374"
		"\374\377\202\377\377\377\377\001\375\375\375\377\212\377\377\377\377\006\376"
		"\376\376\377\377\377\377\377\374\374\374\377\377\377\377\377\371\371\371"
		"\377---\377\205\000\000\000\377\002\021\021\021\377\325\325\325\377\206\377\377\377"
		"\377\014\376\376\376\377\377\377\377\377EEE\377\000\000\000\377\002\002\002\377\000\000\000"
		"\377\002\002\002\377\001\001\001\377\000\000\000\377\001\001\001\377\000\000\000\377\273\273\273\377\206"
		"\377\377\377\377\202\376\376\376\377\001\374\374\374\377\202\377\377\377\377"
		"\001\376\376\376\377\202\377\377\377\377\001\217\217\217\377\203\000\000\000\377\001"
		"\002\002\002\377\203\000\000\000\377\007\001\001\001\377\251\251\251\377\377\377\377\377\376"
		"\376\376\377\375\375\375\377\377\377\377\377\375\375\375\377\202\376\376"
		"\376\377\003\374\374\374\377\247\247\247\377\000\000\000\377\202\001\001\001\377\001\000\000"
		"\000\377\202\001\001\001\377\004FFF\377\374\374\374\377\377\377\377\377\375\375\375"
		"\377\204\377\377\377\377\006\376\376\376\377\370\370\370\377---\377\004\004\004\377"
		"\000\000\000\377\002\002\002\377\210\000\000\000\377\002\040\040\040\377\345\345\345\377\207\377"
		"\377\377\377\002\370\370\370\377///\377\240\000\000\000\377\202\001\001\001\377\005\000\000\000"
		"\377hhh\377\377\377\377\377\374\374\374\377\376\376\376\377\204\377\377\377"
		"\377\005\374\374\374\377\377\377\377\377\375\375\375\377\377\377\377\377\252"
		"\252\252\377\202\000\000\000\377\005\004\004\004\377\000\000\000\377\002\002\002\377\000\000\000\377\002\002"
		"\002\377\205\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377"
		"\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\010\377\036\005\377"
		"\377\037\006\377\377\032\000\377\376\035\000\377\375!\000\377\376\036\000\377\377\034\000"
		"\377\375\036\000\377\210\377\035\000\377\030\372\040\000\377\377\035\006\377\377!\010\377"
		"\363#\000\377\377\037\000\377\377\034\000\377\277\025\006\377\"\005\000\377\000\003\000\377\000"
		"\002\001\377\003\003\003\377\000\001\000\377\000\005\000\377\000\004\000\377\000\000\000\377\007\002\011\377\000\000"
		"\002\377\006\000\000\377\000\004\000\377\001\001\003\377\000\005\006\377\003\004\011\377\000\001\004\377\004\000\000"
		"\377\220\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000"
		"\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300\377"
		"\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001"
		"\001\001\377\203\000\000\000\377\002)))\377\366\366\366\377\202\377\377\377\377\001\375"
		"\375\375\377\202\377\377\377\377\004\376\376\376\377\377\377\377\377\374\374"
		"\374\377\376\376\376\377\213\377\377\377\377\005\375\375\375\377\374\374\374"
		"\377\361\361\361\377+++\377\001\001\001\377\204\000\000\000\377\002\021\021\021\377\325\325"
		"\325\377\206\377\377\377\377\003\376\376\376\377\377\377\377\377EEE\377\202"
		"\000\000\000\377\007\001\001\001\377\000\000\000\377\002\002\002\377\000\000\000\377\004\004\004\377\001\001\001\377"
		"\260\260\260\377\211\377\377\377\377\001\376\376\376\377\203\377\377\377\377"
		"\002\373\373\373\377\212\212\212\377\203\001\001\001\377\007\002\002\002\377\000\000\000\377\001"
		"\001\001\377\000\000\000\377\017\017\017\377\332\332\332\377\376\376\376\377\203\377\377"
		"\377\377\001\374\374\374\377\203\377\377\377\377\003sss\377\000\000\000\377\003\003\003\377"
		"\204\000\000\000\377\004\034\034\034\377\351\351\351\377\377\377\377\377\375\375\375"
		"\377\205\377\377\377\377\003\376\376\376\377```\377\001\001\001\377\203\000\000\000\377"
		"\202\001\001\001\377\205\000\000\000\377\002\040\040\040\377\345\345\345\377\207\377\377\377"
		"\377\002\370\370\370\377///\377\242\000\000\000\377\005\001\001\001\377\020\020\020\377\335"
		"\335\335\377\375\375\375\377\376\376\376\377\206\377\377\377\377\004\376\376"
		"\376\377\373\373\373\377BBB\377\002\002\002\377\204\000\000\000\377\003\001\001\001\377\000\000\000"
		"\377\002\002\002\377\204\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373"
		"\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\010\377"
		"\026\003\377\377\032\003\377\375\036\000\377\375\"\002\377\377\040\001\377\375\033\002\377"
		"\377\036\005\377\377\035\006\377\210\373\040\002\377\030\371\036\002\377\377#\000\377\377"
		"\032\000\377\377\036\005\377\367\"\004\377\312\025\016\377\031\002\000\377\000\000\011\377\010"
		"\004\000\377\000\007\000\377\000\000\000\377\015\000\002\377\007\002\010\377\000\000\004\377\003\000\004\377\000"
		"\001\006\377\000\003\002\377\003\004\006\377\003\000\000\377\010\000\000\377\000\003\000\377\000\002\000\377\000\004"
		"\000\377\000\005\002\377\220\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377"
		"\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300"
		"\300\377\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000"
		"\377\001\001\001\001\377\203\000\000\000\377\006)))\377\366\366\366\377\377\377\377\377\375"
		"\375\375\377\377\377\377\377\374\374\374\377\202\377\377\377\377\002\376\376"
		"\376\377\375\375\375\377\211\377\377\377\377\203\376\376\376\377\202\377"
		"\377\377\377\002\355\355\355\377///\377\205\000\000\000\377\002\021\021\021\377\325\325"
		"\325\377\206\377\377\377\377\003\376\376\376\377\377\377\377\377EEE\377\202"
		"\000\000\000\377\001\004\004\004\377\202\000\000\000\377\004\003\003\003\377\000\000\000\377\002\002\002\377\262"
		"\262\262\377\204\377\377\377\377\204\376\376\376\377\001\377\377\377\377\203"
		"\376\376\376\377\202\377\377\377\377\003\211\211\211\377\000\000\000\377\001\001\001\377"
		"\203\000\000\000\377\202\001\001\001\377\002\066\066\066\377\373\373\373\377\202\377\377\377"
		"\377\002\376\376\376\377\375\375\375\377\202\377\377\377\377\003\375\375\375"
		"\377\372\372\372\377>>>\377\204\000\000\000\377\006\002\002\002\377\000\000\000\377\002\002\002\377"
		"\272\272\272\377\377\377\377\377\376\376\376\377\202\377\377\377\377\001\376"
		"\376\376\377\202\377\377\377\377\004\376\376\376\377\235\235\235\377\000\000\000"
		"\377\005\005\005\377\202\000\000\000\377\001\001\001\001\377\206\000\000\000\377\002\040\040\040\377\345"
		"\345\345\377\207\377\377\377\377\002\370\370\370\377///\377\240\000\000\000\377\202"
		"\001\001\001\377\003\000\000\000\377\001\001\001\377uuu\377\202\377\377\377\377\003\376\376\376"
		"\377\377\377\377\377\375\375\375\377\204\377\377\377\377\002\271\271\271\377"
		"\005\005\005\377\203\000\000\000\377\003\001\001\001\377\000\000\000\377\003\003\003\377\206\000\000\000\377\007"
		"\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034"
		"\002\377\376\037\000\377\211\377\036\000\377\010\373!\000\377\374\"\000\377\370#\000\377"
		"\372\040\000\377\374\033\000\377\372\037\001\377\374#\004\377\377\034\000\377\210\377\035"
		"\000\377\014\376\040\000\377\377\040\000\377\374\036\000\377\374\035\000\377\301\026\005\377"
		"\014\002\000\377\001\005\010\377\000\003\000\377\003\000\005\377\000\000\005\377\002\000\005\377\001\000\002\377"
		"\202\000\003\000\377\012\001\003\000\377\000\002\000\377\000\001\000\377\000\004\005\377\003\000\013\377\003\000"
		"\011\377\006\001\005\377\007\000\000\377\010\000\001\377\004\000\004\377\220\000\000\000\377\010\000\001\000\377"
		"\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024"
		"\002\000\377\207\000\000\000\377\001\300\300\300\377\210\377\377\377\377\001hhh\377\203"
		"\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366"
		"\366\366\377\203\377\377\377\377\001\376\376\376\377\203\377\377\377\377\202"
		"\375\375\375\377\211\377\377\377\377\007\376\376\376\377\377\377\377\377\376"
		"\376\376\377\377\377\377\377\357\357\357\377,,,\377\001\001\001\377\204\000\000\000\377"
		"\002\021\021\021\377\325\325\325\377\206\377\377\377\377\004\376\376\376\377\377"
		"\377\377\377EEE\377\000\000\000\377\203\001\001\001\377\002\000\000\000\377\002\002\002\377\202\000\000"
		"\000\377\001\262\262\262\377\216\377\377\377\377\001\210\210\210\377\203\000\000\000"
		"\377\001\001\001\001\377\203\000\000\000\377\001jjj\377\202\377\377\377\377\001\376\376\376"
		"\377\203\377\377\377\377\004\376\376\376\377\374\374\374\377\343\343\343\377"
		"\025\025\025\377\202\000\000\000\377\006\005\005\005\377\000\000\000\377\002\002\002\377\001\001\001\377\000\000"
		"\000\377\207\207\207\377\203\376\376\376\377\203\377\377\377\377\004\376\376"
		"\376\377\377\377\377\377\316\316\316\377\004\004\004\377\203\001\001\001\377\207\000\000"
		"\000\377\002\040\040\040\377\345\345\345\377\207\377\377\377\377\002\370\370\370\377"
		"///\377\241\000\000\000\377\016\002\002\002\377\000\000\000\377\004\004\004\377\034\034\034\377\351\351"
		"\351\377\375\375\375\377\376\376\376\377\377\377\377\377\376\376\376\377"
		"\377\377\377\377\376\376\376\377\377\377\377\377\376\376\376\377ZZZ\377\202"
		"\000\000\000\377\004\004\004\004\377\000\000\000\377\001\001\001\377\000\000\000\377\202\001\001\001\377\205\000"
		"\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377"
		"\377\034\002\377\376\037\000\377\211\377\036\000\377\010\372\037\003\377\377\034\000\377"
		"\377\036\000\377\377\034\001\377\377\032\005\377\377\036\011\377\374\037\004\377\377\030"
		"\000\377\210\377\035\004\377\030\377\033\000\377\376\034\004\377\375#\010\377\277\024\002"
		"\377\031\001\000\377\004\002\020\377\010\000\005\377\000\001\000\377\003\000\011\377\001\000\004\377\000\003"
		"\000\377\000\004\000\377\010\000\000\377\007\000\000\377\000\000\002\377\007\000\004\377\004\004\004\377\000\005\000"
		"\377\027\002\000\377\004\000\000\377\003\000\000\377\000\003\002\377\000\001\005\377\000\002\004\377\220\000\000"
		"\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000"
		"\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300\377\210\377\377"
		"\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203"
		"\000\000\000\377\005)))\377\366\366\366\377\377\377\377\377\376\376\376\377\374\374"
		"\374\377\202\377\377\377\377\001\373\373\373\377\213\377\377\377\377\001\375"
		"\375\375\377\202\377\377\377\377\005\374\374\374\377\375\375\375\377\361\361"
		"\361\377)))\377\002\002\002\377\204\000\000\000\377\002\021\021\021\377\325\325\325\377\206"
		"\377\377\377\377\003\376\376\376\377\377\377\377\377EEE\377\203\000\000\000\377\001"
		"\001\001\001\377\202\000\000\000\377\003\003\003\003\377\001\001\001\377\257\257\257\377\202\376\376"
		"\376\377\202\377\377\377\377\204\376\376\376\377\001\377\377\377\377\202\375"
		"\375\375\377\203\377\377\377\377\001\210\210\210\377\203\000\000\000\377\001\002\002\002"
		"\377\202\000\000\000\377\003\003\003\003\377\244\244\244\377\375\375\375\377\204\377\377"
		"\377\377\202\376\376\376\377\002\377\377\377\377\267\267\267\377\203\000\000\000"
		"\377\001\002\002\002\377\202\000\000\000\377\202\001\001\001\377\002QQQ\377\373\373\373\377\205"
		"\377\377\377\377\010\374\374\374\377\377\377\377\377\357\357\357\377---\377"
		"\000\000\000\377\001\001\001\377\000\000\000\377\001\001\001\377\206\000\000\000\377\002\040\040\040\377\345"
		"\345\345\377\207\377\377\377\377\002\370\370\370\377///\377\241\000\000\000\377\001"
		"\001\001\001\377\202\000\000\000\377\002\016\016\016\377\335\335\335\377\202\377\377\377\377"
		"\001\376\376\376\377\205\377\377\377\377\004\071\071\071\377\005\005\005\377\000\000\000\377"
		"\002\002\002\377\202\000\000\000\377\001\001\001\001\377\202\000\000\000\377\001\002\002\002\377\204\000\000\000"
		"\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377"
		"\034\002\377\376\037\000\377\211\377\036\000\377\010\377\036\003\377\377\033\000\377\377"
		"!\000\377\371\040\000\377\377\034\004\377\377\033\003\377\366\035\000\377\376%\000\377\211"
		"\376\037\000\377\027\377\033\001\377\273\024\013\377%\002\000\377\000\000\004\377\000\003\004\377"
		"\000\004\000\377\000\002\001\377\000\001\000\377\006\002\001\377\004\000\000\377\000\000\004\377\000\002\005\377\000"
		"\000\004\377\003\000\000\377\000\004\000\377\000\002\013\377>\002\000\377\331\032\020\377\275\030\002\377"
		"k\013\000\377\013\007\000\377\000\001\000\377\002\001\000\377\220\000\000\000\377\010\000\001\000\377\001\000"
		"\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002"
		"\000\377\207\000\000\000\377\001\300\300\300\377\210\377\377\377\377\001hhh\377\203\000"
		"\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366"
		"\366\366\377\203\377\377\377\377\003\375\375\375\377\376\376\376\377\377\377"
		"\377\377\202\376\376\376\377\211\377\377\377\377\003\375\375\375\377\377\377"
		"\377\377\374\374\374\377\202\377\377\377\377\002\373\373\373\377\061\061\061\377"
		"\205\000\000\000\377\002\021\021\021\377\325\325\325\377\206\377\377\377\377\003\376\376"
		"\376\377\377\377\377\377EEE\377\202\000\000\000\377\001\004\004\004\377\203\000\000\000\377\004"
		"\001\001\001\377\000\000\000\377\275\275\275\377\376\376\376\377\210\377\377\377\377"
		"\001\376\376\376\377\202\377\377\377\377\005\374\374\374\377\377\377\377\377"
		"\211\211\211\377\000\000\000\377\001\001\001\377\203\000\000\000\377\003\001\001\001\377\013\013\013\377"
		"\322\322\322\377\202\377\377\377\377\002\375\375\375\377\376\376\376\377\203"
		"\377\377\377\377\010\375\375\375\377ttt\377\000\000\000\377\001\001\001\377\002\002\002\377"
		"\000\000\000\377\004\004\004\377\001\001\001\377\202\000\000\000\377\002\023\023\023\377\351\351\351\377"
		"\203\377\377\377\377\001\374\374\374\377\204\377\377\377\377\001\\\\\\\377\203"
		"\000\000\000\377\001\001\001\001\377\206\000\000\000\377\002\040\040\040\377\345\345\345\377\207\377"
		"\377\377\377\002\370\370\370\377///\377\240\000\000\000\377\010\002\002\002\377\000\000\000\377"
		"\002\002\002\377\000\000\000\377\017\017\017\377\336\336\336\377\377\377\377\377\376\376"
		"\376\377\202\377\377\377\377\005\375\375\375\377\377\377\377\377\375\375\375"
		"\377\372\372\372\377III\377\203\000\000\000\377\004\002\002\002\377\001\001\001\377\000\000\000\377"
		"\001\001\001\377\206\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037"
		"\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\010\377\"\000"
		"\377\333\032\010\377\367\031\004\377\353\033\001\377\356\035\000\377\355\033\000\377\351"
		"\040\002\377\357\031\000\377\210\354\034\000\377\027\370\033\000\377\251\032\012\377*\000"
		"\000\377\000\001\007\377\000\003\011\377\004\000\000\377\005\000\001\377\000\001\004\377\000\000\011\377\000\002"
		"\005\377\007\000\000\377\011\000\000\377\000\003\000\377\000\001\000\377\001\001\000\377\000\005\000\377\006\000\004"
		"\377\063\005\000\377\367\"\002\377\375\037\010\377\377\031\000\377\300\030\000\377+\006\000"
		"\377\202\000\000\002\377\007\000\002\001\377\006\000\000\377\000\001\000\377\000\002\002\377\001\000\002\377\000"
		"\001\000\377\005\000\000\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000"
		"\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300"
		"\300\300\377\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000"
		"\000\000\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366\366\366\377\204\377\377\377"
		"\377\005\373\373\373\377\377\377\377\377\376\376\376\377\367\367\367\377\225"
		"\225\225\377\213\211\211\211\377\004\207\207\207\377\217\217\217\377\177\177"
		"\177\377\033\033\033\377\205\000\000\000\377\002\021\021\021\377\325\325\325\377\206\377"
		"\377\377\377\003\376\376\376\377\377\377\377\377EEE\377\203\000\000\000\377\003\001\001"
		"\001\377\000\000\000\377\003\003\003\377\202\000\000\000\377\010```\377\214\214\214\377\211\211"
		"\211\377\212\212\212\377\213\213\213\377\203\203\203\377\337\337\337\377"
		"\376\376\376\377\203\377\377\377\377\001\376\376\376\377\203\377\377\377\377"
		"\005\210\210\210\377\000\000\000\377\002\002\002\377\000\000\000\377\001\001\001\377\202\000\000\000\377"
		"\002...\377\370\370\370\377\202\377\377\377\377\003\376\376\376\377\377\377\377"
		"\377\374\374\374\377\202\377\377\377\377\004\374\374\374\377\246\246\246\377"
		"xxx\377yyy\377\204zzz\377\001yyy\377\202xxx\377\003\350\350\350\377\376\376\376"
		"\377\375\375\375\377\202\377\377\377\377\002\375\375\375\377\376\376\376\377"
		"\202\377\377\377\377\001\222\222\222\377\202\000\000\000\377\003\002\002\002\377\000\000\000\377"
		"\002\002\002\377\205\000\000\000\377\002\040\040\040\377\345\345\345\377\207\377\377\377\377"
		"\002\370\370\370\377///\377\210\000\000\000\377\001\001\001\001\377\202\000\000\000\377\003\004\004\004"
		"\377\000\000\000\377\001\001\001\377\203\000\000\000\377\002\003\003\003\377\002\002\002\377\203\000\000\000\377"
		"\001\001\001\001\377\212\000\000\000\377\001\001\001\001\377\202\000\000\000\377\002\020\020\020\377\336\336"
		"\336\377\207\377\377\377\377\002\373\373\373\377EEE\377\215\000\000\000\377\007\347"
		"\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377"
		"\376\037\000\377\211\377\036\000\377\010\231\025\006\377\062\005\010\377*\003\000\377$\005\000"
		"\377-\005\000\377+\003\003\377)\010\003\377+\002\000\377\210(\005\000\377\040\"\007\000\377\021\007"
		"\000\377\000\001\004\377\000\001\005\377\004\000\000\377\006\000\000\377\001\000\000\377\000\004\000\377\007\000\000"
		"\377\000\003\001\377\000\001\000\377\005\000\004\377\001\000\005\377\004\000\007\377\012\000\005\377\006\000\004\377"
		"\000\003\006\377\063\007\000\377\361\037\000\377\377\036\005\377\377\032\006\377\371\040\000\377"
		"\274\031\012\377\030\002\005\377\000\000\000\377\000\001\000\377\004\000\000\377\000\001\000\377\000\002\002\377"
		"\003\000\002\377\000\001\000\377\003\000\000\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003"
		"\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000"
		"\000\000\377\001\300\300\300\377\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001"
		"\001\001\377\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377\004)))\377\366\366\366\377"
		"\377\377\377\377\374\374\374\377\203\377\377\377\377\004\375\375\375\377\377"
		"\377\377\377\345\345\345\377\026\026\026\377\211\000\000\000\377\001\003\003\003\377\203\000"
		"\000\000\377\003\007\007\007\377\000\000\000\377\001\001\001\377\204\000\000\000\377\002\021\021\021\377\325"
		"\325\325\377\206\377\377\377\377\004\376\376\376\377\377\377\377\377EEE\377"
		"\000\000\000\377\202\002\002\002\377\203\000\000\000\377\001\004\004\004\377\202\000\000\000\377\001\002\002\002"
		"\377\203\000\000\000\377\003\005\005\005\377\251\251\251\377\375\375\375\377\203\377\377"
		"\377\377\001\376\376\376\377\203\377\377\377\377\001\210\210\210\377\205\000\000"
		"\000\377\003\001\001\001\377```\377\377\377\377\377\202\376\376\376\377\202\377\377"
		"\377\377\006\376\376\376\377\377\377\377\377\374\374\374\377\377\377\377\377"
		"\372\372\372\377\376\376\376\377\206\377\377\377\377\002\376\376\376\377\375"
		"\375\375\377\203\377\377\377\377\001\375\375\375\377\204\377\377\377\377\005"
		"\376\376\376\377\303\303\303\377\012\012\012\377\000\000\000\377\002\002\002\377\207\000\000"
		"\000\377\002\040\040\040\377\345\345\345\377\207\377\377\377\377\002\370\370\370\377"
		"///\377\210\000\000\000\377\002\002\002\002\377\001\001\001\377\204\000\000\000\377\003\001\001\001\377\000\000"
		"\000\377\002\002\002\377\205\000\000\000\377\001\001\001\001\377\212\000\000\000\377\001\001\001\001\377\202"
		"\000\000\000\377\002\020\020\020\377\336\336\336\377\207\377\377\377\377\002\373\373\373"
		"\377EEE\377\215\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037"
		"\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\010\244\014"
		"\011\377\011\000\000\377\000\004\000\377\000\000\005\377\003\000\000\377\000\000\005\377\001\002\007\377\004\000"
		"\005\377\210\000\000\002\377\033\000\002\013\377\000\000\011\377\002\001\007\377\004\002\003\377\001\000\000\377"
		"\002\001\000\377\001\000\000\377\002\000\006\377\007\000\000\377\000\003\000\377\000\003\004\377\002\001\006\377\001"
		"\000\005\377\001\001\003\377\003\001\006\377\000\000\005\377\000\001\003\377I\006\000\377\377\036\007\377\377"
		"\036\000\377\375\034\000\377\375!\000\377\377\040\006\377\177\011\005\377\004\000\000\377\000\003"
		"\000\377\003\000\000\377\202\000\000\002\377\003\003\000\000\377\000\001\000\377\001\000\000\377\210\000\000\000"
		"\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377"
		"\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300\377\210\377\377\377"
		"\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203\000\000"
		"\000\377\002)))\377\366\366\366\377\203\377\377\377\377\006\371\371\371\377\377"
		"\377\377\377\375\375\375\377\377\377\377\377\360\360\360\377\032\032\032\377"
		"\213\000\000\000\377\001\003\003\003\377\202\000\000\000\377\001\004\004\004\377\205\000\000\000\377\002\021\021"
		"\021\377\325\325\325\377\206\377\377\377\377\003\376\376\376\377\377\377\377"
		"\377EEE\377\202\000\000\000\377\003\001\001\001\377\000\000\000\377\006\006\006\377\202\000\000\000\377\001"
		"\004\004\004\377\203\000\000\000\377\006\002\002\002\377\001\001\001\377\000\000\000\377\260\260\260\377"
		"\377\377\377\377\374\374\374\377\202\377\377\377\377\001\376\376\376\377\203"
		"\377\377\377\377\001\210\210\210\377\202\000\000\000\377\001\002\002\002\377\203\000\000\000\377"
		"\001\233\233\233\377\203\377\377\377\377\001\375\375\375\377\203\377\377\377"
		"\377\002\374\374\374\377\376\376\376\377\212\377\377\377\377\002\372\372\372"
		"\377\376\376\376\377\203\377\377\377\377\001\376\376\376\377\202\377\377\377"
		"\377\004\375\375\375\377\360\360\360\377\040\040\040\377\003\003\003\377\210\000\000\000\377"
		"\002\040\040\040\377\345\345\345\377\207\377\377\377\377\002\370\370\370\377///"
		"\377\211\000\000\000\377\003\003\003\003\377\000\000\000\377\003\003\003\377\204\000\000\000\377\004\002\002\002"
		"\377\000\000\000\377\002\002\002\377\003\003\003\377\215\000\000\000\377\001\001\001\001\377\202\000\000\000\377"
		"\002\020\020\020\377\336\336\336\377\207\377\377\377\377\002\373\373\373\377EEE"
		"\377\215\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377"
		"\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\010\235\016\000\377"
		"\000\002\000\377\000\006\000\377\006\000\006\377\001\000\000\377\000\002\002\377\000\000\000\377\004\000\000\377\210"
		"\001\000\000\377\006\012\000\002\377\004\000\000\377\000\001\000\377\000\002\000\377\000\000\000\377\001\001\003\377"
		"\202\000\000\004\377\004\001\000\000\377\000\000\002\377\000\001\002\377\000\000\000\377\202\000\002\000\377\020"
		"\000\003\000\377\000\002\000\377\000\000\005\377\211\016\000\377\375\040\005\377\365\"\000\377\377"
		"\040\001\377\366\037\000\377\376\037\000\377\323\027\000\377\016\000\000\377\000\004\000\377\001\001"
		"\001\377\001\000\002\377\000\001\000\377\004\000\000\377\202\000\001\000\377\210\000\000\000\377\010\000\001\000"
		"\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377"
		"\024\002\000\377\207\000\000\000\377\001\300\300\300\377\210\377\377\377\377\001hhh\377"
		"\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377\004)))\377"
		"\366\366\366\377\377\377\377\377\376\376\376\377\205\377\377\377\377\002\350"
		"\350\350\377\"\"\"\377\210\001\001\001\377\001\002\002\002\377\203\000\000\000\377\002\002\002\002\377"
		"\003\003\003\377\206\000\000\000\377\002\021\021\021\377\325\325\325\377\206\377\377\377\377"
		"\003\376\376\376\377\377\377\377\377EEE\377\202\000\000\000\377\001\002\002\002\377\205\000"
		"\000\000\377\007\003\003\003\377\002\002\002\377\001\001\001\377\000\000\000\377\002\002\002\377\000\000\000\377\261"
		"\261\261\377\204\377\377\377\377\001\376\376\376\377\203\377\377\377\377\001"
		"\210\210\210\377\202\000\000\000\377\006\001\001\001\377\000\000\000\377\002\002\002\377\010\010\010\377"
		"\315\315\315\377\374\374\374\377\202\377\377\377\377\001\376\376\376\377\202"
		"\377\377\377\377\004\373\373\373\377\377\377\377\377\376\376\376\377\375\375"
		"\375\377\210\377\377\377\377\001\373\373\373\377\202\377\377\377\377\001\374"
		"\374\374\377\203\377\377\377\377\001\375\375\375\377\202\377\377\377\377\005"
		"\376\376\376\377MMM\377\004\004\004\377\000\000\000\377\001\001\001\377\206\000\000\000\377\002\040"
		"\040\040\377\345\345\345\377\207\377\377\377\377\002\370\370\370\377///\377\210"
		"\000\000\000\377\002\001\001\001\377\002\002\002\377\203\000\000\000\377\002\002\002\002\377\001\001\001\377\203"
		"\000\000\000\377\001\002\002\002\377\202\000\000\000\377\003\001\001\001\377\000\000\000\377\001\001\001\377\211"
		"\000\000\000\377\001\001\001\001\377\202\000\000\000\377\002\020\020\020\377\336\336\336\377\207\377"
		"\377\377\377\002\373\373\373\377EEE\377\215\000\000\000\377\007\347\034\000\377\377\036"
		"\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211"
		"\377\036\000\377\006\227\025\007\377\000\004\002\377\000\002\005\377\004\000\013\377\000\001\002\377\000\005"
		"\007\377\202\000\000\002\377\210\000\000\004\377\040\001\000\000\377\000\003\000\377\000\007\000\377\000\004\000"
		"\377\000\000\002\377\003\000\004\377\002\001\000\377\000\002\000\377\004\000\004\377\007\000\003\377\003\002\000\377"
		"\000\002\000\377\003\000\000\377\006\000\000\377\005\000\001\377\001\000\005\377\005\005\000\377\327\032\000\377"
		"\375\036\000\377\374\037\005\377\377\035\006\377\366\035\000\377\377\040\000\377\355\036"
		"\000\377\040\003\000\377\000\004\000\377\000\001\003\377\001\000\004\377\001\001\001\377\004\000\000\377\001\001\000"
		"\377\000\000\002\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377"
		"\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300"
		"\300\377\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000"
		"\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366\366\366\377\202\377\377\377\377"
		"\001\375\375\375\377\202\377\377\377\377\004\375\375\375\377\377\377\377\377"
		"\352\352\352\377\035\035\035\377\212\000\000\000\377\003\005\005\005\377\000\000\000\377\001\001\001\377"
		"\202\000\000\000\377\001\003\003\003\377\204\000\000\000\377\002\021\021\021\377\325\325\325\377\206"
		"\377\377\377\377\007\376\376\376\377\377\377\377\377EEE\377\000\000\000\377\001\001\001"
		"\377\000\000\000\377\001\001\001\377\202\000\000\000\377\001\006\006\006\377\203\000\000\000\377\001\002\002\002"
		"\377\203\000\000\000\377\002\263\263\263\377\376\376\376\377\203\377\377\377\377"
		"\001\376\376\376\377\203\377\377\377\377\001\210\210\210\377\204\000\000\000\377\003"
		"\002\002\002\377'''\377\362\362\362\377\202\376\376\376\377\003\375\375\375\377\377"
		"\377\377\377\376\376\376\377\203\377\377\377\377\001\376\376\376\377\203\377"
		"\377\377\377\204\376\376\376\377\203\377\377\377\377\202\375\375\375\377"
		"\202\377\377\377\377\001\375\375\375\377\202\377\377\377\377\001\376\376\376"
		"\377\202\377\377\377\377\002\213\213\213\377\000\000\000\377\202\001\001\001\377\206\000"
		"\000\000\377\002\040\040\040\377\345\345\345\377\207\377\377\377\377\002\370\370\370"
		"\377///\377\212\000\000\000\377\001\002\002\002\377\202\000\000\000\377\001\002\002\002\377\203\000\000\000"
		"\377\001\001\001\001\377\202\000\000\000\377\202\002\002\002\377\213\000\000\000\377\001\001\001\001\377\202"
		"\000\000\000\377\002\020\020\020\377\336\336\336\377\207\377\377\377\377\002\373\373\373"
		"\377EEE\377\215\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037"
		"\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\010\237\020"
		"\002\377\003\000\000\377\000\001\000\377\000\000\007\377\000\004\000\377\000\003\000\377\001\000\000\377\000\007\000"
		"\377\210\000\001\000\377\040\006\000\007\377\006\000\006\377\001\000\000\377\000\000\000\377\000\001\003\377\000"
		"\000\004\377\001\002\006\377\000\000\002\377\000\000\004\377\003\000\000\377\001\000\000\377\000\000\000\377\006\000"
		"\006\377\001\000\006\377\000\002\005\377\000\001\004\377n\022\000\377\374\032\002\377\377\031\012\377"
		"\377\036\010\377\366\035\000\377\372\036\000\377\377\036\000\377\364\036\004\377\065\005\003"
		"\377\000\002\000\377\000\002\003\377\003\000\004\377\001\003\002\377\003\000\000\377\001\001\000\377\000\000\002\377"
		"\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377"
		"\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300\377\210"
		"\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001"
		"\377\203\000\000\000\377\003)))\377\366\366\366\377\377\377\377\377\202\376\376\376"
		"\377\001\375\375\375\377\202\377\377\377\377\003\375\375\375\377\354\354\354"
		"\377\036\036\036\377\216\000\000\000\377\001\002\002\002\377\205\000\000\000\377\002\021\021\021\377"
		"\325\325\325\377\206\377\377\377\377\003\376\376\376\377\377\377\377\377EE"
		"E\377\204\000\000\000\377\001\001\001\001\377\203\000\000\000\377\003\001\001\001\377\003\003\003\377\000\000\000"
		"\377\202\001\001\001\377\004\000\000\000\377\261\261\261\377\377\377\377\377\376\376\376"
		"\377\202\377\377\377\377\001\376\376\376\377\203\377\377\377\377\001\210\210"
		"\210\377\203\000\000\000\377\004\001\001\001\377\000\000\000\377UUU\377\375\375\375\377\204\377"
		"\377\377\377\001\374\374\374\377\204\377\377\377\377\001\374\374\374\377\210"
		"\377\377\377\377\202\376\376\376\377\202\377\377\377\377\003\376\376\376\377"
		"\377\377\377\377\375\375\375\377\202\377\377\377\377\007\374\374\374\377\377"
		"\377\377\377\301\301\301\377\000\000\000\377\001\001\001\377\000\000\000\377\001\001\001\377\205"
		"\000\000\000\377\002\040\040\040\377\345\345\345\377\207\377\377\377\377\002\370\370\370"
		"\377///\377\210\000\000\000\377\003\003\003\003\377\000\000\000\377\002\002\002\377\206\000\000\000\377\004"
		"\001\001\001\377\000\000\000\377\001\001\001\377\002\002\002\377\202\000\000\000\377\001\001\001\001\377\211\000"
		"\000\000\377\001\001\001\001\377\202\000\000\000\377\002\020\020\020\377\336\336\336\377\207\377"
		"\377\377\377\002\373\373\373\377EEE\377\215\000\000\000\377\007\347\034\000\377\377\036"
		"\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211"
		"\377\036\000\377\004\245\015\002\377\011\000\000\377\000\001\002\377\004\001\010\377\203\003\000\000\377"
		"\001\000\001\005\377\210\001\000\000\377\040\000\005\003\377\000\001\004\377\000\000\002\377\003\000\000\377\003\003"
		"\003\377\000\001\000\377\000\003\006\377\000\002\011\377\000\002\005\377\000\001\000\377\000\000\000\377\003\000\004"
		"\377\000\000\013\377\000\004\004\377\016\002\000\377K\007\000\377\363\035\003\377\377\033\000\377\373"
		"\036\014\377\377!\000\377\372\040\000\377\377!\010\377\371\035\005\377\372\040\000\377"
		"I\007\010\377\003\000\000\377\000\001\002\377\001\000\005\377\000\004\003\377\003\000\000\377\001\000\000\377\000"
		"\000\004\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040"
		"\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300\377"
		"\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001"
		"\001\001\377\203\000\000\000\377\007)))\377\366\366\366\377\377\377\377\377\375\375\375"
		"\377\377\377\377\377\376\376\376\377\373\373\373\377\202\377\377\377\377"
		"\002\355\355\355\377\035\035\035\377\211\000\000\000\377\006\002\002\002\377\000\000\000\377\004\004\004"
		"\377\001\001\001\377\000\000\000\377\002\002\002\377\205\000\000\000\377\002\021\021\021\377\325\325\325"
		"\377\206\377\377\377\377\003\376\376\376\377\377\377\377\377EEE\377\202\000\000"
		"\000\377\001\006\006\006\377\202\000\000\000\377\003\002\002\002\377\001\001\001\377\002\002\002\377\204\000\000"
		"\000\377\003\001\001\001\377\000\000\000\377\260\260\260\377\204\377\377\377\377\001\376\376"
		"\376\377\203\377\377\377\377\001\210\210\210\377\202\000\000\000\377\202\002\002\002\377"
		"\003\000\000\000\377\216\216\216\377\375\375\375\377\203\377\377\377\377\001\375\375"
		"\375\377\203\377\377\377\377\001\376\376\376\377\205\377\377\377\377\202\376"
		"\376\376\377\205\377\377\377\377\004\373\373\373\377\377\377\377\377\376\376"
		"\376\377\377\377\377\377\202\376\376\376\377\005\377\377\377\377\374\374\374"
		"\377\377\377\377\377\345\345\345\377\035\035\035\377\202\000\000\000\377\001\002\002\002\377"
		"\205\000\000\000\377\002\040\040\040\377\345\345\345\377\207\377\377\377\377\002\370\370"
		"\370\377///\377\213\000\000\000\377\004\002\002\002\377\003\003\003\377\000\000\000\377\005\005\005\377\202"
		"\000\000\000\377\003\002\002\002\377\000\000\000\377\001\001\001\377\202\000\000\000\377\001\004\004\004\377\212"
		"\000\000\000\377\001\001\001\001\377\202\000\000\000\377\002\020\020\020\377\336\336\336\377\207\377"
		"\377\377\377\002\373\373\373\377EEE\377\215\000\000\000\377\007\347\034\000\377\377\036"
		"\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211"
		"\377\036\000\377\010\227\024\000\377\000\001\000\377\000\004\000\377\004\000\006\377\006\000\000\377\000\000"
		"\000\377\002\003\007\377\004\000\013\377\210\001\000\000\377\040\003\002\000\377\000\000\002\377\001\002\007\377"
		"\001\000\002\377\003\000\000\377\004\000\000\377\004\001\000\377\002\001\000\377\000\000\002\377\001\001\000\377\003"
		"\002\000\377\004\000\006\377\000\001\011\377\000\005\000\377\\\014\000\377\351\032\012\377\377\033\000"
		"\377\377!\000\377\363#\000\377\375\037\000\377\377\034\005\377\374\035\000\377\377\033"
		"\006\377\377\033\000\377V\007\012\377\005\001\000\377\000\001\002\377\001\000\005\377\000\005\003\377\001\000"
		"\000\377\003\000\000\377\001\000\004\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377"
		"\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000"
		"\377\001\300\300\300\377\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001"
		"\377\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366\366\366\377\202"
		"\377\377\377\377\001\374\374\374\377\203\377\377\377\377\003\375\375\375\377"
		"\353\353\353\377\040\040\040\377\211\000\000\000\377\001\003\003\003\377\203\000\000\000\377\003\003"
		"\003\003\377\000\000\000\377\002\002\002\377\204\000\000\000\377\002\021\021\021\377\325\325\325\377"
		"\206\377\377\377\377\005\376\376\376\377\377\377\377\377EEE\377\000\000\000\377\002"
		"\002\002\377\202\000\000\000\377\001\001\001\001\377\202\000\000\000\377\001\002\002\002\377\202\000\000\000\377"
		"\005\001\001\001\377\004\004\004\377\000\000\000\377\001\001\001\377\262\262\262\377\204\377\377\377"
		"\377\001\376\376\376\377\203\377\377\377\377\003\210\210\210\377\000\000\000\377\001"
		"\001\001\377\202\000\000\000\377\002\004\004\004\377\301\301\301\377\202\377\377\377\377\001"
		"\375\375\375\377\203\377\377\377\377\004\375\375\375\377\377\377\377\377\331"
		"\331\331\377\263\263\263\377\211\266\266\266\377\010\264\264\264\377\267\267"
		"\267\377\277\277\277\377\371\371\371\377\377\377\377\377\372\372\372\377"
		"\377\377\377\377\376\376\376\377\203\377\377\377\377\003\373\373\373\377HH"
		"H\377\001\001\001\377\207\000\000\000\377\002\040\040\040\377\345\345\345\377\207\377\377"
		"\377\377\002\370\370\370\377///\377\211\000\000\000\377\017\003\003\003\377\000\000\000\377\001"
		"\001\001\377\000\000\000\377\004\004\004\377\071\071\071\377NNN\377JJJ\377NNN\377KKK\377NNN"
		"\377LLL\377NNN\377III\377$$$\377\211\000\000\000\377\001\001\001\001\377\202\000\000\000\377"
		"\002\020\020\020\377\336\336\336\377\207\377\377\377\377\002\373\373\373\377EEE"
		"\377\215\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377"
		"\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\010\217\023\025\377"
		"\011\001\000\377\000\004\000\377\010\000\006\377\000\000\000\377\001\000\000\377\002\001\000\377\000\002\001\377"
		"\220\000\000\000\377\010\004\000\000\377\000\002\001\377\000\003\002\377\020\000\000\377O\001\000\377\251\025"
		"\011\377\360\040\006\377\377\035\000\377\210\377\036\000\377\003{\014\000\377\000\001\011\377"
		"\001\001\001\377\202\000\002\000\377\003\004\000\005\377\000\004\000\377\001\000\000\377\210\000\000\000\377\010"
		"\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335"
		"\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300\377\210\377\377\377\377"
		"\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377"
		"\002)))\377\366\366\366\377\202\377\377\377\377\001\376\376\376\377\204\377\377"
		"\377\377\002\354\354\354\377\036\036\036\377\220\000\000\000\377\001\001\001\001\377\203\000\000"
		"\000\377\003\021\021\021\377\331\331\331\377\374\374\374\377\203\377\377\377\377"
		"\006\375\375\375\377\377\377\377\377\376\376\376\377\377\377\377\377FFF\377"
		"\001\001\001\377\211\000\000\000\377\007\002\002\002\377\000\000\000\377\002\002\002\377\000\000\000\377\262\262"
		"\262\377\377\377\377\377\376\376\376\377\203\377\377\377\377\001\375\375\375"
		"\377\202\377\377\377\377\001\211\211\211\377\202\000\000\000\377\006\001\001\001\377\000\000"
		"\000\377\040\040\040\377\355\355\355\377\376\376\376\377\375\375\375\377\204\377"
		"\377\377\377\202\376\376\376\377\003QQQ\377\000\000\000\377\001\001\001\377\210\000\000\000\377"
		"\004\001\001\001\377\000\000\000\377\004\004\004\377\311\311\311\377\202\377\377\377\377\001\376"
		"\376\376\377\203\377\377\377\377\202\375\375\375\377\007}}}\377\000\000\000\377\002"
		"\002\002\377\000\000\000\377\001\001\001\377\000\000\000\377\003\003\003\377\202\000\000\000\377\002!!!\377\343"
		"\343\343\377\202\377\377\377\377\202\376\376\376\377\203\377\377\377\377"
		"\011\366\366\366\377\060\060\060\377\001\001\001\377\000\000\000\377\003\003\003\377\000\000\000\377"
		"\002\002\002\377\001\001\001\377\000\000\000\377\202\002\002\002\377\001\000\000\000\377\202\002\002\002\377\003"
		"\000\000\000\377\010\010\010\377\323\323\323\377\202\377\377\377\377\003\376\376\376"
		"\377\377\377\377\377\376\376\376\377\203\377\377\377\377\001uuu\377\211\000\000"
		"\000\377\001\001\001\001\377\202\000\000\000\377\002\020\020\020\377\336\336\336\377\207\377\377"
		"\377\377\002\373\373\373\377EEE\377\215\000\000\000\377\007\347\034\000\377\377\036\002\377"
		"\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377"
		"\036\000\377\010\345\026\004\377\236\024\000\377\240\027\007\377\251\022\013\377\242\025"
		"\004\377\253\024\001\377\252\023\002\377\243\022\001\377\220\246\023\001\377\010\236\025"
		"\005\377\240\022\000\377\265\027\000\377\327\040\001\377\363\040\002\377\377\037\000\377\377"
		"\040\000\377\374\"\000\377\210\377\036\000\377\007\210\017\000\377\000\001\007\377\001\001\001\377"
		"\000\000\000\377\000\002\000\377\004\000\005\377\000\002\000\377\211\000\000\000\377\010\000\001\000\377\001\000\000"
		"\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000"
		"\377\207\000\000\000\377\001\300\300\300\377\210\377\377\377\377\001hhh\377\203\000\000"
		"\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366\366"
		"\366\377\202\377\377\377\377\001\376\376\376\377\204\377\377\377\377\002\354"
		"\354\354\377\036\036\036\377\221\000\000\000\377\005\002\002\002\377\001\001\001\377\000\000\000\377\020"
		"\020\020\377\324\324\324\377\203\377\377\377\377\003\374\374\374\377\377\377"
		"\377\377\374\374\374\377\202\377\377\377\377\002EEE\377\001\001\001\377\210\000\000\000"
		"\377\001\001\001\001\377\202\000\000\000\377\003\002\002\002\377\000\000\000\377\260\260\260\377\202"
		"\377\377\377\377\202\376\376\376\377\202\377\377\377\377\003\373\373\373\377"
		"\377\377\377\377\207\207\207\377\203\000\000\000\377\007\001\001\001\377LLL\377\374\374"
		"\374\377\377\377\377\377\376\376\376\377\377\377\377\377\376\376\376\377"
		"\203\377\377\377\377\002\355\355\355\377%%%\377\212\000\000\000\377\001\002\002\002\377\202"
		"\000\000\000\377\002\235\235\235\377\376\376\376\377\204\377\377\377\377\202\376"
		"\376\376\377\006\377\377\377\377\260\260\260\377\002\002\002\377\000\000\000\377\003\003\003"
		"\377\001\001\001\377\202\000\000\000\377\006\001\001\001\377\000\000\000\377\040\040\040\377\350\350\350"
		"\377\377\377\377\377\376\376\376\377\204\377\377\377\377\004\376\376\376\377"
		"\366\366\366\377...\377\001\001\001\377\202\000\000\000\377\001\002\002\002\377\202\000\000\000\377"
		"\001\003\003\003\377\202\000\000\000\377\001\003\003\003\377\202\000\000\000\377\003\002\002\002\377\006\006\006\377"
		"\313\313\313\377\203\377\377\377\377\006\376\376\376\377\377\377\377\377\375"
		"\375\375\377\376\376\376\377\377\377\377\377nnn\377\211\000\000\000\377\001\001\001\001"
		"\377\202\000\000\000\377\002\020\020\020\377\336\336\336\377\207\377\377\377\377\002\373"
		"\373\373\377EEE\377\215\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377"
		"\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\212\377\036\000\377\007\365"
		"#\000\377\377\040\012\377\376\034\004\377\373!\000\377\377\040\000\377\377\036\000\377\372"
		"\036\000\377\220\377\036\000\377\010\377\035\015\377\377\034\003\377\371\035\000\377\375"
		"\037\000\377\377\036\000\377\377\033\000\377\377\033\001\377\376\035\007\377\210\377\036"
		"\000\377\010\236\023\000\377\000\001\004\377\002\000\001\377\001\000\000\377\000\003\000\377\003\000\004\377"
		"\002\001\000\377\000\001\000\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036"
		"\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001"
		"\300\300\300\377\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214"
		"\000\000\000\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366\366\366\377\202\377\377"
		"\377\377\001\376\376\376\377\204\377\377\377\377\002\354\354\354\377\036\036\036"
		"\377\221\000\000\000\377\001\002\002\002\377\202\000\000\000\377\002\022\022\022\377\325\325\325\377"
		"\205\377\377\377\377\005\376\376\376\377\377\377\377\377\376\376\376\377II"
		"I\377\001\001\001\377\212\000\000\000\377\010\004\004\004\377\000\000\000\377\002\002\002\377\256\256\256"
		"\377\377\377\377\377\376\376\376\377\377\377\377\377\375\375\375\377\202"
		"\377\377\377\377\003\376\376\376\377\377\377\377\377\213\213\213\377\204\000"
		"\000\000\377\003\205\205\205\377\377\377\377\377\376\376\376\377\203\377\377\377"
		"\377\004\376\376\376\377\377\377\377\377\376\376\376\377\312\312\312\377\202"
		"\001\001\001\377\212\000\000\000\377\003\001\001\001\377\000\000\000\377ccc\377\203\377\377\377\377"
		"\003\376\376\376\377\377\377\377\377\376\376\376\377\202\377\377\377\377\003"
		"\345\345\345\377\024\024\024\377\000\000\000\377\202\001\001\001\377\006\002\002\002\377\000\000\000\377"
		"\001\001\001\377\000\000\000\377\037\037\037\377\346\346\346\377\202\376\376\376\377\204"
		"\377\377\377\377\005\376\376\376\377\373\373\373\377...\377\000\000\000\377\003\003\003"
		"\377\204\000\000\000\377\001\001\001\001\377\203\000\000\000\377\202\001\001\001\377\003\002\002\002\377\004"
		"\004\004\377\312\312\312\377\203\377\377\377\377\006\375\375\375\377\377\377\377"
		"\377\375\375\375\377\377\377\377\377\374\374\374\377ooo\377\211\000\000\000\377"
		"\001\001\001\001\377\202\000\000\000\377\002\020\020\020\377\336\336\336\377\207\377\377\377"
		"\377\002\373\373\373\377EEE\377\215\000\000\000\377\007\347\034\000\377\377\036\002\377\377"
		"\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036"
		"\000\377\010\375\036\000\377\377\037\004\377\377\031\003\377\377\030\000\377\377\036\000\377"
		"\377\034\000\377\377\035\000\377\374\040\000\377\220\377\036\002\377\010\375\035\000\377"
		"\377\040\000\377\376\"\002\377\375\035\001\377\377\033\001\377\377\036\002\377\377\037\000"
		"\377\371\035\000\377\210\377\036\000\377\010\265\026\001\377\000\000\000\377\001\000\000\377\003"
		"\000\000\377\000\004\000\377\002\000\005\377\003\000\000\377\000\001\000\377\210\000\000\000\377\010\000\001\000\377"
		"\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024"
		"\002\000\377\207\000\000\000\377\001\300\300\300\377\210\377\377\377\377\001hhh\377\203"
		"\000\000\000\377\001\001\001\001\377\214\000\000\000\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366"
		"\366\366\377\202\377\377\377\377\001\376\376\376\377\204\377\377\377\377\002"
		"\354\354\354\377\036\036\036\377\220\000\000\000\377\001\002\002\002\377\202\000\000\000\377\003\001"
		"\001\001\377\017\017\017\377\323\323\323\377\204\377\377\377\377\001\372\372\372\377"
		"\202\377\377\377\377\002\376\376\376\377FFF\377\212\000\000\000\377\202\001\001\001\377"
		"\005\000\000\000\377\002\002\002\377\261\261\261\377\377\377\377\377\376\376\376\377\202"
		"\377\377\377\377\001\375\375\375\377\202\377\377\377\377\002\372\372\372\377"
		"\210\210\210\377\202\000\000\000\377\014\002\002\002\377\005\005\005\377\274\274\274\377\376"
		"\376\376\377\374\374\374\377\377\377\377\377\376\376\376\377\377\377\377"
		"\377\376\376\376\377\377\377\377\377\375\375\375\377\226\226\226\377\202"
		"\000\000\000\377\001\002\002\002\377\211\000\000\000\377\004\001\001\001\377\002\002\002\377\060\060\060\377\365"
		"\365\365\377\204\377\377\377\377\006\376\376\376\377\377\377\377\377\373\373"
		"\373\377\374\374\374\377???\377\003\003\003\377\202\000\000\000\377\006\001\001\001\377\002\002\002"
		"\377\000\000\000\377\002\002\002\377\037\037\037\377\345\345\345\377\203\377\377\377\377"
		"\001\376\376\376\377\203\377\377\377\377\004\375\375\375\377\061\061\061\377\000\000"
		"\000\377\001\001\001\377\202\003\003\003\377\203\000\000\000\377\004\001\001\001\377\004\004\004\377\000\000\000"
		"\377\002\002\002\377\202\000\000\000\377\007\003\003\003\377\315\315\315\377\376\376\376\377"
		"\377\377\377\377\376\376\376\377\377\377\377\377\376\376\376\377\202\377"
		"\377\377\377\002\374\374\374\377ppp\377\211\000\000\000\377\001\001\001\001\377\202\000\000\000"
		"\377\002\020\020\020\377\336\336\336\377\207\377\377\377\377\002\373\373\373\377"
		"EEE\377\215\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377"
		"\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\202\377\035\000\377"
		"\006\374\033\000\377\377\037\000\377\377\040\000\377\376\036\000\377\376\036\002\377\376\036"
		"\005\377\220\376\036\002\377\010\377\033\000\377\377\034\000\377\375\036\000\377\374\040"
		"\000\377\377\037\000\377\377\034\000\377\377\035\000\377\377\037\000\377\210\377\036\000\377"
		"\010\314\027\002\377\010\000\000\377\001\000\000\377\003\000\000\377\000\004\000\377\002\000\003\377\003\000\000"
		"\377\000\000\002\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377"
		"\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300"
		"\300\377\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000"
		"\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366\366\366\377\202\377\377\377\377"
		"\001\376\376\376\377\204\377\377\377\377\002\354\354\354\377\036\036\036\377\222"
		"\000\000\000\377\005\002\002\002\377\000\000\000\377\006\006\006\377\306\306\306\377\374\374\374\377"
		"\202\376\376\376\377\002\377\377\377\377\375\375\375\377\203\377\377\377\377"
		"\002aaa\377\005\005\005\377\210\000\000\000\377\001\001\001\001\377\202\000\000\000\377\006\003\003\003\377\012"
		"\012\012\377\313\313\313\377\376\376\376\377\377\377\377\377\375\375\375\377"
		"\205\377\377\377\377\001qqq\377\202\000\000\000\377\010\002\002\002\377\031\031\031\377\350"
		"\350\350\377\377\377\377\377\376\376\376\377\377\377\377\377\375\375\375"
		"\377\377\377\377\377\202\376\376\376\377\005\377\377\377\377YYY\377\003\003\003\377"
		"\000\000\000\377\001\001\001\377\213\000\000\000\377\004\014\014\014\377\325\325\325\377\377\377"
		"\377\377\376\376\376\377\202\377\377\377\377\007\376\376\376\377\377\377\377"
		"\377\373\373\373\377\377\377\377\377www\377\000\000\000\377\001\001\001\377\202\000\000\000"
		"\377\001\002\002\002\377\202\000\000\000\377\003\021\021\021\377\336\336\336\377\376\376\376"
		"\377\202\377\377\377\377\001\376\376\376\377\203\377\377\377\377\003\373\373"
		"\373\377KKK\377\004\004\004\377\202\000\000\000\377\014\002\002\002\377\000\000\000\377\001\001\001\377"
		"\004\004\004\377\001\001\001\377\000\000\000\377\002\002\002\377\001\001\001\377\000\000\000\377\003\003\003\377\025"
		"\025\025\377\336\336\336\377\204\377\377\377\377\005\375\375\375\377\377\377"
		"\377\377\375\375\375\377\377\377\377\377ZZZ\377\211\000\000\000\377\001\001\001\001\377"
		"\202\000\000\000\377\002\020\020\020\377\336\336\336\377\207\377\377\377\377\002\373\373"
		"\373\377EEE\377\215\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373"
		"\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\010\377"
		"\034\000\377\373\040\000\377\363%\000\377\375#\000\377\377\036\000\377\374!\003\377\377"
		"\036\005\377\377\034\007\377\220\375\037\000\377\003\372!\002\377\373\040\002\377\377\036"
		"\002\377\202\377\034\002\377\003\375\033\002\377\371\036\002\377\370!\004\377\210\377\036"
		"\000\377\002\337\030\001\377\025\002\000\377\202\000\000\000\377\004\000\003\000\377\001\000\002\377\000\000"
		"\000\377\001\000\002\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377"
		"\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300"
		"\300\377\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000"
		"\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366\366\366\377\202\377\377\377\377"
		"\001\376\376\376\377\204\377\377\377\377\002\354\354\354\377\036\036\036\377\222"
		"\000\000\000\377\005\002\002\002\377\000\000\000\377\003\003\003\377\247\247\247\377\377\377\377\377"
		"\202\376\376\376\377\203\377\377\377\377\003\374\374\374\377\377\377\377\377"
		"\251\251\251\377\214\000\000\000\377\003\002\002\002\377'''\377\356\356\356\377\202\377"
		"\377\377\377\014\376\376\376\377\377\377\377\377\376\376\376\377\377\377\377"
		"\377\376\376\376\377\377\377\377\377LLL\377\000\000\000\377\001\001\001\377\000\000\000\377"
		"CCC\377\376\376\376\377\206\377\377\377\377\004\375\375\375\377\367\367\367"
		"\377(((\377\002\002\002\377\212\000\000\000\377\001\002\002\002\377\203\000\000\000\377\002\243\243\243"
		"\377\377\377\377\377\202\376\376\376\377\202\377\377\377\377\001\376\376\376"
		"\377\202\377\377\377\377\003\253\253\253\377\000\000\000\377\002\002\002\377\203\000\000\000"
		"\377\005\002\002\002\377\000\000\000\377\002\002\002\377\301\301\301\377\375\375\375\377\204"
		"\377\377\377\377\013\375\375\375\377\377\377\377\377\376\376\376\377\215\215"
		"\215\377\000\000\000\377\003\003\003\377\001\001\001\377\000\000\000\377\001\001\001\377\000\000\000\377\002\002"
		"\002\377\202\000\000\000\377\006\001\001\001\377\000\000\000\377\004\004\004\377\000\000\000\377===\377\367"
		"\367\367\377\203\377\377\377\377\001\375\375\375\377\202\377\377\377\377\202"
		"\376\376\376\377\001\066\066\066\377\211\000\000\000\377\001\001\001\001\377\202\000\000\000\377\002"
		"\020\020\020\377\336\336\336\377\207\377\377\377\377\002\373\373\373\377EEE\377"
		"\215\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377"
		"\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\010\377\033\004\377\377"
		"\035\004\377\372!\002\377\377\034\002\377\375\031\000\377\376\036\004\377\377\030\004\377"
		"\377\034\005\377\220\377\035\000\377\010\372\037\000\377\377\"\000\377\377\037\000\377\377"
		"\033\000\377\377\033\001\377\377\036\001\377\377\036\000\377\375\037\000\377\210\377\036"
		"\000\377\010\355\033\002\377#\004\001\377\000\000\000\377\000\001\002\377\002\001\000\377\003\000\002\377\000"
		"\004\000\377\003\000\004\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000"
		"\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300"
		"\300\300\377\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000"
		"\000\000\377\001\001\001\001\377\203\000\000\000\377\002)))\377\366\366\366\377\202\377\377\377"
		"\377\001\376\376\376\377\204\377\377\377\377\002\354\354\354\377\036\036\036\377"
		"\221\000\000\000\377\001\001\001\001\377\202\000\000\000\377\002\002\002\002\377lll\377\204\377\377\377"
		"\377\001\375\375\375\377\203\377\377\377\377\002\346\346\346\377$$$\377\213\000"
		"\000\000\377\003\002\002\002\377zzz\377\375\375\375\377\203\377\377\377\377\203\376\376"
		"\376\377\007\377\377\377\377\354\354\354\377###\377\000\000\000\377\001\001\001\377\000\000"
		"\000\377\201\201\201\377\203\377\377\377\377\001\376\376\376\377\203\377\377"
		"\377\377\003\376\376\376\377\317\317\317\377\014\014\014\377\215\000\000\000\377\006\001"
		"\001\001\377\000\000\000\377hhh\377\376\376\376\377\377\377\377\377\376\376\376\377"
		"\202\377\377\377\377\001\376\376\376\377\202\377\377\377\377\002\332\332\332"
		"\377\024\024\024\377\204\000\000\000\377\202\002\002\002\377\002\000\000\000\377\207\207\207\377"
		"\205\377\377\377\377\001\376\376\376\377\202\377\377\377\377\006\330\330\330"
		"\377\024\024\024\377\000\000\000\377\004\004\004\377\000\000\000\377\002\002\002\377\202\000\000\000\377\002"
		"\001\001\001\377\003\003\003\377\203\000\000\000\377\002\002\002\002\377\220\220\220\377\202\377\377"
		"\377\377\003\376\376\376\377\377\377\377\377\375\375\375\377\203\377\377\377"
		"\377\002\326\326\326\377\023\023\023\377\211\000\000\000\377\001\001\001\001\377\202\000\000\000\377"
		"\002\020\020\020\377\336\336\336\377\207\377\377\377\377\002\373\373\373\377EEE"
		"\377\215\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377"
		"\377\036\001\377\377\034\002\377\376\037\000\377\211\377\036\000\377\002\377\035\004\377\377"
		"\033\001\377\202\377\035\000\377\004\373\037\000\377\375$\001\377\377\032\000\377\372%\000"
		"\377\220\376\036\002\377\010\377\034\005\377\377\035\005\377\377\034\001\377\375\035\001"
		"\377\375!\001\377\374\037\002\377\375\035\001\377\377\036\003\377\210\377\036\000\377\010"
		"\365\036\002\377-\007\006\377\000\002\000\377\000\002\002\377\005\001\000\377\003\000\000\377\000\005\000\377"
		"\004\000\004\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374"
		"\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300"
		"\377\210\377\377\377\377\001hhh\377\203\000\000\000\377\001\001\001\001\377\214\000\000\000\377"
		"\001\001\001\001\377\203\000\000\000\377\002)))\377\366\366\366\377\202\377\377\377\377\001"
		"\376\376\376\377\204\377\377\377\377\002\354\354\354\377\036\036\036\377\221\000"
		"\000\000\377\006\003\003\003\377\000\000\000\377\002\002\002\377\000\000\000\377\061\061\061\377\366\366\366"
		"\377\202\377\377\377\377\003\376\376\376\377\377\377\377\377\376\376\376\377"
		"\203\377\377\377\377\001\233\233\233\377\212\000\000\000\377\004\002\002\002\377\035\035\035"
		"\377\350\350\350\377\377\377\377\377\202\376\376\376\377\007\377\377\377\377"
		"\376\376\376\377\377\377\377\377\375\375\375\377\377\377\377\377\273\273"
		"\273\377\003\003\003\377\202\000\000\000\377\003\002\002\002\377\264\264\264\377\376\376\376"
		"\377\202\377\377\377\377\003\376\376\376\377\377\377\377\377\375\375\375\377"
		"\202\376\376\376\377\005\241\241\241\377\000\000\000\377\002\002\002\377\000\000\000\377\001\001"
		"\001\377\211\000\000\000\377\005\001\001\001\377\002\002\002\377\000\000\000\377:::\377\366\366\366\377"
		"\206\377\377\377\377\003\376\376\376\377\375\375\375\377\070\070\070\377\202\000"
		"\000\000\377\012\001\001\001\377\002\002\002\377\000\000\000\377\002\002\002\377\000\000\000\377EEE\377\375"
		"\375\375\377\376\376\376\377\377\377\377\377\376\376\376\377\202\377\377"
		"\377\377\004\376\376\376\377\374\374\374\377\377\377\377\377\200\200\200\377"
		"\204\000\000\000\377\003\001\001\001\377\000\000\000\377\001\001\001\377\203\000\000\000\377\004\002\002\002\377"
		"\060\060\060\377\363\363\363\377\376\376\376\377\202\377\377\377\377\002\376\376"
		"\376\377\377\377\377\377\202\376\376\376\377\002\377\377\377\377\243\243\243"
		"\377\212\000\000\000\377\001\001\001\001\377\202\000\000\000\377\002\020\020\020\377\336\336\336\377"
		"\207\377\377\377\377\002\373\373\373\377EEE\377\215\000\000\000\377\007\347\034\000\377"
		"\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037"
		"\000\377\261\377\036\000\377\010\377\033\000\377K\011\000\377\000\002\007\377\004\000\000\377\001\000"
		"\004\377\000\001\000\377\003\000\005\377\000\002\000\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377"
		"A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377"
		"\207\000\000\000\377\001\300\300\300\377\210\377\377\377\377\006ggg\377\000\000\000\377\004"
		"\004\004\377\000\000\000\377\001\001\001\377\000\000\000\377\202\001\001\001\377\210\000\000\000\377\001\001\001"
		"\001\377\202\000\000\000\377\005\002\002\002\377\000\000\000\377'''\377\371\371\371\377\375\375"
		"\375\377\203\377\377\377\377\001\376\376\376\377\202\377\377\377\377\002\354"
		"\354\354\377\035\035\035\377\220\000\000\000\377\003\001\001\001\377\000\000\000\377\002\002\002\377\202"
		"\000\000\000\377\006\004\004\004\377\274\274\274\377\377\377\377\377\374\374\374\377\377"
		"\377\377\377\375\375\375\377\202\377\377\377\377\020\376\376\376\377\377\377"
		"\377\377\374\374\374\377qqq\377\001\001\001\377\000\000\000\377\002\002\002\377\000\000\000\377\003"
		"\003\003\377\000\000\000\377\004\004\004\377\001\001\001\377\000\000\000\377\022\022\022\377\276\276\276"
		"\377\376\376\376\377\202\377\377\377\377\202\376\376\376\377\002\377\377\377"
		"\377\375\375\375\377\202\377\377\377\377\007lll\377\000\000\000\377\003\003\003\377\000\000"
		"\000\377\024\024\024\377\344\344\344\377\376\376\376\377\202\377\377\377\377\011"
		"\376\376\376\377\377\377\377\377\376\376\376\377\377\377\377\377\376\376"
		"\376\377eee\377\001\001\001\377\000\000\000\377\004\004\004\377\211\000\000\000\377\001\001\001\001\377\202"
		"\000\000\000\377\004\001\001\001\377\016\016\016\377\336\336\336\377\377\377\377\377\202\376"
		"\376\376\377\203\377\377\377\377\003\375\375\375\377\377\377\377\377qqq\377"
		"\204\000\000\000\377\001\001\001\001\377\202\000\000\000\377\002\013\013\013\377\326\326\326\377\206"
		"\377\377\377\377\006\373\373\373\377\377\377\377\377\366\366\366\377\\\\\\"
		"\377\000\000\000\377\001\001\001\377\202\000\000\000\377\001\001\001\001\377\202\000\000\000\377\005\001\001\001"
		"\377\000\000\000\377\"\"\"\377\321\321\321\377\374\374\374\377\203\377\377\377"
		"\377\002\375\375\375\377\377\377\377\377\203\376\376\376\377\001MMM\377\212\000"
		"\000\000\377\001\001\001\001\377\202\000\000\000\377\002\020\020\020\377\336\336\336\377\207\377"
		"\377\377\377\002\373\373\373\377EEE\377\215\000\000\000\377\007\347\034\000\377\377\036"
		"\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\261"
		"\377\036\000\377\010\377\034\001\377W\013\000\377\000\001\007\377\005\000\000\377\001\000\002\377\000\001"
		"\000\377\003\000\005\377\000\002\000\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377"
		"\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000"
		"\377\001\300\300\300\377\210\377\377\377\377\001aaa\377\205\000\000\000\377\001\002\002\002"
		"\377\213\000\000\000\377\005\003\003\003\377\000\000\000\377\001\001\001\377***\377\365\365\365\377"
		"\202\377\377\377\377\001\376\376\376\377\202\377\377\377\377\004\374\374\374"
		"\377\377\377\377\377\352\352\352\377\024\024\024\377\224\000\000\000\377\004\005\005\005\377"
		"\000\000\000\377RRR\377\376\376\376\377\202\377\377\377\377\015\376\376\376\377"
		"\377\377\377\377\375\375\375\377\377\377\377\377\374\374\374\377\377\377"
		"\377\377\373\373\373\377\225\225\225\377$$$\377\000\000\000\377\003\003\003\377\000\000\000"
		"\377\003\003\003\377\202\000\000\000\377\022CCC\377\304\304\304\377\377\377\377\377\373"
		"\373\373\377\377\377\377\377\376\376\376\377\377\377\377\377\376\376\376"
		"\377\377\377\377\377\375\375\375\377\377\377\377\377\335\335\335\377\026\026"
		"\026\377\002\002\002\377\000\000\000\377\001\001\001\377<<<\377\367\367\367\377\204\377\377"
		"\377\377\002\375\375\375\377\377\377\377\377\202\374\374\374\377\001\063\063\063"
		"\377\203\000\000\000\377\001\001\001\001\377\212\000\000\000\377\004\001\001\001\377\000\000\000\377\004\004\004"
		"\377\261\261\261\377\202\376\376\376\377\206\377\377\377\377\004\235\235\235"
		"\377\001\001\001\377\000\000\000\377\001\001\001\377\203\000\000\000\377\021\004\004\004\377\000\000\000\377q"
		"qq\377\376\376\376\377\377\377\377\377\375\375\375\377\377\377\377\377\373"
		"\373\373\377\376\376\376\377\377\377\377\377\374\374\374\377\376\376\376"
		"\377\371\371\371\377\205\205\205\377\023\023\023\377\002\002\002\377\004\004\004\377\202"
		"\000\000\000\377\004\003\003\003\377\002\002\002\377PPP\377\323\323\323\377\202\377\377\377\377"
		"\001\374\374\374\377\202\377\377\377\377\001\376\376\376\377\203\377\377\377"
		"\377\003\310\310\310\377\006\006\006\377\003\003\003\377\211\000\000\000\377\001\001\001\001\377\202"
		"\000\000\000\377\002\020\020\020\377\336\336\336\377\207\377\377\377\377\002\373\373\373"
		"\377EEE\377\215\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037"
		"\000\377\377\036\001\377\377\034\002\377\376\037\000\377\261\377\036\000\377\010\377\035"
		"\000\377k\016\000\377\000\001\005\377\004\001\000\377\003\000\002\377\000\002\001\377\003\000\004\377\000\001\000"
		"\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000"
		"\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300\377"
		"\210\377\377\377\377\004\237\237\237\377bbb\377eee\377fff\377\202ddd\377\002"
		"eee\377bbb\377\210ddd\377\001:::\377\203\000\000\000\377\003\003\003\003\377)))\377\365\365"
		"\365\377\202\375\375\375\377\204\377\377\377\377\003\376\376\376\377\361\361"
		"\361\377vvv\377\210ccc\377\211ddd\377\003ggg\377ddd\377\036\036\036\377\202\000"
		"\000\000\377\034\015\015\015\377\301\301\301\377\374\374\374\377\377\377\377\377"
		"\373\373\373\377\377\377\377\377\376\376\376\377\373\373\373\377\377\377"
		"\377\377\375\375\375\377\377\377\377\377\376\376\376\377\346\346\346\377"
		"\252\252\252\377{{{\377```\377kkk\377\211\211\211\377\301\301\301\377\376"
		"\376\376\377\377\377\377\377\376\376\376\377\377\377\377\377\367\367\367"
		"\377\377\377\377\377\376\376\376\377\377\377\377\377\375\375\375\377\202"
		"\376\376\376\377\001ttt\377\202\000\000\000\377\011\003\003\003\377\000\000\000\377rrr\377\377"
		"\377\377\377\376\376\376\377\377\377\377\377\376\376\376\377\377\377\377"
		"\377\376\376\376\377\202\377\377\377\377\006\332\332\332\377\015\015\015\377\000"
		"\000\000\377\003\003\003\377\000\000\000\377\001\001\001\377\212\000\000\000\377\001\002\002\002\377\202\000\000"
		"\000\377\001vvv\377\205\377\377\377\377\016\376\376\376\377\377\377\377\377\376"
		"\376\376\377\326\326\326\377\015\015\015\377\000\000\000\377\001\001\001\377\000\000\000\377\001"
		"\001\001\377\000\000\000\377\003\003\003\377\000\000\000\377\026\026\026\377\331\331\331\377\205\377"
		"\377\377\377\001\375\375\375\377\202\377\377\377\377\014\374\374\374\377\377"
		"\377\377\377\344\344\344\377\243\243\243\377rrr\377bbb\377mmm\377\215\215"
		"\215\377\312\312\312\377\375\375\375\377\377\377\377\377\374\374\374\377"
		"\205\377\377\377\377\005\373\373\373\377\377\377\377\377\375\375\375\377SS"
		"S\377\001\001\001\377\212\000\000\000\377\001\001\001\001\377\202\000\000\000\377\002\020\020\020\377\336"
		"\336\336\377\207\377\377\377\377\002\373\373\373\377EEE\377\215\000\000\000\377\007"
		"\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034"
		"\002\377\376\037\000\377\261\377\036\000\377\007\377\035\000\377\205\020\000\377\000\000\004\377"
		"\002\001\000\377\003\000\000\377\000\002\001\377\003\000\002\377\211\000\000\000\377\010\000\001\000\377\001\000\000"
		"\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000"
		"\377\207\000\000\000\377\001\300\300\300\377\211\377\377\377\377\002\371\371\371\377"
		"\377\377\377\377\202\376\376\376\377\002\377\377\377\377\375\375\375\377\211"
		"\377\377\377\377\007\217\217\217\377\006\006\006\377\000\000\000\377\001\001\001\377\000\000\000\377"
		"'''\377\372\372\372\377\204\377\377\377\377\001\373\373\373\377\203\377\377"
		"\377\377\001\373\373\373\377\220\377\377\377\377\014\376\376\376\377\377\377"
		"\377\377\373\373\373\377VVV\377\000\000\000\377\003\003\003\377\000\000\000\377===\377\366"
		"\366\366\377\377\377\377\377\376\376\376\377\374\374\374\377\203\377\377"
		"\377\377\012\376\376\376\377\377\377\377\377\373\373\373\377\377\377\377\377"
		"\375\375\375\377\376\376\376\377\377\377\377\377\376\376\376\377\375\375"
		"\375\377\377\377\377\377\202\374\374\374\377\203\377\377\377\377\010\375\375"
		"\375\377\376\376\376\377\377\377\377\377\374\374\374\377\377\377\377\377"
		"\301\301\301\377\010\010\010\377\001\001\001\377\203\000\000\000\377\004\251\251\251\377\377"
		"\377\377\377\375\375\375\377\377\377\377\377\202\376\376\376\377\010\377\377"
		"\377\377\376\376\376\377\377\377\377\377\246\246\246\377\001\001\001\377\000\000\000"
		"\377\002\002\002\377\001\001\001\377\216\000\000\000\377\002@@@\377\375\375\375\377\204\377\377"
		"\377\377\005\376\376\376\377\377\377\377\377\376\376\376\377\371\371\371\377"
		",,,\377\203\000\000\000\377\001\002\002\002\377\202\000\000\000\377\004\001\001\001\377\000\000\000\377PPP"
		"\377\370\370\370\377\202\377\377\377\377\005\375\375\375\377\377\377\377\377"
		"\375\375\375\377\377\377\377\377\376\376\376\377\203\377\377\377\377\001\376"
		"\376\376\377\202\377\377\377\377\012\373\373\373\377\376\376\376\377\375\375"
		"\375\377\377\377\377\377\376\376\376\377\377\377\377\377\374\374\374\377"
		"\373\373\373\377\377\377\377\377\374\374\374\377\203\377\377\377\377\004\250"
		"\250\250\377\000\000\000\377\002\002\002\377\001\001\001\377\211\000\000\000\377\001\001\001\001\377\202"
		"\000\000\000\377\002\020\020\020\377\336\336\336\377\207\377\377\377\377\002\373\373\373"
		"\377EEE\377\215\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037"
		"\000\377\377\036\001\377\377\034\002\377\376\037\000\377\262\377\036\000\377\006\240\023\000"
		"\377\001\000\002\377\000\001\000\377\003\000\000\377\000\001\000\377\001\000\000\377\211\000\000\000\377\010\000"
		"\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033"
		"\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300\377\210\377\377\377\377\001\373"
		"\373\373\377\202\377\377\377\377\001\376\376\376\377\202\377\377\377\377\001"
		"\375\375\375\377\211\377\377\377\377\001\216\216\216\377\203\000\000\000\377\003\002"
		"\002\002\377***\377\366\366\366\377\202\376\376\376\377\001\373\373\373\377\204"
		"\377\377\377\377\001\372\372\372\377\221\377\377\377\377\001\376\376\376\377"
		"\202\377\377\377\377\001MMM\377\202\000\000\000\377\004\001\001\001\377\000\000\000\377ooo\377"
		"\371\371\371\377\203\377\377\377\377\001\373\373\373\377\202\377\377\377\377"
		"\006\376\376\376\377\377\377\377\377\376\376\376\377\374\374\374\377\377\377"
		"\377\377\375\375\375\377\202\377\377\377\377\001\376\376\376\377\202\377\377"
		"\377\377\003\375\375\375\377\377\377\377\377\375\375\375\377\202\377\377\377"
		"\377\005\376\376\376\377\377\377\377\377\340\340\340\377$$$\377\002\002\002\377\202"
		"\000\000\000\377\004\003\003\003\377\017\017\017\377\331\331\331\377\376\376\376\377\203\377"
		"\377\377\377\001\375\375\375\377\202\377\377\377\377\004\374\374\374\377sss\377"
		"\000\000\000\377\001\001\001\377\213\000\000\000\377\202\001\001\001\377\012\000\000\000\377\001\001\001\377\000"
		"\000\000\377\030\030\030\377\345\345\345\377\375\375\375\377\377\377\377\377\376"
		"\376\376\377\377\377\377\377\376\376\376\377\203\377\377\377\377\002^^^\377"
		"\001\001\001\377\203\000\000\000\377\003\001\001\001\377\000\000\000\377\001\001\001\377\202\000\000\000\377\001"
		"\206\206\206\377\203\377\377\377\377\003\373\373\373\377\377\377\377\377\375"
		"\375\375\377\202\377\377\377\377\005\373\373\373\377\376\376\376\377\377\377"
		"\377\377\375\375\375\377\376\376\376\377\204\377\377\377\377\001\375\375\375"
		"\377\202\377\377\377\377\001\376\376\376\377\204\377\377\377\377\002\314\314"
		"\314\377\034\034\034\377\202\000\000\000\377\001\001\001\001\377\211\000\000\000\377\001\001\001\001\377"
		"\202\000\000\000\377\002\020\020\020\377\336\336\336\377\207\377\377\377\377\002\373\373"
		"\373\377EEE\377\215\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373"
		"\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\261\377\036\000\377\010\376"
		"\035\000\377\272\025\000\377\003\000\000\377\000\001\000\377\003\000\000\377\000\001\000\377\002\001\000\377"
		"\000\000\002\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374"
		"\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300"
		"\377\211\377\377\377\377\004\375\375\375\377\376\376\376\377\377\377\377\377"
		"\376\376\376\377\213\377\377\377\377\003\215\215\215\377\001\001\001\377\003\003\003\377"
		"\202\000\000\000\377\002(((\377\364\364\364\377\203\377\377\377\377\202\376\376\376"
		"\377\203\377\377\377\377\001\375\375\375\377\220\377\377\377\377\202\376\376"
		"\376\377\005\375\375\375\377JJJ\377\001\001\001\377\000\000\000\377\004\004\004\377\202\000\000\000"
		"\377\002{{{\377\376\376\376\377\202\375\375\375\377\007\377\377\377\377\373\373"
		"\373\377\376\376\376\377\377\377\377\377\376\376\376\377\377\377\377\377"
		"\376\376\376\377\202\377\377\377\377\001\375\375\375\377\203\377\377\377\377"
		"\001\375\375\375\377\202\377\377\377\377\202\376\376\376\377\202\377\377\377"
		"\377\002\337\337\337\377\071\071\071\377\202\000\000\000\377\001\001\001\001\377\202\000\000\000\377"
		"\002\063\063\063\377\366\366\366\377\202\377\377\377\377\002\375\375\375\377\377"
		"\377\377\377\202\376\376\376\377\004\377\377\377\377\372\372\372\377<<<\377"
		"\001\001\001\377\215\000\000\000\377\006\001\001\001\377\000\000\000\377\001\001\001\377\000\000\000\377\003\003\003"
		"\377\267\267\267\377\202\377\377\377\377\002\376\376\376\377\377\377\377\377"
		"\202\376\376\376\377\003\377\377\377\377\374\374\374\377\232\232\232\377\202"
		"\000\000\000\377\003\005\005\005\377\000\000\000\377\001\001\001\377\203\000\000\000\377\004\001\001\001\377\000\000"
		"\000\377\221\221\221\377\375\375\375\377\203\377\377\377\377\001\376\376\376"
		"\377\202\375\375\375\377\001\377\377\377\377\202\376\376\376\377\002\377\377"
		"\377\377\375\375\375\377\202\377\377\377\377\005\374\374\374\377\377\377\377"
		"\377\376\376\376\377\377\377\377\377\373\373\373\377\203\377\377\377\377"
		"\003\371\371\371\377\321\321\321\377(((\377\202\000\000\000\377\001\002\002\002\377\212\000"
		"\000\000\377\001\001\001\001\377\202\000\000\000\377\002\020\020\020\377\336\336\336\377\207\377"
		"\377\377\377\002\373\373\373\377EEE\377\215\000\000\000\377\007\347\034\000\377\377\036"
		"\002\377\377\036\000\377\373\037\000\377\377\036\001\377\377\034\002\377\376\037\000\377\261"
		"\377\036\000\377\010\376\037\000\377\316\030\000\377\010\000\002\377\000\001\000\377\003\000\000\377"
		"\000\001\000\377\002\001\000\377\000\000\002\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003"
		"\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\207\000"
		"\000\000\377\001\300\300\300\377\211\377\377\377\377\001\375\375\375\377\203\377"
		"\377\377\377\003\375\375\375\377\377\377\377\377\376\376\376\377\210\377\377"
		"\377\377\001\215\215\215\377\202\000\000\000\377\013\003\003\003\377\000\000\000\377(((\377\365"
		"\365\365\377\377\377\377\377\375\375\375\377\377\377\377\377\375\375\375"
		"\377\376\376\376\377\377\377\377\377\374\374\374\377\222\377\377\377\377"
		"\001\376\376\376\377\202\377\377\377\377\001NNN\377\202\000\000\000\377\001\002\002\002\377"
		"\202\000\000\000\377\005\002\002\002\377[[[\377\351\351\351\377\376\376\376\377\375\375"
		"\375\377\202\377\377\377\377\001\376\376\376\377\203\377\377\377\377\004\375"
		"\375\375\377\376\376\376\377\377\377\377\377\374\374\374\377\202\377\377"
		"\377\377\003\376\376\376\377\377\377\377\377\371\371\371\377\202\377\377\377"
		"\377\013\376\376\376\377\274\274\274\377'''\377\000\000\000\377\001\001\001\377\000\000\000"
		"\377\002\002\002\377\000\000\000\377\001\001\001\377jjj\377\376\376\376\377\202\377\377\377"
		"\377\001\375\375\375\377\202\377\377\377\377\005\376\376\376\377\377\377\377"
		"\377\336\336\336\377\017\017\017\377\004\004\004\377\202\000\000\000\377\202\001\001\001\377\212"
		"\000\000\000\377\005\001\001\001\377\000\000\000\377\001\001\001\377\000\000\000\377|||\377\207\377\377\377"
		"\377\005\376\376\376\377\317\317\317\377\007\007\007\377\000\000\000\377\001\001\001\377\202"
		"\000\000\000\377\202\001\001\001\377\006\002\002\002\377\000\000\000\377\002\002\002\377\000\000\000\377sss\377"
		"\355\355\355\377\202\377\377\377\377\002\375\375\375\377\373\373\373\377\202"
		"\377\377\377\377\202\376\376\376\377\003\375\375\375\377\377\377\377\377\374"
		"\374\374\377\202\377\377\377\377\012\373\373\373\377\376\376\376\377\377\377"
		"\377\377\375\375\375\377\377\377\377\377\375\375\375\377\374\374\374\377"
		"\262\262\262\377\030\030\030\377\001\001\001\377\215\000\000\000\377\001\001\001\001\377\202\000\000"
		"\000\377\002\020\020\020\377\336\336\336\377\207\377\377\377\377\002\373\373\373\377"
		"EEE\377\215\000\000\000\377\007\347\034\000\377\377\036\002\377\377\036\000\377\373\037\000\377"
		"\377\036\001\377\377\034\002\377\376\037\000\377\261\377\036\000\377\010\376\037\000\377"
		"\332\032\003\377\011\000\001\377\000\002\001\377\003\000\000\377\000\001\000\377\002\001\000\377\000\000\002\377"
		"\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377"
		"\377\035\000\377\335\033\002\377\024\002\000\377\207\000\000\000\377\001\300\300\300\377\210"
		"\377\377\377\377\001\376\376\376\377\202\377\377\377\377\001\374\374\374\377"
		"\214\377\377\377\377\002\215\215\215\377\004\004\004\377\203\000\000\000\377\002,,,\377\367"
		"\367\367\377\202\377\377\377\377\003\375\375\375\377\377\377\377\377\376\376"
		"\376\377\203\377\377\377\377\001\375\375\375\377\221\377\377\377\377\202\376"
		"\376\376\377\003LLL\377\001\001\001\377\002\002\002\377\202\000\000\000\377\001\001\001\001\377\202\000"
		"\000\000\377\004+++\377\247\247\247\377\373\373\373\377\375\375\375\377\203\377"
		"\377\377\377\202\376\376\376\377\202\377\377\377\377\001\375\375\375\377\202"
		"\377\377\377\377\003\376\376\376\377\377\377\377\377\375\375\375\377\202\377"
		"\377\377\377\004\343\343\343\377uuu\377\011\011\011\377\002\002\002\377\202\000\000\000\377"
		"\005\005\005\005\377\000\000\000\377\003\003\003\377\000\000\000\377\233\233\233\377\202\377\377\377"
		"\377\003\376\376\376\377\377\377\377\377\376\376\376\377\203\377\377\377\377"
		"\001\257\257\257\377\202\000\000\000\377\001\003\003\003\377\215\000\000\000\377\006\003\003\003\377\000"
		"\000\000\377\002\002\002\377\000\000\000\377OOO\377\374\374\374\377\205\377\377\377\377\007"
		"\375\375\375\377\377\377\377\377\356\356\356\377'''\377\002\002\002\377\000\000\000\377"
		"\003\003\003\377\204\000\000\000\377\001\001\001\001\377\203\000\000\000\377\003:::\377\266\266\266\377"
		"\375\375\375\377\202\377\377\377\377\001\374\374\374\377\202\377\377\377\377"
		"\001\376\376\376\377\203\377\377\377\377\001\376\376\376\377\205\377\377\377"
		"\377\012\376\376\376\377\330\330\330\377iii\377\001\001\001\377\000\000\000\377\001\001\001"
		"\377\000\000\000\377\003\003\003\377\000\000\000\377\001\001\001\377\211\000\000\000\377\001\001\001\001\377\202"
		"\000\000\000\377\002\020\020\020\377\336\336\336\377\207\377\377\377\377\002\373\373\373"
		"\377EEE\377\215\000\000\000\377\005\366\032\000\377\372\036\000\377\377\040\000\377\376\037"
		"\000\377\376\035\000\377\202\377\036\000\377\001\377\035\000\377\261\377\036\000\377\007\365"
		"!\014\377\040\005\000\377\007\000\005\377\000\003\001\377\000\000\005\377\000\002\001\377\000\000\002\377\210"
		"\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377"
		"\035\000\377\335\033\002\377\024\002\000\377\204\000\000\000\377\001\002\002\002\377\202\000\000\000\377"
		"\001\307\307\307\377\202\377\377\377\377\203\376\376\376\377\001\377\377\377"
		"\377\202\376\376\376\377\214\377\377\377\377\202\376\376\376\377\202\377"
		"\377\377\377\002\222\222\222\377\002\002\002\377\203\000\000\000\377\001)))\377\235\377\377"
		"\377\377\004QQQ\377\000\000\000\377\002\002\002\377\000\000\000\377\202\001\001\001\377\007\000\000\000\377"
		"\001\001\001\377\000\000\000\377\002\002\002\377\067\067\067\377\224\224\224\377\333\333\333\377"
		"\205\377\377\377\377\202\376\376\376\377\202\377\377\377\377\010\376\376\376"
		"\377\377\377\377\377\365\365\365\377\306\306\306\377qqq\377\035\035\035\377"
		"\000\000\000\377\002\002\002\377\203\000\000\000\377\012\002\002\002\377\001\001\001\377\000\000\000\377\016\016"
		"\016\377\336\336\336\377\373\373\373\377\377\377\377\377\375\375\375\377\377"
		"\377\377\377\376\376\376\377\202\377\377\377\377\007\376\376\376\377vvv\377"
		"\003\003\003\377\000\000\000\377\005\005\005\377\000\000\000\377\001\001\001\377\212\000\000\000\377\202\002\002"
		"\002\377\202\000\000\000\377\004\001\001\001\377\033\033\033\377\361\361\361\377\377\377\377"
		"\377\202\376\376\376\377\202\377\377\377\377\202\376\376\376\377\006\377\377"
		"\377\377```\377\000\000\000\377\005\005\005\377\000\000\000\377\001\001\001\377\202\000\000\000\377\002\002"
		"\002\002\377\001\001\001\377\202\000\000\000\377\011\001\001\001\377\000\000\000\377\004\004\004\377EEE\377"
		"\236\236\236\377\337\337\337\377\375\375\375\377\377\377\377\377\375\375"
		"\375\377\205\377\377\377\377\007\376\376\376\377\377\377\377\377\376\376\376"
		"\377\357\357\357\377\300\300\300\377fff\377\021\021\021\377\224\000\000\000\377\005"
		"\022\022\022\377\347\347\347\377\377\377\377\377\375\375\375\377\376\376\376"
		"\377\203\377\377\377\377\003\375\375\375\377\377\377\377\377HHH\377\215\000\000"
		"\000\377\005\313\025\000\377\316\030\002\377\320\032\004\377\321\030\003\377\320\027\002\377"
		"\202\322\030\003\377\001\321\027\002\377\260\322\030\003\377\010\331\024\003\377\307\025"
		"\011\377/\007\000\377\013\000\000\377\000\006\000\377\000\001\000\377\000\002\000\377\011\000\001\377\210"
		"\000\000\000\377\011\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377"
		"\035\000\377\335\033\002\377\024\002\000\377\001\001\001\377\202\000\000\000\377\007\001\001\001\377\002\002"
		"\002\377\000\000\000\377\001\001\001\377\225\225\225\377\312\312\312\377\311\311\311\377"
		"\203\307\307\307\377\202\310\310\310\377\001\307\307\307\377\210\306\306\306"
		"\377\202\307\307\307\377\203\310\310\310\377\004\311\311\311\377\313\313\313"
		"\377\314\314\314\377ooo\377\202\000\000\000\377\005\002\002\002\377\000\000\000\377$$$\377\301"
		"\301\301\377\310\310\310\377\230\306\306\306\377\004\305\305\305\377\313\313"
		"\313\377\306\306\306\377???\377\202\000\000\000\377\001\002\002\002\377\203\000\000\000\377\002"
		"\001\001\001\377\002\002\002\377\202\000\000\000\377\017\004\004\004\377\015\015\015\377<<<\377jjj\377"
		"\230\230\230\377\256\256\256\377\274\274\274\377\313\313\313\377\310\310"
		"\310\377\272\272\272\377\245\245\245\377\207\207\207\377[[[\377'''\377\007"
		"\007\007\377\202\000\000\000\377\001\002\002\002\377\202\000\000\000\377\001\004\004\004\377\203\000\000\000\377"
		"\020\007\007\007\377\036\036\036\377\277\277\277\377\314\314\314\377\312\312\312\377"
		"\307\307\307\377\310\310\310\377\307\307\307\377\312\312\312\377\310\310"
		"\310\377\311\311\311\377\065\065\065\377\000\000\000\377\001\001\001\377\000\000\000\377\004\004\004"
		"\377\215\000\000\000\377\007\003\003\003\377\004\004\004\377\000\000\000\377\002\002\002\377\227\227\227"
		"\377\315\315\315\377\312\312\312\377\204\310\310\310\377\006\312\312\312\377"
		"\315\315\315\377lll\377\003\003\003\377\000\000\000\377\001\001\001\377\202\000\000\000\377\001\003\003"
		"\003\377\202\000\000\000\377\004\001\001\001\377\000\000\000\377\001\001\001\377\002\002\002\377\202\000\000\000"
		"\377\021\004\004\004\377\030\030\030\377CCC\377ooo\377\227\227\227\377\265\265\265"
		"\377\302\302\302\377\310\310\310\377\305\305\305\377\271\271\271\377\245"
		"\245\245\377\204\204\204\377VVV\377\"\"\"\377\002\002\002\377\000\000\000\377\002\002\002\377"
		"\221\000\000\000\377\016\003\003\003\377\001\001\001\377\000\000\000\377\020\020\020\377\255\255\255"
		"\377\314\314\314\377\310\310\310\377\311\311\311\377\305\305\305\377\304"
		"\304\304\377\310\310\310\377\313\313\313\377\302\302\302\377;;;\377\215\000"
		"\000\000\377\202\000\001\002\377\001\000\002\003\377\265\000\000\002\377\010\000\003\000\377\013\002\000\377"
		"\000\002\005\377\001\000\005\377\003\000\000\377\011\000\002\377\000\003\000\377\001\000\000\377\210\000\000\000\377"
		"\022\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335"
		"\033\002\377\024\002\000\377\000\000\000\377\001\001\001\377\004\004\004\377\001\001\001\377\000\000\000\377\010"
		"\010\010\377\000\000\000\377\003\003\003\377\002\002\002\377\001\001\001\377\206\000\000\000\377\210\001\001"
		"\001\377\206\000\000\000\377\002\001\001\001\377\002\002\002\377\202\000\000\000\377\006\001\001\001\377\000\000"
		"\000\377\005\005\005\377\000\000\000\377\003\003\003\377\000\000\000\377\230\001\001\001\377\005\003\003\003\377"
		"\000\000\000\377\005\005\005\377\000\000\000\377\004\004\004\377\202\000\000\000\377\003\001\001\001\377\000\000\000"
		"\377\001\001\001\377\202\000\000\000\377\001\002\002\002\377\202\000\000\000\377\001\002\002\002\377\203\000"
		"\000\000\377\202\001\001\001\377\202\000\000\000\377\004\001\001\001\377\003\003\003\377\000\000\000\377\003\003"
		"\003\377\202\000\000\000\377\202\002\002\002\377\004\000\000\000\377\002\002\002\377\000\000\000\377\001\001\001"
		"\377\204\000\000\000\377\005\004\004\004\377\002\002\002\377\001\001\001\377\000\000\000\377\001\001\001\377\202"
		"\000\000\000\377\006\001\001\001\377\000\000\000\377\001\001\001\377\000\000\000\377\001\001\001\377\003\003\003\377"
		"\202\000\000\000\377\001\003\003\003\377\213\000\000\000\377\001\001\001\001\377\202\000\000\000\377\004\010\010"
		"\010\377\000\000\000\377\003\003\003\377\001\001\001\377\206\000\000\000\377\006\001\001\001\377\004\004\004\377"
		"\000\000\000\377\002\002\002\377\000\000\000\377\002\002\002\377\202\000\000\000\377\001\002\002\002\377\205\000"
		"\000\000\377\002\003\003\003\377\002\002\002\377\204\000\000\000\377\001\002\002\002\377\202\000\000\000\377\003"
		"\002\002\002\377\000\000\000\377\002\002\002\377\202\000\000\000\377\004\002\002\002\377\001\001\001\377\000\000\000"
		"\377\001\001\001\377\221\000\000\000\377\001\001\001\001\377\202\000\000\000\377\003\005\005\005\377\000\000\000"
		"\377\005\005\005\377\204\000\000\000\377\001\003\003\003\377\202\000\000\000\377\003\006\006\006\377\000\000\000"
		"\377\002\002\002\377\215\000\000\000\377\202\001\001\001\377\002\000\000\000\377\001\000\000\377\202\002\000"
		"\001\377\001\001\000\000\377\260\002\000\001\377\010\000\004\007\377\000\002\000\377\005\004\002\377\001\000\000\377"
		"\000\001\000\377\003\000\000\377\000\002\000\377\002\002\000\377\210\000\000\000\377\010\000\001\000\377\001\000\000"
		"\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000"
		"\377\203\000\000\000\377\001\003\003\003\377\204\000\000\000\377\001\001\001\001\377\217\000\000\000\377\203"
		"\002\002\002\377\001\001\001\001\377\203\000\000\000\377\204\001\001\001\377\003\002\002\002\377\000\000\000\377"
		"\003\003\003\377\234\000\000\000\377\202\001\001\001\377\202\000\000\000\377\001\003\003\003\377\202\000\000"
		"\000\377\001\003\003\003\377\202\000\000\000\377\003\002\002\002\377\001\001\001\377\000\000\000\377\202\002\002"
		"\002\377\202\000\000\000\377\002\001\001\001\377\002\002\002\377\202\000\000\000\377\202\001\001\001\377\202"
		"\000\000\000\377\001\002\002\002\377\203\000\000\000\377\001\001\001\001\377\205\000\000\000\377\001\001\001\001\377"
		"\202\000\000\000\377\001\001\001\001\377\202\000\000\000\377\004\003\003\003\377\001\001\001\377\000\000\000\377"
		"\002\002\002\377\202\000\000\000\377\001\003\003\003\377\202\000\000\000\377\004\002\002\002\377\000\000\000\377"
		"\001\001\001\377\003\003\003\377\210\000\000\000\377\001\002\002\002\377\202\000\000\000\377\001\002\002\002\377"
		"\202\000\000\000\377\001\001\001\001\377\204\000\000\000\377\202\002\002\002\377\204\000\000\000\377\004\005"
		"\005\005\377\001\001\001\377\000\000\000\377\001\001\001\377\203\000\000\000\377\004\002\002\002\377\000\000\000\377"
		"\001\001\001\377\002\002\002\377\202\000\000\000\377\003\001\001\001\377\000\000\000\377\002\002\002\377\202\000"
		"\000\000\377\004\003\003\003\377\001\001\001\377\000\000\000\377\002\002\002\377\203\000\000\000\377\001\002\002\002"
		"\377\202\000\000\000\377\002\001\001\001\377\002\002\002\377\225\000\000\000\377\005\002\002\002\377\000\000\000"
		"\377\002\002\002\377\000\000\000\377\002\002\002\377\203\000\000\000\377\003\003\003\003\377\000\000\000\377\001"
		"\001\001\377\215\000\000\000\377\203\000\001\000\377\265\001\000\000\377\202\000\001\000\377\006\000\004\000"
		"\377\000\001\000\377\002\000\005\377\000\001\004\377\001\000\002\377\000\002\000\377\210\000\000\000\377\012\000"
		"\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335\033"
		"\002\377\024\002\000\377\003\003\003\377\001\001\001\377\202\000\000\000\377\005\002\002\002\377\000\000\000\377"
		"\001\001\001\377\000\000\000\377\001\001\001\377\232\000\000\000\377\005\001\001\001\377\000\000\000\377\002\002\002"
		"\377\000\000\000\377\002\002\002\377\230\000\000\000\377\202\002\002\002\377\002\000\000\000\377\001\001\001\377"
		"\202\000\000\000\377\001\001\001\001\377\206\000\000\000\377\202\001\001\001\377\202\000\000\000\377\002\002"
		"\002\002\377\003\003\003\377\203\000\000\000\377\202\002\002\002\377\003\000\000\000\377\001\001\001\377\003\003"
		"\003\377\202\000\000\000\377\002\002\002\002\377\001\001\001\377\203\000\000\000\377\002\003\003\003\377\001\001"
		"\001\377\203\000\000\000\377\003\002\002\002\377\000\000\000\377\001\001\001\377\205\000\000\000\377\001\001\001"
		"\001\377\202\000\000\000\377\001\003\003\003\377\202\000\000\000\377\001\004\004\004\377\216\000\000\000\377"
		"\003\002\002\002\377\000\000\000\377\001\001\001\377\211\000\000\000\377\001\001\001\001\377\202\000\000\000\377"
		"\001\005\005\005\377\202\000\000\000\377\002\001\001\001\377\002\002\002\377\205\000\000\000\377\202\001\001\001"
		"\377\001\000\000\000\377\202\001\001\001\377\205\000\000\000\377\002\001\001\001\377\003\003\003\377\233\000"
		"\000\000\377\003\004\004\004\377\000\000\000\377\002\002\002\377\202\000\000\000\377\005\001\001\001\377\000\000\000"
		"\377\002\002\002\377\001\001\001\377\000\000\000\377\202\002\002\002\377\214\000\000\000\377\270\000\000\002"
		"\377\010\011\000\004\377\010\000\012\377\000\003\000\377\000\000\004\377\002\000\014\377\000\000\005\377\007"
		"\000\004\377\001\001\001\377\210\000\000\000\377\010\000\001\000\377\001\000\000\377A\007\003\377\375\036\000"
		"\377\374\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\202\000\000\000\377\002\003"
		"\003\003\377\001\001\001\377\203\000\000\000\377\001\002\002\002\377\226\000\000\000\377\202\001\001\001\377"
		"\002\000\000\000\377\004\004\004\377\204\000\000\000\377\001\003\003\003\377\232\000\000\000\377\003\001\001\001\377"
		"\000\000\000\377\003\003\003\377\203\000\000\000\377\001\002\002\002\377\202\000\000\000\377\002\003\003\003\377"
		"\001\001\001\377\204\000\000\000\377\001\001\001\001\377\202\000\000\000\377\002\001\001\001\377\002\002\002\377"
		"\204\000\000\000\377\202\002\002\002\377\202\000\000\000\377\001\001\001\001\377\206\000\000\000\377\202"
		"\001\001\001\377\203\000\000\000\377\001\003\003\003\377\202\000\000\000\377\202\001\001\001\377\202\000\000"
		"\000\377\002\002\002\002\377\001\001\001\377\202\000\000\000\377\001\001\001\001\377\202\000\000\000\377\001\001"
		"\001\001\377\212\000\000\000\377\002\002\002\002\377\001\001\001\377\202\000\000\000\377\002\001\001\001\377\002"
		"\002\002\377\202\001\001\001\377\204\000\000\000\377\202\001\001\001\377\002\000\000\000\377\004\004\004\377"
		"\203\000\000\000\377\001\006\006\006\377\203\000\000\000\377\001\002\002\002\377\202\001\001\001\377\001\002\002"
		"\002\377\204\000\000\000\377\004\002\002\002\377\001\001\001\377\000\000\000\377\001\001\001\377\205\000\000\000"
		"\377\003\001\001\001\377\003\003\003\377\002\002\002\377\202\000\000\000\377\001\001\001\001\377\222\000\000\000"
		"\377\002\002\002\002\377\001\001\001\377\203\000\000\000\377\003\002\002\002\377\000\000\000\377\002\002\002\377"
		"\203\000\000\000\377\003\001\001\001\377\000\000\000\377\001\001\001\377\214\000\000\000\377\270\000\002\000\377"
		"\010\000\003\000\377\007\000\000\377\000\005\000\377\002\002\000\377\001\000\000\377\001\004\000\377\000\003\001\377"
		"\000\002\004\377\210\000\000\000\377\017\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374"
		"\040\000\377\377\035\000\377\335\033\002\377\024\002\000\377\000\000\000\377\004\004\004\377\001\001\001"
		"\377\000\000\000\377\004\004\004\377\002\002\002\377\000\000\000\377\211\001\001\001\377\210\000\000\000\377"
		"\202\001\001\001\377\211\000\000\000\377\002\002\002\002\377\006\006\006\377\202\000\000\000\377\001\002\002\002"
		"\377\230\000\000\000\377\001\002\002\002\377\202\000\000\000\377\002\002\002\002\377\001\001\001\377\207\000"
		"\000\000\377\001\001\001\001\377\202\002\002\002\377\202\000\000\000\377\002\001\001\001\377\002\002\002\377\202"
		"\000\000\000\377\002\001\001\001\377\002\002\002\377\203\001\001\001\377\003\000\000\000\377\001\001\001\377\002\002"
		"\002\377\202\000\000\000\377\002\002\002\002\377\001\001\001\377\202\002\002\002\377\204\000\000\000\377\001"
		"\002\002\002\377\204\000\000\000\377\202\001\001\001\377\204\000\000\000\377\001\003\003\003\377\202\000\000"
		"\000\377\003\003\003\003\377\000\000\000\377\001\001\001\377\211\000\000\000\377\001\005\005\005\377\202\000\000"
		"\000\377\002\002\002\002\377\003\003\003\377\214\000\000\000\377\002\001\001\001\377\003\003\003\377\203\000\000"
		"\000\377\002\002\002\002\377\003\003\003\377\203\000\000\000\377\001\002\002\002\377\202\000\000\000\377\003\002"
		"\002\002\377\000\000\000\377\001\001\001\377\203\000\000\000\377\202\001\001\001\377\003\003\003\003\377\000\000"
		"\000\377\001\001\001\377\204\000\000\000\377\001\001\001\001\377\221\000\000\000\377\001\002\002\002\377\202"
		"\000\000\000\377\003\003\003\003\377\001\001\001\377\002\002\002\377\203\000\000\000\377\005\001\001\001\377\000\000"
		"\000\377\001\001\001\377\000\000\000\377\002\002\002\377\216\000\000\000\377\203\001\000\002\377\202\002\000"
		"\003\377\202\001\000\002\377\001\002\000\003\377\260\001\000\002\377\010\000\004\002\377\002\000\023\377\000"
		"\001\000\377\005\001\000\377\001\000\000\377\010\000\000\377\000\001\000\377\010\000\005\377\210\000\000\000\377"
		"\011\000\001\000\377\001\000\000\377A\007\003\377\375\036\000\377\374\040\000\377\377\035\000\377\335"
		"\033\002\377\024\002\000\377\002\002\002\377\202\000\000\000\377\001\003\003\003\377\202\000\000\000\377\001"
		"\001\001\001\377\231\000\000\000\377\001\001\001\001\377\202\000\000\000\377\001\002\002\002\377\202\000\000\000"
		"\377\001\002\002\002\377\232\000\000\000\377\001\002\002\002\377\203\000\000\000\377\002\001\001\001\377\002\002"
		"\002\377\202\000\000\000\377\202\001\001\001\377\205\000\000\000\377\001\001\001\001\377\212\000\000\000\377"
		"\001\001\001\001\377\202\000\000\000\377\001\001\001\001\377\205\000\000\000\377\001\002\002\002\377\202\000\000"
		"\000\377\001\001\001\001\377\202\000\000\000\377\001\002\002\002\377\206\000\000\000\377\001\001\001\001\377\202"
		"\000\000\000\377\001\002\002\002\377\213\000\000\000\377\001\001\001\001\377\202\000\000\000\377\001\004\004\004\377"
		"\202\000\000\000\377\001\001\001\001\377\202\000\000\000\377\001\001\001\001\377\204\000\000\000\377\003\001\001"
		"\001\377\000\000\000\377\001\001\001\377\202\000\000\000\377\001\001\001\001\377\202\000\000\000\377\001\002\002"
		"\002\377\203\000\000\000\377\001\001\001\001\377\203\000\000\000\377\003\001\001\001\377\000\000\000\377\001\001"
		"\001\377\202\000\000\000\377\001\001\001\001\377\204\000\000\000\377\001\002\002\002\377\202\000\000\000\377"
		"\003\001\001\001\377\003\003\003\377\001\001\001\377\224\000\000\000\377\001\001\001\001\377\202\000\000\000\377"
		"\203\001\001\001\377\203\000\000\000\377\001\002\002\002\377\202\000\000\000\377\202\001\001\001\377\324"
		"\000\000\000\377\010\000\001\000\377\000\000\005\377E\007\000\377\377\035\007\377\377\034\000\377\356"
		"$\000\377\347\033\003\377\016\004\000\377\377\000\000\000\377\377\000\000\000\377\246\000\000\000\377"
		"\010\010\000\000\377\000\004\000\377F\011\000\377\341\030\000\377\366\031\000\377\355\032\005\377"
		"\307\017\007\377\024\004\005\377\377\000\000\000\377\377\000\000\000\377\246\000\000\000\377\010\001\006"
		"\000\377\000\000\011\377\000\000\014\377\005\001\002\377\000\001\000\377\001\004\000\377\014\005\000\377\000\000"
		"\004\377\377\000\000\000\377\377\000\000\000\377\246\000\000\000\377\010\010\000\000\377\000\000\000\377"
		"\000\004\007\377\000\005\002\377\000\003\000\377\003\001\002\377\004\000\000\377\006\000\006\377\377\000\000\000\377"
		"\377\000\000\000\377\246\000\000\000\377\010\000\001\000\377\000\002\000\377\000\000\000\377\003\000\004\377\001"
		"\000\004\377\001\002\006\377\000\000\004\377\000\005\000\377\377\000\000\000\377\377\000\000\000\377\246\000"
		"\000\000\377\010\000\002\000\377\005\003\004\377\000\007\000\377\001\003\000\377\007\000\000\377\003\000\000\377\000"
		"\000\000\377\000\002\000\377\377\000\000\000\377\377\000\000\000\377\246\000\000\000\377\010\004\000\000\377"
		"\000\000\007\377\004\000\000\377\006\000\002\377\000\000\005\377\000\001\000\377\005\000\003\377\000\001\000\377\377"
		"\000\000\000\377\377\000\000\000\377\246\000\000\000\377\010\001\000\000\377\000\000\013\377\001\002\000\377"
		"\000\004\000\377\000\000\000\377\006\000\000\377\000\002\004\377\001\000\011\377\377\000\000\000\377\377\000\000"
		"\000\377\377\000\000\000\377\377\000\000\000\377\377\000\000\000\377\377\000\000\000\377\377\000\000\000"
		"\377\377\000\000\000\377\377\000\000\000\377\377\000\000\000\377\377\000\000\000\377\377\000\000\000\377"
		"\377\000\000\000\377\377\000\000\000\377\377\000\000\000\377\377\000\000\000\377\377\000\000\000\377\377"
		"\000\000\000\377\377\000\000\000\377\377\000\000\000\377\320\000\000\000\377",
};

#endif // #ifndef INCLUDE_SDL_SPLASH_H
