/*
 * Wolfenstein: Enemy Territory GPL Source Code
 * Copyright (C) 1999-2010 id Software LLC, a ZeniMax Media company.
 *
 * ET: Legacy
 * Copyright (C) 2012-2018 ET:Legacy team <mail@etlegacy.com>
 *
 * This file is part of ET: Legacy - http://www.etlegacy.com
 *
 * ET: Legacy is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ET: Legacy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ET: Legacy. If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, Wolfenstein: Enemy Territory GPL Source Code is also
 * subject to certain additional terms. You should have received a copy
 * of these additional terms immediately following the terms and conditions
 * of the GNU General Public License which accompanied the source code.
 * If not, please request a copy in writing from id Software at the address below.
 *
 * id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.
 */
/**
 * @file sdl_icon.h
 * @brief GIMP RGBA C-Source image dump (sdl_icon.h)
 */

#ifndef INCLUDE_SDL_ICON_H
#define INCLUDE_SDL_ICON_H

static const struct
{
	unsigned int width;
	unsigned int height;
	unsigned int bytes_per_pixel;     // 2:RGB16, 3:RGB, 4:RGBA
	unsigned char pixel_data[64 * 64 * 4 + 1];
} CLIENT_WINDOW_ICON =
{
	64,                                                                                       64, 4,
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0!\36\36\34\217*+(\351,-*\364-.+\366"
	"-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366-."
	"+\366-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366"
	"-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366-."
	"+\366-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366-.+\366--*\364*+(\351"
	"\36\37\34\224\0\0\0&\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\23\23\22w45"
	"1\377@A;\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	">?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?"
	":\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	">?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?"
	":\377>?:\377>?:\377>?:\377>?:\377?@;\377672\377\25\25\24\204\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\20\21\20b<=8\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>"
	"?:\377>?:\377>B=\377>A<\377?@;\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:"
	"\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	">?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?"
	":\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	">?:\377=>9\377\24\25\22q\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\10" "01-\377>?:\377>?:\377>?:\377>"
	                                            "?:\377>?:\377>?:\377>?:\377>?:\377>B=\377w\7\7\377\234\11\10\377r\26\25\377"
	                                            "L#\40\377;'$\3774.*\3773=8\377=B=\377>B=\377?A;\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?"
	                                            ":\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\37723/\377\0\0\0\21"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\16\17\15dAB<\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            "=B=\377\250\4\4\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\376\0"
	                                            "\0\377\320\0\0\377\252\2\2\377\236\7\6\377{\22\20\377O\"\37\377;(%\37728"
	                                            "4\377?A<\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?"
	                                            ":\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377@A<\377\22\22"
	                                            "\20l\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0!\"\37\235?@;\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?"
	                                            ":\377=B=\377\250\4\4\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
	                                            "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
	                                            "\377\0\0\377\341\0\0\377m\23\21\377:=8\377>?:\377>?:\377>?:\377>?:\377>?"
	                                            ":\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?"
	                                            ":\377>?:\377?@;\377%%#\263\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0&'$\274?@;\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377>?:\377=B=\377\250\4\4\377\377\0\0\377\377\0\0\377\377\0\0"
	                                            "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
	                                            "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\205\12\11\377<A<\377"
	                                            ">?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?"
	                                            ":\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377>?:\377>?:\377>?:\377>?:\377))&\320\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0&'$\274?@;\377>?:\377>?:"
	                                            "\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377=B=\377\250\4\4\377\377\0\0"
	                                            "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
	                                            "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
	                                            "\377\377\0\0\3779'$\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?"
	                                            ":\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377))&\320"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "&'$\274?@;\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377=B"
	                                            "=\377\245\4\4\377\373\0\0\377\373\0\0\377\373\0\0\377\373\0\0\377\373\0\0"
	                                            "\377\373\0\0\377\373\0\0\377\373\0\0\377\373\0\0\377\373\0\0\377\377\0\0"
	                                            "\377\177\16\14\3773*&\3777)&\377>50\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?"
	                                            ":\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377))&\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0&'$\274?@;\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?"
	                                            ":\377>?:\377=B=\377\243\4\4\377\367\0\0\377\367\0\0\377\367\0\0\377\367\0"
	                                            "\0\377\367\0\0\377\367\0\0\377\367\0\0\377\367\0\0\377\367\0\0\377\372\0"
	                                            "\0\377v\16\15\377=B=\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?"
	                                            ":\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377))&\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0&'$\274?@;\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:"
	                                            "\377>?:\377>?:\377=B=\377\240\4\4\377\363\0\0\377\363\0\0\377\363\0\0\377"
	                                            "\363\0\0\377\363\0\0\377\363\0\0\377\363\0\0\377\363\0\0\377\363\0\0\377"
	                                            "\365\0\0\377./,\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?"
	                                            ":\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377))&\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0&'$\274?@;\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:"
	                                            "\377>?:\377>?:\377=B=\377\236\4\4\377\356\0\0\377\356\0\0\377\356\0\0\377"
	                                            "\356\0\0\377\356\0\0\377\356\0\0\377\356\0\0\377\356\0\0\377\356\0\0\377"
	                                            "\275\0\0\3776?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?"
	                                            ":\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377))&\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0&'$\274?@;\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:"
	                                            "\377>?:\377>?:\377=B=\377\233\4\4\377\352\0\0\377\352\0\0\377\352\0\0\377"
	                                            "\352\0\0\377\352\0\0\377\352\0\0\377\352\0\0\377\352\0\0\377\352\0\0\377"
	                                            "\257\0\1\3779A<\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?"
	                                            ":\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377))&\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0&'$\274?@;\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:"
	                                            "\377>?:\377>?:\377=B=\377\230\4\4\377\346\0\0\377\346\0\0\377\346\0\0\377"
	                                            "\346\0\0\377\346\0\0\377\346\0\0\377\346\0\0\377\346\0\0\377\346\0\0\377"
	                                            "\251\1\1\377(;6\377-95\377-95\377-95\377-95\377-95\377-95\377-95\377-95\377"
	                                            "-95\377-95\377-95\377-95\377-95\377-95\377-95\377-95\377-95\377-95\377-9"
	                                            "5\377-95\377-95\377-95\377-95\377-95\377-95\377-95\3778:5\377>?:\377>?:\377"
	                                            ">?:\377>?:\377))&\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0&'$\274?@;\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:"
	                                            "\377>?:\377>?:\377=B=\377\226\4\4\377\342\0\0\377\342\0\0\377\342\0\0\377"
	                                            "\342\0\0\377\342\0\0\377\342\0\0\377\342\0\0\377\342\0\0\377\342\0\0\377"
	                                            "\341\0\0\377\324\0\0\377\324\0\0\377\324\0\0\377\324\0\0\377\324\0\0\377"
	                                            "\324\0\0\377\324\0\0\377\324\0\0\377\324\0\0\377\324\0\0\377\324\0\0\377"
	                                            "\324\0\0\377\324\0\0\377\324\0\0\377\324\0\0\377\324\0\0\377\324\0\0\377"
	                                            "\324\0\0\377\324\0\0\377\324\0\0\377\324\0\0\377\324\0\0\377\324\0\0\377"
	                                            "\324\0\0\377\324\0\0\377\326\0\0\377\242\0\0\37763/\377>?:\377>?:\377>?:"
	                                            "\377>?:\377))&\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0&'$\274?@;\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377=B=\377\222\4\4\377\335\0\0\377\335\0\0\377\335\0\0\377\335"
	                                            "\0\0\377\335\0\0\377\335\0\0\377\335\0\0\377\335\0\0\377\335\0\0\377\335"
	                                            "\0\0\377\335\0\0\377\335\0\0\377\335\0\0\377\335\0\0\377\335\0\0\377\335"
	                                            "\0\0\377\335\0\0\377\335\0\0\377\335\0\0\377\335\0\0\377\335\0\0\377\335"
	                                            "\0\0\377\335\0\0\377\335\0\0\377\335\0\0\377\335\0\0\377\335\0\0\377\335"
	                                            "\0\0\377\335\0\0\377\335\0\0\377\335\0\0\377\335\0\0\377\335\0\0\377\335"
	                                            "\0\0\377\337\0\0\377\246\2\2\377383\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            "))&\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0&'$\274?@;\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:"
	                                            "\377>B=\377\220\4\4\377\331\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\331"
	                                            "\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\331"
	                                            "\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\331"
	                                            "\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\331"
	                                            "\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\331"
	                                            "\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\334\0\0\377\240"
	                                            "\3\3\377595\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377))&\320\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0&'$\274?"
	                                            "@;\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>B=\377\215"
	                                            "\4\4\377\325\0\0\377\325\0\0\377\325\0\0\377\325\0\0\377\325\0\0\377\325"
	                                            "\0\0\377\325\0\0\377\325\0\0\377\325\0\0\377\325\0\0\377\325\0\0\377\325"
	                                            "\0\0\377\325\0\0\377\325\0\0\377\325\0\0\377\325\0\0\377\325\0\0\377\325"
	                                            "\0\0\377\325\0\0\377\325\0\0\377\325\0\0\377\325\0\0\377\325\0\0\377\325"
	                                            "\0\0\377\325\0\0\377\325\0\0\377\325\0\0\377\325\0\0\377\325\0\0\377\325"
	                                            "\0\0\377\325\0\0\377\325\0\0\377\330\0\0\377\227\3\3\377495\377>?:\377>?"
	                                            ":\377>?:\377>?:\377>?:\377>?:\377>?:\377))&\320\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0&'$\274?@;\377>?:\377>?:\377"
	                                            ">?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>B=\377\212\4\4\377\320\0\0\377"
	                                            "\320\0\0\377\320\0\0\377\320\0\0\377\320\0\0\377\320\0\0\377\320\0\0\377"
	                                            "\320\0\0\377\320\0\0\377\324\0\0\377\332\0\0\377\332\0\0\377\332\0\0\377"
	                                            "\332\0\0\377\332\0\0\377\332\0\0\377\332\0\0\377\332\0\0\377\332\0\0\377"
	                                            "\332\0\0\377\332\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377"
	                                            "\331\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377\331\0\0\377"
	                                            "\333\0\0\377\220\4\4\3775:5\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377))&\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0&'$\274?@;\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:"
	                                            "\377>?:\377>?:\377>B=\377\210\4\4\377\314\0\0\377\314\0\0\377\314\0\0\377"
	                                            "\314\0\0\377\314\0\0\377\314\0\0\377\314\0\0\377\314\0\0\377\314\0\0\377"
	                                            "\216\2\2\377--)\377/+'\377/+'\377/+'\377/+'\377/+'\377/+'\377/+'\377/+'\377"
	                                            "/+'\377/+'\3773,)\3773,)\3773,)\3773,)\3773,)\3773,)\3773,)\3773,)\3773,"
	                                            ")\3773,)\3773,)\377995\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377))&\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0&'$\274?@;\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:"
	                                            "\377>?:\377>?:\377>B=\377\205\4\4\377\310\0\0\377\310\0\0\377\310\0\0\377"
	                                            "\310\0\0\377\310\0\0\377\310\0\0\377\310\0\0\377\310\0\0\377\310\0\0\377"
	                                            "\215\1\1\377>C>\377?@;\377?@;\377?@;\377?@;\377?@;\377?@;\377?@;\377?@;\377"
	                                            "?@;\377?@;\377?@;\377?@;\377?@;\377?@;\377?@;\377?@;\377?@;\377?@;\377?@"
	                                            ";\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377))&\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0&'$\274?@;\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:"
	                                            "\377>?:\377>?:\377>B=\377\202\4\4\377\304\0\0\377\304\0\0\377\304\0\0\377"
	                                            "\304\0\0\377\304\0\0\377\304\0\0\377\304\0\0\377\304\0\0\377\304\0\0\377"
	                                            "\235\1\1\377O\33\31\377Q\32\30\377Q\32\30\377Q\32\30\377Q\32\30\377Q\32\30"
	                                            "\377Q\32\30\377Q\32\30\377Q\32\30\377Q\32\30\377Q\32\30\377Q\32\30\377Q\32"
	                                            "\30\377Q\32\30\377Q\32\30\377Q\32\30\377Q\32\30\377Q\32\30\377T\32\30\377"
	                                            "4\32\30\377?@;\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377>?:\377"
	                                            ">?:\377>?:\377>?:\377))&\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0%&$\274=>9\377<>8\377<>8\377<>8\377<>8\377<>"
	                                            "8\377<>8\377<>8\377<>8\377<@;\377\177\5\4\377\277\0\0\377\277\0\0\377\277"
	                                            "\0\0\377\277\0\0\377\277\0\0\377\277\0\0\377\277\0\0\377\277\0\0\377\277"
	                                            "\0\0\377\300\0\0\377\304\0\0\377\303\0\0\377\303\0\0\377\303\0\0\377\303"
	                                            "\0\0\377\303\0\0\377\303\0\0\377\303\0\0\377\303\0\0\377\303\0\0\377\303"
	                                            "\0\0\377\303\0\0\377\303\0\0\377\303\0\0\377\303\0\0\377\303\0\0\377\303"
	                                            "\0\0\377\306\0\0\377\207\3\3\377694\377<=8\377<>8\377<>8\377<>8\377<>8\377"
	                                            "<>8\377<>8\377<>8\377<>8\377<>8\377<>8\377=>9\377((%\320\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0$%\"\274;<7\377:"
	                                            "<6\377:<6\377:<6\377:<6\377:<6\377:<6\377:<6\377:<6\377:>9\377|\4\4\377\273"
	                                            "\0\0\377\273\0\0\377\273\0\0\377\273\0\0\377\273\0\0\377\273\0\0\377\273"
	                                            "\0\0\377\273\0\0\377\273\0\0\377\273\0\0\377\273\0\0\377\273\0\0\377\273"
	                                            "\0\0\377\273\0\0\377\273\0\0\377\273\0\0\377\273\0\0\377\273\0\0\377\273"
	                                            "\0\0\377\273\0\0\377\273\0\0\377\273\0\0\377\273\0\0\377\273\0\0\377\273"
	                                            "\0\0\377\273\0\0\377\275\0\0\377\204\3\3\377272\377:;6\377:<6\377:<6\377"
	                                            ":<6\377:<6\377:<6\377:<6\377:<6\377:<6\377:<6\377:<6\377:<6\377;<7\377&'"
	                                            "$\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0$#\40\2749:5\377894\377894\377894\377894\377894\377894\377894\377894"
	                                            "\3778<7\377y\4\4\377\267\0\0\377\267\0\0\377\267\0\0\377\267\0\0\377\267"
	                                            "\0\0\377\267\0\0\377\267\0\0\377\267\0\0\377\267\0\0\377\267\0\0\377\267"
	                                            "\0\0\377\267\0\0\377\267\0\0\377\267\0\0\377\267\0\0\377\267\0\0\377\267"
	                                            "\0\0\377\267\0\0\377\267\0\0\377\267\0\0\377\267\0\0\377\267\0\0\377\267"
	                                            "\0\0\377\267\0\0\377\267\0\0\377\271\0\0\377\204\3\3\377040\377894\37789"
	                                            "4\377894\377894\377894\377894\377894\377894\377894\377894\377894\377894\377"
	                                            "894\377995\377%%\"\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\"\"\37\274773\377662\377662\377662\377662\377662\377"
	                                            "662\377662\377662\377695\377v\4\4\377\262\0\0\377\262\0\0\377\262\0\0\377"
	                                            "\262\0\0\377\262\0\0\377\262\0\0\377\262\0\0\377\262\0\0\377\262\0\0\377"
	                                            "\263\0\0\377\266\0\0\377\266\0\0\377\266\0\0\377\266\0\0\377\266\0\0\377"
	                                            "\266\0\0\377\266\0\0\377\265\0\0\377\265\0\0\377\265\0\0\377\265\0\0\377"
	                                            "\265\0\0\377\265\0\0\377\265\0\0\377\266\0\0\377\202\2\2\377.1.\377662\377"
	                                            "662\377662\377662\377662\377662\377662\377662\377662\377662\377662\37766"
	                                            "2\377662\377662\377773\377$$\40\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\40\40\36\274551\377440\377440\377440\377"
	                                            "440\377440\377440\377440\377440\377473\377t\4\4\377\256\0\0\377\256\0\0\377"
	                                            "\256\0\0\377\256\0\0\377\256\0\0\377\256\0\0\377\256\0\0\377\256\0\0\377"
	                                            "\256\0\0\377\213\1\1\377F\27\25\377H\26\24\377H\26\24\377H\26\24\377H\26"
	                                            "\24\377H\26\24\377H\26\24\377N\25\23\377Q\24\22\377Q\24\22\377Q\24\22\377"
	                                            "Q\24\22\377Q\24\22\377Q\24\22\377Q\24\22\377..*\377440\377440\377440\377"
	                                            "440\377440\377440\377440\377440\377440\377440\377440\377440\377440\37744"
	                                            "0\377440\377551\377\"\"\40\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\37\37\34\27433/\37722.\37722.\37722.\3772"
	                                            "2.\37722.\37722.\37722.\37722.\377251\377q\4\3\377\252\0\0\377\252\0\0\377"
	                                            "\252\0\0\377\252\0\0\377\252\0\0\377\252\0\0\377\252\0\0\377\252\0\0\377"
	                                            "\252\0\0\377w\1\1\377262\37733/\37733/\37733/\37733/\37733/\37733/\37733"
	                                            "/\37733/\37733/\37733/\37733/\37733/\37733/\37733/\37722.\37722.\37722.\377"
	                                            "22.\37722.\37722.\37722.\37722.\37722.\37722.\37722.\37722.\37722.\37722"
	                                            ".\37722.\37722.\37733/\377\40\40\37\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\36\36\33\27411-\37700-\37700-\377"
	                                            "00-\37700-\37700-\37700-\37700-\37700-\37703/\377m\4\3\377\245\0\0\377\245"
	                                            "\0\0\377\245\0\0\377\245\0\0\377\245\0\0\377\245\0\0\377\245\0\0\377\245"
	                                            "\0\0\377\245\0\0\377t\1\1\37703/\37700-\37711-\37711-\37711-\37711-\3771"
	                                            "1-\37711-\37711-\37711.\37711.\37711.\37711-\37700-\37700-\37700-\37700-"
	                                            "\37700-\37700-\37700-\37700-\37700-\37700-\37700-\37700-\37700-\37700-\377"
	                                            "00-\37700-\37700-\37700-\37711-\377\40\40\36\320\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\34\34\33\274//,\377..,\377"
	                                            "..,\377..,\377..,\377..,\377..,\377..,\377..,\377.1.\377k\3\3\377\241\0\0"
	                                            "\377\241\0\0\377\241\0\0\377\241\0\0\377\241\0\0\377\241\0\0\377\241\0\0"
	                                            "\377\241\0\0\377\241\0\0\377|\1\1\377-\34\32\377/\33\31\3773\33\31\3775\30"
	                                            "\27\3776\31\27\377:\30\27\377;\26\25\377@\26\25\377A\26\25\377D\23\22\377"
	                                            "G\24\22\3774\22\21\377--*\377..,\377..,\377..,\377..,\377..,\377..,\377."
	                                            ".,\377..,\377..,\377..,\377..,\377..,\377..,\377..,\377..,\377..,\377..,"
	                                            "\377..,\377//,\377\37\37\35\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\33\33\32\274--*\377,,*\377,,*\377,,*\377,"
	                                            ",*\377,,*\377,,*\377,,*\377,,*\377,/+\377h\3\3\377\235\0\0\377\235\0\0\377"
	                                            "\235\0\0\377\235\0\0\377\235\0\0\377\235\0\0\377\235\0\0\377\235\0\0\377"
	                                            "\235\0\0\377\236\0\0\377\243\0\0\377\243\0\0\377\243\0\0\377\242\0\0\377"
	                                            "\242\0\0\377\242\0\0\377\242\0\0\377\241\0\0\377\241\0\0\377\241\0\0\377"
	                                            "\206\0\0\377%%#\377--*\377,,*\377,,*\377,,*\377,,*\377,,*\377,,*\377,,*\377"
	                                            ",,*\377,,*\377,,*\377,,*\377,,*\377,,*\377,,*\377,,*\377,,*\377,,*\377,,"
	                                            "*\377--*\377\35\35\33\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\33\33\30\274++(\377**(\377**(\377**(\377**(\377"
	                                            "**(\377**(\377**(\377**(\377*-)\377e\3\3\377\230\0\0\377\230\0\0\377\230"
	                                            "\0\0\377\230\0\0\377\230\0\0\377\230\0\0\377\230\0\0\377\230\0\0\377\230"
	                                            "\0\0\377\230\0\0\377\230\0\0\377\230\0\0\377\230\0\0\377\230\0\0\377\230"
	                                            "\0\0\377\230\0\0\377\230\0\0\377\230\0\0\377\231\0\0\377\201\0\0\377\"#!"
	                                            "\377++(\377**(\377**(\377**(\377**(\377**(\377**(\377**(\377**(\377**(\377"
	                                            "**(\377**(\377**(\377**(\377**(\377**(\377**(\377**(\377**(\377**(\377++"
	                                            "(\377\34\34\32\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\31\31\27\274))&\377((&\377((&\377((&\377((&\377((&\377"
	                                            "((&\377((&\377((&\377(*'\377b\3\3\377\224\0\0\377\224\0\0\377\224\0\0\377"
	                                            "\224\0\0\377\224\0\0\377\224\0\0\377\224\0\0\377\224\0\0\377\224\0\0\377"
	                                            "\224\0\0\377\224\0\0\377\224\0\0\377\224\0\0\377\224\0\0\377\224\0\0\377"
	                                            "\224\0\0\377\224\0\0\377\224\0\0\377~\0\0\377\40!\36\377))&\377((&\377(("
	                                            "&\377((&\377((&\377((&\377((&\377((&\377((&\377((&\377((&\377((&\377((&\377"
	                                            "((&\377((&\377((&\377((&\377((&\377((&\377((&\377((&\377))&\377\32\32\30"
	                                            "\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\30\30\27\274''$\377&&$\377&&$\377&&$\377&&$\377&&$\377&&$\377&&$\377"
	                                            "&&$\377&(%\377_\3\3\377\220\0\0\377\220\0\0\377\220\0\0\377\220\0\0\377\220"
	                                            "\0\0\377\220\0\0\377\220\0\0\377\220\0\0\377\220\0\0\377\220\0\0\377\220"
	                                            "\0\0\377\220\0\0\377\220\0\0\377\220\0\0\377\220\0\0\377\220\0\0\377\220"
	                                            "\0\0\377|\0\0\377\37\37\35\377''$\377&&$\377&&$\377&&$\377&&$\377&&$\377"
	                                            "&&$\377&&$\377&&$\377&&$\377&&$\377&&$\377&&$\377&&$\377&&$\377&&$\377&&"
	                                            "$\377&&$\377&&$\377&&$\377&&$\377&&$\377''$\377\31\31\27\320\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\27\27\24\274"
	                                            "%%\"\377$$\"\377$$\"\377$$\"\377$$\"\377$$\"\377$$\"\377$$\"\377$$\"\377"
	                                            "$&#\377\\\3\2\377\214\0\0\377\214\0\0\377\214\0\0\377\214\0\0\377\214\0\0"
	                                            "\377\214\0\0\377\214\0\0\377\214\0\0\377\214\0\0\377\215\0\0\377\222\0\0"
	                                            "\377\222\0\0\377\222\0\0\377\222\0\0\377\222\0\0\377\222\0\0\377y\0\0\377"
	                                            "\35\35\32\377%%\"\377$$\"\377$$\"\377$$\"\377$$\"\377$$\"\377$$\"\377$$!"
	                                            "\377%%\"\377%$!\377$$\"\377$$\"\377$$\"\377$$\"\377$$\"\377$$\"\377$$\"\377"
	                                            "$$\"\377$$\"\377$$\"\377$$\"\377$$\"\377$$\"\377%%\"\377\30\30\26\320\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\26\26"
	                                            "\23\274##\40\377\"\"\37\377\"\"\37\377\"\"\37\377\"\"\37\377\"\"\37\377\""
	                                            "\"\37\377\"\"\37\377\"\"\37\377\"$!\377Y\2\2\377\207\0\0\377\207\0\0\377"
	                                            "\207\0\0\377\207\0\0\377\207\0\0\377\207\0\0\377\207\0\0\377\207\0\0\377"
	                                            "\207\0\0\377f\1\0\377\32\31\26\377\35\30\26\377\35\30\26\377\35\30\26\377"
	                                            "\35\30\26\377\35\30\26\377\36\35\32\377##\40\377\"\"\37\377\"\"\37\377\""
	                                            "\"\37\377\"\"\37\377\"\"\37\377\"\"\37\377\"\"\37\377#$!\3772\14\13\377\37"
	                                            "\27\26\377#$!\377\"\"\37\377\"\"\37\377\"\"\37\377\"\"\37\377\"\"\37\377"
	                                            "\"\"\37\377\"\"\37\377\"\"\37\377\"\"\37\377\"\"\37\377\"\"\37\377\"\"\37"
	                                            "\377##\40\377\26\26\24\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\24\24\23\274!!\37\377\40\40\37\377\40\40\37\377"
	                                            "\40\40\37\377\40\40\37\377\40\40\37\377\40\40\37\377\40\40\37\377\40\40\37"
	                                            "\377\40\"\40\377V\3\2\377\203\0\0\377\203\0\0\377\203\0\0\377\203\0\0\377"
	                                            "\203\0\0\377\203\0\0\377\203\0\0\377\203\0\0\377\203\0\0\377b\0\0\377\36"
	                                            "!\37\377\40\40\37\377\40\40\37\377\40\40\37\377\40\40\37\377\40\40\37\377"
	                                            "\40\40\37\377\40\40\37\377\40\40\37\377\40\40\37\377\40\40\37\377\40\40\37"
	                                            "\377\40\40\37\377\40\40\37\377\40\40\37\377\40\"\40\377T\3\3\377\204\0\0"
	                                            "\377-\15\14\377!!\40\377\40\40\37\377\40\40\37\377\40\40\37\377\40\40\37"
	                                            "\377\40\40\37\377\40\40\37\377\40\40\37\377\40\40\37\377\40\40\37\377\40"
	                                            "\40\37\377\40\40\37\377!!\37\377\25\25\23\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\23\23\22\274\37\37\35\377\36"
	                                            "\36\34\377\36\36\34\377\36\36\34\377\36\36\34\377\36\36\34\377\36\36\34\377"
	                                            "\36\36\34\377\36\36\34\377\36\40\36\377T\2\2\377\177\0\0\377\177\0\0\377"
	                                            "\177\0\0\377\177\0\0\377\177\0\0\377\177\0\0\377\177\0\0\377\177\0\0\377"
	                                            "\177\0\0\377_\0\0\377\34\37\36\377\36\36\34\377\36\36\34\377\36\36\34\377"
	                                            "\36\36\34\377\36\36\34\377\36\36\34\377\36\36\34\377\36\36\34\377\36\36\34"
	                                            "\377\36\36\34\377\36\36\34\377\36\36\34\377\36\36\34\377\36\36\34\377\36"
	                                            "\40\36\377S\2\2\377\177\0\0\377{\0\0\377\31\27\25\377\36\36\34\377\36\36"
	                                            "\34\377\36\36\34\377\36\36\34\377\36\36\34\377\36\36\34\377\36\36\34\377"
	                                            "\36\36\34\377\36\36\34\377\36\36\34\377\36\36\34\377\37\37\35\377\23\23\23"
	                                            "\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\22\22\21\274\35\35\33\377\34\34\32\377\34\34\32\377\34\34\32\377\34"
	                                            "\34\32\377\34\34\32\377\34\34\32\377\34\34\32\377\34\34\32\377\34\36\34\377"
	                                            "P\2\2\377z\0\0\377z\0\0\377z\0\0\377z\0\0\377z\0\0\377z\0\0\377z\0\0\377"
	                                            "z\0\0\377z\0\0\377[\0\0\377\32\36\33\377\34\34\32\377\34\34\32\377\34\34"
	                                            "\32\377\34\34\32\377\34\34\32\377\34\34\32\377\34\34\32\377\34\34\32\377"
	                                            "\34\34\32\377\34\34\32\377\34\34\32\377\34\34\32\377\34\34\32\377\35\36\34"
	                                            "\377\37\16\15\377}\0\0\377z\0\0\377{\0\0\377=\7\7\377\35\35\33\377\34\34"
	                                            "\32\377\34\34\32\377\34\34\32\377\34\34\32\377\34\34\32\377\34\34\32\377"
	                                            "\34\34\32\377\34\34\32\377\34\34\32\377\34\34\32\377\35\35\33\377\23\23\21"
	                                            "\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\21\21\17\274\33\33\31\377\32\32\30\377\32\32\30\377\32\32\30\377\32"
	                                            "\32\30\377\32\32\30\377\32\32\30\377\32\32\30\377\32\32\30\377\32\34\32\377"
	                                            "N\2\2\377v\0\0\377v\0\0\377v\0\0\377v\0\0\377v\0\0\377v\0\0\377v\0\0\377"
	                                            "v\0\0\377v\0\0\377W\0\0\377\21\24\23\377\23\24\22\377\23\24\22\377\23\24"
	                                            "\22\377\23\24\22\377\23\24\22\377\23\24\22\377\23\24\22\377\23\24\22\377"
	                                            "\23\24\22\377\23\24\22\377\23\24\22\377\23\23\22\377\27\22\20\3776\10\7\377"
	                                            "r\0\0\377v\0\0\377v\0\0\377v\0\0\377N\2\1\377\32\34\32\377\32\32\30\377\32"
	                                            "\32\30\377\32\32\30\377\32\32\30\377\32\32\30\377\32\32\30\377\32\32\30\377"
	                                            "\32\32\30\377\32\32\30\377\32\32\30\377\33\33\31\377\21\21\20\320\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\17\17\16"
	                                            "\274\31\31\27\377\30\30\26\377\30\30\26\377\30\30\26\377\30\30\26\377\30"
	                                            "\30\26\377\30\30\26\377\30\30\26\377\30\30\26\377\30\32\30\377K\2\1\377r"
	                                            "\0\0\377r\0\0\377r\0\0\377r\0\0\377r\0\0\377r\0\0\377r\0\0\377r\0\0\377r"
	                                            "\0\0\377t\0\0\377x\0\0\377x\0\0\377x\0\0\377x\0\0\377x\0\0\377x\0\0\377x"
	                                            "\0\0\377x\0\0\377x\0\0\377x\0\0\377x\0\0\377x\0\0\377x\0\0\377w\0\0\377t"
	                                            "\0\0\377r\0\0\377r\0\0\377r\0\0\377r\0\0\377Y\0\0\377\25\31\26\377\30\30"
	                                            "\26\377\30\30\26\377\30\30\26\377\30\30\26\377\30\30\26\377\30\30\26\377"
	                                            "\30\30\26\377\30\30\26\377\30\30\26\377\30\30\26\377\31\31\27\377\20\20\17"
	                                            "\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\16\16\14\274\27\27\25\377\26\26\24\377\26\26\24\377\26\26\24\377\26"
	                                            "\26\24\377\26\26\24\377\26\26\24\377\26\26\24\377\26\26\24\377\26\30\25\377"
	                                            "H\1\2\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377"
	                                            "m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377"
	                                            "m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377"
	                                            "m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377l\0\0\377\21\22\21"
	                                            "\377\26\26\24\377\26\26\24\377\26\26\24\377\26\26\24\377\26\26\24\377\26"
	                                            "\26\24\377\26\26\24\377\26\26\24\377\26\26\24\377\26\26\24\377\27\27\25\377"
	                                            "\17\17\15\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\14\14\13\274\25\25\23\377\24\24\22\377\24\24\22\377\24\24\22"
	                                            "\377\24\24\22\377\24\24\22\377\24\24\22\377\24\24\22\377\24\24\22\377\24"
	                                            "\25\23\377G\2\1\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377"
	                                            "l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377"
	                                            "l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377"
	                                            "l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377q\0\0\377"
	                                            "\23\16\14\377\24\24\22\377\24\24\22\377\24\24\22\377\24\24\22\377\24\24\22"
	                                            "\377\24\24\22\377\24\24\22\377\24\24\22\377\24\24\22\377\24\24\22\377\25"
	                                            "\25\23\377\15\15\14\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\13\13\12\274\23\23\21\377\22\22\21\377\22\22\21\377"
	                                            "\22\22\21\377\22\22\21\377\22\22\21\377\22\22\21\377\22\22\21\377\22\22\21"
	                                            "\377\22\23\22\377F\1\1\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l"
	                                            "\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l"
	                                            "\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l"
	                                            "\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377p"
	                                            "\0\0\377\31\13\12\377\22\22\21\377\22\22\21\377\22\22\21\377\22\22\21\377"
	                                            "\22\22\21\377\22\22\21\377\22\22\21\377\22\22\21\377\22\22\21\377\22\22\21"
	                                            "\377\23\23\21\377\14\14\13\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\12\12\12\274\21\21\20\377\20\20\20\377\20"
	                                            "\20\20\377\20\20\20\377\20\20\20\377\20\20\20\377\20\20\20\377\20\20\20\377"
	                                            "\20\20\20\377\20\21\20\377F\1\1\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l"
	                                            "\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l"
	                                            "\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l"
	                                            "\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l"
	                                            "\0\0\377n\0\0\377)\7\6\377\21\21\20\377\20\20\20\377\20\20\20\377\20\20\20"
	                                            "\377\20\20\20\377\20\20\20\377\20\20\20\377\20\20\20\377\20\20\20\377\20"
	                                            "\20\20\377\21\21\20\377\13\13\12\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\11\11\10\274\17\17\16\377\16\16\16\377"
	                                            "\16\16\16\377\16\16\16\377\16\16\16\377\16\16\16\377\16\16\16\377\16\16\16"
	                                            "\377\16\16\16\377\16\17\16\377F\1\1\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377"
	                                            "l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377"
	                                            "l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377"
	                                            "l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377"
	                                            "l\0\0\377l\0\0\377>\3\2\377\16\17\16\377\16\16\16\377\16\16\16\377\16\16"
	                                            "\16\377\16\16\16\377\16\16\16\377\16\16\16\377\16\16\16\377\16\16\16\377"
	                                            "\16\16\16\377\17\17\16\377\12\12\11\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\10\10\7\274\15\15\14\377\14\14\14"
	                                            "\377\14\14\14\377\14\14\14\377\14\14\14\377\14\14\14\377\14\14\14\377\14"
	                                            "\14\14\377\14\14\14\377\13\15\14\377F\1\1\377l\0\0\377l\0\0\377l\0\0\377"
	                                            "l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377"
	                                            "l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377"
	                                            "l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377"
	                                            "l\0\0\377l\0\0\377l\0\0\377F\1\1\377\13\15\14\377\14\14\14\377\14\14\14\377"
	                                            "\14\14\14\377\14\14\14\377\14\14\14\377\14\14\14\377\14\14\14\377\14\14\14"
	                                            "\377\14\14\14\377\15\15\14\377\10\10\7\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\7\7\6\274\13\13\12\377\12\12\12"
	                                            "\377\12\12\12\377\12\12\12\377\12\12\12\377\12\12\12\377\12\12\12\377\12"
	                                            "\12\12\377\12\12\12\377\11\13\12\377F\0\1\377l\0\0\377l\0\0\377l\0\0\377"
	                                            "l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377"
	                                            "l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377"
	                                            "l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377"
	                                            "l\0\0\377l\0\0\377l\0\0\377O\0\0\377\10\13\12\377\12\12\12\377\12\12\12\377"
	                                            "\12\12\12\377\12\12\12\377\12\12\12\377\12\12\12\377\12\12\12\377\12\12\12"
	                                            "\377\12\12\12\377\13\13\12\377\6\6\6\320\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\5\5\4\263\11\11\10\377\10\10\10"
	                                            "\377\10\10\10\377\10\10\10\377\10\10\10\377\10\10\10\377\10\10\10\377\10"
	                                            "\10\10\377\10\10\10\377\7\11\10\377F\1\0\377l\0\0\377l\0\0\377l\0\0\377l"
	                                            "\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l"
	                                            "\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l"
	                                            "\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l\0\0\377l"
	                                            "\0\0\377l\0\0\377l\0\0\377e\0\0\377\4\7\7\377\10\10\10\377\10\10\10\377\10"
	                                            "\10\10\377\10\10\10\377\10\10\10\377\10\10\10\377\10\10\10\377\10\10\10\377"
	                                            "\10\10\10\377\11\11\10\377\6\6\5\307\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\2\2\200\7\7\6\377\6\6\6\377\6\6\6"
	                                            "\377\6\6\6\377\6\6\6\377\6\6\6\377\6\6\6\377\6\6\6\377\6\6\6\377\5\7\6\377"
	                                            "F\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377"
	                                            "m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377"
	                                            "m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377"
	                                            "m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377m\0\0\377s\0\0\377"
	                                            "\7\5\4\377\6\6\6\377\6\6\6\377\6\6\6\377\6\6\6\377\6\6\6\377\6\6\6\377\6"
	                                            "\6\6\377\6\6\6\377\6\6\6\377\7\7\6\377\3\3\3\222\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0D\4\4\3\377\4\4\3\377"
	                                            "\4\4\3\377\4\4\3\377\4\4\3\377\4\4\3\377\4\4\3\377\4\4\3\377\4\4\3\377\4"
	                                            "\5\4\377\37\2\1\377-\2\1\377-\2\1\377-\2\1\377-\2\1\377-\2\1\377-\2\1\377"
	                                            "-\2\1\377-\2\1\377-\2\1\377-\2\1\377-\2\1\377-\2\1\377-\2\1\377-\2\1\377"
	                                            "-\2\1\377-\2\1\377-\2\1\377-\2\1\377-\2\1\377-\2\1\377-\2\1\377-\2\1\377"
	                                            "-\2\1\377-\2\1\377-\2\1\377-\2\1\377-\2\1\377-\2\1\377-\2\1\377-\2\1\377"
	                                            "/\1\1\377\10\3\2\377\4\4\3\377\4\4\3\377\4\4\3\377\4\4\3\377\4\4\3\377\4"
	                                            "\4\3\377\4\4\3\377\4\4\3\377\4\4\3\377\4\4\4\377\1\1\1N\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\1\1\314"
	                                            "\3\3\3\377\2\2\3\377\2\2\3\377\2\2\3\377\2\2\3\377\2\2\3\377\2\2\3\377\2"
	                                            "\2\3\377\3\2\3\377\2\3\3\377\2\3\3\377\2\3\3\377\2\3\3\377\2\3\3\377\2\3"
	                                            "\3\377\2\3\3\377\2\3\3\377\2\3\3\377\2\3\3\377\2\3\3\377\2\3\3\377\2\3\3"
	                                            "\377\2\3\3\377\2\3\3\377\2\3\3\377\2\3\3\377\2\3\3\377\2\3\3\377\2\3\3\377"
	                                            "\2\3\3\377\2\3\3\377\2\3\3\377\2\3\3\377\2\3\3\377\2\3\3\377\2\3\3\377\2"
	                                            "\3\3\377\2\3\3\377\2\3\3\377\2\3\3\377\2\3\3\377\2\3\3\377\2\2\3\377\2\2"
	                                            "\3\377\2\2\3\377\2\2\3\377\2\2\3\377\2\2\3\377\2\2\3\377\2\2\3\377\3\3\3"
	                                            "\377\1\1\1\326\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\21\0\0\0\361\0\0\0\377\0\0\0\377\0\0"
	                                            "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
	                                            "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
	                                            "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
	                                            "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
	                                            "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
	                                            "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
	                                            "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\370\0\0\0\25\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1"
	                                            "\0\0\0\20\0\0\0\265\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
	                                            "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
	                                            "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
	                                            "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
	                                            "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
	                                            "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
	                                            "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\273\0\0\0\24"
	                                            "\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\31\0\0\0^\0\0\0i\0"
	                                            "\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0"
	                                            "\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0"
	                                            "i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0"
	                                            "\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0\0i\0\0"
	                                            "\0i\0\0\0_\0\0\0\35\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
	                                            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",
};

#endif // #ifndef INCLUDE_SDL_ICON_H
