/*

    Copyright (C) 2003-2005 Christopher Lais (aka "Zinx Verituse")
    and is covered by the following license:

    ***
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
    claim that you wrote the original software.

    2. Altered source versions must be plainly marked as such, and must not be
    misrepresented as being the original software.

    3. Modified source for this software, as used in any binaries you have
    distributed, must be provided on request, free of charge and/or penalty.

    4. This notice may not be removed or altered from any source distribution.
    ***

*/

#ifndef INCLUDE_G_MDX_LUT_H
#define INCLUDE_G_MDX_LUT_H

/* These were dumped */

#if 0
{
	Com_Memset(&refent, 0, sizeof(refent));
	refent.hModel   = trap_R_RegisterModel("evil.mdm");
	refent.frame    = 0;
	refent.oldframe = refent.frame;
	for (j = 0; j < 64; j++)
	{
		qhandle_t mdxFile = trap_R_RegisterModel(va("evil%d.mdx", j));
		refent.torsoFrameModel = refent.oldTorsoFrameModel = refent.frameModel = refent.oldframeModel = mdxFile;
		for (i = 0; i < 64; i++)
		{
			char name[64];
			sprintf(name, "%d", i);
			trap_R_LerpTag(&o[0], &refent, name, 0);
			CG_Printf("/*%4d*/ %a,\n", j * 64 + i, -o[0].origin[2]);
		}
	}
}
#endif

static const float sintable[4096] =
{
	/*
	_MSC_VER section added by Gabriel Magana (Calzonzin) to enable compilation
	under MS Visual C++ 6 (Win32), which does not support the C99-style floating-
	point hex literals (ie, "0x1.9238dp-10") present in the original code.  The
	array was translated under gcc 3.3.5 by running the following program:
	*/

//	int main() {
//		int i;
//		for (i = 0; i <= 4095; i++) {
//			printf("/*%4d*/ %.32e,\n", i, sintable[i]);
//		}
//	}

	/*
	The output of the program was then captured and pasted into place below
	*/

	/*   0*/ -0.00000000000000000000000000000000e+00,
	/*   1*/ 1.53435487300157546997070312500000e-03,
	/*   2*/ 3.06870602071285247802734375000000e-03,
	/*   3*/ 4.60305018350481986999511718750000e-03,
	/*   4*/ 6.13738317042589187622070312500000e-03,
	/*   5*/ 7.67170172184705734252929687500000e-03,
	/*   6*/ 9.20600257813930511474609375000000e-03,
	/*   7*/ 1.07402810826897621154785156250000e-02,
	/*   8*/ 1.22745353728532791137695312500000e-02,
	/*   9*/ 1.38087598606944084167480468750000e-02,
	/*  10*/ 1.53429517522454261779785156250000e-02,
	/*  11*/ 1.68771091848611831665039062500000e-02,
	/*  12*/ 1.84112247079610824584960937500000e-02,
	/*  13*/ 1.99452973902225494384765625000000e-02,
	/*  14*/ 2.14793235063552856445312500000000e-02,
	/*  15*/ 2.30132993310689926147460937500000e-02,
	/*  16*/ 2.45472211390733718872070312500000e-02,
	/*  17*/ 2.60810852050781250000000000000000e-02,
	/*  18*/ 2.76148859411478042602539062500000e-02,
	/*  19*/ 2.91486233472824096679687500000000e-02,
	/*  20*/ 3.06822918355464935302734375000000e-02,
	/*  21*/ 3.22158895432949066162109375000000e-02,
	/*  22*/ 3.37494090199470520019531250000000e-02,
	/*  23*/ 3.52828502655029296875000000000000e-02,
	/*  24*/ 3.68162095546722412109375000000000e-02,
	/*  25*/ 3.83494794368743896484375000000000e-02,
	/*  26*/ 3.98826599121093750000000000000000e-02,
	/*  27*/ 4.14157472550868988037109375000000e-02,
	/*  28*/ 4.29487377405166625976562500000000e-02,
	/*  29*/ 4.44816239178180694580078125000000e-02,
	/*  30*/ 4.60144095122814178466796875000000e-02,
	/*  31*/ 4.75470833480358123779296875000000e-02,
	/*  32*/ 4.90796491503715515136718750000000e-02,
	/*  33*/ 5.06120957434177398681640625000000e-02,
	/*  34*/ 5.21444268524646759033203125000000e-02,
	/*  35*/ 5.36766313016414642333984375000000e-02,
	/*  36*/ 5.52087090909481048583984375000000e-02,
	/*  37*/ 5.67406602203845977783203125000000e-02,
	/*  38*/ 5.82724772393703460693359375000000e-02,
	/*  39*/ 5.98041564226150512695312500000000e-02,
	/*  40*/ 6.13356940448284149169921875000000e-02,
	/*  41*/ 6.28670901060104370117187500000000e-02,
	/*  42*/ 6.43983334302902221679687500000000e-02,
	/*  43*/ 6.59294277429580688476562500000000e-02,
	/*  44*/ 6.74603655934333801269531250000000e-02,
	/*  45*/ 6.89911469817161560058593750000000e-02,
	/*  46*/ 7.05217644572257995605468750000000e-02,
	/*  47*/ 7.20522180199623107910156250000000e-02,
	/*  48*/ 7.35825002193450927734375000000000e-02,
	/*  49*/ 7.51126036047935485839843750000000e-02,
	/*  50*/ 7.66425356268882751464843750000000e-02,
	/*  51*/ 7.81722888350486755371093750000000e-02,
	/*  52*/ 7.97018557786941528320312500000000e-02,
	/*  53*/ 8.12312364578247070312500000000000e-02,
	/*  54*/ 8.27604234218597412109375000000000e-02,
	/*  55*/ 8.42894166707992553710937500000000e-02,
	/*  56*/ 8.58182162046432495117187500000000e-02,
	/*  57*/ 8.73468071222305297851562500000000e-02,
	/*  58*/ 8.88751968741416931152343750000000e-02,
	/*  59*/ 9.04033705592155456542968750000000e-02,
	/*  60*/ 9.19313430786132812500000000000000e-02,
	/*  61*/ 9.34590920805931091308593750000000e-02,
	/*  62*/ 9.49866175651550292968750000000000e-02,
	/*  63*/ 9.65139269828796386718750000000000e-02,
	/*  64*/ 9.80409979820251464843750000000000e-02,
	/*  65*/ 9.95678454637527465820312500000000e-02,
	/*  66*/ 1.01094461977481842041015625000000e-01,
	/*  67*/ 1.02620840072631835937500000000000e-01,
	/*  68*/ 1.04146972298622131347656250000000e-01,
	/*  69*/ 1.05672858655452728271484375000000e-01,
	/*  70*/ 1.07198499143123626708984375000000e-01,
	/*  71*/ 1.08723886311054229736328125000000e-01,
	/*  72*/ 1.10249020159244537353515625000000e-01,
	/*  73*/ 1.11773885786533355712890625000000e-01,
	/*  74*/ 1.13298498094081878662109375000000e-01,
	/*  75*/ 1.14822842180728912353515625000000e-01,
	/*  76*/ 1.16346910595893859863281250000000e-01,
	/*  77*/ 1.17870710790157318115234375000000e-01,
	/*  78*/ 1.19394227862358093261718750000000e-01,
	/*  79*/ 1.20917469263076782226562500000000e-01,
	/*  80*/ 1.22440420091152191162109375000000e-01,
	/*  81*/ 1.23963087797164916992187500000000e-01,
	/*  82*/ 1.25485464930534362792968750000000e-01,
	/*  83*/ 1.27007544040679931640625000000000e-01,
	/*  84*/ 1.28529325127601623535156250000000e-01,
	/*  85*/ 1.30050793290138244628906250000000e-01,
	/*  86*/ 1.31571963429450988769531250000000e-01,
	/*  87*/ 1.33092835545539855957031250000000e-01,
	/*  88*/ 1.34613379836082458496093750000000e-01,
	/*  89*/ 1.36133611202239990234375000000000e-01,
	/*  90*/ 1.37653514742851257324218750000000e-01,
	/*  91*/ 1.39173105359077453613281250000000e-01,
	/*  92*/ 1.40692368149757385253906250000000e-01,
	/*  93*/ 1.42211288213729858398437500000000e-01,
	/*  94*/ 1.43729880452156066894531250000000e-01,
	/*  95*/ 1.45248144865036010742187500000000e-01,
	/*  96*/ 1.46766051650047302246093750000000e-01,
	/*  97*/ 1.48283615708351135253906250000000e-01,
	/*  98*/ 1.49800837039947509765625000000000e-01,
	/*  99*/ 1.51317700743675231933593750000000e-01,
	/* 100*/ 1.52834206819534301757812500000000e-01,
	/* 101*/ 1.54350355267524719238281250000000e-01,
	/* 102*/ 1.55866146087646484375000000000000e-01,
	/* 103*/ 1.57381564378738403320312500000000e-01,
	/* 104*/ 1.58896610140800476074218750000000e-01,
	/* 105*/ 1.60411283373832702636718750000000e-01,
	/* 106*/ 1.61925584077835083007812500000000e-01,
	/* 107*/ 1.63439497351646423339843750000000e-01,
	/* 108*/ 1.64953023195266723632812500000000e-01,
	/* 109*/ 1.66466176509857177734375000000000e-01,
	/* 110*/ 1.67978912591934204101562500000000e-01,
	/* 111*/ 1.69491276144981384277343750000000e-01,
	/* 112*/ 1.71003237366676330566406250000000e-01,
	/* 113*/ 1.72514781355857849121093750000000e-01,
	/* 114*/ 1.74025937914848327636718750000000e-01,
	/* 115*/ 1.75536662340164184570312500000000e-01,
	/* 116*/ 1.77046999335289001464843750000000e-01,
	/* 117*/ 1.78556904196739196777343750000000e-01,
	/* 118*/ 1.80066391825675964355468750000000e-01,
	/* 119*/ 1.81575447320938110351562500000000e-01,
	/* 120*/ 1.83084085583686828613281250000000e-01,
	/* 121*/ 1.84592291712760925292968750000000e-01,
	/* 122*/ 1.86100065708160400390625000000000e-01,
	/* 123*/ 1.87607392668724060058593750000000e-01,
	/* 124*/ 1.89114287495613098144531250000000e-01,
	/* 125*/ 1.90620720386505126953125000000000e-01,
	/* 126*/ 1.92126721143722534179687500000000e-01,
	/* 127*/ 1.93632259964942932128906250000000e-01,
	/* 128*/ 1.95137351751327514648437500000000e-01,
	/* 129*/ 1.96641981601715087890625000000000e-01,
	/* 130*/ 1.98146149516105651855468750000000e-01,
	/* 131*/ 1.99649840593338012695312500000000e-01,
	/* 132*/ 2.01153069734573364257812500000000e-01,
	/* 133*/ 2.02655836939811706542968750000000e-01,
	/* 134*/ 2.04158112406730651855468750000000e-01,
	/* 135*/ 2.05659911036491394042968750000000e-01,
	/* 136*/ 2.07161217927932739257812500000000e-01,
	/* 137*/ 2.08662047982215881347656250000000e-01,
	/* 138*/ 2.10162386298179626464843750000000e-01,
	/* 139*/ 2.11662217974662780761718750000000e-01,
	/* 140*/ 2.13161557912826538085937500000000e-01,
	/* 141*/ 2.14660406112670898437500000000000e-01,
	/* 142*/ 2.16158732771873474121093750000000e-01,
	/* 143*/ 2.17656567692756652832031250000000e-01,
	/* 144*/ 2.19153881072998046875000000000000e-01,
	/* 145*/ 2.20650672912597656250000000000000e-01,
	/* 146*/ 2.22146958112716674804687500000000e-01,
	/* 147*/ 2.23642706871032714843750000000000e-01,
	/* 148*/ 2.25137934088706970214843750000000e-01,
	/* 149*/ 2.26632639765739440917968750000000e-01,
	/* 150*/ 2.28126794099807739257812500000000e-01,
	/* 151*/ 2.29620426893234252929687500000000e-01,
	/* 152*/ 2.31113508343696594238281250000000e-01,
	/* 153*/ 2.32606053352355957031250000000000e-01,
	/* 154*/ 2.34098047018051147460937500000000e-01,
	/* 155*/ 2.35589489340782165527343750000000e-01,
	/* 156*/ 2.37080380320549011230468750000000e-01,
	/* 157*/ 2.38570719957351684570312500000000e-01,
	/* 158*/ 2.40060478448867797851562500000000e-01,
	/* 159*/ 2.41549685597419738769531250000000e-01,
	/* 160*/ 2.43038326501846313476562500000000e-01,
	/* 161*/ 2.44526386260986328125000000000000e-01,
	/* 162*/ 2.46013879776000976562500000000000e-01,
	/* 163*/ 2.47500792145729064941406250000000e-01,
	/* 164*/ 2.48987108469009399414062500000000e-01,
	/* 165*/ 2.50472843647003173828125000000000e-01,
	/* 166*/ 2.51958012580871582031250000000000e-01,
	/* 167*/ 2.53442555665969848632812500000000e-01,
	/* 168*/ 2.54926532506942749023437500000000e-01,
	/* 169*/ 2.56409883499145507812500000000000e-01,
	/* 170*/ 2.57892638444900512695312500000000e-01,
	/* 171*/ 2.59374797344207763671875000000000e-01,
	/* 172*/ 2.60856330394744873046875000000000e-01,
	/* 173*/ 2.62337237596511840820312500000000e-01,
	/* 174*/ 2.63817548751831054687500000000000e-01,
	/* 175*/ 2.65297234058380126953125000000000e-01,
	/* 176*/ 2.66776293516159057617187500000000e-01,
	/* 177*/ 2.68254727125167846679687500000000e-01,
	/* 178*/ 2.69732534885406494140625000000000e-01,
	/* 179*/ 2.71209716796875000000000000000000e-01,
	/* 180*/ 2.72686243057250976562500000000000e-01,
	/* 181*/ 2.74162113666534423828125000000000e-01,
	/* 182*/ 2.75637358427047729492187500000000e-01,
	/* 183*/ 2.77111947536468505859375000000000e-01,
	/* 184*/ 2.78585880994796752929687500000000e-01,
	/* 185*/ 2.80059188604354858398437500000000e-01,
	/* 186*/ 2.81531810760498046875000000000000e-01,
	/* 187*/ 2.83003777265548706054687500000000e-01,
	/* 188*/ 2.84475058317184448242187500000000e-01,
	/* 189*/ 2.85945683717727661132812500000000e-01,
	/* 190*/ 2.87415623664855957031250000000000e-01,
	/* 191*/ 2.88884907960891723632812500000000e-01,
	/* 192*/ 2.90353506803512573242187500000000e-01,
	/* 193*/ 2.91821420192718505859375000000000e-01,
	/* 194*/ 2.93288648128509521484375000000000e-01,
	/* 195*/ 2.94755190610885620117187500000000e-01,
	/* 196*/ 2.96221017837524414062500000000000e-01,
	/* 197*/ 2.97686159610748291015625000000000e-01,
	/* 198*/ 2.99150615930557250976562500000000e-01,
	/* 199*/ 3.00614356994628906250000000000000e-01,
	/* 200*/ 3.02077382802963256835937500000000e-01,
	/* 201*/ 3.03539693355560302734375000000000e-01,
	/* 202*/ 3.05001288652420043945312500000000e-01,
	/* 203*/ 3.06462198495864868164062500000000e-01,
	/* 204*/ 3.07922363281250000000000000000000e-01,
	/* 205*/ 3.09381783008575439453125000000000e-01,
	/* 206*/ 3.10840517282485961914062500000000e-01,
	/* 207*/ 3.12298476696014404296875000000000e-01,
	/* 208*/ 3.13755720853805541992187500000000e-01,
	/* 209*/ 3.15212249755859375000000000000000e-01,
	/* 210*/ 3.16668003797531127929687500000000e-01,
	/* 211*/ 3.18123012781143188476562500000000e-01,
	/* 212*/ 3.19577276706695556640625000000000e-01,
	/* 213*/ 3.21030795574188232421875000000000e-01,
	/* 214*/ 3.22483569383621215820312500000000e-01,
	/* 215*/ 3.23935568332672119140625000000000e-01,
	/* 216*/ 3.25386822223663330078125000000000e-01,
	/* 217*/ 3.26837271451950073242187500000000e-01,
	/* 218*/ 3.28286975622177124023437500000000e-01,
	/* 219*/ 3.29735934734344482421875000000000e-01,
	/* 220*/ 3.31184089183807373046875000000000e-01,
	/* 221*/ 3.32631438970565795898437500000000e-01,
	/* 222*/ 3.34078043699264526367187500000000e-01,
	/* 223*/ 3.35523843765258789062500000000000e-01,
	/* 224*/ 3.36968868970870971679687500000000e-01,
	/* 225*/ 3.38413089513778686523437500000000e-01,
	/* 226*/ 3.39856505393981933593750000000000e-01,
	/* 227*/ 3.41299146413803100585937500000000e-01,
	/* 228*/ 3.42740952968597412109375000000000e-01,
	/* 229*/ 3.44181984663009643554687500000000e-01,
	/* 230*/ 3.45622181892395019531250000000000e-01,
	/* 231*/ 3.47061574459075927734375000000000e-01,
	/* 232*/ 3.48500162363052368164062500000000e-01,
	/* 233*/ 3.49937915802001953125000000000000e-01,
	/* 234*/ 3.51374834775924682617187500000000e-01,
	/* 235*/ 3.52810949087142944335937500000000e-01,
	/* 236*/ 3.54246199131011962890625000000000e-01,
	/* 237*/ 3.55680644512176513671875000000000e-01,
	/* 238*/ 3.57114255428314208984375000000000e-01,
	/* 239*/ 3.58547002077102661132812500000000e-01,
	/* 240*/ 3.59978914260864257812500000000000e-01,
	/* 241*/ 3.61409991979598999023437500000000e-01,
	/* 242*/ 3.62840205430984497070312500000000e-01,
	/* 243*/ 3.64269584417343139648437500000000e-01,
	/* 244*/ 3.65698069334030151367187500000000e-01,
	/* 245*/ 3.67125719785690307617187500000000e-01,
	/* 246*/ 3.68552505970001220703125000000000e-01,
	/* 247*/ 3.69978427886962890625000000000000e-01,
	/* 248*/ 3.71403455734252929687500000000000e-01,
	/* 249*/ 3.72827619314193725585937500000000e-01,
	/* 250*/ 3.74250918626785278320312500000000e-01,
	/* 251*/ 3.75673323869705200195312500000000e-01,
	/* 252*/ 3.77094864845275878906250000000000e-01,
	/* 253*/ 3.78515481948852539062500000000000e-01,
	/* 254*/ 3.79935234785079956054687500000000e-01,
	/* 255*/ 3.81354093551635742187500000000000e-01,
	/* 256*/ 3.82772028446197509765625000000000e-01,
	/* 257*/ 3.84189099073410034179687500000000e-01,
	/* 258*/ 3.85605245828628540039062500000000e-01,
	/* 259*/ 3.87020468711853027343750000000000e-01,
	/* 260*/ 3.88434797525405883789062500000000e-01,
	/* 261*/ 3.89848232269287109375000000000000e-01,
	/* 262*/ 3.91260713338851928710937500000000e-01,
	/* 263*/ 3.92672300338745117187500000000000e-01,
	/* 264*/ 3.94082933664321899414062500000000e-01,
	/* 265*/ 3.95492672920227050781250000000000e-01,
	/* 266*/ 3.96901458501815795898437500000000e-01,
	/* 267*/ 3.98309320211410522460937500000000e-01,
	/* 268*/ 3.99716228246688842773437500000000e-01,
	/* 269*/ 4.01122212409973144531250000000000e-01,
	/* 270*/ 4.02527242898941040039062500000000e-01,
	/* 271*/ 4.03931349515914916992187500000000e-01,
	/* 272*/ 4.05334472656250000000000000000000e-01,
	/* 273*/ 4.06736642122268676757812500000000e-01,
	/* 274*/ 4.08137887716293334960937500000000e-01,
	/* 275*/ 4.09538149833679199218750000000000e-01,
	/* 276*/ 4.10937428474426269531250000000000e-01,
	/* 277*/ 4.12335783243179321289062500000000e-01,
	/* 278*/ 4.13733124732971191406250000000000e-01,
	/* 279*/ 4.15129512548446655273437500000000e-01,
	/* 280*/ 4.16524916887283325195312500000000e-01,
	/* 281*/ 4.17919367551803588867187500000000e-01,
	/* 282*/ 4.19312804937362670898437500000000e-01,
	/* 283*/ 4.20705258846282958984375000000000e-01,
	/* 284*/ 4.22096729278564453125000000000000e-01,
	/* 285*/ 4.23487186431884765625000000000000e-01,
	/* 286*/ 4.24876689910888671875000000000000e-01,
	/* 287*/ 4.26265150308609008789062500000000e-01,
	/* 288*/ 4.27652627229690551757812500000000e-01,
	/* 289*/ 4.29039090871810913085937500000000e-01,
	/* 290*/ 4.30424541234970092773437500000000e-01,
	/* 291*/ 4.31808978319168090820312500000000e-01,
	/* 292*/ 4.33192431926727294921875000000000e-01,
	/* 293*/ 4.34574812650680541992187500000000e-01,
	/* 294*/ 4.35956209897994995117187500000000e-01,
	/* 295*/ 4.37336564064025878906250000000000e-01,
	/* 296*/ 4.38715904951095581054687500000000e-01,
	/* 297*/ 4.40094172954559326171875000000000e-01,
	/* 298*/ 4.41471457481384277343750000000000e-01,
	/* 299*/ 4.42847669124603271484375000000000e-01,
	/* 300*/ 4.44222837686538696289062500000000e-01,
	/* 301*/ 4.45596963167190551757812500000000e-01,
	/* 302*/ 4.46970045566558837890625000000000e-01,
	/* 303*/ 4.48342084884643554687500000000000e-01,
	/* 304*/ 4.49713051319122314453125000000000e-01,
	/* 305*/ 4.51082974672317504882812500000000e-01,
	/* 306*/ 4.52451825141906738281250000000000e-01,
	/* 307*/ 4.53819602727890014648437500000000e-01,
	/* 308*/ 4.55186337232589721679687500000000e-01,
	/* 309*/ 4.56551969051361083984375000000000e-01,
	/* 310*/ 4.57916557788848876953125000000000e-01,
	/* 311*/ 4.59280043840408325195312500000000e-01,
	/* 312*/ 4.60642457008361816406250000000000e-01,
	/* 313*/ 4.62003797292709350585937500000000e-01,
	/* 314*/ 4.63364034891128540039062500000000e-01,
	/* 315*/ 4.64723169803619384765625000000000e-01,
	/* 316*/ 4.66081231832504272460937500000000e-01,
	/* 317*/ 4.67438191175460815429687500000000e-01,
	/* 318*/ 4.68794047832489013671875000000000e-01,
	/* 319*/ 4.70148801803588867187500000000000e-01,
	/* 320*/ 4.71502453088760375976562500000000e-01,
	/* 321*/ 4.72855001688003540039062500000000e-01,
	/* 322*/ 4.74206417798995971679687500000000e-01,
	/* 323*/ 4.75556731224060058593750000000000e-01,
	/* 324*/ 4.76905912160873413085937500000000e-01,
	/* 325*/ 4.78253990411758422851562500000000e-01,
	/* 326*/ 4.79600936174392700195312500000000e-01,
	/* 327*/ 4.80946749448776245117187500000000e-01,
	/* 328*/ 4.82291430234909057617187500000000e-01,
	/* 329*/ 4.83634978532791137695312500000000e-01,
	/* 330*/ 4.84977364540100097656250000000000e-01,
	/* 331*/ 4.86318647861480712890625000000000e-01,
	/* 332*/ 4.87658739089965820312500000000000e-01,
	/* 333*/ 4.88997727632522583007812500000000e-01,
	/* 334*/ 4.90335553884506225585937500000000e-01,
	/* 335*/ 4.91672217845916748046875000000000e-01,
	/* 336*/ 4.93007719516754150390625000000000e-01,
	/* 337*/ 4.94342058897018432617187500000000e-01,
	/* 338*/ 4.95675235986709594726562500000000e-01,
	/* 339*/ 4.97007250785827636718750000000000e-01,
	/* 340*/ 4.98338103294372558593750000000000e-01,
	/* 341*/ 4.99667763710021972656250000000000e-01,
	/* 342*/ 5.00996291637420654296875000000000e-01,
	/* 343*/ 5.02323567867279052734375000000000e-01,
	/* 344*/ 5.03649711608886718750000000000000e-01,
	/* 345*/ 5.04974663257598876953125000000000e-01,
	/* 346*/ 5.06298422813415527343750000000000e-01,
	/* 347*/ 5.07620990276336669921875000000000e-01,
	/* 348*/ 5.08942365646362304687500000000000e-01,
	/* 349*/ 5.10262548923492431640625000000000e-01,
	/* 350*/ 5.11581540107727050781250000000000e-01,
	/* 351*/ 5.12899279594421386718750000000000e-01,
	/* 352*/ 5.14215826988220214843750000000000e-01,
	/* 353*/ 5.15531182289123535156250000000000e-01,
	/* 354*/ 5.16845345497131347656250000000000e-01,
	/* 355*/ 5.18158257007598876953125000000000e-01,
	/* 356*/ 5.19469976425170898437500000000000e-01,
	/* 357*/ 5.20780444145202636718750000000000e-01,
	/* 358*/ 5.22089660167694091796875000000000e-01,
	/* 359*/ 5.23397684097290039062500000000000e-01,
	/* 360*/ 5.24704515933990478515625000000000e-01,
	/* 361*/ 5.26010036468505859375000000000000e-01,
	/* 362*/ 5.27314364910125732421875000000000e-01,
	/* 363*/ 5.28617441654205322265625000000000e-01,
	/* 364*/ 5.29919266700744628906250000000000e-01,
	/* 365*/ 5.31219840049743652343750000000000e-01,
	/* 366*/ 5.32519161701202392578125000000000e-01,
	/* 367*/ 5.33817291259765625000000000000000e-01,
	/* 368*/ 5.35114109516143798828125000000000e-01,
	/* 369*/ 5.36409676074981689453125000000000e-01,
	/* 370*/ 5.37703931331634521484375000000000e-01,
	/* 371*/ 5.38996994495391845703125000000000e-01,
	/* 372*/ 5.40288746356964111328125000000000e-01,
	/* 373*/ 5.41579246520996093750000000000000e-01,
	/* 374*/ 5.42868435382843017578125000000000e-01,
	/* 375*/ 5.44156372547149658203125000000000e-01,
	/* 376*/ 5.45443058013916015625000000000000e-01,
	/* 377*/ 5.46728432178497314453125000000000e-01,
	/* 378*/ 5.48012495040893554687500000000000e-01,
	/* 379*/ 5.49295306205749511718750000000000e-01,
	/* 380*/ 5.50576806068420410156250000000000e-01,
	/* 381*/ 5.51857054233551025390625000000000e-01,
	/* 382*/ 5.53135931491851806640625000000000e-01,
	/* 383*/ 5.54413557052612304687500000000000e-01,
	/* 384*/ 5.55689871311187744140625000000000e-01,
	/* 385*/ 5.56964814662933349609375000000000e-01,
	/* 386*/ 5.58238506317138671875000000000000e-01,
	/* 387*/ 5.59510886669158935546875000000000e-01,
	/* 388*/ 5.60781955718994140625000000000000e-01,
	/* 389*/ 5.62051653861999511718750000000000e-01,
	/* 390*/ 5.63320040702819824218750000000000e-01,
	/* 391*/ 5.64587175846099853515625000000000e-01,
	/* 392*/ 5.65852880477905273437500000000000e-01,
	/* 393*/ 5.67117333412170410156250000000000e-01,
	/* 394*/ 5.68380415439605712890625000000000e-01,
	/* 395*/ 5.69642126560211181640625000000000e-01,
	/* 396*/ 5.70902526378631591796875000000000e-01,
	/* 397*/ 5.72161614894866943359375000000000e-01,
	/* 398*/ 5.73419332504272460937500000000000e-01,
	/* 399*/ 5.74675679206848144531250000000000e-01,
	/* 400*/ 5.75930714607238769531250000000000e-01,
	/* 401*/ 5.77184379100799560546875000000000e-01,
	/* 402*/ 5.78436672687530517578125000000000e-01,
	/* 403*/ 5.79687595367431640625000000000000e-01,
	/* 404*/ 5.80937147140502929687500000000000e-01,
	/* 405*/ 5.82185387611389160156250000000000e-01,
	/* 406*/ 5.83432197570800781250000000000000e-01,
	/* 407*/ 5.84677636623382568359375000000000e-01,
	/* 408*/ 5.85921704769134521484375000000000e-01,
	/* 409*/ 5.87164461612701416015625000000000e-01,
	/* 410*/ 5.88405728340148925781250000000000e-01,
	/* 411*/ 5.89645683765411376953125000000000e-01,
	/* 412*/ 5.90884208679199218750000000000000e-01,
	/* 413*/ 5.92121362686157226562500000000000e-01,
	/* 414*/ 5.93357145786285400390625000000000e-01,
	/* 415*/ 5.94591498374938964843750000000000e-01,
	/* 416*/ 5.95824480056762695312500000000000e-01,
	/* 417*/ 5.97056031227111816406250000000000e-01,
	/* 418*/ 5.98286211490631103515625000000000e-01,
	/* 419*/ 5.99514961242675781250000000000000e-01,
	/* 420*/ 6.00742280483245849609375000000000e-01,
	/* 421*/ 6.01968169212341308593750000000000e-01,
	/* 422*/ 6.03192687034606933593750000000000e-01,
	/* 423*/ 6.04415774345397949218750000000000e-01,
	/* 424*/ 6.05637431144714355468750000000000e-01,
	/* 425*/ 6.06857657432556152343750000000000e-01,
	/* 426*/ 6.08076512813568115234375000000000e-01,
	/* 427*/ 6.09293878078460693359375000000000e-01,
	/* 428*/ 6.10509812831878662109375000000000e-01,
	/* 429*/ 6.11724317073822021484375000000000e-01,
	/* 430*/ 6.12937390804290771484375000000000e-01,
	/* 431*/ 6.14148974418640136718750000000000e-01,
	/* 432*/ 6.15359187126159667968750000000000e-01,
	/* 433*/ 6.16567909717559814453125000000000e-01,
	/* 434*/ 6.17775142192840576171875000000000e-01,
	/* 435*/ 6.18981003761291503906250000000000e-01,
	/* 436*/ 6.20185375213623046875000000000000e-01,
	/* 437*/ 6.21388256549835205078125000000000e-01,
	/* 438*/ 6.22589707374572753906250000000000e-01,
	/* 439*/ 6.23789668083190917968750000000000e-01,
	/* 440*/ 6.24988198280334472656250000000000e-01,
	/* 441*/ 6.26185238361358642578125000000000e-01,
	/* 442*/ 6.27380788326263427734375000000000e-01,
	/* 443*/ 6.28574848175048828125000000000000e-01,
	/* 444*/ 6.29767477512359619140625000000000e-01,
	/* 445*/ 6.30958557128906250000000000000000e-01,
	/* 446*/ 6.32148206233978271484375000000000e-01,
	/* 447*/ 6.33336365222930908203125000000000e-01,
	/* 448*/ 6.34523034095764160156250000000000e-01,
	/* 449*/ 6.35708153247833251953125000000000e-01,
	/* 450*/ 6.36891841888427734375000000000000e-01,
	/* 451*/ 6.38073980808258056640625000000000e-01,
	/* 452*/ 6.39254689216613769531250000000000e-01,
	/* 453*/ 6.40433847904205322265625000000000e-01,
	/* 454*/ 6.41611456871032714843750000000000e-01,
	/* 455*/ 6.42787635326385498046875000000000e-01,
	/* 456*/ 6.43962264060974121093750000000000e-01,
	/* 457*/ 6.45135343074798583984375000000000e-01,
	/* 458*/ 6.46306931972503662109375000000000e-01,
	/* 459*/ 6.47477030754089355468750000000000e-01,
	/* 460*/ 6.48645579814910888671875000000000e-01,
	/* 461*/ 6.49812579154968261718750000000000e-01,
	/* 462*/ 6.50978088378906250000000000000000e-01,
	/* 463*/ 6.52142047882080078125000000000000e-01,
	/* 464*/ 6.53304457664489746093750000000000e-01,
	/* 465*/ 6.54465317726135253906250000000000e-01,
	/* 466*/ 6.55624687671661376953125000000000e-01,
	/* 467*/ 6.56782507896423339843750000000000e-01,
	/* 468*/ 6.57938718795776367187500000000000e-01,
	/* 469*/ 6.59093439579010009765625000000000e-01,
	/* 470*/ 6.60246610641479492187500000000000e-01,
	/* 471*/ 6.61398172378540039062500000000000e-01,
	/* 472*/ 6.62548243999481201171875000000000e-01,
	/* 473*/ 6.63696706295013427734375000000000e-01,
	/* 474*/ 6.64843618869781494140625000000000e-01,
	/* 475*/ 6.65988981723785400390625000000000e-01,
	/* 476*/ 6.67132794857025146484375000000000e-01,
	/* 477*/ 6.68274998664855957031250000000000e-01,
	/* 478*/ 6.69415652751922607421875000000000e-01,
	/* 479*/ 6.70554697513580322265625000000000e-01,
	/* 480*/ 6.71692192554473876953125000000000e-01,
	/* 481*/ 6.72828078269958496093750000000000e-01,
	/* 482*/ 6.73962414264678955078125000000000e-01,
	/* 483*/ 6.75095140933990478515625000000000e-01,
	/* 484*/ 6.76226317882537841796875000000000e-01,
	/* 485*/ 6.77355825901031494140625000000000e-01,
	/* 486*/ 6.78483784198760986328125000000000e-01,
	/* 487*/ 6.79610192775726318359375000000000e-01,
	/* 488*/ 6.80734932422637939453125000000000e-01,
	/* 489*/ 6.81858062744140625000000000000000e-01,
	/* 490*/ 6.82979643344879150390625000000000e-01,
	/* 491*/ 6.84099614620208740234375000000000e-01,
	/* 492*/ 6.85217916965484619140625000000000e-01,
	/* 493*/ 6.86334669589996337890625000000000e-01,
	/* 494*/ 6.87449753284454345703125000000000e-01,
	/* 495*/ 6.88563227653503417968750000000000e-01,
	/* 496*/ 6.89675092697143554687500000000000e-01,
	/* 497*/ 6.90785348415374755859375000000000e-01,
	/* 498*/ 6.91893994808197021484375000000000e-01,
	/* 499*/ 6.93000972270965576171875000000000e-01,
	/* 500*/ 6.94106340408325195312500000000000e-01,
	/* 501*/ 6.95210039615631103515625000000000e-01,
	/* 502*/ 6.96312129497528076171875000000000e-01,
	/* 503*/ 6.97412550449371337890625000000000e-01,
	/* 504*/ 6.98511362075805664062500000000000e-01,
	/* 505*/ 6.99608564376831054687500000000000e-01,
	/* 506*/ 7.00704038143157958984375000000000e-01,
	/* 507*/ 7.01797902584075927734375000000000e-01,
	/* 508*/ 7.02890157699584960937500000000000e-01,
	/* 509*/ 7.03980684280395507812500000000000e-01,
	/* 510*/ 7.05069601535797119140625000000000e-01,
	/* 511*/ 7.06156849861145019531250000000000e-01,
	/* 512*/ 7.07242429256439208984375000000000e-01,
	/* 513*/ 7.08326339721679687500000000000000e-01,
	/* 514*/ 7.09408581256866455078125000000000e-01,
	/* 515*/ 7.10489153861999511718750000000000e-01,
	/* 516*/ 7.11568057537078857421875000000000e-01,
	/* 517*/ 7.12645232677459716796875000000000e-01,
	/* 518*/ 7.13720798492431640625000000000000e-01,
	/* 519*/ 7.14794695377349853515625000000000e-01,
	/* 520*/ 7.15866863727569580078125000000000e-01,
	/* 521*/ 7.16937363147735595703125000000000e-01,
	/* 522*/ 7.18006193637847900390625000000000e-01,
	/* 523*/ 7.19073295593261718750000000000000e-01,
	/* 524*/ 7.20138728618621826171875000000000e-01,
	/* 525*/ 7.21202433109283447265625000000000e-01,
	/* 526*/ 7.22264468669891357421875000000000e-01,
	/* 527*/ 7.23324835300445556640625000000000e-01,
	/* 528*/ 7.24383473396301269531250000000000e-01,
	/* 529*/ 7.25440382957458496093750000000000e-01,
	/* 530*/ 7.26495623588562011718750000000000e-01,
	/* 531*/ 7.27549135684967041015625000000000e-01,
	/* 532*/ 7.28600919246673583984375000000000e-01,
	/* 533*/ 7.29650974273681640625000000000000e-01,
	/* 534*/ 7.30699360370635986328125000000000e-01,
	/* 535*/ 7.31746017932891845703125000000000e-01,
	/* 536*/ 7.32790946960449218750000000000000e-01,
	/* 537*/ 7.33834147453308105468750000000000e-01,
	/* 538*/ 7.34875559806823730468750000000000e-01,
	/* 539*/ 7.35915303230285644531250000000000e-01,
	/* 540*/ 7.36953318119049072265625000000000e-01,
	/* 541*/ 7.37989604473114013671875000000000e-01,
	/* 542*/ 7.39024102687835693359375000000000e-01,
	/* 543*/ 7.40056931972503662109375000000000e-01,
	/* 544*/ 7.41087973117828369140625000000000e-01,
	/* 545*/ 7.42117285728454589843750000000000e-01,
	/* 546*/ 7.43144810199737548828125000000000e-01,
	/* 547*/ 7.44170665740966796875000000000000e-01,
	/* 548*/ 7.45194733142852783203125000000000e-01,
	/* 549*/ 7.46217012405395507812500000000000e-01,
	/* 550*/ 7.47237563133239746093750000000000e-01,
	/* 551*/ 7.48256325721740722656250000000000e-01,
	/* 552*/ 7.49273359775543212890625000000000e-01,
	/* 553*/ 7.50288605690002441406250000000000e-01,
	/* 554*/ 7.51302123069763183593750000000000e-01,
	/* 555*/ 7.52313852310180664062500000000000e-01,
	/* 556*/ 7.53323793411254882812500000000000e-01,
	/* 557*/ 7.54332005977630615234375000000000e-01,
	/* 558*/ 7.55338370800018310546875000000000e-01,
	/* 559*/ 7.56343007087707519531250000000000e-01,
	/* 560*/ 7.57345855236053466796875000000000e-01,
	/* 561*/ 7.58346915245056152343750000000000e-01,
	/* 562*/ 7.59346187114715576171875000000000e-01,
	/* 563*/ 7.60343670845031738281250000000000e-01,
	/* 564*/ 7.61339426040649414062500000000000e-01,
	/* 565*/ 7.62333333492279052734375000000000e-01,
	/* 566*/ 7.63325393199920654296875000000000e-01,
	/* 567*/ 7.64315724372863769531250000000000e-01,
	/* 568*/ 7.65304267406463623046875000000000e-01,
	/* 569*/ 7.66290962696075439453125000000000e-01,
	/* 570*/ 7.67275869846343994140625000000000e-01,
	/* 571*/ 7.68258988857269287109375000000000e-01,
	/* 572*/ 7.69240260124206542968750000000000e-01,
	/* 573*/ 7.70219743251800537109375000000000e-01,
	/* 574*/ 7.71197438240051269531250000000000e-01,
	/* 575*/ 7.72173285484313964843750000000000e-01,
	/* 576*/ 7.73147344589233398437500000000000e-01,
	/* 577*/ 7.74119555950164794921875000000000e-01,
	/* 578*/ 7.75089919567108154296875000000000e-01,
	/* 579*/ 7.76058495044708251953125000000000e-01,
	/* 580*/ 7.77025282382965087890625000000000e-01,
	/* 581*/ 7.77990162372589111328125000000000e-01,
	/* 582*/ 7.78953254222869873046875000000000e-01,
	/* 583*/ 7.79914498329162597656250000000000e-01,
	/* 584*/ 7.80873894691467285156250000000000e-01,
	/* 585*/ 7.81831502914428710937500000000000e-01,
	/* 586*/ 7.82787203788757324218750000000000e-01,
	/* 587*/ 7.83741116523742675781250000000000e-01,
	/* 588*/ 7.84693181514739990234375000000000e-01,
	/* 589*/ 7.85643339157104492187500000000000e-01,
	/* 590*/ 7.86591708660125732421875000000000e-01,
	/* 591*/ 7.87538230419158935546875000000000e-01,
	/* 592*/ 7.88482844829559326171875000000000e-01,
	/* 593*/ 7.89425671100616455078125000000000e-01,
	/* 594*/ 7.90366590023040771484375000000000e-01,
	/* 595*/ 7.91305661201477050781250000000000e-01,
	/* 596*/ 7.92242825031280517578125000000000e-01,
	/* 597*/ 7.93178200721740722656250000000000e-01,
	/* 598*/ 7.94111669063568115234375000000000e-01,
	/* 599*/ 7.95043289661407470703125000000000e-01,
	/* 600*/ 7.95973002910614013671875000000000e-01,
	/* 601*/ 7.96900868415832519531250000000000e-01,
	/* 602*/ 7.97826826572418212890625000000000e-01,
	/* 603*/ 7.98750936985015869140625000000000e-01,
	/* 604*/ 7.99673140048980712890625000000000e-01,
	/* 605*/ 8.00593495368957519531250000000000e-01,
	/* 606*/ 8.01511943340301513671875000000000e-01,
	/* 607*/ 8.02428543567657470703125000000000e-01,
	/* 608*/ 8.03343176841735839843750000000000e-01,
	/* 609*/ 8.04255962371826171875000000000000e-01,
	/* 610*/ 8.05166900157928466796875000000000e-01,
	/* 611*/ 8.06075870990753173828125000000000e-01,
	/* 612*/ 8.06982994079589843750000000000000e-01,
	/* 613*/ 8.07888209819793701171875000000000e-01,
	/* 614*/ 8.08791458606719970703125000000000e-01,
	/* 615*/ 8.09692859649658203125000000000000e-01,
	/* 616*/ 8.10592353343963623046875000000000e-01,
	/* 617*/ 8.11489939689636230468750000000000e-01,
	/* 618*/ 8.12385618686676025390625000000000e-01,
	/* 619*/ 8.13279390335083007812500000000000e-01,
	/* 620*/ 8.14171195030212402343750000000000e-01,
	/* 621*/ 8.15061151981353759765625000000000e-01,
	/* 622*/ 8.15949141979217529296875000000000e-01,
	/* 623*/ 8.16835224628448486328125000000000e-01,
	/* 624*/ 8.17719399929046630859375000000000e-01,
	/* 625*/ 8.18601608276367187500000000000000e-01,
	/* 626*/ 8.19481968879699707031250000000000e-01,
	/* 627*/ 8.20360302925109863281250000000000e-01,
	/* 628*/ 8.21236789226531982421875000000000e-01,
	/* 629*/ 8.22111308574676513671875000000000e-01,
	/* 630*/ 8.22983860969543457031250000000000e-01,
	/* 631*/ 8.23854506015777587890625000000000e-01,
	/* 632*/ 8.24723243713378906250000000000000e-01,
	/* 633*/ 8.25590014457702636718750000000000e-01,
	/* 634*/ 8.26454818248748779296875000000000e-01,
	/* 635*/ 8.27317655086517333984375000000000e-01,
	/* 636*/ 8.28178584575653076171875000000000e-01,
	/* 637*/ 8.29037606716156005859375000000000e-01,
	/* 638*/ 8.29894602298736572265625000000000e-01,
	/* 639*/ 8.30749690532684326171875000000000e-01,
	/* 640*/ 8.31602811813354492187500000000000e-01,
	/* 641*/ 8.32453966140747070312500000000000e-01,
	/* 642*/ 8.33303153514862060546875000000000e-01,
	/* 643*/ 8.34150373935699462890625000000000e-01,
	/* 644*/ 8.34995687007904052734375000000000e-01,
	/* 645*/ 8.35838973522186279296875000000000e-01,
	/* 646*/ 8.36680293083190917968750000000000e-01,
	/* 647*/ 8.37519645690917968750000000000000e-01,
	/* 648*/ 8.38357090950012207031250000000000e-01,
	/* 649*/ 8.39192509651184082031250000000000e-01,
	/* 650*/ 8.40025961399078369140625000000000e-01,
	/* 651*/ 8.40857386589050292968750000000000e-01,
	/* 652*/ 8.41686904430389404296875000000000e-01,
	/* 653*/ 8.42514395713806152343750000000000e-01,
	/* 654*/ 8.43339920043945312500000000000000e-01,
	/* 655*/ 8.44163477420806884765625000000000e-01,
	/* 656*/ 8.44985008239746093750000000000000e-01,
	/* 657*/ 8.45804572105407714843750000000000e-01,
	/* 658*/ 8.46622169017791748046875000000000e-01,
	/* 659*/ 8.47437739372253417968750000000000e-01,
	/* 660*/ 8.48251342773437500000000000000000e-01,
	/* 661*/ 8.49062919616699218750000000000000e-01,
	/* 662*/ 8.49872469902038574218750000000000e-01,
	/* 663*/ 8.50680053234100341796875000000000e-01,
	/* 664*/ 8.51485669612884521484375000000000e-01,
	/* 665*/ 8.52289259433746337890625000000000e-01,
	/* 666*/ 8.53090822696685791015625000000000e-01,
	/* 667*/ 8.53890359401702880859375000000000e-01,
	/* 668*/ 8.54687929153442382812500000000000e-01,
	/* 669*/ 8.55483472347259521484375000000000e-01,
	/* 670*/ 8.56276988983154296875000000000000e-01,
	/* 671*/ 8.57068538665771484375000000000000e-01,
	/* 672*/ 8.57858002185821533203125000000000e-01,
	/* 673*/ 8.58645498752593994140625000000000e-01,
	/* 674*/ 8.59430968761444091796875000000000e-01,
	/* 675*/ 8.60214352607727050781250000000000e-01,
	/* 676*/ 8.60995769500732421875000000000000e-01,
	/* 677*/ 8.61775159835815429687500000000000e-01,
	/* 678*/ 8.62552523612976074218750000000000e-01,
	/* 679*/ 8.63327801227569580078125000000000e-01,
	/* 680*/ 8.64101111888885498046875000000000e-01,
	/* 681*/ 8.64872336387634277343750000000000e-01,
	/* 682*/ 8.65641593933105468750000000000000e-01,
	/* 683*/ 8.66408765316009521484375000000000e-01,
	/* 684*/ 8.67173910140991210937500000000000e-01,
	/* 685*/ 8.67936968803405761718750000000000e-01,
	/* 686*/ 8.68698060512542724609375000000000e-01,
	/* 687*/ 8.69457066059112548828125000000000e-01,
	/* 688*/ 8.70213985443115234375000000000000e-01,
	/* 689*/ 8.70968937873840332031250000000000e-01,
	/* 690*/ 8.71721804141998291015625000000000e-01,
	/* 691*/ 8.72472584247589111328125000000000e-01,
	/* 692*/ 8.73221337795257568359375000000000e-01,
	/* 693*/ 8.73968064785003662109375000000000e-01,
	/* 694*/ 8.74712705612182617187500000000000e-01,
	/* 695*/ 8.75455260276794433593750000000000e-01,
	/* 696*/ 8.76195788383483886718750000000000e-01,
	/* 697*/ 8.76934230327606201171875000000000e-01,
	/* 698*/ 8.77670645713806152343750000000000e-01,
	/* 699*/ 8.78404974937438964843750000000000e-01,
	/* 700*/ 8.79137217998504638671875000000000e-01,
	/* 701*/ 8.79867434501647949218750000000000e-01,
	/* 702*/ 8.80595564842224121093750000000000e-01,
	/* 703*/ 8.81321609020233154296875000000000e-01,
	/* 704*/ 8.82045567035675048828125000000000e-01,
	/* 705*/ 8.82767438888549804687500000000000e-01,
	/* 706*/ 8.83487284183502197265625000000000e-01,
	/* 707*/ 8.84204983711242675781250000000000e-01,
	/* 708*/ 8.84920656681060791015625000000000e-01,
	/* 709*/ 8.85634243488311767578125000000000e-01,
	/* 710*/ 8.86345744132995605468750000000000e-01,
	/* 711*/ 8.87055099010467529296875000000000e-01,
	/* 712*/ 8.87762427330017089843750000000000e-01,
	/* 713*/ 8.88467669486999511718750000000000e-01,
	/* 714*/ 8.89170765876770019531250000000000e-01,
	/* 715*/ 8.89871835708618164062500000000000e-01,
	/* 716*/ 8.90570759773254394531250000000000e-01,
	/* 717*/ 8.91267597675323486328125000000000e-01,
	/* 718*/ 8.91962349414825439453125000000000e-01,
	/* 719*/ 8.92655014991760253906250000000000e-01,
	/* 720*/ 8.93345534801483154296875000000000e-01,
	/* 721*/ 8.94033968448638916015625000000000e-01,
	/* 722*/ 8.94720315933227539062500000000000e-01,
	/* 723*/ 8.95404577255249023437500000000000e-01,
	/* 724*/ 8.96086692810058593750000000000000e-01,
	/* 725*/ 8.96766722202301025390625000000000e-01,
	/* 726*/ 8.97444605827331542968750000000000e-01,
	/* 727*/ 8.98120403289794921875000000000000e-01,
	/* 728*/ 8.98794054985046386718750000000000e-01,
	/* 729*/ 8.99465620517730712890625000000000e-01,
	/* 730*/ 9.00135040283203125000000000000000e-01,
	/* 731*/ 9.00802373886108398437500000000000e-01,
	/* 732*/ 9.01467561721801757812500000000000e-01,
	/* 733*/ 9.02130663394927978515625000000000e-01,
	/* 734*/ 9.02791619300842285156250000000000e-01,
	/* 735*/ 9.03450429439544677734375000000000e-01,
	/* 736*/ 9.04107153415679931640625000000000e-01,
	/* 737*/ 9.04761731624603271484375000000000e-01,
	/* 738*/ 9.05414164066314697265625000000000e-01,
	/* 739*/ 9.06064510345458984375000000000000e-01,
	/* 740*/ 9.06712651252746582031250000000000e-01,
	/* 741*/ 9.07358705997467041015625000000000e-01,
	/* 742*/ 9.08002614974975585937500000000000e-01,
	/* 743*/ 9.08644378185272216796875000000000e-01,
	/* 744*/ 9.09283995628356933593750000000000e-01,
	/* 745*/ 9.09921526908874511718750000000000e-01,
	/* 746*/ 9.10556852817535400390625000000000e-01,
	/* 747*/ 9.11190092563629150390625000000000e-01,
	/* 748*/ 9.11821126937866210937500000000000e-01,
	/* 749*/ 9.12450015544891357421875000000000e-01,
	/* 750*/ 9.13076817989349365234375000000000e-01,
	/* 751*/ 9.13701415061950683593750000000000e-01,
	/* 752*/ 9.14323866367340087890625000000000e-01,
	/* 753*/ 9.14944171905517578125000000000000e-01,
	/* 754*/ 9.15562331676483154296875000000000e-01,
	/* 755*/ 9.16178345680236816406250000000000e-01,
	/* 756*/ 9.16792213916778564453125000000000e-01,
	/* 757*/ 9.17403876781463623046875000000000e-01,
	/* 758*/ 9.18013393878936767578125000000000e-01,
	/* 759*/ 9.18620765209197998046875000000000e-01,
	/* 760*/ 9.19225990772247314453125000000000e-01,
	/* 761*/ 9.19829010963439941406250000000000e-01,
	/* 762*/ 9.20429885387420654296875000000000e-01,
	/* 763*/ 9.21028614044189453125000000000000e-01,
	/* 764*/ 9.21625137329101562500000000000000e-01,
	/* 765*/ 9.22219514846801757812500000000000e-01,
	/* 766*/ 9.22811746597290039062500000000000e-01,
	/* 767*/ 9.23401772975921630859375000000000e-01,
	/* 768*/ 9.23989593982696533203125000000000e-01,
	/* 769*/ 9.24575269222259521484375000000000e-01,
	/* 770*/ 9.25158798694610595703125000000000e-01,
	/* 771*/ 9.25740122795104980468750000000000e-01,
	/* 772*/ 9.26319241523742675781250000000000e-01,
	/* 773*/ 9.26896214485168457031250000000000e-01,
	/* 774*/ 9.27470982074737548828125000000000e-01,
	/* 775*/ 9.28043603897094726562500000000000e-01,
	/* 776*/ 9.28613960742950439453125000000000e-01,
	/* 777*/ 9.29182231426239013671875000000000e-01,
	/* 778*/ 9.29748237133026123046875000000000e-01,
	/* 779*/ 9.30312097072601318359375000000000e-01,
	/* 780*/ 9.30873751640319824218750000000000e-01,
	/* 781*/ 9.31433200836181640625000000000000e-01,
	/* 782*/ 9.31990504264831542968750000000000e-01,
	/* 783*/ 9.32545602321624755859375000000000e-01,
	/* 784*/ 9.33098495006561279296875000000000e-01,
	/* 785*/ 9.33649182319641113281250000000000e-01,
	/* 786*/ 9.34197664260864257812500000000000e-01,
	/* 787*/ 9.34743940830230712890625000000000e-01,
	/* 788*/ 9.35288012027740478515625000000000e-01,
	/* 789*/ 9.35829937458038330078125000000000e-01,
	/* 790*/ 9.36369597911834716796875000000000e-01,
	/* 791*/ 9.36907052993774414062500000000000e-01,
	/* 792*/ 9.37442362308502197265625000000000e-01,
	/* 793*/ 9.37975406646728515625000000000000e-01,
	/* 794*/ 9.38506305217742919921875000000000e-01,
	/* 795*/ 9.39034938812255859375000000000000e-01,
	/* 796*/ 9.39561367034912109375000000000000e-01,
	/* 797*/ 9.40085589885711669921875000000000e-01,
	/* 798*/ 9.40607607364654541015625000000000e-01,
	/* 799*/ 9.41127419471740722656250000000000e-01,
	/* 800*/ 9.41644966602325439453125000000000e-01,
	/* 801*/ 9.42160367965698242187500000000000e-01,
	/* 802*/ 9.42673504352569580078125000000000e-01,
	/* 803*/ 9.43184435367584228515625000000000e-01,
	/* 804*/ 9.43693161010742187500000000000000e-01,
	/* 805*/ 9.44199621677398681640625000000000e-01,
	/* 806*/ 9.44703876972198486328125000000000e-01,
	/* 807*/ 9.45205926895141601562500000000000e-01,
	/* 808*/ 9.45705771446228027343750000000000e-01,
	/* 809*/ 9.46203351020812988281250000000000e-01,
	/* 810*/ 9.46698725223541259765625000000000e-01,
	/* 811*/ 9.47191834449768066406250000000000e-01,
	/* 812*/ 9.47682738304138183593750000000000e-01,
	/* 813*/ 9.48171436786651611328125000000000e-01,
	/* 814*/ 9.48657870292663574218750000000000e-01,
	/* 815*/ 9.49142038822174072265625000000000e-01,
	/* 816*/ 9.49624001979827880859375000000000e-01,
	/* 817*/ 9.50103759765625000000000000000000e-01,
	/* 818*/ 9.50581252574920654296875000000000e-01,
	/* 819*/ 9.51056540012359619140625000000000e-01,
	/* 820*/ 9.51529562473297119140625000000000e-01,
	/* 821*/ 9.52000319957733154296875000000000e-01,
	/* 822*/ 9.52468872070312500000000000000000e-01,
	/* 823*/ 9.52935159206390380859375000000000e-01,
	/* 824*/ 9.53399240970611572265625000000000e-01,
	/* 825*/ 9.53861057758331298828125000000000e-01,
	/* 826*/ 9.54320609569549560546875000000000e-01,
	/* 827*/ 9.54777896404266357421875000000000e-01,
	/* 828*/ 9.55232977867126464843750000000000e-01,
	/* 829*/ 9.55685794353485107421875000000000e-01,
	/* 830*/ 9.56136405467987060546875000000000e-01,
	/* 831*/ 9.56584692001342773437500000000000e-01,
	/* 832*/ 9.57030773162841796875000000000000e-01,
	/* 833*/ 9.57474589347839355468750000000000e-01,
	/* 834*/ 9.57916140556335449218750000000000e-01,
	/* 835*/ 9.58355426788330078125000000000000e-01,
	/* 836*/ 9.58792507648468017578125000000000e-01,
	/* 837*/ 9.59227323532104492187500000000000e-01,
	/* 838*/ 9.59659814834594726562500000000000e-01,
	/* 839*/ 9.60090100765228271484375000000000e-01,
	/* 840*/ 9.60518121719360351562500000000000e-01,
	/* 841*/ 9.60943877696990966796875000000000e-01,
	/* 842*/ 9.61367368698120117187500000000000e-01,
	/* 843*/ 9.61788594722747802734375000000000e-01,
	/* 844*/ 9.62207555770874023437500000000000e-01,
	/* 845*/ 9.62624251842498779296875000000000e-01,
	/* 846*/ 9.63038682937622070312500000000000e-01,
	/* 847*/ 9.63450849056243896484375000000000e-01,
	/* 848*/ 9.63860750198364257812500000000000e-01,
	/* 849*/ 9.64268386363983154296875000000000e-01,
	/* 850*/ 9.64673757553100585937500000000000e-01,
	/* 851*/ 9.65076804161071777343750000000000e-01,
	/* 852*/ 9.65477645397186279296875000000000e-01,
	/* 853*/ 9.65876162052154541015625000000000e-01,
	/* 854*/ 9.66272473335266113281250000000000e-01,
	/* 855*/ 9.66666460037231445312500000000000e-01,
	/* 856*/ 9.67058181762695312500000000000000e-01,
	/* 857*/ 9.67447578907012939453125000000000e-01,
	/* 858*/ 9.67834770679473876953125000000000e-01,
	/* 859*/ 9.68219637870788574218750000000000e-01,
	/* 860*/ 9.68602240085601806640625000000000e-01,
	/* 861*/ 9.68982577323913574218750000000000e-01,
	/* 862*/ 9.69360589981079101562500000000000e-01,
	/* 863*/ 9.69736397266387939453125000000000e-01,
	/* 864*/ 9.70109879970550537109375000000000e-01,
	/* 865*/ 9.70481038093566894531250000000000e-01,
	/* 866*/ 9.70849931240081787109375000000000e-01,
	/* 867*/ 9.71216559410095214843750000000000e-01,
	/* 868*/ 9.71580922603607177734375000000000e-01,
	/* 869*/ 9.71942961215972900390625000000000e-01,
	/* 870*/ 9.72302734851837158203125000000000e-01,
	/* 871*/ 9.72660183906555175781250000000000e-01,
	/* 872*/ 9.73015367984771728515625000000000e-01,
	/* 873*/ 9.73368287086486816406250000000000e-01,
	/* 874*/ 9.73718881607055664062500000000000e-01,
	/* 875*/ 9.74067211151123046875000000000000e-01,
	/* 876*/ 9.74413216114044189453125000000000e-01,
	/* 877*/ 9.74756896495819091796875000000000e-01,
	/* 878*/ 9.75098371505737304687500000000000e-01,
	/* 879*/ 9.75437462329864501953125000000000e-01,
	/* 880*/ 9.75774288177490234375000000000000e-01,
	/* 881*/ 9.76108849048614501953125000000000e-01,
	/* 882*/ 9.76441085338592529296875000000000e-01,
	/* 883*/ 9.76770997047424316406250000000000e-01,
	/* 884*/ 9.77098643779754638671875000000000e-01,
	/* 885*/ 9.77424025535583496093750000000000e-01,
	/* 886*/ 9.77747023105621337890625000000000e-01,
	/* 887*/ 9.78067755699157714843750000000000e-01,
	/* 888*/ 9.78386223316192626953125000000000e-01,
	/* 889*/ 9.78702366352081298828125000000000e-01,
	/* 890*/ 9.79016184806823730468750000000000e-01,
	/* 891*/ 9.79327678680419921875000000000000e-01,
	/* 892*/ 9.79636907577514648437500000000000e-01,
	/* 893*/ 9.79943811893463134765625000000000e-01,
	/* 894*/ 9.80248451232910156250000000000000e-01,
	/* 895*/ 9.80550706386566162109375000000000e-01,
	/* 896*/ 9.80850696563720703125000000000000e-01,
	/* 897*/ 9.81148362159729003906250000000000e-01,
	/* 898*/ 9.81443762779235839843750000000000e-01,
	/* 899*/ 9.81736838817596435546875000000000e-01,
	/* 900*/ 9.82027590274810791015625000000000e-01,
	/* 901*/ 9.82316017150878906250000000000000e-01,
	/* 902*/ 9.82602119445800781250000000000000e-01,
	/* 903*/ 9.82885897159576416015625000000000e-01,
	/* 904*/ 9.83167409896850585937500000000000e-01,
	/* 905*/ 9.83446598052978515625000000000000e-01,
	/* 906*/ 9.83723461627960205078125000000000e-01,
	/* 907*/ 9.83998000621795654296875000000000e-01,
	/* 908*/ 9.84270274639129638671875000000000e-01,
	/* 909*/ 9.84540164470672607421875000000000e-01,
	/* 910*/ 9.84807729721069335937500000000000e-01,
	/* 911*/ 9.85073029994964599609375000000000e-01,
	/* 912*/ 9.85336005687713623046875000000000e-01,
	/* 913*/ 9.85596656799316406250000000000000e-01,
	/* 914*/ 9.85854983329772949218750000000000e-01,
	/* 915*/ 9.86110925674438476562500000000000e-01,
	/* 916*/ 9.86364603042602539062500000000000e-01,
	/* 917*/ 9.86616015434265136718750000000000e-01,
	/* 918*/ 9.86865043640136718750000000000000e-01,
	/* 919*/ 9.87111747264862060546875000000000e-01,
	/* 920*/ 9.87356126308441162109375000000000e-01,
	/* 921*/ 9.87598180770874023437500000000000e-01,
	/* 922*/ 9.87837910652160644531250000000000e-01,
	/* 923*/ 9.88075315952301025390625000000000e-01,
	/* 924*/ 9.88310396671295166015625000000000e-01,
	/* 925*/ 9.88543152809143066406250000000000e-01,
	/* 926*/ 9.88773584365844726562500000000000e-01,
	/* 927*/ 9.89001691341400146484375000000000e-01,
	/* 928*/ 9.89227473735809326171875000000000e-01,
	/* 929*/ 9.89450931549072265625000000000000e-01,
	/* 930*/ 9.89672005176544189453125000000000e-01,
	/* 931*/ 9.89890813827514648437500000000000e-01,
	/* 932*/ 9.90107238292694091796875000000000e-01,
	/* 933*/ 9.90321397781372070312500000000000e-01,
	/* 934*/ 9.90533173084259033203125000000000e-01,
	/* 935*/ 9.90742623805999755859375000000000e-01,
	/* 936*/ 9.90949749946594238281250000000000e-01,
	/* 937*/ 9.91154551506042480468750000000000e-01,
	/* 938*/ 9.91357028484344482421875000000000e-01,
	/* 939*/ 9.91557121276855468750000000000000e-01,
	/* 940*/ 9.91754949092864990234375000000000e-01,
	/* 941*/ 9.91950392723083496093750000000000e-01,
	/* 942*/ 9.92143511772155761718750000000000e-01,
	/* 943*/ 9.92334306240081787109375000000000e-01,
	/* 944*/ 9.92522776126861572265625000000000e-01,
	/* 945*/ 9.92708861827850341796875000000000e-01,
	/* 946*/ 9.92892682552337646484375000000000e-01,
	/* 947*/ 9.93074119091033935546875000000000e-01,
	/* 948*/ 9.93253171443939208984375000000000e-01,
	/* 949*/ 9.93429958820343017578125000000000e-01,
	/* 950*/ 9.93604362010955810546875000000000e-01,
	/* 951*/ 9.93776500225067138671875000000000e-01,
	/* 952*/ 9.93946194648742675781250000000000e-01,
	/* 953*/ 9.94113624095916748046875000000000e-01,
	/* 954*/ 9.94278669357299804687500000000000e-01,
	/* 955*/ 9.94441390037536621093750000000000e-01,
	/* 956*/ 9.94601786136627197265625000000000e-01,
	/* 957*/ 9.94759857654571533203125000000000e-01,
	/* 958*/ 9.94915544986724853515625000000000e-01,
	/* 959*/ 9.95068907737731933593750000000000e-01,
	/* 960*/ 9.95219886302947998046875000000000e-01,
	/* 961*/ 9.95368599891662597656250000000000e-01,
	/* 962*/ 9.95514929294586181640625000000000e-01,
	/* 963*/ 9.95658874511718750000000000000000e-01,
	/* 964*/ 9.95800554752349853515625000000000e-01,
	/* 965*/ 9.95939850807189941406250000000000e-01,
	/* 966*/ 9.96076762676239013671875000000000e-01,
	/* 967*/ 9.96211409568786621093750000000000e-01,
	/* 968*/ 9.96343672275543212890625000000000e-01,
	/* 969*/ 9.96473550796508789062500000000000e-01,
	/* 970*/ 9.96601164340972900390625000000000e-01,
	/* 971*/ 9.96726393699645996093750000000000e-01,
	/* 972*/ 9.96849238872528076171875000000000e-01,
	/* 973*/ 9.96969759464263916015625000000000e-01,
	/* 974*/ 9.97087955474853515625000000000000e-01,
	/* 975*/ 9.97203826904296875000000000000000e-01,
	/* 976*/ 9.97317314147949218750000000000000e-01,
	/* 977*/ 9.97428417205810546875000000000000e-01,
	/* 978*/ 9.97537195682525634765625000000000e-01,
	/* 979*/ 9.97643649578094482421875000000000e-01,
	/* 980*/ 9.97747778892517089843750000000000e-01,
	/* 981*/ 9.97849524021148681640625000000000e-01,
	/* 982*/ 9.97948884963989257812500000000000e-01,
	/* 983*/ 9.98045980930328369140625000000000e-01,
	/* 984*/ 9.98140633106231689453125000000000e-01,
	/* 985*/ 9.98233020305633544921875000000000e-01,
	/* 986*/ 9.98323023319244384765625000000000e-01,
	/* 987*/ 9.98410642147064208984375000000000e-01,
	/* 988*/ 9.98495936393737792968750000000000e-01,
	/* 989*/ 9.98578906059265136718750000000000e-01,
	/* 990*/ 9.98659491539001464843750000000000e-01,
	/* 991*/ 9.98737752437591552734375000000000e-01,
	/* 992*/ 9.98813629150390625000000000000000e-01,
	/* 993*/ 9.98887181282043457031250000000000e-01,
	/* 994*/ 9.98958349227905273437500000000000e-01,
	/* 995*/ 9.99027192592620849609375000000000e-01,
	/* 996*/ 9.99093651771545410156250000000000e-01,
	/* 997*/ 9.99157786369323730468750000000000e-01,
	/* 998*/ 9.99219596385955810546875000000000e-01,
	/* 999*/ 9.99279022216796875000000000000000e-01,
	/*1000*/ 9.99336123466491699218750000000000e-01,
	/*1001*/ 9.99390840530395507812500000000000e-01,
	/*1002*/ 9.99443173408508300781250000000000e-01,
	/*1003*/ 9.99493241310119628906250000000000e-01,
	/*1004*/ 9.99540865421295166015625000000000e-01,
	/*1005*/ 9.99586224555969238281250000000000e-01,
	/*1006*/ 9.99629139900207519531250000000000e-01,
	/*1007*/ 9.99669790267944335937500000000000e-01,
	/*1008*/ 9.99707996845245361328125000000000e-01,
	/*1009*/ 9.99743938446044921875000000000000e-01,
	/*1010*/ 9.99777436256408691406250000000000e-01,
	/*1011*/ 9.99808669090270996093750000000000e-01,
	/*1012*/ 9.99837517738342285156250000000000e-01,
	/*1013*/ 9.99863982200622558593750000000000e-01,
	/*1014*/ 9.99888122081756591796875000000000e-01,
	/*1015*/ 9.99909877777099609375000000000000e-01,
	/*1016*/ 9.99929308891296386718750000000000e-01,
	/*1017*/ 9.99946355819702148437500000000000e-01,
	/*1018*/ 9.99961078166961669921875000000000e-01,
	/*1019*/ 9.99973416328430175781250000000000e-01,
	/*1020*/ 9.99983429908752441406250000000000e-01,
	/*1021*/ 9.99991118907928466796875000000000e-01,
	/*1022*/ 9.99996423721313476562500000000000e-01,
	/*1023*/ 9.99999344348907470703125000000000e-01,
	/*1024*/ 9.99999940395355224609375000000000e-01,
	/*1025*/ 9.99998152256011962890625000000000e-01,
	/*1026*/ 9.99994039535522460937500000000000e-01,
	/*1027*/ 9.99987542629241943359375000000000e-01,
	/*1028*/ 9.99978721141815185546875000000000e-01,
	/*1029*/ 9.99967575073242187500000000000000e-01,
	/*1030*/ 9.99954044818878173828125000000000e-01,
	/*1031*/ 9.99938130378723144531250000000000e-01,
	/*1032*/ 9.99919891357421875000000000000000e-01,
	/*1033*/ 9.99899268150329589843750000000000e-01,
	/*1034*/ 9.99876320362091064453125000000000e-01,
	/*1035*/ 9.99851047992706298828125000000000e-01,
	/*1036*/ 9.99823391437530517578125000000000e-01,
	/*1037*/ 9.99793350696563720703125000000000e-01,
	/*1038*/ 9.99760985374450683593750000000000e-01,
	/*1039*/ 9.99726235866546630859375000000000e-01,
	/*1040*/ 9.99689161777496337890625000000000e-01,
	/*1041*/ 9.99649763107299804687500000000000e-01,
	/*1042*/ 9.99607980251312255859375000000000e-01,
	/*1043*/ 9.99563813209533691406250000000000e-01,
	/*1044*/ 9.99517321586608886718750000000000e-01,
	/*1045*/ 9.99468505382537841796875000000000e-01,
	/*1046*/ 9.99417304992675781250000000000000e-01,
	/*1047*/ 9.99363780021667480468750000000000e-01,
	/*1048*/ 9.99307870864868164062500000000000e-01,
	/*1049*/ 9.99249577522277832031250000000000e-01,
	/*1050*/ 9.99189019203186035156250000000000e-01,
	/*1051*/ 9.99126017093658447265625000000000e-01,
	/*1052*/ 9.99060750007629394531250000000000e-01,
	/*1053*/ 9.98993039131164550781250000000000e-01,
	/*1054*/ 9.98923063278198242187500000000000e-01,
	/*1055*/ 9.98850703239440917968750000000000e-01,
	/*1056*/ 9.98775959014892578125000000000000e-01,
	/*1057*/ 9.98698890209197998046875000000000e-01,
	/*1058*/ 9.98619496822357177734375000000000e-01,
	/*1059*/ 9.98537719249725341796875000000000e-01,
	/*1060*/ 9.98453557491302490234375000000000e-01,
	/*1061*/ 9.98367130756378173828125000000000e-01,
	/*1062*/ 9.98278260231018066406250000000000e-01,
	/*1063*/ 9.98187124729156494140625000000000e-01,
	/*1064*/ 9.98093605041503906250000000000000e-01,
	/*1065*/ 9.97997701168060302734375000000000e-01,
	/*1066*/ 9.97899472713470458984375000000000e-01,
	/*1067*/ 9.97798919677734375000000000000000e-01,
	/*1068*/ 9.97695982456207275390625000000000e-01,
	/*1069*/ 9.97590720653533935546875000000000e-01,
	/*1070*/ 9.97483134269714355468750000000000e-01,
	/*1071*/ 9.97373163700103759765625000000000e-01,
	/*1072*/ 9.97260808944702148437500000000000e-01,
	/*1073*/ 9.97146189212799072265625000000000e-01,
	/*1074*/ 9.97029185295104980468750000000000e-01,
	/*1075*/ 9.96909797191619873046875000000000e-01,
	/*1076*/ 9.96788084506988525390625000000000e-01,
	/*1077*/ 9.96664047241210937500000000000000e-01,
	/*1078*/ 9.96537625789642333984375000000000e-01,
	/*1079*/ 9.96408879756927490234375000000000e-01,
	/*1080*/ 9.96277809143066406250000000000000e-01,
	/*1081*/ 9.96144354343414306640625000000000e-01,
	/*1082*/ 9.96008574962615966796875000000000e-01,
	/*1083*/ 9.95870471000671386718750000000000e-01,
	/*1084*/ 9.95729982852935791015625000000000e-01,
	/*1085*/ 9.95587170124053955078125000000000e-01,
	/*1086*/ 9.95442032814025878906250000000000e-01,
	/*1087*/ 9.95294511318206787109375000000000e-01,
	/*1088*/ 9.95144665241241455078125000000000e-01,
	/*1089*/ 9.94992494583129882812500000000000e-01,
	/*1090*/ 9.94837999343872070312500000000000e-01,
	/*1091*/ 9.94681119918823242187500000000000e-01,
	/*1092*/ 9.94521915912628173828125000000000e-01,
	/*1093*/ 9.94360327720642089843750000000000e-01,
	/*1094*/ 9.94196414947509765625000000000000e-01,
	/*1095*/ 9.94030177593231201171875000000000e-01,
	/*1096*/ 9.93861615657806396484375000000000e-01,
	/*1097*/ 9.93690729141235351562500000000000e-01,
	/*1098*/ 9.93517458438873291015625000000000e-01,
	/*1099*/ 9.93341863155364990234375000000000e-01,
	/*1100*/ 9.93163943290710449218750000000000e-01,
	/*1101*/ 9.92983639240264892578125000000000e-01,
	/*1102*/ 9.92801070213317871093750000000000e-01,
	/*1103*/ 9.92616117000579833984375000000000e-01,
	/*1104*/ 9.92428839206695556640625000000000e-01,
	/*1105*/ 9.92239177227020263671875000000000e-01,
	/*1106*/ 9.92047250270843505859375000000000e-01,
	/*1107*/ 9.91852939128875732421875000000000e-01,
	/*1108*/ 9.91656303405761718750000000000000e-01,
	/*1109*/ 9.91457343101501464843750000000000e-01,
	/*1110*/ 9.91256058216094970703125000000000e-01,
	/*1111*/ 9.91052448749542236328125000000000e-01,
	/*1112*/ 9.90846455097198486328125000000000e-01,
	/*1113*/ 9.90638196468353271484375000000000e-01,
	/*1114*/ 9.90427553653717041015625000000000e-01,
	/*1115*/ 9.90214586257934570312500000000000e-01,
	/*1116*/ 9.89999294281005859375000000000000e-01,
	/*1117*/ 9.89781677722930908203125000000000e-01,
	/*1118*/ 9.89561736583709716796875000000000e-01,
	/*1119*/ 9.89339470863342285156250000000000e-01,
	/*1120*/ 9.89114880561828613281250000000000e-01,
	/*1121*/ 9.88887906074523925781250000000000e-01,
	/*1122*/ 9.88658666610717773437500000000000e-01,
	/*1123*/ 9.88427042961120605468750000000000e-01,
	/*1124*/ 9.88193154335021972656250000000000e-01,
	/*1125*/ 9.87956881523132324218750000000000e-01,
	/*1126*/ 9.87718343734741210937500000000000e-01,
	/*1127*/ 9.87477421760559082031250000000000e-01,
	/*1128*/ 9.87234175205230712890625000000000e-01,
	/*1129*/ 9.86988663673400878906250000000000e-01,
	/*1130*/ 9.86740767955780029296875000000000e-01,
	/*1131*/ 9.86490607261657714843750000000000e-01,
	/*1132*/ 9.86238062381744384765625000000000e-01,
	/*1133*/ 9.85983252525329589843750000000000e-01,
	/*1134*/ 9.85726058483123779296875000000000e-01,
	/*1135*/ 9.85466599464416503906250000000000e-01,
	/*1136*/ 9.85204815864562988281250000000000e-01,
	/*1137*/ 9.84940648078918457031250000000000e-01,
	/*1138*/ 9.84674215316772460937500000000000e-01,
	/*1139*/ 9.84405457973480224609375000000000e-01,
	/*1140*/ 9.84134435653686523437500000000000e-01,
	/*1141*/ 9.83861029148101806640625000000000e-01,
	/*1142*/ 9.83585298061370849609375000000000e-01,
	/*1143*/ 9.83307301998138427734375000000000e-01,
	/*1144*/ 9.83026921749114990234375000000000e-01,
	/*1145*/ 9.82744276523590087890625000000000e-01,
	/*1146*/ 9.82459306716918945312500000000000e-01,
	/*1147*/ 9.82172071933746337890625000000000e-01,
	/*1148*/ 9.81882452964782714843750000000000e-01,
	/*1149*/ 9.81590569019317626953125000000000e-01,
	/*1150*/ 9.81296360492706298828125000000000e-01,
	/*1151*/ 9.80999827384948730468750000000000e-01,
	/*1152*/ 9.80700969696044921875000000000000e-01,
	/*1153*/ 9.80399847030639648437500000000000e-01,
	/*1154*/ 9.80096399784088134765625000000000e-01,
	/*1155*/ 9.79790627956390380859375000000000e-01,
	/*1156*/ 9.79482591152191162109375000000000e-01,
	/*1157*/ 9.79172229766845703125000000000000e-01,
	/*1158*/ 9.78859543800354003906250000000000e-01,
	/*1159*/ 9.78544533252716064453125000000000e-01,
	/*1160*/ 9.78227257728576660156250000000000e-01,
	/*1161*/ 9.77907657623291015625000000000000e-01,
	/*1162*/ 9.77585792541503906250000000000000e-01,
	/*1163*/ 9.77261602878570556640625000000000e-01,
	/*1164*/ 9.76935088634490966796875000000000e-01,
	/*1165*/ 9.76606309413909912109375000000000e-01,
	/*1166*/ 9.76275265216827392578125000000000e-01,
	/*1167*/ 9.75941836833953857421875000000000e-01,
	/*1168*/ 9.75606143474578857421875000000000e-01,
	/*1169*/ 9.75268185138702392578125000000000e-01,
	/*1170*/ 9.74927902221679687500000000000000e-01,
	/*1171*/ 9.74585354328155517578125000000000e-01,
	/*1172*/ 9.74240481853485107421875000000000e-01,
	/*1173*/ 9.73893284797668457031250000000000e-01,
	/*1174*/ 9.73543822765350341796875000000000e-01,
	/*1175*/ 9.73192095756530761718750000000000e-01,
	/*1176*/ 9.72838044166564941406250000000000e-01,
	/*1177*/ 9.72481727600097656250000000000000e-01,
	/*1178*/ 9.72123086452484130859375000000000e-01,
	/*1179*/ 9.71762180328369140625000000000000e-01,
	/*1180*/ 9.71399009227752685546875000000000e-01,
	/*1181*/ 9.71033513545989990234375000000000e-01,
	/*1182*/ 9.70665752887725830078125000000000e-01,
	/*1183*/ 9.70295727252960205078125000000000e-01,
	/*1184*/ 9.69923377037048339843750000000000e-01,
	/*1185*/ 9.69548761844635009765625000000000e-01,
	/*1186*/ 9.69171881675720214843750000000000e-01,
	/*1187*/ 9.68792676925659179687500000000000e-01,
	/*1188*/ 9.68411207199096679687500000000000e-01,
	/*1189*/ 9.68027472496032714843750000000000e-01,
	/*1190*/ 9.67641413211822509765625000000000e-01,
	/*1191*/ 9.67253148555755615234375000000000e-01,
	/*1192*/ 9.66862559318542480468750000000000e-01,
	/*1193*/ 9.66469705104827880859375000000000e-01,
	/*1194*/ 9.66074585914611816406250000000000e-01,
	/*1195*/ 9.65677142143249511718750000000000e-01,
	/*1196*/ 9.65277493000030517578125000000000e-01,
	/*1197*/ 9.64875519275665283203125000000000e-01,
	/*1198*/ 9.64471340179443359375000000000000e-01,
	/*1199*/ 9.64064836502075195312500000000000e-01,
	/*1200*/ 9.63656067848205566406250000000000e-01,
	/*1201*/ 9.63245034217834472656250000000000e-01,
	/*1202*/ 9.62831735610961914062500000000000e-01,
	/*1203*/ 9.62416172027587890625000000000000e-01,
	/*1204*/ 9.61998343467712402343750000000000e-01,
	/*1205*/ 9.61578249931335449218750000000000e-01,
	/*1206*/ 9.61155891418457031250000000000000e-01,
	/*1207*/ 9.60731267929077148437500000000000e-01,
	/*1208*/ 9.60304379463195800781250000000000e-01,
	/*1209*/ 9.59875226020812988281250000000000e-01,
	/*1210*/ 9.59443807601928710937500000000000e-01,
	/*1211*/ 9.59010183811187744140625000000000e-01,
	/*1212*/ 9.58574235439300537109375000000000e-01,
	/*1213*/ 9.58136081695556640625000000000000e-01,
	/*1214*/ 9.57695603370666503906250000000000e-01,
	/*1215*/ 9.57252919673919677734375000000000e-01,
	/*1216*/ 9.56807971000671386718750000000000e-01,
	/*1217*/ 9.56360816955566406250000000000000e-01,
	/*1218*/ 9.55911338329315185546875000000000e-01,
	/*1219*/ 9.55459654331207275390625000000000e-01,
	/*1220*/ 9.55005705356597900390625000000000e-01,
	/*1221*/ 9.54549491405487060546875000000000e-01,
	/*1222*/ 9.54091072082519531250000000000000e-01,
	/*1223*/ 9.53630387783050537109375000000000e-01,
	/*1224*/ 9.53167438507080078125000000000000e-01,
	/*1225*/ 9.52702283859252929687500000000000e-01,
	/*1226*/ 9.52234864234924316406250000000000e-01,
	/*1227*/ 9.51765179634094238281250000000000e-01,
	/*1228*/ 9.51293289661407470703125000000000e-01,
	/*1229*/ 9.50819134712219238281250000000000e-01,
	/*1230*/ 9.50342774391174316406250000000000e-01,
	/*1231*/ 9.49864149093627929687500000000000e-01,
	/*1232*/ 9.49383318424224853515625000000000e-01,
	/*1233*/ 9.48900222778320312500000000000000e-01,
	/*1234*/ 9.48414862155914306640625000000000e-01,
	/*1235*/ 9.47927355766296386718750000000000e-01,
	/*1236*/ 9.47437524795532226562500000000000e-01,
	/*1237*/ 9.46945548057556152343750000000000e-01,
	/*1238*/ 9.46451306343078613281250000000000e-01,
	/*1239*/ 9.45954799652099609375000000000000e-01,
	/*1240*/ 9.45456087589263916015625000000000e-01,
	/*1241*/ 9.44955170154571533203125000000000e-01,
	/*1242*/ 9.44452047348022460937500000000000e-01,
	/*1243*/ 9.43946659564971923828125000000000e-01,
	/*1244*/ 9.43439066410064697265625000000000e-01,
	/*1245*/ 9.42929208278656005859375000000000e-01,
	/*1246*/ 9.42417204380035400390625000000000e-01,
	/*1247*/ 9.41902935504913330078125000000000e-01,
	/*1248*/ 9.41386461257934570312500000000000e-01,
	/*1249*/ 9.40867781639099121093750000000000e-01,
	/*1250*/ 9.40346837043762207031250000000000e-01,
	/*1251*/ 9.39823746681213378906250000000000e-01,
	/*1252*/ 9.39298391342163085937500000000000e-01,
	/*1253*/ 9.38770830631256103515625000000000e-01,
	/*1254*/ 9.38241124153137207031250000000000e-01,
	/*1255*/ 9.37709152698516845703125000000000e-01,
	/*1256*/ 9.37174975872039794921875000000000e-01,
	/*1257*/ 9.36638593673706054687500000000000e-01,
	/*1258*/ 9.36100006103515625000000000000000e-01,
	/*1259*/ 9.35559213161468505859375000000000e-01,
	/*1260*/ 9.35016214847564697265625000000000e-01,
	/*1261*/ 9.34471011161804199218750000000000e-01,
	/*1262*/ 9.33923661708831787109375000000000e-01,
	/*1263*/ 9.33374047279357910156250000000000e-01,
	/*1264*/ 9.32822287082672119140625000000000e-01,
	/*1265*/ 9.32268261909484863281250000000000e-01,
	/*1266*/ 9.31712090969085693359375000000000e-01,
	/*1267*/ 9.31153714656829833984375000000000e-01,
	/*1268*/ 9.30593192577362060546875000000000e-01,
	/*1269*/ 9.30030405521392822265625000000000e-01,
	/*1270*/ 9.29465472698211669921875000000000e-01,
	/*1271*/ 9.28898334503173828125000000000000e-01,
	/*1272*/ 9.28329050540924072265625000000000e-01,
	/*1273*/ 9.27757501602172851562500000000000e-01,
	/*1274*/ 9.27183806896209716796875000000000e-01,
	/*1275*/ 9.26607966423034667968750000000000e-01,
	/*1276*/ 9.26029920578002929687500000000000e-01,
	/*1277*/ 9.25449669361114501953125000000000e-01,
	/*1278*/ 9.24867272377014160156250000000000e-01,
	/*1279*/ 9.24282670021057128906250000000000e-01,
	/*1280*/ 9.23695921897888183593750000000000e-01,
	/*1281*/ 9.23106968402862548828125000000000e-01,
	/*1282*/ 9.22515869140625000000000000000000e-01,
	/*1283*/ 9.21922564506530761718750000000000e-01,
	/*1284*/ 9.21327114105224609375000000000000e-01,
	/*1285*/ 9.20729517936706542968750000000000e-01,
	/*1286*/ 9.20129716396331787109375000000000e-01,
	/*1287*/ 9.19527769088745117187500000000000e-01,
	/*1288*/ 9.18923616409301757812500000000000e-01,
	/*1289*/ 9.18317317962646484375000000000000e-01,
	/*1290*/ 9.17708873748779296875000000000000e-01,
	/*1291*/ 9.17098283767700195312500000000000e-01,
	/*1292*/ 9.16485548019409179687500000000000e-01,
	/*1293*/ 9.15870606899261474609375000000000e-01,
	/*1294*/ 9.15253520011901855468750000000000e-01,
	/*1295*/ 9.14634287357330322265625000000000e-01,
	/*1296*/ 9.14012908935546875000000000000000e-01,
	/*1297*/ 9.13389325141906738281250000000000e-01,
	/*1298*/ 9.12763655185699462890625000000000e-01,
	/*1299*/ 9.12135839462280273437500000000000e-01,
	/*1300*/ 9.11505818367004394531250000000000e-01,
	/*1301*/ 9.10873711109161376953125000000000e-01,
	/*1302*/ 9.10239398479461669921875000000000e-01,
	/*1303*/ 9.09602999687194824218750000000000e-01,
	/*1304*/ 9.08964455127716064453125000000000e-01,
	/*1305*/ 9.08323764801025390625000000000000e-01,
	/*1306*/ 9.07680869102478027343750000000000e-01,
	/*1307*/ 9.07035946846008300781250000000000e-01,
	/*1308*/ 9.06388819217681884765625000000000e-01,
	/*1309*/ 9.05739545822143554687500000000000e-01,
	/*1310*/ 9.05088186264038085937500000000000e-01,
	/*1311*/ 9.04434680938720703125000000000000e-01,
	/*1312*/ 9.03779029846191406250000000000000e-01,
	/*1313*/ 9.03121292591094970703125000000000e-01,
	/*1314*/ 9.02461349964141845703125000000000e-01,
	/*1315*/ 9.01799380779266357421875000000000e-01,
	/*1316*/ 9.01135206222534179687500000000000e-01,
	/*1317*/ 9.00468945503234863281250000000000e-01,
	/*1318*/ 8.99800539016723632812500000000000e-01,
	/*1319*/ 8.99130046367645263671875000000000e-01,
	/*1320*/ 8.98457467555999755859375000000000e-01,
	/*1321*/ 8.97782742977142333984375000000000e-01,
	/*1322*/ 8.97105872631072998046875000000000e-01,
	/*1323*/ 8.96426916122436523437500000000000e-01,
	/*1324*/ 8.95745873451232910156250000000000e-01,
	/*1325*/ 8.95062685012817382812500000000000e-01,
	/*1326*/ 8.94377410411834716796875000000000e-01,
	/*1327*/ 8.93689990043640136718750000000000e-01,
	/*1328*/ 8.93000483512878417968750000000000e-01,
	/*1329*/ 8.92308890819549560546875000000000e-01,
	/*1330*/ 8.91615211963653564453125000000000e-01,
	/*1331*/ 8.90919387340545654296875000000000e-01,
	/*1332*/ 8.90221536159515380859375000000000e-01,
	/*1333*/ 8.89521539211273193359375000000000e-01,
	/*1334*/ 8.88819456100463867187500000000000e-01,
	/*1335*/ 8.88115286827087402343750000000000e-01,
	/*1336*/ 8.87409031391143798828125000000000e-01,
	/*1337*/ 8.86700630187988281250000000000000e-01,
	/*1338*/ 8.85990202426910400390625000000000e-01,
	/*1339*/ 8.85277688503265380859375000000000e-01,
	/*1340*/ 8.84563088417053222656250000000000e-01,
	/*1341*/ 8.83846342563629150390625000000000e-01,
	/*1342*/ 8.83127570152282714843750000000000e-01,
	/*1343*/ 8.82406711578369140625000000000000e-01,
	/*1344*/ 8.81683826446533203125000000000000e-01,
	/*1345*/ 8.80958795547485351562500000000000e-01,
	/*1346*/ 8.80231678485870361328125000000000e-01,
	/*1347*/ 8.79502534866333007812500000000000e-01,
	/*1348*/ 8.78771305084228515625000000000000e-01,
	/*1349*/ 8.78038048744201660156250000000000e-01,
	/*1350*/ 8.77302646636962890625000000000000e-01,
	/*1351*/ 8.76565217971801757812500000000000e-01,
	/*1352*/ 8.75825762748718261718750000000000e-01,
	/*1353*/ 8.75084221363067626953125000000000e-01,
	/*1354*/ 8.74340593814849853515625000000000e-01,
	/*1355*/ 8.73594939708709716796875000000000e-01,
	/*1356*/ 8.72847199440002441406250000000000e-01,
	/*1357*/ 8.72097432613372802734375000000000e-01,
	/*1358*/ 8.71345579624176025390625000000000e-01,
	/*1359*/ 8.70591700077056884765625000000000e-01,
	/*1360*/ 8.69835734367370605468750000000000e-01,
	/*1361*/ 8.69077742099761962890625000000000e-01,
	/*1362*/ 8.68317723274230957031250000000000e-01,
	/*1363*/ 8.67555677890777587890625000000000e-01,
	/*1364*/ 8.66791546344757080078125000000000e-01,
	/*1365*/ 8.66025388240814208984375000000000e-01,
	/*1366*/ 8.65257203578948974609375000000000e-01,
	/*1367*/ 8.64486932754516601562500000000000e-01,
	/*1368*/ 8.63714694976806640625000000000000e-01,
	/*1369*/ 8.62940371036529541015625000000000e-01,
	/*1370*/ 8.62164020538330078125000000000000e-01,
	/*1371*/ 8.61385703086853027343750000000000e-01,
	/*1372*/ 8.60605299472808837890625000000000e-01,
	/*1373*/ 8.59822869300842285156250000000000e-01,
	/*1374*/ 8.59038412570953369140625000000000e-01,
	/*1375*/ 8.58251988887786865234375000000000e-01,
	/*1376*/ 8.57463479042053222656250000000000e-01,
	/*1377*/ 8.56672942638397216796875000000000e-01,
	/*1378*/ 8.55880439281463623046875000000000e-01,
	/*1379*/ 8.55085909366607666015625000000000e-01,
	/*1380*/ 8.54289352893829345703125000000000e-01,
	/*1381*/ 8.53490829467773437500000000000000e-01,
	/*1382*/ 8.52690219879150390625000000000000e-01,
	/*1383*/ 8.51887643337249755859375000000000e-01,
	/*1384*/ 8.51083099842071533203125000000000e-01,
	/*1385*/ 8.50276470184326171875000000000000e-01,
	/*1386*/ 8.49467933177947998046875000000000e-01,
	/*1387*/ 8.48657310009002685546875000000000e-01,
	/*1388*/ 8.47844719886779785156250000000000e-01,
	/*1389*/ 8.47030162811279296875000000000000e-01,
	/*1390*/ 8.46213579177856445312500000000000e-01,
	/*1391*/ 8.45395028591156005859375000000000e-01,
	/*1392*/ 8.44574451446533203125000000000000e-01,
	/*1393*/ 8.43751907348632812500000000000000e-01,
	/*1394*/ 8.42927396297454833984375000000000e-01,
	/*1395*/ 8.42100858688354492187500000000000e-01,
	/*1396*/ 8.41272354125976562500000000000000e-01,
	/*1397*/ 8.40441882610321044921875000000000e-01,
	/*1398*/ 8.39609444141387939453125000000000e-01,
	/*1399*/ 8.38774979114532470703125000000000e-01,
	/*1400*/ 8.37938547134399414062500000000000e-01,
	/*1401*/ 8.37100207805633544921875000000000e-01,
	/*1402*/ 8.36259841918945312500000000000000e-01,
	/*1403*/ 8.35417509078979492187500000000000e-01,
	/*1404*/ 8.34573209285736083984375000000000e-01,
	/*1405*/ 8.33726942539215087890625000000000e-01,
	/*1406*/ 8.32878768444061279296875000000000e-01,
	/*1407*/ 8.32028567790985107421875000000000e-01,
	/*1408*/ 8.31176459789276123046875000000000e-01,
	/*1409*/ 8.30322325229644775390625000000000e-01,
	/*1410*/ 8.29466283321380615234375000000000e-01,
	/*1411*/ 8.28608274459838867187500000000000e-01,
	/*1412*/ 8.27748358249664306640625000000000e-01,
	/*1413*/ 8.26886475086212158203125000000000e-01,
	/*1414*/ 8.26022624969482421875000000000000e-01,
	/*1415*/ 8.25156807899475097656250000000000e-01,
	/*1416*/ 8.24289083480834960937500000000000e-01,
	/*1417*/ 8.23419392108917236328125000000000e-01,
	/*1418*/ 8.22547793388366699218750000000000e-01,
	/*1419*/ 8.21674227714538574218750000000000e-01,
	/*1420*/ 8.20798754692077636718750000000000e-01,
	/*1421*/ 8.19921314716339111328125000000000e-01,
	/*1422*/ 8.19041967391967773437500000000000e-01,
	/*1423*/ 8.18160712718963623046875000000000e-01,
	/*1424*/ 8.17277491092681884765625000000000e-01,
	/*1425*/ 8.16392362117767333984375000000000e-01,
	/*1426*/ 8.15505325794219970703125000000000e-01,
	/*1427*/ 8.14616382122039794921875000000000e-01,
	/*1428*/ 8.13725471496582031250000000000000e-01,
	/*1429*/ 8.12832713127136230468750000000000e-01,
	/*1430*/ 8.11937987804412841796875000000000e-01,
	/*1431*/ 8.11041355133056640625000000000000e-01,
	/*1432*/ 8.10142815113067626953125000000000e-01,
	/*1433*/ 8.09242367744445800781250000000000e-01,
	/*1434*/ 8.08340013027191162109375000000000e-01,
	/*1435*/ 8.07435750961303710937500000000000e-01,
	/*1436*/ 8.06529641151428222656250000000000e-01,
	/*1437*/ 8.05621564388275146484375000000000e-01,
	/*1438*/ 8.04711639881134033203125000000000e-01,
	/*1439*/ 8.03799808025360107421875000000000e-01,
	/*1440*/ 8.02886068820953369140625000000000e-01,
	/*1441*/ 8.01970422267913818359375000000000e-01,
	/*1442*/ 8.01052927970886230468750000000000e-01,
	/*1443*/ 8.00133526325225830078125000000000e-01,
	/*1444*/ 7.99212217330932617187500000000000e-01,
	/*1445*/ 7.98289060592651367187500000000000e-01,
	/*1446*/ 7.97364056110382080078125000000000e-01,
	/*1447*/ 7.96437084674835205078125000000000e-01,
	/*1448*/ 7.95508325099945068359375000000000e-01,
	/*1449*/ 7.94577658176422119140625000000000e-01,
	/*1450*/ 7.93645083904266357421875000000000e-01,
	/*1451*/ 7.92710721492767333984375000000000e-01,
	/*1452*/ 7.91774451732635498046875000000000e-01,
	/*1453*/ 7.90836274623870849609375000000000e-01,
	/*1454*/ 7.89896309375762939453125000000000e-01,
	/*1455*/ 7.88954436779022216796875000000000e-01,
	/*1456*/ 7.88010716438293457031250000000000e-01,
	/*1457*/ 7.87065148353576660156250000000000e-01,
	/*1458*/ 7.86117732524871826171875000000000e-01,
	/*1459*/ 7.85168468952178955078125000000000e-01,
	/*1460*/ 7.84217298030853271484375000000000e-01,
	/*1461*/ 7.83264338970184326171875000000000e-01,
	/*1462*/ 7.82309532165527343750000000000000e-01,
	/*1463*/ 7.81352877616882324218750000000000e-01,
	/*1464*/ 7.80394375324249267578125000000000e-01,
	/*1465*/ 7.79434084892272949218750000000000e-01,
	/*1466*/ 7.78471887111663818359375000000000e-01,
	/*1467*/ 7.77507901191711425781250000000000e-01,
	/*1468*/ 7.76542067527770996093750000000000e-01,
	/*1469*/ 7.75574386119842529296875000000000e-01,
	/*1470*/ 7.74604916572570800781250000000000e-01,
	/*1471*/ 7.73633599281311035156250000000000e-01,
	/*1472*/ 7.72660493850708007812500000000000e-01,
	/*1473*/ 7.71685540676116943359375000000000e-01,
	/*1474*/ 7.70708799362182617187500000000000e-01,
	/*1475*/ 7.69730210304260253906250000000000e-01,
	/*1476*/ 7.68749833106994628906250000000000e-01,
	/*1477*/ 7.67767608165740966796875000000000e-01,
	/*1478*/ 7.66783595085144042968750000000000e-01,
	/*1479*/ 7.65797793865203857421875000000000e-01,
	/*1480*/ 7.64810144901275634765625000000000e-01,
	/*1481*/ 7.63820767402648925781250000000000e-01,
	/*1482*/ 7.62829542160034179687500000000000e-01,
	/*1483*/ 7.61836528778076171875000000000000e-01,
	/*1484*/ 7.60841727256774902343750000000000e-01,
	/*1485*/ 7.59845137596130371093750000000000e-01,
	/*1486*/ 7.58846759796142578125000000000000e-01,
	/*1487*/ 7.57846593856811523437500000000000e-01,
	/*1488*/ 7.56844639778137207031250000000000e-01,
	/*1489*/ 7.55840897560119628906250000000000e-01,
	/*1490*/ 7.54835367202758789062500000000000e-01,
	/*1491*/ 7.53828048706054687500000000000000e-01,
	/*1492*/ 7.52819001674652099609375000000000e-01,
	/*1493*/ 7.51808166503906250000000000000000e-01,
	/*1494*/ 7.50795543193817138671875000000000e-01,
	/*1495*/ 7.49781191349029541015625000000000e-01,
	/*1496*/ 7.48764991760253906250000000000000e-01,
	/*1497*/ 7.47747123241424560546875000000000e-01,
	/*1498*/ 7.46727466583251953125000000000000e-01,
	/*1499*/ 7.45706021785736083984375000000000e-01,
	/*1500*/ 7.44682848453521728515625000000000e-01,
	/*1501*/ 7.43657886981964111328125000000000e-01,
	/*1502*/ 7.42631196975708007812500000000000e-01,
	/*1503*/ 7.41602778434753417968750000000000e-01,
	/*1504*/ 7.40572631359100341796875000000000e-01,
	/*1505*/ 7.39540696144104003906250000000000e-01,
	/*1506*/ 7.38507032394409179687500000000000e-01,
	/*1507*/ 7.37471640110015869140625000000000e-01,
	/*1508*/ 7.36434519290924072265625000000000e-01,
	/*1509*/ 7.35395610332489013671875000000000e-01,
	/*1510*/ 7.34355032444000244140625000000000e-01,
	/*1511*/ 7.33312666416168212890625000000000e-01,
	/*1512*/ 7.32268631458282470703125000000000e-01,
	/*1513*/ 7.31222867965698242187500000000000e-01,
	/*1514*/ 7.30175316333770751953125000000000e-01,
	/*1515*/ 7.29126095771789550781250000000000e-01,
	/*1516*/ 7.28075206279754638671875000000000e-01,
	/*1517*/ 7.27022528648376464843750000000000e-01,
	/*1518*/ 7.25968182086944580078125000000000e-01,
	/*1519*/ 7.24912106990814208984375000000000e-01,
	/*1520*/ 7.23854303359985351562500000000000e-01,
	/*1521*/ 7.22794830799102783203125000000000e-01,
	/*1522*/ 7.21733629703521728515625000000000e-01,
	/*1523*/ 7.20670759677886962890625000000000e-01,
	/*1524*/ 7.19606161117553710937500000000000e-01,
	/*1525*/ 7.18539893627166748046875000000000e-01,
	/*1526*/ 7.17471897602081298828125000000000e-01,
	/*1527*/ 7.16402292251586914062500000000000e-01,
	/*1528*/ 7.15330898761749267578125000000000e-01,
	/*1529*/ 7.14257895946502685546875000000000e-01,
	/*1530*/ 7.13183164596557617187500000000000e-01,
	/*1531*/ 7.12106823921203613281250000000000e-01,
	/*1532*/ 7.11028754711151123046875000000000e-01,
	/*1533*/ 7.09949016571044921875000000000000e-01,
	/*1534*/ 7.08867609500885009765625000000000e-01,
	/*1535*/ 7.07784533500671386718750000000000e-01,
	/*1536*/ 7.06699788570404052734375000000000e-01,
	/*1537*/ 7.05613374710083007812500000000000e-01,
	/*1538*/ 7.04525291919708251953125000000000e-01,
	/*1539*/ 7.03435540199279785156250000000000e-01,
	/*1540*/ 7.02344179153442382812500000000000e-01,
	/*1541*/ 7.01251149177551269531250000000000e-01,
	/*1542*/ 7.00156450271606445312500000000000e-01,
	/*1543*/ 6.99060082435607910156250000000000e-01,
	/*1544*/ 6.97962105274200439453125000000000e-01,
	/*1545*/ 6.96862518787384033203125000000000e-01,
	/*1546*/ 6.95761203765869140625000000000000e-01,
	/*1547*/ 6.94658339023590087890625000000000e-01,
	/*1548*/ 6.93553805351257324218750000000000e-01,
	/*1549*/ 6.92447602748870849609375000000000e-01,
	/*1550*/ 6.91339790821075439453125000000000e-01,
	/*1551*/ 6.90230369567871093750000000000000e-01,
	/*1552*/ 6.89119338989257812500000000000000e-01,
	/*1553*/ 6.88006639480590820312500000000000e-01,
	/*1554*/ 6.86892330646514892578125000000000e-01,
	/*1555*/ 6.85776412487030029296875000000000e-01,
	/*1556*/ 6.84658885002136230468750000000000e-01,
	/*1557*/ 6.83539748191833496093750000000000e-01,
	/*1558*/ 6.82419002056121826171875000000000e-01,
	/*1559*/ 6.81296646595001220703125000000000e-01,
	/*1560*/ 6.80172681808471679687500000000000e-01,
	/*1561*/ 6.79047107696533203125000000000000e-01,
	/*1562*/ 6.77919983863830566406250000000000e-01,
	/*1563*/ 6.76791191101074218750000000000000e-01,
	/*1564*/ 6.75660848617553710937500000000000e-01,
	/*1565*/ 6.74528896808624267578125000000000e-01,
	/*1566*/ 6.73395395278930664062500000000000e-01,
	/*1567*/ 6.72260284423828125000000000000000e-01,
	/*1568*/ 6.71123564243316650390625000000000e-01,
	/*1569*/ 6.69985294342041015625000000000000e-01,
	/*1570*/ 6.68845474720001220703125000000000e-01,
	/*1571*/ 6.67704045772552490234375000000000e-01,
	/*1572*/ 6.66561007499694824218750000000000e-01,
	/*1573*/ 6.65416479110717773437500000000000e-01,
	/*1574*/ 6.64270341396331787109375000000000e-01,
	/*1575*/ 6.63122594356536865234375000000000e-01,
	/*1576*/ 6.61973357200622558593750000000000e-01,
	/*1577*/ 6.60822510719299316406250000000000e-01,
	/*1578*/ 6.59670174121856689453125000000000e-01,
	/*1579*/ 6.58516228199005126953125000000000e-01,
	/*1580*/ 6.57360732555389404296875000000000e-01,
	/*1581*/ 6.56203746795654296875000000000000e-01,
	/*1582*/ 6.55045151710510253906250000000000e-01,
	/*1583*/ 6.53885006904602050781250000000000e-01,
	/*1584*/ 6.52723371982574462890625000000000e-01,
	/*1585*/ 6.51560187339782714843750000000000e-01,
	/*1586*/ 6.50395452976226806640625000000000e-01,
	/*1587*/ 6.49229228496551513671875000000000e-01,
	/*1588*/ 6.48061454296112060546875000000000e-01,
	/*1589*/ 6.46892130374908447265625000000000e-01,
	/*1590*/ 6.45721316337585449218750000000000e-01,
	/*1591*/ 6.44548952579498291015625000000000e-01,
	/*1592*/ 6.43375039100646972656250000000000e-01,
	/*1593*/ 6.42199695110321044921875000000000e-01,
	/*1594*/ 6.41022801399230957031250000000000e-01,
	/*1595*/ 6.39844357967376708984375000000000e-01,
	/*1596*/ 6.38664484024047851562500000000000e-01,
	/*1597*/ 6.37483060359954833984375000000000e-01,
	/*1598*/ 6.36300146579742431640625000000000e-01,
	/*1599*/ 6.35115742683410644531250000000000e-01,
	/*1600*/ 6.33929789066314697265625000000000e-01,
	/*1601*/ 6.32742404937744140625000000000000e-01,
	/*1602*/ 6.31553530693054199218750000000000e-01,
	/*1603*/ 6.30363166332244873046875000000000e-01,
	/*1604*/ 6.29171252250671386718750000000000e-01,
	/*1605*/ 6.27977907657623291015625000000000e-01,
	/*1606*/ 6.26783132553100585937500000000000e-01,
	/*1607*/ 6.25586807727813720703125000000000e-01,
	/*1608*/ 6.24389052391052246093750000000000e-01,
	/*1609*/ 6.23189806938171386718750000000000e-01,
	/*1610*/ 6.21989071369171142578125000000000e-01,
	/*1611*/ 6.20786905288696289062500000000000e-01,
	/*1612*/ 6.19583308696746826171875000000000e-01,
	/*1613*/ 6.18378221988677978515625000000000e-01,
	/*1614*/ 6.17171645164489746093750000000000e-01,
	/*1615*/ 6.15963637828826904296875000000000e-01,
	/*1616*/ 6.14754199981689453125000000000000e-01,
	/*1617*/ 6.13543331623077392578125000000000e-01,
	/*1618*/ 6.12330973148345947265625000000000e-01,
	/*1619*/ 6.11117184162139892578125000000000e-01,
	/*1620*/ 6.09901964664459228515625000000000e-01,
	/*1621*/ 6.08685314655303955078125000000000e-01,
	/*1622*/ 6.07467234134674072265625000000000e-01,
	/*1623*/ 6.06247663497924804687500000000000e-01,
	/*1624*/ 6.05026721954345703125000000000000e-01,
	/*1625*/ 6.03804349899291992187500000000000e-01,
	/*1626*/ 6.02580547332763671875000000000000e-01,
	/*1627*/ 6.01355373859405517578125000000000e-01,
	/*1628*/ 6.00128710269927978515625000000000e-01,
	/*1629*/ 5.98900675773620605468750000000000e-01,
	/*1630*/ 5.97671210765838623046875000000000e-01,
	/*1631*/ 5.96440374851226806640625000000000e-01,
	/*1632*/ 5.95208108425140380859375000000000e-01,
	/*1633*/ 5.93974471092224121093750000000000e-01,
	/*1634*/ 5.92739403247833251953125000000000e-01,
	/*1635*/ 5.91502904891967773437500000000000e-01,
	/*1636*/ 5.90265095233917236328125000000000e-01,
	/*1637*/ 5.89025855064392089843750000000000e-01,
	/*1638*/ 5.87785184383392333984375000000000e-01,
	/*1639*/ 5.86543202400207519531250000000000e-01,
	/*1640*/ 5.85299789905548095703125000000000e-01,
	/*1641*/ 5.84055006504058837890625000000000e-01,
	/*1642*/ 5.82808911800384521484375000000000e-01,
	/*1643*/ 5.81561386585235595703125000000000e-01,
	/*1644*/ 5.80312490463256835937500000000000e-01,
	/*1645*/ 5.79062223434448242187500000000000e-01,
	/*1646*/ 5.77810585498809814453125000000000e-01,
	/*1647*/ 5.76557636260986328125000000000000e-01,
	/*1648*/ 5.75303316116333007812500000000000e-01,
	/*1649*/ 5.74047625064849853515625000000000e-01,
	/*1650*/ 5.72790563106536865234375000000000e-01,
	/*1651*/ 5.71532189846038818359375000000000e-01,
	/*1652*/ 5.70272445678710937500000000000000e-01,
	/*1653*/ 5.69011390209197998046875000000000e-01,
	/*1654*/ 5.67748963832855224609375000000000e-01,
	/*1655*/ 5.66485226154327392578125000000000e-01,
	/*1656*/ 5.65220117568969726562500000000000e-01,
	/*1657*/ 5.63953697681427001953125000000000e-01,
	/*1658*/ 5.62685966491699218750000000000000e-01,
	/*1659*/ 5.61416923999786376953125000000000e-01,
	/*1660*/ 5.60146510601043701171875000000000e-01,
	/*1661*/ 5.58874785900115966796875000000000e-01,
	/*1662*/ 5.57601749897003173828125000000000e-01,
	/*1663*/ 5.56327462196350097656250000000000e-01,
	/*1664*/ 5.55051803588867187500000000000000e-01,
	/*1665*/ 5.53774833679199218750000000000000e-01,
	/*1666*/ 5.52496552467346191406250000000000e-01,
	/*1667*/ 5.51217019557952880859375000000000e-01,
	/*1668*/ 5.49936175346374511718750000000000e-01,
	/*1669*/ 5.48654019832611083984375000000000e-01,
	/*1670*/ 5.47370553016662597656250000000000e-01,
	/*1671*/ 5.46085834503173828125000000000000e-01,
	/*1672*/ 5.44799804687500000000000000000000e-01,
	/*1673*/ 5.43512523174285888671875000000000e-01,
	/*1674*/ 5.42223930358886718750000000000000e-01,
	/*1675*/ 5.40934085845947265625000000000000e-01,
	/*1676*/ 5.39642989635467529296875000000000e-01,
	/*1677*/ 5.38350582122802734375000000000000e-01,
	/*1678*/ 5.37056922912597656250000000000000e-01,
	/*1679*/ 5.35761952400207519531250000000000e-01,
	/*1680*/ 5.34465789794921875000000000000000e-01,
	/*1681*/ 5.33168315887451171875000000000000e-01,
	/*1682*/ 5.31869590282440185546875000000000e-01,
	/*1683*/ 5.30569672584533691406250000000000e-01,
	/*1684*/ 5.29268443584442138671875000000000e-01,
	/*1685*/ 5.27966022491455078125000000000000e-01,
	/*1686*/ 5.26662290096282958984375000000000e-01,
	/*1687*/ 5.25357365608215332031250000000000e-01,
	/*1688*/ 5.24051189422607421875000000000000e-01,
	/*1689*/ 5.22743761539459228515625000000000e-01,
	/*1690*/ 5.21435141563415527343750000000000e-01,
	/*1691*/ 5.20125269889831542968750000000000e-01,
	/*1692*/ 5.18814206123352050781250000000000e-01,
	/*1693*/ 5.17501890659332275390625000000000e-01,
	/*1694*/ 5.16188383102416992187500000000000e-01,
	/*1695*/ 5.14873623847961425781250000000000e-01,
	/*1696*/ 5.13557672500610351562500000000000e-01,
	/*1697*/ 5.12240469455718994140625000000000e-01,
	/*1698*/ 5.10922133922576904296875000000000e-01,
	/*1699*/ 5.09602546691894531250000000000000e-01,
	/*1700*/ 5.08281767368316650390625000000000e-01,
	/*1701*/ 5.06959795951843261718750000000000e-01,
	/*1702*/ 5.05636632442474365234375000000000e-01,
	/*1703*/ 5.04312276840209960937500000000000e-01,
	/*1704*/ 5.02986729145050048828125000000000e-01,
	/*1705*/ 5.01659989356994628906250000000000e-01,
	/*1706*/ 5.00332117080688476562500000000000e-01,
	/*1707*/ 4.99003022909164428710937500000000e-01,
	/*1708*/ 4.97672766447067260742187500000000e-01,
	/*1709*/ 4.96341317892074584960937500000000e-01,
	/*1710*/ 4.95008736848831176757812500000000e-01,
	/*1711*/ 4.93674963712692260742187500000000e-01,
	/*1712*/ 4.92340028285980224609375000000000e-01,
	/*1713*/ 4.91003960371017456054687500000000e-01,
	/*1714*/ 4.89666700363159179687500000000000e-01,
	/*1715*/ 4.88328307867050170898437500000000e-01,
	/*1716*/ 4.86988753080368041992187500000000e-01,
	/*1717*/ 4.85648065805435180664062500000000e-01,
	/*1718*/ 4.84306246042251586914062500000000e-01,
	/*1719*/ 4.82963263988494873046875000000000e-01,
	/*1720*/ 4.81619149446487426757812500000000e-01,
	/*1721*/ 4.80273902416229248046875000000000e-01,
	/*1722*/ 4.78927522897720336914062500000000e-01,
	/*1723*/ 4.77580040693283081054687500000000e-01,
	/*1724*/ 4.76231396198272705078125000000000e-01,
	/*1725*/ 4.74881649017333984375000000000000e-01,
	/*1726*/ 4.73530769348144531250000000000000e-01,
	/*1727*/ 4.72178786993026733398437500000000e-01,
	/*1728*/ 4.70825701951980590820312500000000e-01,
	/*1729*/ 4.69471514225006103515625000000000e-01,
	/*1730*/ 4.68116194009780883789062500000000e-01,
	/*1731*/ 4.66759800910949707031250000000000e-01,
	/*1732*/ 4.65402275323867797851562500000000e-01,
	/*1733*/ 4.64043676853179931640625000000000e-01,
	/*1734*/ 4.62683975696563720703125000000000e-01,
	/*1735*/ 4.61323201656341552734375000000000e-01,
	/*1736*/ 4.59961324930191040039062500000000e-01,
	/*1737*/ 4.58598375320434570312500000000000e-01,
	/*1738*/ 4.57234323024749755859375000000000e-01,
	/*1739*/ 4.55869227647781372070312500000000e-01,
	/*1740*/ 4.54503029584884643554687500000000e-01,
	/*1741*/ 4.53135788440704345703125000000000e-01,
	/*1742*/ 4.51767474412918090820312500000000e-01,
	/*1743*/ 4.50398087501525878906250000000000e-01,
	/*1744*/ 4.49027627706527709960937500000000e-01,
	/*1745*/ 4.47656124830245971679687500000000e-01,
	/*1746*/ 4.46283578872680664062500000000000e-01,
	/*1747*/ 4.44909960031509399414062500000000e-01,
	/*1748*/ 4.43535298109054565429687500000000e-01,
	/*1749*/ 4.42159622907638549804687500000000e-01,
	/*1750*/ 4.40782874822616577148437500000000e-01,
	/*1751*/ 4.39405083656311035156250000000000e-01,
	/*1752*/ 4.38026279211044311523437500000000e-01,
	/*1753*/ 4.36646431684494018554687500000000e-01,
	/*1754*/ 4.35265570878982543945312500000000e-01,
	/*1755*/ 4.33883666992187500000000000000000e-01,
	/*1756*/ 4.32500749826431274414062500000000e-01,
	/*1757*/ 4.31116819381713867187500000000000e-01,
	/*1758*/ 4.29731875658035278320312500000000e-01,
	/*1759*/ 4.28345918655395507812500000000000e-01,
	/*1760*/ 4.26958948373794555664062500000000e-01,
	/*1761*/ 4.25570964813232421875000000000000e-01,
	/*1762*/ 4.24181997776031494140625000000000e-01,
	/*1763*/ 4.22792017459869384765625000000000e-01,
	/*1764*/ 4.21401053667068481445312500000000e-01,
	/*1765*/ 4.20009076595306396484375000000000e-01,
	/*1766*/ 4.18616145849227905273437500000000e-01,
	/*1767*/ 4.17222201824188232421875000000000e-01,
	/*1768*/ 4.15827274322509765625000000000000e-01,
	/*1769*/ 4.14431363344192504882812500000000e-01,
	/*1770*/ 4.13034498691558837890625000000000e-01,
	/*1771*/ 4.11636650562286376953125000000000e-01,
	/*1772*/ 4.10237848758697509765625000000000e-01,
	/*1773*/ 4.08838063478469848632812500000000e-01,
	/*1774*/ 4.07437324523925781250000000000000e-01,
	/*1775*/ 4.06035602092742919921875000000000e-01,
	/*1776*/ 4.04632955789566040039062500000000e-01,
	/*1777*/ 4.03229326009750366210937500000000e-01,
	/*1778*/ 4.01824772357940673828125000000000e-01,
	/*1779*/ 4.00419265031814575195312500000000e-01,
	/*1780*/ 3.99012833833694458007812500000000e-01,
	/*1781*/ 3.97605419158935546875000000000000e-01,
	/*1782*/ 3.96197110414505004882812500000000e-01,
	/*1783*/ 3.94787847995758056640625000000000e-01,
	/*1784*/ 3.93377661705017089843750000000000e-01,
	/*1785*/ 3.91966551542282104492187500000000e-01,
	/*1786*/ 3.90554517507553100585937500000000e-01,
	/*1787*/ 3.89141559600830078125000000000000e-01,
	/*1788*/ 3.87727677822113037109375000000000e-01,
	/*1789*/ 3.86312901973724365234375000000000e-01,
	/*1790*/ 3.84897202253341674804687500000000e-01,
	/*1791*/ 3.83480608463287353515625000000000e-01,
	/*1792*/ 3.82063090801239013671875000000000e-01,
	/*1793*/ 3.80644708871841430664062500000000e-01,
	/*1794*/ 3.79225403070449829101562500000000e-01,
	/*1795*/ 3.77805203199386596679687500000000e-01,
	/*1796*/ 3.76384139060974121093750000000000e-01,
	/*1797*/ 3.74962151050567626953125000000000e-01,
	/*1798*/ 3.73539298772811889648437500000000e-01,
	/*1799*/ 3.72115582227706909179687500000000e-01,
	/*1800*/ 3.70690971612930297851562500000000e-01,
	/*1801*/ 3.69265496730804443359375000000000e-01,
	/*1802*/ 3.67839157581329345703125000000000e-01,
	/*1803*/ 3.66411924362182617187500000000000e-01,
	/*1804*/ 3.64983856678009033203125000000000e-01,
	/*1805*/ 3.63554924726486206054687500000000e-01,
	/*1806*/ 3.62125128507614135742187500000000e-01,
	/*1807*/ 3.60694497823715209960937500000000e-01,
	/*1808*/ 3.59263002872467041015625000000000e-01,
	/*1809*/ 3.57830643653869628906250000000000e-01,
	/*1810*/ 3.56397479772567749023437500000000e-01,
	/*1811*/ 3.54963451623916625976562500000000e-01,
	/*1812*/ 3.53528589010238647460937500000000e-01,
	/*1813*/ 3.52092921733856201171875000000000e-01,
	/*1814*/ 3.50656390190124511718750000000000e-01,
	/*1815*/ 3.49219053983688354492187500000000e-01,
	/*1816*/ 3.47780883312225341796875000000000e-01,
	/*1817*/ 3.46341907978057861328125000000000e-01,
	/*1818*/ 3.44902098178863525390625000000000e-01,
	/*1819*/ 3.43461483716964721679687500000000e-01,
	/*1820*/ 3.42020064592361450195312500000000e-01,
	/*1821*/ 3.40577840805053710937500000000000e-01,
	/*1822*/ 3.39134812355041503906250000000000e-01,
	/*1823*/ 3.37691009044647216796875000000000e-01,
	/*1824*/ 3.36246371269226074218750000000000e-01,
	/*1825*/ 3.34800958633422851562500000000000e-01,
	/*1826*/ 3.33354771137237548828125000000000e-01,
	/*1827*/ 3.31907778978347778320312500000000e-01,
	/*1828*/ 3.30460011959075927734375000000000e-01,
	/*1829*/ 3.29011470079421997070312500000000e-01,
	/*1830*/ 3.27562153339385986328125000000000e-01,
	/*1831*/ 3.26112061738967895507812500000000e-01,
	/*1832*/ 3.24661225080490112304687500000000e-01,
	/*1833*/ 3.23209583759307861328125000000000e-01,
	/*1834*/ 3.21757197380065917968750000000000e-01,
	/*1835*/ 3.20304065942764282226562500000000e-01,
	/*1836*/ 3.18850159645080566406250000000000e-01,
	/*1837*/ 3.17395538091659545898437500000000e-01,
	/*1838*/ 3.15940141677856445312500000000000e-01,
	/*1839*/ 3.14484000205993652343750000000000e-01,
	/*1840*/ 3.13027113676071166992187500000000e-01,
	/*1841*/ 3.11569511890411376953125000000000e-01,
	/*1842*/ 3.10111165046691894531250000000000e-01,
	/*1843*/ 3.08652102947235107421875000000000e-01,
	/*1844*/ 3.07192295789718627929687500000000e-01,
	/*1845*/ 3.05731773376464843750000000000000e-01,
	/*1846*/ 3.04270505905151367187500000000000e-01,
	/*1847*/ 3.02808552980422973632812500000000e-01,
	/*1848*/ 3.01345884799957275390625000000000e-01,
	/*1849*/ 2.99882501363754272460937500000000e-01,
	/*1850*/ 2.98418402671813964843750000000000e-01,
	/*1851*/ 2.96953618526458740234375000000000e-01,
	/*1852*/ 2.95488119125366210937500000000000e-01,
	/*1853*/ 2.94021934270858764648437500000000e-01,
	/*1854*/ 2.92555034160614013671875000000000e-01,
	/*1855*/ 2.91087478399276733398437500000000e-01,
	/*1856*/ 2.89619207382202148437500000000000e-01,
	/*1857*/ 2.88150280714035034179687500000000e-01,
	/*1858*/ 2.86680668592453002929687500000000e-01,
	/*1859*/ 2.85210371017456054687500000000000e-01,
	/*1860*/ 2.83739417791366577148437500000000e-01,
	/*1861*/ 2.82267779111862182617187500000000e-01,
	/*1862*/ 2.80795484781265258789062500000000e-01,
	/*1863*/ 2.79322534799575805664062500000000e-01,
	/*1864*/ 2.77848929166793823242187500000000e-01,
	/*1865*/ 2.76374667882919311523437500000000e-01,
	/*1866*/ 2.74899750947952270507812500000000e-01,
	/*1867*/ 2.73424178361892700195312500000000e-01,
	/*1868*/ 2.71947979927062988281250000000000e-01,
	/*1869*/ 2.70471125841140747070312500000000e-01,
	/*1870*/ 2.68993645906448364257812500000000e-01,
	/*1871*/ 2.67515510320663452148437500000000e-01,
	/*1872*/ 2.66036778688430786132812500000000e-01,
	/*1873*/ 2.64557391405105590820312500000000e-01,
	/*1874*/ 2.63077408075332641601562500000000e-01,
	/*1875*/ 2.61596798896789550781250000000000e-01,
	/*1876*/ 2.60115563869476318359375000000000e-01,
	/*1877*/ 2.58633702993392944335937500000000e-01,
	/*1878*/ 2.57151246070861816406250000000000e-01,
	/*1879*/ 2.55668193101882934570312500000000e-01,
	/*1880*/ 2.54184544086456298828125000000000e-01,
	/*1881*/ 2.52700269222259521484375000000000e-01,
	/*1882*/ 2.51215428113937377929687500000000e-01,
	/*1883*/ 2.49729976058006286621093750000000e-01,
	/*1884*/ 2.48243942856788635253906250000000e-01,
	/*1885*/ 2.46757328510284423828125000000000e-01,
	/*1886*/ 2.45270133018493652343750000000000e-01,
	/*1887*/ 2.43782356381416320800781250000000e-01,
	/*1888*/ 2.42293998599052429199218750000000e-01,
	/*1889*/ 2.40805074572563171386718750000000e-01,
	/*1890*/ 2.39315599203109741210937500000000e-01,
	/*1891*/ 2.37825542688369750976562500000000e-01,
	/*1892*/ 2.36334934830665588378906250000000e-01,
	/*1893*/ 2.34843760728836059570312500000000e-01,
	/*1894*/ 2.33352050185203552246093750000000e-01,
	/*1895*/ 2.31859773397445678710937500000000e-01,
	/*1896*/ 2.30366960167884826660156250000000e-01,
	/*1897*/ 2.28873595595359802246093750000000e-01,
	/*1898*/ 2.27379709482192993164062500000000e-01,
	/*1899*/ 2.25885272026062011718750000000000e-01,
	/*1900*/ 2.24390313029289245605468750000000e-01,
	/*1901*/ 2.22894817590713500976562500000000e-01,
	/*1902*/ 2.21398800611495971679687500000000e-01,
	/*1903*/ 2.19902262091636657714843750000000e-01,
	/*1904*/ 2.18405202031135559082031250000000e-01,
	/*1905*/ 2.16907635331153869628906250000000e-01,
	/*1906*/ 2.15409561991691589355468750000000e-01,
	/*1907*/ 2.13910967111587524414062500000000e-01,
	/*1908*/ 2.12411880493164062500000000000000e-01,
	/*1909*/ 2.10912287235260009765625000000000e-01,
	/*1910*/ 2.09412202239036560058593750000000e-01,
	/*1911*/ 2.07911625504493713378906250000000e-01,
	/*1912*/ 2.06410542130470275878906250000000e-01,
	/*1913*/ 2.04908996820449829101562500000000e-01,
	/*1914*/ 2.03406959772109985351562500000000e-01,
	/*1915*/ 2.01904430985450744628906250000000e-01,
	/*1916*/ 2.00401440262794494628906250000000e-01,
	/*1917*/ 1.98897972702980041503906250000000e-01,
	/*1918*/ 1.97394043207168579101562500000000e-01,
	/*1919*/ 1.95889651775360107421875000000000e-01,
	/*1920*/ 1.94384783506393432617187500000000e-01,
	/*1921*/ 1.92879468202590942382812500000000e-01,
	/*1922*/ 1.91373705863952636718750000000000e-01,
	/*1923*/ 1.89867481589317321777343750000000e-01,
	/*1924*/ 1.88360810279846191406250000000000e-01,
	/*1925*/ 1.86853706836700439453125000000000e-01,
	/*1926*/ 1.85346156358718872070312500000000e-01,
	/*1927*/ 1.83838158845901489257812500000000e-01,
	/*1928*/ 1.82329744100570678710937500000000e-01,
	/*1929*/ 1.80820897221565246582031250000000e-01,
	/*1930*/ 1.79311618208885192871093750000000e-01,
	/*1931*/ 1.77801921963691711425781250000000e-01,
	/*1932*/ 1.76291808485984802246093750000000e-01,
	/*1933*/ 1.74781277775764465332031250000000e-01,
	/*1934*/ 1.73270329833030700683593750000000e-01,
	/*1935*/ 1.71758979558944702148437500000000e-01,
	/*1936*/ 1.70247226953506469726562500000000e-01,
	/*1937*/ 1.68735072016716003417968750000000e-01,
	/*1938*/ 1.67222514748573303222656250000000e-01,
	/*1939*/ 1.65709570050239562988281250000000e-01,
	/*1940*/ 1.64196237921714782714843750000000e-01,
	/*1941*/ 1.62682503461837768554687500000000e-01,
	/*1942*/ 1.61168396472930908203125000000000e-01,
	/*1943*/ 1.59653916954994201660156250000000e-01,
	/*1944*/ 1.58139050006866455078125000000000e-01,
	/*1945*/ 1.56623825430870056152343750000000e-01,
	/*1946*/ 1.55108213424682617187500000000000e-01,
	/*1947*/ 1.53592243790626525878906250000000e-01,
	/*1948*/ 1.52075916528701782226562500000000e-01,
	/*1949*/ 1.50559231638908386230468750000000e-01,
	/*1950*/ 1.49042189121246337890625000000000e-01,
	/*1951*/ 1.47524803876876831054687500000000e-01,
	/*1952*/ 1.46007061004638671875000000000000e-01,
	/*1953*/ 1.44488975405693054199218750000000e-01,
	/*1954*/ 1.42970547080039978027343750000000e-01,
	/*1955*/ 1.41451790928840637207031250000000e-01,
	/*1956*/ 1.39932692050933837890625000000000e-01,
	/*1957*/ 1.38413280248641967773437500000000e-01,
	/*1958*/ 1.36893525719642639160156250000000e-01,
	/*1959*/ 1.35373458266258239746093750000000e-01,
	/*1960*/ 1.33853062987327575683593750000000e-01,
	/*1961*/ 1.32332354784011840820312500000000e-01,
	/*1962*/ 1.30811348557472229003906250000000e-01,
	/*1963*/ 1.29290014505386352539062500000000e-01,
	/*1964*/ 1.27768382430076599121093750000000e-01,
	/*1965*/ 1.26246452331542968750000000000000e-01,
	/*1966*/ 1.24724231660366058349609375000000e-01,
	/*1967*/ 1.23201712965965270996093750000000e-01,
	/*1968*/ 1.21678903698921203613281250000000e-01,
	/*1969*/ 1.20155803859233856201171875000000e-01,
	/*1970*/ 1.18632420897483825683593750000000e-01,
	/*1971*/ 1.17108762264251708984375000000000e-01,
	/*1972*/ 1.15584827959537506103515625000000e-01,
	/*1973*/ 1.14060625433921813964843750000000e-01,
	/*1974*/ 1.12536147236824035644531250000000e-01,
	/*1975*/ 1.11011408269405364990234375000000e-01,
	/*1976*/ 1.09486408531665802001953125000000e-01,
	/*1977*/ 1.07961148023605346679687500000000e-01,
	/*1978*/ 1.06435634195804595947265625000000e-01,
	/*1979*/ 1.04909867048263549804687500000000e-01,
	/*1980*/ 1.03383854031562805175781250000000e-01,
	/*1981*/ 1.01857602596282958984375000000000e-01,
	/*1982*/ 1.00331105291843414306640625000000e-01,
	/*1983*/ 9.88043770194053649902343750000000e-02,
	/*1984*/ 9.72774103283882141113281250000000e-02,
	/*1985*/ 9.57502201199531555175781250000000e-02,
	/*1986*/ 9.42227989435195922851562500000000e-02,
	/*1987*/ 9.26951617002487182617187500000000e-02,
	/*1988*/ 9.11673083901405334472656250000000e-02,
	/*1989*/ 8.96392315626144409179687500000000e-02,
	/*1990*/ 8.81109461188316345214843750000000e-02,
	/*1991*/ 8.65824595093727111816406250000000e-02,
	/*1992*/ 8.50537642836570739746093750000000e-02,
	/*1993*/ 8.35248678922653198242187500000000e-02,
	/*1994*/ 8.19957777857780456542968750000000e-02,
	/*1995*/ 8.04664939641952514648437500000000e-02,
	/*1996*/ 7.89370164275169372558593750000000e-02,
	/*1997*/ 7.74073600769042968750000000000000e-02,
	/*1998*/ 7.58775174617767333984375000000000e-02,
	/*1999*/ 7.43474960327148437500000000000000e-02,
	/*2000*/ 7.28172957897186279296875000000000e-02,
	/*2001*/ 7.12869316339492797851562500000000e-02,
	/*2002*/ 6.97563961148262023925781250000000e-02,
	/*2003*/ 6.82256966829299926757812500000000e-02,
	/*2004*/ 6.66948407888412475585937500000000e-02,
	/*2005*/ 6.51638209819793701171875000000000e-02,
	/*2006*/ 6.36326521635055541992187500000000e-02,
	/*2007*/ 6.21013306081295013427734375000000e-02,
	/*2008*/ 6.05698637664318084716796875000000e-02,
	/*2009*/ 5.90382553637027740478515625000000e-02,
	/*2010*/ 5.75065053999423980712890625000000e-02,
	/*2011*/ 5.59746213257312774658203125000000e-02,
	/*2012*/ 5.44426068663597106933593750000000e-02,
	/*2013*/ 5.29104657471179962158203125000000e-02,
	/*2014*/ 5.13781979680061340332031250000000e-02,
	/*2015*/ 4.98458072543144226074218750000000e-02,
	/*2016*/ 4.83133010566234588623046875000000e-02,
	/*2017*/ 4.67806831002235412597656250000000e-02,
	/*2018*/ 4.52479533851146697998046875000000e-02,
	/*2019*/ 4.37151156365871429443359375000000e-02,
	/*2020*/ 4.21821773052215576171875000000000e-02,
	/*2021*/ 4.06491383910179138183593750000000e-02,
	/*2022*/ 3.91160026192665100097656250000000e-02,
	/*2023*/ 3.75827774405479431152343750000000e-02,
	/*2024*/ 3.60494591295719146728515625000000e-02,
	/*2025*/ 3.45160625874996185302734375000000e-02,
	/*2026*/ 3.29825803637504577636718750000000e-02,
	/*2027*/ 3.14490199089050292968750000000000e-02,
	/*2028*/ 2.99153886735439300537109375000000e-02,
	/*2029*/ 2.83816847950220108032226562500000e-02,
	/*2030*/ 2.68479138612747192382812500000000e-02,
	/*2031*/ 2.53140814602375030517578125000000e-02,
	/*2032*/ 2.37801875919103622436523437500000e-02,
	/*2033*/ 2.22462397068738937377929687500000e-02,
	/*2034*/ 2.07122378051280975341796875000000e-02,
	/*2035*/ 1.91781874746084213256835937500000e-02,
	/*2036*/ 1.76440924406051635742187500000000e-02,
	/*2037*/ 1.61099564284086227416992187500000e-02,
	/*2038*/ 1.45757813006639480590820312500000e-02,
	/*2039*/ 1.30415726453065872192382812500000e-02,
	/*2040*/ 1.15073323249816894531250000000000e-02,
	/*2041*/ 9.97306592762470245361328125000000e-03,
	/*2042*/ 8.43877531588077545166015625000000e-03,
	/*2043*/ 6.90446561202406883239746093750000e-03,
	/*2044*/ 5.37013914436101913452148437500000e-03,
	/*2045*/ 3.83580010384321212768554687500000e-03,
	/*2046*/ 2.30145221576094627380371093750000e-03,
	/*2047*/ 7.67098623327910900115966796875000e-04,
	/*2048*/ -7.67256657127290964126586914062500e-04,
	/*2049*/ -2.30161007493734359741210937500000e-03,
	/*2050*/ -3.83595819585025310516357421875000e-03,
	/*2051*/ -5.37029700353741645812988281250000e-03,
	/*2052*/ -6.90462347120046615600585937500000e-03,
	/*2053*/ -8.43893364071846008300781250000000e-03,
	/*2054*/ -9.97322425246238708496093750000000e-03,
	/*2055*/ -1.15074906498193740844726562500000e-02,
	/*2056*/ -1.30417300388216972351074218750000e-02,
	/*2057*/ -1.45759396255016326904296875000000e-02,
	/*2058*/ -1.61101147532463073730468750000000e-02,
	/*2059*/ -1.76442507654428482055664062500000e-02,
	/*2060*/ -1.91783457994461059570312500000000e-02,
	/*2061*/ -2.07123961299657821655273437500000e-02,
	/*2062*/ -2.22463980317115783691406250000000e-02,
	/*2063*/ -2.37803459167480468750000000000000e-02,
	/*2064*/ -2.53142397850751876831054687500000e-02,
	/*2065*/ -2.68480721861124038696289062500000e-02,
	/*2066*/ -2.83818431198596954345703125000000e-02,
	/*2067*/ -2.99155451357364654541015625000000e-02,
	/*2068*/ -3.14491800963878631591796875000000e-02,
	/*2069*/ -3.29827368259429931640625000000000e-02,
	/*2070*/ -3.45162190496921539306640625000000e-02,
	/*2071*/ -3.60496193170547485351562500000000e-02,
	/*2072*/ -3.75829339027404785156250000000000e-02,
	/*2073*/ -3.91161590814590454101562500000000e-02,
	/*2074*/ -4.06492948532104492187500000000000e-02,
	/*2075*/ -4.21823337674140930175781250000000e-02,
	/*2076*/ -4.37152720987796783447265625000000e-02,
	/*2077*/ -4.52481098473072052001953125000000e-02,
	/*2078*/ -4.67808395624160766601562500000000e-02,
	/*2079*/ -4.83134612441062927246093750000000e-02,
	/*2080*/ -4.98459674417972564697265625000000e-02,
	/*2081*/ -5.13783544301986694335937500000000e-02,
	/*2082*/ -5.29106222093105316162109375000000e-02,
	/*2083*/ -5.44427670538425445556640625000000e-02,
	/*2084*/ -5.59747815132141113281250000000000e-02,
	/*2085*/ -5.75066655874252319335937500000000e-02,
	/*2086*/ -5.90384118258953094482421875000000e-02,
	/*2087*/ -6.05700202286243438720703125000000e-02,
	/*2088*/ -6.21014870703220367431640625000000e-02,
	/*2089*/ -6.36328086256980895996093750000000e-02,
	/*2090*/ -6.51639774441719055175781250000000e-02,
	/*2091*/ -6.66949972510337829589843750000000e-02,
	/*2092*/ -6.82258531451225280761718750000000e-02,
	/*2093*/ -6.97565525770187377929687500000000e-02,
	/*2094*/ -7.12870880961418151855468750000000e-02,
	/*2095*/ -7.28174597024917602539062500000000e-02,
	/*2096*/ -7.43476524949073791503906250000000e-02,
	/*2097*/ -7.58776739239692687988281250000000e-02,
	/*2098*/ -7.74075165390968322753906250000000e-02,
	/*2099*/ -7.89371728897094726562500000000000e-02,
	/*2100*/ -8.04666504263877868652343750000000e-02,
	/*2101*/ -8.19959342479705810546875000000000e-02,
	/*2102*/ -8.35250243544578552246093750000000e-02,
	/*2103*/ -8.50539207458496093750000000000000e-02,
	/*2104*/ -8.65826159715652465820312500000000e-02,
	/*2105*/ -8.81111100316047668457031250000000e-02,
	/*2106*/ -8.96393880248069763183593750000000e-02,
	/*2107*/ -9.11674648523330688476562500000000e-02,
	/*2108*/ -9.26953181624412536621093750000000e-02,
	/*2109*/ -9.42229628562927246093750000000000e-02,
	/*2110*/ -9.57503765821456909179687500000000e-02,
	/*2111*/ -9.72775667905807495117187500000000e-02,
	/*2112*/ -9.88045334815979003906250000000000e-02,
	/*2113*/ -1.00331261754035949707031250000000e-01,
	/*2114*/ -1.01857759058475494384765625000000e-01,
	/*2115*/ -1.03384010493755340576171875000000e-01,
	/*2116*/ -1.04910023510456085205078125000000e-01,
	/*2117*/ -1.06435790657997131347656250000000e-01,
	/*2118*/ -1.07961304485797882080078125000000e-01,
	/*2119*/ -1.09486564993858337402343750000000e-01,
	/*2120*/ -1.11011564731597900390625000000000e-01,
	/*2121*/ -1.12536303699016571044921875000000e-01,
	/*2122*/ -1.14060781896114349365234375000000e-01,
	/*2123*/ -1.15584984421730041503906250000000e-01,
	/*2124*/ -1.17108918726444244384765625000000e-01,
	/*2125*/ -1.18632577359676361083984375000000e-01,
	/*2126*/ -1.20155960321426391601562500000000e-01,
	/*2127*/ -1.21679060161113739013671875000000e-01,
	/*2128*/ -1.23201869428157806396484375000000e-01,
	/*2129*/ -1.24724388122558593750000000000000e-01,
	/*2130*/ -1.26246616244316101074218750000000e-01,
	/*2131*/ -1.27768546342849731445312500000000e-01,
	/*2132*/ -1.29290178418159484863281250000000e-01,
	/*2133*/ -1.30811497569084167480468750000000e-01,
	/*2134*/ -1.32332518696784973144531250000000e-01,
	/*2135*/ -1.33853226900100708007812500000000e-01,
	/*2136*/ -1.35373607277870178222656250000000e-01,
	/*2137*/ -1.36893674731254577636718750000000e-01,
	/*2138*/ -1.38413429260253906250000000000000e-01,
	/*2139*/ -1.39932855963706970214843750000000e-01,
	/*2140*/ -1.41451939940452575683593750000000e-01,
	/*2141*/ -1.42970710992813110351562500000000e-01,
	/*2142*/ -1.44489124417304992675781250000000e-01,
	/*2143*/ -1.46007210016250610351562500000000e-01,
	/*2144*/ -1.47524952888488769531250000000000e-01,
	/*2145*/ -1.49042353034019470214843750000000e-01,
	/*2146*/ -1.50559395551681518554687500000000e-01,
	/*2147*/ -1.52076080441474914550781250000000e-01,
	/*2148*/ -1.53592407703399658203125000000000e-01,
	/*2149*/ -1.55108377337455749511718750000000e-01,
	/*2150*/ -1.56623974442481994628906250000000e-01,
	/*2151*/ -1.58139213919639587402343750000000e-01,
	/*2152*/ -1.59654065966606140136718750000000e-01,
	/*2153*/ -1.61168560385704040527343750000000e-01,
	/*2154*/ -1.62682667374610900878906250000000e-01,
	/*2155*/ -1.64196386933326721191406250000000e-01,
	/*2156*/ -1.65709719061851501464843750000000e-01,
	/*2157*/ -1.67222678661346435546875000000000e-01,
	/*2158*/ -1.68735221028327941894531250000000e-01,
	/*2159*/ -1.70247375965118408203125000000000e-01,
	/*2160*/ -1.71759128570556640625000000000000e-01,
	/*2161*/ -1.73270478844642639160156250000000e-01,
	/*2162*/ -1.74781426787376403808593750000000e-01,
	/*2163*/ -1.76291957497596740722656250000000e-01,
	/*2164*/ -1.77802070975303649902343750000000e-01,
	/*2165*/ -1.79311767220497131347656250000000e-01,
	/*2166*/ -1.80821046233177185058593750000000e-01,
	/*2167*/ -1.82329893112182617187500000000000e-01,
	/*2168*/ -1.83838322758674621582031250000000e-01,
	/*2169*/ -1.85346305370330810546875000000000e-01,
	/*2170*/ -1.86853855848312377929687500000000e-01,
	/*2171*/ -1.88360974192619323730468750000000e-01,
	/*2172*/ -1.89867630600929260253906250000000e-01,
	/*2173*/ -1.91373854875564575195312500000000e-01,
	/*2174*/ -1.92879632115364074707031250000000e-01,
	/*2175*/ -1.94384947419166564941406250000000e-01,
	/*2176*/ -1.95889800786972045898437500000000e-01,
	/*2177*/ -1.97394207119941711425781250000000e-01,
	/*2178*/ -1.98898136615753173828125000000000e-01,
	/*2179*/ -2.00401604175567626953125000000000e-01,
	/*2180*/ -2.01904594898223876953125000000000e-01,
	/*2181*/ -2.03407108783721923828125000000000e-01,
	/*2182*/ -2.04909145832061767578125000000000e-01,
	/*2183*/ -2.06410706043243408203125000000000e-01,
	/*2184*/ -2.07911774516105651855468750000000e-01,
	/*2185*/ -2.09412351250648498535156250000000e-01,
	/*2186*/ -2.10912436246871948242187500000000e-01,
	/*2187*/ -2.12412029504776000976562500000000e-01,
	/*2188*/ -2.13911131024360656738281250000000e-01,
	/*2189*/ -2.15409711003303527832031250000000e-01,
	/*2190*/ -2.16907799243927001953125000000000e-01,
	/*2191*/ -2.18405365943908691406250000000000e-01,
	/*2192*/ -2.19902411103248596191406250000000e-01,
	/*2193*/ -2.21398949623107910156250000000000e-01,
	/*2194*/ -2.22894966602325439453125000000000e-01,
	/*2195*/ -2.24390462040901184082031250000000e-01,
	/*2196*/ -2.25885421037673950195312500000000e-01,
	/*2197*/ -2.27379858493804931640625000000000e-01,
	/*2198*/ -2.28873759508132934570312500000000e-01,
	/*2199*/ -2.30367109179496765136718750000000e-01,
	/*2200*/ -2.31859922409057617187500000000000e-01,
	/*2201*/ -2.33352199196815490722656250000000e-01,
	/*2202*/ -2.34843924641609191894531250000000e-01,
	/*2203*/ -2.36335083842277526855468750000000e-01,
	/*2204*/ -2.37825691699981689453125000000000e-01,
	/*2205*/ -2.39315748214721679687500000000000e-01,
	/*2206*/ -2.40805238485336303710937500000000e-01,
	/*2207*/ -2.42294147610664367675781250000000e-01,
	/*2208*/ -2.43782505393028259277343750000000e-01,
	/*2209*/ -2.45270282030105590820312500000000e-01,
	/*2210*/ -2.46757477521896362304687500000000e-01,
	/*2211*/ -2.48244091868400573730468750000000e-01,
	/*2212*/ -2.49730125069618225097656250000000e-01,
	/*2213*/ -2.51215577125549316406250000000000e-01,
	/*2214*/ -2.52700418233871459960937500000000e-01,
	/*2215*/ -2.54184693098068237304687500000000e-01,
	/*2216*/ -2.55668342113494873046875000000000e-01,
	/*2217*/ -2.57151424884796142578125000000000e-01,
	/*2218*/ -2.58633852005004882812500000000000e-01,
	/*2219*/ -2.60115712881088256835937500000000e-01,
	/*2220*/ -2.61596947908401489257812500000000e-01,
	/*2221*/ -2.63077557086944580078125000000000e-01,
	/*2222*/ -2.64557540416717529296875000000000e-01,
	/*2223*/ -2.66036927700042724609375000000000e-01,
	/*2224*/ -2.67515689134597778320312500000000e-01,
	/*2225*/ -2.68993794918060302734375000000000e-01,
	/*2226*/ -2.70471274852752685546875000000000e-01,
	/*2227*/ -2.71948128938674926757812500000000e-01,
	/*2228*/ -2.73424327373504638671875000000000e-01,
	/*2229*/ -2.74899899959564208984375000000000e-01,
	/*2230*/ -2.76374816894531250000000000000000e-01,
	/*2231*/ -2.77849078178405761718750000000000e-01,
	/*2232*/ -2.79322683811187744140625000000000e-01,
	/*2233*/ -2.80795663595199584960937500000000e-01,
	/*2234*/ -2.82267928123474121093750000000000e-01,
	/*2235*/ -2.83739566802978515625000000000000e-01,
	/*2236*/ -2.85210520029067993164062500000000e-01,
	/*2237*/ -2.86680817604064941406250000000000e-01,
	/*2238*/ -2.88150429725646972656250000000000e-01,
	/*2239*/ -2.89619386196136474609375000000000e-01,
	/*2240*/ -2.91087627410888671875000000000000e-01,
	/*2241*/ -2.92555183172225952148437500000000e-01,
	/*2242*/ -2.94022083282470703125000000000000e-01,
	/*2243*/ -2.95488268136978149414062500000000e-01,
	/*2244*/ -2.96953767538070678710937500000000e-01,
	/*2245*/ -2.98418551683425903320312500000000e-01,
	/*2246*/ -2.99882650375366210937500000000000e-01,
	/*2247*/ -3.01346033811569213867187500000000e-01,
	/*2248*/ -3.02808701992034912109375000000000e-01,
	/*2249*/ -3.04270654916763305664062500000000e-01,
	/*2250*/ -3.05731922388076782226562500000000e-01,
	/*2251*/ -3.07192444801330566406250000000000e-01,
	/*2252*/ -3.08652251958847045898437500000000e-01,
	/*2253*/ -3.10111314058303833007812500000000e-01,
	/*2254*/ -3.11569660902023315429687500000000e-01,
	/*2255*/ -3.13027262687683105468750000000000e-01,
	/*2256*/ -3.14484149217605590820312500000000e-01,
	/*2257*/ -3.15940290689468383789062500000000e-01,
	/*2258*/ -3.17395687103271484375000000000000e-01,
	/*2259*/ -3.18850338459014892578125000000000e-01,
	/*2260*/ -3.20304214954376220703125000000000e-01,
	/*2261*/ -3.21757346391677856445312500000000e-01,
	/*2262*/ -3.23209732770919799804687500000000e-01,
	/*2263*/ -3.24661374092102050781250000000000e-01,
	/*2264*/ -3.26112210750579833984375000000000e-01,
	/*2265*/ -3.27562302350997924804687500000000e-01,
	/*2266*/ -3.29011619091033935546875000000000e-01,
	/*2267*/ -3.30460160970687866210937500000000e-01,
	/*2268*/ -3.31907927989959716796875000000000e-01,
	/*2269*/ -3.33354920148849487304687500000000e-01,
	/*2270*/ -3.34801107645034790039062500000000e-01,
	/*2271*/ -3.36246520280838012695312500000000e-01,
	/*2272*/ -3.37691158056259155273437500000000e-01,
	/*2273*/ -3.39134961366653442382812500000000e-01,
	/*2274*/ -3.40577989816665649414062500000000e-01,
	/*2275*/ -3.42020213603973388671875000000000e-01,
	/*2276*/ -3.43461632728576660156250000000000e-01,
	/*2277*/ -3.44902247190475463867187500000000e-01,
	/*2278*/ -3.46342056989669799804687500000000e-01,
	/*2279*/ -3.47781032323837280273437500000000e-01,
	/*2280*/ -3.49219202995300292968750000000000e-01,
	/*2281*/ -3.50656539201736450195312500000000e-01,
	/*2282*/ -3.52093070745468139648437500000000e-01,
	/*2283*/ -3.53528738021850585937500000000000e-01,
	/*2284*/ -3.54963600635528564453125000000000e-01,
	/*2285*/ -3.56397628784179687500000000000000e-01,
	/*2286*/ -3.57830792665481567382812500000000e-01,
	/*2287*/ -3.59263151884078979492187500000000e-01,
	/*2288*/ -3.60694646835327148437500000000000e-01,
	/*2289*/ -3.62125277519226074218750000000000e-01,
	/*2290*/ -3.63555073738098144531250000000000e-01,
	/*2291*/ -3.64984005689620971679687500000000e-01,
	/*2292*/ -3.66412073373794555664062500000000e-01,
	/*2293*/ -3.67839306592941284179687500000000e-01,
	/*2294*/ -3.69265645742416381835937500000000e-01,
	/*2295*/ -3.70691120624542236328125000000000e-01,
	/*2296*/ -3.72115731239318847656250000000000e-01,
	/*2297*/ -3.73539447784423828125000000000000e-01,
	/*2298*/ -3.74962300062179565429687500000000e-01,
	/*2299*/ -3.76384258270263671875000000000000e-01,
	/*2300*/ -3.77805352210998535156250000000000e-01,
	/*2301*/ -3.79225552082061767578125000000000e-01,
	/*2302*/ -3.80644857883453369140625000000000e-01,
	/*2303*/ -3.82063239812850952148437500000000e-01,
	/*2304*/ -3.83480757474899291992187500000000e-01,
	/*2305*/ -3.84897351264953613281250000000000e-01,
	/*2306*/ -3.86313050985336303710937500000000e-01,
	/*2307*/ -3.87727826833724975585937500000000e-01,
	/*2308*/ -3.89141708612442016601562500000000e-01,
	/*2309*/ -3.90554666519165039062500000000000e-01,
	/*2310*/ -3.91966700553894042968750000000000e-01,
	/*2311*/ -3.93377810716629028320312500000000e-01,
	/*2312*/ -3.94787997007369995117187500000000e-01,
	/*2313*/ -3.96197259426116943359375000000000e-01,
	/*2314*/ -3.97605568170547485351562500000000e-01,
	/*2315*/ -3.99012953042984008789062500000000e-01,
	/*2316*/ -4.00419414043426513671875000000000e-01,
	/*2317*/ -4.01824921369552612304687500000000e-01,
	/*2318*/ -4.03229475021362304687500000000000e-01,
	/*2319*/ -4.04633104801177978515625000000000e-01,
	/*2320*/ -4.06035751104354858398437500000000e-01,
	/*2321*/ -4.07437443733215332031250000000000e-01,
	/*2322*/ -4.08838212490081787109375000000000e-01,
	/*2323*/ -4.10237967967987060546875000000000e-01,
	/*2324*/ -4.11636799573898315429687500000000e-01,
	/*2325*/ -4.13034647703170776367187500000000e-01,
	/*2326*/ -4.14431512355804443359375000000000e-01,
	/*2327*/ -4.15827423334121704101562500000000e-01,
	/*2328*/ -4.17222350835800170898437500000000e-01,
	/*2329*/ -4.18616265058517456054687500000000e-01,
	/*2330*/ -4.20009225606918334960937500000000e-01,
	/*2331*/ -4.21401202678680419921875000000000e-01,
	/*2332*/ -4.22792166471481323242187500000000e-01,
	/*2333*/ -4.24182146787643432617187500000000e-01,
	/*2334*/ -4.25571113824844360351562500000000e-01,
	/*2335*/ -4.26959097385406494140625000000000e-01,
	/*2336*/ -4.28346067667007446289062500000000e-01,
	/*2337*/ -4.29732024669647216796875000000000e-01,
	/*2338*/ -4.31116968393325805664062500000000e-01,
	/*2339*/ -4.32500898838043212890625000000000e-01,
	/*2340*/ -4.33883816003799438476562500000000e-01,
	/*2341*/ -4.35265719890594482421875000000000e-01,
	/*2342*/ -4.36646580696105957031250000000000e-01,
	/*2343*/ -4.38026428222656250000000000000000e-01,
	/*2344*/ -4.39405232667922973632812500000000e-01,
	/*2345*/ -4.40783023834228515625000000000000e-01,
	/*2346*/ -4.42159742116928100585937500000000e-01,
	/*2347*/ -4.43535447120666503906250000000000e-01,
	/*2348*/ -4.44910109043121337890625000000000e-01,
	/*2349*/ -4.46283727884292602539062500000000e-01,
	/*2350*/ -4.47656273841857910156250000000000e-01,
	/*2351*/ -4.49027776718139648437500000000000e-01,
	/*2352*/ -4.50398206710815429687500000000000e-01,
	/*2353*/ -4.51767593622207641601562500000000e-01,
	/*2354*/ -4.53135907649993896484375000000000e-01,
	/*2355*/ -4.54503178596496582031250000000000e-01,
	/*2356*/ -4.55869346857070922851562500000000e-01,
	/*2357*/ -4.57234472036361694335937500000000e-01,
	/*2358*/ -4.58598494529724121093750000000000e-01,
	/*2359*/ -4.59961473941802978515625000000000e-01,
	/*2360*/ -4.61323320865631103515625000000000e-01,
	/*2361*/ -4.62684124708175659179687500000000e-01,
	/*2362*/ -4.64043825864791870117187500000000e-01,
	/*2363*/ -4.65402424335479736328125000000000e-01,
	/*2364*/ -4.66759920120239257812500000000000e-01,
	/*2365*/ -4.68116343021392822265625000000000e-01,
	/*2366*/ -4.69471633434295654296875000000000e-01,
	/*2367*/ -4.70825850963592529296875000000000e-01,
	/*2368*/ -4.72178936004638671875000000000000e-01,
	/*2369*/ -4.73530918359756469726562500000000e-01,
	/*2370*/ -4.74881798028945922851562500000000e-01,
	/*2371*/ -4.76231545209884643554687500000000e-01,
	/*2372*/ -4.77580159902572631835937500000000e-01,
	/*2373*/ -4.78927671909332275390625000000000e-01,
	/*2374*/ -4.80274051427841186523437500000000e-01,
	/*2375*/ -4.81619298458099365234375000000000e-01,
	/*2376*/ -4.82963413000106811523437500000000e-01,
	/*2377*/ -4.84306365251541137695312500000000e-01,
	/*2378*/ -4.85648214817047119140625000000000e-01,
	/*2379*/ -4.86988902091979980468750000000000e-01,
	/*2380*/ -4.88328456878662109375000000000000e-01,
	/*2381*/ -4.89666849374771118164062500000000e-01,
	/*2382*/ -4.91004079580307006835937500000000e-01,
	/*2383*/ -4.92340177297592163085937500000000e-01,
	/*2384*/ -4.93675112724304199218750000000000e-01,
	/*2385*/ -4.95008856058120727539062500000000e-01,
	/*2386*/ -4.96341466903686523437500000000000e-01,
	/*2387*/ -4.97672885656356811523437500000000e-01,
	/*2388*/ -4.99003142118453979492187500000000e-01,
	/*2389*/ -5.00332236289978027343750000000000e-01,
	/*2390*/ -5.01660168170928955078125000000000e-01,
	/*2391*/ -5.02986848354339599609375000000000e-01,
	/*2392*/ -5.04312396049499511718750000000000e-01,
	/*2393*/ -5.05636751651763916015625000000000e-01,
	/*2394*/ -5.06959915161132812500000000000000e-01,
	/*2395*/ -5.08281886577606201171875000000000e-01,
	/*2396*/ -5.09602665901184082031250000000000e-01,
	/*2397*/ -5.10922253131866455078125000000000e-01,
	/*2398*/ -5.12240648269653320312500000000000e-01,
	/*2399*/ -5.13557791709899902343750000000000e-01,
	/*2400*/ -5.14873743057250976562500000000000e-01,
	/*2401*/ -5.16188502311706542968750000000000e-01,
	/*2402*/ -5.17502009868621826171875000000000e-01,
	/*2403*/ -5.18814325332641601562500000000000e-01,
	/*2404*/ -5.20125389099121093750000000000000e-01,
	/*2405*/ -5.21435260772705078125000000000000e-01,
	/*2406*/ -5.22743940353393554687500000000000e-01,
	/*2407*/ -5.24051308631896972656250000000000e-01,
	/*2408*/ -5.25357484817504882812500000000000e-01,
	/*2409*/ -5.26662409305572509765625000000000e-01,
	/*2410*/ -5.27966141700744628906250000000000e-01,
	/*2411*/ -5.29268562793731689453125000000000e-01,
	/*2412*/ -5.30569791793823242187500000000000e-01,
	/*2413*/ -5.31869769096374511718750000000000e-01,
	/*2414*/ -5.33168435096740722656250000000000e-01,
	/*2415*/ -5.34465909004211425781250000000000e-01,
	/*2416*/ -5.35762071609497070312500000000000e-01,
	/*2417*/ -5.37057042121887207031250000000000e-01,
	/*2418*/ -5.38350701332092285156250000000000e-01,
	/*2419*/ -5.39643108844757080078125000000000e-01,
	/*2420*/ -5.40934205055236816406250000000000e-01,
	/*2421*/ -5.42224049568176269531250000000000e-01,
	/*2422*/ -5.43512642383575439453125000000000e-01,
	/*2423*/ -5.44799983501434326171875000000000e-01,
	/*2424*/ -5.46085953712463378906250000000000e-01,
	/*2425*/ -5.47370731830596923828125000000000e-01,
	/*2426*/ -5.48654139041900634765625000000000e-01,
	/*2427*/ -5.49936294555664062500000000000000e-01,
	/*2428*/ -5.51217138767242431640625000000000e-01,
	/*2429*/ -5.52496731281280517578125000000000e-01,
	/*2430*/ -5.53774952888488769531250000000000e-01,
	/*2431*/ -5.55051922798156738281250000000000e-01,
	/*2432*/ -5.56327581405639648437500000000000e-01,
	/*2433*/ -5.57601928710937500000000000000000e-01,
	/*2434*/ -5.58874905109405517578125000000000e-01,
	/*2435*/ -5.60146629810333251953125000000000e-01,
	/*2436*/ -5.61417043209075927734375000000000e-01,
	/*2437*/ -5.62686085700988769531250000000000e-01,
	/*2438*/ -5.63953816890716552734375000000000e-01,
	/*2439*/ -5.65220236778259277343750000000000e-01,
	/*2440*/ -5.66485345363616943359375000000000e-01,
	/*2441*/ -5.67749083042144775390625000000000e-01,
	/*2442*/ -5.69011509418487548828125000000000e-01,
	/*2443*/ -5.70272564888000488281250000000000e-01,
	/*2444*/ -5.71532309055328369140625000000000e-01,
	/*2445*/ -5.72790682315826416015625000000000e-01,
	/*2446*/ -5.74047744274139404296875000000000e-01,
	/*2447*/ -5.75303435325622558593750000000000e-01,
	/*2448*/ -5.76557755470275878906250000000000e-01,
	/*2449*/ -5.77810764312744140625000000000000e-01,
	/*2450*/ -5.79062342643737792968750000000000e-01,
	/*2451*/ -5.80312609672546386718750000000000e-01,
	/*2452*/ -5.81561505794525146484375000000000e-01,
	/*2453*/ -5.82809031009674072265625000000000e-01,
	/*2454*/ -5.84055185317993164062500000000000e-01,
	/*2455*/ -5.85299909114837646484375000000000e-01,
	/*2456*/ -5.86543321609497070312500000000000e-01,
	/*2457*/ -5.87785303592681884765625000000000e-01,
	/*2458*/ -5.89025974273681640625000000000000e-01,
	/*2459*/ -5.90265214443206787109375000000000e-01,
	/*2460*/ -5.91503024101257324218750000000000e-01,
	/*2461*/ -5.92739522457122802734375000000000e-01,
	/*2462*/ -5.93974590301513671875000000000000e-01,
	/*2463*/ -5.95208227634429931640625000000000e-01,
	/*2464*/ -5.96440494060516357421875000000000e-01,
	/*2465*/ -5.97671329975128173828125000000000e-01,
	/*2466*/ -5.98900794982910156250000000000000e-01,
	/*2467*/ -6.00128829479217529296875000000000e-01,
	/*2468*/ -6.01355493068695068359375000000000e-01,
	/*2469*/ -6.02580666542053222656250000000000e-01,
	/*2470*/ -6.03804469108581542968750000000000e-01,
	/*2471*/ -6.05026841163635253906250000000000e-01,
	/*2472*/ -6.06247782707214355468750000000000e-01,
	/*2473*/ -6.07467353343963623046875000000000e-01,
	/*2474*/ -6.08685433864593505859375000000000e-01,
	/*2475*/ -6.09902083873748779296875000000000e-01,
	/*2476*/ -6.11117303371429443359375000000000e-01,
	/*2477*/ -6.12331092357635498046875000000000e-01,
	/*2478*/ -6.13543450832366943359375000000000e-01,
	/*2479*/ -6.14754319190979003906250000000000e-01,
	/*2480*/ -6.15963757038116455078125000000000e-01,
	/*2481*/ -6.17171764373779296875000000000000e-01,
	/*2482*/ -6.18378341197967529296875000000000e-01,
	/*2483*/ -6.19583427906036376953125000000000e-01,
	/*2484*/ -6.20787024497985839843750000000000e-01,
	/*2485*/ -6.21989250183105468750000000000000e-01,
	/*2486*/ -6.23189926147460937500000000000000e-01,
	/*2487*/ -6.24389171600341796875000000000000e-01,
	/*2488*/ -6.25586926937103271484375000000000e-01,
	/*2489*/ -6.26783251762390136718750000000000e-01,
	/*2490*/ -6.27978086471557617187500000000000e-01,
	/*2491*/ -6.29171431064605712890625000000000e-01,
	/*2492*/ -6.30363285541534423828125000000000e-01,
	/*2493*/ -6.31553649902343750000000000000000e-01,
	/*2494*/ -6.32742524147033691406250000000000e-01,
	/*2495*/ -6.33929908275604248046875000000000e-01,
	/*2496*/ -6.35115861892700195312500000000000e-01,
	/*2497*/ -6.36300265789031982421875000000000e-01,
	/*2498*/ -6.37483179569244384765625000000000e-01,
	/*2499*/ -6.38664603233337402343750000000000e-01,
	/*2500*/ -6.39844477176666259765625000000000e-01,
	/*2501*/ -6.41022920608520507812500000000000e-01,
	/*2502*/ -6.42199814319610595703125000000000e-01,
	/*2503*/ -6.43375158309936523437500000000000e-01,
	/*2504*/ -6.44549071788787841796875000000000e-01,
	/*2505*/ -6.45721435546875000000000000000000e-01,
	/*2506*/ -6.46892249584197998046875000000000e-01,
	/*2507*/ -6.48061573505401611328125000000000e-01,
	/*2508*/ -6.49229347705841064453125000000000e-01,
	/*2509*/ -6.50395572185516357421875000000000e-01,
	/*2510*/ -6.51560306549072265625000000000000e-01,
	/*2511*/ -6.52723491191864013671875000000000e-01,
	/*2512*/ -6.53885126113891601562500000000000e-01,
	/*2513*/ -6.55045270919799804687500000000000e-01,
	/*2514*/ -6.56203866004943847656250000000000e-01,
	/*2515*/ -6.57360851764678955078125000000000e-01,
	/*2516*/ -6.58516347408294677734375000000000e-01,
	/*2517*/ -6.59670293331146240234375000000000e-01,
	/*2518*/ -6.60822629928588867187500000000000e-01,
	/*2519*/ -6.61973476409912109375000000000000e-01,
	/*2520*/ -6.63122713565826416015625000000000e-01,
	/*2521*/ -6.64270460605621337890625000000000e-01,
	/*2522*/ -6.65416538715362548828125000000000e-01,
	/*2523*/ -6.66561126708984375000000000000000e-01,
	/*2524*/ -6.67704164981842041015625000000000e-01,
	/*2525*/ -6.68845593929290771484375000000000e-01,
	/*2526*/ -6.69985413551330566406250000000000e-01,
	/*2527*/ -6.71123683452606201171875000000000e-01,
	/*2528*/ -6.72260403633117675781250000000000e-01,
	/*2529*/ -6.73395514488220214843750000000000e-01,
	/*2530*/ -6.74529016017913818359375000000000e-01,
	/*2531*/ -6.75660967826843261718750000000000e-01,
	/*2532*/ -6.76791310310363769531250000000000e-01,
	/*2533*/ -6.77920103073120117187500000000000e-01,
	/*2534*/ -6.79047226905822753906250000000000e-01,
	/*2535*/ -6.80172801017761230468750000000000e-01,
	/*2536*/ -6.81296765804290771484375000000000e-01,
	/*2537*/ -6.82419121265411376953125000000000e-01,
	/*2538*/ -6.83539867401123046875000000000000e-01,
	/*2539*/ -6.84659004211425781250000000000000e-01,
	/*2540*/ -6.85776531696319580078125000000000e-01,
	/*2541*/ -6.86892449855804443359375000000000e-01,
	/*2542*/ -6.88006758689880371093750000000000e-01,
	/*2543*/ -6.89119458198547363281250000000000e-01,
	/*2544*/ -6.90230488777160644531250000000000e-01,
	/*2545*/ -6.91339910030364990234375000000000e-01,
	/*2546*/ -6.92447721958160400390625000000000e-01,
	/*2547*/ -6.93553924560546875000000000000000e-01,
	/*2548*/ -6.94658458232879638671875000000000e-01,
	/*2549*/ -6.95761322975158691406250000000000e-01,
	/*2550*/ -6.96862637996673583984375000000000e-01,
	/*2551*/ -6.97962224483489990234375000000000e-01,
	/*2552*/ -6.99060201644897460937500000000000e-01,
	/*2553*/ -7.00156569480895996093750000000000e-01,
	/*2554*/ -7.01251268386840820312500000000000e-01,
	/*2555*/ -7.02344298362731933593750000000000e-01,
	/*2556*/ -7.03435659408569335937500000000000e-01,
	/*2557*/ -7.04525411128997802734375000000000e-01,
	/*2558*/ -7.05613493919372558593750000000000e-01,
	/*2559*/ -7.06699848175048828125000000000000e-01,
	/*2560*/ -7.07784593105316162109375000000000e-01,
	/*2561*/ -7.08867728710174560546875000000000e-01,
	/*2562*/ -7.09949135780334472656250000000000e-01,
	/*2563*/ -7.11028873920440673828125000000000e-01,
	/*2564*/ -7.12106883525848388671875000000000e-01,
	/*2565*/ -7.13183283805847167968750000000000e-01,
	/*2566*/ -7.14258015155792236328125000000000e-01,
	/*2567*/ -7.15331017971038818359375000000000e-01,
	/*2568*/ -7.16402351856231689453125000000000e-01,
	/*2569*/ -7.17472016811370849609375000000000e-01,
	/*2570*/ -7.18540012836456298828125000000000e-01,
	/*2571*/ -7.19606280326843261718750000000000e-01,
	/*2572*/ -7.20670878887176513671875000000000e-01,
	/*2573*/ -7.21733748912811279296875000000000e-01,
	/*2574*/ -7.22794950008392333984375000000000e-01,
	/*2575*/ -7.23854422569274902343750000000000e-01,
	/*2576*/ -7.24912226200103759765625000000000e-01,
	/*2577*/ -7.25968241691589355468750000000000e-01,
	/*2578*/ -7.27022647857666015625000000000000e-01,
	/*2579*/ -7.28075265884399414062500000000000e-01,
	/*2580*/ -7.29126214981079101562500000000000e-01,
	/*2581*/ -7.30175435543060302734375000000000e-01,
	/*2582*/ -7.31222927570343017578125000000000e-01,
	/*2583*/ -7.32268750667572021484375000000000e-01,
	/*2584*/ -7.33312785625457763671875000000000e-01,
	/*2585*/ -7.34355151653289794921875000000000e-01,
	/*2586*/ -7.35395729541778564453125000000000e-01,
	/*2587*/ -7.36434578895568847656250000000000e-01,
	/*2588*/ -7.37471759319305419921875000000000e-01,
	/*2589*/ -7.38507151603698730468750000000000e-01,
	/*2590*/ -7.39540815353393554687500000000000e-01,
	/*2591*/ -7.40572750568389892578125000000000e-01,
	/*2592*/ -7.41602897644042968750000000000000e-01,
	/*2593*/ -7.42631316184997558593750000000000e-01,
	/*2594*/ -7.43658006191253662109375000000000e-01,
	/*2595*/ -7.44682967662811279296875000000000e-01,
	/*2596*/ -7.45706140995025634765625000000000e-01,
	/*2597*/ -7.46727526187896728515625000000000e-01,
	/*2598*/ -7.47747242450714111328125000000000e-01,
	/*2599*/ -7.48765110969543457031250000000000e-01,
	/*2600*/ -7.49781250953674316406250000000000e-01,
	/*2601*/ -7.50795662403106689453125000000000e-01,
	/*2602*/ -7.51808285713195800781250000000000e-01,
	/*2603*/ -7.52819120883941650390625000000000e-01,
	/*2604*/ -7.53828167915344238281250000000000e-01,
	/*2605*/ -7.54835486412048339843750000000000e-01,
	/*2606*/ -7.55840957164764404296875000000000e-01,
	/*2607*/ -7.56844699382781982421875000000000e-01,
	/*2608*/ -7.57846653461456298828125000000000e-01,
	/*2609*/ -7.58846819400787353515625000000000e-01,
	/*2610*/ -7.59845197200775146484375000000000e-01,
	/*2611*/ -7.60841846466064453125000000000000e-01,
	/*2612*/ -7.61836647987365722656250000000000e-01,
	/*2613*/ -7.62829661369323730468750000000000e-01,
	/*2614*/ -7.63820827007293701171875000000000e-01,
	/*2615*/ -7.64810264110565185546875000000000e-01,
	/*2616*/ -7.65797913074493408203125000000000e-01,
	/*2617*/ -7.66783714294433593750000000000000e-01,
	/*2618*/ -7.67767727375030517578125000000000e-01,
	/*2619*/ -7.68749892711639404296875000000000e-01,
	/*2620*/ -7.69730269908905029296875000000000e-01,
	/*2621*/ -7.70708858966827392578125000000000e-01,
	/*2622*/ -7.71685659885406494140625000000000e-01,
	/*2623*/ -7.72660613059997558593750000000000e-01,
	/*2624*/ -7.73633718490600585937500000000000e-01,
	/*2625*/ -7.74605035781860351562500000000000e-01,
	/*2626*/ -7.75574505329132080078125000000000e-01,
	/*2627*/ -7.76542186737060546875000000000000e-01,
	/*2628*/ -7.77508020401000976562500000000000e-01,
	/*2629*/ -7.78472006320953369140625000000000e-01,
	/*2630*/ -7.79434144496917724609375000000000e-01,
	/*2631*/ -7.80394494533538818359375000000000e-01,
	/*2632*/ -7.81352996826171875000000000000000e-01,
	/*2633*/ -7.82309651374816894531250000000000e-01,
	/*2634*/ -7.83264458179473876953125000000000e-01,
	/*2635*/ -7.84217417240142822265625000000000e-01,
	/*2636*/ -7.85168528556823730468750000000000e-01,
	/*2637*/ -7.86117851734161376953125000000000e-01,
	/*2638*/ -7.87065267562866210937500000000000e-01,
	/*2639*/ -7.88010835647583007812500000000000e-01,
	/*2640*/ -7.88954555988311767578125000000000e-01,
	/*2641*/ -7.89896368980407714843750000000000e-01,
	/*2642*/ -7.90836393833160400390625000000000e-01,
	/*2643*/ -7.91774511337280273437500000000000e-01,
	/*2644*/ -7.92710781097412109375000000000000e-01,
	/*2645*/ -7.93645203113555908203125000000000e-01,
	/*2646*/ -7.94577717781066894531250000000000e-01,
	/*2647*/ -7.95508384704589843750000000000000e-01,
	/*2648*/ -7.96437203884124755859375000000000e-01,
	/*2649*/ -7.97364115715026855468750000000000e-01,
	/*2650*/ -7.98289179801940917968750000000000e-01,
	/*2651*/ -7.99212336540222167968750000000000e-01,
	/*2652*/ -8.00133585929870605468750000000000e-01,
	/*2653*/ -8.01052987575531005859375000000000e-01,
	/*2654*/ -8.01970541477203369140625000000000e-01,
	/*2655*/ -8.02886128425598144531250000000000e-01,
	/*2656*/ -8.03799867630004882812500000000000e-01,
	/*2657*/ -8.04711699485778808593750000000000e-01,
	/*2658*/ -8.05621683597564697265625000000000e-01,
	/*2659*/ -8.06529700756072998046875000000000e-01,
	/*2660*/ -8.07435870170593261718750000000000e-01,
	/*2661*/ -8.08340132236480712890625000000000e-01,
	/*2662*/ -8.09242486953735351562500000000000e-01,
	/*2663*/ -8.10142934322357177734375000000000e-01,
	/*2664*/ -8.11041414737701416015625000000000e-01,
	/*2665*/ -8.11938047409057617187500000000000e-01,
	/*2666*/ -8.12832772731781005859375000000000e-01,
	/*2667*/ -8.13725590705871582031250000000000e-01,
	/*2668*/ -8.14616441726684570312500000000000e-01,
	/*2669*/ -8.15505445003509521484375000000000e-01,
	/*2670*/ -8.16392481327056884765625000000000e-01,
	/*2671*/ -8.17277610301971435546875000000000e-01,
	/*2672*/ -8.18160831928253173828125000000000e-01,
	/*2673*/ -8.19042086601257324218750000000000e-01,
	/*2674*/ -8.19921433925628662109375000000000e-01,
	/*2675*/ -8.20798814296722412109375000000000e-01,
	/*2676*/ -8.21674346923828125000000000000000e-01,
	/*2677*/ -8.22547852993011474609375000000000e-01,
	/*2678*/ -8.23419511318206787109375000000000e-01,
	/*2679*/ -8.24289143085479736328125000000000e-01,
	/*2680*/ -8.25156867504119873046875000000000e-01,
	/*2681*/ -8.26022684574127197265625000000000e-01,
	/*2682*/ -8.26886534690856933593750000000000e-01,
	/*2683*/ -8.27748417854309082031250000000000e-01,
	/*2684*/ -8.28608393669128417968750000000000e-01,
	/*2685*/ -8.29466402530670166015625000000000e-01,
	/*2686*/ -8.30322444438934326171875000000000e-01,
	/*2687*/ -8.31176519393920898437500000000000e-01,
	/*2688*/ -8.32028687000274658203125000000000e-01,
	/*2689*/ -8.32878828048706054687500000000000e-01,
	/*2690*/ -8.33727061748504638671875000000000e-01,
	/*2691*/ -8.34573328495025634765625000000000e-01,
	/*2692*/ -8.35417628288269042968750000000000e-01,
	/*2693*/ -8.36259901523590087890625000000000e-01,
	/*2694*/ -8.37100267410278320312500000000000e-01,
	/*2695*/ -8.37938666343688964843750000000000e-01,
	/*2696*/ -8.38775038719177246093750000000000e-01,
	/*2697*/ -8.39609503746032714843750000000000e-01,
	/*2698*/ -8.40441942214965820312500000000000e-01,
	/*2699*/ -8.41272413730621337890625000000000e-01,
	/*2700*/ -8.42100918292999267578125000000000e-01,
	/*2701*/ -8.42927455902099609375000000000000e-01,
	/*2702*/ -8.43751966953277587890625000000000e-01,
	/*2703*/ -8.44574511051177978515625000000000e-01,
	/*2704*/ -8.45395088195800781250000000000000e-01,
	/*2705*/ -8.46213638782501220703125000000000e-01,
	/*2706*/ -8.47030222415924072265625000000000e-01,
	/*2707*/ -8.47844839096069335937500000000000e-01,
	/*2708*/ -8.48657429218292236328125000000000e-01,
	/*2709*/ -8.49467992782592773437500000000000e-01,
	/*2710*/ -8.50276589393615722656250000000000e-01,
	/*2711*/ -8.51083159446716308593750000000000e-01,
	/*2712*/ -8.51887762546539306640625000000000e-01,
	/*2713*/ -8.52690339088439941406250000000000e-01,
	/*2714*/ -8.53490889072418212890625000000000e-01,
	/*2715*/ -8.54289472103118896484375000000000e-01,
	/*2716*/ -8.55085968971252441406250000000000e-01,
	/*2717*/ -8.55880558490753173828125000000000e-01,
	/*2718*/ -8.56673061847686767578125000000000e-01,
	/*2719*/ -8.57463538646697998046875000000000e-01,
	/*2720*/ -8.58252048492431640625000000000000e-01,
	/*2721*/ -8.59038531780242919921875000000000e-01,
	/*2722*/ -8.59822928905487060546875000000000e-01,
	/*2723*/ -8.60605359077453613281250000000000e-01,
	/*2724*/ -8.61385762691497802734375000000000e-01,
	/*2725*/ -8.62164139747619628906250000000000e-01,
	/*2726*/ -8.62940430641174316406250000000000e-01,
	/*2727*/ -8.63714754581451416015625000000000e-01,
	/*2728*/ -8.64487051963806152343750000000000e-01,
	/*2729*/ -8.65257263183593750000000000000000e-01,
	/*2730*/ -8.66025447845458984375000000000000e-01,
	/*2731*/ -8.66791605949401855468750000000000e-01,
	/*2732*/ -8.67555737495422363281250000000000e-01,
	/*2733*/ -8.68317782878875732421875000000000e-01,
	/*2734*/ -8.69077861309051513671875000000000e-01,
	/*2735*/ -8.69835793972015380859375000000000e-01,
	/*2736*/ -8.70591759681701660156250000000000e-01,
	/*2737*/ -8.71345639228820800781250000000000e-01,
	/*2738*/ -8.72097492218017578125000000000000e-01,
	/*2739*/ -8.72847259044647216796875000000000e-01,
	/*2740*/ -8.73594999313354492187500000000000e-01,
	/*2741*/ -8.74340653419494628906250000000000e-01,
	/*2742*/ -8.75084280967712402343750000000000e-01,
	/*2743*/ -8.75825822353363037109375000000000e-01,
	/*2744*/ -8.76565337181091308593750000000000e-01,
	/*2745*/ -8.77302765846252441406250000000000e-01,
	/*2746*/ -8.78038108348846435546875000000000e-01,
	/*2747*/ -8.78771424293518066406250000000000e-01,
	/*2748*/ -8.79502654075622558593750000000000e-01,
	/*2749*/ -8.80231797695159912109375000000000e-01,
	/*2750*/ -8.80958855152130126953125000000000e-01,
	/*2751*/ -8.81683886051177978515625000000000e-01,
	/*2752*/ -8.82406830787658691406250000000000e-01,
	/*2753*/ -8.83127689361572265625000000000000e-01,
	/*2754*/ -8.83846461772918701171875000000000e-01,
	/*2755*/ -8.84563148021697998046875000000000e-01,
	/*2756*/ -8.85277748107910156250000000000000e-01,
	/*2757*/ -8.85990262031555175781250000000000e-01,
	/*2758*/ -8.86700749397277832031250000000000e-01,
	/*2759*/ -8.87409090995788574218750000000000e-01,
	/*2760*/ -8.88115346431732177734375000000000e-01,
	/*2761*/ -8.88819515705108642578125000000000e-01,
	/*2762*/ -8.89521598815917968750000000000000e-01,
	/*2763*/ -8.90221595764160156250000000000000e-01,
	/*2764*/ -8.90919506549835205078125000000000e-01,
	/*2765*/ -8.91615271568298339843750000000000e-01,
	/*2766*/ -8.92308950424194335937500000000000e-01,
	/*2767*/ -8.93000543117523193359375000000000e-01,
	/*2768*/ -8.93690049648284912109375000000000e-01,
	/*2769*/ -8.94377470016479492187500000000000e-01,
	/*2770*/ -8.95062744617462158203125000000000e-01,
	/*2771*/ -8.95745933055877685546875000000000e-01,
	/*2772*/ -8.96426975727081298828125000000000e-01,
	/*2773*/ -8.97105932235717773437500000000000e-01,
	/*2774*/ -8.97782802581787109375000000000000e-01,
	/*2775*/ -8.98457527160644531250000000000000e-01,
	/*2776*/ -8.99130165576934814453125000000000e-01,
	/*2777*/ -8.99800658226013183593750000000000e-01,
	/*2778*/ -9.00469005107879638671875000000000e-01,
	/*2779*/ -9.01135265827178955078125000000000e-01,
	/*2780*/ -9.01799440383911132812500000000000e-01,
	/*2781*/ -9.02461409568786621093750000000000e-01,
	/*2782*/ -9.03121352195739746093750000000000e-01,
	/*2783*/ -9.03779089450836181640625000000000e-01,
	/*2784*/ -9.04434740543365478515625000000000e-01,
	/*2785*/ -9.05088245868682861328125000000000e-01,
	/*2786*/ -9.05739605426788330078125000000000e-01,
	/*2787*/ -9.06388878822326660156250000000000e-01,
	/*2788*/ -9.07036006450653076171875000000000e-01,
	/*2789*/ -9.07680988311767578125000000000000e-01,
	/*2790*/ -9.08323824405670166015625000000000e-01,
	/*2791*/ -9.08964514732360839843750000000000e-01,
	/*2792*/ -9.09603059291839599609375000000000e-01,
	/*2793*/ -9.10239458084106445312500000000000e-01,
	/*2794*/ -9.10873770713806152343750000000000e-01,
	/*2795*/ -9.11505877971649169921875000000000e-01,
	/*2796*/ -9.12135899066925048828125000000000e-01,
	/*2797*/ -9.12763714790344238281250000000000e-01,
	/*2798*/ -9.13389444351196289062500000000000e-01,
	/*2799*/ -9.14012968540191650390625000000000e-01,
	/*2800*/ -9.14634346961975097656250000000000e-01,
	/*2801*/ -9.15253579616546630859375000000000e-01,
	/*2802*/ -9.15870666503906250000000000000000e-01,
	/*2803*/ -9.16485607624053955078125000000000e-01,
	/*2804*/ -9.17098343372344970703125000000000e-01,
	/*2805*/ -9.17708933353424072265625000000000e-01,
	/*2806*/ -9.18317437171936035156250000000000e-01,
	/*2807*/ -9.18923676013946533203125000000000e-01,
	/*2808*/ -9.19527828693389892578125000000000e-01,
	/*2809*/ -9.20129776000976562500000000000000e-01,
	/*2810*/ -9.20729577541351318359375000000000e-01,
	/*2811*/ -9.21327173709869384765625000000000e-01,
	/*2812*/ -9.21922624111175537109375000000000e-01,
	/*2813*/ -9.22515928745269775390625000000000e-01,
	/*2814*/ -9.23107028007507324218750000000000e-01,
	/*2815*/ -9.23695981502532958984375000000000e-01,
	/*2816*/ -9.24282729625701904296875000000000e-01,
	/*2817*/ -9.24867331981658935546875000000000e-01,
	/*2818*/ -9.25449728965759277343750000000000e-01,
	/*2819*/ -9.26029980182647705078125000000000e-01,
	/*2820*/ -9.26608026027679443359375000000000e-01,
	/*2821*/ -9.27183866500854492187500000000000e-01,
	/*2822*/ -9.27757561206817626953125000000000e-01,
	/*2823*/ -9.28329110145568847656250000000000e-01,
	/*2824*/ -9.28898394107818603515625000000000e-01,
	/*2825*/ -9.29465532302856445312500000000000e-01,
	/*2826*/ -9.30030465126037597656250000000000e-01,
	/*2827*/ -9.30593252182006835937500000000000e-01,
	/*2828*/ -9.31153774261474609375000000000000e-01,
	/*2829*/ -9.31712150573730468750000000000000e-01,
	/*2830*/ -9.32268321514129638671875000000000e-01,
	/*2831*/ -9.32822346687316894531250000000000e-01,
	/*2832*/ -9.33374106884002685546875000000000e-01,
	/*2833*/ -9.33923721313476562500000000000000e-01,
	/*2834*/ -9.34471070766448974609375000000000e-01,
	/*2835*/ -9.35016274452209472656250000000000e-01,
	/*2836*/ -9.35559272766113281250000000000000e-01,
	/*2837*/ -9.36100065708160400390625000000000e-01,
	/*2838*/ -9.36638653278350830078125000000000e-01,
	/*2839*/ -9.37175035476684570312500000000000e-01,
	/*2840*/ -9.37709212303161621093750000000000e-01,
	/*2841*/ -9.38241124153137207031250000000000e-01,
	/*2842*/ -9.38770890235900878906250000000000e-01,
	/*2843*/ -9.39298450946807861328125000000000e-01,
	/*2844*/ -9.39823806285858154296875000000000e-01,
	/*2845*/ -9.40346896648406982421875000000000e-01,
	/*2846*/ -9.40867841243743896484375000000000e-01,
	/*2847*/ -9.41386520862579345703125000000000e-01,
	/*2848*/ -9.41902995109558105468750000000000e-01,
	/*2849*/ -9.42417263984680175781250000000000e-01,
	/*2850*/ -9.42929267883300781250000000000000e-01,
	/*2851*/ -9.43439126014709472656250000000000e-01,
	/*2852*/ -9.43946719169616699218750000000000e-01,
	/*2853*/ -9.44452047348022460937500000000000e-01,
	/*2854*/ -9.44955229759216308593750000000000e-01,
	/*2855*/ -9.45456147193908691406250000000000e-01,
	/*2856*/ -9.45954859256744384765625000000000e-01,
	/*2857*/ -9.46451306343078613281250000000000e-01,
	/*2858*/ -9.46945548057556152343750000000000e-01,
	/*2859*/ -9.47437584400177001953125000000000e-01,
	/*2860*/ -9.47927355766296386718750000000000e-01,
	/*2861*/ -9.48414921760559082031250000000000e-01,
	/*2862*/ -9.48900282382965087890625000000000e-01,
	/*2863*/ -9.49383378028869628906250000000000e-01,
	/*2864*/ -9.49864208698272705078125000000000e-01,
	/*2865*/ -9.50342833995819091796875000000000e-01,
	/*2866*/ -9.50819194316864013671875000000000e-01,
	/*2867*/ -9.51293349266052246093750000000000e-01,
	/*2868*/ -9.51765239238739013671875000000000e-01,
	/*2869*/ -9.52234923839569091796875000000000e-01,
	/*2870*/ -9.52702343463897705078125000000000e-01,
	/*2871*/ -9.53167498111724853515625000000000e-01,
	/*2872*/ -9.53630447387695312500000000000000e-01,
	/*2873*/ -9.54091131687164306640625000000000e-01,
	/*2874*/ -9.54549551010131835937500000000000e-01,
	/*2875*/ -9.55005764961242675781250000000000e-01,
	/*2876*/ -9.55459713935852050781250000000000e-01,
	/*2877*/ -9.55911397933959960937500000000000e-01,
	/*2878*/ -9.56360816955566406250000000000000e-01,
	/*2879*/ -9.56808030605316162109375000000000e-01,
	/*2880*/ -9.57252979278564453125000000000000e-01,
	/*2881*/ -9.57695662975311279296875000000000e-01,
	/*2882*/ -9.58136081695556640625000000000000e-01,
	/*2883*/ -9.58574295043945312500000000000000e-01,
	/*2884*/ -9.59010183811187744140625000000000e-01,
	/*2885*/ -9.59443867206573486328125000000000e-01,
	/*2886*/ -9.59875285625457763671875000000000e-01,
	/*2887*/ -9.60304439067840576171875000000000e-01,
	/*2888*/ -9.60731327533721923828125000000000e-01,
	/*2889*/ -9.61155951023101806640625000000000e-01,
	/*2890*/ -9.61578309535980224609375000000000e-01,
	/*2891*/ -9.61998403072357177734375000000000e-01,
	/*2892*/ -9.62416231632232666015625000000000e-01,
	/*2893*/ -9.62831795215606689453125000000000e-01,
	/*2894*/ -9.63245093822479248046875000000000e-01,
	/*2895*/ -9.63656127452850341796875000000000e-01,
	/*2896*/ -9.64064896106719970703125000000000e-01,
	/*2897*/ -9.64471340179443359375000000000000e-01,
	/*2898*/ -9.64875578880310058593750000000000e-01,
	/*2899*/ -9.65277552604675292968750000000000e-01,
	/*2900*/ -9.65677201747894287109375000000000e-01,
	/*2901*/ -9.66074585914611816406250000000000e-01,
	/*2902*/ -9.66469764709472656250000000000000e-01,
	/*2903*/ -9.66862618923187255859375000000000e-01,
	/*2904*/ -9.67253208160400390625000000000000e-01,
	/*2905*/ -9.67641472816467285156250000000000e-01,
	/*2906*/ -9.68027532100677490234375000000000e-01,
	/*2907*/ -9.68411266803741455078125000000000e-01,
	/*2908*/ -9.68792736530303955078125000000000e-01,
	/*2909*/ -9.69171881675720214843750000000000e-01,
	/*2910*/ -9.69548821449279785156250000000000e-01,
	/*2911*/ -9.69923436641693115234375000000000e-01,
	/*2912*/ -9.70295727252960205078125000000000e-01,
	/*2913*/ -9.70665812492370605468750000000000e-01,
	/*2914*/ -9.71033573150634765625000000000000e-01,
	/*2915*/ -9.71399068832397460937500000000000e-01,
	/*2916*/ -9.71762239933013916015625000000000e-01,
	/*2917*/ -9.72123146057128906250000000000000e-01,
	/*2918*/ -9.72481787204742431640625000000000e-01,
	/*2919*/ -9.72838103771209716796875000000000e-01,
	/*2920*/ -9.73192155361175537109375000000000e-01,
	/*2921*/ -9.73543882369995117187500000000000e-01,
	/*2922*/ -9.73893344402313232421875000000000e-01,
	/*2923*/ -9.74240481853485107421875000000000e-01,
	/*2924*/ -9.74585354328155517578125000000000e-01,
	/*2925*/ -9.74927961826324462890625000000000e-01,
	/*2926*/ -9.75268244743347167968750000000000e-01,
	/*2927*/ -9.75606203079223632812500000000000e-01,
	/*2928*/ -9.75941896438598632812500000000000e-01,
	/*2929*/ -9.76275265216827392578125000000000e-01,
	/*2930*/ -9.76606369018554687500000000000000e-01,
	/*2931*/ -9.76935148239135742187500000000000e-01,
	/*2932*/ -9.77261662483215332031250000000000e-01,
	/*2933*/ -9.77585852146148681640625000000000e-01,
	/*2934*/ -9.77907717227935791015625000000000e-01,
	/*2935*/ -9.78227317333221435546875000000000e-01,
	/*2936*/ -9.78544592857360839843750000000000e-01,
	/*2937*/ -9.78859543800354003906250000000000e-01,
	/*2938*/ -9.79172229766845703125000000000000e-01,
	/*2939*/ -9.79482591152191162109375000000000e-01,
	/*2940*/ -9.79790687561035156250000000000000e-01,
	/*2941*/ -9.80096459388732910156250000000000e-01,
	/*2942*/ -9.80399906635284423828125000000000e-01,
	/*2943*/ -9.80701029300689697265625000000000e-01,
	/*2944*/ -9.80999827384948730468750000000000e-01,
	/*2945*/ -9.81296360492706298828125000000000e-01,
	/*2946*/ -9.81590569019317626953125000000000e-01,
	/*2947*/ -9.81882512569427490234375000000000e-01,
	/*2948*/ -9.82172071933746337890625000000000e-01,
	/*2949*/ -9.82459366321563720703125000000000e-01,
	/*2950*/ -9.82744336128234863281250000000000e-01,
	/*2951*/ -9.83026981353759765625000000000000e-01,
	/*2952*/ -9.83307301998138427734375000000000e-01,
	/*2953*/ -9.83585357666015625000000000000000e-01,
	/*2954*/ -9.83861029148101806640625000000000e-01,
	/*2955*/ -9.84134435653686523437500000000000e-01,
	/*2956*/ -9.84405517578125000000000000000000e-01,
	/*2957*/ -9.84674274921417236328125000000000e-01,
	/*2958*/ -9.84940707683563232421875000000000e-01,
	/*2959*/ -9.85204815864562988281250000000000e-01,
	/*2960*/ -9.85466599464416503906250000000000e-01,
	/*2961*/ -9.85726118087768554687500000000000e-01,
	/*2962*/ -9.85983252525329589843750000000000e-01,
	/*2963*/ -9.86238121986389160156250000000000e-01,
	/*2964*/ -9.86490607261657714843750000000000e-01,
	/*2965*/ -9.86740827560424804687500000000000e-01,
	/*2966*/ -9.86988663673400878906250000000000e-01,
	/*2967*/ -9.87234234809875488281250000000000e-01,
	/*2968*/ -9.87477421760559082031250000000000e-01,
	/*2969*/ -9.87718343734741210937500000000000e-01,
	/*2970*/ -9.87956941127777099609375000000000e-01,
	/*2971*/ -9.88193154335021972656250000000000e-01,
	/*2972*/ -9.88427102565765380859375000000000e-01,
	/*2973*/ -9.88658666610717773437500000000000e-01,
	/*2974*/ -9.88887965679168701171875000000000e-01,
	/*2975*/ -9.89114880561828613281250000000000e-01,
	/*2976*/ -9.89339470863342285156250000000000e-01,
	/*2977*/ -9.89561796188354492187500000000000e-01,
	/*2978*/ -9.89781737327575683593750000000000e-01,
	/*2979*/ -9.89999353885650634765625000000000e-01,
	/*2980*/ -9.90214645862579345703125000000000e-01,
	/*2981*/ -9.90427613258361816406250000000000e-01,
	/*2982*/ -9.90638196468353271484375000000000e-01,
	/*2983*/ -9.90846514701843261718750000000000e-01,
	/*2984*/ -9.91052448749542236328125000000000e-01,
	/*2985*/ -9.91256117820739746093750000000000e-01,
	/*2986*/ -9.91457402706146240234375000000000e-01,
	/*2987*/ -9.91656363010406494140625000000000e-01,
	/*2988*/ -9.91852998733520507812500000000000e-01,
	/*2989*/ -9.92047250270843505859375000000000e-01,
	/*2990*/ -9.92239236831665039062500000000000e-01,
	/*2991*/ -9.92428839206695556640625000000000e-01,
	/*2992*/ -9.92616117000579833984375000000000e-01,
	/*2993*/ -9.92801070213317871093750000000000e-01,
	/*2994*/ -9.92983698844909667968750000000000e-01,
	/*2995*/ -9.93163943290710449218750000000000e-01,
	/*2996*/ -9.93341863155364990234375000000000e-01,
	/*2997*/ -9.93517458438873291015625000000000e-01,
	/*2998*/ -9.93690729141235351562500000000000e-01,
	/*2999*/ -9.93861675262451171875000000000000e-01,
	/*3000*/ -9.94030237197875976562500000000000e-01,
	/*3001*/ -9.94196474552154541015625000000000e-01,
	/*3002*/ -9.94360327720642089843750000000000e-01,
	/*3003*/ -9.94521915912628173828125000000000e-01,
	/*3004*/ -9.94681119918823242187500000000000e-01,
	/*3005*/ -9.94837999343872070312500000000000e-01,
	/*3006*/ -9.94992494583129882812500000000000e-01,
	/*3007*/ -9.95144724845886230468750000000000e-01,
	/*3008*/ -9.95294570922851562500000000000000e-01,
	/*3009*/ -9.95442032814025878906250000000000e-01,
	/*3010*/ -9.95587229728698730468750000000000e-01,
	/*3011*/ -9.95730042457580566406250000000000e-01,
	/*3012*/ -9.95870471000671386718750000000000e-01,
	/*3013*/ -9.96008634567260742187500000000000e-01,
	/*3014*/ -9.96144413948059082031250000000000e-01,
	/*3015*/ -9.96277809143066406250000000000000e-01,
	/*3016*/ -9.96408939361572265625000000000000e-01,
	/*3017*/ -9.96537685394287109375000000000000e-01,
	/*3018*/ -9.96664047241210937500000000000000e-01,
	/*3019*/ -9.96788084506988525390625000000000e-01,
	/*3020*/ -9.96909797191619873046875000000000e-01,
	/*3021*/ -9.97029185295104980468750000000000e-01,
	/*3022*/ -9.97146189212799072265625000000000e-01,
	/*3023*/ -9.97260868549346923828125000000000e-01,
	/*3024*/ -9.97373163700103759765625000000000e-01,
	/*3025*/ -9.97483134269714355468750000000000e-01,
	/*3026*/ -9.97590720653533935546875000000000e-01,
	/*3027*/ -9.97696042060852050781250000000000e-01,
	/*3028*/ -9.97798919677734375000000000000000e-01,
	/*3029*/ -9.97899532318115234375000000000000e-01,
	/*3030*/ -9.97997701168060302734375000000000e-01,
	/*3031*/ -9.98093605041503906250000000000000e-01,
	/*3032*/ -9.98187124729156494140625000000000e-01,
	/*3033*/ -9.98278319835662841796875000000000e-01,
	/*3034*/ -9.98367130756378173828125000000000e-01,
	/*3035*/ -9.98453617095947265625000000000000e-01,
	/*3036*/ -9.98537719249725341796875000000000e-01,
	/*3037*/ -9.98619496822357177734375000000000e-01,
	/*3038*/ -9.98698890209197998046875000000000e-01,
	/*3039*/ -9.98775959014892578125000000000000e-01,
	/*3040*/ -9.98850703239440917968750000000000e-01,
	/*3041*/ -9.98923063278198242187500000000000e-01,
	/*3042*/ -9.98993098735809326171875000000000e-01,
	/*3043*/ -9.99060750007629394531250000000000e-01,
	/*3044*/ -9.99126017093658447265625000000000e-01,
	/*3045*/ -9.99189019203186035156250000000000e-01,
	/*3046*/ -9.99249637126922607421875000000000e-01,
	/*3047*/ -9.99307870864868164062500000000000e-01,
	/*3048*/ -9.99363780021667480468750000000000e-01,
	/*3049*/ -9.99417304992675781250000000000000e-01,
	/*3050*/ -9.99468505382537841796875000000000e-01,
	/*3051*/ -9.99517321586608886718750000000000e-01,
	/*3052*/ -9.99563813209533691406250000000000e-01,
	/*3053*/ -9.99607980251312255859375000000000e-01,
	/*3054*/ -9.99649763107299804687500000000000e-01,
	/*3055*/ -9.99689161777496337890625000000000e-01,
	/*3056*/ -9.99726235866546630859375000000000e-01,
	/*3057*/ -9.99760985374450683593750000000000e-01,
	/*3058*/ -9.99793350696563720703125000000000e-01,
	/*3059*/ -9.99823391437530517578125000000000e-01,
	/*3060*/ -9.99851047992706298828125000000000e-01,
	/*3061*/ -9.99876320362091064453125000000000e-01,
	/*3062*/ -9.99899268150329589843750000000000e-01,
	/*3063*/ -9.99919891357421875000000000000000e-01,
	/*3064*/ -9.99938130378723144531250000000000e-01,
	/*3065*/ -9.99954044818878173828125000000000e-01,
	/*3066*/ -9.99967575073242187500000000000000e-01,
	/*3067*/ -9.99978721141815185546875000000000e-01,
	/*3068*/ -9.99987542629241943359375000000000e-01,
	/*3069*/ -9.99994039535522460937500000000000e-01,
	/*3070*/ -9.99998152256011962890625000000000e-01,
	/*3071*/ -9.99999940395355224609375000000000e-01,
	/*3072*/ -9.99999344348907470703125000000000e-01,
	/*3073*/ -9.99996423721313476562500000000000e-01,
	/*3074*/ -9.99991118907928466796875000000000e-01,
	/*3075*/ -9.99983429908752441406250000000000e-01,
	/*3076*/ -9.99973416328430175781250000000000e-01,
	/*3077*/ -9.99961078166961669921875000000000e-01,
	/*3078*/ -9.99946355819702148437500000000000e-01,
	/*3079*/ -9.99929308891296386718750000000000e-01,
	/*3080*/ -9.99909877777099609375000000000000e-01,
	/*3081*/ -9.99888122081756591796875000000000e-01,
	/*3082*/ -9.99863982200622558593750000000000e-01,
	/*3083*/ -9.99837458133697509765625000000000e-01,
	/*3084*/ -9.99808669090270996093750000000000e-01,
	/*3085*/ -9.99777436256408691406250000000000e-01,
	/*3086*/ -9.99743938446044921875000000000000e-01,
	/*3087*/ -9.99707996845245361328125000000000e-01,
	/*3088*/ -9.99669730663299560546875000000000e-01,
	/*3089*/ -9.99629139900207519531250000000000e-01,
	/*3090*/ -9.99586164951324462890625000000000e-01,
	/*3091*/ -9.99540865421295166015625000000000e-01,
	/*3092*/ -9.99493241310119628906250000000000e-01,
	/*3093*/ -9.99443173408508300781250000000000e-01,
	/*3094*/ -9.99390840530395507812500000000000e-01,
	/*3095*/ -9.99336123466491699218750000000000e-01,
	/*3096*/ -9.99279022216796875000000000000000e-01,
	/*3097*/ -9.99219596385955810546875000000000e-01,
	/*3098*/ -9.99157786369323730468750000000000e-01,
	/*3099*/ -9.99093651771545410156250000000000e-01,
	/*3100*/ -9.99027192592620849609375000000000e-01,
	/*3101*/ -9.98958349227905273437500000000000e-01,
	/*3102*/ -9.98887181282043457031250000000000e-01,
	/*3103*/ -9.98813629150390625000000000000000e-01,
	/*3104*/ -9.98737692832946777343750000000000e-01,
	/*3105*/ -9.98659491539001464843750000000000e-01,
	/*3106*/ -9.98578906059265136718750000000000e-01,
	/*3107*/ -9.98495936393737792968750000000000e-01,
	/*3108*/ -9.98410642147064208984375000000000e-01,
	/*3109*/ -9.98322963714599609375000000000000e-01,
	/*3110*/ -9.98232960700988769531250000000000e-01,
	/*3111*/ -9.98140633106231689453125000000000e-01,
	/*3112*/ -9.98045921325683593750000000000000e-01,
	/*3113*/ -9.97948884963989257812500000000000e-01,
	/*3114*/ -9.97849524021148681640625000000000e-01,
	/*3115*/ -9.97747778892517089843750000000000e-01,
	/*3116*/ -9.97643649578094482421875000000000e-01,
	/*3117*/ -9.97537195682525634765625000000000e-01,
	/*3118*/ -9.97428417205810546875000000000000e-01,
	/*3119*/ -9.97317254543304443359375000000000e-01,
	/*3120*/ -9.97203767299652099609375000000000e-01,
	/*3121*/ -9.97087955474853515625000000000000e-01,
	/*3122*/ -9.96969759464263916015625000000000e-01,
	/*3123*/ -9.96849238872528076171875000000000e-01,
	/*3124*/ -9.96726334095001220703125000000000e-01,
	/*3125*/ -9.96601164340972900390625000000000e-01,
	/*3126*/ -9.96473550796508789062500000000000e-01,
	/*3127*/ -9.96343672275543212890625000000000e-01,
	/*3128*/ -9.96211409568786621093750000000000e-01,
	/*3129*/ -9.96076762676239013671875000000000e-01,
	/*3130*/ -9.95939850807189941406250000000000e-01,
	/*3131*/ -9.95800554752349853515625000000000e-01,
	/*3132*/ -9.95658874511718750000000000000000e-01,
	/*3133*/ -9.95514929294586181640625000000000e-01,
	/*3134*/ -9.95368599891662597656250000000000e-01,
	/*3135*/ -9.95219886302947998046875000000000e-01,
	/*3136*/ -9.95068907737731933593750000000000e-01,
	/*3137*/ -9.94915544986724853515625000000000e-01,
	/*3138*/ -9.94759798049926757812500000000000e-01,
	/*3139*/ -9.94601786136627197265625000000000e-01,
	/*3140*/ -9.94441390037536621093750000000000e-01,
	/*3141*/ -9.94278669357299804687500000000000e-01,
	/*3142*/ -9.94113624095916748046875000000000e-01,
	/*3143*/ -9.93946194648742675781250000000000e-01,
	/*3144*/ -9.93776440620422363281250000000000e-01,
	/*3145*/ -9.93604362010955810546875000000000e-01,
	/*3146*/ -9.93429958820343017578125000000000e-01,
	/*3147*/ -9.93253171443939208984375000000000e-01,
	/*3148*/ -9.93074059486389160156250000000000e-01,
	/*3149*/ -9.92892622947692871093750000000000e-01,
	/*3150*/ -9.92708861827850341796875000000000e-01,
	/*3151*/ -9.92522716522216796875000000000000e-01,
	/*3152*/ -9.92334306240081787109375000000000e-01,
	/*3153*/ -9.92143511772155761718750000000000e-01,
	/*3154*/ -9.91950392723083496093750000000000e-01,
	/*3155*/ -9.91754949092864990234375000000000e-01,
	/*3156*/ -9.91557121276855468750000000000000e-01,
	/*3157*/ -9.91357028484344482421875000000000e-01,
	/*3158*/ -9.91154551506042480468750000000000e-01,
	/*3159*/ -9.90949749946594238281250000000000e-01,
	/*3160*/ -9.90742623805999755859375000000000e-01,
	/*3161*/ -9.90533173084259033203125000000000e-01,
	/*3162*/ -9.90321338176727294921875000000000e-01,
	/*3163*/ -9.90107238292694091796875000000000e-01,
	/*3164*/ -9.89890813827514648437500000000000e-01,
	/*3165*/ -9.89672005176544189453125000000000e-01,
	/*3166*/ -9.89450871944427490234375000000000e-01,
	/*3167*/ -9.89227414131164550781250000000000e-01,
	/*3168*/ -9.89001691341400146484375000000000e-01,
	/*3169*/ -9.88773584365844726562500000000000e-01,
	/*3170*/ -9.88543152809143066406250000000000e-01,
	/*3171*/ -9.88310396671295166015625000000000e-01,
	/*3172*/ -9.88075315952301025390625000000000e-01,
	/*3173*/ -9.87837910652160644531250000000000e-01,
	/*3174*/ -9.87598121166229248046875000000000e-01,
	/*3175*/ -9.87356066703796386718750000000000e-01,
	/*3176*/ -9.87111687660217285156250000000000e-01,
	/*3177*/ -9.86864984035491943359375000000000e-01,
	/*3178*/ -9.86615955829620361328125000000000e-01,
	/*3179*/ -9.86364603042602539062500000000000e-01,
	/*3180*/ -9.86110925674438476562500000000000e-01,
	/*3181*/ -9.85854923725128173828125000000000e-01,
	/*3182*/ -9.85596597194671630859375000000000e-01,
	/*3183*/ -9.85335946083068847656250000000000e-01,
	/*3184*/ -9.85073029994964599609375000000000e-01,
	/*3185*/ -9.84807729721069335937500000000000e-01,
	/*3186*/ -9.84540104866027832031250000000000e-01,
	/*3187*/ -9.84270215034484863281250000000000e-01,
	/*3188*/ -9.83998000621795654296875000000000e-01,
	/*3189*/ -9.83723461627960205078125000000000e-01,
	/*3190*/ -9.83446598052978515625000000000000e-01,
	/*3191*/ -9.83167409896850585937500000000000e-01,
	/*3192*/ -9.82885897159576416015625000000000e-01,
	/*3193*/ -9.82602059841156005859375000000000e-01,
	/*3194*/ -9.82315957546234130859375000000000e-01,
	/*3195*/ -9.82027530670166015625000000000000e-01,
	/*3196*/ -9.81736779212951660156250000000000e-01,
	/*3197*/ -9.81443703174591064453125000000000e-01,
	/*3198*/ -9.81148362159729003906250000000000e-01,
	/*3199*/ -9.80850696563720703125000000000000e-01,
	/*3200*/ -9.80550706386566162109375000000000e-01,
	/*3201*/ -9.80248391628265380859375000000000e-01,
	/*3202*/ -9.79943811893463134765625000000000e-01,
	/*3203*/ -9.79636907577514648437500000000000e-01,
	/*3204*/ -9.79327678680419921875000000000000e-01,
	/*3205*/ -9.79016125202178955078125000000000e-01,
	/*3206*/ -9.78702306747436523437500000000000e-01,
	/*3207*/ -9.78386163711547851562500000000000e-01,
	/*3208*/ -9.78067755699157714843750000000000e-01,
	/*3209*/ -9.77747023105621337890625000000000e-01,
	/*3210*/ -9.77423965930938720703125000000000e-01,
	/*3211*/ -9.77098643779754638671875000000000e-01,
	/*3212*/ -9.76770997047424316406250000000000e-01,
	/*3213*/ -9.76441025733947753906250000000000e-01,
	/*3214*/ -9.76108789443969726562500000000000e-01,
	/*3215*/ -9.75774288177490234375000000000000e-01,
	/*3216*/ -9.75437462329864501953125000000000e-01,
	/*3217*/ -9.75098311901092529296875000000000e-01,
	/*3218*/ -9.74756896495819091796875000000000e-01,
	/*3219*/ -9.74413156509399414062500000000000e-01,
	/*3220*/ -9.74067151546478271484375000000000e-01,
	/*3221*/ -9.73718822002410888671875000000000e-01,
	/*3222*/ -9.73368227481842041015625000000000e-01,
	/*3223*/ -9.73015367984771728515625000000000e-01,
	/*3224*/ -9.72660183906555175781250000000000e-01,
	/*3225*/ -9.72302675247192382812500000000000e-01,
	/*3226*/ -9.71942901611328125000000000000000e-01,
	/*3227*/ -9.71580862998962402343750000000000e-01,
	/*3228*/ -9.71216559410095214843750000000000e-01,
	/*3229*/ -9.70849931240081787109375000000000e-01,
	/*3230*/ -9.70480978488922119140625000000000e-01,
	/*3231*/ -9.70109820365905761718750000000000e-01,
	/*3232*/ -9.69736337661743164062500000000000e-01,
	/*3233*/ -9.69360589981079101562500000000000e-01,
	/*3234*/ -9.68982517719268798828125000000000e-01,
	/*3235*/ -9.68602180480957031250000000000000e-01,
	/*3236*/ -9.68219578266143798828125000000000e-01,
	/*3237*/ -9.67834711074829101562500000000000e-01,
	/*3238*/ -9.67447578907012939453125000000000e-01,
	/*3239*/ -9.67058122158050537109375000000000e-01,
	/*3240*/ -9.66666400432586669921875000000000e-01,
	/*3241*/ -9.66272413730621337890625000000000e-01,
	/*3242*/ -9.65876162052154541015625000000000e-01,
	/*3243*/ -9.65477585792541503906250000000000e-01,
	/*3244*/ -9.65076804161071777343750000000000e-01,
	/*3245*/ -9.64673697948455810546875000000000e-01,
	/*3246*/ -9.64268326759338378906250000000000e-01,
	/*3247*/ -9.63860690593719482421875000000000e-01,
	/*3248*/ -9.63450789451599121093750000000000e-01,
	/*3249*/ -9.63038623332977294921875000000000e-01,
	/*3250*/ -9.62624192237854003906250000000000e-01,
	/*3251*/ -9.62207496166229248046875000000000e-01,
	/*3252*/ -9.61788535118103027343750000000000e-01,
	/*3253*/ -9.61367309093475341796875000000000e-01,
	/*3254*/ -9.60943818092346191406250000000000e-01,
	/*3255*/ -9.60518062114715576171875000000000e-01,
	/*3256*/ -9.60090041160583496093750000000000e-01,
	/*3257*/ -9.59659814834594726562500000000000e-01,
	/*3258*/ -9.59227263927459716796875000000000e-01,
	/*3259*/ -9.58792448043823242187500000000000e-01,
	/*3260*/ -9.58355426788330078125000000000000e-01,
	/*3261*/ -9.57916080951690673828125000000000e-01,
	/*3262*/ -9.57474529743194580078125000000000e-01,
	/*3263*/ -9.57030713558197021484375000000000e-01,
	/*3264*/ -9.56584632396697998046875000000000e-01,
	/*3265*/ -9.56136345863342285156250000000000e-01,
	/*3266*/ -9.55685734748840332031250000000000e-01,
	/*3267*/ -9.55232918262481689453125000000000e-01,
	/*3268*/ -9.54777896404266357421875000000000e-01,
	/*3269*/ -9.54320549964904785156250000000000e-01,
	/*3270*/ -9.53860998153686523437500000000000e-01,
	/*3271*/ -9.53399181365966796875000000000000e-01,
	/*3272*/ -9.52935099601745605468750000000000e-01,
	/*3273*/ -9.52468812465667724609375000000000e-01,
	/*3274*/ -9.52000260353088378906250000000000e-01,
	/*3275*/ -9.51529502868652343750000000000000e-01,
	/*3276*/ -9.51056480407714843750000000000000e-01,
	/*3277*/ -9.50581192970275878906250000000000e-01,
	/*3278*/ -9.50103700160980224609375000000000e-01,
	/*3279*/ -9.49624001979827880859375000000000e-01,
	/*3280*/ -9.49141979217529296875000000000000e-01,
	/*3281*/ -9.48657810688018798828125000000000e-01,
	/*3282*/ -9.48171377182006835937500000000000e-01,
	/*3283*/ -9.47682678699493408203125000000000e-01,
	/*3284*/ -9.47191774845123291015625000000000e-01,
	/*3285*/ -9.46698665618896484375000000000000e-01,
	/*3286*/ -9.46203291416168212890625000000000e-01,
	/*3287*/ -9.45705711841583251953125000000000e-01,
	/*3288*/ -9.45205867290496826171875000000000e-01,
	/*3289*/ -9.44703876972198486328125000000000e-01,
	/*3290*/ -9.44199562072753906250000000000000e-01,
	/*3291*/ -9.43693101406097412109375000000000e-01,
	/*3292*/ -9.43184375762939453125000000000000e-01,
	/*3293*/ -9.42673444747924804687500000000000e-01,
	/*3294*/ -9.42160308361053466796875000000000e-01,
	/*3295*/ -9.41644966602325439453125000000000e-01,
	/*3296*/ -9.41127359867095947265625000000000e-01,
	/*3297*/ -9.40607547760009765625000000000000e-01,
	/*3298*/ -9.40085530281066894531250000000000e-01,
	/*3299*/ -9.39561307430267333984375000000000e-01,
	/*3300*/ -9.39034879207611083984375000000000e-01,
	/*3301*/ -9.38506245613098144531250000000000e-01,
	/*3302*/ -9.37975347042083740234375000000000e-01,
	/*3303*/ -9.37442302703857421875000000000000e-01,
	/*3304*/ -9.36906993389129638671875000000000e-01,
	/*3305*/ -9.36369538307189941406250000000000e-01,
	/*3306*/ -9.35829877853393554687500000000000e-01,
	/*3307*/ -9.35287952423095703125000000000000e-01,
	/*3308*/ -9.34743881225585937500000000000000e-01,
	/*3309*/ -9.34197604656219482421875000000000e-01,
	/*3310*/ -9.33649122714996337890625000000000e-01,
	/*3311*/ -9.33098435401916503906250000000000e-01,
	/*3312*/ -9.32545542716979980468750000000000e-01,
	/*3313*/ -9.31990444660186767578125000000000e-01,
	/*3314*/ -9.31433141231536865234375000000000e-01,
	/*3315*/ -9.30873692035675048828125000000000e-01,
	/*3316*/ -9.30312037467956542968750000000000e-01,
	/*3317*/ -9.29748177528381347656250000000000e-01,
	/*3318*/ -9.29182171821594238281250000000000e-01,
	/*3319*/ -9.28613960742950439453125000000000e-01,
	/*3320*/ -9.28043544292449951171875000000000e-01,
	/*3321*/ -9.27470922470092773437500000000000e-01,
	/*3322*/ -9.26896154880523681640625000000000e-01,
	/*3323*/ -9.26319181919097900390625000000000e-01,
	/*3324*/ -9.25740063190460205078125000000000e-01,
	/*3325*/ -9.25158739089965820312500000000000e-01,
	/*3326*/ -9.24575209617614746093750000000000e-01,
	/*3327*/ -9.23989534378051757812500000000000e-01,
	/*3328*/ -9.23401713371276855468750000000000e-01,
	/*3329*/ -9.22811686992645263671875000000000e-01,
	/*3330*/ -9.22219455242156982421875000000000e-01,
	/*3331*/ -9.21625077724456787109375000000000e-01,
	/*3332*/ -9.21028554439544677734375000000000e-01,
	/*3333*/ -9.20429825782775878906250000000000e-01,
	/*3334*/ -9.19828951358795166015625000000000e-01,
	/*3335*/ -9.19225931167602539062500000000000e-01,
	/*3336*/ -9.18620705604553222656250000000000e-01,
	/*3337*/ -9.18013334274291992187500000000000e-01,
	/*3338*/ -9.17403817176818847656250000000000e-01,
	/*3339*/ -9.16792154312133789062500000000000e-01,
	/*3340*/ -9.16178286075592041015625000000000e-01,
	/*3341*/ -9.15562272071838378906250000000000e-01,
	/*3342*/ -9.14944112300872802734375000000000e-01,
	/*3343*/ -9.14323806762695312500000000000000e-01,
	/*3344*/ -9.13701355457305908203125000000000e-01,
	/*3345*/ -9.13076758384704589843750000000000e-01,
	/*3346*/ -9.12449955940246582031250000000000e-01,
	/*3347*/ -9.11821067333221435546875000000000e-01,
	/*3348*/ -9.11189973354339599609375000000000e-01,
	/*3349*/ -9.10556793212890625000000000000000e-01,
	/*3350*/ -9.09921467304229736328125000000000e-01,
	/*3351*/ -9.09283936023712158203125000000000e-01,
	/*3352*/ -9.08644318580627441406250000000000e-01,
	/*3353*/ -9.08002555370330810546875000000000e-01,
	/*3354*/ -9.07358646392822265625000000000000e-01,
	/*3355*/ -9.06712591648101806640625000000000e-01,
	/*3356*/ -9.06064391136169433593750000000000e-01,
	/*3357*/ -9.05414104461669921875000000000000e-01,
	/*3358*/ -9.04761672019958496093750000000000e-01,
	/*3359*/ -9.04107093811035156250000000000000e-01,
	/*3360*/ -9.03450369834899902343750000000000e-01,
	/*3361*/ -9.02791559696197509765625000000000e-01,
	/*3362*/ -9.02130603790283203125000000000000e-01,
	/*3363*/ -9.01467502117156982421875000000000e-01,
	/*3364*/ -9.00802314281463623046875000000000e-01,
	/*3365*/ -9.00134980678558349609375000000000e-01,
	/*3366*/ -8.99465560913085937500000000000000e-01,
	/*3367*/ -8.98793995380401611328125000000000e-01,
	/*3368*/ -8.98120343685150146484375000000000e-01,
	/*3369*/ -8.97444546222686767578125000000000e-01,
	/*3370*/ -8.96766602993011474609375000000000e-01,
	/*3371*/ -8.96086633205413818359375000000000e-01,
	/*3372*/ -8.95404458045959472656250000000000e-01,
	/*3373*/ -8.94720256328582763671875000000000e-01,
	/*3374*/ -8.94033908843994140625000000000000e-01,
	/*3375*/ -8.93345475196838378906250000000000e-01,
	/*3376*/ -8.92654955387115478515625000000000e-01,
	/*3377*/ -8.91962289810180664062500000000000e-01,
	/*3378*/ -8.91267538070678710937500000000000e-01,
	/*3379*/ -8.90570700168609619140625000000000e-01,
	/*3380*/ -8.89871776103973388671875000000000e-01,
	/*3381*/ -8.89170706272125244140625000000000e-01,
	/*3382*/ -8.88467609882354736328125000000000e-01,
	/*3383*/ -8.87762367725372314453125000000000e-01,
	/*3384*/ -8.87055039405822753906250000000000e-01,
	/*3385*/ -8.86345624923706054687500000000000e-01,
	/*3386*/ -8.85634183883666992187500000000000e-01,
	/*3387*/ -8.84920597076416015625000000000000e-01,
	/*3388*/ -8.84204924106597900390625000000000e-01,
	/*3389*/ -8.83487224578857421875000000000000e-01,
	/*3390*/ -8.82767379283905029296875000000000e-01,
	/*3391*/ -8.82045507431030273437500000000000e-01,
	/*3392*/ -8.81321489810943603515625000000000e-01,
	/*3393*/ -8.80595445632934570312500000000000e-01,
	/*3394*/ -8.79867374897003173828125000000000e-01,
	/*3395*/ -8.79137158393859863281250000000000e-01,
	/*3396*/ -8.78404915332794189453125000000000e-01,
	/*3397*/ -8.77670586109161376953125000000000e-01,
	/*3398*/ -8.76934170722961425781250000000000e-01,
	/*3399*/ -8.76195728778839111328125000000000e-01,
	/*3400*/ -8.75455200672149658203125000000000e-01,
	/*3401*/ -8.74712586402893066406250000000000e-01,
	/*3402*/ -8.73967945575714111328125000000000e-01,
	/*3403*/ -8.73221278190612792968750000000000e-01,
	/*3404*/ -8.72472524642944335937500000000000e-01,
	/*3405*/ -8.71721684932708740234375000000000e-01,
	/*3406*/ -8.70968818664550781250000000000000e-01,
	/*3407*/ -8.70213925838470458984375000000000e-01,
	/*3408*/ -8.69456946849822998046875000000000e-01,
	/*3409*/ -8.68697941303253173828125000000000e-01,
	/*3410*/ -8.67936909198760986328125000000000e-01,
	/*3411*/ -8.67173790931701660156250000000000e-01,
	/*3412*/ -8.66408646106719970703125000000000e-01,
	/*3413*/ -8.65641474723815917968750000000000e-01,
	/*3414*/ -8.64872276782989501953125000000000e-01,
	/*3415*/ -8.64101052284240722656250000000000e-01,
	/*3416*/ -8.63327741622924804687500000000000e-01,
	/*3417*/ -8.62552404403686523437500000000000e-01,
	/*3418*/ -8.61775100231170654296875000000000e-01,
	/*3419*/ -8.60995709896087646484375000000000e-01,
	/*3420*/ -8.60214293003082275390625000000000e-01,
	/*3421*/ -8.59430849552154541015625000000000e-01,
	/*3422*/ -8.58645379543304443359375000000000e-01,
	/*3423*/ -8.57857942581176757812500000000000e-01,
	/*3424*/ -8.57068419456481933593750000000000e-01,
	/*3425*/ -8.56276929378509521484375000000000e-01,
	/*3426*/ -8.55483412742614746093750000000000e-01,
	/*3427*/ -8.54687869548797607421875000000000e-01,
	/*3428*/ -8.53890299797058105468750000000000e-01,
	/*3429*/ -8.53090703487396240234375000000000e-01,
	/*3430*/ -8.52289140224456787109375000000000e-01,
	/*3431*/ -8.51485610008239746093750000000000e-01,
	/*3432*/ -8.50679993629455566406250000000000e-01,
	/*3433*/ -8.49872410297393798828125000000000e-01,
	/*3434*/ -8.49062800407409667968750000000000e-01,
	/*3435*/ -8.48251223564147949218750000000000e-01,
	/*3436*/ -8.47437679767608642578125000000000e-01,
	/*3437*/ -8.46622049808502197265625000000000e-01,
	/*3438*/ -8.45804512500762939453125000000000e-01,
	/*3439*/ -8.44984948635101318359375000000000e-01,
	/*3440*/ -8.44163358211517333984375000000000e-01,
	/*3441*/ -8.43339860439300537109375000000000e-01,
	/*3442*/ -8.42514336109161376953125000000000e-01,
	/*3443*/ -8.41686785221099853515625000000000e-01,
	/*3444*/ -8.40857326984405517578125000000000e-01,
	/*3445*/ -8.40025842189788818359375000000000e-01,
	/*3446*/ -8.39192390441894531250000000000000e-01,
	/*3447*/ -8.38356971740722656250000000000000e-01,
	/*3448*/ -8.37519586086273193359375000000000e-01,
	/*3449*/ -8.36680233478546142578125000000000e-01,
	/*3450*/ -8.35838854312896728515625000000000e-01,
	/*3451*/ -8.34995567798614501953125000000000e-01,
	/*3452*/ -8.34150314331054687500000000000000e-01,
	/*3453*/ -8.33303034305572509765625000000000e-01,
	/*3454*/ -8.32453846931457519531250000000000e-01,
	/*3455*/ -8.31602692604064941406250000000000e-01,
	/*3456*/ -8.30749571323394775390625000000000e-01,
	/*3457*/ -8.29894542694091796875000000000000e-01,
	/*3458*/ -8.29037487506866455078125000000000e-01,
	/*3459*/ -8.28178524971008300781250000000000e-01,
	/*3460*/ -8.27317595481872558593750000000000e-01,
	/*3461*/ -8.26454699039459228515625000000000e-01,
	/*3462*/ -8.25589895248413085937500000000000e-01,
	/*3463*/ -8.24723124504089355468750000000000e-01,
	/*3464*/ -8.23854446411132812500000000000000e-01,
	/*3465*/ -8.22983801364898681640625000000000e-01,
	/*3466*/ -8.22111189365386962890625000000000e-01,
	/*3467*/ -8.21236670017242431640625000000000e-01,
	/*3468*/ -8.20360243320465087890625000000000e-01,
	/*3469*/ -8.19481849670410156250000000000000e-01,
	/*3470*/ -8.18601548671722412109375000000000e-01,
	/*3471*/ -8.17719280719757080078125000000000e-01,
	/*3472*/ -8.16835165023803710937500000000000e-01,
	/*3473*/ -8.15949082374572753906250000000000e-01,
	/*3474*/ -8.15061032772064208984375000000000e-01,
	/*3475*/ -8.14171135425567626953125000000000e-01,
	/*3476*/ -8.13279271125793457031250000000000e-01,
	/*3477*/ -8.12385499477386474609375000000000e-01,
	/*3478*/ -8.11489880084991455078125000000000e-01,
	/*3479*/ -8.10592293739318847656250000000000e-01,
	/*3480*/ -8.09692800045013427734375000000000e-01,
	/*3481*/ -8.08791399002075195312500000000000e-01,
	/*3482*/ -8.07888090610504150390625000000000e-01,
	/*3483*/ -8.06982874870300292968750000000000e-01,
	/*3484*/ -8.06075811386108398437500000000000e-01,
	/*3485*/ -8.05166780948638916015625000000000e-01,
	/*3486*/ -8.04255902767181396484375000000000e-01,
	/*3487*/ -8.03343117237091064453125000000000e-01,
	/*3488*/ -8.02428424358367919921875000000000e-01,
	/*3489*/ -8.01511883735656738281250000000000e-01,
	/*3490*/ -8.00593376159667968750000000000000e-01,
	/*3491*/ -7.99673080444335937500000000000000e-01,
	/*3492*/ -7.98750817775726318359375000000000e-01,
	/*3493*/ -7.97826707363128662109375000000000e-01,
	/*3494*/ -7.96900749206542968750000000000000e-01,
	/*3495*/ -7.95972883701324462890625000000000e-01,
	/*3496*/ -7.95043170452117919921875000000000e-01,
	/*3497*/ -7.94111549854278564453125000000000e-01,
	/*3498*/ -7.93178081512451171875000000000000e-01,
	/*3499*/ -7.92242765426635742187500000000000e-01,
	/*3500*/ -7.91305541992187500000000000000000e-01,
	/*3501*/ -7.90366470813751220703125000000000e-01,
	/*3502*/ -7.89425551891326904296875000000000e-01,
	/*3503*/ -7.88482785224914550781250000000000e-01,
	/*3504*/ -7.87538111209869384765625000000000e-01,
	/*3505*/ -7.86591589450836181640625000000000e-01,
	/*3506*/ -7.85643279552459716796875000000000e-01,
	/*3507*/ -7.84693062305450439453125000000000e-01,
	/*3508*/ -7.83740997314453125000000000000000e-01,
	/*3509*/ -7.82787144184112548828125000000000e-01,
	/*3510*/ -7.81831383705139160156250000000000e-01,
	/*3511*/ -7.80873835086822509765625000000000e-01,
	/*3512*/ -7.79914438724517822265625000000000e-01,
	/*3513*/ -7.78953135013580322265625000000000e-01,
	/*3514*/ -7.77990102767944335937500000000000e-01,
	/*3515*/ -7.77025163173675537109375000000000e-01,
	/*3516*/ -7.76058435440063476562500000000000e-01,
	/*3517*/ -7.75089859962463378906250000000000e-01,
	/*3518*/ -7.74119436740875244140625000000000e-01,
	/*3519*/ -7.73147225379943847656250000000000e-01,
	/*3520*/ -7.72173166275024414062500000000000e-01,
	/*3521*/ -7.71197319030761718750000000000000e-01,
	/*3522*/ -7.70219683647155761718750000000000e-01,
	/*3523*/ -7.69240200519561767578125000000000e-01,
	/*3524*/ -7.68258869647979736328125000000000e-01,
	/*3525*/ -7.67275750637054443359375000000000e-01,
	/*3526*/ -7.66290843486785888671875000000000e-01,
	/*3527*/ -7.65304148197174072265625000000000e-01,
	/*3528*/ -7.64315605163574218750000000000000e-01,
	/*3529*/ -7.63325333595275878906250000000000e-01,
	/*3530*/ -7.62333214282989501953125000000000e-01,
	/*3531*/ -7.61339306831359863281250000000000e-01,
	/*3532*/ -7.60343611240386962890625000000000e-01,
	/*3533*/ -7.59346127510070800781250000000000e-01,
	/*3534*/ -7.58346796035766601562500000000000e-01,
	/*3535*/ -7.57345736026763916015625000000000e-01,
	/*3536*/ -7.56342887878417968750000000000000e-01,
	/*3537*/ -7.55338311195373535156250000000000e-01,
	/*3538*/ -7.54331886768341064453125000000000e-01,
	/*3539*/ -7.53323674201965332031250000000000e-01,
	/*3540*/ -7.52313733100891113281250000000000e-01,
	/*3541*/ -7.51302003860473632812500000000000e-01,
	/*3542*/ -7.50288546085357666015625000000000e-01,
	/*3543*/ -7.49273240566253662109375000000000e-01,
	/*3544*/ -7.48256206512451171875000000000000e-01,
	/*3545*/ -7.47237443923950195312500000000000e-01,
	/*3546*/ -7.46216893196105957031250000000000e-01,
	/*3547*/ -7.45194613933563232421875000000000e-01,
	/*3548*/ -7.44170546531677246093750000000000e-01,
	/*3549*/ -7.43144750595092773437500000000000e-01,
	/*3550*/ -7.42117166519165039062500000000000e-01,
	/*3551*/ -7.41087853908538818359375000000000e-01,
	/*3552*/ -7.40056812763214111328125000000000e-01,
	/*3553*/ -7.39024043083190917968750000000000e-01,
	/*3554*/ -7.37989485263824462890625000000000e-01,
	/*3555*/ -7.36953198909759521484375000000000e-01,
	/*3556*/ -7.35915243625640869140625000000000e-01,
	/*3557*/ -7.34875500202178955078125000000000e-01,
	/*3558*/ -7.33834028244018554687500000000000e-01,
	/*3559*/ -7.32790827751159667968750000000000e-01,
	/*3560*/ -7.31745898723602294921875000000000e-01,
	/*3561*/ -7.30699241161346435546875000000000e-01,
	/*3562*/ -7.29650914669036865234375000000000e-01,
	/*3563*/ -7.28600800037384033203125000000000e-01,
	/*3564*/ -7.27549016475677490234375000000000e-01,
	/*3565*/ -7.26495504379272460937500000000000e-01,
	/*3566*/ -7.25440263748168945312500000000000e-01,
	/*3567*/ -7.24383354187011718750000000000000e-01,
	/*3568*/ -7.23324716091156005859375000000000e-01,
	/*3569*/ -7.22264409065246582031250000000000e-01,
	/*3570*/ -7.21202373504638671875000000000000e-01,
	/*3571*/ -7.20138609409332275390625000000000e-01,
	/*3572*/ -7.19073176383972167968750000000000e-01,
	/*3573*/ -7.18006074428558349609375000000000e-01,
	/*3574*/ -7.16937243938446044921875000000000e-01,
	/*3575*/ -7.15866744518280029296875000000000e-01,
	/*3576*/ -7.14794576168060302734375000000000e-01,
	/*3577*/ -7.13720679283142089843750000000000e-01,
	/*3578*/ -7.12645173072814941406250000000000e-01,
	/*3579*/ -7.11567938327789306640625000000000e-01,
	/*3580*/ -7.10489034652709960937500000000000e-01,
	/*3581*/ -7.09408462047576904296875000000000e-01,
	/*3582*/ -7.08326220512390136718750000000000e-01,
	/*3583*/ -7.07242310047149658203125000000000e-01,
	/*3584*/ -7.06156730651855468750000000000000e-01,
	/*3585*/ -7.05069482326507568359375000000000e-01,
	/*3586*/ -7.03980565071105957031250000000000e-01,
	/*3587*/ -7.02890038490295410156250000000000e-01,
	/*3588*/ -7.01797783374786376953125000000000e-01,
	/*3589*/ -7.00703918933868408203125000000000e-01,
	/*3590*/ -6.99608445167541503906250000000000e-01,
	/*3591*/ -6.98511242866516113281250000000000e-01,
	/*3592*/ -6.97412431240081787109375000000000e-01,
	/*3593*/ -6.96312010288238525390625000000000e-01,
	/*3594*/ -6.95209920406341552734375000000000e-01,
	/*3595*/ -6.94106221199035644531250000000000e-01,
	/*3596*/ -6.93000853061676025390625000000000e-01,
	/*3597*/ -6.91893875598907470703125000000000e-01,
	/*3598*/ -6.90785229206085205078125000000000e-01,
	/*3599*/ -6.89674973487854003906250000000000e-01,
	/*3600*/ -6.88563108444213867187500000000000e-01,
	/*3601*/ -6.87449634075164794921875000000000e-01,
	/*3602*/ -6.86334550380706787109375000000000e-01,
	/*3603*/ -6.85217797756195068359375000000000e-01,
	/*3604*/ -6.84099495410919189453125000000000e-01,
	/*3605*/ -6.82979524135589599609375000000000e-01,
	/*3606*/ -6.81858003139495849609375000000000e-01,
	/*3607*/ -6.80734813213348388671875000000000e-01,
	/*3608*/ -6.79610073566436767578125000000000e-01,
	/*3609*/ -6.78483664989471435546875000000000e-01,
	/*3610*/ -6.77355706691741943359375000000000e-01,
	/*3611*/ -6.76226198673248291015625000000000e-01,
	/*3612*/ -6.75095021724700927734375000000000e-01,
	/*3613*/ -6.73962295055389404296875000000000e-01,
	/*3614*/ -6.72827959060668945312500000000000e-01,
	/*3615*/ -6.71692073345184326171875000000000e-01,
	/*3616*/ -6.70554578304290771484375000000000e-01,
	/*3617*/ -6.69415533542633056640625000000000e-01,
	/*3618*/ -6.68274879455566406250000000000000e-01,
	/*3619*/ -6.67132675647735595703125000000000e-01,
	/*3620*/ -6.65988862514495849609375000000000e-01,
	/*3621*/ -6.64843499660491943359375000000000e-01,
	/*3622*/ -6.63696587085723876953125000000000e-01,
	/*3623*/ -6.62548124790191650390625000000000e-01,
	/*3624*/ -6.61398053169250488281250000000000e-01,
	/*3625*/ -6.60246491432189941406250000000000e-01,
	/*3626*/ -6.59093320369720458984375000000000e-01,
	/*3627*/ -6.57938599586486816406250000000000e-01,
	/*3628*/ -6.56782388687133789062500000000000e-01,
	/*3629*/ -6.55624568462371826171875000000000e-01,
	/*3630*/ -6.54465198516845703125000000000000e-01,
	/*3631*/ -6.53304338455200195312500000000000e-01,
	/*3632*/ -6.52141928672790527343750000000000e-01,
	/*3633*/ -6.50977969169616699218750000000000e-01,
	/*3634*/ -6.49812459945678710937500000000000e-01,
	/*3635*/ -6.48645460605621337890625000000000e-01,
	/*3636*/ -6.47476911544799804687500000000000e-01,
	/*3637*/ -6.46306812763214111328125000000000e-01,
	/*3638*/ -6.45135223865509033203125000000000e-01,
	/*3639*/ -6.43962144851684570312500000000000e-01,
	/*3640*/ -6.42787516117095947265625000000000e-01,
	/*3641*/ -6.41611337661743164062500000000000e-01,
	/*3642*/ -6.40433728694915771484375000000000e-01,
	/*3643*/ -6.39254570007324218750000000000000e-01,
	/*3644*/ -6.38073861598968505859375000000000e-01,
	/*3645*/ -6.36891722679138183593750000000000e-01,
	/*3646*/ -6.35708034038543701171875000000000e-01,
	/*3647*/ -6.34522914886474609375000000000000e-01,
	/*3648*/ -6.33336246013641357421875000000000e-01,
	/*3649*/ -6.32148087024688720703125000000000e-01,
	/*3650*/ -6.30958437919616699218750000000000e-01,
	/*3651*/ -6.29767358303070068359375000000000e-01,
	/*3652*/ -6.28574728965759277343750000000000e-01,
	/*3653*/ -6.27380669116973876953125000000000e-01,
	/*3654*/ -6.26185059547424316406250000000000e-01,
	/*3655*/ -6.24988079071044921875000000000000e-01,
	/*3656*/ -6.23789548873901367187500000000000e-01,
	/*3657*/ -6.22589588165283203125000000000000e-01,
	/*3658*/ -6.21388137340545654296875000000000e-01,
	/*3659*/ -6.20185256004333496093750000000000e-01,
	/*3660*/ -6.18980884552001953125000000000000e-01,
	/*3661*/ -6.17775022983551025390625000000000e-01,
	/*3662*/ -6.16567790508270263671875000000000e-01,
	/*3663*/ -6.15359067916870117187500000000000e-01,
	/*3664*/ -6.14148855209350585937500000000000e-01,
	/*3665*/ -6.12937271595001220703125000000000e-01,
	/*3666*/ -6.11724197864532470703125000000000e-01,
	/*3667*/ -6.10509693622589111328125000000000e-01,
	/*3668*/ -6.09293758869171142578125000000000e-01,
	/*3669*/ -6.08076393604278564453125000000000e-01,
	/*3670*/ -6.06857538223266601562500000000000e-01,
	/*3671*/ -6.05637311935424804687500000000000e-01,
	/*3672*/ -6.04415655136108398437500000000000e-01,
	/*3673*/ -6.03192567825317382812500000000000e-01,
	/*3674*/ -6.01968050003051757812500000000000e-01,
	/*3675*/ -6.00742161273956298828125000000000e-01,
	/*3676*/ -5.99514842033386230468750000000000e-01,
	/*3677*/ -5.98286092281341552734375000000000e-01,
	/*3678*/ -5.97055912017822265625000000000000e-01,
	/*3679*/ -5.95824360847473144531250000000000e-01,
	/*3680*/ -5.94591379165649414062500000000000e-01,
	/*3681*/ -5.93357026576995849609375000000000e-01,
	/*3682*/ -5.92121243476867675781250000000000e-01,
	/*3683*/ -5.90884089469909667968750000000000e-01,
	/*3684*/ -5.89645564556121826171875000000000e-01,
	/*3685*/ -5.88405609130859375000000000000000e-01,
	/*3686*/ -5.87164282798767089843750000000000e-01,
	/*3687*/ -5.85921585559844970703125000000000e-01,
	/*3688*/ -5.84677517414093017578125000000000e-01,
	/*3689*/ -5.83432078361511230468750000000000e-01,
	/*3690*/ -5.82185208797454833984375000000000e-01,
	/*3691*/ -5.80937027931213378906250000000000e-01,
	/*3692*/ -5.79687476158142089843750000000000e-01,
	/*3693*/ -5.78436553478240966796875000000000e-01,
	/*3694*/ -5.77184200286865234375000000000000e-01,
	/*3695*/ -5.75930595397949218750000000000000e-01,
	/*3696*/ -5.74675559997558593750000000000000e-01,
	/*3697*/ -5.73419213294982910156250000000000e-01,
	/*3698*/ -5.72161495685577392578125000000000e-01,
	/*3699*/ -5.70902407169342041015625000000000e-01,
	/*3700*/ -5.69642007350921630859375000000000e-01,
	/*3701*/ -5.68380296230316162109375000000000e-01,
	/*3702*/ -5.67117214202880859375000000000000e-01,
	/*3703*/ -5.65852761268615722656250000000000e-01,
	/*3704*/ -5.64586997032165527343750000000000e-01,
	/*3705*/ -5.63319921493530273437500000000000e-01,
	/*3706*/ -5.62051534652709960937500000000000e-01,
	/*3707*/ -5.60781776905059814453125000000000e-01,
	/*3708*/ -5.59510767459869384765625000000000e-01,
	/*3709*/ -5.58238387107849121093750000000000e-01,
	/*3710*/ -5.56964695453643798828125000000000e-01,
	/*3711*/ -5.55689692497253417968750000000000e-01,
	/*3712*/ -5.54413437843322753906250000000000e-01,
	/*3713*/ -5.53135812282562255859375000000000e-01,
	/*3714*/ -5.51856875419616699218750000000000e-01,
	/*3715*/ -5.50576686859130859375000000000000e-01,
	/*3716*/ -5.49295186996459960937500000000000e-01,
	/*3717*/ -5.48012375831604003906250000000000e-01,
	/*3718*/ -5.46728312969207763671875000000000e-01,
	/*3719*/ -5.45442938804626464843750000000000e-01,
	/*3720*/ -5.44156253337860107421875000000000e-01,
	/*3721*/ -5.42868316173553466796875000000000e-01,
	/*3722*/ -5.41579127311706542968750000000000e-01,
	/*3723*/ -5.40288627147674560546875000000000e-01,
	/*3724*/ -5.38996875286102294921875000000000e-01,
	/*3725*/ -5.37703812122344970703125000000000e-01,
	/*3726*/ -5.36409497261047363281250000000000e-01,
	/*3727*/ -5.35113930702209472656250000000000e-01,
	/*3728*/ -5.33817112445831298828125000000000e-01,
	/*3729*/ -5.32519042491912841796875000000000e-01,
	/*3730*/ -5.31219720840454101562500000000000e-01,
	/*3731*/ -5.29919147491455078125000000000000e-01,
	/*3732*/ -5.28617322444915771484375000000000e-01,
	/*3733*/ -5.27314245700836181640625000000000e-01,
	/*3734*/ -5.26009917259216308593750000000000e-01,
	/*3735*/ -5.24704337120056152343750000000000e-01,
	/*3736*/ -5.23397564888000488281250000000000e-01,
	/*3737*/ -5.22089540958404541015625000000000e-01,
	/*3738*/ -5.20780324935913085937500000000000e-01,
	/*3739*/ -5.19469797611236572265625000000000e-01,
	/*3740*/ -5.18158137798309326171875000000000e-01,
	/*3741*/ -5.16845226287841796875000000000000e-01,
	/*3742*/ -5.15531063079833984375000000000000e-01,
	/*3743*/ -5.14215707778930664062500000000000e-01,
	/*3744*/ -5.12899160385131835937500000000000e-01,
	/*3745*/ -5.11581361293792724609375000000000e-01,
	/*3746*/ -5.10262429714202880859375000000000e-01,
	/*3747*/ -5.08942246437072753906250000000000e-01,
	/*3748*/ -5.07620871067047119140625000000000e-01,
	/*3749*/ -5.06298303604125976562500000000000e-01,
	/*3750*/ -5.04974544048309326171875000000000e-01,
	/*3751*/ -5.03649592399597167968750000000000e-01,
	/*3752*/ -5.02323448657989501953125000000000e-01,
	/*3753*/ -5.00996112823486328125000000000000e-01,
	/*3754*/ -4.99667644500732421875000000000000e-01,
	/*3755*/ -4.98337954282760620117187500000000e-01,
	/*3756*/ -4.97007131576538085937500000000000e-01,
	/*3757*/ -4.95675116777420043945312500000000e-01,
	/*3758*/ -4.94341909885406494140625000000000e-01,
	/*3759*/ -4.93007570505142211914062500000000e-01,
	/*3760*/ -4.91672068834304809570312500000000e-01,
	/*3761*/ -4.90335404872894287109375000000000e-01,
	/*3762*/ -4.88997578620910644531250000000000e-01,
	/*3763*/ -4.87658619880676269531250000000000e-01,
	/*3764*/ -4.86318498849868774414062500000000e-01,
	/*3765*/ -4.84977245330810546875000000000000e-01,
	/*3766*/ -4.83634829521179199218750000000000e-01,
	/*3767*/ -4.82291281223297119140625000000000e-01,
	/*3768*/ -4.80946600437164306640625000000000e-01,
	/*3769*/ -4.79600787162780761718750000000000e-01,
	/*3770*/ -4.78253841400146484375000000000000e-01,
	/*3771*/ -4.76905792951583862304687500000000e-01,
	/*3772*/ -4.75556582212448120117187500000000e-01,
	/*3773*/ -4.74206298589706420898437500000000e-01,
	/*3774*/ -4.72854852676391601562500000000000e-01,
	/*3775*/ -4.71502333879470825195312500000000e-01,
	/*3776*/ -4.70148682594299316406250000000000e-01,
	/*3777*/ -4.68793928623199462890625000000000e-01,
	/*3778*/ -4.67438071966171264648437500000000e-01,
	/*3779*/ -4.66081112623214721679687500000000e-01,
	/*3780*/ -4.64723050594329833984375000000000e-01,
	/*3781*/ -4.63363885879516601562500000000000e-01,
	/*3782*/ -4.62003648281097412109375000000000e-01,
	/*3783*/ -4.60642307996749877929687500000000e-01,
	/*3784*/ -4.59279894828796386718750000000000e-01,
	/*3785*/ -4.57916408777236938476562500000000e-01,
	/*3786*/ -4.56551849842071533203125000000000e-01,
	/*3787*/ -4.55186188220977783203125000000000e-01,
	/*3788*/ -4.53819483518600463867187500000000e-01,
	/*3789*/ -4.52451676130294799804687500000000e-01,
	/*3790*/ -4.51082825660705566406250000000000e-01,
	/*3791*/ -4.49712902307510375976562500000000e-01,
	/*3792*/ -4.48341935873031616210937500000000e-01,
	/*3793*/ -4.46969896554946899414062500000000e-01,
	/*3794*/ -4.45596843957901000976562500000000e-01,
	/*3795*/ -4.44222688674926757812500000000000e-01,
	/*3796*/ -4.42847520112991333007812500000000e-01,
	/*3797*/ -4.41471308469772338867187500000000e-01,
	/*3798*/ -4.40094053745269775390625000000000e-01,
	/*3799*/ -4.38715755939483642578125000000000e-01,
	/*3800*/ -4.37336415052413940429687500000000e-01,
	/*3801*/ -4.35956060886383056640625000000000e-01,
	/*3802*/ -4.34574693441390991210937500000000e-01,
	/*3803*/ -4.33192282915115356445312500000000e-01,
	/*3804*/ -4.31808859109878540039062500000000e-01,
	/*3805*/ -4.30424392223358154296875000000000e-01,
	/*3806*/ -4.29038941860198974609375000000000e-01,
	/*3807*/ -4.27652478218078613281250000000000e-01,
	/*3808*/ -4.26265001296997070312500000000000e-01,
	/*3809*/ -4.24876540899276733398437500000000e-01,
	/*3810*/ -4.23487067222595214843750000000000e-01,
	/*3811*/ -4.22096580266952514648437500000000e-01,
	/*3812*/ -4.20705109834671020507812500000000e-01,
	/*3813*/ -4.19312655925750732421875000000000e-01,
	/*3814*/ -4.17919218540191650390625000000000e-01,
	/*3815*/ -4.16524797677993774414062500000000e-01,
	/*3816*/ -4.15129363536834716796875000000000e-01,
	/*3817*/ -4.13732975721359252929687500000000e-01,
	/*3818*/ -4.12335634231567382812500000000000e-01,
	/*3819*/ -4.10937309265136718750000000000000e-01,
	/*3820*/ -4.09538000822067260742187500000000e-01,
	/*3821*/ -4.08137738704681396484375000000000e-01,
	/*3822*/ -4.06736522912979125976562500000000e-01,
	/*3823*/ -4.05334323644638061523437500000000e-01,
	/*3824*/ -4.03931200504302978515625000000000e-01,
	/*3825*/ -4.02527093887329101562500000000000e-01,
	/*3826*/ -4.01122063398361206054687500000000e-01,
	/*3827*/ -3.99716079235076904296875000000000e-01,
	/*3828*/ -3.98309171199798583984375000000000e-01,
	/*3829*/ -3.96901309490203857421875000000000e-01,
	/*3830*/ -3.95492523908615112304687500000000e-01,
	/*3831*/ -3.94082784652709960937500000000000e-01,
	/*3832*/ -3.92672151327133178710937500000000e-01,
	/*3833*/ -3.91260564327239990234375000000000e-01,
	/*3834*/ -3.89848083257675170898437500000000e-01,
	/*3835*/ -3.88434648513793945312500000000000e-01,
	/*3836*/ -3.87020319700241088867187500000000e-01,
	/*3837*/ -3.85605096817016601562500000000000e-01,
	/*3838*/ -3.84188950061798095703125000000000e-01,
	/*3839*/ -3.82771879434585571289062500000000e-01,
	/*3840*/ -3.81353944540023803710937500000000e-01,
	/*3841*/ -3.79935085773468017578125000000000e-01,
	/*3842*/ -3.78515332937240600585937500000000e-01,
	/*3843*/ -3.77094715833663940429687500000000e-01,
	/*3844*/ -3.75673174858093261718750000000000e-01,
	/*3845*/ -3.74250769615173339843750000000000e-01,
	/*3846*/ -3.72827470302581787109375000000000e-01,
	/*3847*/ -3.71403306722640991210937500000000e-01,
	/*3848*/ -3.69978278875350952148437500000000e-01,
	/*3849*/ -3.68552356958389282226562500000000e-01,
	/*3850*/ -3.67125570774078369140625000000000e-01,
	/*3851*/ -3.65697920322418212890625000000000e-01,
	/*3852*/ -3.64269435405731201171875000000000e-01,
	/*3853*/ -3.62840056419372558593750000000000e-01,
	/*3854*/ -3.61409842967987060546875000000000e-01,
	/*3855*/ -3.59978765249252319335937500000000e-01,
	/*3856*/ -3.58546853065490722656250000000000e-01,
	/*3857*/ -3.57114106416702270507812500000000e-01,
	/*3858*/ -3.55680495500564575195312500000000e-01,
	/*3859*/ -3.54246050119400024414062500000000e-01,
	/*3860*/ -3.52810800075531005859375000000000e-01,
	/*3861*/ -3.51374685764312744140625000000000e-01,
	/*3862*/ -3.49937766790390014648437500000000e-01,
	/*3863*/ -3.48500013351440429687500000000000e-01,
	/*3864*/ -3.47061425447463989257812500000000e-01,
	/*3865*/ -3.45622032880783081054687500000000e-01,
	/*3866*/ -3.44181835651397705078125000000000e-01,
	/*3867*/ -3.42740803956985473632812500000000e-01,
	/*3868*/ -3.41298997402191162109375000000000e-01,
	/*3869*/ -3.39856356382369995117187500000000e-01,
	/*3870*/ -3.38412940502166748046875000000000e-01,
	/*3871*/ -3.36968719959259033203125000000000e-01,
	/*3872*/ -3.35523694753646850585937500000000e-01,
	/*3873*/ -3.34077894687652587890625000000000e-01,
	/*3874*/ -3.32631289958953857421875000000000e-01,
	/*3875*/ -3.31183940172195434570312500000000e-01,
	/*3876*/ -3.29735785722732543945312500000000e-01,
	/*3877*/ -3.28286826610565185546875000000000e-01,
	/*3878*/ -3.26837122440338134765625000000000e-01,
	/*3879*/ -3.25386673212051391601562500000000e-01,
	/*3880*/ -3.23935419321060180664062500000000e-01,
	/*3881*/ -3.22483420372009277343750000000000e-01,
	/*3882*/ -3.21030646562576293945312500000000e-01,
	/*3883*/ -3.19577127695083618164062500000000e-01,
	/*3884*/ -3.18122863769531250000000000000000e-01,
	/*3885*/ -3.16667854785919189453125000000000e-01,
	/*3886*/ -3.15212100744247436523437500000000e-01,
	/*3887*/ -3.13755571842193603515625000000000e-01,
	/*3888*/ -3.12298327684402465820312500000000e-01,
	/*3889*/ -3.10840368270874023437500000000000e-01,
	/*3890*/ -3.09381633996963500976562500000000e-01,
	/*3891*/ -3.07922214269638061523437500000000e-01,
	/*3892*/ -3.06462049484252929687500000000000e-01,
	/*3893*/ -3.05001139640808105468750000000000e-01,
	/*3894*/ -3.03539544343948364257812500000000e-01,
	/*3895*/ -3.02077233791351318359375000000000e-01,
	/*3896*/ -3.00614207983016967773437500000000e-01,
	/*3897*/ -2.99150466918945312500000000000000e-01,
	/*3898*/ -2.97686010599136352539062500000000e-01,
	/*3899*/ -2.96220868825912475585937500000000e-01,
	/*3900*/ -2.94755041599273681640625000000000e-01,
	/*3901*/ -2.93288499116897583007812500000000e-01,
	/*3902*/ -2.91821271181106567382812500000000e-01,
	/*3903*/ -2.90353357791900634765625000000000e-01,
	/*3904*/ -2.88884758949279785156250000000000e-01,
	/*3905*/ -2.87415474653244018554687500000000e-01,
	/*3906*/ -2.85945534706115722656250000000000e-01,
	/*3907*/ -2.84474909305572509765625000000000e-01,
	/*3908*/ -2.83003598451614379882812500000000e-01,
	/*3909*/ -2.81531661748886108398437500000000e-01,
	/*3910*/ -2.80059039592742919921875000000000e-01,
	/*3911*/ -2.78585731983184814453125000000000e-01,
	/*3912*/ -2.77111798524856567382812500000000e-01,
	/*3913*/ -2.75637209415435791015625000000000e-01,
	/*3914*/ -2.74161964654922485351562500000000e-01,
	/*3915*/ -2.72686094045639038085937500000000e-01,
	/*3916*/ -2.71209567785263061523437500000000e-01,
	/*3917*/ -2.69732385873794555664062500000000e-01,
	/*3918*/ -2.68254578113555908203125000000000e-01,
	/*3919*/ -2.66776144504547119140625000000000e-01,
	/*3920*/ -2.65297085046768188476562500000000e-01,
	/*3921*/ -2.63817399740219116210937500000000e-01,
	/*3922*/ -2.62337088584899902343750000000000e-01,
	/*3923*/ -2.60856181383132934570312500000000e-01,
	/*3924*/ -2.59374648332595825195312500000000e-01,
	/*3925*/ -2.57892489433288574218750000000000e-01,
	/*3926*/ -2.56409734487533569335937500000000e-01,
	/*3927*/ -2.54926353693008422851562500000000e-01,
	/*3928*/ -2.53442406654357910156250000000000e-01,
	/*3929*/ -2.51957863569259643554687500000000e-01,
	/*3930*/ -2.50472694635391235351562500000000e-01,
	/*3931*/ -2.48986959457397460937500000000000e-01,
	/*3932*/ -2.47500628232955932617187500000000e-01,
	/*3933*/ -2.46013730764389038085937500000000e-01,
	/*3934*/ -2.44526237249374389648437500000000e-01,
	/*3935*/ -2.43038177490234375000000000000000e-01,
	/*3936*/ -2.41549536585807800292968750000000e-01,
	/*3937*/ -2.40060329437255859375000000000000e-01,
	/*3938*/ -2.38570556044578552246093750000000e-01,
	/*3939*/ -2.37080231308937072753906250000000e-01,
	/*3940*/ -2.35589340329170227050781250000000e-01,
	/*3941*/ -2.34097898006439208984375000000000e-01,
	/*3942*/ -2.32605904340744018554687500000000e-01,
	/*3943*/ -2.31113359332084655761718750000000e-01,
	/*3944*/ -2.29620277881622314453125000000000e-01,
	/*3945*/ -2.28126645088195800781250000000000e-01,
	/*3946*/ -2.26632475852966308593750000000000e-01,
	/*3947*/ -2.25137785077095031738281250000000e-01,
	/*3948*/ -2.23642557859420776367187500000000e-01,
	/*3949*/ -2.22146794199943542480468750000000e-01,
	/*3950*/ -2.20650523900985717773437500000000e-01,
	/*3951*/ -2.19153717160224914550781250000000e-01,
	/*3952*/ -2.17656403779983520507812500000000e-01,
	/*3953*/ -2.16158583760261535644531250000000e-01,
	/*3954*/ -2.14660242199897766113281250000000e-01,
	/*3955*/ -2.13161408901214599609375000000000e-01,
	/*3956*/ -2.11662068963050842285156250000000e-01,
	/*3957*/ -2.10162222385406494140625000000000e-01,
	/*3958*/ -2.08661898970603942871093750000000e-01,
	/*3959*/ -2.07161068916320800781250000000000e-01,
	/*3960*/ -2.05659747123718261718750000000000e-01,
	/*3961*/ -2.04157948493957519531250000000000e-01,
	/*3962*/ -2.02655673027038574218750000000000e-01,
	/*3963*/ -2.01152920722961425781250000000000e-01,
	/*3964*/ -1.99649691581726074218750000000000e-01,
	/*3965*/ -1.98146000504493713378906250000000e-01,
	/*3966*/ -1.96641832590103149414062500000000e-01,
	/*3967*/ -1.95137202739715576171875000000000e-01,
	/*3968*/ -1.93632110953330993652343750000000e-01,
	/*3969*/ -1.92126572132110595703125000000000e-01,
	/*3970*/ -1.90620571374893188476562500000000e-01,
	/*3971*/ -1.89114123582839965820312500000000e-01,
	/*3972*/ -1.87607228755950927734375000000000e-01,
	/*3973*/ -1.86099901795387268066406250000000e-01,
	/*3974*/ -1.84592127799987792968750000000000e-01,
	/*3975*/ -1.83083936572074890136718750000000e-01,
	/*3976*/ -1.81575298309326171875000000000000e-01,
	/*3977*/ -1.80066227912902832031250000000000e-01,
	/*3978*/ -1.78556740283966064453125000000000e-01,
	/*3979*/ -1.77046835422515869140625000000000e-01,
	/*3980*/ -1.75536513328552246093750000000000e-01,
	/*3981*/ -1.74025774002075195312500000000000e-01,
	/*3982*/ -1.72514632344245910644531250000000e-01,
	/*3983*/ -1.71003073453903198242187500000000e-01,
	/*3984*/ -1.69491112232208251953125000000000e-01,
	/*3985*/ -1.67978763580322265625000000000000e-01,
	/*3986*/ -1.66466012597084045410156250000000e-01,
	/*3987*/ -1.64952874183654785156250000000000e-01,
	/*3988*/ -1.63439333438873291015625000000000e-01,
	/*3989*/ -1.61925420165061950683593750000000e-01,
	/*3990*/ -1.60411134362220764160156250000000e-01,
	/*3991*/ -1.58896461129188537597656250000000e-01,
	/*3992*/ -1.57381400465965270996093750000000e-01,
	/*3993*/ -1.55865982174873352050781250000000e-01,
	/*3994*/ -1.54350206255912780761718750000000e-01,
	/*3995*/ -1.52834057807922363281250000000000e-01,
	/*3996*/ -1.51317536830902099609375000000000e-01,
	/*3997*/ -1.49800673127174377441406250000000e-01,
	/*3998*/ -1.48283466696739196777343750000000e-01,
	/*3999*/ -1.46765887737274169921875000000000e-01,
	/*4000*/ -1.45247980952262878417968750000000e-01,
	/*4001*/ -1.43729731440544128417968750000000e-01,
	/*4002*/ -1.42211139202117919921875000000000e-01,
	/*4003*/ -1.40692204236984252929687500000000e-01,
	/*4004*/ -1.39172941446304321289062500000000e-01,
	/*4005*/ -1.37653365731239318847656250000000e-01,
	/*4006*/ -1.36133447289466857910156250000000e-01,
	/*4007*/ -1.34613215923309326171875000000000e-01,
	/*4008*/ -1.33092671632766723632812500000000e-01,
	/*4009*/ -1.31571814417839050292968750000000e-01,
	/*4010*/ -1.30050644278526306152343750000000e-01,
	/*4011*/ -1.28529161214828491210937500000000e-01,
	/*4012*/ -1.27007380127906799316406250000000e-01,
	/*4013*/ -1.25485301017761230468750000000000e-01,
	/*4014*/ -1.23962931334972381591796875000000e-01,
	/*4015*/ -1.22440263628959655761718750000000e-01,
	/*4016*/ -1.20917312800884246826171875000000e-01,
	/*4017*/ -1.19394071400165557861328125000000e-01,
	/*4018*/ -1.17870554327964782714843750000000e-01,
	/*4019*/ -1.16346754133701324462890625000000e-01,
	/*4020*/ -1.14822678267955780029296875000000e-01,
	/*4021*/ -1.13298341631889343261718750000000e-01,
	/*4022*/ -1.11773729324340820312500000000000e-01,
	/*4023*/ -1.10248856246471405029296875000000e-01,
	/*4024*/ -1.08723729848861694335937500000000e-01,
	/*4025*/ -1.07198342680931091308593750000000e-01,
	/*4026*/ -1.05672702193260192871093750000000e-01,
	/*4027*/ -1.04146815836429595947265625000000e-01,
	/*4028*/ -1.02620683610439300537109375000000e-01,
	/*4029*/ -1.01094305515289306640625000000000e-01,
	/*4030*/ -9.95676890015602111816406250000000e-02,
	/*4031*/ -9.80408415198326110839843750000000e-02,
	/*4032*/ -9.65137630701065063476562500000000e-02,
	/*4033*/ -9.49864611029624938964843750000000e-02,
	/*4034*/ -9.34589281678199768066406250000000e-02,
	/*4035*/ -9.19311791658401489257812500000000e-02,
	/*4036*/ -9.04032140970230102539062500000000e-02,
	/*4037*/ -8.88750404119491577148437500000000e-02,
	/*4038*/ -8.73466506600379943847656250000000e-02,
	/*4039*/ -8.58180597424507141113281250000000e-02,
	/*4040*/ -8.42892602086067199707031250000000e-02,
	/*4041*/ -8.27602669596672058105468750000000e-02,
	/*4042*/ -8.12310799956321716308593750000000e-02,
	/*4043*/ -7.97016993165016174316406250000000e-02,
	/*4044*/ -7.81721323728561401367187500000000e-02,
	/*4045*/ -7.66423791646957397460937500000000e-02,
	/*4046*/ -7.51124471426010131835937500000000e-02,
	/*4047*/ -7.35823363065719604492187500000000e-02,
	/*4048*/ -7.20520615577697753906250000000000e-02,
	/*4049*/ -7.05216079950332641601562500000000e-02,
	/*4050*/ -6.89909905195236206054687500000000e-02,
	/*4051*/ -6.74602091312408447265625000000000e-02,
	/*4052*/ -6.59292712807655334472656250000000e-02,
	/*4053*/ -6.43981769680976867675781250000000e-02,
	/*4054*/ -6.28669261932373046875000000000000e-02,
	/*4055*/ -6.13355375826358795166015625000000e-02,
	/*4056*/ -5.98039962351322174072265625000000e-02,
	/*4057*/ -5.82723170518875122070312500000000e-02,
	/*4058*/ -5.67405037581920623779296875000000e-02,
	/*4059*/ -5.52085526287555694580078125000000e-02,
	/*4060*/ -5.36764748394489288330078125000000e-02,
	/*4061*/ -5.21442666649818420410156250000000e-02,
	/*4062*/ -5.06119392812252044677734375000000e-02,
	/*4063*/ -4.90794889628887176513671875000000e-02,
	/*4064*/ -4.75469268858432769775390625000000e-02,
	/*4065*/ -4.60142530500888824462890625000000e-02,
	/*4066*/ -4.44814674556255340576171875000000e-02,
	/*4067*/ -4.29485775530338287353515625000000e-02,
	/*4068*/ -4.14155907928943634033203125000000e-02,
	/*4069*/ -3.98825034499168395996093750000000e-02,
	/*4070*/ -3.83493229746818542480468750000000e-02,
	/*4071*/ -3.68160493671894073486328125000000e-02,
	/*4072*/ -3.52826938033103942871093750000000e-02,
	/*4073*/ -3.37492525577545166015625000000000e-02,
	/*4074*/ -3.22157293558120727539062500000000e-02,
	/*4075*/ -3.06821353733539581298828125000000e-02,
	/*4076*/ -2.91484650224447250366210937500000e-02,
	/*4077*/ -2.76147294789552688598632812500000e-02,
	/*4078*/ -2.60809268802404403686523437500000e-02,
	/*4079*/ -2.45470628142356872558593750000000e-02,
	/*4080*/ -2.30131410062313079833984375000000e-02,
	/*4081*/ -2.14791651815176010131835937500000e-02,
	/*4082*/ -1.99451390653848648071289062500000e-02,
	/*4083*/ -1.84110663831233978271484375000000e-02,
	/*4084*/ -1.68769508600234985351562500000000e-02,
	/*4085*/ -1.53427943587303161621093750000000e-02,
	/*4086*/ -1.38086015358567237854003906250000e-02,
	/*4087*/ -1.22743770480155944824218750000000e-02,
	/*4088*/ -1.07401236891746520996093750000000e-02,
	/*4089*/ -9.20584425330162048339843750000000e-03,
	/*4090*/ -7.67154386267066001892089843750000e-03,
	/*4091*/ -6.13722531124949455261230468750000e-03,
	/*4092*/ -4.60289185866713523864746093750000e-03,
	/*4093*/ -3.06854792870581150054931640625000e-03,
	/*4094*/ -1.53419678099453449249267578125000e-03,
	/*4095*/ 1.57995145855238661170005798339844e-07,
#if 0
	/*   0*/ -0x0p+0,
	/*   1*/ 0x1.9238dp-10,
	/*   2*/ 0x1.9238bp-9,
	/*   3*/ 0x1.2daa5ep-8,
	/*   4*/ 0x1.923834p-8,
	/*   5*/ 0x1.f6c5ccp-8,
	/*   6*/ 0x1.2da98cp-7,
	/*   7*/ 0x1.5ff002p-7,
	/*   8*/ 0x1.923644p-7,
	/*   9*/ 0x1.c47c46p-7,
	/*  10*/ 0x1.f6c202p-7,
	/*  11*/ 0x1.1483bap-6,
	/*  12*/ 0x1.2da646p-6,
	/*  13*/ 0x1.46c8a4p-6,
	/*  14*/ 0x1.5feadp-6,
	/*  15*/ 0x1.790cc6p-6,
	/*  16*/ 0x1.922e82p-6,
	/*  17*/ 0x1.ab5p-6,
	/*  18*/ 0x1.c4713ap-6,
	/*  19*/ 0x1.dd923p-6,
	/*  20*/ 0x1.f6b2dcp-6,
	/*  21*/ 0x1.07e99ep-5,
	/*  22*/ 0x1.1479a4p-5,
	/*  23*/ 0x1.21098p-5,
	/*  24*/ 0x1.2d993p-5,
	/*  25*/ 0x1.3a28bp-5,
	/*  26*/ 0x1.46b8p-5,
	/*  27*/ 0x1.53471ep-5,
	/*  28*/ 0x1.5fd608p-5,
	/*  29*/ 0x1.6c64bap-5,
	/*  30*/ 0x1.78f336p-5,
	/*  31*/ 0x1.858176p-5,
	/*  32*/ 0x1.920f7cp-5,
	/*  33*/ 0x1.9e9d42p-5,
	/*  34*/ 0x1.ab2acap-5,
	/*  35*/ 0x1.b7b80ep-5,
	/*  36*/ 0x1.c4450ep-5,
	/*  37*/ 0x1.d0d1cap-5,
	/*  38*/ 0x1.dd5e3ep-5,
	/*  39*/ 0x1.e9ea68p-5,
	/*  40*/ 0x1.f67646p-5,
	/*  41*/ 0x1.0180ecp-4,
	/*  42*/ 0x1.07c68cp-4,
	/*  43*/ 0x1.0e0c04p-4,
	/*  44*/ 0x1.145152p-4,
	/*  45*/ 0x1.1a9676p-4,
	/*  46*/ 0x1.20db6ep-4,
	/*  47*/ 0x1.27203ap-4,
	/*  48*/ 0x1.2d64d8p-4,
	/*  49*/ 0x1.33a946p-4,
	/*  50*/ 0x1.39ed86p-4,
	/*  51*/ 0x1.403196p-4,
	/*  52*/ 0x1.467574p-4,
	/*  53*/ 0x1.4cb92p-4,
	/*  54*/ 0x1.52fc98p-4,
	/*  55*/ 0x1.593fdcp-4,
	/*  56*/ 0x1.5f82ecp-4,
	/*  57*/ 0x1.65c5c4p-4,
	/*  58*/ 0x1.6c0866p-4,
	/*  59*/ 0x1.724acep-4,
	/*  60*/ 0x1.788dp-4,
	/*  61*/ 0x1.7ecef6p-4,
	/*  62*/ 0x1.8510bp-4,
	/*  63*/ 0x1.8b523p-4,
	/*  64*/ 0x1.91937p-4,
	/*  65*/ 0x1.97d474p-4,
	/*  66*/ 0x1.9e153ap-4,
	/*  67*/ 0x1.a455cp-4,
	/*  68*/ 0x1.aa9604p-4,
	/*  69*/ 0x1.b0d606p-4,
	/*  70*/ 0x1.b715c6p-4,
	/*  71*/ 0x1.bd5542p-4,
	/*  72*/ 0x1.c3947ap-4,
	/*  73*/ 0x1.c9d36ap-4,
	/*  74*/ 0x1.d01216p-4,
	/*  75*/ 0x1.d6507ap-4,
	/*  76*/ 0x1.dc8e94p-4,
	/*  77*/ 0x1.e2cc66p-4,
	/*  78*/ 0x1.e909ecp-4,
	/*  79*/ 0x1.ef4728p-4,
	/*  80*/ 0x1.f58416p-4,
	/*  81*/ 0x1.fbc0b8p-4,
	/*  82*/ 0x1.00fe86p-3,
	/*  83*/ 0x1.041c88p-3,
	/*  84*/ 0x1.073a62p-3,
	/*  85*/ 0x1.0a5812p-3,
	/*  86*/ 0x1.0d759ap-3,
	/*  87*/ 0x1.1092fap-3,
	/*  88*/ 0x1.13b02ep-3,
	/*  89*/ 0x1.16cd38p-3,
	/*  90*/ 0x1.19ea16p-3,
	/*  91*/ 0x1.1d06cap-3,
	/*  92*/ 0x1.202352p-3,
	/*  93*/ 0x1.233facp-3,
	/*  94*/ 0x1.265bdap-3,
	/*  95*/ 0x1.2977dcp-3,
	/*  96*/ 0x1.2c93aep-3,
	/*  97*/ 0x1.2faf52p-3,
	/*  98*/ 0x1.32cac8p-3,
	/*  99*/ 0x1.35e60ep-3,
	/* 100*/ 0x1.390124p-3,
	/* 101*/ 0x1.3c1c0ap-3,
	/* 102*/ 0x1.3f36cp-3,
	/* 103*/ 0x1.425144p-3,
	/* 104*/ 0x1.456b96p-3,
	/* 105*/ 0x1.4885b6p-3,
	/* 106*/ 0x1.4b9fa4p-3,
	/* 107*/ 0x1.4eb95ep-3,
	/* 108*/ 0x1.51d2e4p-3,
	/* 109*/ 0x1.54ec38p-3,
	/* 110*/ 0x1.580554p-3,
	/* 111*/ 0x1.5b1e3ep-3,
	/* 112*/ 0x1.5e36f2p-3,
	/* 113*/ 0x1.614f6ep-3,
	/* 114*/ 0x1.6467b6p-3,
	/* 115*/ 0x1.677fc4p-3,
	/* 116*/ 0x1.6a979ep-3,
	/* 117*/ 0x1.6daf3ep-3,
	/* 118*/ 0x1.70c6a6p-3,
	/* 119*/ 0x1.73ddd4p-3,
	/* 120*/ 0x1.76f4cap-3,
	/* 121*/ 0x1.7a0b86p-3,
	/* 122*/ 0x1.7d2208p-3,
	/* 123*/ 0x1.80384ep-3,
	/* 124*/ 0x1.834e5ap-3,
	/* 125*/ 0x1.866428p-3,
	/* 126*/ 0x1.8979bcp-3,
	/* 127*/ 0x1.8c8f12p-3,
	/* 128*/ 0x1.8fa42cp-3,
	/* 129*/ 0x1.92b908p-3,
	/* 130*/ 0x1.95cda6p-3,
	/* 131*/ 0x1.98e204p-3,
	/* 132*/ 0x1.9bf624p-3,
	/* 133*/ 0x1.9f0a06p-3,
	/* 134*/ 0x1.a21da6p-3,
	/* 135*/ 0x1.a53106p-3,
	/* 136*/ 0x1.a84424p-3,
	/* 137*/ 0x1.ab5702p-3,
	/* 138*/ 0x1.ae699ep-3,
	/* 139*/ 0x1.b17bf6p-3,
	/* 140*/ 0x1.b48e0cp-3,
	/* 141*/ 0x1.b79fep-3,
	/* 142*/ 0x1.bab16ep-3,
	/* 143*/ 0x1.bdc2bap-3,
	/* 144*/ 0x1.c0d3cp-3,
	/* 145*/ 0x1.c3e48p-3,
	/* 146*/ 0x1.c6f4fcp-3,
	/* 147*/ 0x1.ca053p-3,
	/* 148*/ 0x1.cd151ep-3,
	/* 149*/ 0x1.d024c6p-3,
	/* 150*/ 0x1.d33424p-3,
	/* 151*/ 0x1.d6433cp-3,
	/* 152*/ 0x1.d9520ap-3,
	/* 153*/ 0x1.dc609p-3,
	/* 154*/ 0x1.df6eccp-3,
	/* 155*/ 0x1.e27cbep-3,
	/* 156*/ 0x1.e58a66p-3,
	/* 157*/ 0x1.e897c4p-3,
	/* 158*/ 0x1.eba4d4p-3,
	/* 159*/ 0x1.eeb19ap-3,
	/* 160*/ 0x1.f1be14p-3,
	/* 161*/ 0x1.f4ca4p-3,
	/* 162*/ 0x1.f7d62p-3,
	/* 163*/ 0x1.fae1b2p-3,
	/* 164*/ 0x1.fdecf4p-3,
	/* 165*/ 0x1.007bf4p-2,
	/* 166*/ 0x1.020148p-2,
	/* 167*/ 0x1.038672p-2,
	/* 168*/ 0x1.050b76p-2,
	/* 169*/ 0x1.06905p-2,
	/* 170*/ 0x1.081502p-2,
	/* 171*/ 0x1.09998cp-2,
	/* 172*/ 0x1.0b1decp-2,
	/* 173*/ 0x1.0ca222p-2,
	/* 174*/ 0x1.0e263p-2,
	/* 175*/ 0x1.0faa14p-2,
	/* 176*/ 0x1.112dcep-2,
	/* 177*/ 0x1.12b15ep-2,
	/* 178*/ 0x1.1434c4p-2,
	/* 179*/ 0x1.15b8p-2,
	/* 180*/ 0x1.173b1p-2,
	/* 181*/ 0x1.18bdf4p-2,
	/* 182*/ 0x1.1a40aep-2,
	/* 183*/ 0x1.1bc33cp-2,
	/* 184*/ 0x1.1d459ep-2,
	/* 185*/ 0x1.1ec7d6p-2,
	/* 186*/ 0x1.2049ep-2,
	/* 187*/ 0x1.21cbbep-2,
	/* 188*/ 0x1.234d6ep-2,
	/* 189*/ 0x1.24cef2p-2,
	/* 190*/ 0x1.265048p-2,
	/* 191*/ 0x1.27d172p-2,
	/* 192*/ 0x1.29526ep-2,
	/* 193*/ 0x1.2ad33cp-2,
	/* 194*/ 0x1.2c53dcp-2,
	/* 195*/ 0x1.2dd44ep-2,
	/* 196*/ 0x1.2f549p-2,
	/* 197*/ 0x1.30d4a4p-2,
	/* 198*/ 0x1.32548ap-2,
	/* 199*/ 0x1.33d44p-2,
	/* 200*/ 0x1.3553c6p-2,
	/* 201*/ 0x1.36d31cp-2,
	/* 202*/ 0x1.385242p-2,
	/* 203*/ 0x1.39d13ap-2,
	/* 204*/ 0x1.3b5p-2,
	/* 205*/ 0x1.3cce94p-2,
	/* 206*/ 0x1.3e4cfap-2,
	/* 207*/ 0x1.3fcb2cp-2,
	/* 208*/ 0x1.41492ep-2,
	/* 209*/ 0x1.42c7p-2,
	/* 210*/ 0x1.44449ep-2,
	/* 211*/ 0x1.45c20ap-2,
	/* 212*/ 0x1.473f44p-2,
	/* 213*/ 0x1.48bc4cp-2,
	/* 214*/ 0x1.4a3922p-2,
	/* 215*/ 0x1.4bb5c4p-2,
	/* 216*/ 0x1.4d3234p-2,
	/* 217*/ 0x1.4eae6ep-2,
	/* 218*/ 0x1.502a76p-2,
	/* 219*/ 0x1.51a64cp-2,
	/* 220*/ 0x1.5321ecp-2,
	/* 221*/ 0x1.549d56p-2,
	/* 222*/ 0x1.56188ep-2,
	/* 223*/ 0x1.57939p-2,
	/* 224*/ 0x1.590e5ep-2,
	/* 225*/ 0x1.5a88f6p-2,
	/* 226*/ 0x1.5c0358p-2,
	/* 227*/ 0x1.5d7d86p-2,
	/* 228*/ 0x1.5ef77cp-2,
	/* 229*/ 0x1.60713ep-2,
	/* 230*/ 0x1.61eac8p-2,
	/* 231*/ 0x1.63641cp-2,
	/* 232*/ 0x1.64dd3ap-2,
	/* 233*/ 0x1.66562p-2,
	/* 234*/ 0x1.67cecep-2,
	/* 235*/ 0x1.694746p-2,
	/* 236*/ 0x1.6abf84p-2,
	/* 237*/ 0x1.6c378cp-2,
	/* 238*/ 0x1.6daf5cp-2,
	/* 239*/ 0x1.6f26f2p-2,
	/* 240*/ 0x1.709e5p-2,
	/* 241*/ 0x1.721576p-2,
	/* 242*/ 0x1.738c62p-2,
	/* 243*/ 0x1.750316p-2,
	/* 244*/ 0x1.76798ep-2,
	/* 245*/ 0x1.77efcep-2,
	/* 246*/ 0x1.7965d4p-2,
	/* 247*/ 0x1.7adbap-2,
	/* 248*/ 0x1.7c513p-2,
	/* 249*/ 0x1.7dc686p-2,
	/* 250*/ 0x1.7f3ba2p-2,
	/* 251*/ 0x1.80b082p-2,
	/* 252*/ 0x1.822528p-2,
	/* 253*/ 0x1.83999p-2,
	/* 254*/ 0x1.850dbep-2,
	/* 255*/ 0x1.8681bp-2,
	/* 256*/ 0x1.87f564p-2,
	/* 257*/ 0x1.8968dep-2,
	/* 258*/ 0x1.8adc1ap-2,
	/* 259*/ 0x1.8c4f18p-2,
	/* 260*/ 0x1.8dc1dap-2,
	/* 261*/ 0x1.8f346p-2,
	/* 262*/ 0x1.90a6a6p-2,
	/* 263*/ 0x1.9218bp-2,
	/* 264*/ 0x1.938a7ap-2,
	/* 265*/ 0x1.94fc08p-2,
	/* 266*/ 0x1.966d56p-2,
	/* 267*/ 0x1.97de66p-2,
	/* 268*/ 0x1.994f36p-2,
	/* 269*/ 0x1.9abfc8p-2,
	/* 270*/ 0x1.9c301ap-2,
	/* 271*/ 0x1.9da02ep-2,
	/* 272*/ 0x1.9f1p-2,
	/* 273*/ 0x1.a07f92p-2,
	/* 274*/ 0x1.a1eee6p-2,
	/* 275*/ 0x1.a35df8p-2,
	/* 276*/ 0x1.a4ccc8p-2,
	/* 277*/ 0x1.a63b5ap-2,
	/* 278*/ 0x1.a7a9a8p-2,
	/* 279*/ 0x1.a917b6p-2,
	/* 280*/ 0x1.aa8582p-2,
	/* 281*/ 0x1.abf30ep-2,
	/* 282*/ 0x1.ad6056p-2,
	/* 283*/ 0x1.aecd5cp-2,
	/* 284*/ 0x1.b03a2p-2,
	/* 285*/ 0x1.b1a6ap-2,
	/* 286*/ 0x1.b312ep-2,
	/* 287*/ 0x1.b47edap-2,
	/* 288*/ 0x1.b5ea92p-2,
	/* 289*/ 0x1.b75606p-2,
	/* 290*/ 0x1.b8c136p-2,
	/* 291*/ 0x1.ba2c22p-2,
	/* 292*/ 0x1.bb96ccp-2,
	/* 293*/ 0x1.bd012ep-2,
	/* 294*/ 0x1.be6b4ep-2,
	/* 295*/ 0x1.bfd528p-2,
	/* 296*/ 0x1.c13ebep-2,
	/* 297*/ 0x1.c2a80cp-2,
	/* 298*/ 0x1.c41118p-2,
	/* 299*/ 0x1.c579dcp-2,
	/* 300*/ 0x1.c6e25ap-2,
	/* 301*/ 0x1.c84a92p-2,
	/* 302*/ 0x1.c9b284p-2,
	/* 303*/ 0x1.cb1a3p-2,
	/* 304*/ 0x1.cc8194p-2,
	/* 305*/ 0x1.cde8b2p-2,
	/* 306*/ 0x1.cf4f88p-2,
	/* 307*/ 0x1.d0b616p-2,
	/* 308*/ 0x1.d21c5ep-2,
	/* 309*/ 0x1.d3825cp-2,
	/* 310*/ 0x1.d4e814p-2,
	/* 311*/ 0x1.d64d82p-2,
	/* 312*/ 0x1.d7b2a8p-2,
	/* 313*/ 0x1.d91786p-2,
	/* 314*/ 0x1.da7c1ap-2,
	/* 315*/ 0x1.dbe064p-2,
	/* 316*/ 0x1.dd4466p-2,
	/* 317*/ 0x1.dea81ep-2,
	/* 318*/ 0x1.e00b8cp-2,
	/* 319*/ 0x1.e16ebp-2,
	/* 320*/ 0x1.e2d18ap-2,
	/* 321*/ 0x1.e4341ap-2,
	/* 322*/ 0x1.e5965ep-2,
	/* 323*/ 0x1.e6f858p-2,
	/* 324*/ 0x1.e85a06p-2,
	/* 325*/ 0x1.e9bb6ap-2,
	/* 326*/ 0x1.eb1c82p-2,
	/* 327*/ 0x1.ec7d4ep-2,
	/* 328*/ 0x1.edddcep-2,
	/* 329*/ 0x1.ef3e02p-2,
	/* 330*/ 0x1.f09de8p-2,
	/* 331*/ 0x1.f1fd84p-2,
	/* 332*/ 0x1.f35cdp-2,
	/* 333*/ 0x1.f4bbd2p-2,
	/* 334*/ 0x1.f61a86p-2,
	/* 335*/ 0x1.f778ecp-2,
	/* 336*/ 0x1.f8d704p-2,
	/* 337*/ 0x1.fa34cep-2,
	/* 338*/ 0x1.fb924ap-2,
	/* 339*/ 0x1.fcef78p-2,
	/* 340*/ 0x1.fe4c58p-2,
	/* 341*/ 0x1.ffa8e8p-2,
	/* 342*/ 0x1.008296p-1,
	/* 343*/ 0x1.01308ep-1,
	/* 344*/ 0x1.01de6p-1,
	/* 345*/ 0x1.028c0ap-1,
	/* 346*/ 0x1.03398cp-1,
	/* 347*/ 0x1.03e6e6p-1,
	/* 348*/ 0x1.049418p-1,
	/* 349*/ 0x1.054122p-1,
	/* 350*/ 0x1.05ee04p-1,
	/* 351*/ 0x1.069abcp-1,
	/* 352*/ 0x1.07474cp-1,
	/* 353*/ 0x1.07f3b4p-1,
	/* 354*/ 0x1.089ff4p-1,
	/* 355*/ 0x1.094c0ap-1,
	/* 356*/ 0x1.09f7f8p-1,
	/* 357*/ 0x1.0aa3bcp-1,
	/* 358*/ 0x1.0b4f56p-1,
	/* 359*/ 0x1.0bfac8p-1,
	/* 360*/ 0x1.0ca612p-1,
	/* 361*/ 0x1.0d513p-1,
	/* 362*/ 0x1.0dfc26p-1,
	/* 363*/ 0x1.0ea6f2p-1,
	/* 364*/ 0x1.0f5194p-1,
	/* 365*/ 0x1.0ffc0cp-1,
	/* 366*/ 0x1.10a65ap-1,
	/* 367*/ 0x1.11508p-1,
	/* 368*/ 0x1.11fa7ap-1,
	/* 369*/ 0x1.12a44ap-1,
	/* 370*/ 0x1.134deep-1,
	/* 371*/ 0x1.13f76ap-1,
	/* 372*/ 0x1.14a0bap-1,
	/* 373*/ 0x1.1549ep-1,
	/* 374*/ 0x1.15f2dap-1,
	/* 375*/ 0x1.169baap-1,
	/* 376*/ 0x1.17445p-1,
	/* 377*/ 0x1.17eccap-1,
	/* 378*/ 0x1.189518p-1,
	/* 379*/ 0x1.193d3cp-1,
	/* 380*/ 0x1.19e534p-1,
	/* 381*/ 0x1.1a8d02p-1,
	/* 382*/ 0x1.1b34a2p-1,
	/* 383*/ 0x1.1bdc18p-1,
	/* 384*/ 0x1.1c8362p-1,
	/* 385*/ 0x1.1d2a7ep-1,
	/* 386*/ 0x1.1dd17p-1,
	/* 387*/ 0x1.1e7836p-1,
	/* 388*/ 0x1.1f1edp-1,
	/* 389*/ 0x1.1fc53cp-1,
	/* 390*/ 0x1.206b7cp-1,
	/* 391*/ 0x1.211192p-1,
	/* 392*/ 0x1.21b778p-1,
	/* 393*/ 0x1.225d34p-1,
	/* 394*/ 0x1.2302c2p-1,
	/* 395*/ 0x1.23a822p-1,
	/* 396*/ 0x1.244d56p-1,
	/* 397*/ 0x1.24f25ep-1,
	/* 398*/ 0x1.259738p-1,
	/* 399*/ 0x1.263be4p-1,
	/* 400*/ 0x1.26e064p-1,
	/* 401*/ 0x1.2784b6p-1,
	/* 402*/ 0x1.2828dap-1,
	/* 403*/ 0x1.28ccdp-1,
	/* 404*/ 0x1.297098p-1,
	/* 405*/ 0x1.2a1434p-1,
	/* 406*/ 0x1.2ab7ap-1,
	/* 407*/ 0x1.2b5adep-1,
	/* 408*/ 0x1.2bfdeep-1,
	/* 409*/ 0x1.2ca0d2p-1,
	/* 410*/ 0x1.2d4384p-1,
	/* 411*/ 0x1.2de60ap-1,
	/* 412*/ 0x1.2e886p-1,
	/* 413*/ 0x1.2f2a88p-1,
	/* 414*/ 0x1.2fcc82p-1,
	/* 415*/ 0x1.306e4cp-1,
	/* 416*/ 0x1.310fe8p-1,
	/* 417*/ 0x1.31b154p-1,
	/* 418*/ 0x1.325292p-1,
	/* 419*/ 0x1.32f3ap-1,
	/* 420*/ 0x1.33947ep-1,
	/* 421*/ 0x1.34352cp-1,
	/* 422*/ 0x1.34d5acp-1,
	/* 423*/ 0x1.3575fcp-1,
	/* 424*/ 0x1.36161cp-1,
	/* 425*/ 0x1.36b60cp-1,
	/* 426*/ 0x1.3755cep-1,
	/* 427*/ 0x1.37f55ep-1,
	/* 428*/ 0x1.3894bep-1,
	/* 429*/ 0x1.3933eep-1,
	/* 430*/ 0x1.39d2eep-1,
	/* 431*/ 0x1.3a71bcp-1,
	/* 432*/ 0x1.3b105cp-1,
	/* 433*/ 0x1.3baecap-1,
	/* 434*/ 0x1.3c4d06p-1,
	/* 435*/ 0x1.3ceb14p-1,
	/* 436*/ 0x1.3d88fp-1,
	/* 437*/ 0x1.3e269ap-1,
	/* 438*/ 0x1.3ec414p-1,
	/* 439*/ 0x1.3f615cp-1,
	/* 440*/ 0x1.3ffe74p-1,
	/* 441*/ 0x1.409b5ap-1,
	/* 442*/ 0x1.41380ep-1,
	/* 443*/ 0x1.41d49p-1,
	/* 444*/ 0x1.4270e2p-1,
	/* 445*/ 0x1.430dp-1,
	/* 446*/ 0x1.43a8eep-1,
	/* 447*/ 0x1.4444aap-1,
	/* 448*/ 0x1.44e034p-1,
	/* 449*/ 0x1.457b8ap-1,
	/* 450*/ 0x1.4616bp-1,
	/* 451*/ 0x1.46b1a2p-1,
	/* 452*/ 0x1.474c64p-1,
	/* 453*/ 0x1.47e6f2p-1,
	/* 454*/ 0x1.48814cp-1,
	/* 455*/ 0x1.491b76p-1,
	/* 456*/ 0x1.49b56cp-1,
	/* 457*/ 0x1.4a4f2ep-1,
	/* 458*/ 0x1.4ae8bep-1,
	/* 459*/ 0x1.4b821cp-1,
	/* 460*/ 0x1.4c1b46p-1,
	/* 461*/ 0x1.4cb43cp-1,
	/* 462*/ 0x1.4d4dp-1,
	/* 463*/ 0x1.4de59p-1,
	/* 464*/ 0x1.4e7decp-1,
	/* 465*/ 0x1.4f1614p-1,
	/* 466*/ 0x1.4fae0ap-1,
	/* 467*/ 0x1.5045ccp-1,
	/* 468*/ 0x1.50dd58p-1,
	/* 469*/ 0x1.5174b2p-1,
	/* 470*/ 0x1.520bd8p-1,
	/* 471*/ 0x1.52a2c8p-1,
	/* 472*/ 0x1.533986p-1,
	/* 473*/ 0x1.53d00ep-1,
	/* 474*/ 0x1.546662p-1,
	/* 475*/ 0x1.54fc82p-1,
	/* 476*/ 0x1.55926ep-1,
	/* 477*/ 0x1.562824p-1,
	/* 478*/ 0x1.56bda6p-1,
	/* 479*/ 0x1.5752f2p-1,
	/* 480*/ 0x1.57e80ap-1,
	/* 481*/ 0x1.587cecp-1,
	/* 482*/ 0x1.59119ap-1,
	/* 483*/ 0x1.59a612p-1,
	/* 484*/ 0x1.5a3a56p-1,
	/* 485*/ 0x1.5ace62p-1,
	/* 486*/ 0x1.5b623ap-1,
	/* 487*/ 0x1.5bf5dep-1,
	/* 488*/ 0x1.5c894ap-1,
	/* 489*/ 0x1.5d1c8p-1,
	/* 490*/ 0x1.5daf82p-1,
	/* 491*/ 0x1.5e424ep-1,
	/* 492*/ 0x1.5ed4e2p-1,
	/* 493*/ 0x1.5f6742p-1,
	/* 494*/ 0x1.5ff96ap-1,
	/* 495*/ 0x1.608b5cp-1,
	/* 496*/ 0x1.611d18p-1,
	/* 497*/ 0x1.61ae9ep-1,
	/* 498*/ 0x1.623feep-1,
	/* 499*/ 0x1.62d106p-1,
	/* 500*/ 0x1.6361e8p-1,
	/* 501*/ 0x1.63f292p-1,
	/* 502*/ 0x1.648306p-1,
	/* 503*/ 0x1.651342p-1,
	/* 504*/ 0x1.65a348p-1,
	/* 505*/ 0x1.663318p-1,
	/* 506*/ 0x1.66c2aep-1,
	/* 507*/ 0x1.67520ep-1,
	/* 508*/ 0x1.67e138p-1,
	/* 509*/ 0x1.687028p-1,
	/* 510*/ 0x1.68fee2p-1,
	/* 511*/ 0x1.698d64p-1,
	/* 512*/ 0x1.6a1baep-1,
	/* 513*/ 0x1.6aa9cp-1,
	/* 514*/ 0x1.6b379ap-1,
	/* 515*/ 0x1.6bc53cp-1,
	/* 516*/ 0x1.6c52a6p-1,
	/* 517*/ 0x1.6cdfd6p-1,
	/* 518*/ 0x1.6d6cdp-1,
	/* 519*/ 0x1.6df992p-1,
	/* 520*/ 0x1.6e861ap-1,
	/* 521*/ 0x1.6f126ap-1,
	/* 522*/ 0x1.6f9e82p-1,
	/* 523*/ 0x1.702a6p-1,
	/* 524*/ 0x1.70b606p-1,
	/* 525*/ 0x1.714172p-1,
	/* 526*/ 0x1.71cca6p-1,
	/* 527*/ 0x1.7257a2p-1,
	/* 528*/ 0x1.72e264p-1,
	/* 529*/ 0x1.736cecp-1,
	/* 530*/ 0x1.73f73cp-1,
	/* 531*/ 0x1.748152p-1,
	/* 532*/ 0x1.750b2ep-1,
	/* 533*/ 0x1.7594dp-1,
	/* 534*/ 0x1.761e3ap-1,
	/* 535*/ 0x1.76a76ap-1,
	/* 536*/ 0x1.77306p-1,
	/* 537*/ 0x1.77b91cp-1,
	/* 538*/ 0x1.78419cp-1,
	/* 539*/ 0x1.78c9e4p-1,
	/* 540*/ 0x1.7951f2p-1,
	/* 541*/ 0x1.79d9c6p-1,
	/* 542*/ 0x1.7a615ep-1,
	/* 543*/ 0x1.7ae8bep-1,
	/* 544*/ 0x1.7b6fe2p-1,
	/* 545*/ 0x1.7bf6ccp-1,
	/* 546*/ 0x1.7c7d7ap-1,
	/* 547*/ 0x1.7d03fp-1,
	/* 548*/ 0x1.7d8a2ap-1,
	/* 549*/ 0x1.7e1028p-1,
	/* 550*/ 0x1.7e95ecp-1,
	/* 551*/ 0x1.7f1b74p-1,
	/* 552*/ 0x1.7fa0c2p-1,
	/* 553*/ 0x1.8025d4p-1,
	/* 554*/ 0x1.80aaacp-1,
	/* 555*/ 0x1.812f48p-1,
	/* 556*/ 0x1.81b3a8p-1,
	/* 557*/ 0x1.8237cep-1,
	/* 558*/ 0x1.82bbb6p-1,
	/* 559*/ 0x1.833f64p-1,
	/* 560*/ 0x1.83c2d6p-1,
	/* 561*/ 0x1.84460cp-1,
	/* 562*/ 0x1.84c906p-1,
	/* 563*/ 0x1.854bc4p-1,
	/* 564*/ 0x1.85ce48p-1,
	/* 565*/ 0x1.86508ep-1,
	/* 566*/ 0x1.86d296p-1,
	/* 567*/ 0x1.875464p-1,
	/* 568*/ 0x1.87d5f6p-1,
	/* 569*/ 0x1.88574ap-1,
	/* 570*/ 0x1.88d862p-1,
	/* 571*/ 0x1.89593ep-1,
	/* 572*/ 0x1.89d9dcp-1,
	/* 573*/ 0x1.8a5a3ep-1,
	/* 574*/ 0x1.8ada64p-1,
	/* 575*/ 0x1.8b5a4cp-1,
	/* 576*/ 0x1.8bd9f8p-1,
	/* 577*/ 0x1.8c5966p-1,
	/* 578*/ 0x1.8cd896p-1,
	/* 579*/ 0x1.8d578ap-1,
	/* 580*/ 0x1.8dd642p-1,
	/* 581*/ 0x1.8e54bap-1,
	/* 582*/ 0x1.8ed2f6p-1,
	/* 583*/ 0x1.8f50f4p-1,
	/* 584*/ 0x1.8fceb4p-1,
	/* 585*/ 0x1.904c38p-1,
	/* 586*/ 0x1.90c97cp-1,
	/* 587*/ 0x1.914684p-1,
	/* 588*/ 0x1.91c34ep-1,
	/* 589*/ 0x1.923fd8p-1,
	/* 590*/ 0x1.92bc26p-1,
	/* 591*/ 0x1.933836p-1,
	/* 592*/ 0x1.93b406p-1,
	/* 593*/ 0x1.942f9ap-1,
	/* 594*/ 0x1.94aaeep-1,
	/* 595*/ 0x1.952604p-1,
	/* 596*/ 0x1.95a0dap-1,
	/* 597*/ 0x1.961b74p-1,
	/* 598*/ 0x1.9695cep-1,
	/* 599*/ 0x1.970feap-1,
	/* 600*/ 0x1.9789c6p-1,
	/* 601*/ 0x1.980364p-1,
	/* 602*/ 0x1.987cc2p-1,
	/* 603*/ 0x1.98f5e2p-1,
	/* 604*/ 0x1.996ec2p-1,
	/* 605*/ 0x1.99e764p-1,
	/* 606*/ 0x1.9a5fc6p-1,
	/* 607*/ 0x1.9ad7eap-1,
	/* 608*/ 0x1.9b4fccp-1,
	/* 609*/ 0x1.9bc77p-1,
	/* 610*/ 0x1.9c3ed6p-1,
	/* 611*/ 0x1.9cb5fap-1,
	/* 612*/ 0x1.9d2cep-1,
	/* 613*/ 0x1.9da386p-1,
	/* 614*/ 0x1.9e19eap-1,
	/* 615*/ 0x1.9e901p-1,
	/* 616*/ 0x1.9f05f6p-1,
	/* 617*/ 0x1.9f7b9cp-1,
	/* 618*/ 0x1.9ff102p-1,
	/* 619*/ 0x1.a06628p-1,
	/* 620*/ 0x1.a0db0cp-1,
	/* 621*/ 0x1.a14fb2p-1,
	/* 622*/ 0x1.a1c416p-1,
	/* 623*/ 0x1.a2383ap-1,
	/* 624*/ 0x1.a2ac1ep-1,
	/* 625*/ 0x1.a31fcp-1,
	/* 626*/ 0x1.a39324p-1,
	/* 627*/ 0x1.a40644p-1,
	/* 628*/ 0x1.a47926p-1,
	/* 629*/ 0x1.a4ebc6p-1,
	/* 630*/ 0x1.a55e24p-1,
	/* 631*/ 0x1.a5d042p-1,
	/* 632*/ 0x1.a6422p-1,
	/* 633*/ 0x1.a6b3bcp-1,
	/* 634*/ 0x1.a72516p-1,
	/* 635*/ 0x1.a7962ep-1,
	/* 636*/ 0x1.a80706p-1,
	/* 637*/ 0x1.a8779ep-1,
	/* 638*/ 0x1.a8e7f2p-1,
	/* 639*/ 0x1.a95806p-1,
	/* 640*/ 0x1.a9c7d8p-1,
	/* 641*/ 0x1.aa3768p-1,
	/* 642*/ 0x1.aaa6b6p-1,
	/* 643*/ 0x1.ab15c2p-1,
	/* 644*/ 0x1.ab848ep-1,
	/* 645*/ 0x1.abf316p-1,
	/* 646*/ 0x1.ac615cp-1,
	/* 647*/ 0x1.accf6p-1,
	/* 648*/ 0x1.ad3d24p-1,
	/* 649*/ 0x1.adaaa4p-1,
	/* 650*/ 0x1.ae17e2p-1,
	/* 651*/ 0x1.ae84dcp-1,
	/* 652*/ 0x1.aef196p-1,
	/* 653*/ 0x1.af5e0cp-1,
	/* 654*/ 0x1.afca4p-1,
	/* 655*/ 0x1.b03632p-1,
	/* 656*/ 0x1.b0a1ep-1,
	/* 657*/ 0x1.b10d4cp-1,
	/* 658*/ 0x1.b17876p-1,
	/* 659*/ 0x1.b1e35cp-1,
	/* 660*/ 0x1.b24ep-1,
	/* 661*/ 0x1.b2b86p-1,
	/* 662*/ 0x1.b3227cp-1,
	/* 663*/ 0x1.b38c56p-1,
	/* 664*/ 0x1.b3f5eep-1,
	/* 665*/ 0x1.b45f42p-1,
	/* 666*/ 0x1.b4c852p-1,
	/* 667*/ 0x1.b5311ep-1,
	/* 668*/ 0x1.b599a8p-1,
	/* 669*/ 0x1.b601eep-1,
	/* 670*/ 0x1.b669fp-1,
	/* 671*/ 0x1.b6d1bp-1,
	/* 672*/ 0x1.b7392ap-1,
	/* 673*/ 0x1.b7a062p-1,
	/* 674*/ 0x1.b80756p-1,
	/* 675*/ 0x1.b86e04p-1,
	/* 676*/ 0x1.b8d47p-1,
	/* 677*/ 0x1.b93a98p-1,
	/* 678*/ 0x1.b9a07cp-1,
	/* 679*/ 0x1.ba061ap-1,
	/* 680*/ 0x1.ba6b76p-1,
	/* 681*/ 0x1.bad08cp-1,
	/* 682*/ 0x1.bb356p-1,
	/* 683*/ 0x1.bb99eep-1,
	/* 684*/ 0x1.bbfe38p-1,
	/* 685*/ 0x1.bc623cp-1,
	/* 686*/ 0x1.bcc5fep-1,
	/* 687*/ 0x1.bd297ap-1,
	/* 688*/ 0x1.bd8cbp-1,
	/* 689*/ 0x1.bdefa4p-1,
	/* 690*/ 0x1.be5252p-1,
	/* 691*/ 0x1.beb4bap-1,
	/* 692*/ 0x1.bf16dep-1,
	/* 693*/ 0x1.bf78bep-1,
	/* 694*/ 0x1.bfda58p-1,
	/* 695*/ 0x1.c03bacp-1,
	/* 696*/ 0x1.c09cbcp-1,
	/* 697*/ 0x1.c0fd86p-1,
	/* 698*/ 0x1.c15e0cp-1,
	/* 699*/ 0x1.c1be4cp-1,
	/* 700*/ 0x1.c21e46p-1,
	/* 701*/ 0x1.c27dfcp-1,
	/* 702*/ 0x1.c2dd6cp-1,
	/* 703*/ 0x1.c33c96p-1,
	/* 704*/ 0x1.c39b7ap-1,
	/* 705*/ 0x1.c3fa18p-1,
	/* 706*/ 0x1.c45872p-1,
	/* 707*/ 0x1.c4b684p-1,
	/* 708*/ 0x1.c51452p-1,
	/* 709*/ 0x1.c571dap-1,
	/* 710*/ 0x1.c5cf1cp-1,
	/* 711*/ 0x1.c62c16p-1,
	/* 712*/ 0x1.c688ccp-1,
	/* 713*/ 0x1.c6e53cp-1,
	/* 714*/ 0x1.c74164p-1,
	/* 715*/ 0x1.c79d48p-1,
	/* 716*/ 0x1.c7f8e4p-1,
	/* 717*/ 0x1.c8543ap-1,
	/* 718*/ 0x1.c8af4ap-1,
	/* 719*/ 0x1.c90a14p-1,
	/* 720*/ 0x1.c96496p-1,
	/* 721*/ 0x1.c9bed2p-1,
	/* 722*/ 0x1.ca18c8p-1,
	/* 723*/ 0x1.ca7278p-1,
	/* 724*/ 0x1.cacbep-1,
	/* 725*/ 0x1.cb2502p-1,
	/* 726*/ 0x1.cb7ddcp-1,
	/* 727*/ 0x1.cbd67p-1,
	/* 728*/ 0x1.cc2ebcp-1,
	/* 729*/ 0x1.cc86c2p-1,
	/* 730*/ 0x1.ccde8p-1,
	/* 731*/ 0x1.cd35f8p-1,
	/* 732*/ 0x1.cd8d28p-1,
	/* 733*/ 0x1.cde412p-1,
	/* 734*/ 0x1.ce3ab4p-1,
	/* 735*/ 0x1.ce910ep-1,
	/* 736*/ 0x1.cee722p-1,
	/* 737*/ 0x1.cf3ceep-1,
	/* 738*/ 0x1.cf9272p-1,
	/* 739*/ 0x1.cfe7bp-1,
	/* 740*/ 0x1.d03ca4p-1,
	/* 741*/ 0x1.d09152p-1,
	/* 742*/ 0x1.d0e5b8p-1,
	/* 743*/ 0x1.d139d6p-1,
	/* 744*/ 0x1.d18dacp-1,
	/* 745*/ 0x1.d1e13cp-1,
	/* 746*/ 0x1.d23482p-1,
	/* 747*/ 0x1.d28782p-1,
	/* 748*/ 0x1.d2da38p-1,
	/* 749*/ 0x1.d32ca6p-1,
	/* 750*/ 0x1.d37ecep-1,
	/* 751*/ 0x1.d3d0acp-1,
	/* 752*/ 0x1.d42242p-1,
	/* 753*/ 0x1.d4739p-1,
	/* 754*/ 0x1.d4c496p-1,
	/* 755*/ 0x1.d51554p-1,
	/* 756*/ 0x1.d565cap-1,
	/* 757*/ 0x1.d5b5f6p-1,
	/* 758*/ 0x1.d605dap-1,
	/* 759*/ 0x1.d65576p-1,
	/* 760*/ 0x1.d6a4cap-1,
	/* 761*/ 0x1.d6f3d4p-1,
	/* 762*/ 0x1.d74296p-1,
	/* 763*/ 0x1.d7911p-1,
	/* 764*/ 0x1.d7df4p-1,
	/* 765*/ 0x1.d82d28p-1,
	/* 766*/ 0x1.d87ac8p-1,
	/* 767*/ 0x1.d8c81ep-1,
	/* 768*/ 0x1.d9152ap-1,
	/* 769*/ 0x1.d961eep-1,
	/* 770*/ 0x1.d9ae6ap-1,
	/* 771*/ 0x1.d9fa9cp-1,
	/* 772*/ 0x1.da4684p-1,
	/* 773*/ 0x1.da9224p-1,
	/* 774*/ 0x1.dadd7ap-1,
	/* 775*/ 0x1.db2888p-1,
	/* 776*/ 0x1.db734ap-1,
	/* 777*/ 0x1.dbbdc6p-1,
	/* 778*/ 0x1.dc07f6p-1,
	/* 779*/ 0x1.dc51dep-1,
	/* 780*/ 0x1.dc9b7cp-1,
	/* 781*/ 0x1.dce4dp-1,
	/* 782*/ 0x1.dd2ddcp-1,
	/* 783*/ 0x1.dd769ep-1,
	/* 784*/ 0x1.ddbf16p-1,
	/* 785*/ 0x1.de0744p-1,
	/* 786*/ 0x1.de4f28p-1,
	/* 787*/ 0x1.de96c2p-1,
	/* 788*/ 0x1.dede12p-1,
	/* 789*/ 0x1.df251ap-1,
	/* 790*/ 0x1.df6bd6p-1,
	/* 791*/ 0x1.dfb248p-1,
	/* 792*/ 0x1.dff872p-1,
	/* 793*/ 0x1.e03e5p-1,
	/* 794*/ 0x1.e083e6p-1,
	/* 795*/ 0x1.e0c93p-1,
	/* 796*/ 0x1.e10e3p-1,
	/* 797*/ 0x1.e152e6p-1,
	/* 798*/ 0x1.e19752p-1,
	/* 799*/ 0x1.e1db74p-1,
	/* 800*/ 0x1.e21f4ap-1,
	/* 801*/ 0x1.e262d8p-1,
	/* 802*/ 0x1.e2a61ap-1,
	/* 803*/ 0x1.e2e912p-1,
	/* 804*/ 0x1.e32bcp-1,
	/* 805*/ 0x1.e36e22p-1,
	/* 806*/ 0x1.e3b03ap-1,
	/* 807*/ 0x1.e3f208p-1,
	/* 808*/ 0x1.e4338cp-1,
	/* 809*/ 0x1.e474c4p-1,
	/* 810*/ 0x1.e4b5b2p-1,
	/* 811*/ 0x1.e4f654p-1,
	/* 812*/ 0x1.e536acp-1,
	/* 813*/ 0x1.e576bap-1,
	/* 814*/ 0x1.e5b67cp-1,
	/* 815*/ 0x1.e5f5f2p-1,
	/* 816*/ 0x1.e6351ep-1,
	/* 817*/ 0x1.e674p-1,
	/* 818*/ 0x1.e6b296p-1,
	/* 819*/ 0x1.e6f0e2p-1,
	/* 820*/ 0x1.e72ee2p-1,
	/* 821*/ 0x1.e76c96p-1,
	/* 822*/ 0x1.e7aap-1,
	/* 823*/ 0x1.e7e71ep-1,
	/* 824*/ 0x1.e823f2p-1,
	/* 825*/ 0x1.e8607ap-1,
	/* 826*/ 0x1.e89cb6p-1,
	/* 827*/ 0x1.e8d8a6p-1,
	/* 828*/ 0x1.e9144cp-1,
	/* 829*/ 0x1.e94fa6p-1,
	/* 830*/ 0x1.e98ab6p-1,
	/* 831*/ 0x1.e9c578p-1,
	/* 832*/ 0x1.e9fffp-1,
	/* 833*/ 0x1.ea3a1cp-1,
	/* 834*/ 0x1.ea73fcp-1,
	/* 835*/ 0x1.eaad9p-1,
	/* 836*/ 0x1.eae6dap-1,
	/* 837*/ 0x1.eb1fd8p-1,
	/* 838*/ 0x1.eb5888p-1,
	/* 839*/ 0x1.eb90eep-1,
	/* 840*/ 0x1.ebc908p-1,
	/* 841*/ 0x1.ec00d6p-1,
	/* 842*/ 0x1.ec3858p-1,
	/* 843*/ 0x1.ec6f8ep-1,
	/* 844*/ 0x1.eca678p-1,
	/* 845*/ 0x1.ecdd16p-1,
	/* 846*/ 0x1.ed1368p-1,
	/* 847*/ 0x1.ed496ep-1,
	/* 848*/ 0x1.ed7f28p-1,
	/* 849*/ 0x1.edb496p-1,
	/* 850*/ 0x1.ede9b8p-1,
	/* 851*/ 0x1.ee1e8cp-1,
	/* 852*/ 0x1.ee5316p-1,
	/* 853*/ 0x1.ee8752p-1,
	/* 854*/ 0x1.eebb44p-1,
	/* 855*/ 0x1.eeeee8p-1,
	/* 856*/ 0x1.ef224p-1,
	/* 857*/ 0x1.ef554ap-1,
	/* 858*/ 0x1.ef880ap-1,
	/* 859*/ 0x1.efba7cp-1,
	/* 860*/ 0x1.efeca2p-1,
	/* 861*/ 0x1.f01e7cp-1,
	/* 862*/ 0x1.f05008p-1,
	/* 863*/ 0x1.f0814ap-1,
	/* 864*/ 0x1.f0b23ep-1,
	/* 865*/ 0x1.f0e2e4p-1,
	/* 866*/ 0x1.f1133ep-1,
	/* 867*/ 0x1.f1434cp-1,
	/* 868*/ 0x1.f1730ep-1,
	/* 869*/ 0x1.f1a282p-1,
	/* 870*/ 0x1.f1d1aap-1,
	/* 871*/ 0x1.f20084p-1,
	/* 872*/ 0x1.f22f12p-1,
	/* 873*/ 0x1.f25d54p-1,
	/* 874*/ 0x1.f28b48p-1,
	/* 875*/ 0x1.f2b8fp-1,
	/* 876*/ 0x1.f2e64ap-1,
	/* 877*/ 0x1.f31356p-1,
	/* 878*/ 0x1.f34018p-1,
	/* 879*/ 0x1.f36c8ap-1,
	/* 880*/ 0x1.f398bp-1,
	/* 881*/ 0x1.f3c48ap-1,
	/* 882*/ 0x1.f3f016p-1,
	/* 883*/ 0x1.f41b54p-1,
	/* 884*/ 0x1.f44646p-1,
	/* 885*/ 0x1.f470ecp-1,
	/* 886*/ 0x1.f49b42p-1,
	/* 887*/ 0x1.f4c54cp-1,
	/* 888*/ 0x1.f4ef0ap-1,
	/* 889*/ 0x1.f5187ap-1,
	/* 890*/ 0x1.f5419cp-1,
	/* 891*/ 0x1.f56a7p-1,
	/* 892*/ 0x1.f592f8p-1,
	/* 893*/ 0x1.f5bb32p-1,
	/* 894*/ 0x1.f5e32p-1,
	/* 895*/ 0x1.f60abep-1,
	/* 896*/ 0x1.f6321p-1,
	/* 897*/ 0x1.f65914p-1,
	/* 898*/ 0x1.f67fccp-1,
	/* 899*/ 0x1.f6a636p-1,
	/* 900*/ 0x1.f6cc52p-1,
	/* 901*/ 0x1.f6f22p-1,
	/* 902*/ 0x1.f717ap-1,
	/* 903*/ 0x1.f73cd2p-1,
	/* 904*/ 0x1.f761b8p-1,
	/* 905*/ 0x1.f7865p-1,
	/* 906*/ 0x1.f7aa9ap-1,
	/* 907*/ 0x1.f7ce96p-1,
	/* 908*/ 0x1.f7f246p-1,
	/* 909*/ 0x1.f815a6p-1,
	/* 910*/ 0x1.f838b8p-1,
	/* 911*/ 0x1.f85b7ep-1,
	/* 912*/ 0x1.f87df6p-1,
	/* 913*/ 0x1.f8a02p-1,
	/* 914*/ 0x1.f8c1fcp-1,
	/* 915*/ 0x1.f8e388p-1,
	/* 916*/ 0x1.f904c8p-1,
	/* 917*/ 0x1.f925bcp-1,
	/* 918*/ 0x1.f9466p-1,
	/* 919*/ 0x1.f966b6p-1,
	/* 920*/ 0x1.f986bep-1,
	/* 921*/ 0x1.f9a678p-1,
	/* 922*/ 0x1.f9c5e4p-1,
	/* 923*/ 0x1.f9e502p-1,
	/* 924*/ 0x1.fa03d2p-1,
	/* 925*/ 0x1.fa2254p-1,
	/* 926*/ 0x1.fa4088p-1,
	/* 927*/ 0x1.fa5e6ep-1,
	/* 928*/ 0x1.fa7c06p-1,
	/* 929*/ 0x1.fa995p-1,
	/* 930*/ 0x1.fab64ap-1,
	/* 931*/ 0x1.fad2f8p-1,
	/* 932*/ 0x1.faef56p-1,
	/* 933*/ 0x1.fb0b68p-1,
	/* 934*/ 0x1.fb272ap-1,
	/* 935*/ 0x1.fb429ep-1,
	/* 936*/ 0x1.fb5dc4p-1,
	/* 937*/ 0x1.fb789cp-1,
	/* 938*/ 0x1.fb9326p-1,
	/* 939*/ 0x1.fbad6p-1,
	/* 940*/ 0x1.fbc74ep-1,
	/* 941*/ 0x1.fbe0ecp-1,
	/* 942*/ 0x1.fbfa3cp-1,
	/* 943*/ 0x1.fc133ep-1,
	/* 944*/ 0x1.fc2bf2p-1,
	/* 945*/ 0x1.fc4456p-1,
	/* 946*/ 0x1.fc5c6ep-1,
	/* 947*/ 0x1.fc7436p-1,
	/* 948*/ 0x1.fc8baep-1,
	/* 949*/ 0x1.fca2dap-1,
	/* 950*/ 0x1.fcb9b6p-1,
	/* 951*/ 0x1.fcd046p-1,
	/* 952*/ 0x1.fce684p-1,
	/* 953*/ 0x1.fcfc76p-1,
	/* 954*/ 0x1.fd1218p-1,
	/* 955*/ 0x1.fd276cp-1,
	/* 956*/ 0x1.fd3c72p-1,
	/* 957*/ 0x1.fd512ap-1,
	/* 958*/ 0x1.fd6592p-1,
	/* 959*/ 0x1.fd79acp-1,
	/* 960*/ 0x1.fd8d76p-1,
	/* 961*/ 0x1.fda0f4p-1,
	/* 962*/ 0x1.fdb422p-1,
	/* 963*/ 0x1.fdc7p-1,
	/* 964*/ 0x1.fdd992p-1,
	/* 965*/ 0x1.fdebd4p-1,
	/* 966*/ 0x1.fdfdc6p-1,
	/* 967*/ 0x1.fe0f6cp-1,
	/* 968*/ 0x1.fe20c2p-1,
	/* 969*/ 0x1.fe31c8p-1,
	/* 970*/ 0x1.fe4282p-1,
	/* 971*/ 0x1.fe52ecp-1,
	/* 972*/ 0x1.fe6306p-1,
	/* 973*/ 0x1.fe72d2p-1,
	/* 974*/ 0x1.fe825p-1,
	/* 975*/ 0x1.fe918p-1,
	/* 976*/ 0x1.fea06p-1,
	/* 977*/ 0x1.feaefp-1,
	/* 978*/ 0x1.febd32p-1,
	/* 979*/ 0x1.fecb26p-1,
	/* 980*/ 0x1.fed8ccp-1,
	/* 981*/ 0x1.fee622p-1,
	/* 982*/ 0x1.fef328p-1,
	/* 983*/ 0x1.feffe2p-1,
	/* 984*/ 0x1.ff0c4ap-1,
	/* 985*/ 0x1.ff1866p-1,
	/* 986*/ 0x1.ff2432p-1,
	/* 987*/ 0x1.ff2faep-1,
	/* 988*/ 0x1.ff3adcp-1,
	/* 989*/ 0x1.ff45bcp-1,
	/* 990*/ 0x1.ff504cp-1,
	/* 991*/ 0x1.ff5a8ep-1,
	/* 992*/ 0x1.ff648p-1,
	/* 993*/ 0x1.ff6e24p-1,
	/* 994*/ 0x1.ff7778p-1,
	/* 995*/ 0x1.ff807ep-1,
	/* 996*/ 0x1.ff8934p-1,
	/* 997*/ 0x1.ff919cp-1,
	/* 998*/ 0x1.ff99b6p-1,
	/* 999*/ 0x1.ffa18p-1,
	/*1000*/ 0x1.ffa8fcp-1,
	/*1001*/ 0x1.ffb028p-1,
	/*1002*/ 0x1.ffb704p-1,
	/*1003*/ 0x1.ffbd94p-1,
	/*1004*/ 0x1.ffc3d2p-1,
	/*1005*/ 0x1.ffc9c4p-1,
	/*1006*/ 0x1.ffcf64p-1,
	/*1007*/ 0x1.ffd4b8p-1,
	/*1008*/ 0x1.ffd9bap-1,
	/*1009*/ 0x1.ffde7p-1,
	/*1010*/ 0x1.ffe2d4p-1,
	/*1011*/ 0x1.ffe6ecp-1,
	/*1012*/ 0x1.ffeab4p-1,
	/*1013*/ 0x1.ffee2cp-1,
	/*1014*/ 0x1.fff156p-1,
	/*1015*/ 0x1.fff43p-1,
	/*1016*/ 0x1.fff6bcp-1,
	/*1017*/ 0x1.fff8f8p-1,
	/*1018*/ 0x1.fffae6p-1,
	/*1019*/ 0x1.fffc84p-1,
	/*1020*/ 0x1.fffdd4p-1,
	/*1021*/ 0x1.fffed6p-1,
	/*1022*/ 0x1.ffff88p-1,
	/*1023*/ 0x1.ffffeap-1,
	/*1024*/ 0x1.fffffep-1,
	/*1025*/ 0x1.ffffc2p-1,
	/*1026*/ 0x1.ffff38p-1,
	/*1027*/ 0x1.fffe5ep-1,
	/*1028*/ 0x1.fffd36p-1,
	/*1029*/ 0x1.fffbcp-1,
	/*1030*/ 0x1.fff9fap-1,
	/*1031*/ 0x1.fff7e4p-1,
	/*1032*/ 0x1.fff58p-1,
	/*1033*/ 0x1.fff2ccp-1,
	/*1034*/ 0x1.ffefcap-1,
	/*1035*/ 0x1.ffec7ap-1,
	/*1036*/ 0x1.ffe8dap-1,
	/*1037*/ 0x1.ffe4eap-1,
	/*1038*/ 0x1.ffe0acp-1,
	/*1039*/ 0x1.ffdc1ep-1,
	/*1040*/ 0x1.ffd742p-1,
	/*1041*/ 0x1.ffd218p-1,
	/*1042*/ 0x1.ffcc9ep-1,
	/*1043*/ 0x1.ffc6d4p-1,
	/*1044*/ 0x1.ffc0bcp-1,
	/*1045*/ 0x1.ffba56p-1,
	/*1046*/ 0x1.ffb3ap-1,
	/*1047*/ 0x1.ffac9cp-1,
	/*1048*/ 0x1.ffa548p-1,
	/*1049*/ 0x1.ff9da4p-1,
	/*1050*/ 0x1.ff95b4p-1,
	/*1051*/ 0x1.ff8d72p-1,
	/*1052*/ 0x1.ff84e4p-1,
	/*1053*/ 0x1.ff7c04p-1,
	/*1054*/ 0x1.ff72d8p-1,
	/*1055*/ 0x1.ff695cp-1,
	/*1056*/ 0x1.ff5f9p-1,
	/*1057*/ 0x1.ff5576p-1,
	/*1058*/ 0x1.ff4b0ep-1,
	/*1059*/ 0x1.ff4056p-1,
	/*1060*/ 0x1.ff354ep-1,
	/*1061*/ 0x1.ff29fap-1,
	/*1062*/ 0x1.ff1e54p-1,
	/*1063*/ 0x1.ff1262p-1,
	/*1064*/ 0x1.ff062p-1,
	/*1065*/ 0x1.fef98ep-1,
	/*1066*/ 0x1.feecaep-1,
	/*1067*/ 0x1.fedf8p-1,
	/*1068*/ 0x1.fed202p-1,
	/*1069*/ 0x1.fec436p-1,
	/*1070*/ 0x1.feb61cp-1,
	/*1071*/ 0x1.fea7b2p-1,
	/*1072*/ 0x1.fe98f8p-1,
	/*1073*/ 0x1.fe89f2p-1,
	/*1074*/ 0x1.fe7a9cp-1,
	/*1075*/ 0x1.fe6af6p-1,
	/*1076*/ 0x1.fe5b02p-1,
	/*1077*/ 0x1.fe4acp-1,
	/*1078*/ 0x1.fe3a2ep-1,
	/*1079*/ 0x1.fe294ep-1,
	/*1080*/ 0x1.fe182p-1,
	/*1081*/ 0x1.fe06a2p-1,
	/*1082*/ 0x1.fdf4d6p-1,
	/*1083*/ 0x1.fde2bcp-1,
	/*1084*/ 0x1.fdd052p-1,
	/*1085*/ 0x1.fdbd9ap-1,
	/*1086*/ 0x1.fdaa94p-1,
	/*1087*/ 0x1.fd973ep-1,
	/*1088*/ 0x1.fd839ap-1,
	/*1089*/ 0x1.fd6fa8p-1,
	/*1090*/ 0x1.fd5b68p-1,
	/*1091*/ 0x1.fd46d8p-1,
	/*1092*/ 0x1.fd31fap-1,
	/*1093*/ 0x1.fd1cccp-1,
	/*1094*/ 0x1.fd075p-1,
	/*1095*/ 0x1.fcf186p-1,
	/*1096*/ 0x1.fcdb6ep-1,
	/*1097*/ 0x1.fcc508p-1,
	/*1098*/ 0x1.fcae52p-1,
	/*1099*/ 0x1.fc974ep-1,
	/*1100*/ 0x1.fc7ffcp-1,
	/*1101*/ 0x1.fc685ap-1,
	/*1102*/ 0x1.fc506cp-1,
	/*1103*/ 0x1.fc382ep-1,
	/*1104*/ 0x1.fc1fa2p-1,
	/*1105*/ 0x1.fc06c6p-1,
	/*1106*/ 0x1.fbed9ep-1,
	/*1107*/ 0x1.fbd426p-1,
	/*1108*/ 0x1.fbba6p-1,
	/*1109*/ 0x1.fba04cp-1,
	/*1110*/ 0x1.fb85eap-1,
	/*1111*/ 0x1.fb6b3ap-1,
	/*1112*/ 0x1.fb503ap-1,
	/*1113*/ 0x1.fb34eep-1,
	/*1114*/ 0x1.fb1952p-1,
	/*1115*/ 0x1.fafd68p-1,
	/*1116*/ 0x1.fae13p-1,
	/*1117*/ 0x1.fac4aap-1,
	/*1118*/ 0x1.faa7d6p-1,
	/*1119*/ 0x1.fa8ab4p-1,
	/*1120*/ 0x1.fa6d44p-1,
	/*1121*/ 0x1.fa4f84p-1,
	/*1122*/ 0x1.fa3178p-1,
	/*1123*/ 0x1.fa131cp-1,
	/*1124*/ 0x1.f9f474p-1,
	/*1125*/ 0x1.f9d57cp-1,
	/*1126*/ 0x1.f9b638p-1,
	/*1127*/ 0x1.f996a4p-1,
	/*1128*/ 0x1.f976c2p-1,
	/*1129*/ 0x1.f95694p-1,
	/*1130*/ 0x1.f93616p-1,
	/*1131*/ 0x1.f9154cp-1,
	/*1132*/ 0x1.f8f432p-1,
	/*1133*/ 0x1.f8d2ccp-1,
	/*1134*/ 0x1.f8b116p-1,
	/*1135*/ 0x1.f88f14p-1,
	/*1136*/ 0x1.f86cc4p-1,
	/*1137*/ 0x1.f84a24p-1,
	/*1138*/ 0x1.f82738p-1,
	/*1139*/ 0x1.f803fep-1,
	/*1140*/ 0x1.f7e078p-1,
	/*1141*/ 0x1.f7bca2p-1,
	/*1142*/ 0x1.f7987ep-1,
	/*1143*/ 0x1.f7740ep-1,
	/*1144*/ 0x1.f74f4ep-1,
	/*1145*/ 0x1.f72a42p-1,
	/*1146*/ 0x1.f704e8p-1,
	/*1147*/ 0x1.f6df42p-1,
	/*1148*/ 0x1.f6b94cp-1,
	/*1149*/ 0x1.f6930ap-1,
	/*1150*/ 0x1.f66c7ap-1,
	/*1151*/ 0x1.f6459cp-1,
	/*1152*/ 0x1.f61e7p-1,
	/*1153*/ 0x1.f5f6f8p-1,
	/*1154*/ 0x1.f5cf32p-1,
	/*1155*/ 0x1.f5a71ep-1,
	/*1156*/ 0x1.f57ebep-1,
	/*1157*/ 0x1.f5561p-1,
	/*1158*/ 0x1.f52d14p-1,
	/*1159*/ 0x1.f503cap-1,
	/*1160*/ 0x1.f4da34p-1,
	/*1161*/ 0x1.f4b05p-1,
	/*1162*/ 0x1.f4862p-1,
	/*1163*/ 0x1.f45ba2p-1,
	/*1164*/ 0x1.f430d6p-1,
	/*1165*/ 0x1.f405bep-1,
	/*1166*/ 0x1.f3da5ap-1,
	/*1167*/ 0x1.f3aea6p-1,
	/*1168*/ 0x1.f382a6p-1,
	/*1169*/ 0x1.f3565ap-1,
	/*1170*/ 0x1.f329cp-1,
	/*1171*/ 0x1.f2fcdap-1,
	/*1172*/ 0x1.f2cfa6p-1,
	/*1173*/ 0x1.f2a224p-1,
	/*1174*/ 0x1.f27456p-1,
	/*1175*/ 0x1.f2463cp-1,
	/*1176*/ 0x1.f217d4p-1,
	/*1177*/ 0x1.f1e92p-1,
	/*1178*/ 0x1.f1ba1ep-1,
	/*1179*/ 0x1.f18adp-1,
	/*1180*/ 0x1.f15b36p-1,
	/*1181*/ 0x1.f12b4ep-1,
	/*1182*/ 0x1.f0fb1ap-1,
	/*1183*/ 0x1.f0ca9ap-1,
	/*1184*/ 0x1.f099ccp-1,
	/*1185*/ 0x1.f068b2p-1,
	/*1186*/ 0x1.f0374cp-1,
	/*1187*/ 0x1.f00598p-1,
	/*1188*/ 0x1.efd398p-1,
	/*1189*/ 0x1.efa14cp-1,
	/*1190*/ 0x1.ef6eb2p-1,
	/*1191*/ 0x1.ef3bcep-1,
	/*1192*/ 0x1.ef089cp-1,
	/*1193*/ 0x1.eed51ep-1,
	/*1194*/ 0x1.eea154p-1,
	/*1195*/ 0x1.ee6d3cp-1,
	/*1196*/ 0x1.ee38dap-1,
	/*1197*/ 0x1.ee042ap-1,
	/*1198*/ 0x1.edcf3p-1,
	/*1199*/ 0x1.ed99e8p-1,
	/*1200*/ 0x1.ed6454p-1,
	/*1201*/ 0x1.ed2e74p-1,
	/*1202*/ 0x1.ecf848p-1,
	/*1203*/ 0x1.ecc1dp-1,
	/*1204*/ 0x1.ec8b0cp-1,
	/*1205*/ 0x1.ec53fcp-1,
	/*1206*/ 0x1.ec1cap-1,
	/*1207*/ 0x1.ebe4f8p-1,
	/*1208*/ 0x1.ebad04p-1,
	/*1209*/ 0x1.eb74c4p-1,
	/*1210*/ 0x1.eb3c38p-1,
	/*1211*/ 0x1.eb0362p-1,
	/*1212*/ 0x1.eaca3ep-1,
	/*1213*/ 0x1.ea90dp-1,
	/*1214*/ 0x1.ea5714p-1,
	/*1215*/ 0x1.ea1d0ep-1,
	/*1216*/ 0x1.e9e2bcp-1,
	/*1217*/ 0x1.e9a82p-1,
	/*1218*/ 0x1.e96d36p-1,
	/*1219*/ 0x1.e93202p-1,
	/*1220*/ 0x1.e8f682p-1,
	/*1221*/ 0x1.e8bab6p-1,
	/*1222*/ 0x1.e87eap-1,
	/*1223*/ 0x1.e8423ep-1,
	/*1224*/ 0x1.e8059p-1,
	/*1225*/ 0x1.e7c898p-1,
	/*1226*/ 0x1.e78b54p-1,
	/*1227*/ 0x1.e74dc4p-1,
	/*1228*/ 0x1.e70feap-1,
	/*1229*/ 0x1.e6d1c4p-1,
	/*1230*/ 0x1.e69354p-1,
	/*1231*/ 0x1.e65498p-1,
	/*1232*/ 0x1.e61592p-1,
	/*1233*/ 0x1.e5d64p-1,
	/*1234*/ 0x1.e596a2p-1,
	/*1235*/ 0x1.e556bcp-1,
	/*1236*/ 0x1.e51688p-1,
	/*1237*/ 0x1.e4d60cp-1,
	/*1238*/ 0x1.e49544p-1,
	/*1239*/ 0x1.e4543p-1,
	/*1240*/ 0x1.e412d2p-1,
	/*1241*/ 0x1.e3d12ap-1,
	/*1242*/ 0x1.e38f38p-1,
	/*1243*/ 0x1.e34cfap-1,
	/*1244*/ 0x1.e30a72p-1,
	/*1245*/ 0x1.e2c79ep-1,
	/*1246*/ 0x1.e28482p-1,
	/*1247*/ 0x1.e2411ap-1,
	/*1248*/ 0x1.e1fd68p-1,
	/*1249*/ 0x1.e1b96cp-1,
	/*1250*/ 0x1.e17524p-1,
	/*1251*/ 0x1.e13094p-1,
	/*1252*/ 0x1.e0ebb8p-1,
	/*1253*/ 0x1.e0a692p-1,
	/*1254*/ 0x1.e06124p-1,
	/*1255*/ 0x1.e01b6ap-1,
	/*1256*/ 0x1.dfd566p-1,
	/*1257*/ 0x1.df8f18p-1,
	/*1258*/ 0x1.df488p-1,
	/*1259*/ 0x1.df019ep-1,
	/*1260*/ 0x1.deba72p-1,
	/*1261*/ 0x1.de72fcp-1,
	/*1262*/ 0x1.de2b3ep-1,
	/*1263*/ 0x1.dde334p-1,
	/*1264*/ 0x1.dd9ae2p-1,
	/*1265*/ 0x1.dd5244p-1,
	/*1266*/ 0x1.dd095ep-1,
	/*1267*/ 0x1.dcc02ep-1,
	/*1268*/ 0x1.dc76b6p-1,
	/*1269*/ 0x1.dc2cf2p-1,
	/*1270*/ 0x1.dbe2e6p-1,
	/*1271*/ 0x1.db989p-1,
	/*1272*/ 0x1.db4df2p-1,
	/*1273*/ 0x1.db0308p-1,
	/*1274*/ 0x1.dab7d6p-1,
	/*1275*/ 0x1.da6c5cp-1,
	/*1276*/ 0x1.da2098p-1,
	/*1277*/ 0x1.d9d48ap-1,
	/*1278*/ 0x1.d98834p-1,
	/*1279*/ 0x1.d93b94p-1,
	/*1280*/ 0x1.d8eeacp-1,
	/*1281*/ 0x1.d8a17ap-1,
	/*1282*/ 0x1.d854p-1,
	/*1283*/ 0x1.d8063cp-1,
	/*1284*/ 0x1.d7b83p-1,
	/*1285*/ 0x1.d769dcp-1,
	/*1286*/ 0x1.d71b3ep-1,
	/*1287*/ 0x1.d6cc58p-1,
	/*1288*/ 0x1.d67d28p-1,
	/*1289*/ 0x1.d62dbp-1,
	/*1290*/ 0x1.d5ddfp-1,
	/*1291*/ 0x1.d58de8p-1,
	/*1292*/ 0x1.d53d98p-1,
	/*1293*/ 0x1.d4ecfep-1,
	/*1294*/ 0x1.d49c1cp-1,
	/*1295*/ 0x1.d44af2p-1,
	/*1296*/ 0x1.d3f98p-1,
	/*1297*/ 0x1.d3a7c4p-1,
	/*1298*/ 0x1.d355c2p-1,
	/*1299*/ 0x1.d30378p-1,
	/*1300*/ 0x1.d2b0e4p-1,
	/*1301*/ 0x1.d25e0ap-1,
	/*1302*/ 0x1.d20ae6p-1,
	/*1303*/ 0x1.d1b77cp-1,
	/*1304*/ 0x1.d163cap-1,
	/*1305*/ 0x1.d10fdp-1,
	/*1306*/ 0x1.d0bb8cp-1,
	/*1307*/ 0x1.d06704p-1,
	/*1308*/ 0x1.d01232p-1,
	/*1309*/ 0x1.cfbd18p-1,
	/*1310*/ 0x1.cf67b8p-1,
	/*1311*/ 0x1.cf121p-1,
	/*1312*/ 0x1.cebc2p-1,
	/*1313*/ 0x1.ce65eap-1,
	/*1314*/ 0x1.ce0f6ap-1,
	/*1315*/ 0x1.cdb8a6p-1,
	/*1316*/ 0x1.cd6198p-1,
	/*1317*/ 0x1.cd0a44p-1,
	/*1318*/ 0x1.ccb2a8p-1,
	/*1319*/ 0x1.cc5ac6p-1,
	/*1320*/ 0x1.cc029ep-1,
	/*1321*/ 0x1.cbaa2ep-1,
	/*1322*/ 0x1.cb5176p-1,
	/*1323*/ 0x1.caf878p-1,
	/*1324*/ 0x1.ca9f34p-1,
	/*1325*/ 0x1.ca45a8p-1,
	/*1326*/ 0x1.c9ebd6p-1,
	/*1327*/ 0x1.c991bcp-1,
	/*1328*/ 0x1.c9375cp-1,
	/*1329*/ 0x1.c8dcb6p-1,
	/*1330*/ 0x1.c881cap-1,
	/*1331*/ 0x1.c82696p-1,
	/*1332*/ 0x1.c7cb1ep-1,
	/*1333*/ 0x1.c76f5ep-1,
	/*1334*/ 0x1.c71358p-1,
	/*1335*/ 0x1.c6b70cp-1,
	/*1336*/ 0x1.c65a7ap-1,
	/*1337*/ 0x1.c5fdap-1,
	/*1338*/ 0x1.c5a082p-1,
	/*1339*/ 0x1.c5431ep-1,
	/*1340*/ 0x1.c4e574p-1,
	/*1341*/ 0x1.c48782p-1,
	/*1342*/ 0x1.c4294cp-1,
	/*1343*/ 0x1.c3cadp-1,
	/*1344*/ 0x1.c36c1p-1,
	/*1345*/ 0x1.c30d08p-1,
	/*1346*/ 0x1.c2adbap-1,
	/*1347*/ 0x1.c24e28p-1,
	/*1348*/ 0x1.c1ee5p-1,
	/*1349*/ 0x1.c18e34p-1,
	/*1350*/ 0x1.c12ddp-1,
	/*1351*/ 0x1.c0cd28p-1,
	/*1352*/ 0x1.c06c3cp-1,
	/*1353*/ 0x1.c00b0ap-1,
	/*1354*/ 0x1.bfa992p-1,
	/*1355*/ 0x1.bf47d6p-1,
	/*1356*/ 0x1.bee5d4p-1,
	/*1357*/ 0x1.be838ep-1,
	/*1358*/ 0x1.be2102p-1,
	/*1359*/ 0x1.bdbe32p-1,
	/*1360*/ 0x1.bd5b1cp-1,
	/*1361*/ 0x1.bcf7c2p-1,
	/*1362*/ 0x1.bc9424p-1,
	/*1363*/ 0x1.bc3042p-1,
	/*1364*/ 0x1.bbcc1ap-1,
	/*1365*/ 0x1.bb67aep-1,
	/*1366*/ 0x1.bb02fep-1,
	/*1367*/ 0x1.ba9e08p-1,
	/*1368*/ 0x1.ba38dp-1,
	/*1369*/ 0x1.b9d352p-1,
	/*1370*/ 0x1.b96d9p-1,
	/*1371*/ 0x1.b9078cp-1,
	/*1372*/ 0x1.b8a142p-1,
	/*1373*/ 0x1.b83ab4p-1,
	/*1374*/ 0x1.b7d3e2p-1,
	/*1375*/ 0x1.b76ccep-1,
	/*1376*/ 0x1.b70574p-1,
	/*1377*/ 0x1.b69dd6p-1,
	/*1378*/ 0x1.b635f6p-1,
	/*1379*/ 0x1.b5cdd2p-1,
	/*1380*/ 0x1.b5656ap-1,
	/*1381*/ 0x1.b4fccp-1,
	/*1382*/ 0x1.b493dp-1,
	/*1383*/ 0x1.b42a9ep-1,
	/*1384*/ 0x1.b3c12ap-1,
	/*1385*/ 0x1.b3577p-1,
	/*1386*/ 0x1.b2ed76p-1,
	/*1387*/ 0x1.b28336p-1,
	/*1388*/ 0x1.b218b4p-1,
	/*1389*/ 0x1.b1adfp-1,
	/*1390*/ 0x1.b142e8p-1,
	/*1391*/ 0x1.b0d79ep-1,
	/*1392*/ 0x1.b06c1p-1,
	/*1393*/ 0x1.b0004p-1,
	/*1394*/ 0x1.af942ep-1,
	/*1395*/ 0x1.af27d8p-1,
	/*1396*/ 0x1.aebb4p-1,
	/*1397*/ 0x1.ae4e66p-1,
	/*1398*/ 0x1.ade14ap-1,
	/*1399*/ 0x1.ad73eap-1,
	/*1400*/ 0x1.ad0648p-1,
	/*1401*/ 0x1.ac9866p-1,
	/*1402*/ 0x1.ac2a4p-1,
	/*1403*/ 0x1.abbbd8p-1,
	/*1404*/ 0x1.ab4d2ep-1,
	/*1405*/ 0x1.aade42p-1,
	/*1406*/ 0x1.aa6f16p-1,
	/*1407*/ 0x1.a9ffa6p-1,
	/*1408*/ 0x1.a98ff6p-1,
	/*1409*/ 0x1.a92002p-1,
	/*1410*/ 0x1.a8afcep-1,
	/*1411*/ 0x1.a83f58p-1,
	/*1412*/ 0x1.a7cea2p-1,
	/*1413*/ 0x1.a75daap-1,
	/*1414*/ 0x1.a6ec7p-1,
	/*1415*/ 0x1.a67af4p-1,
	/*1416*/ 0x1.a60938p-1,
	/*1417*/ 0x1.a5973ap-1,
	/*1418*/ 0x1.a524fcp-1,
	/*1419*/ 0x1.a4b27cp-1,
	/*1420*/ 0x1.a43fbcp-1,
	/*1421*/ 0x1.a3ccbap-1,
	/*1422*/ 0x1.a35978p-1,
	/*1423*/ 0x1.a2e5f6p-1,
	/*1424*/ 0x1.a27232p-1,
	/*1425*/ 0x1.a1fe2ep-1,
	/*1426*/ 0x1.a189eap-1,
	/*1427*/ 0x1.a11566p-1,
	/*1428*/ 0x1.a0a0ap-1,
	/*1429*/ 0x1.a02b9cp-1,
	/*1430*/ 0x1.9fb656p-1,
	/*1431*/ 0x1.9f40dp-1,
	/*1432*/ 0x1.9ecb0ap-1,
	/*1433*/ 0x1.9e5504p-1,
	/*1434*/ 0x1.9ddebep-1,
	/*1435*/ 0x1.9d6838p-1,
	/*1436*/ 0x1.9cf174p-1,
	/*1437*/ 0x1.9c7a6ep-1,
	/*1438*/ 0x1.9c032ap-1,
	/*1439*/ 0x1.9b8ba6p-1,
	/*1440*/ 0x1.9b13e2p-1,
	/*1441*/ 0x1.9a9bdep-1,
	/*1442*/ 0x1.9a239cp-1,
	/*1443*/ 0x1.99ab1ap-1,
	/*1444*/ 0x1.993258p-1,
	/*1445*/ 0x1.98b958p-1,
	/*1446*/ 0x1.98401ap-1,
	/*1447*/ 0x1.97c69ap-1,
	/*1448*/ 0x1.974cdep-1,
	/*1449*/ 0x1.96d2e2p-1,
	/*1450*/ 0x1.9658a6p-1,
	/*1451*/ 0x1.95de2ep-1,
	/*1452*/ 0x1.956376p-1,
	/*1453*/ 0x1.94e87ep-1,
	/*1454*/ 0x1.946d4ap-1,
	/*1455*/ 0x1.93f1d6p-1,
	/*1456*/ 0x1.937624p-1,
	/*1457*/ 0x1.92fa34p-1,
	/*1458*/ 0x1.927e06p-1,
	/*1459*/ 0x1.92019ap-1,
	/*1460*/ 0x1.9184eep-1,
	/*1461*/ 0x1.910806p-1,
	/*1462*/ 0x1.908aep-1,
	/*1463*/ 0x1.900d7cp-1,
	/*1464*/ 0x1.8f8fdap-1,
	/*1465*/ 0x1.8f11fcp-1,
	/*1466*/ 0x1.8e93dep-1,
	/*1467*/ 0x1.8e1584p-1,
	/*1468*/ 0x1.8d96ecp-1,
	/*1469*/ 0x1.8d1816p-1,
	/*1470*/ 0x1.8c9904p-1,
	/*1471*/ 0x1.8c19b4p-1,
	/*1472*/ 0x1.8b9a28p-1,
	/*1473*/ 0x1.8b1a5ep-1,
	/*1474*/ 0x1.8a9a58p-1,
	/*1475*/ 0x1.8a1a14p-1,
	/*1476*/ 0x1.899994p-1,
	/*1477*/ 0x1.8918d6p-1,
	/*1478*/ 0x1.8897dcp-1,
	/*1479*/ 0x1.8816a6p-1,
	/*1480*/ 0x1.879532p-1,
	/*1481*/ 0x1.871384p-1,
	/*1482*/ 0x1.869198p-1,
	/*1483*/ 0x1.860f7p-1,
	/*1484*/ 0x1.858d0cp-1,
	/*1485*/ 0x1.850a6cp-1,
	/*1486*/ 0x1.84879p-1,
	/*1487*/ 0x1.840478p-1,
	/*1488*/ 0x1.838124p-1,
	/*1489*/ 0x1.82fd94p-1,
	/*1490*/ 0x1.8279c8p-1,
	/*1491*/ 0x1.81f5cp-1,
	/*1492*/ 0x1.81717ep-1,
	/*1493*/ 0x1.80edp-1,
	/*1494*/ 0x1.806846p-1,
	/*1495*/ 0x1.7fe352p-1,
	/*1496*/ 0x1.7f5e2p-1,
	/*1497*/ 0x1.7ed8b6p-1,
	/*1498*/ 0x1.7e531p-1,
	/*1499*/ 0x1.7dcd2ep-1,
	/*1500*/ 0x1.7d4712p-1,
	/*1501*/ 0x1.7cc0bap-1,
	/*1502*/ 0x1.7c3a28p-1,
	/*1503*/ 0x1.7bb35cp-1,
	/*1504*/ 0x1.7b2c56p-1,
	/*1505*/ 0x1.7aa514p-1,
	/*1506*/ 0x1.7a1d98p-1,
	/*1507*/ 0x1.7995e2p-1,
	/*1508*/ 0x1.790df2p-1,
	/*1509*/ 0x1.7885c6p-1,
	/*1510*/ 0x1.77fd62p-1,
	/*1511*/ 0x1.7774c2p-1,
	/*1512*/ 0x1.76ebeap-1,
	/*1513*/ 0x1.7662d8p-1,
	/*1514*/ 0x1.75d98ap-1,
	/*1515*/ 0x1.755004p-1,
	/*1516*/ 0x1.74c646p-1,
	/*1517*/ 0x1.743c4cp-1,
	/*1518*/ 0x1.73b21ap-1,
	/*1519*/ 0x1.7327aep-1,
	/*1520*/ 0x1.729d08p-1,
	/*1521*/ 0x1.72122ap-1,
	/*1522*/ 0x1.718712p-1,
	/*1523*/ 0x1.70fbc2p-1,
	/*1524*/ 0x1.707038p-1,
	/*1525*/ 0x1.6fe476p-1,
	/*1526*/ 0x1.6f587ap-1,
	/*1527*/ 0x1.6ecc48p-1,
	/*1528*/ 0x1.6e3fdap-1,
	/*1529*/ 0x1.6db336p-1,
	/*1530*/ 0x1.6d2658p-1,
	/*1531*/ 0x1.6c9944p-1,
	/*1532*/ 0x1.6c0bf6p-1,
	/*1533*/ 0x1.6b7e7p-1,
	/*1534*/ 0x1.6af0b2p-1,
	/*1535*/ 0x1.6a62bcp-1,
	/*1536*/ 0x1.69d48ep-1,
	/*1537*/ 0x1.694628p-1,
	/*1538*/ 0x1.68b78ap-1,
	/*1539*/ 0x1.6828b4p-1,
	/*1540*/ 0x1.6799a8p-1,
	/*1541*/ 0x1.670a64p-1,
	/*1542*/ 0x1.667ae8p-1,
	/*1543*/ 0x1.65eb34p-1,
	/*1544*/ 0x1.655b4ap-1,
	/*1545*/ 0x1.64cb2ap-1,
	/*1546*/ 0x1.643adp-1,
	/*1547*/ 0x1.63aa42p-1,
	/*1548*/ 0x1.63197cp-1,
	/*1549*/ 0x1.62887ep-1,
	/*1550*/ 0x1.61f74ap-1,
	/*1551*/ 0x1.6165ep-1,
	/*1552*/ 0x1.60d44p-1,
	/*1553*/ 0x1.604268p-1,
	/*1554*/ 0x1.5fb05ap-1,
	/*1555*/ 0x1.5f1e16p-1,
	/*1556*/ 0x1.5e8b9cp-1,
	/*1557*/ 0x1.5df8ecp-1,
	/*1558*/ 0x1.5d6606p-1,
	/*1559*/ 0x1.5cd2eap-1,
	/*1560*/ 0x1.5c3f98p-1,
	/*1561*/ 0x1.5bac1p-1,
	/*1562*/ 0x1.5b1854p-1,
	/*1563*/ 0x1.5a846p-1,
	/*1564*/ 0x1.59f038p-1,
	/*1565*/ 0x1.595bdap-1,
	/*1566*/ 0x1.58c748p-1,
	/*1567*/ 0x1.58328p-1,
	/*1568*/ 0x1.579d82p-1,
	/*1569*/ 0x1.57085p-1,
	/*1570*/ 0x1.5672eap-1,
	/*1571*/ 0x1.55dd4ep-1,
	/*1572*/ 0x1.55477cp-1,
	/*1573*/ 0x1.54b178p-1,
	/*1574*/ 0x1.541b3ep-1,
	/*1575*/ 0x1.5384cep-1,
	/*1576*/ 0x1.52ee2cp-1,
	/*1577*/ 0x1.525754p-1,
	/*1578*/ 0x1.51c04ap-1,
	/*1579*/ 0x1.51290ap-1,
	/*1580*/ 0x1.509196p-1,
	/*1581*/ 0x1.4ff9fp-1,
	/*1582*/ 0x1.4f6214p-1,
	/*1583*/ 0x1.4eca04p-1,
	/*1584*/ 0x1.4e31c2p-1,
	/*1585*/ 0x1.4d994cp-1,
	/*1586*/ 0x1.4d00a2p-1,
	/*1587*/ 0x1.4c67c6p-1,
	/*1588*/ 0x1.4bceb6p-1,
	/*1589*/ 0x1.4b3572p-1,
	/*1590*/ 0x1.4a9bfcp-1,
	/*1591*/ 0x1.4a0252p-1,
	/*1592*/ 0x1.496874p-1,
	/*1593*/ 0x1.48ce66p-1,
	/*1594*/ 0x1.483424p-1,
	/*1595*/ 0x1.4799aep-1,
	/*1596*/ 0x1.46ff08p-1,
	/*1597*/ 0x1.46642ep-1,
	/*1598*/ 0x1.45c922p-1,
	/*1599*/ 0x1.452de4p-1,
	/*1600*/ 0x1.449272p-1,
	/*1601*/ 0x1.43f6dp-1,
	/*1602*/ 0x1.435afcp-1,
	/*1603*/ 0x1.42bef6p-1,
	/*1604*/ 0x1.4222bcp-1,
	/*1605*/ 0x1.418652p-1,
	/*1606*/ 0x1.40e9b8p-1,
	/*1607*/ 0x1.404ceap-1,
	/*1608*/ 0x1.3fafecp-1,
	/*1609*/ 0x1.3f12bcp-1,
	/*1610*/ 0x1.3e755ap-1,
	/*1611*/ 0x1.3dd7c8p-1,
	/*1612*/ 0x1.3d3a06p-1,
	/*1613*/ 0x1.3c9c12p-1,
	/*1614*/ 0x1.3bfdecp-1,
	/*1615*/ 0x1.3b5f96p-1,
	/*1616*/ 0x1.3ac11p-1,
	/*1617*/ 0x1.3a225ap-1,
	/*1618*/ 0x1.398372p-1,
	/*1619*/ 0x1.38e45ap-1,
	/*1620*/ 0x1.384512p-1,
	/*1621*/ 0x1.37a59ap-1,
	/*1622*/ 0x1.3705f2p-1,
	/*1623*/ 0x1.366618p-1,
	/*1624*/ 0x1.35c61p-1,
	/*1625*/ 0x1.3525d8p-1,
	/*1626*/ 0x1.34857p-1,
	/*1627*/ 0x1.33e4dap-1,
	/*1628*/ 0x1.334412p-1,
	/*1629*/ 0x1.32a31cp-1,
	/*1630*/ 0x1.3201f6p-1,
	/*1631*/ 0x1.3160a2p-1,
	/*1632*/ 0x1.30bf1ep-1,
	/*1633*/ 0x1.301d6cp-1,
	/*1634*/ 0x1.2f7b8ap-1,
	/*1635*/ 0x1.2ed978p-1,
	/*1636*/ 0x1.2e373ap-1,
	/*1637*/ 0x1.2d94ccp-1,
	/*1638*/ 0x1.2cf22ep-1,
	/*1639*/ 0x1.2c4f64p-1,
	/*1640*/ 0x1.2bac6ap-1,
	/*1641*/ 0x1.2b0942p-1,
	/*1642*/ 0x1.2a65eep-1,
	/*1643*/ 0x1.29c26ap-1,
	/*1644*/ 0x1.291eb8p-1,
	/*1645*/ 0x1.287ad8p-1,
	/*1646*/ 0x1.27d6cap-1,
	/*1647*/ 0x1.27329p-1,
	/*1648*/ 0x1.268e28p-1,
	/*1649*/ 0x1.25e992p-1,
	/*1650*/ 0x1.2544cep-1,
	/*1651*/ 0x1.249fdep-1,
	/*1652*/ 0x1.23facp-1,
	/*1653*/ 0x1.235576p-1,
	/*1654*/ 0x1.22affep-1,
	/*1655*/ 0x1.220a5ap-1,
	/*1656*/ 0x1.216488p-1,
	/*1657*/ 0x1.20be8ap-1,
	/*1658*/ 0x1.20186p-1,
	/*1659*/ 0x1.1f720ap-1,
	/*1660*/ 0x1.1ecb86p-1,
	/*1661*/ 0x1.1e24d6p-1,
	/*1662*/ 0x1.1d7dfap-1,
	/*1663*/ 0x1.1cd6f4p-1,
	/*1664*/ 0x1.1c2fcp-1,
	/*1665*/ 0x1.1b886p-1,
	/*1666*/ 0x1.1ae0d4p-1,
	/*1667*/ 0x1.1a391ep-1,
	/*1668*/ 0x1.19913cp-1,
	/*1669*/ 0x1.18e92ep-1,
	/*1670*/ 0x1.1840f4p-1,
	/*1671*/ 0x1.17989p-1,
	/*1672*/ 0x1.16fp-1,
	/*1673*/ 0x1.164746p-1,
	/*1674*/ 0x1.159e6p-1,
	/*1675*/ 0x1.14f55p-1,
	/*1676*/ 0x1.144c16p-1,
	/*1677*/ 0x1.13a2bp-1,
	/*1678*/ 0x1.12f92p-1,
	/*1679*/ 0x1.124f64p-1,
	/*1680*/ 0x1.11a58p-1,
	/*1681*/ 0x1.10fb7p-1,
	/*1682*/ 0x1.105136p-1,
	/*1683*/ 0x1.0fa6d4p-1,
	/*1684*/ 0x1.0efc46p-1,
	/*1685*/ 0x1.0e519p-1,
	/*1686*/ 0x1.0da6aep-1,
	/*1687*/ 0x1.0cfba4p-1,
	/*1688*/ 0x1.0c507p-1,
	/*1689*/ 0x1.0ba512p-1,
	/*1690*/ 0x1.0af98cp-1,
	/*1691*/ 0x1.0a4ddcp-1,
	/*1692*/ 0x1.09a204p-1,
	/*1693*/ 0x1.08f602p-1,
	/*1694*/ 0x1.0849d8p-1,
	/*1695*/ 0x1.079d84p-1,
	/*1696*/ 0x1.06f108p-1,
	/*1697*/ 0x1.064462p-1,
	/*1698*/ 0x1.059796p-1,
	/*1699*/ 0x1.04eaap-1,
	/*1700*/ 0x1.043d82p-1,
	/*1701*/ 0x1.03903cp-1,
	/*1702*/ 0x1.02e2cep-1,
	/*1703*/ 0x1.023538p-1,
	/*1704*/ 0x1.01877ap-1,
	/*1705*/ 0x1.00d994p-1,
	/*1706*/ 0x1.002b88p-1,
	/*1707*/ 0x1.fefaa6p-2,
	/*1708*/ 0x1.fd9deep-2,
	/*1709*/ 0x1.fc40e6p-2,
	/*1710*/ 0x1.fae392p-2,
	/*1711*/ 0x1.f985eep-2,
	/*1712*/ 0x1.f827fcp-2,
	/*1713*/ 0x1.f6c9bep-2,
	/*1714*/ 0x1.f56b3p-2,
	/*1715*/ 0x1.f40c56p-2,
	/*1716*/ 0x1.f2ad2ep-2,
	/*1717*/ 0x1.f14dbap-2,
	/*1718*/ 0x1.efedfap-2,
	/*1719*/ 0x1.ee8decp-2,
	/*1720*/ 0x1.ed2d92p-2,
	/*1721*/ 0x1.ebccecp-2,
	/*1722*/ 0x1.ea6bfap-2,
	/*1723*/ 0x1.e90abep-2,
	/*1724*/ 0x1.e7a934p-2,
	/*1725*/ 0x1.e6476p-2,
	/*1726*/ 0x1.e4e54p-2,
	/*1727*/ 0x1.e382d6p-2,
	/*1728*/ 0x1.e22022p-2,
	/*1729*/ 0x1.e0bd24p-2,
	/*1730*/ 0x1.df59dap-2,
	/*1731*/ 0x1.ddf648p-2,
	/*1732*/ 0x1.dc926ap-2,
	/*1733*/ 0x1.db2e44p-2,
	/*1734*/ 0x1.d9c9d4p-2,
	/*1735*/ 0x1.d8651cp-2,
	/*1736*/ 0x1.d7001ap-2,
	/*1737*/ 0x1.d59adp-2,
	/*1738*/ 0x1.d4353cp-2,
	/*1739*/ 0x1.d2cf62p-2,
	/*1740*/ 0x1.d1693ep-2,
	/*1741*/ 0x1.d002d4p-2,
	/*1742*/ 0x1.ce9c22p-2,
	/*1743*/ 0x1.cd3528p-2,
	/*1744*/ 0x1.cbcde6p-2,
	/*1745*/ 0x1.ca665ep-2,
	/*1746*/ 0x1.c8fe9p-2,
	/*1747*/ 0x1.c7967ap-2,
	/*1748*/ 0x1.c62e1ep-2,
	/*1749*/ 0x1.c4c57ep-2,
	/*1750*/ 0x1.c35c96p-2,
	/*1751*/ 0x1.c1f368p-2,
	/*1752*/ 0x1.c089f6p-2,
	/*1753*/ 0x1.bf203ep-2,
	/*1754*/ 0x1.bdb642p-2,
	/*1755*/ 0x1.bc4cp-2,
	/*1756*/ 0x1.bae17ap-2,
	/*1757*/ 0x1.b976bp-2,
	/*1758*/ 0x1.b80ba2p-2,
	/*1759*/ 0x1.b6a05p-2,
	/*1760*/ 0x1.b534bap-2,
	/*1761*/ 0x1.b3c8ep-2,
	/*1762*/ 0x1.b25cc4p-2,
	/*1763*/ 0x1.b0f064p-2,
	/*1764*/ 0x1.af83c2p-2,
	/*1765*/ 0x1.ae16dcp-2,
	/*1766*/ 0x1.aca9b6p-2,
	/*1767*/ 0x1.ab3c4cp-2,
	/*1768*/ 0x1.a9ceap-2,
	/*1769*/ 0x1.a860b2p-2,
	/*1770*/ 0x1.a6f284p-2,
	/*1771*/ 0x1.a58414p-2,
	/*1772*/ 0x1.a41564p-2,
	/*1773*/ 0x1.a2a672p-2,
	/*1774*/ 0x1.a1374p-2,
	/*1775*/ 0x1.9fc7ccp-2,
	/*1776*/ 0x1.9e581ap-2,
	/*1777*/ 0x1.9ce826p-2,
	/*1778*/ 0x1.9b77f4p-2,
	/*1779*/ 0x1.9a0782p-2,
	/*1780*/ 0x1.9896d2p-2,
	/*1781*/ 0x1.9725ep-2,
	/*1782*/ 0x1.95b4b2p-2,
	/*1783*/ 0x1.944344p-2,
	/*1784*/ 0x1.92d198p-2,
	/*1785*/ 0x1.915faep-2,
	/*1786*/ 0x1.8fed86p-2,
	/*1787*/ 0x1.8e7b2p-2,
	/*1788*/ 0x1.8d087cp-2,
	/*1789*/ 0x1.8b959cp-2,
	/*1790*/ 0x1.8a227ep-2,
	/*1791*/ 0x1.88af24p-2,
	/*1792*/ 0x1.873b8cp-2,
	/*1793*/ 0x1.85c7bap-2,
	/*1794*/ 0x1.8453aap-2,
	/*1795*/ 0x1.82df5ep-2,
	/*1796*/ 0x1.816ad8p-2,
	/*1797*/ 0x1.7ff614p-2,
	/*1798*/ 0x1.7e8116p-2,
	/*1799*/ 0x1.7d0bdep-2,
	/*1800*/ 0x1.7b966ap-2,
	/*1801*/ 0x1.7a20bcp-2,
	/*1802*/ 0x1.78aad4p-2,
	/*1803*/ 0x1.7734bp-2,
	/*1804*/ 0x1.75be54p-2,
	/*1805*/ 0x1.7447bep-2,
	/*1806*/ 0x1.72d0eep-2,
	/*1807*/ 0x1.7159e6p-2,
	/*1808*/ 0x1.6fe2a4p-2,
	/*1809*/ 0x1.6e6b28p-2,
	/*1810*/ 0x1.6cf376p-2,
	/*1811*/ 0x1.6b7b8ap-2,
	/*1812*/ 0x1.6a0366p-2,
	/*1813*/ 0x1.688b0cp-2,
	/*1814*/ 0x1.671278p-2,
	/*1815*/ 0x1.6599aep-2,
	/*1816*/ 0x1.6420acp-2,
	/*1817*/ 0x1.62a774p-2,
	/*1818*/ 0x1.612e04p-2,
	/*1819*/ 0x1.5fb45ep-2,
	/*1820*/ 0x1.5e3a82p-2,
	/*1821*/ 0x1.5cc07p-2,
	/*1822*/ 0x1.5b4628p-2,
	/*1823*/ 0x1.59cbacp-2,
	/*1824*/ 0x1.5850f8p-2,
	/*1825*/ 0x1.56d61p-2,
	/*1826*/ 0x1.555af4p-2,
	/*1827*/ 0x1.53dfa2p-2,
	/*1828*/ 0x1.52641cp-2,
	/*1829*/ 0x1.50e862p-2,
	/*1830*/ 0x1.4f6c74p-2,
	/*1831*/ 0x1.4df052p-2,
	/*1832*/ 0x1.4c73fep-2,
	/*1833*/ 0x1.4af774p-2,
	/*1834*/ 0x1.497ab8p-2,
	/*1835*/ 0x1.47fdcap-2,
	/*1836*/ 0x1.4680a8p-2,
	/*1837*/ 0x1.450356p-2,
	/*1838*/ 0x1.4385dp-2,
	/*1839*/ 0x1.420818p-2,
	/*1840*/ 0x1.408a2ep-2,
	/*1841*/ 0x1.3f0c14p-2,
	/*1842*/ 0x1.3d8dc8p-2,
	/*1843*/ 0x1.3c0f4cp-2,
	/*1844*/ 0x1.3a909ep-2,
	/*1845*/ 0x1.3911cp-2,
	/*1846*/ 0x1.3792bp-2,
	/*1847*/ 0x1.361372p-2,
	/*1848*/ 0x1.349404p-2,
	/*1849*/ 0x1.331466p-2,
	/*1850*/ 0x1.319498p-2,
	/*1851*/ 0x1.30149cp-2,
	/*1852*/ 0x1.2e947p-2,
	/*1853*/ 0x1.2d1416p-2,
	/*1854*/ 0x1.2b938cp-2,
	/*1855*/ 0x1.2a12d6p-2,
	/*1856*/ 0x1.2891fp-2,
	/*1857*/ 0x1.2710dep-2,
	/*1858*/ 0x1.258f9ep-2,
	/*1859*/ 0x1.240e3p-2,
	/*1860*/ 0x1.228c96p-2,
	/*1861*/ 0x1.210acep-2,
	/*1862*/ 0x1.1f88dap-2,
	/*1863*/ 0x1.1e06bap-2,
	/*1864*/ 0x1.1c846ep-2,
	/*1865*/ 0x1.1b01f6p-2,
	/*1866*/ 0x1.197f52p-2,
	/*1867*/ 0x1.17fc82p-2,
	/*1868*/ 0x1.167988p-2,
	/*1869*/ 0x1.14f662p-2,
	/*1870*/ 0x1.137312p-2,
	/*1871*/ 0x1.11ef96p-2,
	/*1872*/ 0x1.106bf2p-2,
	/*1873*/ 0x1.0ee822p-2,
	/*1874*/ 0x1.0d642ap-2,
	/*1875*/ 0x1.0be008p-2,
	/*1876*/ 0x1.0a5bbcp-2,
	/*1877*/ 0x1.08d746p-2,
	/*1878*/ 0x1.0752a8p-2,
	/*1879*/ 0x1.05cde2p-2,
	/*1880*/ 0x1.0448f4p-2,
	/*1881*/ 0x1.02c3dcp-2,
	/*1882*/ 0x1.013e9ep-2,
	/*1883*/ 0x1.ff726ep-3,
	/*1884*/ 0x1.fc6752p-3,
	/*1885*/ 0x1.f95be8p-3,
	/*1886*/ 0x1.f6503p-3,
	/*1887*/ 0x1.f3442ap-3,
	/*1888*/ 0x1.f037d6p-3,
	/*1889*/ 0x1.ed2b36p-3,
	/*1890*/ 0x1.ea1e4cp-3,
	/*1891*/ 0x1.e71114p-3,
	/*1892*/ 0x1.e40392p-3,
	/*1893*/ 0x1.e0f5c4p-3,
	/*1894*/ 0x1.dde7aep-3,
	/*1895*/ 0x1.dad94cp-3,
	/*1896*/ 0x1.d7caa2p-3,
	/*1897*/ 0x1.d4bbaep-3,
	/*1898*/ 0x1.d1ac74p-3,
	/*1899*/ 0x1.ce9cfp-3,
	/*1900*/ 0x1.cb8d26p-3,
	/*1901*/ 0x1.c87d14p-3,
	/*1902*/ 0x1.c56cbcp-3,
	/*1903*/ 0x1.c25c1ep-3,
	/*1904*/ 0x1.bf4b3ap-3,
	/*1905*/ 0x1.bc3a12p-3,
	/*1906*/ 0x1.b928a6p-3,
	/*1907*/ 0x1.b616f4p-3,
	/*1908*/ 0x1.b305p-3,
	/*1909*/ 0x1.aff2c8p-3,
	/*1910*/ 0x1.ace04ep-3,
	/*1911*/ 0x1.a9cd92p-3,
	/*1912*/ 0x1.a6ba92p-3,
	/*1913*/ 0x1.a3a754p-3,
	/*1914*/ 0x1.a093d4p-3,
	/*1915*/ 0x1.9d8012p-3,
	/*1916*/ 0x1.9a6c12p-3,
	/*1917*/ 0x1.9757d2p-3,
	/*1918*/ 0x1.944354p-3,
	/*1919*/ 0x1.912e98p-3,
	/*1920*/ 0x1.8e199cp-3,
	/*1921*/ 0x1.8b0464p-3,
	/*1922*/ 0x1.87eefp-3,
	/*1923*/ 0x1.84d93ep-3,
	/*1924*/ 0x1.81c35p-3,
	/*1925*/ 0x1.7ead28p-3,
	/*1926*/ 0x1.7b96c4p-3,
	/*1927*/ 0x1.788024p-3,
	/*1928*/ 0x1.75694cp-3,
	/*1929*/ 0x1.72523ap-3,
	/*1930*/ 0x1.6f3aeep-3,
	/*1931*/ 0x1.6c236ap-3,
	/*1932*/ 0x1.690baep-3,
	/*1933*/ 0x1.65f3bap-3,
	/*1934*/ 0x1.62db8ep-3,
	/*1935*/ 0x1.5fc32cp-3,
	/*1936*/ 0x1.5caa94p-3,
	/*1937*/ 0x1.5991c6p-3,
	/*1938*/ 0x1.5678c2p-3,
	/*1939*/ 0x1.535f8ap-3,
	/*1940*/ 0x1.50461ep-3,
	/*1941*/ 0x1.4d2c7cp-3,
	/*1942*/ 0x1.4a12a8p-3,
	/*1943*/ 0x1.46f8a2p-3,
	/*1944*/ 0x1.43de68p-3,
	/*1945*/ 0x1.40c3fep-3,
	/*1946*/ 0x1.3da96p-3,
	/*1947*/ 0x1.3a8e92p-3,
	/*1948*/ 0x1.377394p-3,
	/*1949*/ 0x1.345866p-3,
	/*1950*/ 0x1.313d08p-3,
	/*1951*/ 0x1.2e217cp-3,
	/*1952*/ 0x1.2b05cp-3,
	/*1953*/ 0x1.27e9d6p-3,
	/*1954*/ 0x1.24cdbep-3,
	/*1955*/ 0x1.21b17ap-3,
	/*1956*/ 0x1.1e9508p-3,
	/*1957*/ 0x1.1b786cp-3,
	/*1958*/ 0x1.185ba2p-3,
	/*1959*/ 0x1.153eaep-3,
	/*1960*/ 0x1.12218ep-3,
	/*1961*/ 0x1.0f0444p-3,
	/*1962*/ 0x1.0be6d2p-3,
	/*1963*/ 0x1.08c934p-3,
	/*1964*/ 0x1.05ab6ep-3,
	/*1965*/ 0x1.028d8p-3,
	/*1966*/ 0x1.feded6p-4,
	/*1967*/ 0x1.f8a25cp-4,
	/*1968*/ 0x1.f26594p-4,
	/*1969*/ 0x1.ec287ep-4,
	/*1970*/ 0x1.e5eb1cp-4,
	/*1971*/ 0x1.dfad7p-4,
	/*1972*/ 0x1.d96f7ap-4,
	/*1973*/ 0x1.d3313cp-4,
	/*1974*/ 0x1.ccf2b4p-4,
	/*1975*/ 0x1.c6b3e6p-4,
	/*1976*/ 0x1.c074d2p-4,
	/*1977*/ 0x1.ba3578p-4,
	/*1978*/ 0x1.b3f5dap-4,
	/*1979*/ 0x1.adb5f8p-4,
	/*1980*/ 0x1.a775d4p-4,
	/*1981*/ 0x1.a1357p-4,
	/*1982*/ 0x1.9af4cap-4,
	/*1983*/ 0x1.94b3e6p-4,
	/*1984*/ 0x1.8e72c2p-4,
	/*1985*/ 0x1.883162p-4,
	/*1986*/ 0x1.81efc4p-4,
	/*1987*/ 0x1.7badecp-4,
	/*1988*/ 0x1.756bdap-4,
	/*1989*/ 0x1.6f298cp-4,
	/*1990*/ 0x1.68e706p-4,
	/*1991*/ 0x1.62a44ap-4,
	/*1992*/ 0x1.5c6156p-4,
	/*1993*/ 0x1.561e2cp-4,
	/*1994*/ 0x1.4fdacep-4,
	/*1995*/ 0x1.49973cp-4,
	/*1996*/ 0x1.435376p-4,
	/*1997*/ 0x1.3d0f8p-4,
	/*1998*/ 0x1.36cb58p-4,
	/*1999*/ 0x1.3087p-4,
	/*2000*/ 0x1.2a4278p-4,
	/*2001*/ 0x1.23fdc4p-4,
	/*2002*/ 0x1.1db8e2p-4,
	/*2003*/ 0x1.1773d4p-4,
	/*2004*/ 0x1.112e9cp-4,
	/*2005*/ 0x1.0ae938p-4,
	/*2006*/ 0x1.04a3acp-4,
	/*2007*/ 0x1.fcbbeep-5,
	/*2008*/ 0x1.f03036p-5,
	/*2009*/ 0x1.e3a432p-5,
	/*2010*/ 0x1.d717e2p-5,
	/*2011*/ 0x1.ca8b4ap-5,
	/*2012*/ 0x1.bdfe6cp-5,
	/*2013*/ 0x1.b1714ap-5,
	/*2014*/ 0x1.a4e3e4p-5,
	/*2015*/ 0x1.98563cp-5,
	/*2016*/ 0x1.8bc856p-5,
	/*2017*/ 0x1.7f3a34p-5,
	/*2018*/ 0x1.72abd6p-5,
	/*2019*/ 0x1.661d3ep-5,
	/*2020*/ 0x1.598e7p-5,
	/*2021*/ 0x1.4cff6cp-5,
	/*2022*/ 0x1.407034p-5,
	/*2023*/ 0x1.33e0ccp-5,
	/*2024*/ 0x1.275132p-5,
	/*2025*/ 0x1.1ac16ep-5,
	/*2026*/ 0x1.0e317cp-5,
	/*2027*/ 0x1.01a16p-5,
	/*2028*/ 0x1.ea223cp-6,
	/*2029*/ 0x1.d1016ap-6,
	/*2030*/ 0x1.b7e05p-6,
	/*2031*/ 0x1.9ebef4p-6,
	/*2032*/ 0x1.859d56p-6,
	/*2033*/ 0x1.6c7b7ep-6,
	/*2034*/ 0x1.53596cp-6,
	/*2035*/ 0x1.3a3726p-6,
	/*2036*/ 0x1.2114bp-6,
	/*2037*/ 0x1.07f20ep-6,
	/*2038*/ 0x1.dd9e84p-7,
	/*2039*/ 0x1.ab58a4p-7,
	/*2040*/ 0x1.79128p-7,
	/*2041*/ 0x1.46cc24p-7,
	/*2042*/ 0x1.148594p-7,
	/*2043*/ 0x1.c47db6p-8,
	/*2044*/ 0x1.5feffcp-8,
	/*2045*/ 0x1.f6c418p-9,
	/*2046*/ 0x1.2da7ecp-9,
	/*2047*/ 0x1.922e3cp-11,
	/*2048*/ -0x1.924372p-11,
	/*2049*/ -0x1.2dad38p-9,
	/*2050*/ -0x1.f6c966p-9,
	/*2051*/ -0x1.5ff2a2p-8,
	/*2052*/ -0x1.c4805cp-8,
	/*2053*/ -0x1.1486e8p-7,
	/*2054*/ -0x1.46cd78p-7,
	/*2055*/ -0x1.7913d4p-7,
	/*2056*/ -0x1.ab59f6p-7,
	/*2057*/ -0x1.dd9fd8p-7,
	/*2058*/ -0x1.07f2b8p-6,
	/*2059*/ -0x1.21155ap-6,
	/*2060*/ -0x1.3a37dp-6,
	/*2061*/ -0x1.535a16p-6,
	/*2062*/ -0x1.6c7c28p-6,
	/*2063*/ -0x1.859ep-6,
	/*2064*/ -0x1.9ebf9ep-6,
	/*2065*/ -0x1.b7e0fap-6,
	/*2066*/ -0x1.d10214p-6,
	/*2067*/ -0x1.ea22e4p-6,
	/*2068*/ -0x1.01a1b6p-5,
	/*2069*/ -0x1.0e31dp-5,
	/*2070*/ -0x1.1ac1c2p-5,
	/*2071*/ -0x1.275188p-5,
	/*2072*/ -0x1.33e12p-5,
	/*2073*/ -0x1.407088p-5,
	/*2074*/ -0x1.4cffcp-5,
	/*2075*/ -0x1.598ec4p-5,
	/*2076*/ -0x1.661d92p-5,
	/*2077*/ -0x1.72ac2ap-5,
	/*2078*/ -0x1.7f3a88p-5,
	/*2079*/ -0x1.8bc8acp-5,
	/*2080*/ -0x1.985692p-5,
	/*2081*/ -0x1.a4e438p-5,
	/*2082*/ -0x1.b1719ep-5,
	/*2083*/ -0x1.bdfec2p-5,
	/*2084*/ -0x1.ca8bap-5,
	/*2085*/ -0x1.d71838p-5,
	/*2086*/ -0x1.e3a486p-5,
	/*2087*/ -0x1.f0308ap-5,
	/*2088*/ -0x1.fcbc42p-5,
	/*2089*/ -0x1.04a3d6p-4,
	/*2090*/ -0x1.0ae962p-4,
	/*2091*/ -0x1.112ec6p-4,
	/*2092*/ -0x1.1773fep-4,
	/*2093*/ -0x1.1db90cp-4,
	/*2094*/ -0x1.23fdeep-4,
	/*2095*/ -0x1.2a42a4p-4,
	/*2096*/ -0x1.30872ap-4,
	/*2097*/ -0x1.36cb82p-4,
	/*2098*/ -0x1.3d0faap-4,
	/*2099*/ -0x1.4353ap-4,
	/*2100*/ -0x1.499766p-4,
	/*2101*/ -0x1.4fdaf8p-4,
	/*2102*/ -0x1.561e56p-4,
	/*2103*/ -0x1.5c618p-4,
	/*2104*/ -0x1.62a474p-4,
	/*2105*/ -0x1.68e732p-4,
	/*2106*/ -0x1.6f29b6p-4,
	/*2107*/ -0x1.756c04p-4,
	/*2108*/ -0x1.7bae16p-4,
	/*2109*/ -0x1.81effp-4,
	/*2110*/ -0x1.88318cp-4,
	/*2111*/ -0x1.8e72ecp-4,
	/*2112*/ -0x1.94b41p-4,
	/*2113*/ -0x1.9af4f4p-4,
	/*2114*/ -0x1.a1359ap-4,
	/*2115*/ -0x1.a775fep-4,
	/*2116*/ -0x1.adb622p-4,
	/*2117*/ -0x1.b3f604p-4,
	/*2118*/ -0x1.ba35a2p-4,
	/*2119*/ -0x1.c074fcp-4,
	/*2120*/ -0x1.c6b41p-4,
	/*2121*/ -0x1.ccf2dep-4,
	/*2122*/ -0x1.d33166p-4,
	/*2123*/ -0x1.d96fa4p-4,
	/*2124*/ -0x1.dfad9ap-4,
	/*2125*/ -0x1.e5eb46p-4,
	/*2126*/ -0x1.ec28a8p-4,
	/*2127*/ -0x1.f265bep-4,
	/*2128*/ -0x1.f8a286p-4,
	/*2129*/ -0x1.fedfp-4,
	/*2130*/ -0x1.028d96p-3,
	/*2131*/ -0x1.05ab84p-3,
	/*2132*/ -0x1.08c94ap-3,
	/*2133*/ -0x1.0be6e6p-3,
	/*2134*/ -0x1.0f045ap-3,
	/*2135*/ -0x1.1221a4p-3,
	/*2136*/ -0x1.153ec2p-3,
	/*2137*/ -0x1.185bb6p-3,
	/*2138*/ -0x1.1b788p-3,
	/*2139*/ -0x1.1e951ep-3,
	/*2140*/ -0x1.21b18ep-3,
	/*2141*/ -0x1.24cdd4p-3,
	/*2142*/ -0x1.27e9eap-3,
	/*2143*/ -0x1.2b05d4p-3,
	/*2144*/ -0x1.2e219p-3,
	/*2145*/ -0x1.313d1ep-3,
	/*2146*/ -0x1.34587cp-3,
	/*2147*/ -0x1.3773aap-3,
	/*2148*/ -0x1.3a8ea8p-3,
	/*2149*/ -0x1.3da976p-3,
	/*2150*/ -0x1.40c412p-3,
	/*2151*/ -0x1.43de7ep-3,
	/*2152*/ -0x1.46f8b6p-3,
	/*2153*/ -0x1.4a12bep-3,
	/*2154*/ -0x1.4d2c92p-3,
	/*2155*/ -0x1.504632p-3,
	/*2156*/ -0x1.535f9ep-3,
	/*2157*/ -0x1.5678d8p-3,
	/*2158*/ -0x1.5991dap-3,
	/*2159*/ -0x1.5caaa8p-3,
	/*2160*/ -0x1.5fc34p-3,
	/*2161*/ -0x1.62dba2p-3,
	/*2162*/ -0x1.65f3cep-3,
	/*2163*/ -0x1.690bc2p-3,
	/*2164*/ -0x1.6c237ep-3,
	/*2165*/ -0x1.6f3b02p-3,
	/*2166*/ -0x1.72524ep-3,
	/*2167*/ -0x1.75696p-3,
	/*2168*/ -0x1.78803ap-3,
	/*2169*/ -0x1.7b96d8p-3,
	/*2170*/ -0x1.7ead3cp-3,
	/*2171*/ -0x1.81c366p-3,
	/*2172*/ -0x1.84d952p-3,
	/*2173*/ -0x1.87ef04p-3,
	/*2174*/ -0x1.8b047ap-3,
	/*2175*/ -0x1.8e19b2p-3,
	/*2176*/ -0x1.912eacp-3,
	/*2177*/ -0x1.94436ap-3,
	/*2178*/ -0x1.9757e8p-3,
	/*2179*/ -0x1.9a6c28p-3,
	/*2180*/ -0x1.9d8028p-3,
	/*2181*/ -0x1.a093e8p-3,
	/*2182*/ -0x1.a3a768p-3,
	/*2183*/ -0x1.a6baa8p-3,
	/*2184*/ -0x1.a9cda6p-3,
	/*2185*/ -0x1.ace062p-3,
	/*2186*/ -0x1.aff2dcp-3,
	/*2187*/ -0x1.b30514p-3,
	/*2188*/ -0x1.b6170ap-3,
	/*2189*/ -0x1.b928bap-3,
	/*2190*/ -0x1.bc3a28p-3,
	/*2191*/ -0x1.bf4b5p-3,
	/*2192*/ -0x1.c25c32p-3,
	/*2193*/ -0x1.c56cdp-3,
	/*2194*/ -0x1.c87d28p-3,
	/*2195*/ -0x1.cb8d3ap-3,
	/*2196*/ -0x1.ce9d04p-3,
	/*2197*/ -0x1.d1ac88p-3,
	/*2198*/ -0x1.d4bbc4p-3,
	/*2199*/ -0x1.d7cab6p-3,
	/*2200*/ -0x1.dad96p-3,
	/*2201*/ -0x1.dde7c2p-3,
	/*2202*/ -0x1.e0f5dap-3,
	/*2203*/ -0x1.e403a6p-3,
	/*2204*/ -0x1.e71128p-3,
	/*2205*/ -0x1.ea1e6p-3,
	/*2206*/ -0x1.ed2b4cp-3,
	/*2207*/ -0x1.f037eap-3,
	/*2208*/ -0x1.f3443ep-3,
	/*2209*/ -0x1.f65044p-3,
	/*2210*/ -0x1.f95bfcp-3,
	/*2211*/ -0x1.fc6766p-3,
	/*2212*/ -0x1.ff7282p-3,
	/*2213*/ -0x1.013ea8p-2,
	/*2214*/ -0x1.02c3e6p-2,
	/*2215*/ -0x1.0448fep-2,
	/*2216*/ -0x1.05cdecp-2,
	/*2217*/ -0x1.0752b4p-2,
	/*2218*/ -0x1.08d75p-2,
	/*2219*/ -0x1.0a5bc6p-2,
	/*2220*/ -0x1.0be012p-2,
	/*2221*/ -0x1.0d6434p-2,
	/*2222*/ -0x1.0ee82cp-2,
	/*2223*/ -0x1.106bfcp-2,
	/*2224*/ -0x1.11efa2p-2,
	/*2225*/ -0x1.13731cp-2,
	/*2226*/ -0x1.14f66cp-2,
	/*2227*/ -0x1.167992p-2,
	/*2228*/ -0x1.17fc8cp-2,
	/*2229*/ -0x1.197f5cp-2,
	/*2230*/ -0x1.1b02p-2,
	/*2231*/ -0x1.1c8478p-2,
	/*2232*/ -0x1.1e06c4p-2,
	/*2233*/ -0x1.1f88e6p-2,
	/*2234*/ -0x1.210ad8p-2,
	/*2235*/ -0x1.228cap-2,
	/*2236*/ -0x1.240e3ap-2,
	/*2237*/ -0x1.258fa8p-2,
	/*2238*/ -0x1.2710e8p-2,
	/*2239*/ -0x1.2891fcp-2,
	/*2240*/ -0x1.2a12ep-2,
	/*2241*/ -0x1.2b9396p-2,
	/*2242*/ -0x1.2d142p-2,
	/*2243*/ -0x1.2e947ap-2,
	/*2244*/ -0x1.3014a6p-2,
	/*2245*/ -0x1.3194a2p-2,
	/*2246*/ -0x1.33147p-2,
	/*2247*/ -0x1.34940ep-2,
	/*2248*/ -0x1.36137cp-2,
	/*2249*/ -0x1.3792bap-2,
	/*2250*/ -0x1.3911cap-2,
	/*2251*/ -0x1.3a90a8p-2,
	/*2252*/ -0x1.3c0f56p-2,
	/*2253*/ -0x1.3d8dd2p-2,
	/*2254*/ -0x1.3f0c1ep-2,
	/*2255*/ -0x1.408a38p-2,
	/*2256*/ -0x1.420822p-2,
	/*2257*/ -0x1.4385dap-2,
	/*2258*/ -0x1.45036p-2,
	/*2259*/ -0x1.4680b4p-2,
	/*2260*/ -0x1.47fdd4p-2,
	/*2261*/ -0x1.497ac2p-2,
	/*2262*/ -0x1.4af77ep-2,
	/*2263*/ -0x1.4c7408p-2,
	/*2264*/ -0x1.4df05cp-2,
	/*2265*/ -0x1.4f6c7ep-2,
	/*2266*/ -0x1.50e86cp-2,
	/*2267*/ -0x1.526426p-2,
	/*2268*/ -0x1.53dfacp-2,
	/*2269*/ -0x1.555afep-2,
	/*2270*/ -0x1.56d61ap-2,
	/*2271*/ -0x1.585102p-2,
	/*2272*/ -0x1.59cbb6p-2,
	/*2273*/ -0x1.5b4632p-2,
	/*2274*/ -0x1.5cc07ap-2,
	/*2275*/ -0x1.5e3a8cp-2,
	/*2276*/ -0x1.5fb468p-2,
	/*2277*/ -0x1.612e0ep-2,
	/*2278*/ -0x1.62a77ep-2,
	/*2279*/ -0x1.6420b6p-2,
	/*2280*/ -0x1.6599b8p-2,
	/*2281*/ -0x1.671282p-2,
	/*2282*/ -0x1.688b16p-2,
	/*2283*/ -0x1.6a037p-2,
	/*2284*/ -0x1.6b7b94p-2,
	/*2285*/ -0x1.6cf38p-2,
	/*2286*/ -0x1.6e6b32p-2,
	/*2287*/ -0x1.6fe2aep-2,
	/*2288*/ -0x1.7159fp-2,
	/*2289*/ -0x1.72d0f8p-2,
	/*2290*/ -0x1.7447c8p-2,
	/*2291*/ -0x1.75be5ep-2,
	/*2292*/ -0x1.7734bap-2,
	/*2293*/ -0x1.78aadep-2,
	/*2294*/ -0x1.7a20c6p-2,
	/*2295*/ -0x1.7b9674p-2,
	/*2296*/ -0x1.7d0be8p-2,
	/*2297*/ -0x1.7e812p-2,
	/*2298*/ -0x1.7ff61ep-2,
	/*2299*/ -0x1.816aep-2,
	/*2300*/ -0x1.82df68p-2,
	/*2301*/ -0x1.8453b4p-2,
	/*2302*/ -0x1.85c7c4p-2,
	/*2303*/ -0x1.873b96p-2,
	/*2304*/ -0x1.88af2ep-2,
	/*2305*/ -0x1.8a2288p-2,
	/*2306*/ -0x1.8b95a6p-2,
	/*2307*/ -0x1.8d0886p-2,
	/*2308*/ -0x1.8e7b2ap-2,
	/*2309*/ -0x1.8fed9p-2,
	/*2310*/ -0x1.915fb8p-2,
	/*2311*/ -0x1.92d1a2p-2,
	/*2312*/ -0x1.94434ep-2,
	/*2313*/ -0x1.95b4bcp-2,
	/*2314*/ -0x1.9725eap-2,
	/*2315*/ -0x1.9896dap-2,
	/*2316*/ -0x1.9a078cp-2,
	/*2317*/ -0x1.9b77fep-2,
	/*2318*/ -0x1.9ce83p-2,
	/*2319*/ -0x1.9e5824p-2,
	/*2320*/ -0x1.9fc7d6p-2,
	/*2321*/ -0x1.a13748p-2,
	/*2322*/ -0x1.a2a67cp-2,
	/*2323*/ -0x1.a4156cp-2,
	/*2324*/ -0x1.a5841ep-2,
	/*2325*/ -0x1.a6f28ep-2,
	/*2326*/ -0x1.a860bcp-2,
	/*2327*/ -0x1.a9ceaap-2,
	/*2328*/ -0x1.ab3c56p-2,
	/*2329*/ -0x1.aca9bep-2,
	/*2330*/ -0x1.ae16e6p-2,
	/*2331*/ -0x1.af83ccp-2,
	/*2332*/ -0x1.b0f06ep-2,
	/*2333*/ -0x1.b25ccep-2,
	/*2334*/ -0x1.b3c8eap-2,
	/*2335*/ -0x1.b534c4p-2,
	/*2336*/ -0x1.b6a05ap-2,
	/*2337*/ -0x1.b80bacp-2,
	/*2338*/ -0x1.b976bap-2,
	/*2339*/ -0x1.bae184p-2,
	/*2340*/ -0x1.bc4c0ap-2,
	/*2341*/ -0x1.bdb64cp-2,
	/*2342*/ -0x1.bf2048p-2,
	/*2343*/ -0x1.c08ap-2,
	/*2344*/ -0x1.c1f372p-2,
	/*2345*/ -0x1.c35cap-2,
	/*2346*/ -0x1.c4c586p-2,
	/*2347*/ -0x1.c62e28p-2,
	/*2348*/ -0x1.c79684p-2,
	/*2349*/ -0x1.c8fe9ap-2,
	/*2350*/ -0x1.ca6668p-2,
	/*2351*/ -0x1.cbcdfp-2,
	/*2352*/ -0x1.cd353p-2,
	/*2353*/ -0x1.ce9c2ap-2,
	/*2354*/ -0x1.d002dcp-2,
	/*2355*/ -0x1.d16948p-2,
	/*2356*/ -0x1.d2cf6ap-2,
	/*2357*/ -0x1.d43546p-2,
	/*2358*/ -0x1.d59ad8p-2,
	/*2359*/ -0x1.d70024p-2,
	/*2360*/ -0x1.d86524p-2,
	/*2361*/ -0x1.d9c9dep-2,
	/*2362*/ -0x1.db2e4ep-2,
	/*2363*/ -0x1.dc9274p-2,
	/*2364*/ -0x1.ddf65p-2,
	/*2365*/ -0x1.df59e4p-2,
	/*2366*/ -0x1.e0bd2cp-2,
	/*2367*/ -0x1.e2202cp-2,
	/*2368*/ -0x1.e382ep-2,
	/*2369*/ -0x1.e4e54ap-2,
	/*2370*/ -0x1.e6476ap-2,
	/*2371*/ -0x1.e7a93ep-2,
	/*2372*/ -0x1.e90ac6p-2,
	/*2373*/ -0x1.ea6c04p-2,
	/*2374*/ -0x1.ebccf6p-2,
	/*2375*/ -0x1.ed2d9cp-2,
	/*2376*/ -0x1.ee8df6p-2,
	/*2377*/ -0x1.efee02p-2,
	/*2378*/ -0x1.f14dc4p-2,
	/*2379*/ -0x1.f2ad38p-2,
	/*2380*/ -0x1.f40c6p-2,
	/*2381*/ -0x1.f56b3ap-2,
	/*2382*/ -0x1.f6c9c6p-2,
	/*2383*/ -0x1.f82806p-2,
	/*2384*/ -0x1.f985f8p-2,
	/*2385*/ -0x1.fae39ap-2,
	/*2386*/ -0x1.fc40fp-2,
	/*2387*/ -0x1.fd9df6p-2,
	/*2388*/ -0x1.fefaaep-2,
	/*2389*/ -0x1.002b8cp-1,
	/*2390*/ -0x1.00d99ap-1,
	/*2391*/ -0x1.01877ep-1,
	/*2392*/ -0x1.02353cp-1,
	/*2393*/ -0x1.02e2d2p-1,
	/*2394*/ -0x1.03904p-1,
	/*2395*/ -0x1.043d86p-1,
	/*2396*/ -0x1.04eaa4p-1,
	/*2397*/ -0x1.05979ap-1,
	/*2398*/ -0x1.064468p-1,
	/*2399*/ -0x1.06f10cp-1,
	/*2400*/ -0x1.079d88p-1,
	/*2401*/ -0x1.0849dcp-1,
	/*2402*/ -0x1.08f606p-1,
	/*2403*/ -0x1.09a208p-1,
	/*2404*/ -0x1.0a4dep-1,
	/*2405*/ -0x1.0af99p-1,
	/*2406*/ -0x1.0ba518p-1,
	/*2407*/ -0x1.0c5074p-1,
	/*2408*/ -0x1.0cfba8p-1,
	/*2409*/ -0x1.0da6b2p-1,
	/*2410*/ -0x1.0e5194p-1,
	/*2411*/ -0x1.0efc4ap-1,
	/*2412*/ -0x1.0fa6d8p-1,
	/*2413*/ -0x1.10513cp-1,
	/*2414*/ -0x1.10fb74p-1,
	/*2415*/ -0x1.11a584p-1,
	/*2416*/ -0x1.124f68p-1,
	/*2417*/ -0x1.12f924p-1,
	/*2418*/ -0x1.13a2b4p-1,
	/*2419*/ -0x1.144c1ap-1,
	/*2420*/ -0x1.14f554p-1,
	/*2421*/ -0x1.159e64p-1,
	/*2422*/ -0x1.16474ap-1,
	/*2423*/ -0x1.16f006p-1,
	/*2424*/ -0x1.179894p-1,
	/*2425*/ -0x1.1840fap-1,
	/*2426*/ -0x1.18e932p-1,
	/*2427*/ -0x1.19914p-1,
	/*2428*/ -0x1.1a3922p-1,
	/*2429*/ -0x1.1ae0dap-1,
	/*2430*/ -0x1.1b8864p-1,
	/*2431*/ -0x1.1c2fc4p-1,
	/*2432*/ -0x1.1cd6f8p-1,
	/*2433*/ -0x1.1d7ep-1,
	/*2434*/ -0x1.1e24dap-1,
	/*2435*/ -0x1.1ecb8ap-1,
	/*2436*/ -0x1.1f720ep-1,
	/*2437*/ -0x1.201864p-1,
	/*2438*/ -0x1.20be8ep-1,
	/*2439*/ -0x1.21648cp-1,
	/*2440*/ -0x1.220a5ep-1,
	/*2441*/ -0x1.22b002p-1,
	/*2442*/ -0x1.23557ap-1,
	/*2443*/ -0x1.23fac4p-1,
	/*2444*/ -0x1.249fe2p-1,
	/*2445*/ -0x1.2544d2p-1,
	/*2446*/ -0x1.25e996p-1,
	/*2447*/ -0x1.268e2cp-1,
	/*2448*/ -0x1.273294p-1,
	/*2449*/ -0x1.27d6dp-1,
	/*2450*/ -0x1.287adcp-1,
	/*2451*/ -0x1.291ebcp-1,
	/*2452*/ -0x1.29c26ep-1,
	/*2453*/ -0x1.2a65f2p-1,
	/*2454*/ -0x1.2b0948p-1,
	/*2455*/ -0x1.2bac6ep-1,
	/*2456*/ -0x1.2c4f68p-1,
	/*2457*/ -0x1.2cf232p-1,
	/*2458*/ -0x1.2d94dp-1,
	/*2459*/ -0x1.2e373ep-1,
	/*2460*/ -0x1.2ed97cp-1,
	/*2461*/ -0x1.2f7b8ep-1,
	/*2462*/ -0x1.301d7p-1,
	/*2463*/ -0x1.30bf22p-1,
	/*2464*/ -0x1.3160a6p-1,
	/*2465*/ -0x1.3201fap-1,
	/*2466*/ -0x1.32a32p-1,
	/*2467*/ -0x1.334416p-1,
	/*2468*/ -0x1.33e4dep-1,
	/*2469*/ -0x1.348574p-1,
	/*2470*/ -0x1.3525dcp-1,
	/*2471*/ -0x1.35c614p-1,
	/*2472*/ -0x1.36661cp-1,
	/*2473*/ -0x1.3705f6p-1,
	/*2474*/ -0x1.37a59ep-1,
	/*2475*/ -0x1.384516p-1,
	/*2476*/ -0x1.38e45ep-1,
	/*2477*/ -0x1.398376p-1,
	/*2478*/ -0x1.3a225ep-1,
	/*2479*/ -0x1.3ac114p-1,
	/*2480*/ -0x1.3b5f9ap-1,
	/*2481*/ -0x1.3bfdfp-1,
	/*2482*/ -0x1.3c9c16p-1,
	/*2483*/ -0x1.3d3a0ap-1,
	/*2484*/ -0x1.3dd7ccp-1,
	/*2485*/ -0x1.3e756p-1,
	/*2486*/ -0x1.3f12cp-1,
	/*2487*/ -0x1.3faffp-1,
	/*2488*/ -0x1.404ceep-1,
	/*2489*/ -0x1.40e9bcp-1,
	/*2490*/ -0x1.418658p-1,
	/*2491*/ -0x1.4222c2p-1,
	/*2492*/ -0x1.42befap-1,
	/*2493*/ -0x1.435bp-1,
	/*2494*/ -0x1.43f6d4p-1,
	/*2495*/ -0x1.449276p-1,
	/*2496*/ -0x1.452de8p-1,
	/*2497*/ -0x1.45c926p-1,
	/*2498*/ -0x1.466432p-1,
	/*2499*/ -0x1.46ff0cp-1,
	/*2500*/ -0x1.4799b2p-1,
	/*2501*/ -0x1.483428p-1,
	/*2502*/ -0x1.48ce6ap-1,
	/*2503*/ -0x1.496878p-1,
	/*2504*/ -0x1.4a0256p-1,
	/*2505*/ -0x1.4a9cp-1,
	/*2506*/ -0x1.4b3576p-1,
	/*2507*/ -0x1.4bcebap-1,
	/*2508*/ -0x1.4c67cap-1,
	/*2509*/ -0x1.4d00a6p-1,
	/*2510*/ -0x1.4d995p-1,
	/*2511*/ -0x1.4e31c6p-1,
	/*2512*/ -0x1.4eca08p-1,
	/*2513*/ -0x1.4f6218p-1,
	/*2514*/ -0x1.4ff9f4p-1,
	/*2515*/ -0x1.50919ap-1,
	/*2516*/ -0x1.51290ep-1,
	/*2517*/ -0x1.51c04ep-1,
	/*2518*/ -0x1.525758p-1,
	/*2519*/ -0x1.52ee3p-1,
	/*2520*/ -0x1.5384d2p-1,
	/*2521*/ -0x1.541b42p-1,
	/*2522*/ -0x1.54b17ap-1,
	/*2523*/ -0x1.55478p-1,
	/*2524*/ -0x1.55dd52p-1,
	/*2525*/ -0x1.5672eep-1,
	/*2526*/ -0x1.570854p-1,
	/*2527*/ -0x1.579d86p-1,
	/*2528*/ -0x1.583284p-1,
	/*2529*/ -0x1.58c74cp-1,
	/*2530*/ -0x1.595bdep-1,
	/*2531*/ -0x1.59f03cp-1,
	/*2532*/ -0x1.5a8464p-1,
	/*2533*/ -0x1.5b1858p-1,
	/*2534*/ -0x1.5bac14p-1,
	/*2535*/ -0x1.5c3f9cp-1,
	/*2536*/ -0x1.5cd2eep-1,
	/*2537*/ -0x1.5d660ap-1,
	/*2538*/ -0x1.5df8fp-1,
	/*2539*/ -0x1.5e8bap-1,
	/*2540*/ -0x1.5f1e1ap-1,
	/*2541*/ -0x1.5fb05ep-1,
	/*2542*/ -0x1.60426cp-1,
	/*2543*/ -0x1.60d444p-1,
	/*2544*/ -0x1.6165e4p-1,
	/*2545*/ -0x1.61f74ep-1,
	/*2546*/ -0x1.628882p-1,
	/*2547*/ -0x1.63198p-1,
	/*2548*/ -0x1.63aa46p-1,
	/*2549*/ -0x1.643ad4p-1,
	/*2550*/ -0x1.64cb2ep-1,
	/*2551*/ -0x1.655b4ep-1,
	/*2552*/ -0x1.65eb38p-1,
	/*2553*/ -0x1.667aecp-1,
	/*2554*/ -0x1.670a68p-1,
	/*2555*/ -0x1.6799acp-1,
	/*2556*/ -0x1.6828b8p-1,
	/*2557*/ -0x1.68b78ep-1,
	/*2558*/ -0x1.69462cp-1,
	/*2559*/ -0x1.69d49p-1,
	/*2560*/ -0x1.6a62bep-1,
	/*2561*/ -0x1.6af0b6p-1,
	/*2562*/ -0x1.6b7e74p-1,
	/*2563*/ -0x1.6c0bfap-1,
	/*2564*/ -0x1.6c9946p-1,
	/*2565*/ -0x1.6d265cp-1,
	/*2566*/ -0x1.6db33ap-1,
	/*2567*/ -0x1.6e3fdep-1,
	/*2568*/ -0x1.6ecc4ap-1,
	/*2569*/ -0x1.6f587ep-1,
	/*2570*/ -0x1.6fe47ap-1,
	/*2571*/ -0x1.70703cp-1,
	/*2572*/ -0x1.70fbc6p-1,
	/*2573*/ -0x1.718716p-1,
	/*2574*/ -0x1.72122ep-1,
	/*2575*/ -0x1.729d0cp-1,
	/*2576*/ -0x1.7327b2p-1,
	/*2577*/ -0x1.73b21cp-1,
	/*2578*/ -0x1.743c5p-1,
	/*2579*/ -0x1.74c648p-1,
	/*2580*/ -0x1.755008p-1,
	/*2581*/ -0x1.75d98ep-1,
	/*2582*/ -0x1.7662dap-1,
	/*2583*/ -0x1.76ebeep-1,
	/*2584*/ -0x1.7774c6p-1,
	/*2585*/ -0x1.77fd66p-1,
	/*2586*/ -0x1.7885cap-1,
	/*2587*/ -0x1.790df4p-1,
	/*2588*/ -0x1.7995e6p-1,
	/*2589*/ -0x1.7a1d9cp-1,
	/*2590*/ -0x1.7aa518p-1,
	/*2591*/ -0x1.7b2c5ap-1,
	/*2592*/ -0x1.7bb36p-1,
	/*2593*/ -0x1.7c3a2cp-1,
	/*2594*/ -0x1.7cc0bep-1,
	/*2595*/ -0x1.7d4716p-1,
	/*2596*/ -0x1.7dcd32p-1,
	/*2597*/ -0x1.7e5312p-1,
	/*2598*/ -0x1.7ed8bap-1,
	/*2599*/ -0x1.7f5e24p-1,
	/*2600*/ -0x1.7fe354p-1,
	/*2601*/ -0x1.80684ap-1,
	/*2602*/ -0x1.80ed04p-1,
	/*2603*/ -0x1.817182p-1,
	/*2604*/ -0x1.81f5c4p-1,
	/*2605*/ -0x1.8279ccp-1,
	/*2606*/ -0x1.82fd96p-1,
	/*2607*/ -0x1.838126p-1,
	/*2608*/ -0x1.84047ap-1,
	/*2609*/ -0x1.848792p-1,
	/*2610*/ -0x1.850a6ep-1,
	/*2611*/ -0x1.858d1p-1,
	/*2612*/ -0x1.860f74p-1,
	/*2613*/ -0x1.86919cp-1,
	/*2614*/ -0x1.871386p-1,
	/*2615*/ -0x1.879536p-1,
	/*2616*/ -0x1.8816aap-1,
	/*2617*/ -0x1.8897ep-1,
	/*2618*/ -0x1.8918dap-1,
	/*2619*/ -0x1.899996p-1,
	/*2620*/ -0x1.8a1a16p-1,
	/*2621*/ -0x1.8a9a5ap-1,
	/*2622*/ -0x1.8b1a62p-1,
	/*2623*/ -0x1.8b9a2cp-1,
	/*2624*/ -0x1.8c19b8p-1,
	/*2625*/ -0x1.8c9908p-1,
	/*2626*/ -0x1.8d181ap-1,
	/*2627*/ -0x1.8d96fp-1,
	/*2628*/ -0x1.8e1588p-1,
	/*2629*/ -0x1.8e93e2p-1,
	/*2630*/ -0x1.8f11fep-1,
	/*2631*/ -0x1.8f8fdep-1,
	/*2632*/ -0x1.900d8p-1,
	/*2633*/ -0x1.908ae4p-1,
	/*2634*/ -0x1.91080ap-1,
	/*2635*/ -0x1.9184f2p-1,
	/*2636*/ -0x1.92019cp-1,
	/*2637*/ -0x1.927e0ap-1,
	/*2638*/ -0x1.92fa38p-1,
	/*2639*/ -0x1.937628p-1,
	/*2640*/ -0x1.93f1dap-1,
	/*2641*/ -0x1.946d4cp-1,
	/*2642*/ -0x1.94e882p-1,
	/*2643*/ -0x1.956378p-1,
	/*2644*/ -0x1.95de3p-1,
	/*2645*/ -0x1.9658aap-1,
	/*2646*/ -0x1.96d2e4p-1,
	/*2647*/ -0x1.974cep-1,
	/*2648*/ -0x1.97c69ep-1,
	/*2649*/ -0x1.98401cp-1,
	/*2650*/ -0x1.98b95cp-1,
	/*2651*/ -0x1.99325cp-1,
	/*2652*/ -0x1.99ab1cp-1,
	/*2653*/ -0x1.9a239ep-1,
	/*2654*/ -0x1.9a9be2p-1,
	/*2655*/ -0x1.9b13e4p-1,
	/*2656*/ -0x1.9b8ba8p-1,
	/*2657*/ -0x1.9c032cp-1,
	/*2658*/ -0x1.9c7a72p-1,
	/*2659*/ -0x1.9cf176p-1,
	/*2660*/ -0x1.9d683cp-1,
	/*2661*/ -0x1.9ddec2p-1,
	/*2662*/ -0x1.9e5508p-1,
	/*2663*/ -0x1.9ecb0ep-1,
	/*2664*/ -0x1.9f40d2p-1,
	/*2665*/ -0x1.9fb658p-1,
	/*2666*/ -0x1.a02b9ep-1,
	/*2667*/ -0x1.a0a0a4p-1,
	/*2668*/ -0x1.a11568p-1,
	/*2669*/ -0x1.a189eep-1,
	/*2670*/ -0x1.a1fe32p-1,
	/*2671*/ -0x1.a27236p-1,
	/*2672*/ -0x1.a2e5fap-1,
	/*2673*/ -0x1.a3597cp-1,
	/*2674*/ -0x1.a3ccbep-1,
	/*2675*/ -0x1.a43fbep-1,
	/*2676*/ -0x1.a4b28p-1,
	/*2677*/ -0x1.a524fep-1,
	/*2678*/ -0x1.a5973ep-1,
	/*2679*/ -0x1.a6093ap-1,
	/*2680*/ -0x1.a67af6p-1,
	/*2681*/ -0x1.a6ec72p-1,
	/*2682*/ -0x1.a75dacp-1,
	/*2683*/ -0x1.a7cea4p-1,
	/*2684*/ -0x1.a83f5cp-1,
	/*2685*/ -0x1.a8afd2p-1,
	/*2686*/ -0x1.a92006p-1,
	/*2687*/ -0x1.a98ff8p-1,
	/*2688*/ -0x1.a9ffaap-1,
	/*2689*/ -0x1.aa6f18p-1,
	/*2690*/ -0x1.aade46p-1,
	/*2691*/ -0x1.ab4d32p-1,
	/*2692*/ -0x1.abbbdcp-1,
	/*2693*/ -0x1.ac2a42p-1,
	/*2694*/ -0x1.ac9868p-1,
	/*2695*/ -0x1.ad064cp-1,
	/*2696*/ -0x1.ad73ecp-1,
	/*2697*/ -0x1.ade14cp-1,
	/*2698*/ -0x1.ae4e68p-1,
	/*2699*/ -0x1.aebb42p-1,
	/*2700*/ -0x1.af27dap-1,
	/*2701*/ -0x1.af943p-1,
	/*2702*/ -0x1.b00042p-1,
	/*2703*/ -0x1.b06c12p-1,
	/*2704*/ -0x1.b0d7ap-1,
	/*2705*/ -0x1.b142eap-1,
	/*2706*/ -0x1.b1adf2p-1,
	/*2707*/ -0x1.b218b8p-1,
	/*2708*/ -0x1.b2833ap-1,
	/*2709*/ -0x1.b2ed78p-1,
	/*2710*/ -0x1.b35774p-1,
	/*2711*/ -0x1.b3c12cp-1,
	/*2712*/ -0x1.b42aa2p-1,
	/*2713*/ -0x1.b493d4p-1,
	/*2714*/ -0x1.b4fcc2p-1,
	/*2715*/ -0x1.b5656ep-1,
	/*2716*/ -0x1.b5cdd4p-1,
	/*2717*/ -0x1.b635fap-1,
	/*2718*/ -0x1.b69ddap-1,
	/*2719*/ -0x1.b70576p-1,
	/*2720*/ -0x1.b76cdp-1,
	/*2721*/ -0x1.b7d3e6p-1,
	/*2722*/ -0x1.b83ab6p-1,
	/*2723*/ -0x1.b8a144p-1,
	/*2724*/ -0x1.b9078ep-1,
	/*2725*/ -0x1.b96d94p-1,
	/*2726*/ -0x1.b9d354p-1,
	/*2727*/ -0x1.ba38d2p-1,
	/*2728*/ -0x1.ba9e0cp-1,
	/*2729*/ -0x1.bb03p-1,
	/*2730*/ -0x1.bb67bp-1,
	/*2731*/ -0x1.bbcc1cp-1,
	/*2732*/ -0x1.bc3044p-1,
	/*2733*/ -0x1.bc9426p-1,
	/*2734*/ -0x1.bcf7c6p-1,
	/*2735*/ -0x1.bd5b1ep-1,
	/*2736*/ -0x1.bdbe34p-1,
	/*2737*/ -0x1.be2104p-1,
	/*2738*/ -0x1.be839p-1,
	/*2739*/ -0x1.bee5d6p-1,
	/*2740*/ -0x1.bf47d8p-1,
	/*2741*/ -0x1.bfa994p-1,
	/*2742*/ -0x1.c00b0cp-1,
	/*2743*/ -0x1.c06c3ep-1,
	/*2744*/ -0x1.c0cd2cp-1,
	/*2745*/ -0x1.c12dd4p-1,
	/*2746*/ -0x1.c18e36p-1,
	/*2747*/ -0x1.c1ee54p-1,
	/*2748*/ -0x1.c24e2cp-1,
	/*2749*/ -0x1.c2adbep-1,
	/*2750*/ -0x1.c30d0ap-1,
	/*2751*/ -0x1.c36c12p-1,
	/*2752*/ -0x1.c3cad4p-1,
	/*2753*/ -0x1.c4295p-1,
	/*2754*/ -0x1.c48786p-1,
	/*2755*/ -0x1.c4e576p-1,
	/*2756*/ -0x1.c5432p-1,
	/*2757*/ -0x1.c5a084p-1,
	/*2758*/ -0x1.c5fda4p-1,
	/*2759*/ -0x1.c65a7cp-1,
	/*2760*/ -0x1.c6b70ep-1,
	/*2761*/ -0x1.c7135ap-1,
	/*2762*/ -0x1.c76f6p-1,
	/*2763*/ -0x1.c7cb2p-1,
	/*2764*/ -0x1.c8269ap-1,
	/*2765*/ -0x1.c881ccp-1,
	/*2766*/ -0x1.c8dcb8p-1,
	/*2767*/ -0x1.c9375ep-1,
	/*2768*/ -0x1.c991bep-1,
	/*2769*/ -0x1.c9ebd8p-1,
	/*2770*/ -0x1.ca45aap-1,
	/*2771*/ -0x1.ca9f36p-1,
	/*2772*/ -0x1.caf87ap-1,
	/*2773*/ -0x1.cb5178p-1,
	/*2774*/ -0x1.cbaa3p-1,
	/*2775*/ -0x1.cc02ap-1,
	/*2776*/ -0x1.cc5acap-1,
	/*2777*/ -0x1.ccb2acp-1,
	/*2778*/ -0x1.cd0a46p-1,
	/*2779*/ -0x1.cd619ap-1,
	/*2780*/ -0x1.cdb8a8p-1,
	/*2781*/ -0x1.ce0f6cp-1,
	/*2782*/ -0x1.ce65ecp-1,
	/*2783*/ -0x1.cebc22p-1,
	/*2784*/ -0x1.cf1212p-1,
	/*2785*/ -0x1.cf67bap-1,
	/*2786*/ -0x1.cfbd1ap-1,
	/*2787*/ -0x1.d01234p-1,
	/*2788*/ -0x1.d06706p-1,
	/*2789*/ -0x1.d0bb9p-1,
	/*2790*/ -0x1.d10fd2p-1,
	/*2791*/ -0x1.d163ccp-1,
	/*2792*/ -0x1.d1b77ep-1,
	/*2793*/ -0x1.d20ae8p-1,
	/*2794*/ -0x1.d25e0cp-1,
	/*2795*/ -0x1.d2b0e6p-1,
	/*2796*/ -0x1.d3037ap-1,
	/*2797*/ -0x1.d355c4p-1,
	/*2798*/ -0x1.d3a7c8p-1,
	/*2799*/ -0x1.d3f982p-1,
	/*2800*/ -0x1.d44af4p-1,
	/*2801*/ -0x1.d49c1ep-1,
	/*2802*/ -0x1.d4edp-1,
	/*2803*/ -0x1.d53d9ap-1,
	/*2804*/ -0x1.d58deap-1,
	/*2805*/ -0x1.d5ddf2p-1,
	/*2806*/ -0x1.d62db4p-1,
	/*2807*/ -0x1.d67d2ap-1,
	/*2808*/ -0x1.d6cc5ap-1,
	/*2809*/ -0x1.d71b4p-1,
	/*2810*/ -0x1.d769dep-1,
	/*2811*/ -0x1.d7b832p-1,
	/*2812*/ -0x1.d8063ep-1,
	/*2813*/ -0x1.d85402p-1,
	/*2814*/ -0x1.d8a17cp-1,
	/*2815*/ -0x1.d8eeaep-1,
	/*2816*/ -0x1.d93b96p-1,
	/*2817*/ -0x1.d98836p-1,
	/*2818*/ -0x1.d9d48cp-1,
	/*2819*/ -0x1.da209ap-1,
	/*2820*/ -0x1.da6c5ep-1,
	/*2821*/ -0x1.dab7d8p-1,
	/*2822*/ -0x1.db030ap-1,
	/*2823*/ -0x1.db4df4p-1,
	/*2824*/ -0x1.db9892p-1,
	/*2825*/ -0x1.dbe2e8p-1,
	/*2826*/ -0x1.dc2cf4p-1,
	/*2827*/ -0x1.dc76b8p-1,
	/*2828*/ -0x1.dcc03p-1,
	/*2829*/ -0x1.dd096p-1,
	/*2830*/ -0x1.dd5246p-1,
	/*2831*/ -0x1.dd9ae4p-1,
	/*2832*/ -0x1.dde336p-1,
	/*2833*/ -0x1.de2b4p-1,
	/*2834*/ -0x1.de72fep-1,
	/*2835*/ -0x1.deba74p-1,
	/*2836*/ -0x1.df01ap-1,
	/*2837*/ -0x1.df4882p-1,
	/*2838*/ -0x1.df8f1ap-1,
	/*2839*/ -0x1.dfd568p-1,
	/*2840*/ -0x1.e01b6cp-1,
	/*2841*/ -0x1.e06124p-1,
	/*2842*/ -0x1.e0a694p-1,
	/*2843*/ -0x1.e0ebbap-1,
	/*2844*/ -0x1.e13096p-1,
	/*2845*/ -0x1.e17526p-1,
	/*2846*/ -0x1.e1b96ep-1,
	/*2847*/ -0x1.e1fd6ap-1,
	/*2848*/ -0x1.e2411cp-1,
	/*2849*/ -0x1.e28484p-1,
	/*2850*/ -0x1.e2c7ap-1,
	/*2851*/ -0x1.e30a74p-1,
	/*2852*/ -0x1.e34cfcp-1,
	/*2853*/ -0x1.e38f38p-1,
	/*2854*/ -0x1.e3d12cp-1,
	/*2855*/ -0x1.e412d4p-1,
	/*2856*/ -0x1.e45432p-1,
	/*2857*/ -0x1.e49544p-1,
	/*2858*/ -0x1.e4d60cp-1,
	/*2859*/ -0x1.e5168ap-1,
	/*2860*/ -0x1.e556bcp-1,
	/*2861*/ -0x1.e596a4p-1,
	/*2862*/ -0x1.e5d642p-1,
	/*2863*/ -0x1.e61594p-1,
	/*2864*/ -0x1.e6549ap-1,
	/*2865*/ -0x1.e69356p-1,
	/*2866*/ -0x1.e6d1c6p-1,
	/*2867*/ -0x1.e70fecp-1,
	/*2868*/ -0x1.e74dc6p-1,
	/*2869*/ -0x1.e78b56p-1,
	/*2870*/ -0x1.e7c89ap-1,
	/*2871*/ -0x1.e80592p-1,
	/*2872*/ -0x1.e8424p-1,
	/*2873*/ -0x1.e87ea2p-1,
	/*2874*/ -0x1.e8bab8p-1,
	/*2875*/ -0x1.e8f684p-1,
	/*2876*/ -0x1.e93204p-1,
	/*2877*/ -0x1.e96d38p-1,
	/*2878*/ -0x1.e9a82p-1,
	/*2879*/ -0x1.e9e2bep-1,
	/*2880*/ -0x1.ea1d1p-1,
	/*2881*/ -0x1.ea5716p-1,
	/*2882*/ -0x1.ea90dp-1,
	/*2883*/ -0x1.eaca4p-1,
	/*2884*/ -0x1.eb0362p-1,
	/*2885*/ -0x1.eb3c3ap-1,
	/*2886*/ -0x1.eb74c6p-1,
	/*2887*/ -0x1.ebad06p-1,
	/*2888*/ -0x1.ebe4fap-1,
	/*2889*/ -0x1.ec1ca2p-1,
	/*2890*/ -0x1.ec53fep-1,
	/*2891*/ -0x1.ec8b0ep-1,
	/*2892*/ -0x1.ecc1d2p-1,
	/*2893*/ -0x1.ecf84ap-1,
	/*2894*/ -0x1.ed2e76p-1,
	/*2895*/ -0x1.ed6456p-1,
	/*2896*/ -0x1.ed99eap-1,
	/*2897*/ -0x1.edcf3p-1,
	/*2898*/ -0x1.ee042cp-1,
	/*2899*/ -0x1.ee38dcp-1,
	/*2900*/ -0x1.ee6d3ep-1,
	/*2901*/ -0x1.eea154p-1,
	/*2902*/ -0x1.eed52p-1,
	/*2903*/ -0x1.ef089ep-1,
	/*2904*/ -0x1.ef3bdp-1,
	/*2905*/ -0x1.ef6eb4p-1,
	/*2906*/ -0x1.efa14ep-1,
	/*2907*/ -0x1.efd39ap-1,
	/*2908*/ -0x1.f0059ap-1,
	/*2909*/ -0x1.f0374cp-1,
	/*2910*/ -0x1.f068b4p-1,
	/*2911*/ -0x1.f099cep-1,
	/*2912*/ -0x1.f0ca9ap-1,
	/*2913*/ -0x1.f0fb1cp-1,
	/*2914*/ -0x1.f12b5p-1,
	/*2915*/ -0x1.f15b38p-1,
	/*2916*/ -0x1.f18ad2p-1,
	/*2917*/ -0x1.f1ba2p-1,
	/*2918*/ -0x1.f1e922p-1,
	/*2919*/ -0x1.f217d6p-1,
	/*2920*/ -0x1.f2463ep-1,
	/*2921*/ -0x1.f27458p-1,
	/*2922*/ -0x1.f2a226p-1,
	/*2923*/ -0x1.f2cfa6p-1,
	/*2924*/ -0x1.f2fcdap-1,
	/*2925*/ -0x1.f329c2p-1,
	/*2926*/ -0x1.f3565cp-1,
	/*2927*/ -0x1.f382a8p-1,
	/*2928*/ -0x1.f3aea8p-1,
	/*2929*/ -0x1.f3da5ap-1,
	/*2930*/ -0x1.f405cp-1,
	/*2931*/ -0x1.f430d8p-1,
	/*2932*/ -0x1.f45ba4p-1,
	/*2933*/ -0x1.f48622p-1,
	/*2934*/ -0x1.f4b052p-1,
	/*2935*/ -0x1.f4da36p-1,
	/*2936*/ -0x1.f503ccp-1,
	/*2937*/ -0x1.f52d14p-1,
	/*2938*/ -0x1.f5561p-1,
	/*2939*/ -0x1.f57ebep-1,
	/*2940*/ -0x1.f5a72p-1,
	/*2941*/ -0x1.f5cf34p-1,
	/*2942*/ -0x1.f5f6fap-1,
	/*2943*/ -0x1.f61e72p-1,
	/*2944*/ -0x1.f6459cp-1,
	/*2945*/ -0x1.f66c7ap-1,
	/*2946*/ -0x1.f6930ap-1,
	/*2947*/ -0x1.f6b94ep-1,
	/*2948*/ -0x1.f6df42p-1,
	/*2949*/ -0x1.f704eap-1,
	/*2950*/ -0x1.f72a44p-1,
	/*2951*/ -0x1.f74f5p-1,
	/*2952*/ -0x1.f7740ep-1,
	/*2953*/ -0x1.f7988p-1,
	/*2954*/ -0x1.f7bca2p-1,
	/*2955*/ -0x1.f7e078p-1,
	/*2956*/ -0x1.f804p-1,
	/*2957*/ -0x1.f8273ap-1,
	/*2958*/ -0x1.f84a26p-1,
	/*2959*/ -0x1.f86cc4p-1,
	/*2960*/ -0x1.f88f14p-1,
	/*2961*/ -0x1.f8b118p-1,
	/*2962*/ -0x1.f8d2ccp-1,
	/*2963*/ -0x1.f8f434p-1,
	/*2964*/ -0x1.f9154cp-1,
	/*2965*/ -0x1.f93618p-1,
	/*2966*/ -0x1.f95694p-1,
	/*2967*/ -0x1.f976c4p-1,
	/*2968*/ -0x1.f996a4p-1,
	/*2969*/ -0x1.f9b638p-1,
	/*2970*/ -0x1.f9d57ep-1,
	/*2971*/ -0x1.f9f474p-1,
	/*2972*/ -0x1.fa131ep-1,
	/*2973*/ -0x1.fa3178p-1,
	/*2974*/ -0x1.fa4f86p-1,
	/*2975*/ -0x1.fa6d44p-1,
	/*2976*/ -0x1.fa8ab4p-1,
	/*2977*/ -0x1.faa7d8p-1,
	/*2978*/ -0x1.fac4acp-1,
	/*2979*/ -0x1.fae132p-1,
	/*2980*/ -0x1.fafd6ap-1,
	/*2981*/ -0x1.fb1954p-1,
	/*2982*/ -0x1.fb34eep-1,
	/*2983*/ -0x1.fb503cp-1,
	/*2984*/ -0x1.fb6b3ap-1,
	/*2985*/ -0x1.fb85ecp-1,
	/*2986*/ -0x1.fba04ep-1,
	/*2987*/ -0x1.fbba62p-1,
	/*2988*/ -0x1.fbd428p-1,
	/*2989*/ -0x1.fbed9ep-1,
	/*2990*/ -0x1.fc06c8p-1,
	/*2991*/ -0x1.fc1fa2p-1,
	/*2992*/ -0x1.fc382ep-1,
	/*2993*/ -0x1.fc506cp-1,
	/*2994*/ -0x1.fc685cp-1,
	/*2995*/ -0x1.fc7ffcp-1,
	/*2996*/ -0x1.fc974ep-1,
	/*2997*/ -0x1.fcae52p-1,
	/*2998*/ -0x1.fcc508p-1,
	/*2999*/ -0x1.fcdb7p-1,
	/*3000*/ -0x1.fcf188p-1,
	/*3001*/ -0x1.fd0752p-1,
	/*3002*/ -0x1.fd1cccp-1,
	/*3003*/ -0x1.fd31fap-1,
	/*3004*/ -0x1.fd46d8p-1,
	/*3005*/ -0x1.fd5b68p-1,
	/*3006*/ -0x1.fd6fa8p-1,
	/*3007*/ -0x1.fd839cp-1,
	/*3008*/ -0x1.fd974p-1,
	/*3009*/ -0x1.fdaa94p-1,
	/*3010*/ -0x1.fdbd9cp-1,
	/*3011*/ -0x1.fdd054p-1,
	/*3012*/ -0x1.fde2bcp-1,
	/*3013*/ -0x1.fdf4d8p-1,
	/*3014*/ -0x1.fe06a4p-1,
	/*3015*/ -0x1.fe182p-1,
	/*3016*/ -0x1.fe295p-1,
	/*3017*/ -0x1.fe3a3p-1,
	/*3018*/ -0x1.fe4acp-1,
	/*3019*/ -0x1.fe5b02p-1,
	/*3020*/ -0x1.fe6af6p-1,
	/*3021*/ -0x1.fe7a9cp-1,
	/*3022*/ -0x1.fe89f2p-1,
	/*3023*/ -0x1.fe98fap-1,
	/*3024*/ -0x1.fea7b2p-1,
	/*3025*/ -0x1.feb61cp-1,
	/*3026*/ -0x1.fec436p-1,
	/*3027*/ -0x1.fed204p-1,
	/*3028*/ -0x1.fedf8p-1,
	/*3029*/ -0x1.feecbp-1,
	/*3030*/ -0x1.fef98ep-1,
	/*3031*/ -0x1.ff062p-1,
	/*3032*/ -0x1.ff1262p-1,
	/*3033*/ -0x1.ff1e56p-1,
	/*3034*/ -0x1.ff29fap-1,
	/*3035*/ -0x1.ff355p-1,
	/*3036*/ -0x1.ff4056p-1,
	/*3037*/ -0x1.ff4b0ep-1,
	/*3038*/ -0x1.ff5576p-1,
	/*3039*/ -0x1.ff5f9p-1,
	/*3040*/ -0x1.ff695cp-1,
	/*3041*/ -0x1.ff72d8p-1,
	/*3042*/ -0x1.ff7c06p-1,
	/*3043*/ -0x1.ff84e4p-1,
	/*3044*/ -0x1.ff8d72p-1,
	/*3045*/ -0x1.ff95b4p-1,
	/*3046*/ -0x1.ff9da6p-1,
	/*3047*/ -0x1.ffa548p-1,
	/*3048*/ -0x1.ffac9cp-1,
	/*3049*/ -0x1.ffb3ap-1,
	/*3050*/ -0x1.ffba56p-1,
	/*3051*/ -0x1.ffc0bcp-1,
	/*3052*/ -0x1.ffc6d4p-1,
	/*3053*/ -0x1.ffcc9ep-1,
	/*3054*/ -0x1.ffd218p-1,
	/*3055*/ -0x1.ffd742p-1,
	/*3056*/ -0x1.ffdc1ep-1,
	/*3057*/ -0x1.ffe0acp-1,
	/*3058*/ -0x1.ffe4eap-1,
	/*3059*/ -0x1.ffe8dap-1,
	/*3060*/ -0x1.ffec7ap-1,
	/*3061*/ -0x1.ffefcap-1,
	/*3062*/ -0x1.fff2ccp-1,
	/*3063*/ -0x1.fff58p-1,
	/*3064*/ -0x1.fff7e4p-1,
	/*3065*/ -0x1.fff9fap-1,
	/*3066*/ -0x1.fffbcp-1,
	/*3067*/ -0x1.fffd36p-1,
	/*3068*/ -0x1.fffe5ep-1,
	/*3069*/ -0x1.ffff38p-1,
	/*3070*/ -0x1.ffffc2p-1,
	/*3071*/ -0x1.fffffep-1,
	/*3072*/ -0x1.ffffeap-1,
	/*3073*/ -0x1.ffff88p-1,
	/*3074*/ -0x1.fffed6p-1,
	/*3075*/ -0x1.fffdd4p-1,
	/*3076*/ -0x1.fffc84p-1,
	/*3077*/ -0x1.fffae6p-1,
	/*3078*/ -0x1.fff8f8p-1,
	/*3079*/ -0x1.fff6bcp-1,
	/*3080*/ -0x1.fff43p-1,
	/*3081*/ -0x1.fff156p-1,
	/*3082*/ -0x1.ffee2cp-1,
	/*3083*/ -0x1.ffeab2p-1,
	/*3084*/ -0x1.ffe6ecp-1,
	/*3085*/ -0x1.ffe2d4p-1,
	/*3086*/ -0x1.ffde7p-1,
	/*3087*/ -0x1.ffd9bap-1,
	/*3088*/ -0x1.ffd4b6p-1,
	/*3089*/ -0x1.ffcf64p-1,
	/*3090*/ -0x1.ffc9c2p-1,
	/*3091*/ -0x1.ffc3d2p-1,
	/*3092*/ -0x1.ffbd94p-1,
	/*3093*/ -0x1.ffb704p-1,
	/*3094*/ -0x1.ffb028p-1,
	/*3095*/ -0x1.ffa8fcp-1,
	/*3096*/ -0x1.ffa18p-1,
	/*3097*/ -0x1.ff99b6p-1,
	/*3098*/ -0x1.ff919cp-1,
	/*3099*/ -0x1.ff8934p-1,
	/*3100*/ -0x1.ff807ep-1,
	/*3101*/ -0x1.ff7778p-1,
	/*3102*/ -0x1.ff6e24p-1,
	/*3103*/ -0x1.ff648p-1,
	/*3104*/ -0x1.ff5a8cp-1,
	/*3105*/ -0x1.ff504cp-1,
	/*3106*/ -0x1.ff45bcp-1,
	/*3107*/ -0x1.ff3adcp-1,
	/*3108*/ -0x1.ff2faep-1,
	/*3109*/ -0x1.ff243p-1,
	/*3110*/ -0x1.ff1864p-1,
	/*3111*/ -0x1.ff0c4ap-1,
	/*3112*/ -0x1.feffep-1,
	/*3113*/ -0x1.fef328p-1,
	/*3114*/ -0x1.fee622p-1,
	/*3115*/ -0x1.fed8ccp-1,
	/*3116*/ -0x1.fecb26p-1,
	/*3117*/ -0x1.febd32p-1,
	/*3118*/ -0x1.feaefp-1,
	/*3119*/ -0x1.fea05ep-1,
	/*3120*/ -0x1.fe917ep-1,
	/*3121*/ -0x1.fe825p-1,
	/*3122*/ -0x1.fe72d2p-1,
	/*3123*/ -0x1.fe6306p-1,
	/*3124*/ -0x1.fe52eap-1,
	/*3125*/ -0x1.fe4282p-1,
	/*3126*/ -0x1.fe31c8p-1,
	/*3127*/ -0x1.fe20c2p-1,
	/*3128*/ -0x1.fe0f6cp-1,
	/*3129*/ -0x1.fdfdc6p-1,
	/*3130*/ -0x1.fdebd4p-1,
	/*3131*/ -0x1.fdd992p-1,
	/*3132*/ -0x1.fdc7p-1,
	/*3133*/ -0x1.fdb422p-1,
	/*3134*/ -0x1.fda0f4p-1,
	/*3135*/ -0x1.fd8d76p-1,
	/*3136*/ -0x1.fd79acp-1,
	/*3137*/ -0x1.fd6592p-1,
	/*3138*/ -0x1.fd5128p-1,
	/*3139*/ -0x1.fd3c72p-1,
	/*3140*/ -0x1.fd276cp-1,
	/*3141*/ -0x1.fd1218p-1,
	/*3142*/ -0x1.fcfc76p-1,
	/*3143*/ -0x1.fce684p-1,
	/*3144*/ -0x1.fcd044p-1,
	/*3145*/ -0x1.fcb9b6p-1,
	/*3146*/ -0x1.fca2dap-1,
	/*3147*/ -0x1.fc8baep-1,
	/*3148*/ -0x1.fc7434p-1,
	/*3149*/ -0x1.fc5c6cp-1,
	/*3150*/ -0x1.fc4456p-1,
	/*3151*/ -0x1.fc2bfp-1,
	/*3152*/ -0x1.fc133ep-1,
	/*3153*/ -0x1.fbfa3cp-1,
	/*3154*/ -0x1.fbe0ecp-1,
	/*3155*/ -0x1.fbc74ep-1,
	/*3156*/ -0x1.fbad6p-1,
	/*3157*/ -0x1.fb9326p-1,
	/*3158*/ -0x1.fb789cp-1,
	/*3159*/ -0x1.fb5dc4p-1,
	/*3160*/ -0x1.fb429ep-1,
	/*3161*/ -0x1.fb272ap-1,
	/*3162*/ -0x1.fb0b66p-1,
	/*3163*/ -0x1.faef56p-1,
	/*3164*/ -0x1.fad2f8p-1,
	/*3165*/ -0x1.fab64ap-1,
	/*3166*/ -0x1.fa994ep-1,
	/*3167*/ -0x1.fa7c04p-1,
	/*3168*/ -0x1.fa5e6ep-1,
	/*3169*/ -0x1.fa4088p-1,
	/*3170*/ -0x1.fa2254p-1,
	/*3171*/ -0x1.fa03d2p-1,
	/*3172*/ -0x1.f9e502p-1,
	/*3173*/ -0x1.f9c5e4p-1,
	/*3174*/ -0x1.f9a676p-1,
	/*3175*/ -0x1.f986bcp-1,
	/*3176*/ -0x1.f966b4p-1,
	/*3177*/ -0x1.f9465ep-1,
	/*3178*/ -0x1.f925bap-1,
	/*3179*/ -0x1.f904c8p-1,
	/*3180*/ -0x1.f8e388p-1,
	/*3181*/ -0x1.f8c1fap-1,
	/*3182*/ -0x1.f8a01ep-1,
	/*3183*/ -0x1.f87df4p-1,
	/*3184*/ -0x1.f85b7ep-1,
	/*3185*/ -0x1.f838b8p-1,
	/*3186*/ -0x1.f815a4p-1,
	/*3187*/ -0x1.f7f244p-1,
	/*3188*/ -0x1.f7ce96p-1,
	/*3189*/ -0x1.f7aa9ap-1,
	/*3190*/ -0x1.f7865p-1,
	/*3191*/ -0x1.f761b8p-1,
	/*3192*/ -0x1.f73cd2p-1,
	/*3193*/ -0x1.f7179ep-1,
	/*3194*/ -0x1.f6f21ep-1,
	/*3195*/ -0x1.f6cc5p-1,
	/*3196*/ -0x1.f6a634p-1,
	/*3197*/ -0x1.f67fcap-1,
	/*3198*/ -0x1.f65914p-1,
	/*3199*/ -0x1.f6321p-1,
	/*3200*/ -0x1.f60abep-1,
	/*3201*/ -0x1.f5e31ep-1,
	/*3202*/ -0x1.f5bb32p-1,
	/*3203*/ -0x1.f592f8p-1,
	/*3204*/ -0x1.f56a7p-1,
	/*3205*/ -0x1.f5419ap-1,
	/*3206*/ -0x1.f51878p-1,
	/*3207*/ -0x1.f4ef08p-1,
	/*3208*/ -0x1.f4c54cp-1,
	/*3209*/ -0x1.f49b42p-1,
	/*3210*/ -0x1.f470eap-1,
	/*3211*/ -0x1.f44646p-1,
	/*3212*/ -0x1.f41b54p-1,
	/*3213*/ -0x1.f3f014p-1,
	/*3214*/ -0x1.f3c488p-1,
	/*3215*/ -0x1.f398bp-1,
	/*3216*/ -0x1.f36c8ap-1,
	/*3217*/ -0x1.f34016p-1,
	/*3218*/ -0x1.f31356p-1,
	/*3219*/ -0x1.f2e648p-1,
	/*3220*/ -0x1.f2b8eep-1,
	/*3221*/ -0x1.f28b46p-1,
	/*3222*/ -0x1.f25d52p-1,
	/*3223*/ -0x1.f22f12p-1,
	/*3224*/ -0x1.f20084p-1,
	/*3225*/ -0x1.f1d1a8p-1,
	/*3226*/ -0x1.f1a28p-1,
	/*3227*/ -0x1.f1730cp-1,
	/*3228*/ -0x1.f1434cp-1,
	/*3229*/ -0x1.f1133ep-1,
	/*3230*/ -0x1.f0e2e2p-1,
	/*3231*/ -0x1.f0b23cp-1,
	/*3232*/ -0x1.f08148p-1,
	/*3233*/ -0x1.f05008p-1,
	/*3234*/ -0x1.f01e7ap-1,
	/*3235*/ -0x1.efecap-1,
	/*3236*/ -0x1.efba7ap-1,
	/*3237*/ -0x1.ef8808p-1,
	/*3238*/ -0x1.ef554ap-1,
	/*3239*/ -0x1.ef223ep-1,
	/*3240*/ -0x1.eeeee6p-1,
	/*3241*/ -0x1.eebb42p-1,
	/*3242*/ -0x1.ee8752p-1,
	/*3243*/ -0x1.ee5314p-1,
	/*3244*/ -0x1.ee1e8cp-1,
	/*3245*/ -0x1.ede9b6p-1,
	/*3246*/ -0x1.edb494p-1,
	/*3247*/ -0x1.ed7f26p-1,
	/*3248*/ -0x1.ed496cp-1,
	/*3249*/ -0x1.ed1366p-1,
	/*3250*/ -0x1.ecdd14p-1,
	/*3251*/ -0x1.eca676p-1,
	/*3252*/ -0x1.ec6f8cp-1,
	/*3253*/ -0x1.ec3856p-1,
	/*3254*/ -0x1.ec00d4p-1,
	/*3255*/ -0x1.ebc906p-1,
	/*3256*/ -0x1.eb90ecp-1,
	/*3257*/ -0x1.eb5888p-1,
	/*3258*/ -0x1.eb1fd6p-1,
	/*3259*/ -0x1.eae6d8p-1,
	/*3260*/ -0x1.eaad9p-1,
	/*3261*/ -0x1.ea73fap-1,
	/*3262*/ -0x1.ea3a1ap-1,
	/*3263*/ -0x1.e9ffeep-1,
	/*3264*/ -0x1.e9c576p-1,
	/*3265*/ -0x1.e98ab4p-1,
	/*3266*/ -0x1.e94fa4p-1,
	/*3267*/ -0x1.e9144ap-1,
	/*3268*/ -0x1.e8d8a6p-1,
	/*3269*/ -0x1.e89cb4p-1,
	/*3270*/ -0x1.e86078p-1,
	/*3271*/ -0x1.e823fp-1,
	/*3272*/ -0x1.e7e71cp-1,
	/*3273*/ -0x1.e7a9fep-1,
	/*3274*/ -0x1.e76c94p-1,
	/*3275*/ -0x1.e72eep-1,
	/*3276*/ -0x1.e6f0ep-1,
	/*3277*/ -0x1.e6b294p-1,
	/*3278*/ -0x1.e673fep-1,
	/*3279*/ -0x1.e6351ep-1,
	/*3280*/ -0x1.e5f5fp-1,
	/*3281*/ -0x1.e5b67ap-1,
	/*3282*/ -0x1.e576b8p-1,
	/*3283*/ -0x1.e536aap-1,
	/*3284*/ -0x1.e4f652p-1,
	/*3285*/ -0x1.e4b5bp-1,
	/*3286*/ -0x1.e474c2p-1,
	/*3287*/ -0x1.e4338ap-1,
	/*3288*/ -0x1.e3f206p-1,
	/*3289*/ -0x1.e3b03ap-1,
	/*3290*/ -0x1.e36e2p-1,
	/*3291*/ -0x1.e32bbep-1,
	/*3292*/ -0x1.e2e91p-1,
	/*3293*/ -0x1.e2a618p-1,
	/*3294*/ -0x1.e262d6p-1,
	/*3295*/ -0x1.e21f4ap-1,
	/*3296*/ -0x1.e1db72p-1,
	/*3297*/ -0x1.e1975p-1,
	/*3298*/ -0x1.e152e4p-1,
	/*3299*/ -0x1.e10e2ep-1,
	/*3300*/ -0x1.e0c92ep-1,
	/*3301*/ -0x1.e083e4p-1,
	/*3302*/ -0x1.e03e4ep-1,
	/*3303*/ -0x1.dff87p-1,
	/*3304*/ -0x1.dfb246p-1,
	/*3305*/ -0x1.df6bd4p-1,
	/*3306*/ -0x1.df2518p-1,
	/*3307*/ -0x1.dede1p-1,
	/*3308*/ -0x1.de96cp-1,
	/*3309*/ -0x1.de4f26p-1,
	/*3310*/ -0x1.de0742p-1,
	/*3311*/ -0x1.ddbf14p-1,
	/*3312*/ -0x1.dd769cp-1,
	/*3313*/ -0x1.dd2ddap-1,
	/*3314*/ -0x1.dce4cep-1,
	/*3315*/ -0x1.dc9b7ap-1,
	/*3316*/ -0x1.dc51dcp-1,
	/*3317*/ -0x1.dc07f4p-1,
	/*3318*/ -0x1.dbbdc4p-1,
	/*3319*/ -0x1.db734ap-1,
	/*3320*/ -0x1.db2886p-1,
	/*3321*/ -0x1.dadd78p-1,
	/*3322*/ -0x1.da9222p-1,
	/*3323*/ -0x1.da4682p-1,
	/*3324*/ -0x1.d9fa9ap-1,
	/*3325*/ -0x1.d9ae68p-1,
	/*3326*/ -0x1.d961ecp-1,
	/*3327*/ -0x1.d91528p-1,
	/*3328*/ -0x1.d8c81cp-1,
	/*3329*/ -0x1.d87ac6p-1,
	/*3330*/ -0x1.d82d26p-1,
	/*3331*/ -0x1.d7df3ep-1,
	/*3332*/ -0x1.d7910ep-1,
	/*3333*/ -0x1.d74294p-1,
	/*3334*/ -0x1.d6f3d2p-1,
	/*3335*/ -0x1.d6a4c8p-1,
	/*3336*/ -0x1.d65574p-1,
	/*3337*/ -0x1.d605d8p-1,
	/*3338*/ -0x1.d5b5f4p-1,
	/*3339*/ -0x1.d565c8p-1,
	/*3340*/ -0x1.d51552p-1,
	/*3341*/ -0x1.d4c494p-1,
	/*3342*/ -0x1.d4738ep-1,
	/*3343*/ -0x1.d4224p-1,
	/*3344*/ -0x1.d3d0aap-1,
	/*3345*/ -0x1.d37eccp-1,
	/*3346*/ -0x1.d32ca4p-1,
	/*3347*/ -0x1.d2da36p-1,
	/*3348*/ -0x1.d2877ep-1,
	/*3349*/ -0x1.d2348p-1,
	/*3350*/ -0x1.d1e13ap-1,
	/*3351*/ -0x1.d18daap-1,
	/*3352*/ -0x1.d139d4p-1,
	/*3353*/ -0x1.d0e5b6p-1,
	/*3354*/ -0x1.d0915p-1,
	/*3355*/ -0x1.d03ca2p-1,
	/*3356*/ -0x1.cfe7acp-1,
	/*3357*/ -0x1.cf927p-1,
	/*3358*/ -0x1.cf3cecp-1,
	/*3359*/ -0x1.cee72p-1,
	/*3360*/ -0x1.ce910cp-1,
	/*3361*/ -0x1.ce3ab2p-1,
	/*3362*/ -0x1.cde41p-1,
	/*3363*/ -0x1.cd8d26p-1,
	/*3364*/ -0x1.cd35f6p-1,
	/*3365*/ -0x1.ccde7ep-1,
	/*3366*/ -0x1.cc86cp-1,
	/*3367*/ -0x1.cc2ebap-1,
	/*3368*/ -0x1.cbd66ep-1,
	/*3369*/ -0x1.cb7ddap-1,
	/*3370*/ -0x1.cb24fep-1,
	/*3371*/ -0x1.cacbdep-1,
	/*3372*/ -0x1.ca7274p-1,
	/*3373*/ -0x1.ca18c6p-1,
	/*3374*/ -0x1.c9bedp-1,
	/*3375*/ -0x1.c96494p-1,
	/*3376*/ -0x1.c90a12p-1,
	/*3377*/ -0x1.c8af48p-1,
	/*3378*/ -0x1.c85438p-1,
	/*3379*/ -0x1.c7f8e2p-1,
	/*3380*/ -0x1.c79d46p-1,
	/*3381*/ -0x1.c74162p-1,
	/*3382*/ -0x1.c6e53ap-1,
	/*3383*/ -0x1.c688cap-1,
	/*3384*/ -0x1.c62c14p-1,
	/*3385*/ -0x1.c5cf18p-1,
	/*3386*/ -0x1.c571d8p-1,
	/*3387*/ -0x1.c5145p-1,
	/*3388*/ -0x1.c4b682p-1,
	/*3389*/ -0x1.c4587p-1,
	/*3390*/ -0x1.c3fa16p-1,
	/*3391*/ -0x1.c39b78p-1,
	/*3392*/ -0x1.c33c92p-1,
	/*3393*/ -0x1.c2dd68p-1,
	/*3394*/ -0x1.c27dfap-1,
	/*3395*/ -0x1.c21e44p-1,
	/*3396*/ -0x1.c1be4ap-1,
	/*3397*/ -0x1.c15e0ap-1,
	/*3398*/ -0x1.c0fd84p-1,
	/*3399*/ -0x1.c09cbap-1,
	/*3400*/ -0x1.c03baap-1,
	/*3401*/ -0x1.bfda54p-1,
	/*3402*/ -0x1.bf78bap-1,
	/*3403*/ -0x1.bf16dcp-1,
	/*3404*/ -0x1.beb4b8p-1,
	/*3405*/ -0x1.be524ep-1,
	/*3406*/ -0x1.bdefap-1,
	/*3407*/ -0x1.bd8caep-1,
	/*3408*/ -0x1.bd2976p-1,
	/*3409*/ -0x1.bcc5fap-1,
	/*3410*/ -0x1.bc623ap-1,
	/*3411*/ -0x1.bbfe34p-1,
	/*3412*/ -0x1.bb99eap-1,
	/*3413*/ -0x1.bb355cp-1,
	/*3414*/ -0x1.bad08ap-1,
	/*3415*/ -0x1.ba6b74p-1,
	/*3416*/ -0x1.ba0618p-1,
	/*3417*/ -0x1.b9a078p-1,
	/*3418*/ -0x1.b93a96p-1,
	/*3419*/ -0x1.b8d46ep-1,
	/*3420*/ -0x1.b86e02p-1,
	/*3421*/ -0x1.b80752p-1,
	/*3422*/ -0x1.b7a05ep-1,
	/*3423*/ -0x1.b73928p-1,
	/*3424*/ -0x1.b6d1acp-1,
	/*3425*/ -0x1.b669eep-1,
	/*3426*/ -0x1.b601ecp-1,
	/*3427*/ -0x1.b599a6p-1,
	/*3428*/ -0x1.b5311cp-1,
	/*3429*/ -0x1.b4c84ep-1,
	/*3430*/ -0x1.b45f3ep-1,
	/*3431*/ -0x1.b3f5ecp-1,
	/*3432*/ -0x1.b38c54p-1,
	/*3433*/ -0x1.b3227ap-1,
	/*3434*/ -0x1.b2b85cp-1,
	/*3435*/ -0x1.b24dfcp-1,
	/*3436*/ -0x1.b1e35ap-1,
	/*3437*/ -0x1.b17872p-1,
	/*3438*/ -0x1.b10d4ap-1,
	/*3439*/ -0x1.b0a1dep-1,
	/*3440*/ -0x1.b0362ep-1,
	/*3441*/ -0x1.afca3ep-1,
	/*3442*/ -0x1.af5e0ap-1,
	/*3443*/ -0x1.aef192p-1,
	/*3444*/ -0x1.ae84dap-1,
	/*3445*/ -0x1.ae17dep-1,
	/*3446*/ -0x1.adaaap-1,
	/*3447*/ -0x1.ad3d2p-1,
	/*3448*/ -0x1.accf5ep-1,
	/*3449*/ -0x1.ac615ap-1,
	/*3450*/ -0x1.abf312p-1,
	/*3451*/ -0x1.ab848ap-1,
	/*3452*/ -0x1.ab15cp-1,
	/*3453*/ -0x1.aaa6b2p-1,
	/*3454*/ -0x1.aa3764p-1,
	/*3455*/ -0x1.a9c7d4p-1,
	/*3456*/ -0x1.a95802p-1,
	/*3457*/ -0x1.a8e7fp-1,
	/*3458*/ -0x1.a8779ap-1,
	/*3459*/ -0x1.a80704p-1,
	/*3460*/ -0x1.a7962cp-1,
	/*3461*/ -0x1.a72512p-1,
	/*3462*/ -0x1.a6b3b8p-1,
	/*3463*/ -0x1.a6421cp-1,
	/*3464*/ -0x1.a5d04p-1,
	/*3465*/ -0x1.a55e22p-1,
	/*3466*/ -0x1.a4ebc2p-1,
	/*3467*/ -0x1.a47922p-1,
	/*3468*/ -0x1.a40642p-1,
	/*3469*/ -0x1.a3932p-1,
	/*3470*/ -0x1.a31fbep-1,
	/*3471*/ -0x1.a2ac1ap-1,
	/*3472*/ -0x1.a23838p-1,
	/*3473*/ -0x1.a1c414p-1,
	/*3474*/ -0x1.a14faep-1,
	/*3475*/ -0x1.a0db0ap-1,
	/*3476*/ -0x1.a06624p-1,
	/*3477*/ -0x1.9ff0fep-1,
	/*3478*/ -0x1.9f7b9ap-1,
	/*3479*/ -0x1.9f05f4p-1,
	/*3480*/ -0x1.9e900ep-1,
	/*3481*/ -0x1.9e19e8p-1,
	/*3482*/ -0x1.9da382p-1,
	/*3483*/ -0x1.9d2cdcp-1,
	/*3484*/ -0x1.9cb5f8p-1,
	/*3485*/ -0x1.9c3ed2p-1,
	/*3486*/ -0x1.9bc76ep-1,
	/*3487*/ -0x1.9b4fcap-1,
	/*3488*/ -0x1.9ad7e6p-1,
	/*3489*/ -0x1.9a5fc4p-1,
	/*3490*/ -0x1.99e76p-1,
	/*3491*/ -0x1.996ecp-1,
	/*3492*/ -0x1.98f5dep-1,
	/*3493*/ -0x1.987cbep-1,
	/*3494*/ -0x1.98036p-1,
	/*3495*/ -0x1.9789c2p-1,
	/*3496*/ -0x1.970fe6p-1,
	/*3497*/ -0x1.9695cap-1,
	/*3498*/ -0x1.961b7p-1,
	/*3499*/ -0x1.95a0d8p-1,
	/*3500*/ -0x1.9526p-1,
	/*3501*/ -0x1.94aaeap-1,
	/*3502*/ -0x1.942f96p-1,
	/*3503*/ -0x1.93b404p-1,
	/*3504*/ -0x1.933832p-1,
	/*3505*/ -0x1.92bc22p-1,
	/*3506*/ -0x1.923fd6p-1,
	/*3507*/ -0x1.91c34ap-1,
	/*3508*/ -0x1.91468p-1,
	/*3509*/ -0x1.90c97ap-1,
	/*3510*/ -0x1.904c34p-1,
	/*3511*/ -0x1.8fceb2p-1,
	/*3512*/ -0x1.8f50f2p-1,
	/*3513*/ -0x1.8ed2f2p-1,
	/*3514*/ -0x1.8e54b8p-1,
	/*3515*/ -0x1.8dd63ep-1,
	/*3516*/ -0x1.8d5788p-1,
	/*3517*/ -0x1.8cd894p-1,
	/*3518*/ -0x1.8c5962p-1,
	/*3519*/ -0x1.8bd9f4p-1,
	/*3520*/ -0x1.8b5a48p-1,
	/*3521*/ -0x1.8ada6p-1,
	/*3522*/ -0x1.8a5a3cp-1,
	/*3523*/ -0x1.89d9dap-1,
	/*3524*/ -0x1.89593ap-1,
	/*3525*/ -0x1.88d85ep-1,
	/*3526*/ -0x1.885746p-1,
	/*3527*/ -0x1.87d5f2p-1,
	/*3528*/ -0x1.87546p-1,
	/*3529*/ -0x1.86d294p-1,
	/*3530*/ -0x1.86508ap-1,
	/*3531*/ -0x1.85ce44p-1,
	/*3532*/ -0x1.854bc2p-1,
	/*3533*/ -0x1.84c904p-1,
	/*3534*/ -0x1.844608p-1,
	/*3535*/ -0x1.83c2d2p-1,
	/*3536*/ -0x1.833f6p-1,
	/*3537*/ -0x1.82bbb4p-1,
	/*3538*/ -0x1.8237cap-1,
	/*3539*/ -0x1.81b3a4p-1,
	/*3540*/ -0x1.812f44p-1,
	/*3541*/ -0x1.80aaa8p-1,
	/*3542*/ -0x1.8025d2p-1,
	/*3543*/ -0x1.7fa0bep-1,
	/*3544*/ -0x1.7f1b7p-1,
	/*3545*/ -0x1.7e95e8p-1,
	/*3546*/ -0x1.7e1024p-1,
	/*3547*/ -0x1.7d8a26p-1,
	/*3548*/ -0x1.7d03ecp-1,
	/*3549*/ -0x1.7c7d78p-1,
	/*3550*/ -0x1.7bf6c8p-1,
	/*3551*/ -0x1.7b6fdep-1,
	/*3552*/ -0x1.7ae8bap-1,
	/*3553*/ -0x1.7a615cp-1,
	/*3554*/ -0x1.79d9c2p-1,
	/*3555*/ -0x1.7951eep-1,
	/*3556*/ -0x1.78c9e2p-1,
	/*3557*/ -0x1.78419ap-1,
	/*3558*/ -0x1.77b918p-1,
	/*3559*/ -0x1.77305cp-1,
	/*3560*/ -0x1.76a766p-1,
	/*3561*/ -0x1.761e36p-1,
	/*3562*/ -0x1.7594cep-1,
	/*3563*/ -0x1.750b2ap-1,
	/*3564*/ -0x1.74814ep-1,
	/*3565*/ -0x1.73f738p-1,
	/*3566*/ -0x1.736ce8p-1,
	/*3567*/ -0x1.72e26p-1,
	/*3568*/ -0x1.72579ep-1,
	/*3569*/ -0x1.71cca4p-1,
	/*3570*/ -0x1.71417p-1,
	/*3571*/ -0x1.70b602p-1,
	/*3572*/ -0x1.702a5cp-1,
	/*3573*/ -0x1.6f9e7ep-1,
	/*3574*/ -0x1.6f1266p-1,
	/*3575*/ -0x1.6e8616p-1,
	/*3576*/ -0x1.6df98ep-1,
	/*3577*/ -0x1.6d6cccp-1,
	/*3578*/ -0x1.6cdfd4p-1,
	/*3579*/ -0x1.6c52a2p-1,
	/*3580*/ -0x1.6bc538p-1,
	/*3581*/ -0x1.6b3796p-1,
	/*3582*/ -0x1.6aa9bcp-1,
	/*3583*/ -0x1.6a1baap-1,
	/*3584*/ -0x1.698d6p-1,
	/*3585*/ -0x1.68fedep-1,
	/*3586*/ -0x1.687024p-1,
	/*3587*/ -0x1.67e134p-1,
	/*3588*/ -0x1.67520ap-1,
	/*3589*/ -0x1.66c2aap-1,
	/*3590*/ -0x1.663314p-1,
	/*3591*/ -0x1.65a344p-1,
	/*3592*/ -0x1.65133ep-1,
	/*3593*/ -0x1.648302p-1,
	/*3594*/ -0x1.63f28ep-1,
	/*3595*/ -0x1.6361e4p-1,
	/*3596*/ -0x1.62d102p-1,
	/*3597*/ -0x1.623feap-1,
	/*3598*/ -0x1.61ae9ap-1,
	/*3599*/ -0x1.611d14p-1,
	/*3600*/ -0x1.608b58p-1,
	/*3601*/ -0x1.5ff966p-1,
	/*3602*/ -0x1.5f673ep-1,
	/*3603*/ -0x1.5ed4dep-1,
	/*3604*/ -0x1.5e424ap-1,
	/*3605*/ -0x1.5daf7ep-1,
	/*3606*/ -0x1.5d1c7ep-1,
	/*3607*/ -0x1.5c8946p-1,
	/*3608*/ -0x1.5bf5dap-1,
	/*3609*/ -0x1.5b6236p-1,
	/*3610*/ -0x1.5ace5ep-1,
	/*3611*/ -0x1.5a3a52p-1,
	/*3612*/ -0x1.59a60ep-1,
	/*3613*/ -0x1.591196p-1,
	/*3614*/ -0x1.587ce8p-1,
	/*3615*/ -0x1.57e806p-1,
	/*3616*/ -0x1.5752eep-1,
	/*3617*/ -0x1.56bda2p-1,
	/*3618*/ -0x1.56282p-1,
	/*3619*/ -0x1.55926ap-1,
	/*3620*/ -0x1.54fc7ep-1,
	/*3621*/ -0x1.54665ep-1,
	/*3622*/ -0x1.53d00ap-1,
	/*3623*/ -0x1.533982p-1,
	/*3624*/ -0x1.52a2c4p-1,
	/*3625*/ -0x1.520bd4p-1,
	/*3626*/ -0x1.5174aep-1,
	/*3627*/ -0x1.50dd54p-1,
	/*3628*/ -0x1.5045c8p-1,
	/*3629*/ -0x1.4fae06p-1,
	/*3630*/ -0x1.4f161p-1,
	/*3631*/ -0x1.4e7de8p-1,
	/*3632*/ -0x1.4de58cp-1,
	/*3633*/ -0x1.4d4cfcp-1,
	/*3634*/ -0x1.4cb438p-1,
	/*3635*/ -0x1.4c1b42p-1,
	/*3636*/ -0x1.4b8218p-1,
	/*3637*/ -0x1.4ae8bap-1,
	/*3638*/ -0x1.4a4f2ap-1,
	/*3639*/ -0x1.49b568p-1,
	/*3640*/ -0x1.491b72p-1,
	/*3641*/ -0x1.488148p-1,
	/*3642*/ -0x1.47e6eep-1,
	/*3643*/ -0x1.474c6p-1,
	/*3644*/ -0x1.46b19ep-1,
	/*3645*/ -0x1.4616acp-1,
	/*3646*/ -0x1.457b86p-1,
	/*3647*/ -0x1.44e03p-1,
	/*3648*/ -0x1.4444a6p-1,
	/*3649*/ -0x1.43a8eap-1,
	/*3650*/ -0x1.430cfcp-1,
	/*3651*/ -0x1.4270dep-1,
	/*3652*/ -0x1.41d48cp-1,
	/*3653*/ -0x1.41380ap-1,
	/*3654*/ -0x1.409b54p-1,
	/*3655*/ -0x1.3ffe7p-1,
	/*3656*/ -0x1.3f6158p-1,
	/*3657*/ -0x1.3ec41p-1,
	/*3658*/ -0x1.3e2696p-1,
	/*3659*/ -0x1.3d88ecp-1,
	/*3660*/ -0x1.3ceb1p-1,
	/*3661*/ -0x1.3c4d02p-1,
	/*3662*/ -0x1.3baec6p-1,
	/*3663*/ -0x1.3b1058p-1,
	/*3664*/ -0x1.3a71b8p-1,
	/*3665*/ -0x1.39d2eap-1,
	/*3666*/ -0x1.3933eap-1,
	/*3667*/ -0x1.3894bap-1,
	/*3668*/ -0x1.37f55ap-1,
	/*3669*/ -0x1.3755cap-1,
	/*3670*/ -0x1.36b608p-1,
	/*3671*/ -0x1.361618p-1,
	/*3672*/ -0x1.3575f8p-1,
	/*3673*/ -0x1.34d5a8p-1,
	/*3674*/ -0x1.343528p-1,
	/*3675*/ -0x1.33947ap-1,
	/*3676*/ -0x1.32f39cp-1,
	/*3677*/ -0x1.32528ep-1,
	/*3678*/ -0x1.31b15p-1,
	/*3679*/ -0x1.310fe4p-1,
	/*3680*/ -0x1.306e48p-1,
	/*3681*/ -0x1.2fcc7ep-1,
	/*3682*/ -0x1.2f2a84p-1,
	/*3683*/ -0x1.2e885cp-1,
	/*3684*/ -0x1.2de606p-1,
	/*3685*/ -0x1.2d438p-1,
	/*3686*/ -0x1.2ca0ccp-1,
	/*3687*/ -0x1.2bfdeap-1,
	/*3688*/ -0x1.2b5adap-1,
	/*3689*/ -0x1.2ab79cp-1,
	/*3690*/ -0x1.2a142ep-1,
	/*3691*/ -0x1.297094p-1,
	/*3692*/ -0x1.28ccccp-1,
	/*3693*/ -0x1.2828d6p-1,
	/*3694*/ -0x1.2784bp-1,
	/*3695*/ -0x1.26e06p-1,
	/*3696*/ -0x1.263bep-1,
	/*3697*/ -0x1.259734p-1,
	/*3698*/ -0x1.24f25ap-1,
	/*3699*/ -0x1.244d52p-1,
	/*3700*/ -0x1.23a81ep-1,
	/*3701*/ -0x1.2302bep-1,
	/*3702*/ -0x1.225d3p-1,
	/*3703*/ -0x1.21b774p-1,
	/*3704*/ -0x1.21118cp-1,
	/*3705*/ -0x1.206b78p-1,
	/*3706*/ -0x1.1fc538p-1,
	/*3707*/ -0x1.1f1ecap-1,
	/*3708*/ -0x1.1e7832p-1,
	/*3709*/ -0x1.1dd16cp-1,
	/*3710*/ -0x1.1d2a7ap-1,
	/*3711*/ -0x1.1c835cp-1,
	/*3712*/ -0x1.1bdc14p-1,
	/*3713*/ -0x1.1b349ep-1,
	/*3714*/ -0x1.1a8cfcp-1,
	/*3715*/ -0x1.19e53p-1,
	/*3716*/ -0x1.193d38p-1,
	/*3717*/ -0x1.189514p-1,
	/*3718*/ -0x1.17ecc6p-1,
	/*3719*/ -0x1.17444cp-1,
	/*3720*/ -0x1.169ba6p-1,
	/*3721*/ -0x1.15f2d6p-1,
	/*3722*/ -0x1.1549dcp-1,
	/*3723*/ -0x1.14a0b6p-1,
	/*3724*/ -0x1.13f766p-1,
	/*3725*/ -0x1.134deap-1,
	/*3726*/ -0x1.12a444p-1,
	/*3727*/ -0x1.11fa74p-1,
	/*3728*/ -0x1.11507ap-1,
	/*3729*/ -0x1.10a656p-1,
	/*3730*/ -0x1.0ffc08p-1,
	/*3731*/ -0x1.0f519p-1,
	/*3732*/ -0x1.0ea6eep-1,
	/*3733*/ -0x1.0dfc22p-1,
	/*3734*/ -0x1.0d512cp-1,
	/*3735*/ -0x1.0ca60cp-1,
	/*3736*/ -0x1.0bfac4p-1,
	/*3737*/ -0x1.0b4f52p-1,
	/*3738*/ -0x1.0aa3b8p-1,
	/*3739*/ -0x1.09f7f2p-1,
	/*3740*/ -0x1.094c06p-1,
	/*3741*/ -0x1.089ffp-1,
	/*3742*/ -0x1.07f3bp-1,
	/*3743*/ -0x1.074748p-1,
	/*3744*/ -0x1.069ab8p-1,
	/*3745*/ -0x1.05edfep-1,
	/*3746*/ -0x1.05411ep-1,
	/*3747*/ -0x1.049414p-1,
	/*3748*/ -0x1.03e6e2p-1,
	/*3749*/ -0x1.033988p-1,
	/*3750*/ -0x1.028c06p-1,
	/*3751*/ -0x1.01de5cp-1,
	/*3752*/ -0x1.01308ap-1,
	/*3753*/ -0x1.00829p-1,
	/*3754*/ -0x1.ffa8ep-2,
	/*3755*/ -0x1.fe4c4ep-2,
	/*3756*/ -0x1.fcef7p-2,
	/*3757*/ -0x1.fb9242p-2,
	/*3758*/ -0x1.fa34c4p-2,
	/*3759*/ -0x1.f8d6fap-2,
	/*3760*/ -0x1.f778e2p-2,
	/*3761*/ -0x1.f61a7cp-2,
	/*3762*/ -0x1.f4bbc8p-2,
	/*3763*/ -0x1.f35cc8p-2,
	/*3764*/ -0x1.f1fd7ap-2,
	/*3765*/ -0x1.f09dep-2,
	/*3766*/ -0x1.ef3df8p-2,
	/*3767*/ -0x1.edddc4p-2,
	/*3768*/ -0x1.ec7d44p-2,
	/*3769*/ -0x1.eb1c78p-2,
	/*3770*/ -0x1.e9bb6p-2,
	/*3771*/ -0x1.e859fep-2,
	/*3772*/ -0x1.e6f84ep-2,
	/*3773*/ -0x1.e59656p-2,
	/*3774*/ -0x1.e4341p-2,
	/*3775*/ -0x1.e2d182p-2,
	/*3776*/ -0x1.e16ea8p-2,
	/*3777*/ -0x1.e00b84p-2,
	/*3778*/ -0x1.dea816p-2,
	/*3779*/ -0x1.dd445ep-2,
	/*3780*/ -0x1.dbe05cp-2,
	/*3781*/ -0x1.da7c1p-2,
	/*3782*/ -0x1.d9177cp-2,
	/*3783*/ -0x1.d7b29ep-2,
	/*3784*/ -0x1.d64d78p-2,
	/*3785*/ -0x1.d4e80ap-2,
	/*3786*/ -0x1.d38254p-2,
	/*3787*/ -0x1.d21c54p-2,
	/*3788*/ -0x1.d0b60ep-2,
	/*3789*/ -0x1.cf4f7ep-2,
	/*3790*/ -0x1.cde8a8p-2,
	/*3791*/ -0x1.cc818ap-2,
	/*3792*/ -0x1.cb1a26p-2,
	/*3793*/ -0x1.c9b27ap-2,
	/*3794*/ -0x1.c84a8ap-2,
	/*3795*/ -0x1.c6e25p-2,
	/*3796*/ -0x1.c579d2p-2,
	/*3797*/ -0x1.c4110ep-2,
	/*3798*/ -0x1.c2a804p-2,
	/*3799*/ -0x1.c13eb4p-2,
	/*3800*/ -0x1.bfd51ep-2,
	/*3801*/ -0x1.be6b44p-2,
	/*3802*/ -0x1.bd0126p-2,
	/*3803*/ -0x1.bb96c2p-2,
	/*3804*/ -0x1.ba2c1ap-2,
	/*3805*/ -0x1.b8c12cp-2,
	/*3806*/ -0x1.b755fcp-2,
	/*3807*/ -0x1.b5ea88p-2,
	/*3808*/ -0x1.b47edp-2,
	/*3809*/ -0x1.b312d6p-2,
	/*3810*/ -0x1.b1a698p-2,
	/*3811*/ -0x1.b03a16p-2,
	/*3812*/ -0x1.aecd52p-2,
	/*3813*/ -0x1.ad604cp-2,
	/*3814*/ -0x1.abf304p-2,
	/*3815*/ -0x1.aa857ap-2,
	/*3816*/ -0x1.a917acp-2,
	/*3817*/ -0x1.a7a99ep-2,
	/*3818*/ -0x1.a63b5p-2,
	/*3819*/ -0x1.a4cccp-2,
	/*3820*/ -0x1.a35deep-2,
	/*3821*/ -0x1.a1eedcp-2,
	/*3822*/ -0x1.a07f8ap-2,
	/*3823*/ -0x1.9f0ff6p-2,
	/*3824*/ -0x1.9da024p-2,
	/*3825*/ -0x1.9c301p-2,
	/*3826*/ -0x1.9abfbep-2,
	/*3827*/ -0x1.994f2cp-2,
	/*3828*/ -0x1.97de5cp-2,
	/*3829*/ -0x1.966d4cp-2,
	/*3830*/ -0x1.94fbfep-2,
	/*3831*/ -0x1.938a7p-2,
	/*3832*/ -0x1.9218a6p-2,
	/*3833*/ -0x1.90a69cp-2,
	/*3834*/ -0x1.8f3456p-2,
	/*3835*/ -0x1.8dc1dp-2,
	/*3836*/ -0x1.8c4f0ep-2,
	/*3837*/ -0x1.8adc1p-2,
	/*3838*/ -0x1.8968d4p-2,
	/*3839*/ -0x1.87f55ap-2,
	/*3840*/ -0x1.8681a6p-2,
	/*3841*/ -0x1.850db4p-2,
	/*3842*/ -0x1.839986p-2,
	/*3843*/ -0x1.82251ep-2,
	/*3844*/ -0x1.80b078p-2,
	/*3845*/ -0x1.7f3b98p-2,
	/*3846*/ -0x1.7dc67cp-2,
	/*3847*/ -0x1.7c5126p-2,
	/*3848*/ -0x1.7adb96p-2,
	/*3849*/ -0x1.7965cap-2,
	/*3850*/ -0x1.77efc4p-2,
	/*3851*/ -0x1.767984p-2,
	/*3852*/ -0x1.75030cp-2,
	/*3853*/ -0x1.738c58p-2,
	/*3854*/ -0x1.72156cp-2,
	/*3855*/ -0x1.709e46p-2,
	/*3856*/ -0x1.6f26e8p-2,
	/*3857*/ -0x1.6daf52p-2,
	/*3858*/ -0x1.6c3782p-2,
	/*3859*/ -0x1.6abf7ap-2,
	/*3860*/ -0x1.69473cp-2,
	/*3861*/ -0x1.67cec4p-2,
	/*3862*/ -0x1.665616p-2,
	/*3863*/ -0x1.64dd3p-2,
	/*3864*/ -0x1.636412p-2,
	/*3865*/ -0x1.61eabep-2,
	/*3866*/ -0x1.607134p-2,
	/*3867*/ -0x1.5ef772p-2,
	/*3868*/ -0x1.5d7d7cp-2,
	/*3869*/ -0x1.5c034ep-2,
	/*3870*/ -0x1.5a88ecp-2,
	/*3871*/ -0x1.590e54p-2,
	/*3872*/ -0x1.579386p-2,
	/*3873*/ -0x1.561884p-2,
	/*3874*/ -0x1.549d4cp-2,
	/*3875*/ -0x1.5321e2p-2,
	/*3876*/ -0x1.51a642p-2,
	/*3877*/ -0x1.502a6cp-2,
	/*3878*/ -0x1.4eae64p-2,
	/*3879*/ -0x1.4d322ap-2,
	/*3880*/ -0x1.4bb5bap-2,
	/*3881*/ -0x1.4a3918p-2,
	/*3882*/ -0x1.48bc42p-2,
	/*3883*/ -0x1.473f3ap-2,
	/*3884*/ -0x1.45c2p-2,
	/*3885*/ -0x1.444494p-2,
	/*3886*/ -0x1.42c6f6p-2,
	/*3887*/ -0x1.414924p-2,
	/*3888*/ -0x1.3fcb22p-2,
	/*3889*/ -0x1.3e4cfp-2,
	/*3890*/ -0x1.3cce8ap-2,
	/*3891*/ -0x1.3b4ff6p-2,
	/*3892*/ -0x1.39d13p-2,
	/*3893*/ -0x1.385238p-2,
	/*3894*/ -0x1.36d312p-2,
	/*3895*/ -0x1.3553bcp-2,
	/*3896*/ -0x1.33d436p-2,
	/*3897*/ -0x1.32548p-2,
	/*3898*/ -0x1.30d49ap-2,
	/*3899*/ -0x1.2f5486p-2,
	/*3900*/ -0x1.2dd444p-2,
	/*3901*/ -0x1.2c53d2p-2,
	/*3902*/ -0x1.2ad332p-2,
	/*3903*/ -0x1.295264p-2,
	/*3904*/ -0x1.27d168p-2,
	/*3905*/ -0x1.26503ep-2,
	/*3906*/ -0x1.24cee8p-2,
	/*3907*/ -0x1.234d64p-2,
	/*3908*/ -0x1.21cbb2p-2,
	/*3909*/ -0x1.2049d6p-2,
	/*3910*/ -0x1.1ec7ccp-2,
	/*3911*/ -0x1.1d4594p-2,
	/*3912*/ -0x1.1bc332p-2,
	/*3913*/ -0x1.1a40a4p-2,
	/*3914*/ -0x1.18bdeap-2,
	/*3915*/ -0x1.173b06p-2,
	/*3916*/ -0x1.15b7f6p-2,
	/*3917*/ -0x1.1434bap-2,
	/*3918*/ -0x1.12b154p-2,
	/*3919*/ -0x1.112dc4p-2,
	/*3920*/ -0x1.0faa0ap-2,
	/*3921*/ -0x1.0e2626p-2,
	/*3922*/ -0x1.0ca218p-2,
	/*3923*/ -0x1.0b1de2p-2,
	/*3924*/ -0x1.099982p-2,
	/*3925*/ -0x1.0814f8p-2,
	/*3926*/ -0x1.069046p-2,
	/*3927*/ -0x1.050b6ap-2,
	/*3928*/ -0x1.038668p-2,
	/*3929*/ -0x1.02013ep-2,
	/*3930*/ -0x1.007beap-2,
	/*3931*/ -0x1.fdecep-3,
	/*3932*/ -0x1.fae19cp-3,
	/*3933*/ -0x1.f7d60cp-3,
	/*3934*/ -0x1.f4ca2cp-3,
	/*3935*/ -0x1.f1bep-3,
	/*3936*/ -0x1.eeb186p-3,
	/*3937*/ -0x1.eba4cp-3,
	/*3938*/ -0x1.e897aep-3,
	/*3939*/ -0x1.e58a52p-3,
	/*3940*/ -0x1.e27caap-3,
	/*3941*/ -0x1.df6eb8p-3,
	/*3942*/ -0x1.dc607cp-3,
	/*3943*/ -0x1.d951f6p-3,
	/*3944*/ -0x1.d64328p-3,
	/*3945*/ -0x1.d3341p-3,
	/*3946*/ -0x1.d024bp-3,
	/*3947*/ -0x1.cd150ap-3,
	/*3948*/ -0x1.ca051cp-3,
	/*3949*/ -0x1.c6f4e6p-3,
	/*3950*/ -0x1.c3e46cp-3,
	/*3951*/ -0x1.c0d3aap-3,
	/*3952*/ -0x1.bdc2a4p-3,
	/*3953*/ -0x1.bab15ap-3,
	/*3954*/ -0x1.b79fcap-3,
	/*3955*/ -0x1.b48df8p-3,
	/*3956*/ -0x1.b17be2p-3,
	/*3957*/ -0x1.ae6988p-3,
	/*3958*/ -0x1.ab56eep-3,
	/*3959*/ -0x1.a8441p-3,
	/*3960*/ -0x1.a530fp-3,
	/*3961*/ -0x1.a21d9p-3,
	/*3962*/ -0x1.9f09fp-3,
	/*3963*/ -0x1.9bf61p-3,
	/*3964*/ -0x1.98e1fp-3,
	/*3965*/ -0x1.95cd92p-3,
	/*3966*/ -0x1.92b8f4p-3,
	/*3967*/ -0x1.8fa418p-3,
	/*3968*/ -0x1.8c8efep-3,
	/*3969*/ -0x1.8979a8p-3,
	/*3970*/ -0x1.866414p-3,
	/*3971*/ -0x1.834e44p-3,
	/*3972*/ -0x1.803838p-3,
	/*3973*/ -0x1.7d21f2p-3,
	/*3974*/ -0x1.7a0b7p-3,
	/*3975*/ -0x1.76f4b6p-3,
	/*3976*/ -0x1.73ddcp-3,
	/*3977*/ -0x1.70c69p-3,
	/*3978*/ -0x1.6daf28p-3,
	/*3979*/ -0x1.6a9788p-3,
	/*3980*/ -0x1.677fbp-3,
	/*3981*/ -0x1.6467ap-3,
	/*3982*/ -0x1.614f5ap-3,
	/*3983*/ -0x1.5e36dcp-3,
	/*3984*/ -0x1.5b1e28p-3,
	/*3985*/ -0x1.58054p-3,
	/*3986*/ -0x1.54ec22p-3,
	/*3987*/ -0x1.51d2dp-3,
	/*3988*/ -0x1.4eb948p-3,
	/*3989*/ -0x1.4b9f8ep-3,
	/*3990*/ -0x1.4885a2p-3,
	/*3991*/ -0x1.456b82p-3,
	/*3992*/ -0x1.42512ep-3,
	/*3993*/ -0x1.3f36aap-3,
	/*3994*/ -0x1.3c1bf6p-3,
	/*3995*/ -0x1.39011p-3,
	/*3996*/ -0x1.35e5f8p-3,
	/*3997*/ -0x1.32cab2p-3,
	/*3998*/ -0x1.2faf3ep-3,
	/*3999*/ -0x1.2c9398p-3,
	/*4000*/ -0x1.2977c6p-3,
	/*4001*/ -0x1.265bc6p-3,
	/*4002*/ -0x1.233f98p-3,
	/*4003*/ -0x1.20233cp-3,
	/*4004*/ -0x1.1d06b4p-3,
	/*4005*/ -0x1.19ea02p-3,
	/*4006*/ -0x1.16cd22p-3,
	/*4007*/ -0x1.13b018p-3,
	/*4008*/ -0x1.1092e4p-3,
	/*4009*/ -0x1.0d7586p-3,
	/*4010*/ -0x1.0a57fep-3,
	/*4011*/ -0x1.073a4cp-3,
	/*4012*/ -0x1.041c72p-3,
	/*4013*/ -0x1.00fe7p-3,
	/*4014*/ -0x1.fbc08ep-4,
	/*4015*/ -0x1.f583ecp-4,
	/*4016*/ -0x1.ef46fep-4,
	/*4017*/ -0x1.e909c2p-4,
	/*4018*/ -0x1.e2cc3cp-4,
	/*4019*/ -0x1.dc8e6ap-4,
	/*4020*/ -0x1.d6504ep-4,
	/*4021*/ -0x1.d011ecp-4,
	/*4022*/ -0x1.c9d34p-4,
	/*4023*/ -0x1.c3944ep-4,
	/*4024*/ -0x1.bd5518p-4,
	/*4025*/ -0x1.b7159cp-4,
	/*4026*/ -0x1.b0d5dcp-4,
	/*4027*/ -0x1.aa95dap-4,
	/*4028*/ -0x1.a45596p-4,
	/*4029*/ -0x1.9e151p-4,
	/*4030*/ -0x1.97d44ap-4,
	/*4031*/ -0x1.919346p-4,
	/*4032*/ -0x1.8b5204p-4,
	/*4033*/ -0x1.851086p-4,
	/*4034*/ -0x1.7ececap-4,
	/*4035*/ -0x1.788cd4p-4,
	/*4036*/ -0x1.724aa4p-4,
	/*4037*/ -0x1.6c083cp-4,
	/*4038*/ -0x1.65c59ap-4,
	/*4039*/ -0x1.5f82c2p-4,
	/*4040*/ -0x1.593fb2p-4,
	/*4041*/ -0x1.52fc6ep-4,
	/*4042*/ -0x1.4cb8f6p-4,
	/*4043*/ -0x1.46754ap-4,
	/*4044*/ -0x1.40316cp-4,
	/*4045*/ -0x1.39ed5cp-4,
	/*4046*/ -0x1.33a91cp-4,
	/*4047*/ -0x1.2d64acp-4,
	/*4048*/ -0x1.27201p-4,
	/*4049*/ -0x1.20db44p-4,
	/*4050*/ -0x1.1a964cp-4,
	/*4051*/ -0x1.145128p-4,
	/*4052*/ -0x1.0e0bdap-4,
	/*4053*/ -0x1.07c662p-4,
	/*4054*/ -0x1.0180cp-4,
	/*4055*/ -0x1.f675f2p-5,
	/*4056*/ -0x1.e9ea12p-5,
	/*4057*/ -0x1.dd5de8p-5,
	/*4058*/ -0x1.d0d176p-5,
	/*4059*/ -0x1.c444bap-5,
	/*4060*/ -0x1.b7b7bap-5,
	/*4061*/ -0x1.ab2a74p-5,
	/*4062*/ -0x1.9e9ceep-5,
	/*4063*/ -0x1.920f26p-5,
	/*4064*/ -0x1.858122p-5,
	/*4065*/ -0x1.78f2e2p-5,
	/*4066*/ -0x1.6c6466p-5,
	/*4067*/ -0x1.5fd5b2p-5,
	/*4068*/ -0x1.5346cap-5,
	/*4069*/ -0x1.46b7acp-5,
	/*4070*/ -0x1.3a285cp-5,
	/*4071*/ -0x1.2d98dap-5,
	/*4072*/ -0x1.21092cp-5,
	/*4073*/ -0x1.14795p-5,
	/*4074*/ -0x1.07e948p-5,
	/*4075*/ -0x1.f6b234p-6,
	/*4076*/ -0x1.dd9186p-6,
	/*4077*/ -0x1.c47092p-6,
	/*4078*/ -0x1.ab4f56p-6,
	/*4079*/ -0x1.922dd8p-6,
	/*4080*/ -0x1.790c1cp-6,
	/*4081*/ -0x1.5fea26p-6,
	/*4082*/ -0x1.46c7fap-6,
	/*4083*/ -0x1.2da59cp-6,
	/*4084*/ -0x1.14831p-6,
	/*4085*/ -0x1.f6c0bp-7,
	/*4086*/ -0x1.c47af2p-7,
	/*4087*/ -0x1.9234fp-7,
	/*4088*/ -0x1.5feebp-7,
	/*4089*/ -0x1.2da838p-7,
	/*4090*/ -0x1.f6c326p-8,
	/*4091*/ -0x1.92358ep-8,
	/*4092*/ -0x1.2da7b6p-8,
	/*4093*/ -0x1.923362p-9,
	/*4094*/ -0x1.922e34p-10,
	/*4095*/ 0x1.534acp-23,
#endif
};

#endif
