/// autogenerated analytical inverse kinematics code from ikfast program part of OpenRAVE
/// \author Rosen Diankov
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///     http://www.apache.org/licenses/LICENSE-2.0
/// 
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// ikfast version 0x1000004a generated on 2017-12-12 14:08:54.348797
/// Generated using solver transform6d
/// To compile with gcc:
///     gcc -lstdc++ ik.cpp
/// To compile without any main function as a shared object (might need -llapack):
///     gcc -fPIC -lstdc++ -DIKFAST_NO_MAIN -DIKFAST_CLIBRARY -shared -Wl,-soname,libik.so -o libik.so ik.cpp
#define IKFAST_HAS_LIBRARY
#include "ikfast.h" // found inside share/openrave-X.Y/python/ikfast.h
using namespace ikfast;

// check if the included ikfast version matches what this file was compiled with
#define IKFAST_COMPILE_ASSERT(x) extern int __dummy[(int)x]
IKFAST_COMPILE_ASSERT(IKFAST_VERSION==0x1000004a);

#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include <complex>

#ifndef IKFAST_ASSERT
#include <stdexcept>
#include <sstream>
#include <iostream>

#ifdef _MSC_VER
#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __FUNCDNAME__
#endif
#endif

#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __func__
#endif

#define IKFAST_ASSERT(b) { if( !(b) ) { std::stringstream ss; ss << "ikfast exception: " << __FILE__ << ":" << __LINE__ << ": " <<__PRETTY_FUNCTION__ << ": Assertion '" << #b << "' failed"; throw std::runtime_error(ss.str()); } }

#endif

#if defined(_MSC_VER)
#define IKFAST_ALIGNED16(x) __declspec(align(16)) x
#else
#define IKFAST_ALIGNED16(x) x __attribute((aligned(16)))
#endif

#define IK2PI  ((IkReal)6.28318530717959)
#define IKPI  ((IkReal)3.14159265358979)
#define IKPI_2  ((IkReal)1.57079632679490)

#ifdef _MSC_VER
#ifndef isnan
#define isnan _isnan
#endif
#ifndef isinf
#define isinf _isinf
#endif
//#ifndef isfinite
//#define isfinite _isfinite
//#endif
#endif // _MSC_VER

// lapack routines
extern "C" {
  void dgetrf_ (const int* m, const int* n, double* a, const int* lda, int* ipiv, int* info);
  void zgetrf_ (const int* m, const int* n, std::complex<double>* a, const int* lda, int* ipiv, int* info);
  void dgetri_(const int* n, const double* a, const int* lda, int* ipiv, double* work, const int* lwork, int* info);
  void dgesv_ (const int* n, const int* nrhs, double* a, const int* lda, int* ipiv, double* b, const int* ldb, int* info);
  void dgetrs_(const char *trans, const int *n, const int *nrhs, double *a, const int *lda, int *ipiv, double *b, const int *ldb, int *info);
  void dgeev_(const char *jobvl, const char *jobvr, const int *n, double *a, const int *lda, double *wr, double *wi,double *vl, const int *ldvl, double *vr, const int *ldvr, double *work, const int *lwork, int *info);
}

using namespace std; // necessary to get std math routines

#ifdef IKFAST_NAMESPACE
namespace IKFAST_NAMESPACE {
#endif

inline float IKabs(float f) { return fabsf(f); }
inline double IKabs(double f) { return fabs(f); }

inline float IKsqr(float f) { return f*f; }
inline double IKsqr(double f) { return f*f; }

inline float IKlog(float f) { return logf(f); }
inline double IKlog(double f) { return log(f); }

// allows asin and acos to exceed 1. has to be smaller than thresholds used for branch conds and evaluation
#ifndef IKFAST_SINCOS_THRESH
#define IKFAST_SINCOS_THRESH ((IkReal)1e-7)
#endif

// used to check input to atan2 for degenerate cases. has to be smaller than thresholds used for branch conds and evaluation
#ifndef IKFAST_ATAN2_MAGTHRESH
#define IKFAST_ATAN2_MAGTHRESH ((IkReal)1e-7)
#endif

// minimum distance of separate solutions
#ifndef IKFAST_SOLUTION_THRESH
#define IKFAST_SOLUTION_THRESH ((IkReal)1e-6)
#endif

// there are checkpoints in ikfast that are evaluated to make sure they are 0. This threshold speicfies by how much they can deviate
#ifndef IKFAST_EVALCOND_THRESH
#define IKFAST_EVALCOND_THRESH ((IkReal)0.00001)
#endif


inline float IKasin(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(-IKPI_2);
else if( f >= 1 ) return float(IKPI_2);
return asinf(f);
}
inline double IKasin(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return -IKPI_2;
else if( f >= 1 ) return IKPI_2;
return asin(f);
}

// return positive value in [0,y)
inline float IKfmod(float x, float y)
{
    while(x < 0) {
        x += y;
    }
    return fmodf(x,y);
}

// return positive value in [0,y)
inline double IKfmod(double x, double y)
{
    while(x < 0) {
        x += y;
    }
    return fmod(x,y);
}

inline float IKacos(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(IKPI);
else if( f >= 1 ) return float(0);
return acosf(f);
}
inline double IKacos(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return IKPI;
else if( f >= 1 ) return 0;
return acos(f);
}
inline float IKsin(float f) { return sinf(f); }
inline double IKsin(double f) { return sin(f); }
inline float IKcos(float f) { return cosf(f); }
inline double IKcos(double f) { return cos(f); }
inline float IKtan(float f) { return tanf(f); }
inline double IKtan(double f) { return tan(f); }
inline float IKsqrt(float f) { if( f <= 0.0f ) return 0.0f; return sqrtf(f); }
inline double IKsqrt(double f) { if( f <= 0.0 ) return 0.0; return sqrt(f); }
inline float IKatan2Simple(float fy, float fx) {
    return atan2f(fy,fx);
}
inline float IKatan2(float fy, float fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return float(IKPI_2);
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2f(fy,fx);
}
inline double IKatan2Simple(double fy, double fx) {
    return atan2(fy,fx);
}
inline double IKatan2(double fy, double fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return IKPI_2;
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2(fy,fx);
}

template <typename T>
struct CheckValue
{
    T value;
    bool valid;
};

template <typename T>
inline CheckValue<T> IKatan2WithCheck(T fy, T fx, T epsilon)
{
    CheckValue<T> ret;
    ret.valid = false;
    ret.value = 0;
    if( !isnan(fy) && !isnan(fx) ) {
        if( IKabs(fy) >= IKFAST_ATAN2_MAGTHRESH || IKabs(fx) > IKFAST_ATAN2_MAGTHRESH ) {
            ret.value = IKatan2Simple(fy,fx);
            ret.valid = true;
        }
    }
    return ret;
}

inline float IKsign(float f) {
    if( f > 0 ) {
        return float(1);
    }
    else if( f < 0 ) {
        return float(-1);
    }
    return 0;
}

inline double IKsign(double f) {
    if( f > 0 ) {
        return 1.0;
    }
    else if( f < 0 ) {
        return -1.0;
    }
    return 0;
}

template <typename T>
inline CheckValue<T> IKPowWithIntegerCheck(T f, int n)
{
    CheckValue<T> ret;
    ret.valid = true;
    if( n == 0 ) {
        ret.value = 1.0;
        return ret;
    }
    else if( n == 1 )
    {
        ret.value = f;
        return ret;
    }
    else if( n < 0 )
    {
        if( f == 0 )
        {
            ret.valid = false;
            ret.value = (T)1.0e30;
            return ret;
        }
        if( n == -1 ) {
            ret.value = T(1.0)/f;
            return ret;
        }
    }

    int num = n > 0 ? n : -n;
    if( num == 2 ) {
        ret.value = f*f;
    }
    else if( num == 3 ) {
        ret.value = f*f*f;
    }
    else {
        ret.value = 1.0;
        while(num>0) {
            if( num & 1 ) {
                ret.value *= f;
            }
            num >>= 1;
            f *= f;
        }
    }
    
    if( n < 0 ) {
        ret.value = T(1.0)/ret.value;
    }
    return ret;
}

/// solves the forward kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API void ComputeFk(const IkReal* j, IkReal* eetrans, IkReal* eerot) {
IkReal x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,x21,x22,x23,x24,x25,x26,x27,x28,x29,x30,x31,x32,x33,x34,x35,x36,x37,x38,x39,x40,x41,x42,x43,x44,x45,x46,x47,x48,x49,x50,x51,x52,x53,x54,x55,x56,x57,x58,x59,x60,x61,x62,x63,x64;
x0=IKcos(j[0]);
x1=IKcos(j[3]);
x2=IKsin(j[0]);
x3=IKsin(j[3]);
x4=IKsin(j[4]);
x5=IKsin(j[1]);
x6=IKsin(j[2]);
x7=IKcos(j[1]);
x8=IKcos(j[2]);
x9=IKcos(j[4]);
x10=IKsin(j[5]);
x11=IKcos(j[5]);
x12=((0.134999999784)*x4);
x13=((5.39999999136e-6)*x4);
x14=((0.9999999992)*x4);
x15=((1.271)*x0);
x16=((1.271)*x2);
x17=((5.39999999136e-6)*x0);
x18=((0.175)*x0);
x19=((3.9999999968e-5)*x4);
x20=((5.39999999136e-6)*x9);
x21=((0.175)*x2);
x22=((0.134999999784)*x9);
x23=((3.9999999968e-5)*x9);
x24=((0.9999999992)*x9);
x25=((1.0)*x2);
x26=((5.39999999136e-6)*x1);
x27=((1.095)*x5);
x28=((2.159999996544e-10)*x0);
x29=((1.0)*x0);
x30=((2.159999996544e-10)*x2);
x31=((2.159999996544e-10)*x1);
x32=((5.39999999136e-6)*x2);
x33=(x5*x6);
x34=(x7*x8);
x35=(x1*x9);
x36=(x2*x3);
x37=(x6*x7);
x38=(x5*x8);
x39=((1.0)*x34);
x40=(x29*x33);
x41=(x25*x33);
x42=((((-1.0)*x39))+x33);
x43=((((-1.0)*x33))+x39);
x44=((((1.0)*x38))+(((1.0)*x37)));
x45=((-1.0)*x44);
x46=(x1*x42);
x47=(x3*x43);
x48=((((-1.0)*x40))+((x0*x34)));
x49=((((-1.0)*x41))+((x2*x34)));
x50=((((-1.0)*x29*x34))+x40);
x51=((((-1.0)*x25*x34))+x41);
x52=(x29*((x38+x37)));
x53=((-1.0)*x52);
x54=(x25*((x38+x37)));
x55=((-1.0)*x54);
x56=(x1*x55);
x57=((((-1.0)*x25*x3))+((x1*x53)));
x58=(((x3*x52))+(((-1.0)*x1*x25)));
x59=(((x0*x3))+x56);
x60=(((x0*x1))+((x3*x54)));
x61=(x4*x57);
x62=(((x19*x46))+((x23*x45))+((x14*x44))+((x24*x46)));
x63=(((x14*x50))+((x23*x48))+((x19*x57))+((x24*x57)));
x64=(((x14*x51))+((x23*x49))+((x19*x59))+((x24*x59)));
eerot[0]=(((x11*x63))+((x10*x58)));
eerot[1]=((((-1.0)*x10*x63))+((x11*x58)));
eerot[2]=(((x14*x57))+(((-1.0)*x23*x57))+(((-1.0)*x19*x50))+((x24*x48)));
IkReal x65=((1.0)*x33);
eetrans[0]=(((x12*x57))+((x0*x27))+(((-1.0)*x15*x65))+((x18*x37))+((x18*x38))+(((-1.0)*x20*x57))+((x22*x48))+((x4*(((((-2.159999996544e-10)*x36))+((x31*x53))))))+((x15*x34))+((x9*((((x28*x34))+(((-1.0)*x28*x65))))))+x18+((x9*((((x26*x53))+(((-5.39999999136e-6)*x36))))))+(((-1.0)*x13*x50))+((x4*((((x17*x33))+(((-1.0)*x17*x34)))))));
eerot[3]=(((x11*x64))+((x10*x60)));
eerot[4]=((((-1.0)*x10*x64))+((x11*x60)));
eerot[5]=(((x14*x59))+(((-1.0)*x23*x59))+(((-1.0)*x19*x51))+((x24*x49)));
IkReal x66=((1.0)*x33);
eetrans[1]=((((-1.0)*x16*x66))+((x12*x59))+((x4*((((x31*x55))+((x28*x3))))))+((x16*x34))+(((-1.0)*x20*x59))+((x4*((((x32*x33))+(((-1.0)*x32*x34))))))+((x22*x49))+((x21*x38))+((x21*x37))+((x9*(((((-1.0)*x30*x66))+((x30*x34))))))+((x2*x27))+x21+(((-1.0)*x13*x51))+((x9*((((x26*x55))+((x17*x3)))))));
eerot[6]=(((x10*x47))+((x11*x62)));
eerot[7]=((((-1.0)*x10*x62))+((x11*x47)));
eerot[8]=(((x14*x46))+(((-1.0)*x19*x44))+((x24*x45))+(((-1.0)*x23*x46)));
eetrans[2]=((0.495)+(((-0.175)*x33))+(((-1.0)*x20*x46))+(((0.175)*x34))+((x22*x45))+(((-1.271)*x38))+(((-1.271)*x37))+((x4*(((((5.39999999136e-6)*x38))+(((5.39999999136e-6)*x37))))))+((x1*x4*(((((-2.159999996544e-10)*x34))+(((2.159999996544e-10)*x33))))))+((x35*(((((5.39999999136e-6)*x33))+(((-5.39999999136e-6)*x34))))))+(((1.095)*x7))+((x12*x46))+((x9*(((((-2.159999996544e-10)*x37))+(((-2.159999996544e-10)*x38))))))+(((-1.0)*x13*x44)));
}

IKFAST_API int GetNumFreeParameters() { return 0; }
IKFAST_API int* GetFreeParameters() { return NULL; }
IKFAST_API int GetNumJoints() { return 6; }

IKFAST_API int GetIkRealSize() { return sizeof(IkReal); }

IKFAST_API int GetIkType() { return 0x67000001; }

class IKSolver {
public:
IkReal j0,cj0,sj0,htj0,j0mul,j1,cj1,sj1,htj1,j1mul,j2,cj2,sj2,htj2,j2mul,j3,cj3,sj3,htj3,j3mul,j4,cj4,sj4,htj4,j4mul,j5,cj5,sj5,htj5,j5mul,new_r00,r00,rxp0_0,new_r01,r01,rxp0_1,new_r02,r02,rxp0_2,new_r10,r10,rxp1_0,new_r11,r11,rxp1_1,new_r12,r12,rxp1_2,new_r20,r20,rxp2_0,new_r21,r21,rxp2_1,new_r22,r22,rxp2_2,new_px,px,npx,new_py,py,npy,new_pz,pz,npz,pp;
unsigned char _ij0[2], _nj0,_ij1[2], _nj1,_ij2[2], _nj2,_ij3[2], _nj3,_ij4[2], _nj4,_ij5[2], _nj5;

IkReal j100, cj100, sj100;
unsigned char _ij100[2], _nj100;
bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
j0=numeric_limits<IkReal>::quiet_NaN(); _ij0[0] = -1; _ij0[1] = -1; _nj0 = -1; j1=numeric_limits<IkReal>::quiet_NaN(); _ij1[0] = -1; _ij1[1] = -1; _nj1 = -1; j2=numeric_limits<IkReal>::quiet_NaN(); _ij2[0] = -1; _ij2[1] = -1; _nj2 = -1; j3=numeric_limits<IkReal>::quiet_NaN(); _ij3[0] = -1; _ij3[1] = -1; _nj3 = -1; j4=numeric_limits<IkReal>::quiet_NaN(); _ij4[0] = -1; _ij4[1] = -1; _nj4 = -1; j5=numeric_limits<IkReal>::quiet_NaN(); _ij5[0] = -1; _ij5[1] = -1; _nj5 = -1; 
for(int dummyiter = 0; dummyiter < 1; ++dummyiter) {
    solutions.Clear();
r00 = eerot[0*3+0];
r01 = eerot[0*3+1];
r02 = eerot[0*3+2];
r10 = eerot[1*3+0];
r11 = eerot[1*3+1];
r12 = eerot[1*3+2];
r20 = eerot[2*3+0];
r21 = eerot[2*3+1];
r22 = eerot[2*3+2];
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];

new_r00=r00;
new_r01=r01;
new_r02=r02;
new_px=((((-0.134999999892)*r02))+px);
new_r10=r10;
new_r11=r11;
new_r12=r12;
new_py=((((-0.134999999892)*r12))+py);
new_r20=r20;
new_r21=r21;
new_r22=r22;
new_pz=((-0.495)+pz+(((-0.134999999892)*r22)));
r00 = new_r00; r01 = new_r01; r02 = new_r02; r10 = new_r10; r11 = new_r11; r12 = new_r12; r20 = new_r20; r21 = new_r21; r22 = new_r22; px = new_px; py = new_py; pz = new_pz;
IkReal x67=((1.0)*px);
IkReal x68=((1.0)*pz);
IkReal x69=((1.0)*py);
pp=((px*px)+(py*py)+(pz*pz));
npx=(((px*r00))+((py*r10))+((pz*r20)));
npy=(((px*r01))+((py*r11))+((pz*r21)));
npz=(((px*r02))+((py*r12))+((pz*r22)));
rxp0_0=((((-1.0)*r20*x69))+((pz*r10)));
rxp0_1=(((px*r20))+(((-1.0)*r00*x68)));
rxp0_2=((((-1.0)*r10*x67))+((py*r00)));
rxp1_0=((((-1.0)*r21*x69))+((pz*r11)));
rxp1_1=(((px*r21))+(((-1.0)*r01*x68)));
rxp1_2=((((-1.0)*r11*x67))+((py*r01)));
rxp2_0=(((pz*r12))+(((-1.0)*r22*x69)));
rxp2_1=(((px*r22))+(((-1.0)*r02*x68)));
rxp2_2=((((-1.0)*r12*x67))+((py*r02)));
{
IkReal j0eval[1];
j0eval[0]=((IKabs(px))+(IKabs(py)));
if( IKabs(j0eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j0, j1, j2]

} else
{
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
CheckValue<IkReal> x71 = IKatan2WithCheck(IkReal(py),IkReal(((-1.0)*px)),IKFAST_ATAN2_MAGTHRESH);
if(!x71.valid){
continue;
}
IkReal x70=x71.value;
j0array[0]=((-1.0)*x70);
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((3.14159265358979)+(((-1.0)*x70)));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];

{
IkReal j2array[2], cj2array[2], sj2array[2];
bool j2valid[2]={false};
_nj2 = 2;
IkReal x72=px*px;
IkReal x73=r10*r10;
IkReal x74=r01*r01;
IkReal x75=py*py;
IkReal x76=r11*r11;
IkReal x77=r00*r00;
IkReal x78=r20*r20;
IkReal x79=r21*r21;
IkReal x80=pz*pz;
IkReal x81=r12*r12;
IkReal x82=r22*r22;
IkReal x83=r02*r02;
IkReal x84=((0.355903503251059)*x80);
IkReal x85=((0.124566226137871)*cj0*px);
IkReal x86=((0.355903503251059)*x72);
IkReal x87=((0.355903503251059)*x75);
IkReal x88=((0.124566226137871)*py*sj0);
IkReal x89=(x74*x76);
IkReal x90=(x77*x78);
IkReal x91=(x76*x79);
IkReal x92=(x81*x83);
IkReal x93=(x82*x83);
IkReal x94=(x81*x82);
IkReal x95=(x74*x79);
IkReal x96=(x73*x87);
if( (((-1.00167830918099)+(((-1.0)*x81*x88))+((x77*x86))+((x87*x91))+((x79*x84))+(((-1.0)*x73*x88))+(((-1.0)*x83*x85))+((x78*x84))+((x82*x84))+((x81*x87))+((x78*x96))+((x86*x90))+((x86*x95))+(((-1.0)*x77*x85))+((x86*x89))+((x74*x86))+(((-0.711807006502117)*x78*x79*x80))+(((-1.0)*x87*x92))+(((-1.0)*x87*x94))+(((-1.0)*x86*x93))+(((-1.0)*x86*x92))+((x76*x87))+((x73*x77*x86))+x96+(((-1.0)*x74*x85))+(((-0.711807006502117)*x73*x75*x76))+(((-1.0)*x76*x88))+(((-1.0)*x84*x94))+(((-1.0)*x84*x93))+((x83*x86))+(((-0.711807006502117)*x72*x74*x77))+((x73*x78*x84))+((x84*x91))+((x84*x90))+((x84*x95))+((x77*x96))+((x87*x89)))) < -1-IKFAST_SINCOS_THRESH || (((-1.00167830918099)+(((-1.0)*x81*x88))+((x77*x86))+((x87*x91))+((x79*x84))+(((-1.0)*x73*x88))+(((-1.0)*x83*x85))+((x78*x84))+((x82*x84))+((x81*x87))+((x78*x96))+((x86*x90))+((x86*x95))+(((-1.0)*x77*x85))+((x86*x89))+((x74*x86))+(((-0.711807006502117)*x78*x79*x80))+(((-1.0)*x87*x92))+(((-1.0)*x87*x94))+(((-1.0)*x86*x93))+(((-1.0)*x86*x92))+((x76*x87))+((x73*x77*x86))+x96+(((-1.0)*x74*x85))+(((-0.711807006502117)*x73*x75*x76))+(((-1.0)*x76*x88))+(((-1.0)*x84*x94))+(((-1.0)*x84*x93))+((x83*x86))+(((-0.711807006502117)*x72*x74*x77))+((x73*x78*x84))+((x84*x91))+((x84*x90))+((x84*x95))+((x77*x96))+((x87*x89)))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x97=IKasin(((-1.00167830918099)+(((-1.0)*x81*x88))+((x77*x86))+((x87*x91))+((x79*x84))+(((-1.0)*x73*x88))+(((-1.0)*x83*x85))+((x78*x84))+((x82*x84))+((x81*x87))+((x78*x96))+((x86*x90))+((x86*x95))+(((-1.0)*x77*x85))+((x86*x89))+((x74*x86))+(((-0.711807006502117)*x78*x79*x80))+(((-1.0)*x87*x92))+(((-1.0)*x87*x94))+(((-1.0)*x86*x93))+(((-1.0)*x86*x92))+((x76*x87))+((x73*x77*x86))+x96+(((-1.0)*x74*x85))+(((-0.711807006502117)*x73*x75*x76))+(((-1.0)*x76*x88))+(((-1.0)*x84*x94))+(((-1.0)*x84*x93))+((x83*x86))+(((-0.711807006502117)*x72*x74*x77))+((x73*x78*x84))+((x84*x91))+((x84*x90))+((x84*x95))+((x77*x96))+((x87*x89))));
j2array[0]=((0.136826551321617)+(((-1.0)*x97)));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
j2array[1]=((3.27841920491141)+x97);
sj2array[1]=IKsin(j2array[1]);
cj2array[1]=IKcos(j2array[1]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
if( j2array[1] > IKPI )
{
    j2array[1]-=IK2PI;
}
else if( j2array[1] < -IKPI )
{    j2array[1]+=IK2PI;
}
j2valid[1] = true;
for(int ij2 = 0; ij2 < 2; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 2; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];

{
IkReal j1eval[2];
IkReal x98=(py*sj0);
IkReal x99=((41.5020408163265)*cj2);
IkReal x100=(pz*sj2);
IkReal x101=((5.71428571428571)*sj2);
IkReal x102=(cj2*pz);
IkReal x103=(cj0*px);
IkReal x104=((1.271)*cj2);
IkReal x105=((0.175)*sj2);
j1eval[0]=((((-35.7551020408163)*pz))+(((-1.0)*sj2))+(((41.5020408163265)*x100))+((x103*x99))+((x101*x98))+(((-5.71428571428571)*x102))+((x98*x99))+((x101*x103))+(((-7.26285714285714)*cj2)));
j1eval[1]=IKsign(((((-1.095)*pz))+(((-0.175)*x102))+((x103*x105))+((x103*x104))+(((-0.030625)*sj2))+((x105*x98))+(((1.271)*x100))+((x104*x98))+(((-0.222425)*cj2))));
if( IKabs(j1eval[0]) < 0.0000010000000000  || IKabs(j1eval[1]) < 0.0000010000000000  )
{
{
IkReal j1eval[2];
j1eval[0]=((7.42359034572733)+(((-7.26285714285714)*sj2))+cj2);
j1eval[1]=IKsign(((2.845091)+(((0.38325)*cj2))+(((-2.78349)*sj2))));
if( IKabs(j1eval[0]) < 0.0000010000000000  || IKabs(j1eval[1]) < 0.0000010000000000  )
{
{
IkReal j1eval[2];
IkReal x106=(py*sj0);
IkReal x107=((0.175)*cj2);
IkReal x108=((5.71428571428571)*cj2);
IkReal x109=(cj0*px);
IkReal x110=((1.271)*sj2);
IkReal x111=(pz*sj2);
IkReal x112=(cj2*pz);
IkReal x113=((41.5020408163265)*sj2);
j1eval[0]=((6.25714285714286)+(((-7.26285714285714)*sj2))+(((-35.7551020408163)*x109))+(((-35.7551020408163)*x106))+cj2+((x106*x113))+(((-5.71428571428571)*x111))+(((-41.5020408163265)*x112))+((x109*x113))+(((-1.0)*x106*x108))+(((-1.0)*x108*x109)));
j1eval[1]=IKsign(((0.191625)+(((-0.175)*x111))+(((-1.271)*x112))+(((-1.095)*x106))+(((-1.095)*x109))+(((0.030625)*cj2))+((x106*x110))+(((-1.0)*x107*x109))+((x109*x110))+(((-1.0)*x106*x107))+(((-0.222425)*sj2))));
if( IKabs(j1eval[0]) < 0.0000010000000000  || IKabs(j1eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j1]

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x114=cj2*cj2;
IkReal x115=(cj2*sj2);
IkReal x116=(py*sj0);
IkReal x117=((1.271)*sj2);
IkReal x118=((0.175)*cj2);
IkReal x119=(cj0*px);
IkReal x120=((0.175)*pz);
IkReal x121=((1.0)*pz);
CheckValue<IkReal> x122=IKPowWithIntegerCheck(IKsign(((0.191625)+(((-1.095)*x116))+(((-1.095)*x119))+(((-1.0)*x118*x119))+(((-1.0)*sj2*x120))+(((-1.271)*cj2*pz))+(((0.030625)*cj2))+(((-1.0)*x116*x118))+(((-0.222425)*sj2))+((x116*x117))+((x117*x119)))),-1);
if(!x122.valid){
continue;
}
CheckValue<IkReal> x123 = IKatan2WithCheck(IkReal(((-2.814466)+(((0.44485)*x115))+(((2.78349)*sj2))+(((-0.38325)*cj2))+(pz*pz)+(((1.584816)*x114)))),IkReal(((0.222425)+(((-0.191625)*sj2))+(((-1.0)*x119*x121))+(((-1.0)*x116*x121))+(((-1.391745)*cj2))+x120+(((1.584816)*x115))+(((-0.44485)*x114)))),IKFAST_ATAN2_MAGTHRESH);
if(!x123.valid){
continue;
}
j1array[0]=((-1.5707963267949)+(((1.5707963267949)*(x122.value)))+(x123.value));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[5];
IkReal x124=IKcos(j1);
IkReal x125=IKsin(j1);
IkReal x126=py*py;
IkReal x127=r11*r11;
IkReal x128=r21*r21;
IkReal x129=r01*r01;
IkReal x130=px*px;
IkReal x131=pz*pz;
IkReal x132=r10*r10;
IkReal x133=r00*r00;
IkReal x134=r20*r20;
IkReal x135=r02*r02;
IkReal x136=r22*r22;
IkReal x137=r12*r12;
IkReal x138=((1.271)*cj2);
IkReal x139=(cj0*px);
IkReal x140=((0.175)*cj2);
IkReal x141=(py*sj0);
IkReal x142=(sj2*x124);
IkReal x143=((1.0)*x125);
IkReal x144=((1.0)*x136);
IkReal x145=(sj2*x125);
IkReal x146=(x130*x133);
IkReal x147=(x130*x135);
IkReal x148=(x128*x131);
IkReal x149=(x126*x137);
IkReal x150=(x131*x134);
IkReal x151=(x126*x132);
IkReal x152=(x126*x127);
IkReal x153=(x129*x130);
evalcond[0]=(((x124*x141))+(((-1.0)*pz*x143))+(((-0.175)*sj2))+(((-1.0)*x138))+((x124*x139))+(((-0.175)*x124)));
evalcond[1]=((((1.271)*x142))+(((-1.0)*x124*x140))+(((0.175)*x145))+((x125*x138))+pz+(((-1.095)*x124)));
evalcond[2]=((1.095)+(((-1.0)*x139*x143))+x140+(((-1.0)*pz*x124))+(((-1.0)*x141*x143))+(((0.175)*x125))+(((-1.271)*sj2)));
evalcond[3]=((-0.175)+(((1.271)*x145))+(((-1.0)*x125*x140))+(((-0.175)*x142))+(((-1.0)*x124*x138))+x141+x139+(((-1.095)*x125)));
evalcond[4]=((-2.875716)+(((-2.0)*x129*x146))+(((-0.38325)*x125))+(((-0.44485)*cj2*x124))+(((-1.0)*x131*x137*x144))+((x128*x153))+((x128*x152))+(((2.78349)*sj2))+(((-0.38325)*cj2))+(((-1.0)*x144*x147))+(((-1.0)*x144*x149))+(((-2.0)*x134*x148))+(((-1.0)*x137*x147))+x153+x152+x151+x150+x146+x147+x148+x149+(((-0.06125)*x142))+((x129*x148))+((x127*x148))+((x131*x136))+((x129*x152))+(((-2.0)*x127*x151))+((x127*x153))+(((-1.0)*x131*x135*x144))+((x134*x146))+(((-0.06125)*cj2*x125))+((x134*x151))+((x132*x146))+((x133*x150))+((x133*x151))+((x132*x150))+(((-1.0)*x135*x149))+(((0.44485)*x145)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x2707=((0.175)*cj2);
IkReal x2708=(cj0*px);
IkReal x2709=(py*sj0);
IkReal x2710=((1.271)*pz);
IkReal x2711=((0.175)*sj2);
IkReal x2712=((1.271)*x2709);
CheckValue<IkReal> x2713 = IKatan2WithCheck(IkReal(((-0.191625)+(((-0.030625)*cj2))+(((-1.0)*cj2*x2710))+(((-1.271)*sj2*x2708))+((x2707*x2708))+((x2707*x2709))+(((-1.0)*sj2*x2712))+(((-1.0)*pz*x2711))+(((0.222425)*sj2))+(((1.095)*x2708))+(((1.095)*x2709)))),IkReal((((x2708*x2711))+((cj2*x2712))+(((1.095)*pz))+((x2709*x2711))+(((1.271)*cj2*x2708))+((pz*x2707))+(((-1.0)*sj2*x2710))+(((-0.030625)*sj2))+(((-0.222425)*cj2)))),IKFAST_ATAN2_MAGTHRESH);
if(!x2713.valid){
continue;
}
CheckValue<IkReal> x2714=IKPowWithIntegerCheck(IKsign(((2.845091)+(((0.38325)*cj2))+(((-2.78349)*sj2)))),-1);
if(!x2714.valid){
continue;
}
j1array[0]=((-1.5707963267949)+(x2713.value)+(((1.5707963267949)*(x2714.value))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[5];
IkReal x2715=IKcos(j1);
IkReal x2716=IKsin(j1);
IkReal x2717=py*py;
IkReal x2718=r11*r11;
IkReal x2719=r21*r21;
IkReal x2720=r01*r01;
IkReal x2721=px*px;
IkReal x2722=pz*pz;
IkReal x2723=r10*r10;
IkReal x2724=r00*r00;
IkReal x2725=r20*r20;
IkReal x2726=r02*r02;
IkReal x2727=r22*r22;
IkReal x2728=r12*r12;
IkReal x2729=((1.271)*cj2);
IkReal x2730=(cj0*px);
IkReal x2731=((0.175)*cj2);
IkReal x2732=(py*sj0);
IkReal x2733=(sj2*x2715);
IkReal x2734=((1.0)*x2716);
IkReal x2735=((1.0)*x2727);
IkReal x2736=(sj2*x2716);
IkReal x2737=(x2721*x2724);
IkReal x2738=(x2721*x2726);
IkReal x2739=(x2719*x2722);
IkReal x2740=(x2717*x2728);
IkReal x2741=(x2722*x2725);
IkReal x2742=(x2717*x2723);
IkReal x2743=(x2717*x2718);
IkReal x2744=(x2720*x2721);
evalcond[0]=((((-1.0)*pz*x2734))+((x2715*x2732))+((x2715*x2730))+(((-0.175)*sj2))+(((-1.0)*x2729))+(((-0.175)*x2715)));
evalcond[1]=((((-1.095)*x2715))+(((-1.0)*x2715*x2731))+(((0.175)*x2736))+(((1.271)*x2733))+pz+((x2716*x2729)));
evalcond[2]=((1.095)+x2731+(((-1.0)*x2730*x2734))+(((0.175)*x2716))+(((-1.0)*pz*x2715))+(((-1.271)*sj2))+(((-1.0)*x2732*x2734)));
evalcond[3]=((-0.175)+x2730+x2732+(((-1.095)*x2716))+(((1.271)*x2736))+(((-1.0)*x2715*x2729))+(((-0.175)*x2733))+(((-1.0)*x2716*x2731)));
evalcond[4]=((-2.875716)+(((-2.0)*x2725*x2739))+x2741+x2740+x2743+x2742+x2744+x2737+x2738+x2739+(((-2.0)*x2720*x2737))+(((-1.0)*x2726*x2740))+(((2.78349)*sj2))+(((-0.44485)*cj2*x2715))+(((-0.38325)*cj2))+(((-1.0)*x2722*x2726*x2735))+((x2725*x2737))+((x2723*x2741))+((x2720*x2739))+(((-0.06125)*cj2*x2716))+(((-0.06125)*x2733))+(((-1.0)*x2735*x2738))+(((-1.0)*x2735*x2740))+((x2718*x2739))+((x2723*x2737))+((x2724*x2741))+((x2724*x2742))+((x2720*x2743))+(((-1.0)*x2728*x2738))+(((-0.38325)*x2716))+((x2722*x2727))+((x2725*x2742))+(((-2.0)*x2718*x2742))+((x2719*x2744))+((x2719*x2743))+(((-1.0)*x2722*x2728*x2735))+(((0.44485)*x2736))+((x2718*x2744)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x2745=cj2*cj2;
IkReal x2746=(cj2*sj2);
IkReal x2747=((0.175)*pz);
IkReal x2748=((1.271)*cj2);
IkReal x2749=(py*sj0);
IkReal x2750=(cj0*px);
IkReal x2751=((0.175)*sj2);
IkReal x2752=((1.0)*pz);
CheckValue<IkReal> x2753 = IKatan2WithCheck(IkReal(((-0.222425)+x2747+(((-1.584816)*x2746))+(((0.191625)*sj2))+(((-1.0)*x2750*x2752))+(((-1.0)*x2749*x2752))+(((1.391745)*cj2))+(((0.44485)*x2745)))),IkReal(((0.030625)+(((-1.0)*pz*x2752))+(((1.584816)*x2745))+(((0.44485)*x2746)))),IKFAST_ATAN2_MAGTHRESH);
if(!x2753.valid){
continue;
}
CheckValue<IkReal> x2754=IKPowWithIntegerCheck(IKsign((((x2749*x2751))+(((-1.095)*pz))+(((1.271)*pz*sj2))+((x2750*x2751))+(((-1.0)*cj2*x2747))+((x2748*x2749))+((x2748*x2750))+(((-0.030625)*sj2))+(((-0.222425)*cj2)))),-1);
if(!x2754.valid){
continue;
}
j1array[0]=((-1.5707963267949)+(x2753.value)+(((1.5707963267949)*(x2754.value))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[5];
IkReal x2755=IKcos(j1);
IkReal x2756=IKsin(j1);
IkReal x2757=py*py;
IkReal x2758=r11*r11;
IkReal x2759=r21*r21;
IkReal x2760=r01*r01;
IkReal x2761=px*px;
IkReal x2762=pz*pz;
IkReal x2763=r10*r10;
IkReal x2764=r00*r00;
IkReal x2765=r20*r20;
IkReal x2766=r02*r02;
IkReal x2767=r22*r22;
IkReal x2768=r12*r12;
IkReal x2769=((1.271)*cj2);
IkReal x2770=(cj0*px);
IkReal x2771=((0.175)*cj2);
IkReal x2772=(py*sj0);
IkReal x2773=(sj2*x2755);
IkReal x2774=((1.0)*x2756);
IkReal x2775=((1.0)*x2767);
IkReal x2776=(sj2*x2756);
IkReal x2777=(x2761*x2764);
IkReal x2778=(x2761*x2766);
IkReal x2779=(x2759*x2762);
IkReal x2780=(x2757*x2768);
IkReal x2781=(x2762*x2765);
IkReal x2782=(x2757*x2763);
IkReal x2783=(x2757*x2758);
IkReal x2784=(x2760*x2761);
evalcond[0]=((((-0.175)*x2755))+(((-0.175)*sj2))+(((-1.0)*pz*x2774))+((x2755*x2770))+((x2755*x2772))+(((-1.0)*x2769)));
evalcond[1]=(((x2756*x2769))+(((0.175)*x2776))+(((-1.095)*x2755))+pz+(((1.271)*x2773))+(((-1.0)*x2755*x2771)));
evalcond[2]=((1.095)+x2771+(((-1.0)*pz*x2755))+(((-1.0)*x2770*x2774))+(((-1.0)*x2772*x2774))+(((0.175)*x2756))+(((-1.271)*sj2)));
evalcond[3]=((-0.175)+x2770+x2772+(((-1.0)*x2755*x2769))+(((-1.0)*x2756*x2771))+(((-1.095)*x2756))+(((1.271)*x2776))+(((-0.175)*x2773)));
evalcond[4]=((-2.875716)+((x2758*x2779))+x2778+x2779+x2777+x2784+x2781+x2780+x2783+x2782+((x2763*x2777))+(((-1.0)*x2766*x2780))+(((-1.0)*x2762*x2768*x2775))+(((-0.06125)*cj2*x2756))+(((-1.0)*x2762*x2766*x2775))+((x2765*x2782))+(((-2.0)*x2760*x2777))+((x2764*x2782))+((x2764*x2781))+(((2.78349)*sj2))+(((-0.06125)*x2773))+((x2760*x2783))+(((-0.38325)*cj2))+(((-1.0)*x2768*x2778))+((x2762*x2767))+((x2759*x2783))+((x2759*x2784))+(((-0.38325)*x2756))+((x2763*x2781))+((x2758*x2784))+(((-2.0)*x2758*x2782))+(((-1.0)*x2775*x2778))+(((-0.44485)*cj2*x2755))+(((-2.0)*x2765*x2779))+(((0.44485)*x2776))+((x2765*x2777))+((x2760*x2779))+(((-1.0)*x2775*x2780)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}
}
}

}

}
}
return solutions.GetNumSolutions()>0;
}
inline void rotationfunction0(IkSolutionListBase<IkReal>& solutions) {
for(int rotationiter = 0; rotationiter < 1; ++rotationiter) {
IkReal x154=((1.0)*cj1);
IkReal x155=((1.0)*sj1);
IkReal x156=((1.0)*sj0);
IkReal x157=((1.0)*sj2);
IkReal x158=(((r10*sj0))+((cj0*r00)));
IkReal x159=(((r11*sj0))+((cj0*r01)));
IkReal x160=(((r12*sj0))+((cj0*r02)));
IkReal x161=((((-1.0)*r20*x155))+((cj1*x158)));
IkReal x162=(((cj1*x159))+(((-1.0)*r21*x155)));
IkReal x163=(((cj1*x160))+(((-1.0)*r22*x155)));
IkReal x164=((((-1.0)*x155*x158))+(((-1.0)*r20*x154)));
IkReal x165=((((-1.0)*x155*x159))+(((-1.0)*r21*x154)));
IkReal x166=((((-1.0)*x155*x160))+(((-1.0)*r22*x154)));
new_r00=((((-1.0)*x157*x161))+((cj2*x164)));
new_r01=((((-1.0)*r00*x156))+((cj0*r10)));
new_r02=(((cj2*x161))+((sj2*x164)));
new_r10=((((-1.0)*x157*x162))+((cj2*x165)));
new_r11=((((-1.0)*r01*x156))+((cj0*r11)));
new_r12=(((cj2*x162))+((sj2*x165)));
new_r20=((((-1.0)*x157*x163))+((cj2*x166)));
new_r21=((((-1.0)*r02*x156))+((cj0*r12)));
new_r22=(((cj2*x163))+((sj2*x166)));
{
IkReal j4array[2], cj4array[2], sj4array[2];
bool j4valid[2]={false};
_nj4 = 2;
if( (new_r22) < -1-IKFAST_SINCOS_THRESH || (new_r22) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x167=IKasin(new_r22);
j4array[0]=((1.57083632679488)+(((-1.0)*x167)));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
j4array[1]=((4.71242898038467)+x167);
sj4array[1]=IKsin(j4array[1]);
cj4array[1]=IKcos(j4array[1]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
if( j4array[1] > IKPI )
{
    j4array[1]-=IK2PI;
}
else if( j4array[1] < -IKPI )
{    j4array[1]+=IK2PI;
}
j4valid[1] = true;
for(int ij4 = 0; ij4 < 2; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 2; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];

{
IkReal j5eval[3];
j5eval[0]=((((25000.0)*sj4))+(((-1.0)*cj4)));
j5eval[1]=((IKabs(new_r12))+(IKabs(new_r02)));
j5eval[2]=IKsign(((((-3.9999999968e-5)*cj4))+(((0.9999999992)*sj4))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j3eval[3];
j3eval[0]=((((-25000.0)*sj4))+cj4);
j3eval[1]=IKsign(((((-0.9999999992)*sj4))+(((3.9999999968e-5)*cj4))));
j3eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  || IKabs(j3eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[3];
IkReal x168=((625000000.5)*sj4);
IkReal x169=((25000.00002)*cj4);
IkReal x170=((new_r12*new_r12)+(new_r02*new_r02));
j5eval[0]=x170;
j5eval[1]=((IKabs((((new_r12*x168))+(((-1.0)*new_r12*x169)))))+(IKabs(((((-1.0)*new_r02*x168))+((new_r02*x169))))));
j5eval[2]=IKsign(x170);
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((new_r12*new_r12)+(new_r02*new_r02));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
new_r12=0;
new_r02=0;
j5eval[0]=IKabs(((((-25000.0)*sj4))+cj4));
if( IKabs(j5eval[0]) < 0.0000000100000000  )
{
{
IkReal j5eval[1];
new_r12=0;
new_r02=0;
j5eval[0]=IKabs(((((-0.9999999992)*sj4))+(((3.9999999968e-5)*cj4))));
if( IKabs(j5eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j3, j5]

} else
{
IkReal op[2+1], zeror[2];
int numroots;
IkReal x171=((0.9999999992)*sj4);
IkReal x172=((3.9999999968e-5)*cj4);
op[0]=((((-1.0)*x171))+x172);
op[1]=0;
op[2]=((((-1.0)*x172))+x171);
polyroots2(op,zeror,numroots);
IkReal j5array[2], cj5array[2], sj5array[2], tempj5array[1];
int numsolutions = 0;
for(int ij5 = 0; ij5 < numroots; ++ij5)
{
IkReal htj5 = zeror[ij5];
tempj5array[0]=((2.0)*(atan(htj5)));
for(int kj5 = 0; kj5 < 1; ++kj5)
{
j5array[numsolutions] = tempj5array[kj5];
if( j5array[numsolutions] > IKPI )
{
    j5array[numsolutions]-=IK2PI;
}
else if( j5array[numsolutions] < -IKPI )
{
    j5array[numsolutions]+=IK2PI;
}
sj5array[numsolutions] = IKsin(j5array[numsolutions]);
cj5array[numsolutions] = IKcos(j5array[numsolutions]);
numsolutions++;
}
}
bool j5valid[2]={true,true};
_nj5 = 2;
for(int ij5 = 0; ij5 < numsolutions; ++ij5)
    {
if( !j5valid[ij5] )
{
    continue;
}
    j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
htj5 = IKtan(j5/2);

_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < numsolutions; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
if( IKabs(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj5*new_r11))+((new_r01*sj5)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))))+IKsqr((((cj5*new_r11))+((new_r01*sj5))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))), (((cj5*new_r11))+((new_r01*sj5))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[10];
IkReal x173=IKsin(j3);
IkReal x174=IKcos(j3);
IkReal x175=(cj5*new_r01);
IkReal x176=((25000.00002)*sj4);
IkReal x177=(cj5*new_r00);
IkReal x178=((1.0)*sj5);
IkReal x179=((1.0)*x174);
IkReal x180=(sj5*x173);
IkReal x181=(cj5*x174);
IkReal x182=(cj5*x173);
evalcond[0]=(((cj5*new_r10))+((new_r00*sj5))+x173);
evalcond[1]=((((-1.0)*x179))+((cj5*new_r11))+((new_r01*sj5)));
evalcond[2]=(x182+((sj5*x174*x176))+new_r10);
evalcond[3]=((((-1.0)*x174*x176))+(((-1.0)*new_r10*x178))+x177);
evalcond[4]=((((-1.0)*new_r11*x178))+x175+(((-1.0)*x173*x176)));
evalcond[5]=(x180+(((-1.0)*x176*x181))+new_r00);
evalcond[6]=((((-1.0)*cj5*x179))+((x176*x180))+new_r11);
evalcond[7]=((((-1.0)*x174*x178))+(((-1.0)*x176*x182))+new_r01);
evalcond[8]=(((x176*x177))+(((-1.0)*x179))+(((-1.0)*new_r10*sj5*x176)));
evalcond[9]=((((-1.0)*new_r11*sj5*x176))+(((-1.0)*x173))+((x175*x176)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
    }

}

}

} else
{
IkReal op[2+1], zeror[2];
int numroots;
IkReal x183=((25000.0)*sj4);
op[0]=(cj4+(((-1.0)*x183)));
op[1]=0;
op[2]=(x183+(((-1.0)*cj4)));
polyroots2(op,zeror,numroots);
IkReal j5array[2], cj5array[2], sj5array[2], tempj5array[1];
int numsolutions = 0;
for(int ij5 = 0; ij5 < numroots; ++ij5)
{
IkReal htj5 = zeror[ij5];
tempj5array[0]=((2.0)*(atan(htj5)));
for(int kj5 = 0; kj5 < 1; ++kj5)
{
j5array[numsolutions] = tempj5array[kj5];
if( j5array[numsolutions] > IKPI )
{
    j5array[numsolutions]-=IK2PI;
}
else if( j5array[numsolutions] < -IKPI )
{
    j5array[numsolutions]+=IK2PI;
}
sj5array[numsolutions] = IKsin(j5array[numsolutions]);
cj5array[numsolutions] = IKcos(j5array[numsolutions]);
numsolutions++;
}
}
bool j5valid[2]={true,true};
_nj5 = 2;
for(int ij5 = 0; ij5 < numsolutions; ++ij5)
    {
if( !j5valid[ij5] )
{
    continue;
}
    j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
htj5 = IKtan(j5/2);

_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < numsolutions; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
if( IKabs(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj5*new_r11))+((new_r01*sj5)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))))+IKsqr((((cj5*new_r11))+((new_r01*sj5))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))), (((cj5*new_r11))+((new_r01*sj5))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[10];
IkReal x184=IKsin(j3);
IkReal x185=IKcos(j3);
IkReal x186=(cj5*new_r01);
IkReal x187=((25000.00002)*sj4);
IkReal x188=(cj5*new_r00);
IkReal x189=((1.0)*sj5);
IkReal x190=((1.0)*x185);
IkReal x191=(sj5*x184);
IkReal x192=(cj5*x185);
IkReal x193=(cj5*x184);
evalcond[0]=(((cj5*new_r10))+((new_r00*sj5))+x184);
evalcond[1]=(((cj5*new_r11))+((new_r01*sj5))+(((-1.0)*x190)));
evalcond[2]=(x193+new_r10+((sj5*x185*x187)));
evalcond[3]=(x188+(((-1.0)*new_r10*x189))+(((-1.0)*x185*x187)));
evalcond[4]=(x186+(((-1.0)*new_r11*x189))+(((-1.0)*x184*x187)));
evalcond[5]=(x191+(((-1.0)*x187*x192))+new_r00);
evalcond[6]=(((x187*x191))+(((-1.0)*cj5*x190))+new_r11);
evalcond[7]=((((-1.0)*x187*x193))+(((-1.0)*x185*x189))+new_r01);
evalcond[8]=((((-1.0)*new_r10*sj5*x187))+((x187*x188))+(((-1.0)*x190)));
evalcond[9]=(((x186*x187))+(((-1.0)*x184))+(((-1.0)*new_r11*sj5*x187)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((3.14155265358981)+j4)))), 6.28318530717959)));
evalcond[1]=new_r02;
evalcond[2]=new_r12;
evalcond[3]=new_r20;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
sj4=-4.0e-5;
cj4=-1.0;
j4=-3.14155264453703;
j5eval[0]=((((5.12e-8)*(IKabs(new_r10))))+(IKabs(((((8.0000000064)*new_r11))+(((8.0)*new_r00)))))+(IKabs(((((16.0000000128)*new_r11))+(((16.0000000512)*new_r00)))))+(IKabs(((((-8.0000000064)*new_r10))+(((8.0)*new_r01)))))+(((2.0)*(IKabs(((((16.0000000128)*new_r00))+(((16.0)*new_r11))))))));
if( IKabs(j5eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j3, j5]

} else
{
IkReal op[4+1], zeror[4];
int numroots;
IkReal j5evalpoly[1];
IkReal x194=((((8.0000000064)*new_r11))+(((8.0)*new_r00)));
op[0]=x194;
op[1]=((-2.56e-8)*new_r10);
op[2]=((((16.0000000128)*new_r11))+(((16.0000000512)*new_r00)));
op[3]=((2.56e-8)*new_r10);
op[4]=x194;
polyroots4(op,zeror,numroots);
IkReal j5array[4], cj5array[4], sj5array[4], tempj5array[1];
int numsolutions = 0;
for(int ij5 = 0; ij5 < numroots; ++ij5)
{
IkReal htj5 = zeror[ij5];
tempj5array[0]=((2.0)*(atan(htj5)));
for(int kj5 = 0; kj5 < 1; ++kj5)
{
j5array[numsolutions] = tempj5array[kj5];
if( j5array[numsolutions] > IKPI )
{
    j5array[numsolutions]-=IK2PI;
}
else if( j5array[numsolutions] < -IKPI )
{
    j5array[numsolutions]+=IK2PI;
}
sj5array[numsolutions] = IKsin(j5array[numsolutions]);
cj5array[numsolutions] = IKcos(j5array[numsolutions]);
numsolutions++;
}
}
bool j5valid[4]={true,true,true,true};
_nj5 = 4;
for(int ij5 = 0; ij5 < numsolutions; ++ij5)
    {
if( !j5valid[ij5] )
{
    continue;
}
    j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
htj5 = IKtan(j5/2);

IkReal x195=((8.0000000064)*new_r10);
IkReal x196=((8.0)*new_r01);
IkReal x197=((((16.0000000128)*new_r00))+(((16.0)*new_r11)));
j5evalpoly[0]=((((htj5*htj5*htj5*htj5)*(((((-1.0)*x195))+x196))))+(((-1.0)*x196))+x195+((htj5*x197))+((x197*(htj5*htj5*htj5))));
if( IKabs(j5evalpoly[0]) > 0.0000001000000000  )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < numsolutions; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
if( IKabs(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj5*new_r11))+((new_r01*sj5)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))))+IKsqr((((cj5*new_r11))+((new_r01*sj5))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))), (((cj5*new_r11))+((new_r01*sj5))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[10];
IkReal x198=IKcos(j3);
IkReal x199=IKsin(j3);
IkReal x200=((1.0000000008)*sj5);
IkReal x201=(cj5*new_r01);
IkReal x202=((1.0)*sj5);
IkReal x203=(cj5*new_r00);
IkReal x204=((1.0)*x198);
IkReal x205=((1.0000000008)*x199);
IkReal x206=((1.0000000008)*x198);
evalcond[0]=(((cj5*new_r10))+((new_r00*sj5))+x199);
evalcond[1]=(((cj5*new_r11))+((new_r01*sj5))+(((-1.0)*x204)));
evalcond[2]=(x206+x203+(((-1.0)*new_r10*x202)));
evalcond[3]=(x205+x201+(((-1.0)*new_r11*x202)));
evalcond[4]=(((cj5*x206))+new_r00+((sj5*x199)));
evalcond[5]=(((cj5*x199))+(((-1.0)*x198*x200))+new_r10);
evalcond[6]=(((cj5*x205))+(((-1.0)*x198*x202))+new_r01);
evalcond[7]=((((-1.0)*cj5*x204))+(((-1.0)*x199*x200))+new_r11);
evalcond[8]=(((new_r10*x200))+(((-1.0000000008)*x203))+(((-1.0)*x204)));
evalcond[9]=(((new_r11*x200))+(((-1.0)*x199))+(((-1.0000000008)*x201)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.99999999786682e-5)+j4)))), 6.28318530717959)));
evalcond[1]=new_r02;
evalcond[2]=new_r12;
evalcond[3]=new_r20;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
j5eval[0]=((((5.12e-8)*(IKabs(new_r10))))+(IKabs(((((8.0000000064)*new_r10))+(((8.0)*new_r01)))))+(((2.0)*(IKabs(((((-16.0000000128)*new_r00))+(((16.0)*new_r11)))))))+(IKabs(((((-8.0000000064)*new_r11))+(((8.0)*new_r00)))))+(IKabs(((((16.0000000512)*new_r00))+(((-16.0000000128)*new_r11))))));
if( IKabs(j5eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j3, j5]

} else
{
IkReal op[4+1], zeror[4];
int numroots;
IkReal j5evalpoly[1];
IkReal x207=((((-8.0000000064)*new_r11))+(((8.0)*new_r00)));
op[0]=x207;
op[1]=((-2.56e-8)*new_r10);
op[2]=((((16.0000000512)*new_r00))+(((-16.0000000128)*new_r11)));
op[3]=((2.56e-8)*new_r10);
op[4]=x207;
polyroots4(op,zeror,numroots);
IkReal j5array[4], cj5array[4], sj5array[4], tempj5array[1];
int numsolutions = 0;
for(int ij5 = 0; ij5 < numroots; ++ij5)
{
IkReal htj5 = zeror[ij5];
tempj5array[0]=((2.0)*(atan(htj5)));
for(int kj5 = 0; kj5 < 1; ++kj5)
{
j5array[numsolutions] = tempj5array[kj5];
if( j5array[numsolutions] > IKPI )
{
    j5array[numsolutions]-=IK2PI;
}
else if( j5array[numsolutions] < -IKPI )
{
    j5array[numsolutions]+=IK2PI;
}
sj5array[numsolutions] = IKsin(j5array[numsolutions]);
cj5array[numsolutions] = IKcos(j5array[numsolutions]);
numsolutions++;
}
}
bool j5valid[4]={true,true,true,true};
_nj5 = 4;
for(int ij5 = 0; ij5 < numsolutions; ++ij5)
    {
if( !j5valid[ij5] )
{
    continue;
}
    j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
htj5 = IKtan(j5/2);

IkReal x208=((((-16.0000000128)*new_r00))+(((16.0)*new_r11)));
IkReal x209=((((8.0000000064)*new_r10))+(((8.0)*new_r01)));
j5evalpoly[0]=(((x208*(htj5*htj5*htj5)))+((htj5*x208))+(((-1.0)*x209))+((x209*(htj5*htj5*htj5*htj5))));
if( IKabs(j5evalpoly[0]) > 0.0000001000000000  )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < numsolutions; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
if( IKabs(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj5*new_r11))+((new_r01*sj5)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))))+IKsqr((((cj5*new_r11))+((new_r01*sj5))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))), (((cj5*new_r11))+((new_r01*sj5))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[10];
IkReal x210=IKcos(j3);
IkReal x211=IKsin(j3);
IkReal x212=((1.0000000008)*sj5);
IkReal x213=(cj5*new_r01);
IkReal x214=((1.0)*sj5);
IkReal x215=(cj5*new_r00);
IkReal x216=((1.0)*x210);
IkReal x217=((1.0000000008)*x211);
IkReal x218=((1.0000000008)*x210);
evalcond[0]=(((cj5*new_r10))+((new_r00*sj5))+x211);
evalcond[1]=(((cj5*new_r11))+((new_r01*sj5))+(((-1.0)*x216)));
evalcond[2]=((((-1.0)*new_r10*x214))+x215+(((-1.0)*x218)));
evalcond[3]=((((-1.0)*new_r11*x214))+x213+(((-1.0)*x217)));
evalcond[4]=(((sj5*x211))+(((-1.0)*cj5*x218))+new_r00);
evalcond[5]=(((x210*x212))+((cj5*x211))+new_r10);
evalcond[6]=((((-1.0)*x210*x214))+(((-1.0)*cj5*x217))+new_r01);
evalcond[7]=(((x211*x212))+(((-1.0)*cj5*x216))+new_r11);
evalcond[8]=((((1.0000000008)*x215))+(((-1.0)*new_r10*x212))+(((-1.0)*x216)));
evalcond[9]=((((1.0000000008)*x213))+(((-1.0)*new_r11*x212))+(((-1.0)*x211)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.99999999786667e-5)+j4)))), 6.28318530717959)));
evalcond[1]=new_r02;
evalcond[2]=new_r12;
evalcond[3]=new_r20;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
j5eval[0]=((((5.12e-8)*(IKabs(new_r10))))+(IKabs(((((8.0000000064)*new_r10))+(((8.0)*new_r01)))))+(((2.0)*(IKabs(((((-16.0000000128)*new_r00))+(((16.0)*new_r11)))))))+(IKabs(((((-8.0000000064)*new_r11))+(((8.0)*new_r00)))))+(IKabs(((((16.0000000512)*new_r00))+(((-16.0000000128)*new_r11))))));
if( IKabs(j5eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j3, j5]

} else
{
IkReal op[4+1], zeror[4];
int numroots;
IkReal j5evalpoly[1];
IkReal x219=((((-8.0000000064)*new_r11))+(((8.0)*new_r00)));
op[0]=x219;
op[1]=((-2.56e-8)*new_r10);
op[2]=((((16.0000000512)*new_r00))+(((-16.0000000128)*new_r11)));
op[3]=((2.56e-8)*new_r10);
op[4]=x219;
polyroots4(op,zeror,numroots);
IkReal j5array[4], cj5array[4], sj5array[4], tempj5array[1];
int numsolutions = 0;
for(int ij5 = 0; ij5 < numroots; ++ij5)
{
IkReal htj5 = zeror[ij5];
tempj5array[0]=((2.0)*(atan(htj5)));
for(int kj5 = 0; kj5 < 1; ++kj5)
{
j5array[numsolutions] = tempj5array[kj5];
if( j5array[numsolutions] > IKPI )
{
    j5array[numsolutions]-=IK2PI;
}
else if( j5array[numsolutions] < -IKPI )
{
    j5array[numsolutions]+=IK2PI;
}
sj5array[numsolutions] = IKsin(j5array[numsolutions]);
cj5array[numsolutions] = IKcos(j5array[numsolutions]);
numsolutions++;
}
}
bool j5valid[4]={true,true,true,true};
_nj5 = 4;
for(int ij5 = 0; ij5 < numsolutions; ++ij5)
    {
if( !j5valid[ij5] )
{
    continue;
}
    j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
htj5 = IKtan(j5/2);

IkReal x220=((((-16.0000000128)*new_r00))+(((16.0)*new_r11)));
IkReal x221=((((8.0000000064)*new_r10))+(((8.0)*new_r01)));
j5evalpoly[0]=(((x220*(htj5*htj5*htj5)))+((x221*(htj5*htj5*htj5*htj5)))+(((-1.0)*x221))+((htj5*x220)));
if( IKabs(j5evalpoly[0]) > 0.0000001000000000  )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < numsolutions; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
if( IKabs(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj5*new_r11))+((new_r01*sj5)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))))+IKsqr((((cj5*new_r11))+((new_r01*sj5))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))), (((cj5*new_r11))+((new_r01*sj5))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[10];
IkReal x222=IKcos(j3);
IkReal x223=IKsin(j3);
IkReal x224=((1.0000000008)*sj5);
IkReal x225=(cj5*new_r01);
IkReal x226=((1.0)*sj5);
IkReal x227=(cj5*new_r00);
IkReal x228=((1.0)*x222);
IkReal x229=((1.0000000008)*x223);
IkReal x230=((1.0000000008)*x222);
evalcond[0]=(((cj5*new_r10))+((new_r00*sj5))+x223);
evalcond[1]=(((cj5*new_r11))+((new_r01*sj5))+(((-1.0)*x228)));
evalcond[2]=((((-1.0)*new_r10*x226))+(((-1.0)*x230))+x227);
evalcond[3]=((((-1.0)*new_r11*x226))+x225+(((-1.0)*x229)));
evalcond[4]=((((-1.0)*cj5*x230))+((sj5*x223))+new_r00);
evalcond[5]=(((x222*x224))+((cj5*x223))+new_r10);
evalcond[6]=((((-1.0)*cj5*x229))+(((-1.0)*x222*x226))+new_r01);
evalcond[7]=((((-1.0)*cj5*x228))+((x223*x224))+new_r11);
evalcond[8]=((((-1.0)*new_r10*x224))+(((1.0000000008)*x227))+(((-1.0)*x228)));
evalcond[9]=((((-1.0)*new_r11*x224))+(((1.0000000008)*x225))+(((-1.0)*x223)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14163265358977)+j4)))), 6.28318530717959)));
evalcond[1]=new_r02;
evalcond[2]=new_r12;
evalcond[3]=new_r20;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
j5eval[0]=((((5.12e-8)*(IKabs(new_r10))))+(IKabs(((((8.0000000064)*new_r11))+(((8.0)*new_r00)))))+(IKabs(((((16.0000000128)*new_r11))+(((16.0000000512)*new_r00)))))+(IKabs(((((-8.0000000064)*new_r10))+(((8.0)*new_r01)))))+(((2.0)*(IKabs(((((16.0000000128)*new_r00))+(((16.0)*new_r11))))))));
if( IKabs(j5eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j3, j5]

} else
{
IkReal op[4+1], zeror[4];
int numroots;
IkReal j5evalpoly[1];
IkReal x231=((((8.0000000064)*new_r11))+(((8.0)*new_r00)));
op[0]=x231;
op[1]=((-2.56e-8)*new_r10);
op[2]=((((16.0000000128)*new_r11))+(((16.0000000512)*new_r00)));
op[3]=((2.56e-8)*new_r10);
op[4]=x231;
polyroots4(op,zeror,numroots);
IkReal j5array[4], cj5array[4], sj5array[4], tempj5array[1];
int numsolutions = 0;
for(int ij5 = 0; ij5 < numroots; ++ij5)
{
IkReal htj5 = zeror[ij5];
tempj5array[0]=((2.0)*(atan(htj5)));
for(int kj5 = 0; kj5 < 1; ++kj5)
{
j5array[numsolutions] = tempj5array[kj5];
if( j5array[numsolutions] > IKPI )
{
    j5array[numsolutions]-=IK2PI;
}
else if( j5array[numsolutions] < -IKPI )
{
    j5array[numsolutions]+=IK2PI;
}
sj5array[numsolutions] = IKsin(j5array[numsolutions]);
cj5array[numsolutions] = IKcos(j5array[numsolutions]);
numsolutions++;
}
}
bool j5valid[4]={true,true,true,true};
_nj5 = 4;
for(int ij5 = 0; ij5 < numsolutions; ++ij5)
    {
if( !j5valid[ij5] )
{
    continue;
}
    j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
htj5 = IKtan(j5/2);

IkReal x232=((8.0000000064)*new_r10);
IkReal x233=((8.0)*new_r01);
IkReal x234=((((16.0000000128)*new_r00))+(((16.0)*new_r11)));
j5evalpoly[0]=((((htj5*htj5*htj5*htj5)*(((((-1.0)*x232))+x233))))+((htj5*x234))+(((-1.0)*x233))+x232+((x234*(htj5*htj5*htj5))));
if( IKabs(j5evalpoly[0]) > 0.0000001000000000  )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < numsolutions; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
if( IKabs(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj5*new_r11))+((new_r01*sj5)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))))+IKsqr((((cj5*new_r11))+((new_r01*sj5))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))), (((cj5*new_r11))+((new_r01*sj5))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[10];
IkReal x235=IKcos(j3);
IkReal x236=IKsin(j3);
IkReal x237=((1.0000000008)*sj5);
IkReal x238=(cj5*new_r01);
IkReal x239=((1.0)*sj5);
IkReal x240=(cj5*new_r00);
IkReal x241=((1.0)*x235);
IkReal x242=((1.0000000008)*x236);
IkReal x243=((1.0000000008)*x235);
evalcond[0]=(((cj5*new_r10))+((new_r00*sj5))+x236);
evalcond[1]=(((cj5*new_r11))+((new_r01*sj5))+(((-1.0)*x241)));
evalcond[2]=(x243+x240+(((-1.0)*new_r10*x239)));
evalcond[3]=(x238+x242+(((-1.0)*new_r11*x239)));
evalcond[4]=(((cj5*x243))+new_r00+((sj5*x236)));
evalcond[5]=((((-1.0)*x235*x237))+((cj5*x236))+new_r10);
evalcond[6]=((((-1.0)*x235*x239))+((cj5*x242))+new_r01);
evalcond[7]=((((-1.0)*cj5*x241))+(((-1.0)*x236*x237))+new_r11);
evalcond[8]=(((new_r10*x237))+(((-1.0000000008)*x240))+(((-1.0)*x241)));
evalcond[9]=(((new_r11*x237))+(((-1.0000000008)*x238))+(((-1.0)*x236)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r12))+(IKabs(new_r02)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j3eval[0]=IKabs(((((-3.9999999968e-5)*cj4))+(((0.9999999992)*sj4))));
if( IKabs(j3eval[0]) < 0.0000000100000000  )
{
{
IkReal j5eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
IkReal x244=((625000000.5)*sj4);
IkReal x245=((25000.00002)*cj4);
j5eval[0]=((IKabs(((((-1.0)*new_r00*x244))+((new_r00*x245)))))+(IKabs(((((-1.0)*new_r10*x245))+((new_r10*x244))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
IkReal x246=((625000000.5)*sj4);
IkReal x247=((25000.00002)*cj4);
j5eval[0]=((IKabs(((((-1.0)*new_r01*x246))+((new_r01*x247)))))+(IKabs(((((-1.0)*new_r11*x247))+((new_r11*x246))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j3, j5]

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
IkReal x248=((3.9999999968e-5)*cj4);
IkReal x249=((0.9999999992)*sj4);
CheckValue<IkReal> x251 = IKatan2WithCheck(IkReal(((((-1.0)*new_r01*x249))+((new_r01*x248)))),IkReal(((((-1.0)*new_r11*x248))+((new_r11*x249)))),IKFAST_ATAN2_MAGTHRESH);
if(!x251.valid){
continue;
}
IkReal x250=x251.value;
j5array[0]=((-1.0)*x250);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
j5array[1]=((3.14159265358979)+(((-1.0)*x250)));
sj5array[1]=IKsin(j5array[1]);
cj5array[1]=IKcos(j5array[1]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
if( j5array[1] > IKPI )
{
    j5array[1]-=IK2PI;
}
else if( j5array[1] < -IKPI )
{    j5array[1]+=IK2PI;
}
j5valid[1] = true;
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[3];
IkReal x252=IKcos(j5);
IkReal x253=IKsin(j5);
IkReal x254=((0.9999999992)*sj4);
IkReal x255=((3.9999999968e-5)*cj4);
IkReal x256=(new_r00*x252);
IkReal x257=(x253*x255);
evalcond[0]=((((-1.0)*x252*x255))+((x252*x254)));
evalcond[1]=(x257+(((-1.0)*x253*x254)));
evalcond[2]=((((-1.0)*new_r10*x257))+(((-1.0)*x254*x256))+((new_r10*x253*x254))+((x255*x256)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
if( IKabs(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj5*new_r11))+((new_r01*sj5)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))))+IKsqr((((cj5*new_r11))+((new_r01*sj5))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))), (((cj5*new_r11))+((new_r01*sj5))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[12];
IkReal x258=IKsin(j3);
IkReal x259=IKcos(j3);
IkReal x260=(cj5*new_r01);
IkReal x261=((25000.00002)*sj4);
IkReal x262=((3.9999999968e-5)*cj4);
IkReal x263=((0.9999999992)*sj4);
IkReal x264=(cj5*new_r00);
IkReal x265=((1.0)*sj5);
IkReal x266=((1.0)*x259);
IkReal x267=(sj5*x258);
IkReal x268=(cj5*x259);
IkReal x269=(cj5*x258);
evalcond[0]=(((cj5*new_r10))+((new_r00*sj5))+x258);
evalcond[1]=(((cj5*new_r11))+((new_r01*sj5))+(((-1.0)*x266)));
evalcond[2]=(x269+new_r10+((sj5*x259*x261)));
evalcond[3]=((((-1.0)*x259*x261))+x264+(((-1.0)*new_r10*x265)));
evalcond[4]=((((-1.0)*x258*x261))+x260+(((-1.0)*new_r11*x265)));
evalcond[5]=(x267+(((-1.0)*x261*x268))+new_r00);
evalcond[6]=((((-1.0)*cj5*x266))+((x261*x267))+new_r11);
evalcond[7]=((((-1.0)*x259*x265))+(((-1.0)*x261*x269))+new_r01);
evalcond[8]=(((x259*x262))+(((-1.0)*x259*x263)));
evalcond[9]=(((x258*x262))+(((-1.0)*x258*x263)));
evalcond[10]=((((-1.0)*new_r10*sj5*x261))+((x261*x264))+(((-1.0)*x266)));
evalcond[11]=(((x260*x261))+(((-1.0)*new_r11*sj5*x261))+(((-1.0)*x258)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
IkReal x270=((3.9999999968e-5)*cj4);
IkReal x271=((0.9999999992)*sj4);
CheckValue<IkReal> x273 = IKatan2WithCheck(IkReal(((((-1.0)*new_r00*x271))+((new_r00*x270)))),IkReal(((((-1.0)*new_r10*x270))+((new_r10*x271)))),IKFAST_ATAN2_MAGTHRESH);
if(!x273.valid){
continue;
}
IkReal x272=x273.value;
j5array[0]=((-1.0)*x272);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
j5array[1]=((3.14159265358979)+(((-1.0)*x272)));
sj5array[1]=IKsin(j5array[1]);
cj5array[1]=IKcos(j5array[1]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
if( j5array[1] > IKPI )
{
    j5array[1]-=IK2PI;
}
else if( j5array[1] < -IKPI )
{    j5array[1]+=IK2PI;
}
j5valid[1] = true;
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[3];
IkReal x274=IKcos(j5);
IkReal x275=IKsin(j5);
IkReal x276=((0.9999999992)*sj4);
IkReal x277=((3.9999999968e-5)*cj4);
IkReal x278=(new_r11*x275);
IkReal x279=(new_r01*x274);
evalcond[0]=((((-1.0)*x274*x277))+((x274*x276)));
evalcond[1]=(((x275*x277))+(((-1.0)*x275*x276)));
evalcond[2]=((((-1.0)*x277*x278))+((x277*x279))+((x276*x278))+(((-1.0)*x276*x279)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
if( IKabs(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj5*new_r11))+((new_r01*sj5)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))))+IKsqr((((cj5*new_r11))+((new_r01*sj5))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))), (((cj5*new_r11))+((new_r01*sj5))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[12];
IkReal x280=IKsin(j3);
IkReal x281=IKcos(j3);
IkReal x282=(cj5*new_r01);
IkReal x283=((25000.00002)*sj4);
IkReal x284=((3.9999999968e-5)*cj4);
IkReal x285=((0.9999999992)*sj4);
IkReal x286=(cj5*new_r00);
IkReal x287=((1.0)*sj5);
IkReal x288=((1.0)*x281);
IkReal x289=(sj5*x280);
IkReal x290=(cj5*x281);
IkReal x291=(cj5*x280);
evalcond[0]=(((cj5*new_r10))+((new_r00*sj5))+x280);
evalcond[1]=(((cj5*new_r11))+((new_r01*sj5))+(((-1.0)*x288)));
evalcond[2]=(x291+((sj5*x281*x283))+new_r10);
evalcond[3]=((((-1.0)*x281*x283))+x286+(((-1.0)*new_r10*x287)));
evalcond[4]=((((-1.0)*x280*x283))+x282+(((-1.0)*new_r11*x287)));
evalcond[5]=(x289+(((-1.0)*x283*x290))+new_r00);
evalcond[6]=((((-1.0)*cj5*x288))+new_r11+((x283*x289)));
evalcond[7]=((((-1.0)*x281*x287))+(((-1.0)*x283*x291))+new_r01);
evalcond[8]=((((-1.0)*x281*x285))+((x281*x284)));
evalcond[9]=((((-1.0)*x280*x285))+((x280*x284)));
evalcond[10]=((((-1.0)*new_r10*sj5*x283))+(((-1.0)*x288))+((x283*x286)));
evalcond[11]=((((-1.0)*x280))+(((-1.0)*new_r11*sj5*x283))+((x282*x283)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}

} else
{
IkReal op[2+1], zeror[2];
int numroots;
IkReal x292=((3.9999999968e-5)*cj4);
IkReal x293=((0.9999999992)*sj4);
op[0]=((((-1.0)*x292))+x293);
op[1]=0;
op[2]=((((-1.0)*x293))+x292);
polyroots2(op,zeror,numroots);
IkReal j3array[2], cj3array[2], sj3array[2], tempj3array[1];
int numsolutions = 0;
for(int ij3 = 0; ij3 < numroots; ++ij3)
{
IkReal htj3 = zeror[ij3];
tempj3array[0]=((2.0)*(atan(htj3)));
for(int kj3 = 0; kj3 < 1; ++kj3)
{
j3array[numsolutions] = tempj3array[kj3];
if( j3array[numsolutions] > IKPI )
{
    j3array[numsolutions]-=IK2PI;
}
else if( j3array[numsolutions] < -IKPI )
{
    j3array[numsolutions]+=IK2PI;
}
sj3array[numsolutions] = IKsin(j3array[numsolutions]);
cj3array[numsolutions] = IKcos(j3array[numsolutions]);
numsolutions++;
}
}
bool j3valid[2]={true,true};
_nj3 = 2;
for(int ij3 = 0; ij3 < numsolutions; ++ij3)
    {
if( !j3valid[ij3] )
{
    continue;
}
    j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
htj3 = IKtan(j3/2);

_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < numsolutions; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
{
IkReal j5eval[3];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
IkReal x294=((1.0)*new_r00);
IkReal x295=((((-1.0)*new_r11*x294))+((new_r01*new_r10)));
j5eval[0]=x295;
j5eval[1]=IKsign(x295);
j5eval[2]=((IKabs((((new_r11*sj3))+((cj3*new_r10)))))+(IKabs(((((-1.0)*new_r01*sj3))+(((-1.0)*cj3*x294))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
IkReal x296=cj3*cj3;
IkReal x297=new_r00*new_r00;
IkReal x298=cj4*cj4;
IkReal x299=((625000001.0)*x296*x298);
j5eval[0]=((((-1.0)*x297*x299))+x299+x297+(((-625000001.0)*x296))+(((625000000.0)*x296*x297)));
j5eval[1]=((((-25000.00002)*cj3*new_r10*sj4))+((new_r00*sj3)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j5eval[0]=(((new_r10*sj3))+(((25000.00002)*cj3*new_r00*sj4)));
j5eval[1]=new_r00;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[3];
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(((-3.14159265358979)+(IKfmod(((3.14159265358979)+j4), 6.28318530717959)))))+(IKabs(((-3.14159265358979)+(IKfmod(((3.14159265358979)+j3), 6.28318530717959))))));
evalcond[1]=new_r00;
evalcond[2]=new_r10;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r01)+IKsqr(new_r11)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r01, new_r11);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x300=IKcos(j5);
IkReal x301=IKsin(j5);
IkReal x302=(new_r01*x300);
IkReal x303=((3.9999999968e-5)*x301);
IkReal x304=((1.0)*x301);
evalcond[0]=(new_r01+(((-1.0)*x304)));
evalcond[1]=((((-1.0)*x300))+new_r11);
evalcond[2]=((-3.9999999968e-5)*x300);
evalcond[3]=x303;
evalcond[4]=((-1.0)+((new_r01*x301))+((new_r11*x300)));
evalcond[5]=(x302+(((-1.0)*new_r11*x304)));
evalcond[6]=((((3.9999999968e-5)*x302))+(((-1.0)*new_r11*x303)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(((-3.14159265358979)+(IKfmod(j3, 6.28318530717959)))))+(IKabs(((-3.14159265358979)+(IKfmod(((3.14159265358979)+j4), 6.28318530717959))))));
evalcond[1]=new_r00;
evalcond[2]=new_r10;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r01))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0)*new_r01), ((-1.0)*new_r11));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x305=IKcos(j5);
IkReal x306=IKsin(j5);
IkReal x307=(new_r01*x305);
IkReal x308=((3.9999999968e-5)*x306);
evalcond[0]=(x306+new_r01);
evalcond[1]=(x305+new_r11);
evalcond[2]=((-3.9999999968e-5)*x305);
evalcond[3]=x308;
evalcond[4]=((1.0)+((new_r01*x306))+((new_r11*x305)));
evalcond[5]=(x307+(((-1.0)*new_r11*x306)));
evalcond[6]=((((3.9999999968e-5)*x307))+(((-1.0)*new_r11*x308)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(((-3.14159265358979)+(IKfmod(j4, 6.28318530717959)))))+(IKabs(((-3.14159265358979)+(IKfmod(((3.14159265358979)+j3), 6.28318530717959))))));
evalcond[1]=new_r00;
evalcond[2]=new_r10;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r01)+IKsqr(new_r11)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r01, new_r11);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x309=IKcos(j5);
IkReal x310=IKsin(j5);
IkReal x311=((3.9999999968e-5)*x309);
IkReal x312=(new_r11*x310);
evalcond[0]=((((-1.0)*x310))+new_r01);
evalcond[1]=((((-1.0)*x309))+new_r11);
evalcond[2]=x311;
evalcond[3]=((-3.9999999968e-5)*x310);
evalcond[4]=((-1.0)+((new_r11*x309))+((new_r01*x310)));
evalcond[5]=(((new_r01*x309))+(((-1.0)*x312)));
evalcond[6]=((((3.9999999968e-5)*x312))+(((-1.0)*new_r01*x311)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(((-3.14159265358979)+(IKfmod(j3, 6.28318530717959)))))+(IKabs(((-3.14159265358979)+(IKfmod(j4, 6.28318530717959))))));
evalcond[1]=new_r00;
evalcond[2]=new_r10;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r01))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0)*new_r01), ((-1.0)*new_r11));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x313=IKcos(j5);
IkReal x314=IKsin(j5);
IkReal x315=((3.9999999968e-5)*x313);
IkReal x316=(new_r11*x314);
evalcond[0]=(x314+new_r01);
evalcond[1]=(x313+new_r11);
evalcond[2]=x315;
evalcond[3]=((-3.9999999968e-5)*x314);
evalcond[4]=((1.0)+((new_r01*x314))+((new_r11*x313)));
evalcond[5]=(((new_r01*x313))+(((-1.0)*x316)));
evalcond[6]=((((3.9999999968e-5)*x316))+(((-1.0)*new_r01*x315)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x321=IKPowWithIntegerCheck(new_r00,-1);
if(!x321.valid){
continue;
}
IkReal x317=x321.value;
IkReal x318=cj3*cj3;
CheckValue<IkReal> x322=IKPowWithIntegerCheck((((new_r10*sj3))+(((25000.00002)*cj3*new_r00*sj4))),-1);
if(!x322.valid){
continue;
}
IkReal x319=x322.value;
IkReal x320=((1.0)*new_r10*x319);
CheckValue<IkReal> x323=IKPowWithIntegerCheck(x317,-2);
if(!x323.valid){
continue;
}
if( IKabs(((((-1.0)*x317*x318*x320))+(((-1.0)*new_r00*x320))+(((-1.0)*sj3*x317))+((new_r10*x317*x319)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x319*(((-1.0)+x318+(x323.value))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*x317*x318*x320))+(((-1.0)*new_r00*x320))+(((-1.0)*sj3*x317))+((new_r10*x317*x319))))+IKsqr((x319*(((-1.0)+x318+(x323.value)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*x317*x318*x320))+(((-1.0)*new_r00*x320))+(((-1.0)*sj3*x317))+((new_r10*x317*x319))), (x319*(((-1.0)+x318+(x323.value)))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[14];
IkReal x324=IKcos(j5);
IkReal x325=IKsin(j5);
IkReal x326=((1.0)*cj3);
IkReal x327=((25000.00002)*sj4);
IkReal x328=((3.9999999968e-5)*cj4);
IkReal x329=((0.9999999992)*sj4);
IkReal x330=(new_r11*x325);
IkReal x331=(new_r01*x324);
IkReal x332=(new_r00*x324);
IkReal x333=(sj3*x325);
IkReal x334=(new_r10*x325);
IkReal x335=(sj3*x324);
evalcond[0]=(((new_r00*x325))+sj3+((new_r10*x324)));
evalcond[1]=(((new_r01*x325))+(((-1.0)*x326))+((new_r11*x324)));
evalcond[2]=(((cj3*x325*x327))+x335+new_r10);
evalcond[3]=((((-1.0)*cj3*x324*x327))+x333+new_r00);
evalcond[4]=(((x327*x333))+new_r11+(((-1.0)*x324*x326)));
evalcond[5]=((((-1.0)*x325*x326))+new_r01+(((-1.0)*x327*x335)));
evalcond[6]=(((x324*x329))+(((-1.0)*x324*x328)));
evalcond[7]=(((x325*x328))+(((-1.0)*x325*x329)));
evalcond[8]=((((-1.0)*cj3*x327))+x332+(((-1.0)*x334)));
evalcond[9]=(x331+(((-1.0)*x330))+(((-1.0)*sj3*x327)));
evalcond[10]=((((-1.0)*x326))+((x327*x332))+(((-1.0)*x327*x334)));
evalcond[11]=((((-1.0)*sj3))+((x327*x331))+(((-1.0)*x327*x330)));
evalcond[12]=((((-1.0)*x329*x332))+(((-1.0)*x328*x334))+((x329*x334))+((x328*x332)));
evalcond[13]=((((-1.0)*x329*x331))+(((-1.0)*x328*x330))+((x329*x330))+((x328*x331)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x336=new_r10*new_r10;
IkReal x337=cj3*cj3;
IkReal x338=new_r00*new_r00;
IkReal x339=(new_r00*sj3);
IkReal x340=((1.0)*new_r00);
IkReal x341=((25000.00002)*cj3*sj4);
IkReal x342=(new_r10*x341);
IkReal x343=((625000001.0)*x336*x337);
CheckValue<IkReal> x344=IKPowWithIntegerCheck((x338+(((-1.0)*x337*x338))+(((-1.0)*x343))+((x343*(cj4*cj4)))),-1);
if(!x344.valid){
continue;
}
CheckValue<IkReal> x345=IKPowWithIntegerCheck((x339+(((-1.0)*x342))),-1);
if(!x345.valid){
continue;
}
if( IKabs(((x344.value)*((((x342*(new_r10*new_r10)))+(((-1.0)*x339*(sj3*sj3)))+((x336*x339))+(((-1.0)*x342))+((x342*(cj3*cj3))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x345.value)*(((((-1.0)*new_r10*x340))+((sj3*x341)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x344.value)*((((x342*(new_r10*new_r10)))+(((-1.0)*x339*(sj3*sj3)))+((x336*x339))+(((-1.0)*x342))+((x342*(cj3*cj3)))))))+IKsqr(((x345.value)*(((((-1.0)*new_r10*x340))+((sj3*x341))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((x344.value)*((((x342*(new_r10*new_r10)))+(((-1.0)*x339*(sj3*sj3)))+((x336*x339))+(((-1.0)*x342))+((x342*(cj3*cj3)))))), ((x345.value)*(((((-1.0)*new_r10*x340))+((sj3*x341))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[14];
IkReal x346=IKcos(j5);
IkReal x347=IKsin(j5);
IkReal x348=((1.0)*cj3);
IkReal x349=((25000.00002)*sj4);
IkReal x350=((3.9999999968e-5)*cj4);
IkReal x351=((0.9999999992)*sj4);
IkReal x352=(new_r11*x347);
IkReal x353=(new_r01*x346);
IkReal x354=(new_r00*x346);
IkReal x355=(sj3*x347);
IkReal x356=(new_r10*x347);
IkReal x357=(sj3*x346);
evalcond[0]=(sj3+((new_r00*x347))+((new_r10*x346)));
evalcond[1]=(((new_r11*x346))+((new_r01*x347))+(((-1.0)*x348)));
evalcond[2]=(x357+new_r10+((cj3*x347*x349)));
evalcond[3]=((((-1.0)*cj3*x346*x349))+x355+new_r00);
evalcond[4]=(((x349*x355))+(((-1.0)*x346*x348))+new_r11);
evalcond[5]=((((-1.0)*x349*x357))+(((-1.0)*x347*x348))+new_r01);
evalcond[6]=(((x346*x351))+(((-1.0)*x346*x350)));
evalcond[7]=(((x347*x350))+(((-1.0)*x347*x351)));
evalcond[8]=((((-1.0)*cj3*x349))+(((-1.0)*x356))+x354);
evalcond[9]=((((-1.0)*x352))+x353+(((-1.0)*sj3*x349)));
evalcond[10]=((((-1.0)*x349*x356))+((x349*x354))+(((-1.0)*x348)));
evalcond[11]=((((-1.0)*sj3))+(((-1.0)*x349*x352))+((x349*x353)));
evalcond[12]=(((x351*x356))+((x350*x354))+(((-1.0)*x351*x354))+(((-1.0)*x350*x356)));
evalcond[13]=(((x351*x352))+((x350*x353))+(((-1.0)*x351*x353))+(((-1.0)*x350*x352)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x358=((1.0)*new_r00);
CheckValue<IkReal> x359 = IKatan2WithCheck(IkReal((((new_r11*sj3))+((cj3*new_r10)))),IkReal(((((-1.0)*new_r01*sj3))+(((-1.0)*cj3*x358)))),IKFAST_ATAN2_MAGTHRESH);
if(!x359.valid){
continue;
}
CheckValue<IkReal> x360=IKPowWithIntegerCheck(IKsign((((new_r01*new_r10))+(((-1.0)*new_r11*x358)))),-1);
if(!x360.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x359.value)+(((1.5707963267949)*(x360.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[14];
IkReal x361=IKcos(j5);
IkReal x362=IKsin(j5);
IkReal x363=((1.0)*cj3);
IkReal x364=((25000.00002)*sj4);
IkReal x365=((3.9999999968e-5)*cj4);
IkReal x366=((0.9999999992)*sj4);
IkReal x367=(new_r11*x362);
IkReal x368=(new_r01*x361);
IkReal x369=(new_r00*x361);
IkReal x370=(sj3*x362);
IkReal x371=(new_r10*x362);
IkReal x372=(sj3*x361);
evalcond[0]=(sj3+((new_r00*x362))+((new_r10*x361)));
evalcond[1]=((((-1.0)*x363))+((new_r01*x362))+((new_r11*x361)));
evalcond[2]=(((cj3*x362*x364))+x372+new_r10);
evalcond[3]=(x370+(((-1.0)*cj3*x361*x364))+new_r00);
evalcond[4]=((((-1.0)*x361*x363))+((x364*x370))+new_r11);
evalcond[5]=((((-1.0)*x362*x363))+new_r01+(((-1.0)*x364*x372)));
evalcond[6]=(((x361*x366))+(((-1.0)*x361*x365)));
evalcond[7]=((((-1.0)*x362*x366))+((x362*x365)));
evalcond[8]=((((-1.0)*x371))+x369+(((-1.0)*cj3*x364)));
evalcond[9]=((((-1.0)*x367))+(((-1.0)*sj3*x364))+x368);
evalcond[10]=(((x364*x369))+(((-1.0)*x363))+(((-1.0)*x364*x371)));
evalcond[11]=((((-1.0)*sj3))+((x364*x368))+(((-1.0)*x364*x367)));
evalcond[12]=(((x365*x369))+((x366*x371))+(((-1.0)*x366*x369))+(((-1.0)*x365*x371)));
evalcond[13]=(((x366*x367))+((x365*x368))+(((-1.0)*x366*x368))+(((-1.0)*x365*x367)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j3, j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x373=((0.9999999992)*sj4);
IkReal x374=((3.9999999968e-5)*cj4);
CheckValue<IkReal> x375=IKPowWithIntegerCheck(IKsign(((new_r12*new_r12)+(new_r02*new_r02))),-1);
if(!x375.valid){
continue;
}
CheckValue<IkReal> x376 = IKatan2WithCheck(IkReal((((new_r12*x373))+(((-1.0)*new_r12*x374)))),IkReal((((new_r02*x374))+(((-1.0)*new_r02*x373)))),IKFAST_ATAN2_MAGTHRESH);
if(!x376.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x375.value)))+(x376.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x377=IKcos(j5);
IkReal x378=IKsin(j5);
IkReal x379=((0.9999999992)*cj4);
IkReal x380=((3.9999999968e-5)*cj4);
IkReal x381=((0.9999999992)*sj4);
IkReal x382=((3.9999999968e-5)*sj4);
IkReal x383=(new_r12*x378);
IkReal x384=(new_r02*x377);
IkReal x385=(new_r01*x377);
IkReal x386=(new_r11*x378);
IkReal x387=(new_r00*x377);
IkReal x388=(new_r10*x378);
evalcond[0]=(((new_r12*x377))+((new_r02*x378)));
evalcond[1]=(((x377*x381))+new_r02+(((-1.0)*x377*x380)));
evalcond[2]=(((x378*x380))+(((-1.0)*x378*x381))+new_r12);
evalcond[3]=(x384+x381+(((-1.0)*x383))+(((-1.0)*x380)));
evalcond[4]=((((-1.0)*x380*x388))+((new_r20*x379))+(((-1.0)*x381*x387))+((new_r20*x382))+((x380*x387))+((x381*x388)));
evalcond[5]=((((-1.0)*x380*x386))+(((-1.0)*x381*x385))+((new_r21*x379))+((x380*x385))+((x381*x386))+((new_r21*x382)));
evalcond[6]=((((-1.0)*x379*x383))+((new_r22*x381))+((x382*x384))+((x379*x384))+(((-1.0)*new_r22*x380))+(((-1.0)*x382*x383)));
evalcond[7]=((-1.0)+(((-1.0)*x380*x383))+(((-1.0)*x381*x384))+((new_r22*x382))+((x380*x384))+((x381*x383))+((new_r22*x379)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
if( IKabs(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj5*new_r11))+((new_r01*sj5)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))))+IKsqr((((cj5*new_r11))+((new_r01*sj5))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))), (((cj5*new_r11))+((new_r01*sj5))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[12];
IkReal x389=IKcos(j3);
IkReal x390=IKsin(j3);
IkReal x391=((0.9999999992)*cj4);
IkReal x392=((3.9999999968e-5)*cj4);
IkReal x393=(cj5*new_r01);
IkReal x394=((0.9999999992)*sj4);
IkReal x395=(cj5*new_r00);
IkReal x396=((3.9999999968e-5)*sj4);
IkReal x397=(new_r10*sj5);
IkReal x398=(new_r11*sj5);
IkReal x399=((1.0)*x389);
IkReal x400=(cj5*x390);
IkReal x401=(sj5*x389);
IkReal x402=(sj5*x390);
IkReal x403=(cj5*x389);
IkReal x404=(x389*x396);
evalcond[0]=(((cj5*new_r10))+((new_r00*sj5))+x390);
evalcond[1]=((((-1.0)*x399))+((cj5*new_r11))+((new_r01*sj5)));
evalcond[2]=((((-1.0)*x389*x394))+new_r20+((x389*x392)));
evalcond[3]=((((-1.0)*x390*x394))+new_r21+((x390*x392)));
evalcond[4]=((((-1.0)*x397))+(((-1.0)*x389*x391))+x395+(((-1.0)*x404)));
evalcond[5]=((((-1.0)*x398))+x393+(((-1.0)*x390*x396))+(((-1.0)*x390*x391)));
evalcond[6]=((((-1.0)*x391*x403))+x402+new_r00+(((-1.0)*x396*x403)));
evalcond[7]=(x400+new_r10+((x396*x401))+((x391*x401)));
evalcond[8]=((((-1.0)*sj5*x399))+(((-1.0)*x391*x400))+new_r01+(((-1.0)*x396*x400)));
evalcond[9]=((((-1.0)*cj5*x399))+new_r11+((x396*x402))+((x391*x402)));
evalcond[10]=((((-1.0)*x399))+((x395*x396))+((new_r20*x394))+(((-1.0)*x391*x397))+((x391*x395))+(((-1.0)*x396*x397))+(((-1.0)*new_r20*x392)));
evalcond[11]=((((-1.0)*x390))+(((-1.0)*new_r21*x392))+(((-1.0)*x391*x398))+((x391*x393))+((new_r21*x394))+(((-1.0)*x396*x398))+((x393*x396)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x405 = IKatan2WithCheck(IkReal(((-1.0)*new_r21)),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x405.valid){
continue;
}
CheckValue<IkReal> x406=IKPowWithIntegerCheck(IKsign(((((-0.9999999992)*sj4))+(((3.9999999968e-5)*cj4)))),-1);
if(!x406.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(x405.value)+(((1.5707963267949)*(x406.value))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x407=IKcos(j3);
IkReal x408=IKsin(j3);
IkReal x409=((0.9999999992)*sj4);
IkReal x410=((3.9999999968e-5)*cj4);
evalcond[0]=(((x407*x410))+(((-1.0)*x407*x409))+new_r20);
evalcond[1]=(((x408*x410))+new_r21+(((-1.0)*x408*x409)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j5eval[3];
IkReal x411=((((-1.0)*new_r00*new_r12))+((new_r02*new_r10)));
j5eval[0]=x411;
j5eval[1]=((IKabs((new_r12*sj3)))+(IKabs((new_r02*sj3))));
j5eval[2]=IKsign(x411);
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[3];
IkReal x412=(((new_r01*new_r12))+(((-1.0)*new_r02*new_r11)));
j5eval[0]=x412;
j5eval[1]=IKsign(x412);
j5eval[2]=((IKabs((cj3*new_r02)))+(IKabs((cj3*new_r12))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[3];
j5eval[0]=((((25000.0)*sj4))+(((-1.0)*cj4)));
j5eval[1]=((IKabs(new_r12))+(IKabs(new_r02)));
j5eval[2]=IKsign(((((-3.9999999968e-5)*cj4))+(((0.9999999992)*sj4))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.99999999786667e-5)+j4)))), 6.28318530717959)));
evalcond[1]=new_r02;
evalcond[2]=new_r12;
evalcond[3]=new_r20;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
IkReal x413=((1.0)*new_r00);
IkReal x414=(((new_r01*new_r10))+(((-1.0)*new_r11*x413)));
j5eval[0]=x414;
j5eval[1]=IKsign(x414);
j5eval[2]=((IKabs((((new_r11*sj3))+((cj3*new_r10)))))+(IKabs(((((-1.0)*new_r01*sj3))+(((-1.0)*cj3*x413))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
IkReal x415=new_r00*new_r00;
IkReal x416=cj3*cj3;
j5eval[0]=((((-1.0)*x415*x416))+x415+(((-1.0000000016)*x416*(new_r10*new_r10))));
j5eval[1]=((((-1.0000000008)*cj3*new_r10))+((new_r00*sj3)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
j5eval[0]=new_r00;
j5eval[1]=((((-1.0000000008)*new_r00*sj3))+((cj3*new_r10)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
IkReal x417=((-1.0000000008)*new_r00);
IkReal x419 = ((((1.0000000016)*(new_r00*new_r00)))+(new_r10*new_r10));
if(IKabs(x419)==0){
continue;
}
IkReal x418=pow(x419,-0.5);
CheckValue<IkReal> x420 = IKatan2WithCheck(IkReal(new_r10),IkReal(x417),IKFAST_ATAN2_MAGTHRESH);
if(!x420.valid){
continue;
}
IkReal gconst6=((-1.0)*(x420.value));
IkReal gconst7=((-1.0)*new_r10*x418);
IkReal gconst8=(x417*x418);
CheckValue<IkReal> x421 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x421.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((x421.value)+j3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
IkReal x422=((-1.0000000008)*new_r00);
IkReal x423=x418;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst7;
cj3=gconst8;
CheckValue<IkReal> x424 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x424.valid){
continue;
}
j3=((-1.0)*(x424.value));
CheckValue<IkReal> x425 = IKatan2WithCheck(IkReal(new_r10),IkReal(x422),IKFAST_ATAN2_MAGTHRESH);
if(!x425.valid){
continue;
}
IkReal gconst6=((-1.0)*(x425.value));
IkReal gconst7=((-1.0)*new_r10*x423);
IkReal gconst8=(x422*x423);
IkReal x426=new_r00*new_r00;
IkReal x427=(new_r01*new_r10);
IkReal x428=(x427+(((-1.0)*new_r00*new_r11)));
IkReal x431 = ((((625000000.0)*(new_r10*new_r10)))+(((625000001.0)*x426)));
if(IKabs(x431)==0){
continue;
}
IkReal x429=pow(x431,-0.5);
IkReal x430=(new_r10*x429);
j5eval[0]=x428;
j5eval[1]=IKsign(x428);
j5eval[2]=((IKabs(((((-25000.00002)*new_r00*x430))+(((-25000.0)*new_r11*x430)))))+(IKabs(((((25000.00002)*x426*x429))+(((25000.0)*x427*x429))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x432=((-1.0000000008)*new_r00);
IkReal x433=x418;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst7;
cj3=gconst8;
CheckValue<IkReal> x434 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x434.valid){
continue;
}
j3=((-1.0)*(x434.value));
CheckValue<IkReal> x435 = IKatan2WithCheck(IkReal(new_r10),IkReal(x432),IKFAST_ATAN2_MAGTHRESH);
if(!x435.valid){
continue;
}
IkReal gconst6=((-1.0)*(x435.value));
IkReal gconst7=((-1.0)*new_r10*x433);
IkReal gconst8=(x432*x433);
IkReal x436=new_r00*new_r00;
IkReal x437=new_r10*new_r10;
IkReal x438=((((1.0000000016)*x436))+x437);
CheckValue<IkReal> x439=IKPowWithIntegerCheck(x438,-1);
if(!x439.valid){
continue;
}
j5eval[0]=((-3.20000000256e-9)*x436*x437*(x439.value));
IkReal x440 = x438;
if(IKabs(x440)==0){
continue;
}
j5eval[1]=((1.6e-9)*new_r00*new_r10*(pow(x440,-0.5)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x441=((-1.0000000008)*new_r00);
IkReal x442=x418;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst7;
cj3=gconst8;
CheckValue<IkReal> x443 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x443.valid){
continue;
}
j3=((-1.0)*(x443.value));
CheckValue<IkReal> x444 = IKatan2WithCheck(IkReal(new_r10),IkReal(x441),IKFAST_ATAN2_MAGTHRESH);
if(!x444.valid){
continue;
}
IkReal gconst6=((-1.0)*(x444.value));
IkReal gconst7=((-1.0)*new_r10*x442);
IkReal gconst8=(x441*x442);
j5eval[0]=new_r00;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(new_r00);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
CheckValue<IkReal> x446 = IKatan2WithCheck(IkReal(new_r10),IkReal(0),IKFAST_ATAN2_MAGTHRESH);
if(!x446.valid){
continue;
}
IkReal x445=((-1.0)*(x446.value));
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst7;
cj3=gconst8;
j3=x445;
new_r00=0;
IkReal gconst6=x445;
IkReal x447 = new_r10*new_r10;
if(IKabs(x447)==0){
continue;
}
IkReal gconst7=((-1.0)*new_r10*(pow(x447,-0.5)));
IkReal gconst8=0;
j5eval[0]=new_r10;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x449=IKPowWithIntegerCheck(gconst7,-1);
if(!x449.valid){
continue;
}
IkReal x448=x449.value;
if( IKabs(((-0.9999999992)*new_r11*x448)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10*x448)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-0.9999999992)*new_r11*x448))+IKsqr(((-1.0)*new_r10*x448))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-0.9999999992)*new_r11*x448), ((-1.0)*new_r10*x448));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x450=IKsin(j5);
IkReal x451=IKcos(j5);
IkReal x452=((1.0000000008)*gconst7);
IkReal x453=(new_r11*x450);
IkReal x454=(new_r10*x450);
IkReal x455=(new_r01*x451);
evalcond[0]=(gconst7*x450);
evalcond[1]=((-1.0)*x454);
evalcond[2]=(((new_r10*x451))+gconst7);
evalcond[3]=(((gconst7*x451))+new_r10);
evalcond[4]=((-1.0000000008)*x454);
evalcond[5]=(((new_r11*x451))+((new_r01*x450)));
evalcond[6]=((((-1.0)*x451*x452))+new_r01);
evalcond[7]=(((x450*x452))+new_r11);
evalcond[8]=((((-1.0)*x453))+(((-1.0)*x452))+x455);
evalcond[9]=((((-1.0)*gconst7))+(((1.0000000008)*x455))+(((-1.0000000008)*x453)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x456=IKPowWithIntegerCheck(gconst7,-1);
if(!x456.valid){
continue;
}
CheckValue<IkReal> x457=IKPowWithIntegerCheck(new_r10,-1);
if(!x457.valid){
continue;
}
if( IKabs(((-0.9999999992)*new_r11*(x456.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*gconst7*(x457.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-0.9999999992)*new_r11*(x456.value)))+IKsqr(((-1.0)*gconst7*(x457.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-0.9999999992)*new_r11*(x456.value)), ((-1.0)*gconst7*(x457.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x458=IKsin(j5);
IkReal x459=IKcos(j5);
IkReal x460=((1.0000000008)*gconst7);
IkReal x461=(new_r11*x458);
IkReal x462=(new_r10*x458);
IkReal x463=(new_r01*x459);
evalcond[0]=(gconst7*x458);
evalcond[1]=((-1.0)*x462);
evalcond[2]=(((new_r10*x459))+gconst7);
evalcond[3]=(((gconst7*x459))+new_r10);
evalcond[4]=((-1.0000000008)*x462);
evalcond[5]=(((new_r11*x459))+((new_r01*x458)));
evalcond[6]=((((-1.0)*x459*x460))+new_r01);
evalcond[7]=(new_r11+((x458*x460)));
evalcond[8]=((((-1.0)*x461))+(((-1.0)*x460))+x463);
evalcond[9]=((((-1.0)*gconst7))+(((1.0000000008)*x463))+(((-1.0000000008)*x461)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
IkReal x464=((-1.0000000008)*new_r00);
IkReal x466 = ((1.0000000016)+(((-1.6e-9)*(new_r10*new_r10))));
if(IKabs(x466)==0){
continue;
}
IkReal x465=pow(x466,-0.5);
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst7;
cj3=gconst8;
CheckValue<IkReal> x467 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x467.valid){
continue;
}
j3=((-1.0)*(x467.value));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x468 = IKatan2WithCheck(IkReal(new_r10),IkReal(x464),IKFAST_ATAN2_MAGTHRESH);
if(!x468.valid){
continue;
}
IkReal gconst6=((-1.0)*(x468.value));
IkReal gconst7=((-1.0)*new_r10*x465);
IkReal gconst8=(x464*x465);
IkReal x469=new_r10*new_r10;
CheckValue<IkReal> x473=IKPowWithIntegerCheck(((-625000001.0)+x469),-1);
if(!x473.valid){
continue;
}
IkReal x470=x473.value;
if((((625000001.0)+(((-1.0)*x469)))) < -0.00001)
continue;
IkReal x471=IKsqrt(((625000001.0)+(((-1.0)*x469))));
IkReal x472=(x470*x471);
j5eval[0]=-1.0;
j5eval[1]=-1.0;
IkReal x474 = ((1.0000000016)+(((-1.6e-9)*x469)));
if(IKabs(x474)==0){
continue;
}
j5eval[2]=((IKabs(((((-625000001.0)*x472))+(((1250000001.0)*x469*x472)))))+(((50000.00004)*(IKabs((new_r00*new_r10*(pow(x474,-0.5))))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x475=((-1.0000000008)*new_r00);
IkReal x477 = ((1.0000000016)+(((-1.6e-9)*(new_r10*new_r10))));
if(IKabs(x477)==0){
continue;
}
IkReal x476=pow(x477,-0.5);
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst7;
cj3=gconst8;
CheckValue<IkReal> x478 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x478.valid){
continue;
}
j3=((-1.0)*(x478.value));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x479 = IKatan2WithCheck(IkReal(new_r10),IkReal(x475),IKFAST_ATAN2_MAGTHRESH);
if(!x479.valid){
continue;
}
IkReal gconst6=((-1.0)*(x479.value));
IkReal gconst7=((-1.0)*new_r10*x476);
IkReal gconst8=(x475*x476);
IkReal x480=new_r10*new_r10;
CheckValue<IkReal> x483=IKPowWithIntegerCheck(((1.0000000016)+(((-1.6e-9)*x480))),-1);
if(!x483.valid){
continue;
}
IkReal x481=x483.value;
IkReal x482=((625000001.0)*x481);
IkReal x484=((1.0)+(((-1.0)*x480)));
j5eval[0]=IKsign((((x482*(x480*x480)))+(((-1.0)*x482*(x484*x484)))));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x485=((-1.0000000008)*new_r00);
IkReal x487 = ((1.0000000016)+(((-1.6e-9)*(new_r10*new_r10))));
if(IKabs(x487)==0){
continue;
}
IkReal x486=pow(x487,-0.5);
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst7;
cj3=gconst8;
CheckValue<IkReal> x488 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x488.valid){
continue;
}
j3=((-1.0)*(x488.value));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x489 = IKatan2WithCheck(IkReal(new_r10),IkReal(x485),IKFAST_ATAN2_MAGTHRESH);
if(!x489.valid){
continue;
}
IkReal gconst6=((-1.0)*(x489.value));
IkReal gconst7=((-1.0)*new_r10*x486);
IkReal gconst8=(x485*x486);
IkReal x490=new_r10*new_r10;
IkReal x491=((1.0000000016)+(((-1.6e-9)*x490)));
CheckValue<IkReal> x492=IKPowWithIntegerCheck(x491,-1);
if(!x492.valid){
continue;
}
j5eval[0]=((-3.20000000256e-9)*x490*(x492.value)*(((1.0)+(((-1.0)*x490)))));
IkReal x493 = x491;
if(IKabs(x493)==0){
continue;
}
j5eval[1]=((1.6e-9)*new_r00*new_r10*(pow(x493,-0.5)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x494=gconst7*gconst7;
IkReal x495=new_r10*new_r10;
IkReal x496=((625000000.0)*new_r00);
IkReal x497=((625000000.5)*gconst8);
IkReal x498=((25000.00002)*gconst8);
IkReal x499=((25000.0)*new_r00);
CheckValue<IkReal> x500=IKPowWithIntegerCheck(((((-625000001.0)*x495*(gconst8*gconst8)))+((new_r00*x494*x496))),-1);
if(!x500.valid){
continue;
}
CheckValue<IkReal> x501=IKPowWithIntegerCheck(((((-1.0)*new_r10*x498))+((gconst7*x499))),-1);
if(!x501.valid){
continue;
}
if( IKabs(((x500.value)*(((((-1.0)*x496*(gconst7*gconst7*gconst7)))+(((-1.0)*new_r10*x494*x497))+((x497*(new_r10*new_r10*new_r10)))+((gconst7*x495*x496)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x501.value)*(((((-1.0)*new_r10*x499))+((gconst7*x498)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x500.value)*(((((-1.0)*x496*(gconst7*gconst7*gconst7)))+(((-1.0)*new_r10*x494*x497))+((x497*(new_r10*new_r10*new_r10)))+((gconst7*x495*x496))))))+IKsqr(((x501.value)*(((((-1.0)*new_r10*x499))+((gconst7*x498))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((x500.value)*(((((-1.0)*x496*(gconst7*gconst7*gconst7)))+(((-1.0)*new_r10*x494*x497))+((x497*(new_r10*new_r10*new_r10)))+((gconst7*x495*x496))))), ((x501.value)*(((((-1.0)*new_r10*x499))+((gconst7*x498))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x502=IKsin(j5);
IkReal x503=IKcos(j5);
IkReal x504=((1.0)*gconst8);
IkReal x505=((1.0000000008)*gconst8);
IkReal x506=(gconst7*x503);
IkReal x507=(new_r00*x503);
IkReal x508=((1.0000000008)*x502);
evalcond[0]=(gconst7+((new_r10*x503))+((new_r00*x502)));
evalcond[1]=(((gconst7*x502))+(((-1.0)*x503*x505))+new_r00);
evalcond[2]=(x506+((x502*x505))+new_r10);
evalcond[3]=((((-1.0)*x502*x504))+(((-1.0000000008)*x506)));
evalcond[4]=(((gconst7*x508))+(((-1.0)*x503*x504)));
evalcond[5]=((((-1.0)*new_r10*x502))+(((-1.0)*x505))+x507);
evalcond[6]=((((-1.0)*x504))+(((1.0000000008)*x507))+(((-1.0)*new_r10*x508)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x509=gconst8*gconst8;
IkReal x510=gconst7*gconst7;
IkReal x511=((625000000.0)*x509);
IkReal x512=((625000000.5)*gconst8*x510);
CheckValue<IkReal> x513 = IKatan2WithCheck(IkReal((((gconst7*new_r00*x511))+(((-1.0)*new_r10*x512)))),IkReal((((new_r00*x512))+(((-625000001.0)*new_r10*(gconst7*gconst7*gconst7))))),IKFAST_ATAN2_MAGTHRESH);
if(!x513.valid){
continue;
}
CheckValue<IkReal> x514=IKPowWithIntegerCheck(IKsign(((((625000001.0)*x510*(new_r10*new_r10)))+(((-1.0)*x511*(new_r00*new_r00))))),-1);
if(!x514.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x513.value)+(((1.5707963267949)*(x514.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x515=IKsin(j5);
IkReal x516=IKcos(j5);
IkReal x517=((1.0)*gconst8);
IkReal x518=((1.0000000008)*gconst8);
IkReal x519=(gconst7*x516);
IkReal x520=(new_r00*x516);
IkReal x521=((1.0000000008)*x515);
evalcond[0]=(((new_r00*x515))+((new_r10*x516))+gconst7);
evalcond[1]=((((-1.0)*x516*x518))+((gconst7*x515))+new_r00);
evalcond[2]=(x519+((x515*x518))+new_r10);
evalcond[3]=((((-1.0000000008)*x519))+(((-1.0)*x515*x517)));
evalcond[4]=(((gconst7*x521))+(((-1.0)*x516*x517)));
evalcond[5]=((((-1.0)*new_r10*x515))+x520+(((-1.0)*x518)));
evalcond[6]=((((1.0000000008)*x520))+(((-1.0)*new_r10*x521))+(((-1.0)*x517)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x522=((25000.00002)*gconst8);
IkReal x523=((25000.0)*gconst7);
CheckValue<IkReal> x524=IKPowWithIntegerCheck(IKsign(((((-25000.0)*(new_r10*new_r10)))+(((-25000.0)*(new_r00*new_r00))))),-1);
if(!x524.valid){
continue;
}
CheckValue<IkReal> x525 = IKatan2WithCheck(IkReal((((new_r10*x522))+((new_r00*x523)))),IkReal(((((-1.0)*new_r00*x522))+((new_r10*x523)))),IKFAST_ATAN2_MAGTHRESH);
if(!x525.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x524.value)))+(x525.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x526=IKsin(j5);
IkReal x527=IKcos(j5);
IkReal x528=((1.0)*gconst8);
IkReal x529=((1.0000000008)*gconst8);
IkReal x530=(gconst7*x527);
IkReal x531=(new_r00*x527);
IkReal x532=((1.0000000008)*x526);
evalcond[0]=(gconst7+((new_r10*x527))+((new_r00*x526)));
evalcond[1]=((((-1.0)*x527*x529))+((gconst7*x526))+new_r00);
evalcond[2]=(((x526*x529))+x530+new_r10);
evalcond[3]=((((-1.0)*x526*x528))+(((-1.0000000008)*x530)));
evalcond[4]=((((-1.0)*x527*x528))+((gconst7*x532)));
evalcond[5]=((((-1.0)*x529))+x531+(((-1.0)*new_r10*x526)));
evalcond[6]=((((1.0000000008)*x531))+(((-1.0)*x528))+(((-1.0)*new_r10*x532)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x534=IKPowWithIntegerCheck(gconst8,-1);
if(!x534.valid){
continue;
}
IkReal x533=x534.value;
if( IKabs((new_r01*x533)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((0.9999999992)*new_r00*x533)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r01*x533))+IKsqr(((0.9999999992)*new_r00*x533))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((new_r01*x533), ((0.9999999992)*new_r00*x533));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x535=IKcos(j5);
IkReal x536=IKsin(j5);
IkReal x537=((1.0)*gconst8);
IkReal x538=((1.0000000008)*gconst8);
IkReal x539=(new_r00*x535);
IkReal x540=(gconst8*x535);
IkReal x541=(new_r01*x535);
evalcond[0]=(new_r00*x536);
evalcond[1]=x541;
evalcond[2]=((-1.0)*x540);
evalcond[3]=(new_r01+(((-1.0)*x536*x537)));
evalcond[4]=(((new_r01*x536))+(((-1.0)*x537)));
evalcond[5]=(x536*x538);
evalcond[6]=((1.0000000008)*x541);
evalcond[7]=((((-1.0)*x535*x538))+new_r00);
evalcond[8]=((((-1.0)*x538))+x539);
evalcond[9]=((((1.0000000008)*x539))+(((-1.0)*x537)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x546=IKPowWithIntegerCheck(new_r00,-1);
if(!x546.valid){
continue;
}
IkReal x542=x546.value;
IkReal x543=gconst7*gconst7;
IkReal x544=((25000.0)*new_r10);
CheckValue<IkReal> x547=IKPowWithIntegerCheck(((((25000.00002)*gconst8*new_r00))+((gconst7*x544))),-1);
if(!x547.valid){
continue;
}
IkReal x545=x547.value;
CheckValue<IkReal> x548=IKPowWithIntegerCheck(x542,-2);
if(!x548.valid){
continue;
}
if( IKabs((((x542*x543*x544*x545))+(((-1.0)*gconst7*x542))+(((-1.0)*new_r00*x544*x545)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x545*(((((25000.0)*(x548.value)))+(((-25000.0)*x543)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((x542*x543*x544*x545))+(((-1.0)*gconst7*x542))+(((-1.0)*new_r00*x544*x545))))+IKsqr((x545*(((((25000.0)*(x548.value)))+(((-25000.0)*x543))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((((x542*x543*x544*x545))+(((-1.0)*gconst7*x542))+(((-1.0)*new_r00*x544*x545))), (x545*(((((25000.0)*(x548.value)))+(((-25000.0)*x543))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x549=IKcos(j5);
IkReal x550=IKsin(j5);
IkReal x551=((1.0)*gconst8);
IkReal x552=((1.0000000008)*gconst7);
IkReal x553=((1.0000000008)*gconst8);
IkReal x554=(new_r11*x550);
IkReal x555=(new_r01*x549);
IkReal x556=(new_r00*x549);
IkReal x557=(new_r10*x550);
evalcond[0]=(gconst7+((new_r10*x549))+((new_r00*x550)));
evalcond[1]=(((new_r11*x549))+(((-1.0)*x551))+((new_r01*x550)));
evalcond[2]=(((gconst7*x550))+(((-1.0)*x549*x553))+new_r00);
evalcond[3]=(((gconst7*x549))+((x550*x553))+new_r10);
evalcond[4]=((((-1.0)*x550*x551))+(((-1.0)*x549*x552))+new_r01);
evalcond[5]=(((x550*x552))+(((-1.0)*x549*x551))+new_r11);
evalcond[6]=((((-1.0)*x557))+(((-1.0)*x553))+x556);
evalcond[7]=((((-1.0)*x554))+(((-1.0)*x552))+x555);
evalcond[8]=((((-1.0000000008)*x557))+(((-1.0)*x551))+(((1.0000000008)*x556)));
evalcond[9]=((((-1.0)*gconst7))+(((-1.0000000008)*x554))+(((1.0000000008)*x555)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x558=gconst7*gconst7;
IkReal x559=new_r10*new_r10;
IkReal x560=((625000000.0)*new_r00);
IkReal x561=((625000000.5)*gconst8);
IkReal x562=((25000.00002)*gconst8);
IkReal x563=((25000.0)*new_r00);
CheckValue<IkReal> x564=IKPowWithIntegerCheck(((((-625000001.0)*x559*(gconst8*gconst8)))+((new_r00*x558*x560))),-1);
if(!x564.valid){
continue;
}
CheckValue<IkReal> x565=IKPowWithIntegerCheck((((gconst7*x563))+(((-1.0)*new_r10*x562))),-1);
if(!x565.valid){
continue;
}
if( IKabs(((x564.value)*((((x561*(new_r10*new_r10*new_r10)))+(((-1.0)*new_r10*x558*x561))+((gconst7*x559*x560))+(((-1.0)*x560*(gconst7*gconst7*gconst7))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x565.value)*((((gconst7*x562))+(((-1.0)*new_r10*x563)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x564.value)*((((x561*(new_r10*new_r10*new_r10)))+(((-1.0)*new_r10*x558*x561))+((gconst7*x559*x560))+(((-1.0)*x560*(gconst7*gconst7*gconst7)))))))+IKsqr(((x565.value)*((((gconst7*x562))+(((-1.0)*new_r10*x563))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((x564.value)*((((x561*(new_r10*new_r10*new_r10)))+(((-1.0)*new_r10*x558*x561))+((gconst7*x559*x560))+(((-1.0)*x560*(gconst7*gconst7*gconst7)))))), ((x565.value)*((((gconst7*x562))+(((-1.0)*new_r10*x563))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x566=IKcos(j5);
IkReal x567=IKsin(j5);
IkReal x568=((1.0)*gconst8);
IkReal x569=((1.0000000008)*gconst7);
IkReal x570=((1.0000000008)*gconst8);
IkReal x571=(new_r11*x567);
IkReal x572=(new_r01*x566);
IkReal x573=(new_r00*x566);
IkReal x574=(new_r10*x567);
evalcond[0]=(gconst7+((new_r00*x567))+((new_r10*x566)));
evalcond[1]=(((new_r01*x567))+((new_r11*x566))+(((-1.0)*x568)));
evalcond[2]=((((-1.0)*x566*x570))+new_r00+((gconst7*x567)));
evalcond[3]=(((x567*x570))+new_r10+((gconst7*x566)));
evalcond[4]=((((-1.0)*x566*x569))+(((-1.0)*x567*x568))+new_r01);
evalcond[5]=((((-1.0)*x566*x568))+((x567*x569))+new_r11);
evalcond[6]=((((-1.0)*x574))+(((-1.0)*x570))+x573);
evalcond[7]=((((-1.0)*x571))+x572+(((-1.0)*x569)));
evalcond[8]=((((-1.0000000008)*x574))+(((1.0000000008)*x573))+(((-1.0)*x568)));
evalcond[9]=((((-1.0000000008)*x571))+(((1.0000000008)*x572))+(((-1.0)*gconst7)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x575=((1.0)*new_r00);
CheckValue<IkReal> x576 = IKatan2WithCheck(IkReal((((gconst8*new_r10))+((gconst7*new_r11)))),IkReal(((((-1.0)*gconst7*new_r01))+(((-1.0)*gconst8*x575)))),IKFAST_ATAN2_MAGTHRESH);
if(!x576.valid){
continue;
}
CheckValue<IkReal> x577=IKPowWithIntegerCheck(IKsign(((((-1.0)*new_r11*x575))+((new_r01*new_r10)))),-1);
if(!x577.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x576.value)+(((1.5707963267949)*(x577.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x578=IKcos(j5);
IkReal x579=IKsin(j5);
IkReal x580=((1.0)*gconst8);
IkReal x581=((1.0000000008)*gconst7);
IkReal x582=((1.0000000008)*gconst8);
IkReal x583=(new_r11*x579);
IkReal x584=(new_r01*x578);
IkReal x585=(new_r00*x578);
IkReal x586=(new_r10*x579);
evalcond[0]=(((new_r00*x579))+((new_r10*x578))+gconst7);
evalcond[1]=(((new_r11*x578))+((new_r01*x579))+(((-1.0)*x580)));
evalcond[2]=((((-1.0)*x578*x582))+((gconst7*x579))+new_r00);
evalcond[3]=(((x579*x582))+((gconst7*x578))+new_r10);
evalcond[4]=((((-1.0)*x578*x581))+(((-1.0)*x579*x580))+new_r01);
evalcond[5]=(((x579*x581))+(((-1.0)*x578*x580))+new_r11);
evalcond[6]=((((-1.0)*x586))+x585+(((-1.0)*x582)));
evalcond[7]=((((-1.0)*x583))+x584+(((-1.0)*x581)));
evalcond[8]=((((1.0000000008)*x585))+(((-1.0)*x580))+(((-1.0000000008)*x586)));
evalcond[9]=((((1.0000000008)*x584))+(((-1.0)*gconst7))+(((-1.0000000008)*x583)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x588 = ((((1.0000000016)*(new_r00*new_r00)))+(new_r10*new_r10));
if(IKabs(x588)==0){
continue;
}
IkReal x587=pow(x588,-0.5);
CheckValue<IkReal> x589 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x589.valid){
continue;
}
IkReal gconst9=((3.14159265358979)+(((-1.0)*(x589.value))));
IkReal gconst10=((1.0)*new_r10*x587);
IkReal gconst11=((1.0000000008)*new_r00*x587);
CheckValue<IkReal> x590 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x590.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+(x590.value)+j3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[2];
IkReal x591=x587;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst10;
cj3=gconst11;
CheckValue<IkReal> x592 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x592.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x592.value))));
CheckValue<IkReal> x593 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x593.valid){
continue;
}
IkReal gconst9=((3.14159265358979)+(((-1.0)*(x593.value))));
IkReal gconst10=((1.0)*new_r10*x591);
IkReal gconst11=((1.0000000008)*new_r00*x591);
IkReal x594=(((new_r01*new_r10))+(((-1.0)*new_r00*new_r11)));
j5eval[0]=x594;
j5eval[1]=IKsign(x594);
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x595=x587;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst10;
cj3=gconst11;
CheckValue<IkReal> x596 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x596.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x596.value))));
CheckValue<IkReal> x597 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x597.valid){
continue;
}
IkReal gconst9=((3.14159265358979)+(((-1.0)*(x597.value))));
IkReal gconst10=((1.0)*new_r10*x595);
IkReal gconst11=((1.0000000008)*new_r00*x595);
IkReal x598=new_r00*new_r00;
IkReal x599=new_r10*new_r10;
IkReal x600=((((1.0000000016)*x598))+x599);
CheckValue<IkReal> x601=IKPowWithIntegerCheck(x600,-1);
if(!x601.valid){
continue;
}
j5eval[0]=((-3.20000004272458e-9)*x598*x599*(x601.value));
IkReal x602 = x600;
if(IKabs(x602)==0){
continue;
}
j5eval[1]=((-1.60000013238459e-9)*new_r00*new_r10*(pow(x602,-0.5)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x603=x587;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst10;
cj3=gconst11;
CheckValue<IkReal> x604 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x604.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x604.value))));
CheckValue<IkReal> x605 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x605.valid){
continue;
}
IkReal gconst9=((3.14159265358979)+(((-1.0)*(x605.value))));
IkReal gconst10=((1.0)*new_r10*x603);
IkReal gconst11=((1.0000000008)*new_r00*x603);
j5eval[0]=new_r00;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(new_r00);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
CheckValue<IkReal> x607 = IKatan2WithCheck(IkReal(new_r10),IkReal(0),IKFAST_ATAN2_MAGTHRESH);
if(!x607.valid){
continue;
}
IkReal x606=((1.0)*(x607.value));
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst10;
cj3=gconst11;
j3=((3.14159265)+(((-1.0)*x606)));
new_r00=0;
IkReal gconst9=((3.14159265358979)+(((-1.0)*x606)));
IkReal x608 = new_r10*new_r10;
if(IKabs(x608)==0){
continue;
}
IkReal gconst10=((1.0)*new_r10*(pow(x608,-0.5)));
IkReal gconst11=0;
j5eval[0]=new_r10;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x610=IKPowWithIntegerCheck(gconst10,-1);
if(!x610.valid){
continue;
}
IkReal x609=x610.value;
if( IKabs(((-0.9999999992)*new_r11*x609)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10*x609)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-0.9999999992)*new_r11*x609))+IKsqr(((-1.0)*new_r10*x609))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-0.9999999992)*new_r11*x609), ((-1.0)*new_r10*x609));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x611=IKsin(j5);
IkReal x612=IKcos(j5);
IkReal x613=(gconst10*x612);
IkReal x614=(gconst10*x611);
IkReal x615=(new_r01*x612);
IkReal x616=(new_r11*x611);
IkReal x617=(new_r10*x611);
evalcond[0]=x614;
evalcond[1]=((-1.0)*x617);
evalcond[2]=(gconst10+((new_r10*x612)));
evalcond[3]=(x613+new_r10);
evalcond[4]=((-1.0000000008)*x617);
evalcond[5]=(((new_r11*x612))+((new_r01*x611)));
evalcond[6]=((((-1.0000000008)*x613))+new_r01);
evalcond[7]=(new_r11+(((1.0000000008)*x614)));
evalcond[8]=((((-1.0000000008)*gconst10))+(((-1.0)*x616))+x615);
evalcond[9]=((((-1.0000000008)*x616))+(((-1.0)*gconst10))+(((1.0000000008)*x615)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x618=IKPowWithIntegerCheck(gconst10,-1);
if(!x618.valid){
continue;
}
CheckValue<IkReal> x619=IKPowWithIntegerCheck(new_r10,-1);
if(!x619.valid){
continue;
}
if( IKabs(((-0.9999999992)*new_r11*(x618.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*gconst10*(x619.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-0.9999999992)*new_r11*(x618.value)))+IKsqr(((-1.0)*gconst10*(x619.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-0.9999999992)*new_r11*(x618.value)), ((-1.0)*gconst10*(x619.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x620=IKsin(j5);
IkReal x621=IKcos(j5);
IkReal x622=(gconst10*x621);
IkReal x623=(gconst10*x620);
IkReal x624=(new_r01*x621);
IkReal x625=(new_r11*x620);
IkReal x626=(new_r10*x620);
evalcond[0]=x623;
evalcond[1]=((-1.0)*x626);
evalcond[2]=(gconst10+((new_r10*x621)));
evalcond[3]=(x622+new_r10);
evalcond[4]=((-1.0000000008)*x626);
evalcond[5]=(((new_r01*x620))+((new_r11*x621)));
evalcond[6]=((((-1.0000000008)*x622))+new_r01);
evalcond[7]=((((1.0000000008)*x623))+new_r11);
evalcond[8]=((((-1.0000000008)*gconst10))+x624+(((-1.0)*x625)));
evalcond[9]=((((1.0000000008)*x624))+(((-1.0000000008)*x625))+(((-1.0)*gconst10)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
IkReal x628 = ((1.0000000016)+(((-1.6e-9)*(new_r10*new_r10))));
if(IKabs(x628)==0){
continue;
}
IkReal x627=pow(x628,-0.5);
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst10;
cj3=gconst11;
CheckValue<IkReal> x629 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x629.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x629.value))));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x630 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x630.valid){
continue;
}
IkReal gconst9=((3.14159265358979)+(((-1.0)*(x630.value))));
IkReal gconst10=((1.0)*new_r10*x627);
IkReal gconst11=((1.0000000008)*new_r00*x627);
IkReal x631=new_r10*new_r10;
CheckValue<IkReal> x635=IKPowWithIntegerCheck(((-3.90625000625e+17)+(((625000000.0)*x631))),-1);
if(!x635.valid){
continue;
}
IkReal x632=x635.value;
if((((625000001.0)+(((-1.0)*x631)))) < -0.00001)
continue;
IkReal x633=IKsqrt(((625000001.0)+(((-1.0)*x631))));
IkReal x634=(x632*x633);
j5eval[0]=-1.0;
j5eval[1]=-1.0;
IkReal x636 = ((1.0000000016)+(((-1.6e-9)*x631)));
if(IKabs(x636)==0){
continue;
}
j5eval[2]=((IKabs(((((-7.81250000625e+17)*x631*x634))+(((3.90625000625e+17)*x634)))))+(IKabs(((50000.00004)*new_r00*new_r10*(pow(x636,-0.5))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x638 = ((1.0000000016)+(((-1.6e-9)*(new_r10*new_r10))));
if(IKabs(x638)==0){
continue;
}
IkReal x637=pow(x638,-0.5);
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst10;
cj3=gconst11;
CheckValue<IkReal> x639 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x639.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x639.value))));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x640 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x640.valid){
continue;
}
IkReal gconst9=((3.14159265358979)+(((-1.0)*(x640.value))));
IkReal gconst10=((1.0)*new_r10*x637);
IkReal gconst11=((1.0000000008)*new_r00*x637);
IkReal x641=new_r10*new_r10;
CheckValue<IkReal> x643=IKPowWithIntegerCheck(((1.0000000016)+(((-1.6e-9)*x641))),-1);
if(!x643.valid){
continue;
}
IkReal x642=x643.value;
IkReal x644=((1.0)+(((-1.0)*x641)));
j5eval[0]=IKsign(((((625000001.0)*x642*(x641*x641)))+(((-625000001.0)*x642*(x644*x644)))));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x646 = ((1.0000000016)+(((-1.6e-9)*(new_r10*new_r10))));
if(IKabs(x646)==0){
continue;
}
IkReal x645=pow(x646,-0.5);
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst10;
cj3=gconst11;
CheckValue<IkReal> x647 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x647.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x647.value))));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x648 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x648.valid){
continue;
}
IkReal gconst9=((3.14159265358979)+(((-1.0)*(x648.value))));
IkReal gconst10=((1.0)*new_r10*x645);
IkReal gconst11=((1.0000000008)*new_r00*x645);
IkReal x649=new_r10*new_r10;
IkReal x650=((1.0000000016)+(((-1.6e-9)*x649)));
CheckValue<IkReal> x651=IKPowWithIntegerCheck(x650,-1);
if(!x651.valid){
continue;
}
j5eval[0]=((-3.20000004272458e-9)*x649*(x651.value)*(((1.0)+(((-1.0)*x649)))));
IkReal x652 = x650;
if(IKabs(x652)==0){
continue;
}
j5eval[1]=((-1.60000013238459e-9)*new_r00*new_r10*(pow(x652,-0.5)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x653=gconst10*gconst10;
IkReal x654=new_r10*new_r10;
IkReal x655=((25000.00002)*gconst11);
IkReal x656=(gconst10*new_r00);
IkReal x657=((625000000.5)*gconst11);
CheckValue<IkReal> x658=IKPowWithIntegerCheck(((((625000000.0)*x653*(new_r00*new_r00)))+(((-625000001.0)*x654*(gconst11*gconst11)))),-1);
if(!x658.valid){
continue;
}
CheckValue<IkReal> x659=IKPowWithIntegerCheck(((((-1.0)*new_r10*x655))+(((25000.0)*x656))),-1);
if(!x659.valid){
continue;
}
if( IKabs(((x658.value)*((((x657*(new_r10*new_r10*new_r10)))+(((625000000.0)*x654*x656))+(((-625000000.0)*x656*(gconst10*gconst10)))+(((-1.0)*new_r10*x653*x657)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x659.value)*(((((-25000.0)*new_r00*new_r10))+((gconst10*x655)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x658.value)*((((x657*(new_r10*new_r10*new_r10)))+(((625000000.0)*x654*x656))+(((-625000000.0)*x656*(gconst10*gconst10)))+(((-1.0)*new_r10*x653*x657))))))+IKsqr(((x659.value)*(((((-25000.0)*new_r00*new_r10))+((gconst10*x655))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((x658.value)*((((x657*(new_r10*new_r10*new_r10)))+(((625000000.0)*x654*x656))+(((-625000000.0)*x656*(gconst10*gconst10)))+(((-1.0)*new_r10*x653*x657))))), ((x659.value)*(((((-25000.0)*new_r00*new_r10))+((gconst10*x655))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x660=IKsin(j5);
IkReal x661=IKcos(j5);
IkReal x662=(gconst11*x661);
IkReal x663=((1.0000000008)*x660);
IkReal x664=(gconst10*x661);
IkReal x665=((1.0)*x660);
IkReal x666=(new_r00*x661);
evalcond[0]=(gconst10+((new_r10*x661))+((new_r00*x660)));
evalcond[1]=((((-1.0000000008)*x662))+new_r00+((gconst10*x660)));
evalcond[2]=(x664+new_r10+((gconst11*x663)));
evalcond[3]=((((-1.0000000008)*x664))+(((-1.0)*gconst11*x665)));
evalcond[4]=((((-1.0)*x662))+((gconst10*x663)));
evalcond[5]=((((-1.0)*new_r10*x665))+(((-1.0000000008)*gconst11))+x666);
evalcond[6]=((((1.0000000008)*x666))+(((-1.0)*new_r10*x663))+(((-1.0)*gconst11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x667=gconst10*gconst10;
IkReal x668=gconst11*gconst11;
IkReal x669=((625000000.0)*x668);
IkReal x670=((625000000.5)*gconst11*x667);
CheckValue<IkReal> x671 = IKatan2WithCheck(IkReal((((gconst10*new_r00*x669))+(((-1.0)*new_r10*x670)))),IkReal((((new_r00*x670))+(((-625000001.0)*new_r10*(gconst10*gconst10*gconst10))))),IKFAST_ATAN2_MAGTHRESH);
if(!x671.valid){
continue;
}
CheckValue<IkReal> x672=IKPowWithIntegerCheck(IKsign(((((625000001.0)*x667*(new_r10*new_r10)))+(((-1.0)*x669*(new_r00*new_r00))))),-1);
if(!x672.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x671.value)+(((1.5707963267949)*(x672.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x673=IKsin(j5);
IkReal x674=IKcos(j5);
IkReal x675=(gconst11*x674);
IkReal x676=((1.0000000008)*x673);
IkReal x677=(gconst10*x674);
IkReal x678=((1.0)*x673);
IkReal x679=(new_r00*x674);
evalcond[0]=(((new_r00*x673))+((new_r10*x674))+gconst10);
evalcond[1]=(((gconst10*x673))+new_r00+(((-1.0000000008)*x675)));
evalcond[2]=(((gconst11*x676))+x677+new_r10);
evalcond[3]=((((-1.0)*gconst11*x678))+(((-1.0000000008)*x677)));
evalcond[4]=(((gconst10*x676))+(((-1.0)*x675)));
evalcond[5]=((((-1.0000000008)*gconst11))+x679+(((-1.0)*new_r10*x678)));
evalcond[6]=((((1.0000000008)*x679))+(((-1.0)*gconst11))+(((-1.0)*new_r10*x676)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x680=((25000.00002)*gconst11);
IkReal x681=((25000.0)*gconst10);
CheckValue<IkReal> x682=IKPowWithIntegerCheck(IKsign(((((-25000.0)*(new_r10*new_r10)))+(((-25000.0)*(new_r00*new_r00))))),-1);
if(!x682.valid){
continue;
}
CheckValue<IkReal> x683 = IKatan2WithCheck(IkReal((((new_r00*x681))+((new_r10*x680)))),IkReal((((new_r10*x681))+(((-1.0)*new_r00*x680)))),IKFAST_ATAN2_MAGTHRESH);
if(!x683.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x682.value)))+(x683.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x684=IKsin(j5);
IkReal x685=IKcos(j5);
IkReal x686=(gconst11*x685);
IkReal x687=((1.0000000008)*x684);
IkReal x688=(gconst10*x685);
IkReal x689=((1.0)*x684);
IkReal x690=(new_r00*x685);
evalcond[0]=(gconst10+((new_r00*x684))+((new_r10*x685)));
evalcond[1]=(((gconst10*x684))+(((-1.0000000008)*x686))+new_r00);
evalcond[2]=(((gconst11*x687))+x688+new_r10);
evalcond[3]=((((-1.0)*gconst11*x689))+(((-1.0000000008)*x688)));
evalcond[4]=(((gconst10*x687))+(((-1.0)*x686)));
evalcond[5]=((((-1.0)*new_r10*x689))+(((-1.0000000008)*gconst11))+x690);
evalcond[6]=((((-1.0)*new_r10*x687))+(((1.0000000008)*x690))+(((-1.0)*gconst11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x692=IKPowWithIntegerCheck(gconst11,-1);
if(!x692.valid){
continue;
}
IkReal x691=x692.value;
if( IKabs((new_r01*x691)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((0.9999999992)*new_r00*x691)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r01*x691))+IKsqr(((0.9999999992)*new_r00*x691))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((new_r01*x691), ((0.9999999992)*new_r00*x691));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x693=IKcos(j5);
IkReal x694=IKsin(j5);
IkReal x695=((1.0)*gconst11);
IkReal x696=((1.0000000008)*gconst11);
IkReal x697=(new_r00*x693);
IkReal x698=(new_r01*x693);
evalcond[0]=(new_r00*x694);
evalcond[1]=x698;
evalcond[2]=((-1.0)*gconst11*x693);
evalcond[3]=((((-1.0)*x694*x695))+new_r01);
evalcond[4]=((((-1.0)*x695))+((new_r01*x694)));
evalcond[5]=(x694*x696);
evalcond[6]=((1.0000000008)*x698);
evalcond[7]=((((-1.0)*x693*x696))+new_r00);
evalcond[8]=(x697+(((-1.0)*x696)));
evalcond[9]=((((-1.0)*x695))+(((1.0000000008)*x697)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x704=IKPowWithIntegerCheck(new_r00,-1);
if(!x704.valid){
continue;
}
IkReal x699=x704.value;
IkReal x700=gconst10*gconst10;
IkReal x701=((25000.0)*new_r10);
IkReal x702=((25000.0)*x700);
CheckValue<IkReal> x705=IKPowWithIntegerCheck((((gconst10*x701))+(((25000.00002)*gconst11*new_r00))),-1);
if(!x705.valid){
continue;
}
IkReal x703=x705.value;
CheckValue<IkReal> x706=IKPowWithIntegerCheck(x699,-2);
if(!x706.valid){
continue;
}
if( IKabs((((x699*x700*x701*x703))+(((-1.0)*new_r00*x701*x703))+(((-1.0)*gconst10*x699)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x703*(((((25000.0)*(x706.value)))+(((-1.0)*x702)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((x699*x700*x701*x703))+(((-1.0)*new_r00*x701*x703))+(((-1.0)*gconst10*x699))))+IKsqr((x703*(((((25000.0)*(x706.value)))+(((-1.0)*x702))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((((x699*x700*x701*x703))+(((-1.0)*new_r00*x701*x703))+(((-1.0)*gconst10*x699))), (x703*(((((25000.0)*(x706.value)))+(((-1.0)*x702))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x707=IKcos(j5);
IkReal x708=IKsin(j5);
IkReal x709=((1.0)*gconst11);
IkReal x710=((1.0000000008)*gconst11);
IkReal x711=((1.0000000008)*gconst10);
IkReal x712=(new_r11*x708);
IkReal x713=(new_r01*x707);
IkReal x714=(new_r00*x707);
IkReal x715=(gconst10*x707);
IkReal x716=(new_r10*x708);
evalcond[0]=(((new_r00*x708))+gconst10+((new_r10*x707)));
evalcond[1]=(((new_r01*x708))+(((-1.0)*x709))+((new_r11*x707)));
evalcond[2]=((((-1.0)*x707*x710))+((gconst10*x708))+new_r00);
evalcond[3]=(x715+new_r10+((x708*x710)));
evalcond[4]=((((-1.0)*x707*x711))+new_r01+(((-1.0)*x708*x709)));
evalcond[5]=((((-1.0)*x707*x709))+new_r11+((x708*x711)));
evalcond[6]=((((-1.0)*x716))+(((-1.0)*x710))+x714);
evalcond[7]=((((-1.0)*x712))+(((-1.0)*x711))+x713);
evalcond[8]=((((1.0000000008)*x714))+(((-1.0)*x709))+(((-1.0000000008)*x716)));
evalcond[9]=((((1.0000000008)*x713))+(((-1.0000000008)*x712))+(((-1.0)*gconst10)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x717=gconst10*gconst10;
IkReal x718=new_r10*new_r10;
IkReal x719=((25000.00002)*gconst11);
IkReal x720=(gconst10*new_r00);
IkReal x721=((625000000.5)*gconst11);
CheckValue<IkReal> x722=IKPowWithIntegerCheck(((((625000000.0)*x717*(new_r00*new_r00)))+(((-625000001.0)*x718*(gconst11*gconst11)))),-1);
if(!x722.valid){
continue;
}
CheckValue<IkReal> x723=IKPowWithIntegerCheck(((((25000.0)*x720))+(((-1.0)*new_r10*x719))),-1);
if(!x723.valid){
continue;
}
if( IKabs(((x722.value)*(((((625000000.0)*x718*x720))+((x721*(new_r10*new_r10*new_r10)))+(((-1.0)*new_r10*x717*x721))+(((-625000000.0)*x720*(gconst10*gconst10))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x723.value)*(((((-25000.0)*new_r00*new_r10))+((gconst10*x719)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x722.value)*(((((625000000.0)*x718*x720))+((x721*(new_r10*new_r10*new_r10)))+(((-1.0)*new_r10*x717*x721))+(((-625000000.0)*x720*(gconst10*gconst10)))))))+IKsqr(((x723.value)*(((((-25000.0)*new_r00*new_r10))+((gconst10*x719))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((x722.value)*(((((625000000.0)*x718*x720))+((x721*(new_r10*new_r10*new_r10)))+(((-1.0)*new_r10*x717*x721))+(((-625000000.0)*x720*(gconst10*gconst10)))))), ((x723.value)*(((((-25000.0)*new_r00*new_r10))+((gconst10*x719))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x724=IKcos(j5);
IkReal x725=IKsin(j5);
IkReal x726=((1.0)*gconst11);
IkReal x727=((1.0000000008)*gconst11);
IkReal x728=((1.0000000008)*gconst10);
IkReal x729=(new_r11*x725);
IkReal x730=(new_r01*x724);
IkReal x731=(new_r00*x724);
IkReal x732=(gconst10*x724);
IkReal x733=(new_r10*x725);
evalcond[0]=(((new_r00*x725))+gconst10+((new_r10*x724)));
evalcond[1]=(((new_r01*x725))+(((-1.0)*x726))+((new_r11*x724)));
evalcond[2]=((((-1.0)*x724*x727))+((gconst10*x725))+new_r00);
evalcond[3]=(((x725*x727))+x732+new_r10);
evalcond[4]=((((-1.0)*x724*x728))+(((-1.0)*x725*x726))+new_r01);
evalcond[5]=((((-1.0)*x724*x726))+((x725*x728))+new_r11);
evalcond[6]=((((-1.0)*x733))+(((-1.0)*x727))+x731);
evalcond[7]=((((-1.0)*x728))+(((-1.0)*x729))+x730);
evalcond[8]=((((1.0000000008)*x731))+(((-1.0)*x726))+(((-1.0000000008)*x733)));
evalcond[9]=((((1.0000000008)*x730))+(((-1.0000000008)*x729))+(((-1.0)*gconst10)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x734=((1.0)*new_r00);
CheckValue<IkReal> x735=IKPowWithIntegerCheck(IKsign((((new_r01*new_r10))+(((-1.0)*new_r11*x734)))),-1);
if(!x735.valid){
continue;
}
CheckValue<IkReal> x736 = IKatan2WithCheck(IkReal((((gconst10*new_r11))+((gconst11*new_r10)))),IkReal(((((-1.0)*gconst11*x734))+(((-1.0)*gconst10*new_r01)))),IKFAST_ATAN2_MAGTHRESH);
if(!x736.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x735.value)))+(x736.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x737=IKcos(j5);
IkReal x738=IKsin(j5);
IkReal x739=((1.0)*gconst11);
IkReal x740=((1.0000000008)*gconst11);
IkReal x741=((1.0000000008)*gconst10);
IkReal x742=(new_r11*x738);
IkReal x743=(new_r01*x737);
IkReal x744=(new_r00*x737);
IkReal x745=(gconst10*x737);
IkReal x746=(new_r10*x738);
evalcond[0]=(gconst10+((new_r00*x738))+((new_r10*x737)));
evalcond[1]=(((new_r01*x738))+(((-1.0)*x739))+((new_r11*x737)));
evalcond[2]=((((-1.0)*x737*x740))+((gconst10*x738))+new_r00);
evalcond[3]=(((x738*x740))+x745+new_r10);
evalcond[4]=((((-1.0)*x737*x741))+new_r01+(((-1.0)*x738*x739)));
evalcond[5]=(((x738*x741))+(((-1.0)*x737*x739))+new_r11);
evalcond[6]=((((-1.0)*x746))+x744+(((-1.0)*x740)));
evalcond[7]=((((-1.0)*x742))+x743+(((-1.0)*x741)));
evalcond[8]=((((-1.0000000008)*x746))+(((-1.0)*x739))+(((1.0000000008)*x744)));
evalcond[9]=((((-1.0000000008)*x742))+(((1.0000000008)*x743))+(((-1.0)*gconst10)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x747=new_r00*new_r00;
CheckValue<IkReal> x748=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x747))),-1);
if(!x748.valid){
continue;
}
if((((-1.0)*x747*(x748.value))) < -0.00001)
continue;
IkReal gconst12=IKsqrt(((-1.0)*x747*(x748.value)));
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.0)+(IKsign(sj3)))))+(IKabs((cj3+(((-1.0)*gconst12)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[2];
IkReal x749=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
sj3=IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))));
cj3=gconst12;
if( (gconst12) < -1-IKFAST_SINCOS_THRESH || (gconst12) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=IKacos(gconst12);
CheckValue<IkReal> x750=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x749))),-1);
if(!x750.valid){
continue;
}
if((((-1.0)*x749*(x750.value))) < -0.00001)
continue;
IkReal gconst12=IKsqrt(((-1.0)*x749*(x750.value)));
IkReal x751=(new_r00*new_r01);
IkReal x752=(new_r10*new_r11);
j5eval[0]=(x751+x752);
j5eval[1]=IKsign(((((25000.0)*x752))+(((25000.0)*x751))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x753=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
sj3=IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))));
cj3=gconst12;
if( (gconst12) < -1-IKFAST_SINCOS_THRESH || (gconst12) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=IKacos(gconst12);
CheckValue<IkReal> x754=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x753))),-1);
if(!x754.valid){
continue;
}
if((((-1.0)*x753*(x754.value))) < -0.00001)
continue;
IkReal gconst12=IKsqrt(((-1.0)*x753*(x754.value)));
IkReal x755=(((new_r01*new_r10))+(((-1.0)*new_r00*new_r11)));
j5eval[0]=x755;
j5eval[1]=IKsign(x755);
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x756=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
sj3=IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))));
cj3=gconst12;
if( (gconst12) < -1-IKFAST_SINCOS_THRESH || (gconst12) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=IKacos(gconst12);
CheckValue<IkReal> x757=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x756))),-1);
if(!x757.valid){
continue;
}
if((((-1.0)*x756*(x757.value))) < -0.00001)
continue;
IkReal gconst12=IKsqrt(((-1.0)*x756*(x757.value)));
j5eval[0]=new_r01;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[2];
IkReal x758=new_r10*new_r10;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
sj3=IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))));
cj3=gconst12;
if( (gconst12) < -1-IKFAST_SINCOS_THRESH || (gconst12) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=IKacos(gconst12);
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x759=IKPowWithIntegerCheck(((-1.0)+(((-1.6e-9)*x758))),-1);
if(!x759.valid){
continue;
}
if((((x759.value)*(((-1.0)+(((1.0)*x758)))))) < -0.00001)
continue;
IkReal gconst12=IKsqrt(((x759.value)*(((-1.0)+(((1.0)*x758))))));
j5eval[0]=-1.0;
j5eval[1]=-1.0;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x760=gconst12*gconst12;
IkReal x761=new_r00*new_r00;
IkReal x762=(gconst12*new_r10);
IkReal x763=((1.0)+(((-1.0)*x760)));
IkReal x764=((3.90625000625e+17)*x760);
if((x763) < -0.00001)
continue;
IkReal x765=IKsqrt(x763);
IkReal x766=(new_r00*x765);
CheckValue<IkReal> x767=IKPowWithIntegerCheck(((((-1.0)*x764*(new_r10*new_r10)))+(((3.90625e+17)*x761*(pow(x763,1.0))))),-1);
if(!x767.valid){
continue;
}
CheckValue<IkReal> x768=IKPowWithIntegerCheck(((((-25000.00002)*x762))+(((25000.0)*x766))),-1);
if(!x768.valid){
continue;
}
if( IKabs(((x767.value)*(((((-3.906250003125e+17)*x761*x762))+(((3.906250009375e+17)*x762*(gconst12*gconst12)))+(((-3.90625e+17)*x766*(new_r00*new_r00)))+((x764*x766)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x768.value)*(((((-25000.0)*new_r00*new_r10))+(((25000.00002)*gconst12*x765)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x767.value)*(((((-3.906250003125e+17)*x761*x762))+(((3.906250009375e+17)*x762*(gconst12*gconst12)))+(((-3.90625e+17)*x766*(new_r00*new_r00)))+((x764*x766))))))+IKsqr(((x768.value)*(((((-25000.0)*new_r00*new_r10))+(((25000.00002)*gconst12*x765))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((x767.value)*(((((-3.906250003125e+17)*x761*x762))+(((3.906250009375e+17)*x762*(gconst12*gconst12)))+(((-3.90625e+17)*x766*(new_r00*new_r00)))+((x764*x766))))), ((x768.value)*(((((-25000.0)*new_r00*new_r10))+(((25000.00002)*gconst12*x765))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x769=IKcos(j5);
IkReal x770=IKsin(j5);
IkReal x771=((1.0)*gconst12);
IkReal x772=((1.0000000008)*gconst12);
IkReal x773=((1.0000000008)*x770);
IkReal x774=(new_r00*x769);
if((((1.0)+(((-1.0)*gconst12*x771)))) < -0.00001)
continue;
IkReal x775=IKsqrt(((1.0)+(((-1.0)*gconst12*x771))));
IkReal x776=(x769*x775);
evalcond[0]=((((-1.0)*new_r10*x770))+x774+(((-1.0)*x772)));
evalcond[1]=(((new_r10*x769))+((new_r00*x770))+x775);
evalcond[2]=((((-1.0)*new_r10*x773))+(((1.0000000008)*x774))+(((-1.0)*x771)));
evalcond[3]=(((x770*x775))+(((-1.0)*x769*x772))+new_r00);
evalcond[4]=(((x770*x772))+x776+new_r10);
evalcond[5]=((((-1.0000000008)*x776))+(((-1.0)*x770*x771)));
evalcond[6]=(((x773*x775))+(((-1.0)*x769*x771)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
IkReal x777=IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))));
IkReal x778=((25000.0)*x777);
CheckValue<IkReal> x779=IKPowWithIntegerCheck(IKsign(((((-25000.0)*(new_r10*new_r10)))+(((-25000.0)*(new_r00*new_r00))))),-1);
if(!x779.valid){
continue;
}
CheckValue<IkReal> x780 = IKatan2WithCheck(IkReal(((((25000.00002)*gconst12*new_r10))+((new_r00*x778)))),IkReal(((((-25000.00002)*gconst12*new_r00))+((new_r10*x778)))),IKFAST_ATAN2_MAGTHRESH);
if(!x780.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x779.value)))+(x780.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x781=IKcos(j5);
IkReal x782=IKsin(j5);
IkReal x783=((1.0)*gconst12);
IkReal x784=((1.0000000008)*gconst12);
IkReal x785=((1.0000000008)*x782);
IkReal x786=(new_r00*x781);
IkReal x787=x777;
IkReal x788=(x781*x787);
evalcond[0]=((((-1.0)*x784))+x786+(((-1.0)*new_r10*x782)));
evalcond[1]=(((new_r10*x781))+((new_r00*x782))+x787);
evalcond[2]=((((-1.0)*x783))+(((-1.0)*new_r10*x785))+(((1.0000000008)*x786)));
evalcond[3]=(((x782*x787))+(((-1.0)*x781*x784))+new_r00);
evalcond[4]=(((x782*x784))+x788+new_r10);
evalcond[5]=((((-1.0)*x782*x783))+(((-1.0000000008)*x788)));
evalcond[6]=(((x785*x787))+(((-1.0)*x781*x783)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(new_r01);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
IkReal x789=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
sj3=IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))));
cj3=gconst12;
if( (gconst12) < -1-IKFAST_SINCOS_THRESH || (gconst12) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=IKacos(gconst12);
new_r01=0;
CheckValue<IkReal> x790=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x789))),-1);
if(!x790.valid){
continue;
}
if((((-1.0)*x789*(x790.value))) < -0.00001)
continue;
IkReal gconst12=IKsqrt(((-1.0)*x789*(x790.value)));
IkReal x791=new_r10*new_r10;
IkReal x792=new_r00*new_r00;
IkReal x793=((1.0)*x792);
j5eval[0]=new_r11;
j5eval[1]=IKsign(new_r11);
CheckValue<IkReal> x794=IKPowWithIntegerCheck(((((625000000.0)*x792))+(((625000001.0)*x791))),-1);
if(!x794.valid){
continue;
}
CheckValue<IkReal> x795=IKPowWithIntegerCheck(((((-1.0000000016)*x791))+(((-1.0)*x792))),-1);
if(!x795.valid){
continue;
}
j5eval[2]=((((625000002.0)*(pow(x791,1.0))*(pow(x794.value,1.0))))+(((-1.0)*x793*(x795.value))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x796=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
sj3=IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))));
cj3=gconst12;
if( (gconst12) < -1-IKFAST_SINCOS_THRESH || (gconst12) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=IKacos(gconst12);
new_r01=0;
CheckValue<IkReal> x797=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x796))),-1);
if(!x797.valid){
continue;
}
if((((-1.0)*x796*(x797.value))) < -0.00001)
continue;
IkReal gconst12=IKsqrt(((-1.0)*x796*(x797.value)));
j5eval[0]=new_r10;
j5eval[1]=new_r11;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x798=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
sj3=IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))));
cj3=gconst12;
if( (gconst12) < -1-IKFAST_SINCOS_THRESH || (gconst12) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=IKacos(gconst12);
new_r01=0;
CheckValue<IkReal> x799=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x798))),-1);
if(!x799.valid){
continue;
}
if((((-1.0)*x798*(x799.value))) < -0.00001)
continue;
IkReal gconst12=IKsqrt(((-1.0)*x798*(x799.value)));
j5eval[0]=new_r00;
j5eval[1]=new_r11;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x801=IKPowWithIntegerCheck(new_r11,-1);
if(!x801.valid){
continue;
}
IkReal x800=x801.value;
CheckValue<IkReal> x802=IKPowWithIntegerCheck(new_r00,-1);
if(!x802.valid){
continue;
}
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
if( IKabs((x800*(x802.value)*(((((-1.0)*new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12))))))))+(((-1.0)*gconst12*new_r10)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((gconst12*x800)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x800*(x802.value)*(((((-1.0)*new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12))))))))+(((-1.0)*gconst12*new_r10))))))+IKsqr((gconst12*x800))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((x800*(x802.value)*(((((-1.0)*new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12))))))))+(((-1.0)*gconst12*new_r10))))), (gconst12*x800));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x803=IKcos(j5);
IkReal x804=IKsin(j5);
IkReal x805=((1.0)*gconst12);
IkReal x806=(gconst12*x803);
IkReal x807=(new_r11*x804);
IkReal x808=(new_r00*x803);
IkReal x809=(gconst12*x804);
IkReal x810=(new_r10*x804);
if((((1.0)+(((-1.0)*gconst12*x805)))) < -0.00001)
continue;
IkReal x811=IKsqrt(((1.0)+(((-1.0)*gconst12*x805))));
IkReal x812=(x804*x811);
IkReal x813=(x803*x811);
evalcond[0]=(((new_r11*x803))+(((-1.0)*x805)));
evalcond[1]=((((-1.0000000008)*gconst12))+(((-1.0)*x810))+x808);
evalcond[2]=(((new_r00*x804))+((new_r10*x803))+x811);
evalcond[3]=((((-1.0)*x807))+(((-1.0000000008)*x811)));
evalcond[4]=((((-1.0000000008)*x807))+(((-1.0)*x811)));
evalcond[5]=((((1.0000000008)*x808))+(((-1.0)*x805))+(((-1.0000000008)*x810)));
evalcond[6]=((((-1.0000000008)*x806))+new_r00+x812);
evalcond[7]=((((1.0000000008)*x809))+new_r10+x813);
evalcond[8]=((((-1.0)*x804*x805))+(((-1.0000000008)*x813)));
evalcond[9]=((((1.0000000008)*x812))+(((-1.0)*x803*x805))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x815=IKPowWithIntegerCheck(new_r11,-1);
if(!x815.valid){
continue;
}
IkReal x814=x815.value;
CheckValue<IkReal> x816=IKPowWithIntegerCheck(new_r10,-1);
if(!x816.valid){
continue;
}
if( IKabs(((4.0e-5)*x814*(x816.value)*(((((25000.0)*gconst12*new_r00))+(((-25000.00002)*gconst12*new_r11)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((gconst12*x814)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((4.0e-5)*x814*(x816.value)*(((((25000.0)*gconst12*new_r00))+(((-25000.00002)*gconst12*new_r11))))))+IKsqr((gconst12*x814))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((4.0e-5)*x814*(x816.value)*(((((25000.0)*gconst12*new_r00))+(((-25000.00002)*gconst12*new_r11))))), (gconst12*x814));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x817=IKcos(j5);
IkReal x818=IKsin(j5);
IkReal x819=((1.0)*gconst12);
IkReal x820=(gconst12*x817);
IkReal x821=(new_r11*x818);
IkReal x822=(new_r00*x817);
IkReal x823=(gconst12*x818);
IkReal x824=(new_r10*x818);
if((((1.0)+(((-1.0)*gconst12*x819)))) < -0.00001)
continue;
IkReal x825=IKsqrt(((1.0)+(((-1.0)*gconst12*x819))));
IkReal x826=(x818*x825);
IkReal x827=(x817*x825);
evalcond[0]=(((new_r11*x817))+(((-1.0)*x819)));
evalcond[1]=((((-1.0000000008)*gconst12))+(((-1.0)*x824))+x822);
evalcond[2]=(((new_r00*x818))+((new_r10*x817))+x825);
evalcond[3]=((((-1.0)*x821))+(((-1.0000000008)*x825)));
evalcond[4]=((((-1.0)*x825))+(((-1.0000000008)*x821)));
evalcond[5]=((((1.0000000008)*x822))+(((-1.0)*x819))+(((-1.0000000008)*x824)));
evalcond[6]=(new_r00+x826+(((-1.0000000008)*x820)));
evalcond[7]=((((1.0000000008)*x823))+new_r10+x827);
evalcond[8]=((((-1.0)*x818*x819))+(((-1.0000000008)*x827)));
evalcond[9]=((((-1.0)*x817*x819))+(((1.0000000008)*x826))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x828=IKPowWithIntegerCheck(IKsign(new_r11),-1);
if(!x828.valid){
continue;
}
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
CheckValue<IkReal> x829 = IKatan2WithCheck(IkReal(((-1.0000000008)*(IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))))))),IkReal(gconst12),IKFAST_ATAN2_MAGTHRESH);
if(!x829.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x828.value)))+(x829.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x830=IKcos(j5);
IkReal x831=IKsin(j5);
IkReal x832=((1.0)*gconst12);
IkReal x833=(gconst12*x830);
IkReal x834=(new_r11*x831);
IkReal x835=(new_r00*x830);
IkReal x836=(gconst12*x831);
IkReal x837=(new_r10*x831);
if((((1.0)+(((-1.0)*gconst12*x832)))) < -0.00001)
continue;
IkReal x838=IKsqrt(((1.0)+(((-1.0)*gconst12*x832))));
IkReal x839=(x831*x838);
IkReal x840=(x830*x838);
evalcond[0]=(((new_r11*x830))+(((-1.0)*x832)));
evalcond[1]=((((-1.0000000008)*gconst12))+(((-1.0)*x837))+x835);
evalcond[2]=(((new_r00*x831))+x838+((new_r10*x830)));
evalcond[3]=((((-1.0)*x834))+(((-1.0000000008)*x838)));
evalcond[4]=((((-1.0)*x838))+(((-1.0000000008)*x834)));
evalcond[5]=((((1.0000000008)*x835))+(((-1.0)*x832))+(((-1.0000000008)*x837)));
evalcond[6]=((((-1.0000000008)*x833))+new_r00+x839);
evalcond[7]=((((1.0000000008)*x836))+new_r10+x840);
evalcond[8]=((((-1.0000000008)*x840))+(((-1.0)*x831*x832)));
evalcond[9]=((((1.0000000008)*x839))+(((-1.0)*x830*x832))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r00)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
cj5array[0]=((-1.0)*new_r10);
if( cj5array[0] >= -1-IKFAST_SINCOS_THRESH && cj5array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j5valid[0] = j5valid[1] = true;
    j5array[0] = IKacos(cj5array[0]);
    sj5array[0] = IKsin(j5array[0]);
    cj5array[1] = cj5array[0];
    j5array[1] = -j5array[0];
    sj5array[1] = -sj5array[0];
}
else if( isnan(cj5array[0]) )
{
    // probably any value will work
    j5valid[0] = true;
    cj5array[0] = 1; sj5array[0] = 0; j5array[0] = 0;
}
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[9];
IkReal x841=IKsin(j5);
IkReal x842=IKcos(j5);
IkReal x843=(new_r10*x841);
IkReal x844=((1.0000000008)*x842);
evalcond[0]=x841;
evalcond[1]=(new_r01*x841);
evalcond[2]=((-1.0)*x843);
evalcond[3]=((1.0)+((new_r10*x842)));
evalcond[4]=((1.0000000008)*x841);
evalcond[5]=((-1.0000000008)*x843);
evalcond[6]=((((-1.0)*x844))+new_r01);
evalcond[7]=((-1.0000000008)+((new_r01*x842)));
evalcond[8]=((-1.0)+((new_r01*x844)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(((-0.9999999992)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((0.9999999992)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-0.9999999992)*new_r11))+IKsqr(((0.9999999992)*new_r01))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-0.9999999992)*new_r11), ((0.9999999992)*new_r01));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x845=IKcos(j5);
IkReal x846=IKsin(j5);
IkReal x847=((1.0000000008)*x846);
IkReal x848=((1.0000000008)*x845);
evalcond[0]=x846;
evalcond[1]=x845;
evalcond[2]=((((-1.0)*x848))+new_r01);
evalcond[3]=(new_r11+x847);
evalcond[4]=(((new_r01*x846))+((new_r11*x845)));
evalcond[5]=((-1.0000000008)+((new_r01*x845))+(((-1.0)*new_r11*x846)));
evalcond[6]=((-1.0)+(((-1.0)*new_r11*x847))+((new_r01*x848)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x855=IKPowWithIntegerCheck(new_r01,-1);
if(!x855.valid){
continue;
}
IkReal x849=x855.value;
IkReal x850=(gconst12*x849);
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
IkReal x851=IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))));
IkReal x852=((25000.0)*x851);
CheckValue<IkReal> x856=IKPowWithIntegerCheck(((((25000.00002)*gconst12*new_r01))+((new_r11*x852))),-1);
if(!x856.valid){
continue;
}
IkReal x853=x856.value;
IkReal x854=((25000.0)*new_r11*x853);
if( IKabs(((((-1.0)*new_r00*x854))+x850+(((-1.0)*new_r11*x850*x852*x853)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x853*((((gconst12*x852))+(((25000.0)*new_r00*new_r01)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*x854))+x850+(((-1.0)*new_r11*x850*x852*x853))))+IKsqr((x853*((((gconst12*x852))+(((25000.0)*new_r00*new_r01))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*new_r00*x854))+x850+(((-1.0)*new_r11*x850*x852*x853))), (x853*((((gconst12*x852))+(((25000.0)*new_r00*new_r01))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x857=IKcos(j5);
IkReal x858=IKsin(j5);
IkReal x859=((1.0)*gconst12);
IkReal x860=(gconst12*x857);
IkReal x861=(new_r11*x858);
IkReal x862=(new_r01*x857);
IkReal x863=(new_r00*x857);
IkReal x864=(gconst12*x858);
IkReal x865=(new_r10*x858);
IkReal x866=x851;
IkReal x867=(x858*x866);
IkReal x868=(x857*x866);
evalcond[0]=((((-1.0)*x859))+((new_r11*x857))+((new_r01*x858)));
evalcond[1]=((((-1.0)*x865))+(((-1.0000000008)*gconst12))+x863);
evalcond[2]=(((new_r10*x857))+x866+((new_r00*x858)));
evalcond[3]=((((-1.0000000008)*x865))+(((1.0000000008)*x863))+(((-1.0)*x859)));
evalcond[4]=((((-1.0000000008)*x860))+new_r00+x867);
evalcond[5]=((((1.0000000008)*x864))+new_r10+x868);
evalcond[6]=((((-1.0000000008)*x868))+(((-1.0)*x858*x859))+new_r01);
evalcond[7]=((((1.0000000008)*x867))+new_r11+(((-1.0)*x857*x859)));
evalcond[8]=((((-1.0000000008)*x866))+(((-1.0)*x861))+x862);
evalcond[9]=((((-1.0000000008)*x861))+(((1.0000000008)*x862))+(((-1.0)*x866)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
IkReal x869=IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))));
CheckValue<IkReal> x870 = IKatan2WithCheck(IkReal((((new_r11*x869))+((gconst12*new_r10)))),IkReal(((((-1.0)*gconst12*new_r00))+(((-1.0)*new_r01*x869)))),IKFAST_ATAN2_MAGTHRESH);
if(!x870.valid){
continue;
}
CheckValue<IkReal> x871=IKPowWithIntegerCheck(IKsign((((new_r01*new_r10))+(((-1.0)*new_r00*new_r11)))),-1);
if(!x871.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x870.value)+(((1.5707963267949)*(x871.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x872=IKcos(j5);
IkReal x873=IKsin(j5);
IkReal x874=((1.0)*gconst12);
IkReal x875=(gconst12*x872);
IkReal x876=(new_r11*x873);
IkReal x877=(new_r01*x872);
IkReal x878=(new_r00*x872);
IkReal x879=(gconst12*x873);
IkReal x880=(new_r10*x873);
IkReal x881=x869;
IkReal x882=(x873*x881);
IkReal x883=(x872*x881);
evalcond[0]=(((new_r01*x873))+((new_r11*x872))+(((-1.0)*x874)));
evalcond[1]=((((-1.0)*x880))+(((-1.0000000008)*gconst12))+x878);
evalcond[2]=(((new_r00*x873))+((new_r10*x872))+x881);
evalcond[3]=((((1.0000000008)*x878))+(((-1.0000000008)*x880))+(((-1.0)*x874)));
evalcond[4]=((((-1.0000000008)*x875))+new_r00+x882);
evalcond[5]=((((1.0000000008)*x879))+new_r10+x883);
evalcond[6]=((((-1.0)*x873*x874))+new_r01+(((-1.0000000008)*x883)));
evalcond[7]=((((-1.0)*x872*x874))+(((1.0000000008)*x882))+new_r11);
evalcond[8]=((((-1.0)*x876))+x877+(((-1.0000000008)*x881)));
evalcond[9]=((((-1.0000000008)*x876))+(((1.0000000008)*x877))+(((-1.0)*x881)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x884=((25000.00002)*gconst12);
IkReal x885=((25000.0)*new_r10);
IkReal x886=((25000.0)*new_r00);
CheckValue<IkReal> x887=IKPowWithIntegerCheck(IKsign((((new_r01*x886))+((new_r11*x885)))),-1);
if(!x887.valid){
continue;
}
CheckValue<IkReal> x888 = IKatan2WithCheck(IkReal(((((-1.0)*new_r11*x884))+((gconst12*x886)))),IkReal((((new_r01*x884))+((gconst12*x885)))),IKFAST_ATAN2_MAGTHRESH);
if(!x888.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x887.value)))+(x888.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x889=IKcos(j5);
IkReal x890=IKsin(j5);
IkReal x891=((1.0)*gconst12);
IkReal x892=(gconst12*x889);
IkReal x893=(new_r11*x890);
IkReal x894=(new_r01*x889);
IkReal x895=(new_r00*x889);
IkReal x896=(gconst12*x890);
IkReal x897=(new_r10*x890);
if((((1.0)+(((-1.0)*gconst12*x891)))) < -0.00001)
continue;
IkReal x898=IKsqrt(((1.0)+(((-1.0)*gconst12*x891))));
IkReal x899=(x890*x898);
IkReal x900=(x889*x898);
evalcond[0]=(((new_r11*x889))+((new_r01*x890))+(((-1.0)*x891)));
evalcond[1]=((((-1.0)*x897))+(((-1.0000000008)*gconst12))+x895);
evalcond[2]=(((new_r10*x889))+((new_r00*x890))+x898);
evalcond[3]=((((1.0000000008)*x895))+(((-1.0)*x891))+(((-1.0000000008)*x897)));
evalcond[4]=(new_r00+x899+(((-1.0000000008)*x892)));
evalcond[5]=((((1.0000000008)*x896))+new_r10+x900);
evalcond[6]=(new_r01+(((-1.0000000008)*x900))+(((-1.0)*x890*x891)));
evalcond[7]=((((1.0000000008)*x899))+(((-1.0)*x889*x891))+new_r11);
evalcond[8]=((((-1.0)*x893))+x894+(((-1.0000000008)*x898)));
evalcond[9]=((((1.0000000008)*x894))+(((-1.0)*x898))+(((-1.0000000008)*x893)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x901=new_r00*new_r00;
CheckValue<IkReal> x902=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x901))),-1);
if(!x902.valid){
continue;
}
if((((-1.0)*x901*(x902.value))) < -0.00001)
continue;
IkReal gconst12=IKsqrt(((-1.0)*x901*(x902.value)));
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.0)+(IKsign(sj3)))))+(IKabs((cj3+(((-1.0)*gconst12)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[2];
IkReal x903=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
sj3=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))))));
cj3=gconst12;
if( (gconst12) < -1-IKFAST_SINCOS_THRESH || (gconst12) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=((-1.0)*(IKacos(gconst12)));
CheckValue<IkReal> x904=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x903))),-1);
if(!x904.valid){
continue;
}
if((((-1.0)*x903*(x904.value))) < -0.00001)
continue;
IkReal gconst12=IKsqrt(((-1.0)*x903*(x904.value)));
IkReal x905=(new_r00*new_r01);
IkReal x906=(new_r10*new_r11);
j5eval[0]=(x905+x906);
j5eval[1]=IKsign(((((25000.0)*x906))+(((25000.0)*x905))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x907=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
sj3=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))))));
cj3=gconst12;
if( (gconst12) < -1-IKFAST_SINCOS_THRESH || (gconst12) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=((-1.0)*(IKacos(gconst12)));
CheckValue<IkReal> x908=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x907))),-1);
if(!x908.valid){
continue;
}
if((((-1.0)*x907*(x908.value))) < -0.00001)
continue;
IkReal gconst12=IKsqrt(((-1.0)*x907*(x908.value)));
IkReal x909=(((new_r01*new_r10))+(((-1.0)*new_r00*new_r11)));
j5eval[0]=x909;
j5eval[1]=IKsign(x909);
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x910=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
sj3=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))))));
cj3=gconst12;
if( (gconst12) < -1-IKFAST_SINCOS_THRESH || (gconst12) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=((-1.0)*(IKacos(gconst12)));
CheckValue<IkReal> x911=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x910))),-1);
if(!x911.valid){
continue;
}
if((((-1.0)*x910*(x911.value))) < -0.00001)
continue;
IkReal gconst12=IKsqrt(((-1.0)*x910*(x911.value)));
j5eval[0]=new_r01;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(new_r01);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
IkReal x912=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
sj3=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))))));
cj3=gconst12;
if( (gconst12) < -1-IKFAST_SINCOS_THRESH || (gconst12) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=((-1.0)*(IKacos(gconst12)));
new_r01=0;
CheckValue<IkReal> x913=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x912))),-1);
if(!x913.valid){
continue;
}
if((((-1.0)*x912*(x913.value))) < -0.00001)
continue;
IkReal gconst12=IKsqrt(((-1.0)*x912*(x913.value)));
j5eval[0]=new_r11;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x914=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
sj3=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))))));
cj3=gconst12;
if( (gconst12) < -1-IKFAST_SINCOS_THRESH || (gconst12) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=((-1.0)*(IKacos(gconst12)));
new_r01=0;
CheckValue<IkReal> x915=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x914))),-1);
if(!x915.valid){
continue;
}
if((((-1.0)*x914*(x915.value))) < -0.00001)
continue;
IkReal gconst12=IKsqrt(((-1.0)*x914*(x915.value)));
j5eval[0]=new_r10;
j5eval[1]=new_r11;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x916=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
sj3=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))))));
cj3=gconst12;
if( (gconst12) < -1-IKFAST_SINCOS_THRESH || (gconst12) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=((-1.0)*(IKacos(gconst12)));
new_r01=0;
CheckValue<IkReal> x917=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x916))),-1);
if(!x917.valid){
continue;
}
if((((-1.0)*x916*(x917.value))) < -0.00001)
continue;
IkReal gconst12=IKsqrt(((-1.0)*x916*(x917.value)));
j5eval[0]=new_r00;
j5eval[1]=new_r11;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x919=IKPowWithIntegerCheck(new_r11,-1);
if(!x919.valid){
continue;
}
IkReal x918=x919.value;
CheckValue<IkReal> x920=IKPowWithIntegerCheck(new_r00,-1);
if(!x920.valid){
continue;
}
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
if( IKabs((x918*(x920.value)*(((((-1.0)*gconst12*new_r10))+((new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))))))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((gconst12*x918)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x918*(x920.value)*(((((-1.0)*gconst12*new_r10))+((new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12))))))))))))+IKsqr((gconst12*x918))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((x918*(x920.value)*(((((-1.0)*gconst12*new_r10))+((new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12))))))))))), (gconst12*x918));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x921=IKcos(j5);
IkReal x922=IKsin(j5);
IkReal x923=((1.0)*gconst12);
IkReal x924=(gconst12*x921);
IkReal x925=(new_r11*x922);
IkReal x926=(new_r00*x921);
IkReal x927=(gconst12*x922);
IkReal x928=(new_r10*x922);
if((((1.0)+(((-1.0)*gconst12*x923)))) < -0.00001)
continue;
IkReal x929=IKsqrt(((1.0)+(((-1.0)*gconst12*x923))));
IkReal x930=((1.0)*x929);
IkReal x931=((1.0000000008)*x929);
evalcond[0]=((((-1.0)*x923))+((new_r11*x921)));
evalcond[1]=((((-1.0000000008)*gconst12))+(((-1.0)*x928))+x926);
evalcond[2]=((((-1.0000000008)*x925))+x929);
evalcond[3]=((((-1.0)*x925))+x931);
evalcond[4]=(((new_r00*x922))+((new_r10*x921))+(((-1.0)*x930)));
evalcond[5]=((((-1.0)*x923))+(((-1.0000000008)*x928))+(((1.0000000008)*x926)));
evalcond[6]=(((x921*x931))+(((-1.0)*x922*x923)));
evalcond[7]=((((-1.0000000008)*x924))+new_r00+(((-1.0)*x922*x930)));
evalcond[8]=((((1.0000000008)*x927))+(((-1.0)*x921*x930))+new_r10);
evalcond[9]=((((-1.0)*x921*x923))+new_r11+(((-1.0)*x922*x931)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x933=IKPowWithIntegerCheck(new_r11,-1);
if(!x933.valid){
continue;
}
IkReal x932=x933.value;
CheckValue<IkReal> x934=IKPowWithIntegerCheck(new_r10,-1);
if(!x934.valid){
continue;
}
if( IKabs(((4.0e-5)*x932*(x934.value)*(((((25000.0)*gconst12*new_r00))+(((-25000.00002)*gconst12*new_r11)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((gconst12*x932)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((4.0e-5)*x932*(x934.value)*(((((25000.0)*gconst12*new_r00))+(((-25000.00002)*gconst12*new_r11))))))+IKsqr((gconst12*x932))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((4.0e-5)*x932*(x934.value)*(((((25000.0)*gconst12*new_r00))+(((-25000.00002)*gconst12*new_r11))))), (gconst12*x932));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x935=IKcos(j5);
IkReal x936=IKsin(j5);
IkReal x937=((1.0)*gconst12);
IkReal x938=(gconst12*x935);
IkReal x939=(new_r11*x936);
IkReal x940=(new_r00*x935);
IkReal x941=(gconst12*x936);
IkReal x942=(new_r10*x936);
if((((1.0)+(((-1.0)*gconst12*x937)))) < -0.00001)
continue;
IkReal x943=IKsqrt(((1.0)+(((-1.0)*gconst12*x937))));
IkReal x944=((1.0)*x943);
IkReal x945=((1.0000000008)*x943);
evalcond[0]=(((new_r11*x935))+(((-1.0)*x937)));
evalcond[1]=((((-1.0)*x942))+(((-1.0000000008)*gconst12))+x940);
evalcond[2]=((((-1.0000000008)*x939))+x943);
evalcond[3]=((((-1.0)*x939))+x945);
evalcond[4]=((((-1.0)*x944))+((new_r00*x936))+((new_r10*x935)));
evalcond[5]=((((1.0000000008)*x940))+(((-1.0000000008)*x942))+(((-1.0)*x937)));
evalcond[6]=(((x935*x945))+(((-1.0)*x936*x937)));
evalcond[7]=((((-1.0000000008)*x938))+(((-1.0)*x936*x944))+new_r00);
evalcond[8]=((((1.0000000008)*x941))+new_r10+(((-1.0)*x935*x944)));
evalcond[9]=((((-1.0)*x935*x937))+(((-1.0)*x936*x945))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x947=IKPowWithIntegerCheck(new_r11,-1);
if(!x947.valid){
continue;
}
IkReal x946=x947.value;
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
if( IKabs(((0.9999999992)*x946*(IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((gconst12*x946)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.9999999992)*x946*(IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12))))))))+IKsqr((gconst12*x946))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((0.9999999992)*x946*(IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12))))))), (gconst12*x946));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x948=IKcos(j5);
IkReal x949=IKsin(j5);
IkReal x950=((1.0)*gconst12);
IkReal x951=(gconst12*x948);
IkReal x952=(new_r11*x949);
IkReal x953=(new_r00*x948);
IkReal x954=(gconst12*x949);
IkReal x955=(new_r10*x949);
if((((1.0)+(((-1.0)*gconst12*x950)))) < -0.00001)
continue;
IkReal x956=IKsqrt(((1.0)+(((-1.0)*gconst12*x950))));
IkReal x957=((1.0)*x956);
IkReal x958=((1.0000000008)*x956);
evalcond[0]=(((new_r11*x948))+(((-1.0)*x950)));
evalcond[1]=((((-1.0)*x955))+(((-1.0000000008)*gconst12))+x953);
evalcond[2]=((((-1.0000000008)*x952))+x956);
evalcond[3]=((((-1.0)*x952))+x958);
evalcond[4]=(((new_r00*x949))+((new_r10*x948))+(((-1.0)*x957)));
evalcond[5]=((((1.0000000008)*x953))+(((-1.0000000008)*x955))+(((-1.0)*x950)));
evalcond[6]=(((x948*x958))+(((-1.0)*x949*x950)));
evalcond[7]=((((-1.0000000008)*x951))+(((-1.0)*x949*x957))+new_r00);
evalcond[8]=((((1.0000000008)*x954))+new_r10+(((-1.0)*x948*x957)));
evalcond[9]=((((-1.0)*x949*x958))+new_r11+(((-1.0)*x948*x950)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r00)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
cj5array[0]=new_r10;
if( cj5array[0] >= -1-IKFAST_SINCOS_THRESH && cj5array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j5valid[0] = j5valid[1] = true;
    j5array[0] = IKacos(cj5array[0]);
    sj5array[0] = IKsin(j5array[0]);
    cj5array[1] = cj5array[0];
    j5array[1] = -j5array[0];
    sj5array[1] = -sj5array[0];
}
else if( isnan(cj5array[0]) )
{
    // probably any value will work
    j5valid[0] = true;
    cj5array[0] = 1; sj5array[0] = 0; j5array[0] = 0;
}
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[9];
IkReal x959=IKsin(j5);
IkReal x960=IKcos(j5);
IkReal x961=((1.0000000008)*x960);
IkReal x962=((-1.0000000008)*x959);
IkReal x963=((-1.0)*x959);
evalcond[0]=(new_r01*x959);
evalcond[1]=x963;
evalcond[2]=(new_r10*x963);
evalcond[3]=((-1.0)+((new_r10*x960)));
evalcond[4]=x962;
evalcond[5]=(new_r10*x962);
evalcond[6]=(new_r01+x961);
evalcond[7]=((1.0000000008)+((new_r01*x960)));
evalcond[8]=((1.0)+((new_r01*x961)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(((0.9999999992)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.9999999992)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.9999999992)*new_r11))+IKsqr(((-0.9999999992)*new_r01))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((0.9999999992)*new_r11), ((-0.9999999992)*new_r01));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x964=IKcos(j5);
IkReal x965=IKsin(j5);
IkReal x966=((1.0000000008)*x965);
IkReal x967=((1.0000000008)*x964);
evalcond[0]=((-1.0)*x965);
evalcond[1]=((-1.0)*x964);
evalcond[2]=(new_r01+x967);
evalcond[3]=(new_r11+(((-1.0)*x966)));
evalcond[4]=(((new_r11*x964))+((new_r01*x965)));
evalcond[5]=((1.0000000008)+((new_r01*x964))+(((-1.0)*new_r11*x965)));
evalcond[6]=((1.0)+((new_r01*x967))+(((-1.0)*new_r11*x966)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x975=IKPowWithIntegerCheck(new_r01,-1);
if(!x975.valid){
continue;
}
IkReal x968=x975.value;
IkReal x969=(gconst12*x968);
IkReal x970=((25000.0)*new_r00);
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
IkReal x971=IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))));
IkReal x972=((25000.0)*new_r11*x971);
CheckValue<IkReal> x976=IKPowWithIntegerCheck(((((25000.00002)*gconst12*new_r01))+(((-1.0)*x972))),-1);
if(!x976.valid){
continue;
}
IkReal x973=x976.value;
IkReal x974=((25000.0)*new_r11*x973);
CheckValue<IkReal> x977=IKPowWithIntegerCheck(((((25000.00002)*gconst12*new_r01))+(((-25000.0)*new_r11*x971))),-1);
if(!x977.valid){
continue;
}
if( IKabs(((((-1.0)*new_r11*x970*x973))+((x969*x972*(x977.value)))+x969)) < IKFAST_ATAN2_MAGTHRESH && IKabs((x973*((((new_r01*x970))+(((-25000.0)*gconst12*x971)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r11*x970*x973))+((x969*x972*(x977.value)))+x969))+IKsqr((x973*((((new_r01*x970))+(((-25000.0)*gconst12*x971))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*new_r11*x970*x973))+((x969*x972*(x977.value)))+x969), (x973*((((new_r01*x970))+(((-25000.0)*gconst12*x971))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x978=IKcos(j5);
IkReal x979=IKsin(j5);
IkReal x980=((1.0)*gconst12);
IkReal x981=(gconst12*x978);
IkReal x982=(new_r11*x979);
IkReal x983=(new_r01*x978);
IkReal x984=(new_r00*x978);
IkReal x985=(gconst12*x979);
IkReal x986=(new_r10*x979);
IkReal x987=x971;
IkReal x988=((1.0)*x987);
IkReal x989=((1.0000000008)*x987);
evalcond[0]=((((-1.0)*x980))+((new_r01*x979))+((new_r11*x978)));
evalcond[1]=((((-1.0)*x986))+(((-1.0000000008)*gconst12))+x984);
evalcond[2]=((((-1.0)*x988))+((new_r10*x978))+((new_r00*x979)));
evalcond[3]=((((-1.0)*x980))+(((-1.0000000008)*x986))+(((1.0000000008)*x984)));
evalcond[4]=((((-1.0000000008)*x981))+new_r00+(((-1.0)*x979*x988)));
evalcond[5]=((((-1.0)*x978*x988))+new_r10+(((1.0000000008)*x985)));
evalcond[6]=(new_r01+(((-1.0)*x979*x980))+((x978*x989)));
evalcond[7]=((((-1.0)*x978*x980))+new_r11+(((-1.0)*x979*x989)));
evalcond[8]=((((-1.0)*x982))+x989+x983);
evalcond[9]=((((-1.0000000008)*x982))+(((1.0000000008)*x983))+x987);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x990=((1.0)*new_r11);
if((((1.0)+(((-1.0)*(gconst12*gconst12))))) < -0.00001)
continue;
IkReal x991=IKsqrt(((1.0)+(((-1.0)*(gconst12*gconst12)))));
CheckValue<IkReal> x992=IKPowWithIntegerCheck(IKsign(((((-1.0)*new_r00*x990))+((new_r01*new_r10)))),-1);
if(!x992.valid){
continue;
}
CheckValue<IkReal> x993 = IKatan2WithCheck(IkReal(((((-1.0)*x990*x991))+((gconst12*new_r10)))),IkReal(((((-1.0)*gconst12*new_r00))+((new_r01*x991)))),IKFAST_ATAN2_MAGTHRESH);
if(!x993.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x992.value)))+(x993.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x994=IKcos(j5);
IkReal x995=IKsin(j5);
IkReal x996=((1.0)*gconst12);
IkReal x997=(gconst12*x994);
IkReal x998=(new_r11*x995);
IkReal x999=(new_r01*x994);
IkReal x1000=(new_r00*x994);
IkReal x1001=(gconst12*x995);
IkReal x1002=(new_r10*x995);
IkReal x1003=x991;
IkReal x1004=((1.0)*x1003);
IkReal x1005=((1.0000000008)*x1003);
evalcond[0]=(((new_r11*x994))+(((-1.0)*x996))+((new_r01*x995)));
evalcond[1]=((((-1.0)*x1002))+x1000+(((-1.0000000008)*gconst12)));
evalcond[2]=((((-1.0)*x1004))+((new_r10*x994))+((new_r00*x995)));
evalcond[3]=((((-1.0000000008)*x1002))+(((1.0000000008)*x1000))+(((-1.0)*x996)));
evalcond[4]=((((-1.0000000008)*x997))+(((-1.0)*x1004*x995))+new_r00);
evalcond[5]=((((1.0000000008)*x1001))+(((-1.0)*x1004*x994))+new_r10);
evalcond[6]=((((-1.0)*x995*x996))+new_r01+((x1005*x994)));
evalcond[7]=((((-1.0)*x994*x996))+new_r11+(((-1.0)*x1005*x995)));
evalcond[8]=((((-1.0)*x998))+x1005+x999);
evalcond[9]=(x1003+(((-1.0000000008)*x998))+(((1.0000000008)*x999)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1006=((25000.00002)*gconst12);
IkReal x1007=((25000.0)*new_r10);
IkReal x1008=((25000.0)*new_r00);
CheckValue<IkReal> x1009=IKPowWithIntegerCheck(IKsign((((new_r11*x1007))+((new_r01*x1008)))),-1);
if(!x1009.valid){
continue;
}
CheckValue<IkReal> x1010 = IKatan2WithCheck(IkReal((((gconst12*x1008))+(((-1.0)*new_r11*x1006)))),IkReal((((gconst12*x1007))+((new_r01*x1006)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1010.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1009.value)))+(x1010.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1011=IKcos(j5);
IkReal x1012=IKsin(j5);
IkReal x1013=((1.0)*gconst12);
IkReal x1014=(gconst12*x1011);
IkReal x1015=(new_r11*x1012);
IkReal x1016=(new_r01*x1011);
IkReal x1017=(new_r00*x1011);
IkReal x1018=(gconst12*x1012);
IkReal x1019=(new_r10*x1012);
if((((1.0)+(((-1.0)*gconst12*x1013)))) < -0.00001)
continue;
IkReal x1020=IKsqrt(((1.0)+(((-1.0)*gconst12*x1013))));
IkReal x1021=((1.0)*x1020);
IkReal x1022=((1.0000000008)*x1020);
evalcond[0]=(((new_r11*x1011))+(((-1.0)*x1013))+((new_r01*x1012)));
evalcond[1]=(x1017+(((-1.0000000008)*gconst12))+(((-1.0)*x1019)));
evalcond[2]=(((new_r10*x1011))+(((-1.0)*x1021))+((new_r00*x1012)));
evalcond[3]=((((-1.0000000008)*x1019))+(((-1.0)*x1013))+(((1.0000000008)*x1017)));
evalcond[4]=((((-1.0000000008)*x1014))+new_r00+(((-1.0)*x1012*x1021)));
evalcond[5]=((((1.0000000008)*x1018))+new_r10+(((-1.0)*x1011*x1021)));
evalcond[6]=((((-1.0)*x1012*x1013))+((x1011*x1022))+new_r01);
evalcond[7]=((((-1.0)*x1011*x1013))+new_r11+(((-1.0)*x1012*x1022)));
evalcond[8]=(x1016+x1022+(((-1.0)*x1015)));
evalcond[9]=((((-1.0000000008)*x1015))+x1020+(((1.0000000008)*x1016)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x1023=new_r00*new_r00;
CheckValue<IkReal> x1024=IKPowWithIntegerCheck(((((-1.0)*x1023))+(((-1.0000000016)*(new_r10*new_r10)))),-1);
if(!x1024.valid){
continue;
}
if((((-1.0)*x1023*(x1024.value))) < -0.00001)
continue;
IkReal gconst13=((-1.0)*(IKsqrt(((-1.0)*x1023*(x1024.value)))));
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.0)+(IKsign(sj3)))))+(IKabs((cj3+(((-1.0)*gconst13)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[2];
IkReal x1025=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
sj3=IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))));
cj3=gconst13;
if( (gconst13) < -1-IKFAST_SINCOS_THRESH || (gconst13) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=IKacos(gconst13);
CheckValue<IkReal> x1026=IKPowWithIntegerCheck(((((-1.0)*x1025))+(((-1.0000000016)*(new_r10*new_r10)))),-1);
if(!x1026.valid){
continue;
}
if((((-1.0)*x1025*(x1026.value))) < -0.00001)
continue;
IkReal gconst13=((-1.0)*(IKsqrt(((-1.0)*x1025*(x1026.value)))));
IkReal x1027=(new_r00*new_r01);
IkReal x1028=(new_r10*new_r11);
j5eval[0]=(x1027+x1028);
j5eval[1]=IKsign(((((25000.0)*x1028))+(((25000.0)*x1027))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x1029=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
sj3=IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))));
cj3=gconst13;
if( (gconst13) < -1-IKFAST_SINCOS_THRESH || (gconst13) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=IKacos(gconst13);
CheckValue<IkReal> x1030=IKPowWithIntegerCheck(((((-1.0)*x1029))+(((-1.0000000016)*(new_r10*new_r10)))),-1);
if(!x1030.valid){
continue;
}
if((((-1.0)*x1029*(x1030.value))) < -0.00001)
continue;
IkReal gconst13=((-1.0)*(IKsqrt(((-1.0)*x1029*(x1030.value)))));
IkReal x1031=(((new_r01*new_r10))+(((-1.0)*new_r00*new_r11)));
j5eval[0]=x1031;
j5eval[1]=IKsign(x1031);
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x1032=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
sj3=IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))));
cj3=gconst13;
if( (gconst13) < -1-IKFAST_SINCOS_THRESH || (gconst13) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=IKacos(gconst13);
CheckValue<IkReal> x1033=IKPowWithIntegerCheck(((((-1.0)*x1032))+(((-1.0000000016)*(new_r10*new_r10)))),-1);
if(!x1033.valid){
continue;
}
if((((-1.0)*x1032*(x1033.value))) < -0.00001)
continue;
IkReal gconst13=((-1.0)*(IKsqrt(((-1.0)*x1032*(x1033.value)))));
j5eval[0]=new_r01;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[2];
IkReal x1034=new_r10*new_r10;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
sj3=IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))));
cj3=gconst13;
if( (gconst13) < -1-IKFAST_SINCOS_THRESH || (gconst13) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=IKacos(gconst13);
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x1035=IKPowWithIntegerCheck(((-1.0)+(((-1.6e-9)*x1034))),-1);
if(!x1035.valid){
continue;
}
if((((x1035.value)*(((-1.0)+(((1.0)*x1034)))))) < -0.00001)
continue;
IkReal gconst13=((-1.0)*(IKsqrt(((x1035.value)*(((-1.0)+(((1.0)*x1034))))))));
j5eval[0]=-1.0;
j5eval[1]=-1.0;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1036=gconst13*gconst13;
IkReal x1037=new_r00*new_r00;
IkReal x1038=(gconst13*new_r10);
IkReal x1039=((1.0)+(((-1.0)*x1036)));
IkReal x1040=((3.90625000625e+17)*x1036);
if((x1039) < -0.00001)
continue;
IkReal x1041=IKsqrt(x1039);
IkReal x1042=(new_r00*x1041);
CheckValue<IkReal> x1043=IKPowWithIntegerCheck(((((-1.0)*x1040*(new_r10*new_r10)))+(((3.90625e+17)*x1037*(pow(x1039,1.0))))),-1);
if(!x1043.valid){
continue;
}
CheckValue<IkReal> x1044=IKPowWithIntegerCheck(((((25000.0)*x1042))+(((-25000.00002)*x1038))),-1);
if(!x1044.valid){
continue;
}
if( IKabs(((x1043.value)*(((((3.906250009375e+17)*x1038*(gconst13*gconst13)))+((x1040*x1042))+(((-3.906250003125e+17)*x1037*x1038))+(((-3.90625e+17)*x1042*(new_r00*new_r00))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x1044.value)*(((((-25000.0)*new_r00*new_r10))+(((25000.00002)*gconst13*x1041)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1043.value)*(((((3.906250009375e+17)*x1038*(gconst13*gconst13)))+((x1040*x1042))+(((-3.906250003125e+17)*x1037*x1038))+(((-3.90625e+17)*x1042*(new_r00*new_r00)))))))+IKsqr(((x1044.value)*(((((-25000.0)*new_r00*new_r10))+(((25000.00002)*gconst13*x1041))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((x1043.value)*(((((3.906250009375e+17)*x1038*(gconst13*gconst13)))+((x1040*x1042))+(((-3.906250003125e+17)*x1037*x1038))+(((-3.90625e+17)*x1042*(new_r00*new_r00)))))), ((x1044.value)*(((((-25000.0)*new_r00*new_r10))+(((25000.00002)*gconst13*x1041))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x1045=IKcos(j5);
IkReal x1046=IKsin(j5);
IkReal x1047=((1.0000000008)*gconst13);
IkReal x1048=((1.0)*gconst13);
IkReal x1049=((1.0000000008)*x1046);
IkReal x1050=(new_r00*x1045);
if((((1.0)+(((-1.0)*gconst13*x1048)))) < -0.00001)
continue;
IkReal x1051=IKsqrt(((1.0)+(((-1.0)*gconst13*x1048))));
IkReal x1052=(x1045*x1051);
evalcond[0]=(x1050+(((-1.0)*new_r10*x1046))+(((-1.0)*x1047)));
evalcond[1]=(x1051+((new_r00*x1046))+((new_r10*x1045)));
evalcond[2]=((((-1.0)*new_r10*x1049))+(((-1.0)*x1048))+(((1.0000000008)*x1050)));
evalcond[3]=((((-1.0)*x1045*x1047))+new_r00+((x1046*x1051)));
evalcond[4]=(x1052+new_r10+((x1046*x1047)));
evalcond[5]=((((-1.0)*x1046*x1048))+(((-1.0000000008)*x1052)));
evalcond[6]=((((-1.0)*x1045*x1048))+((x1049*x1051)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
IkReal x1053=IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))));
IkReal x1054=((25000.0)*x1053);
CheckValue<IkReal> x1055=IKPowWithIntegerCheck(IKsign(((((-25000.0)*(new_r10*new_r10)))+(((-25000.0)*(new_r00*new_r00))))),-1);
if(!x1055.valid){
continue;
}
CheckValue<IkReal> x1056 = IKatan2WithCheck(IkReal(((((25000.00002)*gconst13*new_r10))+((new_r00*x1054)))),IkReal((((new_r10*x1054))+(((-25000.00002)*gconst13*new_r00)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1056.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1055.value)))+(x1056.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x1057=IKcos(j5);
IkReal x1058=IKsin(j5);
IkReal x1059=((1.0000000008)*gconst13);
IkReal x1060=((1.0)*gconst13);
IkReal x1061=((1.0000000008)*x1058);
IkReal x1062=(new_r00*x1057);
IkReal x1063=x1053;
IkReal x1064=(x1057*x1063);
evalcond[0]=((((-1.0)*x1059))+x1062+(((-1.0)*new_r10*x1058)));
evalcond[1]=(x1063+((new_r00*x1058))+((new_r10*x1057)));
evalcond[2]=((((-1.0)*new_r10*x1061))+(((1.0000000008)*x1062))+(((-1.0)*x1060)));
evalcond[3]=((((-1.0)*x1057*x1059))+new_r00+((x1058*x1063)));
evalcond[4]=(x1064+new_r10+((x1058*x1059)));
evalcond[5]=((((-1.0000000008)*x1064))+(((-1.0)*x1058*x1060)));
evalcond[6]=(((x1061*x1063))+(((-1.0)*x1057*x1060)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(new_r01);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
IkReal x1065=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
sj3=IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))));
cj3=gconst13;
if( (gconst13) < -1-IKFAST_SINCOS_THRESH || (gconst13) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=IKacos(gconst13);
new_r01=0;
CheckValue<IkReal> x1066=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x1065))),-1);
if(!x1066.valid){
continue;
}
if((((-1.0)*x1065*(x1066.value))) < -0.00001)
continue;
IkReal gconst13=((-1.0)*(IKsqrt(((-1.0)*x1065*(x1066.value)))));
IkReal x1067=new_r10*new_r10;
IkReal x1068=new_r00*new_r00;
IkReal x1069=((1.0)*x1068);
j5eval[0]=new_r11;
j5eval[1]=IKsign(new_r11);
CheckValue<IkReal> x1070=IKPowWithIntegerCheck(((((625000000.0)*x1068))+(((625000001.0)*x1067))),-1);
if(!x1070.valid){
continue;
}
CheckValue<IkReal> x1071=IKPowWithIntegerCheck(((((-1.0000000016)*x1067))+(((-1.0)*x1068))),-1);
if(!x1071.valid){
continue;
}
j5eval[2]=((((625000002.0)*(pow(x1067,1.0))*(pow(x1070.value,1.0))))+(((-1.0)*x1069*(x1071.value))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x1072=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
sj3=IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))));
cj3=gconst13;
if( (gconst13) < -1-IKFAST_SINCOS_THRESH || (gconst13) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=IKacos(gconst13);
new_r01=0;
CheckValue<IkReal> x1073=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x1072))),-1);
if(!x1073.valid){
continue;
}
if((((-1.0)*x1072*(x1073.value))) < -0.00001)
continue;
IkReal gconst13=((-1.0)*(IKsqrt(((-1.0)*x1072*(x1073.value)))));
j5eval[0]=new_r10;
j5eval[1]=new_r11;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x1074=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
sj3=IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))));
cj3=gconst13;
if( (gconst13) < -1-IKFAST_SINCOS_THRESH || (gconst13) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=IKacos(gconst13);
new_r01=0;
CheckValue<IkReal> x1075=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x1074))),-1);
if(!x1075.valid){
continue;
}
if((((-1.0)*x1074*(x1075.value))) < -0.00001)
continue;
IkReal gconst13=((-1.0)*(IKsqrt(((-1.0)*x1074*(x1075.value)))));
j5eval[0]=new_r00;
j5eval[1]=new_r11;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1077=IKPowWithIntegerCheck(new_r11,-1);
if(!x1077.valid){
continue;
}
IkReal x1076=x1077.value;
CheckValue<IkReal> x1078=IKPowWithIntegerCheck(new_r00,-1);
if(!x1078.valid){
continue;
}
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
if( IKabs((x1076*(x1078.value)*(((((-1.0)*gconst13*new_r10))+(((-1.0)*new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))))))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((gconst13*x1076)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x1076*(x1078.value)*(((((-1.0)*gconst13*new_r10))+(((-1.0)*new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13))))))))))))+IKsqr((gconst13*x1076))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((x1076*(x1078.value)*(((((-1.0)*gconst13*new_r10))+(((-1.0)*new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13))))))))))), (gconst13*x1076));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1079=IKcos(j5);
IkReal x1080=IKsin(j5);
IkReal x1081=((1.0)*gconst13);
IkReal x1082=((1.0000000008)*x1080);
IkReal x1083=((1.0)*x1080);
IkReal x1084=((1.0000000008)*x1079);
if((((1.0)+(((-1.0)*gconst13*x1081)))) < -0.00001)
continue;
IkReal x1085=IKsqrt(((1.0)+(((-1.0)*gconst13*x1081))));
evalcond[0]=(((new_r11*x1079))+(((-1.0)*x1081)));
evalcond[1]=((((-1.0)*new_r10*x1083))+(((-1.0000000008)*gconst13))+((new_r00*x1079)));
evalcond[2]=(x1085+((new_r00*x1080))+((new_r10*x1079)));
evalcond[3]=((((-1.0)*new_r11*x1083))+(((-1.0000000008)*x1085)));
evalcond[4]=((((-1.0)*new_r11*x1082))+(((-1.0)*x1085)));
evalcond[5]=((((-1.0)*new_r10*x1082))+((new_r00*x1084))+(((-1.0)*x1081)));
evalcond[6]=(((x1080*x1085))+new_r00+(((-1.0)*gconst13*x1084)));
evalcond[7]=(((x1079*x1085))+((gconst13*x1082))+new_r10);
evalcond[8]=((((-1.0)*x1080*x1081))+(((-1.0)*x1084*x1085)));
evalcond[9]=(((x1082*x1085))+(((-1.0)*x1079*x1081))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1087=IKPowWithIntegerCheck(new_r11,-1);
if(!x1087.valid){
continue;
}
IkReal x1086=x1087.value;
CheckValue<IkReal> x1088=IKPowWithIntegerCheck(new_r10,-1);
if(!x1088.valid){
continue;
}
if( IKabs(((4.0e-5)*x1086*(x1088.value)*(((((25000.0)*gconst13*new_r00))+(((-25000.00002)*gconst13*new_r11)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((gconst13*x1086)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((4.0e-5)*x1086*(x1088.value)*(((((25000.0)*gconst13*new_r00))+(((-25000.00002)*gconst13*new_r11))))))+IKsqr((gconst13*x1086))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((4.0e-5)*x1086*(x1088.value)*(((((25000.0)*gconst13*new_r00))+(((-25000.00002)*gconst13*new_r11))))), (gconst13*x1086));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1089=IKcos(j5);
IkReal x1090=IKsin(j5);
IkReal x1091=((1.0)*gconst13);
IkReal x1092=((1.0000000008)*x1090);
IkReal x1093=((1.0)*x1090);
IkReal x1094=((1.0000000008)*x1089);
if((((1.0)+(((-1.0)*gconst13*x1091)))) < -0.00001)
continue;
IkReal x1095=IKsqrt(((1.0)+(((-1.0)*gconst13*x1091))));
evalcond[0]=((((-1.0)*x1091))+((new_r11*x1089)));
evalcond[1]=(((new_r00*x1089))+(((-1.0000000008)*gconst13))+(((-1.0)*new_r10*x1093)));
evalcond[2]=(((new_r00*x1090))+x1095+((new_r10*x1089)));
evalcond[3]=((((-1.0000000008)*x1095))+(((-1.0)*new_r11*x1093)));
evalcond[4]=((((-1.0)*x1095))+(((-1.0)*new_r11*x1092)));
evalcond[5]=(((new_r00*x1094))+(((-1.0)*x1091))+(((-1.0)*new_r10*x1092)));
evalcond[6]=((((-1.0)*gconst13*x1094))+new_r00+((x1090*x1095)));
evalcond[7]=(((x1089*x1095))+new_r10+((gconst13*x1092)));
evalcond[8]=((((-1.0)*x1090*x1091))+(((-1.0)*x1094*x1095)));
evalcond[9]=((((-1.0)*x1089*x1091))+((x1092*x1095))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1096=IKPowWithIntegerCheck(IKsign(new_r11),-1);
if(!x1096.valid){
continue;
}
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
CheckValue<IkReal> x1097 = IKatan2WithCheck(IkReal(((-1.0000000008)*(IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))))))),IkReal(gconst13),IKFAST_ATAN2_MAGTHRESH);
if(!x1097.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1096.value)))+(x1097.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1098=IKcos(j5);
IkReal x1099=IKsin(j5);
IkReal x1100=((1.0)*gconst13);
IkReal x1101=((1.0000000008)*x1099);
IkReal x1102=((1.0)*x1099);
IkReal x1103=((1.0000000008)*x1098);
if((((1.0)+(((-1.0)*gconst13*x1100)))) < -0.00001)
continue;
IkReal x1104=IKsqrt(((1.0)+(((-1.0)*gconst13*x1100))));
evalcond[0]=(((new_r11*x1098))+(((-1.0)*x1100)));
evalcond[1]=(((new_r00*x1098))+(((-1.0000000008)*gconst13))+(((-1.0)*new_r10*x1102)));
evalcond[2]=(x1104+((new_r00*x1099))+((new_r10*x1098)));
evalcond[3]=((((-1.0000000008)*x1104))+(((-1.0)*new_r11*x1102)));
evalcond[4]=((((-1.0)*x1104))+(((-1.0)*new_r11*x1101)));
evalcond[5]=(((new_r00*x1103))+(((-1.0)*new_r10*x1101))+(((-1.0)*x1100)));
evalcond[6]=(((x1099*x1104))+new_r00+(((-1.0)*gconst13*x1103)));
evalcond[7]=(((x1098*x1104))+((gconst13*x1101))+new_r10);
evalcond[8]=((((-1.0)*x1103*x1104))+(((-1.0)*x1099*x1100)));
evalcond[9]=((((-1.0)*x1098*x1100))+((x1101*x1104))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r00)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
cj5array[0]=((-1.0)*new_r10);
if( cj5array[0] >= -1-IKFAST_SINCOS_THRESH && cj5array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j5valid[0] = j5valid[1] = true;
    j5array[0] = IKacos(cj5array[0]);
    sj5array[0] = IKsin(j5array[0]);
    cj5array[1] = cj5array[0];
    j5array[1] = -j5array[0];
    sj5array[1] = -sj5array[0];
}
else if( isnan(cj5array[0]) )
{
    // probably any value will work
    j5valid[0] = true;
    cj5array[0] = 1; sj5array[0] = 0; j5array[0] = 0;
}
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[9];
IkReal x1105=IKsin(j5);
IkReal x1106=IKcos(j5);
IkReal x1107=(new_r10*x1105);
IkReal x1108=((1.0000000008)*x1106);
evalcond[0]=x1105;
evalcond[1]=(new_r01*x1105);
evalcond[2]=((-1.0)*x1107);
evalcond[3]=((1.0)+((new_r10*x1106)));
evalcond[4]=((1.0000000008)*x1105);
evalcond[5]=((-1.0000000008)*x1107);
evalcond[6]=(new_r01+(((-1.0)*x1108)));
evalcond[7]=((-1.0000000008)+((new_r01*x1106)));
evalcond[8]=((-1.0)+((new_r01*x1108)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(((-0.9999999992)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((0.9999999992)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-0.9999999992)*new_r11))+IKsqr(((0.9999999992)*new_r01))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-0.9999999992)*new_r11), ((0.9999999992)*new_r01));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x1109=IKcos(j5);
IkReal x1110=IKsin(j5);
IkReal x1111=((1.0000000008)*x1110);
IkReal x1112=((1.0000000008)*x1109);
evalcond[0]=x1110;
evalcond[1]=x1109;
evalcond[2]=(new_r01+(((-1.0)*x1112)));
evalcond[3]=(x1111+new_r11);
evalcond[4]=(((new_r11*x1109))+((new_r01*x1110)));
evalcond[5]=((-1.0000000008)+((new_r01*x1109))+(((-1.0)*new_r11*x1110)));
evalcond[6]=((-1.0)+((new_r01*x1112))+(((-1.0)*new_r11*x1111)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1120=IKPowWithIntegerCheck(new_r01,-1);
if(!x1120.valid){
continue;
}
IkReal x1113=x1120.value;
IkReal x1114=((25000.0)*new_r00);
IkReal x1115=(gconst13*x1113);
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
IkReal x1116=IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))));
IkReal x1117=((25000.0)*x1116);
CheckValue<IkReal> x1121=IKPowWithIntegerCheck(((((25000.00002)*gconst13*new_r01))+((new_r11*x1117))),-1);
if(!x1121.valid){
continue;
}
IkReal x1118=x1121.value;
IkReal x1119=(new_r11*x1118);
if( IKabs((x1115+(((-1.0)*x1114*x1119))+(((-1.0)*x1115*x1117*x1119)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x1118*((((gconst13*x1117))+((new_r01*x1114)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x1115+(((-1.0)*x1114*x1119))+(((-1.0)*x1115*x1117*x1119))))+IKsqr((x1118*((((gconst13*x1117))+((new_r01*x1114))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((x1115+(((-1.0)*x1114*x1119))+(((-1.0)*x1115*x1117*x1119))), (x1118*((((gconst13*x1117))+((new_r01*x1114))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1122=IKcos(j5);
IkReal x1123=IKsin(j5);
IkReal x1124=((1.0)*gconst13);
IkReal x1125=((1.0000000008)*x1123);
IkReal x1126=((1.0)*x1123);
IkReal x1127=((1.0000000008)*x1122);
IkReal x1128=x1116;
evalcond[0]=(((new_r01*x1123))+(((-1.0)*x1124))+((new_r11*x1122)));
evalcond[1]=((((-1.0)*new_r10*x1126))+(((-1.0000000008)*gconst13))+((new_r00*x1122)));
evalcond[2]=(x1128+((new_r10*x1122))+((new_r00*x1123)));
evalcond[3]=((((-1.0)*new_r10*x1125))+(((-1.0)*x1124))+((new_r00*x1127)));
evalcond[4]=((((-1.0)*gconst13*x1127))+new_r00+((x1123*x1128)));
evalcond[5]=(((gconst13*x1125))+((x1122*x1128))+new_r10);
evalcond[6]=((((-1.0)*x1123*x1124))+(((-1.0)*x1127*x1128))+new_r01);
evalcond[7]=((((-1.0)*x1122*x1124))+((x1125*x1128))+new_r11);
evalcond[8]=((((-1.0)*new_r11*x1126))+((new_r01*x1122))+(((-1.0000000008)*x1128)));
evalcond[9]=((((-1.0)*new_r11*x1125))+((new_r01*x1127))+(((-1.0)*x1128)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
IkReal x1129=IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))));
CheckValue<IkReal> x1130 = IKatan2WithCheck(IkReal((((gconst13*new_r10))+((new_r11*x1129)))),IkReal(((((-1.0)*new_r01*x1129))+(((-1.0)*gconst13*new_r00)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1130.valid){
continue;
}
CheckValue<IkReal> x1131=IKPowWithIntegerCheck(IKsign((((new_r01*new_r10))+(((-1.0)*new_r00*new_r11)))),-1);
if(!x1131.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x1130.value)+(((1.5707963267949)*(x1131.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1132=IKcos(j5);
IkReal x1133=IKsin(j5);
IkReal x1134=((1.0)*gconst13);
IkReal x1135=((1.0000000008)*x1133);
IkReal x1136=((1.0)*x1133);
IkReal x1137=((1.0000000008)*x1132);
IkReal x1138=x1129;
evalcond[0]=((((-1.0)*x1134))+((new_r11*x1132))+((new_r01*x1133)));
evalcond[1]=((((-1.0)*new_r10*x1136))+(((-1.0000000008)*gconst13))+((new_r00*x1132)));
evalcond[2]=(x1138+((new_r00*x1133))+((new_r10*x1132)));
evalcond[3]=((((-1.0)*new_r10*x1135))+(((-1.0)*x1134))+((new_r00*x1137)));
evalcond[4]=((((-1.0)*gconst13*x1137))+new_r00+((x1133*x1138)));
evalcond[5]=(((gconst13*x1135))+new_r10+((x1132*x1138)));
evalcond[6]=(new_r01+(((-1.0)*x1137*x1138))+(((-1.0)*x1133*x1134)));
evalcond[7]=(((x1135*x1138))+(((-1.0)*x1132*x1134))+new_r11);
evalcond[8]=((((-1.0)*new_r11*x1136))+(((-1.0000000008)*x1138))+((new_r01*x1132)));
evalcond[9]=((((-1.0)*new_r11*x1135))+((new_r01*x1137))+(((-1.0)*x1138)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1139=((25000.0)*gconst13);
IkReal x1140=((25000.00002)*gconst13);
CheckValue<IkReal> x1141=IKPowWithIntegerCheck(IKsign(((((25000.0)*new_r10*new_r11))+(((25000.0)*new_r00*new_r01)))),-1);
if(!x1141.valid){
continue;
}
CheckValue<IkReal> x1142 = IKatan2WithCheck(IkReal(((((-1.0)*new_r11*x1140))+((new_r00*x1139)))),IkReal((((new_r01*x1140))+((new_r10*x1139)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1142.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1141.value)))+(x1142.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1143=IKcos(j5);
IkReal x1144=IKsin(j5);
IkReal x1145=((1.0)*gconst13);
IkReal x1146=((1.0000000008)*x1144);
IkReal x1147=((1.0)*x1144);
IkReal x1148=((1.0000000008)*x1143);
if((((1.0)+(((-1.0)*gconst13*x1145)))) < -0.00001)
continue;
IkReal x1149=IKsqrt(((1.0)+(((-1.0)*gconst13*x1145))));
evalcond[0]=((((-1.0)*x1145))+((new_r01*x1144))+((new_r11*x1143)));
evalcond[1]=(((new_r00*x1143))+(((-1.0000000008)*gconst13))+(((-1.0)*new_r10*x1147)));
evalcond[2]=(x1149+((new_r00*x1144))+((new_r10*x1143)));
evalcond[3]=(((new_r00*x1148))+(((-1.0)*x1145))+(((-1.0)*new_r10*x1146)));
evalcond[4]=((((-1.0)*gconst13*x1148))+new_r00+((x1144*x1149)));
evalcond[5]=(((x1143*x1149))+((gconst13*x1146))+new_r10);
evalcond[6]=(new_r01+(((-1.0)*x1148*x1149))+(((-1.0)*x1144*x1145)));
evalcond[7]=((((-1.0)*x1143*x1145))+((x1146*x1149))+new_r11);
evalcond[8]=(((new_r01*x1143))+(((-1.0)*new_r11*x1147))+(((-1.0000000008)*x1149)));
evalcond[9]=(((new_r01*x1148))+(((-1.0)*x1149))+(((-1.0)*new_r11*x1146)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x1150=new_r00*new_r00;
CheckValue<IkReal> x1151=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x1150))),-1);
if(!x1151.valid){
continue;
}
if((((-1.0)*x1150*(x1151.value))) < -0.00001)
continue;
IkReal gconst13=((-1.0)*(IKsqrt(((-1.0)*x1150*(x1151.value)))));
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs((cj3+(((-1.0)*gconst13)))))+(IKabs(((1.0)+(IKsign(sj3)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[2];
IkReal x1152=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
sj3=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))))));
cj3=gconst13;
if( (gconst13) < -1-IKFAST_SINCOS_THRESH || (gconst13) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=((-1.0)*(IKacos(gconst13)));
CheckValue<IkReal> x1153=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x1152))),-1);
if(!x1153.valid){
continue;
}
if((((-1.0)*x1152*(x1153.value))) < -0.00001)
continue;
IkReal gconst13=((-1.0)*(IKsqrt(((-1.0)*x1152*(x1153.value)))));
IkReal x1154=(new_r00*new_r01);
IkReal x1155=(new_r10*new_r11);
j5eval[0]=(x1155+x1154);
j5eval[1]=IKsign(((((25000.0)*x1155))+(((25000.0)*x1154))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x1156=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
sj3=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))))));
cj3=gconst13;
if( (gconst13) < -1-IKFAST_SINCOS_THRESH || (gconst13) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=((-1.0)*(IKacos(gconst13)));
CheckValue<IkReal> x1157=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x1156))),-1);
if(!x1157.valid){
continue;
}
if((((-1.0)*x1156*(x1157.value))) < -0.00001)
continue;
IkReal gconst13=((-1.0)*(IKsqrt(((-1.0)*x1156*(x1157.value)))));
IkReal x1158=(((new_r01*new_r10))+(((-1.0)*new_r00*new_r11)));
j5eval[0]=x1158;
j5eval[1]=IKsign(x1158);
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x1159=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
sj3=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))))));
cj3=gconst13;
if( (gconst13) < -1-IKFAST_SINCOS_THRESH || (gconst13) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=((-1.0)*(IKacos(gconst13)));
CheckValue<IkReal> x1160=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x1159))),-1);
if(!x1160.valid){
continue;
}
if((((-1.0)*x1159*(x1160.value))) < -0.00001)
continue;
IkReal gconst13=((-1.0)*(IKsqrt(((-1.0)*x1159*(x1160.value)))));
j5eval[0]=new_r01;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(new_r01);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
IkReal x1161=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
sj3=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))))));
cj3=gconst13;
if( (gconst13) < -1-IKFAST_SINCOS_THRESH || (gconst13) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=((-1.0)*(IKacos(gconst13)));
new_r01=0;
CheckValue<IkReal> x1162=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x1161))),-1);
if(!x1162.valid){
continue;
}
if((((-1.0)*x1161*(x1162.value))) < -0.00001)
continue;
IkReal gconst13=((-1.0)*(IKsqrt(((-1.0)*x1161*(x1162.value)))));
j5eval[0]=new_r11;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x1163=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
sj3=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))))));
cj3=gconst13;
if( (gconst13) < -1-IKFAST_SINCOS_THRESH || (gconst13) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=((-1.0)*(IKacos(gconst13)));
new_r01=0;
CheckValue<IkReal> x1164=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x1163))),-1);
if(!x1164.valid){
continue;
}
if((((-1.0)*x1163*(x1164.value))) < -0.00001)
continue;
IkReal gconst13=((-1.0)*(IKsqrt(((-1.0)*x1163*(x1164.value)))));
j5eval[0]=new_r10;
j5eval[1]=new_r11;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x1165=new_r00*new_r00;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
sj3=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))))));
cj3=gconst13;
if( (gconst13) < -1-IKFAST_SINCOS_THRESH || (gconst13) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=((-1.0)*(IKacos(gconst13)));
new_r01=0;
CheckValue<IkReal> x1166=IKPowWithIntegerCheck(((((-1.0000000016)*(new_r10*new_r10)))+(((-1.0)*x1165))),-1);
if(!x1166.valid){
continue;
}
if((((-1.0)*x1165*(x1166.value))) < -0.00001)
continue;
IkReal gconst13=((-1.0)*(IKsqrt(((-1.0)*x1165*(x1166.value)))));
j5eval[0]=new_r00;
j5eval[1]=new_r11;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1168=IKPowWithIntegerCheck(new_r11,-1);
if(!x1168.valid){
continue;
}
IkReal x1167=x1168.value;
CheckValue<IkReal> x1169=IKPowWithIntegerCheck(new_r00,-1);
if(!x1169.valid){
continue;
}
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
if( IKabs((x1167*(x1169.value)*(((((-1.0)*gconst13*new_r10))+((new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))))))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((gconst13*x1167)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x1167*(x1169.value)*(((((-1.0)*gconst13*new_r10))+((new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13))))))))))))+IKsqr((gconst13*x1167))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((x1167*(x1169.value)*(((((-1.0)*gconst13*new_r10))+((new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13))))))))))), (gconst13*x1167));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1170=IKcos(j5);
IkReal x1171=IKsin(j5);
IkReal x1172=((1.0)*gconst13);
IkReal x1173=((1.0000000008)*gconst13);
IkReal x1174=(new_r11*x1171);
IkReal x1175=(new_r00*x1170);
IkReal x1176=(new_r10*x1171);
if((((1.0)+(((-1.0)*gconst13*x1172)))) < -0.00001)
continue;
IkReal x1177=IKsqrt(((1.0)+(((-1.0)*gconst13*x1172))));
IkReal x1178=(x1171*x1177);
IkReal x1179=(x1170*x1177);
evalcond[0]=(((new_r11*x1170))+(((-1.0)*x1172)));
evalcond[1]=(x1175+(((-1.0)*x1173))+(((-1.0)*x1176)));
evalcond[2]=(x1177+(((-1.0000000008)*x1174)));
evalcond[3]=((((1.0000000008)*x1177))+(((-1.0)*x1174)));
evalcond[4]=(((new_r10*x1170))+((new_r00*x1171))+(((-1.0)*x1177)));
evalcond[5]=((((1.0000000008)*x1175))+(((-1.0000000008)*x1176))+(((-1.0)*x1172)));
evalcond[6]=((((1.0000000008)*x1179))+(((-1.0)*x1171*x1172)));
evalcond[7]=((((-1.0)*x1170*x1173))+new_r00+(((-1.0)*x1178)));
evalcond[8]=(new_r10+((x1171*x1173))+(((-1.0)*x1179)));
evalcond[9]=((((-1.0000000008)*x1178))+(((-1.0)*x1170*x1172))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1181=IKPowWithIntegerCheck(new_r11,-1);
if(!x1181.valid){
continue;
}
IkReal x1180=x1181.value;
CheckValue<IkReal> x1182=IKPowWithIntegerCheck(new_r10,-1);
if(!x1182.valid){
continue;
}
if( IKabs(((4.0e-5)*x1180*(x1182.value)*(((((25000.0)*gconst13*new_r00))+(((-25000.00002)*gconst13*new_r11)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((gconst13*x1180)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((4.0e-5)*x1180*(x1182.value)*(((((25000.0)*gconst13*new_r00))+(((-25000.00002)*gconst13*new_r11))))))+IKsqr((gconst13*x1180))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((4.0e-5)*x1180*(x1182.value)*(((((25000.0)*gconst13*new_r00))+(((-25000.00002)*gconst13*new_r11))))), (gconst13*x1180));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1183=IKcos(j5);
IkReal x1184=IKsin(j5);
IkReal x1185=((1.0)*gconst13);
IkReal x1186=((1.0000000008)*gconst13);
IkReal x1187=(new_r11*x1184);
IkReal x1188=(new_r00*x1183);
IkReal x1189=(new_r10*x1184);
if((((1.0)+(((-1.0)*gconst13*x1185)))) < -0.00001)
continue;
IkReal x1190=IKsqrt(((1.0)+(((-1.0)*gconst13*x1185))));
IkReal x1191=(x1184*x1190);
IkReal x1192=(x1183*x1190);
evalcond[0]=((((-1.0)*x1185))+((new_r11*x1183)));
evalcond[1]=(x1188+(((-1.0)*x1186))+(((-1.0)*x1189)));
evalcond[2]=(x1190+(((-1.0000000008)*x1187)));
evalcond[3]=((((1.0000000008)*x1190))+(((-1.0)*x1187)));
evalcond[4]=(((new_r10*x1183))+((new_r00*x1184))+(((-1.0)*x1190)));
evalcond[5]=((((1.0000000008)*x1188))+(((-1.0)*x1185))+(((-1.0000000008)*x1189)));
evalcond[6]=((((1.0000000008)*x1192))+(((-1.0)*x1184*x1185)));
evalcond[7]=((((-1.0)*x1183*x1186))+new_r00+(((-1.0)*x1191)));
evalcond[8]=(((x1184*x1186))+new_r10+(((-1.0)*x1192)));
evalcond[9]=((((-1.0000000008)*x1191))+(((-1.0)*x1183*x1185))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1194=IKPowWithIntegerCheck(new_r11,-1);
if(!x1194.valid){
continue;
}
IkReal x1193=x1194.value;
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
if( IKabs(((0.9999999992)*x1193*(IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((gconst13*x1193)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.9999999992)*x1193*(IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13))))))))+IKsqr((gconst13*x1193))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((0.9999999992)*x1193*(IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13))))))), (gconst13*x1193));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1195=IKcos(j5);
IkReal x1196=IKsin(j5);
IkReal x1197=((1.0)*gconst13);
IkReal x1198=((1.0000000008)*gconst13);
IkReal x1199=(new_r11*x1196);
IkReal x1200=(new_r00*x1195);
IkReal x1201=(new_r10*x1196);
if((((1.0)+(((-1.0)*gconst13*x1197)))) < -0.00001)
continue;
IkReal x1202=IKsqrt(((1.0)+(((-1.0)*gconst13*x1197))));
IkReal x1203=(x1196*x1202);
IkReal x1204=(x1195*x1202);
evalcond[0]=((((-1.0)*x1197))+((new_r11*x1195)));
evalcond[1]=(x1200+(((-1.0)*x1198))+(((-1.0)*x1201)));
evalcond[2]=(x1202+(((-1.0000000008)*x1199)));
evalcond[3]=((((1.0000000008)*x1202))+(((-1.0)*x1199)));
evalcond[4]=((((-1.0)*x1202))+((new_r00*x1196))+((new_r10*x1195)));
evalcond[5]=((((-1.0)*x1197))+(((1.0000000008)*x1200))+(((-1.0000000008)*x1201)));
evalcond[6]=((((1.0000000008)*x1204))+(((-1.0)*x1196*x1197)));
evalcond[7]=((((-1.0)*x1195*x1198))+(((-1.0)*x1203))+new_r00);
evalcond[8]=(((x1196*x1198))+(((-1.0)*x1204))+new_r10);
evalcond[9]=((((-1.0)*x1195*x1197))+(((-1.0000000008)*x1203))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r00)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
cj5array[0]=new_r10;
if( cj5array[0] >= -1-IKFAST_SINCOS_THRESH && cj5array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j5valid[0] = j5valid[1] = true;
    j5array[0] = IKacos(cj5array[0]);
    sj5array[0] = IKsin(j5array[0]);
    cj5array[1] = cj5array[0];
    j5array[1] = -j5array[0];
    sj5array[1] = -sj5array[0];
}
else if( isnan(cj5array[0]) )
{
    // probably any value will work
    j5valid[0] = true;
    cj5array[0] = 1; sj5array[0] = 0; j5array[0] = 0;
}
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[9];
IkReal x1205=IKsin(j5);
IkReal x1206=IKcos(j5);
IkReal x1207=((1.0000000008)*x1206);
IkReal x1208=((-1.0000000008)*x1205);
IkReal x1209=((-1.0)*x1205);
evalcond[0]=(new_r01*x1205);
evalcond[1]=x1209;
evalcond[2]=(new_r10*x1209);
evalcond[3]=((-1.0)+((new_r10*x1206)));
evalcond[4]=x1208;
evalcond[5]=(new_r10*x1208);
evalcond[6]=(x1207+new_r01);
evalcond[7]=((1.0000000008)+((new_r01*x1206)));
evalcond[8]=((1.0)+((new_r01*x1207)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(((0.9999999992)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.9999999992)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.9999999992)*new_r11))+IKsqr(((-0.9999999992)*new_r01))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((0.9999999992)*new_r11), ((-0.9999999992)*new_r01));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x1210=IKcos(j5);
IkReal x1211=IKsin(j5);
IkReal x1212=((1.0000000008)*x1211);
IkReal x1213=((1.0000000008)*x1210);
evalcond[0]=((-1.0)*x1211);
evalcond[1]=((-1.0)*x1210);
evalcond[2]=(x1213+new_r01);
evalcond[3]=(new_r11+(((-1.0)*x1212)));
evalcond[4]=(((new_r11*x1210))+((new_r01*x1211)));
evalcond[5]=((1.0000000008)+((new_r01*x1210))+(((-1.0)*new_r11*x1211)));
evalcond[6]=((1.0)+((new_r01*x1213))+(((-1.0)*new_r11*x1212)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1221=IKPowWithIntegerCheck(new_r01,-1);
if(!x1221.valid){
continue;
}
IkReal x1214=x1221.value;
IkReal x1215=((25000.0)*new_r00);
IkReal x1216=(gconst13*x1214);
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
IkReal x1217=IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))));
IkReal x1218=((25000.0)*new_r11*x1217);
CheckValue<IkReal> x1222=IKPowWithIntegerCheck(((((25000.00002)*gconst13*new_r01))+(((-1.0)*x1218))),-1);
if(!x1222.valid){
continue;
}
IkReal x1219=x1222.value;
IkReal x1220=(new_r11*x1219);
CheckValue<IkReal> x1223=IKPowWithIntegerCheck(((((25000.00002)*gconst13*new_r01))+(((-25000.0)*new_r11*x1217))),-1);
if(!x1223.valid){
continue;
}
if( IKabs((x1216+(((-1.0)*x1215*x1220))+((x1216*x1218*(x1223.value))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x1219*((((new_r01*x1215))+(((-25000.0)*gconst13*x1217)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x1216+(((-1.0)*x1215*x1220))+((x1216*x1218*(x1223.value)))))+IKsqr((x1219*((((new_r01*x1215))+(((-25000.0)*gconst13*x1217))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((x1216+(((-1.0)*x1215*x1220))+((x1216*x1218*(x1223.value)))), (x1219*((((new_r01*x1215))+(((-25000.0)*gconst13*x1217))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1224=IKcos(j5);
IkReal x1225=IKsin(j5);
IkReal x1226=((1.0)*gconst13);
IkReal x1227=((1.0000000008)*gconst13);
IkReal x1228=(new_r11*x1225);
IkReal x1229=(new_r01*x1224);
IkReal x1230=(new_r00*x1224);
IkReal x1231=(new_r10*x1225);
IkReal x1232=x1217;
IkReal x1233=(x1225*x1232);
IkReal x1234=(x1224*x1232);
evalcond[0]=((((-1.0)*x1226))+((new_r11*x1224))+((new_r01*x1225)));
evalcond[1]=((((-1.0)*x1231))+x1230+(((-1.0)*x1227)));
evalcond[2]=((((-1.0)*x1232))+((new_r00*x1225))+((new_r10*x1224)));
evalcond[3]=((((-1.0)*x1226))+(((-1.0000000008)*x1231))+(((1.0000000008)*x1230)));
evalcond[4]=((((-1.0)*x1233))+(((-1.0)*x1224*x1227))+new_r00);
evalcond[5]=((((-1.0)*x1234))+((x1225*x1227))+new_r10);
evalcond[6]=((((-1.0)*x1225*x1226))+new_r01+(((1.0000000008)*x1234)));
evalcond[7]=((((-1.0)*x1224*x1226))+(((-1.0000000008)*x1233))+new_r11);
evalcond[8]=(x1229+(((-1.0)*x1228))+(((1.0000000008)*x1232)));
evalcond[9]=(x1232+(((-1.0000000008)*x1228))+(((1.0000000008)*x1229)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1235=((1.0)*new_r11);
if((((1.0)+(((-1.0)*(gconst13*gconst13))))) < -0.00001)
continue;
IkReal x1236=IKsqrt(((1.0)+(((-1.0)*(gconst13*gconst13)))));
CheckValue<IkReal> x1237 = IKatan2WithCheck(IkReal(((((-1.0)*x1235*x1236))+((gconst13*new_r10)))),IkReal(((((-1.0)*gconst13*new_r00))+((new_r01*x1236)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1237.valid){
continue;
}
CheckValue<IkReal> x1238=IKPowWithIntegerCheck(IKsign(((((-1.0)*new_r00*x1235))+((new_r01*new_r10)))),-1);
if(!x1238.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x1237.value)+(((1.5707963267949)*(x1238.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1239=IKcos(j5);
IkReal x1240=IKsin(j5);
IkReal x1241=((1.0)*gconst13);
IkReal x1242=((1.0000000008)*gconst13);
IkReal x1243=(new_r11*x1240);
IkReal x1244=(new_r01*x1239);
IkReal x1245=(new_r00*x1239);
IkReal x1246=(new_r10*x1240);
IkReal x1247=x1236;
IkReal x1248=(x1240*x1247);
IkReal x1249=(x1239*x1247);
evalcond[0]=((((-1.0)*x1241))+((new_r11*x1239))+((new_r01*x1240)));
evalcond[1]=(x1245+(((-1.0)*x1246))+(((-1.0)*x1242)));
evalcond[2]=((((-1.0)*x1247))+((new_r10*x1239))+((new_r00*x1240)));
evalcond[3]=((((1.0000000008)*x1245))+(((-1.0)*x1241))+(((-1.0000000008)*x1246)));
evalcond[4]=((((-1.0)*x1239*x1242))+(((-1.0)*x1248))+new_r00);
evalcond[5]=(((x1240*x1242))+(((-1.0)*x1249))+new_r10);
evalcond[6]=((((1.0000000008)*x1249))+(((-1.0)*x1240*x1241))+new_r01);
evalcond[7]=((((-1.0)*x1239*x1241))+new_r11+(((-1.0000000008)*x1248)));
evalcond[8]=(x1244+(((1.0000000008)*x1247))+(((-1.0)*x1243)));
evalcond[9]=(x1247+(((1.0000000008)*x1244))+(((-1.0000000008)*x1243)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1250=((25000.0)*gconst13);
IkReal x1251=((25000.00002)*gconst13);
CheckValue<IkReal> x1252=IKPowWithIntegerCheck(IKsign(((((25000.0)*new_r10*new_r11))+(((25000.0)*new_r00*new_r01)))),-1);
if(!x1252.valid){
continue;
}
CheckValue<IkReal> x1253 = IKatan2WithCheck(IkReal(((((-1.0)*new_r11*x1251))+((new_r00*x1250)))),IkReal((((new_r01*x1251))+((new_r10*x1250)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1253.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1252.value)))+(x1253.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1254=IKcos(j5);
IkReal x1255=IKsin(j5);
IkReal x1256=((1.0)*gconst13);
IkReal x1257=((1.0000000008)*gconst13);
IkReal x1258=(new_r11*x1255);
IkReal x1259=(new_r01*x1254);
IkReal x1260=(new_r00*x1254);
IkReal x1261=(new_r10*x1255);
if((((1.0)+(((-1.0)*gconst13*x1256)))) < -0.00001)
continue;
IkReal x1262=IKsqrt(((1.0)+(((-1.0)*gconst13*x1256))));
IkReal x1263=(x1255*x1262);
IkReal x1264=(x1254*x1262);
evalcond[0]=((((-1.0)*x1256))+((new_r01*x1255))+((new_r11*x1254)));
evalcond[1]=((((-1.0)*x1257))+x1260+(((-1.0)*x1261)));
evalcond[2]=(((new_r00*x1255))+(((-1.0)*x1262))+((new_r10*x1254)));
evalcond[3]=((((-1.0)*x1256))+(((1.0000000008)*x1260))+(((-1.0000000008)*x1261)));
evalcond[4]=((((-1.0)*x1254*x1257))+new_r00+(((-1.0)*x1263)));
evalcond[5]=(((x1255*x1257))+new_r10+(((-1.0)*x1264)));
evalcond[6]=((((-1.0)*x1255*x1256))+(((1.0000000008)*x1264))+new_r01);
evalcond[7]=((((-1.0000000008)*x1263))+(((-1.0)*x1254*x1256))+new_r11);
evalcond[8]=(x1259+(((1.0000000008)*x1262))+(((-1.0)*x1258)));
evalcond[9]=(x1262+(((1.0000000008)*x1259))+(((-1.0000000008)*x1258)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x1266 = ((((1.0000000016)*(new_r10*new_r10)))+(new_r00*new_r00));
if(IKabs(x1266)==0){
continue;
}
IkReal x1265=pow(x1266,-0.5);
CheckValue<IkReal> x1267 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1267.valid){
continue;
}
IkReal gconst14=((-1.0)*(x1267.value));
IkReal gconst15=((1.0000000008)*new_r10*x1265);
IkReal gconst16=(new_r00*x1265);
CheckValue<IkReal> x1268 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1268.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((x1268.value)+j3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
IkReal x1269=x1265;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst15;
cj3=gconst16;
CheckValue<IkReal> x1270 = IKatan2WithCheck(IkReal(((-1.0)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1270.valid){
continue;
}
j3=((-1.0)*(x1270.value));
CheckValue<IkReal> x1271 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1271.valid){
continue;
}
IkReal gconst14=((-1.0)*(x1271.value));
IkReal gconst15=((1.0000000008)*new_r10*x1269);
IkReal gconst16=(new_r00*x1269);
IkReal x1272=new_r00*new_r00;
IkReal x1273=(new_r01*new_r10);
IkReal x1274=(x1273+(((-1.0)*new_r00*new_r11)));
IkReal x1277 = ((((625000001.0)*(new_r10*new_r10)))+(((625000000.0)*x1272)));
if(IKabs(x1277)==0){
continue;
}
IkReal x1275=pow(x1277,-0.5);
IkReal x1276=(new_r10*x1275);
j5eval[0]=x1274;
j5eval[1]=IKsign(x1274);
j5eval[2]=((IKabs(((((25000.0)*new_r00*x1276))+(((25000.00002)*new_r11*x1276)))))+(IKabs(((((25000.0)*x1272*x1275))+(((25000.00002)*x1273*x1275))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x1278=x1265;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst15;
cj3=gconst16;
CheckValue<IkReal> x1279 = IKatan2WithCheck(IkReal(((-1.0)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1279.valid){
continue;
}
j3=((-1.0)*(x1279.value));
CheckValue<IkReal> x1280 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1280.valid){
continue;
}
IkReal gconst14=((-1.0)*(x1280.value));
IkReal gconst15=((1.0000000008)*new_r10*x1278);
IkReal gconst16=(new_r00*x1278);
j5eval[0]=new_r00;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x1281=x1265;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst15;
cj3=gconst16;
CheckValue<IkReal> x1282 = IKatan2WithCheck(IkReal(((-1.0)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1282.valid){
continue;
}
j3=((-1.0)*(x1282.value));
CheckValue<IkReal> x1283 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1283.valid){
continue;
}
IkReal gconst14=((-1.0)*(x1283.value));
IkReal gconst15=((1.0000000008)*new_r10*x1281);
IkReal gconst16=(new_r00*x1281);
j5eval[0]=new_r00;
IkReal x1284 = ((((1.0000000016)*(new_r10*new_r10)))+(new_r00*new_r00));
if(IKabs(x1284)==0){
continue;
}
j5eval[1]=((-1.6e-9)*new_r00*new_r10*(pow(x1284,-0.5)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(new_r00);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst15;
cj3=gconst16;
CheckValue<IkReal> x1285 = IKatan2WithCheck(IkReal(((-1.0)*new_r10)),IkReal(0),IKFAST_ATAN2_MAGTHRESH);
if(!x1285.valid){
continue;
}
j3=((-1.0)*(x1285.value));
new_r00=0;
CheckValue<IkReal> x1286 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(0),IKFAST_ATAN2_MAGTHRESH);
if(!x1286.valid){
continue;
}
IkReal gconst14=((-1.0)*(x1286.value));
IkReal x1287 = new_r10*new_r10;
if(IKabs(x1287)==0){
continue;
}
IkReal gconst15=(new_r10*(pow(x1287,-0.5)));
IkReal gconst16=0;
j5eval[0]=new_r10;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1289=IKPowWithIntegerCheck(gconst15,-1);
if(!x1289.valid){
continue;
}
IkReal x1288=x1289.value;
if( IKabs(((-0.9999999992)*new_r11*x1288)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10*x1288)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-0.9999999992)*new_r11*x1288))+IKsqr(((-1.0)*new_r10*x1288))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-0.9999999992)*new_r11*x1288), ((-1.0)*new_r10*x1288));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1290=IKsin(j5);
IkReal x1291=IKcos(j5);
IkReal x1292=(gconst15*x1290);
IkReal x1293=(new_r11*x1290);
IkReal x1294=(gconst15*x1291);
IkReal x1295=(new_r10*x1290);
IkReal x1296=(new_r01*x1291);
evalcond[0]=x1292;
evalcond[1]=((-1.0)*x1295);
evalcond[2]=(gconst15+((new_r10*x1291)));
evalcond[3]=(x1294+new_r10);
evalcond[4]=((-1.0000000008)*x1295);
evalcond[5]=(((new_r11*x1291))+((new_r01*x1290)));
evalcond[6]=((((-1.0000000008)*x1294))+new_r01);
evalcond[7]=((((1.0000000008)*x1292))+new_r11);
evalcond[8]=(x1296+(((-1.0000000008)*gconst15))+(((-1.0)*x1293)));
evalcond[9]=((((1.0000000008)*x1296))+(((-1.0000000008)*x1293))+(((-1.0)*gconst15)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1297=IKPowWithIntegerCheck(gconst15,-1);
if(!x1297.valid){
continue;
}
CheckValue<IkReal> x1298=IKPowWithIntegerCheck(new_r10,-1);
if(!x1298.valid){
continue;
}
if( IKabs(((-0.9999999992)*new_r11*(x1297.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*gconst15*(x1298.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-0.9999999992)*new_r11*(x1297.value)))+IKsqr(((-1.0)*gconst15*(x1298.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-0.9999999992)*new_r11*(x1297.value)), ((-1.0)*gconst15*(x1298.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1299=IKsin(j5);
IkReal x1300=IKcos(j5);
IkReal x1301=(gconst15*x1299);
IkReal x1302=(new_r11*x1299);
IkReal x1303=(gconst15*x1300);
IkReal x1304=(new_r10*x1299);
IkReal x1305=(new_r01*x1300);
evalcond[0]=x1301;
evalcond[1]=((-1.0)*x1304);
evalcond[2]=(gconst15+((new_r10*x1300)));
evalcond[3]=(x1303+new_r10);
evalcond[4]=((-1.0000000008)*x1304);
evalcond[5]=(((new_r11*x1300))+((new_r01*x1299)));
evalcond[6]=((((-1.0000000008)*x1303))+new_r01);
evalcond[7]=((((1.0000000008)*x1301))+new_r11);
evalcond[8]=(x1305+(((-1.0)*x1302))+(((-1.0000000008)*gconst15)));
evalcond[9]=((((-1.0000000008)*x1302))+(((1.0000000008)*x1305))+(((-1.0)*gconst15)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[5];
IkReal x1307 = ((1.0)+(((1.6e-9)*(new_r10*new_r10))));
if(IKabs(x1307)==0){
continue;
}
IkReal x1306=pow(x1307,-0.5);
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst15;
cj3=gconst16;
CheckValue<IkReal> x1308 = IKatan2WithCheck(IkReal(((-1.0)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1308.valid){
continue;
}
j3=((-1.0)*(x1308.value));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x1309 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1309.valid){
continue;
}
IkReal gconst14=((-1.0)*(x1309.value));
IkReal gconst15=((1.0000000008)*new_r10*x1306);
IkReal gconst16=(new_r00*x1306);
j5eval[0]=-1.0;
j5eval[1]=3.90625000625e+17;
j5eval[2]=((1.0)+(((1.6e-9)*(new_r10*new_r10))));
j5eval[3]=1.0;
j5eval[4]=-1.0;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  || IKabs(j5eval[3]) < 0.0000010000000000  || IKabs(j5eval[4]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x1311 = ((1.0)+(((1.6e-9)*(new_r10*new_r10))));
if(IKabs(x1311)==0){
continue;
}
IkReal x1310=pow(x1311,-0.5);
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst15;
cj3=gconst16;
CheckValue<IkReal> x1312 = IKatan2WithCheck(IkReal(((-1.0)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1312.valid){
continue;
}
j3=((-1.0)*(x1312.value));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x1313 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1313.valid){
continue;
}
IkReal gconst14=((-1.0)*(x1313.value));
IkReal gconst15=((1.0000000008)*new_r10*x1310);
IkReal gconst16=(new_r00*x1310);
IkReal x1314=new_r10*new_r10;
CheckValue<IkReal> x1316=IKPowWithIntegerCheck(((1.0)+(((1.6e-9)*x1314))),-1);
if(!x1316.valid){
continue;
}
IkReal x1315=x1316.value;
IkReal x1317=((1.0)+(((-1.0)*x1314)));
j5eval[0]=IKsign(((((625000002.0)*x1315*(x1314*x1314)))+(((-625000000.0)*x1315*(x1317*x1317)))));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x1319 = ((1.0)+(((1.6e-9)*(new_r10*new_r10))));
if(IKabs(x1319)==0){
continue;
}
IkReal x1318=pow(x1319,-0.5);
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst15;
cj3=gconst16;
CheckValue<IkReal> x1320 = IKatan2WithCheck(IkReal(((-1.0)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1320.valid){
continue;
}
j3=((-1.0)*(x1320.value));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x1321 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1321.valid){
continue;
}
IkReal gconst14=((-1.0)*(x1321.value));
IkReal gconst15=((1.0000000008)*new_r10*x1318);
IkReal gconst16=(new_r00*x1318);
IkReal x1322=new_r10*new_r10;
IkReal x1323=((1.0)+(((1.6e-9)*x1322)));
CheckValue<IkReal> x1324=IKPowWithIntegerCheck(x1323,-1);
if(!x1324.valid){
continue;
}
j5eval[0]=((-3.20000000256e-9)*x1322*(x1324.value)*(((1.0)+(((-1.0)*x1322)))));
IkReal x1325 = x1323;
if(IKabs(x1325)==0){
continue;
}
j5eval[1]=((-1.6e-9)*new_r00*new_r10*(pow(x1325,-0.5)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1326=gconst15*gconst15;
IkReal x1327=(gconst16*new_r10);
CheckValue<IkReal> x1328=IKPowWithIntegerCheck(((((625000000.0)*(x1327*x1327)))+(((-625000001.0)*x1326*(new_r00*new_r00)))),-1);
if(!x1328.valid){
continue;
}
CheckValue<IkReal> x1329=IKPowWithIntegerCheck(((((25000.0)*x1327))+(((-25000.00002)*gconst15*new_r00))),-1);
if(!x1329.valid){
continue;
}
if( IKabs(((x1328.value)*(((((625000000.5)*x1326*x1327))+(((625000001.0)*new_r00*(gconst15*gconst15*gconst15))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-25000.0)*gconst15*gconst16*(x1329.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1328.value)*(((((625000000.5)*x1326*x1327))+(((625000001.0)*new_r00*(gconst15*gconst15*gconst15)))))))+IKsqr(((-25000.0)*gconst15*gconst16*(x1329.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((x1328.value)*(((((625000000.5)*x1326*x1327))+(((625000001.0)*new_r00*(gconst15*gconst15*gconst15)))))), ((-25000.0)*gconst15*gconst16*(x1329.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x1330=IKsin(j5);
IkReal x1331=IKcos(j5);
IkReal x1332=((1.0000000008)*gconst16);
IkReal x1333=((1.0)*gconst16);
IkReal x1334=((1.0000000008)*x1330);
IkReal x1335=((1.0)*x1330);
IkReal x1336=(gconst15*x1331);
IkReal x1337=(new_r00*x1331);
evalcond[0]=(((new_r10*x1331))+gconst15+((new_r00*x1330)));
evalcond[1]=(((gconst15*x1330))+(((-1.0)*x1331*x1332))+new_r00);
evalcond[2]=(x1336+((x1330*x1332))+new_r10);
evalcond[3]=((((-1.0)*x1330*x1333))+(((-1.0000000008)*x1336)));
evalcond[4]=(((gconst15*x1334))+(((-1.0)*x1331*x1333)));
evalcond[5]=(x1337+(((-1.0)*new_r10*x1335))+(((-1.0)*x1332)));
evalcond[6]=((((-1.0)*new_r10*x1334))+(((-1.0)*x1333))+(((1.0000000008)*x1337)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1338=gconst16*gconst16;
IkReal x1339=gconst15*gconst15;
IkReal x1340=((625000000.0)*x1338);
IkReal x1341=((625000000.5)*gconst16*x1339);
CheckValue<IkReal> x1342=IKPowWithIntegerCheck(IKsign(((((-1.0)*x1340*(new_r00*new_r00)))+(((625000001.0)*x1339*(new_r10*new_r10))))),-1);
if(!x1342.valid){
continue;
}
CheckValue<IkReal> x1343 = IKatan2WithCheck(IkReal((((gconst15*new_r00*x1340))+(((-1.0)*new_r10*x1341)))),IkReal(((((-625000001.0)*new_r10*(gconst15*gconst15*gconst15)))+((new_r00*x1341)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1343.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1342.value)))+(x1343.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x1344=IKsin(j5);
IkReal x1345=IKcos(j5);
IkReal x1346=((1.0000000008)*gconst16);
IkReal x1347=((1.0)*gconst16);
IkReal x1348=((1.0000000008)*x1344);
IkReal x1349=((1.0)*x1344);
IkReal x1350=(gconst15*x1345);
IkReal x1351=(new_r00*x1345);
evalcond[0]=(gconst15+((new_r00*x1344))+((new_r10*x1345)));
evalcond[1]=(new_r00+((gconst15*x1344))+(((-1.0)*x1345*x1346)));
evalcond[2]=(x1350+((x1344*x1346))+new_r10);
evalcond[3]=((((-1.0000000008)*x1350))+(((-1.0)*x1344*x1347)));
evalcond[4]=(((gconst15*x1348))+(((-1.0)*x1345*x1347)));
evalcond[5]=(x1351+(((-1.0)*x1346))+(((-1.0)*new_r10*x1349)));
evalcond[6]=((((-1.0)*x1347))+(((-1.0)*new_r10*x1348))+(((1.0000000008)*x1351)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1352=((25000.0)*gconst15);
IkReal x1353=((25000.00002)*gconst16);
CheckValue<IkReal> x1354=IKPowWithIntegerCheck(IKsign(((((-25000.0)*(new_r10*new_r10)))+(((-25000.0)*(new_r00*new_r00))))),-1);
if(!x1354.valid){
continue;
}
CheckValue<IkReal> x1355 = IKatan2WithCheck(IkReal((((new_r10*x1353))+((new_r00*x1352)))),IkReal((((new_r10*x1352))+(((-1.0)*new_r00*x1353)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1355.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1354.value)))+(x1355.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x1356=IKsin(j5);
IkReal x1357=IKcos(j5);
IkReal x1358=((1.0000000008)*gconst16);
IkReal x1359=((1.0)*gconst16);
IkReal x1360=((1.0000000008)*x1356);
IkReal x1361=((1.0)*x1356);
IkReal x1362=(gconst15*x1357);
IkReal x1363=(new_r00*x1357);
evalcond[0]=(((new_r10*x1357))+gconst15+((new_r00*x1356)));
evalcond[1]=(((gconst15*x1356))+new_r00+(((-1.0)*x1357*x1358)));
evalcond[2]=(x1362+new_r10+((x1356*x1358)));
evalcond[3]=((((-1.0000000008)*x1362))+(((-1.0)*x1356*x1359)));
evalcond[4]=(((gconst15*x1360))+(((-1.0)*x1357*x1359)));
evalcond[5]=(x1363+(((-1.0)*x1358))+(((-1.0)*new_r10*x1361)));
evalcond[6]=((((-1.0)*x1359))+(((1.0000000008)*x1363))+(((-1.0)*new_r10*x1360)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1365=IKPowWithIntegerCheck(gconst16,-1);
if(!x1365.valid){
continue;
}
IkReal x1364=x1365.value;
if( IKabs((new_r01*x1364)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((0.9999999992)*new_r00*x1364)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r01*x1364))+IKsqr(((0.9999999992)*new_r00*x1364))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((new_r01*x1364), ((0.9999999992)*new_r00*x1364));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1366=IKcos(j5);
IkReal x1367=IKsin(j5);
IkReal x1368=((1.0)*gconst16);
IkReal x1369=((1.0000000008)*gconst16);
IkReal x1370=(new_r00*x1366);
IkReal x1371=(new_r01*x1366);
evalcond[0]=(new_r00*x1367);
evalcond[1]=x1371;
evalcond[2]=((-1.0)*gconst16*x1366);
evalcond[3]=(new_r01+(((-1.0)*x1367*x1368)));
evalcond[4]=(((new_r01*x1367))+(((-1.0)*x1368)));
evalcond[5]=(x1367*x1369);
evalcond[6]=((1.0000000008)*x1371);
evalcond[7]=((((-1.0)*x1366*x1369))+new_r00);
evalcond[8]=(x1370+(((-1.0)*x1369)));
evalcond[9]=((((1.0000000008)*x1370))+(((-1.0)*x1368)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1378=IKPowWithIntegerCheck(new_r00,-1);
if(!x1378.valid){
continue;
}
IkReal x1372=x1378.value;
IkReal x1373=((25000.0)*gconst16);
IkReal x1374=((25000.0)*new_r01);
IkReal x1375=(gconst15*x1372);
CheckValue<IkReal> x1379=IKPowWithIntegerCheck(((((-25000.00002)*gconst15*new_r00))+((new_r10*x1373))),-1);
if(!x1379.valid){
continue;
}
IkReal x1376=x1379.value;
IkReal x1377=(new_r10*x1376);
CheckValue<IkReal> x1380=IKPowWithIntegerCheck(((((25000.0)*gconst16*new_r10))+(((-25000.00002)*gconst15*new_r00))),-1);
if(!x1380.valid){
continue;
}
if( IKabs(((((-1.0)*x1375))+((new_r10*x1373*x1375*(x1380.value)))+((x1374*x1377)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x1376*(((((-1.0)*new_r00*x1374))+(((-1.0)*gconst15*x1373)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*x1375))+((new_r10*x1373*x1375*(x1380.value)))+((x1374*x1377))))+IKsqr((x1376*(((((-1.0)*new_r00*x1374))+(((-1.0)*gconst15*x1373))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*x1375))+((new_r10*x1373*x1375*(x1380.value)))+((x1374*x1377))), (x1376*(((((-1.0)*new_r00*x1374))+(((-1.0)*gconst15*x1373))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1381=IKcos(j5);
IkReal x1382=IKsin(j5);
IkReal x1383=((1.0)*gconst16);
IkReal x1384=((1.0000000008)*gconst15);
IkReal x1385=((1.0000000008)*gconst16);
IkReal x1386=(gconst15*x1381);
IkReal x1387=(new_r00*x1381);
IkReal x1388=((1.0000000008)*x1382);
IkReal x1389=(new_r01*x1381);
IkReal x1390=((1.0)*x1382);
evalcond[0]=(((new_r10*x1381))+gconst15+((new_r00*x1382)));
evalcond[1]=((((-1.0)*x1383))+((new_r11*x1381))+((new_r01*x1382)));
evalcond[2]=(((gconst15*x1382))+(((-1.0)*x1381*x1385))+new_r00);
evalcond[3]=(x1386+new_r10+((x1382*x1385)));
evalcond[4]=((((-1.0)*x1382*x1383))+(((-1.0)*x1381*x1384))+new_r01);
evalcond[5]=((((-1.0)*x1381*x1383))+new_r11+((x1382*x1384)));
evalcond[6]=((((-1.0)*x1385))+x1387+(((-1.0)*new_r10*x1390)));
evalcond[7]=((((-1.0)*x1384))+x1389+(((-1.0)*new_r11*x1390)));
evalcond[8]=((((-1.0)*x1383))+(((1.0000000008)*x1387))+(((-1.0)*new_r10*x1388)));
evalcond[9]=((((1.0000000008)*x1389))+(((-1.0)*new_r11*x1388))+(((-1.0)*gconst15)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1395=IKPowWithIntegerCheck(new_r00,-1);
if(!x1395.valid){
continue;
}
IkReal x1391=x1395.value;
IkReal x1392=gconst15*gconst15;
IkReal x1393=((25000.0)*new_r10);
CheckValue<IkReal> x1396=IKPowWithIntegerCheck(((((25000.00002)*gconst16*new_r00))+((gconst15*x1393))),-1);
if(!x1396.valid){
continue;
}
IkReal x1394=x1396.value;
CheckValue<IkReal> x1397=IKPowWithIntegerCheck(x1391,-2);
if(!x1397.valid){
continue;
}
if( IKabs(((((-1.0)*gconst15*x1391))+(((-1.0)*new_r00*x1393*x1394))+((x1391*x1392*x1393*x1394)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x1394*(((((-25000.0)*x1392))+(((25000.0)*(x1397.value))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*gconst15*x1391))+(((-1.0)*new_r00*x1393*x1394))+((x1391*x1392*x1393*x1394))))+IKsqr((x1394*(((((-25000.0)*x1392))+(((25000.0)*(x1397.value)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*gconst15*x1391))+(((-1.0)*new_r00*x1393*x1394))+((x1391*x1392*x1393*x1394))), (x1394*(((((-25000.0)*x1392))+(((25000.0)*(x1397.value)))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1398=IKcos(j5);
IkReal x1399=IKsin(j5);
IkReal x1400=((1.0)*gconst16);
IkReal x1401=((1.0000000008)*gconst15);
IkReal x1402=((1.0000000008)*gconst16);
IkReal x1403=(gconst15*x1398);
IkReal x1404=(new_r00*x1398);
IkReal x1405=((1.0000000008)*x1399);
IkReal x1406=(new_r01*x1398);
IkReal x1407=((1.0)*x1399);
evalcond[0]=(((new_r10*x1398))+gconst15+((new_r00*x1399)));
evalcond[1]=(((new_r11*x1398))+(((-1.0)*x1400))+((new_r01*x1399)));
evalcond[2]=(((gconst15*x1399))+(((-1.0)*x1398*x1402))+new_r00);
evalcond[3]=(((x1399*x1402))+x1403+new_r10);
evalcond[4]=((((-1.0)*x1399*x1400))+(((-1.0)*x1398*x1401))+new_r01);
evalcond[5]=((((-1.0)*x1398*x1400))+((x1399*x1401))+new_r11);
evalcond[6]=((((-1.0)*x1402))+x1404+(((-1.0)*new_r10*x1407)));
evalcond[7]=((((-1.0)*x1401))+x1406+(((-1.0)*new_r11*x1407)));
evalcond[8]=((((1.0000000008)*x1404))+(((-1.0)*x1400))+(((-1.0)*new_r10*x1405)));
evalcond[9]=((((1.0000000008)*x1406))+(((-1.0)*gconst15))+(((-1.0)*new_r11*x1405)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1408=((1.0)*new_r00);
CheckValue<IkReal> x1409=IKPowWithIntegerCheck(IKsign((((new_r01*new_r10))+(((-1.0)*new_r11*x1408)))),-1);
if(!x1409.valid){
continue;
}
CheckValue<IkReal> x1410 = IKatan2WithCheck(IkReal((((gconst16*new_r10))+((gconst15*new_r11)))),IkReal(((((-1.0)*gconst16*x1408))+(((-1.0)*gconst15*new_r01)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1410.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1409.value)))+(x1410.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1411=IKcos(j5);
IkReal x1412=IKsin(j5);
IkReal x1413=((1.0)*gconst16);
IkReal x1414=((1.0000000008)*gconst15);
IkReal x1415=((1.0000000008)*gconst16);
IkReal x1416=(gconst15*x1411);
IkReal x1417=(new_r00*x1411);
IkReal x1418=((1.0000000008)*x1412);
IkReal x1419=(new_r01*x1411);
IkReal x1420=((1.0)*x1412);
evalcond[0]=(((new_r00*x1412))+gconst15+((new_r10*x1411)));
evalcond[1]=(((new_r01*x1412))+(((-1.0)*x1413))+((new_r11*x1411)));
evalcond[2]=((((-1.0)*x1411*x1415))+((gconst15*x1412))+new_r00);
evalcond[3]=(((x1412*x1415))+x1416+new_r10);
evalcond[4]=((((-1.0)*x1412*x1413))+(((-1.0)*x1411*x1414))+new_r01);
evalcond[5]=(((x1412*x1414))+(((-1.0)*x1411*x1413))+new_r11);
evalcond[6]=((((-1.0)*x1415))+(((-1.0)*new_r10*x1420))+x1417);
evalcond[7]=((((-1.0)*x1414))+(((-1.0)*new_r11*x1420))+x1419);
evalcond[8]=((((-1.0)*new_r10*x1418))+(((-1.0)*x1413))+(((1.0000000008)*x1417)));
evalcond[9]=((((-1.0)*new_r11*x1418))+(((1.0000000008)*x1419))+(((-1.0)*gconst15)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x1422 = ((((1.0000000016)*(new_r10*new_r10)))+(new_r00*new_r00));
if(IKabs(x1422)==0){
continue;
}
IkReal x1421=pow(x1422,-0.5);
CheckValue<IkReal> x1423 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1423.valid){
continue;
}
IkReal gconst17=((3.14159265358979)+(((-1.0)*(x1423.value))));
IkReal gconst18=((-1.0000000008)*new_r10*x1421);
IkReal gconst19=((-1.0)*new_r00*x1421);
CheckValue<IkReal> x1424 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1424.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+(x1424.value)+j3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[2];
IkReal x1425=x1421;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst18;
cj3=gconst19;
CheckValue<IkReal> x1426 = IKatan2WithCheck(IkReal(((-1.0)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1426.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x1426.value))));
CheckValue<IkReal> x1427 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1427.valid){
continue;
}
IkReal gconst17=((3.14159265358979)+(((-1.0)*(x1427.value))));
IkReal gconst18=((-1.0000000008)*new_r10*x1425);
IkReal gconst19=((-1.0)*new_r00*x1425);
IkReal x1428=(((new_r01*new_r10))+(((-1.0)*new_r00*new_r11)));
j5eval[0]=x1428;
j5eval[1]=IKsign(x1428);
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x1429=x1421;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst18;
cj3=gconst19;
CheckValue<IkReal> x1430 = IKatan2WithCheck(IkReal(((-1.0)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1430.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x1430.value))));
CheckValue<IkReal> x1431 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1431.valid){
continue;
}
IkReal gconst17=((3.14159265358979)+(((-1.0)*(x1431.value))));
IkReal gconst18=((-1.0000000008)*new_r10*x1429);
IkReal gconst19=((-1.0)*new_r00*x1429);
j5eval[0]=new_r00;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x1432=x1421;
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst18;
cj3=gconst19;
CheckValue<IkReal> x1433 = IKatan2WithCheck(IkReal(((-1.0)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1433.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x1433.value))));
CheckValue<IkReal> x1434 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1434.valid){
continue;
}
IkReal gconst17=((3.14159265358979)+(((-1.0)*(x1434.value))));
IkReal gconst18=((-1.0000000008)*new_r10*x1432);
IkReal gconst19=((-1.0)*new_r00*x1432);
j5eval[0]=new_r00;
IkReal x1435 = ((((1.0000000016)*(new_r10*new_r10)))+(new_r00*new_r00));
if(IKabs(x1435)==0){
continue;
}
j5eval[1]=((1.60000013238459e-9)*new_r00*new_r10*(pow(x1435,-0.5)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(new_r00);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst18;
cj3=gconst19;
CheckValue<IkReal> x1436 = IKatan2WithCheck(IkReal(((-1.0)*new_r10)),IkReal(0),IKFAST_ATAN2_MAGTHRESH);
if(!x1436.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x1436.value))));
new_r00=0;
CheckValue<IkReal> x1437 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(0),IKFAST_ATAN2_MAGTHRESH);
if(!x1437.valid){
continue;
}
IkReal gconst17=((3.14159265358979)+(((-1.0)*(x1437.value))));
IkReal x1438 = new_r10*new_r10;
if(IKabs(x1438)==0){
continue;
}
IkReal gconst18=((-1.0)*new_r10*(pow(x1438,-0.5)));
IkReal gconst19=0;
j5eval[0]=new_r10;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1440=IKPowWithIntegerCheck(gconst18,-1);
if(!x1440.valid){
continue;
}
IkReal x1439=x1440.value;
if( IKabs(((-0.9999999992)*new_r11*x1439)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10*x1439)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-0.9999999992)*new_r11*x1439))+IKsqr(((-1.0)*new_r10*x1439))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-0.9999999992)*new_r11*x1439), ((-1.0)*new_r10*x1439));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1441=IKsin(j5);
IkReal x1442=IKcos(j5);
IkReal x1443=((1.0000000008)*gconst18);
IkReal x1444=(gconst18*x1441);
IkReal x1445=(new_r01*x1442);
IkReal x1446=(new_r11*x1441);
IkReal x1447=(new_r10*x1441);
evalcond[0]=x1444;
evalcond[1]=((-1.0)*x1447);
evalcond[2]=(((new_r10*x1442))+gconst18);
evalcond[3]=(new_r10+((gconst18*x1442)));
evalcond[4]=((-1.0000000008)*x1447);
evalcond[5]=(((new_r11*x1442))+((new_r01*x1441)));
evalcond[6]=(new_r01+(((-1.0)*x1442*x1443)));
evalcond[7]=(((x1441*x1443))+new_r11);
evalcond[8]=((((-1.0)*x1446))+x1445+(((-1.0)*x1443)));
evalcond[9]=((((1.0000000008)*x1445))+(((-1.0)*gconst18))+(((-1.0000000008)*x1446)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1448=IKPowWithIntegerCheck(gconst18,-1);
if(!x1448.valid){
continue;
}
CheckValue<IkReal> x1449=IKPowWithIntegerCheck(new_r10,-1);
if(!x1449.valid){
continue;
}
if( IKabs(((-0.9999999992)*new_r11*(x1448.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*gconst18*(x1449.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-0.9999999992)*new_r11*(x1448.value)))+IKsqr(((-1.0)*gconst18*(x1449.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-0.9999999992)*new_r11*(x1448.value)), ((-1.0)*gconst18*(x1449.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1450=IKsin(j5);
IkReal x1451=IKcos(j5);
IkReal x1452=((1.0000000008)*gconst18);
IkReal x1453=(gconst18*x1450);
IkReal x1454=(new_r01*x1451);
IkReal x1455=(new_r11*x1450);
IkReal x1456=(new_r10*x1450);
evalcond[0]=x1453;
evalcond[1]=((-1.0)*x1456);
evalcond[2]=(gconst18+((new_r10*x1451)));
evalcond[3]=(((gconst18*x1451))+new_r10);
evalcond[4]=((-1.0000000008)*x1456);
evalcond[5]=(((new_r01*x1450))+((new_r11*x1451)));
evalcond[6]=(new_r01+(((-1.0)*x1451*x1452)));
evalcond[7]=(((x1450*x1452))+new_r11);
evalcond[8]=((((-1.0)*x1452))+(((-1.0)*x1455))+x1454);
evalcond[9]=((((1.0000000008)*x1454))+(((-1.0)*gconst18))+(((-1.0000000008)*x1455)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
IkReal x1458 = ((1.0)+(((1.6e-9)*(new_r10*new_r10))));
if(IKabs(x1458)==0){
continue;
}
IkReal x1457=pow(x1458,-0.5);
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst18;
cj3=gconst19;
CheckValue<IkReal> x1459 = IKatan2WithCheck(IkReal(((-1.0)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1459.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x1459.value))));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x1460 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1460.valid){
continue;
}
IkReal gconst17=((3.14159265358979)+(((-1.0)*(x1460.value))));
IkReal gconst18=((-1.0000000008)*new_r10*x1457);
IkReal gconst19=((-1.0)*new_r00*x1457);
IkReal x1461=new_r10*new_r10;
CheckValue<IkReal> x1465=IKPowWithIntegerCheck(((625000000.0)+(((1.0)*x1461))),-1);
if(!x1465.valid){
continue;
}
IkReal x1462=x1465.value;
if((((625000000.0)+x1461)) < -0.00001)
continue;
IkReal x1463=IKsqrt(((625000000.0)+x1461));
IkReal x1464=(x1462*x1463);
j5eval[0]=-1.0;
j5eval[1]=-1.0;
IkReal x1466 = ((1.0)+(((1.6e-9)*x1461)));
if(IKabs(x1466)==0){
continue;
}
j5eval[2]=((IKabs(((50000.00004)*new_r00*new_r10*(pow(x1466,-0.5)))))+(IKabs(((((625000000.5)*x1464))+(((-1250000001.0)*x1461*x1464))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x1468 = ((1.0)+(((1.6e-9)*(new_r10*new_r10))));
if(IKabs(x1468)==0){
continue;
}
IkReal x1467=pow(x1468,-0.5);
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst18;
cj3=gconst19;
CheckValue<IkReal> x1469 = IKatan2WithCheck(IkReal(((-1.0)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1469.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x1469.value))));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x1470 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1470.valid){
continue;
}
IkReal gconst17=((3.14159265358979)+(((-1.0)*(x1470.value))));
IkReal gconst18=((-1.0000000008)*new_r10*x1467);
IkReal gconst19=((-1.0)*new_r00*x1467);
IkReal x1471=new_r10*new_r10;
CheckValue<IkReal> x1473=IKPowWithIntegerCheck(((1.0)+(((1.6e-9)*x1471))),-1);
if(!x1473.valid){
continue;
}
IkReal x1472=x1473.value;
IkReal x1474=((1.0)+(((-1.0)*x1471)));
j5eval[0]=IKsign(((((625000002.0)*x1472*(x1471*x1471)))+(((-625000000.0)*x1472*(x1474*x1474)))));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x1476 = ((1.0)+(((1.6e-9)*(new_r10*new_r10))));
if(IKabs(x1476)==0){
continue;
}
IkReal x1475=pow(x1476,-0.5);
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
sj3=gconst18;
cj3=gconst19;
CheckValue<IkReal> x1477 = IKatan2WithCheck(IkReal(((-1.0)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1477.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x1477.value))));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x1478 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1478.valid){
continue;
}
IkReal gconst17=((3.14159265358979)+(((-1.0)*(x1478.value))));
IkReal gconst18=((-1.0000000008)*new_r10*x1475);
IkReal gconst19=((-1.0)*new_r00*x1475);
IkReal x1479=new_r10*new_r10;
IkReal x1480=((1.0)+(((1.6e-9)*x1479)));
CheckValue<IkReal> x1481=IKPowWithIntegerCheck(x1480,-1);
if(!x1481.valid){
continue;
}
j5eval[0]=((-3.20000004272458e-9)*x1479*(x1481.value)*(((1.0)+(((-1.0)*x1479)))));
IkReal x1482 = x1480;
if(IKabs(x1482)==0){
continue;
}
j5eval[1]=((1.60000013238459e-9)*new_r00*new_r10*(pow(x1482,-0.5)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1483=gconst18*gconst18;
IkReal x1484=(gconst19*new_r10);
CheckValue<IkReal> x1485=IKPowWithIntegerCheck(((((-625000001.0)*x1483*(new_r00*new_r00)))+(((625000000.0)*(x1484*x1484)))),-1);
if(!x1485.valid){
continue;
}
CheckValue<IkReal> x1486=IKPowWithIntegerCheck(((((-25000.00002)*gconst18*new_r00))+(((25000.0)*x1484))),-1);
if(!x1486.valid){
continue;
}
if( IKabs(((x1485.value)*(((((625000000.5)*x1483*x1484))+(((625000001.0)*new_r00*(gconst18*gconst18*gconst18))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-25000.0)*gconst18*gconst19*(x1486.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1485.value)*(((((625000000.5)*x1483*x1484))+(((625000001.0)*new_r00*(gconst18*gconst18*gconst18)))))))+IKsqr(((-25000.0)*gconst18*gconst19*(x1486.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((x1485.value)*(((((625000000.5)*x1483*x1484))+(((625000001.0)*new_r00*(gconst18*gconst18*gconst18)))))), ((-25000.0)*gconst18*gconst19*(x1486.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x1487=IKsin(j5);
IkReal x1488=IKcos(j5);
IkReal x1489=((1.0000000008)*gconst19);
IkReal x1490=((1.0)*gconst19);
IkReal x1491=(gconst18*x1487);
IkReal x1492=(new_r00*x1488);
IkReal x1493=(gconst18*x1488);
IkReal x1494=(new_r10*x1487);
evalcond[0]=(gconst18+((new_r00*x1487))+((new_r10*x1488)));
evalcond[1]=(x1491+(((-1.0)*x1488*x1489))+new_r00);
evalcond[2]=(((x1487*x1489))+x1493+new_r10);
evalcond[3]=((((-1.0000000008)*x1493))+(((-1.0)*x1487*x1490)));
evalcond[4]=((((1.0000000008)*x1491))+(((-1.0)*x1488*x1490)));
evalcond[5]=((((-1.0)*x1489))+(((-1.0)*x1494))+x1492);
evalcond[6]=((((-1.0000000008)*x1494))+(((-1.0)*x1490))+(((1.0000000008)*x1492)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1495=gconst18*gconst18;
IkReal x1496=gconst19*gconst19;
IkReal x1497=((625000000.0)*x1496);
IkReal x1498=((625000000.5)*gconst19*x1495);
CheckValue<IkReal> x1499=IKPowWithIntegerCheck(IKsign(((((625000001.0)*x1495*(new_r10*new_r10)))+(((-1.0)*x1497*(new_r00*new_r00))))),-1);
if(!x1499.valid){
continue;
}
CheckValue<IkReal> x1500 = IKatan2WithCheck(IkReal(((((-1.0)*new_r10*x1498))+((gconst18*new_r00*x1497)))),IkReal(((((-625000001.0)*new_r10*(gconst18*gconst18*gconst18)))+((new_r00*x1498)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1500.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1499.value)))+(x1500.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x1501=IKsin(j5);
IkReal x1502=IKcos(j5);
IkReal x1503=((1.0000000008)*gconst19);
IkReal x1504=((1.0)*gconst19);
IkReal x1505=(gconst18*x1501);
IkReal x1506=(new_r00*x1502);
IkReal x1507=(gconst18*x1502);
IkReal x1508=(new_r10*x1501);
evalcond[0]=(((new_r10*x1502))+gconst18+((new_r00*x1501)));
evalcond[1]=(x1505+new_r00+(((-1.0)*x1502*x1503)));
evalcond[2]=(((x1501*x1503))+x1507+new_r10);
evalcond[3]=((((-1.0)*x1501*x1504))+(((-1.0000000008)*x1507)));
evalcond[4]=((((-1.0)*x1502*x1504))+(((1.0000000008)*x1505)));
evalcond[5]=((((-1.0)*x1503))+(((-1.0)*x1508))+x1506);
evalcond[6]=((((-1.0)*x1504))+(((-1.0000000008)*x1508))+(((1.0000000008)*x1506)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1509=((25000.0)*gconst18);
IkReal x1510=((25000.00002)*gconst19);
CheckValue<IkReal> x1511=IKPowWithIntegerCheck(IKsign(((((-25000.0)*(new_r10*new_r10)))+(((-25000.0)*(new_r00*new_r00))))),-1);
if(!x1511.valid){
continue;
}
CheckValue<IkReal> x1512 = IKatan2WithCheck(IkReal((((new_r10*x1510))+((new_r00*x1509)))),IkReal((((new_r10*x1509))+(((-1.0)*new_r00*x1510)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1512.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1511.value)))+(x1512.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x1513=IKsin(j5);
IkReal x1514=IKcos(j5);
IkReal x1515=((1.0000000008)*gconst19);
IkReal x1516=((1.0)*gconst19);
IkReal x1517=(gconst18*x1513);
IkReal x1518=(new_r00*x1514);
IkReal x1519=(gconst18*x1514);
IkReal x1520=(new_r10*x1513);
evalcond[0]=(((new_r10*x1514))+gconst18+((new_r00*x1513)));
evalcond[1]=(x1517+(((-1.0)*x1514*x1515))+new_r00);
evalcond[2]=(((x1513*x1515))+x1519+new_r10);
evalcond[3]=((((-1.0)*x1513*x1516))+(((-1.0000000008)*x1519)));
evalcond[4]=((((-1.0)*x1514*x1516))+(((1.0000000008)*x1517)));
evalcond[5]=((((-1.0)*x1515))+x1518+(((-1.0)*x1520)));
evalcond[6]=((((-1.0)*x1516))+(((-1.0000000008)*x1520))+(((1.0000000008)*x1518)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1522=IKPowWithIntegerCheck(gconst19,-1);
if(!x1522.valid){
continue;
}
IkReal x1521=x1522.value;
if( IKabs((new_r01*x1521)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((0.9999999992)*new_r00*x1521)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r01*x1521))+IKsqr(((0.9999999992)*new_r00*x1521))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((new_r01*x1521), ((0.9999999992)*new_r00*x1521));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1523=IKcos(j5);
IkReal x1524=IKsin(j5);
IkReal x1525=((1.0)*gconst19);
IkReal x1526=((1.0000000008)*gconst19);
IkReal x1527=(new_r00*x1523);
IkReal x1528=(new_r01*x1523);
evalcond[0]=(new_r00*x1524);
evalcond[1]=x1528;
evalcond[2]=((-1.0)*gconst19*x1523);
evalcond[3]=((((-1.0)*x1524*x1525))+new_r01);
evalcond[4]=((((-1.0)*x1525))+((new_r01*x1524)));
evalcond[5]=(x1524*x1526);
evalcond[6]=((1.0000000008)*x1528);
evalcond[7]=((((-1.0)*x1523*x1526))+new_r00);
evalcond[8]=((((-1.0)*x1526))+x1527);
evalcond[9]=((((-1.0)*x1525))+(((1.0000000008)*x1527)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1534=IKPowWithIntegerCheck(new_r00,-1);
if(!x1534.valid){
continue;
}
IkReal x1529=x1534.value;
IkReal x1530=((25000.0)*new_r10);
IkReal x1531=((25000.0)*gconst18*gconst19);
CheckValue<IkReal> x1535=IKPowWithIntegerCheck(((((-25000.00002)*gconst18*new_r00))+((gconst19*x1530))),-1);
if(!x1535.valid){
continue;
}
IkReal x1532=x1535.value;
IkReal x1533=(new_r10*x1532);
CheckValue<IkReal> x1536=IKPowWithIntegerCheck(((((-25000.00002)*gconst18*new_r00))+(((25000.0)*gconst19*new_r10))),-1);
if(!x1536.valid){
continue;
}
CheckValue<IkReal> x1537=IKPowWithIntegerCheck(((((-25000.00002)*gconst18*new_r00))+(((25000.0)*gconst19*new_r10))),-1);
if(!x1537.valid){
continue;
}
if( IKabs((((gconst18*gconst19*x1529*x1530*(x1536.value)))+(((-1.0)*gconst18*x1529))+((new_r01*x1530*(x1537.value))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x1532*(((((-25000.0)*new_r00*new_r01))+(((-1.0)*x1531)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((gconst18*gconst19*x1529*x1530*(x1536.value)))+(((-1.0)*gconst18*x1529))+((new_r01*x1530*(x1537.value)))))+IKsqr((x1532*(((((-25000.0)*new_r00*new_r01))+(((-1.0)*x1531))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((((gconst18*gconst19*x1529*x1530*(x1536.value)))+(((-1.0)*gconst18*x1529))+((new_r01*x1530*(x1537.value)))), (x1532*(((((-25000.0)*new_r00*new_r01))+(((-1.0)*x1531))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1538=IKcos(j5);
IkReal x1539=IKsin(j5);
IkReal x1540=((1.0)*gconst19);
IkReal x1541=((1.0000000008)*gconst19);
IkReal x1542=(new_r11*x1539);
IkReal x1543=(gconst18*x1538);
IkReal x1544=(new_r01*x1538);
IkReal x1545=(new_r00*x1538);
IkReal x1546=(gconst18*x1539);
IkReal x1547=(new_r10*x1539);
evalcond[0]=(gconst18+((new_r00*x1539))+((new_r10*x1538)));
evalcond[1]=(((new_r01*x1539))+((new_r11*x1538))+(((-1.0)*x1540)));
evalcond[2]=(x1546+new_r00+(((-1.0)*x1538*x1541)));
evalcond[3]=(((x1539*x1541))+x1543+new_r10);
evalcond[4]=((((-1.0)*x1539*x1540))+new_r01+(((-1.0000000008)*x1543)));
evalcond[5]=((((1.0000000008)*x1546))+new_r11+(((-1.0)*x1538*x1540)));
evalcond[6]=((((-1.0)*x1547))+x1545+(((-1.0)*x1541)));
evalcond[7]=((((-1.0)*x1542))+(((-1.0000000008)*gconst18))+x1544);
evalcond[8]=((((1.0000000008)*x1545))+(((-1.0)*x1540))+(((-1.0000000008)*x1547)));
evalcond[9]=((((1.0000000008)*x1544))+(((-1.0)*gconst18))+(((-1.0000000008)*x1542)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1552=IKPowWithIntegerCheck(new_r00,-1);
if(!x1552.valid){
continue;
}
IkReal x1548=x1552.value;
IkReal x1549=gconst18*gconst18;
CheckValue<IkReal> x1553=IKPowWithIntegerCheck(((((25000.00002)*gconst19*new_r00))+(((25000.0)*gconst18*new_r10))),-1);
if(!x1553.valid){
continue;
}
IkReal x1550=x1553.value;
IkReal x1551=((25000.0)*new_r10*x1550);
CheckValue<IkReal> x1554=IKPowWithIntegerCheck(x1548,-2);
if(!x1554.valid){
continue;
}
if( IKabs((((x1548*x1549*x1551))+(((-1.0)*gconst18*x1548))+(((-1.0)*new_r00*x1551)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x1550*(((((25000.0)*(x1554.value)))+(((-25000.0)*x1549)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((x1548*x1549*x1551))+(((-1.0)*gconst18*x1548))+(((-1.0)*new_r00*x1551))))+IKsqr((x1550*(((((25000.0)*(x1554.value)))+(((-25000.0)*x1549))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((((x1548*x1549*x1551))+(((-1.0)*gconst18*x1548))+(((-1.0)*new_r00*x1551))), (x1550*(((((25000.0)*(x1554.value)))+(((-25000.0)*x1549))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1555=IKcos(j5);
IkReal x1556=IKsin(j5);
IkReal x1557=((1.0)*gconst19);
IkReal x1558=((1.0000000008)*gconst19);
IkReal x1559=(new_r11*x1556);
IkReal x1560=(gconst18*x1555);
IkReal x1561=(new_r01*x1555);
IkReal x1562=(new_r00*x1555);
IkReal x1563=(gconst18*x1556);
IkReal x1564=(new_r10*x1556);
evalcond[0]=(((new_r00*x1556))+gconst18+((new_r10*x1555)));
evalcond[1]=(((new_r01*x1556))+((new_r11*x1555))+(((-1.0)*x1557)));
evalcond[2]=((((-1.0)*x1555*x1558))+x1563+new_r00);
evalcond[3]=(((x1556*x1558))+x1560+new_r10);
evalcond[4]=((((-1.0)*x1556*x1557))+new_r01+(((-1.0000000008)*x1560)));
evalcond[5]=((((1.0000000008)*x1563))+(((-1.0)*x1555*x1557))+new_r11);
evalcond[6]=(x1562+(((-1.0)*x1558))+(((-1.0)*x1564)));
evalcond[7]=((((-1.0)*x1559))+(((-1.0000000008)*gconst18))+x1561);
evalcond[8]=((((1.0000000008)*x1562))+(((-1.0)*x1557))+(((-1.0000000008)*x1564)));
evalcond[9]=((((1.0000000008)*x1561))+(((-1.0)*gconst18))+(((-1.0000000008)*x1559)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1565=((1.0)*new_r00);
CheckValue<IkReal> x1566 = IKatan2WithCheck(IkReal((((gconst18*new_r11))+((gconst19*new_r10)))),IkReal(((((-1.0)*gconst19*x1565))+(((-1.0)*gconst18*new_r01)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1566.valid){
continue;
}
CheckValue<IkReal> x1567=IKPowWithIntegerCheck(IKsign(((((-1.0)*new_r11*x1565))+((new_r01*new_r10)))),-1);
if(!x1567.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x1566.value)+(((1.5707963267949)*(x1567.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1568=IKcos(j5);
IkReal x1569=IKsin(j5);
IkReal x1570=((1.0)*gconst19);
IkReal x1571=((1.0000000008)*gconst19);
IkReal x1572=(new_r11*x1569);
IkReal x1573=(gconst18*x1568);
IkReal x1574=(new_r01*x1568);
IkReal x1575=(new_r00*x1568);
IkReal x1576=(gconst18*x1569);
IkReal x1577=(new_r10*x1569);
evalcond[0]=(((new_r00*x1569))+((new_r10*x1568))+gconst18);
evalcond[1]=(((new_r01*x1569))+((new_r11*x1568))+(((-1.0)*x1570)));
evalcond[2]=((((-1.0)*x1568*x1571))+x1576+new_r00);
evalcond[3]=(((x1569*x1571))+x1573+new_r10);
evalcond[4]=((((-1.0)*x1569*x1570))+new_r01+(((-1.0000000008)*x1573)));
evalcond[5]=((((1.0000000008)*x1576))+(((-1.0)*x1568*x1570))+new_r11);
evalcond[6]=(x1575+(((-1.0)*x1571))+(((-1.0)*x1577)));
evalcond[7]=((((-1.0000000008)*gconst18))+x1574+(((-1.0)*x1572)));
evalcond[8]=((((1.0000000008)*x1575))+(((-1.0)*x1570))+(((-1.0000000008)*x1577)));
evalcond[9]=((((1.0000000008)*x1574))+(((-1.0)*gconst18))+(((-1.0000000008)*x1572)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
j5eval[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
j5eval[0]=1.0;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j5]

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
CheckValue<IkReal> x1579 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r00)),IkReal(((-1.0000000008)*new_r10)),IKFAST_ATAN2_MAGTHRESH);
if(!x1579.valid){
continue;
}
IkReal x1578=x1579.value;
j5array[0]=((-1.0)*x1578);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
j5array[1]=((3.14159265358979)+(((-1.0)*x1578)));
sj5array[1]=IKsin(j5array[1]);
cj5array[1]=IKcos(j5array[1]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
if( j5array[1] > IKPI )
{
    j5array[1]-=IK2PI;
}
else if( j5array[1] < -IKPI )
{    j5array[1]+=IK2PI;
}
j5valid[1] = true;
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[2];
IkReal x1580=IKcos(j5);
IkReal x1581=IKsin(j5);
evalcond[0]=(((new_r10*x1580))+((new_r00*x1581)));
evalcond[1]=((((-1.0)*new_r10*x1581))+((new_r00*x1580)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
CheckValue<IkReal> x1583 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1583.valid){
continue;
}
IkReal x1582=x1583.value;
j5array[0]=((-1.0)*x1582);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
j5array[1]=((3.14159265358979)+(((-1.0)*x1582)));
sj5array[1]=IKsin(j5array[1]);
cj5array[1]=IKcos(j5array[1]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
if( j5array[1] > IKPI )
{
    j5array[1]-=IK2PI;
}
else if( j5array[1] < -IKPI )
{    j5array[1]+=IK2PI;
}
j5valid[1] = true;
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[2];
IkReal x1584=IKcos(j5);
IkReal x1585=IKsin(j5);
IkReal x1586=(new_r00*x1584);
IkReal x1587=(new_r10*x1585);
evalcond[0]=(x1586+(((-1.0)*x1587)));
evalcond[1]=((((-1.0000000008)*x1587))+(((1.0000000008)*x1586)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
new_r11=0;
new_r10=0;
new_r22=0;
new_r02=0;
j5eval[0]=new_r00;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
new_r11=0;
new_r10=0;
new_r22=0;
new_r02=0;
j5eval[0]=new_r00;
j5eval[1]=new_r01;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j5]

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1588=IKPowWithIntegerCheck(new_r00,-1);
if(!x1588.valid){
continue;
}
CheckValue<IkReal> x1589=IKPowWithIntegerCheck(new_r01,-1);
if(!x1589.valid){
continue;
}
if( IKabs(((-1.0)*sj3*(x1588.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((1.0000000008)*sj3*(x1589.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*sj3*(x1588.value)))+IKsqr(((1.0000000008)*sj3*(x1589.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0)*sj3*(x1588.value)), ((1.0000000008)*sj3*(x1589.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1590=IKsin(j5);
IkReal x1591=IKcos(j5);
IkReal x1592=((1.0)*cj3);
IkReal x1593=((1.0000000008)*cj3);
IkReal x1594=((1.0000000008)*sj3);
IkReal x1595=(new_r00*x1591);
IkReal x1596=(sj3*x1591);
IkReal x1597=(new_r01*x1591);
evalcond[0]=(sj3+((new_r00*x1590)));
evalcond[1]=((((-1.0)*x1592))+((new_r01*x1590)));
evalcond[2]=((((-1.0)*x1593))+x1595);
evalcond[3]=((((-1.0)*x1594))+x1597);
evalcond[4]=((((-1.0)*x1592))+(((1.0000000008)*x1595)));
evalcond[5]=((((-1.0)*sj3))+(((1.0000000008)*x1597)));
evalcond[6]=(((x1590*x1593))+x1596);
evalcond[7]=((((-1.0)*x1591*x1593))+new_r00+((sj3*x1590)));
evalcond[8]=(((x1590*x1594))+(((-1.0)*x1591*x1592)));
evalcond[9]=((((-1.0)*x1591*x1594))+(((-1.0)*x1590*x1592))+new_r01);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1599=IKPowWithIntegerCheck(new_r00,-1);
if(!x1599.valid){
continue;
}
IkReal x1598=x1599.value;
if( IKabs(((-1.0)*sj3*x1598)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((1.0000000008)*cj3*x1598)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*sj3*x1598))+IKsqr(((1.0000000008)*cj3*x1598))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0)*sj3*x1598), ((1.0000000008)*cj3*x1598));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1600=IKsin(j5);
IkReal x1601=IKcos(j5);
IkReal x1602=((1.0)*cj3);
IkReal x1603=((1.0000000008)*cj3);
IkReal x1604=((1.0000000008)*sj3);
IkReal x1605=(new_r00*x1601);
IkReal x1606=(sj3*x1601);
IkReal x1607=(new_r01*x1601);
evalcond[0]=(sj3+((new_r00*x1600)));
evalcond[1]=((((-1.0)*x1602))+((new_r01*x1600)));
evalcond[2]=((((-1.0)*x1603))+x1605);
evalcond[3]=((((-1.0)*x1604))+x1607);
evalcond[4]=((((-1.0)*x1602))+(((1.0000000008)*x1605)));
evalcond[5]=((((-1.0)*sj3))+(((1.0000000008)*x1607)));
evalcond[6]=(x1606+((x1600*x1603)));
evalcond[7]=(((sj3*x1600))+(((-1.0)*x1601*x1603))+new_r00);
evalcond[8]=(((x1600*x1604))+(((-1.0)*x1601*x1602)));
evalcond[9]=((((-1.0)*x1601*x1604))+(((-1.0)*x1600*x1602))+new_r01);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r00))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
new_r00=0;
new_r01=0;
new_r12=0;
new_r22=0;
j5eval[0]=new_r10;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
new_r00=0;
new_r01=0;
new_r12=0;
new_r22=0;
j5eval[0]=new_r11;
j5eval[1]=new_r10;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j5]

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1608=IKPowWithIntegerCheck(new_r11,-1);
if(!x1608.valid){
continue;
}
CheckValue<IkReal> x1609=IKPowWithIntegerCheck(new_r10,-1);
if(!x1609.valid){
continue;
}
if( IKabs(((-1.0000000008)*sj3*(x1608.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*sj3*(x1609.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0000000008)*sj3*(x1608.value)))+IKsqr(((-1.0)*sj3*(x1609.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0000000008)*sj3*(x1608.value)), ((-1.0)*sj3*(x1609.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1610=IKcos(j5);
IkReal x1611=IKsin(j5);
IkReal x1612=((1.0)*cj3);
IkReal x1613=((1.0000000008)*cj3);
IkReal x1614=((1.0000000008)*sj3);
IkReal x1615=(sj3*x1610);
IkReal x1616=(new_r10*x1611);
IkReal x1617=(new_r11*x1611);
evalcond[0]=(sj3+((new_r10*x1610)));
evalcond[1]=(((new_r11*x1610))+(((-1.0)*x1612)));
evalcond[2]=((((-1.0)*x1616))+(((-1.0)*x1613)));
evalcond[3]=((((-1.0)*x1617))+(((-1.0)*x1614)));
evalcond[4]=((((-1.0)*x1612))+(((-1.0000000008)*x1616)));
evalcond[5]=((((-1.0)*sj3))+(((-1.0000000008)*x1617)));
evalcond[6]=(((sj3*x1611))+(((-1.0)*x1610*x1613)));
evalcond[7]=(x1615+new_r10+((x1611*x1613)));
evalcond[8]=((((-1.0)*x1611*x1612))+(((-1.0)*x1610*x1614)));
evalcond[9]=((((-1.0)*x1610*x1612))+new_r11+((x1611*x1614)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1619=IKPowWithIntegerCheck(new_r10,-1);
if(!x1619.valid){
continue;
}
IkReal x1618=x1619.value;
if( IKabs(((-1.0000000008)*cj3*x1618)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*sj3*x1618)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0000000008)*cj3*x1618))+IKsqr(((-1.0)*sj3*x1618))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0000000008)*cj3*x1618), ((-1.0)*sj3*x1618));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1620=IKcos(j5);
IkReal x1621=IKsin(j5);
IkReal x1622=((1.0)*cj3);
IkReal x1623=((1.0000000008)*cj3);
IkReal x1624=((1.0000000008)*sj3);
IkReal x1625=(sj3*x1620);
IkReal x1626=(new_r10*x1621);
IkReal x1627=(new_r11*x1621);
evalcond[0]=(sj3+((new_r10*x1620)));
evalcond[1]=(((new_r11*x1620))+(((-1.0)*x1622)));
evalcond[2]=((((-1.0)*x1626))+(((-1.0)*x1623)));
evalcond[3]=((((-1.0)*x1627))+(((-1.0)*x1624)));
evalcond[4]=((((-1.0)*x1622))+(((-1.0000000008)*x1626)));
evalcond[5]=((((-1.0)*sj3))+(((-1.0000000008)*x1627)));
evalcond[6]=(((sj3*x1621))+(((-1.0)*x1620*x1623)));
evalcond[7]=(x1625+new_r10+((x1621*x1623)));
evalcond[8]=((((-1.0)*x1621*x1622))+(((-1.0)*x1620*x1624)));
evalcond[9]=((((-1.0)*x1620*x1622))+new_r11+((x1621*x1624)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
new_r00=0;
new_r10=0;
new_r21=0;
new_r22=0;
j5eval[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
sj4=4.0e-5;
cj4=1.0;
j4=4.0e-5;
new_r00=0;
new_r10=0;
new_r21=0;
new_r22=0;
j5eval[0]=1.0;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j5]

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
CheckValue<IkReal> x1629 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r01)),IkReal(((-1.0000000008)*new_r11)),IKFAST_ATAN2_MAGTHRESH);
if(!x1629.valid){
continue;
}
IkReal x1628=x1629.value;
j5array[0]=((-1.0)*x1628);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
j5array[1]=((3.14159265358979)+(((-1.0)*x1628)));
sj5array[1]=IKsin(j5array[1]);
cj5array[1]=IKcos(j5array[1]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
if( j5array[1] > IKPI )
{
    j5array[1]-=IK2PI;
}
else if( j5array[1] < -IKPI )
{    j5array[1]+=IK2PI;
}
j5valid[1] = true;
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[2];
IkReal x1630=IKcos(j5);
IkReal x1631=IKsin(j5);
evalcond[0]=(((new_r11*x1630))+((new_r01*x1631)));
evalcond[1]=(((new_r01*x1630))+(((-1.0)*new_r11*x1631)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
CheckValue<IkReal> x1633 = IKatan2WithCheck(IkReal(new_r11),IkReal(new_r01),IKFAST_ATAN2_MAGTHRESH);
if(!x1633.valid){
continue;
}
IkReal x1632=x1633.value;
j5array[0]=((-1.0)*x1632);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
j5array[1]=((3.14159265358979)+(((-1.0)*x1632)));
sj5array[1]=IKsin(j5array[1]);
cj5array[1]=IKcos(j5array[1]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
if( j5array[1] > IKPI )
{
    j5array[1]-=IK2PI;
}
else if( j5array[1] < -IKPI )
{    j5array[1]+=IK2PI;
}
j5valid[1] = true;
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[2];
IkReal x1634=IKcos(j5);
IkReal x1635=IKsin(j5);
IkReal x1636=(new_r11*x1635);
IkReal x1637=(new_r01*x1634);
evalcond[0]=(x1637+(((-1.0)*x1636)));
evalcond[1]=((((-1.0000000008)*x1636))+(((1.0000000008)*x1637)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1643=IKPowWithIntegerCheck(new_r00,-1);
if(!x1643.valid){
continue;
}
IkReal x1638=x1643.value;
IkReal x1639=((25000.0)*new_r01);
IkReal x1640=((25000.0)*cj3*sj3);
CheckValue<IkReal> x1644=IKPowWithIntegerCheck(((((25000.0)*cj3*new_r10))+(((-25000.00002)*new_r00*sj3))),-1);
if(!x1644.valid){
continue;
}
IkReal x1641=x1644.value;
IkReal x1642=(new_r10*x1641);
if( IKabs(((((-1.0)*sj3*x1638))+((x1639*x1642))+((x1638*x1640*x1642)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x1641*(((((-1.0)*new_r00*x1639))+(((-1.0)*x1640)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*sj3*x1638))+((x1639*x1642))+((x1638*x1640*x1642))))+IKsqr((x1641*(((((-1.0)*new_r00*x1639))+(((-1.0)*x1640))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*sj3*x1638))+((x1639*x1642))+((x1638*x1640*x1642))), (x1641*(((((-1.0)*new_r00*x1639))+(((-1.0)*x1640))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1645=IKcos(j5);
IkReal x1646=IKsin(j5);
IkReal x1647=((1.0)*cj3);
IkReal x1648=((1.0000000008)*cj3);
IkReal x1649=(cj3*x1645);
IkReal x1650=(new_r11*x1646);
IkReal x1651=(sj3*x1646);
IkReal x1652=(new_r01*x1645);
IkReal x1653=(new_r00*x1645);
IkReal x1654=(sj3*x1645);
IkReal x1655=(new_r10*x1646);
evalcond[0]=(((new_r10*x1645))+sj3+((new_r00*x1646)));
evalcond[1]=(((new_r11*x1645))+(((-1.0)*x1647))+((new_r01*x1646)));
evalcond[2]=(x1651+(((-1.0)*x1645*x1648))+new_r00);
evalcond[3]=(x1654+((x1646*x1648))+new_r10);
evalcond[4]=((((-1.0)*x1646*x1647))+(((-1.0000000008)*x1654))+new_r01);
evalcond[5]=((((-1.0)*x1645*x1647))+(((1.0000000008)*x1651))+new_r11);
evalcond[6]=(x1653+(((-1.0)*x1655))+(((-1.0)*x1648)));
evalcond[7]=(x1652+(((-1.0)*x1650))+(((-1.0000000008)*sj3)));
evalcond[8]=((((-1.0000000008)*x1655))+(((-1.0)*x1647))+(((1.0000000008)*x1653)));
evalcond[9]=((((-1.0)*sj3))+(((-1.0000000008)*x1650))+(((1.0000000008)*x1652)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1656=new_r00*new_r00;
IkReal x1657=cj3*cj3;
IkReal x1658=new_r10*new_r10;
IkReal x1659=((625000000.0)*new_r00);
IkReal x1660=((25000.00002)*cj3);
IkReal x1661=((625000000.5)*cj3);
IkReal x1662=((25000.0)*new_r00);
IkReal x1663=((625000000.0)*x1656);
CheckValue<IkReal> x1664=IKPowWithIntegerCheck(((((-625000001.0)*x1657*x1658))+x1663+(((-1.0)*x1657*x1663))),-1);
if(!x1664.valid){
continue;
}
CheckValue<IkReal> x1665=IKPowWithIntegerCheck((((sj3*x1662))+(((-1.0)*new_r10*x1660))),-1);
if(!x1665.valid){
continue;
}
if( IKabs(((x1664.value)*(((((-1.0)*x1659*(sj3*sj3*sj3)))+((x1661*(new_r10*new_r10*new_r10)))+((new_r10*x1661*(cj3*cj3)))+(((-1.0)*new_r10*x1661))+((sj3*x1658*x1659)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x1665.value)*((((sj3*x1660))+(((-1.0)*new_r10*x1662)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1664.value)*(((((-1.0)*x1659*(sj3*sj3*sj3)))+((x1661*(new_r10*new_r10*new_r10)))+((new_r10*x1661*(cj3*cj3)))+(((-1.0)*new_r10*x1661))+((sj3*x1658*x1659))))))+IKsqr(((x1665.value)*((((sj3*x1660))+(((-1.0)*new_r10*x1662))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((x1664.value)*(((((-1.0)*x1659*(sj3*sj3*sj3)))+((x1661*(new_r10*new_r10*new_r10)))+((new_r10*x1661*(cj3*cj3)))+(((-1.0)*new_r10*x1661))+((sj3*x1658*x1659))))), ((x1665.value)*((((sj3*x1660))+(((-1.0)*new_r10*x1662))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1666=IKcos(j5);
IkReal x1667=IKsin(j5);
IkReal x1668=((1.0)*cj3);
IkReal x1669=((1.0000000008)*cj3);
IkReal x1670=(cj3*x1666);
IkReal x1671=(new_r11*x1667);
IkReal x1672=(sj3*x1667);
IkReal x1673=(new_r01*x1666);
IkReal x1674=(new_r00*x1666);
IkReal x1675=(sj3*x1666);
IkReal x1676=(new_r10*x1667);
evalcond[0]=(sj3+((new_r00*x1667))+((new_r10*x1666)));
evalcond[1]=(((new_r11*x1666))+((new_r01*x1667))+(((-1.0)*x1668)));
evalcond[2]=(x1672+new_r00+(((-1.0)*x1666*x1669)));
evalcond[3]=(x1675+((x1667*x1669))+new_r10);
evalcond[4]=((((-1.0)*x1667*x1668))+new_r01+(((-1.0000000008)*x1675)));
evalcond[5]=((((1.0000000008)*x1672))+new_r11+(((-1.0)*x1666*x1668)));
evalcond[6]=(x1674+(((-1.0)*x1676))+(((-1.0)*x1669)));
evalcond[7]=(x1673+(((-1.0)*x1671))+(((-1.0000000008)*sj3)));
evalcond[8]=((((1.0000000008)*x1674))+(((-1.0)*x1668))+(((-1.0000000008)*x1676)));
evalcond[9]=((((-1.0)*sj3))+(((1.0000000008)*x1673))+(((-1.0000000008)*x1671)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1677=((1.0)*new_r00);
CheckValue<IkReal> x1678 = IKatan2WithCheck(IkReal((((new_r11*sj3))+((cj3*new_r10)))),IkReal(((((-1.0)*new_r01*sj3))+(((-1.0)*cj3*x1677)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1678.valid){
continue;
}
CheckValue<IkReal> x1679=IKPowWithIntegerCheck(IKsign((((new_r01*new_r10))+(((-1.0)*new_r11*x1677)))),-1);
if(!x1679.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x1678.value)+(((1.5707963267949)*(x1679.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1680=IKcos(j5);
IkReal x1681=IKsin(j5);
IkReal x1682=((1.0)*cj3);
IkReal x1683=((1.0000000008)*cj3);
IkReal x1684=(cj3*x1680);
IkReal x1685=(new_r11*x1681);
IkReal x1686=(sj3*x1681);
IkReal x1687=(new_r01*x1680);
IkReal x1688=(new_r00*x1680);
IkReal x1689=(sj3*x1680);
IkReal x1690=(new_r10*x1681);
evalcond[0]=(((new_r00*x1681))+sj3+((new_r10*x1680)));
evalcond[1]=((((-1.0)*x1682))+((new_r11*x1680))+((new_r01*x1681)));
evalcond[2]=(x1686+(((-1.0)*x1680*x1683))+new_r00);
evalcond[3]=(((x1681*x1683))+x1689+new_r10);
evalcond[4]=((((-1.0)*x1681*x1682))+(((-1.0000000008)*x1689))+new_r01);
evalcond[5]=((((-1.0)*x1680*x1682))+new_r11+(((1.0000000008)*x1686)));
evalcond[6]=((((-1.0)*x1683))+x1688+(((-1.0)*x1690)));
evalcond[7]=(x1687+(((-1.0)*x1685))+(((-1.0000000008)*sj3)));
evalcond[8]=((((-1.0)*x1682))+(((1.0000000008)*x1688))+(((-1.0000000008)*x1690)));
evalcond[9]=((((-1.0)*sj3))+(((-1.0000000008)*x1685))+(((1.0000000008)*x1687)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14163265358977)+j4)))), 6.28318530717959)));
evalcond[1]=new_r02;
evalcond[2]=new_r12;
evalcond[3]=new_r20;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
IkReal x1691=((1.0)*new_r00);
IkReal x1692=((((-1.0)*new_r11*x1691))+((new_r01*new_r10)));
j5eval[0]=x1692;
j5eval[1]=IKsign(x1692);
j5eval[2]=((IKabs((((new_r11*sj3))+((cj3*new_r10)))))+(IKabs(((((-1.0)*new_r01*sj3))+(((-1.0)*cj3*x1691))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
j5eval[0]=((((1.0000000008)*new_r00*sj3))+((cj3*new_r10)));
j5eval[1]=new_r00;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
j5eval[0]=new_r00;
j5eval[1]=(((new_r00*sj3))+(((1.0000000008)*cj3*new_r10)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
IkReal x1694 = ((((1.0000000016)*(new_r10*new_r10)))+(new_r00*new_r00));
if(IKabs(x1694)==0){
continue;
}
IkReal x1693=pow(x1694,-0.5);
CheckValue<IkReal> x1695 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1695.valid){
continue;
}
IkReal gconst20=((-1.0)*(x1695.value));
IkReal gconst21=((-1.0000000008)*new_r10*x1693);
IkReal gconst22=(new_r00*x1693);
CheckValue<IkReal> x1696 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1696.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((x1696.value)+j3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
IkReal x1697=x1693;
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst21;
cj3=gconst22;
CheckValue<IkReal> x1698 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1698.valid){
continue;
}
j3=((-1.0)*(x1698.value));
CheckValue<IkReal> x1699 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1699.valid){
continue;
}
IkReal gconst20=((-1.0)*(x1699.value));
IkReal gconst21=((-1.0000000008)*new_r10*x1697);
IkReal gconst22=(new_r00*x1697);
IkReal x1700=new_r00*new_r00;
IkReal x1701=(new_r01*new_r10);
IkReal x1702=(x1701+(((-1.0)*new_r00*new_r11)));
IkReal x1705 = ((((625000000.0)*x1700))+(((625000001.0)*(new_r10*new_r10))));
if(IKabs(x1705)==0){
continue;
}
IkReal x1703=pow(x1705,-0.5);
IkReal x1704=(new_r10*x1703);
j5eval[0]=x1702;
j5eval[1]=IKsign(x1702);
j5eval[2]=((IKabs(((((25000.0)*new_r00*x1704))+(((-25000.00002)*new_r11*x1704)))))+(IKabs(((((-25000.0)*x1700*x1703))+(((25000.00002)*x1701*x1703))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x1706=x1693;
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst21;
cj3=gconst22;
CheckValue<IkReal> x1707 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1707.valid){
continue;
}
j3=((-1.0)*(x1707.value));
CheckValue<IkReal> x1708 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1708.valid){
continue;
}
IkReal gconst20=((-1.0)*(x1708.value));
IkReal gconst21=((-1.0000000008)*new_r10*x1706);
IkReal gconst22=(new_r00*x1706);
j5eval[0]=new_r00;
IkReal x1709 = ((((1.0000000016)*(new_r10*new_r10)))+(new_r00*new_r00));
if(IKabs(x1709)==0){
continue;
}
j5eval[1]=((-1.6e-9)*new_r00*new_r10*(pow(x1709,-0.5)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x1710=x1693;
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst21;
cj3=gconst22;
CheckValue<IkReal> x1711 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1711.valid){
continue;
}
j3=((-1.0)*(x1711.value));
CheckValue<IkReal> x1712 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1712.valid){
continue;
}
IkReal gconst20=((-1.0)*(x1712.value));
IkReal gconst21=((-1.0000000008)*new_r10*x1710);
IkReal gconst22=(new_r00*x1710);
j5eval[0]=new_r00;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(new_r00);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst21;
cj3=gconst22;
CheckValue<IkReal> x1713 = IKatan2WithCheck(IkReal(new_r10),IkReal(0),IKFAST_ATAN2_MAGTHRESH);
if(!x1713.valid){
continue;
}
j3=((-1.0)*(x1713.value));
new_r00=0;
CheckValue<IkReal> x1714 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(0),IKFAST_ATAN2_MAGTHRESH);
if(!x1714.valid){
continue;
}
IkReal gconst20=((-1.0)*(x1714.value));
IkReal x1715 = new_r10*new_r10;
if(IKabs(x1715)==0){
continue;
}
IkReal gconst21=((-1.0)*new_r10*(pow(x1715,-0.5)));
IkReal gconst22=0;
j5eval[0]=new_r10;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1717=IKPowWithIntegerCheck(gconst21,-1);
if(!x1717.valid){
continue;
}
IkReal x1716=x1717.value;
if( IKabs(((0.9999999992)*new_r11*x1716)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10*x1716)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.9999999992)*new_r11*x1716))+IKsqr(((-1.0)*new_r10*x1716))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((0.9999999992)*new_r11*x1716), ((-1.0)*new_r10*x1716));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1718=IKsin(j5);
IkReal x1719=IKcos(j5);
IkReal x1720=(new_r10*x1718);
IkReal x1721=((1.0000000008)*x1719);
IkReal x1722=(new_r11*x1718);
IkReal x1723=(gconst21*x1718);
evalcond[0]=x1723;
evalcond[1]=((-1.0)*x1720);
evalcond[2]=(((new_r10*x1719))+gconst21);
evalcond[3]=(((gconst21*x1719))+new_r10);
evalcond[4]=((1.0000000008)*x1720);
evalcond[5]=(((new_r11*x1719))+((new_r01*x1718)));
evalcond[6]=(((gconst21*x1721))+new_r01);
evalcond[7]=((((-1.0000000008)*x1723))+new_r11);
evalcond[8]=(((new_r01*x1719))+(((1.0000000008)*gconst21))+(((-1.0)*x1722)));
evalcond[9]=((((-1.0)*new_r01*x1721))+(((1.0000000008)*x1722))+(((-1.0)*gconst21)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1724=IKPowWithIntegerCheck(gconst21,-1);
if(!x1724.valid){
continue;
}
CheckValue<IkReal> x1725=IKPowWithIntegerCheck(new_r10,-1);
if(!x1725.valid){
continue;
}
if( IKabs(((0.9999999992)*new_r11*(x1724.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*gconst21*(x1725.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.9999999992)*new_r11*(x1724.value)))+IKsqr(((-1.0)*gconst21*(x1725.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((0.9999999992)*new_r11*(x1724.value)), ((-1.0)*gconst21*(x1725.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1726=IKsin(j5);
IkReal x1727=IKcos(j5);
IkReal x1728=(new_r10*x1726);
IkReal x1729=((1.0000000008)*x1727);
IkReal x1730=(new_r11*x1726);
IkReal x1731=(gconst21*x1726);
evalcond[0]=x1731;
evalcond[1]=((-1.0)*x1728);
evalcond[2]=(gconst21+((new_r10*x1727)));
evalcond[3]=(((gconst21*x1727))+new_r10);
evalcond[4]=((1.0000000008)*x1728);
evalcond[5]=(((new_r11*x1727))+((new_r01*x1726)));
evalcond[6]=(((gconst21*x1729))+new_r01);
evalcond[7]=((((-1.0000000008)*x1731))+new_r11);
evalcond[8]=((((1.0000000008)*gconst21))+(((-1.0)*x1730))+((new_r01*x1727)));
evalcond[9]=((((-1.0)*new_r01*x1729))+(((1.0000000008)*x1730))+(((-1.0)*gconst21)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[5];
IkReal x1733 = ((1.0)+(((1.6e-9)*(new_r10*new_r10))));
if(IKabs(x1733)==0){
continue;
}
IkReal x1732=pow(x1733,-0.5);
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst21;
cj3=gconst22;
CheckValue<IkReal> x1734 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1734.valid){
continue;
}
j3=((-1.0)*(x1734.value));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x1735 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1735.valid){
continue;
}
IkReal gconst20=((-1.0)*(x1735.value));
IkReal gconst21=((-1.0000000008)*new_r10*x1732);
IkReal gconst22=(new_r00*x1732);
j5eval[0]=1.0;
j5eval[1]=1.0;
j5eval[2]=3.90625000625e+17;
j5eval[3]=((1.0)+(((1.6e-9)*(new_r10*new_r10))));
j5eval[4]=1.0;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  || IKabs(j5eval[3]) < 0.0000010000000000  || IKabs(j5eval[4]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x1737 = ((1.0)+(((1.6e-9)*(new_r10*new_r10))));
if(IKabs(x1737)==0){
continue;
}
IkReal x1736=pow(x1737,-0.5);
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst21;
cj3=gconst22;
CheckValue<IkReal> x1738 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1738.valid){
continue;
}
j3=((-1.0)*(x1738.value));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x1739 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1739.valid){
continue;
}
IkReal gconst20=((-1.0)*(x1739.value));
IkReal gconst21=((-1.0000000008)*new_r10*x1736);
IkReal gconst22=(new_r00*x1736);
IkReal x1740=new_r10*new_r10;
CheckValue<IkReal> x1742=IKPowWithIntegerCheck(((1.0)+(((1.6e-9)*x1740))),-1);
if(!x1742.valid){
continue;
}
IkReal x1741=x1742.value;
IkReal x1743=((1.0)+(((-1.0)*x1740)));
j5eval[0]=IKsign(((((625000002.0)*x1741*(x1740*x1740)))+(((-625000000.0)*x1741*(x1743*x1743)))));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x1745 = ((1.0)+(((1.6e-9)*(new_r10*new_r10))));
if(IKabs(x1745)==0){
continue;
}
IkReal x1744=pow(x1745,-0.5);
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst21;
cj3=gconst22;
CheckValue<IkReal> x1746 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1746.valid){
continue;
}
j3=((-1.0)*(x1746.value));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x1747 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1747.valid){
continue;
}
IkReal gconst20=((-1.0)*(x1747.value));
IkReal gconst21=((-1.0000000008)*new_r10*x1744);
IkReal gconst22=(new_r00*x1744);
IkReal x1748=new_r10*new_r10;
IkReal x1749=((1.0)+(((1.6e-9)*x1748)));
CheckValue<IkReal> x1750=IKPowWithIntegerCheck(x1749,-1);
if(!x1750.valid){
continue;
}
j5eval[0]=((-3.20000000256e-9)*x1748*(x1750.value)*(((1.0)+(((-1.0)*x1748)))));
IkReal x1751 = x1749;
if(IKabs(x1751)==0){
continue;
}
j5eval[1]=((-1.6e-9)*new_r00*new_r10*(pow(x1751,-0.5)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1752=gconst21*gconst21;
IkReal x1753=(gconst22*new_r10);
CheckValue<IkReal> x1754=IKPowWithIntegerCheck(((((-625000001.0)*x1752*(new_r00*new_r00)))+(((625000000.0)*(x1753*x1753)))),-1);
if(!x1754.valid){
continue;
}
CheckValue<IkReal> x1755=IKPowWithIntegerCheck(((((25000.00002)*gconst21*new_r00))+(((25000.0)*x1753))),-1);
if(!x1755.valid){
continue;
}
if( IKabs(((x1754.value)*(((((-625000000.5)*x1752*x1753))+(((625000001.0)*new_r00*(gconst21*gconst21*gconst21))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-25000.0)*gconst21*gconst22*(x1755.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1754.value)*(((((-625000000.5)*x1752*x1753))+(((625000001.0)*new_r00*(gconst21*gconst21*gconst21)))))))+IKsqr(((-25000.0)*gconst21*gconst22*(x1755.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((x1754.value)*(((((-625000000.5)*x1752*x1753))+(((625000001.0)*new_r00*(gconst21*gconst21*gconst21)))))), ((-25000.0)*gconst21*gconst22*(x1755.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x1756=IKcos(j5);
IkReal x1757=IKsin(j5);
IkReal x1758=((1.0)*gconst22);
IkReal x1759=((1.0000000008)*gconst22);
IkReal x1760=((1.0000000008)*x1757);
IkReal x1761=(gconst21*x1756);
IkReal x1762=(new_r00*x1756);
evalcond[0]=(gconst21+((new_r00*x1757))+((new_r10*x1756)));
evalcond[1]=(((gconst21*x1757))+new_r00+((x1756*x1759)));
evalcond[2]=((((-1.0)*x1757*x1759))+x1761+new_r10);
evalcond[3]=((((-1.0)*x1757*x1758))+(((1.0000000008)*x1761)));
evalcond[4]=((((-1.0)*gconst21*x1760))+(((-1.0)*x1756*x1758)));
evalcond[5]=(x1762+x1759+(((-1.0)*new_r10*x1757)));
evalcond[6]=((((-1.0000000008)*x1762))+((new_r10*x1760))+(((-1.0)*x1758)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1763=gconst22*gconst22;
IkReal x1764=gconst21*gconst21;
IkReal x1765=((625000000.0)*x1763);
IkReal x1766=((625000000.5)*gconst22*x1764);
CheckValue<IkReal> x1767 = IKatan2WithCheck(IkReal((((gconst21*new_r00*x1765))+((new_r10*x1766)))),IkReal(((((-625000001.0)*new_r10*(gconst21*gconst21*gconst21)))+(((-1.0)*new_r00*x1766)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1767.valid){
continue;
}
CheckValue<IkReal> x1768=IKPowWithIntegerCheck(IKsign(((((625000001.0)*x1764*(new_r10*new_r10)))+(((-1.0)*x1765*(new_r00*new_r00))))),-1);
if(!x1768.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x1767.value)+(((1.5707963267949)*(x1768.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x1769=IKcos(j5);
IkReal x1770=IKsin(j5);
IkReal x1771=((1.0)*gconst22);
IkReal x1772=((1.0000000008)*gconst22);
IkReal x1773=((1.0000000008)*x1770);
IkReal x1774=(gconst21*x1769);
IkReal x1775=(new_r00*x1769);
evalcond[0]=(((new_r00*x1770))+((new_r10*x1769))+gconst21);
evalcond[1]=(new_r00+((gconst21*x1770))+((x1769*x1772)));
evalcond[2]=(x1774+(((-1.0)*x1770*x1772))+new_r10);
evalcond[3]=((((-1.0)*x1770*x1771))+(((1.0000000008)*x1774)));
evalcond[4]=((((-1.0)*gconst21*x1773))+(((-1.0)*x1769*x1771)));
evalcond[5]=(x1775+x1772+(((-1.0)*new_r10*x1770)));
evalcond[6]=((((-1.0000000008)*x1775))+(((-1.0)*x1771))+((new_r10*x1773)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1776=((25000.00002)*gconst22);
IkReal x1777=((25000.0)*gconst21);
CheckValue<IkReal> x1778=IKPowWithIntegerCheck(IKsign(((((25000.0)*(new_r10*new_r10)))+(((25000.0)*(new_r00*new_r00))))),-1);
if(!x1778.valid){
continue;
}
CheckValue<IkReal> x1779 = IKatan2WithCheck(IkReal((((new_r10*x1776))+(((-1.0)*new_r00*x1777)))),IkReal(((((-1.0)*new_r10*x1777))+(((-1.0)*new_r00*x1776)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1779.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1778.value)))+(x1779.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x1780=IKcos(j5);
IkReal x1781=IKsin(j5);
IkReal x1782=((1.0)*gconst22);
IkReal x1783=((1.0000000008)*gconst22);
IkReal x1784=((1.0000000008)*x1781);
IkReal x1785=(gconst21*x1780);
IkReal x1786=(new_r00*x1780);
evalcond[0]=(gconst21+((new_r10*x1780))+((new_r00*x1781)));
evalcond[1]=(((gconst21*x1781))+new_r00+((x1780*x1783)));
evalcond[2]=(x1785+new_r10+(((-1.0)*x1781*x1783)));
evalcond[3]=((((1.0000000008)*x1785))+(((-1.0)*x1781*x1782)));
evalcond[4]=((((-1.0)*gconst21*x1784))+(((-1.0)*x1780*x1782)));
evalcond[5]=(x1783+x1786+(((-1.0)*new_r10*x1781)));
evalcond[6]=((((-1.0)*x1782))+((new_r10*x1784))+(((-1.0000000008)*x1786)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1788=IKPowWithIntegerCheck(gconst22,-1);
if(!x1788.valid){
continue;
}
IkReal x1787=x1788.value;
if( IKabs((new_r01*x1787)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.9999999992)*new_r00*x1787)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r01*x1787))+IKsqr(((-0.9999999992)*new_r00*x1787))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((new_r01*x1787), ((-0.9999999992)*new_r00*x1787));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1789=IKcos(j5);
IkReal x1790=IKsin(j5);
IkReal x1791=((1.0)*gconst22);
IkReal x1792=(gconst22*x1790);
IkReal x1793=(gconst22*x1789);
IkReal x1794=(new_r00*x1789);
IkReal x1795=(new_r01*x1789);
evalcond[0]=(new_r00*x1790);
evalcond[1]=x1795;
evalcond[2]=((-1.0)*x1793);
evalcond[3]=((((-1.0)*x1790*x1791))+new_r01);
evalcond[4]=((((-1.0)*x1791))+((new_r01*x1790)));
evalcond[5]=((-1.0000000008)*x1792);
evalcond[6]=((-1.0000000008)*x1795);
evalcond[7]=((((1.0000000008)*x1793))+new_r00);
evalcond[8]=(x1794+(((1.0000000008)*gconst22)));
evalcond[9]=((((-1.0)*x1791))+(((-1.0000000008)*x1794)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1802=IKPowWithIntegerCheck(new_r00,-1);
if(!x1802.valid){
continue;
}
IkReal x1796=x1802.value;
IkReal x1797=gconst21*gconst21;
IkReal x1798=((25000.0)*new_r10);
IkReal x1799=((25000.0)*x1797);
CheckValue<IkReal> x1803=IKPowWithIntegerCheck(((((-1.0)*gconst21*x1798))+(((25000.00002)*gconst22*new_r00))),-1);
if(!x1803.valid){
continue;
}
IkReal x1800=x1803.value;
CheckValue<IkReal> x1804=IKPowWithIntegerCheck(((((-25000.0)*gconst21*new_r10))+(((25000.00002)*gconst22*new_r00))),-1);
if(!x1804.valid){
continue;
}
IkReal x1801=(x1798*(x1804.value));
CheckValue<IkReal> x1805=IKPowWithIntegerCheck(x1796,-2);
if(!x1805.valid){
continue;
}
if( IKabs((((new_r00*x1801))+(((-1.0)*gconst21*x1796))+(((-1.0)*x1796*x1797*x1801)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x1800*((x1799+(((-25000.0)*(x1805.value))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((new_r00*x1801))+(((-1.0)*gconst21*x1796))+(((-1.0)*x1796*x1797*x1801))))+IKsqr((x1800*((x1799+(((-25000.0)*(x1805.value)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((((new_r00*x1801))+(((-1.0)*gconst21*x1796))+(((-1.0)*x1796*x1797*x1801))), (x1800*((x1799+(((-25000.0)*(x1805.value)))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1806=IKcos(j5);
IkReal x1807=IKsin(j5);
IkReal x1808=((1.0)*gconst22);
IkReal x1809=((1.0000000008)*gconst21);
IkReal x1810=((1.0000000008)*gconst22);
IkReal x1811=(gconst22*x1807);
IkReal x1812=(new_r11*x1807);
IkReal x1813=(gconst21*x1807);
IkReal x1814=(new_r01*x1806);
IkReal x1815=(new_r00*x1806);
IkReal x1816=(new_r10*x1807);
evalcond[0]=(((new_r00*x1807))+gconst21+((new_r10*x1806)));
evalcond[1]=((((-1.0)*x1808))+((new_r11*x1806))+((new_r01*x1807)));
evalcond[2]=(x1813+new_r00+((x1806*x1810)));
evalcond[3]=((((-1.0)*x1807*x1810))+((gconst21*x1806))+new_r10);
evalcond[4]=(((x1806*x1809))+new_r01+(((-1.0)*x1807*x1808)));
evalcond[5]=((((-1.0)*x1806*x1808))+new_r11+(((-1.0)*x1807*x1809)));
evalcond[6]=(x1815+x1810+(((-1.0)*x1816)));
evalcond[7]=(x1814+x1809+(((-1.0)*x1812)));
evalcond[8]=((((-1.0)*x1808))+(((1.0000000008)*x1816))+(((-1.0000000008)*x1815)));
evalcond[9]=((((-1.0)*gconst21))+(((1.0000000008)*x1812))+(((-1.0000000008)*x1814)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1822=IKPowWithIntegerCheck(new_r00,-1);
if(!x1822.valid){
continue;
}
IkReal x1817=x1822.value;
IkReal x1818=(gconst21*x1817);
IkReal x1819=((25000.0)*new_r01);
IkReal x1820=((25000.0)*gconst22*new_r10);
CheckValue<IkReal> x1823=IKPowWithIntegerCheck((x1820+(((25000.00002)*gconst21*new_r00))),-1);
if(!x1823.valid){
continue;
}
IkReal x1821=x1823.value;
if( IKabs((((new_r10*x1819*x1821))+((x1818*x1820*x1821))+(((-1.0)*x1818)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x1821*(((((-25000.0)*gconst21*gconst22))+(((-1.0)*new_r00*x1819)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((new_r10*x1819*x1821))+((x1818*x1820*x1821))+(((-1.0)*x1818))))+IKsqr((x1821*(((((-25000.0)*gconst21*gconst22))+(((-1.0)*new_r00*x1819))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((((new_r10*x1819*x1821))+((x1818*x1820*x1821))+(((-1.0)*x1818))), (x1821*(((((-25000.0)*gconst21*gconst22))+(((-1.0)*new_r00*x1819))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1824=IKcos(j5);
IkReal x1825=IKsin(j5);
IkReal x1826=((1.0)*gconst22);
IkReal x1827=((1.0000000008)*gconst21);
IkReal x1828=((1.0000000008)*gconst22);
IkReal x1829=(gconst22*x1825);
IkReal x1830=(new_r11*x1825);
IkReal x1831=(gconst21*x1825);
IkReal x1832=(new_r01*x1824);
IkReal x1833=(new_r00*x1824);
IkReal x1834=(new_r10*x1825);
evalcond[0]=(((new_r10*x1824))+((new_r00*x1825))+gconst21);
evalcond[1]=((((-1.0)*x1826))+((new_r01*x1825))+((new_r11*x1824)));
evalcond[2]=(((x1824*x1828))+x1831+new_r00);
evalcond[3]=((((-1.0)*x1825*x1828))+((gconst21*x1824))+new_r10);
evalcond[4]=(((x1824*x1827))+(((-1.0)*x1825*x1826))+new_r01);
evalcond[5]=((((-1.0)*x1825*x1827))+(((-1.0)*x1824*x1826))+new_r11);
evalcond[6]=((((-1.0)*x1834))+x1828+x1833);
evalcond[7]=((((-1.0)*x1830))+x1827+x1832);
evalcond[8]=((((-1.0)*x1826))+(((1.0000000008)*x1834))+(((-1.0000000008)*x1833)));
evalcond[9]=((((1.0000000008)*x1830))+(((-1.0000000008)*x1832))+(((-1.0)*gconst21)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1835=((1.0)*new_r00);
CheckValue<IkReal> x1836=IKPowWithIntegerCheck(IKsign(((((-1.0)*new_r11*x1835))+((new_r01*new_r10)))),-1);
if(!x1836.valid){
continue;
}
CheckValue<IkReal> x1837 = IKatan2WithCheck(IkReal((((gconst21*new_r11))+((gconst22*new_r10)))),IkReal(((((-1.0)*gconst21*new_r01))+(((-1.0)*gconst22*x1835)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1837.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1836.value)))+(x1837.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1838=IKcos(j5);
IkReal x1839=IKsin(j5);
IkReal x1840=((1.0)*gconst22);
IkReal x1841=((1.0000000008)*gconst21);
IkReal x1842=((1.0000000008)*gconst22);
IkReal x1843=(gconst22*x1839);
IkReal x1844=(new_r11*x1839);
IkReal x1845=(gconst21*x1839);
IkReal x1846=(new_r01*x1838);
IkReal x1847=(new_r00*x1838);
IkReal x1848=(new_r10*x1839);
evalcond[0]=(((new_r00*x1839))+gconst21+((new_r10*x1838)));
evalcond[1]=(((new_r01*x1839))+(((-1.0)*x1840))+((new_r11*x1838)));
evalcond[2]=(((x1838*x1842))+x1845+new_r00);
evalcond[3]=((((-1.0)*x1839*x1842))+new_r10+((gconst21*x1838)));
evalcond[4]=(((x1838*x1841))+(((-1.0)*x1839*x1840))+new_r01);
evalcond[5]=((((-1.0)*x1839*x1841))+new_r11+(((-1.0)*x1838*x1840)));
evalcond[6]=(x1842+x1847+(((-1.0)*x1848)));
evalcond[7]=(x1841+x1846+(((-1.0)*x1844)));
evalcond[8]=((((-1.0000000008)*x1847))+(((-1.0)*x1840))+(((1.0000000008)*x1848)));
evalcond[9]=((((-1.0000000008)*x1846))+(((1.0000000008)*x1844))+(((-1.0)*gconst21)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x1850 = ((((1.0000000016)*(new_r10*new_r10)))+(new_r00*new_r00));
if(IKabs(x1850)==0){
continue;
}
IkReal x1849=pow(x1850,-0.5);
CheckValue<IkReal> x1851 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1851.valid){
continue;
}
IkReal gconst23=((3.14159265358979)+(((-1.0)*(x1851.value))));
IkReal gconst24=((1.0000000008)*new_r10*x1849);
IkReal gconst25=((-1.0)*new_r00*x1849);
CheckValue<IkReal> x1852 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1852.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+(x1852.value)+j3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[2];
IkReal x1853=x1849;
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst24;
cj3=gconst25;
CheckValue<IkReal> x1854 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1854.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x1854.value))));
CheckValue<IkReal> x1855 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1855.valid){
continue;
}
IkReal gconst23=((3.14159265358979)+(((-1.0)*(x1855.value))));
IkReal gconst24=((1.0000000008)*new_r10*x1853);
IkReal gconst25=((-1.0)*new_r00*x1853);
IkReal x1856=(((new_r01*new_r10))+(((-1.0)*new_r00*new_r11)));
j5eval[0]=x1856;
j5eval[1]=IKsign(x1856);
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x1857=x1849;
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst24;
cj3=gconst25;
CheckValue<IkReal> x1858 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1858.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x1858.value))));
CheckValue<IkReal> x1859 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1859.valid){
continue;
}
IkReal gconst23=((3.14159265358979)+(((-1.0)*(x1859.value))));
IkReal gconst24=((1.0000000008)*new_r10*x1857);
IkReal gconst25=((-1.0)*new_r00*x1857);
j5eval[0]=new_r00;
IkReal x1860 = ((((1.0000000016)*(new_r10*new_r10)))+(new_r00*new_r00));
if(IKabs(x1860)==0){
continue;
}
j5eval[1]=((1.60000013238459e-9)*new_r00*new_r10*(pow(x1860,-0.5)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x1861=x1849;
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst24;
cj3=gconst25;
CheckValue<IkReal> x1862 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1862.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x1862.value))));
CheckValue<IkReal> x1863 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1863.valid){
continue;
}
IkReal gconst23=((3.14159265358979)+(((-1.0)*(x1863.value))));
IkReal gconst24=((1.0000000008)*new_r10*x1861);
IkReal gconst25=((-1.0)*new_r00*x1861);
j5eval[0]=new_r00;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(new_r00);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst24;
cj3=gconst25;
CheckValue<IkReal> x1864 = IKatan2WithCheck(IkReal(new_r10),IkReal(0),IKFAST_ATAN2_MAGTHRESH);
if(!x1864.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x1864.value))));
new_r00=0;
CheckValue<IkReal> x1865 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(0),IKFAST_ATAN2_MAGTHRESH);
if(!x1865.valid){
continue;
}
IkReal gconst23=((3.14159265358979)+(((-1.0)*(x1865.value))));
IkReal x1866 = new_r10*new_r10;
if(IKabs(x1866)==0){
continue;
}
IkReal gconst24=((1.0)*new_r10*(pow(x1866,-0.5)));
IkReal gconst25=0;
j5eval[0]=new_r10;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1868=IKPowWithIntegerCheck(gconst24,-1);
if(!x1868.valid){
continue;
}
IkReal x1867=x1868.value;
if( IKabs(((0.9999999992)*new_r11*x1867)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10*x1867)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.9999999992)*new_r11*x1867))+IKsqr(((-1.0)*new_r10*x1867))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((0.9999999992)*new_r11*x1867), ((-1.0)*new_r10*x1867));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1869=IKsin(j5);
IkReal x1870=IKcos(j5);
IkReal x1871=((1.0000000008)*x1869);
IkReal x1872=((1.0000000008)*x1870);
evalcond[0]=(gconst24*x1869);
evalcond[1]=((-1.0)*new_r10*x1869);
evalcond[2]=(((new_r10*x1870))+gconst24);
evalcond[3]=(((gconst24*x1870))+new_r10);
evalcond[4]=(new_r10*x1871);
evalcond[5]=(((new_r01*x1869))+((new_r11*x1870)));
evalcond[6]=(((gconst24*x1872))+new_r01);
evalcond[7]=((((-1.0)*gconst24*x1871))+new_r11);
evalcond[8]=((((1.0000000008)*gconst24))+((new_r01*x1870))+(((-1.0)*new_r11*x1869)));
evalcond[9]=((((-1.0)*gconst24))+((new_r11*x1871))+(((-1.0)*new_r01*x1872)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1873=IKPowWithIntegerCheck(gconst24,-1);
if(!x1873.valid){
continue;
}
CheckValue<IkReal> x1874=IKPowWithIntegerCheck(new_r10,-1);
if(!x1874.valid){
continue;
}
if( IKabs(((0.9999999992)*new_r11*(x1873.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*gconst24*(x1874.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.9999999992)*new_r11*(x1873.value)))+IKsqr(((-1.0)*gconst24*(x1874.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((0.9999999992)*new_r11*(x1873.value)), ((-1.0)*gconst24*(x1874.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1875=IKsin(j5);
IkReal x1876=IKcos(j5);
IkReal x1877=((1.0000000008)*x1875);
IkReal x1878=((1.0000000008)*x1876);
evalcond[0]=(gconst24*x1875);
evalcond[1]=((-1.0)*new_r10*x1875);
evalcond[2]=(((new_r10*x1876))+gconst24);
evalcond[3]=(((gconst24*x1876))+new_r10);
evalcond[4]=(new_r10*x1877);
evalcond[5]=(((new_r01*x1875))+((new_r11*x1876)));
evalcond[6]=(((gconst24*x1878))+new_r01);
evalcond[7]=((((-1.0)*gconst24*x1877))+new_r11);
evalcond[8]=((((1.0000000008)*gconst24))+(((-1.0)*new_r11*x1875))+((new_r01*x1876)));
evalcond[9]=((((-1.0)*gconst24))+((new_r11*x1877))+(((-1.0)*new_r01*x1878)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
IkReal x1880 = ((1.0)+(((1.6e-9)*(new_r10*new_r10))));
if(IKabs(x1880)==0){
continue;
}
IkReal x1879=pow(x1880,-0.5);
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst24;
cj3=gconst25;
CheckValue<IkReal> x1881 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1881.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x1881.value))));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x1882 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1882.valid){
continue;
}
IkReal gconst23=((3.14159265358979)+(((-1.0)*(x1882.value))));
IkReal gconst24=((1.0000000008)*new_r10*x1879);
IkReal gconst25=((-1.0)*new_r00*x1879);
IkReal x1883=new_r10*new_r10;
CheckValue<IkReal> x1887=IKPowWithIntegerCheck(((625000000.0)+(((1.0)*x1883))),-1);
if(!x1887.valid){
continue;
}
IkReal x1884=x1887.value;
if((((625000000.0)+x1883)) < -0.00001)
continue;
IkReal x1885=IKsqrt(((625000000.0)+x1883));
IkReal x1886=(x1884*x1885);
j5eval[0]=1.0;
j5eval[1]=1.0;
IkReal x1888 = ((1.0)+(((1.6e-9)*x1883)));
if(IKabs(x1888)==0){
continue;
}
j5eval[2]=((IKabs(((((-1250000001.0)*x1883*x1886))+(((625000000.5)*x1886)))))+(IKabs(((50000.00004)*new_r00*new_r10*(pow(x1888,-0.5))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x1890 = ((1.0)+(((1.6e-9)*(new_r10*new_r10))));
if(IKabs(x1890)==0){
continue;
}
IkReal x1889=pow(x1890,-0.5);
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst24;
cj3=gconst25;
CheckValue<IkReal> x1891 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1891.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x1891.value))));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x1892 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1892.valid){
continue;
}
IkReal gconst23=((3.14159265358979)+(((-1.0)*(x1892.value))));
IkReal gconst24=((1.0000000008)*new_r10*x1889);
IkReal gconst25=((-1.0)*new_r00*x1889);
IkReal x1893=new_r10*new_r10;
CheckValue<IkReal> x1895=IKPowWithIntegerCheck(((1.0)+(((1.6e-9)*x1893))),-1);
if(!x1895.valid){
continue;
}
IkReal x1894=x1895.value;
IkReal x1896=((1.0)+(((-1.0)*x1893)));
j5eval[0]=IKsign(((((-625000000.0)*x1894*(x1896*x1896)))+(((625000002.0)*x1894*(x1893*x1893)))));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x1898 = ((1.0)+(((1.6e-9)*(new_r10*new_r10))));
if(IKabs(x1898)==0){
continue;
}
IkReal x1897=pow(x1898,-0.5);
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst24;
cj3=gconst25;
CheckValue<IkReal> x1899 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1899.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x1899.value))));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x1900 = IKatan2WithCheck(IkReal(((1.0000000008)*new_r10)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1900.valid){
continue;
}
IkReal gconst23=((3.14159265358979)+(((-1.0)*(x1900.value))));
IkReal gconst24=((1.0000000008)*new_r10*x1897);
IkReal gconst25=((-1.0)*new_r00*x1897);
IkReal x1901=new_r10*new_r10;
IkReal x1902=((1.0)+(((1.6e-9)*x1901)));
CheckValue<IkReal> x1903=IKPowWithIntegerCheck(x1902,-1);
if(!x1903.valid){
continue;
}
j5eval[0]=((-3.20000004272458e-9)*x1901*(x1903.value)*(((1.0)+(((-1.0)*x1901)))));
IkReal x1904 = x1902;
if(IKabs(x1904)==0){
continue;
}
j5eval[1]=((1.60000013238459e-9)*new_r00*new_r10*(pow(x1904,-0.5)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1905=gconst24*gconst24;
IkReal x1906=(gconst25*new_r10);
CheckValue<IkReal> x1907=IKPowWithIntegerCheck(((((625000000.0)*(x1906*x1906)))+(((-625000001.0)*x1905*(new_r00*new_r00)))),-1);
if(!x1907.valid){
continue;
}
CheckValue<IkReal> x1908=IKPowWithIntegerCheck(((((25000.0)*x1906))+(((25000.00002)*gconst24*new_r00))),-1);
if(!x1908.valid){
continue;
}
if( IKabs(((x1907.value)*(((((-625000000.5)*x1905*x1906))+(((625000001.0)*new_r00*(gconst24*gconst24*gconst24))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-25000.0)*gconst24*gconst25*(x1908.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1907.value)*(((((-625000000.5)*x1905*x1906))+(((625000001.0)*new_r00*(gconst24*gconst24*gconst24)))))))+IKsqr(((-25000.0)*gconst24*gconst25*(x1908.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((x1907.value)*(((((-625000000.5)*x1905*x1906))+(((625000001.0)*new_r00*(gconst24*gconst24*gconst24)))))), ((-25000.0)*gconst24*gconst25*(x1908.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x1909=IKsin(j5);
IkReal x1910=IKcos(j5);
IkReal x1911=((1.0)*gconst25);
IkReal x1912=((1.0000000008)*x1909);
IkReal x1913=((1.0000000008)*x1910);
evalcond[0]=(gconst24+((new_r10*x1910))+((new_r00*x1909)));
evalcond[1]=(((gconst24*x1909))+((gconst25*x1913))+new_r00);
evalcond[2]=((((-1.0)*gconst25*x1912))+((gconst24*x1910))+new_r10);
evalcond[3]=(((gconst24*x1913))+(((-1.0)*x1909*x1911)));
evalcond[4]=((((-1.0)*x1910*x1911))+(((-1.0)*gconst24*x1912)));
evalcond[5]=((((1.0000000008)*gconst25))+(((-1.0)*new_r10*x1909))+((new_r00*x1910)));
evalcond[6]=((((-1.0)*new_r00*x1913))+((new_r10*x1912))+(((-1.0)*x1911)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1914=gconst25*gconst25;
IkReal x1915=gconst24*gconst24;
IkReal x1916=((625000000.0)*x1914);
IkReal x1917=((625000000.5)*gconst25*x1915);
CheckValue<IkReal> x1918 = IKatan2WithCheck(IkReal((((new_r10*x1917))+((gconst24*new_r00*x1916)))),IkReal(((((-625000001.0)*new_r10*(gconst24*gconst24*gconst24)))+(((-1.0)*new_r00*x1917)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1918.valid){
continue;
}
CheckValue<IkReal> x1919=IKPowWithIntegerCheck(IKsign(((((-1.0)*x1916*(new_r00*new_r00)))+(((625000001.0)*x1915*(new_r10*new_r10))))),-1);
if(!x1919.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x1918.value)+(((1.5707963267949)*(x1919.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x1920=IKsin(j5);
IkReal x1921=IKcos(j5);
IkReal x1922=((1.0)*gconst25);
IkReal x1923=((1.0000000008)*x1920);
IkReal x1924=((1.0000000008)*x1921);
evalcond[0]=(gconst24+((new_r00*x1920))+((new_r10*x1921)));
evalcond[1]=(((gconst25*x1924))+((gconst24*x1920))+new_r00);
evalcond[2]=((((-1.0)*gconst25*x1923))+((gconst24*x1921))+new_r10);
evalcond[3]=(((gconst24*x1924))+(((-1.0)*x1920*x1922)));
evalcond[4]=((((-1.0)*gconst24*x1923))+(((-1.0)*x1921*x1922)));
evalcond[5]=((((1.0000000008)*gconst25))+((new_r00*x1921))+(((-1.0)*new_r10*x1920)));
evalcond[6]=((((-1.0)*x1922))+((new_r10*x1923))+(((-1.0)*new_r00*x1924)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1925=((25000.00002)*gconst25);
IkReal x1926=((25000.0)*gconst24);
CheckValue<IkReal> x1927 = IKatan2WithCheck(IkReal((((new_r10*x1925))+(((-1.0)*new_r00*x1926)))),IkReal(((((-1.0)*new_r10*x1926))+(((-1.0)*new_r00*x1925)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1927.valid){
continue;
}
CheckValue<IkReal> x1928=IKPowWithIntegerCheck(IKsign(((((25000.0)*(new_r10*new_r10)))+(((25000.0)*(new_r00*new_r00))))),-1);
if(!x1928.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x1927.value)+(((1.5707963267949)*(x1928.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x1929=IKsin(j5);
IkReal x1930=IKcos(j5);
IkReal x1931=((1.0)*gconst25);
IkReal x1932=((1.0000000008)*x1929);
IkReal x1933=((1.0000000008)*x1930);
evalcond[0]=(gconst24+((new_r10*x1930))+((new_r00*x1929)));
evalcond[1]=(((gconst24*x1929))+((gconst25*x1933))+new_r00);
evalcond[2]=((((-1.0)*gconst25*x1932))+((gconst24*x1930))+new_r10);
evalcond[3]=(((gconst24*x1933))+(((-1.0)*x1929*x1931)));
evalcond[4]=((((-1.0)*x1930*x1931))+(((-1.0)*gconst24*x1932)));
evalcond[5]=((((1.0000000008)*gconst25))+((new_r00*x1930))+(((-1.0)*new_r10*x1929)));
evalcond[6]=((((-1.0)*new_r00*x1933))+((new_r10*x1932))+(((-1.0)*x1931)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1935=IKPowWithIntegerCheck(gconst25,-1);
if(!x1935.valid){
continue;
}
IkReal x1934=x1935.value;
if( IKabs((new_r01*x1934)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.9999999992)*new_r00*x1934)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r01*x1934))+IKsqr(((-0.9999999992)*new_r00*x1934))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((new_r01*x1934), ((-0.9999999992)*new_r00*x1934));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1936=IKcos(j5);
IkReal x1937=IKsin(j5);
IkReal x1938=((1.0)*gconst25);
IkReal x1939=(gconst25*x1936);
IkReal x1940=(new_r00*x1936);
IkReal x1941=(new_r01*x1936);
evalcond[0]=(new_r00*x1937);
evalcond[1]=x1941;
evalcond[2]=((-1.0)*x1939);
evalcond[3]=((((-1.0)*x1937*x1938))+new_r01);
evalcond[4]=(((new_r01*x1937))+(((-1.0)*x1938)));
evalcond[5]=((-1.0000000008)*gconst25*x1937);
evalcond[6]=((-1.0000000008)*x1941);
evalcond[7]=((((1.0000000008)*x1939))+new_r00);
evalcond[8]=((((1.0000000008)*gconst25))+x1940);
evalcond[9]=((((-1.0000000008)*x1940))+(((-1.0)*x1938)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1946=IKPowWithIntegerCheck(new_r00,-1);
if(!x1946.valid){
continue;
}
IkReal x1942=x1946.value;
IkReal x1943=gconst24*gconst24;
IkReal x1944=((25000.0)*new_r10);
CheckValue<IkReal> x1947=IKPowWithIntegerCheck(((((-1.0)*gconst24*x1944))+(((25000.00002)*gconst25*new_r00))),-1);
if(!x1947.valid){
continue;
}
IkReal x1945=x1947.value;
CheckValue<IkReal> x1948=IKPowWithIntegerCheck(((((-25000.0)*gconst24*new_r10))+(((25000.00002)*gconst25*new_r00))),-1);
if(!x1948.valid){
continue;
}
CheckValue<IkReal> x1949=IKPowWithIntegerCheck(((((-25000.0)*gconst24*new_r10))+(((25000.00002)*gconst25*new_r00))),-1);
if(!x1949.valid){
continue;
}
CheckValue<IkReal> x1950=IKPowWithIntegerCheck(x1942,-2);
if(!x1950.valid){
continue;
}
if( IKabs(((((-1.0)*gconst24*x1942))+((new_r00*x1944*(x1948.value)))+(((-1.0)*x1942*x1943*x1944*(x1949.value))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x1945*(((((25000.0)*x1943))+(((-25000.0)*(x1950.value))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*gconst24*x1942))+((new_r00*x1944*(x1948.value)))+(((-1.0)*x1942*x1943*x1944*(x1949.value)))))+IKsqr((x1945*(((((25000.0)*x1943))+(((-25000.0)*(x1950.value)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*gconst24*x1942))+((new_r00*x1944*(x1948.value)))+(((-1.0)*x1942*x1943*x1944*(x1949.value)))), (x1945*(((((25000.0)*x1943))+(((-25000.0)*(x1950.value)))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1951=IKcos(j5);
IkReal x1952=IKsin(j5);
IkReal x1953=((1.0)*gconst25);
IkReal x1954=((1.0000000008)*gconst25);
IkReal x1955=((1.0000000008)*gconst24);
IkReal x1956=(new_r11*x1952);
IkReal x1957=(new_r01*x1951);
IkReal x1958=(new_r00*x1951);
IkReal x1959=(new_r10*x1952);
evalcond[0]=(((new_r10*x1951))+((new_r00*x1952))+gconst24);
evalcond[1]=(((new_r11*x1951))+(((-1.0)*x1953))+((new_r01*x1952)));
evalcond[2]=(((gconst24*x1952))+((x1951*x1954))+new_r00);
evalcond[3]=((((-1.0)*x1952*x1954))+((gconst24*x1951))+new_r10);
evalcond[4]=((((-1.0)*x1952*x1953))+((x1951*x1955))+new_r01);
evalcond[5]=((((-1.0)*x1952*x1955))+(((-1.0)*x1951*x1953))+new_r11);
evalcond[6]=(x1954+x1958+(((-1.0)*x1959)));
evalcond[7]=(x1955+x1957+(((-1.0)*x1956)));
evalcond[8]=((((1.0000000008)*x1959))+(((-1.0)*x1953))+(((-1.0000000008)*x1958)));
evalcond[9]=((((1.0000000008)*x1956))+(((-1.0000000008)*x1957))+(((-1.0)*gconst24)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x1964=IKPowWithIntegerCheck(new_r00,-1);
if(!x1964.valid){
continue;
}
IkReal x1960=x1964.value;
IkReal x1961=((25000.0)*new_r10);
IkReal x1962=(gconst24*x1960);
CheckValue<IkReal> x1965=IKPowWithIntegerCheck((((gconst25*x1961))+(((25000.00002)*gconst24*new_r00))),-1);
if(!x1965.valid){
continue;
}
IkReal x1963=x1965.value;
if( IKabs(((((-1.0)*x1962))+((new_r01*x1961*x1963))+((gconst25*x1961*x1962*x1963)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x1963*(((((-25000.0)*new_r00*new_r01))+(((-25000.0)*gconst24*gconst25)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*x1962))+((new_r01*x1961*x1963))+((gconst25*x1961*x1962*x1963))))+IKsqr((x1963*(((((-25000.0)*new_r00*new_r01))+(((-25000.0)*gconst24*gconst25))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*x1962))+((new_r01*x1961*x1963))+((gconst25*x1961*x1962*x1963))), (x1963*(((((-25000.0)*new_r00*new_r01))+(((-25000.0)*gconst24*gconst25))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1966=IKcos(j5);
IkReal x1967=IKsin(j5);
IkReal x1968=((1.0)*gconst25);
IkReal x1969=((1.0000000008)*gconst25);
IkReal x1970=((1.0000000008)*gconst24);
IkReal x1971=(new_r11*x1967);
IkReal x1972=(new_r01*x1966);
IkReal x1973=(new_r00*x1966);
IkReal x1974=(new_r10*x1967);
evalcond[0]=(((new_r00*x1967))+gconst24+((new_r10*x1966)));
evalcond[1]=(((new_r11*x1966))+((new_r01*x1967))+(((-1.0)*x1968)));
evalcond[2]=(((gconst24*x1967))+((x1966*x1969))+new_r00);
evalcond[3]=(((gconst24*x1966))+new_r10+(((-1.0)*x1967*x1969)));
evalcond[4]=(((x1966*x1970))+new_r01+(((-1.0)*x1967*x1968)));
evalcond[5]=((((-1.0)*x1966*x1968))+new_r11+(((-1.0)*x1967*x1970)));
evalcond[6]=((((-1.0)*x1974))+x1969+x1973);
evalcond[7]=((((-1.0)*x1971))+x1972+x1970);
evalcond[8]=((((-1.0)*x1968))+(((-1.0000000008)*x1973))+(((1.0000000008)*x1974)));
evalcond[9]=((((-1.0)*gconst24))+(((-1.0000000008)*x1972))+(((1.0000000008)*x1971)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x1975=((1.0)*new_r00);
CheckValue<IkReal> x1976 = IKatan2WithCheck(IkReal((((gconst25*new_r10))+((gconst24*new_r11)))),IkReal(((((-1.0)*gconst24*new_r01))+(((-1.0)*gconst25*x1975)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1976.valid){
continue;
}
CheckValue<IkReal> x1977=IKPowWithIntegerCheck(IKsign(((((-1.0)*new_r11*x1975))+((new_r01*new_r10)))),-1);
if(!x1977.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x1976.value)+(((1.5707963267949)*(x1977.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x1978=IKcos(j5);
IkReal x1979=IKsin(j5);
IkReal x1980=((1.0)*gconst25);
IkReal x1981=((1.0000000008)*gconst25);
IkReal x1982=((1.0000000008)*gconst24);
IkReal x1983=(new_r11*x1979);
IkReal x1984=(new_r01*x1978);
IkReal x1985=(new_r00*x1978);
IkReal x1986=(new_r10*x1979);
evalcond[0]=(((new_r10*x1978))+((new_r00*x1979))+gconst24);
evalcond[1]=(((new_r01*x1979))+((new_r11*x1978))+(((-1.0)*x1980)));
evalcond[2]=(((gconst24*x1979))+((x1978*x1981))+new_r00);
evalcond[3]=(((gconst24*x1978))+(((-1.0)*x1979*x1981))+new_r10);
evalcond[4]=((((-1.0)*x1979*x1980))+((x1978*x1982))+new_r01);
evalcond[5]=((((-1.0)*x1979*x1982))+new_r11+(((-1.0)*x1978*x1980)));
evalcond[6]=(x1985+x1981+(((-1.0)*x1986)));
evalcond[7]=(x1984+x1982+(((-1.0)*x1983)));
evalcond[8]=((((1.0000000008)*x1986))+(((-1.0)*x1980))+(((-1.0000000008)*x1985)));
evalcond[9]=((((1.0000000008)*x1983))+(((-1.0000000008)*x1984))+(((-1.0)*gconst24)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x1987=((1.0000000008)*new_r00);
IkReal x1989 = ((((1.0000000016)*(new_r00*new_r00)))+(new_r10*new_r10));
if(IKabs(x1989)==0){
continue;
}
IkReal x1988=pow(x1989,-0.5);
CheckValue<IkReal> x1990 = IKatan2WithCheck(IkReal(new_r10),IkReal(x1987),IKFAST_ATAN2_MAGTHRESH);
if(!x1990.valid){
continue;
}
IkReal gconst26=((-1.0)*(x1990.value));
IkReal gconst27=((-1.0)*new_r10*x1988);
IkReal gconst28=(x1987*x1988);
CheckValue<IkReal> x1991 = IKatan2WithCheck(IkReal(new_r10),IkReal(((1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x1991.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((x1991.value)+j3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
IkReal x1992=((1.0000000008)*new_r00);
IkReal x1993=x1988;
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst27;
cj3=gconst28;
CheckValue<IkReal> x1994 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x1994.valid){
continue;
}
j3=((-1.0)*(x1994.value));
CheckValue<IkReal> x1995 = IKatan2WithCheck(IkReal(new_r10),IkReal(x1992),IKFAST_ATAN2_MAGTHRESH);
if(!x1995.valid){
continue;
}
IkReal gconst26=((-1.0)*(x1995.value));
IkReal gconst27=((-1.0)*new_r10*x1993);
IkReal gconst28=(x1992*x1993);
IkReal x1996=new_r00*new_r00;
IkReal x1997=(new_r01*new_r10);
IkReal x1998=(x1997+(((-1.0)*new_r00*new_r11)));
IkReal x2001 = ((((625000000.0)*(new_r10*new_r10)))+(((625000001.0)*x1996)));
if(IKabs(x2001)==0){
continue;
}
IkReal x1999=pow(x2001,-0.5);
IkReal x2000=(new_r10*x1999);
j5eval[0]=x1998;
j5eval[1]=IKsign(x1998);
j5eval[2]=((IKabs(((((25000.00002)*new_r00*x2000))+(((-25000.0)*new_r11*x2000)))))+(IKabs(((((25000.0)*x1997*x1999))+(((-25000.00002)*x1996*x1999))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x2002=((1.0000000008)*new_r00);
IkReal x2003=x1988;
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst27;
cj3=gconst28;
CheckValue<IkReal> x2004 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x2004.valid){
continue;
}
j3=((-1.0)*(x2004.value));
CheckValue<IkReal> x2005 = IKatan2WithCheck(IkReal(new_r10),IkReal(x2002),IKFAST_ATAN2_MAGTHRESH);
if(!x2005.valid){
continue;
}
IkReal gconst26=((-1.0)*(x2005.value));
IkReal gconst27=((-1.0)*new_r10*x2003);
IkReal gconst28=(x2002*x2003);
j5eval[0]=new_r00;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x2006=((1.0000000008)*new_r00);
IkReal x2007=x1988;
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst27;
cj3=gconst28;
CheckValue<IkReal> x2008 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x2008.valid){
continue;
}
j3=((-1.0)*(x2008.value));
CheckValue<IkReal> x2009 = IKatan2WithCheck(IkReal(new_r10),IkReal(x2006),IKFAST_ATAN2_MAGTHRESH);
if(!x2009.valid){
continue;
}
IkReal gconst26=((-1.0)*(x2009.value));
IkReal gconst27=((-1.0)*new_r10*x2007);
IkReal gconst28=(x2006*x2007);
j5eval[0]=new_r00;
IkReal x2010 = ((((1.0000000016)*(new_r00*new_r00)))+(new_r10*new_r10));
if(IKabs(x2010)==0){
continue;
}
j5eval[1]=((1.6e-9)*new_r00*new_r10*(pow(x2010,-0.5)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(new_r00);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
CheckValue<IkReal> x2012 = IKatan2WithCheck(IkReal(new_r10),IkReal(0),IKFAST_ATAN2_MAGTHRESH);
if(!x2012.valid){
continue;
}
IkReal x2011=((-1.0)*(x2012.value));
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst27;
cj3=gconst28;
j3=x2011;
new_r00=0;
IkReal gconst26=x2011;
IkReal x2013 = new_r10*new_r10;
if(IKabs(x2013)==0){
continue;
}
IkReal gconst27=((-1.0)*new_r10*(pow(x2013,-0.5)));
IkReal gconst28=0;
j5eval[0]=new_r10;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2015=IKPowWithIntegerCheck(gconst27,-1);
if(!x2015.valid){
continue;
}
IkReal x2014=x2015.value;
if( IKabs(((0.9999999992)*new_r11*x2014)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10*x2014)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.9999999992)*new_r11*x2014))+IKsqr(((-1.0)*new_r10*x2014))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((0.9999999992)*new_r11*x2014), ((-1.0)*new_r10*x2014));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2016=IKsin(j5);
IkReal x2017=IKcos(j5);
IkReal x2018=((1.0000000008)*x2016);
IkReal x2019=(gconst27*x2017);
IkReal x2020=(new_r01*x2017);
evalcond[0]=(gconst27*x2016);
evalcond[1]=((-1.0)*new_r10*x2016);
evalcond[2]=(gconst27+((new_r10*x2017)));
evalcond[3]=(x2019+new_r10);
evalcond[4]=(new_r10*x2018);
evalcond[5]=(((new_r11*x2017))+((new_r01*x2016)));
evalcond[6]=((((1.0000000008)*x2019))+new_r01);
evalcond[7]=(new_r11+(((-1.0)*gconst27*x2018)));
evalcond[8]=(x2020+(((1.0000000008)*gconst27))+(((-1.0)*new_r11*x2016)));
evalcond[9]=(((new_r11*x2018))+(((-1.0000000008)*x2020))+(((-1.0)*gconst27)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2021=IKPowWithIntegerCheck(gconst27,-1);
if(!x2021.valid){
continue;
}
CheckValue<IkReal> x2022=IKPowWithIntegerCheck(new_r10,-1);
if(!x2022.valid){
continue;
}
if( IKabs(((0.9999999992)*new_r11*(x2021.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*gconst27*(x2022.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.9999999992)*new_r11*(x2021.value)))+IKsqr(((-1.0)*gconst27*(x2022.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((0.9999999992)*new_r11*(x2021.value)), ((-1.0)*gconst27*(x2022.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2023=IKsin(j5);
IkReal x2024=IKcos(j5);
IkReal x2025=((1.0000000008)*x2023);
IkReal x2026=(gconst27*x2024);
IkReal x2027=(new_r01*x2024);
evalcond[0]=(gconst27*x2023);
evalcond[1]=((-1.0)*new_r10*x2023);
evalcond[2]=(((new_r10*x2024))+gconst27);
evalcond[3]=(x2026+new_r10);
evalcond[4]=(new_r10*x2025);
evalcond[5]=(((new_r01*x2023))+((new_r11*x2024)));
evalcond[6]=((((1.0000000008)*x2026))+new_r01);
evalcond[7]=((((-1.0)*gconst27*x2025))+new_r11);
evalcond[8]=(x2027+(((1.0000000008)*gconst27))+(((-1.0)*new_r11*x2023)));
evalcond[9]=((((-1.0000000008)*x2027))+((new_r11*x2025))+(((-1.0)*gconst27)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
IkReal x2028=((1.0000000008)*new_r00);
IkReal x2030 = ((1.0000000016)+(((-1.6e-9)*(new_r10*new_r10))));
if(IKabs(x2030)==0){
continue;
}
IkReal x2029=pow(x2030,-0.5);
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst27;
cj3=gconst28;
CheckValue<IkReal> x2031 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x2031.valid){
continue;
}
j3=((-1.0)*(x2031.value));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x2032 = IKatan2WithCheck(IkReal(new_r10),IkReal(x2028),IKFAST_ATAN2_MAGTHRESH);
if(!x2032.valid){
continue;
}
IkReal gconst26=((-1.0)*(x2032.value));
IkReal gconst27=((-1.0)*new_r10*x2029);
IkReal gconst28=(x2028*x2029);
IkReal x2033=new_r10*new_r10;
CheckValue<IkReal> x2037=IKPowWithIntegerCheck(((-625000001.0)+x2033),-1);
if(!x2037.valid){
continue;
}
IkReal x2034=x2037.value;
if((((625000001.0)+(((-1.0)*x2033)))) < -0.00001)
continue;
IkReal x2035=IKsqrt(((625000001.0)+(((-1.0)*x2033))));
IkReal x2036=(x2034*x2035);
j5eval[0]=1.0;
j5eval[1]=1.0;
IkReal x2038 = ((1.0000000016)+(((-1.6e-9)*x2033)));
if(IKabs(x2038)==0){
continue;
}
j5eval[2]=((((50000.00004)*(IKabs((new_r00*new_r10*(pow(x2038,-0.5)))))))+(IKabs(((((-1250000001.0)*x2033*x2036))+(((625000001.0)*x2036))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x2039=((1.0000000008)*new_r00);
IkReal x2041 = ((1.0000000016)+(((-1.6e-9)*(new_r10*new_r10))));
if(IKabs(x2041)==0){
continue;
}
IkReal x2040=pow(x2041,-0.5);
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst27;
cj3=gconst28;
CheckValue<IkReal> x2042 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x2042.valid){
continue;
}
j3=((-1.0)*(x2042.value));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x2043 = IKatan2WithCheck(IkReal(new_r10),IkReal(x2039),IKFAST_ATAN2_MAGTHRESH);
if(!x2043.valid){
continue;
}
IkReal gconst26=((-1.0)*(x2043.value));
IkReal gconst27=((-1.0)*new_r10*x2040);
IkReal gconst28=(x2039*x2040);
IkReal x2044=new_r10*new_r10;
CheckValue<IkReal> x2047=IKPowWithIntegerCheck(((1.0000000016)+(((-1.6e-9)*x2044))),-1);
if(!x2047.valid){
continue;
}
IkReal x2045=x2047.value;
IkReal x2046=((625000001.0)*x2045);
IkReal x2048=((1.0)+(((-1.0)*x2044)));
j5eval[0]=IKsign((((x2046*(x2044*x2044)))+(((-1.0)*x2046*(x2048*x2048)))));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x2049=((1.0000000008)*new_r00);
IkReal x2051 = ((1.0000000016)+(((-1.6e-9)*(new_r10*new_r10))));
if(IKabs(x2051)==0){
continue;
}
IkReal x2050=pow(x2051,-0.5);
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst27;
cj3=gconst28;
CheckValue<IkReal> x2052 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x2052.valid){
continue;
}
j3=((-1.0)*(x2052.value));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x2053 = IKatan2WithCheck(IkReal(new_r10),IkReal(x2049),IKFAST_ATAN2_MAGTHRESH);
if(!x2053.valid){
continue;
}
IkReal gconst26=((-1.0)*(x2053.value));
IkReal gconst27=((-1.0)*new_r10*x2050);
IkReal gconst28=(x2049*x2050);
j5eval[0]=new_r00;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2060=IKPowWithIntegerCheck(new_r00,-1);
if(!x2060.valid){
continue;
}
IkReal x2054=x2060.value;
IkReal x2055=gconst27*gconst27;
IkReal x2056=((25000.0)*new_r10);
IkReal x2057=((25000.0)*x2055);
CheckValue<IkReal> x2061=IKPowWithIntegerCheck(((((-1.0)*gconst27*x2056))+(((25000.00002)*gconst28*new_r00))),-1);
if(!x2061.valid){
continue;
}
IkReal x2058=x2061.value;
IkReal x2059=(new_r10*x2058);
CheckValue<IkReal> x2062=IKPowWithIntegerCheck(((((-25000.0)*gconst27*new_r10))+(((25000.00002)*gconst28*new_r00))),-1);
if(!x2062.valid){
continue;
}
CheckValue<IkReal> x2063=IKPowWithIntegerCheck(((((-25000.0)*gconst27*new_r10))+(((25000.00002)*gconst28*new_r00))),-1);
if(!x2063.valid){
continue;
}
CheckValue<IkReal> x2064=IKPowWithIntegerCheck(x2054,-2);
if(!x2064.valid){
continue;
}
if( IKabs(((((-1.0)*x2054*x2055*x2056*(x2062.value)))+(((-1.0)*gconst27*x2054))+((new_r00*x2056*(x2063.value))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x2058*((x2057+(((-25000.0)*(x2064.value))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*x2054*x2055*x2056*(x2062.value)))+(((-1.0)*gconst27*x2054))+((new_r00*x2056*(x2063.value)))))+IKsqr((x2058*((x2057+(((-25000.0)*(x2064.value)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*x2054*x2055*x2056*(x2062.value)))+(((-1.0)*gconst27*x2054))+((new_r00*x2056*(x2063.value)))), (x2058*((x2057+(((-25000.0)*(x2064.value)))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x2065=IKcos(j5);
IkReal x2066=IKsin(j5);
IkReal x2067=((1.0000000008)*gconst28);
IkReal x2068=((1.0)*gconst28);
IkReal x2069=((1.0000000008)*x2066);
IkReal x2070=(gconst27*x2065);
IkReal x2071=(new_r00*x2065);
evalcond[0]=(gconst27+((new_r10*x2065))+((new_r00*x2066)));
evalcond[1]=(((gconst27*x2066))+new_r00+((x2065*x2067)));
evalcond[2]=(x2070+new_r10+(((-1.0)*x2066*x2067)));
evalcond[3]=((((1.0000000008)*x2070))+(((-1.0)*x2066*x2068)));
evalcond[4]=((((-1.0)*gconst27*x2069))+(((-1.0)*x2065*x2068)));
evalcond[5]=(x2067+x2071+(((-1.0)*new_r10*x2066)));
evalcond[6]=((((-1.0000000008)*x2071))+(((-1.0)*x2068))+((new_r10*x2069)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x2072=gconst27*gconst27;
IkReal x2073=gconst28*gconst28;
IkReal x2074=((625000000.0)*x2073);
IkReal x2075=((625000000.5)*gconst28*x2072);
CheckValue<IkReal> x2076 = IKatan2WithCheck(IkReal((((gconst27*new_r00*x2074))+((new_r10*x2075)))),IkReal(((((-625000001.0)*new_r10*(gconst27*gconst27*gconst27)))+(((-1.0)*new_r00*x2075)))),IKFAST_ATAN2_MAGTHRESH);
if(!x2076.valid){
continue;
}
CheckValue<IkReal> x2077=IKPowWithIntegerCheck(IKsign(((((625000001.0)*x2072*(new_r10*new_r10)))+(((-1.0)*x2074*(new_r00*new_r00))))),-1);
if(!x2077.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x2076.value)+(((1.5707963267949)*(x2077.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x2078=IKcos(j5);
IkReal x2079=IKsin(j5);
IkReal x2080=((1.0000000008)*gconst28);
IkReal x2081=((1.0)*gconst28);
IkReal x2082=((1.0000000008)*x2079);
IkReal x2083=(gconst27*x2078);
IkReal x2084=(new_r00*x2078);
evalcond[0]=(gconst27+((new_r00*x2079))+((new_r10*x2078)));
evalcond[1]=(((gconst27*x2079))+((x2078*x2080))+new_r00);
evalcond[2]=(x2083+(((-1.0)*x2079*x2080))+new_r10);
evalcond[3]=((((1.0000000008)*x2083))+(((-1.0)*x2079*x2081)));
evalcond[4]=((((-1.0)*x2078*x2081))+(((-1.0)*gconst27*x2082)));
evalcond[5]=(x2080+x2084+(((-1.0)*new_r10*x2079)));
evalcond[6]=((((-1.0000000008)*x2084))+(((-1.0)*x2081))+((new_r10*x2082)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x2085=((25000.0)*gconst27);
IkReal x2086=((25000.00002)*gconst28);
CheckValue<IkReal> x2087 = IKatan2WithCheck(IkReal((((new_r10*x2086))+(((-1.0)*new_r00*x2085)))),IkReal(((((-1.0)*new_r10*x2085))+(((-1.0)*new_r00*x2086)))),IKFAST_ATAN2_MAGTHRESH);
if(!x2087.valid){
continue;
}
CheckValue<IkReal> x2088=IKPowWithIntegerCheck(IKsign(((((25000.0)*(new_r10*new_r10)))+(((25000.0)*(new_r00*new_r00))))),-1);
if(!x2088.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x2087.value)+(((1.5707963267949)*(x2088.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x2089=IKcos(j5);
IkReal x2090=IKsin(j5);
IkReal x2091=((1.0000000008)*gconst28);
IkReal x2092=((1.0)*gconst28);
IkReal x2093=((1.0000000008)*x2090);
IkReal x2094=(gconst27*x2089);
IkReal x2095=(new_r00*x2089);
evalcond[0]=(gconst27+((new_r00*x2090))+((new_r10*x2089)));
evalcond[1]=(((gconst27*x2090))+((x2089*x2091))+new_r00);
evalcond[2]=((((-1.0)*x2090*x2091))+x2094+new_r10);
evalcond[3]=((((-1.0)*x2090*x2092))+(((1.0000000008)*x2094)));
evalcond[4]=((((-1.0)*x2089*x2092))+(((-1.0)*gconst27*x2093)));
evalcond[5]=(x2095+x2091+(((-1.0)*new_r10*x2090)));
evalcond[6]=((((-1.0)*x2092))+((new_r10*x2093))+(((-1.0000000008)*x2095)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2097=IKPowWithIntegerCheck(gconst28,-1);
if(!x2097.valid){
continue;
}
IkReal x2096=x2097.value;
if( IKabs((new_r01*x2096)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.9999999992)*new_r00*x2096)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r01*x2096))+IKsqr(((-0.9999999992)*new_r00*x2096))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((new_r01*x2096), ((-0.9999999992)*new_r00*x2096));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2098=IKcos(j5);
IkReal x2099=IKsin(j5);
IkReal x2100=((1.0)*gconst28);
IkReal x2101=((1.0000000008)*gconst28);
IkReal x2102=(new_r00*x2098);
IkReal x2103=(new_r01*x2098);
evalcond[0]=(new_r00*x2099);
evalcond[1]=x2103;
evalcond[2]=((-1.0)*gconst28*x2098);
evalcond[3]=((((-1.0)*x2099*x2100))+new_r01);
evalcond[4]=((((-1.0)*x2100))+((new_r01*x2099)));
evalcond[5]=((-1.0000000008)*gconst28*x2099);
evalcond[6]=((-1.0000000008)*x2103);
evalcond[7]=(((x2098*x2101))+new_r00);
evalcond[8]=(x2102+x2101);
evalcond[9]=((((-1.0)*x2100))+(((-1.0000000008)*x2102)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2109=IKPowWithIntegerCheck(new_r00,-1);
if(!x2109.valid){
continue;
}
IkReal x2104=x2109.value;
IkReal x2105=((25000.0)*new_r00);
IkReal x2106=(gconst27*x2104);
IkReal x2107=((25000.00002)*gconst28);
CheckValue<IkReal> x2110=IKPowWithIntegerCheck((((new_r10*x2107))+((gconst27*x2105))),-1);
if(!x2110.valid){
continue;
}
IkReal x2108=x2110.value;
if( IKabs(((((25000.0)*x2108*(new_r10*new_r10)))+((new_r10*x2106*x2107*x2108))+(((-1.0)*x2106)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x2108*(((((-1.0)*gconst27*x2107))+(((-1.0)*new_r10*x2105)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((25000.0)*x2108*(new_r10*new_r10)))+((new_r10*x2106*x2107*x2108))+(((-1.0)*x2106))))+IKsqr((x2108*(((((-1.0)*gconst27*x2107))+(((-1.0)*new_r10*x2105))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((25000.0)*x2108*(new_r10*new_r10)))+((new_r10*x2106*x2107*x2108))+(((-1.0)*x2106))), (x2108*(((((-1.0)*gconst27*x2107))+(((-1.0)*new_r10*x2105))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2111=IKcos(j5);
IkReal x2112=IKsin(j5);
IkReal x2113=((1.0)*gconst28);
IkReal x2114=((1.0000000008)*gconst27);
IkReal x2115=(new_r11*x2112);
IkReal x2116=((1.0000000008)*x2111);
IkReal x2117=((1.0000000008)*x2112);
evalcond[0]=(((new_r00*x2112))+gconst27+((new_r10*x2111)));
evalcond[1]=(((new_r01*x2112))+((new_r11*x2111))+(((-1.0)*x2113)));
evalcond[2]=(((gconst28*x2116))+new_r00+((gconst27*x2112)));
evalcond[3]=(new_r10+(((-1.0)*gconst28*x2117))+((gconst27*x2111)));
evalcond[4]=((((-1.0)*x2112*x2113))+((x2111*x2114))+new_r01);
evalcond[5]=((((-1.0)*x2112*x2114))+(((-1.0)*x2111*x2113))+new_r11);
evalcond[6]=(((new_r00*x2111))+(((-1.0)*new_r10*x2112))+(((1.0000000008)*gconst28)));
evalcond[7]=(((new_r01*x2111))+x2114+(((-1.0)*x2115)));
evalcond[8]=((((-1.0)*new_r00*x2116))+(((-1.0)*x2113))+((new_r10*x2117)));
evalcond[9]=((((-1.0)*new_r01*x2116))+(((1.0000000008)*x2115))+(((-1.0)*gconst27)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2124=IKPowWithIntegerCheck(new_r00,-1);
if(!x2124.valid){
continue;
}
IkReal x2118=x2124.value;
IkReal x2119=gconst27*gconst27;
IkReal x2120=((25000.0)*new_r10);
IkReal x2121=((25000.0)*x2119);
CheckValue<IkReal> x2125=IKPowWithIntegerCheck(((((-1.0)*gconst27*x2120))+(((25000.00002)*gconst28*new_r00))),-1);
if(!x2125.valid){
continue;
}
IkReal x2122=x2125.value;
IkReal x2123=(new_r10*x2122);
CheckValue<IkReal> x2126=IKPowWithIntegerCheck(((((-25000.0)*gconst27*new_r10))+(((25000.00002)*gconst28*new_r00))),-1);
if(!x2126.valid){
continue;
}
CheckValue<IkReal> x2127=IKPowWithIntegerCheck(((((-25000.0)*gconst27*new_r10))+(((25000.00002)*gconst28*new_r00))),-1);
if(!x2127.valid){
continue;
}
CheckValue<IkReal> x2128=IKPowWithIntegerCheck(x2118,-2);
if(!x2128.valid){
continue;
}
if( IKabs(((((-1.0)*x2118*x2119*x2120*(x2126.value)))+(((-1.0)*gconst27*x2118))+((new_r00*x2120*(x2127.value))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x2122*(((((-25000.0)*(x2128.value)))+x2121)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*x2118*x2119*x2120*(x2126.value)))+(((-1.0)*gconst27*x2118))+((new_r00*x2120*(x2127.value)))))+IKsqr((x2122*(((((-25000.0)*(x2128.value)))+x2121))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*x2118*x2119*x2120*(x2126.value)))+(((-1.0)*gconst27*x2118))+((new_r00*x2120*(x2127.value)))), (x2122*(((((-25000.0)*(x2128.value)))+x2121))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2129=IKcos(j5);
IkReal x2130=IKsin(j5);
IkReal x2131=((1.0)*gconst28);
IkReal x2132=((1.0000000008)*gconst27);
IkReal x2133=(new_r11*x2130);
IkReal x2134=((1.0000000008)*x2129);
IkReal x2135=((1.0000000008)*x2130);
evalcond[0]=(gconst27+((new_r00*x2130))+((new_r10*x2129)));
evalcond[1]=((((-1.0)*x2131))+((new_r11*x2129))+((new_r01*x2130)));
evalcond[2]=(((gconst28*x2134))+((gconst27*x2130))+new_r00);
evalcond[3]=(((gconst27*x2129))+(((-1.0)*gconst28*x2135))+new_r10);
evalcond[4]=((((-1.0)*x2130*x2131))+new_r01+((x2129*x2132)));
evalcond[5]=((((-1.0)*x2130*x2132))+(((-1.0)*x2129*x2131))+new_r11);
evalcond[6]=((((-1.0)*new_r10*x2130))+(((1.0000000008)*gconst28))+((new_r00*x2129)));
evalcond[7]=(x2132+((new_r01*x2129))+(((-1.0)*x2133)));
evalcond[8]=(((new_r10*x2135))+(((-1.0)*x2131))+(((-1.0)*new_r00*x2134)));
evalcond[9]=((((-1.0)*new_r01*x2134))+(((1.0000000008)*x2133))+(((-1.0)*gconst27)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x2136=((1.0)*new_r00);
CheckValue<IkReal> x2137=IKPowWithIntegerCheck(IKsign((((new_r01*new_r10))+(((-1.0)*new_r11*x2136)))),-1);
if(!x2137.valid){
continue;
}
CheckValue<IkReal> x2138 = IKatan2WithCheck(IkReal((((gconst28*new_r10))+((gconst27*new_r11)))),IkReal(((((-1.0)*gconst27*new_r01))+(((-1.0)*gconst28*x2136)))),IKFAST_ATAN2_MAGTHRESH);
if(!x2138.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x2137.value)))+(x2138.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2139=IKcos(j5);
IkReal x2140=IKsin(j5);
IkReal x2141=((1.0)*gconst28);
IkReal x2142=((1.0000000008)*gconst27);
IkReal x2143=(new_r11*x2140);
IkReal x2144=((1.0000000008)*x2139);
IkReal x2145=((1.0000000008)*x2140);
evalcond[0]=(((new_r00*x2140))+((new_r10*x2139))+gconst27);
evalcond[1]=(((new_r11*x2139))+((new_r01*x2140))+(((-1.0)*x2141)));
evalcond[2]=(((gconst27*x2140))+new_r00+((gconst28*x2144)));
evalcond[3]=(((gconst27*x2139))+new_r10+(((-1.0)*gconst28*x2145)));
evalcond[4]=((((-1.0)*x2140*x2141))+new_r01+((x2139*x2142)));
evalcond[5]=((((-1.0)*x2140*x2142))+new_r11+(((-1.0)*x2139*x2141)));
evalcond[6]=((((1.0000000008)*gconst28))+((new_r00*x2139))+(((-1.0)*new_r10*x2140)));
evalcond[7]=((((-1.0)*x2143))+x2142+((new_r01*x2139)));
evalcond[8]=((((-1.0)*x2141))+(((-1.0)*new_r00*x2144))+((new_r10*x2145)));
evalcond[9]=((((-1.0)*new_r01*x2144))+(((1.0000000008)*x2143))+(((-1.0)*gconst27)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x2147 = ((((1.0000000016)*(new_r00*new_r00)))+(new_r10*new_r10));
if(IKabs(x2147)==0){
continue;
}
IkReal x2146=pow(x2147,-0.5);
CheckValue<IkReal> x2148 = IKatan2WithCheck(IkReal(new_r10),IkReal(((1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x2148.valid){
continue;
}
IkReal gconst29=((3.14159265358979)+(((-1.0)*(x2148.value))));
IkReal gconst30=((1.0)*new_r10*x2146);
IkReal gconst31=((-1.0000000008)*new_r00*x2146);
CheckValue<IkReal> x2149 = IKatan2WithCheck(IkReal(new_r10),IkReal(((1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x2149.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+(x2149.value)+j3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[2];
IkReal x2150=x2146;
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst30;
cj3=gconst31;
CheckValue<IkReal> x2151 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x2151.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x2151.value))));
CheckValue<IkReal> x2152 = IKatan2WithCheck(IkReal(new_r10),IkReal(((1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x2152.valid){
continue;
}
IkReal gconst29=((3.14159265358979)+(((-1.0)*(x2152.value))));
IkReal gconst30=((1.0)*new_r10*x2150);
IkReal gconst31=((-1.0000000008)*new_r00*x2150);
IkReal x2153=(((new_r01*new_r10))+(((-1.0)*new_r00*new_r11)));
j5eval[0]=x2153;
j5eval[1]=IKsign(x2153);
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x2154=x2146;
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst30;
cj3=gconst31;
CheckValue<IkReal> x2155 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x2155.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x2155.value))));
CheckValue<IkReal> x2156 = IKatan2WithCheck(IkReal(new_r10),IkReal(((1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x2156.valid){
continue;
}
IkReal gconst29=((3.14159265358979)+(((-1.0)*(x2156.value))));
IkReal gconst30=((1.0)*new_r10*x2154);
IkReal gconst31=((-1.0000000008)*new_r00*x2154);
j5eval[0]=new_r00;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
IkReal x2157=x2146;
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst30;
cj3=gconst31;
CheckValue<IkReal> x2158 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x2158.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x2158.value))));
CheckValue<IkReal> x2159 = IKatan2WithCheck(IkReal(new_r10),IkReal(((1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x2159.valid){
continue;
}
IkReal gconst29=((3.14159265358979)+(((-1.0)*(x2159.value))));
IkReal gconst30=((1.0)*new_r10*x2157);
IkReal gconst31=((-1.0000000008)*new_r00*x2157);
IkReal x2160 = ((((1.0000000016)*(new_r00*new_r00)))+(new_r10*new_r10));
if(IKabs(x2160)==0){
continue;
}
j5eval[0]=((-1.60000013238459e-9)*new_r00*new_r10*(pow(x2160,-0.5)));
j5eval[1]=new_r00;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(new_r00);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
CheckValue<IkReal> x2162 = IKatan2WithCheck(IkReal(new_r10),IkReal(0),IKFAST_ATAN2_MAGTHRESH);
if(!x2162.valid){
continue;
}
IkReal x2161=((1.0)*(x2162.value));
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst30;
cj3=gconst31;
j3=((3.14159265)+(((-1.0)*x2161)));
new_r00=0;
IkReal gconst29=((3.14159265358979)+(((-1.0)*x2161)));
IkReal x2163 = new_r10*new_r10;
if(IKabs(x2163)==0){
continue;
}
IkReal gconst30=((1.0)*new_r10*(pow(x2163,-0.5)));
IkReal gconst31=0;
j5eval[0]=new_r10;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2165=IKPowWithIntegerCheck(gconst30,-1);
if(!x2165.valid){
continue;
}
IkReal x2164=x2165.value;
if( IKabs(((0.9999999992)*new_r11*x2164)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10*x2164)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.9999999992)*new_r11*x2164))+IKsqr(((-1.0)*new_r10*x2164))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((0.9999999992)*new_r11*x2164), ((-1.0)*new_r10*x2164));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2166=IKsin(j5);
IkReal x2167=IKcos(j5);
IkReal x2168=((1.0000000008)*x2166);
IkReal x2169=(gconst30*x2167);
IkReal x2170=(new_r01*x2167);
evalcond[0]=(gconst30*x2166);
evalcond[1]=((-1.0)*new_r10*x2166);
evalcond[2]=(gconst30+((new_r10*x2167)));
evalcond[3]=(x2169+new_r10);
evalcond[4]=(new_r10*x2168);
evalcond[5]=(((new_r11*x2167))+((new_r01*x2166)));
evalcond[6]=((((1.0000000008)*x2169))+new_r01);
evalcond[7]=((((-1.0)*gconst30*x2168))+new_r11);
evalcond[8]=((((-1.0)*new_r11*x2166))+x2170+(((1.0000000008)*gconst30)));
evalcond[9]=((((-1.0000000008)*x2170))+((new_r11*x2168))+(((-1.0)*gconst30)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2171=IKPowWithIntegerCheck(gconst30,-1);
if(!x2171.valid){
continue;
}
CheckValue<IkReal> x2172=IKPowWithIntegerCheck(new_r10,-1);
if(!x2172.valid){
continue;
}
if( IKabs(((0.9999999992)*new_r11*(x2171.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*gconst30*(x2172.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.9999999992)*new_r11*(x2171.value)))+IKsqr(((-1.0)*gconst30*(x2172.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((0.9999999992)*new_r11*(x2171.value)), ((-1.0)*gconst30*(x2172.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2173=IKsin(j5);
IkReal x2174=IKcos(j5);
IkReal x2175=((1.0000000008)*x2173);
IkReal x2176=(gconst30*x2174);
IkReal x2177=(new_r01*x2174);
evalcond[0]=(gconst30*x2173);
evalcond[1]=((-1.0)*new_r10*x2173);
evalcond[2]=(gconst30+((new_r10*x2174)));
evalcond[3]=(x2176+new_r10);
evalcond[4]=(new_r10*x2175);
evalcond[5]=(((new_r11*x2174))+((new_r01*x2173)));
evalcond[6]=((((1.0000000008)*x2176))+new_r01);
evalcond[7]=((((-1.0)*gconst30*x2175))+new_r11);
evalcond[8]=(x2177+(((-1.0)*new_r11*x2173))+(((1.0000000008)*gconst30)));
evalcond[9]=(((new_r11*x2175))+(((-1.0000000008)*x2177))+(((-1.0)*gconst30)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
IkReal x2179 = ((1.0000000016)+(((-1.6e-9)*(new_r10*new_r10))));
if(IKabs(x2179)==0){
continue;
}
IkReal x2178=pow(x2179,-0.5);
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst30;
cj3=gconst31;
CheckValue<IkReal> x2180 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x2180.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x2180.value))));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x2181 = IKatan2WithCheck(IkReal(new_r10),IkReal(((1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x2181.valid){
continue;
}
IkReal gconst29=((3.14159265358979)+(((-1.0)*(x2181.value))));
IkReal gconst30=((1.0)*new_r10*x2178);
IkReal gconst31=((-1.0000000008)*new_r00*x2178);
IkReal x2182=new_r10*new_r10;
CheckValue<IkReal> x2186=IKPowWithIntegerCheck(((-3.90625000625e+17)+(((625000000.0)*x2182))),-1);
if(!x2186.valid){
continue;
}
IkReal x2183=x2186.value;
if((((625000001.0)+(((-1.0)*x2182)))) < -0.00001)
continue;
IkReal x2184=IKsqrt(((625000001.0)+(((-1.0)*x2182))));
IkReal x2185=(x2183*x2184);
j5eval[0]=1.0;
j5eval[1]=1.0;
IkReal x2187 = ((1.0000000016)+(((-1.6e-9)*x2182)));
if(IKabs(x2187)==0){
continue;
}
j5eval[2]=((IKabs(((((-3.90625000625e+17)*x2185))+(((7.81250000625e+17)*x2182*x2185)))))+(IKabs(((50000.00004)*new_r00*new_r10*(pow(x2187,-0.5))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x2189 = ((1.0000000016)+(((-1.6e-9)*(new_r10*new_r10))));
if(IKabs(x2189)==0){
continue;
}
IkReal x2188=pow(x2189,-0.5);
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst30;
cj3=gconst31;
CheckValue<IkReal> x2190 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x2190.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x2190.value))));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x2191 = IKatan2WithCheck(IkReal(new_r10),IkReal(((1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x2191.valid){
continue;
}
IkReal gconst29=((3.14159265358979)+(((-1.0)*(x2191.value))));
IkReal gconst30=((1.0)*new_r10*x2188);
IkReal gconst31=((-1.0000000008)*new_r00*x2188);
IkReal x2192=new_r10*new_r10;
CheckValue<IkReal> x2194=IKPowWithIntegerCheck(((1.0000000016)+(((-1.6e-9)*x2192))),-1);
if(!x2194.valid){
continue;
}
IkReal x2193=x2194.value;
IkReal x2195=((1.0)+(((-1.0)*x2192)));
j5eval[0]=IKsign(((((-625000001.0)*x2193*(x2195*x2195)))+(((625000001.0)*x2193*(x2192*x2192)))));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
IkReal x2197 = ((1.0000000016)+(((-1.6e-9)*(new_r10*new_r10))));
if(IKabs(x2197)==0){
continue;
}
IkReal x2196=pow(x2197,-0.5);
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
sj3=gconst30;
cj3=gconst31;
CheckValue<IkReal> x2198 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x2198.valid){
continue;
}
j3=((3.14159265)+(((-1.0)*(x2198.value))));
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
CheckValue<IkReal> x2199 = IKatan2WithCheck(IkReal(new_r10),IkReal(((1.0000000008)*new_r00)),IKFAST_ATAN2_MAGTHRESH);
if(!x2199.valid){
continue;
}
IkReal gconst29=((3.14159265358979)+(((-1.0)*(x2199.value))));
IkReal gconst30=((1.0)*new_r10*x2196);
IkReal gconst31=((-1.0000000008)*new_r00*x2196);
j5eval[0]=new_r00;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2206=IKPowWithIntegerCheck(new_r00,-1);
if(!x2206.valid){
continue;
}
IkReal x2200=x2206.value;
IkReal x2201=gconst30*gconst30;
IkReal x2202=((25000.0)*new_r10);
IkReal x2203=((25000.0)*x2201);
CheckValue<IkReal> x2207=IKPowWithIntegerCheck(((((-1.0)*gconst30*x2202))+(((25000.00002)*gconst31*new_r00))),-1);
if(!x2207.valid){
continue;
}
IkReal x2204=x2207.value;
IkReal x2205=(new_r10*x2204);
CheckValue<IkReal> x2208=IKPowWithIntegerCheck(((((-25000.0)*gconst30*new_r10))+(((25000.00002)*gconst31*new_r00))),-1);
if(!x2208.valid){
continue;
}
CheckValue<IkReal> x2209=IKPowWithIntegerCheck(((((-25000.0)*gconst30*new_r10))+(((25000.00002)*gconst31*new_r00))),-1);
if(!x2209.valid){
continue;
}
CheckValue<IkReal> x2210=IKPowWithIntegerCheck(x2200,-2);
if(!x2210.valid){
continue;
}
if( IKabs(((((-1.0)*gconst30*x2200))+((new_r00*x2202*(x2208.value)))+(((-1.0)*x2200*x2201*x2202*(x2209.value))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x2204*((x2203+(((-25000.0)*(x2210.value))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*gconst30*x2200))+((new_r00*x2202*(x2208.value)))+(((-1.0)*x2200*x2201*x2202*(x2209.value)))))+IKsqr((x2204*((x2203+(((-25000.0)*(x2210.value)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*gconst30*x2200))+((new_r00*x2202*(x2208.value)))+(((-1.0)*x2200*x2201*x2202*(x2209.value)))), (x2204*((x2203+(((-25000.0)*(x2210.value)))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x2211=IKsin(j5);
IkReal x2212=IKcos(j5);
IkReal x2213=((1.0)*gconst31);
IkReal x2214=((1.0000000008)*x2212);
IkReal x2215=((1.0000000008)*x2211);
evalcond[0]=(gconst30+((new_r00*x2211))+((new_r10*x2212)));
evalcond[1]=(((gconst31*x2214))+((gconst30*x2211))+new_r00);
evalcond[2]=(((gconst30*x2212))+(((-1.0)*gconst31*x2215))+new_r10);
evalcond[3]=(((gconst30*x2214))+(((-1.0)*x2211*x2213)));
evalcond[4]=((((-1.0)*gconst30*x2215))+(((-1.0)*x2212*x2213)));
evalcond[5]=((((-1.0)*new_r10*x2211))+((new_r00*x2212))+(((1.0000000008)*gconst31)));
evalcond[6]=((((-1.0)*x2213))+((new_r10*x2215))+(((-1.0)*new_r00*x2214)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x2216=gconst30*gconst30;
IkReal x2217=gconst31*gconst31;
IkReal x2218=((625000000.0)*x2217);
IkReal x2219=((625000000.5)*gconst31*x2216);
CheckValue<IkReal> x2220=IKPowWithIntegerCheck(IKsign(((((625000001.0)*x2216*(new_r10*new_r10)))+(((-1.0)*x2218*(new_r00*new_r00))))),-1);
if(!x2220.valid){
continue;
}
CheckValue<IkReal> x2221 = IKatan2WithCheck(IkReal((((gconst30*new_r00*x2218))+((new_r10*x2219)))),IkReal(((((-625000001.0)*new_r10*(gconst30*gconst30*gconst30)))+(((-1.0)*new_r00*x2219)))),IKFAST_ATAN2_MAGTHRESH);
if(!x2221.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x2220.value)))+(x2221.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x2222=IKsin(j5);
IkReal x2223=IKcos(j5);
IkReal x2224=((1.0)*gconst31);
IkReal x2225=((1.0000000008)*x2223);
IkReal x2226=((1.0000000008)*x2222);
evalcond[0]=(((new_r00*x2222))+((new_r10*x2223))+gconst30);
evalcond[1]=(((gconst30*x2222))+((gconst31*x2225))+new_r00);
evalcond[2]=(((gconst30*x2223))+(((-1.0)*gconst31*x2226))+new_r10);
evalcond[3]=((((-1.0)*x2222*x2224))+((gconst30*x2225)));
evalcond[4]=((((-1.0)*x2223*x2224))+(((-1.0)*gconst30*x2226)));
evalcond[5]=(((new_r00*x2223))+(((1.0000000008)*gconst31))+(((-1.0)*new_r10*x2222)));
evalcond[6]=((((-1.0)*new_r00*x2225))+((new_r10*x2226))+(((-1.0)*x2224)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x2227=((25000.0)*gconst30);
IkReal x2228=((25000.00002)*gconst31);
CheckValue<IkReal> x2229 = IKatan2WithCheck(IkReal(((((-1.0)*new_r00*x2227))+((new_r10*x2228)))),IkReal(((((-1.0)*new_r00*x2228))+(((-1.0)*new_r10*x2227)))),IKFAST_ATAN2_MAGTHRESH);
if(!x2229.valid){
continue;
}
CheckValue<IkReal> x2230=IKPowWithIntegerCheck(IKsign(((((25000.0)*(new_r10*new_r10)))+(((25000.0)*(new_r00*new_r00))))),-1);
if(!x2230.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x2229.value)+(((1.5707963267949)*(x2230.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[7];
IkReal x2231=IKsin(j5);
IkReal x2232=IKcos(j5);
IkReal x2233=((1.0)*gconst31);
IkReal x2234=((1.0000000008)*x2232);
IkReal x2235=((1.0000000008)*x2231);
evalcond[0]=(((new_r00*x2231))+((new_r10*x2232))+gconst30);
evalcond[1]=(((gconst31*x2234))+((gconst30*x2231))+new_r00);
evalcond[2]=(((gconst30*x2232))+(((-1.0)*gconst31*x2235))+new_r10);
evalcond[3]=(((gconst30*x2234))+(((-1.0)*x2231*x2233)));
evalcond[4]=((((-1.0)*x2232*x2233))+(((-1.0)*gconst30*x2235)));
evalcond[5]=(((new_r00*x2232))+(((1.0000000008)*gconst31))+(((-1.0)*new_r10*x2231)));
evalcond[6]=((((-1.0)*new_r00*x2234))+((new_r10*x2235))+(((-1.0)*x2233)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2237=IKPowWithIntegerCheck(gconst31,-1);
if(!x2237.valid){
continue;
}
IkReal x2236=x2237.value;
if( IKabs((new_r01*x2236)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.9999999992)*new_r00*x2236)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r01*x2236))+IKsqr(((-0.9999999992)*new_r00*x2236))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((new_r01*x2236), ((-0.9999999992)*new_r00*x2236));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2238=IKcos(j5);
IkReal x2239=IKsin(j5);
IkReal x2240=((1.0)*gconst31);
IkReal x2241=((1.0000000008)*gconst31);
IkReal x2242=(new_r00*x2238);
IkReal x2243=(new_r01*x2238);
evalcond[0]=(new_r00*x2239);
evalcond[1]=x2243;
evalcond[2]=((-1.0)*gconst31*x2238);
evalcond[3]=((((-1.0)*x2239*x2240))+new_r01);
evalcond[4]=(((new_r01*x2239))+(((-1.0)*x2240)));
evalcond[5]=((-1.0000000008)*gconst31*x2239);
evalcond[6]=((-1.0000000008)*x2243);
evalcond[7]=(new_r00+((x2238*x2241)));
evalcond[8]=(x2241+x2242);
evalcond[9]=((((-1.0000000008)*x2242))+(((-1.0)*x2240)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2249=IKPowWithIntegerCheck(new_r00,-1);
if(!x2249.valid){
continue;
}
IkReal x2244=x2249.value;
IkReal x2245=((25000.00002)*gconst31);
IkReal x2246=((25000.0)*new_r00);
IkReal x2247=(gconst30*x2244);
CheckValue<IkReal> x2250=IKPowWithIntegerCheck((((new_r10*x2245))+((gconst30*x2246))),-1);
if(!x2250.valid){
continue;
}
IkReal x2248=x2250.value;
if( IKabs(((((-1.0)*x2247))+((new_r10*x2245*x2247*x2248))+(((25000.0)*x2248*(new_r10*new_r10))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x2248*(((((-1.0)*new_r10*x2246))+(((-1.0)*gconst30*x2245)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*x2247))+((new_r10*x2245*x2247*x2248))+(((25000.0)*x2248*(new_r10*new_r10)))))+IKsqr((x2248*(((((-1.0)*new_r10*x2246))+(((-1.0)*gconst30*x2245))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*x2247))+((new_r10*x2245*x2247*x2248))+(((25000.0)*x2248*(new_r10*new_r10)))), (x2248*(((((-1.0)*new_r10*x2246))+(((-1.0)*gconst30*x2245))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2251=IKcos(j5);
IkReal x2252=IKsin(j5);
IkReal x2253=((1.0)*gconst31);
IkReal x2254=((1.0000000008)*gconst31);
IkReal x2255=(gconst30*x2252);
IkReal x2256=(gconst30*x2251);
IkReal x2257=(new_r11*x2252);
IkReal x2258=(new_r01*x2251);
IkReal x2259=(new_r00*x2251);
IkReal x2260=(new_r10*x2252);
evalcond[0]=(((new_r00*x2252))+gconst30+((new_r10*x2251)));
evalcond[1]=((((-1.0)*x2253))+((new_r11*x2251))+((new_r01*x2252)));
evalcond[2]=(x2255+new_r00+((x2251*x2254)));
evalcond[3]=(x2256+(((-1.0)*x2252*x2254))+new_r10);
evalcond[4]=((((-1.0)*x2252*x2253))+new_r01+(((1.0000000008)*x2256)));
evalcond[5]=((((-1.0000000008)*x2255))+new_r11+(((-1.0)*x2251*x2253)));
evalcond[6]=(x2259+x2254+(((-1.0)*x2260)));
evalcond[7]=(x2258+(((-1.0)*x2257))+(((1.0000000008)*gconst30)));
evalcond[8]=((((1.0000000008)*x2260))+(((-1.0000000008)*x2259))+(((-1.0)*x2253)));
evalcond[9]=((((-1.0000000008)*x2258))+(((-1.0)*gconst30))+(((1.0000000008)*x2257)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2267=IKPowWithIntegerCheck(new_r00,-1);
if(!x2267.valid){
continue;
}
IkReal x2261=x2267.value;
IkReal x2262=gconst30*gconst30;
IkReal x2263=((25000.0)*new_r10);
IkReal x2264=((25000.0)*x2262);
CheckValue<IkReal> x2268=IKPowWithIntegerCheck(((((-1.0)*gconst30*x2263))+(((25000.00002)*gconst31*new_r00))),-1);
if(!x2268.valid){
continue;
}
IkReal x2265=x2268.value;
IkReal x2266=(new_r10*x2265);
CheckValue<IkReal> x2269=IKPowWithIntegerCheck(((((-25000.0)*gconst30*new_r10))+(((25000.00002)*gconst31*new_r00))),-1);
if(!x2269.valid){
continue;
}
CheckValue<IkReal> x2270=IKPowWithIntegerCheck(((((-25000.0)*gconst30*new_r10))+(((25000.00002)*gconst31*new_r00))),-1);
if(!x2270.valid){
continue;
}
CheckValue<IkReal> x2271=IKPowWithIntegerCheck(x2261,-2);
if(!x2271.valid){
continue;
}
if( IKabs(((((-1.0)*x2261*x2262*x2263*(x2269.value)))+((new_r00*x2263*(x2270.value)))+(((-1.0)*gconst30*x2261)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x2265*((x2264+(((-25000.0)*(x2271.value))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*x2261*x2262*x2263*(x2269.value)))+((new_r00*x2263*(x2270.value)))+(((-1.0)*gconst30*x2261))))+IKsqr((x2265*((x2264+(((-25000.0)*(x2271.value)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*x2261*x2262*x2263*(x2269.value)))+((new_r00*x2263*(x2270.value)))+(((-1.0)*gconst30*x2261))), (x2265*((x2264+(((-25000.0)*(x2271.value)))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2272=IKcos(j5);
IkReal x2273=IKsin(j5);
IkReal x2274=((1.0)*gconst31);
IkReal x2275=((1.0000000008)*gconst31);
IkReal x2276=(gconst30*x2273);
IkReal x2277=(gconst30*x2272);
IkReal x2278=(new_r11*x2273);
IkReal x2279=(new_r01*x2272);
IkReal x2280=(new_r00*x2272);
IkReal x2281=(new_r10*x2273);
evalcond[0]=(((new_r10*x2272))+((new_r00*x2273))+gconst30);
evalcond[1]=(((new_r11*x2272))+((new_r01*x2273))+(((-1.0)*x2274)));
evalcond[2]=(x2276+((x2272*x2275))+new_r00);
evalcond[3]=(x2277+(((-1.0)*x2273*x2275))+new_r10);
evalcond[4]=((((-1.0)*x2273*x2274))+(((1.0000000008)*x2277))+new_r01);
evalcond[5]=((((-1.0000000008)*x2276))+new_r11+(((-1.0)*x2272*x2274)));
evalcond[6]=(x2280+x2275+(((-1.0)*x2281)));
evalcond[7]=(x2279+(((1.0000000008)*gconst30))+(((-1.0)*x2278)));
evalcond[8]=((((-1.0000000008)*x2280))+(((-1.0)*x2274))+(((1.0000000008)*x2281)));
evalcond[9]=((((1.0000000008)*x2278))+(((-1.0000000008)*x2279))+(((-1.0)*gconst30)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x2282=((1.0)*new_r00);
CheckValue<IkReal> x2283 = IKatan2WithCheck(IkReal((((gconst30*new_r11))+((gconst31*new_r10)))),IkReal(((((-1.0)*gconst30*new_r01))+(((-1.0)*gconst31*x2282)))),IKFAST_ATAN2_MAGTHRESH);
if(!x2283.valid){
continue;
}
CheckValue<IkReal> x2284=IKPowWithIntegerCheck(IKsign((((new_r01*new_r10))+(((-1.0)*new_r11*x2282)))),-1);
if(!x2284.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x2283.value)+(((1.5707963267949)*(x2284.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2285=IKcos(j5);
IkReal x2286=IKsin(j5);
IkReal x2287=((1.0)*gconst31);
IkReal x2288=((1.0000000008)*gconst31);
IkReal x2289=(gconst30*x2286);
IkReal x2290=(gconst30*x2285);
IkReal x2291=(new_r11*x2286);
IkReal x2292=(new_r01*x2285);
IkReal x2293=(new_r00*x2285);
IkReal x2294=(new_r10*x2286);
evalcond[0]=(gconst30+((new_r10*x2285))+((new_r00*x2286)));
evalcond[1]=((((-1.0)*x2287))+((new_r11*x2285))+((new_r01*x2286)));
evalcond[2]=(x2289+new_r00+((x2285*x2288)));
evalcond[3]=(x2290+(((-1.0)*x2286*x2288))+new_r10);
evalcond[4]=((((-1.0)*x2286*x2287))+new_r01+(((1.0000000008)*x2290)));
evalcond[5]=((((-1.0000000008)*x2289))+(((-1.0)*x2285*x2287))+new_r11);
evalcond[6]=(x2288+x2293+(((-1.0)*x2294)));
evalcond[7]=(x2292+(((-1.0)*x2291))+(((1.0000000008)*gconst30)));
evalcond[8]=((((-1.0000000008)*x2293))+(((-1.0)*x2287))+(((1.0000000008)*x2294)));
evalcond[9]=((((-1.0000000008)*x2292))+(((-1.0)*gconst30))+(((1.0000000008)*x2291)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
j5eval[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
j5eval[0]=1.0;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j5]

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
CheckValue<IkReal> x2296 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r00)),IkReal(((1.0000000008)*new_r10)),IKFAST_ATAN2_MAGTHRESH);
if(!x2296.valid){
continue;
}
IkReal x2295=x2296.value;
j5array[0]=((-1.0)*x2295);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
j5array[1]=((3.14159265358979)+(((-1.0)*x2295)));
sj5array[1]=IKsin(j5array[1]);
cj5array[1]=IKcos(j5array[1]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
if( j5array[1] > IKPI )
{
    j5array[1]-=IK2PI;
}
else if( j5array[1] < -IKPI )
{    j5array[1]+=IK2PI;
}
j5valid[1] = true;
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[2];
IkReal x2297=IKcos(j5);
IkReal x2298=IKsin(j5);
evalcond[0]=(((new_r00*x2298))+((new_r10*x2297)));
evalcond[1]=(((new_r00*x2297))+(((-1.0)*new_r10*x2298)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
CheckValue<IkReal> x2300 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x2300.valid){
continue;
}
IkReal x2299=x2300.value;
j5array[0]=((-1.0)*x2299);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
j5array[1]=((3.14159265358979)+(((-1.0)*x2299)));
sj5array[1]=IKsin(j5array[1]);
cj5array[1]=IKcos(j5array[1]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
if( j5array[1] > IKPI )
{
    j5array[1]-=IK2PI;
}
else if( j5array[1] < -IKPI )
{    j5array[1]+=IK2PI;
}
j5valid[1] = true;
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[2];
IkReal x2301=IKsin(j5);
IkReal x2302=IKcos(j5);
IkReal x2303=(new_r00*x2302);
IkReal x2304=(new_r10*x2301);
evalcond[0]=((((-1.0)*x2304))+x2303);
evalcond[1]=((((1.0000000008)*x2304))+(((-1.0000000008)*x2303)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
new_r11=0;
new_r10=0;
new_r22=0;
new_r02=0;
j5eval[0]=new_r00;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
new_r11=0;
new_r10=0;
new_r22=0;
new_r02=0;
j5eval[0]=new_r00;
j5eval[1]=new_r01;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j5]

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2305=IKPowWithIntegerCheck(new_r00,-1);
if(!x2305.valid){
continue;
}
CheckValue<IkReal> x2306=IKPowWithIntegerCheck(new_r01,-1);
if(!x2306.valid){
continue;
}
if( IKabs(((-1.0)*sj3*(x2305.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0000000008)*sj3*(x2306.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*sj3*(x2305.value)))+IKsqr(((-1.0000000008)*sj3*(x2306.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0)*sj3*(x2305.value)), ((-1.0000000008)*sj3*(x2306.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2307=IKsin(j5);
IkReal x2308=IKcos(j5);
IkReal x2309=((1.0)*cj3);
IkReal x2310=((1.0000000008)*cj3);
IkReal x2311=((1.0000000008)*sj3);
IkReal x2312=(new_r00*x2308);
IkReal x2313=(sj3*x2308);
IkReal x2314=(new_r01*x2308);
evalcond[0]=(((new_r00*x2307))+sj3);
evalcond[1]=((((-1.0)*x2309))+((new_r01*x2307)));
evalcond[2]=(x2312+x2310);
evalcond[3]=(x2314+x2311);
evalcond[4]=((((-1.0000000008)*x2312))+(((-1.0)*x2309)));
evalcond[5]=((((-1.0)*sj3))+(((-1.0000000008)*x2314)));
evalcond[6]=(x2313+(((-1.0)*x2307*x2310)));
evalcond[7]=(((x2308*x2310))+((sj3*x2307))+new_r00);
evalcond[8]=((((-1.0)*x2308*x2309))+(((-1.0)*x2307*x2311)));
evalcond[9]=(((x2308*x2311))+new_r01+(((-1.0)*x2307*x2309)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2316=IKPowWithIntegerCheck(new_r00,-1);
if(!x2316.valid){
continue;
}
IkReal x2315=x2316.value;
if( IKabs(((-1.0)*sj3*x2315)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0000000008)*cj3*x2315)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*sj3*x2315))+IKsqr(((-1.0000000008)*cj3*x2315))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0)*sj3*x2315), ((-1.0000000008)*cj3*x2315));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2317=IKsin(j5);
IkReal x2318=IKcos(j5);
IkReal x2319=((1.0)*cj3);
IkReal x2320=((1.0000000008)*cj3);
IkReal x2321=((1.0000000008)*sj3);
IkReal x2322=(new_r00*x2318);
IkReal x2323=(sj3*x2318);
IkReal x2324=(new_r01*x2318);
evalcond[0]=(sj3+((new_r00*x2317)));
evalcond[1]=(((new_r01*x2317))+(((-1.0)*x2319)));
evalcond[2]=(x2322+x2320);
evalcond[3]=(x2321+x2324);
evalcond[4]=((((-1.0000000008)*x2322))+(((-1.0)*x2319)));
evalcond[5]=((((-1.0)*sj3))+(((-1.0000000008)*x2324)));
evalcond[6]=(x2323+(((-1.0)*x2317*x2320)));
evalcond[7]=(((sj3*x2317))+((x2318*x2320))+new_r00);
evalcond[8]=((((-1.0)*x2318*x2319))+(((-1.0)*x2317*x2321)));
evalcond[9]=(((x2318*x2321))+(((-1.0)*x2317*x2319))+new_r01);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r00))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
new_r00=0;
new_r01=0;
new_r12=0;
new_r22=0;
j5eval[0]=new_r10;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
new_r00=0;
new_r01=0;
new_r12=0;
new_r22=0;
j5eval[0]=new_r11;
j5eval[1]=new_r10;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j5]

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2325=IKPowWithIntegerCheck(new_r11,-1);
if(!x2325.valid){
continue;
}
CheckValue<IkReal> x2326=IKPowWithIntegerCheck(new_r10,-1);
if(!x2326.valid){
continue;
}
if( IKabs(((1.0000000008)*sj3*(x2325.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*sj3*(x2326.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((1.0000000008)*sj3*(x2325.value)))+IKsqr(((-1.0)*sj3*(x2326.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((1.0000000008)*sj3*(x2325.value)), ((-1.0)*sj3*(x2326.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2327=IKcos(j5);
IkReal x2328=IKsin(j5);
IkReal x2329=((1.0)*cj3);
IkReal x2330=((1.0000000008)*cj3);
IkReal x2331=((1.0000000008)*sj3);
IkReal x2332=(sj3*x2327);
IkReal x2333=(new_r10*x2328);
IkReal x2334=(new_r11*x2328);
evalcond[0]=(sj3+((new_r10*x2327)));
evalcond[1]=(((new_r11*x2327))+(((-1.0)*x2329)));
evalcond[2]=(x2330+(((-1.0)*x2333)));
evalcond[3]=(x2331+(((-1.0)*x2334)));
evalcond[4]=((((1.0000000008)*x2333))+(((-1.0)*x2329)));
evalcond[5]=((((-1.0)*sj3))+(((1.0000000008)*x2334)));
evalcond[6]=(((sj3*x2328))+((x2327*x2330)));
evalcond[7]=((((-1.0)*x2328*x2330))+x2332+new_r10);
evalcond[8]=((((-1.0)*x2328*x2329))+((x2327*x2331)));
evalcond[9]=((((-1.0)*x2328*x2331))+(((-1.0)*x2327*x2329))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2336=IKPowWithIntegerCheck(new_r10,-1);
if(!x2336.valid){
continue;
}
IkReal x2335=x2336.value;
if( IKabs(((1.0000000008)*cj3*x2335)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*sj3*x2335)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((1.0000000008)*cj3*x2335))+IKsqr(((-1.0)*sj3*x2335))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((1.0000000008)*cj3*x2335), ((-1.0)*sj3*x2335));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2337=IKcos(j5);
IkReal x2338=IKsin(j5);
IkReal x2339=((1.0)*cj3);
IkReal x2340=((1.0000000008)*cj3);
IkReal x2341=((1.0000000008)*sj3);
IkReal x2342=(sj3*x2337);
IkReal x2343=(new_r10*x2338);
IkReal x2344=(new_r11*x2338);
evalcond[0]=(sj3+((new_r10*x2337)));
evalcond[1]=((((-1.0)*x2339))+((new_r11*x2337)));
evalcond[2]=(x2340+(((-1.0)*x2343)));
evalcond[3]=(x2341+(((-1.0)*x2344)));
evalcond[4]=((((-1.0)*x2339))+(((1.0000000008)*x2343)));
evalcond[5]=((((-1.0)*sj3))+(((1.0000000008)*x2344)));
evalcond[6]=(((sj3*x2338))+((x2337*x2340)));
evalcond[7]=(x2342+new_r10+(((-1.0)*x2338*x2340)));
evalcond[8]=((((-1.0)*x2338*x2339))+((x2337*x2341)));
evalcond[9]=((((-1.0)*x2337*x2339))+new_r11+(((-1.0)*x2338*x2341)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
new_r00=0;
new_r10=0;
new_r21=0;
new_r22=0;
j5eval[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
sj4=-4.0e-5;
cj4=-1.0;
j4=3.14163265;
new_r00=0;
new_r10=0;
new_r21=0;
new_r22=0;
j5eval[0]=1.0;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j5]

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
CheckValue<IkReal> x2346 = IKatan2WithCheck(IkReal(((-1.0000000008)*new_r01)),IkReal(((1.0000000008)*new_r11)),IKFAST_ATAN2_MAGTHRESH);
if(!x2346.valid){
continue;
}
IkReal x2345=x2346.value;
j5array[0]=((-1.0)*x2345);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
j5array[1]=((3.14159265358979)+(((-1.0)*x2345)));
sj5array[1]=IKsin(j5array[1]);
cj5array[1]=IKcos(j5array[1]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
if( j5array[1] > IKPI )
{
    j5array[1]-=IK2PI;
}
else if( j5array[1] < -IKPI )
{    j5array[1]+=IK2PI;
}
j5valid[1] = true;
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[2];
IkReal x2347=IKcos(j5);
IkReal x2348=IKsin(j5);
evalcond[0]=(((new_r11*x2347))+((new_r01*x2348)));
evalcond[1]=((((-1.0)*new_r11*x2348))+((new_r01*x2347)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
CheckValue<IkReal> x2350 = IKatan2WithCheck(IkReal(new_r11),IkReal(new_r01),IKFAST_ATAN2_MAGTHRESH);
if(!x2350.valid){
continue;
}
IkReal x2349=x2350.value;
j5array[0]=((-1.0)*x2349);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
j5array[1]=((3.14159265358979)+(((-1.0)*x2349)));
sj5array[1]=IKsin(j5array[1]);
cj5array[1]=IKcos(j5array[1]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
if( j5array[1] > IKPI )
{
    j5array[1]-=IK2PI;
}
else if( j5array[1] < -IKPI )
{    j5array[1]+=IK2PI;
}
j5valid[1] = true;
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[2];
IkReal x2351=IKsin(j5);
IkReal x2352=IKcos(j5);
IkReal x2353=(new_r11*x2351);
IkReal x2354=(new_r01*x2352);
evalcond[0]=(x2354+(((-1.0)*x2353)));
evalcond[1]=((((-1.0000000008)*x2354))+(((1.0000000008)*x2353)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2360=IKPowWithIntegerCheck(new_r00,-1);
if(!x2360.valid){
continue;
}
IkReal x2355=x2360.value;
IkReal x2356=(sj3*x2355);
IkReal x2357=((25000.0)*new_r00);
IkReal x2358=((25000.00002)*cj3*new_r10);
CheckValue<IkReal> x2361=IKPowWithIntegerCheck((x2358+((sj3*x2357))),-1);
if(!x2361.valid){
continue;
}
IkReal x2359=x2361.value;
if( IKabs((((x2356*x2358*x2359))+(((25000.0)*x2359*(new_r10*new_r10)))+(((-1.0)*x2356)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x2359*(((((-1.0)*new_r10*x2357))+(((-25000.00002)*cj3*sj3)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((x2356*x2358*x2359))+(((25000.0)*x2359*(new_r10*new_r10)))+(((-1.0)*x2356))))+IKsqr((x2359*(((((-1.0)*new_r10*x2357))+(((-25000.00002)*cj3*sj3))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((((x2356*x2358*x2359))+(((25000.0)*x2359*(new_r10*new_r10)))+(((-1.0)*x2356))), (x2359*(((((-1.0)*new_r10*x2357))+(((-25000.00002)*cj3*sj3))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2362=IKcos(j5);
IkReal x2363=IKsin(j5);
IkReal x2364=((1.0)*cj3);
IkReal x2365=((1.0000000008)*cj3);
IkReal x2366=(cj3*x2362);
IkReal x2367=(new_r11*x2363);
IkReal x2368=(sj3*x2363);
IkReal x2369=(new_r01*x2362);
IkReal x2370=(new_r00*x2362);
IkReal x2371=(sj3*x2362);
IkReal x2372=(new_r10*x2363);
evalcond[0]=(((new_r00*x2363))+sj3+((new_r10*x2362)));
evalcond[1]=(((new_r01*x2363))+(((-1.0)*x2364))+((new_r11*x2362)));
evalcond[2]=(x2368+((x2362*x2365))+new_r00);
evalcond[3]=(x2371+new_r10+(((-1.0)*x2363*x2365)));
evalcond[4]=((((1.0000000008)*x2371))+new_r01+(((-1.0)*x2363*x2364)));
evalcond[5]=((((-1.0000000008)*x2368))+new_r11+(((-1.0)*x2362*x2364)));
evalcond[6]=(x2370+x2365+(((-1.0)*x2372)));
evalcond[7]=(x2369+(((-1.0)*x2367))+(((1.0000000008)*sj3)));
evalcond[8]=((((-1.0000000008)*x2370))+(((1.0000000008)*x2372))+(((-1.0)*x2364)));
evalcond[9]=((((-1.0000000008)*x2369))+(((-1.0)*sj3))+(((1.0000000008)*x2367)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2379=IKPowWithIntegerCheck(new_r00,-1);
if(!x2379.valid){
continue;
}
IkReal x2373=x2379.value;
IkReal x2374=((25000.0)*cj3);
IkReal x2375=((25000.0)*new_r01);
IkReal x2376=(sj3*x2373);
CheckValue<IkReal> x2380=IKPowWithIntegerCheck((((new_r10*x2374))+(((25000.00002)*new_r00*sj3))),-1);
if(!x2380.valid){
continue;
}
IkReal x2377=x2380.value;
IkReal x2378=(new_r10*x2377);
if( IKabs((((x2375*x2378))+((x2374*x2376*x2378))+(((-1.0)*x2376)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x2377*(((((-1.0)*new_r00*x2375))+(((-1.0)*sj3*x2374)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((x2375*x2378))+((x2374*x2376*x2378))+(((-1.0)*x2376))))+IKsqr((x2377*(((((-1.0)*new_r00*x2375))+(((-1.0)*sj3*x2374))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((((x2375*x2378))+((x2374*x2376*x2378))+(((-1.0)*x2376))), (x2377*(((((-1.0)*new_r00*x2375))+(((-1.0)*sj3*x2374))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2381=IKcos(j5);
IkReal x2382=IKsin(j5);
IkReal x2383=((1.0)*cj3);
IkReal x2384=((1.0000000008)*cj3);
IkReal x2385=(cj3*x2381);
IkReal x2386=(new_r11*x2382);
IkReal x2387=(sj3*x2382);
IkReal x2388=(new_r01*x2381);
IkReal x2389=(new_r00*x2381);
IkReal x2390=(sj3*x2381);
IkReal x2391=(new_r10*x2382);
evalcond[0]=(((new_r10*x2381))+sj3+((new_r00*x2382)));
evalcond[1]=(((new_r11*x2381))+((new_r01*x2382))+(((-1.0)*x2383)));
evalcond[2]=(((x2381*x2384))+x2387+new_r00);
evalcond[3]=(x2390+(((-1.0)*x2382*x2384))+new_r10);
evalcond[4]=((((-1.0)*x2382*x2383))+(((1.0000000008)*x2390))+new_r01);
evalcond[5]=((((-1.0)*x2381*x2383))+(((-1.0000000008)*x2387))+new_r11);
evalcond[6]=(x2384+x2389+(((-1.0)*x2391)));
evalcond[7]=(x2388+(((-1.0)*x2386))+(((1.0000000008)*sj3)));
evalcond[8]=((((-1.0)*x2383))+(((1.0000000008)*x2391))+(((-1.0000000008)*x2389)));
evalcond[9]=((((-1.0)*sj3))+(((1.0000000008)*x2386))+(((-1.0000000008)*x2388)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x2392=((1.0)*new_r00);
CheckValue<IkReal> x2393 = IKatan2WithCheck(IkReal((((new_r11*sj3))+((cj3*new_r10)))),IkReal(((((-1.0)*new_r01*sj3))+(((-1.0)*cj3*x2392)))),IKFAST_ATAN2_MAGTHRESH);
if(!x2393.valid){
continue;
}
CheckValue<IkReal> x2394=IKPowWithIntegerCheck(IKsign(((((-1.0)*new_r11*x2392))+((new_r01*new_r10)))),-1);
if(!x2394.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x2393.value)+(((1.5707963267949)*(x2394.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2395=IKcos(j5);
IkReal x2396=IKsin(j5);
IkReal x2397=((1.0)*cj3);
IkReal x2398=((1.0000000008)*cj3);
IkReal x2399=(cj3*x2395);
IkReal x2400=(new_r11*x2396);
IkReal x2401=(sj3*x2396);
IkReal x2402=(new_r01*x2395);
IkReal x2403=(new_r00*x2395);
IkReal x2404=(sj3*x2395);
IkReal x2405=(new_r10*x2396);
evalcond[0]=(((new_r10*x2395))+sj3+((new_r00*x2396)));
evalcond[1]=(((new_r11*x2395))+((new_r01*x2396))+(((-1.0)*x2397)));
evalcond[2]=(x2401+new_r00+((x2395*x2398)));
evalcond[3]=(x2404+(((-1.0)*x2396*x2398))+new_r10);
evalcond[4]=((((-1.0)*x2396*x2397))+(((1.0000000008)*x2404))+new_r01);
evalcond[5]=((((-1.0000000008)*x2401))+new_r11+(((-1.0)*x2395*x2397)));
evalcond[6]=((((-1.0)*x2405))+x2403+x2398);
evalcond[7]=((((-1.0)*x2400))+x2402+(((1.0000000008)*sj3)));
evalcond[8]=((((-1.0000000008)*x2403))+(((1.0000000008)*x2405))+(((-1.0)*x2397)));
evalcond[9]=((((-1.0)*sj3))+(((-1.0000000008)*x2402))+(((1.0000000008)*x2400)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j3)))), 6.28318530717959)));
evalcond[1]=new_r20;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r00))+IKsqr(((-1.0)*new_r10))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0)*new_r00), ((-1.0)*new_r10));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[18];
IkReal x2406=IKsin(j5);
IkReal x2407=IKcos(j5);
IkReal x2408=((0.9999999992)*cj4);
IkReal x2409=((4.0e-5)*new_r22);
IkReal x2410=((1.0000000008)*sj4);
IkReal x2411=((3.9999999968e-5)*sj4);
IkReal x2412=((3.9999999968e-5)*cj4);
IkReal x2413=((0.9999999992)*sj4);
IkReal x2414=((1.0)*new_r22);
IkReal x2415=(new_r22*x2413);
IkReal x2416=(new_r22*x2412);
IkReal x2417=(new_r22*x2411);
IkReal x2418=(new_r12*x2406);
IkReal x2419=(new_r02*x2407);
IkReal x2420=(new_r01*x2407);
IkReal x2421=(new_r00*x2407);
IkReal x2422=(new_r11*x2406);
IkReal x2423=(new_r10*x2406);
evalcond[0]=(x2406+new_r00);
evalcond[1]=(x2407+new_r10);
evalcond[2]=(((new_r22*x2406))+new_r11);
evalcond[3]=((((-1.0)*x2407*x2414))+new_r01);
evalcond[4]=(((new_r12*x2407))+((new_r02*x2406)));
evalcond[5]=(((new_r01*x2406))+((new_r11*x2407)));
evalcond[6]=((1.0)+((new_r00*x2406))+((new_r10*x2407)));
evalcond[7]=(x2421+(((-1.0)*x2423)));
evalcond[8]=(((new_r22*x2421))+(((-1.0)*x2414*x2423)));
evalcond[9]=(x2420+(((-1.0)*x2414))+(((-1.0)*x2422)));
evalcond[10]=((((-1.0)*x2407*x2409))+((x2407*x2410))+new_r02);
evalcond[11]=((((-1.0)*x2406*x2410))+new_r12+((x2406*x2409)));
evalcond[12]=(x2410+x2419+(((-1.0)*x2409))+(((-1.0)*x2418)));
evalcond[13]=((((-1.0)*x2409*x2423))+(((-1.0)*x2410*x2421))+((x2409*x2421))+((x2410*x2423)));
evalcond[14]=((-1.0)+(((-4.0e-5)*cj4*sj4))+(((1.59999999872e-9)*cj4*new_r22))+(sj4*sj4)+((new_r22*x2420))+(((-1.0)*x2417))+(((-1.0)*x2414*x2422)));
evalcond[15]=((((-1.0)*x2409*x2422))+x2415+(((-1.0)*x2410*x2420))+((x2409*x2420))+(((-1.0)*x2416))+((x2410*x2422)));
evalcond[16]=(x2415+(((-1.0)*x2408*x2418))+((x2408*x2419))+(((-1.0)*x2411*x2418))+(((-1.0)*x2416))+((x2411*x2419)));
evalcond[17]=((-1.0)+x2417+((new_r22*x2408))+((x2413*x2418))+(((-1.0)*x2412*x2418))+(((-1.0)*x2413*x2419))+((x2412*x2419)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j3)))), 6.28318530717959)));
evalcond[1]=new_r20;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r00)+IKsqr(new_r10)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r00, new_r10);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[18];
IkReal x2424=IKcos(j5);
IkReal x2425=IKsin(j5);
IkReal x2426=((0.9999999992)*cj4);
IkReal x2427=((3.9999999968e-5)*cj4);
IkReal x2428=((3.9999999968e-5)*sj4);
IkReal x2429=((0.9999999992)*sj4);
IkReal x2430=(new_r12*x2425);
IkReal x2431=(new_r02*x2424);
IkReal x2432=(new_r01*x2424);
IkReal x2433=(new_r11*x2425);
IkReal x2434=(new_r10*x2425);
IkReal x2435=(new_r00*x2424);
evalcond[0]=((((-1.0)*x2425))+new_r00);
evalcond[1]=((((-1.0)*x2424))+new_r10);
evalcond[2]=(((new_r12*x2424))+((new_r02*x2425)));
evalcond[3]=(((new_r11*x2424))+((new_r01*x2425)));
evalcond[4]=((-1.0)+((new_r10*x2424))+((new_r00*x2425)));
evalcond[5]=((((-1.0)*x2434))+x2435);
evalcond[6]=((((-1.0)*x2424*x2427))+((x2424*x2429))+new_r02);
evalcond[7]=((((-1.0)*x2425*x2429))+((x2425*x2427))+new_r12);
evalcond[8]=(((x2424*x2426))+((x2424*x2428))+new_r01);
evalcond[9]=((((-1.0)*x2425*x2428))+(((-1.0)*x2425*x2426))+new_r11);
evalcond[10]=((((-1.0)*x2430))+x2431+x2429+(((-1.0)*x2427)));
evalcond[11]=((((-1.0)*x2433))+x2432+x2428+x2426);
evalcond[12]=(((x2429*x2434))+(((-1.0)*x2427*x2434))+(((-1.0)*x2429*x2435))+((x2427*x2435)));
evalcond[13]=(((x2428*x2435))+(((-1.0)*x2426*x2434))+(((-1.0)*x2428*x2434))+((x2426*x2435)));
evalcond[14]=(((x2429*x2433))+((new_r21*x2426))+((new_r21*x2428))+(((-1.0)*x2427*x2433))+(((-1.0)*x2429*x2432))+((x2427*x2432)));
evalcond[15]=(((x2428*x2431))+(((-1.0)*x2426*x2430))+((new_r22*x2429))+(((-1.0)*x2428*x2430))+((x2426*x2431))+(((-1.0)*new_r22*x2427)));
evalcond[16]=((-1.0)+((x2429*x2430))+(((-1.0)*x2427*x2430))+((new_r22*x2426))+((new_r22*x2428))+(((-1.0)*x2429*x2431))+((x2427*x2431)));
evalcond[17]=((1.0)+((x2428*x2432))+((new_r21*x2429))+(((-1.0)*x2426*x2433))+(((-1.0)*new_r21*x2427))+(((-1.0)*x2428*x2433))+((x2426*x2432)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j3))), 6.28318530717959)));
evalcond[1]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r01)+IKsqr(new_r11)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r01, new_r11);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[18];
IkReal x2436=IKsin(j5);
IkReal x2437=IKcos(j5);
IkReal x2438=((0.9999999992)*cj4);
IkReal x2439=((0.9999999992)*sj4);
IkReal x2440=((4.0e-5)*new_r22);
IkReal x2441=((3.9999999968e-5)*sj4);
IkReal x2442=((3.9999999968e-5)*cj4);
IkReal x2443=((1.0000000008)*sj4);
IkReal x2444=((1.0)*new_r22);
IkReal x2445=(new_r12*x2436);
IkReal x2446=(new_r02*x2437);
IkReal x2447=(new_r01*x2437);
IkReal x2448=(new_r11*x2436);
IkReal x2449=(new_r00*x2437);
IkReal x2450=(new_r10*x2436);
evalcond[0]=(((new_r22*x2436))+new_r10);
evalcond[1]=((((-1.0)*x2436))+new_r01);
evalcond[2]=((((-1.0)*x2437))+new_r11);
evalcond[3]=((((-1.0)*x2437*x2444))+new_r00);
evalcond[4]=(((new_r12*x2437))+((new_r02*x2436)));
evalcond[5]=(((new_r00*x2436))+((new_r10*x2437)));
evalcond[6]=((-1.0)+((new_r01*x2436))+((new_r11*x2437)));
evalcond[7]=(x2447+(((-1.0)*x2448)));
evalcond[8]=((((-1.0)*x2444*x2448))+((new_r22*x2447)));
evalcond[9]=(x2449+(((-1.0)*x2450))+(((-1.0)*x2444)));
evalcond[10]=((((-1.0)*x2437*x2440))+((x2437*x2443))+new_r02);
evalcond[11]=((((-1.0)*x2436*x2443))+new_r12+((x2436*x2440)));
evalcond[12]=(x2443+x2446+(((-1.0)*x2445))+(((-1.0)*x2440)));
evalcond[13]=((((-1.0)*x2443*x2447))+((x2443*x2448))+((x2440*x2447))+(((-1.0)*x2440*x2448)));
evalcond[14]=((((-1.0)*x2442*x2450))+((x2442*x2449))+((new_r20*x2441))+(((-1.0)*x2439*x2449))+((x2439*x2450))+((new_r20*x2438)));
evalcond[15]=(((new_r22*x2439))+(((-1.0)*x2441*x2445))+(((-1.0)*x2438*x2445))+((x2441*x2446))+(((-1.0)*new_r22*x2442))+((x2438*x2446)));
evalcond[16]=((-1.0)+((new_r22*x2438))+((x2442*x2446))+(((-1.0)*x2439*x2446))+((new_r22*x2441))+((x2439*x2445))+(((-1.0)*x2442*x2445)));
evalcond[17]=((-1.0)+(((-1.0)*new_r20*x2442))+(((-1.0)*x2441*x2450))+(((-1.0)*x2438*x2450))+((x2441*x2449))+((x2438*x2449))+((new_r20*x2439)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j3)))), 6.28318530717959)));
evalcond[1]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r01))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0)*new_r01), ((-1.0)*new_r11));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[18];
IkReal x2451=IKcos(j5);
IkReal x2452=IKsin(j5);
IkReal x2453=((0.9999999992)*cj4);
IkReal x2454=((0.9999999992)*sj4);
IkReal x2455=((3.9999999968e-5)*cj4);
IkReal x2456=((3.9999999968e-5)*sj4);
IkReal x2457=((1.0)*new_r22);
IkReal x2458=(new_r12*x2452);
IkReal x2459=(new_r02*x2451);
IkReal x2460=(new_r01*x2451);
IkReal x2461=(new_r11*x2452);
IkReal x2462=(new_r00*x2451);
IkReal x2463=(new_r10*x2452);
evalcond[0]=(x2452+new_r01);
evalcond[1]=(x2451+new_r11);
evalcond[2]=(((new_r22*x2451))+new_r00);
evalcond[3]=((((-1.0)*x2452*x2457))+new_r10);
evalcond[4]=(((new_r12*x2451))+((new_r02*x2452)));
evalcond[5]=(((new_r10*x2451))+((new_r00*x2452)));
evalcond[6]=((1.0)+((new_r11*x2451))+((new_r01*x2452)));
evalcond[7]=(x2460+(((-1.0)*x2461)));
evalcond[8]=(x2462+(((-1.0)*x2463))+new_r22);
evalcond[9]=((((-1.0)*x2457*x2461))+((new_r22*x2460)));
evalcond[10]=((((-1.0)*x2451*x2455))+((x2451*x2454))+new_r02);
evalcond[11]=((((-1.0)*x2452*x2454))+((x2452*x2455))+new_r12);
evalcond[12]=(x2459+(((25000.0)*new_r22))+(((-625000001.0)*new_r20))+(((-625000000.5)*sj4))+(((-1.0)*x2458)));
evalcond[13]=((((-1.0)*x2454*x2460))+(((-1.0)*x2455*x2461))+((x2454*x2461))+((x2455*x2460)));
evalcond[14]=((((-1.0)*x2454*x2462))+((new_r20*x2456))+((new_r20*x2453))+(((-1.0)*x2455*x2463))+((x2454*x2463))+((x2455*x2462)));
evalcond[15]=((((-1.0)*x2453*x2458))+((x2453*x2459))+(((-1.0)*x2456*x2458))+((x2456*x2459))+((new_r22*x2454))+(((-1.0)*new_r22*x2455)));
evalcond[16]=((-1.0)+(((-1.0)*x2454*x2459))+((x2454*x2458))+((new_r22*x2453))+((new_r22*x2456))+((x2455*x2459))+(((-1.0)*x2455*x2458)));
evalcond[17]=((1.0)+((new_r20*x2454))+(((-1.0)*new_r20*x2455))+(((-1.0)*x2456*x2463))+((x2453*x2462))+((x2456*x2462))+(((-1.0)*x2453*x2463)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
new_r00=0;
new_r10=0;
new_r21=0;
new_r22=0;
j5eval[0]=sj4;
j5eval[1]=IKsign(sj4);
j5eval[2]=((1.0)+(new_r12*new_r12)+(((-1.0)*(new_r01*new_r01))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
new_r00=0;
new_r10=0;
new_r21=0;
new_r22=0;
j5eval[0]=new_r01;
j5eval[1]=sj4;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
new_r00=0;
new_r10=0;
new_r21=0;
new_r22=0;
j5eval[0]=sj4;
j5eval[1]=new_r11;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j4))), 6.28318530717959)));
evalcond[1]=new_r02;
evalcond[2]=new_r12;
evalcond[3]=new_r01;
evalcond[4]=new_r11;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
j5array[0]=0;
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j4)))), 6.28318530717959)));
evalcond[1]=new_r02;
evalcond[2]=new_r12;
evalcond[3]=new_r01;
evalcond[4]=new_r11;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
j5array[0]=0;
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2466=IKPowWithIntegerCheck(sj4,-1);
if(!x2466.valid){
continue;
}
IkReal x2464=x2466.value;
IkReal x2465=(new_r12*x2464);
CheckValue<IkReal> x2467=IKPowWithIntegerCheck(new_r11,-1);
if(!x2467.valid){
continue;
}
if( IKabs(((0.9999999992)*x2465)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.9999999992)*new_r01*x2465*(x2467.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.9999999992)*x2465))+IKsqr(((-0.9999999992)*new_r01*x2465*(x2467.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((0.9999999992)*x2465), ((-0.9999999992)*new_r01*x2465*(x2467.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2468=IKcos(j5);
IkReal x2469=IKsin(j5);
IkReal x2470=((0.9999999992)*cj4);
IkReal x2471=((3.9999999968e-5)*sj4);
IkReal x2472=((1.0000000008)*sj4);
IkReal x2473=(new_r12*x2469);
IkReal x2474=(new_r02*x2468);
IkReal x2475=(new_r11*x2469);
IkReal x2476=(new_r01*x2468);
evalcond[0]=(((new_r02*x2469))+((new_r12*x2468)));
evalcond[1]=(((new_r01*x2469))+((new_r11*x2468)));
evalcond[2]=(((x2468*x2472))+new_r02);
evalcond[3]=((((-1.0)*x2469*x2472))+new_r12);
evalcond[4]=(x2476+(((-1.0)*x2475)));
evalcond[5]=(x2474+x2472+(((-1.0)*x2473)));
evalcond[6]=((((-1.0)*x2472*x2476))+((x2472*x2475)));
evalcond[7]=((-1.0)+(((-1.0)*x2472*x2474))+((x2472*x2473)));
evalcond[8]=(((x2471*x2474))+(((-1.0)*x2470*x2473))+(((-1.0)*x2471*x2473))+((x2470*x2474)));
evalcond[9]=(((x2471*x2476))+(((-1.0)*x2470*x2475))+(((-1.0)*x2471*x2475))+((x2470*x2476)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2479=IKPowWithIntegerCheck(sj4,-1);
if(!x2479.valid){
continue;
}
IkReal x2477=x2479.value;
IkReal x2478=(new_r02*x2477);
CheckValue<IkReal> x2480=IKPowWithIntegerCheck(new_r01,-1);
if(!x2480.valid){
continue;
}
if( IKabs(((0.9999999992)*new_r11*x2478*(x2480.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.9999999992)*x2478)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.9999999992)*new_r11*x2478*(x2480.value)))+IKsqr(((-0.9999999992)*x2478))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((0.9999999992)*new_r11*x2478*(x2480.value)), ((-0.9999999992)*x2478));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2481=IKcos(j5);
IkReal x2482=IKsin(j5);
IkReal x2483=((0.9999999992)*cj4);
IkReal x2484=((3.9999999968e-5)*sj4);
IkReal x2485=((1.0000000008)*sj4);
IkReal x2486=(new_r12*x2482);
IkReal x2487=(new_r02*x2481);
IkReal x2488=(new_r11*x2482);
IkReal x2489=(new_r01*x2481);
evalcond[0]=(((new_r02*x2482))+((new_r12*x2481)));
evalcond[1]=(((new_r01*x2482))+((new_r11*x2481)));
evalcond[2]=(((x2481*x2485))+new_r02);
evalcond[3]=((((-1.0)*x2482*x2485))+new_r12);
evalcond[4]=(x2489+(((-1.0)*x2488)));
evalcond[5]=(x2487+x2485+(((-1.0)*x2486)));
evalcond[6]=(((x2485*x2488))+(((-1.0)*x2485*x2489)));
evalcond[7]=((-1.0)+((x2485*x2486))+(((-1.0)*x2485*x2487)));
evalcond[8]=(((x2483*x2487))+((x2484*x2487))+(((-1.0)*x2484*x2486))+(((-1.0)*x2483*x2486)));
evalcond[9]=(((x2483*x2489))+((x2484*x2489))+(((-1.0)*x2484*x2488))+(((-1.0)*x2483*x2488)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2490 = IKatan2WithCheck(IkReal(((625000000.5)*new_r12)),IkReal(((-625000000.5)*new_r02)),IKFAST_ATAN2_MAGTHRESH);
if(!x2490.valid){
continue;
}
CheckValue<IkReal> x2491=IKPowWithIntegerCheck(IKsign(sj4),-1);
if(!x2491.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x2490.value)+(((1.5707963267949)*(x2491.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x2492=IKcos(j5);
IkReal x2493=IKsin(j5);
IkReal x2494=((0.9999999992)*cj4);
IkReal x2495=((3.9999999968e-5)*sj4);
IkReal x2496=((1.0000000008)*sj4);
IkReal x2497=(new_r12*x2493);
IkReal x2498=(new_r02*x2492);
IkReal x2499=(new_r11*x2493);
IkReal x2500=(new_r01*x2492);
evalcond[0]=(((new_r02*x2493))+((new_r12*x2492)));
evalcond[1]=(((new_r01*x2493))+((new_r11*x2492)));
evalcond[2]=(((x2492*x2496))+new_r02);
evalcond[3]=((((-1.0)*x2493*x2496))+new_r12);
evalcond[4]=(x2500+(((-1.0)*x2499)));
evalcond[5]=(x2498+x2496+(((-1.0)*x2497)));
evalcond[6]=(((x2496*x2499))+(((-1.0)*x2496*x2500)));
evalcond[7]=((-1.0)+(((-1.0)*x2496*x2498))+((x2496*x2497)));
evalcond[8]=((((-1.0)*x2495*x2497))+((x2494*x2498))+(((-1.0)*x2494*x2497))+((x2495*x2498)));
evalcond[9]=((((-1.0)*x2495*x2499))+((x2494*x2500))+(((-1.0)*x2494*x2499))+((x2495*x2500)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r00))+(IKabs(new_r02)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
new_r00=0;
new_r02=0;
new_r11=0;
new_r21=0;
j5eval[0]=cj3;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
new_r00=0;
new_r02=0;
new_r11=0;
new_r21=0;
j5eval[0]=new_r01;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
new_r00=0;
new_r02=0;
new_r11=0;
new_r21=0;
j5eval[0]=((((25000.0)*cj3*cj4))+((cj3*sj4)));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j3)))), 6.28318530717959)));
evalcond[1]=new_r12;
evalcond[2]=new_r20;
evalcond[3]=new_r10;
evalcond[4]=new_r01;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
new_r00=0;
new_r02=0;
new_r11=0;
new_r21=0;
sj3=1.0;
cj3=0;
j3=1.5707963267949;
j5eval[0]=IKabs(((((-25000.0)*sj4))+cj4));
if( IKabs(j5eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j5]

} else
{
IkReal op[2+1], zeror[2];
int numroots;
IkReal x2501=((25000.0)*sj4);
op[0]=((((-1.0)*x2501))+cj4);
op[1]=0;
op[2]=(x2501+(((-1.0)*cj4)));
polyroots2(op,zeror,numroots);
IkReal j5array[2], cj5array[2], sj5array[2], tempj5array[1];
int numsolutions = 0;
for(int ij5 = 0; ij5 < numroots; ++ij5)
{
IkReal htj5 = zeror[ij5];
tempj5array[0]=((2.0)*(atan(htj5)));
for(int kj5 = 0; kj5 < 1; ++kj5)
{
j5array[numsolutions] = tempj5array[kj5];
if( j5array[numsolutions] > IKPI )
{
    j5array[numsolutions]-=IK2PI;
}
else if( j5array[numsolutions] < -IKPI )
{
    j5array[numsolutions]+=IK2PI;
}
sj5array[numsolutions] = IKsin(j5array[numsolutions]);
cj5array[numsolutions] = IKcos(j5array[numsolutions]);
numsolutions++;
}
}
bool j5valid[2]={true,true};
_nj5 = 2;
for(int ij5 = 0; ij5 < numsolutions; ++ij5)
    {
if( !j5valid[ij5] )
{
    continue;
}
    j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
htj5 = IKtan(j5/2);

_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < numsolutions; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j3)))), 6.28318530717959)));
evalcond[1]=new_r12;
evalcond[2]=new_r20;
evalcond[3]=new_r10;
evalcond[4]=new_r01;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
new_r00=0;
new_r02=0;
new_r11=0;
new_r21=0;
sj3=-1.0;
cj3=0;
j3=-1.5707963267949;
j5eval[0]=IKabs(((((-25000.0)*sj4))+cj4));
if( IKabs(j5eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j5]

} else
{
IkReal op[2+1], zeror[2];
int numroots;
IkReal x2502=((25000.0)*sj4);
op[0]=((((-1.0)*x2502))+cj4);
op[1]=0;
op[2]=(x2502+(((-1.0)*cj4)));
polyroots2(op,zeror,numroots);
IkReal j5array[2], cj5array[2], sj5array[2], tempj5array[1];
int numsolutions = 0;
for(int ij5 = 0; ij5 < numroots; ++ij5)
{
IkReal htj5 = zeror[ij5];
tempj5array[0]=((2.0)*(atan(htj5)));
for(int kj5 = 0; kj5 < 1; ++kj5)
{
j5array[numsolutions] = tempj5array[kj5];
if( j5array[numsolutions] > IKPI )
{
    j5array[numsolutions]-=IK2PI;
}
else if( j5array[numsolutions] < -IKPI )
{
    j5array[numsolutions]+=IK2PI;
}
sj5array[numsolutions] = IKsin(j5array[numsolutions]);
cj5array[numsolutions] = IKcos(j5array[numsolutions]);
numsolutions++;
}
}
bool j5valid[2]={true,true};
_nj5 = 2;
for(int ij5 = 0; ij5 < numsolutions; ++ij5)
    {
if( !j5valid[ij5] )
{
    continue;
}
    j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
htj5 = IKtan(j5/2);

_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < numsolutions; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
CheckValue<IkReal> x2503=IKPowWithIntegerCheck(((((0.9999999992)*cj3*cj4))+(((3.9999999968e-5)*cj3*sj4))),-1);
if(!x2503.valid){
continue;
}
sj5array[0]=((-1.0)*new_r10*(x2503.value));
if( sj5array[0] >= -1-IKFAST_SINCOS_THRESH && sj5array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j5valid[0] = j5valid[1] = true;
    j5array[0] = IKasin(sj5array[0]);
    cj5array[0] = IKcos(j5array[0]);
    sj5array[1] = sj5array[0];
    j5array[1] = j5array[0] > 0 ? (IKPI-j5array[0]) : (-IKPI-j5array[0]);
    cj5array[1] = -cj5array[0];
}
else if( isnan(sj5array[0]) )
{
    // probably any value will work
    j5valid[0] = true;
    cj5array[0] = 1; sj5array[0] = 0; j5array[0] = 0;
}
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[15];
IkReal x2504=IKcos(j5);
IkReal x2505=IKsin(j5);
IkReal x2506=((3.9999999968e-5)*cj4);
IkReal x2507=((1.0)*cj3);
IkReal x2508=(cj3*cj4);
IkReal x2509=((25000.00002)*sj4);
IkReal x2510=((0.9999999992)*sj4);
IkReal x2511=((3.9999999968e-5)*sj4);
IkReal x2512=(new_r01*x2504);
IkReal x2513=((0.9999999992)*x2504);
IkReal x2514=(new_r12*x2505);
IkReal x2515=(new_r10*x2505);
IkReal x2516=(cj3*x2504);
evalcond[0]=(new_r12*x2504);
evalcond[1]=(new_r10*x2504);
evalcond[2]=x2512;
evalcond[3]=((-1.0)*x2514);
evalcond[4]=((-1.0)*x2516);
evalcond[5]=(new_r01+(((-1.0)*x2505*x2507)));
evalcond[6]=(((new_r01*x2505))+(((-1.0)*x2507)));
evalcond[7]=(x2509*x2512);
evalcond[8]=((-25000.00002)*sj4*x2514);
evalcond[9]=(((x2504*x2510))+(((-1.0)*x2504*x2506)));
evalcond[10]=((((-1.0)*cj3*x2511))+(((-1.0)*x2515))+(((-0.9999999992)*x2508)));
evalcond[11]=((((-1.0)*x2508*x2513))+(((-1.0)*x2511*x2516)));
evalcond[12]=((((-1.0)*x2510*x2512))+((x2506*x2512)));
CheckValue<IkReal> x2517=IKPowWithIntegerCheck(((((25000.00002)*cj4))+(((-625000000.5)*sj4))),-1);
if(!x2517.valid){
continue;
}
evalcond[13]=((((625000001.0)*new_r20*(x2517.value)))+(((-1.0)*x2509*x2515)));
evalcond[14]=((((0.9999999992)*cj4*new_r20))+(((-1.0)*x2506*x2515))+((x2510*x2515))+((new_r20*x2511)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
CheckValue<IkReal> x2518=IKPowWithIntegerCheck(new_r01,-1);
if(!x2518.valid){
continue;
}
sj5array[0]=(cj3*(x2518.value));
if( sj5array[0] >= -1-IKFAST_SINCOS_THRESH && sj5array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j5valid[0] = j5valid[1] = true;
    j5array[0] = IKasin(sj5array[0]);
    cj5array[0] = IKcos(j5array[0]);
    sj5array[1] = sj5array[0];
    j5array[1] = j5array[0] > 0 ? (IKPI-j5array[0]) : (-IKPI-j5array[0]);
    cj5array[1] = -cj5array[0];
}
else if( isnan(sj5array[0]) )
{
    // probably any value will work
    j5valid[0] = true;
    cj5array[0] = 1; sj5array[0] = 0; j5array[0] = 0;
}
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[15];
IkReal x2519=IKcos(j5);
IkReal x2520=IKsin(j5);
IkReal x2521=((3.9999999968e-5)*cj4);
IkReal x2522=(cj3*cj4);
IkReal x2523=((3.9999999968e-5)*cj3);
IkReal x2524=(new_r01*x2519);
IkReal x2525=((0.9999999992)*x2519);
IkReal x2526=(new_r12*x2520);
IkReal x2527=(sj4*x2520);
IkReal x2528=(new_r10*x2520);
evalcond[0]=(new_r12*x2519);
evalcond[1]=(new_r10*x2519);
evalcond[2]=x2524;
evalcond[3]=((-1.0)*x2526);
evalcond[4]=((-1.0)*cj3*x2519);
evalcond[5]=((((-1.0)*cj3*x2520))+new_r01);
evalcond[6]=((25000.00002)*sj4*x2524);
evalcond[7]=((-25000.00002)*sj4*x2526);
evalcond[8]=(((sj4*x2525))+(((-1.0)*x2519*x2521)));
evalcond[9]=((((-1.0)*sj4*x2523))+(((-1.0)*x2528))+(((-0.9999999992)*x2522)));
evalcond[10]=((((-1.0)*x2522*x2525))+(((-1.0)*sj4*x2519*x2523)));
evalcond[11]=((((-0.9999999992)*sj4*x2524))+((x2521*x2524)));
evalcond[12]=((((0.9999999992)*x2520*x2522))+new_r10+((x2523*x2527)));
CheckValue<IkReal> x2529=IKPowWithIntegerCheck(((((25000.00002)*cj4))+(((-625000000.5)*sj4))),-1);
if(!x2529.valid){
continue;
}
evalcond[13]=((((625000001.0)*new_r20*(x2529.value)))+(((-25000.00002)*new_r10*x2527)));
evalcond[14]=((((0.9999999992)*cj4*new_r20))+(((0.9999999992)*new_r10*x2527))+(((3.9999999968e-5)*new_r20*sj4))+(((-1.0)*x2521*x2528)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
CheckValue<IkReal> x2530=IKPowWithIntegerCheck(cj3,-1);
if(!x2530.valid){
continue;
}
sj5array[0]=(new_r01*(x2530.value));
if( sj5array[0] >= -1-IKFAST_SINCOS_THRESH && sj5array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j5valid[0] = j5valid[1] = true;
    j5array[0] = IKasin(sj5array[0]);
    cj5array[0] = IKcos(j5array[0]);
    sj5array[1] = sj5array[0];
    j5array[1] = j5array[0] > 0 ? (IKPI-j5array[0]) : (-IKPI-j5array[0]);
    cj5array[1] = -cj5array[0];
}
else if( isnan(sj5array[0]) )
{
    // probably any value will work
    j5valid[0] = true;
    cj5array[0] = 1; sj5array[0] = 0; j5array[0] = 0;
}
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[15];
IkReal x2531=IKcos(j5);
IkReal x2532=IKsin(j5);
IkReal x2533=((3.9999999968e-5)*cj4);
IkReal x2534=(cj3*cj4);
IkReal x2535=((3.9999999968e-5)*cj3);
IkReal x2536=(new_r01*x2531);
IkReal x2537=((0.9999999992)*x2531);
IkReal x2538=(new_r12*x2532);
IkReal x2539=(sj4*x2532);
IkReal x2540=(new_r10*x2532);
evalcond[0]=(new_r12*x2531);
evalcond[1]=(new_r10*x2531);
evalcond[2]=x2536;
evalcond[3]=((-1.0)*x2538);
evalcond[4]=((-1.0)*cj3*x2531);
evalcond[5]=(((new_r01*x2532))+(((-1.0)*cj3)));
evalcond[6]=((25000.00002)*sj4*x2536);
evalcond[7]=((-25000.00002)*sj4*x2538);
evalcond[8]=(((sj4*x2537))+(((-1.0)*x2531*x2533)));
evalcond[9]=((((-1.0)*x2540))+(((-1.0)*sj4*x2535))+(((-0.9999999992)*x2534)));
evalcond[10]=((((-1.0)*x2534*x2537))+(((-1.0)*sj4*x2531*x2535)));
evalcond[11]=((((-0.9999999992)*sj4*x2536))+((x2533*x2536)));
evalcond[12]=((((0.9999999992)*x2532*x2534))+new_r10+((x2535*x2539)));
CheckValue<IkReal> x2541=IKPowWithIntegerCheck(((((25000.00002)*cj4))+(((-625000000.5)*sj4))),-1);
if(!x2541.valid){
continue;
}
evalcond[13]=((((-25000.00002)*new_r10*x2539))+(((625000001.0)*new_r20*(x2541.value))));
evalcond[14]=((((0.9999999992)*cj4*new_r20))+(((0.9999999992)*new_r10*x2539))+(((-1.0)*x2533*x2540))+(((3.9999999968e-5)*new_r20*sj4)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r12))+(IKabs(new_r10)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
new_r10=0;
new_r12=0;
new_r21=0;
new_r01=0;
j5eval[0]=cj3;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
new_r10=0;
new_r12=0;
new_r21=0;
new_r01=0;
j5eval[0]=new_r11;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
new_r10=0;
new_r12=0;
new_r21=0;
new_r01=0;
j5eval[0]=((((-25000.0)*cj3*cj4))+(((-1.0)*cj3*sj4)));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j3)))), 6.28318530717959)));
evalcond[1]=new_r02;
evalcond[2]=new_r20;
evalcond[3]=new_r00;
evalcond[4]=new_r11;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
j5array[0]=0;
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j3)))), 6.28318530717959)));
evalcond[1]=new_r02;
evalcond[2]=new_r20;
evalcond[3]=new_r00;
evalcond[4]=new_r11;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
j5array[0]=0;
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
CheckValue<IkReal> x2542=IKPowWithIntegerCheck(((((-0.9999999992)*cj3*cj4))+(((-3.9999999968e-5)*cj3*sj4))),-1);
if(!x2542.valid){
continue;
}
cj5array[0]=((-1.0)*new_r00*(x2542.value));
if( cj5array[0] >= -1-IKFAST_SINCOS_THRESH && cj5array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j5valid[0] = j5valid[1] = true;
    j5array[0] = IKacos(cj5array[0]);
    sj5array[0] = IKsin(j5array[0]);
    cj5array[1] = cj5array[0];
    j5array[1] = -j5array[0];
    sj5array[1] = -sj5array[0];
}
else if( isnan(cj5array[0]) )
{
    // probably any value will work
    j5valid[0] = true;
    cj5array[0] = 1; sj5array[0] = 0; j5array[0] = 0;
}
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[15];
IkReal x2543=IKsin(j5);
IkReal x2544=IKcos(j5);
IkReal x2545=((3.9999999968e-5)*sj4);
IkReal x2546=((1.0)*cj3);
IkReal x2547=((0.9999999992)*cj4);
IkReal x2548=((25000.00002)*sj4);
IkReal x2549=((0.9999999992)*sj4);
IkReal x2550=(cj3*x2543);
IkReal x2551=(new_r00*x2544);
IkReal x2552=(new_r02*x2544);
IkReal x2553=((3.9999999968e-5)*cj4*x2543);
IkReal x2554=(new_r11*sj4*x2543);
evalcond[0]=(new_r02*x2543);
evalcond[1]=(new_r00*x2543);
evalcond[2]=x2552;
evalcond[3]=((-1.0)*new_r11*x2543);
evalcond[4]=((-1.0)*x2550);
evalcond[5]=((((-1.0)*x2544*x2546))+new_r11);
evalcond[6]=((((-1.0)*x2546))+((new_r11*x2544)));
evalcond[7]=(x2548*x2552);
evalcond[8]=((-25000.00002)*x2554);
evalcond[9]=(x2553+(((-1.0)*x2543*x2549)));
evalcond[10]=(x2551+(((-1.0)*cj3*x2547))+(((-1.0)*cj3*x2545)));
evalcond[11]=(((x2547*x2550))+((x2545*x2550)));
evalcond[12]=((((-1.0)*new_r11*x2553))+((new_r11*x2543*x2549)));
CheckValue<IkReal> x2555=IKPowWithIntegerCheck(((((25000.00002)*cj4))+(((-625000000.5)*sj4))),-1);
if(!x2555.valid){
continue;
}
evalcond[13]=((((625000001.0)*new_r20*(x2555.value)))+((x2548*x2551)));
evalcond[14]=((((-1.0)*x2549*x2551))+((new_r20*x2547))+((new_r20*x2545))+(((3.9999999968e-5)*cj4*x2551)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
CheckValue<IkReal> x2556=IKPowWithIntegerCheck(new_r11,-1);
if(!x2556.valid){
continue;
}
cj5array[0]=(cj3*(x2556.value));
if( cj5array[0] >= -1-IKFAST_SINCOS_THRESH && cj5array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j5valid[0] = j5valid[1] = true;
    j5array[0] = IKacos(cj5array[0]);
    sj5array[0] = IKsin(j5array[0]);
    cj5array[1] = cj5array[0];
    j5array[1] = -j5array[0];
    sj5array[1] = -sj5array[0];
}
else if( isnan(cj5array[0]) )
{
    // probably any value will work
    j5valid[0] = true;
    cj5array[0] = 1; sj5array[0] = 0; j5array[0] = 0;
}
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[15];
IkReal x2557=IKsin(j5);
IkReal x2558=IKcos(j5);
IkReal x2559=((3.9999999968e-5)*sj4);
IkReal x2560=((0.9999999992)*cj4);
IkReal x2561=((25000.00002)*sj4);
IkReal x2562=((0.9999999992)*sj4);
IkReal x2563=(cj3*x2557);
IkReal x2564=(cj3*x2558);
IkReal x2565=(new_r00*x2558);
IkReal x2566=(new_r02*x2558);
IkReal x2567=((3.9999999968e-5)*cj4*x2557);
IkReal x2568=(new_r11*sj4*x2557);
evalcond[0]=(new_r02*x2557);
evalcond[1]=(new_r00*x2557);
evalcond[2]=x2566;
evalcond[3]=((-1.0)*new_r11*x2557);
evalcond[4]=((-1.0)*x2563);
evalcond[5]=((((-1.0)*x2564))+new_r11);
evalcond[6]=(x2561*x2566);
evalcond[7]=((-25000.00002)*x2568);
evalcond[8]=(x2567+(((-1.0)*x2557*x2562)));
evalcond[9]=(x2565+(((-1.0)*cj3*x2559))+(((-1.0)*cj3*x2560)));
evalcond[10]=(((x2560*x2563))+((x2559*x2563)));
evalcond[11]=((((-1.0)*new_r11*x2567))+((new_r11*x2557*x2562)));
evalcond[12]=((((-1.0)*x2560*x2564))+(((-1.0)*x2559*x2564))+new_r00);
CheckValue<IkReal> x2569=IKPowWithIntegerCheck(((((25000.00002)*cj4))+(((-625000000.5)*sj4))),-1);
if(!x2569.valid){
continue;
}
evalcond[13]=((((625000001.0)*new_r20*(x2569.value)))+((x2561*x2565)));
evalcond[14]=((((3.9999999968e-5)*cj4*x2565))+(((-1.0)*x2562*x2565))+((new_r20*x2559))+((new_r20*x2560)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
CheckValue<IkReal> x2570=IKPowWithIntegerCheck(cj3,-1);
if(!x2570.valid){
continue;
}
cj5array[0]=(new_r11*(x2570.value));
if( cj5array[0] >= -1-IKFAST_SINCOS_THRESH && cj5array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j5valid[0] = j5valid[1] = true;
    j5array[0] = IKacos(cj5array[0]);
    sj5array[0] = IKsin(j5array[0]);
    cj5array[1] = cj5array[0];
    j5array[1] = -j5array[0];
    sj5array[1] = -sj5array[0];
}
else if( isnan(cj5array[0]) )
{
    // probably any value will work
    j5valid[0] = true;
    cj5array[0] = 1; sj5array[0] = 0; j5array[0] = 0;
}
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[15];
IkReal x2571=IKsin(j5);
IkReal x2572=IKcos(j5);
IkReal x2573=((3.9999999968e-5)*sj4);
IkReal x2574=((0.9999999992)*cj3);
IkReal x2575=((0.9999999992)*cj4);
IkReal x2576=((25000.00002)*sj4);
IkReal x2577=((0.9999999992)*sj4);
IkReal x2578=(cj3*x2571);
IkReal x2579=(cj4*x2572);
IkReal x2580=(new_r00*x2572);
IkReal x2581=(new_r02*x2572);
IkReal x2582=((3.9999999968e-5)*cj4*x2571);
IkReal x2583=(new_r11*sj4*x2571);
evalcond[0]=(new_r02*x2571);
evalcond[1]=(new_r00*x2571);
evalcond[2]=x2581;
evalcond[3]=((-1.0)*new_r11*x2571);
evalcond[4]=((-1.0)*x2578);
evalcond[5]=(((new_r11*x2572))+(((-1.0)*cj3)));
evalcond[6]=(x2576*x2581);
evalcond[7]=((-25000.00002)*x2583);
evalcond[8]=(x2582+(((-1.0)*x2571*x2577)));
evalcond[9]=(x2580+(((-1.0)*cj3*x2573))+(((-1.0)*cj4*x2574)));
evalcond[10]=(((x2573*x2578))+((cj4*x2571*x2574)));
evalcond[11]=(((new_r11*x2571*x2577))+(((-1.0)*new_r11*x2582)));
evalcond[12]=((((-1.0)*cj3*x2572*x2573))+new_r00+(((-1.0)*x2574*x2579)));
CheckValue<IkReal> x2584=IKPowWithIntegerCheck(((((25000.00002)*cj4))+(((-625000000.5)*sj4))),-1);
if(!x2584.valid){
continue;
}
evalcond[13]=((((625000001.0)*new_r20*(x2584.value)))+((x2576*x2580)));
evalcond[14]=((((3.9999999968e-5)*new_r00*x2579))+((new_r20*x2575))+((new_r20*x2573))+(((-1.0)*x2577*x2580)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r12))+(IKabs(new_r02)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j5eval[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j5eval[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[3];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j5eval[0]=625000001.0;
j5eval[1]=sj4;
j5eval[2]=1.0;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j4))), 6.28318530717959)));
evalcond[1]=new_r00;
evalcond[2]=new_r10;
evalcond[3]=new_r01;
evalcond[4]=new_r11;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
sj4=0;
cj4=1.0;
j4=0;
j5eval[0]=1.0;
if( IKabs(j5eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j5]

} else
{
IkReal op[2+1], zeror[2];
int numroots;
op[0]=1.0;
op[1]=0;
op[2]=-1.0;
polyroots2(op,zeror,numroots);
IkReal j5array[2], cj5array[2], sj5array[2], tempj5array[1];
int numsolutions = 0;
for(int ij5 = 0; ij5 < numroots; ++ij5)
{
IkReal htj5 = zeror[ij5];
tempj5array[0]=((2.0)*(atan(htj5)));
for(int kj5 = 0; kj5 < 1; ++kj5)
{
j5array[numsolutions] = tempj5array[kj5];
if( j5array[numsolutions] > IKPI )
{
    j5array[numsolutions]-=IK2PI;
}
else if( j5array[numsolutions] < -IKPI )
{
    j5array[numsolutions]+=IK2PI;
}
sj5array[numsolutions] = IKsin(j5array[numsolutions]);
cj5array[numsolutions] = IKcos(j5array[numsolutions]);
numsolutions++;
}
}
bool j5valid[2]={true,true};
_nj5 = 2;
for(int ij5 = 0; ij5 < numsolutions; ++ij5)
    {
if( !j5valid[ij5] )
{
    continue;
}
    j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
htj5 = IKtan(j5/2);

_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < numsolutions; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j4)))), 6.28318530717959)));
evalcond[1]=new_r00;
evalcond[2]=new_r10;
evalcond[3]=new_r01;
evalcond[4]=new_r11;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
j5eval[0]=1.0;
if( IKabs(j5eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j5]

} else
{
IkReal op[2+1], zeror[2];
int numroots;
op[0]=-1.0;
op[1]=0;
op[2]=1.0;
polyroots2(op,zeror,numroots);
IkReal j5array[2], cj5array[2], sj5array[2], tempj5array[1];
int numsolutions = 0;
for(int ij5 = 0; ij5 < numroots; ++ij5)
{
IkReal htj5 = zeror[ij5];
tempj5array[0]=((2.0)*(atan(htj5)));
for(int kj5 = 0; kj5 < 1; ++kj5)
{
j5array[numsolutions] = tempj5array[kj5];
if( j5array[numsolutions] > IKPI )
{
    j5array[numsolutions]-=IK2PI;
}
else if( j5array[numsolutions] < -IKPI )
{
    j5array[numsolutions]+=IK2PI;
}
sj5array[numsolutions] = IKsin(j5array[numsolutions]);
cj5array[numsolutions] = IKcos(j5array[numsolutions]);
numsolutions++;
}
}
bool j5valid[2]={true,true};
_nj5 = 2;
for(int ij5 = 0; ij5 < numsolutions; ++ij5)
    {
if( !j5valid[ij5] )
{
    continue;
}
    j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
htj5 = IKtan(j5/2);

_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < numsolutions; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
CheckValue<IkReal> x2586 = IKatan2WithCheck(IkReal(((25000.00002)*new_r00*sj4)),IkReal(((-25000.00002)*new_r10*sj4)),IKFAST_ATAN2_MAGTHRESH);
if(!x2586.valid){
continue;
}
IkReal x2585=x2586.value;
j5array[0]=((-1.0)*x2585);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
j5array[1]=((3.14159265358979)+(((-1.0)*x2585)));
sj5array[1]=IKsin(j5array[1]);
cj5array[1]=IKcos(j5array[1]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
if( j5array[1] > IKPI )
{
    j5array[1]-=IK2PI;
}
else if( j5array[1] < -IKPI )
{    j5array[1]+=IK2PI;
}
j5valid[1] = true;
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[9];
IkReal x2587=IKcos(j5);
IkReal x2588=IKsin(j5);
IkReal x2589=((3.9999999968e-5)*cj4);
IkReal x2590=((0.9999999992)*sj4);
IkReal x2591=((25000.00002)*sj4);
IkReal x2592=(new_r01*x2587);
IkReal x2593=(new_r11*x2588);
IkReal x2594=(new_r00*x2587);
IkReal x2595=(new_r10*x2588);
evalcond[0]=(((new_r00*x2588))+((new_r10*x2587)));
evalcond[1]=(((new_r11*x2587))+((new_r01*x2588)));
evalcond[2]=(x2594+(((-1.0)*x2595)));
evalcond[3]=(x2592+(((-1.0)*x2593)));
evalcond[4]=((((-1.0)*x2587*x2589))+((x2587*x2590)));
evalcond[5]=((((-1.0)*x2588*x2590))+((x2588*x2589)));
evalcond[6]=(((x2591*x2592))+(((-1.0)*x2591*x2593)));
evalcond[7]=((((-1.0)*x2590*x2594))+(((-1.0)*x2589*x2595))+((x2589*x2594))+((x2590*x2595)));
evalcond[8]=((((-1.0)*x2590*x2592))+(((-1.0)*x2589*x2593))+((x2589*x2592))+((x2590*x2593)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
CheckValue<IkReal> x2597 = IKatan2WithCheck(IkReal(new_r11),IkReal(new_r01),IKFAST_ATAN2_MAGTHRESH);
if(!x2597.valid){
continue;
}
IkReal x2596=x2597.value;
j5array[0]=((-1.0)*x2596);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
j5array[1]=((3.14159265358979)+(((-1.0)*x2596)));
sj5array[1]=IKsin(j5array[1]);
cj5array[1]=IKcos(j5array[1]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
if( j5array[1] > IKPI )
{
    j5array[1]-=IK2PI;
}
else if( j5array[1] < -IKPI )
{    j5array[1]+=IK2PI;
}
j5valid[1] = true;
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[9];
IkReal x2598=IKcos(j5);
IkReal x2599=IKsin(j5);
IkReal x2600=((3.9999999968e-5)*cj4);
IkReal x2601=((25000.00002)*sj4);
IkReal x2602=((0.9999999992)*sj4);
IkReal x2603=(new_r01*x2598);
IkReal x2604=(new_r11*x2599);
IkReal x2605=(sj4*x2598);
IkReal x2606=(new_r00*x2598);
IkReal x2607=(new_r10*x2599);
evalcond[0]=(((new_r10*x2598))+((new_r00*x2599)));
evalcond[1]=((((-1.0)*x2607))+x2606);
evalcond[2]=((((-1.0)*x2604))+x2603);
evalcond[3]=(((x2598*x2602))+(((-1.0)*x2598*x2600)));
evalcond[4]=(((x2599*x2600))+(((-1.0)*x2599*x2602)));
evalcond[5]=((((-1.0)*x2601*x2607))+((x2601*x2606)));
evalcond[6]=((((-1.0)*x2601*x2604))+((x2601*x2603)));
evalcond[7]=(((x2602*x2607))+(((-1.0)*x2600*x2607))+((x2600*x2606))+(((-1.0)*x2602*x2606)));
evalcond[8]=(((x2602*x2604))+(((-1.0)*x2600*x2604))+((x2600*x2603))+(((-1.0)*x2602*x2603)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
CheckValue<IkReal> x2609 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x2609.valid){
continue;
}
IkReal x2608=x2609.value;
j5array[0]=((-1.0)*x2608);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
j5array[1]=((3.14159265358979)+(((-1.0)*x2608)));
sj5array[1]=IKsin(j5array[1]);
cj5array[1]=IKcos(j5array[1]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
if( j5array[1] > IKPI )
{
    j5array[1]-=IK2PI;
}
else if( j5array[1] < -IKPI )
{    j5array[1]+=IK2PI;
}
j5valid[1] = true;
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[9];
IkReal x2610=IKcos(j5);
IkReal x2611=IKsin(j5);
IkReal x2612=((3.9999999968e-5)*cj4);
IkReal x2613=((25000.00002)*sj4);
IkReal x2614=((0.9999999992)*sj4);
IkReal x2615=(new_r01*x2610);
IkReal x2616=(new_r11*x2611);
IkReal x2617=(sj4*x2610);
IkReal x2618=(new_r00*x2610);
IkReal x2619=(new_r10*x2611);
evalcond[0]=(((new_r11*x2610))+((new_r01*x2611)));
evalcond[1]=((((-1.0)*x2619))+x2618);
evalcond[2]=((((-1.0)*x2616))+x2615);
evalcond[3]=((((-1.0)*x2610*x2612))+((x2610*x2614)));
evalcond[4]=((((-1.0)*x2611*x2614))+((x2611*x2612)));
evalcond[5]=(((x2613*x2618))+(((-1.0)*x2613*x2619)));
evalcond[6]=(((x2613*x2615))+(((-1.0)*x2613*x2616)));
evalcond[7]=((((-1.0)*x2612*x2619))+((x2614*x2619))+((x2612*x2618))+(((-1.0)*x2614*x2618)));
evalcond[8]=((((-1.0)*x2612*x2616))+((x2614*x2616))+((x2612*x2615))+(((-1.0)*x2614*x2615)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2620 = IKatan2WithCheck(IkReal(new_r12),IkReal(((-1.0)*new_r02)),IKFAST_ATAN2_MAGTHRESH);
if(!x2620.valid){
continue;
}
CheckValue<IkReal> x2621=IKPowWithIntegerCheck(IKsign(((((-3.9999999968e-5)*cj4))+(((0.9999999992)*sj4)))),-1);
if(!x2621.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x2620.value)+(((1.5707963267949)*(x2621.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[18];
IkReal x2622=IKcos(j5);
IkReal x2623=IKsin(j5);
IkReal x2624=((1.0)*cj3);
IkReal x2625=((0.9999999992)*cj4);
IkReal x2626=((0.9999999992)*sj4);
IkReal x2627=((3.9999999968e-5)*cj4);
IkReal x2628=((3.9999999968e-5)*sj4);
IkReal x2629=(new_r12*x2623);
IkReal x2630=(new_r02*x2622);
IkReal x2631=(new_r01*x2622);
IkReal x2632=(new_r11*x2623);
IkReal x2633=(sj3*x2623);
IkReal x2634=(sj3*x2622);
IkReal x2635=(new_r00*x2622);
IkReal x2636=(cj3*x2622);
IkReal x2637=(cj3*x2623);
IkReal x2638=(new_r10*x2623);
evalcond[0]=(((new_r12*x2622))+((new_r02*x2623)));
evalcond[1]=(sj3+((new_r10*x2622))+((new_r00*x2623)));
evalcond[2]=(((new_r11*x2622))+(((-1.0)*x2624))+((new_r01*x2623)));
evalcond[3]=((((-1.0)*x2622*x2627))+((x2622*x2626))+new_r02);
evalcond[4]=((((-1.0)*x2623*x2626))+((x2623*x2627))+new_r12);
evalcond[5]=((((-1.0)*x2629))+(((-1.0)*x2627))+x2630+x2626);
evalcond[6]=((((-1.0)*x2638))+(((-1.0)*cj3*x2628))+(((-1.0)*cj3*x2625))+x2635);
evalcond[7]=((((-1.0)*sj3*x2628))+(((-1.0)*sj3*x2625))+(((-1.0)*x2632))+x2631);
evalcond[8]=((((-1.0)*x2628*x2636))+new_r00+(((-1.0)*x2625*x2636))+x2633);
evalcond[9]=(((x2625*x2637))+((x2628*x2637))+new_r10+x2634);
evalcond[10]=((((-1.0)*x2623*x2624))+(((-1.0)*x2628*x2634))+new_r01+(((-1.0)*x2625*x2634)));
evalcond[11]=((((-1.0)*x2622*x2624))+((x2625*x2633))+((x2628*x2633))+new_r11);
evalcond[12]=(((new_r20*x2625))+((new_r20*x2628))+((x2627*x2635))+(((-1.0)*x2626*x2635))+((x2626*x2638))+(((-1.0)*x2627*x2638)));
evalcond[13]=(((new_r21*x2625))+((new_r21*x2628))+((x2627*x2631))+(((-1.0)*x2626*x2631))+((x2626*x2632))+(((-1.0)*x2627*x2632)));
evalcond[14]=((((-1.0)*x2625*x2629))+((x2625*x2630))+((new_r22*x2626))+(((-1.0)*new_r22*x2627))+((x2628*x2630))+(((-1.0)*x2628*x2629)));
evalcond[15]=((-1.0)+((x2626*x2629))+(((-1.0)*x2627*x2629))+((new_r22*x2628))+((new_r22*x2625))+((x2627*x2630))+(((-1.0)*x2626*x2630)));
evalcond[16]=(((new_r20*x2626))+(((-1.0)*x2628*x2638))+((x2625*x2635))+((x2628*x2635))+(((-1.0)*new_r20*x2627))+(((-1.0)*x2624))+(((-1.0)*x2625*x2638)));
evalcond[17]=((((-1.0)*sj3))+((new_r21*x2626))+(((-1.0)*x2628*x2632))+((x2625*x2631))+((x2628*x2631))+(((-1.0)*new_r21*x2627))+(((-1.0)*x2625*x2632)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2639=IKPowWithIntegerCheck(IKsign((((new_r01*new_r12))+(((-1.0)*new_r02*new_r11)))),-1);
if(!x2639.valid){
continue;
}
CheckValue<IkReal> x2640 = IKatan2WithCheck(IkReal((cj3*new_r12)),IkReal(((-1.0)*cj3*new_r02)),IKFAST_ATAN2_MAGTHRESH);
if(!x2640.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x2639.value)))+(x2640.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[18];
IkReal x2641=IKcos(j5);
IkReal x2642=IKsin(j5);
IkReal x2643=((1.0)*cj3);
IkReal x2644=((0.9999999992)*cj4);
IkReal x2645=((0.9999999992)*sj4);
IkReal x2646=((3.9999999968e-5)*cj4);
IkReal x2647=((3.9999999968e-5)*sj4);
IkReal x2648=(new_r12*x2642);
IkReal x2649=(new_r02*x2641);
IkReal x2650=(new_r01*x2641);
IkReal x2651=(new_r11*x2642);
IkReal x2652=(sj3*x2642);
IkReal x2653=(sj3*x2641);
IkReal x2654=(new_r00*x2641);
IkReal x2655=(cj3*x2641);
IkReal x2656=(cj3*x2642);
IkReal x2657=(new_r10*x2642);
evalcond[0]=(((new_r02*x2642))+((new_r12*x2641)));
evalcond[1]=(sj3+((new_r10*x2641))+((new_r00*x2642)));
evalcond[2]=(((new_r11*x2641))+((new_r01*x2642))+(((-1.0)*x2643)));
evalcond[3]=((((-1.0)*x2641*x2646))+new_r02+((x2641*x2645)));
evalcond[4]=((((-1.0)*x2642*x2645))+new_r12+((x2642*x2646)));
evalcond[5]=((((-1.0)*x2646))+(((-1.0)*x2648))+x2649+x2645);
evalcond[6]=((((-1.0)*cj3*x2644))+(((-1.0)*cj3*x2647))+(((-1.0)*x2657))+x2654);
evalcond[7]=((((-1.0)*sj3*x2647))+(((-1.0)*sj3*x2644))+(((-1.0)*x2651))+x2650);
evalcond[8]=((((-1.0)*x2644*x2655))+(((-1.0)*x2647*x2655))+new_r00+x2652);
evalcond[9]=(((x2644*x2656))+new_r10+((x2647*x2656))+x2653);
evalcond[10]=((((-1.0)*x2644*x2653))+(((-1.0)*x2647*x2653))+(((-1.0)*x2642*x2643))+new_r01);
evalcond[11]=(((x2644*x2652))+(((-1.0)*x2641*x2643))+new_r11+((x2647*x2652)));
evalcond[12]=((((-1.0)*x2645*x2654))+(((-1.0)*x2646*x2657))+((new_r20*x2647))+((new_r20*x2644))+((x2645*x2657))+((x2646*x2654)));
evalcond[13]=(((new_r21*x2644))+((new_r21*x2647))+(((-1.0)*x2645*x2650))+(((-1.0)*x2646*x2651))+((x2645*x2651))+((x2646*x2650)));
evalcond[14]=((((-1.0)*x2644*x2648))+(((-1.0)*x2647*x2648))+(((-1.0)*new_r22*x2646))+((x2644*x2649))+((x2647*x2649))+((new_r22*x2645)));
evalcond[15]=((-1.0)+(((-1.0)*x2646*x2648))+(((-1.0)*x2645*x2649))+((x2645*x2648))+((x2646*x2649))+((new_r22*x2647))+((new_r22*x2644)));
evalcond[16]=((((-1.0)*x2644*x2657))+((new_r20*x2645))+(((-1.0)*x2647*x2657))+((x2644*x2654))+(((-1.0)*new_r20*x2646))+(((-1.0)*x2643))+((x2647*x2654)));
evalcond[17]=((((-1.0)*sj3))+((new_r21*x2645))+(((-1.0)*x2644*x2651))+(((-1.0)*x2647*x2651))+(((-1.0)*new_r21*x2646))+((x2644*x2650))+((x2647*x2650)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2658 = IKatan2WithCheck(IkReal((new_r12*sj3)),IkReal(((-1.0)*new_r02*sj3)),IKFAST_ATAN2_MAGTHRESH);
if(!x2658.valid){
continue;
}
CheckValue<IkReal> x2659=IKPowWithIntegerCheck(IKsign(((((-1.0)*new_r00*new_r12))+((new_r02*new_r10)))),-1);
if(!x2659.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x2658.value)+(((1.5707963267949)*(x2659.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[18];
IkReal x2660=IKcos(j5);
IkReal x2661=IKsin(j5);
IkReal x2662=((1.0)*cj3);
IkReal x2663=((0.9999999992)*cj4);
IkReal x2664=((0.9999999992)*sj4);
IkReal x2665=((3.9999999968e-5)*cj4);
IkReal x2666=((3.9999999968e-5)*sj4);
IkReal x2667=(new_r12*x2661);
IkReal x2668=(new_r02*x2660);
IkReal x2669=(new_r01*x2660);
IkReal x2670=(new_r11*x2661);
IkReal x2671=(sj3*x2661);
IkReal x2672=(sj3*x2660);
IkReal x2673=(new_r00*x2660);
IkReal x2674=(cj3*x2660);
IkReal x2675=(cj3*x2661);
IkReal x2676=(new_r10*x2661);
evalcond[0]=(((new_r02*x2661))+((new_r12*x2660)));
evalcond[1]=(sj3+((new_r10*x2660))+((new_r00*x2661)));
evalcond[2]=((((-1.0)*x2662))+((new_r11*x2660))+((new_r01*x2661)));
evalcond[3]=((((-1.0)*x2660*x2665))+((x2660*x2664))+new_r02);
evalcond[4]=(((x2661*x2665))+new_r12+(((-1.0)*x2661*x2664)));
evalcond[5]=((((-1.0)*x2667))+(((-1.0)*x2665))+x2664+x2668);
evalcond[6]=((((-1.0)*x2676))+(((-1.0)*cj3*x2663))+(((-1.0)*cj3*x2666))+x2673);
evalcond[7]=((((-1.0)*x2670))+(((-1.0)*sj3*x2663))+(((-1.0)*sj3*x2666))+x2669);
evalcond[8]=((((-1.0)*x2663*x2674))+(((-1.0)*x2666*x2674))+new_r00+x2671);
evalcond[9]=(((x2663*x2675))+((x2666*x2675))+new_r10+x2672);
evalcond[10]=((((-1.0)*x2663*x2672))+(((-1.0)*x2666*x2672))+new_r01+(((-1.0)*x2661*x2662)));
evalcond[11]=((((-1.0)*x2660*x2662))+((x2663*x2671))+((x2666*x2671))+new_r11);
evalcond[12]=(((new_r20*x2666))+((new_r20*x2663))+((x2664*x2676))+(((-1.0)*x2664*x2673))+(((-1.0)*x2665*x2676))+((x2665*x2673)));
evalcond[13]=(((x2664*x2670))+(((-1.0)*x2665*x2670))+(((-1.0)*x2664*x2669))+((x2665*x2669))+((new_r21*x2666))+((new_r21*x2663)));
evalcond[14]=(((x2663*x2668))+(((-1.0)*new_r22*x2665))+((x2666*x2668))+(((-1.0)*x2663*x2667))+((new_r22*x2664))+(((-1.0)*x2666*x2667)));
evalcond[15]=((-1.0)+((x2664*x2667))+(((-1.0)*x2664*x2668))+(((-1.0)*x2665*x2667))+((new_r22*x2663))+((new_r22*x2666))+((x2665*x2668)));
evalcond[16]=(((x2663*x2673))+(((-1.0)*new_r20*x2665))+((new_r20*x2664))+((x2666*x2673))+(((-1.0)*x2663*x2676))+(((-1.0)*x2662))+(((-1.0)*x2666*x2676)));
evalcond[17]=((((-1.0)*sj3))+((x2663*x2669))+((x2666*x2669))+(((-1.0)*new_r21*x2665))+(((-1.0)*x2663*x2670))+(((-1.0)*x2666*x2670))+((new_r21*x2664)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x2677 = IKatan2WithCheck(IkReal(new_r12),IkReal(((-1.0)*new_r02)),IKFAST_ATAN2_MAGTHRESH);
if(!x2677.valid){
continue;
}
CheckValue<IkReal> x2678=IKPowWithIntegerCheck(IKsign(((((-3.9999999968e-5)*cj4))+(((0.9999999992)*sj4)))),-1);
if(!x2678.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x2677.value)+(((1.5707963267949)*(x2678.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x2679=IKcos(j5);
IkReal x2680=IKsin(j5);
IkReal x2681=((0.9999999992)*cj4);
IkReal x2682=((3.9999999968e-5)*cj4);
IkReal x2683=((0.9999999992)*sj4);
IkReal x2684=((3.9999999968e-5)*sj4);
IkReal x2685=(new_r12*x2680);
IkReal x2686=(new_r02*x2679);
IkReal x2687=(new_r01*x2679);
IkReal x2688=(new_r11*x2680);
IkReal x2689=(new_r00*x2679);
IkReal x2690=(new_r10*x2680);
evalcond[0]=(((new_r12*x2679))+((new_r02*x2680)));
evalcond[1]=((((-1.0)*x2679*x2682))+((x2679*x2683))+new_r02);
evalcond[2]=((((-1.0)*x2680*x2683))+new_r12+((x2680*x2682)));
evalcond[3]=((((-1.0)*x2682))+(((-1.0)*x2685))+x2686+x2683);
evalcond[4]=((((-1.0)*x2683*x2689))+(((-1.0)*x2682*x2690))+((new_r20*x2681))+((new_r20*x2684))+((x2683*x2690))+((x2682*x2689)));
evalcond[5]=((((-1.0)*x2683*x2687))+((x2683*x2688))+(((-1.0)*x2682*x2688))+((x2682*x2687))+((new_r21*x2684))+((new_r21*x2681)));
evalcond[6]=(((new_r22*x2683))+(((-1.0)*x2684*x2685))+(((-1.0)*new_r22*x2682))+((x2684*x2686))+(((-1.0)*x2681*x2685))+((x2681*x2686)));
evalcond[7]=((-1.0)+((new_r22*x2681))+((new_r22*x2684))+(((-1.0)*x2683*x2686))+((x2683*x2685))+(((-1.0)*x2682*x2685))+((x2682*x2686)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
if( IKabs(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj5*new_r11))+((new_r01*sj5)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))))+IKsqr((((cj5*new_r11))+((new_r01*sj5))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((-1.0)*new_r00*sj5))+(((-1.0)*cj5*new_r10))), (((cj5*new_r11))+((new_r01*sj5))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[12];
IkReal x2691=IKcos(j3);
IkReal x2692=IKsin(j3);
IkReal x2693=((0.9999999992)*cj4);
IkReal x2694=((3.9999999968e-5)*cj4);
IkReal x2695=(cj5*new_r01);
IkReal x2696=((0.9999999992)*sj4);
IkReal x2697=(cj5*new_r00);
IkReal x2698=((3.9999999968e-5)*sj4);
IkReal x2699=(new_r10*sj5);
IkReal x2700=(new_r11*sj5);
IkReal x2701=((1.0)*x2691);
IkReal x2702=(cj5*x2692);
IkReal x2703=(sj5*x2691);
IkReal x2704=(sj5*x2692);
IkReal x2705=(cj5*x2691);
IkReal x2706=(x2691*x2698);
evalcond[0]=(((cj5*new_r10))+((new_r00*sj5))+x2692);
evalcond[1]=(((cj5*new_r11))+((new_r01*sj5))+(((-1.0)*x2701)));
evalcond[2]=(((x2691*x2694))+(((-1.0)*x2691*x2696))+new_r20);
evalcond[3]=((((-1.0)*x2692*x2696))+new_r21+((x2692*x2694)));
evalcond[4]=((((-1.0)*x2691*x2693))+(((-1.0)*x2706))+(((-1.0)*x2699))+x2697);
evalcond[5]=((((-1.0)*x2692*x2693))+(((-1.0)*x2692*x2698))+(((-1.0)*x2700))+x2695);
evalcond[6]=(x2704+new_r00+(((-1.0)*x2693*x2705))+(((-1.0)*x2698*x2705)));
evalcond[7]=(x2702+((x2693*x2703))+((x2698*x2703))+new_r10);
evalcond[8]=((((-1.0)*sj5*x2701))+new_r01+(((-1.0)*x2693*x2702))+(((-1.0)*x2698*x2702)));
evalcond[9]=((((-1.0)*cj5*x2701))+((x2693*x2704))+((x2698*x2704))+new_r11);
evalcond[10]=(((x2697*x2698))+(((-1.0)*new_r20*x2694))+((x2693*x2697))+(((-1.0)*x2698*x2699))+(((-1.0)*x2701))+((new_r20*x2696))+(((-1.0)*x2693*x2699)));
evalcond[11]=(((x2693*x2695))+((x2695*x2698))+(((-1.0)*x2692))+((new_r21*x2696))+(((-1.0)*new_r21*x2694))+(((-1.0)*x2693*x2700))+(((-1.0)*x2698*x2700)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}
}
}
}
}static inline void polyroots3(IkReal rawcoeffs[3+1], IkReal rawroots[3], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots2(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[3];
    const int maxsteps = 110;
    for(int i = 0; i < 3; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[3];
    IkReal err[3];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 3; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 3; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 3; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 3; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[3] = {false};
    for(int i = 0; i < 3; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 3; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots2(IkReal rawcoeffs[2+1], IkReal rawroots[2], int& numroots) {
    IkReal det = rawcoeffs[1]*rawcoeffs[1]-4*rawcoeffs[0]*rawcoeffs[2];
    if( det < 0 ) {
        numroots=0;
    }
    else if( det == 0 ) {
        rawroots[0] = -0.5*rawcoeffs[1]/rawcoeffs[0];
        numroots = 1;
    }
    else {
        det = IKsqrt(det);
        rawroots[0] = (-rawcoeffs[1]+det)/(2*rawcoeffs[0]);
        rawroots[1] = (-rawcoeffs[1]-det)/(2*rawcoeffs[0]);//rawcoeffs[2]/(rawcoeffs[0]*rawroots[0]);
        numroots = 2;
    }
}
static inline void polyroots4(IkReal rawcoeffs[4+1], IkReal rawroots[4], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots3(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[4];
    const int maxsteps = 110;
    for(int i = 0; i < 4; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[4];
    IkReal err[4];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 4; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 4; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 4; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 4; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[4] = {false};
    for(int i = 0; i < 4; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 4; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
};


/// solves the inverse kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API bool ComputeIk2(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions, void* pOpenRAVEManip) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API const char* GetKinematicsHash() { return "<robot:GenericRobot - irb4600 (cf95c00c17c4b2b3fc4659a63b598d9c)>"; }

IKFAST_API const char* GetIkFastVersion() { return "0x1000004a"; }

#ifdef IKFAST_NAMESPACE
} // end namespace
#endif

#ifndef IKFAST_NO_MAIN
#include <stdio.h>
#include <stdlib.h>
#ifdef IKFAST_NAMESPACE
using namespace IKFAST_NAMESPACE;
#endif
int main(int argc, char** argv)
{
    if( argc != 12+GetNumFreeParameters()+1 ) {
        printf("\nUsage: ./ik r00 r01 r02 t0 r10 r11 r12 t1 r20 r21 r22 t2 free0 ...\n\n"
               "Returns the ik solutions given the transformation of the end effector specified by\n"
               "a 3x3 rotation R (rXX), and a 3x1 translation (tX).\n"
               "There are %d free parameters that have to be specified.\n\n",GetNumFreeParameters());
        return 1;
    }

    IkSolutionList<IkReal> solutions;
    std::vector<IkReal> vfree(GetNumFreeParameters());
    IkReal eerot[9],eetrans[3];
    eerot[0] = atof(argv[1]); eerot[1] = atof(argv[2]); eerot[2] = atof(argv[3]); eetrans[0] = atof(argv[4]);
    eerot[3] = atof(argv[5]); eerot[4] = atof(argv[6]); eerot[5] = atof(argv[7]); eetrans[1] = atof(argv[8]);
    eerot[6] = atof(argv[9]); eerot[7] = atof(argv[10]); eerot[8] = atof(argv[11]); eetrans[2] = atof(argv[12]);
    for(std::size_t i = 0; i < vfree.size(); ++i)
        vfree[i] = atof(argv[13+i]);
    bool bSuccess = ComputeIk(eetrans, eerot, vfree.size() > 0 ? &vfree[0] : NULL, solutions);

    if( !bSuccess ) {
        fprintf(stderr,"Failed to get ik solution\n");
        return -1;
    }

    printf("Found %d ik solutions:\n", (int)solutions.GetNumSolutions());
    std::vector<IkReal> solvalues(GetNumJoints());
    for(std::size_t i = 0; i < solutions.GetNumSolutions(); ++i) {
        const IkSolutionBase<IkReal>& sol = solutions.GetSolution(i);
        printf("sol%d (free=%d): ", (int)i, (int)sol.GetFree().size());
        std::vector<IkReal> vsolfree(sol.GetFree().size());
        sol.GetSolution(&solvalues[0],vsolfree.size()>0?&vsolfree[0]:NULL);
        for( std::size_t j = 0; j < solvalues.size(); ++j)
            printf("%.15f, ", solvalues[j]);
        printf("\n");
    }
    return 0;
}

#endif
