/**********************************************************************************************************************
This file is part of the Control Toolbox (https://github.com/ethz-adrl/control-toolbox), copyright by ETH Zurich.
Licensed under the BSD-2 license (see LICENSE file in main directory)
**********************************************************************************************************************/
#include "HyQForwardZero.h"

namespace ct {
namespace models {
namespace HyQ {


HyQForwardZero::OUT_TYPE HyQForwardZero::forwardZero(const Eigen::VectorXd& x_in)
{
    double* forwardZero = eval_.data();

        v_[0] = 1 / cos(x_in[1]);
    v_[1] = cos(x_in[2]);
    v_[2] = 0 - v_[0];
    v_[3] = sin(x_in[2]);
    forwardZero[0] = v_[0] * v_[1] * x_in[18] + v_[2] * v_[3] * x_in[19];
    forwardZero[1] = v_[3] * x_in[18] + v_[1] * x_in[19];
    v_[4] = sin(x_in[1]);
    forwardZero[2] = x_in[20] + v_[0] * v_[3] * v_[4] * x_in[19] + v_[2] * v_[1] * v_[4] * x_in[18];
    v_[4] = 0.5 * x_in[0];
    v_[3] = cos(v_[4]);
    v_[2] = 0.5 * x_in[1];
    v_[1] = cos(v_[2]);
    v_[0] = v_[3] * v_[1];
    v_[5] = 0.5 * x_in[2];
    v_[6] = sin(v_[5]);
    v_[4] = sin(v_[4]);
    v_[2] = sin(v_[2]);
    v_[7] = v_[4] * v_[2];
    v_[5] = cos(v_[5]);
    v_[8] = v_[0] * v_[6] + v_[7] * v_[5];
    v_[9] = 2. * v_[8];
    v_[1] = v_[4] * v_[1];
    v_[2] = v_[3] * v_[2];
    v_[10] = v_[1] * v_[5] + v_[2] * v_[6];
    v_[11] = v_[9] * v_[10];
    v_[2] = v_[2] * v_[5] - v_[1] * v_[6];
    v_[1] = 2. * v_[2];
    v_[5] = v_[0] * v_[5] - v_[7] * v_[6];
    v_[7] = v_[1] * v_[5];
    v_[6] = v_[1] * v_[10];
    v_[0] = v_[9] * v_[5];
    v_[8] = v_[9] * v_[8];
    v_[1] = v_[1] * v_[2];
    forwardZero[3] = (v_[11] + v_[7]) * x_in[23] + (v_[6] - v_[0]) * x_in[22] + (1 - v_[8] - v_[1]) * x_in[21];
    v_[2] = v_[9] * v_[2];
    v_[9] = 2. * v_[10];
    v_[5] = v_[9] * v_[5];
    v_[9] = v_[9] * v_[10];
    forwardZero[4] = (v_[2] - v_[5]) * x_in[23] + (1 - v_[8] - v_[9]) * x_in[22] + (v_[6] + v_[0]) * x_in[21];
    forwardZero[5] = (1 - v_[1] - v_[9]) * x_in[23] + (v_[2] + v_[5]) * x_in[22] + (v_[11] - v_[7]) * x_in[21];
    v_[9] = cos(x_in[15]);
    v_[5] = cos(x_in[16]);
    v_[2] = cos(x_in[17]);
    v_[1] = -8.81e-05 * v_[2];
    v_[7] = sin(x_in[17]);
    v_[11] = 0 - v_[7];
    v_[8] = 8.81e-05 * v_[11];
    v_[0] = 0.35 * v_[7];
    v_[6] = 8.81e-05 * v_[0];
    v_[10] = 2. * v_[6];
    v_[12] = -0.35 * v_[2];
    v_[13] = 0 - -8.81e-05 * v_[12];
    v_[14] = 2. * v_[13];
    v_[6] = 0 - v_[6];
    v_[15] = -0.000102 + v_[10] * v_[11] + v_[14] * v_[2] - v_[2] * v_[13] - v_[7] * v_[6];
    v_[16] = -0.00185880198235362 * v_[0] - 0.414812462825713 * v_[12];
    v_[17] = 0.881 * v_[12];
    v_[18] = -0.1104774 + v_[17];
    v_[19] = v_[16] + v_[18];
    v_[20] = 0.880992588508842 * v_[0] - -0.00185880198235362 * v_[12];
    v_[21] = 0 - 0.881 * v_[0];
    v_[22] = -0.0004405 + v_[21];
    v_[23] = v_[20] + v_[22];
    v_[18] = 0 - v_[18];
    v_[24] = v_[2] * v_[18] + v_[11] * v_[22];
    v_[25] = 0.47422804 + v_[19] * v_[2] + v_[23] * v_[7] + v_[24];
    v_[20] = v_[20] * v_[0] - v_[16] * v_[12];
    v_[16] = 0.089871 + v_[20];
    v_[26] = v_[25] / v_[16];
    v_[27] = v_[1] * v_[2] + v_[8] * v_[7] - v_[15] * v_[26];
    v_[28] = sin(x_in[16]);
    v_[29] = 0 - v_[28];
    v_[30] = -8.81e-05 * v_[7];
    v_[31] = 8.81e-05 * v_[2];
    v_[6] = 2.1e-05 + v_[10] * v_[2] + v_[14] * v_[7] + v_[11] * v_[13] + v_[2] * v_[6];
    v_[14] = v_[30] * v_[2] + v_[31] * v_[7] - v_[6] * v_[26];
    v_[13] = v_[5] * v_[27] + v_[29] * v_[14];
    v_[18] = v_[7] * v_[18] + v_[2] * v_[22];
    v_[23] = -0.0825825 + v_[19] * v_[11] + v_[23] * v_[2] - v_[18];
    v_[19] = v_[23] / v_[16];
    v_[8] = v_[1] * v_[11] + v_[8] * v_[2] - v_[15] * v_[19];
    v_[31] = v_[30] * v_[11] + v_[31] * v_[2] - v_[6] * v_[19];
    v_[30] = v_[5] * v_[8] + v_[29] * v_[31];
    v_[1] = -0.0004405 * v_[12] + v_[21] * v_[12] - -0.1104774 * v_[0];
    v_[17] = 0.026409 + -0.2209548 * v_[12] + v_[17] * v_[12] - v_[20];
    v_[12] = v_[7] * v_[1] + v_[2] * v_[17];
    v_[21] = 0.000468 - -0.000881 * v_[0] - v_[21] * v_[0] - v_[20];
    v_[1] = v_[7] * v_[21] + v_[2] * v_[1];
    v_[22] = v_[6] / v_[16];
    v_[10] = -0.007418 + v_[12] * v_[11] + v_[1] * v_[2] - v_[15] * v_[22];
    v_[18] = 0.0825825 + v_[18];
    v_[32] = 0 - v_[5];
    v_[33] = 0.08 * v_[32];
    v_[34] = 0.08 * v_[28];
    v_[35] = 0 - 4.027 * v_[34];
    v_[24] = -0.47422804 - v_[24];
    v_[36] = v_[10] + v_[18] * v_[33] + v_[35] * v_[33] - v_[24] * v_[34];
    v_[1] = v_[1] * v_[7] + v_[12] * v_[2];
    v_[22] = 0.087136 + v_[20] + v_[1] - v_[6] * v_[22];
    v_[12] = 4.027 * v_[33];
    v_[37] = -7.4114911576828e-06 * v_[7] + -0.00185880198235362 * v_[2];
    v_[38] = -0.00185880198235362 * v_[7] + -0.466187537174287 * v_[2];
    v_[39] = v_[37] * v_[7] + v_[38] * v_[2];
    v_[19] = 3.56080505133456 - v_[39] - v_[23] * v_[19];
    v_[38] = v_[38] * v_[11] + v_[37] * v_[2] - v_[23] * v_[26];
    v_[37] = v_[34] * v_[19] - v_[33] * v_[38];
    v_[39] = 4.027 + v_[39] - v_[25] * v_[26];
    v_[26] = v_[34] * v_[38] - v_[33] * v_[39];
    v_[40] = v_[37] * v_[34] - v_[26] * v_[33];
    v_[41] = 2. * v_[24] * v_[33] + v_[22] + v_[12] * v_[33] - v_[40];
    v_[42] = v_[29] * v_[36] + v_[32] * v_[41];
    v_[1] = 0.005495 + v_[17] + v_[21] + v_[20] - v_[1] - v_[15] * v_[15] / v_[16];
    v_[21] = v_[1] - 2. * v_[18] * v_[34] - v_[35] * v_[34] - v_[40];
    v_[36] = v_[29] * v_[21] + v_[32] * v_[36];
    v_[17] = -0.022734 + v_[42] * v_[29] + v_[36] * v_[5];
    v_[20] = v_[29] * v_[8] + v_[32] * v_[31];
    v_[43] = v_[29] * v_[27] + v_[32] * v_[14];
    v_[44] = v_[20] * v_[5] + v_[43] * v_[29];
    v_[36] = v_[36] * v_[29] + v_[42] * v_[32];
    v_[42] = 0.011033 + v_[40] + v_[36];
    v_[45] = v_[44] / v_[42];
    v_[46] = v_[13] * v_[29] + v_[30] * v_[5] - v_[17] * v_[45];
    v_[47] = 0.207 * v_[9];
    v_[48] = sin(x_in[15]);
    v_[49] = 0.3735 * v_[48];
    v_[50] = 0 - v_[9];
    v_[51] = -0.3735 * v_[9];
    v_[52] = v_[48] * v_[49] + v_[50] * v_[51];
    v_[12] = v_[12] + v_[24];
    v_[53] = 0 - v_[12];
    v_[35] = v_[35] + v_[18];
    v_[54] = v_[5] * v_[53] + v_[29] * v_[35];
    v_[55] = 0.1466472 + v_[54];
    v_[56] = v_[55] / v_[42];
    v_[57] = 0 - v_[44] * v_[56];
    v_[58] = v_[52] * v_[57];
    v_[59] = v_[39] - 4.027;
    v_[60] = v_[29] * v_[38] + v_[32] * v_[59];
    v_[61] = v_[19] - 4.027;
    v_[62] = v_[29] * v_[61] + v_[32] * v_[38];
    v_[43] = v_[20] * v_[29] + v_[43] * v_[32];
    v_[20] = v_[43] / v_[42];
    v_[63] = v_[60] * v_[29] + v_[62] * v_[5] - v_[44] * v_[20];
    v_[64] = v_[47] * v_[63];
    v_[65] = v_[58] - v_[64];
    v_[53] = v_[29] * v_[53] + v_[32] * v_[35];
    v_[66] = -0.5824264 - v_[53] - v_[17] * v_[56];
    v_[67] = 0.207 * v_[48];
    v_[68] = 7.467 - v_[55] * v_[56];
    v_[69] = 0 - v_[55] * v_[20];
    v_[70] = v_[52] * v_[68] - v_[47] * v_[69];
    v_[71] = v_[46] * v_[47] + v_[65] * v_[47] - v_[66] * v_[67] - v_[70] * v_[67];
    v_[72] = v_[8] * v_[34] - v_[27] * v_[33];
    v_[33] = v_[31] * v_[34] - v_[14] * v_[33];
    v_[73] = 0 - v_[33];
    v_[74] = -5.1e-05 + v_[29] * v_[72] + v_[5] * v_[73];
    v_[56] = 0 - v_[74] * v_[56];
    v_[75] = v_[67] * v_[69];
    v_[58] = v_[75] - v_[58];
    v_[12] = v_[26] + v_[12];
    v_[35] = v_[37] + v_[35];
    v_[53] = 0.5824264 + v_[12] * v_[29] + v_[35] * v_[5] + v_[53] - v_[74] * v_[45];
    v_[62] = v_[62] * v_[29] + v_[60] * v_[32];
    v_[61] = 7.467 + v_[59] + v_[61] - v_[62] - v_[44] * v_[45];
    v_[59] = v_[67] * v_[63] - v_[52] * v_[61];
    v_[45] = v_[56] * v_[67] + v_[58] * v_[67] - v_[53] * v_[47] - v_[59] * v_[47];
    v_[60] = 0 - v_[9] * v_[71] - v_[48] * v_[45];
    v_[37] = cos(x_in[12]);
    v_[26] = 0 - v_[37];
    v_[76] = cos(x_in[13]);
    v_[77] = sin(x_in[14]);
    v_[78] = 0.35 * v_[77];
    v_[79] = cos(x_in[14]);
    v_[80] = -0.35 * v_[79];
    v_[81] = -0.00370574557885489 * v_[78] - 0.417781802643138 * v_[80];
    v_[82] = 0.881 * v_[80];
    v_[83] = -0.110125 + v_[82];
    v_[84] = v_[81] + v_[83];
    v_[85] = 0.880970354035369 * v_[78] - -0.00370574557885489 * v_[80];
    v_[86] = 0 - 0.881 * v_[78];
    v_[87] = -0.000881 + v_[86];
    v_[88] = v_[85] + v_[87];
    v_[83] = 0 - v_[83];
    v_[89] = 0 - v_[77];
    v_[90] = v_[79] * v_[83] + v_[89] * v_[87];
    v_[91] = 0.47422804 + v_[84] * v_[79] + v_[88] * v_[77] + v_[90];
    v_[85] = v_[85] * v_[78] - v_[81] * v_[80];
    v_[81] = 0.089871 + v_[85];
    v_[92] = v_[91] / v_[81];
    v_[93] = 0 - -0.000102 * v_[92];
    v_[94] = sin(x_in[13]);
    v_[95] = 0 - v_[94];
    v_[96] = 0 - 2.1e-05 * v_[92];
    v_[97] = v_[76] * v_[93] + v_[95] * v_[96];
    v_[83] = v_[77] * v_[83] + v_[79] * v_[87];
    v_[88] = -0.0825825 + v_[84] * v_[89] + v_[88] * v_[79] - v_[83];
    v_[84] = v_[88] / v_[81];
    v_[87] = 0 - -0.000102 * v_[84];
    v_[98] = 0 - 2.1e-05 * v_[84];
    v_[99] = v_[76] * v_[87] + v_[95] * v_[98];
    v_[100] = -0.000881 * v_[80] + v_[86] * v_[80] - -0.110125 * v_[78];
    v_[82] = 0.026409 + -0.22025 * v_[80] + v_[82] * v_[80] - v_[85];
    v_[80] = v_[77] * v_[100] + v_[79] * v_[82];
    v_[86] = 0.000468 - -0.001762 * v_[78] - v_[86] * v_[78] - v_[85];
    v_[100] = v_[77] * v_[86] + v_[79] * v_[100];
    v_[101] = 2.1e-05 / v_[81];
    v_[102] = -0.007418 + v_[80] * v_[89] + v_[100] * v_[79] - -0.000102 * v_[101];
    v_[83] = 0.0825825 + v_[83];
    v_[103] = -0.08 * v_[76];
    v_[104] = -0.08 * v_[94];
    v_[105] = -1 * v_[104];
    v_[106] = 0 - 4.027 * v_[105];
    v_[90] = -0.47422804 - v_[90];
    v_[107] = v_[102] + v_[83] * v_[103] + v_[106] * v_[103] - v_[90] * v_[105];
    v_[100] = v_[100] * v_[77] + v_[80] * v_[79];
    v_[101] = 0.087136 + v_[85] + v_[100] - 2.1e-05 * v_[101];
    v_[80] = 4.027 * v_[103];
    v_[108] = -2.96459646308422e-05 * v_[77] + -0.00370574557885489 * v_[79];
    v_[109] = -0.00370574557885489 * v_[77] + -0.463218197356862 * v_[79];
    v_[110] = v_[108] * v_[77] + v_[109] * v_[79];
    v_[84] = 3.56375215667851 - v_[110] - v_[88] * v_[84];
    v_[109] = v_[109] * v_[89] + v_[108] * v_[79] - v_[88] * v_[92];
    v_[108] = v_[105] * v_[84] - v_[103] * v_[109];
    v_[110] = 4.027 + v_[110] - v_[91] * v_[92];
    v_[92] = v_[105] * v_[109] - v_[103] * v_[110];
    v_[111] = v_[108] * v_[105] - v_[92] * v_[103];
    v_[112] = 2. * v_[90] * v_[103] + v_[101] + v_[80] * v_[103] - v_[111];
    v_[113] = v_[94] * v_[107] + v_[76] * v_[112];
    v_[100] = 0.005495 + v_[82] + v_[86] + v_[85] - v_[100] - -0.000102 * -0.000102 / v_[81];
    v_[86] = v_[100] - 2. * v_[83] * v_[105] - v_[106] * v_[105] - v_[111];
    v_[107] = v_[94] * v_[86] + v_[76] * v_[107];
    v_[82] = 0.022734 + v_[113] * v_[95] + v_[107] * v_[76];
    v_[85] = v_[94] * v_[87] + v_[76] * v_[98];
    v_[114] = v_[94] * v_[93] + v_[76] * v_[96];
    v_[115] = v_[85] * v_[76] + v_[114] * v_[95];
    v_[107] = v_[107] * v_[94] + v_[113] * v_[76];
    v_[113] = 0.011033 + v_[111] + v_[107];
    v_[116] = v_[115] / v_[113];
    v_[117] = v_[97] * v_[95] + v_[99] * v_[76] - v_[82] * v_[116];
    v_[118] = -0.207 * v_[37];
    v_[119] = -1 * v_[118];
    v_[120] = sin(x_in[12]);
    v_[121] = 0 - v_[120];
    v_[122] = 0.3735 * v_[120];
    v_[123] = 0.3735 * v_[37];
    v_[124] = v_[121] * v_[122] + v_[26] * v_[123];
    v_[80] = v_[80] + v_[90];
    v_[125] = 0 - v_[80];
    v_[106] = v_[106] + v_[83];
    v_[126] = v_[76] * v_[125] + v_[95] * v_[106];
    v_[127] = 0.1466472 + v_[126];
    v_[128] = v_[127] / v_[113];
    v_[129] = 0 - v_[115] * v_[128];
    v_[130] = v_[124] * v_[129];
    v_[131] = v_[110] - 4.027;
    v_[132] = v_[94] * v_[109] + v_[76] * v_[131];
    v_[133] = v_[84] - 4.027;
    v_[134] = v_[94] * v_[133] + v_[76] * v_[109];
    v_[114] = v_[85] * v_[94] + v_[114] * v_[76];
    v_[85] = v_[114] / v_[113];
    v_[135] = v_[132] * v_[95] + v_[134] * v_[76] - v_[115] * v_[85];
    v_[136] = v_[119] * v_[135];
    v_[137] = v_[130] - v_[136];
    v_[125] = v_[94] * v_[125] + v_[76] * v_[106];
    v_[138] = 0.5824264 - v_[125] - v_[82] * v_[128];
    v_[139] = 0.207 * v_[120];
    v_[140] = 7.467 - v_[127] * v_[128];
    v_[141] = 0 - v_[127] * v_[85];
    v_[142] = v_[124] * v_[140] - v_[119] * v_[141];
    v_[143] = v_[117] * v_[119] + v_[137] * v_[119] - v_[138] * v_[139] - v_[142] * v_[139];
    v_[144] = v_[87] * v_[105] - v_[93] * v_[103];
    v_[105] = v_[98] * v_[105] - v_[96] * v_[103];
    v_[103] = 0 - v_[105];
    v_[145] = -5.1e-05 + v_[95] * v_[144] + v_[76] * v_[103];
    v_[128] = 0 - v_[145] * v_[128];
    v_[146] = v_[139] * v_[141];
    v_[130] = v_[146] - v_[130];
    v_[80] = -1 * (v_[92] + v_[80]);
    v_[106] = -1 * (v_[108] + v_[106]);
    v_[125] = -0.5824264 + v_[80] * v_[95] + v_[106] * v_[76] + v_[125] - v_[145] * v_[116];
    v_[134] = v_[134] * v_[94] + v_[132] * v_[76];
    v_[133] = 7.467 + v_[131] + v_[133] - v_[134] - v_[115] * v_[116];
    v_[131] = v_[139] * v_[135] - v_[124] * v_[133];
    v_[116] = v_[128] * v_[139] + v_[130] * v_[139] - v_[125] * v_[119] - v_[131] * v_[119];
    v_[132] = 0 - v_[26] * v_[143] - v_[121] * v_[116];
    v_[108] = cos(x_in[9]);
    v_[92] = cos(x_in[10]);
    v_[147] = cos(x_in[11]);
    v_[148] = 8.81e-05 * v_[147];
    v_[149] = sin(x_in[11]);
    v_[150] = 0 - v_[149];
    v_[151] = -8.81e-05 * v_[150];
    v_[152] = 0.35 * v_[149];
    v_[153] = -8.81e-05 * v_[152];
    v_[154] = 2. * v_[153];
    v_[155] = -0.35 * v_[147];
    v_[156] = 0 - 8.81e-05 * v_[155];
    v_[157] = 2. * v_[156];
    v_[153] = 0 - v_[153];
    v_[158] = 0.000102 + v_[154] * v_[150] + v_[157] * v_[147] - v_[147] * v_[156] - v_[149] * v_[153];
    v_[159] = 0.00185880198235362 * v_[152] - 0.414812462825713 * v_[155];
    v_[160] = 0.881 * v_[155];
    v_[161] = -0.1104774 + v_[160];
    v_[162] = v_[159] + v_[161];
    v_[163] = 0.880992588508842 * v_[152] - 0.00185880198235362 * v_[155];
    v_[164] = 0 - 0.881 * v_[152];
    v_[165] = 0.0004405 + v_[164];
    v_[166] = v_[163] + v_[165];
    v_[161] = 0 - v_[161];
    v_[167] = v_[147] * v_[161] + v_[150] * v_[165];
    v_[168] = 0.47422804 + v_[162] * v_[147] + v_[166] * v_[149] + v_[167];
    v_[163] = v_[163] * v_[152] - v_[159] * v_[155];
    v_[159] = 0.089871 + v_[163];
    v_[169] = v_[168] / v_[159];
    v_[170] = v_[148] * v_[147] + v_[151] * v_[149] - v_[158] * v_[169];
    v_[171] = sin(x_in[10]);
    v_[172] = 0 - v_[171];
    v_[173] = 8.81e-05 * v_[149];
    v_[174] = -8.81e-05 * v_[147];
    v_[153] = 2.1e-05 + v_[154] * v_[147] + v_[157] * v_[149] + v_[150] * v_[156] + v_[147] * v_[153];
    v_[157] = v_[173] * v_[147] + v_[174] * v_[149] - v_[153] * v_[169];
    v_[156] = v_[92] * v_[170] + v_[172] * v_[157];
    v_[161] = v_[149] * v_[161] + v_[147] * v_[165];
    v_[166] = 0.0825825 + v_[162] * v_[150] + v_[166] * v_[147] - v_[161];
    v_[162] = v_[166] / v_[159];
    v_[151] = v_[148] * v_[150] + v_[151] * v_[147] - v_[158] * v_[162];
    v_[174] = v_[173] * v_[150] + v_[174] * v_[147] - v_[153] * v_[162];
    v_[173] = v_[92] * v_[151] + v_[172] * v_[174];
    v_[148] = 0.0004405 * v_[155] + v_[164] * v_[155] - -0.1104774 * v_[152];
    v_[160] = 0.026409 + -0.2209548 * v_[155] + v_[160] * v_[155] - v_[163];
    v_[155] = v_[149] * v_[148] + v_[147] * v_[160];
    v_[164] = 0.000468 - 0.000881 * v_[152] - v_[164] * v_[152] - v_[163];
    v_[148] = v_[149] * v_[164] + v_[147] * v_[148];
    v_[165] = v_[153] / v_[159];
    v_[154] = 0.007418 + v_[155] * v_[150] + v_[148] * v_[147] - v_[158] * v_[165];
    v_[161] = -0.0825825 + v_[161];
    v_[175] = 0 - v_[92];
    v_[176] = 0.08 * v_[175];
    v_[177] = 0.08 * v_[171];
    v_[178] = 0 - 4.027 * v_[177];
    v_[167] = -0.47422804 - v_[167];
    v_[179] = v_[154] + v_[161] * v_[176] + v_[178] * v_[176] - v_[167] * v_[177];
    v_[148] = v_[148] * v_[149] + v_[155] * v_[147];
    v_[165] = 0.087136 + v_[163] + v_[148] - v_[153] * v_[165];
    v_[155] = 4.027 * v_[176];
    v_[180] = -7.4114911576828e-06 * v_[149] + 0.00185880198235362 * v_[147];
    v_[181] = 0.00185880198235362 * v_[149] + -0.466187537174287 * v_[147];
    v_[182] = v_[180] * v_[149] + v_[181] * v_[147];
    v_[162] = 3.56080505133456 - v_[182] - v_[166] * v_[162];
    v_[181] = v_[181] * v_[150] + v_[180] * v_[147] - v_[166] * v_[169];
    v_[180] = v_[177] * v_[162] - v_[176] * v_[181];
    v_[182] = 4.027 + v_[182] - v_[168] * v_[169];
    v_[169] = v_[177] * v_[181] - v_[176] * v_[182];
    v_[183] = v_[180] * v_[177] - v_[169] * v_[176];
    v_[184] = 2. * v_[167] * v_[176] + v_[165] + v_[155] * v_[176] - v_[183];
    v_[185] = v_[172] * v_[179] + v_[175] * v_[184];
    v_[148] = 0.005495 + v_[160] + v_[164] + v_[163] - v_[148] - v_[158] * v_[158] / v_[159];
    v_[164] = v_[148] - 2. * v_[161] * v_[177] - v_[178] * v_[177] - v_[183];
    v_[179] = v_[172] * v_[164] + v_[175] * v_[179];
    v_[160] = 0.022734 + v_[185] * v_[172] + v_[179] * v_[92];
    v_[163] = v_[172] * v_[151] + v_[175] * v_[174];
    v_[186] = v_[172] * v_[170] + v_[175] * v_[157];
    v_[187] = v_[163] * v_[92] + v_[186] * v_[172];
    v_[179] = v_[179] * v_[172] + v_[185] * v_[175];
    v_[185] = 0.011033 + v_[183] + v_[179];
    v_[188] = v_[187] / v_[185];
    v_[189] = v_[156] * v_[172] + v_[173] * v_[92] - v_[160] * v_[188];
    v_[190] = 0.207 * v_[108];
    v_[191] = sin(x_in[9]);
    v_[192] = -0.3735 * v_[191];
    v_[193] = 0 - v_[108];
    v_[194] = 0.3735 * v_[108];
    v_[195] = v_[191] * v_[192] + v_[193] * v_[194];
    v_[155] = v_[155] + v_[167];
    v_[196] = 0 - v_[155];
    v_[178] = v_[178] + v_[161];
    v_[197] = v_[92] * v_[196] + v_[172] * v_[178];
    v_[198] = 0.1466472 + v_[197];
    v_[199] = v_[198] / v_[185];
    v_[200] = 0 - v_[187] * v_[199];
    v_[201] = v_[195] * v_[200];
    v_[202] = v_[182] - 4.027;
    v_[203] = v_[172] * v_[181] + v_[175] * v_[202];
    v_[204] = v_[162] - 4.027;
    v_[205] = v_[172] * v_[204] + v_[175] * v_[181];
    v_[186] = v_[163] * v_[172] + v_[186] * v_[175];
    v_[163] = v_[186] / v_[185];
    v_[206] = v_[203] * v_[172] + v_[205] * v_[92] - v_[187] * v_[163];
    v_[207] = v_[190] * v_[206];
    v_[208] = v_[201] - v_[207];
    v_[196] = v_[172] * v_[196] + v_[175] * v_[178];
    v_[209] = 0.5824264 - v_[196] - v_[160] * v_[199];
    v_[210] = 0.207 * v_[191];
    v_[211] = 7.467 - v_[198] * v_[199];
    v_[212] = 0 - v_[198] * v_[163];
    v_[213] = v_[195] * v_[211] - v_[190] * v_[212];
    v_[214] = v_[189] * v_[190] + v_[208] * v_[190] - v_[209] * v_[210] - v_[213] * v_[210];
    v_[215] = v_[151] * v_[177] - v_[170] * v_[176];
    v_[176] = v_[174] * v_[177] - v_[157] * v_[176];
    v_[216] = 0 - v_[176];
    v_[217] = -5.1e-05 + v_[172] * v_[215] + v_[92] * v_[216];
    v_[199] = 0 - v_[217] * v_[199];
    v_[218] = v_[210] * v_[212];
    v_[201] = v_[218] - v_[201];
    v_[155] = v_[169] + v_[155];
    v_[178] = v_[180] + v_[178];
    v_[196] = -0.5824264 + v_[155] * v_[172] + v_[178] * v_[92] + v_[196] - v_[217] * v_[188];
    v_[205] = v_[205] * v_[172] + v_[203] * v_[175];
    v_[204] = 7.467 + v_[202] + v_[204] - v_[205] - v_[187] * v_[188];
    v_[202] = v_[210] * v_[206] - v_[195] * v_[204];
    v_[188] = v_[199] * v_[210] + v_[201] * v_[210] - v_[196] * v_[190] - v_[202] * v_[190];
    v_[203] = 0 - v_[108] * v_[214] - v_[191] * v_[188];
    v_[180] = cos(x_in[6]);
    v_[169] = 0 - v_[180];
    v_[219] = cos(x_in[7]);
    v_[220] = cos(x_in[8]);
    v_[221] = 8.81e-05 * v_[220];
    v_[222] = sin(x_in[8]);
    v_[223] = 0 - v_[222];
    v_[224] = -8.81e-05 * v_[223];
    v_[225] = 0.35 * v_[222];
    v_[226] = -8.81e-05 * v_[225];
    v_[227] = 2. * v_[226];
    v_[228] = -0.35 * v_[220];
    v_[229] = 0 - 8.81e-05 * v_[228];
    v_[230] = 2. * v_[229];
    v_[226] = 0 - v_[226];
    v_[231] = 0.000102 + v_[227] * v_[223] + v_[230] * v_[220] - v_[220] * v_[229] - v_[222] * v_[226];
    v_[232] = 0.00185880198235362 * v_[225] - 0.414812462825713 * v_[228];
    v_[233] = 0.881 * v_[228];
    v_[234] = -0.1104774 + v_[233];
    v_[235] = v_[232] + v_[234];
    v_[236] = 0.880992588508842 * v_[225] - 0.00185880198235362 * v_[228];
    v_[237] = 0 - 0.881 * v_[225];
    v_[238] = 0.0004405 + v_[237];
    v_[239] = v_[236] + v_[238];
    v_[234] = 0 - v_[234];
    v_[240] = v_[220] * v_[234] + v_[223] * v_[238];
    v_[241] = 0.47422804 + v_[235] * v_[220] + v_[239] * v_[222] + v_[240];
    v_[236] = v_[236] * v_[225] - v_[232] * v_[228];
    v_[232] = 0.089871 + v_[236];
    v_[242] = v_[241] / v_[232];
    v_[243] = v_[221] * v_[220] + v_[224] * v_[222] - v_[231] * v_[242];
    v_[244] = sin(x_in[7]);
    v_[245] = 0 - v_[244];
    v_[246] = 8.81e-05 * v_[222];
    v_[247] = -8.81e-05 * v_[220];
    v_[226] = 2.1e-05 + v_[227] * v_[220] + v_[230] * v_[222] + v_[223] * v_[229] + v_[220] * v_[226];
    v_[230] = v_[246] * v_[220] + v_[247] * v_[222] - v_[226] * v_[242];
    v_[229] = v_[219] * v_[243] + v_[245] * v_[230];
    v_[234] = v_[222] * v_[234] + v_[220] * v_[238];
    v_[239] = 0.0825825 + v_[235] * v_[223] + v_[239] * v_[220] - v_[234];
    v_[235] = v_[239] / v_[232];
    v_[224] = v_[221] * v_[223] + v_[224] * v_[220] - v_[231] * v_[235];
    v_[247] = v_[246] * v_[223] + v_[247] * v_[220] - v_[226] * v_[235];
    v_[246] = v_[219] * v_[224] + v_[245] * v_[247];
    v_[221] = 0.0004405 * v_[228] + v_[237] * v_[228] - -0.1104774 * v_[225];
    v_[233] = 0.026409 + -0.2209548 * v_[228] + v_[233] * v_[228] - v_[236];
    v_[228] = v_[222] * v_[221] + v_[220] * v_[233];
    v_[237] = 0.000468 - 0.000881 * v_[225] - v_[237] * v_[225] - v_[236];
    v_[221] = v_[222] * v_[237] + v_[220] * v_[221];
    v_[238] = v_[226] / v_[232];
    v_[227] = 0.007418 + v_[228] * v_[223] + v_[221] * v_[220] - v_[231] * v_[238];
    v_[234] = -0.0825825 + v_[234];
    v_[248] = -0.08 * v_[219];
    v_[249] = -0.08 * v_[244];
    v_[250] = -1 * v_[249];
    v_[251] = 0 - 4.027 * v_[250];
    v_[240] = -0.47422804 - v_[240];
    v_[252] = v_[227] + v_[234] * v_[248] + v_[251] * v_[248] - v_[240] * v_[250];
    v_[221] = v_[221] * v_[222] + v_[228] * v_[220];
    v_[238] = 0.087136 + v_[236] + v_[221] - v_[226] * v_[238];
    v_[228] = 4.027 * v_[248];
    v_[253] = -7.4114911576828e-06 * v_[222] + 0.00185880198235362 * v_[220];
    v_[254] = 0.00185880198235362 * v_[222] + -0.466187537174287 * v_[220];
    v_[255] = v_[253] * v_[222] + v_[254] * v_[220];
    v_[235] = 3.56080505133456 - v_[255] - v_[239] * v_[235];
    v_[254] = v_[254] * v_[223] + v_[253] * v_[220] - v_[239] * v_[242];
    v_[253] = v_[250] * v_[235] - v_[248] * v_[254];
    v_[255] = 4.027 + v_[255] - v_[241] * v_[242];
    v_[242] = v_[250] * v_[254] - v_[248] * v_[255];
    v_[256] = v_[253] * v_[250] - v_[242] * v_[248];
    v_[257] = 2. * v_[240] * v_[248] + v_[238] + v_[228] * v_[248] - v_[256];
    v_[258] = v_[244] * v_[252] + v_[219] * v_[257];
    v_[221] = 0.005495 + v_[233] + v_[237] + v_[236] - v_[221] - v_[231] * v_[231] / v_[232];
    v_[237] = v_[221] - 2. * v_[234] * v_[250] - v_[251] * v_[250] - v_[256];
    v_[252] = v_[244] * v_[237] + v_[219] * v_[252];
    v_[233] = -0.022734 + v_[258] * v_[245] + v_[252] * v_[219];
    v_[236] = v_[244] * v_[224] + v_[219] * v_[247];
    v_[259] = v_[244] * v_[243] + v_[219] * v_[230];
    v_[260] = v_[236] * v_[219] + v_[259] * v_[245];
    v_[252] = v_[252] * v_[244] + v_[258] * v_[219];
    v_[258] = 0.011033 + v_[256] + v_[252];
    v_[261] = v_[260] / v_[258];
    v_[262] = v_[229] * v_[245] + v_[246] * v_[219] - v_[233] * v_[261];
    v_[263] = -0.207 * v_[180];
    v_[264] = -1 * v_[263];
    v_[265] = sin(x_in[6]);
    v_[266] = 0 - v_[265];
    v_[267] = -0.3735 * v_[265];
    v_[268] = -0.3735 * v_[180];
    v_[269] = v_[266] * v_[267] + v_[169] * v_[268];
    v_[228] = v_[228] + v_[240];
    v_[270] = 0 - v_[228];
    v_[251] = v_[251] + v_[234];
    v_[271] = v_[219] * v_[270] + v_[245] * v_[251];
    v_[272] = 0.1466472 + v_[271];
    v_[273] = v_[272] / v_[258];
    v_[274] = 0 - v_[260] * v_[273];
    v_[275] = v_[269] * v_[274];
    v_[276] = v_[255] - 4.027;
    v_[277] = v_[244] * v_[254] + v_[219] * v_[276];
    v_[278] = v_[235] - 4.027;
    v_[279] = v_[244] * v_[278] + v_[219] * v_[254];
    v_[259] = v_[236] * v_[244] + v_[259] * v_[219];
    v_[236] = v_[259] / v_[258];
    v_[280] = v_[277] * v_[245] + v_[279] * v_[219] - v_[260] * v_[236];
    v_[281] = v_[264] * v_[280];
    v_[282] = v_[275] - v_[281];
    v_[270] = v_[244] * v_[270] + v_[219] * v_[251];
    v_[283] = -0.5824264 - v_[270] - v_[233] * v_[273];
    v_[284] = 0.207 * v_[265];
    v_[285] = 7.467 - v_[272] * v_[273];
    v_[286] = 0 - v_[272] * v_[236];
    v_[287] = v_[269] * v_[285] - v_[264] * v_[286];
    v_[288] = v_[262] * v_[264] + v_[282] * v_[264] - v_[283] * v_[284] - v_[287] * v_[284];
    v_[289] = v_[224] * v_[250] - v_[243] * v_[248];
    v_[250] = v_[247] * v_[250] - v_[230] * v_[248];
    v_[248] = 0 - v_[250];
    v_[290] = -5.1e-05 + v_[245] * v_[289] + v_[219] * v_[248];
    v_[273] = 0 - v_[290] * v_[273];
    v_[291] = v_[284] * v_[286];
    v_[275] = v_[291] - v_[275];
    v_[228] = -1 * (v_[242] + v_[228]);
    v_[251] = -1 * (v_[253] + v_[251]);
    v_[270] = 0.5824264 + v_[228] * v_[245] + v_[251] * v_[219] + v_[270] - v_[290] * v_[261];
    v_[279] = v_[279] * v_[244] + v_[277] * v_[219];
    v_[278] = 7.467 + v_[276] + v_[278] - v_[279] - v_[260] * v_[261];
    v_[276] = v_[284] * v_[280] - v_[269] * v_[278];
    v_[261] = v_[273] * v_[284] + v_[275] * v_[284] - v_[270] * v_[264] - v_[276] * v_[264];
    v_[277] = 0 - v_[169] * v_[288] - v_[266] * v_[261];
    v_[35] = -0.1466472 + v_[12] * v_[32] + v_[35] * v_[29] - v_[54] - v_[74] * v_[20];
    v_[12] = v_[74] / v_[42];
    v_[54] = 0.144171 + v_[40] - v_[74] * v_[12];
    v_[62] = 7.467 + v_[62] - v_[43] * v_[20];
    v_[253] = v_[67] * v_[62] - v_[52] * v_[63];
    v_[242] = v_[47] * v_[61] - v_[67] * v_[57];
    v_[292] = v_[47] * v_[57] - v_[67] * v_[68];
    v_[293] = v_[242] * v_[47] - v_[292] * v_[67];
    v_[294] = 2. * v_[35] * v_[67] + v_[54] + v_[253] * v_[67] - 2. * v_[53] * v_[52] - v_[59] * v_[52] - v_[293];
    v_[36] = 0.134705 + v_[41] + v_[21] + v_[40] - v_[36] - v_[17] * v_[17] / v_[42];
    v_[20] = v_[13] * v_[32] + v_[30] * v_[29] - v_[17] * v_[20];
    v_[30] = v_[52] * v_[69] - v_[47] * v_[62];
    v_[13] = 2. * v_[66] * v_[52] + v_[36] + v_[70] * v_[52] - 2. * v_[20] * v_[47] - v_[30] * v_[47] - v_[293];
    v_[106] = -0.1466472 + v_[80] * v_[76] + v_[106] * v_[94] - v_[126] - v_[145] * v_[85];
    v_[80] = v_[145] / v_[113];
    v_[126] = 0.144171 + v_[111] - v_[145] * v_[80];
    v_[134] = 7.467 + v_[134] - v_[114] * v_[85];
    v_[21] = v_[139] * v_[134] - v_[124] * v_[135];
    v_[41] = v_[119] * v_[133] - v_[139] * v_[129];
    v_[40] = v_[119] * v_[129] - v_[139] * v_[140];
    v_[295] = v_[41] * v_[119] - v_[40] * v_[139];
    v_[296] = 2. * v_[106] * v_[139] + v_[126] + v_[21] * v_[139] - 2. * v_[125] * v_[124] - v_[131] * v_[124] - v_[295];
    v_[107] = 0.134705 + v_[112] + v_[86] + v_[111] - v_[107] - v_[82] * v_[82] / v_[113];
    v_[85] = v_[97] * v_[76] + v_[99] * v_[94] - v_[82] * v_[85];
    v_[99] = v_[124] * v_[141] - v_[119] * v_[134];
    v_[97] = 2. * v_[138] * v_[124] + v_[107] + v_[142] * v_[124] - 2. * v_[85] * v_[119] - v_[99] * v_[119] - v_[295];
    v_[178] = -0.1466472 + v_[155] * v_[175] + v_[178] * v_[172] - v_[197] - v_[217] * v_[163];
    v_[155] = v_[217] / v_[185];
    v_[197] = 0.144171 + v_[183] - v_[217] * v_[155];
    v_[205] = 7.467 + v_[205] - v_[186] * v_[163];
    v_[86] = v_[210] * v_[205] - v_[195] * v_[206];
    v_[112] = v_[190] * v_[204] - v_[210] * v_[200];
    v_[111] = v_[190] * v_[200] - v_[210] * v_[211];
    v_[297] = v_[112] * v_[190] - v_[111] * v_[210];
    v_[298] = 2. * v_[178] * v_[210] + v_[197] + v_[86] * v_[210] - 2. * v_[196] * v_[195] - v_[202] * v_[195] - v_[297];
    v_[179] = 0.134705 + v_[184] + v_[164] + v_[183] - v_[179] - v_[160] * v_[160] / v_[185];
    v_[163] = v_[156] * v_[175] + v_[173] * v_[172] - v_[160] * v_[163];
    v_[173] = v_[195] * v_[212] - v_[190] * v_[205];
    v_[156] = 2. * v_[209] * v_[195] + v_[179] + v_[213] * v_[195] - 2. * v_[163] * v_[190] - v_[173] * v_[190] - v_[297];
    v_[251] = -0.1466472 + v_[228] * v_[219] + v_[251] * v_[244] - v_[271] - v_[290] * v_[236];
    v_[228] = v_[290] / v_[258];
    v_[271] = 0.144171 + v_[256] - v_[290] * v_[228];
    v_[279] = 7.467 + v_[279] - v_[259] * v_[236];
    v_[164] = v_[284] * v_[279] - v_[269] * v_[280];
    v_[184] = v_[264] * v_[278] - v_[284] * v_[274];
    v_[183] = v_[264] * v_[274] - v_[284] * v_[285];
    v_[299] = v_[184] * v_[264] - v_[183] * v_[284];
    v_[300] = 2. * v_[251] * v_[284] + v_[271] + v_[164] * v_[284] - 2. * v_[270] * v_[269] - v_[276] * v_[269] - v_[299];
    v_[252] = 0.134705 + v_[257] + v_[237] + v_[256] - v_[252] - v_[233] * v_[233] / v_[258];
    v_[236] = v_[229] * v_[219] + v_[246] * v_[244] - v_[233] * v_[236];
    v_[246] = v_[269] * v_[286] - v_[264] * v_[279];
    v_[229] = 2. * v_[283] * v_[269] + v_[252] + v_[287] * v_[269] - 2. * v_[236] * v_[264] - v_[246] * v_[264] - v_[299];
    v_[12] = -3.6e-05 + 2. * v_[33] * v_[29] + 2. * v_[72] * v_[5] + v_[32] * v_[72] + v_[29] * v_[73] - v_[17] * v_[12];
    v_[67] = v_[56] * v_[52] + v_[12] + v_[20] * v_[67] + v_[30] * v_[67] - v_[46] * v_[52] - v_[35] * v_[47] - v_[65] * v_[52];
    v_[52] = v_[48] * v_[67];
    v_[73] = (v_[48] * v_[13] + v_[9] * v_[67]) * v_[48] + (v_[52] + v_[9] * v_[294]) * v_[9];
    v_[52] = v_[50] * v_[13] + v_[52];
    v_[67] = v_[50] * v_[67] + v_[48] * v_[294];
    v_[33] = v_[52] * v_[50] + v_[67] * v_[48];
    v_[80] = 3.6e-05 + -1 * 2. * v_[105] * v_[95] + -1 * 2. * v_[144] * v_[76] + v_[76] * v_[144] + v_[94] * v_[103] - v_[82] * v_[80];
    v_[139] = v_[128] * v_[124] + v_[80] + v_[85] * v_[139] + v_[99] * v_[139] - v_[117] * v_[124] - v_[106] * v_[119] - v_[137] * v_[124];
    v_[124] = v_[26] * v_[139];
    v_[119] = (v_[121] * v_[97] + v_[124]) * v_[121] + (v_[121] * v_[139] + v_[26] * v_[296]) * v_[26];
    v_[139] = v_[26] * v_[97] + v_[120] * v_[139];
    v_[124] = v_[124] + v_[120] * v_[296];
    v_[103] = v_[139] * v_[26] + v_[124] * v_[120];
    v_[155] = 3.6e-05 + 2. * v_[176] * v_[172] + 2. * v_[215] * v_[92] + v_[175] * v_[215] + v_[172] * v_[216] - v_[160] * v_[155];
    v_[210] = v_[199] * v_[195] + v_[155] + v_[163] * v_[210] + v_[173] * v_[210] - v_[189] * v_[195] - v_[178] * v_[190] - v_[208] * v_[195];
    v_[195] = v_[191] * v_[210];
    v_[216] = (v_[191] * v_[156] + v_[108] * v_[210]) * v_[191] + (v_[195] + v_[108] * v_[298]) * v_[108];
    v_[195] = v_[193] * v_[156] + v_[195];
    v_[210] = v_[193] * v_[210] + v_[191] * v_[298];
    v_[176] = v_[195] * v_[193] + v_[210] * v_[191];
    v_[228] = -3.6e-05 + -1 * 2. * v_[250] * v_[245] + -1 * 2. * v_[289] * v_[219] + v_[219] * v_[289] + v_[244] * v_[248] - v_[233] * v_[228];
    v_[284] = v_[273] * v_[269] + v_[228] + v_[236] * v_[284] + v_[246] * v_[284] - v_[262] * v_[269] - v_[251] * v_[264] - v_[282] * v_[269];
    v_[269] = v_[169] * v_[284];
    v_[264] = (v_[266] * v_[229] + v_[269]) * v_[266] + (v_[266] * v_[284] + v_[169] * v_[300]) * v_[169];
    v_[284] = v_[169] * v_[229] + v_[265] * v_[284];
    v_[269] = v_[269] + v_[265] * v_[300];
    v_[248] = v_[284] * v_[169] + v_[269] * v_[265];
    v_[229] = 1.209488 + v_[294] + v_[13] + v_[293] + v_[296] + v_[97] + v_[295] + v_[298] + v_[156] + v_[297] + v_[300] + v_[229] + v_[299] - v_[73] - v_[33] - v_[119] - v_[103] - v_[216] - v_[176] - v_[264] - v_[248];
    v_[300] = (0.190812 + v_[60] + v_[132] + v_[203] + v_[277]) / v_[229];
    v_[156] = x_in[20] * x_in[21];
    v_[298] = x_in[18] * x_in[23];
    v_[97] = x_in[18] * x_in[19];
    v_[296] = x_in[18] * x_in[20];
    v_[13] = v_[9] * x_in[19] + v_[48] * x_in[20];
    v_[294] = 0.207 * x_in[20] + x_in[21];
    v_[250] = x_in[18] + x_in[33];
    v_[289] = -0.207 * v_[48];
    v_[215] = v_[51] * x_in[20] + v_[49] * x_in[19] + v_[289] * x_in[18] + v_[48] * x_in[23] + v_[9] * x_in[22];
    v_[105] = v_[13] * v_[294] - v_[250] * v_[215];
    v_[144] = v_[13] * v_[250];
    v_[72] = v_[250] * v_[250];
    v_[237] = v_[48] * x_in[19] + v_[50] * x_in[20];
    v_[257] = v_[237] * v_[237];
    v_[256] = v_[13] + x_in[34];
    v_[301] = 0 - v_[28];
    v_[302] = -0.3735 * v_[48];
    v_[303] = -0.3735 * v_[9];
    v_[304] = 0 - v_[9];
    v_[305] = v_[302] * x_in[20] + v_[303] * x_in[19] + v_[47] * x_in[18] + v_[304] * x_in[23] + v_[48] * x_in[22];
    v_[306] = v_[301] * v_[294] + v_[5] * v_[305] + v_[34] * v_[13];
    v_[307] = v_[256] * v_[306];
    v_[308] = v_[5] * v_[237] + v_[29] * v_[250];
    v_[309] = 0.08 * v_[250] + v_[215];
    v_[310] = v_[308] * v_[309];
    v_[311] = v_[29] * v_[237] + v_[32] * v_[250];
    v_[312] = v_[308] * v_[311];
    v_[313] = v_[308] * v_[256];
    v_[314] = v_[256] + x_in[35];
    v_[315] = 0 - v_[5];
    v_[316] = 0 - v_[28];
    v_[317] = 0.08 * v_[5];
    v_[318] = v_[315] * v_[294] + v_[316] * v_[305] + v_[317] * v_[13];
    v_[319] = v_[7] * v_[318] + v_[2] * v_[306] + v_[0] * v_[256];
    v_[320] = v_[314] * v_[319];
    v_[321] = v_[2] * v_[308] + v_[7] * v_[311];
    v_[322] = -0.35 * v_[311] + v_[309];
    v_[323] = v_[321] * v_[322];
    v_[324] = v_[11] * v_[308] + v_[2] * v_[311];
    v_[325] = v_[321] * v_[324];
    v_[326] = -0.3735 + -0.33 * v_[5] * v_[7] - 0.33 * v_[28] * v_[2] - 0.35 * v_[28];
    v_[327] = 0.5 * x_in[0];
    v_[328] = cos(v_[327]);
    v_[329] = 0.5 * x_in[1];
    v_[330] = cos(v_[329]);
    v_[331] = v_[328] * v_[330];
    v_[332] = 0.5 * x_in[2];
    v_[333] = sin(v_[332]);
    v_[327] = sin(v_[327]);
    v_[329] = sin(v_[329]);
    v_[334] = v_[327] * v_[329];
    v_[332] = cos(v_[332]);
    v_[335] = v_[331] * v_[333] + v_[334] * v_[332];
    v_[336] = 2. * v_[335];
    v_[329] = v_[328] * v_[329];
    v_[327] = v_[327] * v_[330];
    v_[330] = v_[329] * v_[332] - v_[327] * v_[333];
    v_[328] = v_[336] * v_[330];
    v_[327] = v_[327] * v_[332] + v_[329] * v_[333];
    v_[329] = 2. * v_[327];
    v_[332] = v_[331] * v_[332] - v_[334] * v_[333];
    v_[334] = v_[329] * v_[332];
    v_[333] = 0.5 * x_in[0];
    v_[331] = cos(v_[333]);
    v_[337] = 0.5 * x_in[1];
    v_[338] = sin(v_[337]);
    v_[339] = v_[331] * v_[338];
    v_[340] = 0.5 * x_in[2];
    v_[341] = cos(v_[340]);
    v_[333] = sin(v_[333]);
    v_[337] = cos(v_[337]);
    v_[342] = v_[333] * v_[337];
    v_[340] = sin(v_[340]);
    v_[343] = v_[339] * v_[341] - v_[342] * v_[340];
    v_[344] = 2. * v_[343];
    v_[345] = v_[344] * v_[343];
    v_[342] = v_[342] * v_[341] + v_[339] * v_[340];
    v_[339] = 2. * v_[342];
    v_[346] = v_[339] * v_[342];
    v_[347] = cos(x_in[15]);
    v_[348] = 0.33 * v_[347];
    v_[349] = sin(x_in[15]);
    v_[350] = -0.33 * v_[349];
    v_[351] = -0.207 + 0.33 * v_[349] * v_[5] * v_[2] + -0.33 * v_[349] * v_[28] * v_[7] + 0.35 * v_[349] * v_[5] + 0.08 * v_[349];
    v_[352] = -0.3735 + -0.33 * v_[5] * v_[7] - 0.33 * v_[28] * v_[2] - 0.35 * v_[28];
    v_[348] = (v_[348] * v_[5] * v_[7] + 0.33 * v_[347] * v_[28] * v_[2]) * x_in[35] + (v_[348] * v_[28] * v_[2] + 0.33 * v_[347] * v_[5] * v_[7] + 0.35 * v_[347] * v_[28]) * x_in[34] + (0.33 * v_[349] * v_[5] * v_[2] + v_[350] * v_[28] * v_[7] + 0.35 * v_[349] * v_[5] + 0.08 * v_[349]) * x_in[33] + x_in[23] + x_in[18] * v_[351] - x_in[19] * v_[352];
    v_[337] = v_[331] * v_[337];
    v_[333] = v_[333] * v_[338];
    v_[338] = v_[337] * v_[340] + v_[333] * v_[341];
    v_[331] = 2. * v_[338];
    v_[343] = v_[331] * v_[343];
    v_[333] = v_[337] * v_[341] - v_[333] * v_[340];
    v_[339] = v_[339] * v_[333];
    v_[337] = 0.33 * v_[347] * v_[28] * v_[7] - 0.33 * v_[347] * v_[5] * v_[2] - 0.35 * v_[347] * v_[5] - 0.08 * v_[347];
    v_[352] = (-0.33 * v_[349] * v_[5] * v_[7] - 0.33 * v_[349] * v_[28] * v_[2]) * x_in[35] + (v_[350] * v_[5] * v_[7] - 0.33 * v_[349] * v_[28] * v_[2] - 0.35 * v_[349] * v_[28]) * x_in[34] + (0.33 * v_[347] * v_[5] * v_[2] + -0.33 * v_[347] * v_[28] * v_[7] + 0.35 * v_[347] * v_[5] + 0.08 * v_[347]) * x_in[33] + x_in[22] + x_in[20] * v_[352] - x_in[18] * v_[337];
    v_[350] = v_[331] * v_[342];
    v_[340] = v_[344] * v_[333];
    v_[337] = (0.33 * v_[28] * v_[7] - 0.33 * v_[5] * v_[2]) * x_in[35] + (0.33 * v_[28] * v_[7] - 0.33 * v_[5] * v_[2] - 0.35 * v_[5]) * x_in[34] + x_in[21] + x_in[19] * v_[337] - x_in[20] * v_[351];
    v_[351] = 0.5 * x_in[0];
    v_[341] = cos(v_[351]);
    v_[353] = 0.5 * x_in[1];
    v_[354] = sin(v_[353]);
    v_[355] = v_[341] * v_[354];
    v_[356] = 0.5 * x_in[2];
    v_[357] = cos(v_[356]);
    v_[351] = sin(v_[351]);
    v_[353] = cos(v_[353]);
    v_[358] = v_[351] * v_[353];
    v_[356] = sin(v_[356]);
    v_[359] = v_[355] * v_[357] - v_[358] * v_[356];
    v_[360] = 2. * v_[359];
    v_[358] = v_[358] * v_[357] + v_[355] * v_[356];
    v_[355] = 2. * v_[358];
    v_[353] = v_[341] * v_[353];
    v_[354] = v_[351] * v_[354];
    v_[361] = 2. * (v_[353] * v_[356] + v_[354] * v_[357]);
    v_[354] = v_[353] * v_[357] - v_[354] * v_[356];
    v_[354] = (1 - v_[360] * v_[359] - v_[355] * v_[358]) * (0.33 * v_[347] * v_[28] * v_[7] - 0.33 * v_[347] * v_[5] * v_[2] - 0.35 * v_[347] * v_[5] - 0.08 * v_[347]) + (v_[361] * v_[359] + v_[355] * v_[354]) * (-0.207 + 0.33 * v_[349] * v_[5] * v_[2] + -0.33 * v_[349] * v_[28] * v_[7] + 0.35 * v_[349] * v_[5] + 0.08 * v_[349]) + (v_[361] * v_[358] - v_[360] * v_[354]) * (-0.3735 + -0.33 * v_[5] * v_[7] - 0.33 * v_[28] * v_[2] - 0.35 * v_[28]) + x_in[5];
    v_[361] = 1 / (1 + exp(100. * v_[354]));
    v_[354] = -1000. * ((1 - v_[345] - v_[346]) * v_[348] + (v_[343] + v_[339]) * v_[352] + (v_[350] - v_[340]) * v_[337]) * v_[361] + 5000. * exp(-100. * (v_[354] + 0.02));
    v_[335] = v_[336] * v_[335];
    v_[329] = v_[329] * v_[327];
    v_[338] = v_[331] * v_[338];
    v_[342] = v_[344] * v_[342];
    v_[333] = v_[331] * v_[333];
    v_[339] = -1000. * ((v_[343] - v_[339]) * v_[348] + (1 - v_[338] - v_[346]) * v_[352] + (v_[342] + v_[333]) * v_[337]) * v_[361];
    v_[343] = 2. * v_[330];
    v_[346] = v_[343] * v_[327];
    v_[331] = v_[336] * v_[332];
    v_[333] = -1000. * ((v_[350] + v_[340]) * v_[348] + (v_[342] - v_[333]) * v_[352] + (1 - v_[338] - v_[345]) * v_[337]) * v_[361];
    v_[342] = (v_[328] + v_[334]) * v_[354] + (1 - v_[335] - v_[329]) * v_[339] + (v_[346] - v_[331]) * v_[333];
    v_[338] = -0.207 + 0.33 * v_[48] * v_[5] * v_[2] + -0.33 * v_[48] * v_[28] * v_[7] + 0.35 * v_[48] * v_[5] + 0.08 * v_[48];
    v_[327] = v_[336] * v_[327];
    v_[332] = v_[343] * v_[332];
    v_[343] = v_[343] * v_[330];
    v_[331] = (v_[327] - v_[332]) * v_[354] + (v_[346] + v_[331]) * v_[339] + (1 - v_[335] - v_[343]) * v_[333];
    v_[346] = v_[326] * v_[342] - v_[338] * v_[331];
    v_[335] = 0.33 * v_[9] * v_[28] * v_[7] - 0.33 * v_[9] * v_[5] * v_[2] - 0.35 * v_[9] * v_[5] - 0.08 * v_[9];
    v_[343] = (1 - v_[343] - v_[329]) * v_[354] + (v_[328] - v_[334]) * v_[339] + (v_[327] + v_[332]) * v_[333];
    v_[326] = v_[335] * v_[331] - v_[326] * v_[343];
    v_[332] = 0 - v_[7];
    v_[327] = 0.35 * v_[2];
    v_[333] = v_[2] * v_[318] + v_[332] * v_[306] + v_[327] * v_[256];
    v_[322] = v_[324] * v_[322] - v_[314] * v_[333];
    v_[339] = 0.1104774 * (v_[320] - v_[323]) + 0.025941 * v_[325] - v_[48] * v_[346] - v_[9] * v_[326] - (-0.35 * v_[9] * v_[28] - 0.3735 * v_[9]) * v_[343] - (0.35 * v_[48] * v_[28] + 0.3735 * v_[48]) * v_[342] - (0.08 + 0.35 * v_[5] - 0.207 * v_[48]) * v_[331] - -0.0004405 * v_[322];
    v_[329] = x_in[47] - v_[339];
    v_[354] = v_[324] * v_[314];
    v_[334] = (0 - v_[319]) * x_in[35];
    v_[328] = v_[333] * x_in[35];
    v_[330] = v_[324] * x_in[35];
    v_[336] = v_[9] * v_[5];
    v_[361] = v_[9] * v_[28];
    v_[337] = v_[336] * v_[7] + v_[361] * v_[2];
    v_[340] = v_[48] * v_[28];
    v_[350] = v_[340] * v_[2];
    v_[352] = v_[28] * v_[7] - v_[5] * v_[2];
    v_[348] = v_[314] * v_[314];
    v_[345] = v_[321] * v_[321];
    v_[344] = -0.881 * (v_[323] - v_[320]) + 0.1104774 * v_[325] + 8.81e-05 * v_[354] + 0.414812462825713 * v_[334] + -0.00185880198235362 * v_[328] + -8.81e-05 * v_[330] + (0.1104774 * v_[329]) / 0.026181 - v_[337] * v_[343] - ((0 - v_[48]) * v_[5] * v_[7] - v_[350]) * v_[342] - v_[352] * v_[331] - -0.0004405 * (v_[348] + v_[345]);
    v_[314] = v_[321] * v_[314];
    v_[355] = (0 - v_[321]) * x_in[35];
    v_[361] = v_[361] * v_[7] - v_[336] * v_[2];
    v_[340] = v_[48] * v_[5] * v_[2] - v_[340] * v_[7];
    v_[336] = v_[28] * v_[2];
    v_[358] = v_[324] * v_[324];
    v_[348] = 0.881 * v_[322] + 8.81e-05 * v_[314] + -0.0004405 * v_[325] + -0.00185880198235362 * v_[334] + 0.880992588508842 * v_[328] + 8.81e-05 * v_[355] + (0.0004405 * v_[329]) / 0.026181 - v_[361] * v_[343] - v_[340] * v_[342] - ((0 - v_[5]) * v_[7] - v_[336]) * v_[331] - 0.1104774 * (v_[348] + v_[358]);
    v_[309] = v_[311] * v_[309] - v_[256] * v_[318];
    v_[325] = v_[311] * v_[256];
    v_[360] = v_[311] * v_[311];
    v_[359] = v_[308] * v_[308];
    v_[339] = 0.47422804 * (v_[307] - v_[310]) + 0.081641 * v_[312] + 2.1e-05 * v_[313] + (0.026181 * v_[329]) / 0.026181 + v_[339] + v_[327] * v_[344] + v_[0] * v_[348] - 0.0825825 * v_[309] - -0.000102 * v_[325] - -0.007418 * (v_[360] - v_[359]);
    v_[349] = x_in[46] - v_[339];
    v_[347] = (0 - v_[308]) * x_in[34];
    v_[353] = v_[311] * x_in[34];
    v_[356] = (0 - v_[306]) * x_in[34];
    v_[357] = v_[318] * x_in[34];
    v_[256] = v_[256] * v_[256];
    v_[310] = -3.146 * (v_[310] - v_[307]) + 0.47422804 * v_[312] + v_[2] * v_[344] + v_[7] * v_[348] + v_[14] * v_[347] + v_[27] * v_[353] + v_[39] * v_[356] + v_[38] * v_[357] + (v_[25] * v_[349]) / v_[16] - 0.0825825 * (v_[256] + v_[359]);
    v_[309] = 3.146 * v_[309] + 0.0825825 * v_[312] + v_[332] * v_[344] + v_[2] * v_[348] + v_[31] * v_[347] + v_[8] * v_[353] + v_[38] * v_[356] + v_[19] * v_[357] + (v_[23] * v_[349]) / v_[16] - 0.47422804 * (v_[256] + v_[360]);
    v_[348] = (0 - v_[237]) * x_in[33];
    v_[344] = v_[13] * x_in[33];
    v_[38] = (0 - v_[305]) * x_in[33];
    v_[19] = v_[215] * x_in[33];
    v_[307] = v_[237] * v_[13];
    v_[39] = v_[250] * v_[305];
    v_[294] = v_[237] * v_[294];
    v_[250] = v_[237] * v_[250];
    v_[335] = v_[338] * v_[343] - v_[335] * v_[342];
    v_[333] = v_[321] * v_[333] - v_[324] * v_[319];
    v_[352] = 8.81e-05 * v_[322] + 8.81e-05 * v_[328] + 0.026409 * v_[355] - v_[337] * v_[346] - ((0 - v_[48]) * v_[5] * v_[7] - v_[350]) * v_[326] - v_[352] * v_[335] - (((0.207 - 0.08 * v_[48]) * v_[28] + 0.3735 * v_[48] * v_[5]) * v_[7] + ((0.08 * v_[48] - 0.207) * v_[5] + 0.3735 * v_[48] * v_[28] + 0.35 * v_[48]) * v_[2]) * v_[343] - ((0.3735 * v_[9] * v_[5] - 0.08 * v_[9] * v_[28]) * v_[7] + (0.08 * v_[9] * v_[5] + 0.3735 * v_[9] * v_[28] + 0.35 * v_[9]) * v_[2]) * v_[342] - (-0.207 * v_[9] * v_[5] * v_[7] - 0.207 * v_[9] * v_[28] * v_[2]) * v_[331] - 0.1104774 * v_[333] - 0.025713 * v_[314];
    v_[335] = -0.0004405 * v_[333] + 8.81e-05 * (v_[323] - v_[320]) + -0.000227999999999999 * v_[354] + -8.81e-05 * v_[334] + 0.000468 * v_[330] - v_[361] * v_[346] - v_[340] * v_[326] - ((0 - v_[5]) * v_[7] - v_[336]) * v_[335] - (((0.08 * v_[48] - 0.207) * v_[5] + 0.3735 * v_[48] * v_[28] + 0.35 * v_[48]) * v_[7] + ((0.08 * v_[48] - 0.207) * v_[28] - 0.3735 * v_[48] * v_[5]) * v_[2]) * v_[343] - ((0.08 * v_[9] * v_[5] + 0.3735 * v_[9] * v_[28] + 0.35 * v_[9]) * v_[7] + (0.08 * v_[9] * v_[28] - 0.3735 * v_[9] * v_[5]) * v_[2]) * v_[342] - (0.207 * v_[9] * v_[5] * v_[2] - 0.207 * v_[9] * v_[28] * v_[7]) * v_[331];
    v_[333] = 0.881 * v_[333] + 0.1104774 * v_[314] + -0.0004405 * v_[354] + -0.1104774 * v_[355] + -0.0004405 * v_[330] - v_[48] * v_[343] - v_[9] * v_[342] - 8.81e-05 * (v_[358] + v_[345]);
    v_[318] = v_[308] * v_[318] - v_[311] * v_[306];
    v_[359] = -0.007418 * v_[325] + -0.000102 * (v_[256] - v_[359]) + v_[2] * v_[352] + v_[7] * v_[335] + -0.35 * v_[333] + v_[22] * v_[347] + v_[10] * v_[353] + v_[14] * v_[356] + v_[31] * v_[357] + (v_[6] * v_[349]) / v_[16] - 0.47422804 * v_[318] - 0.084376 * v_[313] - 2.1e-05 * v_[312];
    v_[335] = 0.002735 * v_[325] + 0.0825825 * v_[318] + -0.000102 * v_[312] + v_[11] * v_[352] + v_[2] * v_[335] + v_[10] * v_[347] + v_[1] * v_[353] + v_[27] * v_[356] + v_[8] * v_[357] + (v_[15] * v_[349]) / v_[16] - -0.007418 * v_[313] - 2.1e-05 * (v_[256] - v_[360]);
    v_[318] = 0.47422804 * v_[313] + 3.146 * v_[318] + 0.0825825 * v_[325] + v_[333] + v_[24] * v_[347] + v_[18] * v_[353];
    v_[333] = v_[13] * v_[13];
    v_[325] = 0.009466 * v_[307] + 0.1466472 * (v_[39] - v_[294]) + -5.1e-05 * v_[250] + v_[32] * v_[359] + v_[29] * v_[335] + 0.08 * v_[318] - -0.022734 * v_[144] - -3.6e-05 * (v_[333] - v_[257]);
    v_[313] = x_in[45] - v_[325];
    v_[305] = v_[237] * v_[215] - v_[13] * v_[305];
    v_[339] = 0.5824264 * v_[105] + -3.6e-05 * v_[144] + -0.022734 * (v_[72] - v_[257]) + (v_[16] * v_[349]) / v_[16] + v_[339] + v_[317] * v_[310] + v_[34] * v_[309] + v_[54] * v_[348] + v_[12] * v_[344] + v_[56] * v_[38] + v_[53] * v_[19] + (v_[74] * v_[313]) / v_[42] - 0.1466472 * v_[305] - -0.123672 * v_[250] - -5.1e-05 * v_[307];
    v_[335] = -0.133138 * v_[144] + 0.5824264 * (v_[294] - v_[39]) + -0.022734 * v_[307] + v_[29] * v_[359] + v_[5] * v_[335] + v_[12] * v_[348] + v_[36] * v_[344] + v_[66] * v_[38] + v_[46] * v_[19] + (v_[17] * v_[313]) / v_[42] - -3.6e-05 * v_[250] - -5.1e-05 * (v_[72] - v_[333]);
    v_[305] = 3.44 * v_[305] + 0.1466472 * v_[250] + v_[315] * v_[310] + v_[301] * v_[309] + v_[35] * v_[348] + v_[20] * v_[344] + v_[69] * v_[38] + v_[63] * v_[19] + (v_[43] * v_[313]) / v_[42] - 0.5824264 * (v_[333] + v_[257]);
    v_[318] = 0.1466472 * v_[307] + -3.44 * (v_[294] - v_[39]) + 0.5824264 * v_[144] + v_[318] + v_[56] * v_[348] + v_[66] * v_[344] + v_[68] * v_[38] + v_[57] * v_[19] + (v_[55] * v_[313]) / v_[42];
    v_[333] = 3.44 * v_[105] + 0.5824264 * v_[250] + v_[316] * v_[310] + v_[5] * v_[309] + v_[53] * v_[348] + v_[46] * v_[344] + v_[57] * v_[38] + v_[61] * v_[19] + (v_[44] * v_[313]) / v_[42] - 0.1466472 * (v_[72] + v_[333]);
    v_[250] = v_[26] * x_in[19] + v_[120] * x_in[20];
    v_[309] = 0.207 * x_in[20] + -1 * x_in[21];
    v_[310] = -1 * x_in[18] + x_in[30];
    v_[72] = 0.207 * v_[120];
    v_[105] = 0 - v_[37];
    v_[294] = v_[123] * x_in[20] + v_[122] * x_in[19] + v_[72] * x_in[18] + v_[120] * x_in[23] + v_[105] * x_in[22];
    v_[39] = v_[250] * v_[309] - v_[310] * v_[294];
    v_[307] = v_[250] * v_[310];
    v_[144] = v_[310] * v_[310];
    v_[257] = v_[121] * x_in[19] + v_[26] * x_in[20];
    v_[359] = v_[257] * v_[257];
    v_[12] = -0.08 * v_[76];
    v_[36] = v_[76] * v_[257] + v_[94] * v_[310];
    v_[54] = -0.08 * v_[310] + -1 * v_[294];
    v_[237] = v_[36] * v_[54];
    v_[215] = -1 * v_[250] + x_in[31];
    v_[13] = 0.3735 * v_[120];
    v_[24] = -0.3735 * v_[37];
    v_[18] = 0 - v_[37];
    v_[352] = 0 - v_[120];
    v_[256] = v_[13] * x_in[20] + v_[24] * x_in[19] + v_[118] * x_in[18] + v_[18] * x_in[23] + v_[352] * x_in[22];
    v_[360] = v_[94] * v_[309] + v_[76] * v_[256] + v_[104] * v_[250];
    v_[312] = v_[215] * v_[360];
    v_[1] = v_[95] * v_[257] + v_[76] * v_[310];
    v_[10] = v_[36] * v_[1];
    v_[8] = v_[79] * v_[36] + v_[77] * v_[1];
    v_[27] = -0.35 * v_[1] + v_[54];
    v_[11] = v_[8] * v_[27];
    v_[22] = v_[215] + x_in[32];
    v_[31] = 0 - v_[94];
    v_[14] = v_[76] * v_[309] + v_[31] * v_[256] + v_[12] * v_[250];
    v_[311] = v_[77] * v_[14] + v_[79] * v_[360] + v_[78] * v_[215];
    v_[308] = v_[22] * v_[311];
    v_[306] = v_[89] * v_[36] + v_[79] * v_[1];
    v_[358] = v_[8] * v_[306];
    v_[355] = (0 - v_[311]) * x_in[32];
    v_[314] = 0 - v_[77];
    v_[345] = 0.35 * v_[79];
    v_[330] = v_[79] * v_[14] + v_[314] * v_[360] + v_[345] * v_[215];
    v_[354] = v_[330] * x_in[32];
    v_[343] = -0.3735 + -0.33 * v_[76] * v_[77] - 0.33 * v_[94] * v_[79] - 0.35 * v_[94];
    v_[342] = 0.5 * x_in[0];
    v_[336] = cos(v_[342]);
    v_[340] = 0.5 * x_in[1];
    v_[361] = cos(v_[340]);
    v_[326] = v_[336] * v_[361];
    v_[346] = 0.5 * x_in[2];
    v_[331] = sin(v_[346]);
    v_[342] = sin(v_[342]);
    v_[340] = sin(v_[340]);
    v_[323] = v_[342] * v_[340];
    v_[346] = cos(v_[346]);
    v_[320] = v_[326] * v_[331] + v_[323] * v_[346];
    v_[28] = 2. * v_[320];
    v_[340] = v_[336] * v_[340];
    v_[342] = v_[342] * v_[361];
    v_[361] = v_[340] * v_[346] - v_[342] * v_[331];
    v_[336] = v_[28] * v_[361];
    v_[342] = v_[342] * v_[346] + v_[340] * v_[331];
    v_[340] = 2. * v_[342];
    v_[346] = v_[326] * v_[346] - v_[323] * v_[331];
    v_[323] = v_[340] * v_[346];
    v_[331] = 0.5 * x_in[0];
    v_[326] = cos(v_[331]);
    v_[350] = 0.5 * x_in[1];
    v_[337] = sin(v_[350]);
    v_[322] = v_[326] * v_[337];
    v_[324] = 0.5 * x_in[2];
    v_[321] = cos(v_[324]);
    v_[331] = sin(v_[331]);
    v_[350] = cos(v_[350]);
    v_[319] = v_[331] * v_[350];
    v_[324] = sin(v_[324]);
    v_[338] = v_[322] * v_[321] - v_[319] * v_[324];
    v_[362] = 2. * v_[338];
    v_[363] = v_[362] * v_[338];
    v_[319] = v_[319] * v_[321] + v_[322] * v_[324];
    v_[322] = 2. * v_[319];
    v_[364] = v_[322] * v_[319];
    v_[365] = 0.33 * v_[37];
    v_[366] = sin(x_in[12]);
    v_[367] = 0.207 + 0.33 * v_[366] * v_[94] * v_[77] - 0.33 * v_[366] * v_[76] * v_[79] - 0.35 * v_[366] * v_[76] - 0.08 * v_[366];
    v_[368] = -0.3735 + -0.33 * v_[76] * v_[77] - 0.33 * v_[94] * v_[79] - 0.35 * v_[94];
    v_[365] = (v_[365] * v_[76] * v_[77] + 0.33 * v_[37] * v_[94] * v_[79]) * x_in[32] + (v_[365] * v_[94] * v_[79] + 0.33 * v_[37] * v_[76] * v_[77] + 0.35 * v_[37] * v_[94]) * x_in[31] + (0.33 * v_[366] * v_[76] * v_[79] + -0.33 * v_[366] * v_[94] * v_[77] + 0.35 * v_[366] * v_[76] + 0.08 * v_[366]) * x_in[30] + x_in[23] + x_in[18] * v_[367] - x_in[19] * v_[368];
    v_[350] = v_[326] * v_[350];
    v_[331] = v_[331] * v_[337];
    v_[337] = v_[350] * v_[324] + v_[331] * v_[321];
    v_[326] = 2. * v_[337];
    v_[338] = v_[326] * v_[338];
    v_[331] = v_[350] * v_[321] - v_[331] * v_[324];
    v_[322] = v_[322] * v_[331];
    v_[350] = 0.33 * v_[366];
    v_[324] = 0.33 * v_[37] * v_[94] * v_[77] - 0.33 * v_[37] * v_[76] * v_[79] - 0.35 * v_[37] * v_[76] - 0.08 * v_[37];
    v_[350] = (v_[350] * v_[76] * v_[77] + 0.33 * v_[366] * v_[94] * v_[79]) * x_in[32] + (v_[350] * v_[94] * v_[79] + 0.33 * v_[366] * v_[76] * v_[77] + 0.35 * v_[366] * v_[94]) * x_in[31] + (0.33 * v_[37] * v_[94] * v_[77] - 0.33 * v_[37] * v_[76] * v_[79] - 0.35 * v_[37] * v_[76] - 0.08 * v_[37]) * x_in[30] + x_in[22] + x_in[20] * v_[368] - x_in[18] * v_[324];
    v_[368] = v_[326] * v_[319];
    v_[321] = v_[362] * v_[331];
    v_[324] = (0.33 * v_[94] * v_[77] - 0.33 * v_[76] * v_[79]) * x_in[32] + (0.33 * v_[94] * v_[77] - 0.33 * v_[76] * v_[79] - 0.35 * v_[76]) * x_in[31] + x_in[21] + x_in[19] * v_[324] - x_in[20] * v_[367];
    v_[367] = 0.5 * x_in[0];
    v_[369] = cos(v_[367]);
    v_[370] = 0.5 * x_in[1];
    v_[371] = sin(v_[370]);
    v_[372] = v_[369] * v_[371];
    v_[373] = 0.5 * x_in[2];
    v_[374] = cos(v_[373]);
    v_[367] = sin(v_[367]);
    v_[370] = cos(v_[370]);
    v_[375] = v_[367] * v_[370];
    v_[373] = sin(v_[373]);
    v_[376] = v_[372] * v_[374] - v_[375] * v_[373];
    v_[377] = 2. * v_[376];
    v_[375] = v_[375] * v_[374] + v_[372] * v_[373];
    v_[372] = 2. * v_[375];
    v_[370] = v_[369] * v_[370];
    v_[367] = v_[367] * v_[371];
    v_[371] = 2. * (v_[370] * v_[373] + v_[367] * v_[374]);
    v_[367] = v_[370] * v_[374] - v_[367] * v_[373];
    v_[367] = (1 - v_[377] * v_[376] - v_[372] * v_[375]) * (0.33 * v_[37] * v_[94] * v_[77] - 0.33 * v_[37] * v_[76] * v_[79] - 0.35 * v_[37] * v_[76] - 0.08 * v_[37]) + (v_[371] * v_[376] + v_[372] * v_[367]) * (0.207 + 0.33 * v_[366] * v_[94] * v_[77] - 0.33 * v_[366] * v_[76] * v_[79] - 0.35 * v_[366] * v_[76] - 0.08 * v_[366]) + (v_[371] * v_[375] - v_[377] * v_[367]) * (-0.3735 + -0.33 * v_[76] * v_[77] - 0.33 * v_[94] * v_[79] - 0.35 * v_[94]) + x_in[5];
    v_[371] = 1 / (1 + exp(100. * v_[367]));
    v_[367] = -1000. * ((1 - v_[363] - v_[364]) * v_[365] + (v_[338] + v_[322]) * v_[350] + (v_[368] - v_[321]) * v_[324]) * v_[371] + 5000. * exp(-100. * (v_[367] + 0.02));
    v_[320] = v_[28] * v_[320];
    v_[340] = v_[340] * v_[342];
    v_[337] = v_[326] * v_[337];
    v_[319] = v_[362] * v_[319];
    v_[331] = v_[326] * v_[331];
    v_[322] = -1000. * ((v_[338] - v_[322]) * v_[365] + (1 - v_[337] - v_[364]) * v_[350] + (v_[319] + v_[331]) * v_[324]) * v_[371];
    v_[338] = 2. * v_[361];
    v_[364] = v_[338] * v_[342];
    v_[326] = v_[28] * v_[346];
    v_[331] = -1000. * ((v_[368] + v_[321]) * v_[365] + (v_[319] - v_[331]) * v_[350] + (1 - v_[337] - v_[363]) * v_[324]) * v_[371];
    v_[319] = (v_[336] + v_[323]) * v_[367] + (1 - v_[320] - v_[340]) * v_[322] + (v_[364] - v_[326]) * v_[331];
    v_[337] = 0.207 + 0.33 * v_[120] * v_[94] * v_[77] - 0.33 * v_[120] * v_[76] * v_[79] - 0.35 * v_[120] * v_[76] - 0.08 * v_[120];
    v_[342] = v_[28] * v_[342];
    v_[346] = v_[338] * v_[346];
    v_[338] = v_[338] * v_[361];
    v_[326] = (v_[342] - v_[346]) * v_[367] + (v_[364] + v_[326]) * v_[322] + (1 - v_[320] - v_[338]) * v_[331];
    v_[364] = v_[343] * v_[319] - v_[337] * v_[326];
    v_[320] = 0.33 * v_[37] * v_[94] * v_[77] - 0.33 * v_[37] * v_[76] * v_[79] - 0.35 * v_[37] * v_[76] - 0.08 * v_[37];
    v_[338] = (1 - v_[338] - v_[340]) * v_[367] + (v_[336] - v_[323]) * v_[322] + (v_[342] + v_[346]) * v_[331];
    v_[343] = v_[320] * v_[326] - v_[343] * v_[338];
    v_[27] = v_[306] * v_[27] - v_[22] * v_[330];
    v_[346] = 0.110125 * (v_[308] - v_[11]) + 0.025941 * v_[358] - (0 - v_[120]) * v_[364] - v_[37] * v_[343] - (-0.35 * v_[37] * v_[94] - 0.3735 * v_[37]) * v_[338] - (-0.35 * v_[120] * v_[94] - 0.3735 * v_[120]) * v_[319] - (0.08 + 0.35 * v_[76] - 0.207 * v_[120]) * v_[326] - -0.000881 * v_[27];
    v_[342] = x_in[44] - v_[346];
    v_[331] = v_[37] * v_[76];
    v_[322] = v_[37] * v_[94];
    v_[340] = v_[331] * v_[77] + v_[322] * v_[79];
    v_[367] = v_[120] * v_[76];
    v_[323] = v_[120] * v_[94];
    v_[336] = v_[367] * v_[77] + v_[323] * v_[79];
    v_[361] = v_[94] * v_[77] - v_[76] * v_[79];
    v_[28] = v_[22] * v_[22];
    v_[308] = -0.881 * (v_[11] - v_[308]) + 0.110125 * v_[358] + 0.417781802643138 * v_[355] + -0.00370574557885489 * v_[354] + (0.110125 * v_[342]) / 0.026181 - v_[340] * v_[338] - v_[336] * v_[319] - v_[361] * v_[326] - -0.000881 * (v_[28] + v_[8] * v_[8]);
    v_[322] = v_[322] * v_[77] - v_[331] * v_[79];
    v_[323] = v_[323] * v_[77] - v_[367] * v_[79];
    v_[367] = v_[94] * v_[79];
    v_[28] = 0.881 * v_[27] + -0.000881 * v_[358] + -0.00370574557885489 * v_[355] + 0.880970354035369 * v_[354] + (0.000881 * v_[342]) / 0.026181 - v_[322] * v_[338] - v_[323] * v_[319] - ((0 - v_[76]) * v_[77] - v_[367]) * v_[326] - 0.110125 * (v_[28] + v_[306] * v_[306]);
    v_[27] = (0 - v_[36]) * x_in[31];
    v_[358] = v_[1] * x_in[31];
    v_[331] = (0 - v_[360]) * x_in[31];
    v_[11] = v_[14] * x_in[31];
    v_[371] = v_[36] * v_[215];
    v_[54] = v_[1] * v_[54] - v_[215] * v_[14];
    v_[324] = v_[1] * v_[215];
    v_[321] = v_[1] * v_[1];
    v_[368] = v_[36] * v_[36];
    v_[346] = 0.47422804 * (v_[312] - v_[237]) + 0.081641 * v_[10] + 2.1e-05 * v_[371] + (0.026181 * v_[342]) / 0.026181 + v_[346] + v_[345] * v_[308] + v_[78] * v_[28] - 0.0825825 * v_[54] - -0.000102 * v_[324] - -0.007418 * (v_[321] - v_[368]);
    v_[350] = x_in[43] - v_[346];
    v_[215] = v_[215] * v_[215];
    v_[312] = -3.146 * (v_[237] - v_[312]) + 0.47422804 * v_[10] + v_[79] * v_[308] + v_[77] * v_[28] + v_[96] * v_[27] + v_[93] * v_[358] + v_[110] * v_[331] + v_[109] * v_[11] + (v_[91] * v_[350]) / v_[81] - 0.0825825 * (v_[215] + v_[368]);
    v_[54] = 3.146 * v_[54] + 0.0825825 * v_[10] + v_[314] * v_[308] + v_[79] * v_[28] + v_[98] * v_[27] + v_[87] * v_[358] + v_[109] * v_[331] + v_[84] * v_[11] + (v_[88] * v_[350]) / v_[81] - 0.47422804 * (v_[215] + v_[321]);
    v_[28] = (0 - v_[257]) * x_in[30];
    v_[308] = v_[250] * x_in[30];
    v_[109] = (0 - v_[256]) * x_in[30];
    v_[84] = v_[294] * x_in[30];
    v_[237] = v_[257] * v_[250];
    v_[110] = v_[310] * v_[256];
    v_[309] = v_[257] * v_[309];
    v_[310] = v_[257] * v_[310];
    v_[365] = (0 - v_[8]) * x_in[32];
    v_[320] = v_[337] * v_[338] - v_[320] * v_[319];
    v_[337] = 0.207 * v_[37];
    v_[330] = v_[8] * v_[330] - v_[306] * v_[311];
    v_[8] = v_[8] * v_[22];
    v_[361] = 0.026409 * v_[365] - v_[340] * v_[364] - v_[336] * v_[343] - v_[361] * v_[320] - (((0.08 * v_[120] - 0.207) * v_[94] - 0.3735 * v_[120] * v_[76]) * v_[77] + ((0.207 - 0.08 * v_[120]) * v_[76] + -0.3735 * v_[120] * v_[94] - 0.35 * v_[120]) * v_[79]) * v_[338] - ((0.3735 * v_[37] * v_[76] - 0.08 * v_[37] * v_[94]) * v_[77] + (0.08 * v_[37] * v_[76] + 0.3735 * v_[37] * v_[94] + 0.35 * v_[37]) * v_[79]) * v_[319] - (v_[337] * v_[76] * v_[77] + 0.207 * v_[37] * v_[94] * v_[79]) * v_[326] - 0.110125 * v_[330] - 0.025713 * v_[8];
    v_[22] = v_[306] * v_[22];
    v_[306] = v_[306] * x_in[32];
    v_[337] = -0.000227999999999999 * v_[22] + -0.000881 * v_[330] + 0.000468 * v_[306] - v_[322] * v_[364] - v_[323] * v_[343] - ((0 - v_[76]) * v_[77] - v_[367]) * v_[320] - (((0.207 - 0.08 * v_[120]) * v_[76] + -0.3735 * v_[120] * v_[94] - 0.35 * v_[120]) * v_[77] + ((0.207 - 0.08 * v_[120]) * v_[94] + 0.3735 * v_[120] * v_[76]) * v_[79]) * v_[338] - ((0.08 * v_[37] * v_[76] + 0.3735 * v_[37] * v_[94] + 0.35 * v_[37]) * v_[77] + (0.08 * v_[37] * v_[94] - 0.3735 * v_[37] * v_[76]) * v_[79]) * v_[319] - (v_[337] * v_[94] * v_[77] - 0.207 * v_[37] * v_[76] * v_[79]) * v_[326];
    v_[306] = 0.110125 * v_[8] + 0.881 * v_[330] + -0.000881 * v_[22] + -0.110125 * v_[365] + -0.000881 * v_[306] - (0 - v_[120]) * v_[338] - v_[37] * v_[319];
    v_[14] = v_[36] * v_[14] - v_[1] * v_[360];
    v_[368] = -0.007418 * v_[324] + -0.000102 * (v_[215] - v_[368]) + v_[79] * v_[361] + v_[77] * v_[337] + -0.35 * v_[306] + v_[101] * v_[27] + v_[102] * v_[358] + v_[96] * v_[331] + v_[98] * v_[11] + (2.1e-05 * v_[350]) / v_[81] - 0.47422804 * v_[14] - 0.084376 * v_[371] - 2.1e-05 * v_[10];
    v_[337] = 0.002735 * v_[324] + 0.0825825 * v_[14] + -0.000102 * v_[10] + v_[89] * v_[361] + v_[79] * v_[337] + v_[102] * v_[27] + v_[100] * v_[358] + v_[93] * v_[331] + v_[87] * v_[11] + (-0.000102 * v_[350]) / v_[81] - -0.007418 * v_[371] - 2.1e-05 * (v_[215] - v_[321]);
    v_[14] = 0.47422804 * v_[371] + 3.146 * v_[14] + 0.0825825 * v_[324] + v_[306] + v_[90] * v_[27] + v_[83] * v_[358];
    v_[306] = v_[250] * v_[250];
    v_[324] = 0.009466 * v_[237] + 0.1466472 * (v_[110] - v_[309]) + -5.1e-05 * v_[310] + v_[76] * v_[368] + v_[94] * v_[337] + -0.08 * v_[14] - 0.022734 * v_[307] - 3.6e-05 * (v_[306] - v_[359]);
    v_[371] = x_in[42] - v_[324];
    v_[256] = v_[257] * v_[294] - v_[250] * v_[256];
    v_[346] = -0.5824264 * v_[39] + 3.6e-05 * v_[307] + 0.022734 * (v_[144] - v_[359]) + v_[12] * v_[312] + v_[104] * v_[54] + -1 * (v_[346] + (v_[81] * v_[350]) / v_[81]) + v_[126] * v_[28] + v_[80] * v_[308] + v_[128] * v_[109] + v_[125] * v_[84] + (v_[145] * v_[371]) / v_[113] - 0.1466472 * v_[256] - -0.123672 * v_[310] - -5.1e-05 * v_[237];
    v_[337] = -0.133138 * v_[307] + -0.5824264 * (v_[309] - v_[110]) + 0.022734 * v_[237] + v_[95] * v_[368] + v_[76] * v_[337] + v_[80] * v_[28] + v_[107] * v_[308] + v_[138] * v_[109] + v_[117] * v_[84] + (v_[82] * v_[371]) / v_[113] - 3.6e-05 * v_[310] - -5.1e-05 * (v_[144] - v_[306]);
    v_[256] = 3.44 * v_[256] + 0.1466472 * v_[310] + v_[76] * v_[312] + v_[94] * v_[54] + v_[106] * v_[28] + v_[85] * v_[308] + v_[141] * v_[109] + v_[135] * v_[84] + (v_[114] * v_[371]) / v_[113] - -0.5824264 * (v_[306] + v_[359]);
    v_[14] = 0.1466472 * v_[237] + -3.44 * (v_[309] - v_[110]) + -0.5824264 * v_[307] + -1 * v_[14] + v_[128] * v_[28] + v_[138] * v_[308] + v_[140] * v_[109] + v_[129] * v_[84] + (v_[127] * v_[371]) / v_[113];
    v_[306] = 3.44 * v_[39] + -0.5824264 * v_[310] + v_[31] * v_[312] + v_[76] * v_[54] + v_[125] * v_[28] + v_[117] * v_[308] + v_[129] * v_[109] + v_[133] * v_[84] + (v_[115] * v_[371]) / v_[113] - 0.1466472 * (v_[144] + v_[306]);
    v_[310] = v_[108] * x_in[19] + v_[191] * x_in[20];
    v_[54] = 0.207 * x_in[20] + x_in[21];
    v_[312] = x_in[18] + x_in[27];
    v_[144] = -0.207 * v_[191];
    v_[39] = v_[194] * x_in[20] + v_[192] * x_in[19] + v_[144] * x_in[18] + v_[191] * x_in[23] + v_[108] * x_in[22];
    v_[309] = v_[310] * v_[54] - v_[312] * v_[39];
    v_[110] = v_[310] * v_[312];
    v_[237] = v_[312] * v_[312];
    v_[307] = v_[191] * x_in[19] + v_[193] * x_in[20];
    v_[359] = v_[307] * v_[307];
    v_[368] = v_[310] + x_in[28];
    v_[80] = 0 - v_[171];
    v_[107] = 0.3735 * v_[191];
    v_[126] = 0.3735 * v_[108];
    v_[257] = 0 - v_[108];
    v_[294] = v_[107] * x_in[20] + v_[126] * x_in[19] + v_[190] * x_in[18] + v_[257] * x_in[23] + v_[191] * x_in[22];
    v_[250] = v_[80] * v_[54] + v_[92] * v_[294] + v_[177] * v_[310];
    v_[90] = v_[368] * v_[250];
    v_[83] = v_[92] * v_[307] + v_[172] * v_[312];
    v_[361] = 0.08 * v_[312] + v_[39];
    v_[215] = v_[83] * v_[361];
    v_[321] = v_[172] * v_[307] + v_[175] * v_[312];
    v_[10] = v_[83] * v_[321];
    v_[100] = v_[83] * v_[368];
    v_[102] = v_[368] + x_in[29];
    v_[87] = 0 - v_[92];
    v_[93] = 0 - v_[171];
    v_[89] = 0.08 * v_[92];
    v_[101] = v_[87] * v_[54] + v_[93] * v_[294] + v_[89] * v_[310];
    v_[98] = v_[149] * v_[101] + v_[147] * v_[250] + v_[152] * v_[368];
    v_[96] = v_[102] * v_[98];
    v_[1] = v_[147] * v_[83] + v_[149] * v_[321];
    v_[360] = -0.35 * v_[321] + v_[361];
    v_[36] = v_[1] * v_[360];
    v_[22] = v_[150] * v_[83] + v_[147] * v_[321];
    v_[8] = v_[1] * v_[22];
    v_[330] = 0.3735 + -0.33 * v_[92] * v_[149] - 0.33 * v_[171] * v_[147] - 0.35 * v_[171];
    v_[365] = 0.5 * x_in[0];
    v_[338] = cos(v_[365]);
    v_[319] = 0.5 * x_in[1];
    v_[37] = cos(v_[319]);
    v_[320] = v_[338] * v_[37];
    v_[367] = 0.5 * x_in[2];
    v_[323] = sin(v_[367]);
    v_[365] = sin(v_[365]);
    v_[319] = sin(v_[319]);
    v_[322] = v_[365] * v_[319];
    v_[367] = cos(v_[367]);
    v_[343] = v_[320] * v_[323] + v_[322] * v_[367];
    v_[364] = 2. * v_[343];
    v_[319] = v_[338] * v_[319];
    v_[365] = v_[365] * v_[37];
    v_[37] = v_[319] * v_[367] - v_[365] * v_[323];
    v_[338] = v_[364] * v_[37];
    v_[365] = v_[365] * v_[367] + v_[319] * v_[323];
    v_[319] = 2. * v_[365];
    v_[367] = v_[320] * v_[367] - v_[322] * v_[323];
    v_[322] = v_[319] * v_[367];
    v_[323] = 0.5 * x_in[1];
    v_[320] = sin(v_[323]);
    v_[326] = v_[341] * v_[320];
    v_[336] = 0.5 * x_in[2];
    v_[340] = cos(v_[336]);
    v_[323] = cos(v_[323]);
    v_[311] = v_[351] * v_[323];
    v_[336] = sin(v_[336]);
    v_[363] = v_[326] * v_[340] - v_[311] * v_[336];
    v_[362] = 2. * v_[363];
    v_[372] = v_[362] * v_[363];
    v_[311] = v_[311] * v_[340] + v_[326] * v_[336];
    v_[326] = 2. * v_[311];
    v_[375] = v_[326] * v_[311];
    v_[377] = 0.33 * v_[108];
    v_[376] = sin(x_in[11]);
    v_[366] = sin(x_in[10]);
    v_[370] = -0.33 * v_[191];
    v_[373] = -0.207 + 0.33 * v_[191] * v_[92] * v_[147] + -0.33 * v_[191] * v_[366] * v_[376] + 0.35 * v_[191] * v_[92] + 0.08 * v_[191];
    v_[374] = 0.3735 + -0.33 * v_[92] * v_[376] - 0.33 * v_[366] * v_[147] - 0.35 * v_[366];
    v_[377] = (v_[377] * v_[92] * v_[376] + 0.33 * v_[108] * v_[366] * v_[147]) * x_in[29] + (v_[377] * v_[366] * v_[147] + 0.33 * v_[108] * v_[92] * v_[376] + 0.35 * v_[108] * v_[366]) * x_in[28] + (0.33 * v_[191] * v_[92] * v_[147] + v_[370] * v_[366] * v_[376] + 0.35 * v_[191] * v_[92] + 0.08 * v_[191]) * x_in[27] + x_in[23] + x_in[18] * v_[373] - x_in[19] * v_[374];
    v_[323] = v_[341] * v_[323];
    v_[320] = v_[351] * v_[320];
    v_[351] = v_[323] * v_[336] + v_[320] * v_[340];
    v_[341] = 2. * v_[351];
    v_[363] = v_[341] * v_[363];
    v_[320] = v_[323] * v_[340] - v_[320] * v_[336];
    v_[326] = v_[326] * v_[320];
    v_[323] = 0.33 * v_[108] * v_[366] * v_[376] - 0.33 * v_[108] * v_[92] * v_[147] - 0.35 * v_[108] * v_[92] - 0.08 * v_[108];
    v_[374] = (-0.33 * v_[191] * v_[92] * v_[376] - 0.33 * v_[191] * v_[366] * v_[147]) * x_in[29] + (v_[370] * v_[92] * v_[376] - 0.33 * v_[191] * v_[366] * v_[147] - 0.35 * v_[191] * v_[366]) * x_in[28] + (0.33 * v_[108] * v_[92] * v_[147] + -0.33 * v_[108] * v_[366] * v_[376] + 0.35 * v_[108] * v_[92] + 0.08 * v_[108]) * x_in[27] + x_in[22] + x_in[20] * v_[374] - x_in[18] * v_[323];
    v_[370] = v_[341] * v_[311];
    v_[336] = v_[362] * v_[320];
    v_[323] = (0.33 * v_[366] * v_[376] - 0.33 * v_[92] * v_[147]) * x_in[29] + (0.33 * v_[366] * v_[376] - 0.33 * v_[92] * v_[147] - 0.35 * v_[92]) * x_in[28] + x_in[21] + x_in[19] * v_[323] - x_in[20] * v_[373];
    v_[373] = 0.5 * x_in[1];
    v_[340] = sin(v_[373]);
    v_[369] = v_[3] * v_[340];
    v_[378] = 0.5 * x_in[2];
    v_[379] = cos(v_[378]);
    v_[373] = cos(v_[373]);
    v_[380] = v_[4] * v_[373];
    v_[378] = sin(v_[378]);
    v_[381] = v_[369] * v_[379] - v_[380] * v_[378];
    v_[382] = 2. * v_[381];
    v_[380] = v_[380] * v_[379] + v_[369] * v_[378];
    v_[369] = 2. * v_[380];
    v_[373] = v_[3] * v_[373];
    v_[340] = v_[4] * v_[340];
    v_[4] = 2. * (v_[373] * v_[378] + v_[340] * v_[379]);
    v_[340] = v_[373] * v_[379] - v_[340] * v_[378];
    v_[340] = (1 - v_[382] * v_[381] - v_[369] * v_[380]) * (0.33 * v_[108] * v_[366] * v_[376] - 0.33 * v_[108] * v_[92] * v_[147] - 0.35 * v_[108] * v_[92] - 0.08 * v_[108]) + (v_[4] * v_[381] + v_[369] * v_[340]) * (-0.207 + 0.33 * v_[191] * v_[92] * v_[147] + -0.33 * v_[191] * v_[366] * v_[376] + 0.35 * v_[191] * v_[92] + 0.08 * v_[191]) + (v_[4] * v_[380] - v_[382] * v_[340]) * (0.3735 + -0.33 * v_[92] * v_[376] - 0.33 * v_[366] * v_[147] - 0.35 * v_[366]) + x_in[5];
    v_[4] = 1 / (1 + exp(100. * v_[340]));
    v_[340] = -1000. * ((1 - v_[372] - v_[375]) * v_[377] + (v_[363] + v_[326]) * v_[374] + (v_[370] - v_[336]) * v_[323]) * v_[4] + 5000. * exp(-100. * (v_[340] + 0.02));
    v_[343] = v_[364] * v_[343];
    v_[319] = v_[319] * v_[365];
    v_[351] = v_[341] * v_[351];
    v_[311] = v_[362] * v_[311];
    v_[320] = v_[341] * v_[320];
    v_[326] = -1000. * ((v_[363] - v_[326]) * v_[377] + (1 - v_[351] - v_[375]) * v_[374] + (v_[311] + v_[320]) * v_[323]) * v_[4];
    v_[363] = 2. * v_[37];
    v_[375] = v_[363] * v_[365];
    v_[341] = v_[364] * v_[367];
    v_[320] = -1000. * ((v_[370] + v_[336]) * v_[377] + (v_[311] - v_[320]) * v_[374] + (1 - v_[351] - v_[372]) * v_[323]) * v_[4];
    v_[311] = (v_[338] + v_[322]) * v_[340] + (1 - v_[343] - v_[319]) * v_[326] + (v_[375] - v_[341]) * v_[320];
    v_[351] = -0.207 + 0.33 * v_[191] * v_[92] * v_[147] + -0.33 * v_[191] * v_[171] * v_[149] + 0.35 * v_[191] * v_[92] + 0.08 * v_[191];
    v_[365] = v_[364] * v_[365];
    v_[367] = v_[363] * v_[367];
    v_[363] = v_[363] * v_[37];
    v_[341] = (v_[365] - v_[367]) * v_[340] + (v_[375] + v_[341]) * v_[326] + (1 - v_[343] - v_[363]) * v_[320];
    v_[375] = v_[330] * v_[311] - v_[351] * v_[341];
    v_[343] = 0.33 * v_[108] * v_[171] * v_[149] - 0.33 * v_[108] * v_[92] * v_[147] - 0.35 * v_[108] * v_[92] - 0.08 * v_[108];
    v_[363] = (1 - v_[363] - v_[319]) * v_[340] + (v_[338] - v_[322]) * v_[326] + (v_[365] + v_[367]) * v_[320];
    v_[330] = v_[343] * v_[341] - v_[330] * v_[363];
    v_[367] = 0 - v_[149];
    v_[365] = 0.35 * v_[147];
    v_[320] = v_[147] * v_[101] + v_[367] * v_[250] + v_[365] * v_[368];
    v_[360] = v_[22] * v_[360] - v_[102] * v_[320];
    v_[326] = 0.1104774 * (v_[96] - v_[36]) + 0.025941 * v_[8] - v_[191] * v_[375] - v_[108] * v_[330] - (0.3735 * v_[108] - 0.35 * v_[108] * v_[171]) * v_[363] - (0.35 * v_[191] * v_[171] - 0.3735 * v_[191]) * v_[311] - (0.08 + 0.35 * v_[92] - 0.207 * v_[191]) * v_[341] - 0.0004405 * v_[360];
    v_[319] = x_in[41] - v_[326];
    v_[340] = v_[22] * v_[102];
    v_[322] = (0 - v_[98]) * x_in[29];
    v_[338] = v_[320] * x_in[29];
    v_[37] = v_[22] * x_in[29];
    v_[364] = v_[108] * v_[92];
    v_[4] = v_[108] * v_[171];
    v_[323] = v_[364] * v_[149] + v_[4] * v_[147];
    v_[336] = v_[191] * v_[171];
    v_[370] = v_[336] * v_[147];
    v_[374] = v_[171] * v_[149] - v_[92] * v_[147];
    v_[377] = v_[102] * v_[102];
    v_[372] = v_[1] * v_[1];
    v_[362] = -0.881 * (v_[36] - v_[96]) + 0.1104774 * v_[8] + -8.81e-05 * v_[340] + 0.414812462825713 * v_[322] + 0.00185880198235362 * v_[338] + 8.81e-05 * v_[37] + (0.1104774 * v_[319]) / 0.026181 - v_[323] * v_[363] - ((0 - v_[191]) * v_[92] * v_[149] - v_[370]) * v_[311] - v_[374] * v_[341] - 0.0004405 * (v_[377] + v_[372]);
    v_[102] = v_[1] * v_[102];
    v_[369] = (0 - v_[1]) * x_in[29];
    v_[4] = v_[4] * v_[149] - v_[364] * v_[147];
    v_[336] = v_[191] * v_[92] * v_[147] - v_[336] * v_[149];
    v_[364] = (0 - v_[92]) * v_[149] - v_[171] * v_[147];
    v_[380] = v_[22] * v_[22];
    v_[377] = 0.881 * v_[360] + -8.81e-05 * v_[102] + 0.0004405 * v_[8] + 0.00185880198235362 * v_[322] + 0.880992588508842 * v_[338] + -8.81e-05 * v_[369] + (-0.0004405 * v_[319]) / 0.026181 - v_[4] * v_[363] - v_[336] * v_[311] - v_[364] * v_[341] - 0.1104774 * (v_[377] + v_[380]);
    v_[361] = v_[321] * v_[361] - v_[368] * v_[101];
    v_[8] = v_[321] * v_[368];
    v_[382] = v_[321] * v_[321];
    v_[381] = v_[83] * v_[83];
    v_[326] = 0.47422804 * (v_[90] - v_[215]) + 0.081641 * v_[10] + 2.1e-05 * v_[100] + (0.026181 * v_[319]) / 0.026181 + v_[326] + v_[365] * v_[362] + v_[152] * v_[377] - -0.0825825 * v_[361] - 0.000102 * v_[8] - 0.007418 * (v_[382] - v_[381]);
    v_[366] = x_in[40] - v_[326];
    v_[376] = (0 - v_[83]) * x_in[28];
    v_[373] = v_[321] * x_in[28];
    v_[378] = (0 - v_[250]) * x_in[28];
    v_[379] = v_[101] * x_in[28];
    v_[368] = v_[368] * v_[368];
    v_[215] = -3.146 * (v_[215] - v_[90]) + 0.47422804 * v_[10] + v_[147] * v_[362] + v_[149] * v_[377] + v_[157] * v_[376] + v_[170] * v_[373] + v_[182] * v_[378] + v_[181] * v_[379] + (v_[168] * v_[366]) / v_[159] - -0.0825825 * (v_[368] + v_[381]);
    v_[361] = 3.146 * v_[361] + -0.0825825 * v_[10] + v_[367] * v_[362] + v_[147] * v_[377] + v_[174] * v_[376] + v_[151] * v_[373] + v_[181] * v_[378] + v_[162] * v_[379] + (v_[166] * v_[366]) / v_[159] - 0.47422804 * (v_[368] + v_[382]);
    v_[377] = (0 - v_[307]) * x_in[27];
    v_[362] = v_[310] * x_in[27];
    v_[181] = (0 - v_[294]) * x_in[27];
    v_[162] = v_[39] * x_in[27];
    v_[90] = v_[307] * v_[310];
    v_[182] = v_[312] * v_[294];
    v_[54] = v_[307] * v_[54];
    v_[312] = v_[307] * v_[312];
    v_[343] = v_[351] * v_[363] - v_[343] * v_[311];
    v_[320] = v_[1] * v_[320] - v_[22] * v_[98];
    v_[374] = -8.81e-05 * v_[360] + -8.81e-05 * v_[338] + 0.026409 * v_[369] - v_[323] * v_[375] - ((0 - v_[191]) * v_[92] * v_[149] - v_[370]) * v_[330] - v_[374] * v_[343] - (((0.207 - 0.08 * v_[191]) * v_[171] - 0.3735 * v_[191] * v_[92]) * v_[149] + ((0.08 * v_[191] - 0.207) * v_[92] + -0.3735 * v_[191] * v_[171] + 0.35 * v_[191]) * v_[147]) * v_[363] - ((-0.08 * v_[108] * v_[171] - 0.3735 * v_[108] * v_[92]) * v_[149] + (0.08 * v_[108] * v_[92] + -0.3735 * v_[108] * v_[171] + 0.35 * v_[108]) * v_[147]) * v_[311] - (-0.207 * v_[108] * v_[92] * v_[149] - 0.207 * v_[108] * v_[171] * v_[147]) * v_[341] - 0.1104774 * v_[320] - 0.025713 * v_[102];
    v_[343] = 0.0004405 * v_[320] + -8.81e-05 * (v_[36] - v_[96]) + -0.000227999999999999 * v_[340] + 8.81e-05 * v_[322] + 0.000468 * v_[37] - v_[4] * v_[375] - v_[336] * v_[330] - v_[364] * v_[343] - (((0.08 * v_[191] - 0.207) * v_[92] + -0.3735 * v_[191] * v_[171] + 0.35 * v_[191]) * v_[149] + ((0.08 * v_[191] - 0.207) * v_[171] + 0.3735 * v_[191] * v_[92]) * v_[147]) * v_[363] - ((0.08 * v_[108] * v_[92] + -0.3735 * v_[108] * v_[171] + 0.35 * v_[108]) * v_[149] + (0.08 * v_[108] * v_[171] + 0.3735 * v_[108] * v_[92]) * v_[147]) * v_[311] - (0.207 * v_[108] * v_[92] * v_[147] - 0.207 * v_[108] * v_[171] * v_[149]) * v_[341];
    v_[320] = 0.881 * v_[320] + 0.1104774 * v_[102] + 0.0004405 * v_[340] + -0.1104774 * v_[369] + 0.0004405 * v_[37] - v_[191] * v_[363] - v_[108] * v_[311] - -8.81e-05 * (v_[380] + v_[372]);
    v_[101] = v_[83] * v_[101] - v_[321] * v_[250];
    v_[381] = 0.007418 * v_[8] + 0.000102 * (v_[368] - v_[381]) + v_[147] * v_[374] + v_[149] * v_[343] + -0.35 * v_[320] + v_[165] * v_[376] + v_[154] * v_[373] + v_[157] * v_[378] + v_[174] * v_[379] + (v_[153] * v_[366]) / v_[159] - 0.47422804 * v_[101] - 0.084376 * v_[100] - 2.1e-05 * v_[10];
    v_[343] = 0.002735 * v_[8] + -0.0825825 * v_[101] + 0.000102 * v_[10] + v_[150] * v_[374] + v_[147] * v_[343] + v_[154] * v_[376] + v_[148] * v_[373] + v_[170] * v_[378] + v_[151] * v_[379] + (v_[158] * v_[366]) / v_[159] - 0.007418 * v_[100] - 2.1e-05 * (v_[368] - v_[382]);
    v_[101] = 0.47422804 * v_[100] + 3.146 * v_[101] + -0.0825825 * v_[8] + v_[320] + v_[167] * v_[376] + v_[161] * v_[373];
    v_[320] = v_[310] * v_[310];
    v_[8] = 0.009466 * v_[90] + 0.1466472 * (v_[182] - v_[54]) + -5.1e-05 * v_[312] + v_[175] * v_[381] + v_[172] * v_[343] + 0.08 * v_[101] - 0.022734 * v_[110] - 3.6e-05 * (v_[320] - v_[359]);
    v_[100] = x_in[39] - v_[8];
    v_[294] = v_[307] * v_[39] - v_[310] * v_[294];
    v_[326] = -0.5824264 * v_[309] + 3.6e-05 * v_[110] + 0.022734 * (v_[237] - v_[359]) + (v_[159] * v_[366]) / v_[159] + v_[326] + v_[89] * v_[215] + v_[177] * v_[361] + v_[197] * v_[377] + v_[155] * v_[362] + v_[199] * v_[181] + v_[196] * v_[162] + (v_[217] * v_[100]) / v_[185] - 0.1466472 * v_[294] - -0.123672 * v_[312] - -5.1e-05 * v_[90];
    v_[343] = -0.133138 * v_[110] + -0.5824264 * (v_[54] - v_[182]) + 0.022734 * v_[90] + v_[172] * v_[381] + v_[92] * v_[343] + v_[155] * v_[377] + v_[179] * v_[362] + v_[209] * v_[181] + v_[189] * v_[162] + (v_[160] * v_[100]) / v_[185] - 3.6e-05 * v_[312] - -5.1e-05 * (v_[237] - v_[320]);
    v_[294] = 3.44 * v_[294] + 0.1466472 * v_[312] + v_[87] * v_[215] + v_[80] * v_[361] + v_[178] * v_[377] + v_[163] * v_[362] + v_[212] * v_[181] + v_[206] * v_[162] + (v_[186] * v_[100]) / v_[185] - -0.5824264 * (v_[320] + v_[359]);
    v_[101] = 0.1466472 * v_[90] + -3.44 * (v_[54] - v_[182]) + -0.5824264 * v_[110] + v_[101] + v_[199] * v_[377] + v_[209] * v_[362] + v_[211] * v_[181] + v_[200] * v_[162] + (v_[198] * v_[100]) / v_[185];
    v_[320] = 3.44 * v_[309] + -0.5824264 * v_[312] + v_[93] * v_[215] + v_[92] * v_[361] + v_[196] * v_[377] + v_[189] * v_[362] + v_[200] * v_[181] + v_[204] * v_[162] + (v_[187] * v_[100]) / v_[185] - 0.1466472 * (v_[237] + v_[320]);
    v_[312] = v_[169] * x_in[19] + v_[265] * x_in[20];
    v_[361] = 0.207 * x_in[20] + -1 * x_in[21];
    v_[215] = -1 * x_in[18] + x_in[24];
    v_[237] = 0.207 * v_[265];
    v_[309] = 0 - v_[180];
    v_[54] = v_[268] * x_in[20] + v_[267] * x_in[19] + v_[237] * x_in[18] + v_[265] * x_in[23] + v_[309] * x_in[22];
    v_[182] = v_[312] * v_[361] - v_[215] * v_[54];
    v_[90] = v_[312] * v_[215];
    v_[110] = v_[215] * v_[215];
    v_[359] = v_[266] * x_in[19] + v_[169] * x_in[20];
    v_[381] = v_[359] * v_[359];
    v_[155] = -0.08 * v_[219];
    v_[179] = v_[219] * v_[359] + v_[244] * v_[215];
    v_[197] = -0.08 * v_[215] + -1 * v_[54];
    v_[307] = v_[179] * v_[197];
    v_[39] = -1 * v_[312] + x_in[25];
    v_[310] = -0.3735 * v_[265];
    v_[167] = 0.3735 * v_[180];
    v_[161] = 0 - v_[180];
    v_[374] = 0 - v_[265];
    v_[368] = v_[310] * x_in[20] + v_[167] * x_in[19] + v_[263] * x_in[18] + v_[161] * x_in[23] + v_[374] * x_in[22];
    v_[382] = v_[244] * v_[361] + v_[219] * v_[368] + v_[249] * v_[312];
    v_[10] = v_[39] * v_[382];
    v_[148] = v_[245] * v_[359] + v_[219] * v_[215];
    v_[154] = v_[179] * v_[148];
    v_[151] = v_[220] * v_[179] + v_[222] * v_[148];
    v_[170] = -0.35 * v_[148] + v_[197];
    v_[150] = v_[151] * v_[170];
    v_[165] = v_[39] + x_in[26];
    v_[174] = 0 - v_[244];
    v_[157] = v_[219] * v_[361] + v_[174] * v_[368] + v_[155] * v_[312];
    v_[321] = v_[222] * v_[157] + v_[220] * v_[382] + v_[225] * v_[39];
    v_[83] = v_[165] * v_[321];
    v_[250] = v_[223] * v_[179] + v_[220] * v_[148];
    v_[380] = v_[151] * v_[250];
    v_[369] = v_[250] * v_[165];
    v_[102] = (0 - v_[321]) * x_in[26];
    v_[372] = 0 - v_[222];
    v_[37] = 0.35 * v_[220];
    v_[340] = v_[220] * v_[157] + v_[372] * v_[382] + v_[37] * v_[39];
    v_[363] = v_[340] * x_in[26];
    v_[311] = v_[250] * x_in[26];
    v_[364] = 0.3735 + -0.33 * v_[219] * v_[222] - 0.33 * v_[244] * v_[220] - 0.35 * v_[244];
    v_[336] = 0.5 * x_in[0];
    v_[4] = cos(v_[336]);
    v_[330] = 0.5 * x_in[1];
    v_[375] = cos(v_[330]);
    v_[341] = v_[4] * v_[375];
    v_[36] = 0.5 * x_in[2];
    v_[96] = sin(v_[36]);
    v_[336] = sin(v_[336]);
    v_[330] = sin(v_[330]);
    v_[171] = v_[336] * v_[330];
    v_[36] = cos(v_[36]);
    v_[370] = v_[341] * v_[96] + v_[171] * v_[36];
    v_[323] = 2. * v_[370];
    v_[330] = v_[4] * v_[330];
    v_[336] = v_[336] * v_[375];
    v_[375] = v_[330] * v_[36] - v_[336] * v_[96];
    v_[4] = v_[323] * v_[375];
    v_[336] = v_[336] * v_[36] + v_[330] * v_[96];
    v_[330] = 2. * v_[336];
    v_[36] = v_[341] * v_[36] - v_[171] * v_[96];
    v_[171] = v_[330] * v_[36];
    v_[96] = 0.5 * x_in[0];
    v_[341] = cos(v_[96]);
    v_[360] = 0.5 * x_in[1];
    v_[22] = sin(v_[360]);
    v_[1] = v_[341] * v_[22];
    v_[98] = 0.5 * x_in[2];
    v_[351] = cos(v_[98]);
    v_[96] = sin(v_[96]);
    v_[360] = cos(v_[360]);
    v_[3] = v_[96] * v_[360];
    v_[98] = sin(v_[98]);
    v_[383] = v_[1] * v_[351] - v_[3] * v_[98];
    v_[384] = 2. * v_[383];
    v_[385] = v_[384] * v_[383];
    v_[3] = v_[3] * v_[351] + v_[1] * v_[98];
    v_[1] = 2. * v_[3];
    v_[386] = v_[1] * v_[3];
    v_[387] = 0.33 * v_[180];
    v_[388] = sin(x_in[8]);
    v_[389] = sin(x_in[7]);
    v_[390] = sin(x_in[6]);
    v_[391] = 0.207 + 0.33 * v_[390] * v_[389] * v_[388] - 0.33 * v_[390] * v_[219] * v_[220] - 0.35 * v_[390] * v_[219] - 0.08 * v_[390];
    v_[392] = 0.3735 + -0.33 * v_[219] * v_[388] - 0.33 * v_[389] * v_[220] - 0.35 * v_[389];
    v_[387] = (v_[387] * v_[219] * v_[388] + 0.33 * v_[180] * v_[389] * v_[220]) * x_in[26] + (v_[387] * v_[389] * v_[220] + 0.33 * v_[180] * v_[219] * v_[388] + 0.35 * v_[180] * v_[389]) * x_in[25] + (0.33 * v_[390] * v_[219] * v_[220] + -0.33 * v_[390] * v_[389] * v_[388] + 0.35 * v_[390] * v_[219] + 0.08 * v_[390]) * x_in[24] + x_in[23] + x_in[18] * v_[391] - x_in[19] * v_[392];
    v_[360] = v_[341] * v_[360];
    v_[96] = v_[96] * v_[22];
    v_[22] = v_[360] * v_[98] + v_[96] * v_[351];
    v_[341] = 2. * v_[22];
    v_[383] = v_[341] * v_[383];
    v_[96] = v_[360] * v_[351] - v_[96] * v_[98];
    v_[1] = v_[1] * v_[96];
    v_[360] = 0.33 * v_[390];
    v_[98] = 0.33 * v_[180] * v_[389] * v_[388] - 0.33 * v_[180] * v_[219] * v_[220] - 0.35 * v_[180] * v_[219] - 0.08 * v_[180];
    v_[360] = (v_[360] * v_[219] * v_[388] + 0.33 * v_[390] * v_[389] * v_[220]) * x_in[26] + (v_[360] * v_[389] * v_[220] + 0.33 * v_[390] * v_[219] * v_[388] + 0.35 * v_[390] * v_[389]) * x_in[25] + (0.33 * v_[180] * v_[389] * v_[388] - 0.33 * v_[180] * v_[219] * v_[220] - 0.35 * v_[180] * v_[219] - 0.08 * v_[180]) * x_in[24] + x_in[22] + x_in[20] * v_[392] - x_in[18] * v_[98];
    v_[392] = v_[341] * v_[3];
    v_[351] = v_[384] * v_[96];
    v_[98] = (0.33 * v_[389] * v_[388] - 0.33 * v_[219] * v_[220]) * x_in[26] + (0.33 * v_[389] * v_[388] - 0.33 * v_[219] * v_[220] - 0.35 * v_[219]) * x_in[25] + x_in[21] + x_in[19] * v_[98] - x_in[20] * v_[391];
    v_[391] = 0.5 * x_in[0];
    v_[393] = cos(v_[391]);
    v_[394] = 0.5 * x_in[1];
    v_[395] = sin(v_[394]);
    v_[396] = v_[393] * v_[395];
    v_[397] = 0.5 * x_in[2];
    v_[398] = cos(v_[397]);
    v_[391] = sin(v_[391]);
    v_[394] = cos(v_[394]);
    v_[399] = v_[391] * v_[394];
    v_[397] = sin(v_[397]);
    v_[400] = v_[396] * v_[398] - v_[399] * v_[397];
    v_[401] = 2. * v_[400];
    v_[399] = v_[399] * v_[398] + v_[396] * v_[397];
    v_[396] = 2. * v_[399];
    v_[394] = v_[393] * v_[394];
    v_[391] = v_[391] * v_[395];
    v_[395] = 2. * (v_[394] * v_[397] + v_[391] * v_[398]);
    v_[391] = v_[394] * v_[398] - v_[391] * v_[397];
    v_[391] = (1 - v_[401] * v_[400] - v_[396] * v_[399]) * (0.33 * v_[180] * v_[389] * v_[388] - 0.33 * v_[180] * v_[219] * v_[220] - 0.35 * v_[180] * v_[219] - 0.08 * v_[180]) + (v_[395] * v_[400] + v_[396] * v_[391]) * (0.207 + 0.33 * v_[390] * v_[389] * v_[388] - 0.33 * v_[390] * v_[219] * v_[220] - 0.35 * v_[390] * v_[219] - 0.08 * v_[390]) + (v_[395] * v_[399] - v_[401] * v_[391]) * (0.3735 + -0.33 * v_[219] * v_[388] - 0.33 * v_[389] * v_[220] - 0.35 * v_[389]) + x_in[5];
    v_[395] = 1 / (1 + exp(100. * v_[391]));
    v_[391] = -1000. * ((1 - v_[385] - v_[386]) * v_[387] + (v_[383] + v_[1]) * v_[360] + (v_[392] - v_[351]) * v_[98]) * v_[395] + 5000. * exp(-100. * (v_[391] + 0.02));
    v_[370] = v_[323] * v_[370];
    v_[330] = v_[330] * v_[336];
    v_[22] = v_[341] * v_[22];
    v_[3] = v_[384] * v_[3];
    v_[96] = v_[341] * v_[96];
    v_[1] = -1000. * ((v_[383] - v_[1]) * v_[387] + (1 - v_[22] - v_[386]) * v_[360] + (v_[3] + v_[96]) * v_[98]) * v_[395];
    v_[383] = 2. * v_[375];
    v_[386] = v_[383] * v_[336];
    v_[341] = v_[323] * v_[36];
    v_[96] = -1000. * ((v_[392] + v_[351]) * v_[387] + (v_[3] - v_[96]) * v_[360] + (1 - v_[22] - v_[385]) * v_[98]) * v_[395];
    v_[3] = (v_[4] + v_[171]) * v_[391] + (1 - v_[370] - v_[330]) * v_[1] + (v_[386] - v_[341]) * v_[96];
    v_[22] = 0.207 + 0.33 * v_[265] * v_[244] * v_[222] - 0.33 * v_[265] * v_[219] * v_[220] - 0.35 * v_[265] * v_[219] - 0.08 * v_[265];
    v_[336] = v_[323] * v_[336];
    v_[36] = v_[383] * v_[36];
    v_[383] = v_[383] * v_[375];
    v_[341] = (v_[336] - v_[36]) * v_[391] + (v_[386] + v_[341]) * v_[1] + (1 - v_[370] - v_[383]) * v_[96];
    v_[386] = v_[364] * v_[3] - v_[22] * v_[341];
    v_[370] = 0.33 * v_[180] * v_[244] * v_[222] - 0.33 * v_[180] * v_[219] * v_[220] - 0.35 * v_[180] * v_[219] - 0.08 * v_[180];
    v_[383] = (1 - v_[383] - v_[330]) * v_[391] + (v_[4] - v_[171]) * v_[1] + (v_[336] + v_[36]) * v_[96];
    v_[364] = v_[370] * v_[341] - v_[364] * v_[383];
    v_[170] = v_[250] * v_[170] - v_[165] * v_[340];
    v_[36] = 0.1104774 * (v_[83] - v_[150]) + 0.025941 * v_[380] - (0 - v_[265]) * v_[386] - v_[180] * v_[364] - (0.3735 * v_[180] - 0.35 * v_[180] * v_[244]) * v_[383] - (0.3735 * v_[265] - 0.35 * v_[265] * v_[244]) * v_[3] - (0.08 + 0.35 * v_[219] - 0.207 * v_[265]) * v_[341] - 0.0004405 * v_[170];
    v_[336] = x_in[38] - v_[36];
    v_[96] = v_[180] * v_[219];
    v_[1] = v_[180] * v_[244];
    v_[330] = v_[96] * v_[222] + v_[1] * v_[220];
    v_[391] = v_[265] * v_[219];
    v_[171] = v_[265] * v_[244];
    v_[4] = v_[171] * v_[220];
    v_[375] = v_[244] * v_[222] - v_[219] * v_[220];
    v_[323] = v_[165] * v_[165];
    v_[395] = v_[151] * v_[151];
    v_[98] = -0.881 * (v_[150] - v_[83]) + 0.1104774 * v_[380] + -8.81e-05 * v_[369] + 0.414812462825713 * v_[102] + 0.00185880198235362 * v_[363] + 8.81e-05 * v_[311] + (0.1104774 * v_[336]) / 0.026181 - v_[330] * v_[383] - (v_[391] * v_[222] + v_[4]) * v_[3] - v_[375] * v_[341] - 0.0004405 * (v_[323] + v_[395]);
    v_[165] = v_[151] * v_[165];
    v_[351] = (0 - v_[151]) * x_in[26];
    v_[1] = v_[1] * v_[222] - v_[96] * v_[220];
    v_[171] = v_[171] * v_[222];
    v_[96] = v_[250] * v_[250];
    v_[323] = 0.881 * v_[170] + -8.81e-05 * v_[165] + 0.0004405 * v_[380] + 0.00185880198235362 * v_[102] + 0.880992588508842 * v_[363] + -8.81e-05 * v_[351] + (-0.0004405 * v_[336]) / 0.026181 - v_[1] * v_[383] - (v_[171] - v_[391] * v_[220]) * v_[3] - ((0 - v_[219]) * v_[222] - v_[244] * v_[220]) * v_[341] - 0.1104774 * (v_[323] + v_[96]);
    v_[391] = (0 - v_[179]) * x_in[25];
    v_[380] = v_[148] * x_in[25];
    v_[392] = (0 - v_[382]) * x_in[25];
    v_[360] = v_[157] * x_in[25];
    v_[387] = v_[179] * v_[39];
    v_[197] = v_[148] * v_[197] - v_[39] * v_[157];
    v_[385] = v_[148] * v_[39];
    v_[384] = v_[148] * v_[148];
    v_[396] = v_[179] * v_[179];
    v_[36] = 0.47422804 * (v_[10] - v_[307]) + 0.081641 * v_[154] + 2.1e-05 * v_[387] + (0.026181 * v_[336]) / 0.026181 + v_[36] + v_[37] * v_[98] + v_[225] * v_[323] - -0.0825825 * v_[197] - 0.000102 * v_[385] - 0.007418 * (v_[384] - v_[396]);
    v_[399] = x_in[37] - v_[36];
    v_[39] = v_[39] * v_[39];
    v_[10] = -3.146 * (v_[307] - v_[10]) + 0.47422804 * v_[154] + v_[220] * v_[98] + v_[222] * v_[323] + v_[230] * v_[391] + v_[243] * v_[380] + v_[255] * v_[392] + v_[254] * v_[360] + (v_[241] * v_[399]) / v_[232] - -0.0825825 * (v_[39] + v_[396]);
    v_[197] = 3.146 * v_[197] + -0.0825825 * v_[154] + v_[372] * v_[98] + v_[220] * v_[323] + v_[247] * v_[391] + v_[224] * v_[380] + v_[254] * v_[392] + v_[235] * v_[360] + (v_[239] * v_[399]) / v_[232] - 0.47422804 * (v_[39] + v_[384]);
    v_[323] = (0 - v_[359]) * x_in[24];
    v_[98] = v_[312] * x_in[24];
    v_[254] = (0 - v_[368]) * x_in[24];
    v_[235] = v_[54] * x_in[24];
    v_[307] = v_[359] * v_[312];
    v_[255] = v_[215] * v_[368];
    v_[361] = v_[359] * v_[361];
    v_[215] = v_[359] * v_[215];
    v_[401] = v_[265] * v_[219];
    v_[370] = v_[22] * v_[383] - v_[370] * v_[3];
    v_[22] = 0.207 * v_[180];
    v_[340] = v_[151] * v_[340] - v_[250] * v_[321];
    v_[375] = -8.81e-05 * v_[170] + -8.81e-05 * v_[363] + 0.026409 * v_[351] - v_[330] * v_[386] - (v_[401] * v_[222] + v_[4]) * v_[364] - v_[375] * v_[370] - (((0.08 * v_[265] - 0.207) * v_[244] + 0.3735 * v_[265] * v_[219]) * v_[222] + ((0.207 - 0.08 * v_[265]) * v_[219] + 0.3735 * v_[265] * v_[244] - 0.35 * v_[265]) * v_[220]) * v_[383] - ((-0.08 * v_[180] * v_[244] - 0.3735 * v_[180] * v_[219]) * v_[222] + (0.08 * v_[180] * v_[219] + -0.3735 * v_[180] * v_[244] + 0.35 * v_[180]) * v_[220]) * v_[3] - (v_[22] * v_[219] * v_[222] + 0.207 * v_[180] * v_[244] * v_[220]) * v_[341] - 0.1104774 * v_[340] - 0.025713 * v_[165];
    v_[22] = 0.0004405 * v_[340] + -8.81e-05 * (v_[150] - v_[83]) + -0.000227999999999999 * v_[369] + 8.81e-05 * v_[102] + 0.000468 * v_[311] - v_[1] * v_[386] - (v_[171] - v_[401] * v_[220]) * v_[364] - ((0 - v_[219]) * v_[222] - v_[244] * v_[220]) * v_[370] - (((0.207 - 0.08 * v_[265]) * v_[219] + 0.3735 * v_[265] * v_[244] - 0.35 * v_[265]) * v_[222] + ((0.207 - 0.08 * v_[265]) * v_[244] - 0.3735 * v_[265] * v_[219]) * v_[220]) * v_[383] - ((0.08 * v_[180] * v_[219] + -0.3735 * v_[180] * v_[244] + 0.35 * v_[180]) * v_[222] + (0.08 * v_[180] * v_[244] + 0.3735 * v_[180] * v_[219]) * v_[220]) * v_[3] - (v_[22] * v_[244] * v_[222] - 0.207 * v_[180] * v_[219] * v_[220]) * v_[341];
    v_[340] = 0.881 * v_[340] + 0.1104774 * v_[165] + 0.0004405 * v_[369] + -0.1104774 * v_[351] + 0.0004405 * v_[311] - (0 - v_[265]) * v_[383] - v_[180] * v_[3] - -8.81e-05 * (v_[96] + v_[395]);
    v_[157] = v_[179] * v_[157] - v_[148] * v_[382];
    v_[396] = 0.007418 * v_[385] + 0.000102 * (v_[39] - v_[396]) + v_[220] * v_[375] + v_[222] * v_[22] + -0.35 * v_[340] + v_[238] * v_[391] + v_[227] * v_[380] + v_[230] * v_[392] + v_[247] * v_[360] + (v_[226] * v_[399]) / v_[232] - 0.47422804 * v_[157] - 0.084376 * v_[387] - 2.1e-05 * v_[154];
    v_[22] = 0.002735 * v_[385] + -0.0825825 * v_[157] + 0.000102 * v_[154] + v_[223] * v_[375] + v_[220] * v_[22] + v_[227] * v_[391] + v_[221] * v_[380] + v_[243] * v_[392] + v_[224] * v_[360] + (v_[231] * v_[399]) / v_[232] - 0.007418 * v_[387] - 2.1e-05 * (v_[39] - v_[384]);
    v_[157] = 0.47422804 * v_[387] + 3.146 * v_[157] + -0.0825825 * v_[385] + v_[340] + v_[240] * v_[391] + v_[234] * v_[380];
    v_[340] = v_[312] * v_[312];
    v_[385] = 0.009466 * v_[307] + 0.1466472 * (v_[255] - v_[361]) + -5.1e-05 * v_[215] + v_[219] * v_[396] + v_[244] * v_[22] + -0.08 * v_[157] - -0.022734 * v_[90] - -3.6e-05 * (v_[340] - v_[381]);
    v_[387] = x_in[36] - v_[385];
    v_[368] = v_[359] * v_[54] - v_[312] * v_[368];
    v_[36] = 0.5824264 * v_[182] + -3.6e-05 * v_[90] + -0.022734 * (v_[110] - v_[381]) + v_[155] * v_[10] + v_[249] * v_[197] + -1 * (v_[36] + (v_[232] * v_[399]) / v_[232]) + v_[271] * v_[323] + v_[228] * v_[98] + v_[273] * v_[254] + v_[270] * v_[235] + (v_[290] * v_[387]) / v_[258] - 0.1466472 * v_[368] - -0.123672 * v_[215] - -5.1e-05 * v_[307];
    v_[22] = -0.133138 * v_[90] + 0.5824264 * (v_[361] - v_[255]) + -0.022734 * v_[307] + v_[245] * v_[396] + v_[219] * v_[22] + v_[228] * v_[323] + v_[252] * v_[98] + v_[283] * v_[254] + v_[262] * v_[235] + (v_[233] * v_[387]) / v_[258] - -3.6e-05 * v_[215] - -5.1e-05 * (v_[110] - v_[340]);
    v_[368] = 3.44 * v_[368] + 0.1466472 * v_[215] + v_[219] * v_[10] + v_[244] * v_[197] + v_[251] * v_[323] + v_[236] * v_[98] + v_[286] * v_[254] + v_[280] * v_[235] + (v_[259] * v_[387]) / v_[258] - 0.5824264 * (v_[340] + v_[381]);
    v_[157] = 0.1466472 * v_[307] + -3.44 * (v_[361] - v_[255]) + 0.5824264 * v_[90] + -1 * v_[157] + v_[273] * v_[323] + v_[283] * v_[98] + v_[285] * v_[254] + v_[274] * v_[235] + (v_[272] * v_[387]) / v_[258];
    v_[340] = 3.44 * v_[182] + 0.5824264 * v_[215] + v_[174] * v_[10] + v_[219] * v_[197] + v_[270] * v_[323] + v_[262] * v_[98] + v_[274] * v_[254] + v_[278] * v_[235] + (v_[260] * v_[387]) / v_[258] - 0.1466472 * (v_[110] + v_[340]);
    v_[215] = x_in[19] * x_in[23] - x_in[20] * x_in[22];
    v_[197] = x_in[19] * x_in[20];
    v_[10] = x_in[19] * x_in[19];
    v_[110] = x_in[18] * x_in[18];
    v_[67] = v_[52] * v_[48] + v_[67] * v_[9];
    v_[124] = v_[139] * v_[121] + v_[124] * v_[26];
    v_[210] = v_[195] * v_[191] + v_[210] * v_[108];
    v_[269] = v_[284] * v_[266] + v_[269] * v_[169];
    v_[277] = 0.190812 + v_[60] + v_[132] + v_[203] + v_[277];
    v_[45] = v_[50] * v_[45] + v_[48] * v_[71];
    v_[116] = v_[26] * v_[116] + v_[120] * v_[143];
    v_[188] = v_[193] * v_[188] + v_[191] * v_[214];
    v_[261] = v_[169] * v_[261] + v_[265] * v_[288];
    v_[288] = (-0.00571 + v_[45] + v_[116] + v_[188] + v_[261]) / v_[229];
    v_[214] = 0.012668 + v_[67] + v_[124] + v_[210] + v_[269] - v_[277] * v_[288];
    v_[143] = x_in[20] * x_in[20];
    v_[71] = x_in[18] * x_in[22] - x_in[19] * x_in[21];
    v_[261] = -0.00571 + v_[45] + v_[116] + v_[188] + v_[261];
    v_[385] = (-0.0053433 * v_[71] + 2.0678571 * (v_[298] - v_[156]) + 0.473273 * v_[197] + 0.190812 * v_[97] + (v_[42] * v_[313]) / v_[42] + v_[325] + v_[289] * v_[318] + v_[47] * v_[333] + v_[72] * v_[14] + v_[118] * v_[306] + -1 * (v_[324] + (v_[113] * v_[371]) / v_[113]) + (v_[185] * v_[100]) / v_[185] + v_[8] + v_[144] * v_[101] + v_[190] * v_[320] + v_[237] * v_[157] + v_[263] * v_[340] + -1 * (v_[385] + (v_[258] * v_[387]) / v_[258]) - -0.00571 * v_[296] - 0.012668 * (v_[143] - v_[10])) / v_[229];
    v_[264] = 5.5837 + v_[293] + v_[73] + v_[295] + v_[119] + v_[297] + v_[216] + v_[299] + v_[264] - v_[261] * v_[288];
    v_[216] = (2.0678571 * v_[215] + -0.00571 * v_[197] + 0.190812 * (v_[143] - v_[110]) + v_[9] * v_[339] + v_[48] * v_[335] + v_[49] * v_[318] + v_[303] * v_[333] + v_[26] * v_[346] + v_[121] * v_[337] + v_[122] * v_[14] + v_[24] * v_[306] + v_[108] * v_[326] + v_[191] * v_[343] + v_[192] * v_[101] + v_[126] * v_[320] + v_[169] * v_[36] + v_[266] * v_[22] + v_[267] * v_[157] + v_[167] * v_[340] - -1.1915559 * v_[71] - 4.847485 * v_[296] - 0.012668 * v_[97] - v_[261] * v_[385]) / v_[264];
    v_[269] = (0.012668 + v_[67] + v_[124] + v_[210] + v_[269] - v_[261] * v_[300]) / v_[264];
    v_[248] = 6.056973 + v_[293] + v_[33] + v_[295] + v_[103] + v_[297] + v_[176] + v_[299] + v_[248] - v_[214] * v_[269] - v_[277] * v_[300];
    v_[22] = (-1.1915559 * (v_[156] - v_[298]) + 4.374212 * v_[97] + 0.012668 * v_[296] + v_[48] * v_[339] + v_[50] * v_[335] + 0.207 * v_[305] + v_[51] * v_[318] + v_[302] * v_[333] + v_[120] * v_[346] + v_[26] * v_[337] + 0.207 * v_[256] + v_[123] * v_[14] + v_[13] * v_[306] + v_[191] * v_[326] + v_[193] * v_[343] + 0.207 * v_[294] + v_[194] * v_[101] + v_[107] * v_[320] + v_[265] * v_[36] + v_[169] * v_[22] + 0.207 * v_[368] + v_[268] * v_[157] + v_[310] * v_[340] - -0.0053433 * v_[215] - 0.190812 * v_[197] - -0.00571 * (v_[10] - v_[110]) - v_[214] * v_[216] - v_[277] * v_[385]) / v_[248];
    v_[75] = v_[64] - v_[75];
    v_[65] = v_[46] + v_[65] - v_[75];
    v_[59] = v_[59] + v_[53];
    v_[53] = v_[50] * v_[65] + v_[48] * v_[59];
    v_[70] = v_[70] + v_[66];
    v_[58] = v_[56] + v_[58] - v_[75];
    v_[56] = v_[50] * v_[70] + v_[48] * v_[58];
    v_[66] = v_[53] * v_[48] + v_[56] * v_[9];
    v_[146] = v_[136] - v_[146];
    v_[137] = v_[117] + v_[137] - v_[146];
    v_[131] = v_[131] + v_[125];
    v_[125] = v_[26] * v_[137] + v_[120] * v_[131];
    v_[142] = v_[142] + v_[138];
    v_[130] = v_[128] + v_[130] - v_[146];
    v_[128] = v_[26] * v_[142] + v_[120] * v_[130];
    v_[138] = v_[125] * v_[121] + v_[128] * v_[26];
    v_[218] = v_[207] - v_[218];
    v_[208] = v_[189] + v_[208] - v_[218];
    v_[202] = v_[202] + v_[196];
    v_[196] = v_[193] * v_[208] + v_[191] * v_[202];
    v_[213] = v_[213] + v_[209];
    v_[201] = v_[199] + v_[201] - v_[218];
    v_[199] = v_[193] * v_[213] + v_[191] * v_[201];
    v_[209] = v_[196] * v_[191] + v_[199] * v_[108];
    v_[291] = v_[281] - v_[291];
    v_[282] = v_[262] + v_[282] - v_[291];
    v_[276] = v_[276] + v_[270];
    v_[270] = v_[169] * v_[282] + v_[265] * v_[276];
    v_[287] = v_[287] + v_[283];
    v_[275] = v_[273] + v_[275] - v_[291];
    v_[273] = v_[169] * v_[287] + v_[265] * v_[275];
    v_[283] = v_[270] * v_[266] + v_[273] * v_[169];
    v_[130] = v_[121] * v_[142] + v_[26] * v_[130];
    v_[131] = v_[121] * v_[137] + v_[26] * v_[131];
    v_[137] = v_[130] * v_[26] + v_[131] * v_[121] + v_[146];
    v_[58] = v_[48] * v_[70] + v_[9] * v_[58];
    v_[59] = v_[48] * v_[65] + v_[9] * v_[59];
    v_[65] = v_[58] * v_[9] + v_[59] * v_[48] + v_[75];
    v_[201] = v_[191] * v_[213] + v_[108] * v_[201];
    v_[202] = v_[191] * v_[208] + v_[108] * v_[202];
    v_[208] = v_[201] * v_[108] + v_[202] * v_[191] + v_[218];
    v_[275] = v_[266] * v_[287] + v_[169] * v_[275];
    v_[276] = v_[266] * v_[282] + v_[169] * v_[276];
    v_[282] = v_[275] * v_[169] + v_[276] * v_[266] + v_[291];
    v_[253] = v_[253] + v_[35];
    v_[292] = v_[292] + v_[253];
    v_[30] = v_[30] + v_[20];
    v_[242] = v_[242] + v_[30];
    v_[253] = 0 - v_[253];
    v_[20] = v_[50] * v_[253] + v_[48] * v_[30];
    v_[35] = v_[292] * v_[9] + v_[242] * v_[48] - v_[20];
    v_[21] = v_[21] + v_[106];
    v_[40] = -1 * (v_[40] + v_[21]);
    v_[99] = v_[99] + v_[85];
    v_[41] = -1 * (v_[41] + v_[99]);
    v_[21] = 0 - v_[21];
    v_[85] = v_[26] * v_[21] + v_[120] * v_[99];
    v_[106] = v_[40] * v_[26] + v_[41] * v_[121] - v_[85];
    v_[86] = v_[86] + v_[178];
    v_[111] = v_[111] + v_[86];
    v_[173] = v_[173] + v_[163];
    v_[112] = v_[112] + v_[173];
    v_[86] = 0 - v_[86];
    v_[163] = v_[193] * v_[86] + v_[191] * v_[173];
    v_[178] = v_[111] * v_[108] + v_[112] * v_[191] - v_[163];
    v_[164] = v_[164] + v_[251];
    v_[183] = -1 * (v_[183] + v_[164]);
    v_[246] = v_[246] + v_[236];
    v_[184] = -1 * (v_[184] + v_[246]);
    v_[164] = 0 - v_[164];
    v_[236] = v_[169] * v_[164] + v_[265] * v_[246];
    v_[251] = v_[183] * v_[169] + v_[184] * v_[266] - v_[236];
    v_[287] = (-2.0678571 + v_[35] + v_[106] + v_[178] + v_[251]) / v_[229];
    v_[213] = (v_[137] + v_[65] + v_[208] + v_[282] - v_[261] * v_[287]) / v_[264];
    v_[70] = (-1.1915559 + v_[66] + v_[138] + v_[209] + v_[283] - v_[214] * v_[213] - v_[277] * v_[287]) / v_[248];
    v_[251] = -2.0678571 + v_[35] + v_[106] + v_[178] + v_[251];
    v_[282] = v_[137] + v_[65] + v_[208] + v_[282] - v_[251] * v_[288];
    v_[283] = -1.1915559 + v_[66] + v_[138] + v_[209] + v_[283] - v_[282] * v_[269] - v_[251] * v_[300];
    v_[141] = 0 - v_[141];
    v_[209] = v_[26] * v_[141] + v_[120] * v_[135];
    v_[69] = 0 - v_[69];
    v_[138] = v_[50] * v_[69] + v_[48] * v_[63];
    v_[212] = 0 - v_[212];
    v_[66] = v_[193] * v_[212] + v_[191] * v_[206];
    v_[286] = 0 - v_[286];
    v_[208] = v_[169] * v_[286] + v_[265] * v_[280];
    v_[65] = (v_[146] + v_[75] + v_[218] + v_[291]) / v_[229];
    v_[137] = (2.0678571 + v_[20] + v_[85] + v_[163] + v_[236] - v_[261] * v_[65]) / v_[264];
    v_[253] = v_[48] * v_[253] + v_[9] * v_[30];
    v_[30] = 0 - v_[253];
    v_[21] = v_[121] * v_[21] + v_[26] * v_[99];
    v_[99] = 0 - v_[21];
    v_[86] = v_[191] * v_[86] + v_[108] * v_[173];
    v_[173] = 0 - v_[86];
    v_[164] = v_[266] * v_[164] + v_[169] * v_[246];
    v_[246] = 0 - v_[164];
    v_[178] = (0.0053433 + v_[30] + v_[99] + v_[173] + v_[246] - v_[214] * v_[137] - v_[277] * v_[65]) / v_[248];
    v_[106] = v_[209] + v_[138] + v_[66] + v_[208] - v_[282] * v_[137] - v_[251] * v_[65] - v_[283] * v_[178];
    v_[35] = v_[146] + v_[75] + v_[218] + v_[291];
    v_[236] = 2.0678571 + v_[20] + v_[85] + v_[163] + v_[236] - v_[35] * v_[288];
    v_[246] = 0.0053433 + v_[30] + v_[99] + v_[173] + v_[246] - v_[236] * v_[269] - v_[35] * v_[300];
    v_[68] = v_[68] - v_[62];
    v_[61] = v_[61] - v_[62];
    v_[140] = v_[140] - v_[134];
    v_[133] = v_[133] - v_[134];
    v_[211] = v_[211] - v_[205];
    v_[204] = v_[204] - v_[205];
    v_[285] = v_[285] - v_[279];
    v_[278] = v_[278] - v_[279];
    v_[173] = v_[48] * v_[57];
    v_[99] = (v_[48] * v_[61] + v_[9] * v_[57]) * v_[48] + (v_[173] + v_[9] * v_[68]) * v_[9];
    v_[173] = v_[50] * v_[61] + v_[173];
    v_[57] = v_[50] * v_[57] + v_[48] * v_[68];
    v_[30] = v_[173] * v_[50] + v_[57] * v_[48];
    v_[163] = v_[26] * v_[129];
    v_[85] = (v_[121] * v_[133] + v_[163]) * v_[121] + (v_[121] * v_[129] + v_[26] * v_[140]) * v_[26];
    v_[129] = v_[26] * v_[133] + v_[120] * v_[129];
    v_[163] = v_[163] + v_[120] * v_[140];
    v_[20] = v_[129] * v_[26] + v_[163] * v_[120];
    v_[142] = v_[191] * v_[200];
    v_[262] = (v_[191] * v_[204] + v_[108] * v_[200]) * v_[191] + (v_[142] + v_[108] * v_[211]) * v_[108];
    v_[142] = v_[193] * v_[204] + v_[142];
    v_[200] = v_[193] * v_[200] + v_[191] * v_[211];
    v_[281] = v_[142] * v_[193] + v_[200] * v_[191];
    v_[189] = v_[169] * v_[274];
    v_[207] = (v_[266] * v_[278] + v_[189]) * v_[266] + (v_[266] * v_[274] + v_[169] * v_[285]) * v_[169];
    v_[274] = v_[169] * v_[278] + v_[265] * v_[274];
    v_[189] = v_[189] + v_[265] * v_[285];
    v_[117] = v_[274] * v_[169] + v_[189] * v_[265];
    v_[278] = 53.433 + v_[68] + v_[61] + v_[62] + v_[140] + v_[133] + v_[134] + v_[211] + v_[204] + v_[205] + v_[285] + v_[278] + v_[279] - v_[99] - v_[30] - v_[85] - v_[20] - v_[262] - v_[281] - v_[207] - v_[117] - v_[236] * v_[137] - v_[35] * v_[65] - v_[246] * v_[178];
    v_[215] = (53.433 * v_[215] + 2.0678571 * v_[296] + -0.0053433 * v_[97] + v_[305] + -1 * v_[256] + v_[294] + -1 * v_[368] - -1.1915559 * (v_[143] + v_[10]) - v_[236] * v_[216] - v_[35] * v_[385] - v_[246] * v_[22]) / v_[278];
    v_[208] = (v_[209] + v_[138] + v_[66] + v_[208] - v_[236] * v_[213] - v_[35] * v_[287] - v_[246] * v_[70]) / v_[278];
    v_[207] = 53.433 + v_[62] + v_[99] + v_[134] + v_[85] + v_[205] + v_[262] + v_[279] + v_[207] - v_[282] * v_[213] - v_[251] * v_[287] - v_[283] * v_[70] - v_[106] * v_[208];
    v_[143] = (-53.433 * (v_[298] - v_[156]) + -1.1915559 * v_[97] + 2.0678571 * v_[197] + v_[9] * v_[318] + v_[48] * v_[333] + v_[105] * v_[14] + v_[352] * v_[306] + v_[108] * v_[101] + v_[191] * v_[320] + v_[309] * v_[157] + v_[374] * v_[340] - -0.0053433 * (v_[143] + v_[110]) - v_[282] * v_[216] - v_[251] * v_[385] - v_[283] * v_[22] - v_[106] * v_[215]) / v_[207];
    v_[163] = v_[129] * v_[121] + v_[163] * v_[26];
    v_[57] = v_[173] * v_[48] + v_[57] * v_[9];
    v_[200] = v_[142] * v_[191] + v_[200] * v_[108];
    v_[189] = v_[274] * v_[266] + v_[189] * v_[169];
    v_[59] = v_[59] * v_[50] + v_[58] * v_[48];
    v_[131] = v_[131] * v_[26] + v_[130] * v_[120];
    v_[202] = v_[202] * v_[193] + v_[201] * v_[191];
    v_[276] = v_[276] * v_[169] + v_[275] * v_[265];
    v_[253] = v_[292] * v_[48] + v_[242] * v_[50] + v_[253];
    v_[21] = v_[40] * v_[120] + v_[41] * v_[26] + v_[21];
    v_[86] = v_[111] * v_[191] + v_[112] * v_[193] + v_[86];
    v_[164] = v_[183] * v_[265] + v_[184] * v_[169] + v_[164];
    v_[229] = (-0.0053433 + v_[253] + v_[21] + v_[86] + v_[164]) / v_[229];
    v_[264] = (1.1915559 + v_[59] + v_[131] + v_[202] + v_[276] - v_[261] * v_[229]) / v_[264];
    v_[128] = v_[128] * v_[120] + v_[125] * v_[26] + v_[146];
    v_[56] = v_[56] * v_[48] + v_[53] * v_[50] + v_[75];
    v_[199] = v_[199] * v_[191] + v_[196] * v_[193] + v_[218];
    v_[273] = v_[273] * v_[265] + v_[270] * v_[169] + v_[291];
    v_[248] = (v_[128] + v_[56] + v_[199] + v_[273] - v_[214] * v_[264] - v_[277] * v_[229]) / v_[248];
    v_[141] = 0 - v_[26] * v_[135] - v_[121] * v_[141];
    v_[69] = 0 - v_[9] * v_[63] - v_[48] * v_[69];
    v_[212] = 0 - v_[108] * v_[206] - v_[191] * v_[212];
    v_[286] = 0 - v_[169] * v_[280] - v_[266] * v_[286];
    v_[278] = (v_[141] + v_[69] + v_[212] + v_[286] - v_[236] * v_[264] - v_[35] * v_[229] - v_[246] * v_[248]) / v_[278];
    v_[207] = (v_[163] + v_[57] + v_[200] + v_[189] - v_[282] * v_[264] - v_[251] * v_[229] - v_[283] * v_[248] - v_[106] * v_[278]) / v_[207];
    v_[164] = -0.0053433 + v_[253] + v_[21] + v_[86] + v_[164];
    v_[276] = 1.1915559 + v_[59] + v_[131] + v_[202] + v_[276] - v_[164] * v_[288];
    v_[273] = v_[128] + v_[56] + v_[199] + v_[273] - v_[276] * v_[269] - v_[164] * v_[300];
    v_[286] = v_[141] + v_[69] + v_[212] + v_[286] - v_[276] * v_[137] - v_[164] * v_[65] - v_[273] * v_[178];
    v_[189] = v_[163] + v_[57] + v_[200] + v_[189] - v_[276] * v_[213] - v_[164] * v_[287] - v_[273] * v_[70] - v_[286] * v_[208];
    v_[189] = (53.433 * v_[71] + -1.1915559 * v_[296] + -0.0053433 * v_[197] + v_[48] * v_[318] + v_[304] * v_[333] + v_[120] * v_[14] + v_[18] * v_[306] + v_[191] * v_[101] + v_[257] * v_[320] + v_[265] * v_[157] + v_[161] * v_[340] - 2.0678571 * (v_[10] + v_[110]) - v_[276] * v_[216] - v_[164] * v_[385] - v_[273] * v_[22] - v_[286] * v_[215] - v_[189] * v_[143]) / (53.433 + v_[62] + v_[30] + v_[134] + v_[20] + v_[205] + v_[281] + v_[279] + v_[117] - v_[276] * v_[264] - v_[164] * v_[229] - v_[273] * v_[248] - v_[286] * v_[278] - v_[189] * v_[207]);
    v_[207] = v_[143] - v_[207] * v_[189];
    v_[278] = v_[215] - v_[278] * v_[189] - v_[208] * v_[207];
    v_[248] = v_[22] - v_[70] * v_[207] - v_[178] * v_[278] - v_[248] * v_[189];
    forwardZero[20] = 0 - v_[248];
    v_[264] = v_[216] - v_[137] * v_[278] - v_[269] * v_[248] - v_[213] * v_[207] - v_[264] * v_[189];
    forwardZero[18] = v_[300] * v_[248] + v_[288] * v_[264] + v_[65] * v_[278] + v_[287] * v_[207] + v_[229] * v_[189] - v_[385];
    forwardZero[19] = 0 - v_[264];
    v_[278] = 0 - v_[278];
    v_[264] = 0.5 * x_in[0];
    v_[248] = cos(v_[264]);
    v_[229] = 0.5 * x_in[1];
    v_[65] = cos(v_[229]);
    v_[287] = v_[248] * v_[65];
    v_[385] = 0.5 * x_in[2];
    v_[288] = sin(v_[385]);
    v_[264] = sin(v_[264]);
    v_[229] = sin(v_[229]);
    v_[300] = v_[264] * v_[229];
    v_[385] = cos(v_[385]);
    v_[137] = 2. * (v_[287] * v_[288] + v_[300] * v_[385]);
    v_[264] = v_[264] * v_[65];
    v_[229] = v_[248] * v_[229];
    v_[248] = v_[264] * v_[385] + v_[229] * v_[288];
    v_[229] = v_[229] * v_[385] - v_[264] * v_[288];
    v_[264] = 2. * v_[229];
    v_[385] = v_[287] * v_[385] - v_[300] * v_[288];
    forwardZero[21] = v_[278] + -9.81 * (v_[137] * v_[248] - v_[264] * v_[385]);
    v_[207] = 0 - v_[207];
    v_[300] = 2. * v_[248];
    forwardZero[22] = v_[207] + -9.81 * (v_[137] * v_[229] + v_[300] * v_[385]);
    v_[189] = 0 - v_[189];
    forwardZero[23] = v_[189] + -9.81 * (1 - v_[264] * v_[229] - v_[300] * v_[248]);
    v_[300] = -1 * forwardZero[18];
    v_[323] = v_[265] * forwardZero[20] + v_[169] * forwardZero[19] + v_[323];
    v_[98] = v_[169] * forwardZero[20] + v_[266] * forwardZero[19] + v_[98];
    v_[266] = -1 * v_[278];
    v_[169] = 0.207 * forwardZero[20] + v_[266];
    v_[235] = v_[310] * forwardZero[20] + v_[167] * forwardZero[19] + v_[263] * forwardZero[18] + v_[161] * v_[189] + v_[374] * v_[207] + v_[235];
    forwardZero[24] = (v_[387] - v_[258] * v_[300] - v_[290] * v_[323] - v_[233] * v_[98] - v_[259] * v_[169] - v_[272] * (v_[268] * forwardZero[20] + v_[267] * forwardZero[19] + v_[237] * forwardZero[18] + v_[265] * v_[189] + v_[309] * v_[207] + v_[254]) - v_[260] * v_[235]) / v_[258];
    v_[387] = -1 * v_[323];
    v_[254] = v_[300] + forwardZero[24];
    v_[392] = v_[219] * v_[169] + v_[174] * v_[235] + v_[155] * v_[323] + v_[392];
    v_[235] = v_[244] * v_[169] + v_[219] * v_[235] + v_[249] * v_[323] + v_[360];
    forwardZero[25] = (v_[399] - v_[232] * v_[387] - v_[226] * (v_[219] * v_[254] + v_[245] * v_[98] + v_[391]) - v_[231] * (v_[244] * v_[254] + v_[219] * v_[98] + v_[380]) - v_[241] * v_[392] - v_[239] * v_[235]) / v_[232];
    v_[387] = v_[387] + forwardZero[25];
    forwardZero[26] = (v_[336] - 0.1104774 * (v_[220] * v_[392] + v_[372] * v_[235] + v_[37] * v_[387] + v_[102]) - -0.0004405 * (v_[222] * v_[392] + v_[220] * v_[235] + v_[225] * v_[387] + v_[363]) - 0.026181 * v_[387]) / 0.026181;
    v_[377] = v_[191] * forwardZero[20] + v_[108] * forwardZero[19] + v_[377];
    v_[362] = v_[193] * forwardZero[20] + v_[191] * forwardZero[19] + v_[362];
    v_[193] = 0.207 * forwardZero[20] + v_[278];
    v_[162] = v_[107] * forwardZero[20] + v_[126] * forwardZero[19] + v_[190] * forwardZero[18] + v_[257] * v_[189] + v_[191] * v_[207] + v_[162];
    forwardZero[27] = (v_[100] - v_[185] * forwardZero[18] - v_[217] * v_[377] - v_[160] * v_[362] - v_[186] * v_[193] - v_[198] * (v_[194] * forwardZero[20] + v_[192] * forwardZero[19] + v_[144] * forwardZero[18] + v_[191] * v_[189] + v_[108] * v_[207] + v_[181]) - v_[187] * v_[162]) / v_[185];
    v_[100] = forwardZero[18] + forwardZero[27];
    v_[378] = v_[87] * v_[193] + v_[93] * v_[162] + v_[89] * v_[377] + v_[378];
    v_[162] = v_[80] * v_[193] + v_[92] * v_[162] + v_[177] * v_[377] + v_[379];
    forwardZero[28] = (v_[366] - v_[159] * v_[377] - v_[153] * (v_[175] * v_[100] + v_[172] * v_[362] + v_[376]) - v_[158] * (v_[172] * v_[100] + v_[92] * v_[362] + v_[373]) - v_[168] * v_[378] - v_[166] * v_[162]) / v_[159];
    v_[377] = v_[377] + forwardZero[28];
    forwardZero[29] = (v_[319] - 0.1104774 * (v_[147] * v_[378] + v_[367] * v_[162] + v_[365] * v_[377] + v_[322]) - -0.0004405 * (v_[149] * v_[378] + v_[147] * v_[162] + v_[152] * v_[377] + v_[338]) - 0.026181 * v_[377]) / 0.026181;
    v_[28] = v_[120] * forwardZero[20] + v_[26] * forwardZero[19] + v_[28];
    v_[308] = v_[26] * forwardZero[20] + v_[121] * forwardZero[19] + v_[308];
    v_[266] = 0.207 * forwardZero[20] + v_[266];
    v_[84] = v_[13] * forwardZero[20] + v_[24] * forwardZero[19] + v_[118] * forwardZero[18] + v_[18] * v_[189] + v_[352] * v_[207] + v_[84];
    forwardZero[30] = (v_[371] - v_[113] * v_[300] - v_[145] * v_[28] - v_[82] * v_[308] - v_[114] * v_[266] - v_[127] * (v_[123] * forwardZero[20] + v_[122] * forwardZero[19] + v_[72] * forwardZero[18] + v_[120] * v_[189] + v_[105] * v_[207] + v_[109]) - v_[115] * v_[84]) / v_[113];
    v_[371] = -1 * v_[28];
    v_[300] = v_[300] + forwardZero[30];
    v_[331] = v_[76] * v_[266] + v_[31] * v_[84] + v_[12] * v_[28] + v_[331];
    v_[84] = v_[94] * v_[266] + v_[76] * v_[84] + v_[104] * v_[28] + v_[11];
    forwardZero[31] = (v_[350] - v_[81] * v_[371] - 2.1e-05 * (v_[76] * v_[300] + v_[95] * v_[308] + v_[27]) - -0.000102 * (v_[94] * v_[300] + v_[76] * v_[308] + v_[358]) - v_[91] * v_[331] - v_[88] * v_[84]) / v_[81];
    v_[371] = v_[371] + forwardZero[31];
    forwardZero[32] = (v_[342] - 0.110125 * (v_[79] * v_[331] + v_[314] * v_[84] + v_[345] * v_[371] + v_[355]) - 0.000881 * (v_[77] * v_[331] + v_[79] * v_[84] + v_[78] * v_[371] + v_[354]) - 0.026181 * v_[371]) / 0.026181;
    v_[348] = v_[48] * forwardZero[20] + v_[9] * forwardZero[19] + v_[348];
    v_[344] = v_[50] * forwardZero[20] + v_[48] * forwardZero[19] + v_[344];
    v_[278] = 0.207 * forwardZero[20] + v_[278];
    v_[19] = v_[302] * forwardZero[20] + v_[303] * forwardZero[19] + v_[47] * forwardZero[18] + v_[304] * v_[189] + v_[48] * v_[207] + v_[19];
    forwardZero[33] = (v_[313] - v_[42] * forwardZero[18] - v_[74] * v_[348] - v_[17] * v_[344] - v_[43] * v_[278] - v_[55] * (v_[51] * forwardZero[20] + v_[49] * forwardZero[19] + v_[289] * forwardZero[18] + v_[48] * v_[189] + v_[9] * v_[207] + v_[38]) - v_[44] * v_[19]) / v_[42];
    v_[189] = forwardZero[18] + forwardZero[33];
    v_[356] = v_[315] * v_[278] + v_[316] * v_[19] + v_[317] * v_[348] + v_[356];
    v_[19] = v_[301] * v_[278] + v_[5] * v_[19] + v_[34] * v_[348] + v_[357];
    forwardZero[34] = (v_[349] - v_[16] * v_[348] - v_[6] * (v_[32] * v_[189] + v_[29] * v_[344] + v_[347]) - v_[15] * (v_[29] * v_[189] + v_[5] * v_[344] + v_[353]) - v_[25] * v_[356] - v_[23] * v_[19]) / v_[16];
    v_[348] = v_[348] + forwardZero[34];
    forwardZero[35] = (v_[329] - 0.1104774 * (v_[2] * v_[356] + v_[332] * v_[19] + v_[327] * v_[348] + v_[334]) - 0.0004405 * (v_[7] * v_[356] + v_[2] * v_[19] + v_[0] * v_[348] + v_[328]) - 0.026181 * v_[348]) / 0.026181;
    // dependent variables without operations
    forwardZero[6] = x_in[24];
    forwardZero[7] = x_in[25];
    forwardZero[8] = x_in[26];
    forwardZero[9] = x_in[27];
    forwardZero[10] = x_in[28];
    forwardZero[11] = x_in[29];
    forwardZero[12] = x_in[30];
    forwardZero[13] = x_in[31];
    forwardZero[14] = x_in[32];
    forwardZero[15] = x_in[33];
    forwardZero[16] = x_in[34];
    forwardZero[17] = x_in[35];


    return eval_;
}
}
}
}
