/**********************************************************************************************************************
This file is part of the Control Toolbox (https://github.com/ethz-adrl/control-toolbox), copyright by ETH Zurich.
Licensed under the BSD-2 license (see LICENSE file in main directory)
**********************************************************************************************************************/
#include "HyQForwardKinJacForward.h"

namespace ct {
namespace models {
namespace HyQ {


HyQForwardKinJacForward::JAC_TYPE HyQForwardKinJacForward::jacobian(const Eigen::VectorXd& x_in)
{
    double* jac = jac_.data();

        v_[0] = 0.5 * x_in[0];
    v_[1] = cos(v_[0]);
    v_[2] = 0.5 * x_in[1];
    v_[3] = cos(v_[2]);
    v_[4] = v_[1] * v_[3];
    v_[5] = 0.5 * x_in[2];
    v_[6] = sin(v_[5]);
    v_[7] = sin(v_[0]);
    v_[8] = sin(v_[2]);
    v_[9] = v_[7] * v_[8];
    v_[10] = cos(v_[5]);
    v_[11] = v_[4] * v_[6] + v_[9] * v_[10];
    v_[12] = 2. * v_[11];
    v_[13] = 0.5 * cos(v_[0]);
    v_[14] = v_[13] * v_[3];
    v_[0] = -0.5 * sin(v_[0]);
    v_[15] = v_[0] * v_[8];
    v_[16] = v_[14] * v_[10] + v_[15] * v_[6];
    v_[0] = v_[0] * v_[3];
    v_[13] = v_[13] * v_[8];
    v_[17] = v_[0] * v_[6] + v_[13] * v_[10];
    v_[18] = 2. * v_[17];
    v_[3] = v_[7] * v_[3];
    v_[8] = v_[1] * v_[8];
    v_[19] = v_[3] * v_[10] + v_[8] * v_[6];
    v_[20] = v_[12] * v_[16] + v_[18] * v_[19];
    v_[21] = v_[8] * v_[10] - v_[3] * v_[6];
    v_[22] = 2. * v_[21];
    v_[13] = v_[0] * v_[10] - v_[13] * v_[6];
    v_[15] = v_[15] * v_[10] - v_[14] * v_[6];
    v_[14] = 2. * v_[15];
    v_[0] = v_[4] * v_[10] - v_[9] * v_[6];
    v_[23] = v_[22] * v_[13] + v_[14] * v_[0];
    v_[24] = cos(x_in[6]);
    v_[25] = 0.33 * v_[24];
    v_[26] = sin(x_in[7]);
    v_[27] = v_[25] * v_[26];
    v_[28] = sin(x_in[8]);
    v_[29] = 0.33 * v_[24];
    v_[30] = cos(x_in[7]);
    v_[31] = v_[29] * v_[30];
    v_[32] = cos(x_in[8]);
    v_[33] = 0.35 * v_[24];
    v_[34] = v_[27] * v_[28] - v_[31] * v_[32] - v_[33] * v_[30] - 0.08 * v_[24];
    v_[35] = v_[22] * v_[16] + v_[14] * v_[19];
    v_[36] = v_[12] * v_[13] + v_[18] * v_[0];
    v_[37] = sin(x_in[6]);
    v_[38] = 0.33 * v_[37];
    v_[39] = v_[38] * v_[26];
    v_[40] = 0.33 * v_[37];
    v_[41] = v_[40] * v_[30];
    v_[42] = 0.35 * v_[37];
    v_[43] = 0.207 + v_[39] * v_[28] - v_[41] * v_[32] - v_[42] * v_[30] - 0.08 * v_[37];
    v_[17] = v_[12] * v_[17] + v_[18] * v_[11];
    v_[14] = v_[22] * v_[15] + v_[14] * v_[21];
    v_[44] = -0.33 * v_[30];
    v_[45] = 0.33 * v_[26];
    v_[46] = 0.3735 + v_[44] * v_[28] - v_[45] * v_[32] - 0.35 * v_[26];
    jac[0] = (v_[20] + v_[23]) * v_[34] + (v_[35] - v_[36]) * v_[43] + (0 - v_[17] - v_[14]) * v_[46];
    v_[15] = v_[12] * v_[15] + v_[18] * v_[21];
    v_[18] = 2. * v_[19];
    v_[47] = 2. * v_[16];
    v_[13] = v_[18] * v_[13] + v_[47] * v_[0];
    v_[47] = v_[18] * v_[16] + v_[47] * v_[19];
    jac[1] = (v_[15] - v_[13]) * v_[34] + (0 - v_[17] - v_[47]) * v_[43] + (v_[35] + v_[36]) * v_[46];
    jac[2] = (0 - v_[14] - v_[47]) * v_[34] + (v_[15] + v_[13]) * v_[43] + (v_[20] - v_[23]) * v_[46];
    v_[47] = 0.5 * x_in[0];
    v_[13] = cos(v_[47]);
    v_[15] = 0.5 * x_in[1];
    v_[14] = cos(v_[15]);
    v_[23] = v_[13] * v_[14];
    v_[20] = 0.5 * x_in[2];
    v_[17] = sin(v_[20]);
    v_[36] = sin(v_[47]);
    v_[35] = sin(v_[15]);
    v_[16] = v_[36] * v_[35];
    v_[48] = cos(v_[20]);
    v_[49] = v_[23] * v_[17] + v_[16] * v_[48];
    v_[50] = 2. * v_[49];
    v_[51] = 0.5 * cos(v_[47]);
    v_[52] = v_[51] * v_[14];
    v_[47] = -0.5 * sin(v_[47]);
    v_[53] = v_[47] * v_[35];
    v_[54] = v_[52] * v_[48] + v_[53] * v_[17];
    v_[47] = v_[47] * v_[14];
    v_[51] = v_[51] * v_[35];
    v_[55] = v_[47] * v_[17] + v_[51] * v_[48];
    v_[56] = 2. * v_[55];
    v_[14] = v_[36] * v_[14];
    v_[35] = v_[13] * v_[35];
    v_[57] = v_[14] * v_[48] + v_[35] * v_[17];
    v_[58] = v_[50] * v_[54] + v_[56] * v_[57];
    v_[59] = v_[35] * v_[48] - v_[14] * v_[17];
    v_[60] = 2. * v_[59];
    v_[51] = v_[47] * v_[48] - v_[51] * v_[17];
    v_[53] = v_[53] * v_[48] - v_[52] * v_[17];
    v_[52] = 2. * v_[53];
    v_[47] = v_[23] * v_[48] - v_[16] * v_[17];
    v_[61] = v_[60] * v_[51] + v_[52] * v_[47];
    v_[62] = 0.33 * v_[24];
    v_[63] = v_[62] * v_[30];
    v_[64] = 0.33 * v_[24];
    v_[65] = v_[64] * v_[26];
    v_[66] = v_[63] * v_[28] + v_[65] * v_[32];
    v_[67] = v_[62] * v_[26];
    v_[68] = 0.33 * v_[24];
    v_[69] = v_[68] * v_[30];
    v_[70] = 0.35 * v_[24];
    v_[71] = v_[67] * v_[32] + v_[69] * v_[28] + v_[70] * v_[26];
    v_[72] = 0.33 * v_[37];
    v_[73] = v_[72] * v_[30];
    v_[74] = -0.33 * v_[37];
    v_[75] = v_[74] * v_[26];
    v_[76] = 0.35 * v_[37];
    v_[77] = v_[73] * v_[32] + v_[75] * v_[28] + v_[76] * v_[30] + 0.08 * v_[37];
    v_[78] = 0.33 * v_[37];
    v_[79] = v_[78] * v_[26];
    v_[80] = 0.33 * v_[37];
    v_[81] = v_[80] * v_[30];
    v_[82] = 0.35 * v_[37];
    v_[83] = 0.207 + v_[79] * v_[28] - v_[81] * v_[32] - v_[82] * v_[30] - 0.08 * v_[37];
    v_[84] = -0.33 * v_[30];
    v_[85] = 0.33 * v_[26];
    v_[86] = 0.3735 + v_[84] * v_[28] - v_[85] * v_[32] - 0.35 * v_[26];
    v_[87] = v_[66] * x_in[26] + v_[71] * x_in[25] + v_[77] * x_in[24] + x_in[23] + x_in[18] * v_[83] - x_in[19] * v_[86];
    v_[88] = v_[60] * v_[54] + v_[52] * v_[57];
    v_[89] = v_[50] * v_[51] + v_[56] * v_[47];
    v_[90] = 0.33 * v_[37];
    v_[91] = v_[90] * v_[30];
    v_[92] = 0.33 * v_[37];
    v_[93] = v_[92] * v_[26];
    v_[94] = v_[91] * v_[28] + v_[93] * v_[32];
    v_[95] = v_[90] * v_[26];
    v_[96] = 0.33 * v_[37];
    v_[97] = v_[96] * v_[30];
    v_[37] = 0.35 * v_[37];
    v_[98] = v_[95] * v_[32] + v_[97] * v_[28] + v_[37] * v_[26];
    v_[99] = 0.33 * v_[24];
    v_[100] = v_[99] * v_[26];
    v_[101] = 0.33 * v_[24];
    v_[102] = v_[101] * v_[30];
    v_[103] = 0.35 * v_[24];
    v_[104] = v_[100] * v_[28] - v_[102] * v_[32] - v_[103] * v_[30] - 0.08 * v_[24];
    v_[105] = 0.33 * v_[24];
    v_[106] = v_[105] * v_[26];
    v_[107] = 0.35 * v_[24];
    v_[24] = v_[106] * v_[28] - v_[102] * v_[32] - v_[107] * v_[30] - 0.08 * v_[24];
    v_[108] = v_[94] * x_in[26] + v_[98] * x_in[25] + v_[104] * x_in[24] + x_in[22] + x_in[20] * v_[86] - x_in[18] * v_[24];
    v_[55] = v_[50] * v_[55] + v_[56] * v_[49];
    v_[52] = v_[60] * v_[53] + v_[52] * v_[59];
    v_[109] = 0.33 * v_[26];
    v_[110] = 0.33 * v_[30];
    v_[111] = v_[109] * v_[28] - v_[110] * v_[32];
    v_[112] = 0.33 * v_[26];
    v_[113] = 0.33 * v_[30];
    v_[114] = v_[112] * v_[28] - v_[113] * v_[32] - 0.35 * v_[30];
    v_[115] = v_[111] * x_in[26] + v_[114] * x_in[25] + x_in[21] + x_in[19] * v_[24] - x_in[20] * v_[83];
    jac[3] = (v_[58] + v_[61]) * v_[87] + (v_[88] - v_[89]) * v_[108] + (0 - v_[55] - v_[52]) * v_[115];
    v_[53] = v_[50] * v_[53] + v_[56] * v_[59];
    v_[56] = 2. * v_[57];
    v_[116] = 2. * v_[54];
    v_[51] = v_[56] * v_[51] + v_[116] * v_[47];
    v_[116] = v_[56] * v_[54] + v_[116] * v_[57];
    jac[4] = (v_[53] - v_[51]) * v_[87] + (0 - v_[55] - v_[116]) * v_[108] + (v_[88] + v_[89]) * v_[115];
    jac[5] = (0 - v_[52] - v_[116]) * v_[87] + (v_[53] + v_[51]) * v_[108] + (v_[58] - v_[61]) * v_[115];
    v_[116] = 0.5 * x_in[0];
    v_[51] = cos(v_[116]);
    v_[53] = 0.5 * x_in[1];
    v_[52] = cos(v_[53]);
    v_[61] = v_[51] * v_[52];
    v_[58] = 0.5 * x_in[2];
    v_[55] = sin(v_[58]);
    v_[89] = sin(v_[116]);
    v_[88] = sin(v_[53]);
    v_[54] = v_[89] * v_[88];
    v_[117] = cos(v_[58]);
    v_[118] = v_[61] * v_[55] + v_[54] * v_[117];
    v_[119] = 2. * v_[118];
    v_[120] = 0.5 * cos(v_[116]);
    v_[121] = v_[120] * v_[52];
    v_[116] = -0.5 * sin(v_[116]);
    v_[122] = v_[116] * v_[88];
    v_[123] = v_[121] * v_[117] + v_[122] * v_[55];
    v_[116] = v_[116] * v_[52];
    v_[120] = v_[120] * v_[88];
    v_[124] = v_[116] * v_[55] + v_[120] * v_[117];
    v_[125] = 2. * v_[124];
    v_[52] = v_[89] * v_[52];
    v_[88] = v_[51] * v_[88];
    v_[126] = v_[52] * v_[117] + v_[88] * v_[55];
    v_[127] = v_[119] * v_[123] + v_[125] * v_[126];
    v_[128] = v_[88] * v_[117] - v_[52] * v_[55];
    v_[129] = 2. * v_[128];
    v_[120] = v_[116] * v_[117] - v_[120] * v_[55];
    v_[122] = v_[122] * v_[117] - v_[121] * v_[55];
    v_[121] = 2. * v_[122];
    v_[116] = v_[61] * v_[117] - v_[54] * v_[55];
    v_[130] = v_[129] * v_[120] + v_[121] * v_[116];
    v_[131] = cos(x_in[9]);
    v_[132] = 0.33 * v_[131];
    v_[133] = sin(x_in[10]);
    v_[134] = v_[132] * v_[133];
    v_[135] = sin(x_in[11]);
    v_[136] = 0.33 * v_[131];
    v_[137] = cos(x_in[10]);
    v_[138] = v_[136] * v_[137];
    v_[139] = cos(x_in[11]);
    v_[140] = 0.35 * v_[131];
    v_[141] = v_[134] * v_[135] - v_[138] * v_[139] - v_[140] * v_[137] - 0.08 * v_[131];
    v_[142] = v_[129] * v_[123] + v_[121] * v_[126];
    v_[143] = v_[119] * v_[120] + v_[125] * v_[116];
    v_[144] = sin(x_in[9]);
    v_[145] = 0.33 * v_[144];
    v_[146] = v_[145] * v_[137];
    v_[147] = -0.33 * v_[144];
    v_[148] = v_[147] * v_[133];
    v_[149] = 0.35 * v_[144];
    v_[150] = -0.207 + v_[146] * v_[139] + v_[148] * v_[135] + v_[149] * v_[137] + 0.08 * v_[144];
    v_[124] = v_[119] * v_[124] + v_[125] * v_[118];
    v_[121] = v_[129] * v_[122] + v_[121] * v_[128];
    v_[151] = -0.33 * v_[137];
    v_[152] = 0.33 * v_[133];
    v_[153] = 0.3735 + v_[151] * v_[135] - v_[152] * v_[139] - 0.35 * v_[133];
    jac[6] = (v_[127] + v_[130]) * v_[141] + (v_[142] - v_[143]) * v_[150] + (0 - v_[124] - v_[121]) * v_[153];
    v_[122] = v_[119] * v_[122] + v_[125] * v_[128];
    v_[125] = 2. * v_[126];
    v_[154] = 2. * v_[123];
    v_[120] = v_[125] * v_[120] + v_[154] * v_[116];
    v_[154] = v_[125] * v_[123] + v_[154] * v_[126];
    jac[7] = (v_[122] - v_[120]) * v_[141] + (0 - v_[124] - v_[154]) * v_[150] + (v_[142] + v_[143]) * v_[153];
    jac[8] = (0 - v_[121] - v_[154]) * v_[141] + (v_[122] + v_[120]) * v_[150] + (v_[127] - v_[130]) * v_[153];
    v_[154] = 0.5 * x_in[0];
    v_[120] = cos(v_[154]);
    v_[122] = 0.5 * x_in[1];
    v_[121] = cos(v_[122]);
    v_[130] = v_[120] * v_[121];
    v_[127] = 0.5 * x_in[2];
    v_[124] = sin(v_[127]);
    v_[143] = sin(v_[154]);
    v_[142] = sin(v_[122]);
    v_[123] = v_[143] * v_[142];
    v_[155] = cos(v_[127]);
    v_[156] = v_[130] * v_[124] + v_[123] * v_[155];
    v_[157] = 2. * v_[156];
    v_[158] = 0.5 * cos(v_[154]);
    v_[159] = v_[158] * v_[121];
    v_[154] = -0.5 * sin(v_[154]);
    v_[160] = v_[154] * v_[142];
    v_[161] = v_[159] * v_[155] + v_[160] * v_[124];
    v_[154] = v_[154] * v_[121];
    v_[158] = v_[158] * v_[142];
    v_[162] = v_[154] * v_[124] + v_[158] * v_[155];
    v_[163] = 2. * v_[162];
    v_[121] = v_[143] * v_[121];
    v_[142] = v_[120] * v_[142];
    v_[164] = v_[121] * v_[155] + v_[142] * v_[124];
    v_[165] = v_[157] * v_[161] + v_[163] * v_[164];
    v_[166] = v_[142] * v_[155] - v_[121] * v_[124];
    v_[167] = 2. * v_[166];
    v_[158] = v_[154] * v_[155] - v_[158] * v_[124];
    v_[160] = v_[160] * v_[155] - v_[159] * v_[124];
    v_[159] = 2. * v_[160];
    v_[154] = v_[130] * v_[155] - v_[123] * v_[124];
    v_[168] = v_[167] * v_[158] + v_[159] * v_[154];
    v_[169] = 0.33 * v_[131];
    v_[170] = v_[169] * v_[137];
    v_[171] = 0.33 * v_[131];
    v_[172] = v_[171] * v_[133];
    v_[173] = v_[170] * v_[135] + v_[172] * v_[139];
    v_[174] = v_[169] * v_[133];
    v_[175] = 0.33 * v_[131];
    v_[176] = v_[175] * v_[137];
    v_[177] = 0.35 * v_[131];
    v_[178] = v_[174] * v_[139] + v_[176] * v_[135] + v_[177] * v_[133];
    v_[179] = 0.33 * v_[144];
    v_[180] = v_[179] * v_[137];
    v_[181] = -0.33 * v_[144];
    v_[182] = v_[181] * v_[133];
    v_[183] = 0.35 * v_[144];
    v_[184] = v_[180] * v_[139] + v_[182] * v_[135] + v_[183] * v_[137] + 0.08 * v_[144];
    v_[185] = 0.33 * v_[144];
    v_[186] = v_[185] * v_[137];
    v_[187] = -0.33 * v_[144];
    v_[188] = v_[187] * v_[133];
    v_[189] = 0.35 * v_[144];
    v_[190] = -0.207 + v_[186] * v_[139] + v_[188] * v_[135] + v_[189] * v_[137] + 0.08 * v_[144];
    v_[191] = -0.33 * v_[137];
    v_[192] = 0.33 * v_[133];
    v_[193] = 0.3735 + v_[191] * v_[135] - v_[192] * v_[139] - 0.35 * v_[133];
    v_[194] = v_[173] * x_in[29] + v_[178] * x_in[28] + v_[184] * x_in[27] + x_in[23] + x_in[18] * v_[190] - x_in[19] * v_[193];
    v_[195] = v_[167] * v_[161] + v_[159] * v_[164];
    v_[196] = v_[157] * v_[158] + v_[163] * v_[154];
    v_[197] = -0.33 * v_[144];
    v_[198] = v_[197] * v_[137];
    v_[199] = 0.33 * v_[144];
    v_[200] = v_[199] * v_[133];
    v_[201] = v_[198] * v_[135] - v_[200] * v_[139];
    v_[202] = v_[181] * v_[137];
    v_[203] = 0.33 * v_[144];
    v_[204] = v_[203] * v_[133];
    v_[144] = 0.35 * v_[144];
    v_[205] = v_[202] * v_[135] - v_[204] * v_[139] - v_[144] * v_[133];
    v_[206] = 0.33 * v_[131];
    v_[207] = v_[206] * v_[137];
    v_[208] = -0.33 * v_[131];
    v_[209] = v_[208] * v_[133];
    v_[210] = 0.35 * v_[131];
    v_[211] = v_[207] * v_[139] + v_[209] * v_[135] + v_[210] * v_[137] + 0.08 * v_[131];
    v_[212] = 0.33 * v_[131];
    v_[213] = v_[212] * v_[133];
    v_[214] = 0.33 * v_[131];
    v_[215] = v_[214] * v_[137];
    v_[216] = 0.35 * v_[131];
    v_[131] = v_[213] * v_[135] - v_[215] * v_[139] - v_[216] * v_[137] - 0.08 * v_[131];
    v_[217] = v_[201] * x_in[29] + v_[205] * x_in[28] + v_[211] * x_in[27] + x_in[22] + x_in[20] * v_[193] - x_in[18] * v_[131];
    v_[162] = v_[157] * v_[162] + v_[163] * v_[156];
    v_[159] = v_[167] * v_[160] + v_[159] * v_[166];
    v_[218] = 0.33 * v_[133];
    v_[219] = 0.33 * v_[137];
    v_[220] = v_[218] * v_[135] - v_[219] * v_[139];
    v_[221] = 0.33 * v_[133];
    v_[222] = 0.33 * v_[137];
    v_[223] = v_[221] * v_[135] - v_[222] * v_[139] - 0.35 * v_[137];
    v_[224] = v_[220] * x_in[29] + v_[223] * x_in[28] + x_in[21] + x_in[19] * v_[131] - x_in[20] * v_[190];
    jac[9] = (v_[165] + v_[168]) * v_[194] + (v_[195] - v_[196]) * v_[217] + (0 - v_[162] - v_[159]) * v_[224];
    v_[160] = v_[157] * v_[160] + v_[163] * v_[166];
    v_[163] = 2. * v_[164];
    v_[225] = 2. * v_[161];
    v_[158] = v_[163] * v_[158] + v_[225] * v_[154];
    v_[225] = v_[163] * v_[161] + v_[225] * v_[164];
    jac[10] = (v_[160] - v_[158]) * v_[194] + (0 - v_[162] - v_[225]) * v_[217] + (v_[195] + v_[196]) * v_[224];
    jac[11] = (0 - v_[159] - v_[225]) * v_[194] + (v_[160] + v_[158]) * v_[217] + (v_[165] - v_[168]) * v_[224];
    v_[225] = 0.5 * x_in[0];
    v_[158] = cos(v_[225]);
    v_[160] = 0.5 * x_in[1];
    v_[159] = cos(v_[160]);
    v_[168] = v_[158] * v_[159];
    v_[165] = 0.5 * x_in[2];
    v_[162] = sin(v_[165]);
    v_[196] = sin(v_[225]);
    v_[195] = sin(v_[160]);
    v_[161] = v_[196] * v_[195];
    v_[226] = cos(v_[165]);
    v_[227] = v_[168] * v_[162] + v_[161] * v_[226];
    v_[228] = 2. * v_[227];
    v_[229] = 0.5 * cos(v_[225]);
    v_[230] = v_[229] * v_[159];
    v_[225] = -0.5 * sin(v_[225]);
    v_[231] = v_[225] * v_[195];
    v_[232] = v_[230] * v_[226] + v_[231] * v_[162];
    v_[225] = v_[225] * v_[159];
    v_[229] = v_[229] * v_[195];
    v_[233] = v_[225] * v_[162] + v_[229] * v_[226];
    v_[234] = 2. * v_[233];
    v_[159] = v_[196] * v_[159];
    v_[195] = v_[158] * v_[195];
    v_[235] = v_[159] * v_[226] + v_[195] * v_[162];
    v_[236] = v_[228] * v_[232] + v_[234] * v_[235];
    v_[237] = v_[195] * v_[226] - v_[159] * v_[162];
    v_[238] = 2. * v_[237];
    v_[229] = v_[225] * v_[226] - v_[229] * v_[162];
    v_[231] = v_[231] * v_[226] - v_[230] * v_[162];
    v_[230] = 2. * v_[231];
    v_[225] = v_[168] * v_[226] - v_[161] * v_[162];
    v_[239] = v_[238] * v_[229] + v_[230] * v_[225];
    v_[240] = cos(x_in[12]);
    v_[241] = 0.33 * v_[240];
    v_[242] = sin(x_in[13]);
    v_[243] = v_[241] * v_[242];
    v_[244] = sin(x_in[14]);
    v_[245] = 0.33 * v_[240];
    v_[246] = cos(x_in[13]);
    v_[247] = v_[245] * v_[246];
    v_[248] = cos(x_in[14]);
    v_[249] = 0.35 * v_[240];
    v_[250] = v_[243] * v_[244] - v_[247] * v_[248] - v_[249] * v_[246] - 0.08 * v_[240];
    v_[251] = v_[238] * v_[232] + v_[230] * v_[235];
    v_[252] = v_[228] * v_[229] + v_[234] * v_[225];
    v_[253] = sin(x_in[12]);
    v_[254] = 0.33 * v_[253];
    v_[255] = v_[254] * v_[242];
    v_[256] = 0.33 * v_[253];
    v_[257] = v_[256] * v_[246];
    v_[258] = 0.35 * v_[253];
    v_[259] = 0.207 + v_[255] * v_[244] - v_[257] * v_[248] - v_[258] * v_[246] - 0.08 * v_[253];
    v_[233] = v_[228] * v_[233] + v_[234] * v_[227];
    v_[230] = v_[238] * v_[231] + v_[230] * v_[237];
    v_[260] = -0.33 * v_[246];
    v_[261] = 0.33 * v_[242];
    v_[262] = -0.3735 + v_[260] * v_[244] - v_[261] * v_[248] - 0.35 * v_[242];
    jac[12] = (v_[236] + v_[239]) * v_[250] + (v_[251] - v_[252]) * v_[259] + (0 - v_[233] - v_[230]) * v_[262];
    v_[231] = v_[228] * v_[231] + v_[234] * v_[237];
    v_[234] = 2. * v_[235];
    v_[263] = 2. * v_[232];
    v_[229] = v_[234] * v_[229] + v_[263] * v_[225];
    v_[263] = v_[234] * v_[232] + v_[263] * v_[235];
    jac[13] = (v_[231] - v_[229]) * v_[250] + (0 - v_[233] - v_[263]) * v_[259] + (v_[251] + v_[252]) * v_[262];
    jac[14] = (0 - v_[230] - v_[263]) * v_[250] + (v_[231] + v_[229]) * v_[259] + (v_[236] - v_[239]) * v_[262];
    v_[263] = 0.5 * x_in[0];
    v_[229] = cos(v_[263]);
    v_[231] = 0.5 * x_in[1];
    v_[230] = cos(v_[231]);
    v_[239] = v_[229] * v_[230];
    v_[236] = 0.5 * x_in[2];
    v_[233] = sin(v_[236]);
    v_[252] = sin(v_[263]);
    v_[251] = sin(v_[231]);
    v_[232] = v_[252] * v_[251];
    v_[264] = cos(v_[236]);
    v_[265] = v_[239] * v_[233] + v_[232] * v_[264];
    v_[266] = 2. * v_[265];
    v_[267] = 0.5 * cos(v_[263]);
    v_[268] = v_[267] * v_[230];
    v_[263] = -0.5 * sin(v_[263]);
    v_[269] = v_[263] * v_[251];
    v_[270] = v_[268] * v_[264] + v_[269] * v_[233];
    v_[263] = v_[263] * v_[230];
    v_[267] = v_[267] * v_[251];
    v_[271] = v_[263] * v_[233] + v_[267] * v_[264];
    v_[272] = 2. * v_[271];
    v_[230] = v_[252] * v_[230];
    v_[251] = v_[229] * v_[251];
    v_[273] = v_[230] * v_[264] + v_[251] * v_[233];
    v_[274] = v_[266] * v_[270] + v_[272] * v_[273];
    v_[275] = v_[251] * v_[264] - v_[230] * v_[233];
    v_[276] = 2. * v_[275];
    v_[267] = v_[263] * v_[264] - v_[267] * v_[233];
    v_[269] = v_[269] * v_[264] - v_[268] * v_[233];
    v_[268] = 2. * v_[269];
    v_[263] = v_[239] * v_[264] - v_[232] * v_[233];
    v_[277] = v_[276] * v_[267] + v_[268] * v_[263];
    v_[278] = 0.33 * v_[240];
    v_[279] = v_[278] * v_[246];
    v_[280] = 0.33 * v_[240];
    v_[281] = v_[280] * v_[242];
    v_[282] = v_[279] * v_[244] + v_[281] * v_[248];
    v_[283] = v_[278] * v_[242];
    v_[284] = 0.33 * v_[240];
    v_[285] = v_[284] * v_[246];
    v_[286] = 0.35 * v_[240];
    v_[287] = v_[283] * v_[248] + v_[285] * v_[244] + v_[286] * v_[242];
    v_[288] = 0.33 * v_[253];
    v_[289] = v_[288] * v_[246];
    v_[290] = -0.33 * v_[253];
    v_[291] = v_[290] * v_[242];
    v_[292] = 0.35 * v_[253];
    v_[293] = v_[289] * v_[248] + v_[291] * v_[244] + v_[292] * v_[246] + 0.08 * v_[253];
    v_[294] = 0.33 * v_[253];
    v_[295] = v_[294] * v_[242];
    v_[296] = sin(x_in[14]);
    v_[297] = 0.33 * v_[253];
    v_[298] = v_[297] * v_[246];
    v_[299] = 0.35 * v_[253];
    v_[300] = 0.207 + v_[295] * v_[296] - v_[298] * v_[248] - v_[299] * v_[246] - 0.08 * v_[253];
    v_[301] = -0.33 * v_[246];
    v_[302] = 0.33 * v_[242];
    v_[303] = -0.3735 + v_[301] * v_[296] - v_[302] * v_[248] - 0.35 * v_[242];
    v_[304] = v_[282] * x_in[32] + v_[287] * x_in[31] + v_[293] * x_in[30] + x_in[23] + x_in[18] * v_[300] - x_in[19] * v_[303];
    v_[305] = v_[276] * v_[270] + v_[268] * v_[273];
    v_[306] = v_[266] * v_[267] + v_[272] * v_[263];
    v_[307] = 0.33 * v_[253];
    v_[308] = v_[307] * v_[246];
    v_[309] = 0.33 * v_[253];
    v_[310] = v_[309] * v_[242];
    v_[311] = v_[308] * v_[244] + v_[310] * v_[248];
    v_[312] = v_[307] * v_[242];
    v_[313] = 0.33 * v_[253];
    v_[314] = v_[313] * v_[246];
    v_[253] = 0.35 * v_[253];
    v_[315] = v_[312] * v_[248] + v_[314] * v_[244] + v_[253] * v_[242];
    v_[316] = 0.33 * v_[240];
    v_[317] = v_[316] * v_[242];
    v_[318] = 0.33 * v_[240];
    v_[319] = v_[318] * v_[246];
    v_[320] = 0.35 * v_[240];
    v_[321] = v_[317] * v_[244] - v_[319] * v_[248] - v_[320] * v_[246] - 0.08 * v_[240];
    v_[322] = 0.33 * v_[240];
    v_[323] = v_[322] * v_[242];
    v_[324] = 0.33 * v_[240];
    v_[325] = v_[324] * v_[246];
    v_[326] = 0.35 * v_[240];
    v_[240] = v_[323] * v_[296] - v_[325] * v_[248] - v_[326] * v_[246] - 0.08 * v_[240];
    v_[327] = v_[311] * x_in[32] + v_[315] * x_in[31] + v_[321] * x_in[30] + x_in[22] + x_in[20] * v_[303] - x_in[18] * v_[240];
    v_[271] = v_[266] * v_[271] + v_[272] * v_[265];
    v_[268] = v_[276] * v_[269] + v_[268] * v_[275];
    v_[328] = 0.33 * v_[242];
    v_[329] = 0.33 * v_[246];
    v_[330] = v_[328] * v_[244] - v_[329] * v_[248];
    v_[331] = 0.33 * v_[242];
    v_[332] = 0.33 * v_[246];
    v_[333] = v_[331] * v_[244] - v_[332] * v_[248] - 0.35 * v_[246];
    v_[334] = v_[330] * x_in[32] + v_[333] * x_in[31] + x_in[21] + x_in[19] * v_[240] - x_in[20] * v_[300];
    jac[15] = (v_[274] + v_[277]) * v_[304] + (v_[305] - v_[306]) * v_[327] + (0 - v_[271] - v_[268]) * v_[334];
    v_[269] = v_[266] * v_[269] + v_[272] * v_[275];
    v_[272] = 2. * v_[273];
    v_[335] = 2. * v_[270];
    v_[267] = v_[272] * v_[267] + v_[335] * v_[263];
    v_[335] = v_[272] * v_[270] + v_[335] * v_[273];
    jac[16] = (v_[269] - v_[267]) * v_[304] + (0 - v_[271] - v_[335]) * v_[327] + (v_[305] + v_[306]) * v_[334];
    jac[17] = (0 - v_[268] - v_[335]) * v_[304] + (v_[269] + v_[267]) * v_[327] + (v_[274] - v_[277]) * v_[334];
    v_[335] = 0.5 * x_in[0];
    v_[267] = cos(v_[335]);
    v_[269] = 0.5 * x_in[1];
    v_[268] = cos(v_[269]);
    v_[277] = v_[267] * v_[268];
    v_[274] = 0.5 * x_in[2];
    v_[271] = sin(v_[274]);
    v_[306] = sin(v_[335]);
    v_[305] = sin(v_[269]);
    v_[270] = v_[306] * v_[305];
    v_[336] = cos(v_[274]);
    v_[337] = v_[277] * v_[271] + v_[270] * v_[336];
    v_[338] = 2. * v_[337];
    v_[339] = 0.5 * cos(v_[335]);
    v_[340] = v_[339] * v_[268];
    v_[335] = -0.5 * sin(v_[335]);
    v_[341] = v_[335] * v_[305];
    v_[342] = v_[340] * v_[336] + v_[341] * v_[271];
    v_[335] = v_[335] * v_[268];
    v_[339] = v_[339] * v_[305];
    v_[343] = v_[335] * v_[271] + v_[339] * v_[336];
    v_[344] = 2. * v_[343];
    v_[268] = v_[306] * v_[268];
    v_[305] = v_[267] * v_[305];
    v_[345] = v_[268] * v_[336] + v_[305] * v_[271];
    v_[346] = v_[338] * v_[342] + v_[344] * v_[345];
    v_[347] = v_[305] * v_[336] - v_[268] * v_[271];
    v_[348] = 2. * v_[347];
    v_[339] = v_[335] * v_[336] - v_[339] * v_[271];
    v_[341] = v_[341] * v_[336] - v_[340] * v_[271];
    v_[340] = 2. * v_[341];
    v_[335] = v_[277] * v_[336] - v_[270] * v_[271];
    v_[349] = v_[348] * v_[339] + v_[340] * v_[335];
    v_[350] = cos(x_in[15]);
    v_[351] = 0.33 * v_[350];
    v_[352] = sin(x_in[16]);
    v_[353] = v_[351] * v_[352];
    v_[354] = sin(x_in[17]);
    v_[355] = 0.33 * v_[350];
    v_[356] = cos(x_in[16]);
    v_[357] = v_[355] * v_[356];
    v_[358] = cos(x_in[17]);
    v_[359] = 0.35 * v_[350];
    v_[360] = v_[353] * v_[354] - v_[357] * v_[358] - v_[359] * v_[356] - 0.08 * v_[350];
    v_[361] = v_[348] * v_[342] + v_[340] * v_[345];
    v_[362] = v_[338] * v_[339] + v_[344] * v_[335];
    v_[363] = sin(x_in[15]);
    v_[364] = 0.33 * v_[363];
    v_[365] = v_[364] * v_[356];
    v_[366] = -0.33 * v_[363];
    v_[367] = v_[366] * v_[352];
    v_[368] = 0.35 * v_[363];
    v_[369] = -0.207 + v_[365] * v_[358] + v_[367] * v_[354] + v_[368] * v_[356] + 0.08 * v_[363];
    v_[343] = v_[338] * v_[343] + v_[344] * v_[337];
    v_[340] = v_[348] * v_[341] + v_[340] * v_[347];
    v_[370] = -0.33 * v_[356];
    v_[371] = 0.33 * v_[352];
    v_[372] = -0.3735 + v_[370] * v_[354] - v_[371] * v_[358] - 0.35 * v_[352];
    jac[18] = (v_[346] + v_[349]) * v_[360] + (v_[361] - v_[362]) * v_[369] + (0 - v_[343] - v_[340]) * v_[372];
    v_[341] = v_[338] * v_[341] + v_[344] * v_[347];
    v_[344] = 2. * v_[345];
    v_[373] = 2. * v_[342];
    v_[339] = v_[344] * v_[339] + v_[373] * v_[335];
    v_[373] = v_[344] * v_[342] + v_[373] * v_[345];
    jac[19] = (v_[341] - v_[339]) * v_[360] + (0 - v_[343] - v_[373]) * v_[369] + (v_[361] + v_[362]) * v_[372];
    jac[20] = (0 - v_[340] - v_[373]) * v_[360] + (v_[341] + v_[339]) * v_[369] + (v_[346] - v_[349]) * v_[372];
    v_[373] = 0.5 * x_in[0];
    v_[339] = cos(v_[373]);
    v_[341] = 0.5 * x_in[1];
    v_[340] = cos(v_[341]);
    v_[349] = v_[339] * v_[340];
    v_[346] = 0.5 * x_in[2];
    v_[343] = sin(v_[346]);
    v_[362] = sin(v_[373]);
    v_[361] = sin(v_[341]);
    v_[342] = v_[362] * v_[361];
    v_[374] = cos(v_[346]);
    v_[375] = v_[349] * v_[343] + v_[342] * v_[374];
    v_[376] = 2. * v_[375];
    v_[377] = 0.5 * cos(v_[373]);
    v_[378] = v_[377] * v_[340];
    v_[373] = -0.5 * sin(v_[373]);
    v_[379] = v_[373] * v_[361];
    v_[380] = v_[378] * v_[374] + v_[379] * v_[343];
    v_[373] = v_[373] * v_[340];
    v_[377] = v_[377] * v_[361];
    v_[381] = v_[373] * v_[343] + v_[377] * v_[374];
    v_[382] = 2. * v_[381];
    v_[340] = v_[362] * v_[340];
    v_[361] = v_[339] * v_[361];
    v_[383] = v_[340] * v_[374] + v_[361] * v_[343];
    v_[384] = v_[376] * v_[380] + v_[382] * v_[383];
    v_[385] = v_[361] * v_[374] - v_[340] * v_[343];
    v_[386] = 2. * v_[385];
    v_[377] = v_[373] * v_[374] - v_[377] * v_[343];
    v_[379] = v_[379] * v_[374] - v_[378] * v_[343];
    v_[378] = 2. * v_[379];
    v_[373] = v_[349] * v_[374] - v_[342] * v_[343];
    v_[387] = v_[386] * v_[377] + v_[378] * v_[373];
    v_[388] = 0.33 * v_[350];
    v_[389] = v_[388] * v_[356];
    v_[390] = 0.33 * v_[350];
    v_[391] = v_[390] * v_[352];
    v_[392] = v_[389] * v_[354] + v_[391] * v_[358];
    v_[393] = v_[388] * v_[352];
    v_[394] = 0.33 * v_[350];
    v_[395] = v_[394] * v_[356];
    v_[396] = 0.35 * v_[350];
    v_[397] = v_[393] * v_[358] + v_[395] * v_[354] + v_[396] * v_[352];
    v_[398] = 0.33 * v_[363];
    v_[399] = v_[398] * v_[356];
    v_[400] = -0.33 * v_[363];
    v_[401] = v_[400] * v_[352];
    v_[402] = 0.35 * v_[363];
    v_[403] = v_[399] * v_[358] + v_[401] * v_[354] + v_[402] * v_[356] + 0.08 * v_[363];
    v_[404] = 0.33 * v_[363];
    v_[405] = v_[404] * v_[356];
    v_[406] = -0.33 * v_[363];
    v_[407] = v_[406] * v_[352];
    v_[408] = 0.35 * v_[363];
    v_[409] = -0.207 + v_[405] * v_[358] + v_[407] * v_[354] + v_[408] * v_[356] + 0.08 * v_[363];
    v_[410] = -0.33 * v_[356];
    v_[411] = 0.33 * v_[352];
    v_[412] = -0.3735 + v_[410] * v_[354] - v_[411] * v_[358] - 0.35 * v_[352];
    v_[413] = v_[392] * x_in[35] + v_[397] * x_in[34] + v_[403] * x_in[33] + x_in[23] + x_in[18] * v_[409] - x_in[19] * v_[412];
    v_[414] = v_[386] * v_[380] + v_[378] * v_[383];
    v_[415] = v_[376] * v_[377] + v_[382] * v_[373];
    v_[416] = -0.33 * v_[363];
    v_[417] = v_[416] * v_[356];
    v_[418] = 0.33 * v_[363];
    v_[419] = v_[418] * v_[352];
    v_[420] = v_[417] * v_[354] - v_[419] * v_[358];
    v_[421] = v_[400] * v_[356];
    v_[422] = 0.33 * v_[363];
    v_[423] = v_[422] * v_[352];
    v_[363] = 0.35 * v_[363];
    v_[424] = v_[421] * v_[354] - v_[423] * v_[358] - v_[363] * v_[352];
    v_[425] = 0.33 * v_[350];
    v_[426] = v_[425] * v_[356];
    v_[427] = -0.33 * v_[350];
    v_[428] = v_[427] * v_[352];
    v_[429] = 0.35 * v_[350];
    v_[430] = v_[426] * v_[358] + v_[428] * v_[354] + v_[429] * v_[356] + 0.08 * v_[350];
    v_[431] = 0.33 * v_[350];
    v_[432] = v_[431] * v_[352];
    v_[433] = 0.33 * v_[350];
    v_[434] = v_[433] * v_[356];
    v_[435] = 0.35 * v_[350];
    v_[350] = v_[432] * v_[354] - v_[434] * v_[358] - v_[435] * v_[356] - 0.08 * v_[350];
    v_[436] = v_[420] * x_in[35] + v_[424] * x_in[34] + v_[430] * x_in[33] + x_in[22] + x_in[20] * v_[412] - x_in[18] * v_[350];
    v_[381] = v_[376] * v_[381] + v_[382] * v_[375];
    v_[378] = v_[386] * v_[379] + v_[378] * v_[385];
    v_[437] = 0.33 * v_[352];
    v_[438] = 0.33 * v_[356];
    v_[439] = v_[437] * v_[354] - v_[438] * v_[358];
    v_[440] = 0.33 * v_[352];
    v_[441] = 0.33 * v_[356];
    v_[442] = v_[440] * v_[354] - v_[441] * v_[358] - 0.35 * v_[356];
    v_[443] = v_[439] * x_in[35] + v_[442] * x_in[34] + x_in[21] + x_in[19] * v_[350] - x_in[20] * v_[409];
    jac[21] = (v_[384] + v_[387]) * v_[413] + (v_[414] - v_[415]) * v_[436] + (0 - v_[381] - v_[378]) * v_[443];
    v_[379] = v_[376] * v_[379] + v_[382] * v_[385];
    v_[382] = 2. * v_[383];
    v_[444] = 2. * v_[380];
    v_[377] = v_[382] * v_[377] + v_[444] * v_[373];
    v_[444] = v_[382] * v_[380] + v_[444] * v_[383];
    jac[22] = (v_[379] - v_[377]) * v_[413] + (0 - v_[381] - v_[444]) * v_[436] + (v_[414] + v_[415]) * v_[443];
    jac[23] = (0 - v_[378] - v_[444]) * v_[413] + (v_[379] + v_[377]) * v_[436] + (v_[384] - v_[387]) * v_[443];
    v_[444] = -0.5 * sin(v_[2]);
    v_[377] = v_[7] * v_[444];
    v_[2] = 0.5 * cos(v_[2]);
    v_[379] = v_[1] * v_[2];
    v_[378] = v_[377] * v_[10] + v_[379] * v_[6];
    v_[444] = v_[1] * v_[444];
    v_[2] = v_[7] * v_[2];
    v_[7] = v_[444] * v_[6] + v_[2] * v_[10];
    v_[1] = 2. * v_[7];
    v_[387] = v_[12] * v_[378] + v_[1] * v_[19];
    v_[2] = v_[444] * v_[10] - v_[2] * v_[6];
    v_[379] = v_[379] * v_[10] - v_[377] * v_[6];
    v_[377] = 2. * v_[379];
    v_[10] = v_[22] * v_[2] + v_[377] * v_[0];
    v_[6] = v_[22] * v_[378] + v_[377] * v_[19];
    v_[444] = v_[12] * v_[2] + v_[1] * v_[0];
    v_[7] = v_[12] * v_[7] + v_[1] * v_[11];
    v_[377] = v_[22] * v_[379] + v_[377] * v_[21];
    jac[24] = (v_[387] + v_[10]) * v_[34] + (v_[6] - v_[444]) * v_[43] + (0 - v_[7] - v_[377]) * v_[46];
    v_[379] = v_[12] * v_[379] + v_[1] * v_[21];
    v_[1] = 2. * v_[378];
    v_[2] = v_[18] * v_[2] + v_[1] * v_[0];
    v_[1] = v_[18] * v_[378] + v_[1] * v_[19];
    jac[25] = (v_[379] - v_[2]) * v_[34] + (0 - v_[7] - v_[1]) * v_[43] + (v_[6] + v_[444]) * v_[46];
    jac[26] = (0 - v_[377] - v_[1]) * v_[34] + (v_[379] + v_[2]) * v_[43] + (v_[387] - v_[10]) * v_[46];
    v_[1] = -0.5 * sin(v_[15]);
    v_[2] = v_[36] * v_[1];
    v_[15] = 0.5 * cos(v_[15]);
    v_[379] = v_[13] * v_[15];
    v_[377] = v_[2] * v_[48] + v_[379] * v_[17];
    v_[1] = v_[13] * v_[1];
    v_[15] = v_[36] * v_[15];
    v_[36] = v_[1] * v_[17] + v_[15] * v_[48];
    v_[13] = 2. * v_[36];
    v_[10] = v_[50] * v_[377] + v_[13] * v_[57];
    v_[15] = v_[1] * v_[48] - v_[15] * v_[17];
    v_[379] = v_[379] * v_[48] - v_[2] * v_[17];
    v_[2] = 2. * v_[379];
    v_[48] = v_[60] * v_[15] + v_[2] * v_[47];
    v_[17] = v_[60] * v_[377] + v_[2] * v_[57];
    v_[1] = v_[50] * v_[15] + v_[13] * v_[47];
    v_[36] = v_[50] * v_[36] + v_[13] * v_[49];
    v_[2] = v_[60] * v_[379] + v_[2] * v_[59];
    jac[27] = (v_[10] + v_[48]) * v_[87] + (v_[17] - v_[1]) * v_[108] + (0 - v_[36] - v_[2]) * v_[115];
    v_[379] = v_[50] * v_[379] + v_[13] * v_[59];
    v_[13] = 2. * v_[377];
    v_[15] = v_[56] * v_[15] + v_[13] * v_[47];
    v_[13] = v_[56] * v_[377] + v_[13] * v_[57];
    jac[28] = (v_[379] - v_[15]) * v_[87] + (0 - v_[36] - v_[13]) * v_[108] + (v_[17] + v_[1]) * v_[115];
    jac[29] = (0 - v_[2] - v_[13]) * v_[87] + (v_[379] + v_[15]) * v_[108] + (v_[10] - v_[48]) * v_[115];
    v_[13] = -0.5 * sin(v_[53]);
    v_[15] = v_[89] * v_[13];
    v_[53] = 0.5 * cos(v_[53]);
    v_[379] = v_[51] * v_[53];
    v_[2] = v_[15] * v_[117] + v_[379] * v_[55];
    v_[13] = v_[51] * v_[13];
    v_[53] = v_[89] * v_[53];
    v_[89] = v_[13] * v_[55] + v_[53] * v_[117];
    v_[51] = 2. * v_[89];
    v_[48] = v_[119] * v_[2] + v_[51] * v_[126];
    v_[53] = v_[13] * v_[117] - v_[53] * v_[55];
    v_[379] = v_[379] * v_[117] - v_[15] * v_[55];
    v_[15] = 2. * v_[379];
    v_[117] = v_[129] * v_[53] + v_[15] * v_[116];
    v_[55] = v_[129] * v_[2] + v_[15] * v_[126];
    v_[13] = v_[119] * v_[53] + v_[51] * v_[116];
    v_[89] = v_[119] * v_[89] + v_[51] * v_[118];
    v_[15] = v_[129] * v_[379] + v_[15] * v_[128];
    jac[30] = (v_[48] + v_[117]) * v_[141] + (v_[55] - v_[13]) * v_[150] + (0 - v_[89] - v_[15]) * v_[153];
    v_[379] = v_[119] * v_[379] + v_[51] * v_[128];
    v_[51] = 2. * v_[2];
    v_[53] = v_[125] * v_[53] + v_[51] * v_[116];
    v_[51] = v_[125] * v_[2] + v_[51] * v_[126];
    jac[31] = (v_[379] - v_[53]) * v_[141] + (0 - v_[89] - v_[51]) * v_[150] + (v_[55] + v_[13]) * v_[153];
    jac[32] = (0 - v_[15] - v_[51]) * v_[141] + (v_[379] + v_[53]) * v_[150] + (v_[48] - v_[117]) * v_[153];
    v_[51] = -0.5 * sin(v_[122]);
    v_[53] = v_[143] * v_[51];
    v_[122] = 0.5 * cos(v_[122]);
    v_[379] = v_[120] * v_[122];
    v_[15] = v_[53] * v_[155] + v_[379] * v_[124];
    v_[51] = v_[120] * v_[51];
    v_[122] = v_[143] * v_[122];
    v_[143] = v_[51] * v_[124] + v_[122] * v_[155];
    v_[120] = 2. * v_[143];
    v_[117] = v_[157] * v_[15] + v_[120] * v_[164];
    v_[122] = v_[51] * v_[155] - v_[122] * v_[124];
    v_[379] = v_[379] * v_[155] - v_[53] * v_[124];
    v_[53] = 2. * v_[379];
    v_[155] = v_[167] * v_[122] + v_[53] * v_[154];
    v_[124] = v_[167] * v_[15] + v_[53] * v_[164];
    v_[51] = v_[157] * v_[122] + v_[120] * v_[154];
    v_[143] = v_[157] * v_[143] + v_[120] * v_[156];
    v_[53] = v_[167] * v_[379] + v_[53] * v_[166];
    jac[33] = (v_[117] + v_[155]) * v_[194] + (v_[124] - v_[51]) * v_[217] + (0 - v_[143] - v_[53]) * v_[224];
    v_[379] = v_[157] * v_[379] + v_[120] * v_[166];
    v_[120] = 2. * v_[15];
    v_[122] = v_[163] * v_[122] + v_[120] * v_[154];
    v_[120] = v_[163] * v_[15] + v_[120] * v_[164];
    jac[34] = (v_[379] - v_[122]) * v_[194] + (0 - v_[143] - v_[120]) * v_[217] + (v_[124] + v_[51]) * v_[224];
    jac[35] = (0 - v_[53] - v_[120]) * v_[194] + (v_[379] + v_[122]) * v_[217] + (v_[117] - v_[155]) * v_[224];
    v_[120] = -0.5 * sin(v_[160]);
    v_[122] = v_[196] * v_[120];
    v_[160] = 0.5 * cos(v_[160]);
    v_[379] = v_[158] * v_[160];
    v_[53] = v_[122] * v_[226] + v_[379] * v_[162];
    v_[120] = v_[158] * v_[120];
    v_[160] = v_[196] * v_[160];
    v_[196] = v_[120] * v_[162] + v_[160] * v_[226];
    v_[158] = 2. * v_[196];
    v_[155] = v_[228] * v_[53] + v_[158] * v_[235];
    v_[160] = v_[120] * v_[226] - v_[160] * v_[162];
    v_[379] = v_[379] * v_[226] - v_[122] * v_[162];
    v_[122] = 2. * v_[379];
    v_[226] = v_[238] * v_[160] + v_[122] * v_[225];
    v_[162] = v_[238] * v_[53] + v_[122] * v_[235];
    v_[120] = v_[228] * v_[160] + v_[158] * v_[225];
    v_[196] = v_[228] * v_[196] + v_[158] * v_[227];
    v_[122] = v_[238] * v_[379] + v_[122] * v_[237];
    jac[36] = (v_[155] + v_[226]) * v_[250] + (v_[162] - v_[120]) * v_[259] + (0 - v_[196] - v_[122]) * v_[262];
    v_[379] = v_[228] * v_[379] + v_[158] * v_[237];
    v_[158] = 2. * v_[53];
    v_[160] = v_[234] * v_[160] + v_[158] * v_[225];
    v_[158] = v_[234] * v_[53] + v_[158] * v_[235];
    jac[37] = (v_[379] - v_[160]) * v_[250] + (0 - v_[196] - v_[158]) * v_[259] + (v_[162] + v_[120]) * v_[262];
    jac[38] = (0 - v_[122] - v_[158]) * v_[250] + (v_[379] + v_[160]) * v_[259] + (v_[155] - v_[226]) * v_[262];
    v_[158] = -0.5 * sin(v_[231]);
    v_[160] = v_[252] * v_[158];
    v_[231] = 0.5 * cos(v_[231]);
    v_[379] = v_[229] * v_[231];
    v_[122] = v_[160] * v_[264] + v_[379] * v_[233];
    v_[158] = v_[229] * v_[158];
    v_[231] = v_[252] * v_[231];
    v_[252] = v_[158] * v_[233] + v_[231] * v_[264];
    v_[229] = 2. * v_[252];
    v_[226] = v_[266] * v_[122] + v_[229] * v_[273];
    v_[231] = v_[158] * v_[264] - v_[231] * v_[233];
    v_[379] = v_[379] * v_[264] - v_[160] * v_[233];
    v_[160] = 2. * v_[379];
    v_[264] = v_[276] * v_[231] + v_[160] * v_[263];
    v_[233] = v_[276] * v_[122] + v_[160] * v_[273];
    v_[158] = v_[266] * v_[231] + v_[229] * v_[263];
    v_[252] = v_[266] * v_[252] + v_[229] * v_[265];
    v_[160] = v_[276] * v_[379] + v_[160] * v_[275];
    jac[39] = (v_[226] + v_[264]) * v_[304] + (v_[233] - v_[158]) * v_[327] + (0 - v_[252] - v_[160]) * v_[334];
    v_[379] = v_[266] * v_[379] + v_[229] * v_[275];
    v_[229] = 2. * v_[122];
    v_[231] = v_[272] * v_[231] + v_[229] * v_[263];
    v_[229] = v_[272] * v_[122] + v_[229] * v_[273];
    jac[40] = (v_[379] - v_[231]) * v_[304] + (0 - v_[252] - v_[229]) * v_[327] + (v_[233] + v_[158]) * v_[334];
    jac[41] = (0 - v_[160] - v_[229]) * v_[304] + (v_[379] + v_[231]) * v_[327] + (v_[226] - v_[264]) * v_[334];
    v_[229] = -0.5 * sin(v_[269]);
    v_[231] = v_[306] * v_[229];
    v_[269] = 0.5 * cos(v_[269]);
    v_[379] = v_[267] * v_[269];
    v_[160] = v_[231] * v_[336] + v_[379] * v_[271];
    v_[229] = v_[267] * v_[229];
    v_[269] = v_[306] * v_[269];
    v_[306] = v_[229] * v_[271] + v_[269] * v_[336];
    v_[267] = 2. * v_[306];
    v_[264] = v_[338] * v_[160] + v_[267] * v_[345];
    v_[269] = v_[229] * v_[336] - v_[269] * v_[271];
    v_[379] = v_[379] * v_[336] - v_[231] * v_[271];
    v_[231] = 2. * v_[379];
    v_[336] = v_[348] * v_[269] + v_[231] * v_[335];
    v_[271] = v_[348] * v_[160] + v_[231] * v_[345];
    v_[229] = v_[338] * v_[269] + v_[267] * v_[335];
    v_[306] = v_[338] * v_[306] + v_[267] * v_[337];
    v_[231] = v_[348] * v_[379] + v_[231] * v_[347];
    jac[42] = (v_[264] + v_[336]) * v_[360] + (v_[271] - v_[229]) * v_[369] + (0 - v_[306] - v_[231]) * v_[372];
    v_[379] = v_[338] * v_[379] + v_[267] * v_[347];
    v_[267] = 2. * v_[160];
    v_[269] = v_[344] * v_[269] + v_[267] * v_[335];
    v_[267] = v_[344] * v_[160] + v_[267] * v_[345];
    jac[43] = (v_[379] - v_[269]) * v_[360] + (0 - v_[306] - v_[267]) * v_[369] + (v_[271] + v_[229]) * v_[372];
    jac[44] = (0 - v_[231] - v_[267]) * v_[360] + (v_[379] + v_[269]) * v_[369] + (v_[264] - v_[336]) * v_[372];
    v_[267] = -0.5 * sin(v_[341]);
    v_[269] = v_[362] * v_[267];
    v_[341] = 0.5 * cos(v_[341]);
    v_[379] = v_[339] * v_[341];
    v_[231] = v_[269] * v_[374] + v_[379] * v_[343];
    v_[267] = v_[339] * v_[267];
    v_[341] = v_[362] * v_[341];
    v_[362] = v_[267] * v_[343] + v_[341] * v_[374];
    v_[339] = 2. * v_[362];
    v_[336] = v_[376] * v_[231] + v_[339] * v_[383];
    v_[341] = v_[267] * v_[374] - v_[341] * v_[343];
    v_[379] = v_[379] * v_[374] - v_[269] * v_[343];
    v_[269] = 2. * v_[379];
    v_[374] = v_[386] * v_[341] + v_[269] * v_[373];
    v_[343] = v_[386] * v_[231] + v_[269] * v_[383];
    v_[267] = v_[376] * v_[341] + v_[339] * v_[373];
    v_[362] = v_[376] * v_[362] + v_[339] * v_[375];
    v_[269] = v_[386] * v_[379] + v_[269] * v_[385];
    jac[45] = (v_[336] + v_[374]) * v_[413] + (v_[343] - v_[267]) * v_[436] + (0 - v_[362] - v_[269]) * v_[443];
    v_[379] = v_[376] * v_[379] + v_[339] * v_[385];
    v_[339] = 2. * v_[231];
    v_[341] = v_[382] * v_[341] + v_[339] * v_[373];
    v_[339] = v_[382] * v_[231] + v_[339] * v_[383];
    jac[46] = (v_[379] - v_[341]) * v_[413] + (0 - v_[362] - v_[339]) * v_[436] + (v_[343] + v_[267]) * v_[443];
    jac[47] = (0 - v_[269] - v_[339]) * v_[413] + (v_[379] + v_[341]) * v_[436] + (v_[336] - v_[374]) * v_[443];
    v_[339] = -0.5 * sin(v_[5]);
    v_[5] = 0.5 * cos(v_[5]);
    v_[341] = v_[3] * v_[339] + v_[8] * v_[5];
    v_[379] = v_[4] * v_[5] + v_[9] * v_[339];
    v_[269] = 2. * v_[379];
    v_[374] = v_[12] * v_[341] + v_[269] * v_[19];
    v_[9] = v_[4] * v_[339] - v_[9] * v_[5];
    v_[5] = v_[8] * v_[339] - v_[3] * v_[5];
    v_[339] = 2. * v_[5];
    v_[8] = v_[22] * v_[9] + v_[339] * v_[0];
    v_[3] = v_[22] * v_[341] + v_[339] * v_[19];
    v_[4] = v_[12] * v_[9] + v_[269] * v_[0];
    v_[379] = v_[12] * v_[379] + v_[269] * v_[11];
    v_[339] = v_[22] * v_[5] + v_[339] * v_[21];
    jac[48] = (v_[374] + v_[8]) * v_[34] + (v_[3] - v_[4]) * v_[43] + (0 - v_[379] - v_[339]) * v_[46];
    v_[5] = v_[12] * v_[5] + v_[269] * v_[21];
    v_[269] = 2. * v_[341];
    v_[9] = v_[18] * v_[9] + v_[269] * v_[0];
    v_[269] = v_[18] * v_[341] + v_[269] * v_[19];
    jac[49] = (v_[5] - v_[9]) * v_[34] + (0 - v_[379] - v_[269]) * v_[43] + (v_[3] + v_[4]) * v_[46];
    jac[50] = (0 - v_[339] - v_[269]) * v_[34] + (v_[5] + v_[9]) * v_[43] + (v_[374] - v_[8]) * v_[46];
    v_[269] = -0.5 * sin(v_[20]);
    v_[20] = 0.5 * cos(v_[20]);
    v_[9] = v_[14] * v_[269] + v_[35] * v_[20];
    v_[5] = v_[23] * v_[20] + v_[16] * v_[269];
    v_[339] = 2. * v_[5];
    v_[8] = v_[50] * v_[9] + v_[339] * v_[57];
    v_[16] = v_[23] * v_[269] - v_[16] * v_[20];
    v_[20] = v_[35] * v_[269] - v_[14] * v_[20];
    v_[269] = 2. * v_[20];
    v_[35] = v_[60] * v_[16] + v_[269] * v_[47];
    v_[14] = v_[60] * v_[9] + v_[269] * v_[57];
    v_[23] = v_[50] * v_[16] + v_[339] * v_[47];
    v_[5] = v_[50] * v_[5] + v_[339] * v_[49];
    v_[269] = v_[60] * v_[20] + v_[269] * v_[59];
    jac[51] = (v_[8] + v_[35]) * v_[87] + (v_[14] - v_[23]) * v_[108] + (0 - v_[5] - v_[269]) * v_[115];
    v_[20] = v_[50] * v_[20] + v_[339] * v_[59];
    v_[339] = 2. * v_[9];
    v_[16] = v_[56] * v_[16] + v_[339] * v_[47];
    v_[339] = v_[56] * v_[9] + v_[339] * v_[57];
    jac[52] = (v_[20] - v_[16]) * v_[87] + (0 - v_[5] - v_[339]) * v_[108] + (v_[14] + v_[23]) * v_[115];
    jac[53] = (0 - v_[269] - v_[339]) * v_[87] + (v_[20] + v_[16]) * v_[108] + (v_[8] - v_[35]) * v_[115];
    v_[339] = -0.5 * sin(v_[58]);
    v_[58] = 0.5 * cos(v_[58]);
    v_[16] = v_[52] * v_[339] + v_[88] * v_[58];
    v_[20] = v_[61] * v_[58] + v_[54] * v_[339];
    v_[269] = 2. * v_[20];
    v_[35] = v_[119] * v_[16] + v_[269] * v_[126];
    v_[54] = v_[61] * v_[339] - v_[54] * v_[58];
    v_[58] = v_[88] * v_[339] - v_[52] * v_[58];
    v_[339] = 2. * v_[58];
    v_[88] = v_[129] * v_[54] + v_[339] * v_[116];
    v_[52] = v_[129] * v_[16] + v_[339] * v_[126];
    v_[61] = v_[119] * v_[54] + v_[269] * v_[116];
    v_[20] = v_[119] * v_[20] + v_[269] * v_[118];
    v_[339] = v_[129] * v_[58] + v_[339] * v_[128];
    jac[54] = (v_[35] + v_[88]) * v_[141] + (v_[52] - v_[61]) * v_[150] + (0 - v_[20] - v_[339]) * v_[153];
    v_[58] = v_[119] * v_[58] + v_[269] * v_[128];
    v_[269] = 2. * v_[16];
    v_[54] = v_[125] * v_[54] + v_[269] * v_[116];
    v_[269] = v_[125] * v_[16] + v_[269] * v_[126];
    jac[55] = (v_[58] - v_[54]) * v_[141] + (0 - v_[20] - v_[269]) * v_[150] + (v_[52] + v_[61]) * v_[153];
    jac[56] = (0 - v_[339] - v_[269]) * v_[141] + (v_[58] + v_[54]) * v_[150] + (v_[35] - v_[88]) * v_[153];
    v_[269] = -0.5 * sin(v_[127]);
    v_[127] = 0.5 * cos(v_[127]);
    v_[54] = v_[121] * v_[269] + v_[142] * v_[127];
    v_[58] = v_[130] * v_[127] + v_[123] * v_[269];
    v_[339] = 2. * v_[58];
    v_[88] = v_[157] * v_[54] + v_[339] * v_[164];
    v_[123] = v_[130] * v_[269] - v_[123] * v_[127];
    v_[127] = v_[142] * v_[269] - v_[121] * v_[127];
    v_[269] = 2. * v_[127];
    v_[142] = v_[167] * v_[123] + v_[269] * v_[154];
    v_[121] = v_[167] * v_[54] + v_[269] * v_[164];
    v_[130] = v_[157] * v_[123] + v_[339] * v_[154];
    v_[58] = v_[157] * v_[58] + v_[339] * v_[156];
    v_[269] = v_[167] * v_[127] + v_[269] * v_[166];
    jac[57] = (v_[88] + v_[142]) * v_[194] + (v_[121] - v_[130]) * v_[217] + (0 - v_[58] - v_[269]) * v_[224];
    v_[127] = v_[157] * v_[127] + v_[339] * v_[166];
    v_[339] = 2. * v_[54];
    v_[123] = v_[163] * v_[123] + v_[339] * v_[154];
    v_[339] = v_[163] * v_[54] + v_[339] * v_[164];
    jac[58] = (v_[127] - v_[123]) * v_[194] + (0 - v_[58] - v_[339]) * v_[217] + (v_[121] + v_[130]) * v_[224];
    jac[59] = (0 - v_[269] - v_[339]) * v_[194] + (v_[127] + v_[123]) * v_[217] + (v_[88] - v_[142]) * v_[224];
    v_[339] = -0.5 * sin(v_[165]);
    v_[165] = 0.5 * cos(v_[165]);
    v_[123] = v_[159] * v_[339] + v_[195] * v_[165];
    v_[127] = v_[168] * v_[165] + v_[161] * v_[339];
    v_[269] = 2. * v_[127];
    v_[142] = v_[228] * v_[123] + v_[269] * v_[235];
    v_[161] = v_[168] * v_[339] - v_[161] * v_[165];
    v_[165] = v_[195] * v_[339] - v_[159] * v_[165];
    v_[339] = 2. * v_[165];
    v_[195] = v_[238] * v_[161] + v_[339] * v_[225];
    v_[159] = v_[238] * v_[123] + v_[339] * v_[235];
    v_[168] = v_[228] * v_[161] + v_[269] * v_[225];
    v_[127] = v_[228] * v_[127] + v_[269] * v_[227];
    v_[339] = v_[238] * v_[165] + v_[339] * v_[237];
    jac[60] = (v_[142] + v_[195]) * v_[250] + (v_[159] - v_[168]) * v_[259] + (0 - v_[127] - v_[339]) * v_[262];
    v_[165] = v_[228] * v_[165] + v_[269] * v_[237];
    v_[269] = 2. * v_[123];
    v_[161] = v_[234] * v_[161] + v_[269] * v_[225];
    v_[269] = v_[234] * v_[123] + v_[269] * v_[235];
    jac[61] = (v_[165] - v_[161]) * v_[250] + (0 - v_[127] - v_[269]) * v_[259] + (v_[159] + v_[168]) * v_[262];
    jac[62] = (0 - v_[339] - v_[269]) * v_[250] + (v_[165] + v_[161]) * v_[259] + (v_[142] - v_[195]) * v_[262];
    v_[269] = -0.5 * sin(v_[236]);
    v_[236] = 0.5 * cos(v_[236]);
    v_[161] = v_[230] * v_[269] + v_[251] * v_[236];
    v_[165] = v_[239] * v_[236] + v_[232] * v_[269];
    v_[339] = 2. * v_[165];
    v_[195] = v_[266] * v_[161] + v_[339] * v_[273];
    v_[232] = v_[239] * v_[269] - v_[232] * v_[236];
    v_[236] = v_[251] * v_[269] - v_[230] * v_[236];
    v_[269] = 2. * v_[236];
    v_[251] = v_[276] * v_[232] + v_[269] * v_[263];
    v_[230] = v_[276] * v_[161] + v_[269] * v_[273];
    v_[239] = v_[266] * v_[232] + v_[339] * v_[263];
    v_[165] = v_[266] * v_[165] + v_[339] * v_[265];
    v_[269] = v_[276] * v_[236] + v_[269] * v_[275];
    jac[63] = (v_[195] + v_[251]) * v_[304] + (v_[230] - v_[239]) * v_[327] + (0 - v_[165] - v_[269]) * v_[334];
    v_[236] = v_[266] * v_[236] + v_[339] * v_[275];
    v_[339] = 2. * v_[161];
    v_[232] = v_[272] * v_[232] + v_[339] * v_[263];
    v_[339] = v_[272] * v_[161] + v_[339] * v_[273];
    jac[64] = (v_[236] - v_[232]) * v_[304] + (0 - v_[165] - v_[339]) * v_[327] + (v_[230] + v_[239]) * v_[334];
    jac[65] = (0 - v_[269] - v_[339]) * v_[304] + (v_[236] + v_[232]) * v_[327] + (v_[195] - v_[251]) * v_[334];
    v_[339] = -0.5 * sin(v_[274]);
    v_[274] = 0.5 * cos(v_[274]);
    v_[232] = v_[268] * v_[339] + v_[305] * v_[274];
    v_[236] = v_[277] * v_[274] + v_[270] * v_[339];
    v_[269] = 2. * v_[236];
    v_[251] = v_[338] * v_[232] + v_[269] * v_[345];
    v_[270] = v_[277] * v_[339] - v_[270] * v_[274];
    v_[274] = v_[305] * v_[339] - v_[268] * v_[274];
    v_[339] = 2. * v_[274];
    v_[305] = v_[348] * v_[270] + v_[339] * v_[335];
    v_[268] = v_[348] * v_[232] + v_[339] * v_[345];
    v_[277] = v_[338] * v_[270] + v_[269] * v_[335];
    v_[236] = v_[338] * v_[236] + v_[269] * v_[337];
    v_[339] = v_[348] * v_[274] + v_[339] * v_[347];
    jac[66] = (v_[251] + v_[305]) * v_[360] + (v_[268] - v_[277]) * v_[369] + (0 - v_[236] - v_[339]) * v_[372];
    v_[274] = v_[338] * v_[274] + v_[269] * v_[347];
    v_[269] = 2. * v_[232];
    v_[270] = v_[344] * v_[270] + v_[269] * v_[335];
    v_[269] = v_[344] * v_[232] + v_[269] * v_[345];
    jac[67] = (v_[274] - v_[270]) * v_[360] + (0 - v_[236] - v_[269]) * v_[369] + (v_[268] + v_[277]) * v_[372];
    jac[68] = (0 - v_[339] - v_[269]) * v_[360] + (v_[274] + v_[270]) * v_[369] + (v_[251] - v_[305]) * v_[372];
    v_[269] = -0.5 * sin(v_[346]);
    v_[346] = 0.5 * cos(v_[346]);
    v_[270] = v_[340] * v_[269] + v_[361] * v_[346];
    v_[274] = v_[349] * v_[346] + v_[342] * v_[269];
    v_[339] = 2. * v_[274];
    v_[305] = v_[376] * v_[270] + v_[339] * v_[383];
    v_[342] = v_[349] * v_[269] - v_[342] * v_[346];
    v_[346] = v_[361] * v_[269] - v_[340] * v_[346];
    v_[269] = 2. * v_[346];
    v_[361] = v_[386] * v_[342] + v_[269] * v_[373];
    v_[340] = v_[386] * v_[270] + v_[269] * v_[383];
    v_[349] = v_[376] * v_[342] + v_[339] * v_[373];
    v_[274] = v_[376] * v_[274] + v_[339] * v_[375];
    v_[269] = v_[386] * v_[346] + v_[269] * v_[385];
    jac[69] = (v_[305] + v_[361]) * v_[413] + (v_[340] - v_[349]) * v_[436] + (0 - v_[274] - v_[269]) * v_[443];
    v_[346] = v_[376] * v_[346] + v_[339] * v_[385];
    v_[339] = 2. * v_[270];
    v_[342] = v_[382] * v_[342] + v_[339] * v_[373];
    v_[339] = v_[382] * v_[270] + v_[339] * v_[383];
    jac[70] = (v_[346] - v_[342]) * v_[413] + (0 - v_[274] - v_[339]) * v_[436] + (v_[340] + v_[349]) * v_[443];
    jac[71] = (0 - v_[269] - v_[339]) * v_[413] + (v_[346] + v_[342]) * v_[436] + (v_[305] - v_[361]) * v_[443];
    v_[339] = v_[12] * v_[19];
    v_[342] = v_[22] * v_[0];
    v_[346] = v_[339] + v_[342];
    v_[269] = -1 * sin(x_in[6]);
    v_[361] = 0.33 * v_[269] * v_[26] * v_[28] - 0.33 * v_[269] * v_[30] * v_[32] - 0.35 * v_[269] * v_[30] - 0.08 * v_[269];
    v_[305] = v_[22] * v_[19];
    v_[443] = v_[12] * v_[0];
    v_[436] = v_[305] - v_[443];
    v_[413] = cos(x_in[6]);
    v_[274] = 0.33 * v_[413] * v_[26] * v_[28] - 0.33 * v_[413] * v_[30] * v_[32] - 0.35 * v_[413] * v_[30] - 0.08 * v_[413];
    jac[144] = v_[346] * v_[361] + v_[436] * v_[274];
    v_[349] = v_[12] * v_[21];
    v_[0] = v_[18] * v_[0];
    v_[340] = v_[349] - v_[0];
    v_[12] = v_[12] * v_[11];
    v_[18] = v_[18] * v_[19];
    v_[19] = 1 - v_[12] - v_[18];
    jac[145] = v_[340] * v_[361] + v_[19] * v_[274];
    v_[22] = v_[22] * v_[21];
    v_[18] = 1 - v_[22] - v_[18];
    v_[0] = v_[349] + v_[0];
    jac[146] = v_[18] * v_[361] + v_[0] * v_[274];
    v_[274] = v_[50] * v_[57];
    v_[361] = v_[60] * v_[47];
    jac[555] = v_[274] + v_[361];
    jac[509] = v_[274] - v_[361];
    v_[361] = 0.33 * v_[269];
    v_[274] = 0.33 * v_[413] * v_[26] * v_[28] - 0.33 * v_[413] * v_[30] * v_[32] - 0.35 * v_[413] * v_[30] - 0.08 * v_[413];
    v_[361] = (v_[361] * v_[30] * v_[28] + 0.33 * v_[269] * v_[26] * v_[32]) * x_in[26] + (v_[361] * v_[26] * v_[32] + 0.33 * v_[269] * v_[30] * v_[28] + 0.35 * v_[269] * v_[26]) * x_in[25] + (0.33 * v_[413] * v_[30] * v_[32] + -0.33 * v_[413] * v_[26] * v_[28] + 0.35 * v_[413] * v_[30] + 0.08 * v_[413]) * x_in[24] + x_in[18] * v_[274];
    v_[349] = v_[60] * v_[57];
    v_[21] = v_[50] * v_[47];
    jac[531] = v_[349] - v_[21];
    jac[508] = v_[349] + v_[21];
    jac[579] = jac[555] * v_[77] + jac[531] * v_[104];
    v_[21] = 0.33 * v_[413];
    v_[349] = 0.33 * v_[269] * v_[30];
    v_[11] = 0.33 * v_[269] * v_[26] * v_[28] - v_[349] * v_[32] - 0.35 * v_[269] * v_[30] - 0.08 * v_[269];
    v_[349] = (v_[21] * v_[30] * v_[28] + 0.33 * v_[413] * v_[26] * v_[32]) * x_in[26] + (v_[21] * v_[26] * v_[32] + 0.33 * v_[413] * v_[30] * v_[28] + 0.35 * v_[413] * v_[26]) * x_in[25] + (0.33 * v_[269] * v_[26] * v_[28] - v_[349] * v_[32] - 0.35 * v_[269] * v_[30] - 0.08 * v_[269]) * x_in[24] - x_in[18] * v_[11];
    v_[49] = v_[50] * v_[49];
    v_[60] = v_[60] * v_[59];
    jac[507] = 1 - v_[49] - v_[60];
    jac[603] = jac[555] * v_[71] + jac[531] * v_[98] + jac[507] * v_[114];
    jac[627] = jac[555] * v_[66] + jac[531] * v_[94] + jac[507] * v_[111];
    v_[11] = x_in[19] * v_[11] - x_in[20] * v_[274];
    jac[147] = jac[555] * v_[361] + jac[531] * v_[349] + jac[507] * v_[11];
    v_[59] = v_[50] * v_[59];
    v_[47] = v_[56] * v_[47];
    jac[556] = v_[59] - v_[47];
    jac[533] = v_[59] + v_[47];
    v_[56] = v_[56] * v_[57];
    jac[532] = 1 - v_[49] - v_[56];
    jac[148] = jac[556] * v_[361] + jac[532] * v_[349] + jac[508] * v_[11];
    jac[557] = 1 - v_[60] - v_[56];
    jac[149] = jac[557] * v_[361] + jac[533] * v_[349] + jac[509] * v_[11];
    jac[580] = jac[556] * v_[77] + jac[532] * v_[104];
    jac[581] = jac[557] * v_[77] + jac[533] * v_[104];
    jac[604] = jac[556] * v_[71] + jac[532] * v_[98] + jac[508] * v_[114];
    jac[605] = jac[557] * v_[71] + jac[533] * v_[98] + jac[509] * v_[114];
    jac[628] = jac[556] * v_[66] + jac[532] * v_[94] + jac[508] * v_[111];
    jac[629] = jac[557] * v_[66] + jac[533] * v_[94] + jac[509] * v_[111];
    v_[111] = cos(x_in[7]);
    v_[94] = -1 * sin(x_in[7]);
    v_[33] = v_[25] * v_[111] * v_[28] - v_[29] * v_[94] * v_[32] - v_[33] * v_[94];
    v_[42] = v_[38] * v_[111] * v_[28] - v_[40] * v_[94] * v_[32] - v_[42] * v_[94];
    v_[22] = 1 - v_[12] - v_[22];
    v_[12] = -0.33 * v_[94] * v_[28] - 0.33 * v_[111] * v_[32] - 0.35 * v_[111];
    jac[168] = v_[346] * v_[33] + v_[436] * v_[42] + v_[22] * v_[12];
    v_[443] = v_[305] + v_[443];
    jac[169] = v_[340] * v_[33] + v_[19] * v_[42] + v_[443] * v_[12];
    v_[342] = v_[339] - v_[342];
    jac[170] = v_[18] * v_[33] + v_[0] * v_[42] + v_[342] * v_[12];
    v_[82] = v_[78] * v_[111] * v_[28] - v_[80] * v_[94] * v_[32] - v_[82] * v_[94];
    v_[80] = -0.33 * v_[94] * v_[28] - 0.33 * v_[111] * v_[32] - 0.35 * v_[111];
    v_[76] = (v_[62] * v_[94] * v_[28] + v_[64] * v_[111] * v_[32]) * x_in[26] + (v_[62] * v_[111] * v_[32] + v_[68] * v_[94] * v_[28] + v_[70] * v_[111]) * x_in[25] + (v_[72] * v_[94] * v_[32] + v_[74] * v_[111] * v_[28] + v_[76] * v_[94]) * x_in[24] + x_in[18] * v_[82] - x_in[19] * v_[80];
    v_[101] = v_[101] * v_[94];
    v_[107] = v_[105] * v_[111] * v_[28] - v_[101] * v_[32] - v_[107] * v_[94];
    v_[101] = (v_[90] * v_[94] * v_[28] + v_[92] * v_[111] * v_[32]) * x_in[26] + (v_[90] * v_[111] * v_[32] + v_[96] * v_[94] * v_[28] + v_[37] * v_[111]) * x_in[25] + (v_[99] * v_[111] * v_[28] - v_[101] * v_[32] - v_[103] * v_[94]) * x_in[24] + x_in[20] * v_[80] - x_in[18] * v_[107];
    v_[107] = (0.33 * v_[111] * v_[28] - 0.33 * v_[94] * v_[32]) * x_in[26] + (0.33 * v_[111] * v_[28] - 0.33 * v_[94] * v_[32] - 0.35 * v_[94]) * x_in[25] + x_in[19] * v_[107] - x_in[20] * v_[82];
    jac[171] = jac[555] * v_[76] + jac[531] * v_[101] + jac[507] * v_[107];
    jac[172] = jac[556] * v_[76] + jac[532] * v_[101] + jac[508] * v_[107];
    jac[173] = jac[557] * v_[76] + jac[533] * v_[101] + jac[509] * v_[107];
    v_[107] = cos(x_in[8]);
    v_[101] = -1 * sin(x_in[8]);
    v_[31] = v_[27] * v_[107] - v_[31] * v_[101];
    v_[41] = v_[39] * v_[107] - v_[41] * v_[101];
    v_[45] = v_[44] * v_[107] - v_[45] * v_[101];
    jac[192] = v_[346] * v_[31] + v_[436] * v_[41] + v_[22] * v_[45];
    jac[193] = v_[340] * v_[31] + v_[19] * v_[41] + v_[443] * v_[45];
    jac[194] = v_[18] * v_[31] + v_[0] * v_[41] + v_[342] * v_[45];
    v_[81] = v_[79] * v_[107] - v_[81] * v_[101];
    v_[85] = v_[84] * v_[107] - v_[85] * v_[101];
    v_[75] = (v_[63] * v_[107] + v_[65] * v_[101]) * x_in[26] + (v_[67] * v_[101] + v_[69] * v_[107]) * x_in[25] + (v_[73] * v_[101] + v_[75] * v_[107]) * x_in[24] + x_in[18] * v_[81] - x_in[19] * v_[85];
    v_[106] = v_[106] * v_[107] - v_[102] * v_[101];
    v_[85] = (v_[91] * v_[107] + v_[93] * v_[101]) * x_in[26] + (v_[95] * v_[101] + v_[97] * v_[107]) * x_in[25] + (v_[100] * v_[107] - v_[102] * v_[101]) * x_in[24] + x_in[20] * v_[85] - x_in[18] * v_[106];
    v_[106] = (v_[109] * v_[107] - v_[110] * v_[101]) * x_in[26] + (v_[112] * v_[107] - v_[113] * v_[101]) * x_in[25] + x_in[19] * v_[106] - x_in[20] * v_[81];
    jac[195] = jac[555] * v_[75] + jac[531] * v_[85] + jac[507] * v_[106];
    jac[196] = jac[556] * v_[75] + jac[532] * v_[85] + jac[508] * v_[106];
    jac[197] = jac[557] * v_[75] + jac[533] * v_[85] + jac[509] * v_[106];
    v_[106] = v_[119] * v_[126];
    v_[85] = v_[129] * v_[116];
    v_[75] = v_[106] + v_[85];
    v_[81] = -1 * sin(x_in[9]);
    v_[101] = 0.33 * v_[81] * v_[133] * v_[135] - 0.33 * v_[81] * v_[137] * v_[139] - 0.35 * v_[81] * v_[137] - 0.08 * v_[81];
    v_[107] = v_[129] * v_[126];
    v_[113] = v_[119] * v_[116];
    v_[112] = v_[107] - v_[113];
    v_[110] = cos(x_in[9]);
    v_[109] = 0.33 * v_[110] * v_[137] * v_[139] + -0.33 * v_[110] * v_[133] * v_[135] + 0.35 * v_[110] * v_[137] + 0.08 * v_[110];
    jac[222] = v_[75] * v_[101] + v_[112] * v_[109];
    v_[102] = v_[119] * v_[128];
    v_[116] = v_[125] * v_[116];
    v_[100] = v_[102] - v_[116];
    v_[119] = v_[119] * v_[118];
    v_[125] = v_[125] * v_[126];
    v_[126] = 1 - v_[119] - v_[125];
    jac[223] = v_[100] * v_[101] + v_[126] * v_[109];
    v_[129] = v_[129] * v_[128];
    v_[125] = 1 - v_[129] - v_[125];
    v_[116] = v_[102] + v_[116];
    jac[224] = v_[125] * v_[101] + v_[116] * v_[109];
    v_[109] = v_[157] * v_[164];
    v_[101] = v_[167] * v_[154];
    jac[561] = v_[109] + v_[101];
    jac[515] = v_[109] - v_[101];
    v_[101] = 0.33 * v_[81];
    v_[109] = -0.33 * v_[110];
    v_[102] = 0.33 * v_[110] * v_[137] * v_[139] + -0.33 * v_[110] * v_[133] * v_[135] + 0.35 * v_[110] * v_[137] + 0.08 * v_[110];
    v_[101] = (v_[101] * v_[137] * v_[135] + 0.33 * v_[81] * v_[133] * v_[139]) * x_in[29] + (v_[101] * v_[133] * v_[139] + 0.33 * v_[81] * v_[137] * v_[135] + 0.35 * v_[81] * v_[133]) * x_in[28] + (0.33 * v_[110] * v_[137] * v_[139] + v_[109] * v_[133] * v_[135] + 0.35 * v_[110] * v_[137] + 0.08 * v_[110]) * x_in[27] + x_in[18] * v_[102];
    v_[128] = v_[167] * v_[164];
    v_[118] = v_[157] * v_[154];
    jac[537] = v_[128] - v_[118];
    jac[514] = v_[128] + v_[118];
    jac[657] = jac[561] * v_[184] + jac[537] * v_[211];
    v_[118] = 0.33 * v_[81] * v_[133] * v_[135] - 0.33 * v_[81] * v_[137] * v_[139] - 0.35 * v_[81] * v_[137] - 0.08 * v_[81];
    v_[109] = (-0.33 * v_[110] * v_[137] * v_[135] - 0.33 * v_[110] * v_[133] * v_[139]) * x_in[29] + (v_[109] * v_[137] * v_[135] - 0.33 * v_[110] * v_[133] * v_[139] - 0.35 * v_[110] * v_[133]) * x_in[28] + (0.33 * v_[81] * v_[137] * v_[139] + -0.33 * v_[81] * v_[133] * v_[135] + 0.35 * v_[81] * v_[137] + 0.08 * v_[81]) * x_in[27] - x_in[18] * v_[118];
    v_[156] = v_[157] * v_[156];
    v_[167] = v_[167] * v_[166];
    jac[513] = 1 - v_[156] - v_[167];
    jac[681] = jac[561] * v_[178] + jac[537] * v_[205] + jac[513] * v_[223];
    jac[705] = jac[561] * v_[173] + jac[537] * v_[201] + jac[513] * v_[220];
    v_[118] = x_in[19] * v_[118] - x_in[20] * v_[102];
    jac[225] = jac[561] * v_[101] + jac[537] * v_[109] + jac[513] * v_[118];
    v_[166] = v_[157] * v_[166];
    v_[154] = v_[163] * v_[154];
    jac[562] = v_[166] - v_[154];
    jac[539] = v_[166] + v_[154];
    v_[163] = v_[163] * v_[164];
    jac[538] = 1 - v_[156] - v_[163];
    jac[226] = jac[562] * v_[101] + jac[538] * v_[109] + jac[514] * v_[118];
    jac[563] = 1 - v_[167] - v_[163];
    jac[227] = jac[563] * v_[101] + jac[539] * v_[109] + jac[515] * v_[118];
    jac[658] = jac[562] * v_[184] + jac[538] * v_[211];
    jac[659] = jac[563] * v_[184] + jac[539] * v_[211];
    jac[682] = jac[562] * v_[178] + jac[538] * v_[205] + jac[514] * v_[223];
    jac[683] = jac[563] * v_[178] + jac[539] * v_[205] + jac[515] * v_[223];
    jac[706] = jac[562] * v_[173] + jac[538] * v_[201] + jac[514] * v_[220];
    jac[707] = jac[563] * v_[173] + jac[539] * v_[201] + jac[515] * v_[220];
    v_[220] = cos(x_in[10]);
    v_[201] = -1 * sin(x_in[10]);
    v_[140] = v_[132] * v_[220] * v_[135] - v_[136] * v_[201] * v_[139] - v_[140] * v_[201];
    v_[149] = v_[145] * v_[201] * v_[139] + v_[147] * v_[220] * v_[135] + v_[149] * v_[201];
    v_[129] = 1 - v_[119] - v_[129];
    v_[119] = -0.33 * v_[201] * v_[135] - 0.33 * v_[220] * v_[139] - 0.35 * v_[220];
    jac[246] = v_[75] * v_[140] + v_[112] * v_[149] + v_[129] * v_[119];
    v_[113] = v_[107] + v_[113];
    jac[247] = v_[100] * v_[140] + v_[126] * v_[149] + v_[113] * v_[119];
    v_[85] = v_[106] - v_[85];
    jac[248] = v_[125] * v_[140] + v_[116] * v_[149] + v_[85] * v_[119];
    v_[189] = v_[185] * v_[201] * v_[139] + v_[187] * v_[220] * v_[135] + v_[189] * v_[201];
    v_[187] = -0.33 * v_[201] * v_[135] - 0.33 * v_[220] * v_[139] - 0.35 * v_[220];
    v_[183] = (v_[169] * v_[201] * v_[135] + v_[171] * v_[220] * v_[139]) * x_in[29] + (v_[169] * v_[220] * v_[139] + v_[175] * v_[201] * v_[135] + v_[177] * v_[220]) * x_in[28] + (v_[179] * v_[201] * v_[139] + v_[181] * v_[220] * v_[135] + v_[183] * v_[201]) * x_in[27] + x_in[18] * v_[189] - x_in[19] * v_[187];
    v_[216] = v_[212] * v_[220] * v_[135] - v_[214] * v_[201] * v_[139] - v_[216] * v_[201];
    v_[187] = (v_[197] * v_[201] * v_[135] - v_[199] * v_[220] * v_[139]) * x_in[29] + (v_[181] * v_[201] * v_[135] - v_[203] * v_[220] * v_[139] - v_[144] * v_[220]) * x_in[28] + (v_[206] * v_[201] * v_[139] + v_[208] * v_[220] * v_[135] + v_[210] * v_[201]) * x_in[27] + x_in[20] * v_[187] - x_in[18] * v_[216];
    v_[216] = (0.33 * v_[220] * v_[135] - 0.33 * v_[201] * v_[139]) * x_in[29] + (0.33 * v_[220] * v_[135] - 0.33 * v_[201] * v_[139] - 0.35 * v_[201]) * x_in[28] + x_in[19] * v_[216] - x_in[20] * v_[189];
    jac[249] = jac[561] * v_[183] + jac[537] * v_[187] + jac[513] * v_[216];
    jac[250] = jac[562] * v_[183] + jac[538] * v_[187] + jac[514] * v_[216];
    jac[251] = jac[563] * v_[183] + jac[539] * v_[187] + jac[515] * v_[216];
    v_[216] = cos(x_in[11]);
    v_[187] = -1 * sin(x_in[11]);
    v_[138] = v_[134] * v_[216] - v_[138] * v_[187];
    v_[148] = v_[146] * v_[187] + v_[148] * v_[216];
    v_[152] = v_[151] * v_[216] - v_[152] * v_[187];
    jac[270] = v_[75] * v_[138] + v_[112] * v_[148] + v_[129] * v_[152];
    jac[271] = v_[100] * v_[138] + v_[126] * v_[148] + v_[113] * v_[152];
    jac[272] = v_[125] * v_[138] + v_[116] * v_[148] + v_[85] * v_[152];
    v_[188] = v_[186] * v_[187] + v_[188] * v_[216];
    v_[192] = v_[191] * v_[216] - v_[192] * v_[187];
    v_[182] = (v_[170] * v_[216] + v_[172] * v_[187]) * x_in[29] + (v_[174] * v_[187] + v_[176] * v_[216]) * x_in[28] + (v_[180] * v_[187] + v_[182] * v_[216]) * x_in[27] + x_in[18] * v_[188] - x_in[19] * v_[192];
    v_[215] = v_[213] * v_[216] - v_[215] * v_[187];
    v_[192] = (v_[198] * v_[216] - v_[200] * v_[187]) * x_in[29] + (v_[202] * v_[216] - v_[204] * v_[187]) * x_in[28] + (v_[207] * v_[187] + v_[209] * v_[216]) * x_in[27] + x_in[20] * v_[192] - x_in[18] * v_[215];
    v_[215] = (v_[218] * v_[216] - v_[219] * v_[187]) * x_in[29] + (v_[221] * v_[216] - v_[222] * v_[187]) * x_in[28] + x_in[19] * v_[215] - x_in[20] * v_[188];
    jac[273] = jac[561] * v_[182] + jac[537] * v_[192] + jac[513] * v_[215];
    jac[274] = jac[562] * v_[182] + jac[538] * v_[192] + jac[514] * v_[215];
    jac[275] = jac[563] * v_[182] + jac[539] * v_[192] + jac[515] * v_[215];
    v_[215] = v_[228] * v_[235];
    v_[192] = v_[238] * v_[225];
    v_[182] = v_[215] + v_[192];
    v_[188] = -1 * sin(x_in[12]);
    v_[187] = 0.33 * v_[188] * v_[242] * v_[244] - 0.33 * v_[188] * v_[246] * v_[248] - 0.35 * v_[188] * v_[246] - 0.08 * v_[188];
    v_[216] = v_[238] * v_[235];
    v_[222] = v_[228] * v_[225];
    v_[221] = v_[216] - v_[222];
    v_[219] = cos(x_in[12]);
    v_[218] = 0.33 * v_[219] * v_[242] * v_[244] - 0.33 * v_[219] * v_[246] * v_[248] - 0.35 * v_[219] * v_[246] - 0.08 * v_[219];
    jac[300] = v_[182] * v_[187] + v_[221] * v_[218];
    v_[209] = v_[228] * v_[237];
    v_[225] = v_[234] * v_[225];
    v_[207] = v_[209] - v_[225];
    v_[228] = v_[228] * v_[227];
    v_[234] = v_[234] * v_[235];
    v_[235] = 1 - v_[228] - v_[234];
    jac[301] = v_[207] * v_[187] + v_[235] * v_[218];
    v_[238] = v_[238] * v_[237];
    v_[234] = 1 - v_[238] - v_[234];
    v_[225] = v_[209] + v_[225];
    jac[302] = v_[234] * v_[187] + v_[225] * v_[218];
    v_[218] = v_[266] * v_[273];
    v_[187] = v_[276] * v_[263];
    jac[567] = v_[218] + v_[187];
    jac[521] = v_[218] - v_[187];
    v_[187] = 0.33 * v_[188];
    v_[218] = 0.33 * v_[219] * v_[242] * v_[296] - 0.33 * v_[219] * v_[246] * v_[248] - 0.35 * v_[219] * v_[246] - 0.08 * v_[219];
    v_[187] = (v_[187] * v_[246] * v_[244] + 0.33 * v_[188] * v_[242] * v_[248]) * x_in[32] + (v_[187] * v_[242] * v_[248] + 0.33 * v_[188] * v_[246] * v_[244] + 0.35 * v_[188] * v_[242]) * x_in[31] + (0.33 * v_[219] * v_[246] * v_[248] + -0.33 * v_[219] * v_[242] * v_[244] + 0.35 * v_[219] * v_[246] + 0.08 * v_[219]) * x_in[30] + x_in[18] * v_[218];
    v_[209] = v_[276] * v_[273];
    v_[237] = v_[266] * v_[263];
    jac[543] = v_[209] - v_[237];
    jac[520] = v_[209] + v_[237];
    jac[735] = jac[567] * v_[293] + jac[543] * v_[321];
    v_[237] = 0.33 * v_[219];
    v_[209] = 0.33 * v_[188] * v_[242] * v_[296] - 0.33 * v_[188] * v_[246] * v_[248] - 0.35 * v_[188] * v_[246] - 0.08 * v_[188];
    v_[237] = (v_[237] * v_[246] * v_[244] + 0.33 * v_[219] * v_[242] * v_[248]) * x_in[32] + (v_[237] * v_[242] * v_[248] + 0.33 * v_[219] * v_[246] * v_[244] + 0.35 * v_[219] * v_[242]) * x_in[31] + (0.33 * v_[188] * v_[242] * v_[244] - 0.33 * v_[188] * v_[246] * v_[248] - 0.35 * v_[188] * v_[246] - 0.08 * v_[188]) * x_in[30] - x_in[18] * v_[209];
    v_[265] = v_[266] * v_[265];
    v_[276] = v_[276] * v_[275];
    jac[519] = 1 - v_[265] - v_[276];
    jac[759] = jac[567] * v_[287] + jac[543] * v_[315] + jac[519] * v_[333];
    jac[783] = jac[567] * v_[282] + jac[543] * v_[311] + jac[519] * v_[330];
    v_[209] = x_in[19] * v_[209] - x_in[20] * v_[218];
    jac[303] = jac[567] * v_[187] + jac[543] * v_[237] + jac[519] * v_[209];
    v_[275] = v_[266] * v_[275];
    v_[263] = v_[272] * v_[263];
    jac[568] = v_[275] - v_[263];
    jac[545] = v_[275] + v_[263];
    v_[272] = v_[272] * v_[273];
    jac[544] = 1 - v_[265] - v_[272];
    jac[304] = jac[568] * v_[187] + jac[544] * v_[237] + jac[520] * v_[209];
    jac[569] = 1 - v_[276] - v_[272];
    jac[305] = jac[569] * v_[187] + jac[545] * v_[237] + jac[521] * v_[209];
    jac[736] = jac[568] * v_[293] + jac[544] * v_[321];
    jac[737] = jac[569] * v_[293] + jac[545] * v_[321];
    jac[760] = jac[568] * v_[287] + jac[544] * v_[315] + jac[520] * v_[333];
    jac[761] = jac[569] * v_[287] + jac[545] * v_[315] + jac[521] * v_[333];
    jac[784] = jac[568] * v_[282] + jac[544] * v_[311] + jac[520] * v_[330];
    jac[785] = jac[569] * v_[282] + jac[545] * v_[311] + jac[521] * v_[330];
    v_[330] = cos(x_in[13]);
    v_[311] = -1 * sin(x_in[13]);
    v_[249] = v_[241] * v_[330] * v_[244] - v_[245] * v_[311] * v_[248] - v_[249] * v_[311];
    v_[258] = v_[254] * v_[330] * v_[244] - v_[256] * v_[311] * v_[248] - v_[258] * v_[311];
    v_[238] = 1 - v_[228] - v_[238];
    v_[228] = -0.33 * v_[311] * v_[244] - 0.33 * v_[330] * v_[248] - 0.35 * v_[330];
    jac[324] = v_[182] * v_[249] + v_[221] * v_[258] + v_[238] * v_[228];
    v_[222] = v_[216] + v_[222];
    jac[325] = v_[207] * v_[249] + v_[235] * v_[258] + v_[222] * v_[228];
    v_[192] = v_[215] - v_[192];
    jac[326] = v_[234] * v_[249] + v_[225] * v_[258] + v_[192] * v_[228];
    v_[299] = v_[294] * v_[330] * v_[296] - v_[297] * v_[311] * v_[248] - v_[299] * v_[311];
    v_[297] = -0.33 * v_[311] * v_[296] - 0.33 * v_[330] * v_[248] - 0.35 * v_[330];
    v_[292] = (v_[278] * v_[311] * v_[244] + v_[280] * v_[330] * v_[248]) * x_in[32] + (v_[278] * v_[330] * v_[248] + v_[284] * v_[311] * v_[244] + v_[286] * v_[330]) * x_in[31] + (v_[288] * v_[311] * v_[248] + v_[290] * v_[330] * v_[244] + v_[292] * v_[311]) * x_in[30] + x_in[18] * v_[299] - x_in[19] * v_[297];
    v_[326] = v_[322] * v_[330] * v_[296] - v_[324] * v_[311] * v_[248] - v_[326] * v_[311];
    v_[297] = (v_[307] * v_[311] * v_[244] + v_[309] * v_[330] * v_[248]) * x_in[32] + (v_[307] * v_[330] * v_[248] + v_[313] * v_[311] * v_[244] + v_[253] * v_[330]) * x_in[31] + (v_[316] * v_[330] * v_[244] - v_[318] * v_[311] * v_[248] - v_[320] * v_[311]) * x_in[30] + x_in[20] * v_[297] - x_in[18] * v_[326];
    v_[326] = (0.33 * v_[330] * v_[244] - 0.33 * v_[311] * v_[248]) * x_in[32] + (0.33 * v_[330] * v_[244] - 0.33 * v_[311] * v_[248] - 0.35 * v_[311]) * x_in[31] + x_in[19] * v_[326] - x_in[20] * v_[299];
    jac[327] = jac[567] * v_[292] + jac[543] * v_[297] + jac[519] * v_[326];
    jac[328] = jac[568] * v_[292] + jac[544] * v_[297] + jac[520] * v_[326];
    jac[329] = jac[569] * v_[292] + jac[545] * v_[297] + jac[521] * v_[326];
    v_[326] = cos(x_in[14]);
    v_[297] = -1 * sin(x_in[14]);
    v_[247] = v_[243] * v_[326] - v_[247] * v_[297];
    v_[257] = v_[255] * v_[326] - v_[257] * v_[297];
    v_[261] = v_[260] * v_[326] - v_[261] * v_[297];
    jac[348] = v_[182] * v_[247] + v_[221] * v_[257] + v_[238] * v_[261];
    jac[349] = v_[207] * v_[247] + v_[235] * v_[257] + v_[222] * v_[261];
    jac[350] = v_[234] * v_[247] + v_[225] * v_[257] + v_[192] * v_[261];
    v_[261] = cos(x_in[14]);
    v_[298] = v_[295] * v_[261] - v_[298] * v_[297];
    v_[302] = v_[301] * v_[261] - v_[302] * v_[297];
    v_[291] = (v_[279] * v_[326] + v_[281] * v_[297]) * x_in[32] + (v_[283] * v_[297] + v_[285] * v_[326]) * x_in[31] + (v_[289] * v_[297] + v_[291] * v_[326]) * x_in[30] + x_in[18] * v_[298] - x_in[19] * v_[302];
    v_[261] = v_[323] * v_[261] - v_[325] * v_[297];
    v_[302] = (v_[308] * v_[326] + v_[310] * v_[297]) * x_in[32] + (v_[312] * v_[297] + v_[314] * v_[326]) * x_in[31] + (v_[317] * v_[326] - v_[319] * v_[297]) * x_in[30] + x_in[20] * v_[302] - x_in[18] * v_[261];
    v_[261] = (v_[328] * v_[326] - v_[329] * v_[297]) * x_in[32] + (v_[331] * v_[326] - v_[332] * v_[297]) * x_in[31] + x_in[19] * v_[261] - x_in[20] * v_[298];
    jac[351] = jac[567] * v_[291] + jac[543] * v_[302] + jac[519] * v_[261];
    jac[352] = jac[568] * v_[291] + jac[544] * v_[302] + jac[520] * v_[261];
    jac[353] = jac[569] * v_[291] + jac[545] * v_[302] + jac[521] * v_[261];
    v_[261] = v_[338] * v_[345];
    v_[302] = v_[348] * v_[335];
    v_[291] = v_[261] + v_[302];
    v_[298] = -1 * sin(x_in[15]);
    v_[297] = 0.33 * v_[298] * v_[352] * v_[354] - 0.33 * v_[298] * v_[356] * v_[358] - 0.35 * v_[298] * v_[356] - 0.08 * v_[298];
    v_[326] = v_[348] * v_[345];
    v_[332] = v_[338] * v_[335];
    v_[331] = v_[326] - v_[332];
    v_[329] = cos(x_in[15]);
    v_[328] = 0.33 * v_[329] * v_[356] * v_[358] + -0.33 * v_[329] * v_[352] * v_[354] + 0.35 * v_[329] * v_[356] + 0.08 * v_[329];
    jac[378] = v_[291] * v_[297] + v_[331] * v_[328];
    v_[319] = v_[338] * v_[347];
    v_[335] = v_[344] * v_[335];
    v_[317] = v_[319] - v_[335];
    v_[338] = v_[338] * v_[337];
    v_[344] = v_[344] * v_[345];
    v_[345] = 1 - v_[338] - v_[344];
    jac[379] = v_[317] * v_[297] + v_[345] * v_[328];
    v_[348] = v_[348] * v_[347];
    v_[344] = 1 - v_[348] - v_[344];
    v_[335] = v_[319] + v_[335];
    jac[380] = v_[344] * v_[297] + v_[335] * v_[328];
    v_[328] = v_[376] * v_[383];
    v_[297] = v_[386] * v_[373];
    jac[573] = v_[328] + v_[297];
    jac[527] = v_[328] - v_[297];
    v_[297] = 0.33 * v_[298];
    v_[328] = -0.33 * v_[329];
    v_[319] = 0.33 * v_[329] * v_[356] * v_[358] + -0.33 * v_[329] * v_[352] * v_[354] + 0.35 * v_[329] * v_[356] + 0.08 * v_[329];
    v_[297] = (v_[297] * v_[356] * v_[354] + 0.33 * v_[298] * v_[352] * v_[358]) * x_in[35] + (v_[297] * v_[352] * v_[358] + 0.33 * v_[298] * v_[356] * v_[354] + 0.35 * v_[298] * v_[352]) * x_in[34] + (0.33 * v_[329] * v_[356] * v_[358] + v_[328] * v_[352] * v_[354] + 0.35 * v_[329] * v_[356] + 0.08 * v_[329]) * x_in[33] + x_in[18] * v_[319];
    v_[347] = v_[386] * v_[383];
    v_[337] = v_[376] * v_[373];
    jac[549] = v_[347] - v_[337];
    jac[526] = v_[347] + v_[337];
    jac[813] = jac[573] * v_[403] + jac[549] * v_[430];
    v_[337] = 0.33 * v_[298] * v_[352] * v_[354] - 0.33 * v_[298] * v_[356] * v_[358] - 0.35 * v_[298] * v_[356] - 0.08 * v_[298];
    v_[328] = (-0.33 * v_[329] * v_[356] * v_[354] - 0.33 * v_[329] * v_[352] * v_[358]) * x_in[35] + (v_[328] * v_[356] * v_[354] - 0.33 * v_[329] * v_[352] * v_[358] - 0.35 * v_[329] * v_[352]) * x_in[34] + (0.33 * v_[298] * v_[356] * v_[358] + -0.33 * v_[298] * v_[352] * v_[354] + 0.35 * v_[298] * v_[356] + 0.08 * v_[298]) * x_in[33] - x_in[18] * v_[337];
    v_[375] = v_[376] * v_[375];
    v_[386] = v_[386] * v_[385];
    jac[525] = 1 - v_[375] - v_[386];
    jac[837] = jac[573] * v_[397] + jac[549] * v_[424] + jac[525] * v_[442];
    jac[861] = jac[573] * v_[392] + jac[549] * v_[420] + jac[525] * v_[439];
    v_[337] = x_in[19] * v_[337] - x_in[20] * v_[319];
    jac[381] = jac[573] * v_[297] + jac[549] * v_[328] + jac[525] * v_[337];
    v_[385] = v_[376] * v_[385];
    v_[373] = v_[382] * v_[373];
    jac[574] = v_[385] - v_[373];
    jac[551] = v_[385] + v_[373];
    v_[382] = v_[382] * v_[383];
    jac[550] = 1 - v_[375] - v_[382];
    jac[382] = jac[574] * v_[297] + jac[550] * v_[328] + jac[526] * v_[337];
    jac[575] = 1 - v_[386] - v_[382];
    jac[383] = jac[575] * v_[297] + jac[551] * v_[328] + jac[527] * v_[337];
    jac[814] = jac[574] * v_[403] + jac[550] * v_[430];
    jac[815] = jac[575] * v_[403] + jac[551] * v_[430];
    jac[838] = jac[574] * v_[397] + jac[550] * v_[424] + jac[526] * v_[442];
    jac[839] = jac[575] * v_[397] + jac[551] * v_[424] + jac[527] * v_[442];
    jac[862] = jac[574] * v_[392] + jac[550] * v_[420] + jac[526] * v_[439];
    jac[863] = jac[575] * v_[392] + jac[551] * v_[420] + jac[527] * v_[439];
    v_[439] = cos(x_in[16]);
    v_[420] = -1 * sin(x_in[16]);
    v_[359] = v_[351] * v_[439] * v_[354] - v_[355] * v_[420] * v_[358] - v_[359] * v_[420];
    v_[368] = v_[364] * v_[420] * v_[358] + v_[366] * v_[439] * v_[354] + v_[368] * v_[420];
    v_[348] = 1 - v_[338] - v_[348];
    v_[338] = -0.33 * v_[420] * v_[354] - 0.33 * v_[439] * v_[358] - 0.35 * v_[439];
    jac[402] = v_[291] * v_[359] + v_[331] * v_[368] + v_[348] * v_[338];
    v_[332] = v_[326] + v_[332];
    jac[403] = v_[317] * v_[359] + v_[345] * v_[368] + v_[332] * v_[338];
    v_[302] = v_[261] - v_[302];
    jac[404] = v_[344] * v_[359] + v_[335] * v_[368] + v_[302] * v_[338];
    v_[408] = v_[404] * v_[420] * v_[358] + v_[406] * v_[439] * v_[354] + v_[408] * v_[420];
    v_[406] = -0.33 * v_[420] * v_[354] - 0.33 * v_[439] * v_[358] - 0.35 * v_[439];
    v_[402] = (v_[388] * v_[420] * v_[354] + v_[390] * v_[439] * v_[358]) * x_in[35] + (v_[388] * v_[439] * v_[358] + v_[394] * v_[420] * v_[354] + v_[396] * v_[439]) * x_in[34] + (v_[398] * v_[420] * v_[358] + v_[400] * v_[439] * v_[354] + v_[402] * v_[420]) * x_in[33] + x_in[18] * v_[408] - x_in[19] * v_[406];
    v_[435] = v_[431] * v_[439] * v_[354] - v_[433] * v_[420] * v_[358] - v_[435] * v_[420];
    v_[406] = (v_[416] * v_[420] * v_[354] - v_[418] * v_[439] * v_[358]) * x_in[35] + (v_[400] * v_[420] * v_[354] - v_[422] * v_[439] * v_[358] - v_[363] * v_[439]) * x_in[34] + (v_[425] * v_[420] * v_[358] + v_[427] * v_[439] * v_[354] + v_[429] * v_[420]) * x_in[33] + x_in[20] * v_[406] - x_in[18] * v_[435];
    v_[435] = (0.33 * v_[439] * v_[354] - 0.33 * v_[420] * v_[358]) * x_in[35] + (0.33 * v_[439] * v_[354] - 0.33 * v_[420] * v_[358] - 0.35 * v_[420]) * x_in[34] + x_in[19] * v_[435] - x_in[20] * v_[408];
    jac[405] = jac[573] * v_[402] + jac[549] * v_[406] + jac[525] * v_[435];
    jac[406] = jac[574] * v_[402] + jac[550] * v_[406] + jac[526] * v_[435];
    jac[407] = jac[575] * v_[402] + jac[551] * v_[406] + jac[527] * v_[435];
    v_[435] = cos(x_in[17]);
    v_[406] = -1 * sin(x_in[17]);
    v_[357] = v_[353] * v_[435] - v_[357] * v_[406];
    v_[367] = v_[365] * v_[406] + v_[367] * v_[435];
    v_[371] = v_[370] * v_[435] - v_[371] * v_[406];
    jac[426] = v_[291] * v_[357] + v_[331] * v_[367] + v_[348] * v_[371];
    jac[427] = v_[317] * v_[357] + v_[345] * v_[367] + v_[332] * v_[371];
    jac[428] = v_[344] * v_[357] + v_[335] * v_[367] + v_[302] * v_[371];
    v_[407] = v_[405] * v_[406] + v_[407] * v_[435];
    v_[411] = v_[410] * v_[435] - v_[411] * v_[406];
    v_[401] = (v_[389] * v_[435] + v_[391] * v_[406]) * x_in[35] + (v_[393] * v_[406] + v_[395] * v_[435]) * x_in[34] + (v_[399] * v_[406] + v_[401] * v_[435]) * x_in[33] + x_in[18] * v_[407] - x_in[19] * v_[411];
    v_[434] = v_[432] * v_[435] - v_[434] * v_[406];
    v_[411] = (v_[417] * v_[435] - v_[419] * v_[406]) * x_in[35] + (v_[421] * v_[435] - v_[423] * v_[406]) * x_in[34] + (v_[426] * v_[406] + v_[428] * v_[435]) * x_in[33] + x_in[20] * v_[411] - x_in[18] * v_[434];
    v_[434] = (v_[437] * v_[435] - v_[438] * v_[406]) * x_in[35] + (v_[440] * v_[435] - v_[441] * v_[406]) * x_in[34] + x_in[19] * v_[434] - x_in[20] * v_[407];
    jac[429] = jac[573] * v_[401] + jac[549] * v_[411] + jac[525] * v_[434];
    jac[430] = jac[574] * v_[401] + jac[550] * v_[411] + jac[526] * v_[434];
    jac[431] = jac[575] * v_[401] + jac[551] * v_[411] + jac[527] * v_[434];
    v_[434] = 0 - v_[24];
    jac[435] = jac[555] * v_[83] + jac[531] * v_[434];
    jac[436] = jac[556] * v_[83] + jac[532] * v_[434];
    jac[437] = jac[557] * v_[83] + jac[533] * v_[434];
    v_[434] = 0 - v_[131];
    jac[441] = jac[561] * v_[190] + jac[537] * v_[434];
    jac[442] = jac[562] * v_[190] + jac[538] * v_[434];
    jac[443] = jac[563] * v_[190] + jac[539] * v_[434];
    v_[434] = 0 - v_[240];
    jac[447] = jac[567] * v_[300] + jac[543] * v_[434];
    jac[448] = jac[568] * v_[300] + jac[544] * v_[434];
    jac[449] = jac[569] * v_[300] + jac[545] * v_[434];
    v_[434] = 0 - v_[350];
    jac[453] = jac[573] * v_[409] + jac[549] * v_[434];
    jac[454] = jac[574] * v_[409] + jac[550] * v_[434];
    jac[455] = jac[575] * v_[409] + jac[551] * v_[434];
    v_[434] = 0 - v_[86];
    jac[459] = jac[555] * v_[434] + jac[507] * v_[24];
    jac[460] = jac[556] * v_[434] + jac[508] * v_[24];
    jac[461] = jac[557] * v_[434] + jac[509] * v_[24];
    v_[434] = 0 - v_[193];
    jac[465] = jac[561] * v_[434] + jac[513] * v_[131];
    jac[466] = jac[562] * v_[434] + jac[514] * v_[131];
    jac[467] = jac[563] * v_[434] + jac[515] * v_[131];
    v_[434] = 0 - v_[303];
    jac[471] = jac[567] * v_[434] + jac[519] * v_[240];
    jac[472] = jac[568] * v_[434] + jac[520] * v_[240];
    jac[473] = jac[569] * v_[434] + jac[521] * v_[240];
    v_[434] = 0 - v_[412];
    jac[477] = jac[573] * v_[434] + jac[525] * v_[350];
    jac[478] = jac[574] * v_[434] + jac[526] * v_[350];
    jac[479] = jac[575] * v_[434] + jac[527] * v_[350];
    v_[83] = 0 - v_[83];
    jac[483] = jac[531] * v_[86] + jac[507] * v_[83];
    jac[484] = jac[532] * v_[86] + jac[508] * v_[83];
    jac[485] = jac[533] * v_[86] + jac[509] * v_[83];
    v_[190] = 0 - v_[190];
    jac[489] = jac[537] * v_[193] + jac[513] * v_[190];
    jac[490] = jac[538] * v_[193] + jac[514] * v_[190];
    jac[491] = jac[539] * v_[193] + jac[515] * v_[190];
    v_[300] = 0 - v_[300];
    jac[495] = jac[543] * v_[303] + jac[519] * v_[300];
    jac[496] = jac[544] * v_[303] + jac[520] * v_[300];
    jac[497] = jac[545] * v_[303] + jac[521] * v_[300];
    v_[409] = 0 - v_[409];
    jac[501] = jac[549] * v_[412] + jac[525] * v_[409];
    jac[502] = jac[550] * v_[412] + jac[526] * v_[409];
    jac[503] = jac[551] * v_[412] + jac[527] * v_[409];
    // dependent variables without operations
    jac[72] = 1;
    jac[78] = 1;
    jac[84] = 1;
    jac[90] = 1;
    jac[97] = 1;
    jac[103] = 1;
    jac[109] = 1;
    jac[115] = 1;
    jac[122] = 1;
    jac[128] = 1;
    jac[134] = 1;
    jac[140] = 1;


    return jac_;
}
}
}
}
