/**********************************************************************************************************************
This file is part of the Control Toolbox (https://github.com/ethz-adrl/control-toolbox), copyright by ETH Zurich.
Licensed under the BSD-2 license (see LICENSE file in main directory)
**********************************************************************************************************************/

#include "HyALinearizedForward.h"

namespace ct {
namespace models {
namespace HyA {
namespace tpl {

template <typename SCALAR>
const typename HyALinearizedForward<SCALAR>::state_matrix_t& HyALinearizedForward<SCALAR>::getDerivativeState(
    const ct::core::StateVector<12, SCALAR>& x,
    const ct::core::ControlVector<6, SCALAR>& u,
    const SCALAR t)
{
    SCALAR* jac = dFdx_.data();
    Eigen::Matrix<SCALAR, 12 + 6, 1> x_in;
    x_in << x, u;

    vX_[0] = cos(x_in[1]);
    vX_[1] = -1 * sin(x_in[1]);
    vX_[2] = vX_[1] * x_in[6];
    vX_[3] = vX_[2] * x_in[7];
    vX_[4] = sin(x_in[1]);
    vX_[5] = vX_[4] * x_in[6];
    vX_[6] = cos(x_in[1]);
    vX_[7] = vX_[6] * x_in[6];
    vX_[8] = vX_[5] * vX_[7] + vX_[7] * vX_[5];
    vX_[9] = cos(x_in[2]);
    vX_[10] = vX_[5] + x_in[8];
    vX_[11] = sin(x_in[2]);
    vX_[12] = -0.112 * vX_[11];
    vX_[13] = vX_[12] * vX_[2];
    vX_[14] = vX_[0] * x_in[6];
    vX_[15] = 0.112 * vX_[9];
    vX_[16] = vX_[12] * vX_[14] + vX_[15] * x_in[7];
    vX_[17] = -(vX_[10] * vX_[13] + vX_[7] * vX_[16]);
    vX_[18] = vX_[9] * vX_[14] + vX_[11] * x_in[7];
    vX_[19] = vX_[9] * vX_[2];
    vX_[20] = vX_[18] * vX_[7] + vX_[19] * vX_[10];
    vX_[21] = vX_[10] * vX_[7] + vX_[7] * vX_[10];
    vX_[22] = 0 - vX_[9];
    vX_[23] = vX_[11] * vX_[14] + vX_[22] * x_in[7];
    vX_[24] = vX_[11] * vX_[2];
    vX_[25] = vX_[23] * vX_[24] + vX_[24] * vX_[23];
    vX_[26] = cos(x_in[3]);
    vX_[27] = sin(x_in[3]);
    vX_[28] = 0 - vX_[27];
    vX_[29] = vX_[26] * vX_[18] + vX_[28] * vX_[10];
    vX_[30] = 0.112 * vX_[9];
    vX_[31] = vX_[30] * vX_[2];
    vX_[32] = -0.304 * vX_[19] + -1 * vX_[31];
    vX_[33] = vX_[26] * vX_[19] + vX_[28] * vX_[7];
    vX_[34] = 0.112 * vX_[11];
    vX_[35] = vX_[30] * vX_[14] + vX_[34] * x_in[7];
    vX_[36] = -0.304 * vX_[18] + -1 * vX_[35];
    vX_[37] = -1 * vX_[23] + x_in[9];
    vX_[38] = -0.304 * vX_[26];
    vX_[39] = vX_[38] * vX_[24] + vX_[26] * vX_[13];
    vX_[40] = -1 * vX_[24];
    vX_[41] = vX_[38] * vX_[23] + vX_[26] * vX_[16];
    vX_[42] = vX_[29] * vX_[32] + vX_[33] * vX_[36] - (vX_[37] * vX_[39] + vX_[40] * vX_[41]);
    vX_[43] = vX_[29] * vX_[40] + vX_[33] * vX_[37];
    vX_[44] = vX_[37] * vX_[40] + vX_[40] * vX_[37];
    vX_[45] = vX_[27] * vX_[18] + vX_[26] * vX_[10];
    vX_[46] = vX_[27] * vX_[19] + vX_[26] * vX_[7];
    vX_[47] = vX_[45] * vX_[46] + vX_[46] * vX_[45];
    vX_[48] = cos(x_in[4]);
    vX_[49] = sin(x_in[4]);
    vX_[50] = vX_[48] * vX_[29] + vX_[49] * vX_[37];
    vX_[51] = -0.304 * vX_[27];
    vX_[52] = vX_[51] * vX_[24] + vX_[27] * vX_[13];
    vX_[53] = vX_[48] * vX_[33] + vX_[49] * vX_[40];
    vX_[54] = vX_[51] * vX_[23] + vX_[27] * vX_[16];
    vX_[55] = vX_[45] + x_in[10];
    vX_[56] = 0.112 * vX_[48];
    vX_[57] = -0.112 * vX_[49];
    vX_[58] = vX_[56] * vX_[40] + vX_[57] * vX_[33] + vX_[48] * vX_[39] + vX_[49] * vX_[32];
    vX_[59] = vX_[56] * vX_[37] + vX_[57] * vX_[29] + vX_[48] * vX_[41] + vX_[49] * vX_[36];
    vX_[60] = vX_[50] * vX_[52] + vX_[53] * vX_[54] - (vX_[55] * vX_[58] + vX_[46] * vX_[59]);
    vX_[61] = vX_[50] * vX_[46] + vX_[53] * vX_[55];
    vX_[62] = vX_[55] * vX_[46] + vX_[46] * vX_[55];
    vX_[63] = 0 - vX_[48];
    vX_[64] = vX_[49] * vX_[29] + vX_[63] * vX_[37];
    vX_[65] = vX_[49] * vX_[33] + vX_[63] * vX_[40];
    vX_[66] = vX_[64] * vX_[65] + vX_[65] * vX_[64];
    vX_[67] = sin(x_in[5]);
    vX_[68] = cos(x_in[5]);
    vX_[69] = vX_[67] * vX_[64] + vX_[68] * vX_[55];
    vX_[70] = 0 - vX_[67];
    vX_[71] = vX_[68] * vX_[65] + vX_[70] * vX_[46];
    vX_[72] = vX_[67] * vX_[65] + vX_[68] * vX_[46];
    vX_[73] = vX_[68] * vX_[64] + vX_[70] * vX_[55];
    vX_[74] = vX_[69] * vX_[71] + vX_[72] * vX_[73];
    vX_[75] = vX_[50] + x_in[11];
    vX_[76] = 0.112 * vX_[49];
    vX_[77] = 0.112 * vX_[48];
    vX_[78] = 0 - vX_[48];
    vX_[79] = vX_[76] * vX_[40] + vX_[77] * vX_[33] + vX_[49] * vX_[39] + vX_[78] * vX_[32];
    vX_[80] = 0.184 * vX_[67] - 0.02075 * vX_[68];
    vX_[81] = vX_[67] * vX_[79] + vX_[80] * vX_[53] + vX_[68] * vX_[52];
    vX_[82] = vX_[76] * vX_[37] + vX_[77] * vX_[29] + vX_[49] * vX_[41] + vX_[78] * vX_[36];
    vX_[83] = vX_[67] * vX_[82] + vX_[80] * vX_[50] + vX_[68] * vX_[54];
    vX_[84] = vX_[75] * vX_[81] + vX_[53] * vX_[83];
    vX_[85] = 0.02075 * vX_[46] + -0.184 * vX_[65] + vX_[58];
    vX_[86] = 0.02075 * vX_[55] + -0.184 * vX_[64] + vX_[59];
    vX_[87] = vX_[69] * vX_[85] + vX_[72] * vX_[86];
    vX_[88] = vX_[69] * vX_[53] + vX_[72] * vX_[75];
    vX_[89] = vX_[73] * vX_[53] + vX_[71] * vX_[75];
    vX_[90] = vX_[73] * vX_[71] + vX_[71] * vX_[73];
    vX_[91] = vX_[69] * vX_[72] + vX_[72] * vX_[69];
    vX_[92] = -0.00751 * vX_[74] + 0.038686875 * (vX_[84] - vX_[87]) + -0.000829 * vX_[88] - 1.5e-05 * vX_[89] -
              0.000198 * (vX_[90] - vX_[91]);
    vX_[93] = 0 - vX_[92];
    vX_[94] = 0.02075 * vX_[67] + 0.184 * vX_[68];
    vX_[95] = 0 - vX_[67];
    vX_[96] = vX_[68] * vX_[79] + vX_[94] * vX_[53] + vX_[95] * vX_[52];
    vX_[97] = vX_[68] * vX_[82] + vX_[94] * vX_[50] + vX_[95] * vX_[54];
    vX_[98] = vX_[75] * vX_[53] + vX_[53] * vX_[75];
    vX_[85] = 1.547475 * (vX_[73] * vX_[85] + vX_[71] * vX_[86] - (vX_[75] * vX_[96] + vX_[53] * vX_[97])) +
              1.547475 * vX_[96] * x_in[11] - 0.038686875 * (vX_[98] + vX_[90]);
    vX_[99] = (-vX_[72]) * x_in[11];
    vX_[100] = vX_[71] * x_in[11];
    vX_[101] = (-vX_[81]) * x_in[11];
    vX_[87] = 0.038686875 * vX_[74] + -1.547475 * (vX_[87] - vX_[84]) + 0.00345708950900075 * vX_[99] +
              -6.25528861700981e-05 * vX_[100] + 1.38614328745655 * vX_[101] + (0.038686875 * vX_[93]) / 0.009277;
    vX_[84] = 1.547475 * vX_[80];
    vX_[102] = -0.184 * vX_[68] + 0.02075 * vX_[70];
    vX_[103] = 0 - 1.38614328745655 * vX_[102];
    vX_[104] = vX_[84] * vX_[80] - vX_[103] * vX_[102];
    vX_[105] = 0 - -6.25528861700981e-05 * vX_[102];
    vX_[106] = 0 - 0.00345708950900075 * vX_[102];
    vX_[107] = 0 - vX_[106];
    vX_[108] = -0.001243 + vX_[68] * vX_[105] + vX_[67] * vX_[107];
    vX_[109] = 0 - 1.547475 * vX_[80];
    vX_[110] = 0.0107369757464698 - vX_[109] * vX_[80] - vX_[104];
    vX_[111] = 0.000199340411771047 + vX_[109] * vX_[102] - -0.038686875 * vX_[80];
    vX_[112] = vX_[68] * vX_[110] + vX_[70] * vX_[111];
    vX_[113] = 1.547475 * vX_[102];
    vX_[114] = 0.00315291990945349 + -0.07737375 * vX_[102] + vX_[113] * vX_[102] - vX_[104];
    vX_[115] = vX_[68] * vX_[111] + vX_[70] * vX_[114];
    vX_[116] = vX_[112] * vX_[68] + vX_[115] * vX_[70];
    vX_[117] = 0.011046 + vX_[104] + vX_[116];
    vX_[118] = vX_[108] / vX_[117];
    vX_[119] = 0.029115 + vX_[104] - vX_[108] * vX_[118];
    vX_[120] = (-vX_[65]) * x_in[10];
    vX_[106] = 2. * vX_[106];
    vX_[121] = 2. * vX_[105];
    vX_[122] = -0.012652 + vX_[115] * vX_[68] + vX_[112] * vX_[67];
    vX_[123] = -0.001387 + vX_[106] * vX_[68] + vX_[121] * vX_[67] + vX_[70] * vX_[105] + vX_[68] * vX_[107] -
               vX_[122] * vX_[118];
    vX_[124] = vX_[53] * x_in[10];
    vX_[125] = -0.038686875 + vX_[113];
    vX_[126] = vX_[103] + vX_[125];
    vX_[127] = vX_[84] + vX_[109];
    vX_[125] = 0 - vX_[125];
    vX_[128] = vX_[68] * vX_[125] + vX_[70] * vX_[109];
    vX_[129] = -6.25528861700981e-05 * vX_[68] + 0.00345708950900075 * vX_[70];
    vX_[130] = vX_[129] * vX_[68];
    vX_[131] = vX_[130] / vX_[117];
    vX_[132] = 0.057838 + vX_[126] * vX_[68] + vX_[127] * vX_[67] + vX_[128] - vX_[108] * vX_[131];
    vX_[133] = vX_[58] * x_in[10];
    vX_[134] = vX_[67] * vX_[125] + vX_[68] * vX_[109];
    vX_[135] = vX_[134] / vX_[117];
    vX_[136] = 0 - vX_[108] * vX_[135];
    vX_[137] = (-vX_[79]) * x_in[10];
    vX_[138] = vX_[64] * vX_[46] + vX_[65] * vX_[55];
    vX_[139] = vX_[64] * vX_[53] + vX_[65] * vX_[50];
    vX_[96] = vX_[69] * vX_[96] + vX_[72] * vX_[97] - (vX_[73] * vX_[81] + vX_[71] * vX_[83]);
    vX_[91] = 0.000198 * vX_[89] + 1.5e-05 * (vX_[98] - vX_[91]) + 0.00315291990945349 * vX_[99] +
              0.000199340411771047 * vX_[100] + 0.00345708950900075 * vX_[101] + (-0.000829 * vX_[93]) / 0.009277 -
              0.038686875 * vX_[96] - -0.00146 * vX_[88] - -0.000829 * vX_[74];
    vX_[98] = 0.00605 * vX_[89] + 1.5e-05 * vX_[74] + 0.000199340411771047 * vX_[99] + 0.0107369757464698 * vX_[100] +
              -6.25528861700981e-05 * vX_[101] + (1.5e-05 * vX_[93]) / 0.009277 - 0.000198 * vX_[88] -
              -0.000829 * (vX_[98] - vX_[90]);
    vX_[96] = 0.038686875 * vX_[88] + 1.547475 * vX_[96] + -0.038686875 * vX_[99];
    vX_[88] = vX_[50] * vX_[53] + vX_[53] * vX_[50];
    vX_[90] = -0.001243 * vX_[138] + 0.009683 * vX_[139] + vX_[70] * vX_[91] + vX_[68] * vX_[98] + 0.02075 * vX_[96] -
              -0.012652 * vX_[61] - -0.001387 * (vX_[88] - vX_[66]);
    vX_[89] = 0 - vX_[90];
    vX_[92] = 0.057838 * vX_[60] + -0.001387 * vX_[61] + -0.012652 * (vX_[62] - vX_[66]) +
              (0.009277 * vX_[93]) / 0.009277 + vX_[92] + vX_[80] * vX_[85] + vX_[94] * vX_[87] + vX_[119] * vX_[120] +
              vX_[123] * vX_[124] + vX_[132] * vX_[133] + vX_[136] * vX_[137] + (vX_[108] * vX_[89]) / vX_[117] -
              -0.008386 * vX_[138] - -0.001243 * vX_[139];
    vX_[74] = vX_[64] * vX_[52] + vX_[65] * vX_[54] - (vX_[55] * vX_[79] + vX_[46] * vX_[82]);
    vX_[81] = vX_[122] / vX_[117];
    vX_[116] = 0.019432 + vX_[114] + vX_[110] + vX_[104] - vX_[116] - vX_[122] * vX_[81];
    vX_[104] = -6.25528861700981e-05 * vX_[67] + 0.00345708950900075 * vX_[68];
    vX_[72] = vX_[104] * vX_[68] - vX_[122] * vX_[131];
    vX_[128] = -0.057838 - vX_[128] - vX_[122] * vX_[135];
    vX_[98] = -0.018069 * vX_[61] + 0.057838 * vX_[74] + -0.012652 * vX_[139] + vX_[68] * vX_[91] + vX_[67] * vX_[98] +
              -0.184 * vX_[96] + vX_[123] * vX_[120] + vX_[116] * vX_[124] + vX_[72] * vX_[133] + vX_[128] * vX_[137] +
              (vX_[122] * vX_[89]) / vX_[117] - -0.001387 * vX_[138] - -0.001243 * (vX_[62] - vX_[88]);
    vX_[91] = -0.161331712543454 * vX_[70];
    vX_[139] = vX_[91] * vX_[70];
    vX_[62] = 3.48934328745655 - vX_[139] - vX_[130] * vX_[131];
    vX_[71] = 0 - vX_[130] * vX_[135];
    vX_[138] = 0.057838 * vX_[138] + 2.1032 * vX_[60] + vX_[68] * vX_[87] + vX_[67] * vX_[85] + vX_[132] * vX_[120] +
               vX_[72] * vX_[124] + vX_[62] * vX_[133] + vX_[71] * vX_[137] + (vX_[130] * vX_[89]) / vX_[117];
    vX_[60] = 3.650675 - vX_[134] * vX_[135];
    vX_[74] = 0.057838 * vX_[61] + -2.1032 * vX_[74] + vX_[96] + vX_[136] * vX_[120] + vX_[128] * vX_[124] +
              vX_[71] * vX_[133] + vX_[60] * vX_[137] + (vX_[134] * vX_[89]) / vX_[117];
    vX_[96] = 2. * vX_[128];
    vX_[61] = vX_[49] * vX_[57] + vX_[63] * vX_[56];
    vX_[140] = vX_[61] * vX_[60];
    vX_[141] = vX_[96] * vX_[61] + vX_[116] + vX_[140] * vX_[61];
    vX_[142] = vX_[61] * vX_[71];
    vX_[143] = vX_[136] * vX_[61] + vX_[123] - vX_[72] * vX_[61] - vX_[142] * vX_[61];
    vX_[144] = vX_[49] * vX_[141] + vX_[48] * vX_[143];
    vX_[145] = vX_[49] * vX_[143];
    vX_[146] = 2. * vX_[132];
    vX_[147] = 0 - vX_[61] * vX_[62];
    vX_[148] = vX_[119] - vX_[146] * vX_[61] - vX_[147] * vX_[61];
    vX_[149] = vX_[145] + vX_[48] * vX_[148];
    vX_[150] = vX_[144] * vX_[49] + vX_[149] * vX_[48];
    vX_[151] = vX_[63] * vX_[143] + vX_[49] * vX_[148];
    vX_[145] = vX_[63] * vX_[141] + vX_[145];
    vX_[152] = -0.0022920002 + vX_[151] * vX_[48] + vX_[145] * vX_[49];
    vX_[153] = vX_[145] * vX_[63] + vX_[151] * vX_[49];
    vX_[154] = 0.09570849 + vX_[153];
    vX_[155] = vX_[152] / vX_[154];
    vX_[156] = 0.01828449 + vX_[150] - vX_[152] * vX_[155];
    vX_[157] = (-vX_[46]) * x_in[9];
    vX_[158] = 0.0036857284 - -0.00021200017 * vX_[155];
    vX_[159] = vX_[33] * x_in[9];
    vX_[160] = vX_[129] * vX_[70];
    vX_[161] = vX_[160] / vX_[117];
    vX_[162] = vX_[126] * vX_[70] + vX_[127] * vX_[68] - vX_[134] - vX_[108] * vX_[161];
    vX_[163] = vX_[91] * vX_[68] - vX_[130] * vX_[161];
    vX_[164] = vX_[162] - vX_[61] * vX_[163];
    vX_[165] = 0 - vX_[164];
    vX_[166] = 0 - vX_[134] * vX_[161];
    vX_[167] = vX_[104] * vX_[70] - vX_[122] * vX_[161];
    vX_[168] = vX_[61] * vX_[166] + vX_[167];
    vX_[169] = vX_[49] * vX_[168];
    vX_[170] = vX_[63] * vX_[165] + vX_[169];
    vX_[171] = vX_[49] * vX_[165] + vX_[48] * vX_[168];
    vX_[172] = 0.008711861 - vX_[171];
    vX_[173] = vX_[172] / vX_[154];
    vX_[174] = 1.52322944854339e-09 + vX_[170] - vX_[152] * vX_[173];
    vX_[175] = vX_[39] * x_in[9];
    vX_[176] = vX_[140] + vX_[128];
    vX_[177] = vX_[136] - vX_[142];
    vX_[178] = vX_[49] * vX_[176] + vX_[48] * vX_[177];
    vX_[179] = vX_[142] + vX_[72];
    vX_[180] = vX_[147] + vX_[132];
    vX_[181] = vX_[49] * vX_[179] + vX_[48] * vX_[180];
    vX_[182] = vX_[63] * vX_[176] + vX_[49] * vX_[177];
    vX_[183] = vX_[63] * vX_[179] + vX_[49] * vX_[180];
    vX_[184] = 0.160298259823722 + vX_[182] * vX_[48] + vX_[183] * vX_[49];
    vX_[185] = vX_[184] / vX_[154];
    vX_[186] = vX_[178] * vX_[48] + vX_[181] * vX_[49] - vX_[152] * vX_[185];
    vX_[187] = (-vX_[52]) * x_in[9];
    vX_[188] = vX_[37] * vX_[52] + vX_[40] * vX_[54];
    vX_[32] = vX_[45] * vX_[32] + vX_[46] * vX_[36];
    vX_[189] = vX_[45] * vX_[33] + vX_[46] * vX_[29];
    vX_[40] = vX_[45] * vX_[40] + vX_[46] * vX_[37];
    vX_[190] = vX_[29] * vX_[33] + vX_[33] * vX_[29];
    vX_[191] = 0.160298259823722 * (vX_[188] - vX_[32]) + -0.06337651 * vX_[189] + -0.0022920002 * vX_[40] +
               vX_[49] * vX_[92] + vX_[63] * vX_[98] + vX_[76] * vX_[138] + vX_[56] * vX_[74] - -0.008711861 * vX_[42] -
               -0.00021200017 * vX_[43] - 0.0036857284 * (vX_[190] - vX_[47]);
    vX_[192] = 0 - vX_[191];
    vX_[52] = vX_[45] * vX_[39] + vX_[46] * vX_[41] - (vX_[29] * vX_[52] + vX_[33] * vX_[54]);
    vX_[98] = 1.52322944854339e-09 * vX_[42] + 0.0036857284 * vX_[43] + -0.00021200017 * (vX_[44] - vX_[47]) +
              vX_[48] * vX_[92] + vX_[49] * vX_[98] + vX_[77] * vX_[138] + vX_[57] * vX_[74] + vX_[156] * vX_[157] +
              vX_[158] * vX_[159] + vX_[174] * vX_[175] + vX_[186] * vX_[187] + (vX_[152] * vX_[192]) / vX_[154] -
              0.160298259823722 * vX_[52] - 0.01404749 * vX_[40] - -0.0022920002 * vX_[189];
    vX_[92] = -0.00021200017 / vX_[154];
    vX_[153] = 0.081661 + vX_[148] + vX_[141] - vX_[150] - vX_[153] - -0.00021200017 * vX_[92];
    vX_[150] = 0 - -0.00021200017 * vX_[173];
    vX_[170] = -1.52322944854339e-09 + vX_[164] * vX_[48] + vX_[169] - vX_[170] - -0.00021200017 * vX_[185];
    vX_[90] = -0.008711861 * vX_[52] + 1.52322944854339e-09 * (vX_[32] - vX_[188]) + 0.077424 * vX_[43] +
              -0.00021200017 * vX_[189] + (vX_[117] * vX_[89]) / vX_[117] + vX_[90] + vX_[158] * vX_[157] +
              vX_[153] * vX_[159] + vX_[150] * vX_[175] + vX_[170] * vX_[187] + (-0.00021200017 * vX_[192]) / vX_[154] -
              0.0036857284 * vX_[40] - -0.0022920002 * (vX_[44] - vX_[190]);
    vX_[169] = vX_[183] * vX_[63] + vX_[182] * vX_[49];
    vX_[46] = vX_[169] / vX_[154];
    vX_[39] = -0.160298259823722 + vX_[178] * vX_[49] + vX_[181] * vX_[63] - vX_[152] * vX_[46];
    vX_[171] = -0.008711861 + vX_[164] * vX_[49] + vX_[168] * vX_[63] + vX_[171] - -0.00021200017 * vX_[46];
    vX_[33] = 0 - vX_[166];
    vX_[193] = 0 - vX_[48] * vX_[163] - vX_[49] * vX_[33] - vX_[172] * vX_[46];
    vX_[139] = 3.650675 + vX_[139] - vX_[160] * vX_[161];
    vX_[194] = vX_[60] - vX_[139];
    vX_[195] = vX_[63] * vX_[71] + vX_[49] * vX_[194];
    vX_[196] = vX_[62] - vX_[139];
    vX_[197] = vX_[49] * vX_[71];
    vX_[198] = vX_[63] * vX_[196] + vX_[197];
    vX_[199] = vX_[195] * vX_[48] + vX_[198] * vX_[49] - vX_[184] * vX_[46];
    vX_[52] = 1.7423722 * vX_[52] + 0.160298259823722 * vX_[40] + -0.008711861 * vX_[43] + vX_[49] * vX_[74] +
              vX_[78] * vX_[138] + vX_[39] * vX_[157] + vX_[171] * vX_[159] + vX_[193] * vX_[175] +
              vX_[199] * vX_[187] + (vX_[169] * vX_[192]) / vX_[154] - 1.52322944854339e-09 * (vX_[190] + vX_[47]);
    vX_[200] = -1 * vX_[51];
    vX_[201] = vX_[49] * vX_[196] + vX_[48] * vX_[71];
    vX_[197] = vX_[197] + vX_[48] * vX_[194];
    vX_[202] = vX_[201] * vX_[49] + vX_[197] * vX_[48];
    vX_[203] = vX_[198] * vX_[63] + vX_[195] * vX_[49];
    vX_[204] = 1.7423722 + vX_[194] + vX_[196] + vX_[139] - vX_[202] - vX_[203] - vX_[172] * vX_[173];
    vX_[205] = -0.304 * vX_[26];
    vX_[206] = vX_[49] * vX_[163] + vX_[63] * vX_[33] - vX_[172] * vX_[185];
    vX_[207] = vX_[200] * vX_[204] - vX_[205] * vX_[206];
    vX_[202] = 1.7423722 + vX_[139] + vX_[202] - vX_[184] * vX_[185];
    vX_[208] = vX_[200] * vX_[206] - vX_[205] * vX_[202];
    vX_[209] = vX_[207] * vX_[200] - vX_[208] * vX_[205];
    vX_[210] = 2. * vX_[171];
    vX_[203] = 1.7423722 + vX_[139] + vX_[203] - vX_[169] * vX_[46];
    vX_[139] = 0 - vX_[200] * vX_[203];
    vX_[211] = vX_[153] - vX_[210] * vX_[200] - vX_[139] * vX_[200] - vX_[209];
    vX_[212] = vX_[158] + vX_[171] * vX_[205] + vX_[139] * vX_[205] - vX_[39] * vX_[200];
    vX_[213] = vX_[26] * vX_[212];
    vX_[214] = vX_[27] * vX_[211] + vX_[213];
    vX_[215] = 2. * vX_[39];
    vX_[216] = vX_[205] * vX_[203];
    vX_[217] = vX_[215] * vX_[205] + vX_[156] + vX_[216] * vX_[205] - vX_[209];
    vX_[218] = vX_[27] * vX_[212] + vX_[26] * vX_[217];
    vX_[219] = vX_[214] * vX_[27] + vX_[218] * vX_[26];
    vX_[213] = vX_[213] + vX_[28] * vX_[217];
    vX_[220] = vX_[26] * vX_[211] + vX_[28] * vX_[212];
    vX_[221] = -0.0037997814 + vX_[213] * vX_[26] + vX_[220] * vX_[27];
    vX_[222] = vX_[220] * vX_[26] + vX_[213] * vX_[28];
    vX_[223] = 0.010329999 + vX_[209] + vX_[222];
    vX_[224] = vX_[221] / vX_[223];
    vX_[225] = 0.20986895 + vX_[209] + vX_[219] - vX_[221] * vX_[224];
    vX_[226] = (-vX_[24]) * x_in[8];
    vX_[227] = vX_[200] * vX_[193];
    vX_[228] = 0 - vX_[227];
    vX_[229] = 0 - vX_[200] * vX_[199];
    vX_[230] = vX_[150] * vX_[200] + vX_[228] * vX_[200] - vX_[170] * vX_[205] - vX_[229] * vX_[205];
    vX_[231] = vX_[205] * vX_[199];
    vX_[232] = vX_[205] * vX_[193];
    vX_[233] = vX_[186] * vX_[205] + vX_[231] * vX_[205] - vX_[174] * vX_[200] - vX_[232] * vX_[200];
    vX_[234] = -0.011715295 - vX_[26] * vX_[230] - vX_[27] * vX_[233];
    vX_[235] = 5.399998e-05 + vX_[28] * vX_[230] + vX_[26] * vX_[233] - vX_[234] * vX_[224];
    vX_[236] = vX_[19] * x_in[8];
    vX_[237] = vX_[216] + vX_[39];
    vX_[238] = 0 - vX_[237];
    vX_[239] = vX_[139] + vX_[171];
    vX_[240] = vX_[26] * vX_[238] + vX_[28] * vX_[239];
    vX_[241] = vX_[27] * vX_[238] + vX_[26] * vX_[239];
    vX_[242] = -0.01438086 - vX_[241];
    vX_[243] = vX_[242] / vX_[223];
    vX_[244] = 0.647967112 + vX_[240] - vX_[221] * vX_[243];
    vX_[245] = vX_[13] * x_in[8];
    vX_[246] = vX_[229] + vX_[170];
    vX_[227] = vX_[227] - vX_[231];
    vX_[247] = vX_[186] + vX_[231] - vX_[227];
    vX_[248] = vX_[27] * vX_[246] + vX_[26] * vX_[247];
    vX_[249] = vX_[150] + vX_[228] - vX_[227];
    vX_[250] = vX_[232] + vX_[174];
    vX_[251] = vX_[27] * vX_[249] + vX_[26] * vX_[250];
    vX_[252] = vX_[26] * vX_[246] + vX_[28] * vX_[247];
    vX_[253] = vX_[26] * vX_[249] + vX_[28] * vX_[250];
    vX_[254] = -0.0055615274403 + vX_[252] * vX_[26] + vX_[253] * vX_[27];
    vX_[255] = vX_[254] / vX_[223];
    vX_[256] = vX_[248] * vX_[26] + vX_[251] * vX_[27] + vX_[227] - vX_[221] * vX_[255];
    vX_[257] = (-vX_[31]) * x_in[8];
    vX_[258] = vX_[10] * vX_[31] + vX_[7] * vX_[35];
    vX_[259] = vX_[23] * vX_[19] + vX_[24] * vX_[18];
    vX_[260] = vX_[23] * vX_[7] + vX_[24] * vX_[10];
    vX_[261] = vX_[18] * vX_[19] + vX_[19] * vX_[18];
    vX_[262] = -0.0055615274403 * vX_[258] + 0.00750500000000001 * vX_[259] + -0.0037997814 * vX_[260] +
               vX_[28] * vX_[98] + vX_[26] * vX_[90] - 0.01438086 * vX_[17] - -0.011715295 * vX_[20] -
               5.399998e-05 * (vX_[261] - vX_[25]);
    vX_[263] = 0 - vX_[262];
    vX_[31] = vX_[23] * vX_[13] + vX_[24] * vX_[16] - (vX_[18] * vX_[31] + vX_[19] * vX_[35]);
    vX_[90] = 0.647967112 * vX_[17] + 5.399998e-05 * vX_[20] + -0.011715295 * (vX_[21] - vX_[25]) + vX_[26] * vX_[98] +
              vX_[27] * vX_[90] + -0.304 * vX_[52] + vX_[225] * vX_[226] + vX_[235] * vX_[236] + vX_[244] * vX_[245] +
              vX_[256] * vX_[257] + (vX_[221] * vX_[263]) / vX_[223] - -0.0055615274403 * vX_[31] -
              -0.192033951 * vX_[260] - -0.0037997814 * vX_[259];
    vX_[258] = -vX_[258];
    vX_[190] = 1.7423722 * vX_[42] + 1.52322944854339e-09 * vX_[40] + -0.008711861 * vX_[189] +
               2.1032 * (vX_[64] * vX_[58] + vX_[65] * vX_[59] - (vX_[50] * vX_[79] + vX_[53] * vX_[82])) +
               vX_[95] * vX_[87] + vX_[68] * vX_[85] + vX_[162] * vX_[120] + vX_[167] * vX_[124] + vX_[163] * vX_[133] +
               vX_[166] * vX_[137] + (vX_[160] * vX_[89]) / vX_[117] + vX_[174] * vX_[157] + vX_[150] * vX_[159] +
               vX_[204] * vX_[175] + vX_[206] * vX_[187] + (vX_[172] * vX_[192]) / vX_[154] -
               0.160298259823722 * (vX_[44] + vX_[190]) - 0.057838 * (vX_[88] + vX_[66]);
    vX_[189] = -1.7423722 * (vX_[32] - vX_[188]) + 0.160298259823722 * vX_[189] + 1.52322944854339e-09 * vX_[43] +
               vX_[48] * vX_[74] + vX_[49] * vX_[138] + vX_[186] * vX_[157] + vX_[170] * vX_[159] +
               vX_[206] * vX_[175] + vX_[202] * vX_[187] + (vX_[184] * vX_[192]) / vX_[154] -
               -0.008711861 * (vX_[44] + vX_[47]);
    vX_[32] = vX_[234] / vX_[223];
    vX_[222] = 0.20236395 + vX_[217] + vX_[211] + vX_[209] - vX_[219] - vX_[222] - vX_[234] * vX_[32];
    vX_[219] = vX_[227] - vX_[234] * vX_[243];
    vX_[237] = -1 * (vX_[208] + vX_[237]);
    vX_[209] = -1 * (vX_[207] + vX_[239]);
    vX_[240] = -0.647967112 + vX_[237] * vX_[26] + vX_[209] * vX_[27] - vX_[240] - vX_[234] * vX_[255];
    vX_[31] = 0.01438086 * vX_[31] + 0.647967112 * vX_[258] + -0.199538951 * vX_[20] + -0.011715295 * vX_[259] +
              vX_[51] * vX_[190] + -1 * (vX_[191] + (vX_[154] * vX_[192]) / vX_[154]) + vX_[38] * vX_[189] +
              vX_[235] * vX_[226] + vX_[222] * vX_[236] + vX_[219] * vX_[245] + vX_[240] * vX_[257] +
              (vX_[234] * vX_[263]) / vX_[223] - 5.399998e-05 * vX_[260] - -0.0037997814 * (vX_[21] - vX_[261]);
    vX_[191] = vX_[202] - vX_[203];
    vX_[188] = vX_[204] - vX_[203];
    vX_[74] = vX_[26] * vX_[206];
    vX_[138] = vX_[27] * vX_[188] + vX_[74];
    vX_[47] = vX_[27] * vX_[206] + vX_[26] * vX_[191];
    vX_[44] = vX_[138] * vX_[27] + vX_[47] * vX_[26];
    vX_[43] = vX_[26] * vX_[188] + vX_[28] * vX_[206];
    vX_[74] = vX_[74] + vX_[28] * vX_[191];
    vX_[40] = vX_[43] * vX_[26] + vX_[74] * vX_[28];
    vX_[88] = 2.327 + vX_[191] + vX_[188] + vX_[203] - vX_[44] - vX_[40] - vX_[242] * vX_[243];
    vX_[87] = 0 - vX_[199];
    vX_[85] = vX_[28] * vX_[193] + vX_[26] * vX_[87] - vX_[242] * vX_[255];
    vX_[261] = 2.327 * vX_[17] + 0.647967112 * vX_[260] + 0.01438086 * vX_[259] + -1 * vX_[52] + vX_[244] * vX_[226] +
               vX_[219] * vX_[236] + vX_[88] * vX_[245] + vX_[85] * vX_[257] + (vX_[242] * vX_[263]) / vX_[223] -
               -0.0055615274403 * (vX_[21] + vX_[261]);
    vX_[44] = 2.327 + vX_[203] + vX_[44] - vX_[254] * vX_[255];
    vX_[189] = -2.327 * vX_[258] + -0.0055615274403 * vX_[259] + 0.647967112 * vX_[20] + vX_[26] * vX_[189] +
               vX_[27] * vX_[190] + vX_[256] * vX_[226] + vX_[240] * vX_[236] + vX_[85] * vX_[245] +
               vX_[44] * vX_[257] + (vX_[254] * vX_[263]) / vX_[223] - 0.01438086 * (vX_[21] + vX_[25]);
    vX_[190] = 2. * vX_[240];
    vX_[258] = vX_[11] * vX_[12] + vX_[22] * vX_[15];
    vX_[259] = vX_[258] * vX_[44];
    vX_[25] = vX_[190] * vX_[258] + vX_[222] + vX_[259] * vX_[258];
    vX_[21] = vX_[258] * vX_[85];
    vX_[20] = vX_[256] * vX_[258] + vX_[235] - vX_[219] * vX_[258] - vX_[21] * vX_[258];
    vX_[260] = vX_[11] * vX_[25] + vX_[9] * vX_[20];
    vX_[52] = vX_[11] * vX_[20];
    vX_[17] = 2. * vX_[244];
    vX_[79] = 0 - vX_[258] * vX_[88];
    vX_[66] = vX_[225] - vX_[17] * vX_[258] - vX_[79] * vX_[258];
    vX_[65] = vX_[52] + vX_[9] * vX_[66];
    vX_[58] = vX_[260] * vX_[11] + vX_[65] * vX_[9];
    vX_[53] = vX_[22] * vX_[20] + vX_[11] * vX_[66];
    vX_[52] = vX_[22] * vX_[25] + vX_[52];
    vX_[42] = -0.002752 + vX_[53] * vX_[9] + vX_[52] * vX_[11];
    vX_[98] = vX_[52] * vX_[22] + vX_[53] * vX_[11];
    vX_[24] = 0.051393528 + vX_[98];
    vX_[19] = vX_[42] / vX_[24];
    vX_[13] = 0.08585553 + vX_[58] - vX_[42] * vX_[19];
    vX_[264] = (-vX_[7]) * x_in[7];
    vX_[265] = 0.0055279857 - -0.022851627 * vX_[19];
    vX_[266] = vX_[14] * vX_[2] + vX_[2] * vX_[14];
    vX_[267] = vX_[7] * x_in[7];
    vX_[7] = vX_[5] * vX_[2] + vX_[7] * vX_[14];
    vX_[2] = -0.022851627 * vX_[3] + 0.0055279857 * (vX_[266] - vX_[8]) - -0.002752 * vX_[267] - 0.046852534 * vX_[7] -
             vX_[11] * vX_[90] - vX_[22] * vX_[31] - vX_[34] * vX_[261] - vX_[15] * vX_[189];
    vX_[268] = vX_[14] * x_in[7];
    vX_[269] = x_in[7] * x_in[7];
    vX_[270] = vX_[5] * vX_[5];
    vX_[271] = 0 - vX_[10] * vX_[16];
    vX_[272] = vX_[18] * vX_[10];
    vX_[273] = vX_[10] * vX_[10];
    vX_[274] = vX_[23] * vX_[23];
    vX_[275] = vX_[29] * vX_[36] - vX_[37] * vX_[41];
    vX_[276] = vX_[29] * vX_[37];
    vX_[277] = vX_[37] * vX_[37];
    vX_[278] = vX_[45] * vX_[45];
    vX_[279] = vX_[50] * vX_[54] - vX_[55] * vX_[59];
    vX_[280] = vX_[50] * vX_[55];
    vX_[281] = vX_[55] * vX_[55];
    vX_[282] = vX_[64] * vX_[64];
    vX_[283] = vX_[69] * vX_[73];
    vX_[284] = vX_[75] * vX_[83];
    vX_[285] = vX_[69] * vX_[86];
    vX_[286] = vX_[69] * vX_[75];
    vX_[287] = vX_[73] * vX_[75];
    vX_[288] = vX_[73] * vX_[73];
    vX_[289] = vX_[69] * vX_[69];
    vX_[290] = -0.00751 * vX_[283] + 0.038686875 * (vX_[284] - vX_[285]) + -0.000829 * vX_[286] - 1.5e-05 * vX_[287] -
               0.000198 * (vX_[288] - vX_[289]);
    vX_[291] = x_in[17] - vX_[290];
    vX_[292] = vX_[75] * vX_[75];
    vX_[293] = 1.547475 * (vX_[73] * vX_[86] - vX_[75] * vX_[97]) + 1.547475 * vX_[97] * x_in[11] -
               0.038686875 * (vX_[292] + vX_[288]);
    vX_[294] = 0 - vX_[69];
    vX_[295] = vX_[294] * x_in[11];
    vX_[296] = vX_[73] * x_in[11];
    vX_[297] = 0 - vX_[83];
    vX_[298] = vX_[297] * x_in[11];
    vX_[285] = 0.038686875 * vX_[283] + -1.547475 * (vX_[285] - vX_[284]) + 0.00345708950900075 * vX_[295] +
               -6.25528861700981e-05 * vX_[296] + 1.38614328745655 * vX_[298] + (0.038686875 * vX_[291]) / 0.009277;
    vX_[284] = 0 - vX_[64];
    vX_[299] = vX_[284] * x_in[10];
    vX_[300] = vX_[50] * x_in[10];
    vX_[301] = vX_[59] * x_in[10];
    vX_[302] = 0 - vX_[82];
    vX_[303] = vX_[302] * x_in[10];
    vX_[304] = vX_[64] * vX_[55];
    vX_[305] = vX_[64] * vX_[50];
    vX_[306] = vX_[69] * vX_[97] - vX_[73] * vX_[83];
    vX_[289] = 0.000198 * vX_[287] + 1.5e-05 * (vX_[292] - vX_[289]) + 0.00315291990945349 * vX_[295] +
               0.000199340411771047 * vX_[296] + 0.00345708950900075 * vX_[298] + (-0.000829 * vX_[291]) / 0.009277 -
               0.038686875 * vX_[306] - -0.00146 * vX_[286] - -0.000829 * vX_[283];
    vX_[298] = 0.00605 * vX_[287] + 1.5e-05 * vX_[283] + 0.000199340411771047 * vX_[295] +
               0.0107369757464698 * vX_[296] + -6.25528861700981e-05 * vX_[298] + (1.5e-05 * vX_[291]) / 0.009277 -
               0.000198 * vX_[286] - -0.000829 * (vX_[292] - vX_[288]);
    vX_[306] = 0.038686875 * vX_[286] + 1.547475 * vX_[306] + -0.038686875 * vX_[295];
    vX_[295] = vX_[50] * vX_[50];
    vX_[286] = -0.001243 * vX_[304] + 0.009683 * vX_[305] + vX_[70] * vX_[289] + vX_[68] * vX_[298] +
               0.02075 * vX_[306] - -0.012652 * vX_[280] - -0.001387 * (vX_[295] - vX_[282]);
    vX_[296] = x_in[16] - vX_[286];
    vX_[292] = (vX_[108] * vX_[296]) / vX_[117];
    vX_[291] = 0.057838 * vX_[279] + -0.001387 * vX_[280] + -0.012652 * (vX_[281] - vX_[282]) +
               (0.009277 * vX_[291]) / 0.009277 + vX_[290] + vX_[80] * vX_[293] + vX_[94] * vX_[285] +
               vX_[119] * vX_[299] + vX_[123] * vX_[300] + vX_[132] * vX_[301] + vX_[136] * vX_[303] + vX_[292] -
               -0.008386 * vX_[304] - -0.001243 * vX_[305];
    vX_[290] = vX_[64] * vX_[54] - vX_[55] * vX_[82];
    vX_[288] = (vX_[122] * vX_[296]) / vX_[117];
    vX_[305] = -0.018069 * vX_[280] + 0.057838 * vX_[290] + -0.012652 * vX_[305] + vX_[68] * vX_[289] +
               vX_[67] * vX_[298] + -0.184 * vX_[306] + vX_[123] * vX_[299] + vX_[116] * vX_[300] + vX_[72] * vX_[301] +
               vX_[128] * vX_[303] + vX_[288] - -0.001387 * vX_[304] - -0.001243 * (vX_[281] - vX_[295]);
    vX_[281] = (vX_[130] * vX_[296]) / vX_[117];
    vX_[304] = 0.057838 * vX_[304] + 2.1032 * vX_[279] + vX_[68] * vX_[285] + vX_[67] * vX_[293] + vX_[132] * vX_[299] +
               vX_[72] * vX_[300] + vX_[62] * vX_[301] + vX_[71] * vX_[303] + vX_[281];
    vX_[279] = (vX_[134] * vX_[296]) / vX_[117];
    vX_[290] = 0.057838 * vX_[280] + -2.1032 * vX_[290] + vX_[306] + vX_[136] * vX_[299] + vX_[128] * vX_[300] +
               vX_[71] * vX_[301] + vX_[60] * vX_[303] + vX_[279];
    vX_[306] = 0 - vX_[45];
    vX_[280] = vX_[306] * x_in[9];
    vX_[287] = vX_[29] * x_in[9];
    vX_[283] = vX_[41] * x_in[9];
    vX_[307] = 0 - vX_[54];
    vX_[308] = vX_[307] * x_in[9];
    vX_[309] = vX_[37] * vX_[54];
    vX_[310] = vX_[45] * vX_[36];
    vX_[311] = vX_[45] * vX_[29];
    vX_[312] = vX_[45] * vX_[37];
    vX_[313] = vX_[29] * vX_[29];
    vX_[314] = 0.160298259823722 * (vX_[309] - vX_[310]) + -0.06337651 * vX_[311] + -0.0022920002 * vX_[312] +
               vX_[49] * vX_[291] + vX_[63] * vX_[305] + vX_[76] * vX_[304] + vX_[56] * vX_[290] -
               -0.008711861 * vX_[275] - -0.00021200017 * vX_[276] - 0.0036857284 * (vX_[313] - vX_[278]);
    vX_[315] = x_in[15] - vX_[314];
    vX_[316] = (vX_[152] * vX_[315]) / vX_[154];
    vX_[317] = vX_[45] * vX_[41] - vX_[29] * vX_[54];
    vX_[318] = 1.52322944854339e-09 * vX_[275] + 0.0036857284 * vX_[276] + -0.00021200017 * (vX_[277] - vX_[278]) +
               vX_[48] * vX_[291] + vX_[49] * vX_[305] + vX_[77] * vX_[304] + vX_[57] * vX_[290] + vX_[156] * vX_[280] +
               vX_[158] * vX_[287] + vX_[174] * vX_[283] + vX_[186] * vX_[308] + vX_[316] -
               0.160298259823722 * vX_[317] - 0.01404749 * vX_[312] - -0.0022920002 * vX_[311];
    vX_[319] = (vX_[117] * vX_[296]) / vX_[117];
    vX_[320] = (-0.00021200017 * vX_[315]) / vX_[154];
    vX_[286] = -0.008711861 * vX_[317] + 1.52322944854339e-09 * (vX_[310] - vX_[309]) + 0.077424 * vX_[276] +
               -0.00021200017 * vX_[311] + vX_[319] + vX_[286] + vX_[158] * vX_[280] + vX_[153] * vX_[287] +
               vX_[150] * vX_[283] + vX_[170] * vX_[308] + vX_[320] - 0.0036857284 * vX_[312] -
               -0.0022920002 * (vX_[277] - vX_[313]);
    vX_[321] = (vX_[169] * vX_[315]) / vX_[154];
    vX_[317] = 1.7423722 * vX_[317] + 0.160298259823722 * vX_[312] + -0.008711861 * vX_[276] + vX_[49] * vX_[290] +
               vX_[78] * vX_[304] + vX_[39] * vX_[280] + vX_[171] * vX_[287] + vX_[193] * vX_[283] +
               vX_[199] * vX_[308] + vX_[321] - 1.52322944854339e-09 * (vX_[313] + vX_[278]);
    vX_[322] = 0 - vX_[23];
    vX_[323] = vX_[322] * x_in[8];
    vX_[324] = vX_[18] * x_in[8];
    vX_[325] = vX_[16] * x_in[8];
    vX_[326] = 0 - vX_[35];
    vX_[327] = vX_[326] * x_in[8];
    vX_[328] = vX_[10] * vX_[35];
    vX_[329] = vX_[23] * vX_[18];
    vX_[330] = vX_[23] * vX_[10];
    vX_[331] = vX_[18] * vX_[18];
    vX_[332] = -0.0055615274403 * vX_[328] + 0.00750500000000001 * vX_[329] + -0.0037997814 * vX_[330] +
               vX_[28] * vX_[318] + vX_[26] * vX_[286] - 0.01438086 * vX_[271] - -0.011715295 * vX_[272] -
               5.399998e-05 * (vX_[331] - vX_[274]);
    vX_[333] = x_in[14] - vX_[332];
    vX_[334] = (vX_[221] * vX_[333]) / vX_[223];
    vX_[335] = vX_[23] * vX_[16] - vX_[18] * vX_[35];
    vX_[336] = 0.647967112 * vX_[271] + 5.399998e-05 * vX_[272] + -0.011715295 * (vX_[273] - vX_[274]) +
               vX_[26] * vX_[318] + vX_[27] * vX_[286] + -0.304 * vX_[317] + vX_[225] * vX_[323] + vX_[235] * vX_[324] +
               vX_[244] * vX_[325] + vX_[256] * vX_[327] + vX_[334] - -0.0055615274403 * vX_[335] -
               -0.192033951 * vX_[330] - -0.0037997814 * vX_[329];
    vX_[328] = 0 - vX_[328];
    vX_[337] = (vX_[160] * vX_[296]) / vX_[117];
    vX_[338] = (vX_[172] * vX_[315]) / vX_[154];
    vX_[313] = 1.7423722 * vX_[275] + 1.52322944854339e-09 * vX_[312] + -0.008711861 * vX_[311] +
               2.1032 * (vX_[64] * vX_[59] - vX_[50] * vX_[82]) + vX_[95] * vX_[285] + vX_[68] * vX_[293] +
               vX_[162] * vX_[299] + vX_[167] * vX_[300] + vX_[163] * vX_[301] + vX_[166] * vX_[303] + vX_[337] +
               vX_[174] * vX_[280] + vX_[150] * vX_[287] + vX_[204] * vX_[283] + vX_[206] * vX_[308] + vX_[338] -
               0.160298259823722 * (vX_[277] + vX_[313]) - 0.057838 * (vX_[295] + vX_[282]);
    vX_[312] = (vX_[154] * vX_[315]) / vX_[154];
    vX_[295] = (vX_[184] * vX_[315]) / vX_[154];
    vX_[311] = -1.7423722 * (vX_[310] - vX_[309]) + 0.160298259823722 * vX_[311] + 1.52322944854339e-09 * vX_[276] +
               vX_[48] * vX_[290] + vX_[49] * vX_[304] + vX_[186] * vX_[280] + vX_[170] * vX_[287] +
               vX_[206] * vX_[283] + vX_[202] * vX_[308] + vX_[295] - -0.008711861 * (vX_[277] + vX_[278]);
    vX_[310] = (vX_[234] * vX_[333]) / vX_[223];
    vX_[335] = 0.01438086 * vX_[335] + 0.647967112 * vX_[328] + -0.199538951 * vX_[272] + -0.011715295 * vX_[329] +
               vX_[51] * vX_[313] + -1 * (vX_[314] + vX_[312]) + vX_[38] * vX_[311] + vX_[235] * vX_[323] +
               vX_[222] * vX_[324] + vX_[219] * vX_[325] + vX_[240] * vX_[327] + vX_[310] - 5.399998e-05 * vX_[330] -
               -0.0037997814 * (vX_[273] - vX_[331]);
    vX_[314] = (vX_[242] * vX_[333]) / vX_[223];
    vX_[331] = 2.327 * vX_[271] + 0.647967112 * vX_[330] + 0.01438086 * vX_[329] + -1 * vX_[317] + vX_[244] * vX_[323] +
               vX_[219] * vX_[324] + vX_[88] * vX_[325] + vX_[85] * vX_[327] + vX_[314] -
               -0.0055615274403 * (vX_[273] + vX_[331]);
    vX_[330] = (vX_[254] * vX_[333]) / vX_[223];
    vX_[328] = -2.327 * vX_[328] + -0.0055615274403 * vX_[329] + 0.647967112 * vX_[272] + vX_[26] * vX_[311] +
               vX_[27] * vX_[313] + vX_[256] * vX_[323] + vX_[240] * vX_[324] + vX_[85] * vX_[325] +
               vX_[44] * vX_[327] + vX_[330] - 0.01438086 * (vX_[273] + vX_[274]);
    vX_[329] = 0 - vX_[5];
    vX_[274] = vX_[329] * x_in[7];
    vX_[273] = vX_[14] * vX_[14];
    vX_[272] = vX_[5] * x_in[7];
    vX_[317] = vX_[5] * vX_[14];
    vX_[271] = -0.022851627 * vX_[268] + 0.0055279857 * (vX_[273] - vX_[270]) + x_in[13] - -0.002752 * vX_[272] -
               0.046852534 * vX_[317] - vX_[11] * vX_[336] - vX_[22] * vX_[335] - vX_[34] * vX_[331] -
               vX_[15] * vX_[328];
    vX_[309] = (vX_[42] * vX_[271]) / vX_[24];
    vX_[270] = 0.0055279857 * vX_[268] + -0.022851627 * (vX_[269] - vX_[270]) + vX_[9] * vX_[336] + vX_[11] * vX_[335] +
               vX_[30] * vX_[331] + vX_[12] * vX_[328] + vX_[13] * vX_[274] + vX_[265] * vX_[268] + vX_[309] -
               0.012390532 * vX_[272] - -0.002752 * vX_[317];
    vX_[278] = -0.022851627 / vX_[24];
    vX_[98] = 0.039002996 + vX_[66] + vX_[25] - vX_[58] - vX_[98] - -0.022851627 * vX_[278];
    vX_[58] = (vX_[223] * vX_[333]) / vX_[223];
    vX_[277] = (-0.022851627 * vX_[271]) / vX_[24];
    vX_[317] = -0.034462002 * vX_[268] + -0.022851627 * vX_[317] + vX_[58] + vX_[332] + vX_[265] * vX_[274] +
               vX_[98] * vX_[268] + vX_[277] - 0.0055279857 * vX_[272] - -0.002752 * (vX_[269] - vX_[273]);
    vX_[227] = vX_[252] * vX_[28] + vX_[253] * vX_[26] + vX_[227];
    vX_[272] = vX_[227] / vX_[223];
    vX_[273] = 0 - vX_[26] * vX_[193] - vX_[27] * vX_[87] - vX_[242] * vX_[272];
    vX_[332] = 0.0055615274403 + vX_[248] * vX_[28] + vX_[251] * vX_[26] - vX_[258] * vX_[273] - vX_[221] * vX_[272];
    vX_[269] = vX_[74] * vX_[26] + vX_[43] * vX_[27] - vX_[254] * vX_[272];
    vX_[241] =
        0.01438086 + vX_[237] * vX_[28] + vX_[209] * vX_[26] + vX_[241] + vX_[258] * vX_[269] - vX_[234] * vX_[272];
    vX_[276] = vX_[11] * vX_[241];
    vX_[282] = -1 * 0.178 * vX_[0];
    vX_[40] = 2.327 + vX_[203] + vX_[40] - vX_[227] * vX_[272];
    vX_[275] = vX_[44] - vX_[40];
    vX_[339] = vX_[22] * vX_[85] + vX_[11] * vX_[275];
    vX_[340] = vX_[88] - vX_[40];
    vX_[341] = vX_[11] * vX_[85];
    vX_[342] = vX_[22] * vX_[340] + vX_[341];
    vX_[343] = vX_[259] + vX_[240];
    vX_[344] = vX_[256] - vX_[21];
    vX_[345] = vX_[22] * vX_[343] + vX_[11] * vX_[344];
    vX_[346] = vX_[21] + vX_[219];
    vX_[347] = vX_[79] + vX_[244];
    vX_[348] = vX_[22] * vX_[346] + vX_[11] * vX_[347];
    vX_[349] = 0.293374233908935 + vX_[345] * vX_[9] + vX_[348] * vX_[11];
    vX_[350] = vX_[348] * vX_[22] + vX_[345] * vX_[11];
    vX_[351] = vX_[350] / vX_[24];
    vX_[352] = vX_[339] * vX_[9] + vX_[342] * vX_[11] - vX_[349] * vX_[351];
    vX_[353] = 0 - vX_[332];
    vX_[354] = vX_[22] * vX_[353] + vX_[276];
    vX_[355] = vX_[349] / vX_[24];
    vX_[276] =
        -0.0099341499912 + vX_[332] * vX_[9] + vX_[276] - vX_[282] * vX_[352] - vX_[354] - -0.022851627 * vX_[355];
    vX_[356] = vX_[11] * vX_[343] + vX_[9] * vX_[344];
    vX_[357] = vX_[11] * vX_[346] + vX_[9] * vX_[347];
    vX_[358] = 0.178 * (0 - vX_[4]);
    vX_[359] = vX_[358] * vX_[352];
    vX_[360] = 0 - vX_[269];
    vX_[361] = vX_[11] * vX_[353] + vX_[9] * vX_[241];
    vX_[362] = 0.0606159433962 - vX_[361];
    vX_[363] = 0 - vX_[9] * vX_[273] - vX_[11] * vX_[360] - vX_[362] * vX_[351];
    vX_[364] = vX_[282] * vX_[363];
    vX_[365] = vX_[364] - vX_[359];
    vX_[359] = vX_[356] * vX_[9] + vX_[357] * vX_[11] + vX_[359] - vX_[42] * vX_[355] - vX_[365];
    vX_[366] = vX_[4] * vX_[276] + vX_[0] * vX_[359];
    vX_[367] = -1 * 0.178 * vX_[1];
    vX_[368] = 0.178 * (-vX_[6]);
    vX_[369] = vX_[368] * vX_[352];
    vX_[370] = vX_[367] * vX_[363];
    vX_[371] = vX_[370] - vX_[369];
    vX_[372] = vX_[362] / vX_[24];
    vX_[364] = 0 - vX_[364] - -0.022851627 * vX_[372] - vX_[365];
    vX_[354] = 0.0099341499912 + vX_[354] + vX_[358] * vX_[363] - vX_[42] * vX_[372];
    vX_[373] = vX_[4] * vX_[364] + vX_[0] * vX_[354];
    vX_[361] = -0.0606159433962 + vX_[332] * vX_[11] + vX_[241] * vX_[22] + vX_[361] - -0.022851627 * vX_[351];
    vX_[374] = vX_[342] * vX_[22] + vX_[339] * vX_[11];
    vX_[375] = 2.5924191 + vX_[40] + vX_[374] - vX_[350] * vX_[351];
    vX_[376] = 0 - vX_[282] * vX_[375];
    vX_[377] = -0.293374233908935 + vX_[356] * vX_[11] + vX_[357] * vX_[22] - vX_[42] * vX_[351];
    vX_[378] = vX_[265] + vX_[361] * vX_[358] + vX_[376] * vX_[358] - vX_[377] * vX_[282];
    vX_[379] = 2. * vX_[377];
    vX_[380] = vX_[358] * vX_[375];
    vX_[381] = vX_[11] * vX_[340] + vX_[9] * vX_[85];
    vX_[341] = vX_[341] + vX_[9] * vX_[275];
    vX_[382] = vX_[381] * vX_[11] + vX_[341] * vX_[9];
    vX_[374] = 2.5924191 + vX_[275] + vX_[340] + vX_[40] - vX_[382] - vX_[374] - vX_[362] * vX_[372];
    vX_[383] = vX_[11] * vX_[273] + vX_[22] * vX_[360] - vX_[362] * vX_[355];
    vX_[384] = vX_[282] * vX_[374] - vX_[358] * vX_[383];
    vX_[382] = 2.5924191 + vX_[40] + vX_[382] - vX_[349] * vX_[355];
    vX_[40] = vX_[282] * vX_[383] - vX_[358] * vX_[382];
    vX_[385] = vX_[384] * vX_[282] - vX_[40] * vX_[358];
    vX_[386] = vX_[379] * vX_[358] + vX_[13] + vX_[380] * vX_[358] - vX_[385];
    vX_[387] = vX_[4] * vX_[378] + vX_[0] * vX_[386];
    vX_[388] = 2. * vX_[361];
    vX_[389] = vX_[98] - vX_[388] * vX_[282] - vX_[376] * vX_[282] - vX_[385];
    vX_[390] = vX_[4] * vX_[389] + vX_[0] * vX_[378];
    vX_[385] = 0.007629 + vX_[387] * vX_[0] + vX_[390] * vX_[4] + vX_[385];
    vX_[365] =
        (x_in[12] - vX_[0] * vX_[270] - vX_[4] * vX_[317] - 9.81 * (vX_[366] * vX_[0] + vX_[373] * vX_[4] + vX_[365])) /
        vX_[385];
    vX_[391] = -vX_[367] * vX_[375];
    vX_[377] = vX_[361] * vX_[368] + vX_[376] * vX_[368] + vX_[391] * vX_[358] - vX_[377] * vX_[367];
    vX_[40] = vX_[384] * vX_[367] + (vX_[367] * vX_[374] - vX_[368] * vX_[383]) * vX_[282] -
              (vX_[40] * vX_[368] + (vX_[367] * vX_[383] - vX_[368] * vX_[382]) * vX_[358]);
    jac[18] =
        (0 -
            (vX_[0] * (0.0055279857 * vX_[3] + -0.022851627 * (0 - vX_[8]) + vX_[9] * vX_[90] + vX_[11] * vX_[31] +
                          vX_[30] * vX_[261] + vX_[12] * vX_[189] + vX_[13] * vX_[264] + vX_[265] * vX_[3] +
                          (vX_[42] * vX_[2]) / vX_[24] - 0.012390532 * vX_[267] - -0.002752 * vX_[7]) +
                vX_[1] * vX_[270]) -
            (vX_[4] * (-0.034462002 * vX_[3] + -0.022851627 * vX_[7] + (vX_[223] * vX_[263]) / vX_[223] + vX_[262] +
                          vX_[265] * vX_[264] + vX_[98] * vX_[3] + (-0.022851627 * vX_[2]) / vX_[24] -
                          0.0055279857 * vX_[267] - -0.002752 * (0 - vX_[266])) +
                vX_[6] * vX_[317]) -
            9.81 * (vX_[366] * vX_[1] +
                       (vX_[4] * (0 - vX_[367] * vX_[352]) + vX_[6] * vX_[276] + vX_[0] * (vX_[369] - vX_[371]) +
                           vX_[1] * vX_[359]) *
                           vX_[0] +
                       vX_[373] * vX_[6] +
                       (vX_[4] * (0 - vX_[370] - vX_[371]) + vX_[6] * vX_[364] + vX_[0] * vX_[368] * vX_[363] +
                           vX_[1] * vX_[354]) *
                           vX_[4] +
                       vX_[371]) -
            vX_[365] * (vX_[387] * vX_[1] +
                           (vX_[4] * vX_[377] + vX_[6] * vX_[378] +
                               vX_[0] * (vX_[379] * vX_[368] + vX_[380] * vX_[368] + vX_[368] * vX_[375] * vX_[358] -
                                            vX_[40]) +
                               vX_[1] * vX_[386]) *
                               vX_[0] +
                           vX_[390] * vX_[6] +
                           (vX_[4] * (0 - vX_[388] * vX_[367] - (vX_[376] * vX_[367] + vX_[391] * vX_[282]) - vX_[40]) +
                               vX_[6] * vX_[389] + vX_[0] * vX_[377] + vX_[1] * vX_[378]) *
                               vX_[4] +
                           vX_[40])) /
        vX_[385];
    vX_[264] = vX_[0] * jac[18] + vX_[1] * vX_[365] + vX_[264];
    vX_[3] = vX_[4] * jac[18] + vX_[6] * vX_[365] + vX_[3];
    vX_[1] = 9.81 * vX_[1];
    vX_[6] = 9.81 * vX_[6];
    jac[19] = (vX_[2] - vX_[42] * vX_[264] - -0.022851627 * vX_[3] - vX_[349] * vX_[1] - vX_[362] * vX_[6]) / vX_[24];
    vX_[226] = vX_[11] * jac[19] + vX_[9] * vX_[264] + vX_[226];
    vX_[236] = vX_[22] * jac[19] + vX_[11] * vX_[264] + vX_[236];
    vX_[257] = vX_[15] * jac[19] + vX_[12] * vX_[264] + vX_[9] * vX_[1] + vX_[257];
    vX_[1] = vX_[34] * jac[19] + vX_[30] * vX_[264] + vX_[11] * vX_[1] + vX_[245];
    jac[20] = (vX_[263] - vX_[223] * vX_[3] - vX_[221] * vX_[226] - vX_[234] * vX_[236] - vX_[227] * vX_[6] -
                  vX_[254] * vX_[257] - vX_[242] * vX_[1]) /
              vX_[223];
    vX_[263] = -1 * vX_[236];
    vX_[3] = vX_[3] + jac[20];
    vX_[157] = vX_[28] * vX_[3] + vX_[26] * vX_[226] + vX_[157];
    vX_[3] = vX_[26] * vX_[3] + vX_[27] * vX_[226] + vX_[159];
    vX_[1] = -0.304 * vX_[226] + -1 * vX_[1];
    vX_[226] = 0 - vX_[27];
    vX_[187] = vX_[26] * vX_[257] + vX_[38] * vX_[236] + vX_[226] * vX_[6] + vX_[187];
    vX_[257] = vX_[27] * vX_[257] + vX_[51] * vX_[236] + vX_[26] * vX_[6] + vX_[175];
    jac[21] = (vX_[192] - vX_[154] * vX_[263] - vX_[152] * vX_[157] - -0.00021200017 * vX_[3] - vX_[169] * vX_[1] -
                  vX_[184] * vX_[187] - vX_[172] * vX_[257]) /
              vX_[154];
    vX_[263] = vX_[263] + jac[21];
    vX_[120] = vX_[49] * vX_[263] + vX_[48] * vX_[157] + vX_[120];
    vX_[124] = vX_[63] * vX_[263] + vX_[49] * vX_[157] + vX_[124];
    vX_[133] = vX_[76] * vX_[263] + vX_[77] * vX_[157] + vX_[49] * vX_[187] + vX_[78] * vX_[1] + vX_[133];
    jac[22] =
        (vX_[89] - vX_[117] * vX_[3] - vX_[108] * vX_[120] - vX_[122] * vX_[124] - vX_[160] * vX_[257] -
            vX_[134] * (vX_[56] * vX_[263] + vX_[57] * vX_[157] + vX_[48] * vX_[187] + vX_[49] * vX_[1] + vX_[137]) -
            vX_[130] * vX_[133]) /
        vX_[117];
    vX_[3] = vX_[3] + jac[22];
    jac[23] = (vX_[93] - 0.009277 * vX_[120] - -0.000829 * (vX_[70] * vX_[3] + vX_[68] * vX_[124] + vX_[99]) -
                  1.5e-05 * (vX_[68] * vX_[3] + vX_[67] * vX_[124] + vX_[100]) -
                  0.038686875 * (vX_[68] * vX_[133] + vX_[94] * vX_[120] + vX_[95] * vX_[257] + vX_[101])) /
              0.009277;
    vX_[3] = cos(x_in[2]);
    vX_[133] = -0.112 * vX_[3];
    vX_[124] = -1 * sin(x_in[2]);
    vX_[120] = 0.112 * vX_[124];
    vX_[257] = vX_[133] * vX_[14] + vX_[120] * x_in[7];
    vX_[101] = -vX_[10] * vX_[257];
    vX_[100] = vX_[124] * vX_[14] + vX_[3] * x_in[7];
    vX_[99] = vX_[100] * vX_[10];
    vX_[93] = -vX_[124];
    vX_[263] = vX_[3] * vX_[14] + vX_[93] * x_in[7];
    vX_[187] = vX_[23] * vX_[263] + vX_[263] * vX_[23];
    vX_[1] = 0.112 * vX_[124];
    vX_[157] = 0.112 * vX_[3];
    vX_[89] = vX_[1] * vX_[14] + vX_[157] * x_in[7];
    vX_[137] = -0.304 * vX_[100] + -1 * vX_[89];
    vX_[192] = vX_[26] * vX_[100];
    vX_[236] = vX_[38] * vX_[263] + vX_[26] * vX_[257];
    vX_[6] = -1 * vX_[263];
    vX_[175] = vX_[29] * vX_[137] + vX_[192] * vX_[36] - (vX_[37] * vX_[236] + vX_[6] * vX_[41]);
    vX_[159] = vX_[29] * vX_[6] + vX_[192] * vX_[37];
    vX_[264] = vX_[37] * vX_[6] + vX_[6] * vX_[37];
    vX_[245] = vX_[27] * vX_[100];
    vX_[2] = vX_[45] * vX_[245] + vX_[245] * vX_[45];
    vX_[40] = vX_[51] * vX_[263] + vX_[27] * vX_[257];
    vX_[377] = vX_[48] * vX_[192] + vX_[49] * vX_[6];
    vX_[391] = vX_[56] * vX_[6] + vX_[57] * vX_[192] + vX_[48] * vX_[236] + vX_[49] * vX_[137];
    vX_[390] = vX_[50] * vX_[40] + vX_[377] * vX_[54] - (vX_[55] * vX_[391] + vX_[245] * vX_[59]);
    vX_[389] = vX_[50] * vX_[245] + vX_[377] * vX_[55];
    vX_[388] = vX_[55] * vX_[245] + vX_[245] * vX_[55];
    vX_[387] = vX_[49] * vX_[192] + vX_[63] * vX_[6];
    vX_[386] = vX_[64] * vX_[387] + vX_[387] * vX_[64];
    vX_[380] = vX_[68] * vX_[387] + vX_[70] * vX_[245];
    vX_[379] = vX_[67] * vX_[387] + vX_[68] * vX_[245];
    vX_[378] = vX_[69] * vX_[380] + vX_[379] * vX_[73];
    vX_[376] = vX_[76] * vX_[6] + vX_[77] * vX_[192] + vX_[49] * vX_[236] + vX_[78] * vX_[137];
    vX_[375] = vX_[67] * vX_[376] + vX_[80] * vX_[377] + vX_[68] * vX_[40];
    vX_[373] = vX_[75] * vX_[375] + vX_[377] * vX_[83];
    vX_[354] = 0.02075 * vX_[245] + -0.184 * vX_[387] + vX_[391];
    vX_[364] = vX_[69] * vX_[354] + vX_[379] * vX_[86];
    vX_[371] = vX_[69] * vX_[377] + vX_[379] * vX_[75];
    vX_[370] = vX_[73] * vX_[377] + vX_[380] * vX_[75];
    vX_[369] = vX_[73] * vX_[380] + vX_[380] * vX_[73];
    vX_[368] = vX_[69] * vX_[379] + vX_[379] * vX_[69];
    vX_[367] = -0.00751 * vX_[378] + 0.038686875 * (vX_[373] - vX_[364]) + -0.000829 * vX_[371] - 1.5e-05 * vX_[370] -
               0.000198 * (vX_[369] - vX_[368]);
    vX_[366] = 0 - vX_[367];
    vX_[359] = vX_[68] * vX_[376] + vX_[94] * vX_[377] + vX_[95] * vX_[40];
    vX_[363] = vX_[75] * vX_[377] + vX_[377] * vX_[75];
    vX_[354] = 1.547475 * (vX_[73] * vX_[354] + vX_[380] * vX_[86] - (vX_[75] * vX_[359] + vX_[377] * vX_[97])) +
               1.547475 * vX_[359] * x_in[11] - 0.038686875 * (vX_[363] + vX_[369]);
    vX_[276] = (-vX_[379]) * x_in[11];
    vX_[352] = vX_[380] * x_in[11];
    vX_[317] = (-vX_[375]) * x_in[11];
    vX_[364] = 0.038686875 * vX_[378] + -1.547475 * (vX_[364] - vX_[373]) + 0.00345708950900075 * vX_[276] +
               -6.25528861700981e-05 * vX_[352] + 1.38614328745655 * vX_[317] + (0.038686875 * vX_[366]) / 0.009277;
    vX_[373] = (-vX_[387]) * x_in[10];
    vX_[270] = vX_[377] * x_in[10];
    vX_[7] = vX_[391] * x_in[10];
    vX_[267] = (-vX_[376]) * x_in[10];
    vX_[266] = vX_[64] * vX_[245] + vX_[387] * vX_[55];
    vX_[189] = vX_[64] * vX_[377] + vX_[387] * vX_[50];
    vX_[359] = vX_[69] * vX_[359] + vX_[379] * vX_[97] - (vX_[73] * vX_[375] + vX_[380] * vX_[83]);
    vX_[368] = 0.000198 * vX_[370] + 1.5e-05 * (vX_[363] - vX_[368]) + 0.00315291990945349 * vX_[276] +
               0.000199340411771047 * vX_[352] + 0.00345708950900075 * vX_[317] + (-0.000829 * vX_[366]) / 0.009277 -
               0.038686875 * vX_[359] - -0.00146 * vX_[371] - -0.000829 * vX_[378];
    vX_[363] = 0.00605 * vX_[370] + 1.5e-05 * vX_[378] + 0.000199340411771047 * vX_[276] +
               0.0107369757464698 * vX_[352] + -6.25528861700981e-05 * vX_[317] + (1.5e-05 * vX_[366]) / 0.009277 -
               0.000198 * vX_[371] - -0.000829 * (vX_[363] - vX_[369]);
    vX_[359] = 0.038686875 * vX_[371] + 1.547475 * vX_[359] + -0.038686875 * vX_[276];
    vX_[371] = vX_[50] * vX_[377] + vX_[377] * vX_[50];
    vX_[369] = -0.001243 * vX_[266] + 0.009683 * vX_[189] + vX_[70] * vX_[368] + vX_[68] * vX_[363] +
               0.02075 * vX_[359] - -0.012652 * vX_[389] - -0.001387 * (vX_[371] - vX_[386]);
    vX_[370] = 0 - vX_[369];
    vX_[367] = 0.057838 * vX_[390] + -0.001387 * vX_[389] + -0.012652 * (vX_[388] - vX_[386]) +
               (0.009277 * vX_[366]) / 0.009277 + vX_[367] + vX_[80] * vX_[354] + vX_[94] * vX_[364] +
               vX_[119] * vX_[373] + vX_[123] * vX_[270] + vX_[132] * vX_[7] + vX_[136] * vX_[267] +
               (vX_[108] * vX_[370]) / vX_[117] - -0.008386 * vX_[266] - -0.001243 * vX_[189];
    vX_[378] = vX_[64] * vX_[40] + vX_[387] * vX_[54] - (vX_[55] * vX_[376] + vX_[245] * vX_[82]);
    vX_[363] = -0.018069 * vX_[389] + 0.057838 * vX_[378] + -0.012652 * vX_[189] + vX_[68] * vX_[368] +
               vX_[67] * vX_[363] + -0.184 * vX_[359] + vX_[123] * vX_[373] + vX_[116] * vX_[270] + vX_[72] * vX_[7] +
               vX_[128] * vX_[267] + (vX_[122] * vX_[370]) / vX_[117] - -0.001387 * vX_[266] -
               -0.001243 * (vX_[388] - vX_[371]);
    vX_[266] = 0.057838 * vX_[266] + 2.1032 * vX_[390] + vX_[68] * vX_[364] + vX_[67] * vX_[354] + vX_[132] * vX_[373] +
               vX_[72] * vX_[270] + vX_[62] * vX_[7] + vX_[71] * vX_[267] + (vX_[130] * vX_[370]) / vX_[117];
    vX_[378] = 0.057838 * vX_[389] + -2.1032 * vX_[378] + vX_[359] + vX_[136] * vX_[373] + vX_[128] * vX_[270] +
               vX_[71] * vX_[7] + vX_[60] * vX_[267] + (vX_[134] * vX_[370]) / vX_[117];
    vX_[359] = (-vX_[245]) * x_in[9];
    vX_[389] = vX_[192] * x_in[9];
    vX_[390] = vX_[236] * x_in[9];
    vX_[368] = (-vX_[40]) * x_in[9];
    vX_[189] = vX_[37] * vX_[40] + vX_[6] * vX_[54];
    vX_[137] = vX_[45] * vX_[137] + vX_[245] * vX_[36];
    vX_[388] = vX_[45] * vX_[192] + vX_[245] * vX_[29];
    vX_[6] = vX_[45] * vX_[6] + vX_[245] * vX_[37];
    vX_[375] = vX_[29] * vX_[192] + vX_[192] * vX_[29];
    vX_[379] = 0.160298259823722 * (vX_[189] - vX_[137]) + -0.06337651 * vX_[388] + -0.0022920002 * vX_[6] +
               vX_[49] * vX_[367] + vX_[63] * vX_[363] + vX_[76] * vX_[266] + vX_[56] * vX_[378] -
               -0.008711861 * vX_[175] - -0.00021200017 * vX_[159] - 0.0036857284 * (vX_[375] - vX_[2]);
    vX_[380] = 0 - vX_[379];
    vX_[40] = vX_[45] * vX_[236] + vX_[245] * vX_[41] - (vX_[29] * vX_[40] + vX_[192] * vX_[54]);
    vX_[363] = 1.52322944854339e-09 * vX_[175] + 0.0036857284 * vX_[159] + -0.00021200017 * (vX_[264] - vX_[2]) +
               vX_[48] * vX_[367] + vX_[49] * vX_[363] + vX_[77] * vX_[266] + vX_[57] * vX_[378] + vX_[156] * vX_[359] +
               vX_[158] * vX_[389] + vX_[174] * vX_[390] + vX_[186] * vX_[368] + (vX_[152] * vX_[380]) / vX_[154] -
               0.160298259823722 * vX_[40] - 0.01404749 * vX_[6] - -0.0022920002 * vX_[388];
    vX_[369] = -0.008711861 * vX_[40] + 1.52322944854339e-09 * (vX_[137] - vX_[189]) + 0.077424 * vX_[159] +
               -0.00021200017 * vX_[388] + (vX_[117] * vX_[370]) / vX_[117] + vX_[369] + vX_[158] * vX_[359] +
               vX_[153] * vX_[389] + vX_[150] * vX_[390] + vX_[170] * vX_[368] +
               (-0.00021200017 * vX_[380]) / vX_[154] - 0.0036857284 * vX_[6] - -0.0022920002 * (vX_[264] - vX_[375]);
    vX_[40] = 1.7423722 * vX_[40] + 0.160298259823722 * vX_[6] + -0.008711861 * vX_[159] + vX_[49] * vX_[378] +
              vX_[78] * vX_[266] + vX_[39] * vX_[359] + vX_[171] * vX_[389] + vX_[193] * vX_[390] +
              vX_[199] * vX_[368] + (vX_[169] * vX_[380]) / vX_[154] - 1.52322944854339e-09 * (vX_[375] + vX_[2]);
    vX_[367] = (-vX_[263]) * x_in[8];
    vX_[245] = vX_[100] * x_in[8];
    vX_[236] = vX_[257] * x_in[8];
    vX_[192] = (-vX_[89]) * x_in[8];
    vX_[261] = vX_[10] * vX_[89];
    vX_[31] = vX_[23] * vX_[100] + vX_[263] * vX_[18];
    vX_[90] = vX_[263] * vX_[10];
    vX_[262] = vX_[18] * vX_[100] + vX_[100] * vX_[18];
    vX_[8] = -0.0055615274403 * vX_[261] + 0.00750500000000001 * vX_[31] + -0.0037997814 * vX_[90] +
             vX_[28] * vX_[363] + vX_[26] * vX_[369] - 0.01438086 * vX_[101] - -0.011715295 * vX_[99] -
             5.399998e-05 * (vX_[262] - vX_[187]);
    vX_[382] = 0 - vX_[8];
    vX_[89] = vX_[23] * vX_[257] + vX_[263] * vX_[16] - (vX_[18] * vX_[89] + vX_[100] * vX_[35]);
    vX_[369] = 0.647967112 * vX_[101] + 5.399998e-05 * vX_[99] + -0.011715295 * (0 - vX_[187]) + vX_[26] * vX_[363] +
               vX_[27] * vX_[369] + -0.304 * vX_[40] + vX_[225] * vX_[367] + vX_[235] * vX_[245] + vX_[244] * vX_[236] +
               vX_[256] * vX_[192] + (vX_[221] * vX_[382]) / vX_[223] - -0.0055615274403 * vX_[89] -
               -0.192033951 * vX_[90] - -0.0037997814 * vX_[31];
    vX_[261] = -vX_[261];
    vX_[375] = 1.7423722 * vX_[175] + 1.52322944854339e-09 * vX_[6] + -0.008711861 * vX_[388] +
               2.1032 * (vX_[64] * vX_[391] + vX_[387] * vX_[59] - (vX_[50] * vX_[376] + vX_[377] * vX_[82])) +
               vX_[95] * vX_[364] + vX_[68] * vX_[354] + vX_[162] * vX_[373] + vX_[167] * vX_[270] + vX_[163] * vX_[7] +
               vX_[166] * vX_[267] + (vX_[160] * vX_[370]) / vX_[117] + vX_[174] * vX_[359] + vX_[150] * vX_[389] +
               vX_[204] * vX_[390] + vX_[206] * vX_[368] + (vX_[172] * vX_[380]) / vX_[154] -
               0.160298259823722 * (vX_[264] + vX_[375]) - 0.057838 * (vX_[371] + vX_[386]);
    vX_[388] = -1.7423722 * (vX_[137] - vX_[189]) + 0.160298259823722 * vX_[388] + 1.52322944854339e-09 * vX_[159] +
               vX_[48] * vX_[378] + vX_[49] * vX_[266] + vX_[186] * vX_[359] + vX_[170] * vX_[389] +
               vX_[206] * vX_[390] + vX_[202] * vX_[368] + (vX_[184] * vX_[380]) / vX_[154] -
               -0.008711861 * (vX_[264] + vX_[2]);
    vX_[89] = 0.01438086 * vX_[89] + 0.647967112 * vX_[261] + -0.199538951 * vX_[99] + -0.011715295 * vX_[31] +
              vX_[51] * vX_[375] + -1 * (vX_[379] + (vX_[154] * vX_[380]) / vX_[154]) + vX_[38] * vX_[388] +
              vX_[235] * vX_[367] + vX_[222] * vX_[245] + vX_[219] * vX_[236] + vX_[240] * vX_[192] +
              (vX_[234] * vX_[382]) / vX_[223] - 5.399998e-05 * vX_[90] - -0.0037997814 * (0 - vX_[262]);
    vX_[262] = 2.327 * vX_[101] + 0.647967112 * vX_[90] + 0.01438086 * vX_[31] + -1 * vX_[40] + vX_[244] * vX_[367] +
               vX_[219] * vX_[245] + vX_[88] * vX_[236] + vX_[85] * vX_[192] + (vX_[242] * vX_[382]) / vX_[223] -
               -0.0055615274403 * vX_[262];
    vX_[388] = -2.327 * vX_[261] + -0.0055615274403 * vX_[31] + 0.647967112 * vX_[99] + vX_[26] * vX_[388] +
               vX_[27] * vX_[375] + vX_[256] * vX_[367] + vX_[240] * vX_[245] + vX_[85] * vX_[236] +
               vX_[44] * vX_[192] + (vX_[254] * vX_[382]) / vX_[223] - 0.01438086 * vX_[187];
    vX_[375] = vX_[11] * vX_[133] + vX_[3] * vX_[12] + vX_[22] * vX_[120] + vX_[93] * vX_[15];
    vX_[261] = vX_[375] * vX_[44];
    vX_[259] = vX_[190] * vX_[375] + vX_[259] * vX_[375] + vX_[261] * vX_[258];
    vX_[190] = vX_[375] * vX_[85];
    vX_[21] = vX_[256] * vX_[375] - vX_[219] * vX_[375] - (vX_[21] * vX_[375] + vX_[190] * vX_[258]);
    vX_[31] = vX_[11] * vX_[21] + vX_[3] * vX_[20];
    vX_[187] = -vX_[375] * vX_[88];
    vX_[79] = 0 - vX_[17] * vX_[375] - (vX_[79] * vX_[375] + vX_[187] * vX_[258]);
    vX_[65] = vX_[260] * vX_[3] +
              (vX_[11] * vX_[259] + vX_[3] * vX_[25] + vX_[9] * vX_[21] + vX_[124] * vX_[20]) * vX_[11] +
              vX_[65] * vX_[124] + (vX_[31] + vX_[9] * vX_[79] + vX_[124] * vX_[66]) * vX_[9];
    vX_[21] = vX_[22] * vX_[21] + vX_[93] * vX_[20] + vX_[11] * vX_[79] + vX_[3] * vX_[66];
    vX_[31] = vX_[22] * vX_[259] + vX_[93] * vX_[25] + vX_[31];
    vX_[25] = vX_[53] * vX_[124] + vX_[21] * vX_[9] + vX_[52] * vX_[3] + vX_[31] * vX_[11];
    vX_[31] = vX_[52] * vX_[93] + vX_[31] * vX_[22] + vX_[53] * vX_[3] + vX_[21] * vX_[11];
    vX_[21] = (vX_[25] - vX_[19] * vX_[31]) / vX_[24];
    vX_[52] = vX_[65] - (vX_[42] * vX_[21] + vX_[25] * vX_[19]);
    vX_[21] = --0.022851627 * vX_[21];
    vX_[53] = 0 - (vX_[11] * vX_[369] + vX_[3] * vX_[336]) - (vX_[22] * vX_[89] + vX_[93] * vX_[335]) -
              (vX_[34] * vX_[262] + vX_[157] * vX_[331]) - (vX_[15] * vX_[388] + vX_[120] * vX_[328]);
    vX_[65] = vX_[79] + vX_[259] - vX_[65] - vX_[31] - -0.022851627 * ((-vX_[278]) * vX_[31]) / vX_[24];
    vX_[79] = 0 - vX_[375] * vX_[273];
    vX_[375] = vX_[375] * vX_[269];
    vX_[269] = vX_[11] * vX_[375] + vX_[3] * vX_[241];
    vX_[259] = vX_[93] * vX_[85] + vX_[3] * vX_[275];
    vX_[66] = vX_[3] * vX_[85];
    vX_[20] = vX_[93] * vX_[340] + vX_[66];
    vX_[260] = vX_[22] * vX_[190] + vX_[93] * vX_[346] + vX_[11] * vX_[187] + vX_[3] * vX_[347];
    vX_[17] = 0 - vX_[190];
    vX_[99] = vX_[22] * vX_[261] + vX_[93] * vX_[343] + vX_[11] * vX_[17] + vX_[3] * vX_[344];
    vX_[90] = vX_[348] * vX_[93] + vX_[260] * vX_[22] + vX_[345] * vX_[3] + vX_[99] * vX_[11];
    vX_[40] = (vX_[90] - vX_[351] * vX_[31]) / vX_[24];
    vX_[99] = vX_[345] * vX_[124] + vX_[99] * vX_[9] + vX_[348] * vX_[3] + vX_[260] * vX_[11];
    vX_[260] = vX_[339] * vX_[124] + vX_[259] * vX_[9] + vX_[342] * vX_[3] + vX_[20] * vX_[11] -
               (vX_[349] * vX_[40] + vX_[99] * vX_[351]);
    vX_[348] = -vX_[79];
    vX_[345] = vX_[22] * vX_[348] + vX_[93] * vX_[353] + vX_[269];
    vX_[101] = (vX_[99] - vX_[355] * vX_[31]) / vX_[24];
    vX_[17] = vX_[11] * vX_[261] + vX_[3] * vX_[343] + vX_[9] * vX_[17] + vX_[124] * vX_[344];
    vX_[187] = vX_[11] * vX_[190] + vX_[3] * vX_[346] + vX_[9] * vX_[187] + vX_[124] * vX_[347];
    vX_[190] = vX_[358] * vX_[260];
    vX_[348] = vX_[11] * vX_[348] + vX_[3] * vX_[353] + vX_[9] * vX_[375] + vX_[124] * vX_[241];
    vX_[353] = 0 - vX_[348];
    vX_[347] = 0 - vX_[124] * vX_[273] - vX_[3] * vX_[360] - (vX_[362] * vX_[40] + vX_[353] * vX_[351]);
    vX_[346] = vX_[282] * vX_[347];
    vX_[261] = vX_[346] - vX_[190];
    vX_[344] = (vX_[353] - vX_[372] * vX_[31]) / vX_[24];
    vX_[348] = vX_[332] * vX_[3] + vX_[79] * vX_[11] + vX_[241] * vX_[93] + vX_[375] * vX_[22] + vX_[348] -
               -0.022851627 * vX_[40];
    vX_[20] = vX_[342] * vX_[93] + vX_[20] * vX_[22] + vX_[339] * vX_[3] + vX_[259] * vX_[11];
    vX_[90] = vX_[20] - (vX_[350] * vX_[40] + vX_[90] * vX_[351]);
    vX_[259] = -vX_[282] * vX_[90];
    vX_[40] = vX_[356] * vX_[3] + vX_[17] * vX_[11] + vX_[357] * vX_[93] + vX_[187] * vX_[22] -
              (vX_[42] * vX_[40] + vX_[25] * vX_[351]);
    vX_[342] = vX_[21] + vX_[348] * vX_[358] + vX_[259] * vX_[358] - vX_[40] * vX_[282];
    vX_[66] = vX_[381] * vX_[3] + (vX_[3] * vX_[340] + vX_[124] * vX_[85]) * vX_[11] + vX_[341] * vX_[124] +
              (vX_[66] + vX_[124] * vX_[275]) * vX_[9];
    vX_[360] = vX_[3] * vX_[273] + vX_[93] * vX_[360] - (vX_[362] * vX_[101] + vX_[353] * vX_[355]);
    vX_[360] =
        (vX_[282] * (0 - vX_[66] - vX_[20] - (vX_[362] * vX_[344] + vX_[353] * vX_[372])) - vX_[358] * vX_[360]) *
            vX_[282] -
        (vX_[282] * vX_[360] - vX_[358] * (vX_[66] - (vX_[349] * vX_[101] + vX_[99] * vX_[355]))) * vX_[358];
    jac[30] =
        (0 -
            vX_[0] *
                (vX_[9] * vX_[369] + vX_[124] * vX_[336] + vX_[11] * vX_[89] + vX_[3] * vX_[335] + vX_[30] * vX_[262] +
                    vX_[1] * vX_[331] + vX_[12] * vX_[388] + vX_[133] * vX_[328] + vX_[52] * vX_[274] +
                    vX_[21] * vX_[268] + (vX_[42] * vX_[53] + vX_[25] * vX_[271] - vX_[309] * vX_[31]) / vX_[24]) -
            vX_[4] * ((vX_[223] * vX_[382]) / vX_[223] + vX_[8] + vX_[21] * vX_[274] + vX_[65] * vX_[268] +
                         (-0.022851627 * vX_[53] - vX_[277] * vX_[31]) / vX_[24]) -
            9.81 * ((vX_[4] * (vX_[332] * vX_[124] + vX_[79] * vX_[9] + vX_[269] - vX_[282] * vX_[260] - vX_[345] -
                                  -0.022851627 * vX_[101]) +
                        vX_[0] * (vX_[356] * vX_[124] + vX_[17] * vX_[9] + vX_[357] * vX_[3] + vX_[187] * vX_[11] +
                                     vX_[190] - (vX_[42] * vX_[101] + vX_[25] * vX_[355]) - vX_[261])) *
                           vX_[0] +
                       (vX_[4] * (0 - vX_[346] - -0.022851627 * vX_[344] - vX_[261]) +
                           vX_[0] * (vX_[345] + vX_[358] * vX_[347] - (vX_[42] * vX_[344] + vX_[25] * vX_[372]))) *
                           vX_[4] +
                       vX_[261]) -
            vX_[365] * ((vX_[4] * vX_[342] +
                            vX_[0] * (2. * vX_[40] * vX_[358] + vX_[52] + vX_[358] * vX_[90] * vX_[358] - vX_[360])) *
                               vX_[0] +
                           (vX_[4] * (vX_[65] - 2. * vX_[348] * vX_[282] - vX_[259] * vX_[282] - vX_[360]) +
                               vX_[0] * vX_[342]) *
                               vX_[4] +
                           vX_[360])) /
        vX_[385];
    vX_[360] = vX_[0] * jac[30];
    vX_[342] = vX_[0] * vX_[365] + vX_[274];
    vX_[40] = vX_[4] * jac[30];
    vX_[259] = 9.81 * vX_[0];
    vX_[90] = 9.81 * vX_[4];
    vX_[348] = vX_[4] * vX_[365] + vX_[268];
    vX_[344] =
        (vX_[271] - vX_[42] * vX_[342] - -0.022851627 * vX_[348] - vX_[349] * vX_[259] - vX_[362] * vX_[90]) / vX_[24];
    jac[31] = (vX_[53] - (vX_[42] * vX_[360] + vX_[25] * vX_[342]) - -0.022851627 * vX_[40] - vX_[99] * vX_[259] -
                  vX_[353] * vX_[90] - vX_[344] * vX_[31]) /
              vX_[24];
    vX_[367] = vX_[11] * jac[31] + vX_[3] * vX_[344] + vX_[9] * vX_[360] + vX_[124] * vX_[342] + vX_[367];
    vX_[245] = vX_[22] * jac[31] + vX_[93] * vX_[344] + vX_[11] * vX_[360] + vX_[3] * vX_[342] + vX_[245];
    vX_[192] = vX_[15] * jac[31] + vX_[120] * vX_[344] + vX_[12] * vX_[360] + vX_[133] * vX_[342] +
               vX_[124] * vX_[259] + vX_[192];
    vX_[360] =
        vX_[34] * jac[31] + vX_[157] * vX_[344] + vX_[30] * vX_[360] + vX_[1] * vX_[342] + vX_[3] * vX_[259] + vX_[236];
    jac[32] = (vX_[382] - vX_[223] * vX_[40] - vX_[221] * vX_[367] - vX_[234] * vX_[245] - vX_[254] * vX_[192] -
                  vX_[242] * vX_[360]) /
              vX_[223];
    vX_[382] = -1 * vX_[245];
    vX_[40] = vX_[40] + jac[32];
    vX_[359] = vX_[28] * vX_[40] + vX_[26] * vX_[367] + vX_[359];
    vX_[40] = vX_[26] * vX_[40] + vX_[27] * vX_[367] + vX_[389];
    vX_[360] = -0.304 * vX_[367] + -1 * vX_[360];
    vX_[368] = vX_[26] * vX_[192] + vX_[38] * vX_[245] + vX_[368];
    vX_[192] = vX_[27] * vX_[192] + vX_[51] * vX_[245] + vX_[390];
    jac[33] = (vX_[380] - vX_[154] * vX_[382] - vX_[152] * vX_[359] - -0.00021200017 * vX_[40] - vX_[169] * vX_[360] -
                  vX_[184] * vX_[368] - vX_[172] * vX_[192]) /
              vX_[154];
    vX_[382] = vX_[382] + jac[33];
    vX_[373] = vX_[49] * vX_[382] + vX_[48] * vX_[359] + vX_[373];
    vX_[270] = vX_[63] * vX_[382] + vX_[49] * vX_[359] + vX_[270];
    vX_[7] = vX_[76] * vX_[382] + vX_[77] * vX_[359] + vX_[49] * vX_[368] + vX_[78] * vX_[360] + vX_[7];
    jac[34] =
        (vX_[370] - vX_[117] * vX_[40] - vX_[108] * vX_[373] - vX_[122] * vX_[270] - vX_[160] * vX_[192] -
            vX_[134] * (vX_[56] * vX_[382] + vX_[57] * vX_[359] + vX_[48] * vX_[368] + vX_[49] * vX_[360] + vX_[267]) -
            vX_[130] * vX_[7]) /
        vX_[117];
    vX_[40] = vX_[40] + jac[34];
    jac[35] = (vX_[366] - 0.009277 * vX_[373] - -0.000829 * (vX_[70] * vX_[40] + vX_[68] * vX_[270] + vX_[276]) -
                  1.5e-05 * (vX_[68] * vX_[40] + vX_[67] * vX_[270] + vX_[352]) -
                  0.038686875 * (vX_[68] * vX_[7] + vX_[94] * vX_[373] + vX_[95] * vX_[192] + vX_[317])) /
              0.009277;
    vX_[40] = -1 * sin(x_in[3]);
    vX_[7] = cos(x_in[3]);
    vX_[270] = -vX_[7];
    vX_[373] = vX_[40] * vX_[18] + vX_[270] * vX_[10];
    vX_[192] = -0.304 * vX_[40];
    vX_[317] = vX_[192] * vX_[23] + vX_[40] * vX_[16];
    vX_[352] = vX_[373] * vX_[36] - vX_[37] * vX_[317];
    vX_[276] = vX_[373] * vX_[37];
    vX_[366] = vX_[7] * vX_[18] + vX_[40] * vX_[10];
    vX_[382] = vX_[45] * vX_[366] + vX_[366] * vX_[45];
    vX_[368] = -0.304 * vX_[7];
    vX_[360] = vX_[368] * vX_[23] + vX_[7] * vX_[16];
    vX_[359] = vX_[48] * vX_[373];
    vX_[370] = vX_[57] * vX_[373] + vX_[48] * vX_[317];
    vX_[267] = vX_[50] * vX_[360] + vX_[359] * vX_[54] - (vX_[55] * vX_[370] + vX_[366] * vX_[59]);
    vX_[380] = vX_[50] * vX_[366] + vX_[359] * vX_[55];
    vX_[245] = vX_[55] * vX_[366] + vX_[366] * vX_[55];
    vX_[390] = vX_[49] * vX_[373];
    vX_[367] = vX_[64] * vX_[390] + vX_[390] * vX_[64];
    vX_[389] = vX_[68] * vX_[390] + vX_[70] * vX_[366];
    vX_[236] = vX_[67] * vX_[390] + vX_[68] * vX_[366];
    vX_[157] = vX_[69] * vX_[389] + vX_[236] * vX_[73];
    vX_[1] = vX_[77] * vX_[373] + vX_[49] * vX_[317];
    vX_[3] = vX_[67] * vX_[1] + vX_[80] * vX_[359] + vX_[68] * vX_[360];
    vX_[120] = vX_[75] * vX_[3] + vX_[359] * vX_[83];
    vX_[124] = 0.02075 * vX_[366] + -0.184 * vX_[390] + vX_[370];
    vX_[133] = vX_[69] * vX_[124] + vX_[236] * vX_[86];
    vX_[93] = vX_[69] * vX_[359] + vX_[236] * vX_[75];
    vX_[353] = vX_[73] * vX_[359] + vX_[389] * vX_[75];
    vX_[99] = vX_[73] * vX_[389] + vX_[389] * vX_[73];
    vX_[53] = vX_[69] * vX_[236] + vX_[236] * vX_[69];
    vX_[31] = -0.00751 * vX_[157] + 0.038686875 * (vX_[120] - vX_[133]) + -0.000829 * vX_[93] - 1.5e-05 * vX_[353] -
              0.000198 * (vX_[99] - vX_[53]);
    vX_[25] = 0 - vX_[31];
    vX_[261] = vX_[68] * vX_[1] + vX_[94] * vX_[359] + vX_[95] * vX_[360];
    vX_[346] = vX_[75] * vX_[359] + vX_[359] * vX_[75];
    vX_[124] = 1.547475 * (vX_[73] * vX_[124] + vX_[389] * vX_[86] - (vX_[75] * vX_[261] + vX_[359] * vX_[97])) +
               1.547475 * vX_[261] * x_in[11] - 0.038686875 * (vX_[346] + vX_[99]);
    vX_[347] = (-vX_[236]) * x_in[11];
    vX_[190] = vX_[389] * x_in[11];
    vX_[187] = (-vX_[3]) * x_in[11];
    vX_[133] = 0.038686875 * vX_[157] + -1.547475 * (vX_[133] - vX_[120]) + 0.00345708950900075 * vX_[347] +
               -6.25528861700981e-05 * vX_[190] + 1.38614328745655 * vX_[187] + (0.038686875 * vX_[25]) / 0.009277;
    vX_[120] = (-vX_[390]) * x_in[10];
    vX_[17] = vX_[359] * x_in[10];
    vX_[101] = vX_[370] * x_in[10];
    vX_[345] = (-vX_[1]) * x_in[10];
    vX_[260] = vX_[64] * vX_[366] + vX_[390] * vX_[55];
    vX_[269] = vX_[64] * vX_[359] + vX_[390] * vX_[50];
    vX_[261] = vX_[69] * vX_[261] + vX_[236] * vX_[97] - (vX_[73] * vX_[3] + vX_[389] * vX_[83]);
    vX_[53] = 0.000198 * vX_[353] + 1.5e-05 * (vX_[346] - vX_[53]) + 0.00315291990945349 * vX_[347] +
              0.000199340411771047 * vX_[190] + 0.00345708950900075 * vX_[187] + (-0.000829 * vX_[25]) / 0.009277 -
              0.038686875 * vX_[261] - -0.00146 * vX_[93] - -0.000829 * vX_[157];
    vX_[346] = 0.00605 * vX_[353] + 1.5e-05 * vX_[157] + 0.000199340411771047 * vX_[347] +
               0.0107369757464698 * vX_[190] + -6.25528861700981e-05 * vX_[187] + (1.5e-05 * vX_[25]) / 0.009277 -
               0.000198 * vX_[93] - -0.000829 * (vX_[346] - vX_[99]);
    vX_[261] = 0.038686875 * vX_[93] + 1.547475 * vX_[261] + -0.038686875 * vX_[347];
    vX_[93] = vX_[50] * vX_[359] + vX_[359] * vX_[50];
    vX_[99] = -0.001243 * vX_[260] + 0.009683 * vX_[269] + vX_[70] * vX_[53] + vX_[68] * vX_[346] + 0.02075 * vX_[261] -
              -0.012652 * vX_[380] - -0.001387 * (vX_[93] - vX_[367]);
    vX_[353] = 0 - vX_[99];
    vX_[31] = 0.057838 * vX_[267] + -0.001387 * vX_[380] + -0.012652 * (vX_[245] - vX_[367]) +
              (0.009277 * vX_[25]) / 0.009277 + vX_[31] + vX_[80] * vX_[124] + vX_[94] * vX_[133] +
              vX_[119] * vX_[120] + vX_[123] * vX_[17] + vX_[132] * vX_[101] + vX_[136] * vX_[345] +
              (vX_[108] * vX_[353]) / vX_[117] - -0.008386 * vX_[260] - -0.001243 * vX_[269];
    vX_[157] = vX_[64] * vX_[360] + vX_[390] * vX_[54] - (vX_[55] * vX_[1] + vX_[366] * vX_[82]);
    vX_[346] = -0.018069 * vX_[380] + 0.057838 * vX_[157] + -0.012652 * vX_[269] + vX_[68] * vX_[53] +
               vX_[67] * vX_[346] + -0.184 * vX_[261] + vX_[123] * vX_[120] + vX_[116] * vX_[17] + vX_[72] * vX_[101] +
               vX_[128] * vX_[345] + (vX_[122] * vX_[353]) / vX_[117] - -0.001387 * vX_[260] -
               -0.001243 * (vX_[245] - vX_[93]);
    vX_[260] = 0.057838 * vX_[260] + 2.1032 * vX_[267] + vX_[68] * vX_[133] + vX_[67] * vX_[124] + vX_[132] * vX_[120] +
               vX_[72] * vX_[17] + vX_[62] * vX_[101] + vX_[71] * vX_[345] + (vX_[130] * vX_[353]) / vX_[117];
    vX_[157] = 0.057838 * vX_[380] + -2.1032 * vX_[157] + vX_[261] + vX_[136] * vX_[120] + vX_[128] * vX_[17] +
               vX_[71] * vX_[101] + vX_[60] * vX_[345] + (vX_[134] * vX_[353]) / vX_[117];
    vX_[261] = (-vX_[366]) * x_in[9];
    vX_[380] = vX_[373] * x_in[9];
    vX_[267] = vX_[317] * x_in[9];
    vX_[53] = (-vX_[360]) * x_in[9];
    vX_[269] = vX_[37] * vX_[360];
    vX_[245] = vX_[366] * vX_[36];
    vX_[3] = vX_[45] * vX_[373] + vX_[366] * vX_[29];
    vX_[236] = vX_[366] * vX_[37];
    vX_[389] = vX_[29] * vX_[373] + vX_[373] * vX_[29];
    vX_[79] = 0.160298259823722 * (vX_[269] - vX_[245]) + -0.06337651 * vX_[3] + -0.0022920002 * vX_[236] +
              vX_[49] * vX_[31] + vX_[63] * vX_[346] + vX_[76] * vX_[260] + vX_[56] * vX_[157] -
              -0.008711861 * vX_[352] - -0.00021200017 * vX_[276] - 0.0036857284 * (vX_[389] - vX_[382]);
    vX_[65] = 0 - vX_[79];
    vX_[360] = vX_[45] * vX_[317] + vX_[366] * vX_[41] - (vX_[29] * vX_[360] + vX_[373] * vX_[54]);
    vX_[346] = 1.52322944854339e-09 * vX_[352] + 0.0036857284 * vX_[276] + -0.00021200017 * (0 - vX_[382]) +
               vX_[48] * vX_[31] + vX_[49] * vX_[346] + vX_[77] * vX_[260] + vX_[57] * vX_[157] + vX_[156] * vX_[261] +
               vX_[158] * vX_[380] + vX_[174] * vX_[267] + vX_[186] * vX_[53] + (vX_[152] * vX_[65]) / vX_[154] -
               0.160298259823722 * vX_[360] - 0.01404749 * vX_[236] - -0.0022920002 * vX_[3];
    vX_[99] = -0.008711861 * vX_[360] + 1.52322944854339e-09 * (vX_[245] - vX_[269]) + 0.077424 * vX_[276] +
              -0.00021200017 * vX_[3] + (vX_[117] * vX_[353]) / vX_[117] + vX_[99] + vX_[158] * vX_[261] +
              vX_[153] * vX_[380] + vX_[150] * vX_[267] + vX_[170] * vX_[53] + (-0.00021200017 * vX_[65]) / vX_[154] -
              0.0036857284 * vX_[236] - -0.0022920002 * (0 - vX_[389]);
    vX_[360] = 1.7423722 * vX_[360] + 0.160298259823722 * vX_[236] + -0.008711861 * vX_[276] + vX_[49] * vX_[157] +
               vX_[78] * vX_[260] + vX_[39] * vX_[261] + vX_[171] * vX_[380] + vX_[193] * vX_[267] +
               vX_[199] * vX_[53] + (vX_[169] * vX_[65]) / vX_[154] - 1.52322944854339e-09 * (vX_[389] + vX_[382]);
    vX_[31] = -1 * vX_[368];
    vX_[366] = -0.304 * vX_[40];
    vX_[317] = vX_[31] * vX_[204] - vX_[366] * vX_[206];
    vX_[373] = vX_[31] * vX_[206] - vX_[366] * vX_[202];
    vX_[208] = vX_[207] * vX_[31] + vX_[317] * vX_[200] - (vX_[208] * vX_[366] + vX_[373] * vX_[205]);
    vX_[207] = -vX_[31] * vX_[203];
    vX_[210] = 0 - vX_[210] * vX_[31] - (vX_[139] * vX_[31] + vX_[207] * vX_[200]) - vX_[208];
    vX_[139] = vX_[171] * vX_[366] + vX_[139] * vX_[366] + vX_[207] * vX_[205] - vX_[39] * vX_[31];
    vX_[21] = vX_[26] * vX_[139] + vX_[40] * vX_[212];
    vX_[203] = vX_[366] * vX_[203];
    vX_[216] = vX_[215] * vX_[366] + vX_[216] * vX_[366] + vX_[203] * vX_[205] - vX_[208];
    vX_[218] = vX_[214] * vX_[7] + (vX_[27] * vX_[210] + vX_[7] * vX_[211] + vX_[21]) * vX_[27] + vX_[218] * vX_[40] +
               (vX_[27] * vX_[139] + vX_[7] * vX_[212] + vX_[26] * vX_[216] + vX_[40] * vX_[217]) * vX_[26];
    vX_[21] = vX_[21] + vX_[28] * vX_[216] + vX_[270] * vX_[217];
    vX_[139] = vX_[26] * vX_[210] + vX_[40] * vX_[211] + vX_[28] * vX_[139] + vX_[270] * vX_[212];
    vX_[212] = vX_[213] * vX_[40] + vX_[21] * vX_[26] + vX_[220] * vX_[7] + vX_[139] * vX_[27];
    vX_[139] = vX_[220] * vX_[40] + vX_[139] * vX_[26] + vX_[213] * vX_[270] + vX_[21] * vX_[28];
    vX_[21] = vX_[208] + vX_[139];
    vX_[220] = (vX_[212] - vX_[224] * vX_[21]) / vX_[223];
    vX_[213] = vX_[208] + vX_[218] - (vX_[221] * vX_[220] + vX_[212] * vX_[224]);
    vX_[211] = vX_[31] * vX_[193];
    vX_[217] = -vX_[211];
    vX_[214] = -vX_[31] * vX_[199];
    vX_[229] = vX_[150] * vX_[31] + vX_[228] * vX_[31] + vX_[217] * vX_[200] - vX_[170] * vX_[366] -
               (vX_[229] * vX_[366] + vX_[214] * vX_[205]);
    vX_[228] = vX_[366] * vX_[199];
    vX_[215] = vX_[366] * vX_[193];
    vX_[366] = vX_[186] * vX_[366] + vX_[231] * vX_[366] + vX_[228] * vX_[205] - vX_[174] * vX_[31] -
               (vX_[232] * vX_[31] + vX_[215] * vX_[200]);
    vX_[31] = 0 - (vX_[26] * vX_[229] + vX_[40] * vX_[230]) - (vX_[27] * vX_[366] + vX_[7] * vX_[233]);
    vX_[366] = vX_[28] * vX_[229] + vX_[270] * vX_[230] + vX_[26] * vX_[366] + vX_[40] * vX_[233] -
               (vX_[234] * vX_[220] + vX_[31] * vX_[224]);
    vX_[229] = -vX_[203];
    vX_[220] = vX_[26] * vX_[229] + vX_[40] * vX_[238] + vX_[28] * vX_[207] + vX_[270] * vX_[239];
    vX_[229] = vX_[27] * vX_[229] + vX_[7] * vX_[238] + vX_[26] * vX_[207] + vX_[40] * vX_[239];
    vX_[239] = 0 - vX_[229];
    vX_[238] = (vX_[239] - vX_[243] * vX_[21]) / vX_[223];
    vX_[233] = vX_[220] - (vX_[221] * vX_[238] + vX_[212] * vX_[243]);
    vX_[211] = vX_[211] - vX_[228];
    vX_[228] = vX_[228] - vX_[211];
    vX_[230] = vX_[27] * vX_[214] + vX_[7] * vX_[246] + vX_[26] * vX_[228] + vX_[40] * vX_[247];
    vX_[217] = vX_[217] - vX_[211];
    vX_[232] = vX_[27] * vX_[217] + vX_[7] * vX_[249] + vX_[26] * vX_[215] + vX_[40] * vX_[250];
    vX_[228] = vX_[26] * vX_[214] + vX_[40] * vX_[246] + vX_[28] * vX_[228] + vX_[270] * vX_[247];
    vX_[217] = vX_[26] * vX_[217] + vX_[40] * vX_[249] + vX_[28] * vX_[215] + vX_[270] * vX_[250];
    vX_[215] = vX_[252] * vX_[40] + vX_[228] * vX_[26] + vX_[253] * vX_[7] + vX_[217] * vX_[27];
    vX_[250] = (vX_[215] - vX_[255] * vX_[21]) / vX_[223];
    vX_[249] = vX_[248] * vX_[40] + vX_[230] * vX_[26] + vX_[251] * vX_[7] + vX_[232] * vX_[27] + vX_[211] -
               (vX_[221] * vX_[250] + vX_[212] * vX_[255]);
    vX_[214] = vX_[28] * vX_[346] + vX_[270] * vX_[318] + vX_[26] * vX_[99] + vX_[40] * vX_[286];
    vX_[247] = 0 - vX_[214];
    vX_[99] = vX_[26] * vX_[346] + vX_[40] * vX_[318] + vX_[27] * vX_[99] + vX_[7] * vX_[286] + -0.304 * vX_[360] +
              vX_[213] * vX_[323] + vX_[366] * vX_[324] + vX_[233] * vX_[325] + vX_[249] * vX_[327] +
              (vX_[221] * vX_[247] + vX_[212] * vX_[333] - vX_[334] * vX_[21]) / vX_[223];
    vX_[389] = 1.7423722 * vX_[352] + 1.52322944854339e-09 * vX_[236] + -0.008711861 * vX_[3] +
               2.1032 * (vX_[64] * vX_[370] + vX_[390] * vX_[59] - (vX_[50] * vX_[1] + vX_[359] * vX_[82])) +
               vX_[95] * vX_[133] + vX_[68] * vX_[124] + vX_[162] * vX_[120] + vX_[167] * vX_[17] +
               vX_[163] * vX_[101] + vX_[166] * vX_[345] + (vX_[160] * vX_[353]) / vX_[117] + vX_[174] * vX_[261] +
               vX_[150] * vX_[380] + vX_[204] * vX_[267] + vX_[206] * vX_[53] + (vX_[172] * vX_[65]) / vX_[154] -
               0.160298259823722 * vX_[389] - 0.057838 * (vX_[93] + vX_[367]);
    vX_[3] = -1.7423722 * (vX_[245] - vX_[269]) + 0.160298259823722 * vX_[3] + 1.52322944854339e-09 * vX_[276] +
             vX_[48] * vX_[157] + vX_[49] * vX_[260] + vX_[186] * vX_[261] + vX_[170] * vX_[380] + vX_[206] * vX_[267] +
             vX_[202] * vX_[53] + (vX_[184] * vX_[65]) / vX_[154] - -0.008711861 * vX_[382];
    vX_[139] = vX_[216] + vX_[210] + vX_[208] - vX_[218] - vX_[139] -
               (vX_[234] * (vX_[31] - vX_[32] * vX_[21]) / vX_[223] + vX_[31] * vX_[32]);
    vX_[218] = vX_[211] - (vX_[234] * vX_[238] + vX_[31] * vX_[243]);
    vX_[203] = -1 * (vX_[373] + vX_[203]);
    vX_[207] = -1 * (vX_[317] + vX_[207]);
    vX_[220] = vX_[237] * vX_[40] + vX_[203] * vX_[26] + vX_[209] * vX_[7] + vX_[207] * vX_[27] - vX_[220] -
               (vX_[234] * vX_[250] + vX_[31] * vX_[255]);
    vX_[79] = vX_[51] * vX_[389] + vX_[368] * vX_[313] + -1 * (vX_[79] + (vX_[154] * vX_[65]) / vX_[154]) +
              vX_[38] * vX_[3] + vX_[192] * vX_[311] + vX_[366] * vX_[323] + vX_[139] * vX_[324] + vX_[218] * vX_[325] +
              vX_[220] * vX_[327] + (vX_[234] * vX_[247] + vX_[31] * vX_[333] - vX_[310] * vX_[21]) / vX_[223];
    vX_[317] = vX_[40] * vX_[206];
    vX_[47] = vX_[138] * vX_[7] + (vX_[7] * vX_[188] + vX_[317]) * vX_[27] + vX_[47] * vX_[40] +
              (vX_[7] * vX_[206] + vX_[40] * vX_[191]) * vX_[26];
    vX_[188] = vX_[40] * vX_[188] + vX_[270] * vX_[206];
    vX_[317] = vX_[317] + vX_[270] * vX_[191];
    vX_[191] = vX_[43] * vX_[40] + vX_[188] * vX_[26] + vX_[74] * vX_[270] + vX_[317] * vX_[28];
    vX_[238] = 0 - vX_[47] - vX_[191] - (vX_[242] * vX_[238] + vX_[239] * vX_[243]);
    vX_[138] = vX_[270] * vX_[193] + vX_[40] * vX_[87] - (vX_[242] * vX_[250] + vX_[239] * vX_[255]);
    vX_[360] = -1 * vX_[360] + vX_[233] * vX_[323] + vX_[218] * vX_[324] + vX_[238] * vX_[325] + vX_[138] * vX_[327] +
               (vX_[242] * vX_[247] + vX_[239] * vX_[333] - vX_[314] * vX_[21]) / vX_[223];
    vX_[47] = vX_[47] - (vX_[254] * vX_[250] + vX_[215] * vX_[255]);
    vX_[3] = vX_[26] * vX_[3] + vX_[40] * vX_[311] + vX_[27] * vX_[389] + vX_[7] * vX_[313] + vX_[249] * vX_[323] +
             vX_[220] * vX_[324] + vX_[138] * vX_[325] + vX_[47] * vX_[327] +
             (vX_[254] * vX_[247] + vX_[215] * vX_[333] - vX_[330] * vX_[21]) / vX_[223];
    vX_[389] = vX_[258] * vX_[47];
    vX_[139] = 2. * vX_[220] * vX_[258] + vX_[139] + vX_[389] * vX_[258];
    vX_[311] = vX_[258] * vX_[138];
    vX_[366] = vX_[249] * vX_[258] + vX_[366] - vX_[218] * vX_[258] - vX_[311] * vX_[258];
    vX_[313] = vX_[11] * vX_[366];
    vX_[250] = -vX_[258] * vX_[238];
    vX_[213] = vX_[213] - 2. * vX_[233] * vX_[258] - vX_[250] * vX_[258];
    vX_[373] = (vX_[11] * vX_[139] + vX_[9] * vX_[366]) * vX_[11] + (vX_[313] + vX_[9] * vX_[213]) * vX_[9];
    vX_[366] = vX_[22] * vX_[366] + vX_[11] * vX_[213];
    vX_[313] = vX_[22] * vX_[139] + vX_[313];
    vX_[216] = vX_[366] * vX_[9] + vX_[313] * vX_[11];
    vX_[313] = vX_[313] * vX_[22] + vX_[366] * vX_[11];
    vX_[366] = (vX_[216] - vX_[19] * vX_[313]) / vX_[24];
    vX_[210] = vX_[373] - (vX_[42] * vX_[366] + vX_[216] * vX_[19]);
    vX_[366] = --0.022851627 * vX_[366];
    vX_[208] = 0 - vX_[11] * vX_[99] - vX_[22] * vX_[79] - vX_[34] * vX_[360] - vX_[15] * vX_[3];
    vX_[373] = vX_[213] + vX_[139] - vX_[373] - vX_[313] - -0.022851627 * ((-vX_[278]) * vX_[313]) / vX_[24];
    vX_[217] = vX_[252] * vX_[270] + vX_[228] * vX_[28] + vX_[253] * vX_[40] + vX_[217] * vX_[26] + vX_[211];
    vX_[228] = (vX_[217] - vX_[272] * vX_[21]) / vX_[223];
    vX_[87] = 0 - vX_[40] * vX_[193] - vX_[7] * vX_[87] - (vX_[242] * vX_[228] + vX_[239] * vX_[272]);
    vX_[232] = vX_[248] * vX_[270] + vX_[230] * vX_[28] + vX_[251] * vX_[40] + vX_[232] * vX_[26] - vX_[258] * vX_[87] -
               (vX_[221] * vX_[228] + vX_[212] * vX_[272]);
    vX_[317] = vX_[74] * vX_[40] + vX_[317] * vX_[26] + vX_[43] * vX_[7] + vX_[188] * vX_[27] -
               (vX_[254] * vX_[228] + vX_[215] * vX_[272]);
    vX_[207] = vX_[237] * vX_[270] + vX_[203] * vX_[28] + vX_[209] * vX_[40] + vX_[207] * vX_[26] + vX_[229] +
               vX_[258] * vX_[317] - (vX_[234] * vX_[228] + vX_[31] * vX_[272]);
    vX_[203] = vX_[11] * vX_[207];
    vX_[228] = vX_[191] - (vX_[227] * vX_[228] + vX_[217] * vX_[272]);
    vX_[47] = vX_[47] - vX_[228];
    vX_[191] = vX_[22] * vX_[138] + vX_[11] * vX_[47];
    vX_[238] = vX_[238] - vX_[228];
    vX_[229] = vX_[11] * vX_[138];
    vX_[209] = vX_[22] * vX_[238] + vX_[229];
    vX_[218] = vX_[311] + vX_[218];
    vX_[250] = vX_[250] + vX_[233];
    vX_[233] = vX_[22] * vX_[218] + vX_[11] * vX_[250];
    vX_[389] = vX_[389] + vX_[220];
    vX_[311] = vX_[249] - vX_[311];
    vX_[249] = vX_[22] * vX_[389] + vX_[11] * vX_[311];
    vX_[220] = vX_[233] * vX_[22] + vX_[249] * vX_[11];
    vX_[237] = (vX_[220] - vX_[351] * vX_[313]) / vX_[24];
    vX_[249] = vX_[249] * vX_[9] + vX_[233] * vX_[11];
    vX_[233] = vX_[191] * vX_[9] + vX_[209] * vX_[11] - (vX_[349] * vX_[237] + vX_[249] * vX_[351]);
    vX_[188] = -vX_[232];
    vX_[74] = vX_[22] * vX_[188] + vX_[203];
    vX_[43] = (vX_[249] - vX_[355] * vX_[313]) / vX_[24];
    vX_[311] = vX_[11] * vX_[389] + vX_[9] * vX_[311];
    vX_[250] = vX_[11] * vX_[218] + vX_[9] * vX_[250];
    vX_[218] = vX_[358] * vX_[233];
    vX_[317] = -vX_[317];
    vX_[188] = vX_[11] * vX_[188] + vX_[9] * vX_[207];
    vX_[389] = 0 - vX_[188];
    vX_[230] = 0 - vX_[9] * vX_[87] - vX_[11] * vX_[317] - (vX_[362] * vX_[237] + vX_[389] * vX_[351]);
    vX_[251] = vX_[282] * vX_[230];
    vX_[248] = vX_[251] - vX_[218];
    vX_[211] = (vX_[389] - vX_[372] * vX_[313]) / vX_[24];
    vX_[188] = vX_[232] * vX_[11] + vX_[207] * vX_[22] + vX_[188] - -0.022851627 * vX_[237];
    vX_[209] = vX_[209] * vX_[22] + vX_[191] * vX_[11];
    vX_[220] = vX_[228] + vX_[209] - (vX_[350] * vX_[237] + vX_[220] * vX_[351]);
    vX_[191] = -vX_[282] * vX_[220];
    vX_[237] = vX_[311] * vX_[11] + vX_[250] * vX_[22] - (vX_[42] * vX_[237] + vX_[216] * vX_[351]);
    vX_[207] = vX_[366] + vX_[188] * vX_[358] + vX_[191] * vX_[358] - vX_[237] * vX_[282];
    vX_[229] = (vX_[11] * vX_[238] + vX_[9] * vX_[138]) * vX_[11] + (vX_[229] + vX_[9] * vX_[47]) * vX_[9];
    vX_[317] = vX_[11] * vX_[87] + vX_[22] * vX_[317] - (vX_[362] * vX_[43] + vX_[389] * vX_[355]);
    vX_[317] = (vX_[282] * (vX_[47] + vX_[238] + vX_[228] - vX_[229] - vX_[209] -
                               (vX_[362] * vX_[211] + vX_[389] * vX_[372])) -
                   vX_[358] * vX_[317]) *
                   vX_[282] -
               (vX_[282] * vX_[317] - vX_[358] * (vX_[228] + vX_[229] - (vX_[349] * vX_[43] + vX_[249] * vX_[355]))) *
                   vX_[358];
    jac[42] =
        (0 -
            vX_[0] *
                (vX_[9] * vX_[99] + vX_[11] * vX_[79] + vX_[30] * vX_[360] + vX_[12] * vX_[3] + vX_[210] * vX_[274] +
                    vX_[366] * vX_[268] + (vX_[42] * vX_[208] + vX_[216] * vX_[271] - vX_[309] * vX_[313]) / vX_[24]) -
            vX_[4] * ((vX_[223] * vX_[247] + vX_[21] * vX_[333] - vX_[58] * vX_[21]) / vX_[223] + vX_[214] +
                         vX_[366] * vX_[274] + vX_[373] * vX_[268] +
                         (-0.022851627 * vX_[208] - vX_[277] * vX_[313]) / vX_[24]) -
            9.81 * ((vX_[4] * (vX_[232] * vX_[9] + vX_[203] - vX_[282] * vX_[233] - vX_[74] - -0.022851627 * vX_[43]) +
                        vX_[0] * (vX_[311] * vX_[9] + vX_[250] * vX_[11] + vX_[218] -
                                     (vX_[42] * vX_[43] + vX_[216] * vX_[355]) - vX_[248])) *
                           vX_[0] +
                       (vX_[4] * (0 - vX_[251] - -0.022851627 * vX_[211] - vX_[248]) +
                           vX_[0] * (vX_[74] + vX_[358] * vX_[230] - (vX_[42] * vX_[211] + vX_[216] * vX_[372]))) *
                           vX_[4] +
                       vX_[248]) -
            vX_[365] * ((vX_[4] * vX_[207] + vX_[0] * (2. * vX_[237] * vX_[358] + vX_[210] +
                                                          vX_[358] * vX_[220] * vX_[358] - vX_[317])) *
                               vX_[0] +
                           (vX_[4] * (vX_[373] - 2. * vX_[188] * vX_[282] - vX_[191] * vX_[282] - vX_[317]) +
                               vX_[0] * vX_[207]) *
                               vX_[4] +
                           vX_[317])) /
        vX_[385];
    vX_[317] = vX_[0] * jac[42];
    vX_[207] = vX_[4] * jac[42];
    jac[43] = (vX_[208] - (vX_[42] * vX_[317] + vX_[216] * vX_[342]) - -0.022851627 * vX_[207] - vX_[249] * vX_[259] -
                  vX_[389] * vX_[90] - vX_[344] * vX_[313]) /
              vX_[24];
    vX_[389] = vX_[11] * jac[43] + vX_[9] * vX_[317];
    vX_[249] = vX_[11] * vX_[344] + vX_[9] * vX_[342] + vX_[323];
    vX_[208] = vX_[22] * jac[43] + vX_[11] * vX_[317];
    vX_[313] = vX_[22] * vX_[344] + vX_[11] * vX_[342] + vX_[324];
    vX_[216] = vX_[15] * jac[43] + vX_[12] * vX_[317];
    vX_[237] = vX_[15] * vX_[344] + vX_[12] * vX_[342] + vX_[9] * vX_[259] + vX_[327];
    vX_[317] = vX_[34] * jac[43] + vX_[30] * vX_[317];
    vX_[191] = vX_[34] * vX_[344] + vX_[30] * vX_[342] + vX_[11] * vX_[259] + vX_[325];
    vX_[220] = (vX_[333] - vX_[223] * vX_[348] - vX_[221] * vX_[249] - vX_[234] * vX_[313] - vX_[227] * vX_[90] -
                   vX_[254] * vX_[237] - vX_[242] * vX_[191]) /
               vX_[223];
    jac[44] = (vX_[247] - (vX_[223] * vX_[207] + vX_[21] * vX_[348]) - (vX_[221] * vX_[389] + vX_[212] * vX_[249]) -
                  (vX_[234] * vX_[208] + vX_[31] * vX_[313]) - vX_[217] * vX_[90] -
                  (vX_[254] * vX_[216] + vX_[215] * vX_[237]) - (vX_[242] * vX_[317] + vX_[239] * vX_[191]) -
                  vX_[220] * vX_[21]) /
              vX_[223];
    vX_[217] = -1 * vX_[208];
    vX_[207] = vX_[207] + jac[44];
    vX_[247] = vX_[348] + vX_[220];
    vX_[261] = vX_[28] * vX_[207] + vX_[270] * vX_[247] + vX_[26] * vX_[389] + vX_[40] * vX_[249] + vX_[261];
    vX_[207] = vX_[26] * vX_[207] + vX_[40] * vX_[247] + vX_[27] * vX_[389] + vX_[7] * vX_[249] + vX_[380];
    vX_[317] = -0.304 * vX_[389] + -1 * vX_[317];
    vX_[53] = vX_[26] * vX_[216] + vX_[40] * vX_[237] + vX_[38] * vX_[208] + vX_[192] * vX_[313] + (-vX_[7]) * vX_[90] +
              vX_[53];
    vX_[216] = vX_[27] * vX_[216] + vX_[7] * vX_[237] + vX_[51] * vX_[208] + vX_[368] * vX_[313] + vX_[40] * vX_[90] +
               vX_[267];
    jac[45] = (vX_[65] - vX_[154] * vX_[217] - vX_[152] * vX_[261] - -0.00021200017 * vX_[207] - vX_[169] * vX_[317] -
                  vX_[184] * vX_[53] - vX_[172] * vX_[216]) /
              vX_[154];
    vX_[217] = vX_[217] + jac[45];
    vX_[120] = vX_[49] * vX_[217] + vX_[48] * vX_[261] + vX_[120];
    vX_[17] = vX_[63] * vX_[217] + vX_[49] * vX_[261] + vX_[17];
    vX_[101] = vX_[76] * vX_[217] + vX_[77] * vX_[261] + vX_[49] * vX_[53] + vX_[78] * vX_[317] + vX_[101];
    jac[46] =
        (vX_[353] - vX_[117] * vX_[207] - vX_[108] * vX_[120] - vX_[122] * vX_[17] - vX_[160] * vX_[216] -
            vX_[134] * (vX_[56] * vX_[217] + vX_[57] * vX_[261] + vX_[48] * vX_[53] + vX_[49] * vX_[317] + vX_[345]) -
            vX_[130] * vX_[101]) /
        vX_[117];
    vX_[207] = vX_[207] + jac[46];
    jac[47] = (vX_[25] - 0.009277 * vX_[120] - -0.000829 * (vX_[70] * vX_[207] + vX_[68] * vX_[17] + vX_[347]) -
                  1.5e-05 * (vX_[68] * vX_[207] + vX_[67] * vX_[17] + vX_[190]) -
                  0.038686875 * (vX_[68] * vX_[101] + vX_[94] * vX_[120] + vX_[95] * vX_[216] + vX_[187])) /
              0.009277;
    vX_[207] = -1 * sin(x_in[4]);
    vX_[101] = cos(x_in[4]);
    vX_[17] = vX_[207] * vX_[29] + vX_[101] * vX_[37];
    vX_[120] = 0.112 * vX_[207];
    vX_[216] = -0.112 * vX_[101];
    vX_[187] = vX_[120] * vX_[37] + vX_[216] * vX_[29] + vX_[207] * vX_[41] + vX_[101] * vX_[36];
    vX_[190] = vX_[17] * vX_[54] - vX_[55] * vX_[187];
    vX_[347] = vX_[17] * vX_[55];
    vX_[25] = -vX_[207];
    vX_[217] = vX_[101] * vX_[29] + vX_[25] * vX_[37];
    vX_[53] = vX_[64] * vX_[217] + vX_[217] * vX_[64];
    vX_[317] = vX_[68] * vX_[217];
    vX_[261] = vX_[67] * vX_[217];
    vX_[353] = vX_[69] * vX_[317] + vX_[261] * vX_[73];
    vX_[345] = 0.112 * vX_[101];
    vX_[65] = 0.112 * vX_[207];
    vX_[208] = -vX_[207];
    vX_[267] = vX_[345] * vX_[37] + vX_[65] * vX_[29] + vX_[101] * vX_[41] + vX_[208] * vX_[36];
    vX_[368] = vX_[67] * vX_[267] + vX_[80] * vX_[17];
    vX_[7] = vX_[75] * vX_[368] + vX_[17] * vX_[83];
    vX_[40] = -0.184 * vX_[217] + vX_[187];
    vX_[192] = vX_[69] * vX_[40] + vX_[261] * vX_[86];
    vX_[389] = vX_[69] * vX_[17] + vX_[261] * vX_[75];
    vX_[380] = vX_[73] * vX_[17] + vX_[317] * vX_[75];
    vX_[270] = vX_[73] * vX_[317] + vX_[317] * vX_[73];
    vX_[215] = vX_[69] * vX_[261] + vX_[261] * vX_[69];
    vX_[239] = -0.00751 * vX_[353] + 0.038686875 * (vX_[7] - vX_[192]) + -0.000829 * vX_[389] - 1.5e-05 * vX_[380] -
               0.000198 * (vX_[270] - vX_[215]);
    vX_[31] = 0 - vX_[239];
    vX_[21] = vX_[68] * vX_[267] + vX_[94] * vX_[17];
    vX_[212] = vX_[75] * vX_[17] + vX_[17] * vX_[75];
    vX_[40] = 1.547475 * (vX_[73] * vX_[40] + vX_[317] * vX_[86] - (vX_[75] * vX_[21] + vX_[17] * vX_[97])) +
              1.547475 * vX_[21] * x_in[11] - 0.038686875 * (vX_[212] + vX_[270]);
    vX_[188] = (-vX_[261]) * x_in[11];
    vX_[211] = vX_[317] * x_in[11];
    vX_[248] = (-vX_[368]) * x_in[11];
    vX_[192] = 0.038686875 * vX_[353] + -1.547475 * (vX_[192] - vX_[7]) + 0.00345708950900075 * vX_[188] +
               -6.25528861700981e-05 * vX_[211] + 1.38614328745655 * vX_[248] + (0.038686875 * vX_[31]) / 0.009277;
    vX_[7] = (-vX_[217]) * x_in[10];
    vX_[251] = vX_[17] * x_in[10];
    vX_[230] = vX_[187] * x_in[10];
    vX_[218] = (-vX_[267]) * x_in[10];
    vX_[250] = vX_[217] * vX_[55];
    vX_[311] = vX_[64] * vX_[17] + vX_[217] * vX_[50];
    vX_[21] = vX_[69] * vX_[21] + vX_[261] * vX_[97] - (vX_[73] * vX_[368] + vX_[317] * vX_[83]);
    vX_[215] = 0.000198 * vX_[380] + 1.5e-05 * (vX_[212] - vX_[215]) + 0.00315291990945349 * vX_[188] +
               0.000199340411771047 * vX_[211] + 0.00345708950900075 * vX_[248] + (-0.000829 * vX_[31]) / 0.009277 -
               0.038686875 * vX_[21] - -0.00146 * vX_[389] - -0.000829 * vX_[353];
    vX_[212] = 0.00605 * vX_[380] + 1.5e-05 * vX_[353] + 0.000199340411771047 * vX_[188] +
               0.0107369757464698 * vX_[211] + -6.25528861700981e-05 * vX_[248] + (1.5e-05 * vX_[31]) / 0.009277 -
               0.000198 * vX_[389] - -0.000829 * (vX_[212] - vX_[270]);
    vX_[21] = 0.038686875 * vX_[389] + 1.547475 * vX_[21] + -0.038686875 * vX_[188];
    vX_[389] = vX_[50] * vX_[17] + vX_[17] * vX_[50];
    vX_[270] = -0.001243 * vX_[250] + 0.009683 * vX_[311] + vX_[70] * vX_[215] + vX_[68] * vX_[212] +
               0.02075 * vX_[21] - -0.012652 * vX_[347] - -0.001387 * (vX_[389] - vX_[53]);
    vX_[380] = 0 - vX_[270];
    vX_[239] = 0.057838 * vX_[190] + -0.001387 * vX_[347] + -0.012652 * (0 - vX_[53]) +
               (0.009277 * vX_[31]) / 0.009277 + vX_[239] + vX_[80] * vX_[40] + vX_[94] * vX_[192] + vX_[119] * vX_[7] +
               vX_[123] * vX_[251] + vX_[132] * vX_[230] + vX_[136] * vX_[218] + (vX_[108] * vX_[380]) / vX_[117] -
               -0.008386 * vX_[250] - -0.001243 * vX_[311];
    vX_[353] = vX_[217] * vX_[54] - vX_[55] * vX_[267];
    vX_[212] = -0.018069 * vX_[347] + 0.057838 * vX_[353] + -0.012652 * vX_[311] + vX_[68] * vX_[215] +
               vX_[67] * vX_[212] + -0.184 * vX_[21] + vX_[123] * vX_[7] + vX_[116] * vX_[251] + vX_[72] * vX_[230] +
               vX_[128] * vX_[218] + (vX_[122] * vX_[380]) / vX_[117] - -0.001387 * vX_[250] -
               -0.001243 * (0 - vX_[389]);
    vX_[250] = 0.057838 * vX_[250] + 2.1032 * vX_[190] + vX_[68] * vX_[192] + vX_[67] * vX_[40] + vX_[132] * vX_[7] +
               vX_[72] * vX_[251] + vX_[62] * vX_[230] + vX_[71] * vX_[218] + (vX_[130] * vX_[380]) / vX_[117];
    vX_[353] = 0.057838 * vX_[347] + -2.1032 * vX_[353] + vX_[21] + vX_[136] * vX_[7] + vX_[128] * vX_[251] +
               vX_[71] * vX_[230] + vX_[60] * vX_[218] + (vX_[134] * vX_[380]) / vX_[117];
    vX_[21] = vX_[49] * vX_[216] + vX_[101] * vX_[57] + vX_[63] * vX_[120] + vX_[25] * vX_[56];
    vX_[347] = vX_[21] * vX_[60];
    vX_[140] = vX_[96] * vX_[21] + vX_[140] * vX_[21] + vX_[347] * vX_[61];
    vX_[96] = vX_[21] * vX_[71];
    vX_[142] = vX_[136] * vX_[21] - vX_[72] * vX_[21] - (vX_[142] * vX_[21] + vX_[96] * vX_[61]);
    vX_[190] = vX_[49] * vX_[142] + vX_[101] * vX_[143];
    vX_[215] = -vX_[21] * vX_[62];
    vX_[147] = 0 - vX_[146] * vX_[21] - (vX_[147] * vX_[21] + vX_[215] * vX_[61]);
    vX_[149] = vX_[144] * vX_[101] +
               (vX_[49] * vX_[140] + vX_[101] * vX_[141] + vX_[48] * vX_[142] + vX_[207] * vX_[143]) * vX_[49] +
               vX_[149] * vX_[207] + (vX_[190] + vX_[48] * vX_[147] + vX_[207] * vX_[148]) * vX_[48];
    vX_[142] = vX_[63] * vX_[142] + vX_[25] * vX_[143] + vX_[49] * vX_[147] + vX_[101] * vX_[148];
    vX_[190] = vX_[63] * vX_[140] + vX_[25] * vX_[141] + vX_[190];
    vX_[141] = vX_[151] * vX_[207] + vX_[142] * vX_[48] + vX_[145] * vX_[101] + vX_[190] * vX_[49];
    vX_[190] = vX_[145] * vX_[25] + vX_[190] * vX_[63] + vX_[151] * vX_[101] + vX_[142] * vX_[49];
    vX_[142] = (vX_[141] - vX_[155] * vX_[190]) / vX_[154];
    vX_[145] = vX_[149] - (vX_[152] * vX_[142] + vX_[141] * vX_[155]);
    vX_[142] = --0.00021200017 * vX_[142];
    vX_[151] = 0 - vX_[21] * vX_[163];
    vX_[148] = -vX_[151];
    vX_[21] = vX_[21] * vX_[166];
    vX_[143] = vX_[49] * vX_[21] + vX_[101] * vX_[168];
    vX_[144] = vX_[63] * vX_[148] + vX_[25] * vX_[165] + vX_[143];
    vX_[148] = vX_[49] * vX_[148] + vX_[101] * vX_[165] + vX_[48] * vX_[21] + vX_[207] * vX_[168];
    vX_[165] = 0 - vX_[148];
    vX_[146] = (vX_[165] - vX_[173] * vX_[190]) / vX_[154];
    vX_[311] = vX_[144] - (vX_[152] * vX_[146] + vX_[141] * vX_[173]);
    vX_[368] = 0 - vX_[96];
    vX_[261] = vX_[49] * vX_[347] + vX_[101] * vX_[176] + vX_[48] * vX_[368] + vX_[207] * vX_[177];
    vX_[317] = vX_[49] * vX_[96] + vX_[101] * vX_[179] + vX_[48] * vX_[215] + vX_[207] * vX_[180];
    vX_[368] = vX_[63] * vX_[347] + vX_[25] * vX_[176] + vX_[49] * vX_[368] + vX_[101] * vX_[177];
    vX_[215] = vX_[63] * vX_[96] + vX_[25] * vX_[179] + vX_[49] * vX_[215] + vX_[101] * vX_[180];
    vX_[96] = vX_[182] * vX_[207] + vX_[368] * vX_[48] + vX_[183] * vX_[101] + vX_[215] * vX_[49];
    vX_[180] = (vX_[96] - vX_[185] * vX_[190]) / vX_[154];
    vX_[179] = vX_[178] * vX_[207] + vX_[261] * vX_[48] + vX_[181] * vX_[101] + vX_[317] * vX_[49] -
               (vX_[152] * vX_[180] + vX_[141] * vX_[185]);
    vX_[347] = vX_[49] * vX_[239] + vX_[101] * vX_[291] + vX_[63] * vX_[212] + vX_[25] * vX_[305] + vX_[76] * vX_[250] +
               vX_[345] * vX_[304] + vX_[56] * vX_[353] + vX_[120] * vX_[290];
    vX_[177] = 0 - vX_[347];
    vX_[212] = vX_[48] * vX_[239] + vX_[207] * vX_[291] + vX_[49] * vX_[212] + vX_[101] * vX_[305] +
               vX_[77] * vX_[250] + vX_[65] * vX_[304] + vX_[57] * vX_[353] + vX_[216] * vX_[290] +
               vX_[145] * vX_[280] + vX_[142] * vX_[287] + vX_[311] * vX_[283] + vX_[179] * vX_[308] +
               (vX_[152] * vX_[177] + vX_[141] * vX_[315] - vX_[316] * vX_[190]) / vX_[154];
    vX_[149] = vX_[147] + vX_[140] - vX_[149] - vX_[190] - -0.00021200017 * ((-vX_[92]) * vX_[190]) / vX_[154];
    vX_[147] = --0.00021200017 * vX_[146];
    vX_[144] = vX_[164] * vX_[207] + vX_[151] * vX_[48] + vX_[143] - vX_[144] - -0.00021200017 * vX_[180];
    vX_[270] = (vX_[117] * vX_[380]) / vX_[117] + vX_[270] + vX_[142] * vX_[280] + vX_[149] * vX_[287] +
               vX_[147] * vX_[283] + vX_[144] * vX_[308] + (-0.00021200017 * vX_[177] - vX_[320] * vX_[190]) / vX_[154];
    vX_[215] = vX_[183] * vX_[25] + vX_[215] * vX_[63] + vX_[182] * vX_[101] + vX_[368] * vX_[49];
    vX_[368] = (vX_[215] - vX_[46] * vX_[190]) / vX_[154];
    vX_[317] = vX_[178] * vX_[101] + vX_[261] * vX_[49] + vX_[181] * vX_[25] + vX_[317] * vX_[63] -
               (vX_[152] * vX_[368] + vX_[141] * vX_[46]);
    vX_[148] = vX_[164] * vX_[101] + vX_[151] * vX_[49] + vX_[168] * vX_[25] + vX_[21] * vX_[63] + vX_[148] -
               -0.00021200017 * vX_[368];
    vX_[21] = 0 - vX_[207] * vX_[163] - vX_[101] * vX_[33] - (vX_[172] * vX_[368] + vX_[165] * vX_[46]);
    vX_[151] = vX_[25] * vX_[71] + vX_[101] * vX_[194];
    vX_[168] = vX_[101] * vX_[71];
    vX_[164] = vX_[25] * vX_[196] + vX_[168];
    vX_[261] = vX_[195] * vX_[207] + vX_[151] * vX_[48] + vX_[198] * vX_[101] + vX_[164] * vX_[49] -
               (vX_[184] * vX_[368] + vX_[96] * vX_[46]);
    vX_[181] = vX_[49] * vX_[353] + vX_[101] * vX_[290] + vX_[78] * vX_[250] + vX_[208] * vX_[304] +
               vX_[317] * vX_[280] + vX_[148] * vX_[287] + vX_[21] * vX_[283] + vX_[261] * vX_[308] +
               (vX_[169] * vX_[177] + vX_[215] * vX_[315] - vX_[321] * vX_[190]) / vX_[154];
    vX_[168] = vX_[201] * vX_[101] + (vX_[101] * vX_[196] + vX_[207] * vX_[71]) * vX_[49] + vX_[197] * vX_[207] +
               (vX_[168] + vX_[207] * vX_[194]) * vX_[48];
    vX_[164] = vX_[198] * vX_[25] + vX_[164] * vX_[63] + vX_[195] * vX_[101] + vX_[151] * vX_[49];
    vX_[146] = 0 - vX_[168] - vX_[164] - (vX_[172] * vX_[146] + vX_[165] * vX_[173]);
    vX_[33] = vX_[101] * vX_[163] + vX_[25] * vX_[33] - (vX_[172] * vX_[180] + vX_[165] * vX_[185]);
    vX_[151] = vX_[200] * vX_[146] - vX_[205] * vX_[33];
    vX_[168] = vX_[168] - (vX_[184] * vX_[180] + vX_[96] * vX_[185]);
    vX_[180] = vX_[200] * vX_[33] - vX_[205] * vX_[168];
    vX_[198] = vX_[151] * vX_[200] - vX_[180] * vX_[205];
    vX_[164] = vX_[164] - (vX_[169] * vX_[368] + vX_[215] * vX_[46]);
    vX_[368] = -vX_[200] * vX_[164];
    vX_[149] = vX_[149] - 2. * vX_[148] * vX_[200] - vX_[368] * vX_[200] - vX_[198];
    vX_[142] = vX_[142] + vX_[148] * vX_[205] + vX_[368] * vX_[205] - vX_[317] * vX_[200];
    vX_[195] = vX_[26] * vX_[142];
    vX_[197] = vX_[205] * vX_[164];
    vX_[145] = 2. * vX_[317] * vX_[205] + vX_[145] + vX_[197] * vX_[205] - vX_[198];
    vX_[201] = (vX_[27] * vX_[149] + vX_[195]) * vX_[27] + (vX_[27] * vX_[142] + vX_[26] * vX_[145]) * vX_[26];
    vX_[195] = vX_[195] + vX_[28] * vX_[145];
    vX_[142] = vX_[26] * vX_[149] + vX_[28] * vX_[142];
    vX_[196] = vX_[195] * vX_[26] + vX_[142] * vX_[27];
    vX_[142] = vX_[142] * vX_[26] + vX_[195] * vX_[28];
    vX_[195] = vX_[198] + vX_[142];
    vX_[194] = (vX_[196] - vX_[224] * vX_[195]) / vX_[223];
    vX_[178] = vX_[198] + vX_[201] - (vX_[221] * vX_[194] + vX_[196] * vX_[224]);
    vX_[183] = vX_[200] * vX_[21];
    vX_[182] = -vX_[183];
    vX_[143] = -vX_[200] * vX_[261];
    vX_[140] = vX_[147] * vX_[200] + vX_[182] * vX_[200] - vX_[144] * vX_[205] - vX_[143] * vX_[205];
    vX_[239] = vX_[205] * vX_[261];
    vX_[305] = vX_[205] * vX_[21];
    vX_[291] = vX_[179] * vX_[205] + vX_[239] * vX_[205] - vX_[311] * vX_[200] - vX_[305] * vX_[200];
    vX_[176] = 0 - vX_[26] * vX_[140] - vX_[27] * vX_[291];
    vX_[291] = vX_[28] * vX_[140] + vX_[26] * vX_[291] - (vX_[234] * vX_[194] + vX_[176] * vX_[224]);
    vX_[197] = vX_[197] + vX_[317];
    vX_[317] = -vX_[197];
    vX_[368] = vX_[368] + vX_[148];
    vX_[148] = vX_[26] * vX_[317] + vX_[28] * vX_[368];
    vX_[317] = vX_[27] * vX_[317] + vX_[26] * vX_[368];
    vX_[140] = 0 - vX_[317];
    vX_[194] = (vX_[140] - vX_[243] * vX_[195]) / vX_[223];
    vX_[43] = vX_[148] - (vX_[221] * vX_[194] + vX_[196] * vX_[243]);
    vX_[143] = vX_[143] + vX_[144];
    vX_[183] = vX_[183] - vX_[239];
    vX_[239] = vX_[179] + vX_[239] - vX_[183];
    vX_[74] = vX_[27] * vX_[143] + vX_[26] * vX_[239];
    vX_[182] = vX_[147] + vX_[182] - vX_[183];
    vX_[305] = vX_[305] + vX_[311];
    vX_[233] = vX_[27] * vX_[182] + vX_[26] * vX_[305];
    vX_[239] = vX_[26] * vX_[143] + vX_[28] * vX_[239];
    vX_[305] = vX_[26] * vX_[182] + vX_[28] * vX_[305];
    vX_[182] = vX_[239] * vX_[26] + vX_[305] * vX_[27];
    vX_[143] = (vX_[182] - vX_[255] * vX_[195]) / vX_[223];
    vX_[203] = vX_[74] * vX_[26] + vX_[233] * vX_[27] + vX_[183] - (vX_[221] * vX_[143] + vX_[196] * vX_[255]);
    vX_[232] = vX_[28] * vX_[212] + vX_[26] * vX_[270];
    vX_[373] = 0 - vX_[232];
    vX_[270] = vX_[26] * vX_[212] + vX_[27] * vX_[270] + -0.304 * vX_[181] + vX_[178] * vX_[323] + vX_[291] * vX_[324] +
               vX_[43] * vX_[325] + vX_[203] * vX_[327] +
               (vX_[221] * vX_[373] + vX_[196] * vX_[333] - vX_[334] * vX_[195]) / vX_[223];
    vX_[147] = 2.1032 * (vX_[64] * vX_[187] + vX_[217] * vX_[59] - (vX_[50] * vX_[267] + vX_[17] * vX_[82])) +
               vX_[95] * vX_[192] + vX_[68] * vX_[40] + vX_[162] * vX_[7] + vX_[167] * vX_[251] + vX_[163] * vX_[230] +
               vX_[166] * vX_[218] + (vX_[160] * vX_[380]) / vX_[117] + vX_[311] * vX_[280] + vX_[147] * vX_[287] +
               vX_[146] * vX_[283] + vX_[33] * vX_[308] +
               (vX_[172] * vX_[177] + vX_[165] * vX_[315] - vX_[338] * vX_[190]) / vX_[154] -
               0.057838 * (vX_[389] + vX_[53]);
    vX_[144] = vX_[48] * vX_[353] + vX_[207] * vX_[290] + vX_[49] * vX_[250] + vX_[101] * vX_[304] +
               vX_[179] * vX_[280] + vX_[144] * vX_[287] + vX_[33] * vX_[283] + vX_[168] * vX_[308] +
               (vX_[184] * vX_[177] + vX_[96] * vX_[315] - vX_[295] * vX_[190]) / vX_[154];
    vX_[142] = vX_[145] + vX_[149] + vX_[198] - vX_[201] - vX_[142] -
               (vX_[234] * (vX_[176] - vX_[32] * vX_[195]) / vX_[223] + vX_[176] * vX_[32]);
    vX_[201] = vX_[183] - (vX_[234] * vX_[194] + vX_[176] * vX_[243]);
    vX_[197] = -1 * (vX_[180] + vX_[197]);
    vX_[368] = -1 * (vX_[151] + vX_[368]);
    vX_[148] = vX_[197] * vX_[26] + vX_[368] * vX_[27] - vX_[148] - (vX_[234] * vX_[143] + vX_[176] * vX_[255]);
    vX_[347] = vX_[51] * vX_[147] +
               -1 * (vX_[347] + (vX_[154] * vX_[177] + vX_[190] * vX_[315] - vX_[312] * vX_[190]) / vX_[154]) +
               vX_[38] * vX_[144] + vX_[291] * vX_[323] + vX_[142] * vX_[324] + vX_[201] * vX_[325] +
               vX_[148] * vX_[327] + (vX_[234] * vX_[373] + vX_[176] * vX_[333] - vX_[310] * vX_[195]) / vX_[223];
    vX_[168] = vX_[168] - vX_[164];
    vX_[146] = vX_[146] - vX_[164];
    vX_[151] = vX_[26] * vX_[33];
    vX_[180] = (vX_[27] * vX_[146] + vX_[151]) * vX_[27] + (vX_[27] * vX_[33] + vX_[26] * vX_[168]) * vX_[26];
    vX_[33] = vX_[26] * vX_[146] + vX_[28] * vX_[33];
    vX_[151] = vX_[151] + vX_[28] * vX_[168];
    vX_[145] = vX_[33] * vX_[26] + vX_[151] * vX_[28];
    vX_[146] = vX_[168] + vX_[146] + vX_[164] - vX_[180] - vX_[145] - (vX_[242] * vX_[194] + vX_[140] * vX_[243]);
    vX_[261] = -vX_[261];
    vX_[168] = vX_[28] * vX_[21] + vX_[26] * vX_[261] - (vX_[242] * vX_[143] + vX_[140] * vX_[255]);
    vX_[181] = -1 * vX_[181] + vX_[43] * vX_[323] + vX_[201] * vX_[324] + vX_[146] * vX_[325] + vX_[168] * vX_[327] +
               (vX_[242] * vX_[373] + vX_[140] * vX_[333] - vX_[314] * vX_[195]) / vX_[223];
    vX_[180] = vX_[164] + vX_[180] - (vX_[254] * vX_[143] + vX_[182] * vX_[255]);
    vX_[144] = vX_[26] * vX_[144] + vX_[27] * vX_[147] + vX_[203] * vX_[323] + vX_[148] * vX_[324] +
               vX_[168] * vX_[325] + vX_[180] * vX_[327] +
               (vX_[254] * vX_[373] + vX_[182] * vX_[333] - vX_[330] * vX_[195]) / vX_[223];
    vX_[147] = vX_[258] * vX_[180];
    vX_[142] = 2. * vX_[148] * vX_[258] + vX_[142] + vX_[147] * vX_[258];
    vX_[143] = vX_[258] * vX_[168];
    vX_[291] = vX_[203] * vX_[258] + vX_[291] - vX_[201] * vX_[258] - vX_[143] * vX_[258];
    vX_[194] = vX_[11] * vX_[291];
    vX_[149] = -vX_[258] * vX_[146];
    vX_[178] = vX_[178] - 2. * vX_[43] * vX_[258] - vX_[149] * vX_[258];
    vX_[198] = (vX_[11] * vX_[142] + vX_[9] * vX_[291]) * vX_[11] + (vX_[194] + vX_[9] * vX_[178]) * vX_[9];
    vX_[291] = vX_[22] * vX_[291] + vX_[11] * vX_[178];
    vX_[194] = vX_[22] * vX_[142] + vX_[194];
    vX_[179] = vX_[291] * vX_[9] + vX_[194] * vX_[11];
    vX_[194] = vX_[194] * vX_[22] + vX_[291] * vX_[11];
    vX_[291] = (vX_[179] - vX_[19] * vX_[194]) / vX_[24];
    vX_[353] = vX_[198] - (vX_[42] * vX_[291] + vX_[179] * vX_[19]);
    vX_[291] = --0.022851627 * vX_[291];
    vX_[250] = 0 - vX_[11] * vX_[270] - vX_[22] * vX_[347] - vX_[34] * vX_[181] - vX_[15] * vX_[144];
    vX_[198] = vX_[178] + vX_[142] - vX_[198] - vX_[194] - -0.022851627 * ((-vX_[278]) * vX_[194]) / vX_[24];
    vX_[305] = vX_[239] * vX_[28] + vX_[305] * vX_[26] + vX_[183];
    vX_[239] = (vX_[305] - vX_[272] * vX_[195]) / vX_[223];
    vX_[261] = 0 - vX_[26] * vX_[21] - vX_[27] * vX_[261] - (vX_[242] * vX_[239] + vX_[140] * vX_[272]);
    vX_[233] =
        vX_[74] * vX_[28] + vX_[233] * vX_[26] - vX_[258] * vX_[261] - (vX_[221] * vX_[239] + vX_[196] * vX_[272]);
    vX_[151] = vX_[151] * vX_[26] + vX_[33] * vX_[27] - (vX_[254] * vX_[239] + vX_[182] * vX_[272]);
    vX_[368] = vX_[197] * vX_[28] + vX_[368] * vX_[26] + vX_[317] + vX_[258] * vX_[151] -
               (vX_[234] * vX_[239] + vX_[176] * vX_[272]);
    vX_[197] = vX_[11] * vX_[368];
    vX_[239] = vX_[164] + vX_[145] - (vX_[227] * vX_[239] + vX_[305] * vX_[272]);
    vX_[180] = vX_[180] - vX_[239];
    vX_[145] = vX_[22] * vX_[168] + vX_[11] * vX_[180];
    vX_[146] = vX_[146] - vX_[239];
    vX_[164] = vX_[11] * vX_[168];
    vX_[317] = vX_[22] * vX_[146] + vX_[164];
    vX_[201] = vX_[143] + vX_[201];
    vX_[149] = vX_[149] + vX_[43];
    vX_[43] = vX_[22] * vX_[201] + vX_[11] * vX_[149];
    vX_[147] = vX_[147] + vX_[148];
    vX_[143] = vX_[203] - vX_[143];
    vX_[203] = vX_[22] * vX_[147] + vX_[11] * vX_[143];
    vX_[148] = vX_[43] * vX_[22] + vX_[203] * vX_[11];
    vX_[33] = (vX_[148] - vX_[351] * vX_[194]) / vX_[24];
    vX_[203] = vX_[203] * vX_[9] + vX_[43] * vX_[11];
    vX_[43] = vX_[145] * vX_[9] + vX_[317] * vX_[11] - (vX_[349] * vX_[33] + vX_[203] * vX_[351]);
    vX_[74] = -vX_[233];
    vX_[21] = vX_[22] * vX_[74] + vX_[197];
    vX_[183] = (vX_[203] - vX_[355] * vX_[194]) / vX_[24];
    vX_[143] = vX_[11] * vX_[147] + vX_[9] * vX_[143];
    vX_[149] = vX_[11] * vX_[201] + vX_[9] * vX_[149];
    vX_[201] = vX_[358] * vX_[43];
    vX_[151] = -vX_[151];
    vX_[74] = vX_[11] * vX_[74] + vX_[9] * vX_[368];
    vX_[147] = 0 - vX_[74];
    vX_[178] = 0 - vX_[9] * vX_[261] - vX_[11] * vX_[151] - (vX_[362] * vX_[33] + vX_[147] * vX_[351]);
    vX_[142] = vX_[282] * vX_[178];
    vX_[290] = vX_[142] - vX_[201];
    vX_[304] = (vX_[147] - vX_[372] * vX_[194]) / vX_[24];
    vX_[74] = vX_[233] * vX_[11] + vX_[368] * vX_[22] + vX_[74] - -0.022851627 * vX_[33];
    vX_[317] = vX_[317] * vX_[22] + vX_[145] * vX_[11];
    vX_[148] = vX_[239] + vX_[317] - (vX_[350] * vX_[33] + vX_[148] * vX_[351]);
    vX_[145] = -vX_[282] * vX_[148];
    vX_[33] = vX_[143] * vX_[11] + vX_[149] * vX_[22] - (vX_[42] * vX_[33] + vX_[179] * vX_[351]);
    vX_[368] = vX_[291] + vX_[74] * vX_[358] + vX_[145] * vX_[358] - vX_[33] * vX_[282];
    vX_[164] = (vX_[11] * vX_[146] + vX_[9] * vX_[168]) * vX_[11] + (vX_[164] + vX_[9] * vX_[180]) * vX_[9];
    vX_[151] = vX_[11] * vX_[261] + vX_[22] * vX_[151] - (vX_[362] * vX_[183] + vX_[147] * vX_[355]);
    vX_[151] = (vX_[282] * (vX_[180] + vX_[146] + vX_[239] - vX_[164] - vX_[317] -
                               (vX_[362] * vX_[304] + vX_[147] * vX_[372])) -
                   vX_[358] * vX_[151]) *
                   vX_[282] -
               (vX_[282] * vX_[151] - vX_[358] * (vX_[239] + vX_[164] - (vX_[349] * vX_[183] + vX_[203] * vX_[355]))) *
                   vX_[358];
    jac[54] =
        (0 -
            vX_[0] * (vX_[9] * vX_[270] + vX_[11] * vX_[347] + vX_[30] * vX_[181] + vX_[12] * vX_[144] +
                         vX_[353] * vX_[274] + vX_[291] * vX_[268] +
                         (vX_[42] * vX_[250] + vX_[179] * vX_[271] - vX_[309] * vX_[194]) / vX_[24]) -
            vX_[4] * ((vX_[223] * vX_[373] + vX_[195] * vX_[333] - vX_[58] * vX_[195]) / vX_[223] + vX_[232] +
                         vX_[291] * vX_[274] + vX_[198] * vX_[268] +
                         (-0.022851627 * vX_[250] - vX_[277] * vX_[194]) / vX_[24]) -
            9.81 * ((vX_[4] * (vX_[233] * vX_[9] + vX_[197] - vX_[282] * vX_[43] - vX_[21] - -0.022851627 * vX_[183]) +
                        vX_[0] * (vX_[143] * vX_[9] + vX_[149] * vX_[11] + vX_[201] -
                                     (vX_[42] * vX_[183] + vX_[179] * vX_[355]) - vX_[290])) *
                           vX_[0] +
                       (vX_[4] * (0 - vX_[142] - -0.022851627 * vX_[304] - vX_[290]) +
                           vX_[0] * (vX_[21] + vX_[358] * vX_[178] - (vX_[42] * vX_[304] + vX_[179] * vX_[372]))) *
                           vX_[4] +
                       vX_[290]) -
            vX_[365] * ((vX_[4] * vX_[368] +
                            vX_[0] * (2. * vX_[33] * vX_[358] + vX_[353] + vX_[358] * vX_[148] * vX_[358] - vX_[151])) *
                               vX_[0] +
                           (vX_[4] * (vX_[198] - 2. * vX_[74] * vX_[282] - vX_[145] * vX_[282] - vX_[151]) +
                               vX_[0] * vX_[368]) *
                               vX_[4] +
                           vX_[151])) /
        vX_[385];
    vX_[151] = vX_[0] * jac[54];
    vX_[368] = vX_[4] * jac[54];
    jac[55] = (vX_[250] - (vX_[42] * vX_[151] + vX_[179] * vX_[342]) - -0.022851627 * vX_[368] - vX_[203] * vX_[259] -
                  vX_[147] * vX_[90] - vX_[344] * vX_[194]) /
              vX_[24];
    vX_[147] = vX_[11] * jac[55] + vX_[9] * vX_[151];
    vX_[203] = vX_[22] * jac[55] + vX_[11] * vX_[151];
    vX_[250] = vX_[15] * jac[55] + vX_[12] * vX_[151];
    vX_[151] = vX_[34] * jac[55] + vX_[30] * vX_[151];
    jac[56] = (vX_[373] - (vX_[223] * vX_[368] + vX_[195] * vX_[348]) - (vX_[221] * vX_[147] + vX_[196] * vX_[249]) -
                  (vX_[234] * vX_[203] + vX_[176] * vX_[313]) - vX_[305] * vX_[90] -
                  (vX_[254] * vX_[250] + vX_[182] * vX_[237]) - (vX_[242] * vX_[151] + vX_[140] * vX_[191]) -
                  vX_[220] * vX_[195]) /
              vX_[223];
    vX_[305] = -1 * vX_[203];
    vX_[373] = -1 * vX_[313];
    vX_[368] = vX_[368] + jac[56];
    vX_[182] = vX_[28] * vX_[368] + vX_[26] * vX_[147];
    vX_[140] = vX_[28] * vX_[247] + vX_[26] * vX_[249] + vX_[280];
    vX_[368] = vX_[26] * vX_[368] + vX_[27] * vX_[147];
    vX_[151] = -0.304 * vX_[147] + -1 * vX_[151];
    vX_[147] = -0.304 * vX_[249] + -1 * vX_[191];
    vX_[176] = vX_[26] * vX_[250] + vX_[38] * vX_[203];
    vX_[226] = vX_[26] * vX_[237] + vX_[38] * vX_[313] + vX_[226] * vX_[90] + vX_[308];
    vX_[250] = vX_[27] * vX_[250] + vX_[51] * vX_[203];
    vX_[203] = vX_[27] * vX_[237] + vX_[51] * vX_[313] + vX_[26] * vX_[90] + vX_[283];
    vX_[247] = vX_[26] * vX_[247] + vX_[27] * vX_[249] + vX_[287];
    vX_[195] = (vX_[315] - vX_[154] * vX_[373] - vX_[152] * vX_[140] - -0.00021200017 * vX_[247] - vX_[169] * vX_[147] -
                   vX_[184] * vX_[226] - vX_[172] * vX_[203]) /
               vX_[154];
    jac[57] = (vX_[177] - (vX_[154] * vX_[305] + vX_[190] * vX_[373]) - (vX_[152] * vX_[182] + vX_[141] * vX_[140]) -
                  -0.00021200017 * vX_[368] - (vX_[169] * vX_[151] + vX_[215] * vX_[147]) -
                  (vX_[184] * vX_[176] + vX_[96] * vX_[226]) - (vX_[172] * vX_[250] + vX_[165] * vX_[203]) -
                  vX_[195] * vX_[190]) /
              vX_[154];
    vX_[305] = vX_[305] + jac[57];
    vX_[215] = vX_[373] + vX_[195];
    vX_[7] = vX_[49] * vX_[305] + vX_[101] * vX_[215] + vX_[48] * vX_[182] + vX_[207] * vX_[140] + vX_[7];
    vX_[251] = vX_[63] * vX_[305] + vX_[25] * vX_[215] + vX_[49] * vX_[182] + vX_[101] * vX_[140] + vX_[251];
    vX_[230] = vX_[76] * vX_[305] + vX_[345] * vX_[215] + vX_[77] * vX_[182] + vX_[65] * vX_[140] + vX_[49] * vX_[176] +
               vX_[101] * vX_[226] + vX_[78] * vX_[151] + vX_[208] * vX_[147] + vX_[230];
    jac[58] = (vX_[380] - vX_[117] * vX_[368] - vX_[108] * vX_[7] - vX_[122] * vX_[251] - vX_[160] * vX_[250] -
                  vX_[134] * (vX_[56] * vX_[305] + vX_[120] * vX_[215] + vX_[57] * vX_[182] + vX_[216] * vX_[140] +
                                 vX_[48] * vX_[176] + vX_[207] * vX_[226] + vX_[49] * vX_[151] + vX_[101] * vX_[147] +
                                 vX_[218]) -
                  vX_[130] * vX_[230]) /
              vX_[117];
    vX_[368] = vX_[368] + jac[58];
    jac[59] = (vX_[31] - 0.009277 * vX_[7] - -0.000829 * (vX_[70] * vX_[368] + vX_[68] * vX_[251] + vX_[188]) -
                  1.5e-05 * (vX_[68] * vX_[368] + vX_[67] * vX_[251] + vX_[211]) -
                  0.038686875 * (vX_[68] * vX_[230] + vX_[94] * vX_[7] + vX_[95] * vX_[250] + vX_[248])) /
              0.009277;
    vX_[368] = -1 * sin(x_in[5]);
    vX_[230] = cos(x_in[5]);
    vX_[251] = -vX_[230];
    vX_[7] = vX_[368] * vX_[64] + vX_[251] * vX_[55];
    vX_[250] = vX_[230] * vX_[64] + vX_[368] * vX_[55];
    vX_[248] = vX_[69] * vX_[7] + vX_[250] * vX_[73];
    vX_[211] = 0.184 * vX_[230] - 0.02075 * vX_[368];
    vX_[188] = vX_[230] * vX_[82] + vX_[211] * vX_[50] + vX_[368] * vX_[54];
    vX_[31] = vX_[75] * vX_[188];
    vX_[305] = vX_[250] * vX_[86];
    vX_[176] = vX_[250] * vX_[75];
    vX_[151] = vX_[7] * vX_[75];
    vX_[182] = vX_[73] * vX_[7] + vX_[7] * vX_[73];
    vX_[380] = vX_[69] * vX_[250] + vX_[250] * vX_[69];
    vX_[218] = -0.00751 * vX_[248] + 0.038686875 * (vX_[31] - vX_[305]) + -0.000829 * vX_[176] - 1.5e-05 * vX_[151] -
               0.000198 * (vX_[182] - vX_[380]);
    vX_[216] = 0 - vX_[218];
    vX_[120] = 0.02075 * vX_[230] + 0.184 * vX_[368];
    vX_[101] = -vX_[230];
    vX_[207] = vX_[368] * vX_[82] + vX_[120] * vX_[50] + vX_[101] * vX_[54];
    vX_[208] =
        1.547475 * (vX_[7] * vX_[86] - vX_[75] * vX_[207]) + 1.547475 * vX_[207] * x_in[11] - 0.038686875 * vX_[182];
    vX_[65] = (-vX_[250]) * x_in[11];
    vX_[345] = vX_[7] * x_in[11];
    vX_[25] = (-vX_[188]) * x_in[11];
    vX_[305] = 0.038686875 * vX_[248] + -1.547475 * (vX_[305] - vX_[31]) + 0.00345708950900075 * vX_[65] +
               -6.25528861700981e-05 * vX_[345] + 1.38614328745655 * vX_[25] + (0.038686875 * vX_[216]) / 0.009277;
    vX_[31] = 1.547475 * vX_[211];
    vX_[177] = -0.184 * vX_[368] + 0.02075 * vX_[251];
    vX_[96] = -1.38614328745655 * vX_[177];
    vX_[103] = vX_[84] * vX_[211] + vX_[31] * vX_[80] - (vX_[103] * vX_[177] + vX_[96] * vX_[102]);
    vX_[84] = --6.25528861700981e-05 * vX_[177];
    vX_[165] = -0.00345708950900075 * vX_[177];
    vX_[190] = -vX_[165];
    vX_[141] = vX_[68] * vX_[84] + vX_[368] * vX_[105] + vX_[67] * vX_[190] + vX_[230] * vX_[107];
    vX_[196] = -1.547475 * vX_[211];
    vX_[194] = 0 - (vX_[109] * vX_[211] + vX_[196] * vX_[80]) - vX_[103];
    vX_[179] = vX_[109] * vX_[177] + vX_[196] * vX_[102] - -0.038686875 * vX_[211];
    vX_[110] = vX_[68] * vX_[194] + vX_[368] * vX_[110] + vX_[70] * vX_[179] + vX_[251] * vX_[111];
    vX_[33] = 1.547475 * vX_[177];
    vX_[177] = -0.07737375 * vX_[177] + vX_[113] * vX_[177] + vX_[33] * vX_[102] - vX_[103];
    vX_[179] = vX_[68] * vX_[179] + vX_[368] * vX_[111] + vX_[70] * vX_[177] + vX_[251] * vX_[114];
    vX_[114] = vX_[112] * vX_[368] + vX_[110] * vX_[68] + vX_[115] * vX_[251] + vX_[179] * vX_[70];
    vX_[111] = vX_[103] + vX_[114];
    vX_[113] = (vX_[141] - vX_[118] * vX_[111]) / vX_[117];
    vX_[102] = vX_[103] - (vX_[108] * vX_[113] + vX_[141] * vX_[118]);
    vX_[179] = vX_[115] * vX_[368] + vX_[179] * vX_[68] + vX_[112] * vX_[230] + vX_[110] * vX_[67];
    vX_[113] = vX_[106] * vX_[368] + 2. * vX_[165] * vX_[68] + vX_[121] * vX_[230] + 2. * vX_[84] * vX_[67] +
               vX_[70] * vX_[84] + vX_[251] * vX_[105] + vX_[68] * vX_[190] + vX_[368] * vX_[107] -
               (vX_[122] * vX_[113] + vX_[179] * vX_[118]);
    vX_[96] = vX_[96] + vX_[33];
    vX_[31] = vX_[31] + vX_[196];
    vX_[33] = -vX_[33];
    vX_[190] = vX_[68] * vX_[33] + vX_[368] * vX_[125] + vX_[70] * vX_[196] + vX_[251] * vX_[109];
    vX_[165] = -6.25528861700981e-05 * vX_[368] + 0.00345708950900075 * vX_[251];
    vX_[84] = vX_[129] * vX_[368] + vX_[165] * vX_[68];
    vX_[121] = (vX_[84] - vX_[131] * vX_[111]) / vX_[117];
    vX_[106] = vX_[126] * vX_[368] + vX_[96] * vX_[68] + vX_[127] * vX_[230] + vX_[31] * vX_[67] + vX_[190] -
               (vX_[108] * vX_[121] + vX_[141] * vX_[131]);
    vX_[33] = vX_[67] * vX_[33] + vX_[230] * vX_[125] + vX_[68] * vX_[196] + vX_[368] * vX_[109];
    vX_[196] = (vX_[33] - vX_[135] * vX_[111]) / vX_[117];
    vX_[125] = -(vX_[108] * vX_[196] + vX_[141] * vX_[135]);
    vX_[207] = vX_[69] * vX_[207] + vX_[250] * vX_[97] - (vX_[73] * vX_[188] + vX_[7] * vX_[83]);
    vX_[380] = 0.000198 * vX_[151] + 1.5e-05 * (0 - vX_[380]) + 0.00315291990945349 * vX_[65] +
               0.000199340411771047 * vX_[345] + 0.00345708950900075 * vX_[25] + (-0.000829 * vX_[216]) / 0.009277 -
               0.038686875 * vX_[207] - -0.00146 * vX_[176] - -0.000829 * vX_[248];
    vX_[182] = 0.00605 * vX_[151] + 1.5e-05 * vX_[248] + 0.000199340411771047 * vX_[65] +
               0.0107369757464698 * vX_[345] + -6.25528861700981e-05 * vX_[25] + (1.5e-05 * vX_[216]) / 0.009277 -
               0.000198 * vX_[176] - -0.000829 * (0 - vX_[182]);
    vX_[207] = 0.038686875 * vX_[176] + 1.547475 * vX_[207] + -0.038686875 * vX_[65];
    vX_[176] = vX_[70] * vX_[380] + vX_[251] * vX_[289] + vX_[68] * vX_[182] + vX_[368] * vX_[298] + 0.02075 * vX_[207];
    vX_[151] = 0 - vX_[176];
    vX_[218] = (0.009277 * vX_[216]) / 0.009277 + vX_[218] + vX_[80] * vX_[208] + vX_[211] * vX_[293] +
               vX_[94] * vX_[305] + vX_[120] * vX_[285] + vX_[102] * vX_[299] + vX_[113] * vX_[300] +
               vX_[106] * vX_[301] + vX_[125] * vX_[303] +
               (vX_[108] * vX_[151] + vX_[141] * vX_[296] - vX_[292] * vX_[111]) / vX_[117];
    vX_[114] = vX_[177] + vX_[194] + vX_[103] - vX_[114] -
               (vX_[122] * (vX_[179] - vX_[81] * vX_[111]) / vX_[117] + vX_[179] * vX_[81]);
    vX_[177] = -6.25528861700981e-05 * vX_[230] + 0.00345708950900075 * vX_[368];
    vX_[194] = vX_[104] * vX_[368] + vX_[177] * vX_[68] - (vX_[122] * vX_[121] + vX_[179] * vX_[131]);
    vX_[190] = 0 - vX_[190] - (vX_[122] * vX_[196] + vX_[179] * vX_[135]);
    vX_[182] = vX_[68] * vX_[380] + vX_[368] * vX_[289] + vX_[67] * vX_[182] + vX_[230] * vX_[298] + -0.184 * vX_[207] +
               vX_[113] * vX_[299] + vX_[114] * vX_[300] + vX_[194] * vX_[301] + vX_[190] * vX_[303] +
               (vX_[122] * vX_[151] + vX_[179] * vX_[296] - vX_[288] * vX_[111]) / vX_[117];
    vX_[380] = -0.161331712543454 * vX_[251];
    vX_[288] = vX_[91] * vX_[251] + vX_[380] * vX_[70];
    vX_[121] = 0 - vX_[288] - (vX_[130] * vX_[121] + vX_[84] * vX_[131]);
    vX_[131] = -(vX_[130] * vX_[196] + vX_[84] * vX_[135]);
    vX_[281] = vX_[68] * vX_[305] + vX_[368] * vX_[285] + vX_[67] * vX_[208] + vX_[230] * vX_[293] +
               vX_[106] * vX_[299] + vX_[194] * vX_[300] + vX_[121] * vX_[301] + vX_[131] * vX_[303] +
               (vX_[130] * vX_[151] + vX_[84] * vX_[296] - vX_[281] * vX_[111]) / vX_[117];
    vX_[196] = -(vX_[134] * vX_[196] + vX_[33] * vX_[135]);
    vX_[207] = vX_[207] + vX_[125] * vX_[299] + vX_[190] * vX_[300] + vX_[131] * vX_[301] + vX_[196] * vX_[303] +
               (vX_[134] * vX_[151] + vX_[33] * vX_[296] - vX_[279] * vX_[111]) / vX_[117];
    vX_[279] = vX_[61] * vX_[196];
    vX_[114] = 2. * vX_[190] * vX_[61] + vX_[114] + vX_[279] * vX_[61];
    vX_[135] = vX_[61] * vX_[131];
    vX_[113] = vX_[125] * vX_[61] + vX_[113] - vX_[194] * vX_[61] - vX_[135] * vX_[61];
    vX_[298] = vX_[49] * vX_[113];
    vX_[289] = -vX_[61] * vX_[121];
    vX_[102] = vX_[102] - 2. * vX_[106] * vX_[61] - vX_[289] * vX_[61];
    vX_[103] = (vX_[49] * vX_[114] + vX_[48] * vX_[113]) * vX_[49] + (vX_[298] + vX_[48] * vX_[102]) * vX_[48];
    vX_[113] = vX_[63] * vX_[113] + vX_[49] * vX_[102];
    vX_[298] = vX_[63] * vX_[114] + vX_[298];
    vX_[81] = vX_[113] * vX_[48] + vX_[298] * vX_[49];
    vX_[298] = vX_[298] * vX_[63] + vX_[113] * vX_[49];
    vX_[113] = (vX_[81] - vX_[155] * vX_[298]) / vX_[154];
    vX_[155] = vX_[103] - (vX_[152] * vX_[113] + vX_[81] * vX_[155]);
    vX_[113] = --0.00021200017 * vX_[113];
    vX_[165] = vX_[129] * vX_[251] + vX_[165] * vX_[70];
    vX_[129] = (vX_[165] - vX_[161] * vX_[111]) / vX_[117];
    vX_[31] = vX_[126] * vX_[251] + vX_[96] * vX_[70] + vX_[127] * vX_[368] + vX_[31] * vX_[68] - vX_[33] -
              (vX_[108] * vX_[129] + vX_[141] * vX_[161]);
    vX_[380] = vX_[91] * vX_[368] + vX_[380] * vX_[68] - (vX_[130] * vX_[129] + vX_[84] * vX_[161]);
    vX_[91] = vX_[31] - vX_[61] * vX_[380];
    vX_[96] = -vX_[91];
    vX_[127] = -(vX_[134] * vX_[129] + vX_[33] * vX_[161]);
    vX_[177] = vX_[104] * vX_[251] + vX_[177] * vX_[70] - (vX_[122] * vX_[129] + vX_[179] * vX_[161]);
    vX_[61] = vX_[61] * vX_[127] + vX_[177];
    vX_[104] = vX_[49] * vX_[61];
    vX_[126] = vX_[63] * vX_[96] + vX_[104];
    vX_[96] = vX_[49] * vX_[96] + vX_[48] * vX_[61];
    vX_[211] = 0 - vX_[96];
    vX_[292] = (vX_[211] - vX_[173] * vX_[298]) / vX_[154];
    vX_[248] = vX_[126] - (vX_[152] * vX_[292] + vX_[81] * vX_[173]);
    vX_[279] = vX_[279] + vX_[190];
    vX_[125] = vX_[125] - vX_[135];
    vX_[190] = vX_[49] * vX_[279] + vX_[48] * vX_[125];
    vX_[135] = vX_[135] + vX_[194];
    vX_[289] = vX_[289] + vX_[106];
    vX_[106] = vX_[49] * vX_[135] + vX_[48] * vX_[289];
    vX_[125] = vX_[63] * vX_[279] + vX_[49] * vX_[125];
    vX_[289] = vX_[63] * vX_[135] + vX_[49] * vX_[289];
    vX_[135] = vX_[125] * vX_[48] + vX_[289] * vX_[49];
    vX_[279] = (vX_[135] - vX_[185] * vX_[298]) / vX_[154];
    vX_[194] = vX_[190] * vX_[48] + vX_[106] * vX_[49] - (vX_[152] * vX_[279] + vX_[81] * vX_[185]);
    vX_[188] = vX_[49] * vX_[218] + vX_[63] * vX_[182] + vX_[76] * vX_[281] + vX_[56] * vX_[207];
    vX_[250] = 0 - vX_[188];
    vX_[182] = vX_[48] * vX_[218] + vX_[49] * vX_[182] + vX_[77] * vX_[281] + vX_[57] * vX_[207] + vX_[155] * vX_[280] +
               vX_[113] * vX_[287] + vX_[248] * vX_[283] + vX_[194] * vX_[308] +
               (vX_[152] * vX_[250] + vX_[81] * vX_[315] - vX_[316] * vX_[298]) / vX_[154];
    vX_[103] = vX_[102] + vX_[114] - vX_[103] - vX_[298] - -0.00021200017 * ((-vX_[92]) * vX_[298]) / vX_[154];
    vX_[102] = --0.00021200017 * vX_[292];
    vX_[126] = vX_[91] * vX_[48] + vX_[104] - vX_[126] - -0.00021200017 * vX_[279];
    vX_[176] = (vX_[117] * vX_[151] + vX_[111] * vX_[296] - vX_[319] * vX_[111]) / vX_[117] + vX_[176] +
               vX_[113] * vX_[280] + vX_[103] * vX_[287] + vX_[102] * vX_[283] + vX_[126] * vX_[308] +
               (-0.00021200017 * vX_[250] - vX_[320] * vX_[298]) / vX_[154];
    vX_[289] = vX_[289] * vX_[63] + vX_[125] * vX_[49];
    vX_[125] = (vX_[289] - vX_[46] * vX_[298]) / vX_[154];
    vX_[106] = vX_[190] * vX_[49] + vX_[106] * vX_[63] - (vX_[152] * vX_[125] + vX_[81] * vX_[46]);
    vX_[96] = vX_[91] * vX_[49] + vX_[61] * vX_[63] + vX_[96] - -0.00021200017 * vX_[125];
    vX_[61] = -vX_[127];
    vX_[91] = 0 - vX_[48] * vX_[380] - vX_[49] * vX_[61] - (vX_[172] * vX_[125] + vX_[211] * vX_[46]);
    vX_[129] = vX_[288] - (vX_[160] * vX_[129] + vX_[165] * vX_[161]);
    vX_[196] = vX_[196] - vX_[129];
    vX_[288] = vX_[63] * vX_[131] + vX_[49] * vX_[196];
    vX_[121] = vX_[121] - vX_[129];
    vX_[161] = vX_[49] * vX_[131];
    vX_[190] = vX_[63] * vX_[121] + vX_[161];
    vX_[320] = vX_[288] * vX_[48] + vX_[190] * vX_[49] - (vX_[184] * vX_[125] + vX_[135] * vX_[46]);
    vX_[321] = vX_[49] * vX_[207] + vX_[78] * vX_[281] + vX_[106] * vX_[280] + vX_[96] * vX_[287] + vX_[91] * vX_[283] +
               vX_[320] * vX_[308] + (vX_[169] * vX_[250] + vX_[289] * vX_[315] - vX_[321] * vX_[298]) / vX_[154];
    vX_[161] = (vX_[49] * vX_[121] + vX_[48] * vX_[131]) * vX_[49] + (vX_[161] + vX_[48] * vX_[196]) * vX_[48];
    vX_[190] = vX_[190] * vX_[63] + vX_[288] * vX_[49];
    vX_[121] = vX_[196] + vX_[121] + vX_[129] - vX_[161] - vX_[190] - (vX_[172] * vX_[292] + vX_[211] * vX_[173]);
    vX_[61] = vX_[49] * vX_[380] + vX_[63] * vX_[61] - (vX_[172] * vX_[279] + vX_[211] * vX_[185]);
    vX_[196] = vX_[200] * vX_[121] - vX_[205] * vX_[61];
    vX_[161] = vX_[129] + vX_[161] - (vX_[184] * vX_[279] + vX_[135] * vX_[185]);
    vX_[279] = vX_[200] * vX_[61] - vX_[205] * vX_[161];
    vX_[185] = vX_[196] * vX_[200] - vX_[279] * vX_[205];
    vX_[190] = vX_[129] + vX_[190] - (vX_[169] * vX_[125] + vX_[289] * vX_[46]);
    vX_[129] = -vX_[200] * vX_[190];
    vX_[103] = vX_[103] - 2. * vX_[96] * vX_[200] - vX_[129] * vX_[200] - vX_[185];
    vX_[113] = vX_[113] + vX_[96] * vX_[205] + vX_[129] * vX_[205] - vX_[106] * vX_[200];
    vX_[125] = vX_[26] * vX_[113];
    vX_[46] = vX_[205] * vX_[190];
    vX_[155] = 2. * vX_[106] * vX_[205] + vX_[155] + vX_[46] * vX_[205] - vX_[185];
    vX_[292] = (vX_[27] * vX_[103] + vX_[125]) * vX_[27] + (vX_[27] * vX_[113] + vX_[26] * vX_[155]) * vX_[26];
    vX_[125] = vX_[125] + vX_[28] * vX_[155];
    vX_[113] = vX_[26] * vX_[103] + vX_[28] * vX_[113];
    vX_[173] = vX_[125] * vX_[26] + vX_[113] * vX_[27];
    vX_[113] = vX_[113] * vX_[26] + vX_[125] * vX_[28];
    vX_[125] = vX_[185] + vX_[113];
    vX_[288] = (vX_[173] - vX_[224] * vX_[125]) / vX_[223];
    vX_[131] = vX_[185] + vX_[292] - (vX_[221] * vX_[288] + vX_[173] * vX_[224]);
    vX_[319] = vX_[200] * vX_[91];
    vX_[104] = -vX_[319];
    vX_[114] = -vX_[200] * vX_[320];
    vX_[92] = vX_[102] * vX_[200] + vX_[104] * vX_[200] - vX_[126] * vX_[205] - vX_[114] * vX_[205];
    vX_[218] = vX_[205] * vX_[320];
    vX_[316] = vX_[205] * vX_[91];
    vX_[205] = vX_[194] * vX_[205] + vX_[218] * vX_[205] - vX_[248] * vX_[200] - vX_[316] * vX_[200];
    vX_[200] = 0 - vX_[26] * vX_[92] - vX_[27] * vX_[205];
    vX_[205] = vX_[28] * vX_[92] + vX_[26] * vX_[205] - (vX_[234] * vX_[288] + vX_[200] * vX_[224]);
    vX_[46] = vX_[46] + vX_[106];
    vX_[106] = -vX_[46];
    vX_[129] = vX_[129] + vX_[96];
    vX_[96] = vX_[26] * vX_[106] + vX_[28] * vX_[129];
    vX_[106] = vX_[27] * vX_[106] + vX_[26] * vX_[129];
    vX_[92] = 0 - vX_[106];
    vX_[288] = (vX_[92] - vX_[243] * vX_[125]) / vX_[223];
    vX_[224] = vX_[96] - (vX_[221] * vX_[288] + vX_[173] * vX_[243]);
    vX_[114] = vX_[114] + vX_[126];
    vX_[319] = vX_[319] - vX_[218];
    vX_[218] = vX_[194] + vX_[218] - vX_[319];
    vX_[7] = vX_[27] * vX_[114] + vX_[26] * vX_[218];
    vX_[104] = vX_[102] + vX_[104] - vX_[319];
    vX_[316] = vX_[316] + vX_[248];
    vX_[109] = vX_[27] * vX_[104] + vX_[26] * vX_[316];
    vX_[218] = vX_[26] * vX_[114] + vX_[28] * vX_[218];
    vX_[316] = vX_[26] * vX_[104] + vX_[28] * vX_[316];
    vX_[104] = vX_[218] * vX_[26] + vX_[316] * vX_[27];
    vX_[114] = (vX_[104] - vX_[255] * vX_[125]) / vX_[223];
    vX_[118] = vX_[7] * vX_[26] + vX_[109] * vX_[27] + vX_[319] - (vX_[221] * vX_[114] + vX_[173] * vX_[255]);
    vX_[107] = vX_[28] * vX_[182] + vX_[26] * vX_[176];
    vX_[105] = 0 - vX_[107];
    vX_[176] = vX_[26] * vX_[182] + vX_[27] * vX_[176] + -0.304 * vX_[321] + vX_[131] * vX_[323] + vX_[205] * vX_[324] +
               vX_[224] * vX_[325] + vX_[118] * vX_[327] +
               (vX_[221] * vX_[105] + vX_[173] * vX_[333] - vX_[334] * vX_[125]) / vX_[223];
    vX_[102] = vX_[95] * vX_[305] + vX_[101] * vX_[285] + vX_[68] * vX_[208] + vX_[368] * vX_[293] +
               vX_[31] * vX_[299] + vX_[177] * vX_[300] + vX_[380] * vX_[301] + vX_[127] * vX_[303] +
               (vX_[160] * vX_[151] + vX_[165] * vX_[296] - vX_[337] * vX_[111]) / vX_[117] + vX_[248] * vX_[280] +
               vX_[102] * vX_[287] + vX_[121] * vX_[283] + vX_[61] * vX_[308] +
               (vX_[172] * vX_[250] + vX_[211] * vX_[315] - vX_[338] * vX_[298]) / vX_[154];
    vX_[126] = vX_[48] * vX_[207] + vX_[49] * vX_[281] + vX_[194] * vX_[280] + vX_[126] * vX_[287] +
               vX_[61] * vX_[283] + vX_[161] * vX_[308] +
               (vX_[184] * vX_[250] + vX_[135] * vX_[315] - vX_[295] * vX_[298]) / vX_[154];
    vX_[113] = vX_[155] + vX_[103] + vX_[185] - vX_[292] - vX_[113] -
               (vX_[234] * (vX_[200] - vX_[32] * vX_[125]) / vX_[223] + vX_[200] * vX_[32]);
    vX_[292] = vX_[319] - (vX_[234] * vX_[288] + vX_[200] * vX_[243]);
    vX_[46] = -1 * (vX_[279] + vX_[46]);
    vX_[129] = -1 * (vX_[196] + vX_[129]);
    vX_[96] = vX_[46] * vX_[26] + vX_[129] * vX_[27] - vX_[96] - (vX_[234] * vX_[114] + vX_[200] * vX_[255]);
    vX_[188] = vX_[51] * vX_[102] +
               -1 * (vX_[188] + (vX_[154] * vX_[250] + vX_[298] * vX_[315] - vX_[312] * vX_[298]) / vX_[154]) +
               vX_[38] * vX_[126] + vX_[205] * vX_[323] + vX_[113] * vX_[324] + vX_[292] * vX_[325] +
               vX_[96] * vX_[327] + (vX_[234] * vX_[105] + vX_[200] * vX_[333] - vX_[310] * vX_[125]) / vX_[223];
    vX_[161] = vX_[161] - vX_[190];
    vX_[121] = vX_[121] - vX_[190];
    vX_[310] = vX_[26] * vX_[61];
    vX_[312] = (vX_[27] * vX_[121] + vX_[310]) * vX_[27] + (vX_[27] * vX_[61] + vX_[26] * vX_[161]) * vX_[26];
    vX_[61] = vX_[26] * vX_[121] + vX_[28] * vX_[61];
    vX_[310] = vX_[310] + vX_[28] * vX_[161];
    vX_[315] = vX_[61] * vX_[26] + vX_[310] * vX_[28];
    vX_[121] = vX_[161] + vX_[121] + vX_[190] - vX_[312] - vX_[315] - (vX_[242] * vX_[288] + vX_[92] * vX_[243]);
    vX_[320] = -vX_[320];
    vX_[161] = vX_[28] * vX_[91] + vX_[26] * vX_[320] - (vX_[242] * vX_[114] + vX_[92] * vX_[255]);
    vX_[321] = -1 * vX_[321] + vX_[224] * vX_[323] + vX_[292] * vX_[324] + vX_[121] * vX_[325] + vX_[161] * vX_[327] +
               (vX_[242] * vX_[105] + vX_[92] * vX_[333] - vX_[314] * vX_[125]) / vX_[223];
    vX_[312] = vX_[190] + vX_[312] - (vX_[254] * vX_[114] + vX_[104] * vX_[255]);
    vX_[126] = vX_[26] * vX_[126] + vX_[27] * vX_[102] + vX_[118] * vX_[323] + vX_[96] * vX_[324] +
               vX_[161] * vX_[325] + vX_[312] * vX_[327] +
               (vX_[254] * vX_[105] + vX_[104] * vX_[333] - vX_[330] * vX_[125]) / vX_[223];
    vX_[102] = vX_[258] * vX_[312];
    vX_[113] = 2. * vX_[96] * vX_[258] + vX_[113] + vX_[102] * vX_[258];
    vX_[330] = vX_[258] * vX_[161];
    vX_[205] = vX_[118] * vX_[258] + vX_[205] - vX_[292] * vX_[258] - vX_[330] * vX_[258];
    vX_[327] = vX_[11] * vX_[205];
    vX_[325] = -vX_[258] * vX_[121];
    vX_[131] = vX_[131] - 2. * vX_[224] * vX_[258] - vX_[325] * vX_[258];
    vX_[324] = (vX_[11] * vX_[113] + vX_[9] * vX_[205]) * vX_[11] + (vX_[327] + vX_[9] * vX_[131]) * vX_[9];
    vX_[205] = vX_[22] * vX_[205] + vX_[11] * vX_[131];
    vX_[327] = vX_[22] * vX_[113] + vX_[327];
    vX_[323] = vX_[205] * vX_[9] + vX_[327] * vX_[11];
    vX_[327] = vX_[327] * vX_[22] + vX_[205] * vX_[11];
    vX_[205] = (vX_[323] - vX_[19] * vX_[327]) / vX_[24];
    vX_[19] = vX_[324] - (vX_[42] * vX_[205] + vX_[323] * vX_[19]);
    vX_[205] = --0.022851627 * vX_[205];
    vX_[114] = 0 - vX_[11] * vX_[176] - vX_[22] * vX_[188] - vX_[34] * vX_[321] - vX_[15] * vX_[126];
    vX_[324] = vX_[131] + vX_[113] - vX_[324] - vX_[327] - -0.022851627 * ((-vX_[278]) * vX_[327]) / vX_[24];
    vX_[316] = vX_[218] * vX_[28] + vX_[316] * vX_[26] + vX_[319];
    vX_[218] = (vX_[316] - vX_[272] * vX_[125]) / vX_[223];
    vX_[320] = 0 - vX_[26] * vX_[91] - vX_[27] * vX_[320] - (vX_[242] * vX_[218] + vX_[92] * vX_[272]);
    vX_[109] =
        vX_[7] * vX_[28] + vX_[109] * vX_[26] - vX_[258] * vX_[320] - (vX_[221] * vX_[218] + vX_[173] * vX_[272]);
    vX_[310] = vX_[310] * vX_[26] + vX_[61] * vX_[27] - (vX_[254] * vX_[218] + vX_[104] * vX_[272]);
    vX_[129] = vX_[46] * vX_[28] + vX_[129] * vX_[26] + vX_[106] + vX_[258] * vX_[310] -
               (vX_[234] * vX_[218] + vX_[200] * vX_[272]);
    vX_[46] = vX_[11] * vX_[129];
    vX_[218] = vX_[190] + vX_[315] - (vX_[227] * vX_[218] + vX_[316] * vX_[272]);
    vX_[312] = vX_[312] - vX_[218];
    vX_[315] = vX_[22] * vX_[161] + vX_[11] * vX_[312];
    vX_[121] = vX_[121] - vX_[218];
    vX_[190] = vX_[11] * vX_[161];
    vX_[272] = vX_[22] * vX_[121] + vX_[190];
    vX_[292] = vX_[330] + vX_[292];
    vX_[325] = vX_[325] + vX_[224];
    vX_[224] = vX_[22] * vX_[292] + vX_[11] * vX_[325];
    vX_[102] = vX_[102] + vX_[96];
    vX_[330] = vX_[118] - vX_[330];
    vX_[118] = vX_[22] * vX_[102] + vX_[11] * vX_[330];
    vX_[96] = vX_[224] * vX_[22] + vX_[118] * vX_[11];
    vX_[227] = (vX_[96] - vX_[351] * vX_[327]) / vX_[24];
    vX_[118] = vX_[118] * vX_[9] + vX_[224] * vX_[11];
    vX_[224] = vX_[315] * vX_[9] + vX_[272] * vX_[11] - (vX_[349] * vX_[227] + vX_[118] * vX_[351]);
    vX_[106] = -vX_[109];
    vX_[258] = vX_[22] * vX_[106] + vX_[46];
    vX_[61] = (vX_[118] - vX_[355] * vX_[327]) / vX_[24];
    vX_[330] = vX_[11] * vX_[102] + vX_[9] * vX_[330];
    vX_[325] = vX_[11] * vX_[292] + vX_[9] * vX_[325];
    vX_[292] = vX_[358] * vX_[224];
    vX_[310] = -vX_[310];
    vX_[106] = vX_[11] * vX_[106] + vX_[9] * vX_[129];
    vX_[102] = 0 - vX_[106];
    vX_[7] = 0 - vX_[9] * vX_[320] - vX_[11] * vX_[310] - (vX_[362] * vX_[227] + vX_[102] * vX_[351]);
    vX_[91] = vX_[282] * vX_[7];
    vX_[319] = vX_[91] - vX_[292];
    vX_[131] = (vX_[102] - vX_[372] * vX_[327]) / vX_[24];
    vX_[106] = vX_[109] * vX_[11] + vX_[129] * vX_[22] + vX_[106] - -0.022851627 * vX_[227];
    vX_[272] = vX_[272] * vX_[22] + vX_[315] * vX_[11];
    vX_[96] = vX_[218] + vX_[272] - (vX_[350] * vX_[227] + vX_[96] * vX_[351]);
    vX_[350] = -vX_[282] * vX_[96];
    vX_[227] = vX_[330] * vX_[11] + vX_[325] * vX_[22] - (vX_[42] * vX_[227] + vX_[323] * vX_[351]);
    vX_[351] = vX_[205] + vX_[106] * vX_[358] + vX_[350] * vX_[358] - vX_[227] * vX_[282];
    vX_[190] = (vX_[11] * vX_[121] + vX_[9] * vX_[161]) * vX_[11] + (vX_[190] + vX_[9] * vX_[312]) * vX_[9];
    vX_[310] = vX_[11] * vX_[320] + vX_[22] * vX_[310] - (vX_[362] * vX_[61] + vX_[102] * vX_[355]);
    vX_[310] = (vX_[282] * (vX_[312] + vX_[121] + vX_[218] - vX_[190] - vX_[272] -
                               (vX_[362] * vX_[131] + vX_[102] * vX_[372])) -
                   vX_[358] * vX_[310]) *
                   vX_[282] -
               (vX_[282] * vX_[310] - vX_[358] * (vX_[218] + vX_[190] - (vX_[349] * vX_[61] + vX_[118] * vX_[355]))) *
                   vX_[358];
    jac[66] =
        (0 -
            vX_[0] *
                (vX_[9] * vX_[176] + vX_[11] * vX_[188] + vX_[30] * vX_[321] + vX_[12] * vX_[126] + vX_[19] * vX_[274] +
                    vX_[205] * vX_[268] + (vX_[42] * vX_[114] + vX_[323] * vX_[271] - vX_[309] * vX_[327]) / vX_[24]) -
            vX_[4] * ((vX_[223] * vX_[105] + vX_[125] * vX_[333] - vX_[58] * vX_[125]) / vX_[223] + vX_[107] +
                         vX_[205] * vX_[274] + vX_[324] * vX_[268] +
                         (-0.022851627 * vX_[114] - vX_[277] * vX_[327]) / vX_[24]) -
            9.81 * ((vX_[4] * (vX_[109] * vX_[9] + vX_[46] - vX_[282] * vX_[224] - vX_[258] - -0.022851627 * vX_[61]) +
                        vX_[0] * (vX_[330] * vX_[9] + vX_[325] * vX_[11] + vX_[292] -
                                     (vX_[42] * vX_[61] + vX_[323] * vX_[355]) - vX_[319])) *
                           vX_[0] +
                       (vX_[4] * (0 - vX_[91] - -0.022851627 * vX_[131] - vX_[319]) +
                           vX_[0] * (vX_[258] + vX_[358] * vX_[7] - (vX_[42] * vX_[131] + vX_[323] * vX_[372]))) *
                           vX_[4] +
                       vX_[319]) -
            vX_[365] * ((vX_[4] * vX_[351] +
                            vX_[0] * (2. * vX_[227] * vX_[358] + vX_[19] + vX_[358] * vX_[96] * vX_[358] - vX_[310])) *
                               vX_[0] +
                           (vX_[4] * (vX_[324] - 2. * vX_[106] * vX_[282] - vX_[350] * vX_[282] - vX_[310]) +
                               vX_[0] * vX_[351]) *
                               vX_[4] +
                           vX_[310])) /
        vX_[385];
    vX_[310] = vX_[0] * jac[66];
    vX_[351] = vX_[4] * jac[66];
    jac[67] = (vX_[114] - (vX_[42] * vX_[310] + vX_[323] * vX_[342]) - -0.022851627 * vX_[351] - vX_[118] * vX_[259] -
                  vX_[102] * vX_[90] - vX_[344] * vX_[327]) /
              vX_[24];
    vX_[102] = vX_[11] * jac[67] + vX_[9] * vX_[310];
    vX_[118] = vX_[22] * jac[67] + vX_[11] * vX_[310];
    vX_[114] = vX_[15] * jac[67] + vX_[12] * vX_[310];
    vX_[310] = vX_[34] * jac[67] + vX_[30] * vX_[310];
    jac[68] = (vX_[105] - (vX_[223] * vX_[351] + vX_[125] * vX_[348]) - (vX_[221] * vX_[102] + vX_[173] * vX_[249]) -
                  (vX_[234] * vX_[118] + vX_[200] * vX_[313]) - vX_[316] * vX_[90] -
                  (vX_[254] * vX_[114] + vX_[104] * vX_[237]) - (vX_[242] * vX_[310] + vX_[92] * vX_[191]) -
                  vX_[220] * vX_[125]) /
              vX_[223];
    vX_[316] = -1 * vX_[118];
    vX_[351] = vX_[351] + jac[68];
    vX_[105] = vX_[28] * vX_[351] + vX_[26] * vX_[102];
    vX_[351] = vX_[26] * vX_[351] + vX_[27] * vX_[102];
    vX_[310] = -0.304 * vX_[102] + -1 * vX_[310];
    vX_[102] = vX_[26] * vX_[114] + vX_[38] * vX_[118];
    vX_[114] = vX_[27] * vX_[114] + vX_[51] * vX_[118];
    jac[69] = (vX_[250] - (vX_[154] * vX_[316] + vX_[298] * vX_[373]) - (vX_[152] * vX_[105] + vX_[81] * vX_[140]) -
                  -0.00021200017 * vX_[351] - (vX_[169] * vX_[310] + vX_[289] * vX_[147]) -
                  (vX_[184] * vX_[102] + vX_[135] * vX_[226]) - (vX_[172] * vX_[114] + vX_[211] * vX_[203]) -
                  vX_[195] * vX_[298]) /
              vX_[154];
    vX_[316] = vX_[316] + jac[69];
    vX_[289] = vX_[49] * vX_[316] + vX_[48] * vX_[105];
    vX_[299] = vX_[49] * vX_[215] + vX_[48] * vX_[140] + vX_[299];
    vX_[250] = vX_[63] * vX_[316] + vX_[49] * vX_[105];
    vX_[300] = vX_[63] * vX_[215] + vX_[49] * vX_[140] + vX_[300];
    vX_[303] = vX_[56] * vX_[215] + vX_[57] * vX_[140] + vX_[48] * vX_[226] + vX_[49] * vX_[147] + vX_[303];
    vX_[135] = vX_[76] * vX_[316] + vX_[77] * vX_[105] + vX_[49] * vX_[102] + vX_[78] * vX_[310];
    vX_[215] = vX_[76] * vX_[215] + vX_[77] * vX_[140] + vX_[49] * vX_[226] + vX_[78] * vX_[147] + vX_[301];
    vX_[296] = (vX_[296] - vX_[117] * vX_[247] - vX_[108] * vX_[299] - vX_[122] * vX_[300] - vX_[160] * vX_[203] -
                   vX_[134] * vX_[303] - vX_[130] * vX_[215]) /
               vX_[117];
    jac[70] = (vX_[151] - (vX_[117] * vX_[351] + vX_[111] * vX_[247]) - (vX_[108] * vX_[289] + vX_[141] * vX_[299]) -
                  (vX_[122] * vX_[250] + vX_[179] * vX_[300]) - (vX_[160] * vX_[114] + vX_[165] * vX_[203]) -
                  (vX_[134] * (vX_[56] * vX_[316] + vX_[57] * vX_[105] + vX_[48] * vX_[102] + vX_[49] * vX_[310]) +
                      vX_[33] * vX_[303]) -
                  (vX_[130] * vX_[135] + vX_[84] * vX_[215]) - vX_[296] * vX_[111]) /
              vX_[117];
    vX_[351] = vX_[351] + jac[70];
    vX_[296] = vX_[247] + vX_[296];
    jac[71] =
        (vX_[216] - 0.009277 * vX_[289] -
            -0.000829 *
                (vX_[70] * vX_[351] + vX_[251] * vX_[296] + vX_[68] * vX_[250] + vX_[368] * vX_[300] + vX_[65]) -
            1.5e-05 * (vX_[68] * vX_[351] + vX_[368] * vX_[296] + vX_[67] * vX_[250] + vX_[230] * vX_[300] + vX_[345]) -
            0.038686875 * (vX_[68] * vX_[135] + vX_[368] * vX_[215] + vX_[94] * vX_[289] + vX_[120] * vX_[299] +
                              vX_[95] * vX_[114] + vX_[101] * vX_[203] + vX_[25])) /
        0.009277;
    vX_[296] = vX_[0] * x_in[7];
    vX_[351] = vX_[5] * vX_[4] + vX_[4] * vX_[5];
    vX_[215] = vX_[12] * vX_[0];
    vX_[135] = -(vX_[10] * vX_[215] + vX_[4] * vX_[16]);
    vX_[300] = vX_[9] * vX_[0];
    vX_[250] = vX_[18] * vX_[4] + vX_[300] * vX_[10];
    vX_[299] = vX_[10] * vX_[4] + vX_[4] * vX_[10];
    vX_[289] = vX_[11] * vX_[0];
    vX_[114] = vX_[23] * vX_[289] + vX_[289] * vX_[23];
    vX_[25] = vX_[30] * vX_[0];
    vX_[345] = -0.304 * vX_[300] + -1 * vX_[25];
    vX_[65] = vX_[26] * vX_[300] + vX_[28] * vX_[4];
    vX_[101] = vX_[38] * vX_[289] + vX_[26] * vX_[215];
    vX_[120] = -1 * vX_[289];
    vX_[216] = vX_[29] * vX_[345] + vX_[65] * vX_[36] - (vX_[37] * vX_[101] + vX_[120] * vX_[41]);
    vX_[251] = vX_[29] * vX_[120] + vX_[65] * vX_[37];
    vX_[230] = vX_[37] * vX_[120] + vX_[120] * vX_[37];
    vX_[368] = vX_[27] * vX_[300] + vX_[26] * vX_[4];
    vX_[203] = vX_[45] * vX_[368] + vX_[368] * vX_[45];
    vX_[247] = vX_[51] * vX_[289] + vX_[27] * vX_[215];
    vX_[303] = vX_[48] * vX_[65] + vX_[49] * vX_[120];
    vX_[316] = vX_[56] * vX_[120] + vX_[57] * vX_[65] + vX_[48] * vX_[101] + vX_[49] * vX_[345];
    vX_[102] = vX_[50] * vX_[247] + vX_[303] * vX_[54] - (vX_[55] * vX_[316] + vX_[368] * vX_[59]);
    vX_[310] = vX_[50] * vX_[368] + vX_[303] * vX_[55];
    vX_[105] = vX_[55] * vX_[368] + vX_[368] * vX_[55];
    vX_[165] = vX_[49] * vX_[65] + vX_[63] * vX_[120];
    vX_[151] = vX_[64] * vX_[165] + vX_[165] * vX_[64];
    vX_[33] = vX_[68] * vX_[165] + vX_[70] * vX_[368];
    vX_[84] = vX_[67] * vX_[165] + vX_[68] * vX_[368];
    vX_[179] = vX_[69] * vX_[33] + vX_[84] * vX_[73];
    vX_[111] = vX_[76] * vX_[120] + vX_[77] * vX_[65] + vX_[49] * vX_[101] + vX_[78] * vX_[345];
    vX_[141] = vX_[67] * vX_[111] + vX_[80] * vX_[303] + vX_[68] * vX_[247];
    vX_[226] = vX_[75] * vX_[141] + vX_[303] * vX_[83];
    vX_[147] = 0.02075 * vX_[368] + -0.184 * vX_[165] + vX_[316];
    vX_[140] = vX_[69] * vX_[147] + vX_[84] * vX_[86];
    vX_[301] = vX_[69] * vX_[303] + vX_[84] * vX_[75];
    vX_[211] = vX_[73] * vX_[303] + vX_[33] * vX_[75];
    vX_[298] = vX_[73] * vX_[33] + vX_[33] * vX_[73];
    vX_[81] = vX_[69] * vX_[84] + vX_[84] * vX_[69];
    vX_[195] = -0.00751 * vX_[179] + 0.038686875 * (vX_[226] - vX_[140]) + -0.000829 * vX_[301] - 1.5e-05 * vX_[211] -
               0.000198 * (vX_[298] - vX_[81]);
    vX_[373] = 0 - vX_[195];
    vX_[118] = vX_[68] * vX_[111] + vX_[94] * vX_[303] + vX_[95] * vX_[247];
    vX_[104] = vX_[75] * vX_[303] + vX_[303] * vX_[75];
    vX_[147] = 1.547475 * (vX_[73] * vX_[147] + vX_[33] * vX_[86] - (vX_[75] * vX_[118] + vX_[303] * vX_[97])) +
               1.547475 * vX_[118] * x_in[11] - 0.038686875 * (vX_[104] + vX_[298]);
    vX_[92] = (-vX_[84]) * x_in[11];
    vX_[200] = vX_[33] * x_in[11];
    vX_[125] = (-vX_[141]) * x_in[11];
    vX_[140] = 0.038686875 * vX_[179] + -1.547475 * (vX_[140] - vX_[226]) + 0.00345708950900075 * vX_[92] +
               -6.25528861700981e-05 * vX_[200] + 1.38614328745655 * vX_[125] + (0.038686875 * vX_[373]) / 0.009277;
    vX_[226] = (-vX_[165]) * x_in[10];
    vX_[173] = vX_[303] * x_in[10];
    vX_[220] = vX_[316] * x_in[10];
    vX_[191] = (-vX_[111]) * x_in[10];
    vX_[237] = vX_[64] * vX_[368] + vX_[165] * vX_[55];
    vX_[313] = vX_[64] * vX_[303] + vX_[165] * vX_[50];
    vX_[118] = vX_[69] * vX_[118] + vX_[84] * vX_[97] - (vX_[73] * vX_[141] + vX_[33] * vX_[83]);
    vX_[81] = 0.000198 * vX_[211] + 1.5e-05 * (vX_[104] - vX_[81]) + 0.00315291990945349 * vX_[92] +
              0.000199340411771047 * vX_[200] + 0.00345708950900075 * vX_[125] + (-0.000829 * vX_[373]) / 0.009277 -
              0.038686875 * vX_[118] - -0.00146 * vX_[301] - -0.000829 * vX_[179];
    vX_[104] = 0.00605 * vX_[211] + 1.5e-05 * vX_[179] + 0.000199340411771047 * vX_[92] +
               0.0107369757464698 * vX_[200] + -6.25528861700981e-05 * vX_[125] + (1.5e-05 * vX_[373]) / 0.009277 -
               0.000198 * vX_[301] - -0.000829 * (vX_[104] - vX_[298]);
    vX_[118] = 0.038686875 * vX_[301] + 1.547475 * vX_[118] + -0.038686875 * vX_[92];
    vX_[301] = vX_[50] * vX_[303] + vX_[303] * vX_[50];
    vX_[298] = -0.001243 * vX_[237] + 0.009683 * vX_[313] + vX_[70] * vX_[81] + vX_[68] * vX_[104] +
               0.02075 * vX_[118] - -0.012652 * vX_[310] - -0.001387 * (vX_[301] - vX_[151]);
    vX_[211] = 0 - vX_[298];
    vX_[195] = 0.057838 * vX_[102] + -0.001387 * vX_[310] + -0.012652 * (vX_[105] - vX_[151]) +
               (0.009277 * vX_[373]) / 0.009277 + vX_[195] + vX_[80] * vX_[147] + vX_[94] * vX_[140] +
               vX_[119] * vX_[226] + vX_[123] * vX_[173] + vX_[132] * vX_[220] + vX_[136] * vX_[191] +
               (vX_[108] * vX_[211]) / vX_[117] - -0.008386 * vX_[237] - -0.001243 * vX_[313];
    vX_[179] = vX_[64] * vX_[247] + vX_[165] * vX_[54] - (vX_[55] * vX_[111] + vX_[368] * vX_[82]);
    vX_[104] = -0.018069 * vX_[310] + 0.057838 * vX_[179] + -0.012652 * vX_[313] + vX_[68] * vX_[81] +
               vX_[67] * vX_[104] + -0.184 * vX_[118] + vX_[123] * vX_[226] + vX_[116] * vX_[173] + vX_[72] * vX_[220] +
               vX_[128] * vX_[191] + (vX_[122] * vX_[211]) / vX_[117] - -0.001387 * vX_[237] -
               -0.001243 * (vX_[105] - vX_[301]);
    vX_[237] = 0.057838 * vX_[237] + 2.1032 * vX_[102] + vX_[68] * vX_[140] + vX_[67] * vX_[147] + vX_[132] * vX_[226] +
               vX_[72] * vX_[173] + vX_[62] * vX_[220] + vX_[71] * vX_[191] + (vX_[130] * vX_[211]) / vX_[117];
    vX_[179] = 0.057838 * vX_[310] + -2.1032 * vX_[179] + vX_[118] + vX_[136] * vX_[226] + vX_[128] * vX_[173] +
               vX_[71] * vX_[220] + vX_[60] * vX_[191] + (vX_[134] * vX_[211]) / vX_[117];
    vX_[118] = (-vX_[368]) * x_in[9];
    vX_[310] = vX_[65] * x_in[9];
    vX_[102] = vX_[101] * x_in[9];
    vX_[81] = (-vX_[247]) * x_in[9];
    vX_[313] = vX_[37] * vX_[247] + vX_[120] * vX_[54];
    vX_[345] = vX_[45] * vX_[345] + vX_[368] * vX_[36];
    vX_[105] = vX_[45] * vX_[65] + vX_[368] * vX_[29];
    vX_[120] = vX_[45] * vX_[120] + vX_[368] * vX_[37];
    vX_[141] = vX_[29] * vX_[65] + vX_[65] * vX_[29];
    vX_[84] = 0.160298259823722 * (vX_[313] - vX_[345]) + -0.06337651 * vX_[105] + -0.0022920002 * vX_[120] +
              vX_[49] * vX_[195] + vX_[63] * vX_[104] + vX_[76] * vX_[237] + vX_[56] * vX_[179] -
              -0.008711861 * vX_[216] - -0.00021200017 * vX_[251] - 0.0036857284 * (vX_[141] - vX_[203]);
    vX_[33] = 0 - vX_[84];
    vX_[247] = vX_[45] * vX_[101] + vX_[368] * vX_[41] - (vX_[29] * vX_[247] + vX_[65] * vX_[54]);
    vX_[104] = 1.52322944854339e-09 * vX_[216] + 0.0036857284 * vX_[251] + -0.00021200017 * (vX_[230] - vX_[203]) +
               vX_[48] * vX_[195] + vX_[49] * vX_[104] + vX_[77] * vX_[237] + vX_[57] * vX_[179] + vX_[156] * vX_[118] +
               vX_[158] * vX_[310] + vX_[174] * vX_[102] + vX_[186] * vX_[81] + (vX_[152] * vX_[33]) / vX_[154] -
               0.160298259823722 * vX_[247] - 0.01404749 * vX_[120] - -0.0022920002 * vX_[105];
    vX_[298] = -0.008711861 * vX_[247] + 1.52322944854339e-09 * (vX_[345] - vX_[313]) + 0.077424 * vX_[251] +
               -0.00021200017 * vX_[105] + (vX_[117] * vX_[211]) / vX_[117] + vX_[298] + vX_[158] * vX_[118] +
               vX_[153] * vX_[310] + vX_[150] * vX_[102] + vX_[170] * vX_[81] + (-0.00021200017 * vX_[33]) / vX_[154] -
               0.0036857284 * vX_[120] - -0.0022920002 * (vX_[230] - vX_[141]);
    vX_[247] = 1.7423722 * vX_[247] + 0.160298259823722 * vX_[120] + -0.008711861 * vX_[251] + vX_[49] * vX_[179] +
               vX_[78] * vX_[237] + vX_[39] * vX_[118] + vX_[171] * vX_[310] + vX_[193] * vX_[102] +
               vX_[199] * vX_[81] + (vX_[169] * vX_[33]) / vX_[154] - 1.52322944854339e-09 * (vX_[141] + vX_[203]);
    vX_[195] = (-vX_[289]) * x_in[8];
    vX_[368] = vX_[300] * x_in[8];
    vX_[101] = vX_[215] * x_in[8];
    vX_[65] = (-vX_[25]) * x_in[8];
    vX_[249] = vX_[10] * vX_[25] + vX_[4] * vX_[35];
    vX_[348] = vX_[23] * vX_[300] + vX_[289] * vX_[18];
    vX_[90] = vX_[23] * vX_[4] + vX_[289] * vX_[10];
    vX_[327] = vX_[18] * vX_[300] + vX_[300] * vX_[18];
    vX_[323] = -0.0055615274403 * vX_[249] + 0.00750500000000001 * vX_[348] + -0.0037997814 * vX_[90] +
               vX_[28] * vX_[104] + vX_[26] * vX_[298] - 0.01438086 * vX_[135] - -0.011715295 * vX_[250] -
               5.399998e-05 * (vX_[327] - vX_[114]);
    vX_[344] = 0 - vX_[323];
    vX_[25] = vX_[23] * vX_[215] + vX_[289] * vX_[16] - (vX_[18] * vX_[25] + vX_[300] * vX_[35]);
    vX_[298] = 0.647967112 * vX_[135] + 5.399998e-05 * vX_[250] + -0.011715295 * (vX_[299] - vX_[114]) +
               vX_[26] * vX_[104] + vX_[27] * vX_[298] + -0.304 * vX_[247] + vX_[225] * vX_[195] + vX_[235] * vX_[368] +
               vX_[244] * vX_[101] + vX_[256] * vX_[65] + (vX_[221] * vX_[344]) / vX_[223] -
               -0.0055615274403 * vX_[25] - -0.192033951 * vX_[90] - -0.0037997814 * vX_[348];
    vX_[249] = -vX_[249];
    vX_[141] = 1.7423722 * vX_[216] + 1.52322944854339e-09 * vX_[120] + -0.008711861 * vX_[105] +
               2.1032 * (vX_[64] * vX_[316] + vX_[165] * vX_[59] - (vX_[50] * vX_[111] + vX_[303] * vX_[82])) +
               vX_[95] * vX_[140] + vX_[68] * vX_[147] + vX_[162] * vX_[226] + vX_[167] * vX_[173] +
               vX_[163] * vX_[220] + vX_[166] * vX_[191] + (vX_[160] * vX_[211]) / vX_[117] + vX_[174] * vX_[118] +
               vX_[150] * vX_[310] + vX_[204] * vX_[102] + vX_[206] * vX_[81] + (vX_[172] * vX_[33]) / vX_[154] -
               0.160298259823722 * (vX_[230] + vX_[141]) - 0.057838 * (vX_[301] + vX_[151]);
    vX_[105] = -1.7423722 * (vX_[345] - vX_[313]) + 0.160298259823722 * vX_[105] + 1.52322944854339e-09 * vX_[251] +
               vX_[48] * vX_[179] + vX_[49] * vX_[237] + vX_[186] * vX_[118] + vX_[170] * vX_[310] +
               vX_[206] * vX_[102] + vX_[202] * vX_[81] + (vX_[184] * vX_[33]) / vX_[154] -
               -0.008711861 * (vX_[230] + vX_[203]);
    vX_[25] = 0.01438086 * vX_[25] + 0.647967112 * vX_[249] + -0.199538951 * vX_[250] + -0.011715295 * vX_[348] +
              vX_[51] * vX_[141] + -1 * (vX_[84] + (vX_[154] * vX_[33]) / vX_[154]) + vX_[38] * vX_[105] +
              vX_[235] * vX_[195] + vX_[222] * vX_[368] + vX_[219] * vX_[101] + vX_[240] * vX_[65] +
              (vX_[234] * vX_[344]) / vX_[223] - 5.399998e-05 * vX_[90] - -0.0037997814 * (vX_[299] - vX_[327]);
    vX_[327] = 2.327 * vX_[135] + 0.647967112 * vX_[90] + 0.01438086 * vX_[348] + -1 * vX_[247] + vX_[244] * vX_[195] +
               vX_[219] * vX_[368] + vX_[88] * vX_[101] + vX_[85] * vX_[65] + (vX_[242] * vX_[344]) / vX_[223] -
               -0.0055615274403 * (vX_[299] + vX_[327]);
    vX_[105] = -2.327 * vX_[249] + -0.0055615274403 * vX_[348] + 0.647967112 * vX_[250] + vX_[26] * vX_[105] +
               vX_[27] * vX_[141] + vX_[256] * vX_[195] + vX_[240] * vX_[368] + vX_[85] * vX_[101] + vX_[44] * vX_[65] +
               (vX_[254] * vX_[344]) / vX_[223] - 0.01438086 * (vX_[299] + vX_[114]);
    vX_[141] = (-vX_[4]) * x_in[7];
    vX_[249] = vX_[14] * vX_[0] + vX_[0] * vX_[14];
    vX_[348] = vX_[4] * x_in[7];
    vX_[114] = vX_[5] * vX_[0] + vX_[4] * vX_[14];
    vX_[299] = -0.022851627 * vX_[296] + 0.0055279857 * (vX_[249] - vX_[351]) - -0.002752 * vX_[348] -
               0.046852534 * vX_[114] - vX_[11] * vX_[298] - vX_[22] * vX_[25] - vX_[34] * vX_[327] -
               vX_[15] * vX_[105];
    jac[78] =
        (0 -
            vX_[0] * (0.0055279857 * vX_[296] + -0.022851627 * (0 - vX_[351]) + vX_[9] * vX_[298] + vX_[11] * vX_[25] +
                         vX_[30] * vX_[327] + vX_[12] * vX_[105] + vX_[13] * vX_[141] + vX_[265] * vX_[296] +
                         (vX_[42] * vX_[299]) / vX_[24] - 0.012390532 * vX_[348] - -0.002752 * vX_[114]) -
            vX_[4] * (-0.034462002 * vX_[296] + -0.022851627 * vX_[114] + (vX_[223] * vX_[344]) / vX_[223] + vX_[323] +
                         vX_[265] * vX_[141] + vX_[98] * vX_[296] + (-0.022851627 * vX_[299]) / vX_[24] -
                         0.0055279857 * vX_[348] - -0.002752 * (0 - vX_[249]))) /
        vX_[385];
    vX_[141] = vX_[0] * jac[78] + vX_[141];
    vX_[296] = vX_[4] * jac[78] + vX_[296];
    jac[79] = (vX_[299] - vX_[42] * vX_[141] - -0.022851627 * vX_[296]) / vX_[24];
    vX_[195] = vX_[11] * jac[79] + vX_[9] * vX_[141] + vX_[195];
    vX_[368] = vX_[22] * jac[79] + vX_[11] * vX_[141] + vX_[368];
    vX_[65] = vX_[15] * jac[79] + vX_[12] * vX_[141] + vX_[65];
    vX_[141] = vX_[34] * jac[79] + vX_[30] * vX_[141] + vX_[101];
    jac[80] = (vX_[344] - vX_[223] * vX_[296] - vX_[221] * vX_[195] - vX_[234] * vX_[368] - vX_[254] * vX_[65] -
                  vX_[242] * vX_[141]) /
              vX_[223];
    vX_[344] = -1 * vX_[368];
    vX_[296] = vX_[296] + jac[80];
    vX_[118] = vX_[28] * vX_[296] + vX_[26] * vX_[195] + vX_[118];
    vX_[296] = vX_[26] * vX_[296] + vX_[27] * vX_[195] + vX_[310];
    vX_[141] = -0.304 * vX_[195] + -1 * vX_[141];
    vX_[81] = vX_[26] * vX_[65] + vX_[38] * vX_[368] + vX_[81];
    vX_[65] = vX_[27] * vX_[65] + vX_[51] * vX_[368] + vX_[102];
    jac[81] = (vX_[33] - vX_[154] * vX_[344] - vX_[152] * vX_[118] - -0.00021200017 * vX_[296] - vX_[169] * vX_[141] -
                  vX_[184] * vX_[81] - vX_[172] * vX_[65]) /
              vX_[154];
    vX_[344] = vX_[344] + jac[81];
    vX_[226] = vX_[49] * vX_[344] + vX_[48] * vX_[118] + vX_[226];
    vX_[173] = vX_[63] * vX_[344] + vX_[49] * vX_[118] + vX_[173];
    vX_[220] = vX_[76] * vX_[344] + vX_[77] * vX_[118] + vX_[49] * vX_[81] + vX_[78] * vX_[141] + vX_[220];
    jac[82] =
        (vX_[211] - vX_[117] * vX_[296] - vX_[108] * vX_[226] - vX_[122] * vX_[173] - vX_[160] * vX_[65] -
            vX_[134] * (vX_[56] * vX_[344] + vX_[57] * vX_[118] + vX_[48] * vX_[81] + vX_[49] * vX_[141] + vX_[191]) -
            vX_[130] * vX_[220]) /
        vX_[117];
    vX_[296] = vX_[296] + jac[82];
    jac[83] = (vX_[373] - 0.009277 * vX_[226] - -0.000829 * (vX_[70] * vX_[296] + vX_[68] * vX_[173] + vX_[92]) -
                  1.5e-05 * (vX_[68] * vX_[296] + vX_[67] * vX_[173] + vX_[200]) -
                  0.038686875 * (vX_[68] * vX_[220] + vX_[94] * vX_[226] + vX_[95] * vX_[65] + vX_[125])) /
              0.009277;
    vX_[296] = x_in[7] + x_in[7];
    vX_[220] = -vX_[10] * vX_[15];
    vX_[173] = vX_[11] * vX_[10];
    vX_[226] = vX_[23] * vX_[22] + vX_[22] * vX_[23];
    vX_[65] = -0.304 * vX_[11] + -1 * vX_[34];
    vX_[125] = vX_[26] * vX_[11];
    vX_[200] = vX_[38] * vX_[22] + vX_[26] * vX_[15];
    vX_[92] = -1 * vX_[22];
    vX_[373] = vX_[29] * vX_[65] + vX_[125] * vX_[36] - (vX_[37] * vX_[200] + vX_[92] * vX_[41]);
    vX_[344] = vX_[29] * vX_[92] + vX_[125] * vX_[37];
    vX_[81] = vX_[37] * vX_[92] + vX_[92] * vX_[37];
    vX_[141] = vX_[27] * vX_[11];
    vX_[118] = vX_[45] * vX_[141] + vX_[141] * vX_[45];
    vX_[211] = vX_[51] * vX_[22] + vX_[27] * vX_[15];
    vX_[191] = vX_[48] * vX_[125] + vX_[49] * vX_[92];
    vX_[33] = vX_[56] * vX_[92] + vX_[57] * vX_[125] + vX_[48] * vX_[200] + vX_[49] * vX_[65];
    vX_[368] = vX_[50] * vX_[211] + vX_[191] * vX_[54] - (vX_[55] * vX_[33] + vX_[141] * vX_[59]);
    vX_[102] = vX_[50] * vX_[141] + vX_[191] * vX_[55];
    vX_[195] = vX_[55] * vX_[141] + vX_[141] * vX_[55];
    vX_[310] = vX_[49] * vX_[125] + vX_[63] * vX_[92];
    vX_[101] = vX_[64] * vX_[310] + vX_[310] * vX_[64];
    vX_[299] = vX_[68] * vX_[310] + vX_[70] * vX_[141];
    vX_[114] = vX_[67] * vX_[310] + vX_[68] * vX_[141];
    vX_[348] = vX_[69] * vX_[299] + vX_[114] * vX_[73];
    vX_[249] = vX_[76] * vX_[92] + vX_[77] * vX_[125] + vX_[49] * vX_[200] + vX_[78] * vX_[65];
    vX_[105] = vX_[67] * vX_[249] + vX_[80] * vX_[191] + vX_[68] * vX_[211];
    vX_[327] = vX_[75] * vX_[105] + vX_[191] * vX_[83];
    vX_[25] = 0.02075 * vX_[141] + -0.184 * vX_[310] + vX_[33];
    vX_[298] = vX_[69] * vX_[25] + vX_[114] * vX_[86];
    vX_[323] = vX_[69] * vX_[191] + vX_[114] * vX_[75];
    vX_[351] = vX_[73] * vX_[191] + vX_[299] * vX_[75];
    vX_[250] = vX_[73] * vX_[299] + vX_[299] * vX_[73];
    vX_[90] = vX_[69] * vX_[114] + vX_[114] * vX_[69];
    vX_[247] = -0.00751 * vX_[348] + 0.038686875 * (vX_[327] - vX_[298]) + -0.000829 * vX_[323] - 1.5e-05 * vX_[351] -
               0.000198 * (vX_[250] - vX_[90]);
    vX_[135] = 0 - vX_[247];
    vX_[84] = vX_[68] * vX_[249] + vX_[94] * vX_[191] + vX_[95] * vX_[211];
    vX_[345] = vX_[75] * vX_[191] + vX_[191] * vX_[75];
    vX_[25] = 1.547475 * (vX_[73] * vX_[25] + vX_[299] * vX_[86] - (vX_[75] * vX_[84] + vX_[191] * vX_[97])) +
              1.547475 * vX_[84] * x_in[11] - 0.038686875 * (vX_[345] + vX_[250]);
    vX_[313] = (-vX_[114]) * x_in[11];
    vX_[179] = vX_[299] * x_in[11];
    vX_[237] = (-vX_[105]) * x_in[11];
    vX_[298] = 0.038686875 * vX_[348] + -1.547475 * (vX_[298] - vX_[327]) + 0.00345708950900075 * vX_[313] +
               -6.25528861700981e-05 * vX_[179] + 1.38614328745655 * vX_[237] + (0.038686875 * vX_[135]) / 0.009277;
    vX_[327] = (-vX_[310]) * x_in[10];
    vX_[203] = vX_[191] * x_in[10];
    vX_[230] = vX_[33] * x_in[10];
    vX_[251] = (-vX_[249]) * x_in[10];
    vX_[120] = vX_[64] * vX_[141] + vX_[310] * vX_[55];
    vX_[301] = vX_[64] * vX_[191] + vX_[310] * vX_[50];
    vX_[84] = vX_[69] * vX_[84] + vX_[114] * vX_[97] - (vX_[73] * vX_[105] + vX_[299] * vX_[83]);
    vX_[90] = 0.000198 * vX_[351] + 1.5e-05 * (vX_[345] - vX_[90]) + 0.00315291990945349 * vX_[313] +
              0.000199340411771047 * vX_[179] + 0.00345708950900075 * vX_[237] + (-0.000829 * vX_[135]) / 0.009277 -
              0.038686875 * vX_[84] - -0.00146 * vX_[323] - -0.000829 * vX_[348];
    vX_[345] = 0.00605 * vX_[351] + 1.5e-05 * vX_[348] + 0.000199340411771047 * vX_[313] +
               0.0107369757464698 * vX_[179] + -6.25528861700981e-05 * vX_[237] + (1.5e-05 * vX_[135]) / 0.009277 -
               0.000198 * vX_[323] - -0.000829 * (vX_[345] - vX_[250]);
    vX_[84] = 0.038686875 * vX_[323] + 1.547475 * vX_[84] + -0.038686875 * vX_[313];
    vX_[323] = vX_[50] * vX_[191] + vX_[191] * vX_[50];
    vX_[250] = -0.001243 * vX_[120] + 0.009683 * vX_[301] + vX_[70] * vX_[90] + vX_[68] * vX_[345] + 0.02075 * vX_[84] -
               -0.012652 * vX_[102] - -0.001387 * (vX_[323] - vX_[101]);
    vX_[351] = 0 - vX_[250];
    vX_[247] = 0.057838 * vX_[368] + -0.001387 * vX_[102] + -0.012652 * (vX_[195] - vX_[101]) +
               (0.009277 * vX_[135]) / 0.009277 + vX_[247] + vX_[80] * vX_[25] + vX_[94] * vX_[298] +
               vX_[119] * vX_[327] + vX_[123] * vX_[203] + vX_[132] * vX_[230] + vX_[136] * vX_[251] +
               (vX_[108] * vX_[351]) / vX_[117] - -0.008386 * vX_[120] - -0.001243 * vX_[301];
    vX_[348] = vX_[64] * vX_[211] + vX_[310] * vX_[54] - (vX_[55] * vX_[249] + vX_[141] * vX_[82]);
    vX_[345] = -0.018069 * vX_[102] + 0.057838 * vX_[348] + -0.012652 * vX_[301] + vX_[68] * vX_[90] +
               vX_[67] * vX_[345] + -0.184 * vX_[84] + vX_[123] * vX_[327] + vX_[116] * vX_[203] + vX_[72] * vX_[230] +
               vX_[128] * vX_[251] + (vX_[122] * vX_[351]) / vX_[117] - -0.001387 * vX_[120] -
               -0.001243 * (vX_[195] - vX_[323]);
    vX_[120] = 0.057838 * vX_[120] + 2.1032 * vX_[368] + vX_[68] * vX_[298] + vX_[67] * vX_[25] + vX_[132] * vX_[327] +
               vX_[72] * vX_[203] + vX_[62] * vX_[230] + vX_[71] * vX_[251] + (vX_[130] * vX_[351]) / vX_[117];
    vX_[348] = 0.057838 * vX_[102] + -2.1032 * vX_[348] + vX_[84] + vX_[136] * vX_[327] + vX_[128] * vX_[203] +
               vX_[71] * vX_[230] + vX_[60] * vX_[251] + (vX_[134] * vX_[351]) / vX_[117];
    vX_[84] = (-vX_[141]) * x_in[9];
    vX_[102] = vX_[125] * x_in[9];
    vX_[368] = vX_[200] * x_in[9];
    vX_[90] = (-vX_[211]) * x_in[9];
    vX_[301] = vX_[37] * vX_[211] + vX_[92] * vX_[54];
    vX_[65] = vX_[45] * vX_[65] + vX_[141] * vX_[36];
    vX_[195] = vX_[45] * vX_[125] + vX_[141] * vX_[29];
    vX_[92] = vX_[45] * vX_[92] + vX_[141] * vX_[37];
    vX_[105] = vX_[29] * vX_[125] + vX_[125] * vX_[29];
    vX_[114] = 0.160298259823722 * (vX_[301] - vX_[65]) + -0.06337651 * vX_[195] + -0.0022920002 * vX_[92] +
               vX_[49] * vX_[247] + vX_[63] * vX_[345] + vX_[76] * vX_[120] + vX_[56] * vX_[348] -
               -0.008711861 * vX_[373] - -0.00021200017 * vX_[344] - 0.0036857284 * (vX_[105] - vX_[118]);
    vX_[299] = 0 - vX_[114];
    vX_[211] = vX_[45] * vX_[200] + vX_[141] * vX_[41] - (vX_[29] * vX_[211] + vX_[125] * vX_[54]);
    vX_[345] = 1.52322944854339e-09 * vX_[373] + 0.0036857284 * vX_[344] + -0.00021200017 * (vX_[81] - vX_[118]) +
               vX_[48] * vX_[247] + vX_[49] * vX_[345] + vX_[77] * vX_[120] + vX_[57] * vX_[348] + vX_[156] * vX_[84] +
               vX_[158] * vX_[102] + vX_[174] * vX_[368] + vX_[186] * vX_[90] + (vX_[152] * vX_[299]) / vX_[154] -
               0.160298259823722 * vX_[211] - 0.01404749 * vX_[92] - -0.0022920002 * vX_[195];
    vX_[250] = -0.008711861 * vX_[211] + 1.52322944854339e-09 * (vX_[65] - vX_[301]) + 0.077424 * vX_[344] +
               -0.00021200017 * vX_[195] + (vX_[117] * vX_[351]) / vX_[117] + vX_[250] + vX_[158] * vX_[84] +
               vX_[153] * vX_[102] + vX_[150] * vX_[368] + vX_[170] * vX_[90] + (-0.00021200017 * vX_[299]) / vX_[154] -
               0.0036857284 * vX_[92] - -0.0022920002 * (vX_[81] - vX_[105]);
    vX_[211] = 1.7423722 * vX_[211] + 0.160298259823722 * vX_[92] + -0.008711861 * vX_[344] + vX_[49] * vX_[348] +
               vX_[78] * vX_[120] + vX_[39] * vX_[84] + vX_[171] * vX_[102] + vX_[193] * vX_[368] + vX_[199] * vX_[90] +
               (vX_[169] * vX_[299]) / vX_[154] - 1.52322944854339e-09 * (vX_[105] + vX_[118]);
    vX_[247] = (-vX_[22]) * x_in[8];
    vX_[141] = vX_[11] * x_in[8];
    vX_[200] = vX_[15] * x_in[8];
    vX_[125] = (-vX_[34]) * x_in[8];
    vX_[140] = vX_[10] * vX_[34];
    vX_[147] = vX_[23] * vX_[11] + vX_[22] * vX_[18];
    vX_[111] = vX_[22] * vX_[10];
    vX_[151] = vX_[18] * vX_[11] + vX_[11] * vX_[18];
    vX_[165] = -0.0055615274403 * vX_[140] + 0.00750500000000001 * vX_[147] + -0.0037997814 * vX_[111] +
               vX_[28] * vX_[345] + vX_[26] * vX_[250] - 0.01438086 * vX_[220] - -0.011715295 * vX_[173] -
               5.399998e-05 * (vX_[151] - vX_[226]);
    vX_[316] = 0 - vX_[165];
    vX_[303] = vX_[23] * vX_[15] + vX_[22] * vX_[16] - (vX_[18] * vX_[34] + vX_[11] * vX_[35]);
    vX_[250] = 0.647967112 * vX_[220] + 5.399998e-05 * vX_[173] + -0.011715295 * (0 - vX_[226]) + vX_[26] * vX_[345] +
               vX_[27] * vX_[250] + -0.304 * vX_[211] + vX_[225] * vX_[247] + vX_[235] * vX_[141] +
               vX_[244] * vX_[200] + vX_[256] * vX_[125] + (vX_[221] * vX_[316]) / vX_[223] -
               -0.0055615274403 * vX_[303] - -0.192033951 * vX_[111] - -0.0037997814 * vX_[147];
    vX_[140] = -vX_[140];
    vX_[105] = 1.7423722 * vX_[373] + 1.52322944854339e-09 * vX_[92] + -0.008711861 * vX_[195] +
               2.1032 * (vX_[64] * vX_[33] + vX_[310] * vX_[59] - (vX_[50] * vX_[249] + vX_[191] * vX_[82])) +
               vX_[95] * vX_[298] + vX_[68] * vX_[25] + vX_[162] * vX_[327] + vX_[167] * vX_[203] +
               vX_[163] * vX_[230] + vX_[166] * vX_[251] + (vX_[160] * vX_[351]) / vX_[117] + vX_[174] * vX_[84] +
               vX_[150] * vX_[102] + vX_[204] * vX_[368] + vX_[206] * vX_[90] + (vX_[172] * vX_[299]) / vX_[154] -
               0.160298259823722 * (vX_[81] + vX_[105]) - 0.057838 * (vX_[323] + vX_[101]);
    vX_[195] = -1.7423722 * (vX_[65] - vX_[301]) + 0.160298259823722 * vX_[195] + 1.52322944854339e-09 * vX_[344] +
               vX_[48] * vX_[348] + vX_[49] * vX_[120] + vX_[186] * vX_[84] + vX_[170] * vX_[102] +
               vX_[206] * vX_[368] + vX_[202] * vX_[90] + (vX_[184] * vX_[299]) / vX_[154] -
               -0.008711861 * (vX_[81] + vX_[118]);
    vX_[303] = 0.01438086 * vX_[303] + 0.647967112 * vX_[140] + -0.199538951 * vX_[173] + -0.011715295 * vX_[147] +
               vX_[51] * vX_[105] + -1 * (vX_[114] + (vX_[154] * vX_[299]) / vX_[154]) + vX_[38] * vX_[195] +
               vX_[235] * vX_[247] + vX_[222] * vX_[141] + vX_[219] * vX_[200] + vX_[240] * vX_[125] +
               (vX_[234] * vX_[316]) / vX_[223] - 5.399998e-05 * vX_[111] - -0.0037997814 * (0 - vX_[151]);
    vX_[151] = 2.327 * vX_[220] + 0.647967112 * vX_[111] + 0.01438086 * vX_[147] + -1 * vX_[211] + vX_[244] * vX_[247] +
               vX_[219] * vX_[141] + vX_[88] * vX_[200] + vX_[85] * vX_[125] + (vX_[242] * vX_[316]) / vX_[223] -
               -0.0055615274403 * vX_[151];
    vX_[195] = -2.327 * vX_[140] + -0.0055615274403 * vX_[147] + 0.647967112 * vX_[173] + vX_[26] * vX_[195] +
               vX_[27] * vX_[105] + vX_[256] * vX_[247] + vX_[240] * vX_[141] + vX_[85] * vX_[200] +
               vX_[44] * vX_[125] + (vX_[254] * vX_[316]) / vX_[223] - 0.01438086 * vX_[226];
    vX_[105] = -0.022851627 * vX_[14] - -0.002752 * vX_[5] - vX_[11] * vX_[250] - vX_[22] * vX_[303] -
               vX_[34] * vX_[151] - vX_[15] * vX_[195];
    jac[90] = (0 -
                  vX_[0] * (0.0055279857 * vX_[14] + -0.022851627 * vX_[296] + vX_[9] * vX_[250] + vX_[11] * vX_[303] +
                               vX_[30] * vX_[151] + vX_[12] * vX_[195] + vX_[13] * vX_[329] + vX_[265] * vX_[14] +
                               (vX_[42] * vX_[105]) / vX_[24] - 0.012390532 * vX_[5]) -
                  vX_[4] * (-0.034462002 * vX_[14] + (vX_[223] * vX_[316]) / vX_[223] + vX_[165] + vX_[265] * vX_[329] +
                               vX_[98] * vX_[14] + (-0.022851627 * vX_[105]) / vX_[24] - 0.0055279857 * vX_[5] -
                               -0.002752 * vX_[296])) /
              vX_[385];
    vX_[329] = vX_[0] * jac[90] + vX_[329];
    vX_[14] = vX_[4] * jac[90] + vX_[14];
    jac[91] = (vX_[105] - vX_[42] * vX_[329] - -0.022851627 * vX_[14]) / vX_[24];
    vX_[247] = vX_[11] * jac[91] + vX_[9] * vX_[329] + vX_[247];
    vX_[141] = vX_[22] * jac[91] + vX_[11] * vX_[329] + vX_[141];
    vX_[125] = vX_[15] * jac[91] + vX_[12] * vX_[329] + vX_[125];
    vX_[329] = vX_[34] * jac[91] + vX_[30] * vX_[329] + vX_[200];
    jac[92] = (vX_[316] - vX_[223] * vX_[14] - vX_[221] * vX_[247] - vX_[234] * vX_[141] - vX_[254] * vX_[125] -
                  vX_[242] * vX_[329]) /
              vX_[223];
    vX_[316] = -1 * vX_[141];
    vX_[14] = vX_[14] + jac[92];
    vX_[84] = vX_[28] * vX_[14] + vX_[26] * vX_[247] + vX_[84];
    vX_[14] = vX_[26] * vX_[14] + vX_[27] * vX_[247] + vX_[102];
    vX_[329] = -0.304 * vX_[247] + -1 * vX_[329];
    vX_[90] = vX_[26] * vX_[125] + vX_[38] * vX_[141] + vX_[90];
    vX_[125] = vX_[27] * vX_[125] + vX_[51] * vX_[141] + vX_[368];
    jac[93] = (vX_[299] - vX_[154] * vX_[316] - vX_[152] * vX_[84] - -0.00021200017 * vX_[14] - vX_[169] * vX_[329] -
                  vX_[184] * vX_[90] - vX_[172] * vX_[125]) /
              vX_[154];
    vX_[316] = vX_[316] + jac[93];
    vX_[327] = vX_[49] * vX_[316] + vX_[48] * vX_[84] + vX_[327];
    vX_[203] = vX_[63] * vX_[316] + vX_[49] * vX_[84] + vX_[203];
    vX_[230] = vX_[76] * vX_[316] + vX_[77] * vX_[84] + vX_[49] * vX_[90] + vX_[78] * vX_[329] + vX_[230];
    jac[94] =
        (vX_[351] - vX_[117] * vX_[14] - vX_[108] * vX_[327] - vX_[122] * vX_[203] - vX_[160] * vX_[125] -
            vX_[134] * (vX_[56] * vX_[316] + vX_[57] * vX_[84] + vX_[48] * vX_[90] + vX_[49] * vX_[329] + vX_[251]) -
            vX_[130] * vX_[230]) /
        vX_[117];
    vX_[14] = vX_[14] + jac[94];
    jac[95] = (vX_[135] - 0.009277 * vX_[327] - -0.000829 * (vX_[70] * vX_[14] + vX_[68] * vX_[203] + vX_[313]) -
                  1.5e-05 * (vX_[68] * vX_[14] + vX_[67] * vX_[203] + vX_[179]) -
                  0.038686875 * (vX_[68] * vX_[230] + vX_[94] * vX_[327] + vX_[95] * vX_[125] + vX_[237])) /
              0.009277;
    vX_[14] = -vX_[16];
    vX_[10] = vX_[10] + vX_[10];
    vX_[230] = vX_[28] * vX_[36];
    vX_[203] = vX_[28] * vX_[37];
    vX_[327] = vX_[45] * vX_[26] + vX_[26] * vX_[45];
    vX_[125] = vX_[48] * vX_[28];
    vX_[237] = vX_[57] * vX_[28];
    vX_[179] = vX_[125] * vX_[54] - (vX_[55] * vX_[237] + vX_[26] * vX_[59]);
    vX_[313] = vX_[50] * vX_[26] + vX_[125] * vX_[55];
    vX_[135] = vX_[55] * vX_[26] + vX_[26] * vX_[55];
    vX_[316] = vX_[49] * vX_[28];
    vX_[90] = vX_[64] * vX_[316] + vX_[316] * vX_[64];
    vX_[329] = vX_[68] * vX_[316] + vX_[70] * vX_[26];
    vX_[84] = vX_[67] * vX_[316] + vX_[68] * vX_[26];
    vX_[351] = vX_[69] * vX_[329] + vX_[84] * vX_[73];
    vX_[251] = vX_[77] * vX_[28];
    vX_[299] = vX_[67] * vX_[251] + vX_[80] * vX_[125];
    vX_[141] = vX_[75] * vX_[299] + vX_[125] * vX_[83];
    vX_[368] = 0.02075 * vX_[26] + -0.184 * vX_[316] + vX_[237];
    vX_[247] = vX_[69] * vX_[368] + vX_[84] * vX_[86];
    vX_[102] = vX_[69] * vX_[125] + vX_[84] * vX_[75];
    vX_[200] = vX_[73] * vX_[125] + vX_[329] * vX_[75];
    vX_[105] = vX_[73] * vX_[329] + vX_[329] * vX_[73];
    vX_[195] = vX_[69] * vX_[84] + vX_[84] * vX_[69];
    vX_[151] = -0.00751 * vX_[351] + 0.038686875 * (vX_[141] - vX_[247]) + -0.000829 * vX_[102] - 1.5e-05 * vX_[200] -
               0.000198 * (vX_[105] - vX_[195]);
    vX_[303] = 0 - vX_[151];
    vX_[250] = vX_[68] * vX_[251] + vX_[94] * vX_[125];
    vX_[165] = vX_[75] * vX_[125] + vX_[125] * vX_[75];
    vX_[368] = 1.547475 * (vX_[73] * vX_[368] + vX_[329] * vX_[86] - (vX_[75] * vX_[250] + vX_[125] * vX_[97])) +
               1.547475 * vX_[250] * x_in[11] - 0.038686875 * (vX_[165] + vX_[105]);
    vX_[296] = (-vX_[84]) * x_in[11];
    vX_[98] = vX_[329] * x_in[11];
    vX_[265] = (-vX_[299]) * x_in[11];
    vX_[247] = 0.038686875 * vX_[351] + -1.547475 * (vX_[247] - vX_[141]) + 0.00345708950900075 * vX_[296] +
               -6.25528861700981e-05 * vX_[98] + 1.38614328745655 * vX_[265] + (0.038686875 * vX_[303]) / 0.009277;
    vX_[141] = (-vX_[316]) * x_in[10];
    vX_[13] = vX_[125] * x_in[10];
    vX_[5] = vX_[237] * x_in[10];
    vX_[140] = (-vX_[251]) * x_in[10];
    vX_[147] = vX_[64] * vX_[26] + vX_[316] * vX_[55];
    vX_[226] = vX_[64] * vX_[125] + vX_[316] * vX_[50];
    vX_[250] = vX_[69] * vX_[250] + vX_[84] * vX_[97] - (vX_[73] * vX_[299] + vX_[329] * vX_[83]);
    vX_[195] = 0.000198 * vX_[200] + 1.5e-05 * (vX_[165] - vX_[195]) + 0.00315291990945349 * vX_[296] +
               0.000199340411771047 * vX_[98] + 0.00345708950900075 * vX_[265] + (-0.000829 * vX_[303]) / 0.009277 -
               0.038686875 * vX_[250] - -0.00146 * vX_[102] - -0.000829 * vX_[351];
    vX_[165] = 0.00605 * vX_[200] + 1.5e-05 * vX_[351] + 0.000199340411771047 * vX_[296] +
               0.0107369757464698 * vX_[98] + -6.25528861700981e-05 * vX_[265] + (1.5e-05 * vX_[303]) / 0.009277 -
               0.000198 * vX_[102] - -0.000829 * (vX_[165] - vX_[105]);
    vX_[250] = 0.038686875 * vX_[102] + 1.547475 * vX_[250] + -0.038686875 * vX_[296];
    vX_[102] = vX_[50] * vX_[125] + vX_[125] * vX_[50];
    vX_[105] = -0.001243 * vX_[147] + 0.009683 * vX_[226] + vX_[70] * vX_[195] + vX_[68] * vX_[165] +
               0.02075 * vX_[250] - -0.012652 * vX_[313] - -0.001387 * (vX_[102] - vX_[90]);
    vX_[200] = 0 - vX_[105];
    vX_[151] = 0.057838 * vX_[179] + -0.001387 * vX_[313] + -0.012652 * (vX_[135] - vX_[90]) +
               (0.009277 * vX_[303]) / 0.009277 + vX_[151] + vX_[80] * vX_[368] + vX_[94] * vX_[247] +
               vX_[119] * vX_[141] + vX_[123] * vX_[13] + vX_[132] * vX_[5] + vX_[136] * vX_[140] +
               (vX_[108] * vX_[200]) / vX_[117] - -0.008386 * vX_[147] - -0.001243 * vX_[226];
    vX_[351] = vX_[316] * vX_[54] - (vX_[55] * vX_[251] + vX_[26] * vX_[82]);
    vX_[165] = -0.018069 * vX_[313] + 0.057838 * vX_[351] + -0.012652 * vX_[226] + vX_[68] * vX_[195] +
               vX_[67] * vX_[165] + -0.184 * vX_[250] + vX_[123] * vX_[141] + vX_[116] * vX_[13] + vX_[72] * vX_[5] +
               vX_[128] * vX_[140] + (vX_[122] * vX_[200]) / vX_[117] - -0.001387 * vX_[147] -
               -0.001243 * (vX_[135] - vX_[102]);
    vX_[147] = 0.057838 * vX_[147] + 2.1032 * vX_[179] + vX_[68] * vX_[247] + vX_[67] * vX_[368] + vX_[132] * vX_[141] +
               vX_[72] * vX_[13] + vX_[62] * vX_[5] + vX_[71] * vX_[140] + (vX_[130] * vX_[200]) / vX_[117];
    vX_[351] = 0.057838 * vX_[313] + -2.1032 * vX_[351] + vX_[250] + vX_[136] * vX_[141] + vX_[128] * vX_[13] +
               vX_[71] * vX_[5] + vX_[60] * vX_[140] + (vX_[134] * vX_[200]) / vX_[117];
    vX_[250] = (-vX_[26]) * x_in[9];
    vX_[313] = vX_[28] * x_in[9];
    vX_[36] = vX_[26] * vX_[36];
    vX_[179] = vX_[45] * vX_[28] + vX_[26] * vX_[29];
    vX_[195] = vX_[26] * vX_[37];
    vX_[226] = vX_[29] * vX_[28] + vX_[28] * vX_[29];
    vX_[135] = 0.160298259823722 * (0 - vX_[36]) + -0.06337651 * vX_[179] + -0.0022920002 * vX_[195] +
               vX_[49] * vX_[151] + vX_[63] * vX_[165] + vX_[76] * vX_[147] + vX_[56] * vX_[351] -
               -0.008711861 * vX_[230] - -0.00021200017 * vX_[203] - 0.0036857284 * (vX_[226] - vX_[327]);
    vX_[299] = 0 - vX_[135];
    vX_[84] = vX_[26] * vX_[41] - vX_[28] * vX_[54];
    vX_[165] = 1.52322944854339e-09 * vX_[230] + 0.0036857284 * vX_[203] + -0.00021200017 * (0 - vX_[327]) +
               vX_[48] * vX_[151] + vX_[49] * vX_[165] + vX_[77] * vX_[147] + vX_[57] * vX_[351] + vX_[156] * vX_[250] +
               vX_[158] * vX_[313] + (vX_[152] * vX_[299]) / vX_[154] - 0.160298259823722 * vX_[84] -
               0.01404749 * vX_[195] - -0.0022920002 * vX_[179];
    vX_[105] = -0.008711861 * vX_[84] + 1.52322944854339e-09 * vX_[36] + 0.077424 * vX_[203] +
               -0.00021200017 * vX_[179] + (vX_[117] * vX_[200]) / vX_[117] + vX_[105] + vX_[158] * vX_[250] +
               vX_[153] * vX_[313] + (-0.00021200017 * vX_[299]) / vX_[154] - 0.0036857284 * vX_[195] -
               -0.0022920002 * (0 - vX_[226]);
    vX_[84] = 1.7423722 * vX_[84] + 0.160298259823722 * vX_[195] + -0.008711861 * vX_[203] + vX_[49] * vX_[351] +
              vX_[78] * vX_[147] + vX_[39] * vX_[250] + vX_[171] * vX_[313] + (vX_[169] * vX_[299]) / vX_[154] -
              1.52322944854339e-09 * (vX_[226] + vX_[327]);
    vX_[151] = -0.0055615274403 * vX_[35] + -0.0037997814 * vX_[23] + vX_[28] * vX_[165] + vX_[26] * vX_[105] -
               0.01438086 * vX_[14] - -0.011715295 * vX_[18];
    vX_[329] = 0 - vX_[151];
    vX_[105] = 0.647967112 * vX_[14] + 5.399998e-05 * vX_[18] + -0.011715295 * vX_[10] + vX_[26] * vX_[165] +
               vX_[27] * vX_[105] + -0.304 * vX_[84] + vX_[225] * vX_[322] + vX_[235] * vX_[18] + vX_[244] * vX_[16] +
               vX_[256] * vX_[326] + (vX_[221] * vX_[329]) / vX_[223] - -0.192033951 * vX_[23];
    vX_[35] = -vX_[35];
    vX_[226] = 1.7423722 * vX_[230] + 1.52322944854339e-09 * vX_[195] + -0.008711861 * vX_[179] +
               2.1032 * (vX_[64] * vX_[237] + vX_[316] * vX_[59] - (vX_[50] * vX_[251] + vX_[125] * vX_[82])) +
               vX_[95] * vX_[247] + vX_[68] * vX_[368] + vX_[162] * vX_[141] + vX_[167] * vX_[13] + vX_[163] * vX_[5] +
               vX_[166] * vX_[140] + (vX_[160] * vX_[200]) / vX_[117] + vX_[174] * vX_[250] + vX_[150] * vX_[313] +
               (vX_[172] * vX_[299]) / vX_[154] - 0.160298259823722 * vX_[226] - 0.057838 * (vX_[102] + vX_[90]);
    vX_[179] = -1.7423722 * vX_[36] + 0.160298259823722 * vX_[179] + 1.52322944854339e-09 * vX_[203] +
               vX_[48] * vX_[351] + vX_[49] * vX_[147] + vX_[186] * vX_[250] + vX_[170] * vX_[313] +
               (vX_[184] * vX_[299]) / vX_[154] - -0.008711861 * vX_[327];
    vX_[135] = 0.647967112 * vX_[35] + -0.199538951 * vX_[18] + vX_[51] * vX_[226] +
               -1 * (vX_[135] + (vX_[154] * vX_[299]) / vX_[154]) + vX_[38] * vX_[179] + vX_[235] * vX_[322] +
               vX_[222] * vX_[18] + vX_[219] * vX_[16] + vX_[240] * vX_[326] + (vX_[234] * vX_[329]) / vX_[223] -
               5.399998e-05 * vX_[23] - -0.0037997814 * vX_[10];
    vX_[84] = 2.327 * vX_[14] + 0.647967112 * vX_[23] + -1 * vX_[84] + vX_[244] * vX_[322] + vX_[219] * vX_[18] +
              vX_[88] * vX_[16] + vX_[85] * vX_[326] + (vX_[242] * vX_[329]) / vX_[223] - -0.0055615274403 * vX_[10];
    vX_[179] = -2.327 * vX_[35] + 0.647967112 * vX_[18] + vX_[26] * vX_[179] + vX_[27] * vX_[226] +
               vX_[256] * vX_[322] + vX_[240] * vX_[18] + vX_[85] * vX_[16] + vX_[44] * vX_[326] +
               (vX_[254] * vX_[329]) / vX_[223] - 0.01438086 * vX_[10];
    vX_[226] = 0 - vX_[11] * vX_[105] - vX_[22] * vX_[135] - vX_[34] * vX_[84] - vX_[15] * vX_[179];
    jac[102] = (0 -
                   vX_[0] * (vX_[9] * vX_[105] + vX_[11] * vX_[135] + vX_[30] * vX_[84] + vX_[12] * vX_[179] +
                                (vX_[42] * vX_[226]) / vX_[24]) -
                   vX_[4] * ((vX_[223] * vX_[329]) / vX_[223] + vX_[151] + (-0.022851627 * vX_[226]) / vX_[24])) /
               vX_[385];
    vX_[179] = vX_[0] * jac[102];
    vX_[84] = vX_[4] * jac[102];
    jac[103] = (vX_[226] - vX_[42] * vX_[179] - -0.022851627 * vX_[84]) / vX_[24];
    vX_[322] = vX_[11] * jac[103] + vX_[9] * vX_[179] + vX_[322];
    vX_[18] = vX_[22] * jac[103] + vX_[11] * vX_[179] + vX_[18];
    vX_[326] = vX_[15] * jac[103] + vX_[12] * vX_[179] + vX_[326];
    vX_[179] = vX_[34] * jac[103] + vX_[30] * vX_[179] + vX_[16];
    jac[104] = (vX_[329] - vX_[223] * vX_[84] - vX_[221] * vX_[322] - vX_[234] * vX_[18] - vX_[254] * vX_[326] -
                   vX_[242] * vX_[179]) /
               vX_[223];
    vX_[329] = -1 * vX_[18];
    vX_[84] = vX_[84] + jac[104];
    vX_[250] = vX_[28] * vX_[84] + vX_[26] * vX_[322] + vX_[250];
    vX_[84] = vX_[26] * vX_[84] + vX_[27] * vX_[322] + vX_[313];
    vX_[179] = -0.304 * vX_[322] + -1 * vX_[179];
    vX_[322] = vX_[26] * vX_[326] + vX_[38] * vX_[18];
    vX_[326] = vX_[27] * vX_[326] + vX_[51] * vX_[18];
    jac[105] = (vX_[299] - vX_[154] * vX_[329] - vX_[152] * vX_[250] - -0.00021200017 * vX_[84] - vX_[169] * vX_[179] -
                   vX_[184] * vX_[322] - vX_[172] * vX_[326]) /
               vX_[154];
    vX_[329] = vX_[329] + jac[105];
    vX_[141] = vX_[49] * vX_[329] + vX_[48] * vX_[250] + vX_[141];
    vX_[13] = vX_[63] * vX_[329] + vX_[49] * vX_[250] + vX_[13];
    vX_[5] = vX_[76] * vX_[329] + vX_[77] * vX_[250] + vX_[49] * vX_[322] + vX_[78] * vX_[179] + vX_[5];
    jac[106] =
        (vX_[200] - vX_[117] * vX_[84] - vX_[108] * vX_[141] - vX_[122] * vX_[13] - vX_[160] * vX_[326] -
            vX_[134] * (vX_[56] * vX_[329] + vX_[57] * vX_[250] + vX_[48] * vX_[322] + vX_[49] * vX_[179] + vX_[140]) -
            vX_[130] * vX_[5]) /
        vX_[117];
    vX_[84] = vX_[84] + jac[106];
    jac[107] = (vX_[303] - 0.009277 * vX_[141] - -0.000829 * (vX_[70] * vX_[84] + vX_[68] * vX_[13] + vX_[296]) -
                   1.5e-05 * (vX_[68] * vX_[84] + vX_[67] * vX_[13] + vX_[98]) -
                   0.038686875 * (vX_[68] * vX_[5] + vX_[94] * vX_[141] + vX_[95] * vX_[326] + vX_[265])) /
               0.009277;
    vX_[84] = 0 - vX_[41];
    vX_[37] = vX_[37] + vX_[37];
    vX_[5] = vX_[49] * vX_[54] - vX_[55] * vX_[56];
    vX_[13] = vX_[49] * vX_[55];
    vX_[141] = vX_[64] * vX_[63] + vX_[63] * vX_[64];
    vX_[326] = vX_[68] * vX_[63];
    vX_[265] = vX_[67] * vX_[63];
    vX_[98] = vX_[69] * vX_[326] + vX_[265] * vX_[73];
    vX_[296] = vX_[67] * vX_[76] + vX_[80] * vX_[49];
    vX_[303] = vX_[75] * vX_[296] + vX_[49] * vX_[83];
    vX_[329] = -0.184 * vX_[63] + vX_[56];
    vX_[322] = vX_[69] * vX_[329] + vX_[265] * vX_[86];
    vX_[179] = vX_[69] * vX_[49] + vX_[265] * vX_[75];
    vX_[250] = vX_[73] * vX_[49] + vX_[326] * vX_[75];
    vX_[200] = vX_[73] * vX_[326] + vX_[326] * vX_[73];
    vX_[140] = vX_[69] * vX_[265] + vX_[265] * vX_[69];
    vX_[299] = -0.00751 * vX_[98] + 0.038686875 * (vX_[303] - vX_[322]) + -0.000829 * vX_[179] - 1.5e-05 * vX_[250] -
               0.000198 * (vX_[200] - vX_[140]);
    vX_[18] = 0 - vX_[299];
    vX_[313] = vX_[68] * vX_[76] + vX_[94] * vX_[49];
    vX_[16] = vX_[75] * vX_[49] + vX_[49] * vX_[75];
    vX_[329] = 1.547475 * (vX_[73] * vX_[329] + vX_[326] * vX_[86] - (vX_[75] * vX_[313] + vX_[49] * vX_[97])) +
               1.547475 * vX_[313] * x_in[11] - 0.038686875 * (vX_[16] + vX_[200]);
    vX_[226] = (-vX_[265]) * x_in[11];
    vX_[135] = vX_[326] * x_in[11];
    vX_[105] = (-vX_[296]) * x_in[11];
    vX_[322] = 0.038686875 * vX_[98] + -1.547475 * (vX_[322] - vX_[303]) + 0.00345708950900075 * vX_[226] +
               -6.25528861700981e-05 * vX_[135] + 1.38614328745655 * vX_[105] + (0.038686875 * vX_[18]) / 0.009277;
    vX_[303] = (-vX_[63]) * x_in[10];
    vX_[151] = vX_[49] * x_in[10];
    vX_[35] = vX_[56] * x_in[10];
    vX_[10] = (-vX_[76]) * x_in[10];
    vX_[44] = vX_[63] * vX_[55];
    vX_[85] = vX_[64] * vX_[49] + vX_[63] * vX_[50];
    vX_[313] = vX_[69] * vX_[313] + vX_[265] * vX_[97] - (vX_[73] * vX_[296] + vX_[326] * vX_[83]);
    vX_[140] = 0.000198 * vX_[250] + 1.5e-05 * (vX_[16] - vX_[140]) + 0.00315291990945349 * vX_[226] +
               0.000199340411771047 * vX_[135] + 0.00345708950900075 * vX_[105] + (-0.000829 * vX_[18]) / 0.009277 -
               0.038686875 * vX_[313] - -0.00146 * vX_[179] - -0.000829 * vX_[98];
    vX_[16] = 0.00605 * vX_[250] + 1.5e-05 * vX_[98] + 0.000199340411771047 * vX_[226] + 0.0107369757464698 * vX_[135] +
              -6.25528861700981e-05 * vX_[105] + (1.5e-05 * vX_[18]) / 0.009277 - 0.000198 * vX_[179] -
              -0.000829 * (vX_[16] - vX_[200]);
    vX_[313] = 0.038686875 * vX_[179] + 1.547475 * vX_[313] + -0.038686875 * vX_[226];
    vX_[179] = vX_[50] * vX_[49] + vX_[49] * vX_[50];
    vX_[200] = -0.001243 * vX_[44] + 0.009683 * vX_[85] + vX_[70] * vX_[140] + vX_[68] * vX_[16] + 0.02075 * vX_[313] -
               -0.012652 * vX_[13] - -0.001387 * (vX_[179] - vX_[141]);
    vX_[250] = 0 - vX_[200];
    vX_[299] = 0.057838 * vX_[5] + -0.001387 * vX_[13] + -0.012652 * (0 - vX_[141]) + (0.009277 * vX_[18]) / 0.009277 +
               vX_[299] + vX_[80] * vX_[329] + vX_[94] * vX_[322] + vX_[119] * vX_[303] + vX_[123] * vX_[151] +
               vX_[132] * vX_[35] + vX_[136] * vX_[10] + (vX_[108] * vX_[250]) / vX_[117] - -0.008386 * vX_[44] -
               -0.001243 * vX_[85];
    vX_[98] = vX_[63] * vX_[54] - vX_[55] * vX_[76];
    vX_[16] = -0.018069 * vX_[13] + 0.057838 * vX_[98] + -0.012652 * vX_[85] + vX_[68] * vX_[140] + vX_[67] * vX_[16] +
              -0.184 * vX_[313] + vX_[123] * vX_[303] + vX_[116] * vX_[151] + vX_[72] * vX_[35] + vX_[128] * vX_[10] +
              (vX_[122] * vX_[250]) / vX_[117] - -0.001387 * vX_[44] - -0.001243 * (0 - vX_[179]);
    vX_[44] = 0.057838 * vX_[44] + 2.1032 * vX_[5] + vX_[68] * vX_[322] + vX_[67] * vX_[329] + vX_[132] * vX_[303] +
              vX_[72] * vX_[151] + vX_[62] * vX_[35] + vX_[71] * vX_[10] + (vX_[130] * vX_[250]) / vX_[117];
    vX_[98] = 0.057838 * vX_[13] + -2.1032 * vX_[98] + vX_[313] + vX_[136] * vX_[303] + vX_[128] * vX_[151] +
              vX_[71] * vX_[35] + vX_[60] * vX_[10] + (vX_[134] * vX_[250]) / vX_[117];
    vX_[313] = 0.160298259823722 * vX_[54] + -0.0022920002 * vX_[45] + vX_[49] * vX_[299] + vX_[63] * vX_[16] +
               vX_[76] * vX_[44] + vX_[56] * vX_[98] - -0.008711861 * vX_[84] - -0.00021200017 * vX_[29];
    vX_[13] = 0 - vX_[313];
    vX_[16] = 1.52322944854339e-09 * vX_[84] + 0.0036857284 * vX_[29] + -0.00021200017 * vX_[37] + vX_[48] * vX_[299] +
              vX_[49] * vX_[16] + vX_[77] * vX_[44] + vX_[57] * vX_[98] + vX_[156] * vX_[306] + vX_[158] * vX_[29] +
              vX_[174] * vX_[41] + vX_[186] * vX_[307] + (vX_[152] * vX_[13]) / vX_[154] - 0.01404749 * vX_[45];
    vX_[200] = 1.52322944854339e-09 * (0 - vX_[54]) + 0.077424 * vX_[29] + (vX_[117] * vX_[250]) / vX_[117] + vX_[200] +
               vX_[158] * vX_[306] + vX_[153] * vX_[29] + vX_[150] * vX_[41] + vX_[170] * vX_[307] +
               (-0.00021200017 * vX_[13]) / vX_[154] - 0.0036857284 * vX_[45] - -0.0022920002 * vX_[37];
    vX_[199] = 0.160298259823722 * vX_[45] + -0.008711861 * vX_[29] + vX_[49] * vX_[98] + vX_[78] * vX_[44] +
               vX_[39] * vX_[306] + vX_[171] * vX_[29] + vX_[193] * vX_[41] + vX_[199] * vX_[307] +
               (vX_[169] * vX_[13]) / vX_[154];
    vX_[193] = vX_[28] * vX_[16] + vX_[26] * vX_[200];
    vX_[171] = 0 - vX_[193];
    vX_[200] = vX_[26] * vX_[16] + vX_[27] * vX_[200] + -0.304 * vX_[199] + (vX_[221] * vX_[171]) / vX_[223];
    vX_[179] = 1.7423722 * vX_[84] + 1.52322944854339e-09 * vX_[45] +
               2.1032 * (vX_[64] * vX_[56] + vX_[63] * vX_[59] - (vX_[50] * vX_[76] + vX_[49] * vX_[82])) +
               vX_[95] * vX_[322] + vX_[68] * vX_[329] + vX_[162] * vX_[303] + vX_[167] * vX_[151] +
               vX_[163] * vX_[35] + vX_[166] * vX_[10] + (vX_[160] * vX_[250]) / vX_[117] + vX_[174] * vX_[306] +
               vX_[150] * vX_[29] + vX_[204] * vX_[41] + vX_[206] * vX_[307] + (vX_[172] * vX_[13]) / vX_[154] -
               0.160298259823722 * vX_[37] - 0.057838 * (vX_[179] + vX_[141]);
    vX_[98] = -1.7423722 * (0 - vX_[54]) + 1.52322944854339e-09 * vX_[29] + vX_[48] * vX_[98] + vX_[49] * vX_[44] +
              vX_[186] * vX_[306] + vX_[170] * vX_[29] + vX_[206] * vX_[41] + vX_[202] * vX_[307] +
              (vX_[184] * vX_[13]) / vX_[154] - -0.008711861 * vX_[37];
    vX_[313] = vX_[51] * vX_[179] + -1 * (vX_[313] + (vX_[154] * vX_[13]) / vX_[154]) + vX_[38] * vX_[98] +
               (vX_[234] * vX_[171]) / vX_[223];
    vX_[199] = -1 * vX_[199] + (vX_[242] * vX_[171]) / vX_[223];
    vX_[98] = vX_[26] * vX_[98] + vX_[27] * vX_[179] + (vX_[254] * vX_[171]) / vX_[223];
    vX_[179] = 0 - vX_[11] * vX_[200] - vX_[22] * vX_[313] - vX_[34] * vX_[199] - vX_[15] * vX_[98];
    jac[114] = (0 -
                   vX_[0] * (vX_[9] * vX_[200] + vX_[11] * vX_[313] + vX_[30] * vX_[199] + vX_[12] * vX_[98] +
                                (vX_[42] * vX_[179]) / vX_[24]) -
                   vX_[4] * ((vX_[223] * vX_[171]) / vX_[223] + vX_[193] + (-0.022851627 * vX_[179]) / vX_[24])) /
               vX_[385];
    vX_[98] = vX_[0] * jac[114];
    vX_[199] = vX_[4] * jac[114];
    jac[115] = (vX_[179] - vX_[42] * vX_[98] - -0.022851627 * vX_[199]) / vX_[24];
    vX_[179] = vX_[11] * jac[115] + vX_[9] * vX_[98];
    vX_[313] = vX_[22] * jac[115] + vX_[11] * vX_[98];
    vX_[200] = vX_[15] * jac[115] + vX_[12] * vX_[98];
    vX_[98] = vX_[34] * jac[115] + vX_[30] * vX_[98];
    jac[116] = (vX_[171] - vX_[223] * vX_[199] - vX_[221] * vX_[179] - vX_[234] * vX_[313] - vX_[254] * vX_[200] -
                   vX_[242] * vX_[98]) /
               vX_[223];
    vX_[171] = -1 * vX_[313];
    vX_[199] = vX_[199] + jac[116];
    vX_[306] = vX_[28] * vX_[199] + vX_[26] * vX_[179] + vX_[306];
    vX_[199] = vX_[26] * vX_[199] + vX_[27] * vX_[179] + vX_[29];
    vX_[98] = -0.304 * vX_[179] + -1 * vX_[98];
    vX_[307] = vX_[26] * vX_[200] + vX_[38] * vX_[313] + vX_[307];
    vX_[200] = vX_[27] * vX_[200] + vX_[51] * vX_[313] + vX_[41];
    jac[117] = (vX_[13] - vX_[154] * vX_[171] - vX_[152] * vX_[306] - -0.00021200017 * vX_[199] - vX_[169] * vX_[98] -
                   vX_[184] * vX_[307] - vX_[172] * vX_[200]) /
               vX_[154];
    vX_[171] = vX_[171] + jac[117];
    vX_[303] = vX_[49] * vX_[171] + vX_[48] * vX_[306] + vX_[303];
    vX_[151] = vX_[63] * vX_[171] + vX_[49] * vX_[306] + vX_[151];
    vX_[35] = vX_[76] * vX_[171] + vX_[77] * vX_[306] + vX_[49] * vX_[307] + vX_[78] * vX_[98] + vX_[35];
    jac[118] =
        (vX_[250] - vX_[117] * vX_[199] - vX_[108] * vX_[303] - vX_[122] * vX_[151] - vX_[160] * vX_[200] -
            vX_[134] * (vX_[56] * vX_[171] + vX_[57] * vX_[306] + vX_[48] * vX_[307] + vX_[49] * vX_[98] + vX_[10]) -
            vX_[130] * vX_[35]) /
        vX_[117];
    vX_[199] = vX_[199] + jac[118];
    jac[119] = (vX_[18] - 0.009277 * vX_[303] - -0.000829 * (vX_[70] * vX_[199] + vX_[68] * vX_[151] + vX_[226]) -
                   1.5e-05 * (vX_[68] * vX_[199] + vX_[67] * vX_[151] + vX_[135]) -
                   0.038686875 * (vX_[68] * vX_[35] + vX_[94] * vX_[303] + vX_[95] * vX_[200] + vX_[105])) /
               0.009277;
    vX_[199] = 0 - vX_[59];
    vX_[55] = vX_[55] + vX_[55];
    vX_[35] = vX_[69] * vX_[70] + vX_[68] * vX_[73];
    vX_[151] = vX_[69] * 0.02075 + vX_[68] * vX_[86];
    vX_[303] = vX_[68] * vX_[75];
    vX_[200] = vX_[70] * vX_[75];
    vX_[105] = vX_[73] * vX_[70] + vX_[70] * vX_[73];
    vX_[135] = vX_[69] * vX_[68] + vX_[68] * vX_[69];
    vX_[226] = -0.00751 * vX_[35] + 0.038686875 * (0 - vX_[151]) + -0.000829 * vX_[303] - 1.5e-05 * vX_[200] -
               0.000198 * (vX_[105] - vX_[135]);
    vX_[18] = 0 - vX_[226];
    vX_[86] = 1.547475 * (vX_[73] * 0.02075 + vX_[70] * vX_[86]) - 0.038686875 * vX_[105];
    vX_[171] = (-vX_[68]) * x_in[11];
    vX_[307] = vX_[70] * x_in[11];
    vX_[151] = 0.038686875 * vX_[35] + -1.547475 * vX_[151] + 0.00345708950900075 * vX_[171] +
               -6.25528861700981e-05 * vX_[307] + (0.038686875 * vX_[18]) / 0.009277;
    vX_[98] = vX_[68] * vX_[97] - vX_[70] * vX_[83];
    vX_[135] = 0.000198 * vX_[200] + 1.5e-05 * (0 - vX_[135]) + 0.00315291990945349 * vX_[171] +
               0.000199340411771047 * vX_[307] + (-0.000829 * vX_[18]) / 0.009277 - 0.038686875 * vX_[98] -
               -0.00146 * vX_[303] - -0.000829 * vX_[35];
    vX_[105] = 0.00605 * vX_[200] + 1.5e-05 * vX_[35] + 0.000199340411771047 * vX_[171] +
               0.0107369757464698 * vX_[307] + (1.5e-05 * vX_[18]) / 0.009277 - 0.000198 * vX_[303] -
               -0.000829 * (0 - vX_[105]);
    vX_[98] = 0.038686875 * vX_[303] + 1.547475 * vX_[98] + -0.038686875 * vX_[171];
    vX_[303] = -0.001243 * vX_[64] + vX_[70] * vX_[135] + vX_[68] * vX_[105] + 0.02075 * vX_[98] - -0.012652 * vX_[50];
    vX_[200] = 0 - vX_[303];
    vX_[226] = 0.057838 * vX_[199] + -0.001387 * vX_[50] + -0.012652 * vX_[55] + (0.009277 * vX_[18]) / 0.009277 +
               vX_[226] + vX_[80] * vX_[86] + vX_[94] * vX_[151] + vX_[119] * vX_[284] + vX_[123] * vX_[50] +
               vX_[132] * vX_[59] + vX_[136] * vX_[302] + (vX_[108] * vX_[200]) / vX_[117] - -0.008386 * vX_[64];
    vX_[82] = 0 - vX_[82];
    vX_[105] = -0.018069 * vX_[50] + 0.057838 * vX_[82] + vX_[68] * vX_[135] + vX_[67] * vX_[105] + -0.184 * vX_[98] +
               vX_[123] * vX_[284] + vX_[116] * vX_[50] + vX_[72] * vX_[59] + vX_[128] * vX_[302] +
               (vX_[122] * vX_[200]) / vX_[117] - -0.001387 * vX_[64] - -0.001243 * vX_[55];
    vX_[199] = 0.057838 * vX_[64] + 2.1032 * vX_[199] + vX_[68] * vX_[151] + vX_[67] * vX_[86] + vX_[132] * vX_[284] +
               vX_[72] * vX_[50] + vX_[62] * vX_[59] + vX_[71] * vX_[302] + (vX_[130] * vX_[200]) / vX_[117];
    vX_[82] = 0.057838 * vX_[50] + -2.1032 * vX_[82] + vX_[98] + vX_[136] * vX_[284] + vX_[128] * vX_[50] +
              vX_[71] * vX_[59] + vX_[60] * vX_[302] + (vX_[134] * vX_[200]) / vX_[117];
    vX_[98] = vX_[49] * vX_[226] + vX_[63] * vX_[105] + vX_[76] * vX_[199] + vX_[56] * vX_[82];
    vX_[60] = 0 - vX_[98];
    vX_[105] = vX_[48] * vX_[226] + vX_[49] * vX_[105] + vX_[77] * vX_[199] + vX_[57] * vX_[82] +
               (vX_[152] * vX_[60]) / vX_[154];
    vX_[303] = (vX_[117] * vX_[200]) / vX_[117] + vX_[303] + (-0.00021200017 * vX_[60]) / vX_[154];
    vX_[226] = vX_[49] * vX_[82] + vX_[78] * vX_[199] + (vX_[169] * vX_[60]) / vX_[154];
    vX_[71] = vX_[28] * vX_[105] + vX_[26] * vX_[303];
    vX_[128] = 0 - vX_[71];
    vX_[303] = vX_[26] * vX_[105] + vX_[27] * vX_[303] + -0.304 * vX_[226] + (vX_[221] * vX_[128]) / vX_[223];
    vX_[151] = vX_[95] * vX_[151] + vX_[68] * vX_[86] + vX_[162] * vX_[284] + vX_[167] * vX_[50] + vX_[163] * vX_[59] +
               vX_[166] * vX_[302] + (vX_[160] * vX_[200]) / vX_[117] + (vX_[172] * vX_[60]) / vX_[154];
    vX_[82] = vX_[48] * vX_[82] + vX_[49] * vX_[199] + (vX_[184] * vX_[60]) / vX_[154];
    vX_[98] = vX_[51] * vX_[151] + -1 * (vX_[98] + (vX_[154] * vX_[60]) / vX_[154]) + vX_[38] * vX_[82] +
              (vX_[234] * vX_[128]) / vX_[223];
    vX_[226] = -1 * vX_[226] + (vX_[242] * vX_[128]) / vX_[223];
    vX_[82] = vX_[26] * vX_[82] + vX_[27] * vX_[151] + (vX_[254] * vX_[128]) / vX_[223];
    vX_[151] = 0 - vX_[11] * vX_[303] - vX_[22] * vX_[98] - vX_[34] * vX_[226] - vX_[15] * vX_[82];
    jac[126] = (0 -
                   vX_[0] * (vX_[9] * vX_[303] + vX_[11] * vX_[98] + vX_[30] * vX_[226] + vX_[12] * vX_[82] +
                                (vX_[42] * vX_[151]) / vX_[24]) -
                   vX_[4] * ((vX_[223] * vX_[128]) / vX_[223] + vX_[71] + (-0.022851627 * vX_[151]) / vX_[24])) /
               vX_[385];
    vX_[82] = vX_[0] * jac[126];
    vX_[226] = vX_[4] * jac[126];
    jac[127] = (vX_[151] - vX_[42] * vX_[82] - -0.022851627 * vX_[226]) / vX_[24];
    vX_[151] = vX_[11] * jac[127] + vX_[9] * vX_[82];
    vX_[98] = vX_[22] * jac[127] + vX_[11] * vX_[82];
    vX_[303] = vX_[15] * jac[127] + vX_[12] * vX_[82];
    vX_[82] = vX_[34] * jac[127] + vX_[30] * vX_[82];
    jac[128] = (vX_[128] - vX_[223] * vX_[226] - vX_[221] * vX_[151] - vX_[234] * vX_[98] - vX_[254] * vX_[303] -
                   vX_[242] * vX_[82]) /
               vX_[223];
    vX_[128] = -1 * vX_[98];
    vX_[226] = vX_[226] + jac[128];
    vX_[71] = vX_[28] * vX_[226] + vX_[26] * vX_[151];
    vX_[226] = vX_[26] * vX_[226] + vX_[27] * vX_[151];
    vX_[82] = -0.304 * vX_[151] + -1 * vX_[82];
    vX_[151] = vX_[26] * vX_[303] + vX_[38] * vX_[98];
    vX_[303] = vX_[27] * vX_[303] + vX_[51] * vX_[98];
    jac[129] = (vX_[60] - vX_[154] * vX_[128] - vX_[152] * vX_[71] - -0.00021200017 * vX_[226] - vX_[169] * vX_[82] -
                   vX_[184] * vX_[151] - vX_[172] * vX_[303]) /
               vX_[154];
    vX_[128] = vX_[128] + jac[129];
    vX_[284] = vX_[49] * vX_[128] + vX_[48] * vX_[71] + vX_[284];
    vX_[50] = vX_[63] * vX_[128] + vX_[49] * vX_[71] + vX_[50];
    vX_[59] = vX_[76] * vX_[128] + vX_[77] * vX_[71] + vX_[49] * vX_[151] + vX_[78] * vX_[82] + vX_[59];
    jac[130] =
        (vX_[200] - vX_[117] * vX_[226] - vX_[108] * vX_[284] - vX_[122] * vX_[50] - vX_[160] * vX_[303] -
            vX_[134] * (vX_[56] * vX_[128] + vX_[57] * vX_[71] + vX_[48] * vX_[151] + vX_[49] * vX_[82] + vX_[302]) -
            vX_[130] * vX_[59]) /
        vX_[117];
    vX_[226] = vX_[226] + jac[130];
    jac[131] = (vX_[18] - 0.009277 * vX_[284] - -0.000829 * (vX_[70] * vX_[226] + vX_[68] * vX_[50] + vX_[171]) -
                   1.5e-05 * (vX_[68] * vX_[226] + vX_[67] * vX_[50] + vX_[307]) -
                   0.038686875 * (vX_[68] * vX_[59] + vX_[94] * vX_[284] + vX_[95] * vX_[303])) /
               0.009277;
    vX_[226] = 0.038686875 * vX_[83] + -0.000829 * vX_[69] - 1.5e-05 * vX_[73];
    vX_[59] = 0 - vX_[226];
    vX_[75] = vX_[75] + vX_[75];
    vX_[97] = 1.547475 * (0 - vX_[97]) + 1.547475 * vX_[97] - 0.038686875 * vX_[75];
    vX_[83] = -1.547475 * (0 - vX_[83]) + 0.00345708950900075 * vX_[294] + -6.25528861700981e-05 * vX_[73] +
              1.38614328745655 * vX_[297] + (0.038686875 * vX_[59]) / 0.009277;
    vX_[50] = 0.000198 * vX_[73] + 1.5e-05 * vX_[75] + 0.00315291990945349 * vX_[294] + 0.000199340411771047 * vX_[73] +
              0.00345708950900075 * vX_[297] + (-0.000829 * vX_[59]) / 0.009277 - -0.00146 * vX_[69];
    vX_[75] = 0.00605 * vX_[73] + 0.000199340411771047 * vX_[294] + 0.0107369757464698 * vX_[73] +
              -6.25528861700981e-05 * vX_[297] + (1.5e-05 * vX_[59]) / 0.009277 - 0.000198 * vX_[69] -
              -0.000829 * vX_[75];
    vX_[69] = 0.038686875 * vX_[69] + -0.038686875 * vX_[294];
    vX_[284] = vX_[70] * vX_[50] + vX_[68] * vX_[75] + 0.02075 * vX_[69];
    vX_[303] = 0 - vX_[284];
    vX_[226] = (0.009277 * vX_[59]) / 0.009277 + vX_[226] + vX_[80] * vX_[97] + vX_[94] * vX_[83] +
               (vX_[108] * vX_[303]) / vX_[117];
    vX_[75] = vX_[68] * vX_[50] + vX_[67] * vX_[75] + -0.184 * vX_[69] + (vX_[122] * vX_[303]) / vX_[117];
    vX_[50] = vX_[68] * vX_[83] + vX_[67] * vX_[97] + (vX_[130] * vX_[303]) / vX_[117];
    vX_[69] = vX_[69] + (vX_[134] * vX_[303]) / vX_[117];
    vX_[80] = vX_[49] * vX_[226] + vX_[63] * vX_[75] + vX_[76] * vX_[50] + vX_[56] * vX_[69];
    vX_[307] = 0 - vX_[80];
    vX_[75] = vX_[48] * vX_[226] + vX_[49] * vX_[75] + vX_[77] * vX_[50] + vX_[57] * vX_[69] +
              (vX_[152] * vX_[307]) / vX_[154];
    vX_[284] = (vX_[117] * vX_[303]) / vX_[117] + vX_[284] + (-0.00021200017 * vX_[307]) / vX_[154];
    vX_[226] = vX_[49] * vX_[69] + vX_[78] * vX_[50] + (vX_[169] * vX_[307]) / vX_[154];
    vX_[171] = vX_[28] * vX_[75] + vX_[26] * vX_[284];
    vX_[18] = 0 - vX_[171];
    vX_[284] = vX_[26] * vX_[75] + vX_[27] * vX_[284] + -0.304 * vX_[226] + (vX_[221] * vX_[18]) / vX_[223];
    vX_[83] =
        vX_[95] * vX_[83] + vX_[68] * vX_[97] + (vX_[160] * vX_[303]) / vX_[117] + (vX_[172] * vX_[307]) / vX_[154];
    vX_[69] = vX_[48] * vX_[69] + vX_[49] * vX_[50] + (vX_[184] * vX_[307]) / vX_[154];
    vX_[80] = vX_[51] * vX_[83] + -1 * (vX_[80] + (vX_[154] * vX_[307]) / vX_[154]) + vX_[38] * vX_[69] +
              (vX_[234] * vX_[18]) / vX_[223];
    vX_[226] = -1 * vX_[226] + (vX_[242] * vX_[18]) / vX_[223];
    vX_[69] = vX_[26] * vX_[69] + vX_[27] * vX_[83] + (vX_[254] * vX_[18]) / vX_[223];
    vX_[83] = 0 - vX_[11] * vX_[284] - vX_[22] * vX_[80] - vX_[34] * vX_[226] - vX_[15] * vX_[69];
    jac[138] = (0 -
                   vX_[0] * (vX_[9] * vX_[284] + vX_[11] * vX_[80] + vX_[30] * vX_[226] + vX_[12] * vX_[69] +
                                (vX_[42] * vX_[83]) / vX_[24]) -
                   vX_[4] * ((vX_[223] * vX_[18]) / vX_[223] + vX_[171] + (-0.022851627 * vX_[83]) / vX_[24])) /
               vX_[385];
    vX_[0] = vX_[0] * jac[138];
    vX_[4] = vX_[4] * jac[138];
    jac[139] = (vX_[83] - vX_[42] * vX_[0] - -0.022851627 * vX_[4]) / vX_[24];
    vX_[9] = vX_[11] * jac[139] + vX_[9] * vX_[0];
    vX_[22] = vX_[22] * jac[139] + vX_[11] * vX_[0];
    vX_[15] = vX_[15] * jac[139] + vX_[12] * vX_[0];
    vX_[0] = vX_[34] * jac[139] + vX_[30] * vX_[0];
    jac[140] = (vX_[18] - vX_[223] * vX_[4] - vX_[221] * vX_[9] - vX_[234] * vX_[22] - vX_[254] * vX_[15] -
                   vX_[242] * vX_[0]) /
               vX_[223];
    vX_[18] = -1 * vX_[22];
    vX_[4] = vX_[4] + jac[140];
    vX_[28] = vX_[28] * vX_[4] + vX_[26] * vX_[9];
    vX_[4] = vX_[26] * vX_[4] + vX_[27] * vX_[9];
    vX_[0] = -0.304 * vX_[9] + -1 * vX_[0];
    vX_[38] = vX_[26] * vX_[15] + vX_[38] * vX_[22];
    vX_[15] = vX_[27] * vX_[15] + vX_[51] * vX_[22];
    jac[141] = (vX_[307] - vX_[154] * vX_[18] - vX_[152] * vX_[28] - -0.00021200017 * vX_[4] - vX_[169] * vX_[0] -
                   vX_[184] * vX_[38] - vX_[172] * vX_[15]) /
               vX_[154];
    vX_[18] = vX_[18] + jac[141];
    vX_[307] = vX_[49] * vX_[18] + vX_[48] * vX_[28];
    vX_[63] = vX_[63] * vX_[18] + vX_[49] * vX_[28];
    vX_[78] = vX_[76] * vX_[18] + vX_[77] * vX_[28] + vX_[49] * vX_[38] + vX_[78] * vX_[0];
    jac[142] = (vX_[303] - vX_[117] * vX_[4] - vX_[108] * vX_[307] - vX_[122] * vX_[63] - vX_[160] * vX_[15] -
                   vX_[134] * (vX_[56] * vX_[18] + vX_[57] * vX_[28] + vX_[48] * vX_[38] + vX_[49] * vX_[0]) -
                   vX_[130] * vX_[78]) /
               vX_[117];
    vX_[4] = vX_[4] + jac[142];
    jac[143] = (vX_[59] - 0.009277 * vX_[307] - -0.000829 * (vX_[70] * vX_[4] + vX_[68] * vX_[63] + vX_[294]) -
                   1.5e-05 * (vX_[68] * vX_[4] + vX_[67] * vX_[63] + vX_[73]) -
                   0.038686875 * (vX_[68] * vX_[78] + vX_[94] * vX_[307] + vX_[95] * vX_[15] + vX_[297])) /
               0.009277;
    // dependent variables without operations
    jac[72] = 1;
    jac[85] = 1;
    jac[98] = 1;
    jac[111] = 1;
    jac[124] = 1;
    jac[137] = 1;


    return dFdx_;
}

template <typename SCALAR>
const typename HyALinearizedForward<SCALAR>::state_control_matrix_t& HyALinearizedForward<SCALAR>::getDerivativeControl(
    const ct::core::StateVector<12, SCALAR>& x,
    const ct::core::ControlVector<6, SCALAR>& u,
    const SCALAR t)
{
    SCALAR* jac = dFdu_.data();
    Eigen::Matrix<SCALAR, 12 + 6, 1> x_in;
    x_in << x, u;

    vU_[0] = sin(x_in[1]);
    vU_[1] = cos(x_in[2]);
    vU_[2] = 0 - vU_[1];
    vU_[3] = sin(x_in[3]);
    vU_[4] = -0.304 * vU_[3];
    vU_[5] = -1 * vU_[4];
    vU_[6] = cos(x_in[4]);
    vU_[7] = 0 - vU_[6];
    vU_[8] = cos(x_in[5]);
    vU_[9] = sin(x_in[5]);
    vU_[10] = 0 - vU_[9];
    vU_[11] = -6.25528861700981e-05 * vU_[8] + 0.00345708950900075 * vU_[10];
    vU_[12] = vU_[11] * vU_[8];
    vU_[13] = -0.184 * vU_[8] + 0.02075 * vU_[10];
    vU_[14] = 1.547475 * vU_[13];
    vU_[15] = -0.038686875 + vU_[14];
    vU_[16] = 0 - vU_[15];
    vU_[17] = 0.184 * vU_[9] - 0.02075 * vU_[8];
    vU_[18] = 0 - 1.547475 * vU_[17];
    vU_[19] = vU_[9] * vU_[16] + vU_[8] * vU_[18];
    vU_[20] = 1.547475 * vU_[17];
    vU_[21] = 0 - 1.38614328745655 * vU_[13];
    vU_[22] = vU_[20] * vU_[17] - vU_[21] * vU_[13];
    vU_[23] = 0.0107369757464698 - vU_[18] * vU_[17] - vU_[22];
    vU_[17] = 0.000199340411771047 + vU_[18] * vU_[13] - -0.038686875 * vU_[17];
    vU_[24] = vU_[8] * vU_[23] + vU_[10] * vU_[17];
    vU_[14] = 0.00315291990945349 + -0.07737375 * vU_[13] + vU_[14] * vU_[13] - vU_[22];
    vU_[17] = vU_[8] * vU_[17] + vU_[10] * vU_[14];
    vU_[25] = vU_[24] * vU_[8] + vU_[17] * vU_[10];
    vU_[26] = 0.011046 + vU_[22] + vU_[25];
    vU_[27] = vU_[19] / vU_[26];
    vU_[28] = 0 - vU_[12] * vU_[27];
    vU_[29] = sin(x_in[4]);
    vU_[30] = 3.650675 - vU_[19] * vU_[27];
    vU_[31] = -0.161331712543454 * vU_[10];
    vU_[32] = vU_[31] * vU_[10];
    vU_[11] = vU_[11] * vU_[10];
    vU_[33] = vU_[11] / vU_[26];
    vU_[34] = 3.650675 + vU_[32] - vU_[11] * vU_[33];
    vU_[35] = vU_[30] - vU_[34];
    vU_[36] = vU_[7] * vU_[28] + vU_[29] * vU_[35];
    vU_[37] = vU_[12] / vU_[26];
    vU_[32] = 3.48934328745655 - vU_[32] - vU_[12] * vU_[37];
    vU_[38] = vU_[32] - vU_[34];
    vU_[39] = vU_[29] * vU_[28];
    vU_[40] = vU_[7] * vU_[38] + vU_[39];
    vU_[41] = -0.112 * vU_[29];
    vU_[42] = 0.112 * vU_[6];
    vU_[43] = vU_[29] * vU_[41] + vU_[7] * vU_[42];
    vU_[30] = vU_[43] * vU_[30];
    vU_[16] = vU_[8] * vU_[16] + vU_[10] * vU_[18];
    vU_[17] = -0.012652 + vU_[17] * vU_[8] + vU_[24] * vU_[9];
    vU_[24] = -0.057838 - vU_[16] - vU_[17] * vU_[27];
    vU_[44] = vU_[30] + vU_[24];
    vU_[45] = 0 - -6.25528861700981e-05 * vU_[13];
    vU_[13] = 0 - 0.00345708950900075 * vU_[13];
    vU_[46] = 0 - vU_[13];
    vU_[47] = -0.001243 + vU_[8] * vU_[45] + vU_[9] * vU_[46];
    vU_[27] = 0 - vU_[47] * vU_[27];
    vU_[48] = vU_[43] * vU_[28];
    vU_[49] = vU_[27] - vU_[48];
    vU_[50] = vU_[7] * vU_[44] + vU_[29] * vU_[49];
    vU_[51] = -6.25528861700981e-05 * vU_[9] + 0.00345708950900075 * vU_[8];
    vU_[52] = vU_[51] * vU_[8] - vU_[17] * vU_[37];
    vU_[53] = vU_[48] + vU_[52];
    vU_[32] = 0 - vU_[43] * vU_[32];
    vU_[21] = vU_[21] + vU_[15];
    vU_[20] = vU_[20] + vU_[18];
    vU_[16] = 0.057838 + vU_[21] * vU_[8] + vU_[20] * vU_[9] + vU_[16] - vU_[47] * vU_[37];
    vU_[37] = vU_[32] + vU_[16];
    vU_[18] = vU_[7] * vU_[53] + vU_[29] * vU_[37];
    vU_[15] = 0.160298259823722 + vU_[50] * vU_[6] + vU_[18] * vU_[29];
    vU_[18] = vU_[18] * vU_[7] + vU_[50] * vU_[29];
    vU_[24] = 2. * vU_[24] * vU_[43] + 0.019432 + vU_[14] + vU_[23] + vU_[22] - vU_[25] - vU_[17] * vU_[17] / vU_[26] +
              vU_[30] * vU_[43];
    vU_[30] = vU_[47] / vU_[26];
    vU_[52] = vU_[27] * vU_[43] + -0.001387 + 2. * vU_[13] * vU_[8] + 2. * vU_[45] * vU_[9] + vU_[10] * vU_[45] +
              vU_[8] * vU_[46] - vU_[17] * vU_[30] - vU_[52] * vU_[43] - vU_[48] * vU_[43];
    vU_[48] = vU_[29] * vU_[52];
    vU_[27] = vU_[7] * vU_[24] + vU_[48];
    vU_[30] = 0.029115 + vU_[22] - vU_[47] * vU_[30] - 2. * vU_[16] * vU_[43] - vU_[32] * vU_[43];
    vU_[16] = vU_[7] * vU_[52] + vU_[29] * vU_[30];
    vU_[32] = vU_[27] * vU_[7] + vU_[16] * vU_[29];
    vU_[22] = 0.09570849 + vU_[32];
    vU_[46] = vU_[18] / vU_[22];
    vU_[13] = vU_[36] * vU_[6] + vU_[40] * vU_[29] - vU_[15] * vU_[46];
    vU_[45] = 0 - vU_[5] * vU_[13];
    vU_[31] = vU_[31] * vU_[8] - vU_[12] * vU_[33];
    vU_[20] = vU_[21] * vU_[10] + vU_[20] * vU_[8] - vU_[19] - vU_[47] * vU_[33] - vU_[43] * vU_[31];
    vU_[21] = 0 - vU_[19] * vU_[33];
    vU_[51] = vU_[43] * vU_[21] + vU_[51] * vU_[10] - vU_[17] * vU_[33];
    vU_[43] = vU_[29] * vU_[51];
    vU_[33] = 0 - vU_[20];
    vU_[25] = vU_[7] * vU_[33] + vU_[43];
    vU_[14] = vU_[15] / vU_[22];
    vU_[43] = -1.52322944854339e-09 + vU_[20] * vU_[6] + vU_[43] - vU_[25] - -0.00021200017 * vU_[14];
    vU_[23] = vU_[45] + vU_[43];
    vU_[50] = cos(x_in[3]);
    vU_[49] = vU_[29] * vU_[44] + vU_[6] * vU_[49];
    vU_[37] = vU_[29] * vU_[53] + vU_[6] * vU_[37];
    vU_[16] = -0.0022920002 + vU_[16] * vU_[6] + vU_[27] * vU_[29];
    vU_[27] = vU_[49] * vU_[6] + vU_[37] * vU_[29] - vU_[16] * vU_[14];
    vU_[53] = -0.304 * vU_[50];
    vU_[44] = vU_[53] * vU_[13];
    vU_[21] = 0 - vU_[21];
    vU_[33] = vU_[29] * vU_[33] + vU_[6] * vU_[51];
    vU_[54] = 0.008711861 - vU_[33];
    vU_[55] = 0 - vU_[6] * vU_[31] - vU_[29] * vU_[21] - vU_[54] * vU_[46];
    vU_[56] = vU_[5] * vU_[55];
    vU_[57] = vU_[56] - vU_[44];
    vU_[58] = vU_[27] + vU_[44] - vU_[57];
    vU_[59] = vU_[3] * vU_[23] + vU_[50] * vU_[58];
    vU_[60] = vU_[54] / vU_[22];
    vU_[61] = 0 - -0.00021200017 * vU_[60];
    vU_[56] = 0 - vU_[56];
    vU_[62] = vU_[61] + vU_[56] - vU_[57];
    vU_[63] = vU_[53] * vU_[55];
    vU_[25] = 1.52322944854339e-09 + vU_[25] - vU_[16] * vU_[60];
    vU_[64] = vU_[63] + vU_[25];
    vU_[65] = vU_[3] * vU_[62] + vU_[50] * vU_[64];
    vU_[66] = vU_[16] / vU_[22];
    vU_[33] = -0.008711861 + vU_[20] * vU_[29] + vU_[51] * vU_[7] + vU_[33] - -0.00021200017 * vU_[46];
    vU_[40] = vU_[40] * vU_[7] + vU_[36] * vU_[29];
    vU_[36] = 1.7423722 + vU_[34] + vU_[40] - vU_[18] * vU_[46];
    vU_[51] = 0 - vU_[5] * vU_[36];
    vU_[37] = -0.160298259823722 + vU_[49] * vU_[29] + vU_[37] * vU_[7] - vU_[16] * vU_[46];
    vU_[49] = 0.0036857284 - -0.00021200017 * vU_[66] + vU_[33] * vU_[53] + vU_[51] * vU_[53] - vU_[37] * vU_[5];
    vU_[46] = vU_[50] * vU_[49];
    vU_[20] = 0 - vU_[3];
    vU_[48] = (vU_[29] * vU_[24] + vU_[6] * vU_[52]) * vU_[29] + (vU_[48] + vU_[6] * vU_[30]) * vU_[6];
    vU_[52] = vU_[53] * vU_[36];
    vU_[39] = (vU_[29] * vU_[38] + vU_[6] * vU_[28]) * vU_[29] + (vU_[39] + vU_[6] * vU_[35]) * vU_[6];
    vU_[40] = 1.7423722 + vU_[35] + vU_[38] + vU_[34] - vU_[39] - vU_[40] - vU_[54] * vU_[60];
    vU_[21] = vU_[29] * vU_[31] + vU_[7] * vU_[21] - vU_[54] * vU_[14];
    vU_[31] = vU_[5] * vU_[40] - vU_[53] * vU_[21];
    vU_[39] = 1.7423722 + vU_[34] + vU_[39] - vU_[15] * vU_[14];
    vU_[14] = vU_[5] * vU_[21] - vU_[53] * vU_[39];
    vU_[34] = vU_[31] * vU_[5] - vU_[14] * vU_[53];
    vU_[66] = 2. * vU_[37] * vU_[53] + 0.01828449 + vU_[48] - vU_[16] * vU_[66] + vU_[52] * vU_[53] - vU_[34];
    vU_[60] = vU_[46] + vU_[20] * vU_[66];
    vU_[48] = 0.081661 + vU_[30] + vU_[24] - vU_[48] - vU_[32] - -0.00021200017 * -0.00021200017 / vU_[22] -
              2. * vU_[33] * vU_[5] - vU_[51] * vU_[5] - vU_[34];
    vU_[32] = vU_[50] * vU_[48] + vU_[20] * vU_[49];
    vU_[30] = -0.0037997814 + vU_[60] * vU_[50] + vU_[32] * vU_[3];
    vU_[58] = vU_[50] * vU_[23] + vU_[20] * vU_[58];
    vU_[64] = vU_[50] * vU_[62] + vU_[20] * vU_[64];
    vU_[62] = -0.0055615274403 + vU_[58] * vU_[50] + vU_[64] * vU_[3];
    vU_[32] = vU_[32] * vU_[50] + vU_[60] * vU_[20];
    vU_[60] = 0.010329999 + vU_[34] + vU_[32];
    vU_[23] = vU_[62] / vU_[60];
    vU_[24] = vU_[59] * vU_[50] + vU_[65] * vU_[3] + vU_[57] - vU_[30] * vU_[23];
    vU_[38] = sin(x_in[2]);
    vU_[35] = -0.112 * vU_[38];
    vU_[28] = 0.112 * vU_[1];
    vU_[67] = vU_[38] * vU_[35] + vU_[2] * vU_[28];
    vU_[56] = vU_[61] * vU_[5] + vU_[56] * vU_[5] - vU_[43] * vU_[53] - vU_[45] * vU_[53];
    vU_[25] = vU_[27] * vU_[53] + vU_[44] * vU_[53] - vU_[25] * vU_[5] - vU_[63] * vU_[5];
    vU_[63] = -0.011715295 - vU_[50] * vU_[56] - vU_[3] * vU_[25];
    vU_[44] = vU_[30] / vU_[60];
    vU_[52] = vU_[52] + vU_[37];
    vU_[37] = 0 - vU_[52];
    vU_[51] = vU_[51] + vU_[33];
    vU_[33] = vU_[3] * vU_[37] + vU_[50] * vU_[51];
    vU_[53] = -0.01438086 - vU_[33];
    vU_[27] = vU_[53] / vU_[60];
    vU_[5] = vU_[57] - vU_[63] * vU_[27];
    vU_[13] = 0 - vU_[13];
    vU_[61] = vU_[20] * vU_[55] + vU_[50] * vU_[13] - vU_[53] * vU_[23];
    vU_[43] = vU_[67] * vU_[61];
    vU_[25] = vU_[24] * vU_[67] + 5.399998e-05 + vU_[20] * vU_[56] + vU_[50] * vU_[25] - vU_[63] * vU_[44] -
              vU_[5] * vU_[67] - vU_[43] * vU_[67];
    vU_[46] = (vU_[3] * vU_[48] + vU_[46]) * vU_[3] + (vU_[3] * vU_[49] + vU_[50] * vU_[66]) * vU_[50];
    vU_[37] = vU_[50] * vU_[37] + vU_[20] * vU_[51];
    vU_[49] = 0.647967112 + vU_[37] - vU_[30] * vU_[27];
    vU_[39] = vU_[39] - vU_[36];
    vU_[40] = vU_[40] - vU_[36];
    vU_[56] = vU_[50] * vU_[21];
    vU_[45] = (vU_[3] * vU_[40] + vU_[56]) * vU_[3] + (vU_[3] * vU_[21] + vU_[50] * vU_[39]) * vU_[50];
    vU_[21] = vU_[50] * vU_[40] + vU_[20] * vU_[21];
    vU_[56] = vU_[56] + vU_[20] * vU_[39];
    vU_[68] = vU_[21] * vU_[50] + vU_[56] * vU_[20];
    vU_[40] = 2.327 + vU_[39] + vU_[40] + vU_[36] - vU_[45] - vU_[68] - vU_[53] * vU_[27];
    vU_[39] = 0 - vU_[67] * vU_[40];
    vU_[44] = 0.20986895 + vU_[34] + vU_[46] - vU_[30] * vU_[44] - 2. * vU_[49] * vU_[67] - vU_[39] * vU_[67];
    vU_[27] = vU_[2] * vU_[25] + vU_[38] * vU_[44];
    vU_[52] = -1 * (vU_[14] + vU_[52]);
    vU_[51] = -1 * (vU_[31] + vU_[51]);
    vU_[37] = -0.647967112 + vU_[52] * vU_[50] + vU_[51] * vU_[3] - vU_[37] - vU_[63] * vU_[23];
    vU_[45] = 2.327 + vU_[36] + vU_[45] - vU_[62] * vU_[23];
    vU_[23] = vU_[67] * vU_[45];
    vU_[46] = 2. * vU_[37] * vU_[67] + 0.20236395 + vU_[66] + vU_[48] + vU_[34] - vU_[46] - vU_[32] -
              vU_[63] * vU_[63] / vU_[60] + vU_[23] * vU_[67];
    vU_[32] = vU_[38] * vU_[25];
    vU_[48] = vU_[2] * vU_[46] + vU_[32];
    vU_[66] = -0.002752 + vU_[27] * vU_[1] + vU_[48] * vU_[38];
    vU_[48] = vU_[48] * vU_[2] + vU_[27] * vU_[38];
    vU_[27] = 0.051393528 + vU_[48];
    vU_[34] = vU_[66] / vU_[27];
    vU_[64] = vU_[58] * vU_[20] + vU_[64] * vU_[50] + vU_[57];
    vU_[58] = vU_[64] / vU_[60];
    vU_[13] = 0 - vU_[50] * vU_[55] - vU_[3] * vU_[13] - vU_[53] * vU_[58];
    vU_[65] = 0.0055615274403 + vU_[59] * vU_[20] + vU_[65] * vU_[50] - vU_[67] * vU_[13] - vU_[30] * vU_[58];
    vU_[56] = vU_[56] * vU_[50] + vU_[21] * vU_[3] - vU_[62] * vU_[58];
    vU_[51] = 0.01438086 + vU_[52] * vU_[20] + vU_[51] * vU_[50] + vU_[33] + vU_[67] * vU_[56] - vU_[63] * vU_[58];
    vU_[52] = vU_[38] * (0 - vU_[65]) + vU_[1] * vU_[51];
    vU_[5] = vU_[43] + vU_[5];
    vU_[39] = vU_[39] + vU_[49];
    vU_[49] = vU_[2] * vU_[5] + vU_[38] * vU_[39];
    vU_[23] = vU_[23] + vU_[37];
    vU_[43] = vU_[24] - vU_[43];
    vU_[24] = vU_[2] * vU_[23] + vU_[38] * vU_[43];
    vU_[37] = vU_[49] * vU_[2] + vU_[24] * vU_[38];
    vU_[33] = vU_[37] / vU_[27];
    vU_[51] = -0.0606159433962 + vU_[65] * vU_[38] + vU_[51] * vU_[2] + vU_[52] - -0.022851627 * vU_[33];
    vU_[65] = 0.178 * (0 - vU_[0]);
    vU_[67] = cos(x_in[1]);
    vU_[21] = -1 * 0.178 * vU_[67];
    vU_[58] = 2.327 + vU_[36] + vU_[68] - vU_[64] * vU_[58];
    vU_[40] = vU_[40] - vU_[58];
    vU_[64] = vU_[38] * vU_[61];
    vU_[45] = vU_[45] - vU_[58];
    vU_[68] = (vU_[2] * vU_[40] + vU_[64]) * vU_[2] + (vU_[2] * vU_[61] + vU_[38] * vU_[45]) * vU_[38];
    vU_[37] = 2.5924191 + vU_[58] + vU_[68] - vU_[37] * vU_[33];
    vU_[36] = 0 - vU_[21] * vU_[37];
    vU_[33] = -0.293374233908935 + (vU_[38] * vU_[23] + vU_[1] * vU_[43]) * vU_[38] +
              (vU_[38] * vU_[5] + vU_[1] * vU_[39]) * vU_[2] - vU_[66] * vU_[33];
    vU_[43] = 0.0055279857 - -0.022851627 * vU_[34] + vU_[51] * vU_[65] + vU_[36] * vU_[65] - vU_[33] * vU_[21];
    vU_[32] = (vU_[38] * vU_[46] + vU_[1] * vU_[25]) * vU_[38] + (vU_[32] + vU_[1] * vU_[44]) * vU_[1];
    vU_[64] = (vU_[38] * vU_[40] + vU_[1] * vU_[61]) * vU_[38] + (vU_[64] + vU_[1] * vU_[45]) * vU_[1];
    vU_[52] = 0.0606159433962 - vU_[52];
    vU_[24] = 0.293374233908935 + vU_[24] * vU_[1] + vU_[49] * vU_[38];
    vU_[49] = vU_[24] / vU_[27];
    vU_[56] = vU_[38] * vU_[13] + vU_[2] * (0 - vU_[56]) - vU_[52] * vU_[49];
    vU_[56] = (vU_[21] * (2.5924191 + vU_[45] + vU_[40] + vU_[58] - vU_[64] - vU_[68] - vU_[52] * vU_[52] / vU_[27]) -
                  vU_[65] * vU_[56]) *
                  vU_[21] -
              (vU_[21] * vU_[56] - vU_[65] * (2.5924191 + vU_[58] + vU_[64] - vU_[24] * vU_[49])) * vU_[65];
    vU_[56] = 0.007629 +
              (vU_[0] * vU_[43] + vU_[67] * (2. * vU_[33] * vU_[65] + 0.08585553 + vU_[32] - vU_[66] * vU_[34] +
                                                vU_[65] * vU_[37] * vU_[65] - vU_[56])) *
                  vU_[67] +
              (vU_[0] * (0.039002996 + vU_[44] + vU_[46] - vU_[32] - vU_[48] - -0.022851627 * -0.022851627 / vU_[27] -
                            2. * vU_[51] * vU_[21] - vU_[36] * vU_[21] - vU_[56]) +
                  vU_[67] * vU_[43]) *
                  vU_[0] +
              vU_[56];
    jac[6] = 1 / vU_[56];
    jac[18] = (0 - vU_[67] * vU_[66] / vU_[27] - vU_[0] * -0.022851627 / vU_[27]) / vU_[56];
    vU_[32] = vU_[67] * jac[6];
    vU_[43] = vU_[0] * jac[6];
    jac[7] = (0 - vU_[66] * vU_[32] - -0.022851627 * vU_[43]) / vU_[27];
    vU_[33] = vU_[38] * jac[7] + vU_[1] * vU_[32];
    vU_[36] = vU_[2] * jac[7] + vU_[38] * vU_[32];
    vU_[37] = vU_[28] * jac[7] + vU_[35] * vU_[32];
    vU_[21] = 0.112 * vU_[38];
    vU_[65] = 0.112 * vU_[1];
    vU_[32] = vU_[21] * jac[7] + vU_[65] * vU_[32];
    jac[8] = (0 - vU_[60] * vU_[43] - vU_[30] * vU_[33] - vU_[63] * vU_[36] - vU_[62] * vU_[37] - vU_[53] * vU_[32]) /
             vU_[60];
    vU_[51] = -1 * vU_[36];
    vU_[43] = vU_[43] + jac[8];
    vU_[34] = vU_[20] * vU_[43] + vU_[50] * vU_[33];
    vU_[43] = vU_[50] * vU_[43] + vU_[3] * vU_[33];
    vU_[32] = -0.304 * vU_[33] + -1 * vU_[32];
    vU_[33] = -0.304 * vU_[50];
    vU_[48] = vU_[50] * vU_[37] + vU_[33] * vU_[36];
    vU_[37] = vU_[3] * vU_[37] + vU_[4] * vU_[36];
    jac[9] = (0 - vU_[22] * vU_[51] - vU_[16] * vU_[34] - -0.00021200017 * vU_[43] - vU_[18] * vU_[32] -
                 vU_[15] * vU_[48] - vU_[54] * vU_[37]) /
             vU_[22];
    vU_[51] = vU_[51] + jac[9];
    vU_[36] = vU_[29] * vU_[51] + vU_[6] * vU_[34];
    vU_[46] = vU_[7] * vU_[51] + vU_[29] * vU_[34];
    vU_[44] = 0.112 * vU_[29];
    vU_[49] = 0.112 * vU_[6];
    vU_[24] = 0 - vU_[6];
    vU_[52] = vU_[44] * vU_[51] + vU_[49] * vU_[34] + vU_[29] * vU_[48] + vU_[24] * vU_[32];
    jac[10] = (0 - vU_[26] * vU_[43] - vU_[47] * vU_[36] - vU_[17] * vU_[46] - vU_[11] * vU_[37] -
                  vU_[19] * (vU_[42] * vU_[51] + vU_[41] * vU_[34] + vU_[6] * vU_[48] + vU_[29] * vU_[32]) -
                  vU_[12] * vU_[52]) /
              vU_[26];
    vU_[43] = vU_[43] + jac[10];
    vU_[51] = 0.02075 * vU_[9] + 0.184 * vU_[8];
    vU_[48] = 0 - vU_[9];
    jac[11] = (0 - 0.009277 * vU_[36] - -0.000829 * (vU_[10] * vU_[43] + vU_[8] * vU_[46]) -
                  1.5e-05 * (vU_[8] * vU_[43] + vU_[9] * vU_[46]) -
                  0.038686875 * (vU_[8] * vU_[52] + vU_[51] * vU_[36] + vU_[48] * vU_[37])) /
              0.009277;
    vU_[43] = vU_[67] * jac[18];
    vU_[52] = vU_[0] * jac[18];
    jac[19] = (1 - vU_[66] * vU_[43] - -0.022851627 * vU_[52]) / vU_[27];
    vU_[46] = vU_[38] * jac[19] + vU_[1] * vU_[43];
    vU_[36] = vU_[2] * jac[19] + vU_[38] * vU_[43];
    vU_[37] = vU_[28] * jac[19] + vU_[35] * vU_[43];
    vU_[43] = vU_[21] * jac[19] + vU_[65] * vU_[43];
    jac[20] = (0 - vU_[60] * vU_[52] - vU_[30] * vU_[46] - vU_[63] * vU_[36] - vU_[62] * vU_[37] - vU_[53] * vU_[43]) /
              vU_[60];
    vU_[32] = -1 * vU_[36];
    vU_[52] = vU_[52] + jac[20];
    vU_[34] = vU_[20] * vU_[52] + vU_[50] * vU_[46];
    vU_[52] = vU_[50] * vU_[52] + vU_[3] * vU_[46];
    vU_[43] = -0.304 * vU_[46] + -1 * vU_[43];
    vU_[46] = vU_[50] * vU_[37] + vU_[33] * vU_[36];
    vU_[37] = vU_[3] * vU_[37] + vU_[4] * vU_[36];
    jac[21] = (0 - vU_[22] * vU_[32] - vU_[16] * vU_[34] - -0.00021200017 * vU_[52] - vU_[18] * vU_[43] -
                  vU_[15] * vU_[46] - vU_[54] * vU_[37]) /
              vU_[22];
    vU_[32] = vU_[32] + jac[21];
    vU_[36] = vU_[29] * vU_[32] + vU_[6] * vU_[34];
    vU_[64] = vU_[7] * vU_[32] + vU_[29] * vU_[34];
    vU_[68] = vU_[44] * vU_[32] + vU_[49] * vU_[34] + vU_[29] * vU_[46] + vU_[24] * vU_[43];
    jac[22] = (0 - vU_[26] * vU_[52] - vU_[47] * vU_[36] - vU_[17] * vU_[64] - vU_[11] * vU_[37] -
                  vU_[19] * (vU_[42] * vU_[32] + vU_[41] * vU_[34] + vU_[6] * vU_[46] + vU_[29] * vU_[43]) -
                  vU_[12] * vU_[68]) /
              vU_[26];
    vU_[52] = vU_[52] + jac[22];
    jac[23] = (0 - 0.009277 * vU_[36] - -0.000829 * (vU_[10] * vU_[52] + vU_[8] * vU_[64]) -
                  1.5e-05 * (vU_[8] * vU_[52] + vU_[9] * vU_[64]) -
                  0.038686875 * (vU_[8] * vU_[68] + vU_[51] * vU_[36] + vU_[48] * vU_[37])) /
              0.009277;
    vU_[52] = vU_[30] / vU_[60];
    vU_[68] = vU_[63] / vU_[60];
    vU_[64] = vU_[53] / vU_[60];
    vU_[36] = vU_[62] / vU_[60];
    vU_[37] = 0 - vU_[38] * vU_[52] - vU_[2] * vU_[68] - vU_[21] * vU_[64] - vU_[28] * vU_[36];
    jac[30] = (0 -
                  vU_[67] * (vU_[1] * vU_[52] + vU_[38] * vU_[68] + vU_[65] * vU_[64] + vU_[35] * vU_[36] +
                                (vU_[66] * vU_[37]) / vU_[27]) -
                  vU_[0] * (vU_[60] / vU_[60] + (-0.022851627 * vU_[37]) / vU_[27])) /
              vU_[56];
    vU_[36] = vU_[67] * jac[30];
    vU_[64] = vU_[0] * jac[30];
    jac[31] = (vU_[37] - vU_[66] * vU_[36] - -0.022851627 * vU_[64]) / vU_[27];
    vU_[37] = vU_[38] * jac[31] + vU_[1] * vU_[36];
    vU_[68] = vU_[2] * jac[31] + vU_[38] * vU_[36];
    vU_[52] = vU_[28] * jac[31] + vU_[35] * vU_[36];
    vU_[36] = vU_[21] * jac[31] + vU_[65] * vU_[36];
    jac[32] = (1 - vU_[60] * vU_[64] - vU_[30] * vU_[37] - vU_[63] * vU_[68] - vU_[62] * vU_[52] - vU_[53] * vU_[36]) /
              vU_[60];
    vU_[32] = -1 * vU_[68];
    vU_[64] = vU_[64] + jac[32];
    vU_[46] = vU_[20] * vU_[64] + vU_[50] * vU_[37];
    vU_[64] = vU_[50] * vU_[64] + vU_[3] * vU_[37];
    vU_[36] = -0.304 * vU_[37] + -1 * vU_[36];
    vU_[37] = vU_[50] * vU_[52] + vU_[33] * vU_[68];
    vU_[52] = vU_[3] * vU_[52] + vU_[4] * vU_[68];
    jac[33] = (0 - vU_[22] * vU_[32] - vU_[16] * vU_[46] - -0.00021200017 * vU_[64] - vU_[18] * vU_[36] -
                  vU_[15] * vU_[37] - vU_[54] * vU_[52]) /
              vU_[22];
    vU_[32] = vU_[32] + jac[33];
    vU_[68] = vU_[29] * vU_[32] + vU_[6] * vU_[46];
    vU_[43] = vU_[7] * vU_[32] + vU_[29] * vU_[46];
    vU_[34] = vU_[44] * vU_[32] + vU_[49] * vU_[46] + vU_[29] * vU_[37] + vU_[24] * vU_[36];
    jac[34] = (0 - vU_[26] * vU_[64] - vU_[47] * vU_[68] - vU_[17] * vU_[43] - vU_[11] * vU_[52] -
                  vU_[19] * (vU_[42] * vU_[32] + vU_[41] * vU_[46] + vU_[6] * vU_[37] + vU_[29] * vU_[36]) -
                  vU_[12] * vU_[34]) /
              vU_[26];
    vU_[64] = vU_[64] + jac[34];
    jac[35] = (0 - 0.009277 * vU_[68] - -0.000829 * (vU_[10] * vU_[64] + vU_[8] * vU_[43]) -
                  1.5e-05 * (vU_[8] * vU_[64] + vU_[9] * vU_[43]) -
                  0.038686875 * (vU_[8] * vU_[34] + vU_[51] * vU_[68] + vU_[48] * vU_[52])) /
              0.009277;
    vU_[64] = vU_[16] / vU_[22];
    vU_[34] = -0.00021200017 / vU_[22];
    vU_[43] = vU_[18] / vU_[22];
    vU_[68] = vU_[20] * vU_[64] + vU_[50] * vU_[34];
    vU_[52] = 0 - vU_[68];
    vU_[34] = vU_[50] * vU_[64] + vU_[3] * vU_[34] + -0.304 * vU_[43] + (vU_[30] * vU_[52]) / vU_[60];
    vU_[64] = vU_[54] / vU_[22];
    vU_[32] = vU_[15] / vU_[22];
    vU_[37] = vU_[4] * vU_[64] + -1 * vU_[22] / vU_[22] + vU_[33] * vU_[32] + (vU_[63] * vU_[52]) / vU_[60];
    vU_[43] = -1 * vU_[43] + (vU_[53] * vU_[52]) / vU_[60];
    vU_[32] = vU_[50] * vU_[32] + vU_[3] * vU_[64] + (vU_[62] * vU_[52]) / vU_[60];
    vU_[64] = 0 - vU_[38] * vU_[34] - vU_[2] * vU_[37] - vU_[21] * vU_[43] - vU_[28] * vU_[32];
    jac[42] = (0 -
                  vU_[67] * (vU_[1] * vU_[34] + vU_[38] * vU_[37] + vU_[65] * vU_[43] + vU_[35] * vU_[32] +
                                (vU_[66] * vU_[64]) / vU_[27]) -
                  vU_[0] * ((vU_[60] * vU_[52]) / vU_[60] + vU_[68] + (-0.022851627 * vU_[64]) / vU_[27])) /
              vU_[56];
    vU_[32] = vU_[67] * jac[42];
    vU_[43] = vU_[0] * jac[42];
    jac[43] = (vU_[64] - vU_[66] * vU_[32] - -0.022851627 * vU_[43]) / vU_[27];
    vU_[64] = vU_[38] * jac[43] + vU_[1] * vU_[32];
    vU_[37] = vU_[2] * jac[43] + vU_[38] * vU_[32];
    vU_[34] = vU_[28] * jac[43] + vU_[35] * vU_[32];
    vU_[32] = vU_[21] * jac[43] + vU_[65] * vU_[32];
    jac[44] =
        (vU_[52] - vU_[60] * vU_[43] - vU_[30] * vU_[64] - vU_[63] * vU_[37] - vU_[62] * vU_[34] - vU_[53] * vU_[32]) /
        vU_[60];
    vU_[52] = -1 * vU_[37];
    vU_[43] = vU_[43] + jac[44];
    vU_[68] = vU_[20] * vU_[43] + vU_[50] * vU_[64];
    vU_[43] = vU_[50] * vU_[43] + vU_[3] * vU_[64];
    vU_[32] = -0.304 * vU_[64] + -1 * vU_[32];
    vU_[64] = vU_[50] * vU_[34] + vU_[33] * vU_[37];
    vU_[34] = vU_[3] * vU_[34] + vU_[4] * vU_[37];
    jac[45] = (1 - vU_[22] * vU_[52] - vU_[16] * vU_[68] - -0.00021200017 * vU_[43] - vU_[18] * vU_[32] -
                  vU_[15] * vU_[64] - vU_[54] * vU_[34]) /
              vU_[22];
    vU_[52] = vU_[52] + jac[45];
    vU_[37] = vU_[29] * vU_[52] + vU_[6] * vU_[68];
    vU_[36] = vU_[7] * vU_[52] + vU_[29] * vU_[68];
    vU_[46] = vU_[44] * vU_[52] + vU_[49] * vU_[68] + vU_[29] * vU_[64] + vU_[24] * vU_[32];
    jac[46] = (0 - vU_[26] * vU_[43] - vU_[47] * vU_[37] - vU_[17] * vU_[36] - vU_[11] * vU_[34] -
                  vU_[19] * (vU_[42] * vU_[52] + vU_[41] * vU_[68] + vU_[6] * vU_[64] + vU_[29] * vU_[32]) -
                  vU_[12] * vU_[46]) /
              vU_[26];
    vU_[43] = vU_[43] + jac[46];
    jac[47] = (0 - 0.009277 * vU_[37] - -0.000829 * (vU_[10] * vU_[43] + vU_[8] * vU_[36]) -
                  1.5e-05 * (vU_[8] * vU_[43] + vU_[9] * vU_[36]) -
                  0.038686875 * (vU_[8] * vU_[46] + vU_[51] * vU_[37] + vU_[48] * vU_[34])) /
              0.009277;
    vU_[43] = vU_[47] / vU_[26];
    vU_[46] = vU_[17] / vU_[26];
    vU_[36] = vU_[12] / vU_[26];
    vU_[37] = vU_[19] / vU_[26];
    vU_[34] = vU_[29] * vU_[43] + vU_[7] * vU_[46] + vU_[44] * vU_[36] + vU_[42] * vU_[37];
    vU_[52] = 0 - vU_[34];
    vU_[46] =
        vU_[6] * vU_[43] + vU_[29] * vU_[46] + vU_[49] * vU_[36] + vU_[41] * vU_[37] + (vU_[16] * vU_[52]) / vU_[22];
    vU_[43] = vU_[26] / vU_[26] + (-0.00021200017 * vU_[52]) / vU_[22];
    vU_[64] = vU_[29] * vU_[37] + vU_[24] * vU_[36] + (vU_[18] * vU_[52]) / vU_[22];
    vU_[32] = vU_[20] * vU_[46] + vU_[50] * vU_[43];
    vU_[68] = 0 - vU_[32];
    vU_[43] = vU_[50] * vU_[46] + vU_[3] * vU_[43] + -0.304 * vU_[64] + (vU_[30] * vU_[68]) / vU_[60];
    vU_[46] = vU_[11] / vU_[26] + (vU_[54] * vU_[52]) / vU_[22];
    vU_[37] = vU_[6] * vU_[37] + vU_[29] * vU_[36] + (vU_[15] * vU_[52]) / vU_[22];
    vU_[34] = vU_[4] * vU_[46] + -1 * (vU_[34] + (vU_[22] * vU_[52]) / vU_[22]) + vU_[33] * vU_[37] +
              (vU_[63] * vU_[68]) / vU_[60];
    vU_[64] = -1 * vU_[64] + (vU_[53] * vU_[68]) / vU_[60];
    vU_[37] = vU_[50] * vU_[37] + vU_[3] * vU_[46] + (vU_[62] * vU_[68]) / vU_[60];
    vU_[46] = 0 - vU_[38] * vU_[43] - vU_[2] * vU_[34] - vU_[21] * vU_[64] - vU_[28] * vU_[37];
    jac[54] = (0 -
                  vU_[67] * (vU_[1] * vU_[43] + vU_[38] * vU_[34] + vU_[65] * vU_[64] + vU_[35] * vU_[37] +
                                (vU_[66] * vU_[46]) / vU_[27]) -
                  vU_[0] * ((vU_[60] * vU_[68]) / vU_[60] + vU_[32] + (-0.022851627 * vU_[46]) / vU_[27])) /
              vU_[56];
    vU_[37] = vU_[67] * jac[54];
    vU_[64] = vU_[0] * jac[54];
    jac[55] = (vU_[46] - vU_[66] * vU_[37] - -0.022851627 * vU_[64]) / vU_[27];
    vU_[46] = vU_[38] * jac[55] + vU_[1] * vU_[37];
    vU_[34] = vU_[2] * jac[55] + vU_[38] * vU_[37];
    vU_[43] = vU_[28] * jac[55] + vU_[35] * vU_[37];
    vU_[37] = vU_[21] * jac[55] + vU_[65] * vU_[37];
    jac[56] =
        (vU_[68] - vU_[60] * vU_[64] - vU_[30] * vU_[46] - vU_[63] * vU_[34] - vU_[62] * vU_[43] - vU_[53] * vU_[37]) /
        vU_[60];
    vU_[68] = -1 * vU_[34];
    vU_[64] = vU_[64] + jac[56];
    vU_[32] = vU_[20] * vU_[64] + vU_[50] * vU_[46];
    vU_[64] = vU_[50] * vU_[64] + vU_[3] * vU_[46];
    vU_[37] = -0.304 * vU_[46] + -1 * vU_[37];
    vU_[46] = vU_[50] * vU_[43] + vU_[33] * vU_[34];
    vU_[43] = vU_[3] * vU_[43] + vU_[4] * vU_[34];
    jac[57] = (vU_[52] - vU_[22] * vU_[68] - vU_[16] * vU_[32] - -0.00021200017 * vU_[64] - vU_[18] * vU_[37] -
                  vU_[15] * vU_[46] - vU_[54] * vU_[43]) /
              vU_[22];
    vU_[68] = vU_[68] + jac[57];
    vU_[52] = vU_[29] * vU_[68] + vU_[6] * vU_[32];
    vU_[34] = vU_[7] * vU_[68] + vU_[29] * vU_[32];
    vU_[36] = vU_[44] * vU_[68] + vU_[49] * vU_[32] + vU_[29] * vU_[46] + vU_[24] * vU_[37];
    jac[58] = (1 - vU_[26] * vU_[64] - vU_[47] * vU_[52] - vU_[17] * vU_[34] - vU_[11] * vU_[43] -
                  vU_[19] * (vU_[42] * vU_[68] + vU_[41] * vU_[32] + vU_[6] * vU_[46] + vU_[29] * vU_[37]) -
                  vU_[12] * vU_[36]) /
              vU_[26];
    vU_[64] = vU_[64] + jac[58];
    jac[59] = (0 - 0.009277 * vU_[52] - -0.000829 * (vU_[10] * vU_[64] + vU_[8] * vU_[34]) -
                  1.5e-05 * (vU_[8] * vU_[64] + vU_[9] * vU_[34]) -
                  0.038686875 * (vU_[8] * vU_[36] + vU_[51] * vU_[52] + vU_[48] * vU_[43])) /
              0.009277;
    vU_[64] = vU_[10] * -0.089360784736445 + vU_[8] * 0.00161690201573785;
    vU_[36] = 0 - vU_[64];
    vU_[34] = 1 + vU_[51] * 4.17019241133987 + (vU_[47] * vU_[36]) / vU_[26];
    vU_[52] = vU_[8] * -0.089360784736445 + vU_[9] * 0.00161690201573785 + (vU_[17] * vU_[36]) / vU_[26];
    vU_[43] = vU_[8] * 4.17019241133987 + (vU_[12] * vU_[36]) / vU_[26];
    vU_[68] = (vU_[19] * vU_[36]) / vU_[26];
    vU_[46] = vU_[29] * vU_[34] + vU_[7] * vU_[52] + vU_[44] * vU_[43] + vU_[42] * vU_[68];
    vU_[37] = 0 - vU_[46];
    vU_[52] =
        vU_[6] * vU_[34] + vU_[29] * vU_[52] + vU_[49] * vU_[43] + vU_[41] * vU_[68] + (vU_[16] * vU_[37]) / vU_[22];
    vU_[64] = (vU_[26] * vU_[36]) / vU_[26] + vU_[64] + (-0.00021200017 * vU_[37]) / vU_[22];
    vU_[34] = vU_[29] * vU_[68] + vU_[24] * vU_[43] + (vU_[18] * vU_[37]) / vU_[22];
    vU_[32] = vU_[20] * vU_[52] + vU_[50] * vU_[64];
    vU_[45] = 0 - vU_[32];
    vU_[64] = vU_[50] * vU_[52] + vU_[3] * vU_[64] + -0.304 * vU_[34] + (vU_[30] * vU_[45]) / vU_[60];
    vU_[52] = vU_[48] * 4.17019241133987 + (vU_[11] * vU_[36]) / vU_[26] + (vU_[54] * vU_[37]) / vU_[22];
    vU_[68] = vU_[6] * vU_[68] + vU_[29] * vU_[43] + (vU_[15] * vU_[37]) / vU_[22];
    vU_[46] = vU_[4] * vU_[52] + -1 * (vU_[46] + (vU_[22] * vU_[37]) / vU_[22]) + vU_[33] * vU_[68] +
              (vU_[63] * vU_[45]) / vU_[60];
    vU_[34] = -1 * vU_[34] + (vU_[53] * vU_[45]) / vU_[60];
    vU_[68] = vU_[50] * vU_[68] + vU_[3] * vU_[52] + (vU_[62] * vU_[45]) / vU_[60];
    vU_[52] = 0 - vU_[38] * vU_[64] - vU_[2] * vU_[46] - vU_[21] * vU_[34] - vU_[28] * vU_[68];
    jac[66] = (0 -
                  vU_[67] * (vU_[1] * vU_[64] + vU_[38] * vU_[46] + vU_[65] * vU_[34] + vU_[35] * vU_[68] +
                                (vU_[66] * vU_[52]) / vU_[27]) -
                  vU_[0] * ((vU_[60] * vU_[45]) / vU_[60] + vU_[32] + (-0.022851627 * vU_[52]) / vU_[27])) /
              vU_[56];
    vU_[67] = vU_[67] * jac[66];
    vU_[0] = vU_[0] * jac[66];
    jac[67] = (vU_[52] - vU_[66] * vU_[67] - -0.022851627 * vU_[0]) / vU_[27];
    vU_[1] = vU_[38] * jac[67] + vU_[1] * vU_[67];
    vU_[38] = vU_[2] * jac[67] + vU_[38] * vU_[67];
    vU_[28] = vU_[28] * jac[67] + vU_[35] * vU_[67];
    vU_[67] = vU_[21] * jac[67] + vU_[65] * vU_[67];
    jac[68] =
        (vU_[45] - vU_[60] * vU_[0] - vU_[30] * vU_[1] - vU_[63] * vU_[38] - vU_[62] * vU_[28] - vU_[53] * vU_[67]) /
        vU_[60];
    vU_[45] = -1 * vU_[38];
    vU_[0] = vU_[0] + jac[68];
    vU_[20] = vU_[20] * vU_[0] + vU_[50] * vU_[1];
    vU_[0] = vU_[50] * vU_[0] + vU_[3] * vU_[1];
    vU_[67] = -0.304 * vU_[1] + -1 * vU_[67];
    vU_[33] = vU_[50] * vU_[28] + vU_[33] * vU_[38];
    vU_[28] = vU_[3] * vU_[28] + vU_[4] * vU_[38];
    jac[69] = (vU_[37] - vU_[22] * vU_[45] - vU_[16] * vU_[20] - -0.00021200017 * vU_[0] - vU_[18] * vU_[67] -
                  vU_[15] * vU_[33] - vU_[54] * vU_[28]) /
              vU_[22];
    vU_[45] = vU_[45] + jac[69];
    vU_[37] = vU_[29] * vU_[45] + vU_[6] * vU_[20];
    vU_[7] = vU_[7] * vU_[45] + vU_[29] * vU_[20];
    vU_[24] = vU_[44] * vU_[45] + vU_[49] * vU_[20] + vU_[29] * vU_[33] + vU_[24] * vU_[67];
    jac[70] = (vU_[36] - vU_[26] * vU_[0] - vU_[47] * vU_[37] - vU_[17] * vU_[7] - vU_[11] * vU_[28] -
                  vU_[19] * (vU_[42] * vU_[45] + vU_[41] * vU_[20] + vU_[6] * vU_[33] + vU_[29] * vU_[67]) -
                  vU_[12] * vU_[24]) /
              vU_[26];
    vU_[0] = vU_[0] + jac[70];
    jac[71] = (1 - 0.009277 * vU_[37] - -0.000829 * (vU_[10] * vU_[0] + vU_[8] * vU_[7]) -
                  1.5e-05 * (vU_[8] * vU_[0] + vU_[9] * vU_[7]) -
                  0.038686875 * (vU_[8] * vU_[24] + vU_[51] * vU_[37] + vU_[48] * vU_[28])) /
              0.009277;


    return dFdu_;
}
}  // namespace tpl
}  // namespace HyA
}  // namespace models
}  // namespace ct
