/**********************************************************************************************************************
This file is part of the Control Toolbox (https://github.com/ethz-adrl/control-toolbox), copyright by ETH Zurich.
Licensed under the BSD-2 license (see LICENSE file in main directory)
**********************************************************************************************************************/
#include "HyAInverseDynHessian.h"

namespace ct {
namespace models {
namespace HyA {


HyAInverseDynHessian::HES_TYPE HyAInverseDynHessian::hessian(const Eigen::VectorXd& x_in, const Eigen::VectorXd& w_in)
{
    double* hes = hessian_.data();

    v_[0] = sin(x_in[1]);
    v_[1] = v_[0] * w_in[0];
    v_[2] = 0 - v_[1];
    v_[3] = v_[2] * w_in[1];
    v_[4] = cos(x_in[1]);
    v_[5] = v_[4] * w_in[0];
    v_[6] = v_[5] * w_in[1];
    v_[7] = 9.81 * v_[0];
    v_[8] = w_in[1] * w_in[1];
    v_[9] = cos(x_in[2]);
    v_[10] = sin(x_in[2]);
    v_[11] = 0 - v_[9];
    v_[12] = v_[10] * v_[5] + v_[11] * w_in[1];
    v_[13] = 0 - v_[12];
    v_[14] = v_[9] * v_[3] + v_[13] * w_in[2];
    v_[15] = v_[9] * v_[5] + v_[10] * w_in[1];
    v_[16] = v_[10] * v_[3] + v_[15] * w_in[2];
    v_[17] = 9.81 * v_[4];
    v_[18] = 0.112 * v_[9];
    v_[19] = -0.112 * v_[10];
    v_[20] = 0.112 * v_[9];
    v_[21] = v_[19] * v_[5] + v_[20] * w_in[1];
    v_[22] = v_[10] * v_[17] + v_[18] * v_[3] + v_[21] * w_in[2];
    v_[23] = v_[1] + w_in[2];
    v_[24] = 0 - v_[23] * v_[21];
    v_[25] = v_[15] * v_[23];
    v_[26] = v_[23] * v_[23];
    v_[27] = v_[12] * v_[12];
    v_[28] = cos(x_in[3]);
    v_[29] = -1 * v_[16];
    v_[30] = sin(x_in[3]);
    v_[31] = 0 - v_[30];
    v_[32] = v_[30] * v_[15] + v_[28] * v_[23];
    v_[33] = 0 - v_[32];
    v_[34] = v_[31] * v_[6] + v_[28] * v_[14] + v_[33] * w_in[3];
    v_[35] = v_[28] * v_[15] + v_[31] * v_[23];
    v_[36] = v_[28] * v_[6] + v_[30] * v_[14] + v_[35] * w_in[3];
    v_[37] = -0.304 * v_[14] + -1 * v_[22];
    v_[38] = 0.112 * v_[10];
    v_[39] = v_[18] * v_[5] + v_[38] * w_in[1];
    v_[40] = 0 - v_[39];
    v_[41] = v_[9] * v_[17] + v_[19] * v_[3] + v_[40] * w_in[2];
    v_[42] = -0.304 * v_[30];
    v_[43] = -0.304 * v_[28];
    v_[44] = v_[43] * v_[12] + v_[28] * v_[21];
    v_[45] = v_[28] * v_[7] + v_[30] * v_[41] + v_[42] * v_[16] + v_[44] * w_in[3];
    v_[46] = -0.304 * v_[15] + -1 * v_[39];
    v_[47] = -1 * v_[12] + w_in[3];
    v_[48] = v_[35] * v_[46] - v_[47] * v_[44];
    v_[49] = v_[35] * v_[47];
    v_[50] = v_[47] * v_[47];
    v_[51] = v_[32] * v_[32];
    v_[52] = cos(x_in[4]);
    v_[53] = sin(x_in[4]);
    v_[54] = 0 - v_[52];
    v_[55] = v_[53] * v_[35] + v_[54] * v_[47];
    v_[56] = 0 - v_[55];
    v_[57] = v_[53] * v_[29] + v_[52] * v_[34] + v_[56] * w_in[4];
    v_[58] = v_[52] * v_[35] + v_[53] * v_[47];
    v_[59] = v_[54] * v_[29] + v_[53] * v_[34] + v_[58] * w_in[4];
    v_[60] = 0.112 * v_[53];
    v_[61] = 0.112 * v_[52];
    v_[62] = 0 - v_[52];
    v_[63] = 0 - v_[30];
    v_[64] = v_[42] * v_[12] + v_[30] * v_[21];
    v_[65] = 0 - v_[64];
    v_[66] = v_[63] * v_[7] + v_[28] * v_[41] + v_[43] * v_[16] + v_[65] * w_in[3];
    v_[67] = 0.112 * v_[52];
    v_[68] = -0.112 * v_[53];
    v_[69] = v_[67] * v_[47] + v_[68] * v_[35] + v_[53] * v_[46] + v_[52] * v_[44];
    v_[70] = v_[60] * v_[29] + v_[61] * v_[34] + v_[62] * v_[37] + v_[53] * v_[66] + v_[69] * w_in[4];
    v_[71] = v_[32] + w_in[4];
    v_[72] = v_[58] * v_[64] - v_[71] * v_[69];
    v_[73] = v_[58] * v_[71];
    v_[74] = v_[71] * v_[71];
    v_[75] = v_[55] * v_[55];
    v_[76] = sin(x_in[5]);
    v_[77] = cos(x_in[5]);
    v_[78] = 0.02075 * v_[76] + 0.184 * v_[77];
    v_[79] = 0 - v_[76];
    v_[80] = v_[60] * v_[47] + v_[61] * v_[35] + v_[62] * v_[46] + v_[53] * v_[44];
    v_[81] = 0.184 * v_[76] - 0.02075 * v_[77];
    v_[82] = v_[77] * v_[64] + v_[76] * v_[80] + v_[81] * v_[58];
    v_[83] = 0 - v_[82];
    v_[84] = v_[79] * v_[45] + v_[77] * v_[70] + v_[78] * v_[57] + v_[83] * w_in[5];
    v_[85] = v_[76] * v_[55] + v_[77] * v_[71];
    v_[86] = 0 - v_[76];
    v_[87] = v_[77] * v_[55] + v_[86] * v_[71];
    v_[88] = v_[85] * v_[87];
    v_[89] = 0.02075 * v_[71] + -0.184 * v_[55] + v_[69];
    v_[90] = v_[85] * v_[89];
    v_[91] = v_[58] + w_in[5];
    v_[92] = v_[91] * v_[82];
    v_[93] = 1.547475 * v_[84] + 0.038686875 * v_[57] + 0.038686875 * v_[88] + -1.547475 * (v_[90] - v_[92]);
    v_[94] = v_[79] * v_[64] + v_[77] * v_[80] + v_[78] * v_[58];
    v_[95] = v_[91] * v_[91];
    v_[96] = v_[87] * v_[87];
    v_[97] = 1.547475 * (v_[87] * v_[89] - v_[91] * v_[94]) +
             1.547475 * (v_[77] * v_[45] + v_[76] * v_[70] + v_[81] * v_[57] + v_[94] * w_in[5]) -
             0.038686875 * (v_[95] + v_[96]);
    v_[98] = 0 - v_[85];
    v_[99] = v_[86] * v_[36] + v_[77] * v_[59] + v_[98] * w_in[5];
    v_[100] = v_[77] * v_[36] + v_[76] * v_[59] + v_[87] * w_in[5];
    v_[101] = v_[85] * v_[91];
    v_[102] = v_[87] * v_[91];
    v_[103] = v_[85] * v_[85];
    v_[104] = v_[55] * v_[71];
    v_[105] = v_[55] * v_[58];
    v_[92] = -0.001243 * v_[36] + 0.029115 * v_[57] + -0.001387 * v_[59] + 0.057838 * v_[70] + 0.057838 * v_[72] +
             -0.001387 * v_[73] + -0.012652 * (v_[74] - v_[75]) + v_[78] * v_[93] + v_[81] * v_[97] +
             0.009277 * v_[57] + -0.000829 * v_[99] + 1.5e-05 * v_[100] + 0.038686875 * v_[84] + -0.00751 * v_[88] +
             0.038686875 * (v_[92] - v_[90]) + -0.000829 * v_[101] - 1.5e-05 * v_[102] - 0.000198 * (v_[96] - v_[103]) -
             -0.008386 * v_[104] - -0.001243 * v_[105];
    v_[90] = 0 - v_[80];
    v_[84] = v_[67] * v_[29] + v_[68] * v_[34] + v_[53] * v_[37] + v_[52] * v_[66] + v_[90] * w_in[4];
    v_[106] = v_[55] * v_[64] - v_[71] * v_[80];
    v_[107] = 0.02075 * v_[36] + -0.184 * v_[59] + v_[84];
    v_[108] = v_[85] * v_[94] - v_[87] * v_[82];
    v_[103] = -0.000829 * v_[57] + 0.003227 * v_[99] + 0.000198 * v_[100] + -0.038686875 * v_[107] +
              0.000198 * v_[102] + 1.5e-05 * (v_[95] - v_[103]) - 0.038686875 * v_[108] - -0.00146 * v_[101] -
              -0.000829 * v_[88];
    v_[102] = 1.5e-05 * v_[57] + 0.000198 * v_[99] + 0.010737 * v_[100] + 0.00605 * v_[102] + 1.5e-05 * v_[88] -
              0.000198 * v_[101] - -0.000829 * (v_[95] - v_[96]);
    v_[108] = 1.547475 * v_[107] + -0.038686875 * v_[99] + 0.038686875 * v_[101] + 1.547475 * v_[108];
    v_[107] = v_[58] * v_[58];
    v_[74] = -0.012652 * v_[36] + -0.001387 * v_[57] + 0.019432 * v_[59] + -0.057838 * v_[84] + -0.018069 * v_[73] +
             0.057838 * v_[106] + -0.012652 * v_[105] + v_[77] * v_[103] + v_[76] * v_[102] + -0.184 * v_[108] -
             -0.001387 * v_[104] - -0.001243 * (v_[74] - v_[107]);
    v_[106] = 2.1032 * v_[84] + -0.057838 * v_[59] + 0.057838 * v_[73] + -2.1032 * v_[106] + v_[108];
    v_[72] =
        2.1032 * v_[70] + 0.057838 * v_[57] + 0.057838 * v_[104] + 2.1032 * v_[72] + v_[77] * v_[93] + v_[76] * v_[97];
    v_[84] = v_[32] * v_[44] - v_[35] * v_[64];
    v_[101] = v_[32] * v_[47];
    v_[99] = v_[32] * v_[35];
    v_[100] = -0.0022920002 * v_[29] + 0.01828449 * v_[34] + 0.0036857284 * v_[36] + -0.160298259823722 * v_[37] +
              1.52322944854339e-09 * v_[45] + 1.52322944854339e-09 * v_[48] + 0.0036857284 * v_[49] +
              -0.00021200017 * (v_[50] - v_[51]) + v_[52] * v_[92] + v_[53] * v_[74] + v_[68] * v_[106] +
              v_[61] * v_[72] - 0.160298259823722 * v_[84] - 0.01404749 * v_[101] - -0.0022920002 * v_[99];
    v_[96] = v_[32] * v_[46];
    v_[95] = v_[47] * v_[64];
    v_[88] = v_[35] * v_[35];
    v_[108] = -0.00021200017 * v_[29] + 0.0036857284 * v_[34] + 0.081661 * v_[36] + -0.008711861 * v_[37] +
              -1.52322944854339e-09 * v_[66] + -0.008711861 * v_[84] + 1.52322944854339e-09 * (v_[96] - v_[95]) +
              0.077424 * v_[49] + -0.00021200017 * v_[99] + 0.011046 * v_[36] + -0.001243 * v_[57] +
              -0.012652 * v_[59] + -0.001243 * v_[104] + 0.009683 * v_[105] + v_[86] * v_[103] + v_[77] * v_[102] +
              0.02075 * v_[108] - -0.012652 * v_[73] - -0.001387 * (v_[107] - v_[75]) - 0.0036857284 * v_[101] -
              -0.0022920002 * (v_[50] - v_[88]);
    v_[84] = -0.160298259823722 * v_[34] + -0.008711861 * v_[36] + 1.7423722 * v_[37] + 1.7423722 * v_[84] +
             0.160298259823722 * v_[101] + -0.008711861 * v_[49] + v_[53] * v_[106] + v_[62] * v_[72] -
             1.52322944854339e-09 * (v_[88] + v_[51]);
    v_[105] = v_[12] * v_[21] - v_[15] * v_[39];
    v_[104] = v_[12] * v_[23];
    v_[73] = v_[12] * v_[15];
    v_[109] = -0.0037997814 * v_[6] + 0.20986895 * v_[14] + 5.399998e-05 * v_[16] + 0.0055615274403 * v_[7] +
              0.647967112 * v_[22] + 0.647967112 * v_[24] + 5.399998e-05 * v_[25] + -0.011715295 * (v_[26] - v_[27]) +
              v_[28] * v_[100] + v_[30] * v_[108] + -0.304 * v_[84] - -0.0055615274403 * v_[105] -
              -0.192033951 * v_[104] - -0.0037997814 * v_[73];
    v_[110] = v_[23] * v_[39];
    v_[111] = 0 - v_[110];
    v_[112] = 0.160298259823722 * v_[29] + -1.52322944854339e-09 * v_[36] + 1.7423722 * v_[66] +
              -1.7423722 * (v_[96] - v_[95]) + 0.160298259823722 * v_[99] + 1.52322944854339e-09 * v_[49] +
              v_[52] * v_[106] + v_[53] * v_[72] - -0.008711861 * (v_[50] + v_[51]);
    v_[107] = 0.008711861 * v_[29] + 1.52322944854339e-09 * v_[34] + 1.7423722 * v_[45] + 1.7423722 * v_[48] +
              1.52322944854339e-09 * v_[101] + -0.008711861 * v_[99] + 2.1032 * (v_[55] * v_[69] - v_[58] * v_[80]) +
              2.1032 * v_[45] + v_[79] * v_[93] + v_[77] * v_[97] - 0.160298259823722 * (v_[50] + v_[88]) -
              0.057838 * (v_[107] + v_[75]);
    v_[75] = v_[15] * v_[15];
    v_[105] =
        -0.011715295 * v_[6] + 5.399998e-05 * v_[14] + 0.20236395 * v_[16] + 0.01438086 * v_[7] +
        -0.647967112 * v_[41] + 0.01438086 * v_[105] + 0.647967112 * v_[111] + -0.199538951 * v_[25] +
        -0.011715295 * v_[73] + v_[43] * v_[112] + v_[42] * v_[107] +
        -1 * (0.09570849 * v_[29] + -0.0022920002 * v_[34] + -0.00021200017 * v_[36] + 0.160298259823722 * v_[66] +
                 0.008711861 * v_[45] + 0.160298259823722 * (v_[95] - v_[96]) + -0.06337651 * v_[99] +
                 -0.0022920002 * v_[101] + v_[53] * v_[92] + v_[54] * v_[74] + v_[67] * v_[106] + v_[60] * v_[72] -
                 -0.008711861 * v_[48] - -0.00021200017 * v_[49] - 0.0036857284 * (v_[88] - v_[51])) -
        5.399998e-05 * v_[104] - -0.0037997814 * (v_[26] - v_[75]);
    v_[111] = -0.0055615274403 * v_[6] + -0.647967112 * v_[16] + 2.327 * v_[41] + -2.327 * v_[111] +
              -0.0055615274403 * v_[73] + 0.647967112 * v_[25] + v_[28] * v_[112] + v_[30] * v_[107] -
              0.01438086 * (v_[26] + v_[27]);
    v_[84] = -0.01438086 * v_[6] + 0.647967112 * v_[14] + 2.327 * v_[22] + 2.327 * v_[24] + 0.647967112 * v_[104] +
             0.01438086 * v_[73] + -1 * v_[84] - -0.0055615274403 * (v_[26] + v_[75]);
    v_[26] = v_[1] * w_in[1];
    v_[88] = v_[1] * v_[5];
    v_[95] = w_in[6] * v_[4];
    v_[96] = w_in[7] * v_[38] + v_[95] * v_[18];
    v_[99] = w_in[7] * v_[10] + v_[95] * v_[9];
    v_[101] = v_[96] * -1 + v_[99] * -0.304;
    v_[51] = w_in[7] * v_[20] + v_[95] * v_[19];
    v_[49] = w_in[7] * v_[11] + v_[95] * v_[10];
    v_[48] = v_[51] * v_[28] + v_[49] * v_[43];
    v_[50] = w_in[9] + v_[49] * -1;
    v_[113] = w_in[6] * v_[0];
    v_[114] = w_in[8] + v_[113];
    v_[115] = v_[114] * v_[31] + v_[99] * v_[28];
    v_[116] = v_[101] * v_[53] + v_[48] * v_[52] + v_[50] * v_[67] + v_[115] * v_[68];
    v_[117] = v_[114] * v_[28] + v_[99] * v_[30];
    v_[118] = w_in[10] + v_[117];
    v_[119] = v_[50] * v_[54] + v_[115] * v_[53];
    v_[120] = v_[116] + v_[118] * 0.02075 + v_[119] * -0.184;
    v_[121] = v_[118] * v_[86] + v_[119] * v_[77];
    v_[122] = v_[120] * 1.547475 + v_[121] * -0.038686875;
    v_[123] = v_[122] + v_[116] * 2.1032 + v_[119] * -0.057838;
    v_[124] = v_[51] * v_[30] + v_[49] * v_[42];
    v_[125] = v_[101] * v_[62] + v_[48] * v_[53] + v_[50] * v_[60] + v_[115] * v_[61];
    v_[126] = v_[50] * v_[53] + v_[115] * v_[52];
    v_[127] = v_[124] * v_[79] + v_[125] * v_[77] + v_[126] * v_[78];
    v_[128] = w_in[11] + v_[126];
    v_[129] = v_[127] * 1.547475 + v_[128] * 0.038686875;
    v_[130] = v_[124] * v_[77] + v_[125] * v_[76] + v_[126] * v_[81];
    v_[131] = v_[130] * 1.547475;
    v_[132] = v_[129] * v_[77] + v_[131] * v_[76] + v_[125] * 2.1032 + v_[126] * 0.057838;
    v_[133] = v_[123] * v_[52] + v_[132] * v_[53] + v_[48] * 1.7423722 + v_[50] * 0.160298259823722 +
              v_[117] * -1.52322944854339e-09;
    v_[134] = v_[129] * v_[79] + v_[131] * v_[77] + v_[124] * 2.1032 + v_[124] * 1.7423722 + v_[50] * 0.008711861 +
              v_[115] * 1.52322944854339e-09;
    v_[135] = v_[133] * v_[28] + v_[134] * v_[30] + v_[51] * 2.327 + v_[114] * -0.0055615274403 + v_[49] * -0.647967112;
    v_[136] = v_[123] * v_[53] + v_[132] * v_[62] + v_[101] * 1.7423722 + v_[115] * -0.160298259823722 +
              v_[117] * -0.008711861;
    v_[137] = v_[136] * -1 + v_[96] * 2.327 + v_[114] * -0.01438086 + v_[99] * 0.647967112;
    v_[138] = v_[130] * 1.547475;
    v_[139] = v_[127] * -1.547475;
    v_[140] = v_[128] * 0.038686875;
    v_[141] = v_[139] - v_[140];
    v_[142] = v_[138] * v_[87] + v_[141] * v_[85];
    v_[143] = v_[125] * 2.1032 + v_[126] * 0.057838;
    v_[144] = 0 - v_[143];
    v_[145] = v_[124] * 2.1032;
    v_[146] = v_[142] + v_[144] * v_[71] + v_[145] * v_[55] + v_[132] * w_in[4];
    v_[147] = 0 - v_[138];
    v_[148] = v_[120] * 1.547475 + (0 - v_[121]) * 0.038686875;
    v_[149] = v_[147] * v_[91] + v_[148] * v_[85] + v_[131] * w_in[5];
    v_[140] = 0 - v_[139] + v_[140];
    v_[139] = 0 - v_[148];
    v_[150] = v_[140] * v_[91] + v_[139] * v_[87] - v_[129] * w_in[5];
    v_[151] = v_[116] * -2.1032 + v_[119] * 0.057838;
    v_[152] = 0 - v_[151];
    v_[153] = 0 - v_[145];
    v_[154] = v_[149] * v_[77] + v_[150] * v_[76] + v_[152] * v_[71] + v_[153] * v_[58] - v_[123] * w_in[4];
    v_[155] = v_[124] * 1.7423722 + (0 - v_[50]) * -0.008711861 + v_[115] * 1.52322944854339e-09;
    v_[156] = 0 - v_[155];
    v_[157] = v_[101] * 1.7423722 + (0 - v_[115]) * 0.160298259823722 + v_[117] * -0.008711861;
    v_[158] = v_[146] * v_[52] + v_[154] * v_[53] + v_[156] * v_[47] + v_[157] * v_[32] + v_[134] * w_in[3];
    v_[159] = v_[48] * -1.7423722;
    v_[160] = v_[50] * 0.160298259823722;
    v_[161] = v_[117] * 1.52322944854339e-09;
    v_[162] = 0 - v_[159] + v_[160] - v_[161];
    v_[163] = 0 - v_[157];
    v_[164] = v_[149] * v_[79] + v_[150] * v_[77] + v_[143] * v_[58] + v_[151] * v_[55] + v_[162] * v_[47] +
              v_[163] * v_[35] - v_[133] * w_in[3];
    v_[165] = 0 - (v_[96] * 2.327 + (0 - v_[114]) * 0.01438086 + v_[99] * 0.647967112);
    v_[166] = (0 - v_[99]) * -0.0055615274403 + v_[49] * 0.01438086;
    v_[167] = v_[158] * v_[28] + v_[164] * v_[30] + v_[165] * v_[23] + v_[166] * v_[12] + v_[137] * w_in[2];
    v_[161] = v_[159] - v_[160] + v_[161];
    v_[160] = v_[146] * v_[53] + v_[154] * v_[62] + v_[155] * v_[35] + v_[161] * v_[32];
    v_[159] = v_[114] * -0.0055615274403 - (v_[51] * -2.327 + v_[49] * 0.647967112);
    v_[168] = 0 - v_[166];
    v_[169] = v_[160] * -1 + v_[159] * v_[23] + v_[168] * v_[15] - v_[135] * w_in[2];
    v_[170] = v_[118] * v_[77] + v_[119] * v_[76];
    v_[171] = (0 - v_[128]) * 1.5e-05 + v_[121] * 0.000198 + v_[170] * 0.00605;
    v_[172] = v_[120] * 0.038686875 + v_[128] * -0.000829 + (0 - v_[121]) * -0.00146 + (0 - v_[170]) * 0.000198;
    v_[130] = (0 - v_[130]) * 0.038686875;
    v_[173] = v_[121] * 1.5e-05;
    v_[174] = (0 - v_[170]) * -0.000829;
    v_[175] = v_[130] + v_[173] + v_[174];
    v_[176] = v_[116] * 0.057838 + (0 - v_[118]) * -0.012652 + v_[126] * -0.001387 + v_[119] * -0.018069;
    v_[177] = v_[118] * 0.009683 + (0 - v_[126]) * -0.001243 + v_[119] * -0.012652;
    v_[178] = (0 - v_[124]) * 0.057838;
    v_[179] = (0 - v_[118]) * -0.001387;
    v_[180] = (0 - v_[119]) * -0.001243;
    v_[181] = v_[178] + v_[179] - v_[180];
    v_[120] = v_[120] * -0.038686875 + v_[128] * -0.000829 + v_[121] * 0.003227 + v_[170] * 0.000198;
    v_[182] = v_[128] * 1.5e-05 + v_[121] * 0.000198 + v_[170] * 0.010737;
    v_[116] = v_[122] * -0.184 + v_[120] * v_[77] + v_[182] * v_[76] + v_[116] * -0.057838 + v_[118] * -0.012652 +
              v_[126] * -0.001387 + v_[119] * 0.019432;
    v_[183] = v_[147] * v_[94] + v_[140] * v_[82] + v_[171] * v_[87] + v_[172] * v_[85] + v_[175] * v_[91] +
              v_[175] * v_[91] + v_[149] * v_[78] + v_[150] * v_[81] + v_[143] * v_[64] + v_[153] * v_[80] +
              v_[176] * v_[71] + v_[177] * v_[55] + v_[181] * v_[58] + v_[181] * v_[58] + v_[116] * w_in[4];
    v_[184] = v_[127] * 0.038686875 + v_[128] * -0.00751 + (0 - v_[121]) * -0.000829 + v_[170] * 1.5e-05;
    v_[185] = (0 - v_[128]) * 0.000198;
    v_[174] = v_[130] + v_[185] - v_[174];
    v_[130] = v_[138] * v_[89] + v_[139] * v_[82] + v_[171] * v_[91] + v_[184] * v_[85] + v_[174] * v_[87] +
              v_[174] * v_[87] + v_[182] * w_in[5];
    v_[185] = 0 - v_[185] - v_[173];
    v_[173] = v_[141] * v_[89] + v_[148] * v_[94] + v_[172] * v_[91] + v_[184] * v_[87] + v_[185] * v_[85] +
              v_[185] * v_[85] - v_[120] * w_in[5];
    v_[186] = v_[125] * 0.057838 + v_[118] * -0.001243 + (0 - v_[126]) * -0.008386 + (0 - v_[119]) * -0.001387;
    v_[187] = v_[126] * -0.012652;
    v_[179] = v_[178] - v_[179] - v_[187];
    v_[170] = v_[127] * 0.038686875 + v_[128] * 0.009277 + v_[121] * -0.000829 + v_[170] * 1.5e-05 + v_[129] * v_[78] +
              v_[131] * v_[81] + v_[125] * 0.057838 + v_[118] * -0.001243 + v_[126] * 0.029115 + v_[119] * -0.001387;
    v_[128] = v_[142] * -0.184 + v_[130] * v_[77] + v_[173] * v_[76] + v_[151] * v_[64] + v_[145] * v_[69] +
              v_[186] * v_[71] + v_[177] * v_[58] + v_[179] * v_[55] + v_[179] * v_[55] - v_[170] * w_in[4];
    v_[127] = v_[101] * -0.008711861 + v_[48] * 1.52322944854339e-09 + (0 - v_[50]) * -0.00021200017 +
              v_[115] * 0.0036857284 + v_[117] * 0.077424;
    v_[121] = v_[48] * 0.160298259823722 + v_[124] * -0.008711861 + v_[50] * -0.06337651 +
              (0 - v_[115]) * -0.0022920002 + v_[117] * -0.00021200017;
    v_[178] = (0 - v_[101]) * 1.52322944854339e-09;
    v_[188] = (0 - v_[124]) * 0.160298259823722;
    v_[189] = (0 - v_[50]) * 0.0036857284;
    v_[190] = (0 - v_[117]) * -0.0022920002;
    v_[191] = v_[178] + v_[188] + v_[189] - v_[190];
    v_[122] = v_[122] * 0.02075 + v_[120] * v_[86] + v_[182] * v_[77] + v_[118] * 0.011046 + v_[126] * -0.001243 +
              v_[119] * -0.012652 + v_[101] * -0.008711861 + v_[48] * -1.52322944854339e-09 + v_[50] * -0.00021200017 +
              v_[115] * 0.0036857284 + v_[117] * 0.081661;
    v_[192] = v_[146] * v_[68] + v_[154] * v_[61] + v_[183] * v_[52] + v_[128] * v_[53] + v_[155] * v_[46] +
              v_[163] * v_[64] + v_[127] * v_[47] + v_[121] * v_[32] + v_[191] * v_[35] + v_[191] * v_[35] +
              v_[122] * w_in[3];
    v_[187] = v_[187] + v_[180];
    v_[180] = v_[101] * 0.160298259823722 + v_[124] * 1.52322944854339e-09 + v_[50] * -0.0022920002 +
              (0 - v_[115]) * 0.01404749 + (0 - v_[117]) * 0.0036857284;
    v_[193] = (0 - v_[48]) * -0.008711861;
    v_[194] = v_[115] * -0.00021200017;
    v_[189] = v_[178] + v_[193] - v_[189] - v_[194];
    v_[178] = v_[123] * v_[68] + v_[132] * v_[61] + v_[170] * v_[52] + v_[116] * v_[53] + v_[101] * -0.160298259823722 +
              v_[124] * 1.52322944854339e-09 + v_[50] * -0.0022920002 + v_[115] * 0.01828449 + v_[117] * 0.0036857284;
    v_[142] = v_[142] * 0.02075 + v_[130] * v_[86] + v_[173] * v_[77] + v_[144] * v_[69] + v_[152] * v_[80] +
              v_[176] * v_[58] + v_[186] * v_[55] + v_[187] * v_[71] + v_[187] * v_[71] + v_[161] * v_[46] +
              v_[157] * v_[44] + v_[180] * v_[47] + v_[121] * v_[35] + v_[189] * v_[32] + v_[189] * v_[32] -
              v_[178] * w_in[3];
    v_[195] = v_[51] * 0.647967112 + (0 - v_[114]) * -0.011715295 + v_[99] * 5.399998e-05 + v_[49] * -0.199538951;
    v_[196] = v_[51] * -0.0055615274403 + v_[96] * 0.01438086 + v_[114] * 0.00750500000000001 +
              (0 - v_[99]) * -0.0037997814 + v_[49] * -0.011715295;
    v_[197] = (0 - v_[96]) * -0.0055615274403;
    v_[198] = (0 - v_[114]) * 5.399998e-05;
    v_[199] = (0 - v_[49]) * -0.0037997814;
    v_[200] = v_[197] + v_[198] - v_[199];
    v_[117] = v_[133] * v_[43] + v_[134] * v_[42] +
              (v_[123] * v_[67] + v_[132] * v_[60] + v_[170] * v_[53] + v_[116] * v_[54] + v_[48] * 0.160298259823722 +
                  v_[124] * 0.008711861 + v_[50] * 0.09570849 + v_[115] * -0.0022920002 + v_[117] * -0.00021200017) *
                  -1 +
              v_[51] * -0.647967112 + v_[114] * -0.011715295 + v_[99] * 5.399998e-05 + v_[49] * 0.20236395;
    v_[160] = v_[160] * -0.304 + v_[192] * v_[28] + v_[142] * v_[30] + v_[168] * v_[39] + v_[195] * v_[23] +
              v_[196] * v_[12] + v_[200] * v_[15] + v_[200] * v_[15] + v_[117] * w_in[2];
    v_[194] = v_[193] + v_[188] + v_[194] + v_[190];
    v_[193] =
        v_[96] * 0.647967112 + v_[114] * -0.0037997814 + (0 - v_[99]) * -0.192033951 + (0 - v_[49]) * 5.399998e-05;
    v_[190] = (0 - v_[51]) * 0.01438086;
    v_[188] = v_[99] * -0.011715295;
    v_[198] = v_[190] - v_[198] - v_[188];
    v_[136] = v_[136] * -0.304 + v_[178] * v_[28] + v_[122] * v_[30] + v_[96] * 0.647967112 + v_[114] * -0.0037997814 +
              v_[99] * 0.20986895 + v_[49] * 5.399998e-05;
    v_[201] = v_[158] * v_[43] + v_[164] * v_[42] +
              (v_[146] * v_[67] + v_[154] * v_[60] + v_[183] * v_[53] + v_[128] * v_[54] + v_[156] * v_[44] +
                  v_[162] * v_[64] + v_[127] * v_[35] + v_[180] * v_[32] + v_[194] * v_[47] + v_[194] * v_[47]) *
                  -1 +
              v_[166] * v_[21] + v_[193] * v_[23] + v_[196] * v_[15] + v_[198] * v_[12] + v_[198] * v_[12] -
              v_[136] * w_in[2];
    v_[202] = w_in[7] * 0.046852534 + (0 - v_[95]) * -0.002752 + v_[113] * -0.022851627;
    v_[203] = (0 - w_in[7]) * 0.0055279857;
    v_[204] = v_[203] - (0 - v_[113]) * -0.002752;
    v_[96] = v_[178] * v_[31] + v_[122] * v_[28] + v_[51] * -0.0055615274403 + v_[96] * -0.01438086 +
             v_[114] * 0.010329999 + v_[99] * -0.0037997814 + v_[49] * -0.011715295 + w_in[7] * -0.022851627 +
             v_[95] * 0.0055279857 + v_[113] * 0.039002996 + (0 - w_in[7]) * -0.022851627 + v_[95] * 0.0055279857 +
             v_[113] * -0.034462002;
    v_[205] = v_[167] * v_[19] + v_[169] * v_[18] + v_[160] * v_[9] + v_[201] * v_[10] + v_[202] * v_[1] +
              v_[204] * v_[5] + v_[204] * v_[5] + v_[96] * w_in[1];
    v_[206] = cos(x_in[1]);
    v_[207] = v_[206] * w_in[0];
    v_[208] = -v_[207];
    v_[209] = v_[208] * w_in[1];
    v_[210] = sin(x_in[1]);
    v_[211] = 0 - v_[210];
    v_[212] = v_[211] * w_in[0];
    v_[213] = v_[212] * w_in[1];
    v_[214] = 9.81 * v_[206];
    v_[215] = v_[10] * v_[212];
    v_[216] = -v_[215];
    v_[217] = v_[9] * v_[209] + v_[216] * w_in[2];
    v_[218] = v_[9] * v_[212];
    v_[219] = v_[10] * v_[209] + v_[218] * w_in[2];
    v_[220] = 9.81 * v_[211];
    v_[221] = v_[19] * v_[212];
    v_[222] = v_[10] * v_[220] + v_[18] * v_[209] + v_[221] * w_in[2];
    v_[223] = -(v_[207] * v_[21] + v_[23] * v_[221]);
    v_[224] = v_[218] * v_[23] + v_[15] * v_[207];
    v_[225] = v_[207] * v_[23] + v_[23] * v_[207];
    v_[226] = v_[215] * v_[12] + v_[12] * v_[215];
    v_[227] = -1 * v_[219];
    v_[228] = v_[30] * v_[218] + v_[28] * v_[207];
    v_[229] = -v_[228];
    v_[230] = v_[31] * v_[213] + v_[28] * v_[217] + v_[229] * w_in[3];
    v_[231] = v_[28] * v_[218] + v_[31] * v_[207];
    v_[232] = v_[28] * v_[213] + v_[30] * v_[217] + v_[231] * w_in[3];
    v_[233] = -0.304 * v_[217] + -1 * v_[222];
    v_[234] = v_[18] * v_[212];
    v_[235] = -v_[234];
    v_[236] = v_[9] * v_[220] + v_[19] * v_[209] + v_[235] * w_in[2];
    v_[237] = v_[43] * v_[215] + v_[28] * v_[221];
    v_[238] = v_[28] * v_[214] + v_[30] * v_[236] + v_[42] * v_[219] + v_[237] * w_in[3];
    v_[239] = -0.304 * v_[218] + -1 * v_[234];
    v_[240] = -1 * v_[215];
    v_[241] = v_[231] * v_[46] + v_[35] * v_[239] - (v_[240] * v_[44] + v_[47] * v_[237]);
    v_[242] = v_[231] * v_[47] + v_[35] * v_[240];
    v_[243] = v_[240] * v_[47] + v_[47] * v_[240];
    v_[244] = v_[228] * v_[32] + v_[32] * v_[228];
    v_[245] = v_[53] * v_[231] + v_[54] * v_[240];
    v_[246] = -v_[245];
    v_[247] = v_[53] * v_[227] + v_[52] * v_[230] + v_[246] * w_in[4];
    v_[248] = v_[52] * v_[231] + v_[53] * v_[240];
    v_[249] = v_[54] * v_[227] + v_[53] * v_[230] + v_[248] * w_in[4];
    v_[250] = v_[42] * v_[215] + v_[30] * v_[221];
    v_[251] = -v_[250];
    v_[252] = v_[63] * v_[214] + v_[28] * v_[236] + v_[43] * v_[219] + v_[251] * w_in[3];
    v_[253] = v_[67] * v_[240] + v_[68] * v_[231] + v_[53] * v_[239] + v_[52] * v_[237];
    v_[254] = v_[60] * v_[227] + v_[61] * v_[230] + v_[62] * v_[233] + v_[53] * v_[252] + v_[253] * w_in[4];
    v_[255] = v_[248] * v_[64] + v_[58] * v_[250] - (v_[228] * v_[69] + v_[71] * v_[253]);
    v_[256] = v_[248] * v_[71] + v_[58] * v_[228];
    v_[257] = v_[228] * v_[71] + v_[71] * v_[228];
    v_[258] = v_[245] * v_[55] + v_[55] * v_[245];
    v_[259] = v_[60] * v_[240] + v_[61] * v_[231] + v_[62] * v_[239] + v_[53] * v_[237];
    v_[260] = v_[77] * v_[250] + v_[76] * v_[259] + v_[81] * v_[248];
    v_[261] = -v_[260];
    v_[262] = v_[79] * v_[238] + v_[77] * v_[254] + v_[78] * v_[247] + v_[261] * w_in[5];
    v_[263] = v_[76] * v_[245] + v_[77] * v_[228];
    v_[264] = v_[77] * v_[245] + v_[86] * v_[228];
    v_[265] = v_[263] * v_[87] + v_[85] * v_[264];
    v_[266] = 0.02075 * v_[228] + -0.184 * v_[245] + v_[253];
    v_[267] = v_[263] * v_[89] + v_[85] * v_[266];
    v_[268] = v_[248] * v_[82] + v_[91] * v_[260];
    v_[269] = 1.547475 * v_[262] + 0.038686875 * v_[247] + 0.038686875 * v_[265] + -1.547475 * (v_[267] - v_[268]);
    v_[270] = v_[79] * v_[250] + v_[77] * v_[259] + v_[78] * v_[248];
    v_[271] = v_[248] * v_[91] + v_[91] * v_[248];
    v_[272] = v_[264] * v_[87] + v_[87] * v_[264];
    v_[273] = 1.547475 * (v_[264] * v_[89] + v_[87] * v_[266] - (v_[248] * v_[94] + v_[91] * v_[270])) +
              1.547475 * (v_[77] * v_[238] + v_[76] * v_[254] + v_[81] * v_[247] + v_[270] * w_in[5]) -
              0.038686875 * (v_[271] + v_[272]);
    v_[274] = -v_[263];
    v_[275] = v_[86] * v_[232] + v_[77] * v_[249] + v_[274] * w_in[5];
    v_[276] = v_[77] * v_[232] + v_[76] * v_[249] + v_[264] * w_in[5];
    v_[277] = v_[263] * v_[91] + v_[85] * v_[248];
    v_[278] = v_[264] * v_[91] + v_[87] * v_[248];
    v_[279] = v_[263] * v_[85] + v_[85] * v_[263];
    v_[280] = v_[245] * v_[71] + v_[55] * v_[228];
    v_[281] = v_[245] * v_[58] + v_[55] * v_[248];
    v_[268] = -0.001243 * v_[232] + 0.029115 * v_[247] + -0.001387 * v_[249] + 0.057838 * v_[254] + 0.057838 * v_[255] +
              -0.001387 * v_[256] + -0.012652 * (v_[257] - v_[258]) + v_[78] * v_[269] + v_[81] * v_[273] +
              0.009277 * v_[247] + -0.000829 * v_[275] + 1.5e-05 * v_[276] + 0.038686875 * v_[262] +
              -0.00751 * v_[265] + 0.038686875 * (v_[268] - v_[267]) + -0.000829 * v_[277] - 1.5e-05 * v_[278] -
              0.000198 * (v_[272] - v_[279]) - -0.008386 * v_[280] - -0.001243 * v_[281];
    v_[267] = -v_[259];
    v_[262] = v_[67] * v_[227] + v_[68] * v_[230] + v_[53] * v_[233] + v_[52] * v_[252] + v_[267] * w_in[4];
    v_[282] = v_[245] * v_[64] + v_[55] * v_[250] - (v_[228] * v_[80] + v_[71] * v_[259]);
    v_[283] = 0.02075 * v_[232] + -0.184 * v_[249] + v_[262];
    v_[284] = v_[263] * v_[94] + v_[85] * v_[270] - (v_[264] * v_[82] + v_[87] * v_[260]);
    v_[279] = -0.000829 * v_[247] + 0.003227 * v_[275] + 0.000198 * v_[276] + -0.038686875 * v_[283] +
              0.000198 * v_[278] + 1.5e-05 * (v_[271] - v_[279]) - 0.038686875 * v_[284] - -0.00146 * v_[277] -
              -0.000829 * v_[265];
    v_[278] = 1.5e-05 * v_[247] + 0.000198 * v_[275] + 0.010737 * v_[276] + 0.00605 * v_[278] + 1.5e-05 * v_[265] -
              0.000198 * v_[277] - -0.000829 * (v_[271] - v_[272]);
    v_[284] = 1.547475 * v_[283] + -0.038686875 * v_[275] + 0.038686875 * v_[277] + 1.547475 * v_[284];
    v_[283] = v_[248] * v_[58] + v_[58] * v_[248];
    v_[257] = -0.012652 * v_[232] + -0.001387 * v_[247] + 0.019432 * v_[249] + -0.057838 * v_[262] +
              -0.018069 * v_[256] + 0.057838 * v_[282] + -0.012652 * v_[281] + v_[77] * v_[279] + v_[76] * v_[278] +
              -0.184 * v_[284] - -0.001387 * v_[280] - -0.001243 * (v_[257] - v_[283]);
    v_[282] = 2.1032 * v_[262] + -0.057838 * v_[249] + 0.057838 * v_[256] + -2.1032 * v_[282] + v_[284];
    v_[255] = 2.1032 * v_[254] + 0.057838 * v_[247] + 0.057838 * v_[280] + 2.1032 * v_[255] + v_[77] * v_[269] +
              v_[76] * v_[273];
    v_[262] = v_[228] * v_[44] + v_[32] * v_[237] - (v_[231] * v_[64] + v_[35] * v_[250]);
    v_[277] = v_[228] * v_[47] + v_[32] * v_[240];
    v_[275] = v_[228] * v_[35] + v_[32] * v_[231];
    v_[276] = -0.0022920002 * v_[227] + 0.01828449 * v_[230] + 0.0036857284 * v_[232] + -0.160298259823722 * v_[233] +
              1.52322944854339e-09 * v_[238] + 1.52322944854339e-09 * v_[241] + 0.0036857284 * v_[242] +
              -0.00021200017 * (v_[243] - v_[244]) + v_[52] * v_[268] + v_[53] * v_[257] + v_[68] * v_[282] +
              v_[61] * v_[255] - 0.160298259823722 * v_[262] - 0.01404749 * v_[277] - -0.0022920002 * v_[275];
    v_[272] = v_[228] * v_[46] + v_[32] * v_[239];
    v_[271] = v_[240] * v_[64] + v_[47] * v_[250];
    v_[265] = v_[231] * v_[35] + v_[35] * v_[231];
    v_[284] = -0.00021200017 * v_[227] + 0.0036857284 * v_[230] + 0.081661 * v_[232] + -0.008711861 * v_[233] +
              -1.52322944854339e-09 * v_[252] + -0.008711861 * v_[262] + 1.52322944854339e-09 * (v_[272] - v_[271]) +
              0.077424 * v_[242] + -0.00021200017 * v_[275] + 0.011046 * v_[232] + -0.001243 * v_[247] +
              -0.012652 * v_[249] + -0.001243 * v_[280] + 0.009683 * v_[281] + v_[86] * v_[279] + v_[77] * v_[278] +
              0.02075 * v_[284] - -0.012652 * v_[256] - -0.001387 * (v_[283] - v_[258]) - 0.0036857284 * v_[277] -
              -0.0022920002 * (v_[243] - v_[265]);
    v_[262] = -0.160298259823722 * v_[230] + -0.008711861 * v_[232] + 1.7423722 * v_[233] + 1.7423722 * v_[262] +
              0.160298259823722 * v_[277] + -0.008711861 * v_[242] + v_[53] * v_[282] + v_[62] * v_[255] -
              1.52322944854339e-09 * (v_[265] + v_[244]);
    v_[281] = v_[215] * v_[21] + v_[12] * v_[221] - (v_[218] * v_[39] + v_[15] * v_[234]);
    v_[280] = v_[215] * v_[23] + v_[12] * v_[207];
    v_[256] = v_[215] * v_[15] + v_[12] * v_[218];
    v_[285] = -0.0037997814 * v_[213] + 0.20986895 * v_[217] + 5.399998e-05 * v_[219] + 0.0055615274403 * v_[214] +
              0.647967112 * v_[222] + 0.647967112 * v_[223] + 5.399998e-05 * v_[224] +
              -0.011715295 * (v_[225] - v_[226]) + v_[28] * v_[276] + v_[30] * v_[284] + -0.304 * v_[262] -
              -0.0055615274403 * v_[281] - -0.192033951 * v_[280] - -0.0037997814 * v_[256];
    v_[286] = v_[207] * v_[39] + v_[23] * v_[234];
    v_[287] = -v_[286];
    v_[288] = 0.160298259823722 * v_[227] + -1.52322944854339e-09 * v_[232] + 1.7423722 * v_[252] +
              -1.7423722 * (v_[272] - v_[271]) + 0.160298259823722 * v_[275] + 1.52322944854339e-09 * v_[242] +
              v_[52] * v_[282] + v_[53] * v_[255] - -0.008711861 * (v_[243] + v_[244]);
    v_[283] = 0.008711861 * v_[227] + 1.52322944854339e-09 * v_[230] + 1.7423722 * v_[238] + 1.7423722 * v_[241] +
              1.52322944854339e-09 * v_[277] + -0.008711861 * v_[275] +
              2.1032 * (v_[245] * v_[69] + v_[55] * v_[253] - (v_[248] * v_[80] + v_[58] * v_[259])) +
              2.1032 * v_[238] + v_[79] * v_[269] + v_[77] * v_[273] - 0.160298259823722 * (v_[243] + v_[265]) -
              0.057838 * (v_[283] + v_[258]);
    v_[258] = v_[218] * v_[15] + v_[15] * v_[218];
    v_[281] =
        -0.011715295 * v_[213] + 5.399998e-05 * v_[217] + 0.20236395 * v_[219] + 0.01438086 * v_[214] +
        -0.647967112 * v_[236] + 0.01438086 * v_[281] + 0.647967112 * v_[287] + -0.199538951 * v_[224] +
        -0.011715295 * v_[256] + v_[43] * v_[288] + v_[42] * v_[283] +
        -1 * (0.09570849 * v_[227] + -0.0022920002 * v_[230] + -0.00021200017 * v_[232] + 0.160298259823722 * v_[252] +
                 0.008711861 * v_[238] + 0.160298259823722 * (v_[271] - v_[272]) + -0.06337651 * v_[275] +
                 -0.0022920002 * v_[277] + v_[53] * v_[268] + v_[54] * v_[257] + v_[67] * v_[282] + v_[60] * v_[255] -
                 -0.008711861 * v_[241] - -0.00021200017 * v_[242] - 0.0036857284 * (v_[265] - v_[244])) -
        5.399998e-05 * v_[280] - -0.0037997814 * (v_[225] - v_[258]);
    v_[287] = -0.0055615274403 * v_[213] + -0.647967112 * v_[219] + 2.327 * v_[236] + -2.327 * v_[287] +
              -0.0055615274403 * v_[256] + 0.647967112 * v_[224] + v_[28] * v_[288] + v_[30] * v_[283] -
              0.01438086 * (v_[225] + v_[226]);
    v_[262] = -0.01438086 * v_[213] + 0.647967112 * v_[217] + 2.327 * v_[222] + 2.327 * v_[223] +
              0.647967112 * v_[280] + 0.01438086 * v_[256] + -1 * v_[262] - -0.0055615274403 * (v_[225] + v_[258]);
    v_[225] = v_[207] * w_in[1];
    v_[265] = v_[207] * v_[5] + v_[1] * v_[212];
    v_[271] = w_in[6] * v_[211];
    v_[272] = v_[271] * v_[18];
    v_[275] = v_[271] * v_[9];
    v_[277] = v_[272] * -1 + v_[275] * -0.304;
    v_[244] = v_[271] * v_[19];
    v_[242] = v_[271] * v_[10];
    v_[241] = v_[244] * v_[28] + v_[242] * v_[43];
    v_[243] = v_[242] * -1;
    v_[289] = w_in[6] * v_[206];
    v_[290] = v_[289] * v_[31] + v_[275] * v_[28];
    v_[291] = v_[277] * v_[53] + v_[241] * v_[52] + v_[243] * v_[67] + v_[290] * v_[68];
    v_[292] = v_[289] * v_[28] + v_[275] * v_[30];
    v_[293] = v_[243] * v_[54] + v_[290] * v_[53];
    v_[294] = v_[291] + v_[292] * 0.02075 + v_[293] * -0.184;
    v_[295] = v_[292] * v_[86] + v_[293] * v_[77];
    v_[296] = v_[294] * 1.547475 + v_[295] * -0.038686875;
    v_[297] = v_[296] + v_[291] * 2.1032 + v_[293] * -0.057838;
    v_[298] = v_[244] * v_[30] + v_[242] * v_[42];
    v_[299] = v_[277] * v_[62] + v_[241] * v_[53] + v_[243] * v_[60] + v_[290] * v_[61];
    v_[300] = v_[243] * v_[53] + v_[290] * v_[52];
    v_[301] = v_[298] * v_[79] + v_[299] * v_[77] + v_[300] * v_[78];
    v_[302] = v_[301] * 1.547475 + v_[300] * 0.038686875;
    v_[303] = v_[298] * v_[77] + v_[299] * v_[76] + v_[300] * v_[81];
    v_[304] = v_[303] * 1.547475;
    v_[305] = v_[302] * v_[77] + v_[304] * v_[76] + v_[299] * 2.1032 + v_[300] * 0.057838;
    v_[306] = v_[297] * v_[52] + v_[305] * v_[53] + v_[241] * 1.7423722 + v_[243] * 0.160298259823722 +
              v_[292] * -1.52322944854339e-09;
    v_[307] = v_[302] * v_[79] + v_[304] * v_[77] + v_[298] * 2.1032 + v_[298] * 1.7423722 + v_[243] * 0.008711861 +
              v_[290] * 1.52322944854339e-09;
    v_[308] =
        v_[306] * v_[28] + v_[307] * v_[30] + v_[244] * 2.327 + v_[289] * -0.0055615274403 + v_[242] * -0.647967112;
    v_[309] = v_[297] * v_[53] + v_[305] * v_[62] + v_[277] * 1.7423722 + v_[290] * -0.160298259823722 +
              v_[292] * -0.008711861;
    v_[310] = v_[309] * -1 + v_[272] * 2.327 + v_[289] * -0.01438086 + v_[275] * 0.647967112;
    v_[311] = v_[303] * 1.547475;
    v_[312] = v_[301] * -1.547475;
    v_[313] = v_[300] * 0.038686875;
    v_[314] = v_[312] - v_[313];
    v_[315] = v_[138] * v_[264] + v_[311] * v_[87] + v_[141] * v_[263] + v_[314] * v_[85];
    v_[316] = v_[299] * 2.1032 + v_[300] * 0.057838;
    v_[317] = 0 - v_[316];
    v_[318] = v_[298] * 2.1032;
    v_[319] = v_[315] + v_[144] * v_[228] + v_[317] * v_[71] + v_[145] * v_[245] + v_[318] * v_[55] + v_[305] * w_in[4];
    v_[320] = 0 - v_[311];
    v_[321] = v_[294] * 1.547475 + (0 - v_[295]) * 0.038686875;
    v_[322] = v_[147] * v_[248] + v_[320] * v_[91] + v_[148] * v_[263] + v_[321] * v_[85] + v_[304] * w_in[5];
    v_[313] = 0 - v_[312] + v_[313];
    v_[312] = 0 - v_[321];
    v_[323] = v_[140] * v_[248] + v_[313] * v_[91] + v_[139] * v_[264] + v_[312] * v_[87] - v_[302] * w_in[5];
    v_[324] = v_[291] * -2.1032 + v_[293] * 0.057838;
    v_[325] = 0 - v_[324];
    v_[326] = 0 - v_[318];
    v_[327] = v_[322] * v_[77] + v_[323] * v_[76] + v_[152] * v_[228] + v_[325] * v_[71] + v_[153] * v_[248] +
              v_[326] * v_[58] - v_[297] * w_in[4];
    v_[328] = v_[298] * 1.7423722 + (0 - v_[243]) * -0.008711861 + v_[290] * 1.52322944854339e-09;
    v_[329] = 0 - v_[328];
    v_[330] = v_[277] * 1.7423722 + (0 - v_[290]) * 0.160298259823722 + v_[292] * -0.008711861;
    v_[331] = v_[319] * v_[52] + v_[327] * v_[53] + v_[156] * v_[240] + v_[329] * v_[47] + v_[157] * v_[228] +
              v_[330] * v_[32] + v_[307] * w_in[3];
    v_[332] = v_[241] * -1.7423722;
    v_[333] = v_[243] * 0.160298259823722;
    v_[334] = v_[292] * 1.52322944854339e-09;
    v_[335] = 0 - v_[332] + v_[333] - v_[334];
    v_[336] = 0 - v_[330];
    v_[337] = v_[322] * v_[79] + v_[323] * v_[77] + v_[143] * v_[248] + v_[316] * v_[58] + v_[151] * v_[245] +
              v_[324] * v_[55] + v_[162] * v_[240] + v_[335] * v_[47] + v_[163] * v_[231] + v_[336] * v_[35] -
              v_[306] * w_in[3];
    v_[338] = 0 - (v_[272] * 2.327 + (0 - v_[289]) * 0.01438086 + v_[275] * 0.647967112);
    v_[339] = (0 - v_[275]) * -0.0055615274403 + v_[242] * 0.01438086;
    v_[340] = v_[331] * v_[28] + v_[337] * v_[30] + v_[165] * v_[207] + v_[338] * v_[23] + v_[166] * v_[215] +
              v_[339] * v_[12] + v_[310] * w_in[2];
    v_[334] = v_[332] - v_[333] + v_[334];
    v_[333] = v_[319] * v_[53] + v_[327] * v_[62] + v_[155] * v_[231] + v_[328] * v_[35] + v_[161] * v_[228] +
              v_[334] * v_[32];
    v_[332] = v_[289] * -0.0055615274403 - (v_[244] * -2.327 + v_[242] * 0.647967112);
    v_[341] = 0 - v_[339];
    v_[342] =
        v_[333] * -1 + v_[159] * v_[207] + v_[332] * v_[23] + v_[168] * v_[218] + v_[341] * v_[15] - v_[308] * w_in[2];
    v_[343] = v_[292] * v_[77] + v_[293] * v_[76];
    v_[344] = (0 - v_[300]) * 1.5e-05 + v_[295] * 0.000198 + v_[343] * 0.00605;
    v_[345] = v_[294] * 0.038686875 + v_[300] * -0.000829 + (0 - v_[295]) * -0.00146 + (0 - v_[343]) * 0.000198;
    v_[303] = (0 - v_[303]) * 0.038686875;
    v_[346] = v_[295] * 1.5e-05;
    v_[347] = (0 - v_[343]) * -0.000829;
    v_[348] = v_[303] + v_[346] + v_[347];
    v_[348] = v_[147] * v_[270] + v_[320] * v_[94] + v_[140] * v_[260] + v_[313] * v_[82] + v_[171] * v_[264] +
              v_[344] * v_[87] + v_[172] * v_[263] + v_[345] * v_[85] + v_[175] * v_[248] + v_[175] * v_[248] +
              v_[348] * v_[91] + v_[348] * v_[91];
    v_[313] = v_[291] * 0.057838 + (0 - v_[292]) * -0.012652 + v_[300] * -0.001387 + v_[293] * -0.018069;
    v_[320] = v_[292] * 0.009683 + (0 - v_[300]) * -0.001243 + v_[293] * -0.012652;
    v_[175] = (0 - v_[298]) * 0.057838;
    v_[140] = (0 - v_[292]) * -0.001387;
    v_[147] = (0 - v_[293]) * -0.001243;
    v_[349] = v_[175] + v_[140] - v_[147];
    v_[294] = v_[294] * -0.038686875 + v_[300] * -0.000829 + v_[295] * 0.003227 + v_[343] * 0.000198;
    v_[350] = v_[300] * 1.5e-05 + v_[295] * 0.000198 + v_[343] * 0.010737;
    hes[23] = v_[129] * v_[261] + v_[302] * v_[83] + v_[131] * v_[270] + v_[304] * v_[94] + v_[120] * v_[274] +
              v_[294] * v_[98] + v_[182] * v_[264] + v_[350] * v_[87] + v_[348];
    v_[291] = v_[296] * -0.184 + v_[294] * v_[77] + v_[350] * v_[76] + v_[291] * -0.057838 + v_[292] * -0.012652 +
              v_[300] * -0.001387 + v_[293] * 0.019432;
    v_[349] = v_[348] + v_[322] * v_[78] + v_[323] * v_[81] + v_[143] * v_[250] + v_[316] * v_[64] + v_[153] * v_[259] +
              v_[326] * v_[80] + v_[176] * v_[228] + v_[313] * v_[71] + v_[177] * v_[245] + v_[320] * v_[55] +
              v_[181] * v_[248] + v_[181] * v_[248] + v_[349] * v_[58] + v_[349] * v_[58] + v_[291] * w_in[4];
    v_[348] = v_[301] * 0.038686875 + v_[300] * -0.00751 + (0 - v_[295]) * -0.000829 + v_[343] * 1.5e-05;
    v_[326] = (0 - v_[300]) * 0.000198;
    v_[347] = v_[303] + v_[326] - v_[347];
    v_[347] = v_[138] * v_[266] + v_[311] * v_[89] + v_[139] * v_[260] + v_[312] * v_[82] + v_[171] * v_[248] +
              v_[344] * v_[91] + v_[184] * v_[263] + v_[348] * v_[85] + v_[174] * v_[264] + v_[174] * v_[264] +
              v_[347] * v_[87] + v_[347] * v_[87] + v_[350] * w_in[5];
    v_[326] = 0 - v_[326] - v_[346];
    v_[326] = v_[141] * v_[266] + v_[314] * v_[89] + v_[148] * v_[270] + v_[321] * v_[94] + v_[172] * v_[248] +
              v_[345] * v_[91] + v_[184] * v_[264] + v_[348] * v_[87] + v_[185] * v_[263] + v_[185] * v_[263] +
              v_[326] * v_[85] + v_[326] * v_[85] - v_[294] * w_in[5];
    v_[348] = v_[299] * 0.057838 + v_[292] * -0.001243 + (0 - v_[300]) * -0.008386 + (0 - v_[293]) * -0.001387;
    v_[345] = v_[300] * -0.012652;
    v_[140] = v_[175] - v_[140] - v_[345];
    v_[343] = v_[301] * 0.038686875 + v_[300] * 0.009277 + v_[295] * -0.000829 + v_[343] * 1.5e-05 + v_[302] * v_[78] +
              v_[304] * v_[81] + v_[299] * 0.057838 + v_[292] * -0.001243 + v_[300] * 0.029115 + v_[293] * -0.001387;
    v_[140] = v_[315] * -0.184 + v_[347] * v_[77] + v_[326] * v_[76] + v_[151] * v_[250] + v_[324] * v_[64] +
              v_[145] * v_[253] + v_[318] * v_[69] + v_[186] * v_[228] + v_[348] * v_[71] + v_[177] * v_[248] +
              v_[320] * v_[58] + v_[179] * v_[245] + v_[179] * v_[245] + v_[140] * v_[55] + v_[140] * v_[55] -
              v_[343] * w_in[4];
    v_[320] = v_[277] * -0.008711861 + v_[241] * 1.52322944854339e-09 + (0 - v_[243]) * -0.00021200017 +
              v_[290] * 0.0036857284 + v_[292] * 0.077424;
    v_[324] = v_[241] * 0.160298259823722 + v_[298] * -0.008711861 + v_[243] * -0.06337651 +
              (0 - v_[290]) * -0.0022920002 + v_[292] * -0.00021200017;
    v_[318] = (0 - v_[277]) * 1.52322944854339e-09;
    v_[179] = (0 - v_[298]) * 0.160298259823722;
    v_[177] = (0 - v_[243]) * 0.0036857284;
    v_[151] = (0 - v_[292]) * -0.0022920002;
    v_[145] = v_[318] + v_[179] + v_[177] - v_[151];
    v_[296] = v_[296] * 0.02075 + v_[294] * v_[86] + v_[350] * v_[77] + v_[292] * 0.011046 + v_[300] * -0.001243 +
              v_[293] * -0.012652 + v_[277] * -0.008711861 + v_[241] * -1.52322944854339e-09 +
              v_[243] * -0.00021200017 + v_[290] * 0.0036857284 + v_[292] * 0.081661;
    v_[145] = v_[319] * v_[68] + v_[327] * v_[61] + v_[349] * v_[52] + v_[140] * v_[53] + v_[155] * v_[239] +
              v_[328] * v_[46] + v_[163] * v_[250] + v_[336] * v_[64] + v_[127] * v_[240] + v_[320] * v_[47] +
              v_[121] * v_[228] + v_[324] * v_[32] + v_[191] * v_[231] + v_[191] * v_[231] + v_[145] * v_[35] +
              v_[145] * v_[35] + v_[296] * w_in[3];
    v_[345] = v_[345] + v_[147];
    v_[345] = v_[315] * 0.02075 + v_[347] * v_[86] + v_[326] * v_[77] + v_[144] * v_[253] + v_[317] * v_[69] +
              v_[152] * v_[259] + v_[325] * v_[80] + v_[176] * v_[248] + v_[313] * v_[58] + v_[186] * v_[245] +
              v_[348] * v_[55] + v_[187] * v_[228] + v_[187] * v_[228] + v_[345] * v_[71] + v_[345] * v_[71];
    hes[22] = v_[123] * v_[267] + v_[297] * v_[90] + v_[132] * v_[253] + v_[305] * v_[69] + v_[170] * v_[246] +
              v_[343] * v_[56] + v_[116] * v_[248] + v_[291] * v_[58] + v_[345];
    v_[267] = v_[277] * 0.160298259823722 + v_[298] * 1.52322944854339e-09 + v_[243] * -0.0022920002 +
              (0 - v_[290]) * 0.01404749 + (0 - v_[292]) * 0.0036857284;
    v_[253] = (0 - v_[241]) * -0.008711861;
    v_[246] = v_[290] * -0.00021200017;
    v_[177] = v_[318] + v_[253] - v_[177] - v_[246];
    v_[318] = v_[297] * v_[68] + v_[305] * v_[61] + v_[343] * v_[52] + v_[291] * v_[53] + v_[277] * -0.160298259823722 +
              v_[298] * 1.52322944854339e-09 + v_[243] * -0.0022920002 + v_[290] * 0.01828449 + v_[292] * 0.0036857284;
    v_[177] = v_[345] + v_[161] * v_[239] + v_[334] * v_[46] + v_[157] * v_[237] + v_[330] * v_[44] +
              v_[180] * v_[240] + v_[267] * v_[47] + v_[121] * v_[231] + v_[324] * v_[35] + v_[189] * v_[228] +
              v_[189] * v_[228] + v_[177] * v_[32] + v_[177] * v_[32] - v_[318] * w_in[3];
    v_[345] = v_[244] * 0.647967112 + (0 - v_[289]) * -0.011715295 + v_[275] * 5.399998e-05 + v_[242] * -0.199538951;
    v_[324] = v_[244] * -0.0055615274403 + v_[272] * 0.01438086 + v_[289] * 0.00750500000000001 +
              (0 - v_[275]) * -0.0037997814 + v_[242] * -0.011715295;
    v_[334] = (0 - v_[272]) * -0.0055615274403;
    v_[330] = (0 - v_[289]) * 5.399998e-05;
    v_[189] = (0 - v_[242]) * -0.0037997814;
    v_[121] = v_[334] + v_[330] - v_[189];
    v_[161] = v_[306] * v_[43] + v_[307] * v_[42] +
              (v_[297] * v_[67] + v_[305] * v_[60] + v_[343] * v_[53] + v_[291] * v_[54] + v_[241] * 0.160298259823722 +
                  v_[298] * 0.008711861 + v_[243] * 0.09570849 + v_[290] * -0.0022920002 + v_[292] * -0.00021200017) *
                  -1 +
              v_[244] * -0.647967112 + v_[289] * -0.011715295 + v_[275] * 5.399998e-05 + v_[242] * 0.20236395;
    v_[121] = v_[333] * -0.304 + v_[145] * v_[28] + v_[177] * v_[30] + v_[168] * v_[234] + v_[341] * v_[39] +
              v_[195] * v_[207] + v_[345] * v_[23] + v_[196] * v_[215] + v_[324] * v_[12] + v_[200] * v_[218] +
              v_[200] * v_[218] + v_[121] * v_[15] + v_[121] * v_[15] + v_[161] * w_in[2];
    v_[246] = v_[253] + v_[179] + v_[246] + v_[151];
    v_[246] = v_[319] * v_[67] + v_[327] * v_[60] + v_[349] * v_[53] + v_[140] * v_[54] + v_[156] * v_[237] +
              v_[329] * v_[44] + v_[162] * v_[250] + v_[335] * v_[64] + v_[127] * v_[231] + v_[320] * v_[35] +
              v_[180] * v_[228] + v_[267] * v_[32] + v_[194] * v_[240] + v_[194] * v_[240] + v_[246] * v_[47] +
              v_[246] * v_[47];
    hes[21] = v_[133] * v_[251] + v_[306] * v_[65] + v_[134] * v_[237] + v_[307] * v_[44] + v_[178] * v_[229] +
              v_[318] * v_[33] + v_[122] * v_[231] + v_[296] * v_[35] + v_[246];
    v_[251] =
        v_[272] * 0.647967112 + v_[289] * -0.0037997814 + (0 - v_[275]) * -0.192033951 + (0 - v_[242]) * 5.399998e-05;
    v_[229] = (0 - v_[244]) * 0.01438086;
    v_[267] = v_[275] * -0.011715295;
    v_[330] = v_[229] - v_[330] - v_[267];
    v_[309] = v_[309] * -0.304 + v_[318] * v_[28] + v_[296] * v_[30] + v_[272] * 0.647967112 + v_[289] * -0.0037997814 +
              v_[275] * 0.20986895 + v_[242] * 5.399998e-05;
    v_[330] = v_[331] * v_[43] + v_[337] * v_[42] + v_[246] * -1 + v_[166] * v_[221] + v_[339] * v_[21] +
              v_[193] * v_[207] + v_[251] * v_[23] + v_[196] * v_[218] + v_[324] * v_[15] + v_[198] * v_[215] +
              v_[198] * v_[215] + v_[330] * v_[12] + v_[330] * v_[12] - v_[309] * w_in[2];
    v_[246] = (0 - v_[271]) * -0.002752 + v_[289] * -0.022851627;
    v_[324] = (0 - v_[289]) * -0.002752;
    v_[339] = 0 - v_[324];
    v_[272] = v_[318] * v_[31] + v_[296] * v_[28] + v_[244] * -0.0055615274403 + v_[272] * -0.01438086 +
              v_[289] * 0.010329999 + v_[275] * -0.0037997814 + v_[242] * -0.011715295 + v_[271] * 0.0055279857 +
              v_[289] * 0.039002996 + v_[271] * 0.0055279857 + v_[289] * -0.034462002;
    v_[339] = v_[340] * v_[19] + v_[342] * v_[18] + v_[121] * v_[9] + v_[330] * v_[10] + v_[202] * v_[207] +
              v_[246] * v_[1] + v_[204] * v_[212] + v_[204] * v_[212] + v_[339] * v_[5] + v_[339] * v_[5] +
              v_[272] * w_in[1];
    v_[188] = v_[190] + v_[197] + v_[188] + v_[199];
    v_[267] = v_[229] + v_[334] + v_[267] + v_[189];
    v_[267] = v_[145] * v_[31] + v_[177] * v_[28] + v_[165] * v_[221] + v_[338] * v_[21] + v_[159] * v_[234] +
              v_[332] * v_[39] + v_[195] * v_[218] + v_[345] * v_[15] + v_[193] * v_[215] + v_[251] * v_[12] +
              v_[188] * v_[207] + v_[188] * v_[207] + v_[267] * v_[23] + v_[267] * v_[23];
    hes[20] = v_[135] * v_[235] + v_[308] * v_[40] + v_[137] * v_[221] + v_[310] * v_[21] + v_[136] * v_[216] +
              v_[309] * v_[13] + v_[117] * v_[218] + v_[161] * v_[15] + v_[267];
    v_[235] = (0 - v_[271]) * 0.012390532 + (0 - v_[289]) * 0.0055279857;
    v_[203] = 0 - v_[203] - v_[95] * -0.022851627;
    v_[216] = v_[271] * -0.022851627;
    v_[251] = 0 - v_[216];
    v_[345] = v_[308] * v_[19] + v_[310] * v_[18] + v_[309] * v_[9] + v_[161] * v_[10] + v_[271] * 0.08585553 +
              v_[289] * 0.0055279857;
    v_[251] = v_[267] + v_[235] * w_in[1] + v_[202] * v_[212] + v_[246] * v_[5] + v_[203] * v_[207] +
              v_[203] * v_[207] + v_[251] * v_[1] + v_[251] * v_[1] - v_[345] * w_in[1];
    v_[267] = w_in[7] * -0.002752 + (0 - v_[95]) * 0.012390532 + (0 - v_[113]) * 0.0055279857;
    v_[246] = v_[135] * v_[19] + v_[137] * v_[18] + v_[136] * v_[9] + v_[117] * v_[10] + w_in[7] * -0.002752 +
              v_[95] * 0.08585553 + v_[113] * 0.0055279857;
    v_[203] = v_[192] * v_[31] + v_[142] * v_[28] + v_[165] * v_[21] + v_[159] * v_[39] + v_[195] * v_[15] +
              v_[193] * v_[12] + v_[188] * v_[23] + v_[188] * v_[23] + v_[267] * w_in[1] + v_[202] * v_[5] +
              v_[203] * v_[1] + v_[203] * v_[1] - v_[246] * w_in[1];
    hes[13] =
        (0 -
            (w_in[6] * (0.08585553 * v_[3] + 0.0055279857 * v_[6] + 0.0099341499912 * v_[7] + 0.0055279857 * v_[6] +
                           -0.022851627 * (v_[8] - v_[1] * v_[1]) + v_[9] * v_[109] + v_[10] * v_[105] +
                           v_[19] * v_[111] + v_[18] * v_[84] - 0.012390532 * v_[26] - -0.002752 * v_[88]) +
                (v_[135] * v_[9] + v_[137] * v_[10] + w_in[7] * 0.293374233908935 + v_[113] * -0.0099341499912) * 9.81 +
                v_[205] * w_in[0])) *
            v_[4] -
        (w_in[6] * (0.08585553 * v_[209] + 0.0055279857 * v_[213] + 0.0099341499912 * v_[214] + 0.0055279857 * v_[213] +
                       -0.022851627 * (0 - (v_[207] * v_[1] + v_[1] * v_[207])) + v_[9] * v_[285] + v_[10] * v_[281] +
                       v_[19] * v_[287] + v_[18] * v_[262] - 0.012390532 * v_[225] - -0.002752 * v_[265]) +
            (v_[308] * v_[9] + v_[310] * v_[10] + v_[289] * -0.0099341499912) * 9.81 + v_[339] * w_in[0]) *
            v_[210] +
        (w_in[6] *
                (0.0055279857 * v_[209] + 0.039002996 * v_[213] + -0.0099341499912 * v_[220] + -0.034462002 * v_[213] +
                    -0.022851627 * v_[265] + 0.010329999 * v_[213] + -0.0037997814 * v_[217] + -0.011715295 * v_[219] +
                    -0.0055615274403 * v_[236] + -0.01438086 * v_[222] + -0.0055615274403 * v_[286] +
                    0.00750500000000001 * v_[256] + -0.0037997814 * v_[280] + v_[31] * v_[276] + v_[28] * v_[284] -
                    0.01438086 * v_[223] - -0.011715295 * v_[224] - 5.399998e-05 * (v_[258] - v_[226]) -
                    0.0055279857 * v_[225] - -0.002752 * (0 - (v_[212] * v_[5] + v_[5] * v_[212]))) +
            (v_[306] * v_[63] + v_[307] * v_[28] + v_[275] * 0.0055615274403 + v_[242] * 0.01438086 +
                v_[271] * 0.0099341499912) *
                9.81 +
            v_[251] * w_in[0]) *
            v_[206] -
        (w_in[6] * (0.0055279857 * v_[3] + 0.039002996 * v_[6] + -0.0099341499912 * v_[17] + -0.034462002 * v_[6] +
                       -0.022851627 * v_[88] + 0.010329999 * v_[6] + -0.0037997814 * v_[14] + -0.011715295 * v_[16] +
                       -0.0055615274403 * v_[41] + -0.01438086 * v_[22] + -0.0055615274403 * v_[110] +
                       0.00750500000000001 * v_[73] + -0.0037997814 * v_[104] + v_[31] * v_[100] + v_[28] * v_[108] -
                       0.01438086 * v_[24] - -0.011715295 * v_[25] - 5.399998e-05 * (v_[75] - v_[27]) -
                       0.0055279857 * v_[26] - -0.002752 * (v_[8] - v_[5] * v_[5])) +
            (v_[133] * v_[63] + v_[134] * v_[28] + v_[99] * 0.0055615274403 + v_[49] * 0.01438086 +
                w_in[7] * 0.0606159433962 + v_[95] * 0.0099341499912) *
                9.81 +
            v_[203] * w_in[0]) *
            v_[0];
    hes[18] = v_[205] * v_[211] + v_[339] * v_[4] + v_[203] * v_[206] + v_[251] * v_[0];
    v_[203] = sin(x_in[2]);
    v_[251] = cos(x_in[2]);
    hes[14] =
        0 -
        (v_[95] * v_[285] + v_[271] * v_[109] + v_[135] * v_[220] + v_[308] * v_[17] + v_[136] * v_[209] +
            v_[309] * v_[3] + v_[160] * v_[212] + v_[121] * v_[5] + (w_in[7] * v_[287] + v_[340] * w_in[1]) * 0.112 +
            (v_[95] * v_[262] + v_[271] * v_[84] + v_[137] * v_[209] + v_[310] * v_[3] + v_[169] * v_[212] +
                v_[342] * v_[5]) *
                0.112 -
            (w_in[7] * v_[281] + v_[330] * w_in[1])) *
            v_[203] +
        (w_in[7] * v_[285] + v_[95] * v_[281] + v_[271] * v_[105] + v_[137] * v_[220] + v_[310] * v_[17] +
            v_[117] * v_[209] + v_[161] * v_[3] + v_[121] * w_in[1] + v_[201] * v_[212] + v_[330] * v_[5] +
            (v_[95] * v_[287] + v_[271] * v_[111] + v_[135] * v_[209] + v_[308] * v_[3] + v_[167] * v_[212] +
                v_[340] * v_[5]) *
                -0.112 +
            (w_in[7] * v_[262] + v_[342] * w_in[1]) * 0.112) *
            v_[251];
    v_[309] = sin(x_in[3]);
    v_[161] = cos(x_in[3]);
    hes[15] = 0 -
              (v_[51] * v_[288] + v_[244] * v_[112] + v_[114] * v_[284] + v_[289] * v_[108] + v_[99] * v_[276] +
                  v_[275] * v_[100] + v_[133] * v_[236] + v_[306] * v_[41] + v_[134] * v_[214] + v_[307] * v_[7] +
                  v_[178] * v_[217] + v_[318] * v_[14] + v_[122] * v_[213] + v_[296] * v_[6] + v_[158] * v_[221] +
                  v_[331] * v_[21] + v_[192] * v_[218] + v_[145] * v_[15] + v_[142] * v_[207] + v_[177] * v_[23] +
                  (v_[49] * v_[288] + v_[242] * v_[112] + v_[133] * v_[219] + v_[306] * v_[16] + v_[158] * v_[215] +
                      v_[331] * v_[12]) *
                      -0.304) *
                  v_[309] +
              (v_[51] * v_[283] + v_[244] * v_[107] + v_[99] * v_[284] + v_[275] * v_[108] + v_[134] * v_[236] +
                  v_[307] * v_[41] + v_[122] * v_[217] + v_[296] * v_[14] + v_[164] * v_[221] + v_[337] * v_[21] +
                  v_[142] * v_[218] + v_[177] * v_[15] - (v_[133] * v_[214] + v_[306] * v_[7]) +
                  (v_[49] * v_[283] + v_[242] * v_[107] + v_[134] * v_[219] + v_[307] * v_[16] + v_[164] * v_[215] +
                      v_[337] * v_[12]) *
                      -0.304 -
                  (v_[114] * v_[276] + v_[289] * v_[100] + v_[178] * v_[213] + v_[318] * v_[6] + v_[192] * v_[207] +
                      v_[145] * v_[23])) *
                  v_[161];
    v_[177] = sin(x_in[4]);
    v_[318] = cos(x_in[4]);
    hes[16] = 0 -
              (v_[48] * v_[282] + v_[241] * v_[106] + v_[115] * v_[268] + v_[290] * v_[92] + v_[123] * v_[252] +
                  v_[297] * v_[66] + v_[170] * v_[230] + v_[343] * v_[34] + v_[146] * v_[237] + v_[319] * v_[44] +
                  v_[183] * v_[231] + v_[349] * v_[35] +
                  (v_[50] * v_[282] + v_[243] * v_[106] + v_[123] * v_[227] + v_[297] * v_[29] + v_[146] * v_[240] +
                      v_[319] * v_[47]) *
                      0.112 -
                  (v_[101] * v_[255] + v_[277] * v_[72] + v_[132] * v_[233] + v_[305] * v_[37] + v_[154] * v_[239] +
                      v_[327] * v_[46]) +
                  (v_[115] * v_[255] + v_[290] * v_[72] + v_[132] * v_[230] + v_[305] * v_[34] + v_[154] * v_[231] +
                      v_[327] * v_[35]) *
                      0.112 -
                  (v_[50] * v_[257] + v_[243] * v_[74] + v_[116] * v_[227] + v_[291] * v_[29] + v_[128] * v_[240] +
                      v_[140] * v_[47])) *
                  v_[177] +
              (v_[101] * v_[282] + v_[277] * v_[106] + v_[48] * v_[255] + v_[241] * v_[72] + v_[50] * v_[268] +
                  v_[243] * v_[92] + v_[115] * v_[257] + v_[290] * v_[74] + v_[123] * v_[233] + v_[297] * v_[37] +
                  v_[132] * v_[252] + v_[305] * v_[66] + v_[170] * v_[227] + v_[343] * v_[29] + v_[116] * v_[230] +
                  v_[291] * v_[34] + v_[146] * v_[239] + v_[319] * v_[46] + v_[154] * v_[237] + v_[327] * v_[44] +
                  v_[183] * v_[240] + v_[349] * v_[47] + v_[128] * v_[231] + v_[140] * v_[35] +
                  (v_[115] * v_[282] + v_[290] * v_[106] + v_[123] * v_[230] + v_[297] * v_[34] + v_[146] * v_[231] +
                      v_[319] * v_[35]) *
                      -0.112 +
                  (v_[50] * v_[255] + v_[243] * v_[72] + v_[132] * v_[227] + v_[305] * v_[29] + v_[154] * v_[240] +
                      v_[327] * v_[47]) *
                      0.112) *
                  v_[318];
    v_[140] = v_[126] * v_[269] + v_[300] * v_[93] + v_[129] * v_[247] + v_[302] * v_[57] + v_[149] * v_[248] +
              v_[322] * v_[58];
    v_[300] = v_[126] * v_[273] + v_[300] * v_[97] + v_[131] * v_[247] + v_[304] * v_[57] + v_[150] * v_[248] +
              v_[323] * v_[58];
    v_[248] = sin(x_in[5]);
    v_[247] = cos(x_in[5]);
    hes[17] = 0 -
              (v_[124] * v_[273] + v_[298] * v_[97] + v_[125] * v_[269] + v_[299] * v_[93] + v_[118] * v_[278] +
                  v_[292] * v_[102] + v_[119] * v_[279] + v_[293] * v_[103] + v_[129] * v_[254] + v_[302] * v_[70] +
                  v_[131] * v_[238] + v_[304] * v_[45] + v_[120] * v_[249] + v_[294] * v_[59] + v_[182] * v_[232] +
                  v_[350] * v_[36] + v_[149] * v_[259] + v_[322] * v_[80] + v_[150] * v_[250] + v_[323] * v_[64] +
                  v_[130] * v_[245] + v_[347] * v_[55] + v_[173] * v_[228] + v_[326] * v_[71] + v_[140] * 0.184 +
                  (0 - v_[300]) * 0.02075) *
                  v_[248] +
              (v_[125] * v_[273] + v_[299] * v_[97] + v_[119] * v_[278] + v_[293] * v_[102] + v_[131] * v_[254] +
                  v_[304] * v_[70] + v_[182] * v_[249] + v_[350] * v_[59] + v_[150] * v_[259] + v_[323] * v_[80] +
                  v_[173] * v_[245] + v_[326] * v_[55] -
                  (v_[124] * v_[269] + v_[298] * v_[93] + v_[129] * v_[238] + v_[302] * v_[45] + v_[149] * v_[250] +
                      v_[322] * v_[64]) +
                  v_[140] * 0.02075 + v_[300] * 0.184 -
                  (v_[118] * v_[279] + v_[292] * v_[103] + v_[120] * v_[232] + v_[294] * v_[36] + v_[130] * v_[228] +
                      v_[347] * v_[71])) *
                  v_[247];
    v_[216] = v_[216] + v_[324];
    hes[19] = v_[340] * v_[20] + v_[342] * v_[38] + v_[121] * v_[10] + v_[330] * v_[11] + v_[267] * v_[207] +
              v_[235] * v_[1] + v_[216] * w_in[1] + v_[216] * w_in[1] + v_[246] * v_[208] + v_[345] * v_[2] +
              v_[96] * v_[212] + v_[272] * v_[5];
    v_[216] = w_in[6] * v_[4];
    v_[246] = w_in[7] * v_[38] + v_[216] * v_[18];
    v_[267] = w_in[7] * v_[10] + v_[216] * v_[9];
    v_[345] = v_[246] * -1 + v_[267] * -0.304;
    v_[235] = w_in[7] * v_[20] + v_[216] * v_[19];
    v_[272] = w_in[7] * v_[11] + v_[216] * v_[10];
    v_[330] = v_[235] * v_[28] + v_[272] * v_[43];
    v_[121] = w_in[9] + v_[272] * -1;
    v_[342] = w_in[8] + w_in[6] * v_[0];
    v_[340] = v_[342] * v_[31] + v_[267] * v_[28];
    v_[212] = v_[345] * v_[53] + v_[330] * v_[52] + v_[121] * v_[67] + v_[340] * v_[68];
    v_[208] = v_[342] * v_[28] + v_[267] * v_[30];
    v_[207] = w_in[10] + v_[208];
    v_[96] = v_[121] * v_[54] + v_[340] * v_[53];
    v_[1] = v_[212] + v_[207] * 0.02075 + v_[96] * -0.184;
    v_[324] = v_[207] * v_[86] + v_[96] * v_[77];
    v_[300] = v_[1] * 1.547475 + v_[324] * -0.038686875;
    v_[140] = v_[300] + v_[212] * 2.1032 + v_[96] * -0.057838;
    v_[326] = v_[235] * v_[30] + v_[272] * v_[42];
    v_[347] = v_[345] * v_[62] + v_[330] * v_[53] + v_[121] * v_[60] + v_[340] * v_[61];
    v_[350] = v_[121] * v_[53] + v_[340] * v_[52];
    v_[294] = v_[326] * v_[79] + v_[347] * v_[77] + v_[350] * v_[78];
    v_[323] = w_in[11] + v_[350];
    v_[322] = v_[294] * 1.547475 + v_[323] * 0.038686875;
    v_[304] = v_[326] * v_[77] + v_[347] * v_[76] + v_[350] * v_[81];
    v_[302] = v_[304] * 1.547475;
    v_[299] = v_[322] * v_[77] + v_[302] * v_[76] + v_[347] * 2.1032 + v_[350] * 0.057838;
    v_[298] = v_[140] * v_[52] + v_[299] * v_[53] + v_[330] * 1.7423722 + v_[121] * 0.160298259823722 +
              v_[208] * -1.52322944854339e-09;
    v_[293] = v_[322] * v_[79] + v_[302] * v_[77] + v_[326] * 2.1032 + v_[326] * 1.7423722 + v_[121] * 0.008711861 +
              v_[340] * 1.52322944854339e-09;
    v_[292] =
        v_[298] * v_[28] + v_[293] * v_[30] + v_[235] * 2.327 + v_[342] * -0.0055615274403 + v_[272] * -0.647967112;
    v_[278] = v_[140] * v_[53] + v_[299] * v_[62] + v_[345] * 1.7423722 + v_[340] * -0.160298259823722 +
              v_[208] * -0.008711861;
    v_[279] = v_[207] * v_[77] + v_[96] * v_[76];
    v_[273] = v_[294] * 0.038686875 + v_[323] * 0.009277 + v_[324] * -0.000829 + v_[279] * 1.5e-05 + v_[322] * v_[78] +
              v_[302] * v_[81] + v_[347] * 0.057838 + v_[207] * -0.001243 + v_[350] * 0.029115 + v_[96] * -0.001387;
    v_[269] = v_[1] * -0.038686875 + v_[323] * -0.000829 + v_[324] * 0.003227 + v_[279] * 0.000198;
    v_[259] = v_[323] * 1.5e-05 + v_[324] * 0.000198 + v_[279] * 0.010737;
    v_[254] = v_[300] * -0.184 + v_[269] * v_[77] + v_[259] * v_[76] + v_[212] * -0.057838 + v_[207] * -0.012652 +
              v_[350] * -0.001387 + v_[96] * 0.019432;
    v_[250] = v_[140] * v_[68] + v_[299] * v_[61] + v_[273] * v_[52] + v_[254] * v_[53] + v_[345] * -0.160298259823722 +
              v_[326] * 1.52322944854339e-09 + v_[121] * -0.0022920002 + v_[340] * 0.01828449 + v_[208] * 0.0036857284;
    v_[300] = v_[300] * 0.02075 + v_[269] * v_[86] + v_[259] * v_[77] + v_[207] * 0.011046 + v_[350] * -0.001243 +
              v_[96] * -0.012652 + v_[345] * -0.008711861 + v_[330] * -1.52322944854339e-09 + v_[121] * -0.00021200017 +
              v_[340] * 0.0036857284 + v_[208] * 0.081661;
    v_[249] = v_[278] * -0.304 + v_[250] * v_[28] + v_[300] * v_[30] + v_[246] * 0.647967112 + v_[342] * -0.0037997814 +
              v_[267] * 0.20986895 + v_[272] * 5.399998e-05;
    v_[245] = v_[304] * 1.547475;
    v_[238] = v_[294] * -1.547475;
    v_[232] = v_[323] * 0.038686875;
    v_[228] = v_[238] - v_[232];
    v_[173] = v_[245] * v_[87] + v_[228] * v_[85];
    v_[130] = v_[347] * 2.1032 + v_[350] * 0.057838;
    v_[182] = 0 - v_[130];
    v_[120] = v_[326] * 2.1032;
    v_[150] = v_[173] + v_[182] * v_[71] + v_[120] * v_[55] + v_[299] * w_in[4];
    v_[149] = 0 - v_[245];
    v_[131] = v_[1] * 1.547475 + (0 - v_[324]) * 0.038686875;
    v_[129] = v_[149] * v_[91] + v_[131] * v_[85] + v_[302] * w_in[5];
    v_[232] = 0 - v_[238] + v_[232];
    v_[238] = 0 - v_[131];
    v_[125] = v_[232] * v_[91] + v_[238] * v_[87] - v_[322] * w_in[5];
    v_[124] = v_[212] * -2.1032 + v_[96] * 0.057838;
    v_[119] = 0 - v_[124];
    v_[118] = 0 - v_[120];
    v_[126] = v_[129] * v_[77] + v_[125] * v_[76] + v_[119] * v_[71] + v_[118] * v_[58] - v_[140] * w_in[4];
    v_[343] = v_[326] * 1.7423722 + (0 - v_[121]) * -0.008711861 + v_[340] * 1.52322944854339e-09;
    v_[349] = v_[330] * -1.7423722;
    v_[291] = v_[121] * 0.160298259823722;
    v_[327] = v_[208] * 1.52322944854339e-09;
    v_[319] = v_[349] - v_[291] + v_[327];
    v_[305] = v_[150] * v_[53] + v_[126] * v_[62] + v_[343] * v_[35] + v_[319] * v_[32];
    v_[297] = (0 - v_[323]) * 1.5e-05 + v_[324] * 0.000198 + v_[279] * 0.00605;
    v_[1] = v_[1] * 0.038686875 + v_[323] * -0.000829 + (0 - v_[324]) * -0.00146 + (0 - v_[279]) * 0.000198;
    v_[304] = (0 - v_[304]) * 0.038686875;
    v_[290] = v_[324] * 1.5e-05;
    v_[243] = (0 - v_[279]) * -0.000829;
    v_[241] = v_[304] + v_[290] + v_[243];
    v_[212] = v_[212] * 0.057838 + (0 - v_[207]) * -0.012652 + v_[350] * -0.001387 + v_[96] * -0.018069;
    v_[277] = v_[207] * 0.009683 + (0 - v_[350]) * -0.001243 + v_[96] * -0.012652;
    v_[255] = (0 - v_[326]) * 0.057838;
    v_[282] = (0 - v_[207]) * -0.001387;
    v_[257] = (0 - v_[96]) * -0.001243;
    v_[268] = v_[255] + v_[282] - v_[257];
    v_[252] = v_[149] * v_[94] + v_[232] * v_[82] + v_[297] * v_[87] + v_[1] * v_[85] + v_[241] * v_[91] +
              v_[241] * v_[91] + v_[129] * v_[78] + v_[125] * v_[81] + v_[130] * v_[64] + v_[118] * v_[80] +
              v_[212] * v_[71] + v_[277] * v_[55] + v_[268] * v_[58] + v_[268] * v_[58] + v_[254] * w_in[4];
    v_[279] = v_[294] * 0.038686875 + v_[323] * -0.00751 + (0 - v_[324]) * -0.000829 + v_[279] * 1.5e-05;
    v_[323] = (0 - v_[323]) * 0.000198;
    v_[243] = v_[304] + v_[323] - v_[243];
    v_[304] = v_[245] * v_[89] + v_[238] * v_[82] + v_[297] * v_[91] + v_[279] * v_[85] + v_[243] * v_[87] +
              v_[243] * v_[87] + v_[259] * w_in[5];
    v_[323] = 0 - v_[323] - v_[290];
    v_[290] = v_[228] * v_[89] + v_[131] * v_[94] + v_[1] * v_[91] + v_[279] * v_[87] + v_[323] * v_[85] +
              v_[323] * v_[85] - v_[269] * w_in[5];
    v_[294] = v_[347] * 0.057838 + v_[207] * -0.001243 + (0 - v_[350]) * -0.008386 + (0 - v_[96]) * -0.001387;
    v_[324] = v_[350] * -0.012652;
    v_[282] = v_[255] - v_[282] - v_[324];
    v_[255] = v_[173] * -0.184 + v_[304] * v_[77] + v_[290] * v_[76] + v_[124] * v_[64] + v_[120] * v_[69] +
              v_[294] * v_[71] + v_[277] * v_[58] + v_[282] * v_[55] + v_[282] * v_[55] - v_[273] * w_in[4];
    v_[240] = v_[345] * 1.7423722 + (0 - v_[340]) * 0.160298259823722 + v_[208] * -0.008711861;
    v_[239] = 0 - v_[240];
    v_[237] = v_[345] * -0.008711861 + v_[330] * 1.52322944854339e-09 + (0 - v_[121]) * -0.00021200017 +
              v_[340] * 0.0036857284 + v_[208] * 0.077424;
    v_[233] = v_[330] * 0.160298259823722 + v_[326] * -0.008711861 + v_[121] * -0.06337651 +
              (0 - v_[340]) * -0.0022920002 + v_[208] * -0.00021200017;
    v_[231] = (0 - v_[345]) * 1.52322944854339e-09;
    v_[230] = (0 - v_[326]) * 0.160298259823722;
    v_[227] = (0 - v_[121]) * 0.0036857284;
    v_[128] = (0 - v_[208]) * -0.0022920002;
    v_[170] = v_[231] + v_[230] + v_[227] - v_[128];
    v_[183] = v_[150] * v_[68] + v_[126] * v_[61] + v_[252] * v_[52] + v_[255] * v_[53] + v_[343] * v_[46] +
              v_[239] * v_[64] + v_[237] * v_[47] + v_[233] * v_[32] + v_[170] * v_[35] + v_[170] * v_[35] +
              v_[300] * w_in[3];
    v_[324] = v_[324] + v_[257];
    v_[257] = v_[345] * 0.160298259823722 + v_[326] * 1.52322944854339e-09 + v_[121] * -0.0022920002 +
              (0 - v_[340]) * 0.01404749 + (0 - v_[208]) * 0.0036857284;
    v_[116] = (0 - v_[330]) * -0.008711861;
    v_[154] = v_[340] * -0.00021200017;
    v_[227] = v_[231] + v_[116] - v_[227] - v_[154];
    v_[173] = v_[173] * 0.02075 + v_[304] * v_[86] + v_[290] * v_[77] + v_[182] * v_[69] + v_[119] * v_[80] +
              v_[212] * v_[58] + v_[294] * v_[55] + v_[324] * v_[71] + v_[324] * v_[71] + v_[319] * v_[46] +
              v_[240] * v_[44] + v_[257] * v_[47] + v_[233] * v_[35] + v_[227] * v_[32] + v_[227] * v_[32] -
              v_[250] * w_in[3];
    v_[231] = (0 - v_[267]) * -0.0055615274403 + v_[272] * 0.01438086;
    v_[146] = 0 - v_[231];
    v_[132] = v_[235] * 0.647967112 + (0 - v_[342]) * -0.011715295 + v_[267] * 5.399998e-05 + v_[272] * -0.199538951;
    v_[123] = v_[235] * -0.0055615274403 + v_[246] * 0.01438086 + v_[342] * 0.00750500000000001 +
              (0 - v_[267]) * -0.0037997814 + v_[272] * -0.011715295;
    v_[115] = (0 - v_[342]) * 5.399998e-05;
    v_[50] = (0 - v_[246]) * -0.0055615274403 + v_[115] - (0 - v_[272]) * -0.0037997814;
    v_[208] = v_[298] * v_[43] + v_[293] * v_[42] +
              (v_[140] * v_[67] + v_[299] * v_[60] + v_[273] * v_[53] + v_[254] * v_[54] + v_[330] * 0.160298259823722 +
                  v_[326] * 0.008711861 + v_[121] * 0.09570849 + v_[340] * -0.0022920002 + v_[208] * -0.00021200017) *
                  -1 +
              v_[235] * -0.647967112 + v_[342] * -0.011715295 + v_[267] * 5.399998e-05 + v_[272] * 0.20236395;
    v_[48] = v_[305] * -0.304 + v_[183] * v_[28] + v_[173] * v_[30] + v_[146] * v_[39] + v_[132] * v_[23] +
             v_[123] * v_[12] + v_[50] * v_[15] + v_[50] * v_[15] + v_[208] * w_in[2];
    v_[101] = 0 - v_[343];
    v_[145] = v_[150] * v_[52] + v_[126] * v_[53] + v_[101] * v_[47] + v_[240] * v_[32] + v_[293] * w_in[3];
    v_[327] = 0 - v_[349] + v_[291] - v_[327];
    v_[291] = v_[129] * v_[79] + v_[125] * v_[77] + v_[130] * v_[58] + v_[124] * v_[55] + v_[327] * v_[47] +
              v_[239] * v_[35] - v_[298] * w_in[3];
    v_[349] = 0 - (v_[246] * 2.327 + (0 - v_[342]) * 0.01438086 + v_[267] * 0.647967112);
    v_[278] = v_[278] * -1 + v_[246] * 2.327 + v_[342] * -0.01438086 + v_[267] * 0.647967112;
    v_[296] = v_[145] * v_[28] + v_[291] * v_[30] + v_[349] * v_[23] + v_[231] * v_[12] + v_[278] * w_in[2];
    v_[337] = v_[342] * -0.0055615274403 - (v_[235] * -2.327 + v_[272] * 0.647967112);
    v_[305] = v_[305] * -1 + v_[337] * v_[23] + v_[146] * v_[15] - v_[292] * w_in[2];
    v_[154] = v_[116] + v_[230] + v_[154] + v_[128];
    v_[246] =
        v_[246] * 0.647967112 + v_[342] * -0.0037997814 + (0 - v_[267]) * -0.192033951 + (0 - v_[272]) * 5.399998e-05;
    v_[115] = (0 - v_[235]) * 0.01438086 - v_[115] - v_[267] * -0.011715295;
    v_[116] = v_[145] * v_[43] + v_[291] * v_[42] +
              (v_[150] * v_[67] + v_[126] * v_[60] + v_[252] * v_[53] + v_[255] * v_[54] + v_[101] * v_[44] +
                  v_[327] * v_[64] + v_[237] * v_[35] + v_[257] * v_[32] + v_[154] * v_[47] + v_[154] * v_[47]) *
                  -1 +
              v_[231] * v_[21] + v_[246] * v_[23] + v_[123] * v_[15] + v_[115] * v_[12] + v_[115] * v_[12] -
              v_[249] * w_in[2];
    v_[128] = 0 - v_[203];
    v_[230] = -v_[128];
    v_[331] = v_[251] * v_[5] + v_[230] * w_in[1];
    v_[307] = -v_[331];
    v_[306] = v_[128] * v_[3] + v_[307] * w_in[2];
    v_[289] = v_[128] * v_[5] + v_[251] * w_in[1];
    v_[242] = v_[251] * v_[3] + v_[289] * w_in[2];
    v_[244] = 0.112 * v_[128];
    v_[275] = -0.112 * v_[251];
    v_[283] = 0.112 * v_[128];
    v_[288] = v_[275] * v_[5] + v_[283] * w_in[1];
    v_[284] = v_[251] * v_[17] + v_[244] * v_[3] + v_[288] * w_in[2];
    v_[276] = -v_[23] * v_[288];
    v_[236] = v_[289] * v_[23];
    v_[221] = v_[331] * v_[12] + v_[12] * v_[331];
    v_[219] = -1 * v_[242];
    v_[218] = v_[30] * v_[289];
    v_[217] = -v_[218];
    v_[215] = v_[28] * v_[306] + v_[217] * w_in[3];
    v_[214] = v_[28] * v_[289];
    v_[213] = v_[30] * v_[306] + v_[214] * w_in[3];
    v_[142] = -0.304 * v_[306] + -1 * v_[284];
    v_[178] = 0.112 * v_[251];
    v_[192] = v_[244] * v_[5] + v_[178] * w_in[1];
    v_[122] = -v_[192];
    v_[164] = v_[128] * v_[17] + v_[275] * v_[3] + v_[122] * w_in[2];
    v_[158] = v_[43] * v_[331] + v_[28] * v_[288];
    v_[134] = v_[30] * v_[164] + v_[42] * v_[242] + v_[158] * w_in[3];
    v_[133] = -0.304 * v_[289] + -1 * v_[192];
    v_[114] = -1 * v_[331];
    v_[49] = v_[214] * v_[46] + v_[35] * v_[133] - (v_[114] * v_[44] + v_[47] * v_[158]);
    v_[51] = v_[214] * v_[47] + v_[35] * v_[114];
    v_[99] = v_[114] * v_[47] + v_[47] * v_[114];
    v_[310] = v_[218] * v_[32] + v_[32] * v_[218];
    v_[308] = v_[53] * v_[214] + v_[54] * v_[114];
    v_[271] = -v_[308];
    v_[262] = v_[53] * v_[219] + v_[52] * v_[215] + v_[271] * w_in[4];
    v_[287] = v_[52] * v_[214] + v_[53] * v_[114];
    v_[281] = v_[54] * v_[219] + v_[53] * v_[215] + v_[287] * w_in[4];
    v_[285] = v_[42] * v_[331] + v_[30] * v_[288];
    v_[220] = -v_[285];
    v_[209] = v_[28] * v_[164] + v_[43] * v_[242] + v_[220] * w_in[3];
    v_[201] = v_[67] * v_[114] + v_[68] * v_[214] + v_[53] * v_[133] + v_[52] * v_[158];
    v_[136] = v_[60] * v_[219] + v_[61] * v_[215] + v_[62] * v_[142] + v_[53] * v_[209] + v_[201] * w_in[4];
    v_[160] = v_[287] * v_[64] + v_[58] * v_[285] - (v_[218] * v_[69] + v_[71] * v_[201]);
    v_[117] = v_[287] * v_[71] + v_[58] * v_[218];
    v_[169] = v_[218] * v_[71] + v_[71] * v_[218];
    v_[167] = v_[308] * v_[55] + v_[55] * v_[308];
    v_[137] = v_[60] * v_[114] + v_[61] * v_[214] + v_[62] * v_[133] + v_[53] * v_[158];
    v_[135] = v_[77] * v_[285] + v_[76] * v_[137] + v_[81] * v_[287];
    v_[95] = -v_[135];
    v_[339] = v_[79] * v_[134] + v_[77] * v_[136] + v_[78] * v_[262] + v_[95] * w_in[5];
    v_[211] = v_[76] * v_[308] + v_[77] * v_[218];
    v_[206] = v_[77] * v_[308] + v_[86] * v_[218];
    v_[205] = v_[211] * v_[87] + v_[85] * v_[206];
    v_[265] = 0.02075 * v_[218] + -0.184 * v_[308] + v_[201];
    v_[225] = v_[211] * v_[89] + v_[85] * v_[265];
    v_[258] = v_[287] * v_[82] + v_[91] * v_[135];
    v_[286] = 1.547475 * v_[339] + 0.038686875 * v_[262] + 0.038686875 * v_[205] + -1.547475 * (v_[225] - v_[258]);
    v_[256] = v_[79] * v_[285] + v_[77] * v_[137] + v_[78] * v_[287];
    v_[280] = v_[287] * v_[91] + v_[91] * v_[287];
    v_[226] = v_[206] * v_[87] + v_[87] * v_[206];
    v_[224] = 1.547475 * (v_[206] * v_[89] + v_[87] * v_[265] - (v_[287] * v_[94] + v_[91] * v_[256])) +
              1.547475 * (v_[77] * v_[134] + v_[76] * v_[136] + v_[81] * v_[262] + v_[256] * w_in[5]) -
              0.038686875 * (v_[280] + v_[226]);
    v_[223] = -v_[211];
    v_[222] = v_[86] * v_[213] + v_[77] * v_[281] + v_[223] * w_in[5];
    v_[210] = v_[77] * v_[213] + v_[76] * v_[281] + v_[206] * w_in[5];
    v_[113] = v_[211] * v_[91] + v_[85] * v_[287];
    v_[88] = v_[206] * v_[91] + v_[87] * v_[287];
    v_[26] = v_[211] * v_[85] + v_[85] * v_[211];
    v_[75] = v_[308] * v_[71] + v_[55] * v_[218];
    v_[110] = v_[308] * v_[58] + v_[55] * v_[287];
    v_[258] = -0.001243 * v_[213] + 0.029115 * v_[262] + -0.001387 * v_[281] + 0.057838 * v_[136] + 0.057838 * v_[160] +
              -0.001387 * v_[117] + -0.012652 * (v_[169] - v_[167]) + v_[78] * v_[286] + v_[81] * v_[224] +
              0.009277 * v_[262] + -0.000829 * v_[222] + 1.5e-05 * v_[210] + 0.038686875 * v_[339] +
              -0.00751 * v_[205] + 0.038686875 * (v_[258] - v_[225]) + -0.000829 * v_[113] - 1.5e-05 * v_[88] -
              0.000198 * (v_[226] - v_[26]) - -0.008386 * v_[75] - -0.001243 * v_[110];
    v_[225] = -v_[137];
    v_[339] = v_[67] * v_[219] + v_[68] * v_[215] + v_[53] * v_[142] + v_[52] * v_[209] + v_[225] * w_in[4];
    v_[73] = v_[308] * v_[64] + v_[55] * v_[285] - (v_[218] * v_[80] + v_[71] * v_[137]);
    v_[104] = 0.02075 * v_[213] + -0.184 * v_[281] + v_[339];
    v_[63] = v_[211] * v_[94] + v_[85] * v_[256] - (v_[206] * v_[82] + v_[87] * v_[135]);
    v_[26] = -0.000829 * v_[262] + 0.003227 * v_[222] + 0.000198 * v_[210] + -0.038686875 * v_[104] +
             0.000198 * v_[88] + 1.5e-05 * (v_[280] - v_[26]) - 0.038686875 * v_[63] - -0.00146 * v_[113] -
             -0.000829 * v_[205];
    v_[88] = 1.5e-05 * v_[262] + 0.000198 * v_[222] + 0.010737 * v_[210] + 0.00605 * v_[88] + 1.5e-05 * v_[205] -
             0.000198 * v_[113] - -0.000829 * (v_[280] - v_[226]);
    v_[63] = 1.547475 * v_[104] + -0.038686875 * v_[222] + 0.038686875 * v_[113] + 1.547475 * v_[63];
    v_[104] = v_[287] * v_[58] + v_[58] * v_[287];
    v_[169] = -0.012652 * v_[213] + -0.001387 * v_[262] + 0.019432 * v_[281] + -0.057838 * v_[339] +
              -0.018069 * v_[117] + 0.057838 * v_[73] + -0.012652 * v_[110] + v_[77] * v_[26] + v_[76] * v_[88] +
              -0.184 * v_[63] - -0.001387 * v_[75] - -0.001243 * (v_[169] - v_[104]);
    v_[73] = 2.1032 * v_[339] + -0.057838 * v_[281] + 0.057838 * v_[117] + -2.1032 * v_[73] + v_[63];
    v_[160] = 2.1032 * v_[136] + 0.057838 * v_[262] + 0.057838 * v_[75] + 2.1032 * v_[160] + v_[77] * v_[286] +
              v_[76] * v_[224];
    v_[339] = v_[218] * v_[44] + v_[32] * v_[158] - (v_[214] * v_[64] + v_[35] * v_[285]);
    v_[113] = v_[218] * v_[47] + v_[32] * v_[114];
    v_[222] = v_[218] * v_[35] + v_[32] * v_[214];
    v_[210] = -0.0022920002 * v_[219] + 0.01828449 * v_[215] + 0.0036857284 * v_[213] + -0.160298259823722 * v_[142] +
              1.52322944854339e-09 * v_[134] + 1.52322944854339e-09 * v_[49] + 0.0036857284 * v_[51] +
              -0.00021200017 * (v_[99] - v_[310]) + v_[52] * v_[258] + v_[53] * v_[169] + v_[68] * v_[73] +
              v_[61] * v_[160] - 0.160298259823722 * v_[339] - 0.01404749 * v_[113] - -0.0022920002 * v_[222];
    v_[226] = v_[218] * v_[46] + v_[32] * v_[133];
    v_[280] = v_[114] * v_[64] + v_[47] * v_[285];
    v_[205] = v_[214] * v_[35] + v_[35] * v_[214];
    v_[63] = -0.00021200017 * v_[219] + 0.0036857284 * v_[215] + 0.081661 * v_[213] + -0.008711861 * v_[142] +
             -1.52322944854339e-09 * v_[209] + -0.008711861 * v_[339] + 1.52322944854339e-09 * (v_[226] - v_[280]) +
             0.077424 * v_[51] + -0.00021200017 * v_[222] + 0.011046 * v_[213] + -0.001243 * v_[262] +
             -0.012652 * v_[281] + -0.001243 * v_[75] + 0.009683 * v_[110] + v_[86] * v_[26] + v_[77] * v_[88] +
             0.02075 * v_[63] - -0.012652 * v_[117] - -0.001387 * (v_[104] - v_[167]) - 0.0036857284 * v_[113] -
             -0.0022920002 * (v_[99] - v_[205]);
    v_[339] = -0.160298259823722 * v_[215] + -0.008711861 * v_[213] + 1.7423722 * v_[142] + 1.7423722 * v_[339] +
              0.160298259823722 * v_[113] + -0.008711861 * v_[51] + v_[53] * v_[73] + v_[62] * v_[160] -
              1.52322944854339e-09 * (v_[205] + v_[310]);
    v_[110] = v_[331] * v_[21] + v_[12] * v_[288] - (v_[289] * v_[39] + v_[15] * v_[192]);
    v_[75] = v_[331] * v_[23];
    v_[117] = v_[331] * v_[15] + v_[12] * v_[289];
    v_[27] = 0.20986895 * v_[306] + 5.399998e-05 * v_[242] + 0.647967112 * v_[284] + 0.647967112 * v_[276] +
             5.399998e-05 * v_[236] + -0.011715295 * (0 - v_[221]) + v_[28] * v_[210] + v_[30] * v_[63] +
             -0.304 * v_[339] - -0.0055615274403 * v_[110] - -0.192033951 * v_[75] - -0.0037997814 * v_[117];
    v_[25] = w_in[7] * v_[178] + v_[216] * v_[244];
    v_[24] = w_in[7] * v_[251] + v_[216] * v_[128];
    v_[22] = v_[25] * -1 + v_[24] * -0.304;
    v_[8] = w_in[7] * v_[283] + v_[216] * v_[275];
    v_[188] = w_in[7] * v_[230] + v_[216] * v_[251];
    v_[202] = v_[8] * v_[28] + v_[188] * v_[43];
    v_[193] = v_[188] * -1;
    v_[195] = v_[24] * v_[28];
    v_[159] = v_[22] * v_[53] + v_[202] * v_[52] + v_[193] * v_[67] + v_[195] * v_[68];
    v_[165] = v_[24] * v_[30];
    v_[332] = v_[193] * v_[54] + v_[195] * v_[53];
    v_[338] = v_[159] + v_[165] * 0.02075 + v_[332] * -0.184;
    v_[234] = v_[165] * v_[86] + v_[332] * v_[77];
    v_[229] = v_[338] * 1.547475 + v_[234] * -0.038686875;
    v_[189] = v_[229] + v_[159] * 2.1032 + v_[332] * -0.057838;
    v_[334] = v_[8] * v_[30] + v_[188] * v_[42];
    v_[190] = v_[22] * v_[62] + v_[202] * v_[53] + v_[193] * v_[60] + v_[195] * v_[61];
    v_[199] = v_[193] * v_[53] + v_[195] * v_[52];
    v_[197] = v_[334] * v_[79] + v_[190] * v_[77] + v_[199] * v_[78];
    v_[204] = v_[197] * 1.547475 + v_[199] * 0.038686875;
    v_[198] = v_[334] * v_[77] + v_[190] * v_[76] + v_[199] * v_[81];
    v_[196] = v_[198] * 1.547475;
    v_[166] = v_[204] * v_[77] + v_[196] * v_[76] + v_[190] * 2.1032 + v_[199] * 0.057838;
    v_[320] = v_[189] * v_[52] + v_[166] * v_[53] + v_[202] * 1.7423722 + v_[193] * 0.160298259823722 +
              v_[165] * -1.52322944854339e-09;
    v_[335] = v_[204] * v_[79] + v_[196] * v_[77] + v_[334] * 2.1032 + v_[334] * 1.7423722 + v_[193] * 0.008711861 +
              v_[195] * 1.52322944854339e-09;
    v_[329] = v_[320] * v_[28] + v_[335] * v_[30] + v_[8] * 2.327 + v_[188] * -0.647967112;
    v_[194] = v_[189] * v_[53] + v_[166] * v_[62] + v_[22] * 1.7423722 + v_[195] * -0.160298259823722 +
              v_[165] * -0.008711861;
    v_[180] = v_[165] * v_[77] + v_[332] * v_[76];
    v_[127] = v_[197] * 0.038686875 + v_[199] * 0.009277 + v_[234] * -0.000829 + v_[180] * 1.5e-05 + v_[204] * v_[78] +
              v_[196] * v_[81] + v_[190] * 0.057838 + v_[165] * -0.001243 + v_[199] * 0.029115 + v_[332] * -0.001387;
    v_[162] = v_[338] * -0.038686875 + v_[199] * -0.000829 + v_[234] * 0.003227 + v_[180] * 0.000198;
    v_[156] = v_[199] * 1.5e-05 + v_[234] * 0.000198 + v_[180] * 0.010737;
    v_[253] = v_[229] * -0.184 + v_[162] * v_[77] + v_[156] * v_[76] + v_[159] * -0.057838 + v_[165] * -0.012652 +
              v_[199] * -0.001387 + v_[332] * 0.019432;
    v_[151] = v_[189] * v_[68] + v_[166] * v_[61] + v_[127] * v_[52] + v_[253] * v_[53] + v_[22] * -0.160298259823722 +
              v_[334] * 1.52322944854339e-09 + v_[193] * -0.0022920002 + v_[195] * 0.01828449 + v_[165] * 0.0036857284;
    v_[229] = v_[229] * 0.02075 + v_[162] * v_[86] + v_[156] * v_[77] + v_[165] * 0.011046 + v_[199] * -0.001243 +
              v_[332] * -0.012652 + v_[22] * -0.008711861 + v_[202] * -1.52322944854339e-09 + v_[193] * -0.00021200017 +
              v_[195] * 0.0036857284 + v_[165] * 0.081661;
    v_[179] = v_[194] * -0.304 + v_[151] * v_[28] + v_[229] * v_[30] + v_[25] * 0.647967112 + v_[24] * 0.20986895 +
              v_[188] * 5.399998e-05;
    v_[341] = v_[198] * 1.547475;
    v_[333] = v_[197] * -1.547475;
    v_[200] = v_[199] * 0.038686875;
    v_[168] = v_[333] - v_[200];
    v_[157] = v_[245] * v_[206] + v_[341] * v_[87] + v_[228] * v_[211] + v_[168] * v_[85];
    v_[348] = v_[190] * 2.1032 + v_[199] * 0.057838;
    v_[313] = 0 - v_[348];
    v_[325] = v_[334] * 2.1032;
    v_[317] = v_[157] + v_[182] * v_[218] + v_[313] * v_[71] + v_[120] * v_[308] + v_[325] * v_[55] + v_[166] * w_in[4];
    v_[315] = 0 - v_[341];
    v_[187] = v_[338] * 1.547475 + (0 - v_[234]) * 0.038686875;
    v_[186] = v_[149] * v_[287] + v_[315] * v_[91] + v_[131] * v_[211] + v_[187] * v_[85] + v_[196] * w_in[5];
    v_[200] = 0 - v_[333] + v_[200];
    v_[333] = 0 - v_[187];
    v_[176] = v_[232] * v_[287] + v_[200] * v_[91] + v_[238] * v_[206] + v_[333] * v_[87] - v_[204] * w_in[5];
    v_[152] = v_[159] * -2.1032 + v_[332] * 0.057838;
    v_[144] = 0 - v_[152];
    v_[147] = 0 - v_[325];
    v_[336] = v_[186] * v_[77] + v_[176] * v_[76] + v_[119] * v_[218] + v_[144] * v_[71] + v_[118] * v_[287] +
              v_[147] * v_[58] - v_[189] * w_in[4];
    v_[328] = v_[334] * 1.7423722 + (0 - v_[193]) * -0.008711861 + v_[195] * 1.52322944854339e-09;
    v_[191] = v_[202] * -1.7423722;
    v_[163] = v_[193] * 0.160298259823722;
    v_[155] = v_[165] * 1.52322944854339e-09;
    v_[301] = v_[191] - v_[163] + v_[155];
    v_[295] = v_[317] * v_[53] + v_[336] * v_[62] + v_[343] * v_[214] + v_[328] * v_[35] + v_[319] * v_[218] +
              v_[301] * v_[32];
    v_[175] = (0 - v_[199]) * 1.5e-05 + v_[234] * 0.000198 + v_[180] * 0.00605;
    v_[338] = v_[338] * 0.038686875 + v_[199] * -0.000829 + (0 - v_[234]) * -0.00146 + (0 - v_[180]) * 0.000198;
    v_[198] = (0 - v_[198]) * 0.038686875;
    v_[321] = v_[234] * 1.5e-05;
    v_[314] = (0 - v_[180]) * -0.000829;
    v_[270] = v_[198] + v_[321] + v_[314];
    v_[270] = v_[149] * v_[256] + v_[315] * v_[94] + v_[232] * v_[135] + v_[200] * v_[82] + v_[297] * v_[206] +
              v_[175] * v_[87] + v_[1] * v_[211] + v_[338] * v_[85] + v_[241] * v_[287] + v_[241] * v_[287] +
              v_[270] * v_[91] + v_[270] * v_[91];
    hes[35] = v_[322] * v_[95] + v_[204] * v_[83] + v_[302] * v_[256] + v_[196] * v_[94] + v_[269] * v_[223] +
              v_[162] * v_[98] + v_[259] * v_[206] + v_[156] * v_[87] + v_[270];
    v_[159] = v_[159] * 0.057838 + (0 - v_[165]) * -0.012652 + v_[199] * -0.001387 + v_[332] * -0.018069;
    v_[223] = v_[165] * 0.009683 + (0 - v_[199]) * -0.001243 + v_[332] * -0.012652;
    v_[95] = (0 - v_[334]) * 0.057838;
    v_[200] = (0 - v_[165]) * -0.001387;
    v_[315] = (0 - v_[332]) * -0.001243;
    v_[241] = v_[95] + v_[200] - v_[315];
    v_[241] = v_[270] + v_[186] * v_[78] + v_[176] * v_[81] + v_[130] * v_[285] + v_[348] * v_[64] + v_[118] * v_[137] +
              v_[147] * v_[80] + v_[212] * v_[218] + v_[159] * v_[71] + v_[277] * v_[308] + v_[223] * v_[55] +
              v_[268] * v_[287] + v_[268] * v_[287] + v_[241] * v_[58] + v_[241] * v_[58] + v_[253] * w_in[4];
    v_[180] = v_[197] * 0.038686875 + v_[199] * -0.00751 + (0 - v_[234]) * -0.000829 + v_[180] * 1.5e-05;
    v_[197] = (0 - v_[199]) * 0.000198;
    v_[314] = v_[198] + v_[197] - v_[314];
    v_[314] = v_[245] * v_[265] + v_[341] * v_[89] + v_[238] * v_[135] + v_[333] * v_[82] + v_[297] * v_[287] +
              v_[175] * v_[91] + v_[279] * v_[211] + v_[180] * v_[85] + v_[243] * v_[206] + v_[243] * v_[206] +
              v_[314] * v_[87] + v_[314] * v_[87] + v_[156] * w_in[5];
    v_[197] = 0 - v_[197] - v_[321];
    v_[197] = v_[228] * v_[265] + v_[168] * v_[89] + v_[131] * v_[256] + v_[187] * v_[94] + v_[1] * v_[287] +
              v_[338] * v_[91] + v_[279] * v_[206] + v_[180] * v_[87] + v_[323] * v_[211] + v_[323] * v_[211] +
              v_[197] * v_[85] + v_[197] * v_[85] - v_[162] * w_in[5];
    v_[180] = v_[190] * 0.057838 + v_[165] * -0.001243 + (0 - v_[199]) * -0.008386 + (0 - v_[332]) * -0.001387;
    v_[338] = v_[199] * -0.012652;
    v_[200] = v_[95] - v_[200] - v_[338];
    v_[200] = v_[157] * -0.184 + v_[314] * v_[77] + v_[197] * v_[76] + v_[124] * v_[285] + v_[152] * v_[64] +
              v_[120] * v_[201] + v_[325] * v_[69] + v_[294] * v_[218] + v_[180] * v_[71] + v_[277] * v_[287] +
              v_[223] * v_[58] + v_[282] * v_[308] + v_[282] * v_[308] + v_[200] * v_[55] + v_[200] * v_[55] -
              v_[127] * w_in[4];
    hes[28] = 0 -
              (v_[330] * v_[73] + v_[202] * v_[106] + v_[340] * v_[258] + v_[195] * v_[92] + v_[140] * v_[209] +
                  v_[189] * v_[66] + v_[273] * v_[215] + v_[127] * v_[34] + v_[150] * v_[158] + v_[317] * v_[44] +
                  v_[252] * v_[214] + v_[241] * v_[35] +
                  (v_[121] * v_[73] + v_[193] * v_[106] + v_[140] * v_[219] + v_[189] * v_[29] + v_[150] * v_[114] +
                      v_[317] * v_[47]) *
                      0.112 -
                  (v_[345] * v_[160] + v_[22] * v_[72] + v_[299] * v_[142] + v_[166] * v_[37] + v_[126] * v_[133] +
                      v_[336] * v_[46]) +
                  (v_[340] * v_[160] + v_[195] * v_[72] + v_[299] * v_[215] + v_[166] * v_[34] + v_[126] * v_[214] +
                      v_[336] * v_[35]) *
                      0.112 -
                  (v_[121] * v_[169] + v_[193] * v_[74] + v_[254] * v_[219] + v_[253] * v_[29] + v_[255] * v_[114] +
                      v_[200] * v_[47])) *
                  v_[177] +
              (v_[345] * v_[73] + v_[22] * v_[106] + v_[330] * v_[160] + v_[202] * v_[72] + v_[121] * v_[258] +
                  v_[193] * v_[92] + v_[340] * v_[169] + v_[195] * v_[74] + v_[140] * v_[142] + v_[189] * v_[37] +
                  v_[299] * v_[209] + v_[166] * v_[66] + v_[273] * v_[219] + v_[127] * v_[29] + v_[254] * v_[215] +
                  v_[253] * v_[34] + v_[150] * v_[133] + v_[317] * v_[46] + v_[126] * v_[158] + v_[336] * v_[44] +
                  v_[252] * v_[114] + v_[241] * v_[47] + v_[255] * v_[214] + v_[200] * v_[35] +
                  (v_[340] * v_[73] + v_[195] * v_[106] + v_[140] * v_[215] + v_[189] * v_[34] + v_[150] * v_[214] +
                      v_[317] * v_[35]) *
                      -0.112 +
                  (v_[121] * v_[160] + v_[193] * v_[72] + v_[299] * v_[219] + v_[166] * v_[29] + v_[126] * v_[114] +
                      v_[336] * v_[47]) *
                      0.112) *
                  v_[318];
    v_[142] = v_[22] * 1.7423722 + (0 - v_[195]) * 0.160298259823722 + v_[165] * -0.008711861;
    v_[255] = 0 - v_[142];
    v_[252] = v_[22] * -0.008711861 + v_[202] * 1.52322944854339e-09 + (0 - v_[193]) * -0.00021200017 +
              v_[195] * 0.0036857284 + v_[165] * 0.077424;
    v_[126] = v_[202] * 0.160298259823722 + v_[334] * -0.008711861 + v_[193] * -0.06337651 +
              (0 - v_[195]) * -0.0022920002 + v_[165] * -0.00021200017;
    v_[150] = (0 - v_[22]) * 1.52322944854339e-09;
    v_[340] = (0 - v_[334]) * 0.160298259823722;
    v_[121] = (0 - v_[193]) * 0.0036857284;
    v_[330] = (0 - v_[165]) * -0.0022920002;
    v_[345] = v_[150] + v_[340] + v_[121] - v_[330];
    v_[345] = v_[317] * v_[68] + v_[336] * v_[61] + v_[241] * v_[52] + v_[200] * v_[53] + v_[343] * v_[133] +
              v_[328] * v_[46] + v_[239] * v_[285] + v_[255] * v_[64] + v_[237] * v_[114] + v_[252] * v_[47] +
              v_[233] * v_[218] + v_[126] * v_[32] + v_[170] * v_[214] + v_[170] * v_[214] + v_[345] * v_[35] +
              v_[345] * v_[35] + v_[229] * w_in[3];
    v_[338] = v_[338] + v_[315];
    v_[338] = v_[157] * 0.02075 + v_[314] * v_[86] + v_[197] * v_[77] + v_[182] * v_[201] + v_[313] * v_[69] +
              v_[119] * v_[137] + v_[144] * v_[80] + v_[212] * v_[287] + v_[159] * v_[58] + v_[294] * v_[308] +
              v_[180] * v_[55] + v_[324] * v_[218] + v_[324] * v_[218] + v_[338] * v_[71] + v_[338] * v_[71];
    hes[34] = v_[140] * v_[225] + v_[189] * v_[90] + v_[299] * v_[201] + v_[166] * v_[69] + v_[273] * v_[271] +
              v_[127] * v_[56] + v_[254] * v_[287] + v_[253] * v_[58] + v_[338];
    v_[22] = v_[22] * 0.160298259823722 + v_[334] * 1.52322944854339e-09 + v_[193] * -0.0022920002 +
             (0 - v_[195]) * 0.01404749 + (0 - v_[165]) * 0.0036857284;
    v_[225] = (0 - v_[202]) * -0.008711861;
    v_[271] = v_[195] * -0.00021200017;
    v_[121] = v_[150] + v_[225] - v_[121] - v_[271];
    v_[121] = v_[338] + v_[319] * v_[133] + v_[301] * v_[46] + v_[240] * v_[158] + v_[142] * v_[44] +
              v_[257] * v_[114] + v_[22] * v_[47] + v_[233] * v_[214] + v_[126] * v_[35] + v_[227] * v_[218] +
              v_[227] * v_[218] + v_[121] * v_[32] + v_[121] * v_[32] - v_[151] * w_in[3];
    v_[338] = (0 - v_[24]) * -0.0055615274403 + v_[188] * 0.01438086;
    v_[126] = 0 - v_[338];
    v_[301] = v_[8] * 0.647967112 + v_[24] * 5.399998e-05 + v_[188] * -0.199538951;
    v_[133] = v_[8] * -0.0055615274403 + v_[25] * 0.01438086 + (0 - v_[24]) * -0.0037997814 + v_[188] * -0.011715295;
    v_[227] = (0 - v_[25]) * -0.0055615274403;
    v_[233] = (0 - v_[188]) * -0.0037997814;
    v_[319] = v_[227] - v_[233];
    v_[253] = v_[320] * v_[43] + v_[335] * v_[42] +
              (v_[189] * v_[67] + v_[166] * v_[60] + v_[127] * v_[53] + v_[253] * v_[54] + v_[202] * 0.160298259823722 +
                  v_[334] * 0.008711861 + v_[193] * 0.09570849 + v_[195] * -0.0022920002 + v_[165] * -0.00021200017) *
                  -1 +
              v_[8] * -0.647967112 + v_[24] * 5.399998e-05 + v_[188] * 0.20236395;
    v_[319] = v_[295] * -0.304 + v_[345] * v_[28] + v_[121] * v_[30] + v_[146] * v_[192] + v_[126] * v_[39] +
              v_[301] * v_[23] + v_[123] * v_[331] + v_[133] * v_[12] + v_[50] * v_[289] + v_[50] * v_[289] +
              v_[319] * v_[15] + v_[319] * v_[15] + v_[253] * w_in[2];
    v_[50] = -v_[23] * v_[192];
    v_[127] = 0.160298259823722 * v_[219] + -1.52322944854339e-09 * v_[213] + 1.7423722 * v_[209] +
              -1.7423722 * (v_[226] - v_[280]) + 0.160298259823722 * v_[222] + 1.52322944854339e-09 * v_[51] +
              v_[52] * v_[73] + v_[53] * v_[160] - -0.008711861 * (v_[99] + v_[310]);
    v_[104] = 0.008711861 * v_[219] + 1.52322944854339e-09 * v_[215] + 1.7423722 * v_[134] + 1.7423722 * v_[49] +
              1.52322944854339e-09 * v_[113] + -0.008711861 * v_[222] +
              2.1032 * (v_[308] * v_[69] + v_[55] * v_[201] - (v_[287] * v_[80] + v_[58] * v_[137])) +
              2.1032 * v_[134] + v_[79] * v_[286] + v_[77] * v_[224] - 0.160298259823722 * (v_[99] + v_[205]) -
              0.057838 * (v_[104] + v_[167]);
    v_[221] = -0.647967112 * v_[242] + 2.327 * v_[164] + -2.327 * v_[50] + -0.0055615274403 * v_[117] +
              0.647967112 * v_[236] + v_[28] * v_[127] + v_[30] * v_[104] - 0.01438086 * v_[221];
    v_[328] = 0 - v_[328];
    v_[142] = v_[317] * v_[52] + v_[336] * v_[53] + v_[101] * v_[114] + v_[328] * v_[47] + v_[240] * v_[218] +
              v_[142] * v_[32] + v_[335] * w_in[3];
    v_[155] = 0 - v_[191] + v_[163] - v_[155];
    v_[255] = v_[186] * v_[79] + v_[176] * v_[77] + v_[130] * v_[287] + v_[348] * v_[58] + v_[124] * v_[308] +
              v_[152] * v_[55] + v_[327] * v_[114] + v_[155] * v_[47] + v_[239] * v_[214] + v_[255] * v_[35] -
              v_[320] * w_in[3];
    hes[27] = 0 -
              (v_[235] * v_[127] + v_[8] * v_[112] + v_[342] * v_[63] + v_[267] * v_[210] + v_[24] * v_[100] +
                  v_[298] * v_[164] + v_[320] * v_[41] + v_[335] * v_[7] + v_[250] * v_[306] + v_[151] * v_[14] +
                  v_[229] * v_[6] + v_[145] * v_[288] + v_[142] * v_[21] + v_[183] * v_[289] + v_[345] * v_[15] +
                  v_[121] * v_[23] +
                  (v_[272] * v_[127] + v_[188] * v_[112] + v_[298] * v_[242] + v_[320] * v_[16] + v_[145] * v_[331] +
                      v_[142] * v_[12]) *
                      -0.304) *
                  v_[309] +
              (v_[235] * v_[104] + v_[8] * v_[107] + v_[267] * v_[63] + v_[24] * v_[108] + v_[293] * v_[164] +
                  v_[335] * v_[41] + v_[300] * v_[306] + v_[229] * v_[14] + v_[291] * v_[288] + v_[255] * v_[21] +
                  v_[173] * v_[289] + v_[121] * v_[15] - v_[320] * v_[7] +
                  (v_[272] * v_[104] + v_[188] * v_[107] + v_[293] * v_[242] + v_[335] * v_[16] + v_[291] * v_[331] +
                      v_[255] * v_[12]) *
                      -0.304 -
                  (v_[342] * v_[210] + v_[151] * v_[6] + v_[345] * v_[23])) *
                  v_[161];
    v_[63] = 0 - (v_[25] * 2.327 + v_[24] * 0.647967112);
    v_[194] = v_[194] * -1 + v_[25] * 2.327 + v_[24] * 0.647967112;
    v_[210] = v_[142] * v_[28] + v_[255] * v_[30] + v_[63] * v_[23] + v_[231] * v_[331] + v_[338] * v_[12] +
              v_[194] * w_in[2];
    v_[291] = v_[289] * v_[15] + v_[15] * v_[289];
    v_[339] = 0.647967112 * v_[306] + 2.327 * v_[284] + 2.327 * v_[276] + 0.647967112 * v_[75] + 0.01438086 * v_[117] +
              -1 * v_[339] - -0.0055615274403 * v_[291];
    v_[276] = 0 - (v_[8] * -2.327 + v_[188] * 0.647967112);
    v_[126] = v_[295] * -1 + v_[276] * v_[23] + v_[146] * v_[289] + v_[126] * v_[15] - v_[329] * w_in[2];
    v_[291] =
        5.399998e-05 * v_[306] + 0.20236395 * v_[242] + -0.647967112 * v_[164] + 0.01438086 * v_[110] +
        0.647967112 * v_[50] + -0.199538951 * v_[236] + -0.011715295 * v_[117] + v_[43] * v_[127] + v_[42] * v_[104] +
        -1 * (0.09570849 * v_[219] + -0.0022920002 * v_[215] + -0.00021200017 * v_[213] + 0.160298259823722 * v_[209] +
                 0.008711861 * v_[134] + 0.160298259823722 * (v_[280] - v_[226]) + -0.06337651 * v_[222] +
                 -0.0022920002 * v_[113] + v_[53] * v_[258] + v_[54] * v_[169] + v_[67] * v_[73] + v_[60] * v_[160] -
                 -0.008711861 * v_[49] - -0.00021200017 * v_[51] - 0.0036857284 * (v_[205] - v_[310])) -
        5.399998e-05 * v_[75] - -0.0037997814 * (0 - v_[291]);
    v_[271] = v_[225] + v_[340] + v_[271] + v_[330];
    v_[271] = v_[317] * v_[67] + v_[336] * v_[60] + v_[241] * v_[53] + v_[200] * v_[54] + v_[101] * v_[158] +
              v_[328] * v_[44] + v_[327] * v_[285] + v_[155] * v_[64] + v_[237] * v_[214] + v_[252] * v_[35] +
              v_[257] * v_[218] + v_[22] * v_[32] + v_[154] * v_[114] + v_[154] * v_[114] + v_[271] * v_[47] +
              v_[271] * v_[47];
    hes[33] = v_[298] * v_[220] + v_[320] * v_[65] + v_[293] * v_[158] + v_[335] * v_[44] + v_[250] * v_[217] +
              v_[151] * v_[33] + v_[300] * v_[214] + v_[229] * v_[35] + v_[271];
    v_[335] = v_[25] * 0.647967112 + (0 - v_[24]) * -0.192033951 + (0 - v_[188]) * 5.399998e-05;
    v_[320] = (0 - v_[8]) * 0.01438086;
    v_[220] = v_[24] * -0.011715295;
    v_[158] = v_[320] - v_[220];
    v_[158] = v_[142] * v_[43] + v_[255] * v_[42] + v_[271] * -1 + v_[231] * v_[288] + v_[338] * v_[21] +
              v_[335] * v_[23] + v_[123] * v_[289] + v_[133] * v_[15] + v_[115] * v_[331] + v_[115] * v_[331] +
              v_[158] * v_[12] + v_[158] * v_[12] - v_[179] * w_in[2];
    hes[26] =
        (0 - (v_[216] * v_[109] + v_[292] * v_[17] + v_[249] * v_[3] + v_[48] * v_[5] +
                 (w_in[7] * v_[111] + v_[296] * w_in[1]) * 0.112 +
                 (v_[216] * v_[84] + v_[278] * v_[3] + v_[305] * v_[5]) * 0.112 -
                 (w_in[7] * v_[105] + v_[116] * w_in[1]))) *
            v_[9] -
        (v_[216] * v_[27] + v_[329] * v_[17] + v_[179] * v_[3] + v_[319] * v_[5] +
            (w_in[7] * v_[221] + v_[210] * w_in[1]) * 0.112 +
            (v_[216] * v_[339] + v_[194] * v_[3] + v_[126] * v_[5]) * 0.112 - (w_in[7] * v_[291] + v_[158] * w_in[1])) *
            v_[203] +
        (w_in[7] * v_[27] + v_[216] * v_[291] + v_[194] * v_[17] + v_[253] * v_[3] + v_[319] * w_in[1] +
            v_[158] * v_[5] + (v_[216] * v_[221] + v_[329] * v_[3] + v_[210] * v_[5]) * -0.112 +
            (w_in[7] * v_[339] + v_[126] * w_in[1]) * 0.112) *
            v_[251] -
        (w_in[7] * v_[109] + v_[216] * v_[105] + v_[278] * v_[17] + v_[208] * v_[3] + v_[48] * w_in[1] +
            v_[116] * v_[5] + (v_[216] * v_[111] + v_[292] * v_[3] + v_[296] * v_[5]) * -0.112 +
            (w_in[7] * v_[84] + v_[305] * w_in[1]) * 0.112) *
            v_[10];
    v_[291] = v_[350] * v_[286] + v_[199] * v_[93] + v_[322] * v_[262] + v_[204] * v_[57] + v_[129] * v_[287] +
              v_[186] * v_[58];
    v_[199] = v_[350] * v_[224] + v_[199] * v_[97] + v_[302] * v_[262] + v_[196] * v_[57] + v_[125] * v_[287] +
              v_[176] * v_[58];
    hes[29] = 0 -
              (v_[326] * v_[224] + v_[334] * v_[97] + v_[347] * v_[286] + v_[190] * v_[93] + v_[207] * v_[88] +
                  v_[165] * v_[102] + v_[96] * v_[26] + v_[332] * v_[103] + v_[322] * v_[136] + v_[204] * v_[70] +
                  v_[302] * v_[134] + v_[196] * v_[45] + v_[269] * v_[281] + v_[162] * v_[59] + v_[259] * v_[213] +
                  v_[156] * v_[36] + v_[129] * v_[137] + v_[186] * v_[80] + v_[125] * v_[285] + v_[176] * v_[64] +
                  v_[304] * v_[308] + v_[314] * v_[55] + v_[290] * v_[218] + v_[197] * v_[71] + v_[291] * 0.184 +
                  (0 - v_[199]) * 0.02075) *
                  v_[248] +
              (v_[347] * v_[224] + v_[190] * v_[97] + v_[96] * v_[88] + v_[332] * v_[102] + v_[302] * v_[136] +
                  v_[196] * v_[70] + v_[259] * v_[281] + v_[156] * v_[59] + v_[125] * v_[137] + v_[176] * v_[80] +
                  v_[290] * v_[308] + v_[197] * v_[55] -
                  (v_[326] * v_[286] + v_[334] * v_[93] + v_[322] * v_[134] + v_[204] * v_[45] + v_[129] * v_[285] +
                      v_[186] * v_[64]) +
                  v_[291] * 0.02075 + v_[199] * 0.184 -
                  (v_[207] * v_[26] + v_[165] * v_[103] + v_[269] * v_[213] + v_[162] * v_[36] + v_[304] * v_[218] +
                      v_[314] * v_[71])) *
                  v_[247];
    v_[229] = v_[151] * v_[31] + v_[229] * v_[28] + v_[8] * -0.0055615274403 + v_[25] * -0.01438086 +
              v_[24] * -0.0037997814 + v_[188] * -0.011715295;
    v_[220] = v_[320] + v_[227] + v_[220] + v_[233];
    v_[220] = v_[345] * v_[31] + v_[121] * v_[28] + v_[349] * v_[288] + v_[63] * v_[21] + v_[337] * v_[192] +
              v_[276] * v_[39] + v_[132] * v_[289] + v_[301] * v_[15] + v_[246] * v_[331] + v_[335] * v_[12] +
              v_[220] * v_[23] + v_[220] * v_[23];
    hes[32] = v_[292] * v_[122] + v_[329] * v_[40] + v_[278] * v_[288] + v_[194] * v_[21] + v_[249] * v_[307] +
              v_[179] * v_[13] + v_[208] * v_[289] + v_[253] * v_[15] + v_[220];
    v_[194] = v_[292] * v_[275] + v_[329] * v_[19] + v_[278] * v_[244] + v_[194] * v_[18] + v_[249] * v_[128] +
              v_[179] * v_[9] + v_[208] * v_[251] + v_[253] * v_[10];
    hes[30] = (v_[296] * v_[275] + v_[210] * v_[19] + v_[305] * v_[244] + v_[126] * v_[18] + v_[48] * v_[128] +
                  v_[319] * v_[9] + v_[116] * v_[251] + v_[158] * v_[10] + v_[229] * w_in[1]) *
                  v_[4] +
              (v_[220] - v_[194] * w_in[1]) * v_[0];
    hes[31] = v_[296] * v_[283] + v_[210] * v_[20] + v_[305] * v_[178] + v_[126] * v_[38] + v_[48] * v_[251] +
              v_[319] * v_[10] + v_[116] * v_[230] + v_[158] * v_[11] + v_[194] * v_[2] + v_[229] * v_[5];
    v_[194] = w_in[6] * v_[4];
    v_[229] = w_in[7] * v_[20] + v_[194] * v_[19];
    v_[158] = w_in[8] + w_in[6] * v_[0];
    v_[126] = w_in[7] * v_[10] + v_[194] * v_[9];
    v_[210] = (w_in[7] * v_[38] + v_[194] * v_[18]) * -1 + v_[126] * -0.304;
    v_[194] = w_in[7] * v_[11] + v_[194] * v_[10];
    v_[319] = v_[229] * v_[28] + v_[194] * v_[43];
    v_[178] = w_in[9] + v_[194] * -1;
    v_[283] = v_[158] * v_[31] + v_[126] * v_[28];
    v_[230] = v_[210] * v_[53] + v_[319] * v_[52] + v_[178] * v_[67] + v_[283] * v_[68];
    v_[116] = v_[158] * v_[28] + v_[126] * v_[30];
    v_[305] = w_in[10] + v_[116];
    v_[296] = v_[178] * v_[54] + v_[283] * v_[53];
    v_[48] = v_[230] + v_[305] * 0.02075 + v_[296] * -0.184;
    v_[251] = v_[305] * v_[86] + v_[296] * v_[77];
    v_[220] = v_[48] * 1.547475 + v_[251] * -0.038686875;
    v_[275] = v_[220] + v_[230] * 2.1032 + v_[296] * -0.057838;
    v_[244] = v_[229] * v_[30] + v_[194] * v_[42];
    v_[128] = v_[210] * v_[62] + v_[319] * v_[53] + v_[178] * v_[60] + v_[283] * v_[61];
    v_[253] = v_[178] * v_[53] + v_[283] * v_[52];
    v_[179] = v_[244] * v_[79] + v_[128] * v_[77] + v_[253] * v_[78];
    v_[329] = w_in[11] + v_[253];
    v_[278] = v_[179] * 1.547475 + v_[329] * 0.038686875;
    v_[208] = v_[244] * v_[77] + v_[128] * v_[76] + v_[253] * v_[81];
    v_[249] = v_[208] * 1.547475;
    v_[292] = v_[278] * v_[77] + v_[249] * v_[76] + v_[128] * 2.1032 + v_[253] * 0.057838;
    v_[122] = v_[275] * v_[52] + v_[292] * v_[53] + v_[319] * 1.7423722 + v_[178] * 0.160298259823722 +
              v_[116] * -1.52322944854339e-09;
    v_[288] = v_[278] * v_[79] + v_[249] * v_[77] + v_[244] * 2.1032 + v_[244] * 1.7423722 + v_[178] * 0.008711861 +
              v_[283] * 1.52322944854339e-09;
    v_[289] = v_[305] * v_[77] + v_[296] * v_[76];
    v_[307] = v_[179] * 0.038686875 + v_[329] * 0.009277 + v_[251] * -0.000829 + v_[289] * 1.5e-05 + v_[278] * v_[78] +
              v_[249] * v_[81] + v_[128] * 0.057838 + v_[305] * -0.001243 + v_[253] * 0.029115 + v_[296] * -0.001387;
    v_[335] = v_[48] * -0.038686875 + v_[329] * -0.000829 + v_[251] * 0.003227 + v_[289] * 0.000198;
    v_[276] = v_[329] * 1.5e-05 + v_[251] * 0.000198 + v_[289] * 0.010737;
    v_[63] = v_[220] * -0.184 + v_[335] * v_[77] + v_[276] * v_[76] + v_[230] * -0.057838 + v_[305] * -0.012652 +
             v_[253] * -0.001387 + v_[296] * 0.019432;
    v_[301] = v_[275] * v_[68] + v_[292] * v_[61] + v_[307] * v_[52] + v_[63] * v_[53] + v_[210] * -0.160298259823722 +
              v_[244] * 1.52322944854339e-09 + v_[178] * -0.0022920002 + v_[283] * 0.01828449 + v_[116] * 0.0036857284;
    v_[220] = v_[220] * 0.02075 + v_[335] * v_[86] + v_[276] * v_[77] + v_[305] * 0.011046 + v_[253] * -0.001243 +
              v_[296] * -0.012652 + v_[210] * -0.008711861 + v_[319] * -1.52322944854339e-09 +
              v_[178] * -0.00021200017 + v_[283] * 0.0036857284 + v_[116] * 0.081661;
    v_[121] = v_[208] * 1.547475;
    v_[345] = v_[179] * -1.547475;
    v_[192] = v_[329] * 0.038686875;
    v_[331] = v_[345] - v_[192];
    v_[246] = v_[121] * v_[87] + v_[331] * v_[85];
    v_[337] = v_[128] * 2.1032 + v_[253] * 0.057838;
    v_[349] = 0 - v_[337];
    v_[132] = v_[244] * 2.1032;
    v_[39] = v_[246] + v_[349] * v_[71] + v_[132] * v_[55] + v_[292] * w_in[4];
    v_[320] = 0 - v_[121];
    v_[233] = v_[48] * 1.547475 + (0 - v_[251]) * 0.038686875;
    v_[227] = v_[320] * v_[91] + v_[233] * v_[85] + v_[249] * w_in[5];
    v_[192] = 0 - v_[345] + v_[192];
    v_[345] = 0 - v_[233];
    v_[151] = v_[192] * v_[91] + v_[345] * v_[87] - v_[278] * w_in[5];
    v_[188] = v_[230] * -2.1032 + v_[296] * 0.057838;
    v_[8] = 0 - v_[188];
    v_[24] = 0 - v_[132];
    v_[25] = v_[227] * v_[77] + v_[151] * v_[76] + v_[8] * v_[71] + v_[24] * v_[58] - v_[275] * w_in[4];
    v_[199] = v_[244] * 1.7423722 + (0 - v_[178]) * -0.008711861 + v_[283] * 1.52322944854339e-09;
    v_[291] = 0 - v_[199];
    v_[197] = v_[210] * 1.7423722 + (0 - v_[283]) * 0.160298259823722 + v_[116] * -0.008711861;
    v_[314] = v_[39] * v_[52] + v_[25] * v_[53] + v_[291] * v_[47] + v_[197] * v_[32] + v_[288] * w_in[3];
    v_[176] = (0 - v_[329]) * 1.5e-05 + v_[251] * 0.000198 + v_[289] * 0.00605;
    v_[48] = v_[48] * 0.038686875 + v_[329] * -0.000829 + (0 - v_[251]) * -0.00146 + (0 - v_[289]) * 0.000198;
    v_[208] = (0 - v_[208]) * 0.038686875;
    v_[186] = v_[251] * 1.5e-05;
    v_[156] = (0 - v_[289]) * -0.000829;
    v_[162] = v_[208] + v_[186] + v_[156];
    v_[230] = v_[230] * 0.057838 + (0 - v_[305]) * -0.012652 + v_[253] * -0.001387 + v_[296] * -0.018069;
    v_[196] = v_[305] * 0.009683 + (0 - v_[253]) * -0.001243 + v_[296] * -0.012652;
    v_[204] = (0 - v_[244]) * 0.057838;
    v_[190] = (0 - v_[305]) * -0.001387;
    v_[334] = (0 - v_[296]) * -0.001243;
    v_[332] = v_[204] + v_[190] - v_[334];
    v_[165] = v_[320] * v_[94] + v_[192] * v_[82] + v_[176] * v_[87] + v_[48] * v_[85] + v_[162] * v_[91] +
              v_[162] * v_[91] + v_[227] * v_[78] + v_[151] * v_[81] + v_[337] * v_[64] + v_[24] * v_[80] +
              v_[230] * v_[71] + v_[196] * v_[55] + v_[332] * v_[58] + v_[332] * v_[58] + v_[63] * w_in[4];
    v_[289] = v_[179] * 0.038686875 + v_[329] * -0.00751 + (0 - v_[251]) * -0.000829 + v_[289] * 1.5e-05;
    v_[329] = (0 - v_[329]) * 0.000198;
    v_[156] = v_[208] + v_[329] - v_[156];
    v_[208] = v_[121] * v_[89] + v_[345] * v_[82] + v_[176] * v_[91] + v_[289] * v_[85] + v_[156] * v_[87] +
              v_[156] * v_[87] + v_[276] * w_in[5];
    v_[329] = 0 - v_[329] - v_[186];
    v_[186] = v_[331] * v_[89] + v_[233] * v_[94] + v_[48] * v_[91] + v_[289] * v_[87] + v_[329] * v_[85] +
              v_[329] * v_[85] - v_[335] * w_in[5];
    v_[179] = v_[128] * 0.057838 + v_[305] * -0.001243 + (0 - v_[253]) * -0.008386 + (0 - v_[296]) * -0.001387;
    v_[251] = v_[253] * -0.012652;
    v_[190] = v_[204] - v_[190] - v_[251];
    v_[204] = v_[246] * -0.184 + v_[208] * v_[77] + v_[186] * v_[76] + v_[188] * v_[64] + v_[132] * v_[69] +
              v_[179] * v_[71] + v_[196] * v_[58] + v_[190] * v_[55] + v_[190] * v_[55] - v_[307] * w_in[4];
    v_[88] = 0 - v_[197];
    v_[26] = v_[210] * -0.008711861 + v_[319] * 1.52322944854339e-09 + (0 - v_[178]) * -0.00021200017 +
             v_[283] * 0.0036857284 + v_[116] * 0.077424;
    v_[224] = v_[319] * 0.160298259823722 + v_[244] * -0.008711861 + v_[178] * -0.06337651 +
              (0 - v_[283]) * -0.0022920002 + v_[116] * -0.00021200017;
    v_[286] = (0 - v_[210]) * 1.52322944854339e-09;
    v_[137] = (0 - v_[178]) * 0.0036857284;
    v_[136] = v_[286] + (0 - v_[244]) * 0.160298259823722 + v_[137] - (0 - v_[116]) * -0.0022920002;
    v_[285] = v_[39] * v_[68] + v_[25] * v_[61] + v_[165] * v_[52] + v_[204] * v_[53] + v_[199] * v_[46] +
              v_[88] * v_[64] + v_[26] * v_[47] + v_[224] * v_[32] + v_[136] * v_[35] + v_[136] * v_[35] +
              v_[220] * w_in[3];
    v_[251] = v_[251] + v_[334];
    v_[334] = v_[319] * -1.7423722;
    v_[281] = v_[178] * 0.160298259823722;
    v_[308] = v_[116] * 1.52322944854339e-09;
    v_[134] = v_[334] - v_[281] + v_[308];
    v_[116] = v_[210] * 0.160298259823722 + v_[244] * 1.52322944854339e-09 + v_[178] * -0.0022920002 +
              (0 - v_[283]) * 0.01404749 + (0 - v_[116]) * 0.0036857284;
    v_[137] = v_[286] + (0 - v_[319]) * -0.008711861 - v_[137] - v_[283] * -0.00021200017;
    v_[246] = v_[246] * 0.02075 + v_[208] * v_[86] + v_[186] * v_[77] + v_[349] * v_[69] + v_[8] * v_[80] +
              v_[230] * v_[58] + v_[179] * v_[55] + v_[251] * v_[71] + v_[251] * v_[71] + v_[134] * v_[46] +
              v_[197] * v_[44] + v_[116] * v_[47] + v_[224] * v_[35] + v_[137] * v_[32] + v_[137] * v_[32] -
              v_[301] * w_in[3];
    v_[286] = 0 - v_[309];
    v_[213] = -v_[161];
    v_[218] = v_[286] * v_[15] + v_[213] * v_[23];
    v_[290] = v_[286] * v_[6] + v_[161] * v_[14] + v_[218] * w_in[3];
    v_[304] = -0.304 * v_[286];
    v_[125] = -0.304 * v_[161];
    v_[129] = v_[125] * v_[12] + v_[161] * v_[21];
    v_[259] = -v_[129];
    v_[269] = (-v_[161]) * v_[7] + v_[286] * v_[41] + v_[304] * v_[16] + v_[259] * w_in[3];
    v_[302] = v_[161] * v_[15] + v_[286] * v_[23];
    v_[322] = v_[302] * v_[46];
    v_[347] = v_[47] * v_[129];
    v_[326] = v_[302] * v_[35] + v_[32] * v_[218];
    v_[96] = v_[218] * v_[47];
    v_[207] = -v_[302];
    v_[287] = v_[213] * v_[6] + v_[286] * v_[14] + v_[207] * w_in[3];
    v_[262] = v_[304] * v_[12] + v_[286] * v_[21];
    v_[350] = v_[61] * v_[218] + v_[53] * v_[262];
    v_[339] = -v_[350];
    v_[221] = v_[68] * v_[287] + v_[52] * v_[269] + v_[339] * w_in[4];
    v_[27] = v_[52] * v_[218];
    v_[216] = v_[53] * v_[287] + v_[27] * w_in[4];
    v_[203] = v_[27] * v_[71] + v_[58] * v_[302];
    v_[84] = v_[53] * v_[218];
    v_[111] = v_[84] * v_[64] + v_[55] * v_[129] - (v_[302] * v_[80] + v_[71] * v_[350]);
    v_[105] = 0.02075 * v_[290] + -0.184 * v_[216] + v_[221];
    v_[109] = v_[76] * v_[84] + v_[77] * v_[302];
    v_[17] = -v_[109];
    v_[3] = v_[86] * v_[290] + v_[77] * v_[216] + v_[17] * w_in[5];
    v_[271] = v_[109] * v_[91] + v_[85] * v_[27];
    v_[255] = v_[79] * v_[129] + v_[77] * v_[350] + v_[78] * v_[27];
    v_[142] = v_[77] * v_[84] + v_[86] * v_[302];
    v_[133] = v_[77] * v_[129] + v_[76] * v_[350] + v_[81] * v_[27];
    v_[338] = v_[109] * v_[94] + v_[85] * v_[255] - (v_[142] * v_[82] + v_[87] * v_[133]);
    v_[115] = 1.547475 * v_[105] + -0.038686875 * v_[3] + 0.038686875 * v_[271] + 1.547475 * v_[338];
    v_[123] = 2.1032 * v_[221] + -0.057838 * v_[216] + 0.057838 * v_[203] + -2.1032 * v_[111] + v_[115];
    v_[231] = v_[68] * v_[218] + v_[52] * v_[262];
    v_[214] = v_[61] * v_[287] + v_[53] * v_[269] + v_[231] * w_in[4];
    v_[217] = -v_[84];
    v_[300] = v_[52] * v_[287] + v_[217] * w_in[4];
    v_[250] = v_[84] * v_[71] + v_[55] * v_[302];
    v_[293] = v_[27] * v_[64] + v_[58] * v_[129] - (v_[302] * v_[69] + v_[71] * v_[231]);
    v_[298] = v_[286] * v_[7] + v_[161] * v_[41] + v_[125] * v_[16] + v_[262] * w_in[3];
    v_[155] = -v_[133];
    v_[328] = v_[79] * v_[298] + v_[77] * v_[214] + v_[78] * v_[300] + v_[155] * w_in[5];
    v_[22] = v_[109] * v_[87] + v_[85] * v_[142];
    v_[252] = 0.02075 * v_[302] + -0.184 * v_[84] + v_[231];
    v_[200] = v_[109] * v_[89] + v_[85] * v_[252];
    v_[241] = v_[27] * v_[82] + v_[91] * v_[133];
    v_[336] = 1.547475 * v_[328] + 0.038686875 * v_[300] + 0.038686875 * v_[22] + -1.547475 * (v_[200] - v_[241]);
    v_[317] = v_[27] * v_[91] + v_[91] * v_[27];
    v_[114] = v_[142] * v_[87] + v_[87] * v_[142];
    v_[154] = 1.547475 * (v_[142] * v_[89] + v_[87] * v_[252] - (v_[27] * v_[94] + v_[91] * v_[255])) +
              1.547475 * (v_[77] * v_[298] + v_[76] * v_[214] + v_[81] * v_[300] + v_[255] * w_in[5]) -
              0.038686875 * (v_[317] + v_[114]);
    v_[327] = 2.1032 * v_[214] + 0.057838 * v_[300] + 0.057838 * v_[250] + 2.1032 * v_[293] + v_[77] * v_[336] +
              v_[76] * v_[154];
    v_[101] = v_[302] * v_[32] + v_[32] * v_[302];
    v_[257] = -1.52322944854339e-09 * v_[290] + 1.7423722 * v_[269] + -1.7423722 * (v_[322] - v_[347]) +
              0.160298259823722 * v_[326] + 1.52322944854339e-09 * v_[96] + v_[52] * v_[123] + v_[53] * v_[327] -
              -0.008711861 * v_[101];
    v_[237] = v_[302] * v_[44] + v_[32] * v_[262] - (v_[218] * v_[64] + v_[35] * v_[129]);
    v_[225] = v_[84] * v_[58] + v_[55] * v_[27];
    v_[330] = v_[77] * v_[290] + v_[76] * v_[216] + v_[142] * w_in[5];
    v_[340] = v_[142] * v_[91] + v_[87] * v_[27];
    v_[104] = v_[109] * v_[85] + v_[85] * v_[109];
    v_[338] = -0.000829 * v_[300] + 0.003227 * v_[3] + 0.000198 * v_[330] + -0.038686875 * v_[105] +
              0.000198 * v_[340] + 1.5e-05 * (v_[317] - v_[104]) - 0.038686875 * v_[338] - -0.00146 * v_[271] -
              -0.000829 * v_[22];
    v_[317] = 1.5e-05 * v_[300] + 0.000198 * v_[3] + 0.010737 * v_[330] + 0.00605 * v_[340] + 1.5e-05 * v_[22] -
              0.000198 * v_[271] - -0.000829 * (v_[317] - v_[114]);
    v_[105] = v_[27] * v_[58] + v_[58] * v_[27];
    v_[127] = v_[84] * v_[55] + v_[55] * v_[84];
    v_[50] = v_[302] * v_[47];
    v_[117] = v_[218] * v_[35] + v_[35] * v_[218];
    v_[347] = 0.0036857284 * v_[287] + 0.081661 * v_[290] + -1.52322944854339e-09 * v_[269] + -0.008711861 * v_[237] +
              1.52322944854339e-09 * (v_[322] - v_[347]) + 0.077424 * v_[96] + -0.00021200017 * v_[326] +
              0.011046 * v_[290] + -0.001243 * v_[300] + -0.012652 * v_[216] + -0.001243 * v_[250] +
              0.009683 * v_[225] + v_[86] * v_[338] + v_[77] * v_[317] + 0.02075 * v_[115] - -0.012652 * v_[203] -
              -0.001387 * (v_[105] - v_[127]) - 0.0036857284 * v_[50] - -0.0022920002 * (0 - v_[117]);
    v_[322] = v_[218] * v_[46] - v_[47] * v_[262];
    v_[75] = v_[302] * v_[71] + v_[71] * v_[302];
    v_[104] = -0.001243 * v_[290] + 0.029115 * v_[300] + -0.001387 * v_[216] + 0.057838 * v_[214] + 0.057838 * v_[293] +
              -0.001387 * v_[203] + -0.012652 * (v_[75] - v_[127]) + v_[78] * v_[336] + v_[81] * v_[154] +
              0.009277 * v_[300] + -0.000829 * v_[3] + 1.5e-05 * v_[330] + 0.038686875 * v_[328] + -0.00751 * v_[22] +
              0.038686875 * (v_[241] - v_[200]) + -0.000829 * v_[271] - 1.5e-05 * v_[340] -
              0.000198 * (v_[114] - v_[104]) - -0.008386 * v_[250] - -0.001243 * v_[225];
    v_[75] = -0.012652 * v_[290] + -0.001387 * v_[300] + 0.019432 * v_[216] + -0.057838 * v_[221] +
             -0.018069 * v_[203] + 0.057838 * v_[111] + -0.012652 * v_[225] + v_[77] * v_[338] + v_[76] * v_[317] +
             -0.184 * v_[115] - -0.001387 * v_[250] - -0.001243 * (v_[75] - v_[105]);
    v_[237] = 0.01828449 * v_[287] + 0.0036857284 * v_[290] + 1.52322944854339e-09 * v_[298] +
              1.52322944854339e-09 * v_[322] + 0.0036857284 * v_[96] + -0.00021200017 * (0 - v_[101]) +
              v_[52] * v_[104] + v_[53] * v_[75] + v_[68] * v_[123] + v_[61] * v_[327] - 0.160298259823722 * v_[237] -
              0.01404749 * v_[50] - -0.0022920002 * v_[326];
    v_[101] = v_[229] * v_[286] + v_[194] * v_[304];
    v_[96] = v_[158] * v_[213] + v_[126] * v_[286];
    v_[225] = v_[101] * v_[52] + v_[96] * v_[68];
    v_[250] = v_[158] * v_[286] + v_[126] * v_[161];
    v_[115] = v_[96] * v_[53];
    v_[111] = v_[225] + v_[250] * 0.02075 + v_[115] * -0.184;
    v_[203] = v_[250] * v_[86] + v_[115] * v_[77];
    v_[221] = v_[111] * 1.547475 + v_[203] * -0.038686875;
    v_[340] = v_[221] + v_[225] * 2.1032 + v_[115] * -0.057838;
    v_[330] = v_[229] * v_[161] + v_[194] * v_[125];
    v_[114] = v_[101] * v_[53] + v_[96] * v_[61];
    v_[241] = v_[96] * v_[52];
    v_[200] = v_[330] * v_[79] + v_[114] * v_[77] + v_[241] * v_[78];
    v_[22] = v_[200] * 1.547475 + v_[241] * 0.038686875;
    v_[328] = v_[330] * v_[77] + v_[114] * v_[76] + v_[241] * v_[81];
    v_[293] = v_[328] * 1.547475;
    v_[271] = v_[22] * v_[77] + v_[293] * v_[76] + v_[114] * 2.1032 + v_[241] * 0.057838;
    v_[3] = v_[340] * v_[52] + v_[271] * v_[53] + v_[101] * 1.7423722 + v_[250] * -1.52322944854339e-09;
    v_[110] =
        v_[22] * v_[79] + v_[293] * v_[77] + v_[330] * 2.1032 + v_[330] * 1.7423722 + v_[96] * 1.52322944854339e-09;
    v_[205] = v_[250] * v_[77] + v_[115] * v_[76];
    v_[280] = v_[200] * 0.038686875 + v_[241] * 0.009277 + v_[203] * -0.000829 + v_[205] * 1.5e-05 + v_[22] * v_[78] +
              v_[293] * v_[81] + v_[114] * 0.057838 + v_[250] * -0.001243 + v_[241] * 0.029115 + v_[115] * -0.001387;
    v_[226] = v_[111] * -0.038686875 + v_[241] * -0.000829 + v_[203] * 0.003227 + v_[205] * 0.000198;
    v_[222] = v_[241] * 1.5e-05 + v_[203] * 0.000198 + v_[205] * 0.010737;
    v_[113] = v_[221] * -0.184 + v_[226] * v_[77] + v_[222] * v_[76] + v_[225] * -0.057838 + v_[250] * -0.012652 +
              v_[241] * -0.001387 + v_[115] * 0.019432;
    v_[160] = v_[340] * v_[68] + v_[271] * v_[61] + v_[280] * v_[52] + v_[113] * v_[53] +
              v_[330] * 1.52322944854339e-09 + v_[96] * 0.01828449 + v_[250] * 0.0036857284;
    v_[221] = v_[221] * 0.02075 + v_[226] * v_[86] + v_[222] * v_[77] + v_[250] * 0.011046 + v_[241] * -0.001243 +
              v_[115] * -0.012652 + v_[101] * -1.52322944854339e-09 + v_[96] * 0.0036857284 + v_[250] * 0.081661;
    v_[73] = v_[328] * 1.547475;
    v_[169] = v_[200] * -1.547475;
    v_[258] = v_[241] * 0.038686875;
    v_[209] = v_[169] - v_[258];
    v_[310] = v_[121] * v_[142] + v_[73] * v_[87] + v_[331] * v_[109] + v_[209] * v_[85];
    v_[51] = v_[114] * 2.1032 + v_[241] * 0.057838;
    v_[49] = 0 - v_[51];
    v_[164] = v_[330] * 2.1032;
    v_[215] = v_[310] + v_[349] * v_[302] + v_[49] * v_[71] + v_[132] * v_[84] + v_[164] * v_[55] + v_[271] * w_in[4];
    v_[219] = 0 - v_[73];
    v_[236] = v_[111] * 1.547475 + (0 - v_[203]) * 0.038686875;
    v_[242] = v_[320] * v_[27] + v_[219] * v_[91] + v_[233] * v_[109] + v_[236] * v_[85] + v_[293] * w_in[5];
    v_[258] = 0 - v_[169] + v_[258];
    v_[169] = 0 - v_[236];
    v_[306] = v_[192] * v_[27] + v_[258] * v_[91] + v_[345] * v_[142] + v_[169] * v_[87] - v_[22] * w_in[5];
    v_[295] = v_[225] * -2.1032 + v_[115] * 0.057838;
    v_[146] = 0 - v_[295];
    v_[284] = 0 - v_[164];
    v_[145] = v_[242] * v_[77] + v_[306] * v_[76] + v_[8] * v_[302] + v_[146] * v_[71] + v_[24] * v_[27] +
              v_[284] * v_[58] - v_[340] * w_in[4];
    v_[173] = v_[330] * 1.7423722 + v_[96] * 1.52322944854339e-09;
    v_[183] = 0 - v_[173];
    v_[342] = (0 - v_[96]) * 0.160298259823722 + v_[250] * -0.008711861;
    v_[272] = v_[215] * v_[52] + v_[145] * v_[53] + v_[183] * v_[47] + v_[197] * v_[302] + v_[342] * v_[32] +
              v_[110] * w_in[3];
    v_[235] = (0 - v_[241]) * 1.5e-05 + v_[203] * 0.000198 + v_[205] * 0.00605;
    v_[111] = v_[111] * 0.038686875 + v_[241] * -0.000829 + (0 - v_[203]) * -0.00146 + (0 - v_[205]) * 0.000198;
    v_[328] = (0 - v_[328]) * 0.038686875;
    v_[267] = v_[203] * 1.5e-05;
    v_[152] = (0 - v_[205]) * -0.000829;
    v_[348] = v_[328] + v_[267] + v_[152];
    v_[348] = v_[320] * v_[255] + v_[219] * v_[94] + v_[192] * v_[133] + v_[258] * v_[82] + v_[176] * v_[142] +
              v_[235] * v_[87] + v_[48] * v_[109] + v_[111] * v_[85] + v_[162] * v_[27] + v_[162] * v_[27] +
              v_[348] * v_[91] + v_[348] * v_[91];
    hes[47] = v_[278] * v_[155] + v_[22] * v_[83] + v_[249] * v_[255] + v_[293] * v_[94] + v_[335] * v_[17] +
              v_[226] * v_[98] + v_[276] * v_[142] + v_[222] * v_[87] + v_[348];
    v_[225] = v_[225] * 0.057838 + (0 - v_[250]) * -0.012652 + v_[241] * -0.001387 + v_[115] * -0.018069;
    v_[155] = v_[250] * 0.009683 + (0 - v_[241]) * -0.001243 + v_[115] * -0.012652;
    v_[17] = (0 - v_[330]) * 0.057838;
    v_[258] = (0 - v_[250]) * -0.001387;
    v_[219] = (0 - v_[115]) * -0.001243;
    v_[162] = v_[17] + v_[258] - v_[219];
    v_[162] = v_[348] + v_[242] * v_[78] + v_[306] * v_[81] + v_[337] * v_[129] + v_[51] * v_[64] + v_[24] * v_[350] +
              v_[284] * v_[80] + v_[230] * v_[302] + v_[225] * v_[71] + v_[196] * v_[84] + v_[155] * v_[55] +
              v_[332] * v_[27] + v_[332] * v_[27] + v_[162] * v_[58] + v_[162] * v_[58] + v_[113] * w_in[4];
    v_[205] = v_[200] * 0.038686875 + v_[241] * -0.00751 + (0 - v_[203]) * -0.000829 + v_[205] * 1.5e-05;
    v_[200] = (0 - v_[241]) * 0.000198;
    v_[152] = v_[328] + v_[200] - v_[152];
    v_[152] = v_[121] * v_[252] + v_[73] * v_[89] + v_[345] * v_[133] + v_[169] * v_[82] + v_[176] * v_[27] +
              v_[235] * v_[91] + v_[289] * v_[109] + v_[205] * v_[85] + v_[156] * v_[142] + v_[156] * v_[142] +
              v_[152] * v_[87] + v_[152] * v_[87] + v_[222] * w_in[5];
    v_[200] = 0 - v_[200] - v_[267];
    v_[200] = v_[331] * v_[252] + v_[209] * v_[89] + v_[233] * v_[255] + v_[236] * v_[94] + v_[48] * v_[27] +
              v_[111] * v_[91] + v_[289] * v_[142] + v_[205] * v_[87] + v_[329] * v_[109] + v_[329] * v_[109] +
              v_[200] * v_[85] + v_[200] * v_[85] - v_[226] * w_in[5];
    v_[205] = v_[114] * 0.057838 + v_[250] * -0.001243 + (0 - v_[241]) * -0.008386 + (0 - v_[115]) * -0.001387;
    v_[111] = v_[241] * -0.012652;
    v_[258] = v_[17] - v_[258] - v_[111];
    v_[258] = v_[310] * -0.184 + v_[152] * v_[77] + v_[200] * v_[76] + v_[188] * v_[129] + v_[295] * v_[64] +
              v_[132] * v_[231] + v_[164] * v_[69] + v_[179] * v_[302] + v_[205] * v_[71] + v_[196] * v_[27] +
              v_[155] * v_[58] + v_[190] * v_[84] + v_[190] * v_[84] + v_[258] * v_[55] + v_[258] * v_[55] -
              v_[280] * w_in[4];
    hes[40] =
        0 -
        (v_[319] * v_[123] + v_[101] * v_[106] + v_[283] * v_[104] + v_[96] * v_[92] + v_[275] * v_[269] +
            v_[340] * v_[66] + v_[307] * v_[287] + v_[280] * v_[34] + v_[39] * v_[262] + v_[215] * v_[44] +
            v_[165] * v_[218] + v_[162] * v_[35] + (v_[178] * v_[123] + v_[340] * v_[29] + v_[215] * v_[47]) * 0.112 -
            (v_[210] * v_[327] + v_[271] * v_[37] + v_[145] * v_[46]) +
            (v_[283] * v_[327] + v_[96] * v_[72] + v_[292] * v_[287] + v_[271] * v_[34] + v_[25] * v_[218] +
                v_[145] * v_[35]) *
                0.112 -
            (v_[178] * v_[75] + v_[113] * v_[29] + v_[258] * v_[47])) *
            v_[177] +
        (v_[210] * v_[123] + v_[319] * v_[327] + v_[101] * v_[72] + v_[178] * v_[104] + v_[283] * v_[75] +
            v_[96] * v_[74] + v_[340] * v_[37] + v_[292] * v_[269] + v_[271] * v_[66] + v_[280] * v_[29] +
            v_[63] * v_[287] + v_[113] * v_[34] + v_[215] * v_[46] + v_[25] * v_[262] + v_[145] * v_[44] +
            v_[162] * v_[47] + v_[204] * v_[218] + v_[258] * v_[35] +
            (v_[283] * v_[123] + v_[96] * v_[106] + v_[275] * v_[287] + v_[340] * v_[34] + v_[39] * v_[218] +
                v_[215] * v_[35]) *
                -0.112 +
            (v_[178] * v_[327] + v_[271] * v_[29] + v_[145] * v_[47]) * 0.112) *
            v_[318];
    v_[75] = 0 - v_[342];
    v_[104] = v_[101] * 1.52322944854339e-09 + v_[96] * 0.0036857284 + v_[250] * 0.077424;
    v_[327] =
        v_[101] * 0.160298259823722 + v_[330] * -0.008711861 + (0 - v_[96]) * -0.0022920002 + v_[250] * -0.00021200017;
    v_[123] = (0 - v_[330]) * 0.160298259823722;
    v_[269] = (0 - v_[250]) * -0.0022920002;
    v_[204] = v_[123] - v_[269];
    v_[204] = v_[215] * v_[68] + v_[145] * v_[61] + v_[162] * v_[52] + v_[258] * v_[53] + v_[173] * v_[46] +
              v_[88] * v_[129] + v_[75] * v_[64] + v_[104] * v_[47] + v_[224] * v_[302] + v_[327] * v_[32] +
              v_[136] * v_[218] + v_[136] * v_[218] + v_[204] * v_[35] + v_[204] * v_[35] + v_[221] * w_in[3];
    v_[111] = v_[111] + v_[219];
    v_[111] = v_[310] * 0.02075 + v_[152] * v_[86] + v_[200] * v_[77] + v_[349] * v_[231] + v_[49] * v_[69] +
              v_[8] * v_[350] + v_[146] * v_[80] + v_[230] * v_[27] + v_[225] * v_[58] + v_[179] * v_[84] +
              v_[205] * v_[55] + v_[251] * v_[302] + v_[251] * v_[302] + v_[111] * v_[71] + v_[111] * v_[71];
    hes[46] = v_[275] * v_[339] + v_[340] * v_[90] + v_[292] * v_[231] + v_[271] * v_[69] + v_[307] * v_[217] +
              v_[280] * v_[56] + v_[63] * v_[27] + v_[113] * v_[58] + v_[111];
    v_[217] = v_[101] * -1.7423722;
    v_[339] = v_[250] * 1.52322944854339e-09;
    v_[63] = v_[217] + v_[339];
    v_[307] = v_[330] * 1.52322944854339e-09 + (0 - v_[96]) * 0.01404749 + (0 - v_[250]) * 0.0036857284;
    v_[292] = (0 - v_[101]) * -0.008711861;
    v_[275] = v_[96] * -0.00021200017;
    v_[205] = v_[292] - v_[275];
    v_[205] = v_[111] + v_[63] * v_[46] + v_[197] * v_[262] + v_[342] * v_[44] + v_[307] * v_[47] + v_[224] * v_[218] +
              v_[327] * v_[35] + v_[137] * v_[302] + v_[137] * v_[302] + v_[205] * v_[32] + v_[205] * v_[32] -
              v_[160] * w_in[3];
    v_[322] = 1.52322944854339e-09 * v_[287] + 1.7423722 * v_[298] + 1.7423722 * v_[322] +
              1.52322944854339e-09 * v_[50] + -0.008711861 * v_[326] +
              2.1032 * (v_[84] * v_[69] + v_[55] * v_[231] - (v_[27] * v_[80] + v_[58] * v_[350])) + 2.1032 * v_[298] +
              v_[79] * v_[336] + v_[77] * v_[154] - 0.160298259823722 * v_[117] - 0.057838 * (v_[105] + v_[127]);
    v_[339] = 0 - v_[217] - v_[339];
    v_[75] = v_[242] * v_[79] + v_[306] * v_[77] + v_[337] * v_[27] + v_[51] * v_[58] + v_[188] * v_[84] +
             v_[295] * v_[55] + v_[339] * v_[47] + v_[88] * v_[218] + v_[75] * v_[35] - v_[3] * w_in[3];
    v_[308] = 0 - v_[334] + v_[281] - v_[308];
    v_[88] = v_[227] * v_[79] + v_[151] * v_[77] + v_[337] * v_[58] + v_[188] * v_[55] + v_[308] * v_[47] +
             v_[88] * v_[35] - v_[122] * w_in[3];
    hes[39] =
        (0 - (v_[229] * v_[112] + v_[158] * v_[108] + v_[126] * v_[100] + v_[122] * v_[41] + v_[288] * v_[7] +
                 v_[301] * v_[14] + v_[220] * v_[6] + v_[314] * v_[21] + v_[285] * v_[15] + v_[246] * v_[23] +
                 (v_[194] * v_[112] + v_[122] * v_[16] + v_[314] * v_[12]) * -0.304)) *
            v_[28] -
        (v_[229] * v_[257] + v_[158] * v_[347] + v_[126] * v_[237] + v_[3] * v_[41] + v_[110] * v_[7] +
            v_[160] * v_[14] + v_[221] * v_[6] + v_[272] * v_[21] + v_[204] * v_[15] + v_[205] * v_[23] +
            (v_[194] * v_[257] + v_[3] * v_[16] + v_[272] * v_[12]) * -0.304) *
            v_[309] +
        (v_[229] * v_[322] + v_[126] * v_[347] + v_[110] * v_[41] + v_[221] * v_[14] + v_[75] * v_[21] +
            v_[205] * v_[15] - v_[3] * v_[7] + (v_[194] * v_[322] + v_[110] * v_[16] + v_[75] * v_[12]) * -0.304 -
            (v_[158] * v_[237] + v_[160] * v_[6] + v_[204] * v_[23])) *
            v_[161] -
        (v_[229] * v_[107] + v_[126] * v_[108] + v_[288] * v_[41] + v_[220] * v_[14] + v_[88] * v_[21] +
            v_[246] * v_[15] - v_[122] * v_[7] + (v_[194] * v_[107] + v_[288] * v_[16] + v_[88] * v_[12]) * -0.304 -
            (v_[158] * v_[100] + v_[301] * v_[6] + v_[285] * v_[23])) *
            v_[30];
    v_[322] = v_[253] * v_[336] + v_[241] * v_[93] + v_[278] * v_[300] + v_[22] * v_[57] + v_[227] * v_[27] +
              v_[242] * v_[58];
    v_[241] = v_[253] * v_[154] + v_[241] * v_[97] + v_[249] * v_[300] + v_[293] * v_[57] + v_[151] * v_[27] +
              v_[306] * v_[58];
    hes[41] = 0 -
              (v_[244] * v_[154] + v_[330] * v_[97] + v_[128] * v_[336] + v_[114] * v_[93] + v_[305] * v_[317] +
                  v_[250] * v_[102] + v_[296] * v_[338] + v_[115] * v_[103] + v_[278] * v_[214] + v_[22] * v_[70] +
                  v_[249] * v_[298] + v_[293] * v_[45] + v_[335] * v_[216] + v_[226] * v_[59] + v_[276] * v_[290] +
                  v_[222] * v_[36] + v_[227] * v_[350] + v_[242] * v_[80] + v_[151] * v_[129] + v_[306] * v_[64] +
                  v_[208] * v_[84] + v_[152] * v_[55] + v_[186] * v_[302] + v_[200] * v_[71] + v_[322] * 0.184 +
                  (0 - v_[241]) * 0.02075) *
                  v_[248] +
              (v_[128] * v_[154] + v_[114] * v_[97] + v_[296] * v_[317] + v_[115] * v_[102] + v_[249] * v_[214] +
                  v_[293] * v_[70] + v_[276] * v_[216] + v_[222] * v_[59] + v_[151] * v_[350] + v_[306] * v_[80] +
                  v_[186] * v_[84] + v_[200] * v_[55] -
                  (v_[244] * v_[336] + v_[330] * v_[93] + v_[278] * v_[298] + v_[22] * v_[45] + v_[227] * v_[129] +
                      v_[242] * v_[64]) +
                  v_[322] * 0.02075 + v_[241] * 0.184 -
                  (v_[305] * v_[338] + v_[250] * v_[103] + v_[335] * v_[290] + v_[226] * v_[36] + v_[208] * v_[302] +
                      v_[152] * v_[71])) *
                  v_[247];
    v_[241] = v_[340] * v_[53] + v_[271] * v_[62] + v_[96] * -0.160298259823722 + v_[250] * -0.008711861;
    v_[322] = v_[241] * -1;
    v_[200] = v_[314] * v_[286] + v_[272] * v_[28] + v_[88] * v_[161] + v_[75] * v_[30] + v_[322] * w_in[2];
    v_[63] = v_[215] * v_[53] + v_[145] * v_[62] + v_[199] * v_[218] + v_[173] * v_[35] + v_[134] * v_[302] +
             v_[63] * v_[32];
    v_[173] = v_[122] * v_[286] + v_[3] * v_[28] + v_[288] * v_[161] + v_[110] * v_[30];
    v_[134] = v_[63] * -1 - v_[173] * w_in[2];
    v_[113] = v_[122] * v_[304] + v_[3] * v_[43] + v_[288] * v_[125] + v_[110] * v_[42] +
              (v_[340] * v_[67] + v_[271] * v_[60] + v_[280] * v_[53] + v_[113] * v_[54] + v_[101] * 0.160298259823722 +
                  v_[330] * 0.008711861 + v_[96] * -0.0022920002 + v_[250] * -0.00021200017) *
                  -1;
    v_[63] = v_[63] * -0.304 + v_[285] * v_[286] + v_[204] * v_[28] + v_[246] * v_[161] + v_[205] * v_[30] +
             v_[113] * w_in[2];
    v_[275] = v_[292] + v_[123] + v_[275] + v_[269];
    v_[275] = v_[215] * v_[67] + v_[145] * v_[60] + v_[162] * v_[53] + v_[258] * v_[54] + v_[291] * v_[262] +
              v_[183] * v_[44] + v_[308] * v_[129] + v_[339] * v_[64] + v_[26] * v_[218] + v_[104] * v_[35] +
              v_[116] * v_[302] + v_[307] * v_[32] + v_[275] * v_[47] + v_[275] * v_[47];
    hes[45] = v_[122] * v_[259] + v_[3] * v_[65] + v_[288] * v_[262] + v_[110] * v_[44] + v_[301] * v_[207] +
              v_[160] * v_[33] + v_[220] * v_[218] + v_[221] * v_[35] + v_[275];
    v_[241] = v_[241] * -0.304 + v_[301] * v_[286] + v_[160] * v_[28] + v_[220] * v_[161] + v_[221] * v_[30];
    v_[275] =
        v_[314] * v_[304] + v_[272] * v_[43] + v_[88] * v_[125] + v_[75] * v_[42] + v_[275] * -1 - v_[241] * w_in[2];
    v_[221] = v_[301] * v_[213] + v_[160] * v_[31] + v_[220] * v_[286] + v_[221] * v_[28];
    v_[205] = v_[285] * v_[213] + v_[204] * v_[31] + v_[246] * v_[286] + v_[205] * v_[28];
    hes[44] = v_[173] * v_[40] + v_[322] * v_[21] + v_[241] * v_[13] + v_[113] * v_[15] + v_[205];
    v_[241] = v_[173] * v_[19] + v_[322] * v_[18] + v_[241] * v_[9] + v_[113] * v_[10];
    hes[42] = (v_[200] * v_[19] + v_[134] * v_[18] + v_[63] * v_[9] + v_[275] * v_[10] + v_[221] * w_in[1]) * v_[4] +
              (v_[205] - v_[241] * w_in[1]) * v_[0];
    hes[43] =
        v_[200] * v_[20] + v_[134] * v_[38] + v_[63] * v_[10] + v_[275] * v_[11] + v_[241] * v_[2] + v_[221] * v_[5];
    v_[241] = w_in[6] * v_[4];
    v_[221] = w_in[7] * v_[20] + v_[241] * v_[19];
    v_[275] = w_in[7] * v_[11] + v_[241] * v_[10];
    v_[63] = v_[221] * v_[28] + v_[275] * v_[43];
    v_[134] = w_in[8] + w_in[6] * v_[0];
    v_[200] = w_in[7] * v_[10] + v_[241] * v_[9];
    v_[205] = v_[134] * v_[31] + v_[200] * v_[28];
    v_[241] = (w_in[7] * v_[38] + v_[241] * v_[18]) * -1 + v_[200] * -0.304;
    v_[113] = w_in[9] + v_[275] * -1;
    v_[173] = v_[241] * v_[53] + v_[63] * v_[52] + v_[113] * v_[67] + v_[205] * v_[68];
    v_[200] = w_in[10] + v_[134] * v_[28] + v_[200] * v_[30];
    v_[134] = v_[113] * v_[54] + v_[205] * v_[53];
    v_[322] = v_[173] + v_[200] * 0.02075 + v_[134] * -0.184;
    v_[204] = v_[200] * v_[86] + v_[134] * v_[77];
    v_[213] = v_[322] * 1.547475 + v_[204] * -0.038686875;
    v_[286] = v_[213] + v_[173] * 2.1032 + v_[134] * -0.057838;
    v_[275] = v_[221] * v_[30] + v_[275] * v_[42];
    v_[221] = v_[241] * v_[62] + v_[63] * v_[53] + v_[113] * v_[60] + v_[205] * v_[61];
    v_[246] = v_[113] * v_[53] + v_[205] * v_[52];
    v_[285] = v_[275] * v_[79] + v_[221] * v_[77] + v_[246] * v_[78];
    v_[160] = w_in[11] + v_[246];
    v_[220] = v_[200] * v_[77] + v_[134] * v_[76];
    v_[301] = v_[285] * 1.547475 + v_[160] * 0.038686875;
    v_[88] = v_[275] * v_[77] + v_[221] * v_[76] + v_[246] * v_[81];
    v_[75] = v_[88] * 1.547475;
    v_[272] = v_[285] * 0.038686875 + v_[160] * 0.009277 + v_[204] * -0.000829 + v_[220] * 1.5e-05 + v_[301] * v_[78] +
              v_[75] * v_[81] + v_[221] * 0.057838 + v_[200] * -0.001243 + v_[246] * 0.029115 + v_[134] * -0.001387;
    v_[125] = v_[88] * 1.547475;
    v_[304] = v_[285] * -1.547475;
    v_[314] = v_[160] * 0.038686875;
    v_[161] = v_[304] - v_[314];
    v_[110] = v_[125] * v_[87] + v_[161] * v_[85];
    v_[3] = v_[221] * 2.1032 + v_[246] * 0.057838;
    v_[262] = 0 - v_[3];
    v_[207] = v_[275] * 2.1032;
    v_[259] = v_[301] * v_[77] + v_[75] * v_[76] + v_[221] * 2.1032 + v_[246] * 0.057838;
    v_[218] = v_[110] + v_[262] * v_[71] + v_[207] * v_[55] + v_[259] * w_in[4];
    v_[288] = 0 - v_[125];
    v_[314] = 0 - v_[304] + v_[314];
    v_[304] = (0 - v_[160]) * 1.5e-05 + v_[204] * 0.000198 + v_[220] * 0.00605;
    v_[122] = v_[322] * 0.038686875 + v_[160] * -0.000829 + (0 - v_[204]) * -0.00146 + (0 - v_[220]) * 0.000198;
    v_[88] = (0 - v_[88]) * 0.038686875;
    v_[308] = v_[204] * 1.5e-05;
    v_[339] = (0 - v_[220]) * -0.000829;
    v_[307] = v_[88] + v_[308] + v_[339];
    v_[104] = v_[322] * 1.547475 + (0 - v_[204]) * 0.038686875;
    v_[258] = v_[288] * v_[91] + v_[104] * v_[85] + v_[75] * w_in[5];
    v_[162] = 0 - v_[104];
    v_[183] = v_[314] * v_[91] + v_[162] * v_[87] - v_[301] * w_in[5];
    v_[145] = 0 - v_[207];
    v_[215] = v_[173] * 0.057838 + (0 - v_[200]) * -0.012652 + v_[246] * -0.001387 + v_[134] * -0.018069;
    v_[302] = v_[200] * 0.009683 + (0 - v_[246]) * -0.001243 + v_[134] * -0.012652;
    v_[129] = (0 - v_[275]) * 0.057838;
    v_[116] = (0 - v_[200]) * -0.001387;
    v_[26] = v_[129] + v_[116] - (0 - v_[134]) * -0.001243;
    v_[322] = v_[322] * -0.038686875 + v_[160] * -0.000829 + v_[204] * 0.003227 + v_[220] * 0.000198;
    v_[291] = v_[160] * 1.5e-05 + v_[204] * 0.000198 + v_[220] * 0.010737;
    v_[213] = v_[213] * -0.184 + v_[322] * v_[77] + v_[291] * v_[76] + v_[173] * -0.057838 + v_[200] * -0.012652 +
              v_[246] * -0.001387 + v_[134] * 0.019432;
    v_[32] = v_[288] * v_[94] + v_[314] * v_[82] + v_[304] * v_[87] + v_[122] * v_[85] + v_[307] * v_[91] +
             v_[307] * v_[91] + v_[258] * v_[78] + v_[183] * v_[81] + v_[3] * v_[64] + v_[145] * v_[80] +
             v_[215] * v_[71] + v_[302] * v_[55] + v_[26] * v_[58] + v_[26] * v_[58] + v_[213] * w_in[4];
    v_[173] = v_[173] * -2.1032 + v_[134] * 0.057838;
    v_[292] = 0 - v_[173];
    v_[269] = v_[258] * v_[77] + v_[183] * v_[76] + v_[292] * v_[71] + v_[145] * v_[58] - v_[286] * w_in[4];
    v_[220] = v_[285] * 0.038686875 + v_[160] * -0.00751 + (0 - v_[204]) * -0.000829 + v_[220] * 1.5e-05;
    v_[160] = (0 - v_[160]) * 0.000198;
    v_[339] = v_[88] + v_[160] - v_[339];
    v_[88] = v_[125] * v_[89] + v_[162] * v_[82] + v_[304] * v_[91] + v_[220] * v_[85] + v_[339] * v_[87] +
             v_[339] * v_[87] + v_[291] * w_in[5];
    v_[160] = 0 - v_[160] - v_[308];
    v_[308] = v_[161] * v_[89] + v_[104] * v_[94] + v_[122] * v_[91] + v_[220] * v_[87] + v_[160] * v_[85] +
              v_[160] * v_[85] - v_[322] * w_in[5];
    v_[285] = v_[221] * 0.057838 + v_[200] * -0.001243 + (0 - v_[246]) * -0.008386 + (0 - v_[134]) * -0.001387;
    v_[116] = v_[129] - v_[116] - v_[246] * -0.012652;
    v_[110] = v_[110] * -0.184 + v_[88] * v_[77] + v_[308] * v_[76] + v_[173] * v_[64] + v_[207] * v_[69] +
              v_[285] * v_[71] + v_[302] * v_[58] + v_[116] * v_[55] + v_[116] * v_[55] - v_[272] * w_in[4];
    v_[129] = 0 - v_[177];
    v_[204] = 0.112 * v_[129];
    v_[123] = -0.112 * v_[318];
    v_[280] = 0.112 * v_[318];
    v_[271] = 0.112 * v_[129];
    v_[330] = -v_[129];
    v_[340] = v_[280] * v_[47] + v_[271] * v_[35] + v_[330] * v_[46] + v_[318] * v_[44];
    v_[250] = -v_[340];
    v_[96] = v_[204] * v_[29] + v_[123] * v_[34] + v_[318] * v_[37] + v_[129] * v_[66] + v_[250] * w_in[4];
    v_[101] = -v_[129];
    v_[199] = v_[129] * v_[35] + v_[318] * v_[47];
    v_[152] = v_[101] * v_[29] + v_[318] * v_[34] + v_[199] * w_in[4];
    v_[306] = v_[199] * v_[71];
    v_[242] = v_[318] * v_[35] + v_[101] * v_[47];
    v_[222] = v_[242] * v_[64] - v_[71] * v_[340];
    v_[226] = -0.184 * v_[152] + v_[96];
    v_[293] = v_[76] * v_[242];
    v_[22] = -v_[293];
    v_[114] = v_[77] * v_[152] + v_[22] * w_in[5];
    v_[115] = v_[293] * v_[91] + v_[85] * v_[199];
    v_[317] = v_[77] * v_[340] + v_[78] * v_[199];
    v_[338] = v_[77] * v_[242];
    v_[154] = v_[76] * v_[340] + v_[81] * v_[199];
    v_[336] = v_[293] * v_[94] + v_[85] * v_[317] - (v_[338] * v_[82] + v_[87] * v_[154]);
    v_[298] = 1.547475 * v_[226] + -0.038686875 * v_[114] + 0.038686875 * v_[115] + 1.547475 * v_[336];
    v_[214] = 2.1032 * v_[96] + -0.057838 * v_[152] + 0.057838 * v_[306] + -2.1032 * v_[222] + v_[298];
    v_[84] = -v_[242];
    v_[216] = v_[318] * v_[29] + v_[129] * v_[34] + v_[84] * w_in[4];
    v_[350] = v_[204] * v_[47] + v_[123] * v_[35] + v_[318] * v_[46] + v_[129] * v_[44];
    v_[290] = v_[280] * v_[29] + v_[271] * v_[34] + v_[330] * v_[37] + v_[318] * v_[66] + v_[350] * w_in[4];
    v_[186] = v_[199] * v_[64] - v_[71] * v_[350];
    v_[208] = -v_[154];
    v_[151] = v_[77] * v_[290] + v_[78] * v_[216] + v_[208] * w_in[5];
    v_[227] = v_[293] * v_[87] + v_[85] * v_[338];
    v_[276] = -0.184 * v_[242] + v_[350];
    v_[335] = v_[293] * v_[89] + v_[85] * v_[276];
    v_[249] = v_[199] * v_[82] + v_[91] * v_[154];
    v_[278] = 1.547475 * v_[151] + 0.038686875 * v_[216] + 0.038686875 * v_[227] + -1.547475 * (v_[335] - v_[249]);
    v_[128] = v_[199] * v_[91] + v_[91] * v_[199];
    v_[244] = v_[338] * v_[87] + v_[87] * v_[338];
    v_[296] = 1.547475 * (v_[338] * v_[89] + v_[87] * v_[276] - (v_[199] * v_[94] + v_[91] * v_[317])) +
              1.547475 * (v_[76] * v_[290] + v_[81] * v_[216] + v_[317] * w_in[5]) - 0.038686875 * (v_[128] + v_[244]);
    v_[305] = v_[76] * v_[152] + v_[338] * w_in[5];
    v_[300] = v_[338] * v_[91] + v_[87] * v_[199];
    v_[27] = v_[293] * v_[85] + v_[85] * v_[293];
    v_[253] = v_[242] * v_[71];
    v_[237] = v_[242] * v_[58] + v_[55] * v_[199];
    v_[249] = 0.029115 * v_[216] + -0.001387 * v_[152] + 0.057838 * v_[290] + 0.057838 * v_[186] + -0.001387 * v_[306] +
              -0.012652 * (0 - (v_[242] * v_[55] + v_[55] * v_[242])) + v_[78] * v_[278] + v_[81] * v_[296] +
              0.009277 * v_[216] + -0.000829 * v_[114] + 1.5e-05 * v_[305] + 0.038686875 * v_[151] +
              -0.00751 * v_[227] + 0.038686875 * (v_[249] - v_[335]) + -0.000829 * v_[115] - 1.5e-05 * v_[300] -
              0.000198 * (v_[244] - v_[27]) - -0.008386 * v_[253] - -0.001243 * v_[237];
    v_[335] = v_[241] * v_[318] + v_[63] * v_[129] + v_[113] * v_[204] + v_[205] * v_[123];
    v_[151] = v_[113] * v_[101] + v_[205] * v_[318];
    v_[347] = v_[335] + v_[151] * -0.184;
    v_[257] = v_[151] * v_[77];
    v_[194] = v_[347] * 1.547475 + v_[257] * -0.038686875;
    v_[126] = v_[194] + v_[335] * 2.1032 + v_[151] * -0.057838;
    v_[158] = v_[241] * v_[330] + v_[63] * v_[318] + v_[113] * v_[280] + v_[205] * v_[271];
    v_[229] = v_[113] * v_[318] + v_[205] * v_[129];
    v_[309] = v_[158] * v_[77] + v_[229] * v_[78];
    v_[107] = v_[151] * v_[76];
    v_[112] = v_[309] * 1.547475 + v_[229] * 0.038686875;
    v_[108] = v_[158] * v_[76] + v_[229] * v_[81];
    v_[100] = v_[108] * 1.547475;
    v_[41] = v_[309] * 0.038686875 + v_[229] * 0.009277 + v_[257] * -0.000829 + v_[107] * 1.5e-05 + v_[112] * v_[78] +
             v_[100] * v_[81] + v_[158] * 0.057838 + v_[229] * 0.029115 + v_[151] * -0.001387;
    v_[23] = v_[108] * 1.547475;
    v_[16] = v_[309] * -1.547475;
    v_[14] = v_[229] * 0.038686875;
    v_[12] = v_[16] - v_[14];
    v_[7] = v_[125] * v_[338] + v_[23] * v_[87] + v_[161] * v_[293] + v_[12] * v_[85];
    v_[6] = v_[158] * 2.1032 + v_[229] * 0.057838;
    v_[188] = 0 - v_[6];
    v_[337] = v_[112] * v_[77] + v_[100] * v_[76] + v_[158] * 2.1032 + v_[229] * 0.057838;
    v_[281] = v_[7] + v_[188] * v_[71] + v_[207] * v_[242] + v_[337] * w_in[4];
    v_[334] = 0 - v_[23];
    v_[14] = 0 - v_[16] + v_[14];
    v_[16] = (0 - v_[229]) * 1.5e-05 + v_[257] * 0.000198 + v_[107] * 0.00605;
    v_[295] = v_[347] * 0.038686875 + v_[229] * -0.000829 + (0 - v_[257]) * -0.00146 + (0 - v_[107]) * 0.000198;
    v_[108] = (0 - v_[108]) * 0.038686875;
    v_[51] = v_[257] * 1.5e-05;
    v_[217] = (0 - v_[107]) * -0.000829;
    v_[117] = v_[108] + v_[51] + v_[217];
    v_[117] = v_[288] * v_[317] + v_[334] * v_[94] + v_[314] * v_[154] + v_[14] * v_[82] + v_[304] * v_[338] +
              v_[16] * v_[87] + v_[122] * v_[293] + v_[295] * v_[85] + v_[307] * v_[199] + v_[307] * v_[199] +
              v_[117] * v_[91] + v_[117] * v_[91];
    v_[307] = v_[347] * 1.547475 + (0 - v_[257]) * 0.038686875;
    v_[334] = v_[288] * v_[199] + v_[334] * v_[91] + v_[104] * v_[293] + v_[307] * v_[85] + v_[100] * w_in[5];
    v_[288] = 0 - v_[307];
    v_[14] = v_[314] * v_[199] + v_[14] * v_[91] + v_[162] * v_[338] + v_[288] * v_[87] - v_[112] * w_in[5];
    v_[314] = v_[335] * 0.057838 + v_[229] * -0.001387 + v_[151] * -0.018069;
    v_[50] = (0 - v_[229]) * -0.001243 + v_[151] * -0.012652;
    v_[127] = (0 - v_[151]) * -0.001243;
    v_[105] = 0 - v_[127];
    v_[347] = v_[347] * -0.038686875 + v_[229] * -0.000829 + v_[257] * 0.003227 + v_[107] * 0.000198;
    v_[231] = v_[229] * 1.5e-05 + v_[257] * 0.000198 + v_[107] * 0.010737;
    hes[59] = v_[301] * v_[208] + v_[112] * v_[83] + v_[75] * v_[317] + v_[100] * v_[94] + v_[322] * v_[22] +
              v_[347] * v_[98] + v_[291] * v_[338] + v_[231] * v_[87] + v_[117];
    v_[208] = v_[194] * -0.184 + v_[347] * v_[77] + v_[231] * v_[76] + v_[335] * -0.057838 + v_[229] * -0.001387 +
              v_[151] * 0.019432;
    v_[105] = v_[117] + v_[334] * v_[78] + v_[14] * v_[81] + v_[6] * v_[64] + v_[145] * v_[340] + v_[314] * v_[71] +
              v_[302] * v_[242] + v_[50] * v_[55] + v_[26] * v_[199] + v_[26] * v_[199] + v_[105] * v_[58] +
              v_[105] * v_[58] + v_[208] * w_in[4];
    v_[186] = 2.1032 * v_[290] + 0.057838 * v_[216] + 0.057838 * v_[253] + 2.1032 * v_[186] + v_[77] * v_[278] +
              v_[76] * v_[296];
    v_[335] = v_[335] * -2.1032 + v_[151] * 0.057838;
    v_[117] = 0 - v_[335];
    v_[145] = v_[334] * v_[77] + v_[14] * v_[76] + v_[117] * v_[71] + v_[145] * v_[199] - v_[126] * w_in[4];
    v_[27] = -0.000829 * v_[216] + 0.003227 * v_[114] + 0.000198 * v_[305] + -0.038686875 * v_[226] +
             0.000198 * v_[300] + 1.5e-05 * (v_[128] - v_[27]) - 0.038686875 * v_[336] - -0.00146 * v_[115] -
             -0.000829 * v_[227];
    v_[300] = 1.5e-05 * v_[216] + 0.000198 * v_[114] + 0.010737 * v_[305] + 0.00605 * v_[300] + 1.5e-05 * v_[227] -
              0.000198 * v_[115] - -0.000829 * (v_[128] - v_[244]);
    v_[237] = -0.001387 * v_[216] + 0.019432 * v_[152] + -0.057838 * v_[96] + -0.018069 * v_[306] + 0.057838 * v_[222] +
              -0.012652 * v_[237] + v_[77] * v_[27] + v_[76] * v_[300] + -0.184 * v_[298] - -0.001387 * v_[253] -
              -0.001243 * (0 - (v_[199] * v_[58] + v_[58] * v_[199]));
    v_[107] = v_[309] * 0.038686875 + v_[229] * -0.00751 + (0 - v_[257]) * -0.000829 + v_[107] * 1.5e-05;
    v_[309] = (0 - v_[229]) * 0.000198;
    v_[217] = v_[108] + v_[309] - v_[217];
    v_[217] = v_[125] * v_[276] + v_[23] * v_[89] + v_[162] * v_[154] + v_[288] * v_[82] + v_[304] * v_[199] +
              v_[16] * v_[91] + v_[220] * v_[293] + v_[107] * v_[85] + v_[339] * v_[338] + v_[339] * v_[338] +
              v_[217] * v_[87] + v_[217] * v_[87] + v_[231] * w_in[5];
    v_[309] = 0 - v_[309] - v_[51];
    v_[309] = v_[161] * v_[276] + v_[12] * v_[89] + v_[104] * v_[317] + v_[307] * v_[94] + v_[122] * v_[199] +
              v_[295] * v_[91] + v_[220] * v_[338] + v_[107] * v_[87] + v_[160] * v_[293] + v_[160] * v_[293] +
              v_[309] * v_[85] + v_[309] * v_[85] - v_[347] * w_in[5];
    v_[107] = v_[158] * 0.057838 + (0 - v_[229]) * -0.008386 + (0 - v_[151]) * -0.001387;
    v_[307] = v_[229] * -0.012652;
    v_[295] = 0 - v_[307];
    v_[295] = v_[7] * -0.184 + v_[217] * v_[77] + v_[309] * v_[76] + v_[335] * v_[64] + v_[207] * v_[350] +
              v_[107] * v_[71] + v_[302] * v_[199] + v_[50] * v_[58] + v_[116] * v_[242] + v_[116] * v_[242] +
              v_[295] * v_[55] + v_[295] * v_[55] - v_[41] * w_in[4];
    hes[52] =
        (0 - (v_[63] * v_[106] + v_[205] * v_[92] + v_[286] * v_[66] + v_[272] * v_[34] + v_[218] * v_[44] +
                 v_[32] * v_[35] + (v_[113] * v_[106] + v_[286] * v_[29] + v_[218] * v_[47]) * 0.112 -
                 (v_[241] * v_[72] + v_[259] * v_[37] + v_[269] * v_[46]) +
                 (v_[205] * v_[72] + v_[259] * v_[34] + v_[269] * v_[35]) * 0.112 -
                 (v_[113] * v_[74] + v_[213] * v_[29] + v_[110] * v_[47]))) *
            v_[52] -
        (v_[63] * v_[214] + v_[205] * v_[249] + v_[126] * v_[66] + v_[41] * v_[34] + v_[281] * v_[44] +
            v_[105] * v_[35] + (v_[113] * v_[214] + v_[126] * v_[29] + v_[281] * v_[47]) * 0.112 -
            (v_[241] * v_[186] + v_[337] * v_[37] + v_[145] * v_[46]) +
            (v_[205] * v_[186] + v_[337] * v_[34] + v_[145] * v_[35]) * 0.112 -
            (v_[113] * v_[237] + v_[208] * v_[29] + v_[295] * v_[47])) *
            v_[177] +
        (v_[241] * v_[214] + v_[63] * v_[186] + v_[113] * v_[249] + v_[205] * v_[237] + v_[126] * v_[37] +
            v_[337] * v_[66] + v_[41] * v_[29] + v_[208] * v_[34] + v_[281] * v_[46] + v_[145] * v_[44] +
            v_[105] * v_[47] + v_[295] * v_[35] + (v_[205] * v_[214] + v_[126] * v_[34] + v_[281] * v_[35]) * -0.112 +
            (v_[113] * v_[186] + v_[337] * v_[29] + v_[145] * v_[47]) * 0.112) *
            v_[318] -
        (v_[241] * v_[106] + v_[63] * v_[72] + v_[113] * v_[92] + v_[205] * v_[74] + v_[286] * v_[37] +
            v_[259] * v_[66] + v_[272] * v_[29] + v_[213] * v_[34] + v_[218] * v_[46] + v_[269] * v_[44] +
            v_[32] * v_[47] + v_[110] * v_[35] + (v_[205] * v_[106] + v_[286] * v_[34] + v_[218] * v_[35]) * -0.112 +
            (v_[113] * v_[72] + v_[259] * v_[29] + v_[269] * v_[47]) * 0.112) *
            v_[53];
    v_[237] = v_[246] * v_[278] + v_[229] * v_[93] + v_[301] * v_[216] + v_[112] * v_[57] + v_[258] * v_[199] +
              v_[334] * v_[58];
    v_[216] = v_[246] * v_[296] + v_[229] * v_[97] + v_[75] * v_[216] + v_[100] * v_[57] + v_[183] * v_[199] +
              v_[14] * v_[58];
    hes[53] = 0 -
              (v_[275] * v_[296] + v_[221] * v_[278] + v_[158] * v_[93] + v_[200] * v_[300] + v_[134] * v_[27] +
                  v_[151] * v_[103] + v_[301] * v_[290] + v_[112] * v_[70] + v_[100] * v_[45] + v_[322] * v_[152] +
                  v_[347] * v_[59] + v_[231] * v_[36] + v_[258] * v_[340] + v_[334] * v_[80] + v_[14] * v_[64] +
                  v_[88] * v_[242] + v_[217] * v_[55] + v_[309] * v_[71] + v_[237] * 0.184 + (0 - v_[216]) * 0.02075) *
                  v_[248] +
              (v_[221] * v_[296] + v_[158] * v_[97] + v_[134] * v_[300] + v_[151] * v_[102] + v_[75] * v_[290] +
                  v_[100] * v_[70] + v_[291] * v_[152] + v_[231] * v_[59] + v_[183] * v_[340] + v_[14] * v_[80] +
                  v_[308] * v_[242] + v_[309] * v_[55] - (v_[275] * v_[278] + v_[112] * v_[45] + v_[334] * v_[64]) +
                  v_[237] * 0.02075 + v_[216] * 0.184 - (v_[200] * v_[27] + v_[347] * v_[36] + v_[217] * v_[71])) *
                  v_[247];
    v_[100] = v_[112] * v_[79] + v_[100] * v_[77];
    v_[112] = v_[218] * v_[129] + v_[281] * v_[52] + v_[269] * v_[318] + v_[145] * v_[53] + v_[100] * w_in[3];
    v_[216] = v_[286] * v_[129] + v_[126] * v_[52] + v_[259] * v_[318] + v_[337] * v_[53];
    v_[335] = v_[334] * v_[79] + v_[14] * v_[77] + v_[3] * v_[199] + v_[6] * v_[58] + v_[173] * v_[242] +
              v_[335] * v_[55] - v_[216] * w_in[3];
    v_[14] = v_[286] * v_[318] + v_[126] * v_[53] + v_[259] * v_[330] + v_[337] * v_[62];
    v_[334] = v_[14] * -1;
    v_[6] = v_[112] * v_[28] + v_[335] * v_[30] + v_[334] * w_in[2];
    v_[330] = v_[218] * v_[318] + v_[281] * v_[53] + v_[269] * v_[330] + v_[145] * v_[62];
    v_[173] = v_[216] * v_[28] + v_[100] * v_[30];
    v_[3] = v_[330] * -1 - v_[173] * w_in[2];
    v_[231] = v_[194] * 0.02075 + v_[347] * v_[86] + v_[231] * v_[77] + v_[229] * -0.001243 + v_[151] * -0.012652;
    v_[347] = v_[218] * v_[123] + v_[281] * v_[68] + v_[269] * v_[271] + v_[145] * v_[61] + v_[32] * v_[129] +
              v_[105] * v_[52] + v_[110] * v_[318] + v_[295] * v_[53] + v_[231] * w_in[3];
    v_[307] = v_[307] + v_[127];
    v_[307] = v_[7] * 0.02075 + v_[217] * v_[86] + v_[309] * v_[77] + v_[262] * v_[350] + v_[188] * v_[69] +
              v_[292] * v_[340] + v_[117] * v_[80] + v_[215] * v_[199] + v_[314] * v_[58] + v_[285] * v_[242] +
              v_[107] * v_[55] + v_[307] * v_[71] + v_[307] * v_[71];
    hes[58] = v_[286] * v_[250] + v_[126] * v_[90] + v_[259] * v_[350] + v_[337] * v_[69] + v_[272] * v_[84] +
              v_[41] * v_[56] + v_[213] * v_[199] + v_[208] * v_[58] + v_[307];
    v_[271] = v_[286] * v_[123] + v_[126] * v_[68] + v_[259] * v_[271] + v_[337] * v_[61] + v_[272] * v_[129] +
              v_[41] * v_[52] + v_[213] * v_[318] + v_[208] * v_[53];
    v_[307] = v_[307] - v_[271] * w_in[3];
    v_[208] = v_[216] * v_[43] + v_[100] * v_[42] +
              (v_[286] * v_[204] + v_[126] * v_[67] + v_[259] * v_[280] + v_[337] * v_[60] + v_[272] * v_[318] +
                  v_[41] * v_[53] + v_[213] * v_[101] + v_[208] * v_[54]) *
                  -1;
    v_[330] = v_[330] * -0.304 + v_[347] * v_[28] + v_[307] * v_[30] + v_[208] * w_in[2];
    v_[295] = v_[218] * v_[204] + v_[281] * v_[67] + v_[269] * v_[280] + v_[145] * v_[60] + v_[32] * v_[318] +
              v_[105] * v_[53] + v_[110] * v_[101] + v_[295] * v_[54];
    hes[57] = v_[216] * v_[65] + v_[100] * v_[44] + v_[271] * v_[33] + v_[231] * v_[35] + v_[295];
    v_[14] = v_[14] * -0.304 + v_[271] * v_[28] + v_[231] * v_[30];
    v_[295] = v_[112] * v_[43] + v_[335] * v_[42] + v_[295] * -1 - v_[14] * w_in[2];
    v_[271] = v_[271] * v_[31] + v_[231] * v_[28];
    v_[307] = v_[347] * v_[31] + v_[307] * v_[28];
    hes[56] = v_[173] * v_[40] + v_[334] * v_[21] + v_[14] * v_[13] + v_[208] * v_[15] + v_[307];
    v_[14] = v_[173] * v_[19] + v_[334] * v_[18] + v_[14] * v_[9] + v_[208] * v_[10];
    hes[54] = (v_[6] * v_[19] + v_[3] * v_[18] + v_[330] * v_[9] + v_[295] * v_[10] + v_[271] * w_in[1]) * v_[4] +
              (v_[307] - v_[14] * w_in[1]) * v_[0];
    hes[55] = v_[6] * v_[20] + v_[3] * v_[38] + v_[330] * v_[10] + v_[295] * v_[11] + v_[14] * v_[2] + v_[271] * v_[5];
    v_[14] = w_in[6] * v_[4];
    v_[271] = w_in[7] * v_[20] + v_[14] * v_[19];
    v_[295] = w_in[7] * v_[11] + v_[14] * v_[10];
    v_[330] = v_[271] * v_[30] + v_[295] * v_[42];
    v_[3] = w_in[7] * v_[10] + v_[14] * v_[9];
    v_[14] = (w_in[7] * v_[38] + v_[14] * v_[18]) * -1 + v_[3] * -0.304;
    v_[271] = v_[271] * v_[28] + v_[295] * v_[43];
    v_[295] = w_in[9] + v_[295] * -1;
    v_[6] = w_in[8] + w_in[6] * v_[0];
    v_[307] = v_[6] * v_[31] + v_[3] * v_[28];
    v_[208] = v_[14] * v_[62] + v_[271] * v_[53] + v_[295] * v_[60] + v_[307] * v_[61];
    v_[6] = w_in[10] + v_[6] * v_[28] + v_[3] * v_[30];
    v_[3] = v_[295] * v_[54] + v_[307] * v_[53];
    v_[173] = v_[295] * v_[53] + v_[307] * v_[52];
    v_[334] = v_[330] * v_[79] + v_[208] * v_[77] + v_[173] * v_[78];
    v_[347] = w_in[11] + v_[173];
    v_[231] = v_[334] * 1.547475 + v_[347] * 0.038686875;
    v_[335] = v_[330] * v_[77] + v_[208] * v_[76] + v_[173] * v_[81];
    v_[112] = v_[335] * 1.547475;
    v_[307] =
        v_[14] * v_[53] + v_[271] * v_[52] + v_[295] * v_[67] + v_[307] * v_[68] + v_[6] * 0.02075 + v_[3] * -0.184;
    v_[295] = v_[6] * v_[86] + v_[3] * v_[77];
    v_[271] = v_[6] * v_[77] + v_[3] * v_[76];
    v_[14] = v_[307] * -0.038686875 + v_[347] * -0.000829 + v_[295] * 0.003227 + v_[271] * 0.000198;
    v_[216] = v_[347] * 1.5e-05 + v_[295] * 0.000198 + v_[271] * 0.010737;
    v_[100] = v_[335] * 1.547475;
    v_[145] = 0 - v_[100];
    v_[105] = v_[307] * 1.547475 + (0 - v_[295]) * 0.038686875;
    v_[281] = v_[145] * v_[91] + v_[105] * v_[85] + v_[112] * w_in[5];
    v_[101] = v_[334] * -1.547475;
    v_[280] = v_[347] * 0.038686875;
    v_[204] = 0 - v_[101] + v_[280];
    v_[110] = 0 - v_[105];
    v_[269] = v_[204] * v_[91] + v_[110] * v_[87] - v_[231] * w_in[5];
    v_[32] = (0 - v_[347]) * 1.5e-05 + v_[295] * 0.000198 + v_[271] * 0.00605;
    v_[334] = v_[334] * 0.038686875 + v_[347] * -0.00751 + (0 - v_[295]) * -0.000829 + v_[271] * 1.5e-05;
    v_[218] = (0 - v_[347]) * 0.000198;
    v_[335] = (0 - v_[335]) * 0.038686875 + v_[218] - (0 - v_[271]) * -0.000829;
    v_[318] = v_[100] * v_[89] + v_[110] * v_[82] + v_[32] * v_[91] + v_[334] * v_[85] + v_[335] * v_[87] +
              v_[335] * v_[87] + v_[216] * w_in[5];
    v_[280] = v_[101] - v_[280];
    v_[271] = v_[307] * 0.038686875 + v_[347] * -0.000829 + (0 - v_[295]) * -0.00146 + (0 - v_[271]) * 0.000198;
    v_[218] = 0 - v_[218] - v_[295] * 1.5e-05;
    v_[295] = v_[280] * v_[89] + v_[105] * v_[94] + v_[271] * v_[91] + v_[334] * v_[87] + v_[218] * v_[85] +
              v_[218] * v_[85] - v_[14] * w_in[5];
    v_[307] = v_[173] * v_[93] + v_[231] * v_[57] + v_[281] * v_[58];
    v_[347] = v_[173] * v_[97] + v_[112] * v_[57] + v_[269] * v_[58];
    v_[101] = 0 - v_[248];
    v_[337] = -v_[247];
    v_[41] = v_[101] * v_[55] + v_[337] * v_[71];
    v_[126] = -v_[247];
    v_[213] = 0.02075 * v_[247] + 0.184 * v_[101];
    v_[259] = v_[126] * v_[64] + v_[101] * v_[80] + v_[213] * v_[58];
    v_[272] = 0.184 * v_[247] - 0.02075 * v_[101];
    v_[286] = v_[41] * v_[87] + v_[87] * v_[41];
    v_[123] = 1.547475 * (v_[41] * v_[89] - v_[91] * v_[259]) +
              1.547475 * (v_[101] * v_[45] + v_[247] * v_[70] + v_[272] * v_[57] + v_[259] * w_in[5]) -
              0.038686875 * v_[286];
    v_[129] = v_[101] * v_[64] + v_[247] * v_[80] + v_[272] * v_[58];
    v_[350] = -v_[129];
    v_[84] = v_[247] * v_[55] + v_[101] * v_[71];
    v_[199] = v_[84] * v_[87] + v_[85] * v_[41];
    v_[250] = 1.547475 * (v_[126] * v_[45] + v_[101] * v_[70] + v_[213] * v_[57] + v_[350] * w_in[5]) +
              0.038686875 * v_[199] + -1.547475 * (v_[84] * v_[89] - v_[91] * v_[129]);
    v_[107] = -v_[84];
    v_[309] = v_[337] * v_[36] + v_[101] * v_[59] + v_[107] * w_in[5];
    v_[217] = v_[101] * v_[36] + v_[247] * v_[59] + v_[41] * w_in[5];
    v_[117] = v_[41] * v_[91];
    v_[314] = v_[84] * v_[91];
    v_[286] = 0.000198 * v_[309] + 0.010737 * v_[217] + 0.00605 * v_[117] + 1.5e-05 * v_[199] - 0.000198 * v_[314] -
              -0.000829 * (0 - v_[286]);
    v_[314] = 0.003227 * v_[309] + 0.000198 * v_[217] + 0.000198 * v_[117] +
              1.5e-05 * (0 - (v_[84] * v_[85] + v_[85] * v_[84])) -
              0.038686875 * (v_[84] * v_[94] + v_[85] * v_[259] - (v_[41] * v_[82] + v_[87] * v_[129])) -
              -0.00146 * v_[314] - -0.000829 * v_[199];
    v_[117] = v_[330] * v_[126] + v_[208] * v_[101] + v_[173] * v_[213];
    v_[217] = v_[117] * 1.547475;
    v_[309] = v_[330] * v_[101] + v_[208] * v_[247] + v_[173] * v_[272];
    v_[199] = v_[309] * 1.547475;
    v_[188] = v_[6] * v_[337] + v_[3] * v_[101];
    v_[7] = v_[6] * v_[101] + v_[3] * v_[247];
    v_[242] = v_[188] * 0.003227 + v_[7] * 0.000198;
    v_[340] = v_[188] * 0.000198 + v_[7] * 0.010737;
    v_[285] = v_[309] * 1.547475;
    v_[292] = 0 - v_[285];
    v_[215] = (0 - v_[188]) * 0.038686875;
    v_[262] = v_[292] * v_[91] + v_[105] * v_[84] + v_[215] * v_[85] + v_[199] * w_in[5];
    v_[127] = v_[117] * -1.547475;
    v_[229] = 0 - v_[127];
    v_[194] = 0 - v_[215];
    v_[151] = v_[229] * v_[91] + v_[110] * v_[41] + v_[194] * v_[87] - v_[217] * w_in[5];
    v_[237] = v_[188] * 0.000198 + v_[7] * 0.00605;
    v_[300] = v_[117] * 0.038686875 + (0 - v_[188]) * -0.000829 + v_[7] * 1.5e-05;
    v_[309] = (0 - v_[309]) * 0.038686875;
    v_[27] = (0 - v_[7]) * -0.000829;
    v_[158] = v_[309] - v_[27];
    v_[158] = v_[285] * v_[89] + v_[110] * v_[129] + v_[194] * v_[82] + v_[237] * v_[91] + v_[334] * v_[84] +
              v_[300] * v_[85] + v_[335] * v_[41] + v_[335] * v_[41] + v_[158] * v_[87] + v_[158] * v_[87] +
              v_[340] * w_in[5];
    v_[194] = (0 - v_[188]) * -0.00146 + (0 - v_[7]) * 0.000198;
    v_[335] = v_[188] * 1.5e-05;
    v_[110] = 0 - v_[335];
    v_[110] = v_[127] * v_[89] + v_[105] * v_[259] + v_[215] * v_[94] + v_[194] * v_[91] + v_[334] * v_[41] +
              v_[300] * v_[87] + v_[218] * v_[84] + v_[218] * v_[84] + v_[110] * v_[85] + v_[110] * v_[85] -
              v_[242] * w_in[5];
    v_[300] = v_[173] * v_[250] + v_[217] * v_[57] + v_[262] * v_[58];
    v_[173] = v_[173] * v_[123] + v_[199] * v_[57] + v_[151] * v_[58];
    hes[65] = (0 - (v_[330] * v_[97] + v_[208] * v_[93] + v_[6] * v_[102] + v_[3] * v_[103] + v_[231] * v_[70] +
                       v_[112] * v_[45] + v_[14] * v_[59] + v_[216] * v_[36] + v_[281] * v_[80] + v_[269] * v_[64] +
                       v_[318] * v_[55] + v_[295] * v_[71] + v_[307] * 0.184 + (0 - v_[347]) * 0.02075)) *
                  v_[77] -
              (v_[330] * v_[123] + v_[208] * v_[250] + v_[6] * v_[286] + v_[3] * v_[314] + v_[217] * v_[70] +
                  v_[199] * v_[45] + v_[242] * v_[59] + v_[340] * v_[36] + v_[262] * v_[80] + v_[151] * v_[64] +
                  v_[158] * v_[55] + v_[110] * v_[71] + v_[300] * 0.184 + (0 - v_[173]) * 0.02075) *
                  v_[248] +
              (v_[208] * v_[123] + v_[3] * v_[286] + v_[199] * v_[70] + v_[340] * v_[59] + v_[151] * v_[80] +
                  v_[110] * v_[55] - (v_[330] * v_[250] + v_[217] * v_[45] + v_[262] * v_[64]) + v_[300] * 0.02075 +
                  v_[173] * 0.184 - (v_[6] * v_[314] + v_[242] * v_[36] + v_[158] * v_[71])) *
                  v_[247] -
              (v_[208] * v_[97] + v_[3] * v_[102] + v_[112] * v_[70] + v_[216] * v_[59] + v_[269] * v_[80] +
                  v_[295] * v_[55] - (v_[330] * v_[93] + v_[231] * v_[45] + v_[281] * v_[64]) + v_[307] * 0.02075 +
                  v_[347] * 0.184 - (v_[6] * v_[103] + v_[14] * v_[36] + v_[318] * v_[71])) *
                  v_[76];
    v_[127] = v_[100] * v_[41] + v_[285] * v_[87] + v_[280] * v_[84] + v_[127] * v_[85];
    v_[285] = v_[231] * v_[101] + v_[217] * v_[77] + v_[112] * v_[247] + v_[199] * v_[76];
    v_[280] = v_[127] + v_[285] * w_in[4];
    v_[100] = v_[188] * -0.038686875;
    v_[173] = v_[281] * v_[101] + v_[262] * v_[77] + v_[269] * v_[247] + v_[151] * v_[76] - v_[100] * w_in[4];
    v_[300] = v_[231] * v_[126] + v_[217] * v_[79] + v_[112] * v_[101] + v_[199] * v_[77];
    v_[314] = v_[280] * v_[52] + v_[173] * v_[53] + v_[300] * w_in[3];
    v_[286] = v_[100] * v_[52] + v_[285] * v_[53];
    v_[126] = v_[281] * v_[126] + v_[262] * v_[79] + v_[269] * v_[101] + v_[151] * v_[77] - v_[286] * w_in[3];
    v_[250] = v_[100] * v_[53] + v_[285] * v_[62];
    v_[123] = v_[250] * -1;
    v_[347] = v_[314] * v_[28] + v_[126] * v_[30] + v_[123] * w_in[2];
    v_[307] = v_[280] * v_[53] + v_[173] * v_[62];
    v_[3] = v_[286] * v_[28] + v_[300] * v_[30];
    v_[6] = v_[307] * -1 - v_[3] * w_in[2];
    v_[335] = v_[309] + v_[335] + v_[27];
    v_[335] = v_[145] * v_[259] + v_[292] * v_[94] + v_[204] * v_[129] + v_[229] * v_[82] + v_[32] * v_[41] +
              v_[237] * v_[87] + v_[271] * v_[84] + v_[194] * v_[85] + v_[335] * v_[91] + v_[335] * v_[91];
    hes[71] = v_[231] * v_[350] + v_[217] * v_[83] + v_[112] * v_[259] + v_[199] * v_[94] + v_[14] * v_[107] +
              v_[242] * v_[98] + v_[216] * v_[41] + v_[340] * v_[87] + v_[335];
    v_[107] = v_[100] * -0.184 + v_[14] * v_[101] + v_[242] * v_[77] + v_[216] * v_[247] + v_[340] * v_[76];
    v_[335] = v_[335] + v_[281] * v_[213] + v_[262] * v_[78] + v_[269] * v_[272] + v_[151] * v_[81] + v_[107] * w_in[4];
    v_[7] = v_[117] * 0.038686875 + v_[188] * -0.000829 + v_[7] * 1.5e-05 + v_[231] * v_[213] + v_[217] * v_[78] +
            v_[112] * v_[272] + v_[199] * v_[81];
    v_[247] = v_[127] * -0.184 + v_[318] * v_[101] + v_[158] * v_[77] + v_[295] * v_[247] + v_[110] * v_[76] -
              v_[7] * w_in[4];
    v_[340] = v_[100] * 0.02075 + v_[14] * v_[337] + v_[242] * v_[86] + v_[216] * v_[101] + v_[340] * v_[77];
    v_[242] = v_[280] * v_[68] + v_[173] * v_[61] + v_[335] * v_[52] + v_[247] * v_[53] + v_[340] * w_in[3];
    v_[127] = v_[127] * 0.02075 + v_[318] * v_[337] + v_[158] * v_[86] + v_[295] * v_[101] + v_[110] * v_[77];
    hes[70] = v_[100] * v_[90] + v_[285] * v_[69] + v_[7] * v_[56] + v_[107] * v_[58] + v_[127];
    v_[90] = v_[100] * v_[68] + v_[285] * v_[61] + v_[7] * v_[52] + v_[107] * v_[53];
    v_[127] = v_[127] - v_[90] * w_in[3];
    v_[7] = v_[286] * v_[43] + v_[300] * v_[42] +
            (v_[100] * v_[67] + v_[285] * v_[60] + v_[7] * v_[53] + v_[107] * v_[54]) * -1;
    v_[307] = v_[307] * -0.304 + v_[242] * v_[28] + v_[127] * v_[30] + v_[7] * w_in[2];
    v_[247] = v_[280] * v_[67] + v_[173] * v_[60] + v_[335] * v_[53] + v_[247] * v_[54];
    hes[69] = v_[286] * v_[65] + v_[300] * v_[44] + v_[90] * v_[33] + v_[340] * v_[35] + v_[247];
    v_[250] = v_[250] * -0.304 + v_[90] * v_[28] + v_[340] * v_[30];
    v_[247] = v_[314] * v_[43] + v_[126] * v_[42] + v_[247] * -1 - v_[250] * w_in[2];
    v_[90] = v_[90] * v_[31] + v_[340] * v_[28];
    v_[127] = v_[242] * v_[31] + v_[127] * v_[28];
    hes[68] = v_[3] * v_[40] + v_[123] * v_[21] + v_[250] * v_[13] + v_[7] * v_[15] + v_[127];
    v_[250] = v_[3] * v_[19] + v_[123] * v_[18] + v_[250] * v_[9] + v_[7] * v_[10];
    hes[66] = (v_[347] * v_[19] + v_[6] * v_[18] + v_[307] * v_[9] + v_[247] * v_[10] + v_[90] * w_in[1]) * v_[4] +
              (v_[127] - v_[250] * w_in[1]) * v_[0];
    hes[67] =
        v_[347] * v_[20] + v_[6] * v_[38] + v_[307] * v_[10] + v_[247] * v_[11] + v_[250] * v_[2] + v_[90] * v_[5];
    v_[250] = w_in[6] * v_[4];
    v_[90] = w_in[7] * v_[20] + v_[250] * v_[19];
    v_[247] = w_in[7] * v_[11] + v_[250] * v_[10];
    v_[307] = v_[90] * v_[30] + v_[247] * v_[42];
    v_[6] = w_in[7] * v_[38] + v_[250] * v_[18];
    v_[347] = w_in[7] * v_[10] + v_[250] * v_[9];
    v_[5] = v_[6] * -1 + v_[347] * -0.304;
    v_[2] = v_[90] * v_[28] + v_[247] * v_[43];
    v_[127] = w_in[9] + v_[247] * -1;
    v_[7] = w_in[6] * v_[0];
    v_[3] = w_in[8] + v_[7];
    v_[123] = v_[3] * v_[31] + v_[347] * v_[28];
    v_[40] = v_[5] * v_[62] + v_[2] * v_[53] + v_[127] * v_[60] + v_[123] * v_[61];
    v_[21] = v_[127] * v_[53] + v_[123] * v_[52];
    v_[15] = v_[307] * v_[77] + v_[40] * v_[76] + v_[21] * v_[81];
    v_[13] = v_[15] * 1.547475;
    v_[242] = v_[9] * v_[4];
    v_[340] = v_[28] * v_[242] + v_[31] * v_[0];
    v_[126] = v_[10] * v_[4];
    v_[314] = -1 * v_[126];
    v_[286] = v_[53] * v_[340] + v_[54] * v_[314];
    v_[300] = v_[30] * v_[242] + v_[28] * v_[0];
    v_[65] = v_[77] * v_[286] + v_[86] * v_[300];
    v_[44] = v_[307] * v_[79] + v_[40] * v_[77] + v_[21] * v_[78];
    v_[35] = v_[44] * -1.547475;
    v_[33] = w_in[11] + v_[21];
    v_[335] = v_[33] * 0.038686875;
    v_[173] = v_[35] - v_[335];
    v_[280] = v_[76] * v_[286] + v_[77] * v_[300];
    v_[107] = v_[13] * v_[65] + v_[173] * v_[280];
    v_[100] = v_[40] * 2.1032 + v_[21] * 0.057838;
    v_[285] = 0 - v_[100];
    v_[69] = v_[307] * 2.1032;
    v_[58] = v_[107] + v_[285] * v_[300] + v_[69] * v_[286];
    v_[56] = 0 - v_[13];
    v_[110] = v_[52] * v_[340] + v_[53] * v_[314];
    v_[158] = v_[5] * v_[53] + v_[2] * v_[52] + v_[127] * v_[67] + v_[123] * v_[68];
    v_[337] = v_[3] * v_[28] + v_[347] * v_[30];
    v_[101] = w_in[10] + v_[337];
    v_[295] = v_[127] * v_[54] + v_[123] * v_[53];
    v_[318] = v_[158] + v_[101] * 0.02075 + v_[295] * -0.184;
    v_[216] = v_[101] * v_[86] + v_[295] * v_[77];
    v_[14] = v_[318] * 1.547475 + (0 - v_[216]) * 0.038686875;
    v_[188] = v_[56] * v_[110] + v_[14] * v_[280];
    v_[335] = 0 - v_[35] + v_[335];
    v_[35] = 0 - v_[14];
    v_[199] = v_[335] * v_[110] + v_[35] * v_[65];
    v_[217] = v_[158] * -2.1032 + v_[295] * 0.057838;
    v_[117] = 0 - v_[217];
    v_[272] = 0 - v_[69];
    v_[213] = v_[188] * v_[77] + v_[199] * v_[76] + v_[117] * v_[300] + v_[272] * v_[110];
    v_[112] = v_[307] * 1.7423722 + (0 - v_[127]) * -0.008711861 + v_[123] * 1.52322944854339e-09;
    v_[231] = 0 - v_[112];
    v_[151] = v_[5] * 1.7423722 + (0 - v_[123]) * 0.160298259823722 + v_[337] * -0.008711861;
    v_[262] = v_[58] * v_[52] + v_[213] * v_[53] + v_[231] * v_[314] + v_[151] * v_[300];
    v_[269] = v_[2] * -1.7423722;
    v_[281] = v_[127] * 0.160298259823722;
    v_[350] = v_[337] * 1.52322944854339e-09;
    v_[259] = 0 - v_[269] + v_[281] - v_[350];
    v_[41] = 0 - v_[151];
    v_[98] = v_[188] * v_[79] + v_[199] * v_[77] + v_[100] * v_[110] + v_[217] * v_[286] + v_[259] * v_[314] +
             v_[41] * v_[340];
    v_[94] = 0 - (v_[6] * 2.327 + (0 - v_[3]) * 0.01438086 + v_[347] * 0.647967112);
    v_[87] = (0 - v_[347]) * -0.0055615274403 + v_[247] * 0.01438086;
    v_[83] = v_[262] * v_[28] + v_[98] * v_[30] + v_[94] * v_[0] + v_[87] * v_[126];
    v_[350] = v_[269] - v_[281] + v_[350];
    v_[281] = v_[58] * v_[53] + v_[213] * v_[62] + v_[112] * v_[340] + v_[350] * v_[300];
    v_[269] = v_[3] * -0.0055615274403 - (v_[90] * -2.327 + v_[247] * 0.647967112);
    v_[194] = 0 - v_[87];
    v_[237] = v_[281] * -1 + v_[269] * v_[0] + v_[194] * v_[242];
    v_[229] = v_[19] * v_[4];
    v_[292] = v_[42] * v_[126] + v_[30] * v_[229];
    v_[84] = v_[18] * v_[4];
    v_[129] = -0.304 * v_[242] + -1 * v_[84];
    v_[271] = v_[43] * v_[126] + v_[28] * v_[229];
    v_[32] = v_[60] * v_[314] + v_[61] * v_[340] + v_[62] * v_[129] + v_[53] * v_[271];
    v_[204] = v_[79] * v_[292] + v_[77] * v_[32] + v_[78] * v_[110];
    v_[145] = v_[77] * v_[292] + v_[76] * v_[32] + v_[81] * v_[110];
    v_[91] = v_[101] * v_[77] + v_[295] * v_[76];
    v_[85] = (0 - v_[33]) * 1.5e-05 + v_[216] * 0.000198 + v_[91] * 0.00605;
    v_[82] = v_[318] * 0.038686875 + v_[33] * -0.000829 + (0 - v_[216]) * -0.00146 + (0 - v_[91]) * 0.000198;
    v_[27] = (0 - v_[15]) * 0.038686875;
    v_[309] = v_[216] * 1.5e-05;
    v_[208] = (0 - v_[91]) * -0.000829;
    v_[330] = v_[27] + v_[309] + v_[208];
    v_[330] = v_[56] * v_[204] + v_[335] * v_[145] + v_[85] * v_[65] + v_[82] * v_[280] + v_[330] * v_[110] +
              v_[330] * v_[110];
    v_[335] = v_[158] * 0.057838 + (0 - v_[101]) * -0.012652 + v_[21] * -0.001387 + v_[295] * -0.018069;
    v_[56] = v_[101] * 0.009683 + (0 - v_[21]) * -0.001243 + v_[295] * -0.012652;
    v_[248] = (0 - v_[307]) * 0.057838;
    v_[102] = (0 - v_[101]) * -0.001387;
    v_[103] = (0 - v_[295]) * -0.001243;
    v_[97] = v_[248] + v_[102] - v_[103];
    v_[97] = v_[330] + v_[188] * v_[78] + v_[199] * v_[81] + v_[100] * v_[292] + v_[272] * v_[32] + v_[335] * v_[300] +
             v_[56] * v_[286] + v_[97] * v_[110] + v_[97] * v_[110];
    v_[272] = v_[67] * v_[314] + v_[68] * v_[340] + v_[53] * v_[129] + v_[52] * v_[271];
    v_[199] = 0.02075 * v_[300] + -0.184 * v_[286] + v_[272];
    v_[188] = v_[44] * 0.038686875 + v_[33] * -0.00751 + (0 - v_[216]) * -0.000829 + v_[91] * 1.5e-05;
    v_[100] = (0 - v_[33]) * 0.000198;
    v_[208] = v_[27] + v_[100] - v_[208];
    v_[208] = v_[13] * v_[199] + v_[35] * v_[145] + v_[85] * v_[110] + v_[188] * v_[280] + v_[208] * v_[65] +
              v_[208] * v_[65];
    v_[100] = 0 - v_[100] - v_[309];
    v_[100] = v_[173] * v_[199] + v_[14] * v_[204] + v_[82] * v_[110] + v_[188] * v_[65] + v_[100] * v_[280] +
              v_[100] * v_[280];
    v_[188] = v_[40] * 0.057838 + v_[101] * -0.001243 + (0 - v_[21]) * -0.008386 + (0 - v_[295]) * -0.001387;
    v_[199] = v_[21] * -0.012652;
    v_[102] = v_[248] - v_[102] - v_[199];
    v_[102] = v_[107] * -0.184 + v_[208] * v_[77] + v_[100] * v_[76] + v_[217] * v_[292] + v_[69] * v_[272] +
              v_[188] * v_[300] + v_[56] * v_[110] + v_[102] * v_[286] + v_[102] * v_[286];
    v_[56] = v_[5] * -0.008711861 + v_[2] * 1.52322944854339e-09 + (0 - v_[127]) * -0.00021200017 +
             v_[123] * 0.0036857284 + v_[337] * 0.077424;
    v_[217] = v_[2] * 0.160298259823722 + v_[307] * -0.008711861 + v_[127] * -0.06337651 +
              (0 - v_[123]) * -0.0022920002 + v_[337] * -0.00021200017;
    v_[69] = (0 - v_[5]) * 1.52322944854339e-09;
    v_[248] = (0 - v_[307]) * 0.160298259823722;
    v_[82] = (0 - v_[127]) * 0.0036857284;
    v_[14] = (0 - v_[337]) * -0.0022920002;
    v_[173] = v_[69] + v_[248] + v_[82] - v_[14];
    v_[173] = v_[58] * v_[68] + v_[213] * v_[61] + v_[97] * v_[52] + v_[102] * v_[53] + v_[112] * v_[129] +
              v_[41] * v_[292] + v_[56] * v_[314] + v_[217] * v_[300] + v_[173] * v_[340] + v_[173] * v_[340];
    v_[199] = v_[199] + v_[103];
    v_[199] = v_[107] * 0.02075 + v_[208] * v_[86] + v_[100] * v_[77] + v_[285] * v_[272] + v_[117] * v_[32] +
              v_[335] * v_[110] + v_[188] * v_[286] + v_[199] * v_[300] + v_[199] * v_[300];
    v_[188] = v_[5] * 0.160298259823722 + v_[307] * 1.52322944854339e-09 + v_[127] * -0.0022920002 +
              (0 - v_[123]) * 0.01404749 + (0 - v_[337]) * 0.0036857284;
    v_[100] = (0 - v_[2]) * -0.008711861;
    v_[208] = v_[123] * -0.00021200017;
    v_[82] = v_[69] + v_[100] - v_[82] - v_[208];
    v_[82] = v_[199] + v_[350] * v_[129] + v_[151] * v_[271] + v_[188] * v_[314] + v_[217] * v_[340] +
             v_[82] * v_[300] + v_[82] * v_[300];
    v_[217] = v_[90] * 0.647967112 + (0 - v_[3]) * -0.011715295 + v_[347] * 5.399998e-05 + v_[247] * -0.199538951;
    v_[129] = v_[90] * -0.0055615274403 + v_[6] * 0.01438086 + v_[3] * 0.00750500000000001 +
              (0 - v_[347]) * -0.0037997814 + v_[247] * -0.011715295;
    v_[350] = (0 - v_[6]) * -0.0055615274403;
    v_[151] = (0 - v_[3]) * 5.399998e-05;
    v_[69] = (0 - v_[247]) * -0.0037997814;
    v_[335] = v_[350] + v_[151] - v_[69];
    v_[335] = v_[281] * -0.304 + v_[173] * v_[28] + v_[82] * v_[30] + v_[194] * v_[84] + v_[217] * v_[0] +
              v_[129] * v_[126] + v_[335] * v_[242] + v_[335] * v_[242];
    v_[208] = v_[100] + v_[248] + v_[208] + v_[14];
    v_[208] = v_[58] * v_[67] + v_[213] * v_[60] + v_[97] * v_[53] + v_[102] * v_[54] + v_[231] * v_[271] +
              v_[259] * v_[292] + v_[56] * v_[340] + v_[188] * v_[300] + v_[208] * v_[314] + v_[208] * v_[314];
    v_[188] = v_[6] * 0.647967112 + v_[3] * -0.0037997814 + (0 - v_[347]) * -0.192033951 + (0 - v_[247]) * 5.399998e-05;
    v_[56] = (0 - v_[90]) * 0.01438086;
    v_[102] = v_[347] * -0.011715295;
    v_[151] = v_[56] - v_[151] - v_[102];
    v_[151] = v_[262] * v_[43] + v_[98] * v_[42] + v_[208] * -1 + v_[87] * v_[229] + v_[188] * v_[0] +
              v_[129] * v_[242] + v_[151] * v_[126] + v_[151] * v_[126];
    v_[129] = w_in[7] * 0.046852534 + (0 - v_[250]) * -0.002752 + v_[7] * -0.022851627;
    v_[87] = (0 - w_in[7]) * 0.0055279857;
    v_[98] = v_[87] - (0 - v_[7]) * -0.002752;
    v_[102] = v_[56] + v_[350] + v_[102] + v_[69];
    v_[102] = v_[173] * v_[31] + v_[82] * v_[28] + v_[94] * v_[229] + v_[269] * v_[84] + v_[217] * v_[242] +
              v_[188] * v_[126] + v_[102] * v_[0] + v_[102] * v_[0];
    v_[87] = 0 - v_[87] - v_[250] * -0.022851627;
    hes[78] = (v_[83] * v_[19] + v_[237] * v_[18] + v_[335] * v_[9] + v_[151] * v_[10] + v_[129] * v_[0] +
                  v_[98] * v_[4] + v_[98] * v_[4]) *
                  v_[4] +
              (v_[102] + v_[129] * v_[4] + v_[87] * v_[0] + v_[87] * v_[0]) * v_[0];
    v_[87] = v_[318] * 1.547475 + v_[216] * -0.038686875;
    v_[98] = v_[87] + v_[158] * 2.1032 + v_[295] * -0.057838;
    v_[129] = v_[44] * 1.547475 + v_[33] * 0.038686875;
    v_[15] = v_[15] * 1.547475;
    v_[188] = v_[129] * v_[77] + v_[15] * v_[76] + v_[40] * 2.1032 + v_[21] * 0.057838;
    v_[217] = v_[98] * v_[52] + v_[188] * v_[53] + v_[2] * 1.7423722 + v_[127] * 0.160298259823722 +
              v_[337] * -1.52322944854339e-09;
    v_[82] = v_[129] * v_[79] + v_[15] * v_[77] + v_[307] * 2.1032 + v_[307] * 1.7423722 + v_[127] * 0.008711861 +
             v_[123] * 1.52322944854339e-09;
    v_[173] = v_[217] * v_[28] + v_[82] * v_[30] + v_[90] * 2.327 + v_[3] * -0.0055615274403 + v_[247] * -0.647967112;
    v_[269] =
        v_[98] * v_[53] + v_[188] * v_[62] + v_[5] * 1.7423722 + v_[123] * -0.160298259823722 + v_[337] * -0.008711861;
    v_[94] = v_[269] * -1 + v_[6] * 2.327 + v_[3] * -0.01438086 + v_[347] * 0.647967112;
    v_[44] = v_[44] * 0.038686875 + v_[33] * 0.009277 + v_[216] * -0.000829 + v_[91] * 1.5e-05 + v_[129] * v_[78] +
             v_[15] * v_[81] + v_[40] * 0.057838 + v_[101] * -0.001243 + v_[21] * 0.029115 + v_[295] * -0.001387;
    v_[318] = v_[318] * -0.038686875 + v_[33] * -0.000829 + v_[216] * 0.003227 + v_[91] * 0.000198;
    v_[91] = v_[33] * 1.5e-05 + v_[216] * 0.000198 + v_[91] * 0.010737;
    hes[83] = v_[129] * (-v_[145]) + v_[15] * v_[204] + v_[318] * (-v_[280]) + v_[91] * v_[65] + v_[330];
    v_[158] = v_[87] * -0.184 + v_[318] * v_[77] + v_[91] * v_[76] + v_[158] * -0.057838 + v_[101] * -0.012652 +
              v_[21] * -0.001387 + v_[295] * 0.019432;
    hes[82] = v_[98] * (-v_[32]) + v_[188] * v_[272] + v_[44] * (-v_[286]) + v_[158] * v_[110] + v_[199];
    v_[199] = v_[98] * v_[68] + v_[188] * v_[61] + v_[44] * v_[52] + v_[158] * v_[53] + v_[5] * -0.160298259823722 +
              v_[307] * 1.52322944854339e-09 + v_[127] * -0.0022920002 + v_[123] * 0.01828449 + v_[337] * 0.0036857284;
    v_[91] = v_[87] * 0.02075 + v_[318] * v_[86] + v_[91] * v_[77] + v_[101] * 0.011046 + v_[21] * -0.001243 +
             v_[295] * -0.012652 + v_[5] * -0.008711861 + v_[2] * -1.52322944854339e-09 + v_[127] * -0.00021200017 +
             v_[123] * 0.0036857284 + v_[337] * 0.081661;
    hes[81] = v_[217] * (-v_[292]) + v_[82] * v_[271] + v_[199] * (-v_[300]) + v_[91] * v_[340] + v_[208];
    v_[269] = v_[269] * -0.304 + v_[199] * v_[28] + v_[91] * v_[30] + v_[6] * 0.647967112 + v_[3] * -0.0037997814 +
              v_[347] * 0.20986895 + v_[247] * 5.399998e-05;
    v_[158] = v_[217] * v_[43] + v_[82] * v_[42] +
              (v_[98] * v_[67] + v_[188] * v_[60] + v_[44] * v_[53] + v_[158] * v_[54] + v_[2] * 0.160298259823722 +
                  v_[307] * 0.008711861 + v_[127] * 0.09570849 + v_[123] * -0.0022920002 + v_[337] * -0.00021200017) *
                  -1 +
              v_[90] * -0.647967112 + v_[3] * -0.011715295 + v_[347] * 5.399998e-05 + v_[247] * 0.20236395;
    hes[79] =
        v_[83] * v_[20] + v_[237] * v_[38] + v_[335] * v_[10] + v_[151] * v_[11] +
        (w_in[7] * -0.002752 + (0 - v_[250]) * 0.012390532 + (0 - v_[7]) * 0.0055279857) * v_[0] +
        (v_[173] * v_[19] + v_[94] * v_[18] + v_[269] * v_[9] + v_[158] * v_[10] + w_in[7] * -0.002752 +
            v_[250] * 0.08585553 + v_[7] * 0.0055279857) *
            (-v_[0]) +
        (v_[199] * v_[31] + v_[91] * v_[28] + v_[90] * -0.0055615274403 + v_[6] * -0.01438086 + v_[3] * 0.010329999 +
            v_[347] * -0.0037997814 + v_[247] * -0.011715295 + w_in[7] * -0.022851627 + v_[250] * 0.0055279857 +
            v_[7] * 0.039002996 + (0 - w_in[7]) * -0.022851627 + v_[250] * 0.0055279857 + v_[7] * -0.034462002) *
            v_[4];
    hes[80] = v_[173] * (-v_[84]) + v_[94] * v_[229] + v_[269] * (-v_[126]) + v_[158] * v_[242] + v_[102];
    v_[158] = w_in[6] * v_[4];
    v_[269] = w_in[7] * v_[20] + v_[158] * v_[19];
    v_[94] = w_in[7] * v_[11] + v_[158] * v_[10];
    v_[173] = v_[269] * v_[30] + v_[94] * v_[42];
    v_[102] = w_in[7] * v_[38] + v_[158] * v_[18];
    v_[84] = w_in[7] * v_[10] + v_[158] * v_[9];
    v_[229] = v_[102] * -1 + v_[84] * -0.304;
    v_[126] = v_[269] * v_[28] + v_[94] * v_[43];
    v_[242] = w_in[9] + v_[94] * -1;
    v_[91] = w_in[6] * v_[0];
    v_[199] = w_in[8] + v_[91];
    v_[151] = v_[199] * v_[31] + v_[84] * v_[28];
    v_[335] = v_[229] * v_[62] + v_[126] * v_[53] + v_[242] * v_[60] + v_[151] * v_[61];
    v_[237] = v_[242] * v_[53] + v_[151] * v_[52];
    v_[83] = v_[173] * v_[77] + v_[335] * v_[76] + v_[237] * v_[81];
    v_[3] = v_[83] * 1.547475;
    v_[7] = v_[28] * v_[10];
    v_[347] = -1 * v_[11];
    v_[6] = v_[53] * v_[7] + v_[54] * v_[347];
    v_[247] = v_[30] * v_[10];
    v_[90] = v_[77] * v_[6] + v_[86] * v_[247];
    v_[250] = v_[173] * v_[79] + v_[335] * v_[77] + v_[237] * v_[78];
    v_[44] = v_[250] * -1.547475;
    v_[82] = w_in[11] + v_[237];
    v_[217] = v_[82] * 0.038686875;
    v_[188] = v_[44] - v_[217];
    v_[98] = v_[76] * v_[6] + v_[77] * v_[247];
    v_[337] = v_[3] * v_[90] + v_[188] * v_[98];
    v_[123] = v_[335] * 2.1032 + v_[237] * 0.057838;
    v_[127] = 0 - v_[123];
    v_[2] = v_[173] * 2.1032;
    v_[307] = v_[337] + v_[127] * v_[247] + v_[2] * v_[6];
    v_[208] = 0 - v_[3];
    v_[271] = v_[52] * v_[7] + v_[53] * v_[347];
    v_[292] = v_[229] * v_[53] + v_[126] * v_[52] + v_[242] * v_[67] + v_[151] * v_[68];
    v_[300] = v_[199] * v_[28] + v_[84] * v_[30];
    v_[340] = w_in[10] + v_[300];
    v_[318] = v_[242] * v_[54] + v_[151] * v_[53];
    v_[87] = v_[292] + v_[340] * 0.02075 + v_[318] * -0.184;
    v_[295] = v_[340] * v_[86] + v_[318] * v_[77];
    v_[101] = v_[87] * 1.547475 + (0 - v_[295]) * 0.038686875;
    v_[21] = v_[208] * v_[271] + v_[101] * v_[98];
    v_[217] = 0 - v_[44] + v_[217];
    v_[44] = 0 - v_[101];
    v_[5] = v_[217] * v_[271] + v_[44] * v_[90];
    v_[272] = v_[292] * -2.1032 + v_[318] * 0.057838;
    v_[32] = 0 - v_[272];
    v_[110] = 0 - v_[2];
    v_[286] = v_[21] * v_[77] + v_[5] * v_[76] + v_[32] * v_[247] + v_[110] * v_[271];
    v_[15] = v_[173] * 1.7423722 + (0 - v_[242]) * -0.008711861 + v_[151] * 1.52322944854339e-09;
    v_[129] = 0 - v_[15];
    v_[330] = v_[229] * 1.7423722 + (0 - v_[151]) * 0.160298259823722 + v_[300] * -0.008711861;
    v_[145] = v_[307] * v_[52] + v_[286] * v_[53] + v_[129] * v_[347] + v_[330] * v_[247];
    v_[204] = v_[126] * -1.7423722;
    v_[280] = v_[242] * 0.160298259823722;
    v_[65] = v_[300] * 1.52322944854339e-09;
    v_[216] = 0 - v_[204] + v_[280] - v_[65];
    v_[33] = 0 - v_[330];
    v_[40] =
        v_[21] * v_[79] + v_[5] * v_[77] + v_[123] * v_[271] + v_[272] * v_[6] + v_[216] * v_[347] + v_[33] * v_[7];
    v_[56] = (0 - v_[84]) * -0.0055615274403 + v_[94] * 0.01438086;
    v_[65] = v_[204] - v_[280] + v_[65];
    v_[280] = v_[307] * v_[53] + v_[286] * v_[62] + v_[15] * v_[7] + v_[65] * v_[247];
    v_[204] = 0 - v_[56];
    v_[69] = v_[42] * v_[11] + v_[30] * v_[20];
    v_[350] = -0.304 * v_[10] + -1 * v_[38];
    v_[262] = v_[43] * v_[11] + v_[28] * v_[20];
    v_[97] = v_[60] * v_[347] + v_[61] * v_[7] + v_[62] * v_[350] + v_[53] * v_[262];
    v_[259] = v_[79] * v_[69] + v_[77] * v_[97] + v_[78] * v_[271];
    v_[231] = v_[77] * v_[69] + v_[76] * v_[97] + v_[81] * v_[271];
    v_[213] = v_[340] * v_[77] + v_[318] * v_[76];
    v_[58] = (0 - v_[82]) * 1.5e-05 + v_[295] * 0.000198 + v_[213] * 0.00605;
    v_[314] = v_[87] * 0.038686875 + v_[82] * -0.000829 + (0 - v_[295]) * -0.00146 + (0 - v_[213]) * 0.000198;
    v_[100] = (0 - v_[83]) * 0.038686875;
    v_[14] = v_[295] * 1.5e-05;
    v_[248] = (0 - v_[213]) * -0.000829;
    v_[194] = v_[100] + v_[14] + v_[248];
    v_[194] = v_[208] * v_[259] + v_[217] * v_[231] + v_[58] * v_[90] + v_[314] * v_[98] + v_[194] * v_[271] +
              v_[194] * v_[271];
    v_[217] = v_[292] * 0.057838 + (0 - v_[340]) * -0.012652 + v_[237] * -0.001387 + v_[318] * -0.018069;
    v_[208] = v_[340] * 0.009683 + (0 - v_[237]) * -0.001243 + v_[318] * -0.012652;
    v_[281] = (0 - v_[173]) * 0.057838;
    v_[117] = (0 - v_[340]) * -0.001387;
    v_[285] = (0 - v_[318]) * -0.001243;
    v_[107] = v_[281] + v_[117] - v_[285];
    v_[107] = v_[194] + v_[21] * v_[78] + v_[5] * v_[81] + v_[123] * v_[69] + v_[110] * v_[97] + v_[217] * v_[247] +
              v_[208] * v_[6] + v_[107] * v_[271] + v_[107] * v_[271];
    v_[110] = v_[67] * v_[347] + v_[68] * v_[7] + v_[53] * v_[350] + v_[52] * v_[262];
    v_[5] = 0.02075 * v_[247] + -0.184 * v_[6] + v_[110];
    v_[21] = v_[250] * 0.038686875 + v_[82] * -0.00751 + (0 - v_[295]) * -0.000829 + v_[213] * 1.5e-05;
    v_[123] = (0 - v_[82]) * 0.000198;
    v_[248] = v_[100] + v_[123] - v_[248];
    v_[248] =
        v_[3] * v_[5] + v_[44] * v_[231] + v_[58] * v_[271] + v_[21] * v_[98] + v_[248] * v_[90] + v_[248] * v_[90];
    v_[123] = 0 - v_[123] - v_[14];
    v_[123] =
        v_[188] * v_[5] + v_[101] * v_[259] + v_[314] * v_[271] + v_[21] * v_[90] + v_[123] * v_[98] + v_[123] * v_[98];
    v_[21] = v_[335] * 0.057838 + v_[340] * -0.001243 + (0 - v_[237]) * -0.008386 + (0 - v_[318]) * -0.001387;
    v_[5] = v_[237] * -0.012652;
    v_[117] = v_[281] - v_[117] - v_[5];
    v_[117] = v_[337] * -0.184 + v_[248] * v_[77] + v_[123] * v_[76] + v_[272] * v_[69] + v_[2] * v_[110] +
              v_[21] * v_[247] + v_[208] * v_[271] + v_[117] * v_[6] + v_[117] * v_[6];
    v_[208] = v_[229] * -0.008711861 + v_[126] * 1.52322944854339e-09 + (0 - v_[242]) * -0.00021200017 +
              v_[151] * 0.0036857284 + v_[300] * 0.077424;
    v_[272] = v_[126] * 0.160298259823722 + v_[173] * -0.008711861 + v_[242] * -0.06337651 +
              (0 - v_[151]) * -0.0022920002 + v_[300] * -0.00021200017;
    v_[2] = (0 - v_[229]) * 1.52322944854339e-09;
    v_[281] = (0 - v_[173]) * 0.160298259823722;
    v_[314] = (0 - v_[242]) * 0.0036857284;
    v_[101] = (0 - v_[300]) * -0.0022920002;
    v_[188] = v_[2] + v_[281] + v_[314] - v_[101];
    v_[188] = v_[307] * v_[68] + v_[286] * v_[61] + v_[107] * v_[52] + v_[117] * v_[53] + v_[15] * v_[350] +
              v_[33] * v_[69] + v_[208] * v_[347] + v_[272] * v_[247] + v_[188] * v_[7] + v_[188] * v_[7];
    v_[5] = v_[5] + v_[285];
    v_[5] = v_[337] * 0.02075 + v_[248] * v_[86] + v_[123] * v_[77] + v_[127] * v_[110] + v_[32] * v_[97] +
            v_[217] * v_[271] + v_[21] * v_[6] + v_[5] * v_[247] + v_[5] * v_[247];
    v_[21] = v_[229] * 0.160298259823722 + v_[173] * 1.52322944854339e-09 + v_[242] * -0.0022920002 +
             (0 - v_[151]) * 0.01404749 + (0 - v_[300]) * 0.0036857284;
    v_[123] = (0 - v_[126]) * -0.008711861;
    v_[248] = v_[151] * -0.00021200017;
    v_[314] = v_[2] + v_[123] - v_[314] - v_[248];
    v_[314] = v_[5] + v_[65] * v_[350] + v_[330] * v_[262] + v_[21] * v_[347] + v_[272] * v_[7] + v_[314] * v_[247] +
              v_[314] * v_[247];
    v_[272] = v_[269] * -0.0055615274403 + v_[102] * 0.01438086 + v_[199] * 0.00750500000000001 +
              (0 - v_[84]) * -0.0037997814 + v_[94] * -0.011715295;
    v_[350] = (0 - v_[199]) * 5.399998e-05;
    v_[65] = (0 - v_[102]) * -0.0055615274403 + v_[350] - (0 - v_[94]) * -0.0037997814;
    v_[248] = v_[123] + v_[281] + v_[248] + v_[101];
    v_[248] = v_[307] * v_[67] + v_[286] * v_[60] + v_[107] * v_[53] + v_[117] * v_[54] + v_[129] * v_[262] +
              v_[216] * v_[69] + v_[208] * v_[7] + v_[21] * v_[247] + v_[248] * v_[347] + v_[248] * v_[347];
    v_[350] = (0 - v_[269]) * 0.01438086 - v_[350] - v_[84] * -0.011715295;
    v_[91] = v_[158] * -0.022851627 + (0 - v_[91]) * -0.002752;
    hes[91] = (v_[145] * v_[28] + v_[40] * v_[30] + v_[56] * v_[11]) * v_[20] +
              (v_[280] * -1 + v_[204] * v_[10]) * v_[38] +
              (v_[280] * -0.304 + v_[188] * v_[28] + v_[314] * v_[30] + v_[204] * v_[38] + v_[272] * v_[11] +
                  v_[65] * v_[10] + v_[65] * v_[10]) *
                  v_[10] +
              (v_[145] * v_[43] + v_[40] * v_[42] + v_[248] * -1 + v_[56] * v_[20] + v_[272] * v_[10] +
                  v_[350] * v_[11] + v_[350] * v_[11]) *
                  v_[11] +
              v_[91] + v_[91];
    v_[91] = v_[87] * 1.547475 + v_[295] * -0.038686875;
    v_[350] = v_[91] + v_[292] * 2.1032 + v_[318] * -0.057838;
    v_[65] = v_[250] * 1.547475 + v_[82] * 0.038686875;
    v_[83] = v_[83] * 1.547475;
    v_[272] = v_[65] * v_[77] + v_[83] * v_[76] + v_[335] * 2.1032 + v_[237] * 0.057838;
    v_[204] = v_[350] * v_[52] + v_[272] * v_[53] + v_[126] * 1.7423722 + v_[242] * 0.160298259823722 +
              v_[300] * -1.52322944854339e-09;
    v_[280] = v_[65] * v_[79] + v_[83] * v_[77] + v_[173] * 2.1032 + v_[173] * 1.7423722 + v_[242] * 0.008711861 +
              v_[151] * 1.52322944854339e-09;
    v_[56] = v_[350] * v_[53] + v_[272] * v_[62] + v_[229] * 1.7423722 + v_[151] * -0.160298259823722 +
             v_[300] * -0.008711861;
    v_[250] = v_[250] * 0.038686875 + v_[82] * 0.009277 + v_[295] * -0.000829 + v_[213] * 1.5e-05 + v_[65] * v_[78] +
              v_[83] * v_[81] + v_[335] * 0.057838 + v_[340] * -0.001243 + v_[237] * 0.029115 + v_[318] * -0.001387;
    v_[87] = v_[87] * -0.038686875 + v_[82] * -0.000829 + v_[295] * 0.003227 + v_[213] * 0.000198;
    v_[213] = v_[82] * 1.5e-05 + v_[295] * 0.000198 + v_[213] * 0.010737;
    hes[95] = v_[65] * (-v_[231]) + v_[83] * v_[259] + v_[87] * (-v_[98]) + v_[213] * v_[90] + v_[194];
    v_[292] = v_[91] * -0.184 + v_[87] * v_[77] + v_[213] * v_[76] + v_[292] * -0.057838 + v_[340] * -0.012652 +
              v_[237] * -0.001387 + v_[318] * 0.019432;
    hes[94] = v_[350] * (-v_[97]) + v_[272] * v_[110] + v_[250] * (-v_[6]) + v_[292] * v_[271] + v_[5];
    v_[5] = v_[350] * v_[68] + v_[272] * v_[61] + v_[250] * v_[52] + v_[292] * v_[53] + v_[229] * -0.160298259823722 +
            v_[173] * 1.52322944854339e-09 + v_[242] * -0.0022920002 + v_[151] * 0.01828449 + v_[300] * 0.0036857284;
    v_[213] = v_[91] * 0.02075 + v_[87] * v_[86] + v_[213] * v_[77] + v_[340] * 0.011046 + v_[237] * -0.001243 +
              v_[318] * -0.012652 + v_[229] * -0.008711861 + v_[126] * -1.52322944854339e-09 +
              v_[242] * -0.00021200017 + v_[151] * 0.0036857284 + v_[300] * 0.081661;
    hes[92] =
        (v_[204] * v_[28] + v_[280] * v_[30] + v_[269] * 2.327 + v_[199] * -0.0055615274403 + v_[94] * -0.647967112) *
            (-v_[38]) +
        (v_[56] * -1 + v_[102] * 2.327 + v_[199] * -0.01438086 + v_[84] * 0.647967112) * v_[20] +
        (v_[56] * -0.304 + v_[5] * v_[28] + v_[213] * v_[30] + v_[102] * 0.647967112 + v_[199] * -0.0037997814 +
            v_[84] * 0.20986895 + v_[94] * 5.399998e-05) *
            (-v_[11]) +
        (v_[204] * v_[43] + v_[280] * v_[42] +
            (v_[350] * v_[67] + v_[272] * v_[60] + v_[250] * v_[53] + v_[292] * v_[54] + v_[126] * 0.160298259823722 +
                v_[173] * 0.008711861 + v_[242] * 0.09570849 + v_[151] * -0.0022920002 + v_[300] * -0.00021200017) *
                -1 +
            v_[269] * -0.647967112 + v_[199] * -0.011715295 + v_[84] * 5.399998e-05 + v_[94] * 0.20236395) *
            v_[10] +
        v_[188] * v_[31] + v_[314] * v_[28] +
        (0 - (v_[102] * 2.327 + (0 - v_[199]) * 0.01438086 + v_[84] * 0.647967112)) * v_[20] +
        (v_[199] * -0.0055615274403 - (v_[269] * -2.327 + v_[94] * 0.647967112)) * v_[38] +
        (v_[269] * 0.647967112 + (0 - v_[199]) * -0.011715295 + v_[84] * 5.399998e-05 + v_[94] * -0.199538951) *
            v_[10] +
        (v_[102] * 0.647967112 + v_[199] * -0.0037997814 + (0 - v_[84]) * -0.192033951 + (0 - v_[94]) * 5.399998e-05) *
            v_[11];
    hes[93] = v_[204] * (-v_[69]) + v_[280] * v_[262] + v_[5] * (-v_[247]) + v_[213] * v_[7] + v_[248];
    v_[213] = w_in[6] * v_[4];
    v_[5] = w_in[7] * v_[20] + v_[213] * v_[19];
    v_[280] = w_in[7] * v_[11] + v_[213] * v_[10];
    v_[204] = v_[5] * v_[30] + v_[280] * v_[42];
    v_[248] = w_in[7] * v_[38] + v_[213] * v_[18];
    v_[213] = w_in[7] * v_[10] + v_[213] * v_[9];
    v_[262] = v_[248] * -1 + v_[213] * -0.304;
    v_[69] = v_[5] * v_[28] + v_[280] * v_[43];
    v_[247] = w_in[9] + v_[280] * -1;
    v_[7] = w_in[8] + w_in[6] * v_[0];
    v_[292] = v_[7] * v_[31] + v_[213] * v_[28];
    v_[250] = v_[262] * v_[62] + v_[69] * v_[53] + v_[247] * v_[60] + v_[292] * v_[61];
    v_[56] = v_[247] * v_[53] + v_[292] * v_[52];
    v_[272] = v_[204] * v_[77] + v_[250] * v_[76] + v_[56] * v_[81];
    v_[350] = v_[272] * 1.547475;
    v_[314] = v_[53] * v_[31];
    v_[188] = v_[77] * v_[314] + v_[86] * v_[28];
    v_[300] = v_[204] * v_[79] + v_[250] * v_[77] + v_[56] * v_[78];
    v_[151] = v_[300] * -1.547475;
    v_[199] = w_in[11] + v_[56];
    v_[242] = v_[199] * 0.038686875;
    v_[126] = v_[151] - v_[242];
    v_[84] = v_[76] * v_[314] + v_[77] * v_[28];
    v_[102] = v_[350] * v_[188] + v_[126] * v_[84];
    v_[173] = 0 - (v_[250] * 2.1032 + v_[56] * 0.057838);
    v_[94] = v_[204] * 2.1032;
    v_[269] = v_[102] + v_[173] * v_[28] + v_[94] * v_[314];
    v_[87] = 0 - v_[350];
    v_[91] = v_[52] * v_[31];
    v_[318] = v_[262] * v_[53] + v_[69] * v_[52] + v_[247] * v_[67] + v_[292] * v_[68];
    v_[7] = v_[7] * v_[28] + v_[213] * v_[30];
    v_[340] = w_in[10] + v_[7];
    v_[237] = v_[247] * v_[54] + v_[292] * v_[53];
    v_[229] = v_[318] + v_[340] * 0.02075 + v_[237] * -0.184;
    v_[110] = v_[340] * v_[86] + v_[237] * v_[77];
    v_[97] = v_[229] * 1.547475 + (0 - v_[110]) * 0.038686875;
    v_[271] = v_[87] * v_[91] + v_[97] * v_[84];
    v_[242] = 0 - v_[151] + v_[242];
    v_[151] = 0 - v_[97];
    v_[6] = v_[242] * v_[91] + v_[151] * v_[188];
    v_[83] = 0 - (v_[318] * -2.1032 + v_[237] * 0.057838);
    v_[65] = 0 - v_[94];
    v_[194] = v_[271] * v_[77] + v_[6] * v_[76] + v_[83] * v_[28] + v_[65] * v_[91];
    v_[231] = v_[61] * v_[31];
    v_[259] = v_[77] * v_[231] + v_[78] * v_[91];
    v_[98] = v_[76] * v_[231] + v_[81] * v_[91];
    v_[90] = v_[340] * v_[77] + v_[237] * v_[76];
    v_[295] = (0 - v_[199]) * 1.5e-05 + v_[110] * 0.000198 + v_[90] * 0.00605;
    v_[82] = v_[229] * 0.038686875 + v_[199] * -0.000829 + (0 - v_[110]) * -0.00146 + (0 - v_[90]) * 0.000198;
    v_[335] = (0 - v_[272]) * 0.038686875;
    v_[40] = v_[110] * 1.5e-05;
    v_[145] = (0 - v_[90]) * -0.000829;
    v_[158] = v_[335] + v_[40] + v_[145];
    v_[158] =
        v_[87] * v_[259] + v_[242] * v_[98] + v_[295] * v_[188] + v_[82] * v_[84] + v_[158] * v_[91] + v_[158] * v_[91];
    v_[242] = v_[318] * 0.057838 + (0 - v_[340]) * -0.012652 + v_[56] * -0.001387 + v_[237] * -0.018069;
    v_[87] = v_[340] * 0.009683 + (0 - v_[56]) * -0.001243 + v_[237] * -0.012652;
    v_[21] = (0 - v_[204]) * 0.057838;
    v_[208] = (0 - v_[340]) * -0.001387;
    v_[117] = (0 - v_[237]) * -0.001243;
    v_[107] = v_[21] + v_[208] - v_[117];
    v_[107] = v_[158] + v_[271] * v_[78] + v_[6] * v_[81] + v_[65] * v_[231] + v_[242] * v_[28] + v_[87] * v_[314] +
              v_[107] * v_[91] + v_[107] * v_[91];
    v_[65] = v_[68] * v_[31];
    v_[6] = 0.02075 * v_[28] + -0.184 * v_[314] + v_[65];
    v_[271] = v_[300] * 0.038686875 + v_[199] * -0.00751 + (0 - v_[110]) * -0.000829 + v_[90] * 1.5e-05;
    v_[216] = (0 - v_[199]) * 0.000198;
    v_[145] = v_[335] + v_[216] - v_[145];
    v_[145] = v_[350] * v_[6] + v_[151] * v_[98] + v_[295] * v_[91] + v_[271] * v_[84] + v_[145] * v_[188] +
              v_[145] * v_[188];
    v_[216] = 0 - v_[216] - v_[40];
    v_[216] =
        v_[126] * v_[6] + v_[97] * v_[259] + v_[82] * v_[91] + v_[271] * v_[188] + v_[216] * v_[84] + v_[216] * v_[84];
    v_[271] = v_[250] * 0.057838 + v_[340] * -0.001243 + (0 - v_[56]) * -0.008386 + (0 - v_[237]) * -0.001387;
    v_[6] = v_[56] * -0.012652;
    v_[208] = v_[21] - v_[208] - v_[6];
    v_[208] = v_[102] * -0.184 + v_[145] * v_[77] + v_[216] * v_[76] + v_[94] * v_[65] + v_[271] * v_[28] +
              v_[87] * v_[91] + v_[208] * v_[314] + v_[208] * v_[314];
    v_[87] = v_[69] * 0.160298259823722 + v_[204] * -0.008711861 + v_[247] * -0.06337651 +
             (0 - v_[292]) * -0.0022920002 + v_[7] * -0.00021200017;
    v_[94] = (0 - v_[262]) * 1.52322944854339e-09;
    v_[21] = (0 - v_[247]) * 0.0036857284;
    v_[82] = v_[94] + (0 - v_[204]) * 0.160298259823722 + v_[21] - (0 - v_[7]) * -0.0022920002;
    v_[6] = v_[6] + v_[117];
    v_[6] = v_[102] * 0.02075 + v_[145] * v_[86] + v_[216] * v_[77] + v_[173] * v_[65] + v_[83] * v_[231] +
            v_[242] * v_[91] + v_[271] * v_[314] + v_[6] * v_[28] + v_[6] * v_[28];
    v_[21] = v_[94] + (0 - v_[69]) * -0.008711861 - v_[21] - v_[292] * -0.00021200017;
    v_[213] = (0 - v_[5]) * 0.01438086 + (0 - v_[248]) * -0.0055615274403 + v_[213] * -0.011715295 +
              (0 - v_[280]) * -0.0037997814;
    hes[104] = (v_[269] * v_[68] + v_[194] * v_[61] + v_[107] * v_[52] + v_[208] * v_[53] + v_[87] * v_[28] +
                   v_[82] * v_[31] + v_[82] * v_[31]) *
                   v_[31] +
               (v_[6] + v_[87] * v_[31] + v_[21] * v_[28] + v_[21] * v_[28]) * v_[28] + v_[213] + v_[213];
    v_[213] = v_[229] * 1.547475 + v_[110] * -0.038686875;
    v_[21] = v_[213] + v_[318] * 2.1032 + v_[237] * -0.057838;
    v_[82] = v_[300] * 1.547475 + v_[199] * 0.038686875;
    v_[272] = v_[272] * 1.547475;
    v_[87] = v_[82] * v_[77] + v_[272] * v_[76] + v_[250] * 2.1032 + v_[56] * 0.057838;
    v_[300] = v_[300] * 0.038686875 + v_[199] * 0.009277 + v_[110] * -0.000829 + v_[90] * 1.5e-05 + v_[82] * v_[78] +
              v_[272] * v_[81] + v_[250] * 0.057838 + v_[340] * -0.001243 + v_[56] * 0.029115 + v_[237] * -0.001387;
    v_[229] = v_[229] * -0.038686875 + v_[199] * -0.000829 + v_[110] * 0.003227 + v_[90] * 0.000198;
    v_[90] = v_[199] * 1.5e-05 + v_[110] * 0.000198 + v_[90] * 0.010737;
    hes[107] = v_[82] * (-v_[98]) + v_[272] * v_[259] + v_[229] * (-v_[84]) + v_[90] * v_[188] + v_[158];
    v_[318] = v_[213] * -0.184 + v_[229] * v_[77] + v_[90] * v_[76] + v_[318] * -0.057838 + v_[340] * -0.012652 +
              v_[56] * -0.001387 + v_[237] * 0.019432;
    hes[105] =
        (v_[21] * v_[68] + v_[87] * v_[61] + v_[300] * v_[52] + v_[318] * v_[53] + v_[262] * -0.160298259823722 +
            v_[204] * 1.52322944854339e-09 + v_[247] * -0.0022920002 + v_[292] * 0.01828449 + v_[7] * 0.0036857284) *
            (-v_[28]) +
        (v_[213] * 0.02075 + v_[229] * v_[86] + v_[90] * v_[77] + v_[340] * 0.011046 + v_[56] * -0.001243 +
            v_[237] * -0.012652 + v_[262] * -0.008711861 + v_[69] * -1.52322944854339e-09 + v_[247] * -0.00021200017 +
            v_[292] * 0.0036857284 + v_[7] * 0.081661) *
            v_[31] +
        v_[269] * v_[67] + v_[194] * v_[60] + v_[107] * v_[53] + v_[208] * v_[54] +
        (v_[262] * -0.008711861 + v_[69] * 1.52322944854339e-09 + (0 - v_[247]) * -0.00021200017 +
            v_[292] * 0.0036857284 + v_[7] * 0.077424) *
            v_[31] +
        (v_[262] * 0.160298259823722 + v_[204] * 1.52322944854339e-09 + v_[247] * -0.0022920002 +
            (0 - v_[292]) * 0.01404749 + (0 - v_[7]) * 0.0036857284) *
            v_[28];
    hes[106] = v_[21] * (-v_[231]) + v_[87] * v_[65] + v_[300] * (-v_[314]) + v_[318] * v_[91] + v_[6];
    v_[318] = w_in[6] * v_[4];
    v_[300] = w_in[7] * v_[20] + v_[318] * v_[19];
    v_[87] = w_in[7] * v_[11] + v_[318] * v_[10];
    v_[21] = v_[300] * v_[30] + v_[87] * v_[42];
    v_[6] = w_in[7] * v_[10] + v_[318] * v_[9];
    v_[318] = (w_in[7] * v_[38] + v_[318] * v_[18]) * -1 + v_[6] * -0.304;
    v_[300] = v_[300] * v_[28] + v_[87] * v_[43];
    v_[87] = w_in[9] + v_[87] * -1;
    v_[65] = w_in[8] + w_in[6] * v_[0];
    v_[231] = v_[65] * v_[31] + v_[6] * v_[28];
    v_[91] = v_[318] * v_[62] + v_[300] * v_[53] + v_[87] * v_[60] + v_[231] * v_[61];
    v_[314] = v_[87] * v_[53] + v_[231] * v_[52];
    v_[90] = v_[21] * v_[77] + v_[91] * v_[76] + v_[314] * v_[81];
    v_[229] = v_[90] * 1.547475;
    v_[213] = v_[77] * v_[54];
    v_[208] = v_[21] * v_[79] + v_[91] * v_[77] + v_[314] * v_[78];
    v_[107] = v_[208] * -1.547475;
    v_[194] = w_in[11] + v_[314];
    v_[237] = v_[194] * 0.038686875;
    v_[340] = v_[107] - v_[237];
    v_[7] = v_[76] * v_[54];
    v_[269] = v_[229] * v_[213] + v_[340] * v_[7];
    v_[56] = v_[21] * 2.1032;
    v_[292] = 0 - v_[229];
    v_[318] = v_[318] * v_[53] + v_[300] * v_[52] + v_[87] * v_[67] + v_[231] * v_[68];
    v_[65] = v_[65] * v_[28] + v_[6] * v_[30];
    v_[6] = w_in[10] + v_[65];
    v_[87] = v_[87] * v_[54] + v_[231] * v_[53];
    v_[247] = v_[318] + v_[6] * 0.02075 + v_[87] * -0.184;
    v_[69] = v_[6] * v_[86] + v_[87] * v_[77];
    v_[262] = v_[247] * 1.547475 + (0 - v_[69]) * 0.038686875;
    v_[204] = v_[292] * v_[53] + v_[262] * v_[7];
    v_[237] = 0 - v_[107] + v_[237];
    v_[107] = 0 - v_[262];
    v_[272] = v_[237] * v_[53] + v_[107] * v_[213];
    v_[82] = 0 - v_[56];
    v_[158] = v_[77] * v_[60] + v_[78] * v_[53];
    v_[98] = v_[76] * v_[60] + v_[81] * v_[53];
    v_[259] = v_[6] * v_[77] + v_[87] * v_[76];
    v_[84] = (0 - v_[194]) * 1.5e-05 + v_[69] * 0.000198 + v_[259] * 0.00605;
    v_[188] = v_[247] * 0.038686875 + v_[194] * -0.000829 + (0 - v_[69]) * -0.00146 + (0 - v_[259]) * 0.000198;
    v_[110] = (0 - v_[90]) * 0.038686875;
    v_[199] = v_[69] * 1.5e-05;
    v_[250] = (0 - v_[259]) * -0.000829;
    v_[248] = v_[110] + v_[199] + v_[250];
    v_[248] =
        v_[292] * v_[158] + v_[237] * v_[98] + v_[84] * v_[213] + v_[188] * v_[7] + v_[248] * v_[53] + v_[248] * v_[53];
    v_[237] = v_[6] * 0.009683 + (0 - v_[314]) * -0.001243 + v_[87] * -0.012652;
    v_[292] = (0 - v_[21]) * 0.057838;
    v_[280] = (0 - v_[6]) * -0.001387;
    v_[5] = v_[292] + v_[280] - (0 - v_[87]) * -0.001243;
    v_[94] = -0.184 * v_[54] + v_[67];
    v_[271] = v_[208] * 0.038686875 + v_[194] * -0.00751 + (0 - v_[69]) * -0.000829 + v_[259] * 1.5e-05;
    v_[216] = (0 - v_[194]) * 0.000198;
    v_[250] = v_[110] + v_[216] - v_[250];
    v_[250] =
        v_[229] * v_[94] + v_[107] * v_[98] + v_[84] * v_[53] + v_[271] * v_[7] + v_[250] * v_[213] + v_[250] * v_[213];
    v_[216] = 0 - v_[216] - v_[199];
    v_[216] =
        v_[340] * v_[94] + v_[262] * v_[158] + v_[188] * v_[53] + v_[271] * v_[213] + v_[216] * v_[7] + v_[216] * v_[7];
    v_[280] = v_[292] - v_[280] - v_[314] * -0.012652;
    v_[65] = (0 - v_[300]) * -0.008711861 + (0 - v_[21]) * 0.160298259823722 + v_[231] * -0.00021200017 +
             (0 - v_[65]) * -0.0022920002;
    hes[117] = (v_[269] + v_[56] * v_[54]) * v_[67] + (v_[204] * v_[77] + v_[272] * v_[76] + v_[82] * v_[53]) * v_[60] +
               (v_[248] + v_[204] * v_[78] + v_[272] * v_[81] + v_[82] * v_[60] + v_[237] * v_[54] + v_[5] * v_[53] +
                   v_[5] * v_[53]) *
                   v_[53] +
               (v_[269] * -0.184 + v_[250] * v_[77] + v_[216] * v_[76] + v_[56] * v_[67] + v_[237] * v_[53] +
                   v_[280] * v_[54] + v_[280] * v_[54]) *
                   v_[54] +
               v_[65] + v_[65];
    v_[65] = v_[247] * 1.547475 + v_[69] * -0.038686875;
    v_[280] = v_[208] * 1.547475 + v_[194] * 0.038686875;
    v_[90] = v_[90] * 1.547475;
    v_[247] = v_[247] * -0.038686875 + v_[194] * -0.000829 + v_[69] * 0.003227 + v_[259] * 0.000198;
    v_[5] = v_[194] * 1.5e-05 + v_[69] * 0.000198 + v_[259] * 0.010737;
    hes[118] = (v_[65] + v_[318] * 2.1032 + v_[87] * -0.057838) * (-v_[60]) +
               (v_[280] * v_[77] + v_[90] * v_[76] + v_[91] * 2.1032 + v_[314] * 0.057838) * v_[67] +
               (v_[208] * 0.038686875 + v_[194] * 0.009277 + v_[69] * -0.000829 + v_[259] * 1.5e-05 + v_[280] * v_[78] +
                   v_[90] * v_[81] + v_[91] * 0.057838 + v_[6] * -0.001243 + v_[314] * 0.029115 + v_[87] * -0.001387) *
                   (-v_[54]) +
               (v_[65] * -0.184 + v_[247] * v_[77] + v_[5] * v_[76] + v_[318] * -0.057838 + v_[6] * -0.012652 +
                   v_[314] * -0.001387 + v_[87] * 0.019432) *
                   v_[53] +
               v_[269] * 0.02075 + v_[250] * v_[86] + v_[216] * v_[77] +
               (0 - (v_[91] * 2.1032 + v_[314] * 0.057838)) * v_[67] +
               (0 - (v_[318] * -2.1032 + v_[87] * 0.057838)) * v_[60] +
               (v_[318] * 0.057838 + (0 - v_[6]) * -0.012652 + v_[314] * -0.001387 + v_[87] * -0.018069) * v_[53] +
               (v_[91] * 0.057838 + v_[6] * -0.001243 + (0 - v_[314]) * -0.008386 + (0 - v_[87]) * -0.001387) * v_[54];
    hes[119] = v_[280] * (-v_[98]) + v_[90] * v_[158] + v_[247] * (-v_[7]) + v_[5] * v_[213] + v_[248];
    v_[5] = w_in[6] * v_[4];
    v_[247] = w_in[7] * v_[20] + v_[5] * v_[19];
    v_[90] = w_in[7] * v_[11] + v_[5] * v_[10];
    v_[280] = v_[247] * v_[30] + v_[90] * v_[42];
    v_[248] = w_in[7] * v_[10] + v_[5] * v_[9];
    v_[5] = (w_in[7] * v_[38] + v_[5] * v_[18]) * -1 + v_[248] * -0.304;
    v_[247] = v_[247] * v_[28] + v_[90] * v_[43];
    v_[90] = w_in[9] + v_[90] * -1;
    v_[98] = w_in[8] + w_in[6] * v_[0];
    v_[158] = v_[98] * v_[31] + v_[248] * v_[28];
    v_[7] = v_[5] * v_[62] + v_[247] * v_[53] + v_[90] * v_[60] + v_[158] * v_[61];
    v_[213] = v_[90] * v_[53] + v_[158] * v_[52];
    v_[65] = v_[280] * v_[77] + v_[7] * v_[76] + v_[213] * v_[81];
    v_[216] = v_[65] * 1.547475;
    v_[7] = v_[280] * v_[79] + v_[7] * v_[77] + v_[213] * v_[78];
    v_[280] = w_in[11] + v_[213];
    v_[79] = v_[7] * -1.547475 - v_[280] * 0.038686875;
    v_[98] = w_in[10] + v_[98] * v_[28] + v_[248] * v_[30];
    v_[248] = v_[90] * v_[54] + v_[158] * v_[53];
    v_[78] = v_[98] * v_[86] + v_[248] * v_[77];
    v_[250] = v_[98] * v_[77] + v_[248] * v_[76];
    v_[7] = v_[7] * 0.038686875 + v_[280] * -0.00751 + (0 - v_[78]) * -0.000829 + v_[250] * 1.5e-05;
    v_[259] = (0 - v_[280]) * 0.000198;
    v_[65] = (0 - v_[65]) * 0.038686875 + v_[259] - (0 - v_[250]) * -0.000829;
    v_[259] = 0 - v_[259] - v_[78] * 1.5e-05;
    v_[213] = v_[213] * -0.012652 + (0 - v_[248]) * -0.001243;
    hes[130] = (v_[216] * v_[86] + v_[79] * v_[77]) * 0.02075 +
               (v_[216] * 0.02075 + v_[7] * v_[77] + v_[65] * v_[86] + v_[65] * v_[86]) * v_[86] +
               (v_[79] * 0.02075 + v_[7] * v_[86] + v_[259] * v_[77] + v_[259] * v_[77]) * v_[77] + v_[213] + v_[213];
    v_[248] =
        v_[5] * v_[53] + v_[247] * v_[52] + v_[90] * v_[67] + v_[158] * v_[68] + v_[98] * 0.02075 + v_[248] * -0.184;
    hes[131] =
        (v_[248] * -0.038686875 + v_[280] * -0.000829 + v_[78] * 0.003227 + v_[250] * 0.000198) * (-v_[77]) +
        (v_[280] * 1.5e-05 + v_[78] * 0.000198 + v_[250] * 0.010737) * v_[86] +
        ((0 - v_[280]) * 1.5e-05 + v_[78] * 0.000198 + v_[250] * 0.00605) * v_[86] +
        (v_[248] * 0.038686875 + v_[280] * -0.000829 + (0 - v_[78]) * -0.00146 + (0 - v_[250]) * 0.000198) * v_[77];
    v_[4] = w_in[6] * v_[4];
    v_[20] = w_in[7] * v_[20] + v_[4] * v_[19];
    v_[11] = w_in[7] * v_[11] + v_[4] * v_[10];
    v_[10] = w_in[7] * v_[10] + v_[4] * v_[9];
    v_[9] = w_in[9] + v_[11] * -1;
    v_[0] = w_in[8] + w_in[6] * v_[0];
    v_[31] = v_[0] * v_[31] + v_[10] * v_[28];
    v_[0] = w_in[10] + v_[0] * v_[28] + v_[10] * v_[30];
    v_[54] = v_[9] * v_[54] + v_[31] * v_[53];
    v_[54] = (0 - ((v_[20] * v_[30] + v_[11] * v_[42]) * v_[77] +
                      (((w_in[7] * v_[38] + v_[4] * v_[18]) * -1 + v_[10] * -0.304) * v_[62] +
                          (v_[20] * v_[28] + v_[11] * v_[43]) * v_[53] + v_[9] * v_[60] + v_[31] * v_[61]) *
                          v_[76] +
                      (v_[9] * v_[53] + v_[31] * v_[52]) * v_[81])) *
                 0.038686875 +
             (v_[0] * v_[86] + v_[54] * v_[77]) * 1.5e-05 + (0 - (v_[0] * v_[77] + v_[54] * v_[76])) * -0.000829;
    hes[143] = v_[54] + v_[54];
    // variable duplicates: 55
    hes[25] = hes[14];
    hes[37] = hes[15];
    hes[38] = hes[27];
    hes[49] = hes[16];
    hes[50] = hes[28];
    hes[51] = hes[40];
    hes[61] = hes[17];
    hes[62] = hes[29];
    hes[63] = hes[41];
    hes[64] = hes[53];
    hes[73] = hes[18];
    hes[74] = hes[30];
    hes[75] = hes[42];
    hes[76] = hes[54];
    hes[77] = hes[66];
    hes[85] = hes[19];
    hes[86] = hes[31];
    hes[87] = hes[43];
    hes[88] = hes[55];
    hes[89] = hes[67];
    hes[90] = hes[79];
    hes[97] = hes[20];
    hes[98] = hes[32];
    hes[99] = hes[44];
    hes[100] = hes[56];
    hes[101] = hes[68];
    hes[102] = hes[80];
    hes[103] = hes[92];
    hes[109] = hes[21];
    hes[110] = hes[33];
    hes[111] = hes[45];
    hes[112] = hes[57];
    hes[113] = hes[69];
    hes[114] = hes[81];
    hes[115] = hes[93];
    hes[116] = hes[105];
    hes[121] = hes[22];
    hes[122] = hes[34];
    hes[123] = hes[46];
    hes[124] = hes[58];
    hes[125] = hes[70];
    hes[126] = hes[82];
    hes[127] = hes[94];
    hes[128] = hes[106];
    hes[129] = hes[118];
    hes[133] = hes[23];
    hes[134] = hes[35];
    hes[135] = hes[47];
    hes[136] = hes[59];
    hes[137] = hes[71];
    hes[138] = hes[83];
    hes[139] = hes[95];
    hes[140] = hes[107];
    hes[141] = hes[119];
    hes[142] = hes[131];


    return hessian_;
}
}  // namespace HyA
}  // namespace models
}  // namespace ct
