/**********************************************************************************************************************
This file is part of the Control Toolbox (https://github.com/ethz-adrl/control-toolbox), copyright by ETH Zurich.
Licensed under the BSD-2 license (see LICENSE file in main directory)
**********************************************************************************************************************/

// clang-format off

#include "LINEAR_SYSTEM_NAME.h"

namespace ct {
namespace NS1 {
namespace NS2 {

const LINEAR_SYSTEM_NAME::state_matrix_t& LINEAR_SYSTEM_NAME::getDerivativeState(
    const state_vector_t& x,
    const control_vector_t& u,
    const int t)
{
    SCALAR* jac = dFdx_.data();
    Eigen::Matrix<SCALAR, STATE_DIM + CONTROL_DIM, 1> x_in;
    x_in << x, u;

    AUTOGENERATED_CODE_PLACEHOLDER_JAC_A

    return dFdx_;
}

} // namespace NS2
} // namespace NS1
} // namespace ct

// clang-format on
