# Awesome Touch Typing (on progress)


> An awesome & curated list of the best applications for learning and practicing touch typing.


![gif of touch typing](https://github.com/esteves-esta/awesome-touch-typing/blob/master/touchtyping.gif)

## Contents

- [Learning](#learning) 
  - [Online](#online)
  - [Software](software)
- [Practicing](#practicing)
  - [Games](#games)
  - [Typing Test](#typing-test)
  - [Typing Code](#typing-code)
- [Inspired by](#inspired-by)
- [Contribute](#contribute)
- [License](#license)



## Learning

### Online

**[typing.com](https://www.typing.com/) [ FREE ]**
Great set and number of lessons divided in 3 types: *Beginner, Intermediate and Advanced* with videos introducing tips or lessons about touch typing on each step of the course. Practice with interactive stories and also learn about the basics of the following: Tech, Carrer Prep, and Coding (HTML/CSS).

Languages available: ENG (US/UK) | ESP.
Keyboard Settings: Show/Hide Keyboard | Show/Hide Hands | Keyboard Layout Option.

Contains: **Lessons | Practice | Speed Test | Games | Statistics | Keyboard Settings | Theme change | Badges? | Problem Key Custom Lessons**.

---
**[Ratatype](https://www.ratatype.com/) [ FREEMIUM ]**
Lessons for begginers and lessong to get rid of spelling mistakes.
On mistakes it stop but you don't need to use backspace.
Functionality to create group and compete with friends.
Game mode is simple, just a packman character eating the letters. Limited acess per day.

Languages available: ENG (US/UK) | ESP | Portuguese (BR) | French | Russian | Ukrainian |Italian | German | Polish | Turkish | Dutch.
Keyboard Settings: No customizations.

Contains: **Lessons | | Games | Speed Statistic |**.

---

**[Typing Club](https://www.typingclub.com/) [ FREEMIUM ]**
Great lessons with 20 levels with 447 lessons with fun and interesing facts used in the practice of the lessons. There are games but some are just for the paid version. The *awesomeness* is also in the acessibility with the: voice over; subtitles on videos; one hand typing lessons; and the playback of your perfomance on the lesson.

Languages available: ENG | ESP | DEU | FRA | PT-PT | CHI | RUS | SLOV | ITA.
Keyboard Settings: Show/Hide Keyboard | Show/Hide Hands/Hand | Keyboard Layout Option.

Contains: **Lessons | Practice | Speed Test | Statistics | Block on errors | Speed of each word | Live wpm and accuracy | Theme change | Playback Performance | Acessibility (Font size, Type of Font, Voice over, Subtitles) |**.

---

**[Touch Typing Study](https://www.typingstudy.com/) [ FREE ]**
A simple website that contains 15 lessons each with 10 steps focusing in different sets of keys.

Languages available: Multiple languages.
Keyboard Settings: Keyboard Layout Option.

Contains: **| Lessons | Practice | Speed Test | Games | Statistics |**.

---

**[Keybr](https://www.keybr.com/) [ FREE ]**
A website that generates typings lessons matching your skills and putting emphasis on letter you have difficulty. It show the key that is being used in the lesson, and has good settings.

Contains: **Lessons | Statistics | Dark Mode | Font Size | 3 Layouts | Full Screen Mode | Multiplayer race**.

---

### Software 

**[TIPP 10](https://www.tipp10.com/) [ FREE ]**
TIPP10 is a free 10-finger touch typing tutor. You can use TIPP10 directly in your browser or you can download the software version for Windows, Mac OS and Linux. TIPP10 features a clear user interface and various settings and custom lessons.

Platforms supported: **Windows | Mac OS X | Linux**

Contains: **Lessons | Duration of Lesson | Keyboard Assistance | Caracter Limit | Typing Error Handling | Statistics | Error rate by finger | Keyboard Layout | Font Size and Color | Audio Outpout**.

---

## Practicing

### Games

**[ZTYPE](https://zty.pe/) [ FREE | Shooter ]**
The game allows you to practice with random words that grow in difficulty and also allows you to use the game with your own text or a website.

Practice with: **Random Words| Own Text**.

---

**[TYPR - typing races](http://app.typrx.com/#HomePlace:) [ FREE | race ]**
The game allows you to practice alone or to compete in a race with a set of different quotes. You can also compete in a private race. There is a ranking and a Hall of Fame and you can submit quotes.

Practice with: **Quotes**.

Contains: **Multiplayer | Chat**. 

---

**[Typing Karaoke](TypingKaraoke.com) [ FREE | For advance typists ]**
Is a very fun flash game with 10 songs with different levels of difficulty, while the song plays you have to type the line before the singer change to the next.
Practice with: **Music Lyrics**.

---

**[Epistory - Typing Chronicles](http://www.epistorygame.com/) [ PAID ]**
Great game where it slowly make battles with mosters harder with more complex words all at the same type, very good for practicing if you already know touch typing and very entertaning game, good art and nice choose of words and difficulty.

Platforms supported: **Windows | Mac | Linux**.

---

**[TypeTime](https://loanr.github.io/typetime) [ FREE ]**
A very fun touch typing game where you need to type the displayed word in a allocated time, there are levels and each level time is reduced and words are more difficult and unfrequent.

Practice with: **Random Words**.
Settings: **Choose difficulty | Modifiers | (Fun) Sound Cues**

### Typing Test

**[Mastering Typing ](https://www.masteringtyping.com/) [ FREE ]**
Simple practice with minimal layout. Good ability to make the test custom with lots of settings that can make your test more personalized to what you want to focus and get better. 

Practice with: **Random words | Own text | Code Snippets**.

Settings: **Just lowercase | Remove Punctuation | Show Keyboard | Show Hands | Sound | Distraction Free Mode | Multiple languages | Theme ( Dark | Brown | Default ( White/Blue ) ) | Many more**.

---

**[10 Fast Fingers](https://10fastfingers.com/) [ FREE ]**
This websites has typing test in multiple languages of 1 minute with random words. There is the ability to make a custom test with your own text/words and with different duration. There is a multiplayer typing test and a typing competiton where you can enter on a game or make a private test/game to play with your friends.

Practice with: **Random words ( 200 / 1000 ) | Custom Test**.

Contains: **Multiple Languages | Multiplayer**.

Settings: **Custom test ( duration / wordlist )**.

---

**[TypeFast.io](https://typefast.io/) [ FREE ]**
Simple practice with minimal layout in only dark mode and ability to practice in the korean keyboard with hangul. 

Practice with: **Sentences | Paragraph**.

Contains: **English | Korean**.

Settings: **Duration of Test | Pangram **.

---


**[typing.works](https://typing.works/) [ FREE ]**
Simple practice with minimal layout. User can customize a lot of the visual part of the text. 

Practice with: **Sentences | Words**.

Contains: **English | Korean**.

Settings: **Just lowercase | | Theme ( Dark | Light ) | Text size | Text Weight | Only one font | Scrolling**.

---


**[new typing.works](https://new.typing.works/) [ FREE ]**
Simple practice with minimal layout. Good ability to make the test custom with lots of settings that can make your test more personalized to what you want to focus and get better. 

Practice with: **Sentences | Words**.

Settings: **Just lowercase | Remove Punctuation | Multiple languages | Theme ( Dark | Light ) | Text size | Scrolling**.

---

**[TypeLit.io](https://www.typelit.io/) [ FREE ]**
Test your typing online by practicing on your favorite literature. Choose a book below to get started, or subscribe and import your own!

Practice with: **Sentences**.

Contains: **Various**.

Settings: **Theme | Fonts | Virtual Keyboard | Ignore Capitalization | Skip Punctuation | Cursor Styles | Show Mistypes | Auto Scroll**.

---

**[Ngram Type](https://ranelpadon.github.io/ngram-type/) [ FREE ]**
Ngram refers to sequence/grouping of characters, and they're usually ranked to describe the common ones. Historically, ngrams are used in Crytography to decrypt messages. Nowadays, they have many applications, for classifying spam messages, as auto-completion or spell-checking tool, etc. Technically, Ngrams are words also, and vice versa. The better you're able to type these sequences of characters, the faster you'll be able to type in general.

Practice with: **Ngrams Types**.

Contains: **English**.

Settings: **Generator**.

---


**[Monkeytype](https://monkeytype.com/about) [ FREE ]**
Monkeytype is a minimalistic and customizable typing test. It features many test modes, an account system to save your typing speed history, and user-configurable features such as themes, sounds, a smooth caret, and more. Monkeytype attempts to emulate the experience of natural keyboard typing during a typing test, by unobtrusively presenting the text prompts and displaying typed characters in-place, providing straightforward, real-time feedback on typos, speed, and accuracy

Practice with: **Ngrams Types**.

Contains: **Various**.

Settings: **themes | font settings | Test difficulty | quick restart | blid mode | min speed | min accuracy | min burst | sounds | cursor style**.

---

### Typing Code

**[typing.io](https://typing.io/) [ FREEMIUM]**
In the free version it has lessons with open source code that allow you to practice real code in different programing languages. In the paid version you can make a custom practice, change color and have keyboard and hand settings and statistics.

Practice with: **Code in 16 Programming Languages**.

---

## Inspired by

Inspire by the **Awesome List** here on github and by the article [Teach yourself Touch Typing with Free Tools](https://www.labnol.org/internet/teach-yourself-touch-typing-with-free-tools/28849/) by Amit Agarwal. 



## Contribute

Contributions are most welcome! Please read and adhere to the [contribution guidelines](contributing.md) first.

**[⬆ back to top](#awesome-touch-typing)**

## License

[![CC0](https://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0)

To the extent possible under law, esteves-esta has waived all copyright and
related or neighboring rights to this work.
