## Module Description

This module handles the `push_notification` hook generated by `mod_pubsub` with an active `push` node.
Each `push_notification` hook is converted as a `REST` API call to the [MongoosePush](https://github.com/esl/MongoosePush) service.
You can find the full list of supported `publish-options` [here](../tutorials/push-notifications/Push-notifications-client-side.md#publish-options).

!!! warning
    This module does not support [dynamic domains](../configuration/general.md#generalhost_types).

### Prerequisites

This module uses a connection pool via `mongoose_http_client`.
It must be defined in [outgoing_pools setting](../configuration/outgoing-connections.md#http-options).

## Options

### `modules.mod_push_service_mongoosepush.pool_name`
* **Syntax:** non-empty string
* **Default:** `"undefined"`
* **Example:** `pool_name = "mongoose_push_http"`

The name of the pool to use (as defined in [`outgoing_pools`](../configuration/outgoing-connections.md)).

### `modules.mod_push_service_mongoosepush.api_version`
* **Syntax:** string, `"v2"` or `"v3"`
* **Default:** `"v3"`
* **Example:** `api_version = "v3"`

REST API version to be used.

### `modules.mod_push_service_mongoosepush.max_http_connections`
* **Syntax:** non-negative integer
* **Default:** `100`
* **Example:** `max_http_connections = 100`

The maximum amount of concurrent HTTP connections.

## Example configuration

```toml
[outgoing_pools.http.mongoose_push_http]
  scope = "global"
  workers = 50

  [outgoing_pools.http.mongoose_push_http.connection]
    host = "https://localhost:8443"
    path_prefix = "/"
    request_timeout = 2000

[modules.mod_push_service_mongoosepush]
  pool_name = "mongoose_push_http"
  api_version = "v3"
  max_http_connections = 100
```
