## Hooks

Hook names have been unified by removing the `_hook` suffix from the few hooks which used it,
e.g. `offline_message_hook` is now called `offline_message`. This change affects the hook metric names as well.

Some hooks have been removed:

 - `xmpp_stanza_dropped`,
 - `privacy_list_push`,
 - `xmpp_bounce_message`,
 - `mam_flush_messages`,
 - `mam_muc_flush_messages`.

## Listener configuration

`listen.c2s.c2s_state_timeout` option has been renamed to [listen.c2s.state_timeout](../listeners/listen-c2s.md#listenc2sstate_timeout).

## Metrics and instrumentation

Metrics implementation has been reworked, and now a Prometheus endpoint is available.
For more details, see [the instrumentation documentation](../configuration/instrumentation.md).
This requires some changes to the configuration file, which are described in the following sections.

### New `[instrumentation]` section

To have metrics available in MongooseIM, an [`[instrumentation]` section](../configuration/instrumentation.md)  is now **required**.

### `general` section

`general.all_metrics_are_global` has been replaced by [`instrumentation.exometer.all_metrics_are_global`](../configuration/instrumentation.md#instrumentationexometerall_metrics_are_global).
This option has no effect when using Prometheus, and should be removed from the config file in this case.

### Exometer configuration changes

Exometer is no longer configured through [`app.config`](../configuration/configuration-files.md#appconfig), but through [`mongooseim.toml`](../configuration/configuration-files.md#mongooseimtoml).

Example configuration that is equivalent to the old example configuration provided in `app.config`:
```toml
[[instrumentation.exometer.report.graphite]]
  host = "127.0.0.1"
  port = 2003
  api_key = ""
  interval = 60000
  prefix = "mongooseim"
  connect_timeout = 5000
```

See [Exometer configuration doc](../configuration/instrumentation.md#exometer-options) for more information.

### New Prometheus endpoint

Alternatively to Exometer, MongooseIM can now expose an endpoint serving Prometheus metrics.
The Prometheus metrics provide labels, for example `host_type`.
Because of this, the names of the metrics are usually shorter than the Exometer ones.

The simplest configuration to have it available on port `9090` on the `/metrcis` path is:

 - Add `prometheus` handler to the `instrumentation` section:
    ```toml
    [instrumentation.prometheus]
    ```
 - Configure Prometheus HTTP handler in the `listen` section:
    ```toml
    [[listen.http]]
      port = 9090

      [[listen.http.handlers.mongoose_prometheus_handler]]
        host = "_"
        path = "/metrics"
    ```

See [instrumentation configuration doc](../configuration/instrumentation.md) and [Prometheus endpoint configuration doc](../listeners/listen-http.md#handler-types-prometheus-mongoose_prometheus_handler) for more information.

### Hook metrics

Hook metrics that have been removed:

 - `mam_flush_messages`,
 - `privacy_list_push`,
 - `xmpp_bounce_message`.

All the remaining hook metrics now have the `hook_` prefix.

### Other metric changes

Several metrics have had their names changed. The new metric names have been documented in module documentation pages.

## Upgrade procedure

In order to have metrics available in MongooseIM, perform the following steps.
Stop the cluster, or individual nodes, if performing a rolling upgrade, and execute the configuration changes, that were described above:

=== "Keep Exometer metrics"

    1. Add an `[instrumentation]` section.
    2. Replace the `general.all_metrics_are_global` option with [`instrumentation.exometer.all_metrics_are_global`](../configuration/instrumentation.md#instrumentationexometerall_metrics_are_global).
    3. Configure [Exometer exporters](../configuration/instrumentation.md#exometer-options) in the `instrumentation` section.
    4. Note that many metrics have new names, and [some have been removed](#hook-metrics).

=== "Move to Prometheus metrics"

    1. Add an `[instrumentation]` section.
    2. Remove the `general.all_metrics_are_global` option.
    3. Add Prometheus to the [instrumentation section](../configuration/instrumentation.md).
    4. Configure a [listener](../listeners/listen-http.md#handler-types-prometheus-mongoose_prometheus_handler) for Prometheus.

Restart the node or cluster.

## Support for the new RDBMS database - CockroachDB

We've introduced support for a new RDBMS database, CockroachDB.

To configure CockroachDB, update the connection settings in your configuration file as follows:
```toml
[outgoing_pools.rdbms.default.connection]
  driver = "cockroachdb"
  host = "localhost"
  port = 26257
  database = "mongooseim"
  username = "mongooseim"
  password = "mongooseim_secret"
```

Refer to the [Outgoing connections configuration doc](../configuration/outgoing-connections.md) for more information.
