## Database migration

The migration scripts for PostgreSQL, MySQL and MS SQL are in the [`priv/migrations`](https://github.com/esl/MongooseIM/tree/master/priv/migrations) directory. They are required due to the following changes:

### MAM message improvements

There is a new column in the `mam_message` table, which is used to support including or excluding groupchat results in a user archive ([`mod_mam`](../modules/mod_mam.md)). Please be aware, that the filtering process will only be effective for new messages and will not apply to those messages that have already been stored in the database.

### Roster

[`mod_roster`](../modules/mod_roster.md) was internally refactored to modernise and improve the performance of the code, but as a side-effect, some database migrations need to be carried.

### CETS node discovery

The `discovery_nodes` table used by the CETS [internal database](http://localhost:8000/MongooseDocs/latest/configuration/internal-databases/) has been updated - now each node name can appear only once, while in the past a node could be a part of multiple clusters. Manual intervention might be needed if there are nodes that belong to more than one cluster.

### Entity capabilities

[`mod_caps`](../modules/mod_caps.md) has a new RDBMS backend, making it possible to use it with CETS. As a result, a new table `caps` is added to the DB schema.

## Configuration changes: outgoing pools

The outgoing connections option `host` is now named `host_type`, see [outgoing pools](../configuration/outgoing-connections.md) for more information.

The option `single_host` for the scope has been deprecated, in favour of configuring the specified pools within the [`host_config`](../configuration/host_config.md) section.

## Functional changes: presences

[`mod_presence`](../modules/mod_presence.md) was internally refactored to modernise and improve the performance of the code, but as a side-effect, code for [XEP-0018](https://xmpp.org/extensions/xep-0018.html) was removed. Note that this XEP was not advertised and as a matter of fact was deprecated already in 2003, so if your client was depending on it, it is high time to update.

## Upgrade procedure

The standard migration procedure is to stop the cluster, apply the DB migrations, and start the new version of the cluster.

Should you require no downtime, you could apply the DB migration first, and then perform the rolling upgrade procedure - either manually or using `helm` or `kubectl`. If you are using CETS, the restarted nodes will stay disconnected from the ones still running the previous version, causing transient connectivity issues between the end users connected to different parts of the cluster. This is due to changes in the internal CETS API.
