## Internal databases

So far MongooseIM has been using the internal Mnesia database to replicate the in-memory data between cluster nodes.
Now there is an option to use [CETS](https://github.com/esl/cets/) instead.
Mnesia is still used by default, so you don't need to change your configuration file.
If you want to switch to CETS, see the [tutorial](../tutorials/CETS-configure.md) and the reference for [`internal_databases`](../configuration/internal-databases.md).

## Database migration

There is a new table `discovery_nodes` in the database, which is used by CETS for dynamic discovery of cluster nodes. See the migrations for Postgres, MySQL and MSSQL in the [`priv/migrations`](https://github.com/esl/MongooseIM/tree/master/priv/migrations) directory. Although the new table is only needed by CETS, we recommend applying the migration anyway to keep the database in sync with the latest schema.

## Validation of TLS options

Erlang/OTP 26 has more strict checking of the TLS options, as described in [release highlights](https://www.erlang.org/blog/otp-26-highlights/#ssl-improved-checking-of-options).
MongooseIM follows the same rules now, preventing runtime crashes if TLS is misconfigured.

By default `verify_mode` is set to `"peer"` for each `tls` section in the configuration, and this requires `cacertfile` - otherwise the server will refuse to start. This was already documented, but not enforced. The option `"selfsigned_peer"` also requires `cacertfile` now.

This change affects the following configuration sections:

* [Listeners](../configuration/listen.md). Currently, it only affects [`http`](../listeners/listen-http.md#http-based-services-listenhttp) and [`c2s`](../listeners/listen-c2s.md#client-to-server-c2s-listenc2s) with [`tls.module`](../listeners/listen-c2s.md#listenc2stlsmodule) set to `"just_tls"`, but we recommend fixing it for all listeners already, because in future releases all listeners would have this validation.
* [Outgoing connections](../configuration/outgoing-connections.md).

For each of the affected sections, if there is any `tls` option present, **make sure** that either `tls.cacertfile` is provided or `tls.verify_mode` is set to `"none"`.

## Transition to New CLI Commands

Legacy CLI commands previously marked as deprecated have now been removed. The users are encouraged to explore the new GraphQL-based CLI. It is recommended to transition to the new CLI commands **prior to the next system upgrade**. The configuration options `general.mongooseimctl_access_commands` and `services.service_admin_extra` related to the legacy CLI were also removed. **You need to remove them** from your configuration file unless you have already done so.

## Removed support for Riak

The deprecated and obsolete Riak database is not supported anymore, and you cannot configure it in the [`outgoing_pools`](../configuration/outgoing-connections.md) section.
