## Listener configuration

With the new implementation of the client-to-server (C2S) state machine, `mongoose_c2s`, there are some changes in the listener options:

* The `zlib` option for supporting [stream compression](https://xmpp.org/extensions/xep-0138.html), which was present in the default configuration file, is removed, and **you need to delete it** from your listener configuration unless you have already done so. The extension is [obsolete due to security vulnerability](https://xmpp.org/extensions/xep-0138.html#revision-history-v2.1), and the [CRIME](https://en.wikipedia.org/wiki/CRIME) vulnerability has been found [a long time ago](https://blog.thijsalkema.de/blog/2014/08/07/https-attacks-and-xmpp-2-crime-and-breach/).
* Support for [`listen.http.handlers.mod_websockets.service`] has been removed, the component connection over WebSockets did not correspond to any XEP/RFC, and neither it was properly described anywhere in the MIM documentation. It was present in the default configuration file, and **you need to delete it** from your listener configuration unless you have already done so.
* The `max_fsm_queue` option is no longer supported for C2S listeners. It is incompatible with the new `gen_statem` state machine, and if you need to limit incoming traffic, you should use [traffic shapers](../configuration/shaper.md) instead. You need to remove this option from your C2S configuration if you are using it.
* The default value of the [`backlog`](../configuration/listen.md#listenbacklog) option for all XMPP listeners has been increased from 100 to 1024 for performance reasons.
* You might be interested in the new C2S listener options: [`max_connections`](../listeners/listen-c2s.md#listenc2smax_connections), [`c2s_state_timeout`](../listeners/listen-c2s.md#listenc2sstate_timeout), [`reuse_port`](../listeners/listen-c2s.md#listenc2sreuse_port) and [`backwards_compatible_session`](../listeners/listen-c2s.md#listenc2sbackwards_compatible_session). The first two options can be set for [websockets](../listeners/listen-http.md#handler-types-websockets-mod_websockets) as well.

## Module configuration

The `mongoose_c2s` module, which provides the core XMPP features, is now separated from modules which used to have their parts hardcoded into the old C2S implementation:

* Presence handling has been exported to a separate module [`mod_presence`](../modules/mod_presence.md), which is enabled in the default configuration file. **Enable `mod_presence` in your configuration file** unless you are sure that you don't need server-side presence handling, in which case you could gain some performance by not using this module.
* Stream management is now handled completely by [`mod_stream_management`](../modules/mod_stream_management.md), and if you don't need it, you can now gain more performance than before by disabling it.
* Client state indication is now handled completely by [`mod_csi`](../modules/mod_csi.md), and if you don't need it, you can now gain more performance than before by disabling it.

## Database migration

There is no database migration required when upgrading from version `6.0.0` to `6.1.0`.

## Metrics

The `c2s_unauthenticated_iq` metric has been removed.

Since we don't know whether a compressed/encrypted packet contains a single stanza or a batch, calculation of histogram metrics for compressed and encrypted streams is inaccurate. The following histogram metrics have been removed:
    * `global.data.xmpp.received.compressed_size` - obsolete, `stream compression` support is removed.
    * `global.data.xmpp.sent.compressed_size` - obsolete, `stream compression` support is removed.
    * `global.data.xmpp.received.encrypted_size` - impractical, has no value but consumes calculation resources.
    * `global.data.xmpp.sent.encrypted_size` - impractical, has no value but consumes calculation resources.

A set of `global.data.xmpp.received.**` and `global.data.xmpp.sent.**` spiral [data metrics](../operation-and-maintenance/MongooseIM-metrics.md#data-metrics) has been introduced instead.

## Hooks

Multiple hooks have been added, removed or changed because of the introduction of `mongoose_c2s` - the most important change is the increased granularity of the `user_send_*` and `user_receive_*` hooks. If you have some custom modules (e.g. that implement some XMPP extensions) using the hooks mechanism, please refactor your handlers to be compliant with the new hooks. Refer to [Hooks Description](../developers-guide/hooks_description.md) and [Message routing](../developers-guide/Stanza-routing.md) for more details.

## Upgrade procedure

As long as you are not using Mnesia for persistent storage (it is not recommended to do so), the safest option would be to prepare a new cluster with version 6.1.0, and switch the traffic to it on a load balancer. The only downside is that clients connected to different clusters would see each other as offline. If you are limited to one cluster, it is recommended to do a split-cluster rolling upgrade by [removing](../operation-and-maintenance/Cluster-configuration-and-node-management.md#leaving-cluster) each node from the cluster before stopping and upgrading it, and gradually forming a **new separate cluster** from the upgraded nodes. This means that for each newly started node except the first one, you should [join](../operation-and-maintenance/Cluster-configuration-and-node-management.md#new-node-joining-cluster) one of the previously started nodes.

### Rolling upgrade issues

If you want to perform a typical [rolling upgrade](../operation-and-maintenance/Rolling-upgrade.md) instead, there are a few potential issues caused by the introduction of `mongoose_c2s`. When a node is stopped, upgraded and started again, it reconnects to the cluster. When a stanza is routed between users connected to different nodes of the cluster, an internal message is sent between the nodes. In version 6.1.0 that message has a different format, and routing a stanza between nodes with versions 6.0.0 and 6.1.0 would fail, resulting in a warning message for each stanza. This means that after upgrading the first node you might get a huge amount of warning messages on all nodes, causing a performance drop. What is more, the sender's node would still assume that the recipient is online, and some actions (e.g. responding with the `service-unavailable` error) would be omitted.

!!! Info "Changing the log level"
    You can set the log level to `error` during the upgrade to silence the excess warnings.
    Before the upgrade, set the log level on all nodes:
    ```bash
    mongooseimctl server setLoglevel --level ERROR
    ```
    Before starting the upgraded node, set the [`loglevel`](../configuration/general.md#generalloglevel) option to `error` in the configuration file.
    After the whole upgrade procedure, use `mongooseimctl` to change the log level back to the previous value (`warning` by default).
    Change the values in the configuration files as well to make the setting permanent.
