## Module configuration

* The `mod_mam_meta` module is now named `mod_mam` for simplicity, so if you are using this module, you need to update the module name in `mongooseim.toml`.
* `mod_commands`, `mod_inbox_commands`, `mod_muc_commands` and `mod_muc_light_commands` are removed. Their functionality is now fully covered by [`mongoose_admin_api`](../listeners/listen-http.md/#handler-types-rest-api-admin-mongoose_admin_api). You need to delete these modules from `mongooseim.toml`.

## Metrics

The `mod_mam` backend module is now named `mod_mam_pm` for consistency with `mod_mam_muc`. As a result, the backend metrics have updated names, i.e. each `[backends, mod_mam, Metric]` name is changed to `[backends, mod_mam_pm, Metric]`, where `Metric` can be `lookup` or `archive`.

## REST API

The whole REST API has been unified and simplified. There are now only two REST API handlers that you can configure in the `listen` section of `mongooseim.toml`:

- [`mongoose_admin_api`](../listeners/listen-http.md/#handler-types-rest-api-admin-mongoose_admin_api) handles the administrative API,
- [`mongoose_client_api`](../listeners/listen-http.md/#handler-types-rest-api-client-mongoose_client_api) handles the client-facing API.

You need to remove the references to the obsolete handlers (`mongoose_api_client`, `mongoose_api_admin`, `mongoose_api`, `mongoose_domain_handler`) from your configuration file.

Additionally, all the backend administration endpoints for `mod_muc_light` require now `XMPPMUCHost` (MUC subdomain) instead of `XMPPHost` (domain) and `roomID` instead of `roomName`.

For some endpoints, the response messages may be slightly different because of the unification with other APIs.

## Command Line Interface

For some commands, the response messages may be slightly different because of the unification with other APIs.

## Dynamic domains

Removing a domain was a potentially troublesome operation: if the removal was to fail midway through the process, retrials wouldn't be accepted. This is fixed now, by first disabling and marking a domain for removal, then running all the handlers, and only on full success will the domain be removed. So if any failure is notified, the whole operation can be retried again.

The database requires a migration, as the status of a domain takes now more than the two values a boolean allows, moreover the table for data of the domain admin has been added. See the migrations for Postgres, MySQL and MSSQL in the [`priv/migrations`](https://github.com/esl/MongooseIM/tree/master/priv/migrations) directory.

## Hooks

Support for `ejabberd_hooks` has been removed.
Now handlers should be compliant with `gen_hook`.
If you have some custom modules (e.g. that implement some XMPP extensions) and use hooks mechanism, please refactor your handlers to be compliant with it.
For more details refer to [`Hooks and Handlers`](../developers-guide/Hooks-and-handlers.md) chapter.
