## Configuration changes

The configuration format has slightly changed and you might need to amend `mongooseim.toml`.

### Section `listen`

The options `tls.verify_peer` and `tls.verify_mode` are replaced with just [`tls.verify_mode`](../listeners/listen-c2s.md#listenc2stlsverify_mode). You need to amend the affected options for each listener:

* `verify_peer = false` (the old default for C2S and HTTP listeners) should be replaced with `verify_mode = "none"`.
* `verify_peer = true` should be replaced with `verify_mode = "peer"` or just removed, as this is the new default.

There is a new, simplified configuration format for `mongoose_client_api`. You need to change the `listen` section unless you have disabled the client API in your configuration file. Consult the [option description](../listeners/listen-http.md#handler-types-rest-api-client-mongoose_client_api) and the [example configuration](../listeners/listen-http.md#example-6-client-rest-api) for details.

### Section `acl`

The implicit check for user's domain in patterns is now configurable and the default behaviour (previously undocumented) is more consistent - the check is always performed unless disabled with `match = "all"`.
See the description of [`current_domain`](../configuration/acl.md#aclmatch) for more details.

### Section `auth`

* Each authentication method needs a TOML section, e.g. if you have the `rdbms` method enabled, you need to have the `[auth.rdbms]` section in the configuration file, even if it is empty. The `methods` option is not required anymore and especially if you are using only one method, you can remove it.
* The `auth.scram_iterations` option was moved to [`auth.password.scram_iterations`](../configuration/auth.md#authpasswordscram_iterations).

See the [auth configuration](../configuration/auth.md) for details.

### Section `outgoing_pools`

The option `tls.verify_peer` is replaced with [`tls.verify_mode`](../configuration/outgoing-connections.md#outgoing_poolsconnectiontlsverify_mode). You need to change this option for each outgoing connection pool:

* `verify_peer = false` (the old default for all pools except Riak) should be replaced with `verify_mode = "none"`.
* `verify_peer = true` should be replaced with `verify_mode = "peer"` or just removed, as this is the new default.

A few options of the outgoing connection pools were changed for consistency:

* [Cassandra servers](../configuration/outgoing-connections.md#outgoing_poolscassandraconnectionservers): `ip_address` was renamed to `host`,
* [RabbitMQ](../configuration/outgoing-connections.md#rabbitmq-options): the `amqp_` option prefix was removed,
* [LDAP](../configuration/outgoing-connections.md#ldap-options): `rootdn` was renamed to `root_dn`;
`encrypt` was removed (the `tls` option should be used instead).

### Section `s2s`

* All options can be set globally or inside `host_config`.
* The `host_config.s2s` section overrides the whole global section now. Previously only the specified options were overridden.
* The `domain_certfile` option has been moved to the `general` section because it affects `c2s` connections as well.

### Section `host_config`

The rules for overriding global options in the `host_config` section have been simplified. The `auth` section and the `s2s.address` and `s2s.host_policy` options now completely override the corresponding general settings instead of being merged with them.

### Extension modules

* `mod_auth_token` has a new configuration format - if you are using this module, amend the [`validity_period`](../modules/mod_auth_token.md#modulesmod_auth_tokenvalidity_period) option.
* `mod_event_pusher` has an updated configuration format - the `backend` subsection is removed and the `http` backend has a new `handlers` option. Adjust your configuration according to [`mod_event_pusher`](../modules/mod_event_pusher.md) documentation.
* `mod_mam_meta` does not have the `rdbms_message_format` and `simple` options anymore. Use [`db_jid_format`](../modules/mod_mam.md#modulesmod_mamdb_jid_format) and [`db_message_format`](../modules/mod_mam.md#modulesmod_mamdb_message_format) instead. (note: the module is called `mod_mam` in the most recent versions).
* `mod_shared_roster_ldap` all options have their `ldap_` prefix dropped.
* `mod_vcard` LDAP options are moved into an LDAP subsection.

## Async workers

The `async_writer` flag of MAM is now a section on its own, that absorbs previous flags related to it: `flush_interval`, `max_batch_size` and `pool_size` now become subelements of the `async_writer` section, with one more parameter, `enabled`. Below an example:

```toml
[modules.mod_mam_meta]
  flush_interval = 1000
  max_batch_size = 100
  muc.async_writer = false
```
now becomes
```toml
[modules.mod_mam_meta]
  async_writer.flush_interval = 1000
  async_writer.batch_size = 100
  muc.async_writer.enabled = false
```

## Smart markers
There's an experimental and undocumented module called `mod_smart_markers`, that had a default table in the RDBMS schema, which you probably never used (or shouldn't have, as it was undocumented). If you rely on this table, the column `from_jid` has been split in `from_luser` and `lserver`, in order to support the `remove_domain` callback for the dynamic domains functionality. You might need to migrate it, or simply drop the previously defined table and recreate the new one.

## Inbox
The archive functionality recently introduced has been extended to support many more boxes. IQ queries can remain as they were, but, a new flag called `box` is now introduced, and if provided, it takes preference over the old `archive` flag. The database requires a migration, as the archive is now a column storing the proper name of the box, see the migrations for Postgres, MySQL and MSSQL in the [`priv/migrations`](https://github.com/esl/MongooseIM/tree/master/priv/migrations) directory.

## Removal of deprecated modules
* `mod_revproxy` - removed from the code base as it was unsupported since 4.2.0.
* `mod_aws_sns` - its functionality is fully covered by [`mod_event_pusher`](../modules/mod_event_pusher.md).

## Internal module configuration rework
If you are using your own extension modules (or services), you need to update the code. The most important change is that configuration options were stored in proplists before, and now they are stored in maps, so e.g. the `start/2` function of your module should expect a map as the second argument.
