## DB migrations

The migrations scripts for Postgres, MySQL, MSSQL can be found in the [`priv/migrations`](https://github.com/esl/MongooseIM/tree/master/priv/migrations) directory. Please remember to provide the existing server domain for the `server` column instead of the localhost.

### Changes in XEPs:

- `mod_last`
    - Table `last` - added server column, updated primary key and indexes.
- `mod_privacy`
    - Table `privacy_default_list` - added server column, updated primary key and indexes.
    - Table `privacy_list` - added server column, updated primary key and indexes.
- `mod_private`
    - Table `private_storage` - added server column, updated primary key and indexes, removed unused columns.
- `mod_roster`
    - Table `rosterusers` - added server column, updated indexes.
    - Table `rostergroups` - added server column, updated indexes.
    - Table `roster_version` - added server column, updated primary key and indexes.
- `mod_muc` 
    - Table `i_muc_light_blocking` - updated indexes.
- `mod_inbox`
    - Table `inbox` - updated primary key and indexes.

### Other changes:
- RDBMS auth - modified `users` table.
- Added `domain_settings` table.
- Added `domain_events` table.

## Config migrations

Most important changes without which a server might not run.

### Section general

- New mandatory option `default_server_domain` that must be set. This domain is used as a default when one cannot be determined, for example when sending XMPP stream errors to unauthenticated clients.
- Option `hosts` is no longer mandatory, but if omitted, at least one host type has to be defined.
- New option `host_types`. If omitted, at least one host has to be defined. This is the list of names for the types of hosts that will serve dynamic XMPP domains.

Simply use `hosts` if you want to stay with static domains and use `host_types` for dynamic domains.

### Section host_config

- Option `host` specifies the XMPP domain that this section refers to.
- New option `host_type` specifies the host type that this section refers to. Either this option or `host` is mandatory.

For every configured `host` the `host_type` of the same name is declared automatically. As `host_config` section is now used for changing configuration of the `host_type`, we don't need `host` option any more. But to stay compatible with an old config format we keep `host` option as well. Now it is just a synonym to host type.

## Hook migrations

The support for dynamic domains has resulted in changes in most Hooks. Mostly these changes concern calling hooks for a `host_type`.

### Added
- `adhoc_local_commands/4`
- `adhoc_sm_commands/4`
- `does_user_exist/3`
- `get_room_affiliations/2`
- `mam_get_behaviour/4`
- `mam_set_prefs/6`
- `disco_muc_features/1`
- `remove_domain/2`
- `node_cleanup/1`
- `gen_mod:get_module_opt_by_subhost`

### Removed
- `host_config_update/4`
- `local_send_to_resource_hook/5`
- `muc_room_pid/3`
- `amp_check_packet/4`
- `amp_error_action_triggered/2`
- `amp_notify_action_triggered/2`
- `room_send_packet/3`
- `caps_update/6`
- `caps_add/6`

### Changed
- `auth_failed/2` -> `auth_failed/3`
- `failed_to_store_message/2` -> `failed_to_store_message/1`
- `filter_local_packet/2` -> `filter_local_packet/1`
- `get_key/3` -> `get_key/2`
- `register_command/2` -> `register_command/1`
- `register_subhost/3` -> `register_subhost/2`
- `resend_offline_messages_hook/3` -> `resend_offline_messages_hook/2`
- `rest_user_send_packet/5` -> `rest_user_send_packet/4`
- `set_vcard/4` -> `set_vcard/3`
- `unregister_command/2` -> `unregister_command/1`
- `unregister_subhost/2` -> `unregister_subhost/1`
- `user_ping_timeout/3` -> `user_ping_timeout/2`
- `user_send_packet/5` -> `user_send_packet/4`
- `xmpp_stanza_dropped/5` -> `xmpp_stanza_dropped/4`
- `c2s_broadcast_recipients/6` -> `c2s_broadcast_recipients/4`
- `c2s_filter_packet/6` -> `c2s_filter_packet/4`
- `c2s_presence_in/5` -> `c2s_presence_in/4`
- `check_bl_c2s/2` -> `check_bl_c2s/1`
- `session_opening_allowed_for_user/3` -> `session_opening_allowed_for_user/2`
- `privacy_check_packet/6` -> `privacy_check_packet/5`
- `privacy_get_user_list/3` -> `privacy_get_user_list/2`
- `privacy_updated_list/4` -> `privacy_updated_list/3`
- `offline_groupchat_message_hook/5` -> `offline_groupchat_message_hook/4`
- `offline_message_hook/5` -> `offline_message_hook/4`
- `set_presence_hook/5` -> `set_presence_hook/3`
- `sm_broadcast/6` -> `sm_broadcast/5`
- `sm_filter_offline_message/5` -> `sm_filter_offline_message/4`
- `sm_remove_connection_hook/6` -> `sm_remove_connection_hook/5`
- `unset_presence_hook/5` -> `unset_presence_hook/3`
- `xmpp_bounce_message/2` -> `xmpp_bounce_message/1`
- `roster_get/3` -> `roster_get/2`
- `roster_get_jid_info/4` -> `roster_get_jid_info/3`
- `roster_get_versioning_feature/2` -> `roster_get_versioning_feature/1`
- `roster_groups/2` -> `roster_groups/1`
- `roster_in_subscription/6` -> `roster_in_subscription/5`
- `roster_out_subscription/5` -> `roster_out_subscription/4`
- `roster_process_item/2` -> `roster_process_item/3`
- `roster_push/4` -> `roster_push/3`
- `roster_set/5` -> `roster_set/4`
- `is_muc_room_owner/4` -> `is_muc_room_owner/3`
- `can_access_identity/4` -> `can_access_identity/3`
- `can_access_room/4` -> `can_access_room/3`
- `mam_archive_id/3` -> `mam_archive_id/2`
- `mam_archive_size/4` -> `mam_archive_size/3`
- `mam_get_behaviour/5` -> `mam_get_behaviour/4`
- `mam_set_prefs/7` -> `mam_set_prefs/6`
- `mam_remove_archive/4` -> `mam_remove_archive/3`
- `mam_lookup_messages/3` -> `mam_lookup_messages/2`
- `mam_archive_message/3` -> `mam_archive_message/2`
- `mam_muc_archive_id/3` -> `mam_muc_archive_id/2`
- `mam_muc_archive_size/4` -> `mam_muc_archive_size/3`
- `mam_muc_get_behaviour/5` -> `mam_muc_get_behaviour/4`
- `mam_muc_set_prefs/7` -> `mam_muc_set_prefs/6`
- `mam_muc_remove_archive/4` -> `mam_muc_remove_archive/3`
- `mam_muc_lookup_messages/3` -> `mam_muc_lookup_messages/2`
- `mam_muc_archive_message/3` -> `mam_muc_archive_message/2`
- `mam_muc_flush_messages/3` -> `mam_muc_flush_messages/2`
- `get_mam_pm_gdpr_data/3` -> `get_mam_pm_gdpr_data/2`
- `get_mam_muc_gdpr_data/3` -> `get_mam_muc_gdpr_data/2`
- `get_personal_data/3` -> `get_personal_data/2`
- `find_s2s_bridge/3` -> `find_s2s_bridge/2`
- `s2s_allow_host/3` -> `s2s_allow_host/2`
- `s2s_connect_hook/3` -> `s2s_connect_hook/2`
- `s2s_receive_packet/2` -> `s2s_receive_packet/1`
- `disco_local_identity/6` -> `disco_local_identity/1`
- `disco_sm_identity/6` -> `disco_sm_identity/1`
- `disco_local_items/6` -> `disco_local_items/1`
- `disco_sm_items/6` -> `disco_sm_items/1`
- `disco_local_features/6` -> `disco_local_features/1`
- `disco_sm_features/6` -> `disco_sm_features/1`
- `disco_info/5` -> `disco_info/1`
- `amp_check_condition/4` -> `amp_check_condition/3`
- `amp_determine_strategy/6` -> `amp_determine_strategy/5`
- `amp_verify_support/3` -> `amp_verify_support/2`
- `forget_room/4` -> `forget_room/3`
- `invitation_sent/7` -> `invitation_sent/6`
- `join_room/6` -> `join_room/5`
- `leave_room/6` -> `leave_room/5`
- `room_packet/6` -> `room_packet/5`
- `caps_recognised/5` -> `caps_recognised/4`
- `pubsub_create_node/6` -> `pubsub_create_node/5`
- `pubsub_delete_node/5` -> `pubsub_delete_node/4`
- `pubsub_publish_item/7` -> `pubsub_publish_item/6`
- `mod_global_distrib_known_recipient/5` -> `mod_global_distrib_known_recipient/4`

## Metrics REST API (obsolete)

The API is still considered obsolete so if you are using it,
please consider using [WombatOAM](https://www.erlang-solutions.com/capabilities/wombatoam/)
or metrics reporters as described in [Logging and monitoring](../operation-and-maintenance/Logging-&-monitoring.md).

In each endpoint, `host` has been changed to `host_type`.
This is because the metrics are now collected per host type rather than host.

## Users cache

MongooseIM used to feature a cache to check whether a user exists, that was unavoidably enabled, and had no eviction policy, that is, the cache could continue growing forever. Now, MIM features a module called [`mod_cache_users`](../modules/mod_cache_users.md) that implements a configurable cache policy, that can be enabled, disabled, and parametrised, per `host_type`. This might not be enabled by default in your configuration, so we recommend you verify your configuration and enable it if needed.
