## Minor changes in the `TOML` config format

* The `pgsql_users_number_estimate` option was moved to [`auth.rdbms.users_number_estimate`](../authentication-methods/rdbms.md#authrdbmsusers_number_estimate). The new option supports PostgreSQL and MySQL.

## DB migrations

### New inbox features

Inbox now implements new functionality (see [inbox](../open-extensions/inbox.md)), but this required adding new columns to the DB. If you're using inbox, please update the tables as follows:

For Postgres or MySQL:
```sql
ALTER TABLE inbox
  ADD COLUMN archive BOOLEAN DEFAULT false,
  ADD COLUMN muted_until BIGINT DEFAULT 0;
```
For MSSQL:
```sql
ALTER TABLE inbox
  ADD COLUMN archive TINYINT DEFAULT 0,
  ADD COLUMN muted_until BIGINT DEFAULT 0;
```

### Archived groupchat messages in `mod_mam`

The [`archive_groupchats`](../modules/mod_mam.md#modulesmod_mampmarchive_groupchats) option is now set to `false` by default, as documented.
Before the change, the private message (PM) archive stored incoming groupchat messages as well, contrary to the documentation.
After the upgrade you can manually remove those messages from the database.
For example, when the MUC domain is `muc.localhost` and `rdbms_message_format` has the default value `internal`, one can remove such messages with the following query:

```sql
DELETE FROM mam_message
  WHERE direction = 'I' AND remote_bare_jid LIKE 'muc.localhost:%';
```

This can be a heavy operation and it needs to be done with caution.

### Using `mod_auth_token` with MySQL and MS SQL

The [`mod_auth_token`](../modules/mod_auth_token.md) module supports MySQL and MS SQL now. To use this functionality, you need to create the `auth_token` table with the query which you can find in `priv/mysql.sql` and `priv/mssql2012.sql`, respectively.
