## TOML configuration file

After the latest [MongooseIM 4.0.0](https://github.com/esl/MongooseIM/releases/tag/4.0.0) release that announced the new TOML configuration format, we've changed a few configuration formats:

* Removed the backend option for `mod_bosh` as "mnesia" was the only valid option.
* Removed the backend option for `mod_inbox` as "rdbms" was the only valid option.
* Deprecated `mod_revproxy`, it can now only be configured with the older, `.cfg` configuration file. Please refer to the older versions of the documentation to see how to do this.
* For `mod_global_distrib`:
  * Replaced the `bounce` option with `bounce.enabled` for `mod_global_distrib`. It was a "boolean with only false being a valid option" which was very confusing. This was because when someone wanted to have bounce enabled it became a TOML table as opposed to a key. Now there is a switch in the bounce section for this behaviour which keeps the behaviour of having bounce enabled by default.
  * Replaced the `tls` option with `tls.enabled` for `mod_global_distrib` for the same reason. The only issue here is as tls is disabled by default (it needs some options in the tls section to be set), the "no section - disabled" approach seems more natural. Just for the consistency, it's changed to be similar to the bounce section in this regard.


## `mod_http_notification` module is no longer available

`mod_http_notification` has been deprecated since MongooseIM 2.1.1 and it is no longer available in this release.
Please use the `http` backend for `mod_event_pusher`, which is the direct equivalent of `mod_http_notification`.

### Metrics

`mod_http_notification` metric was updated and now is available as [`mod_event_pusher_http`](../modules/mod_event_pusher_http.md#metrics).
For more details on how to configure `mod_event_pusher` with `http` backend, please see [this section](../modules/mod_event_pusher_http.md).
