## TOML configuration file

> Note that a minor [4.0.1](https://github.com/esl/MongooseIM/releases/tag/4.0.1) version has been released with small but important changes to take into account if you're migrating to MongooseIM 4.0.

There is a new [TOML configuration file](../configuration/configuration-files.md): `mongooseim.toml`.
The legacy `mongooseim.cfg` file is still supported as an alternative, but deprecated.

You are advised to rewrite your configuration file in the TOML format.
Until then, you can still make MongooseIM use the old format by setting the `MONGOOSEIM_CONFIG_FORMAT` environment variable to `cfg`:

`MONGOOSEIM_CONFIG_FORMAT=cfg mongooseimctl start`

## Changes in hooks

If modified the code, e.g. by adding a custom extension module, you might want to update your handlers to the following hooks. You can find them in the `mongoose_hooks` module.

* We refactored the MAM (XEP-0313) implementation, replacing the long lists of arguments accepted by the `mam_archive_message` and `mam_muc_archive_message` hooks with a more readable key-value structure (a map).
* The argument list of the `failed_to_store_message` hook has been changed as a result of code refactoring.

## OTP Logger as the logging framework

We've transitioned from [lager][lager] to [Logger][Logger] as our logging framework.
No internal changes were introduced, and the default handlers still implement the same behaviour,
but the configuration is different, though still done in the same place.
To know more, please refer to each framework's documentation.

As an example, for our previous default lager configuration:
```erlang
 {lager, [
    %% Make logging more async
    %% If some very heavy loaded process want to log something, it's better to not block the process.
    {async_threshold, 2000},
    {async_threshold_window, 500},
    %% Kill sink if it has more than 10k messages
    {killer_hwm, 10000},
    {killer_reinstall_after, 5000},
    {log_root, "log"},
    {crash_log, "crash.log"},
    {handlers, [
        {lager_console_backend, [{level, info}]},
        {lager_file_backend, [{file, "ejabberd.log"}, {level, info}, {size, 2097152}, {date, "$D0"}, {count, 5}]}
    ]}
  ]}
```

The equivalent Logger configuration is
```erlang
 {kernel, [
  {logger_level, warning},
  {logger, [
    %% Console logger
    {handler, default, logger_std_h, #{}},
    %% Disk logger for errors
    {handler, disk_log, logger_disk_log_h,
       #{config => #{
           file => "log/mongooseim.log",
           type => wrap,
           max_no_files => 5,
           max_no_bytes => 2097152,
           sync_mode_qlen => 2000, % If sync_mode_qlen is set to the same value as drop_mode_qlen,
           drop_mode_qlen => 2000, % synchronous mode is disabled. That is, the handler always runs
           flush_qlen => 5000,     % in asynchronous mode, unless dropping or flushing is invoked.
           overload_kill_enable => true
         },
         formatter => {logger_formatter, #{
           depth => 12,
           chars_limit => 4096
         }}
        }
    }
  ]}]}
```

[lager]: https://github.com/erlang-lager/lager
[Logger]: https://erlang.org/doc/apps/kernel/logger_chapter.html
