## Push notifications

In this version, push notifications work with MongoosePush 2.0.0 and its API v3 by default.

### Push notifications are send from the server's JID

Since this version, MongooseIM sends the PubSub publish request to push notifications node from the server's JID.
Previously the publish request was sent from the user's JID.
If the push PubSub node was created with `pubsub#access_mode` set to **whitelist** and `pubsub#publish_model` set to **publishers**,
now the server's JID needs to be added to the push node in order to send the push notifications successfully.

It can be done by sending the following request from the push node's owner:

```xml
<iq to='pubsub.mypubsub'
    type='set'
    id='wy6Hibg='
    from='alice@wonderland.com/resource'>
	<pubsub xmlns='http://jabber.org/protocol/pubsub#owner'>
		<affiliations node='punsub_node_for_my_private_iphone'>
			<affiliation jid='mychat.com' affiliation='publish-only'/>
		</affiliations>
	</pubsub>
</iq>
```

### `mod_push` module is no longer available

`mod_push` has been deprecated since MongooseIM 2.1.1 and it is no longer present in this release.
Please use the `push` backend for `mod_event_pusher`, which is the direct equivalent of `mod_push`.

## Different MUC Light room schema definition

We have introduced a change that enforces defining fields with default values.
The previous setup led to problems with the RDBMS backend as separating MUC Light options for the schema from the default values was unintuitive.
In a specific case when the default config was a subset of the schema and the client failed to provide these values when a room was created, MUC Light stored the incomplete config in the table.
Then the missing config fields could not be supplied by the clients.
If you've experienced this issue, a way to fix it is described in the [Known issues](../operation-and-maintenance/known-issues.md) page.

The current method makes it impossible to make the same mistake, as it disallows field definition without any default value.

### What has changed? - for administrators

* It's no longer possible to declare a room config field only with its name.
* There is no `default_config` option anymore.
* Declaring a field name and type without an atom key is no longer supported.

#### Example 1

**Old config:**

```erlang
{config_schema, [
                 "roomname",
                 "subject",
                 "background",
                 "notification_sound"
                ]},
{default_config, [
                  {"roomname", "The room"},
                  {"subject", "Chit-chat"}
                 ]}
```

**New config:**

```erlang
{config_schema, [
                 {"roomname", "The room"},
                 {"subject", "Chit-chat"},
                 {"background", ""},
                 {"notification_sound", ""}
                ]}
```

#### Example 2

**Old config:**

```erlang
{config_schema, [
                 "roomname",
                 {"subject", binary},
                 {"priority", priority, integer},
                 {"owners-height", owners_height, float}
                ]},
{default_config, [
                  {"roomname", "The room"},
                  {"subject", "Chit-chat"},
                  {"priority", 10}]}
```

**New config:**

```erlang
{config_schema, [
                 {"roomname", "The room"},
                 {"subject", "Chit-chat"},
                 {"priority", 10, priority, integer},
                 {"owners-height", 180.0, owners_height, float}
                ]}

```

### What has changed? - for developers

The room config schema is currently stored in a completely different data structure, so if you have any custom modules that use it, you'll need to adjust them.
Additionally, all definitions and the room config API have been extracted from `mod_muc_light.hrl` and `mod_muc_light_utils.erl` into `mod_muc_light_room_config.erl` module.

For more information, please check the specs for types and functions in the aforementioned file.

### What hasn't changed?

* The default room config is still the same, i.e. `roomname` (default: `"Untitled"`) and `subject` (empty string).
* The room config representation in databases (both Mnesia and RDBMS) is the same; no need for migration.

## Offline storage

In this version the offline storage entries contain one additional information for internal use.
Riak and mnesia backends don't require any changes when upgrading to this version.
In case of the RDBMS backends, a new column needs to be added.
Below there are MySQL, PgSQL and MSSQL queries which can be used to add the new column.

**MySQL**

```sql
ALTER TABLE offline_message ADD COLUMN permanent_fields mediumblob;
```

**PostgreSQL**

```sql
ALTER TABLE offline_message ADD COLUMN permanent_fields bytea;
```

**MSSQL**

```sql
ALTER TABLE [dbo].[offline_message] ADD permanent_fields varbinary(max);
```

## Persistent Cluster ID

In this version, a new cluster ID has been created, to correctly identify the lifetime of a cluster,
across restarts and nodes joining and leaving. This is used for example by
[System Metrics](../operation-and-maintenance/System-Metrics-Privacy-Policy.md).
This cluster ID is persisted in RDBMS, when an RDBMS database is available, but a new table is
required:

**MySQL**
```sql
CREATE TABLE mongoose_cluster_id (k varchar(50) PRIMARY KEY, v text);
```

**PostgreSQL**
```sql
CREATE TABLE mongoose_cluster_id (k varchar(50) PRIMARY KEY, v text);
```

**MSSQL**
```sql
CREATE TABLE mongoose_cluster_id (k varchar(50) NOT NULL PRIMARY KEY, v text);
```

