## **`odbc` renamed to `rdbms` in module names and options**

* **For MongooseIM users:** simply replace all instances of `odbc` in your config files with `rdbms`.
  E.g. `{auth_method, odbc}.` would now be `{auth_method, rdbms}.`.<br/>
  It's also important to note that all metrics that previously contained `odbc` in their names have also been renamed to contain `rdbms` instead.

  Please note that `odbc_server` has been completely replaced with new `outgoing_pools` (see one of the next sections of this document) config element.

* **For developers calling MongooseIM modules:** most modules, functions and atoms had `odbc` in their names replaced with `rdbms`.
  The only exceptions to this rule were names actually pertaining to the ODBC driver, e.g. `mongoose_rdbms_odbc`.

## **`ejabberd.cfg` renamed to `mongooseim.cfg`**

Rename the existing config file of MongooseIM from `ejabberd.cfg` to `mongooseim.cfg`.

## Pools configuration

Configuring pools to external services has changed, please see [Outgoing Connection doc](../configuration/outgoing-connections.md) for more details.

!!! Note
    Keep in mind that `outgoing_pools` is a list of pools, it may turn out that you will have more than one entry in the list when more than a single outgoing pool is needed.

### Example - Old format

```erlang
{elasticsearch_server, [{host, "elastic.host.com"}, {port, 9042}]}.
{riak_server, [{pool_size, 20}, {address, "127.0.0.1"}, {port, 8087}, {riak_pb_socket_opts, []}]}.
{http_connections, [{conn1, [{server, "http://server:8080"}, {pool_size, 50}]} ]}.
{cassandra_servers, [
  {default, 100,
   [
    {servers,
     [
      {"cassandra_server1.example.com", 9042},
      {"cassandra_server2.example.com", 9042},
      {"cassandra_server3.example.com", 9042},
      {"cassandra_server4.example.com", 9042}
     ]
    },
    {keyspace, "big_mongooseim"}
   ]
  }
 ]
}.
```

### Example - New format

This section provides direct "translation" of configuration from "Old format" section.

```erlang
{outgoing_pools, [
  {elastic, global, default, [], [{host, "elastic.host.com"}, {port, 9042}]},
  {riak, global, default, [{workers, 20}], [{address, "127.0.0.1"}, {port, 8087}]},
  {http, global, conn1, [{workers, 50}], [{server, "http://server:8080"}]},
  {cassandra, global, default, [{workers, 100}], [
        {servers, [
          {"cassandra_server1.example.com", 9042},
          {"cassandra_server2.example.com", 9042},
          {"cassandra_server3.example.com", 9042},
          {"cassandra_server4.example.com", 9042}
        ]},
        {keyspace, "big_mongooseim"}
    ]}
]}.
```

### RDBMS configuration migration

RDBMS pools are no longer configured by a `{pool, odbc, _}` tuple, instead using the generic outgoing pools mechanism.
The connection configuration is now passed via `server` option of the pool instead of being configured via a top-level `{odbc_server, _}` tuple.
Similarly, the number of workers is no longer configured by `odbc_pool_size`, and the default pool no longer set by `odbc_pool`.
A top-level `odbc_keepalive_interval` is now also specified as an option for a specific pool.
For example:

```erlang
{odbc_pool_size, 10}.
{pool, odbc, default}.
{odbc_server_type, mssql}.
{odbc_server, "DSN=mongoose-mssql;UID=sa;PWD=mongooseim_secret+ESL123"}.
{odbc_keepalive_interval, 10}.
```

will now become:

```erlang
{rdbms_server_type, mssql}.
{outgoing_pools, [
 {rdbms, global, default, [{workers, 10}],
  [{server, "DSN=mongoose-mssql;UID=sa;PWD=mongooseim_secret+ESL123"}, {keepalive_interval, 10}]}
]}.
```

Note that `odbc_server_type` was only renamed to `rdbms_server_type` and still remains a top-level configuration value.

## sm_backend

If you had the `sm_backend` set to redis like below:

```erlang
{sm_backend, {redis, [{pool_size, 3}, {worker_config, [{host, "localhost"}, {port, 6379}]}]}}.
```

The pool needs to be defined inside `outgoing_pools` like this:

```erlang
{outgoing_pools, [
 {redis, global, default, [{workers, 3}],
  [{host, "localhost"},
   {port, 6379}]}
]}.
```

and the `sm_backend` configuration needs to changed to just:

```erlang
{sm_backend, {redis, []}}.
```

## mod_global_distrib

If you had `mod_global_distrib` configured in the following way:

```erlang
{mod_global_distrib, [
        (...)
        {redis, [
              {pool_size, 24},
              {server, "172.16.0.3"}
             ]}
       ]}
```

The redis pool needs to be defined inside `outgoing_pools`:

```erlang
{outgoing_pools, [
 {redis, global, global_distrib, [{workers, 24}], [{host, "172.16.0.3"}]}
]}.
```
