---
title: Present at our Dev CoP
layout: default
category: Practices
summary: A walk though of important things to consider when preparing a presentation.
date: 2017-01-01
---

This user guide is to help those who have never presented at our Dev CoP sessions, but like to do so. It should give you good information on how to prepare your presentation and how to wow your audience.

## Outlining your Presentation

### Introduction

Introduce yourself. Tell them what you're presenting, and why it matters to YOU! This is where you "sell" your product, tell them how it will improve their everyday work.

(1-2 slides)

### Agenda

Give a quick overview of what you're going to cover in your presentation.

(1 slide - bullet points)

### Selling Points

Which problem does this product/best practice solve?

(1-5 slides)

### Product description

Know your audience. If they've never seen it before, you'll need to give a high-level overview and use terms that everyone will understand. Explain how your product/best practice fits into their existing environment. Use a demo to show them how your product/best practice fits into their existing environment.

(1-2 slides - include a high-level diagram)

### Feature Benefits

Include and walk through your list of features and benefits. Don't forget the benefits! It may be obvious to you but your audience needs to know how your product/best practice will improve their working lives.

(1-5 slides)

### Examples / Successes

Give examples of how your product/best practice is being used and how it's improved you/your team's everyday work.

(1-3 slides)

### Closing Arguments

This is an opportunity for a "call to action". Re-state the point of your presentation, and ask your audience to do something. Do you want them to use your product/best practice? Ask the audience questions?

We also encourage community discussion online (GCConnex, GCMessage), make yourself available there as well.

(1 slide - include your contact info if anyone has any questions afterwards)

## Considerations for Framing the Presentation

### Who is your Audience

Mainly Developers and Technical Analysts. We also sometimes get Team Leaders and occasionally Managers and Directors.

- What is their knowledge level of your topic (do they even know what your product is)?
- Do they have any assumptions/skepticism about your topic? Do you need to "sell them" on your product?

### What are you Presenting

- Are you presenting a development tool?
- Are you presenting best practices in software development that you'd like to share with others?

### Why does this Topic Matter to you

- What's your objective at the end of your presentation?
- Do you want your audience to use your product/best practice?
- Do you want your audience to ask questions afterwards?
- Is this mandatory for IITB developers/ESDC?

## FAQ for Dev CoP Presenters

### How long should my presentation be?

You should have 30 minutes of presentation material.

Our sessions are scheduled for about 90 minutes; about 30 minutes is used for the session introduction and announcements; about 20 minutes is for a question and answer period; with a 30 minute presentation it leaves us with 10 minutes buffer.

### Should I practice my presentation before the actual Dev CoP?

A resounding YES!

We usually schedule a "dry-run meeting" with each presenter, 2-3 weeks before the Dev CoP to provide feedback, and potential questions the audience may ask at the Dev CoP.

### How many slides should I include?

No more than 30 slides. It's best to keep your slides as simple as possible (minimal amount of text per slide - use diagrams instead) and make sure your slides are readable from the back of the room.

Please use the latest ESDC PowerPoint template - Check [this](https://esdc.prv/en/work_tools/templates.shtml)

### Should I give a demo of the Product?

If you're presenting a new product/best practices/mandatory instructions for all developers, then ABSOLUTELY! Check out [The Art of Live Coding](https://medium.com/@azamsharp/the-art-of-live-coding-459f0c5910c1 )
