---
title: TFS 2015 Use and Configuration Recommendation
layout: default
category: Tools
summary: Detailing the best use for TFS 2015 configurations.
date: 2015-09-01
---

## Overview

This document provides guidelines to manage the projects in ESDC that hare hosted in SADE's instance of TFS 2015 to provide strong recommendations as to the implementation and use of the tool for these projects.
TFS 2015 offers two version control systems, TFVC and Git.

ESDC has developed a default template that is slightly different than the default provided by Microsoft in order to accommodate a few specific requirements from our Testing Services team.
It is the recommendation that this is the only template that is used and that no customization is made. Most projects in TFS currently have customization and should be actively working with SADE to remove all of it.

SADE (Shared Application Development Environment) is the technical owner of TFS 2015. Any questions or requests should be made though NSD assigned to 'NA-SADEADMIN'.

### Iterations

Iterations are a way to identify the cycle/release/milestone/sprint you are working on.
They are used to assign Work Items to the right time period and also as a filter to Queries and Reports.

Iteration names should reflect the version of the product being developed for that iteration.
The name should stay consistent across multiple iterations to aid with sorting.
The iterations could contain sub-iteration only if necessary for organizing "sprints" or "cycles".
All iterations should have a start and end date set.
The top level iteration, named the same as your TFS project, should be set as the backlog iteration (right click).
The current iteration should be selected with the checkbox on the left; this will change over time.
If you have sub iterations you may want to select multiple at a time.
These setting will effect your Kan-ban board and overall project planning so ensure you set it so your team can be successful.

![Iterations example in TFS 2015](../assets/pictures/IterationsTFS2015.PNG)

### Areas

Areas are a way of grouping the structure of your system, components, modules.
They are used to assign Work Items to the proper artifact of your system and also as a filter in Queries and Reports.

The structure and naming should mimic the structure and naming of your source code structure.
They should never contain release information.
They should not have sections for "types" of bugs or work items; aka not Security, Performance, Web Accessibility, Testing.
The areas that are part of regular development (not R&D, or not Legacy) should be selected with the left checkbox; this will set Work Items in these area to show in the backlog.
Most teams will likely need to have everything selected.

![Areas example in TFS 2015](../assets/pictures/AreasTFS2015.PNG)

### Security

This is where access to different levels of features can be set within TFS.
There are three separate groupings for how security is organized: Teams, TFS groups, Windows groups.
The permissions of the TFS groups should never be changed from the defaults.

Different Teams can be created for organizing your security; it is recommended that you have one team for each type of working member (Developers, Testers).
Adding a Windows group whenever possible over adding individual users is a much more maintainable method to maintaining access to the project (single point of change).
TFS groups should only have Teams and other TFS groups as their members (no Windows groups or user accounts).
The Windows groups section will populate if the group has been added to a Team; they can't be edited from TFS.
Teams may have other Teams as members.
You should have a default team with the TFS project name that should have members from the core teams.
Permissions should only be set at the TFS group level.

### Alerts

The suggested recommendation is to use the default alerts.
If the team requires additional alerts to stay effective they should enable custom alerts.

### Services

If you are using External Git for your Endpoint, you should use a Token rather than a user/password.

### Test

Defaults should be maintained.

## Code

### Branching

The branching strategy is based on the "Development and Release Isolation" models of the ALM Rangers.
This model provides us with 3 branches: DEV, MAIN, REL.

The **MAIN** branch is defined by the following:

* Is the parent/junction to the DEV branch and the REL branch
* Is the branch of “truth”, which must be buildable, meet minimum quality bar
* Is the trusted source by the application team.
* Avoid making changes to this branch
* Other branches (DEV, REL) are created from this branch

The **DEV** branch is defined by the following:

* Is a child to the MAIN branch
* Is created from the parent branch MAIN
* Is used to isolate code changes from MAIN until they are stable enough to merge back into main
* When parallel development is necessary, multiple DEV branches can be created but should be avoided when possible.
  As the number of DEV branches increases, the cost, time, complexity and effort needed to merge into MAIN and resolve merging conflicts is greatly increased.

The **REL** branch is defined by the following:

* Is a child to the MAIN branch
* Often referenced as PROD
* Is created from the parent branch MAIN
* Is created to isolate (snapshot) the code that has been release to the production environment
* Is used when changes are required to the code that has been released to the production environment and the DEV branch is already utilized for new development requirements.
  If the DEV branch is not utilized then the fix should be performed in DEV as a regular code change and merge to MAIN once completed.

#### Life Cycle

Below is a diagram illustrating how the 3 branches are used throughout the lifecycle of an application.
During the lifespan of the following illustration, we see 2 regular releases, Release 1 and Release 2.
An Emergency Release to Release 1 needed to be performed while development on Release 2 was underway.

![ALM Branching and Merging example for TFVC](../assets/pictures/BranchingMergingTFVC.JPG)

#### R&D or Parallel Development

When R&D or multiple development work needs to be performed in parallel, multiple "DEV" branches can be created to address these situations.
Once the work is completed and accepted, these changes should be merged back into your main development streams and you should be back to your 3 branch strategy.
The branches are short lived and should be closed when no longer needed.

The following illustration shows 2 different strategies where parallel work is required: one is performed from the MAIN branch and the other from an existing DEV branch.
Both cases show that the changes will be incorporated in a future release as they are merged into the DEV branch.
If the changes fall out of scope or won't be incorporated in the next release, the Merge should not be performed and the branch can be closed, shelved or remain open.

![ALM Branching and Merging with R&D or Parallel Development example for TFVC](../assets/pictures/BranchingMergingRnDTFVC.JPG)

#### Branching considerations

* Only branch when you need to
  * As the number of branches increases, the cost, time, complexity and effort needed to merge and resolve merging conflicts is greatly increased.
  * Keeping the number of branches to the minimum required (DEV, MAIN, REL) will help prevent expensive merges.
  * When extra branches are created, for emergency releases or hotfixes, ensure that those changes are merged to the other necessary branches as soon as possible.
* Merge (FI) frequently to reduce the complexity of “big bang” type merges
* Branch everything you require to develop in parallel, typically this may mean branching the entire parent.
* The folder structure and/or items included should be identical in each branch
* Building regularly (continuously) encourages a regular cadence and the ability to immediately identify quality issues.
* The movement of changes between child and parent branches is a concept all team members must consider and understand.

#### Merging Consideration

* Merging conditions:
  * Avoid merging untested changes
  * Merge only stable code (pass unit tests, code must build successfully)
* Branch from MAIN to DEV when you have a need for concurrent development of the next release, experimentation, or bug fixes in isolated development branches
* Merge from DEV to MAIN when the changes performed are ready to release or ready to share with other teams
* Branch from MAIN to REL when you have a need for concurrent release management and require support for code that has been release to your production environment.
* Merge from REL to MAIN when the changes performed are ready to integrate with concurrent development branches or ready to share with other teams
  * When you merge changes from a REL branch to the MAIN branch, such as due to an emergency hotfix, ensure that you merge these changes to the DEV branches as soon as possible.
* You should never merge from DEV to REL nor from REL to DEV

### Outside the branch

Files outside of the branch but stored in the repository should be limited as much as possible. Keeping files inside the branch, even documentation, allow for determining what the documentation was for a given release compared to how it has changed for the development of the current release.

## Work

### Backlogs

The product backlog is a prioritized features list, containing short descriptions of all functionality desired in the product.
This includes features that may or may not be implemented in the next release.

If the appropriate settings have been set for the project, current iteration, areas and if the work items have been properly organized though parent/child relationships, the backlog will become exceptionally effective at giving you a strong overview of the products needs.
Having the User Stories properly ranked with Story Points will properly prioritize the work to be done.

The backlog has 2 key views, one by work item type (Epics, Features, Stories) and one by the Current (set in iteration settings).
The work item type view will show an overview of everything the client or stakeholder wants added to the product.
The Current view will filter those requests to the ones the team has indicated they are actively working on (for the iteration).

... _more to do here_

### Queries

Make sure you team has a flow in place for how you work with work items.
It will make tracking your work and tasks with quires much easier.
**Even if your teams process is different from a recommend one, its more important that the team agrees and understand the process being used.**

### Work Item Types

Work items should have as much detail filled out as possible to aid in the organization of all the work items in the project, including meaningful titles.
Not all work item types require extensive amount of detail in the description, but the description still needs to be descriptive enough in order to clearly identify the need of that work item.

This diagram is an overview of the relationships.  
_Arrows point to a child Work Item type; Bold are essentially must have relationships; Dashed is unlikely relationships._

![TFS Task Relation ships](../assets/pictures/TFSTAskDiagram.PNG)

#### Epic - Épopée

Is a very high level definition of a group of similar or alike Features.

* Should have multiple child Features
* Should describe a very high level of how the features serve one over arching purpose or business objective
* Epics should never close unless the sub features are removed from the project and the purpose behind the epic is no longer required.

**Ex:** X Management - child Features may be, Create X, Edit X, Delete X.

#### Feature - Functionnalité

Represents a specific functionality within the product.

* Should describe in specifics with clean English (non technical words)
* Details should be effective as documentation
* Should have an Epic as the parent
* Should be created as the result of a User Story (child).
* May have multiple User Stories and Bugs as a child.
* Features should never close unless the purpose behind the feature is no longer required in the product.

**Ex:** Ability to edit X. - Details would define how and when you can edit X. What fields of X can be edited. List validation.

While the example uses "edit", there may also be a feature for "add" as it differs from how edit works.
At the same time you may have business logic behind how both work together, that might need to be a third feature under the epic.

#### User Story - Récit utilisateur

Represents a request from the clients to either change or add a feature to the product with detailed requirements.

* Should describe the current situation in detail and explain in a high level how the feature should behave (describing what success would look like)
* Should be the business requirement
* Should not have descriptions of how features are developed (how buttons or pages specifically function).
* Should have child tasks that designate work needed to implement the change.

#### Bug - Bogue

Represent a problem with the working functionality of a feature.

* Should have a Feature or User Story as the parent
* Should have child Task(s) that designate work needed to fix the Bug

#### Task - Tache

Represents a section of work to be done. The work may depend on other tasks, but the work designated in a single task should still be able to be completed independently (even by another team member).

* Should have a Bug or User Story as the Parent
* May have sub Task(s) as a Child
* Should be written in a way that a technical developer can easily understand
* Typically written by the TL or TA
* If using the backlog capacity the Effort must be accurately maintained

#### Issue - Problème

Represents and event or condition that may prevent unexpected behavior or impediments to the product.
Likely will affect project timelines or availability.

#### Test Case - Scénario d'essai

Represents a series of steps performed against the product to validate the software is working correctly.

## Build

You should be using the the build features within TFS for building your solutions; not custom scripts.
Custom scripts may be warranted for your application however you should plug those scripts into the branch of your code and have the TFS build reference it.

## Release

Please open a ticket with NA-SADEADMIN to configure this for your application.
