#!/usr/bin/perl

sub usage {
	die "incbin.pl out.c in.bin symbol\n";
}

my $out = shift @ARGV or usage();
my $in = shift @ARGV or usage();
my $symbol = shift @ARGV or usage();

open OUT, ">$out" or die "$out: $!\n";
open IN, "$in" or die "$in: $!\n";
binmode(IN);
print OUT "// Auto-generated by incbin.pl from $in\n\n";
print OUT "const unsigned char ${symbol}[] = {\n";
my $i = 0;
while (read(IN, my $byte, 1)) {
	print OUT "\t" if ($i == 0);
	printf OUT "0x%02x", (unpack 'C', $byte);
	print OUT "," unless eof IN;
	$i++;
	if ($i == 16) {
		$i = 0;
		print OUT "\n";
	}
}
print OUT " };\n\n";
print OUT "int ${symbol}_size = (int)sizeof($symbol);\n\n";
close IN;
close OUT;

