[back to README](../README.md)

# Request and Response

`Enm\JsonApi\Model\Request\RequestInterface`:

| Method                                                                                                 | Return Type                   | Description                                                                                                                                                                               |
|--------------------------------------------------------------------------------------------------------|-------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| method                                                                                                 | string                        | The http method of this request                                                                                                                                                           |
| uri                                                                                                    | Psr\Http\Message\UriInterface | The request uri                                                                                                                                                                           |
| headers()                                                                                              | KeyValueCollectionInterface   | Request headers                                                                                                                                                                           |
| type()                                                                                                 | string                        | Requested resource type                                                                                                                                                                   |
| id()                                                                                                   | string|null                   | Requested resource id, if requested                                                                                                                                                       |
| relationship()                                                                                         | string|null                   | Requested relationship, if requested                                                                                                                                                      |
| requestsAttributes()                                                                                   | bool                          | Indicates if the response for this request should contain attributes for a resource                                                                                                       |
| requestsMetaInformation()                                                                              | bool                          | Indicates if the response for this request should contain meta information for a resource                                                                                                 |
| requestsRelationships()                                                                                | bool                          | Indicates if the response for this request should contain relationships for a resource                                                                                                    |
| requestField(string $type, string $name)                                                               | void                          | Define a field as requested. This method will manipulate the uri of the request.                                                                                                          |
| requestsField(string $type, string $name)                                                              | bool                          | Indicates if the response should contain the given field for the given type.                                                                                                              |
| requestInclude(string $relationship)                                                                   | void                          | Define a relationship as included. This method will manipulate the uri of the request.                                                                                                    |
| requestsInclude(string $relationship)                                                                  | bool                          | Indicates if a response should include the given relationship.                                                                                                                            |
| addFilter(string $name, $value)                                                                        | void                          | Define a filter value. This method will manipulate the uri of the request.                                                                                                                |
| hasFilter(string $name)                                                                                | bool                          | Indicates if the given filter is available.                                                                                                                                               |
| filterValue(string $name, string $explodeBy = null)                                                    | mixed                         | Retrieve the value for the given filter.                                                                                                                                                  |
| addOrderBy(string $name, string $direction = self::ORDER_ASC)                                          | void                          | Define a sort parameter. This method will manipulate the uri of the request.                                                                                                              |
| order()                                                                                                | array                         | The field name is always the key while the value always have to be self::ORDER_ASC or self::ORDER_DESC                                                                                    |
| addPagination(string $key, $value)                                                                     | void                          | Define a pagination parameter. This method will manipulate the uri of the request.                                                                                                        |
| hasPagination(string $key)                                                                             | bool                          | Indicates if the given pagination parameter is available.                                                                                                                                 |
| paginationValue(string $key)                                                                           | mixed                         | Retrieve a pagination value.                                                                                                                                                              |
| requestBody()                                                                                          | DocumentInterface|null        | Retrieve the request body if available.                                                                                                                                                   |
| createSubRequest(string $relationship, ?ResourceInterface $resource = null, bool $keepFilters = false) | RequestInterface              | Creates a request for the given relationship.If called twice, the call will return the already created sub request.A sub request does not contain pagination and sorting from its parent. |

`Enm\JsonApi\Model\Response\ResponseInterface`:

| Method     | Return Type                 | Description   |
|------------|-----------------------------|---------------|
| status()   | integer                     | Http status   |
| headers()  | KeyValueCollectionInterface | Http headers  |
| document() | DocumentInterface|null      | Response body |

*****

[prev: Errors and Exceptions](../docs/06-errors.md) | [back to README](../README.md)
