[back to README](../README.md)
# Attributes and Meta-Informations
Resources and documents allowing access to attributes and meta information via `attributes()` and `metaInformation()`,
which will both return an instance of `Enm\JsonApi\Model\Common\KeyValueCollectionInterface`.

These collections will allow you to add, remove or get values by key, getting all key-values-pairs or check for the existence of a value by key.

`Enm\JsonApi\Model\Common\KeyValueCollectionInterface`:

| Method                                                                         | Return type                                                                          | Description                                                                                                                                                                                                                                                                                                                                                                                                |
|--------------------------------------------------------------------------------|--------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| all()                                                                          | array                                                                                | All elements as key-value-array.                                                                                                                                                                                                                                                                                                                                                                           |
| count()                                                                        | int                                                                                  | Number of collection entries.                                                                                                                                                                                                                                                                                                                                                                              |
| isEmpty()                                                                      | bool                                                                                 | Checks if the collection contains any elements.                                                                                                                                                                                                                                                                                                                                                            |
| has(string $key)                                                               | bool                                                                                 | Checks if the collection contains a special element.                                                                                                                                                                                                                                                                                                                                                       |
| getRequired(string $key)                                                       | mixed                                                                                | Returns an element or throws an \InvalidArgumentException if element does not exists.                                                                                                                                                                                                                                                                                                                      |
| getOptional(string $key, $defaultValue = null)                                 | mixed                                                                                | Returns an element or the defined default value if element does not exists.                                                                                                                                                                                                                                                                                                                                |
| createSubCollection(string $key, bool $required = true)                        | [KeyValueCollectionInterface](../src/Model/Common/KeyValueCollectionInterface.php)   | Creates a new collection for a collection element. If required and element does not exists, an \InvalidArgumentException will be thrown. If the element exists but is not an array an \InvalidArgumentException will be thrown.  ATTENTION: If you want to store changed value of the sub collection under the parent collections original key you have to call: `$collection->set($key, $subCollection);` |
| merge(array $data, bool $overwrite = true)                                     | $this                                                                                | Merges the given array into the current collection. If overwrite is set to true (default) existing values are overwritten by the new values, otherwise they will be ignored.                                                                                                                                                                                                                               |
| mergeCollection(SimpleCollectionInterface $collection, bool $overwrite = true) | $this                                                                                | Merges the given collection into the current one. If overwrite is set to true (default) existing values are overwritten by the new values, otherwise they will be ignored.                                                                                                                                                                                                                                 |
| set(string $key, $value)                                                       | $this                                                                                | Set a key-value-pair into the collection.                                                                                                                                                                                                                                                                                                                                                                  |
| remove(string $key)                                                            | $this                                                                                | Remove an element by key from the collection.                                                                                                                                                                                                                                                                                                                                                              |

*****

[prev: Resources](../docs/02-resources.md) | [back to README](../README.md) | [next: Links](../docs/04-links.md)
