# EntKit

A Comprehensive Solution for Building Data-Driven Applications with Ease and Efficiency

[![GitHub license](https://img.shields.io/github/license/entkit/entkit)](https://github.com/entkit/entkit)
[![GitHub stars](https://img.shields.io/github/stars/entkit/entkit)](https://github.com/entkit/entkit/stargazers)
![GitHub release (latest by date)](https://img.shields.io/github/v/release/entkit/entkit)
[![Go Report Card](https://goreportcard.com/badge/github.com/entkit/entkit/v2)](https://goreportcard.com/report/github.com/entkit/entkit/v2)
[![codecov](https://codecov.io/gh/entkit/entkit/branch/main/graph/badge.svg?token=SDEXU6YQH9)](https://codecov.io/gh/entkit/entkit)

[Documentation](https://entkit.com/docs/get-started/introduction) | [GoDoc](https://pkg.go.dev/github.com/entkit/entkit/v2) | [Example project](https://github.com/entkit/entkit-demo) | [Live demo](https://demo-refine-project.entkit.com)

>Live demo credentials
>  - username: `entuser`
>  - password: `entuser`

![logo-color.svg](docs%2Flogo-color.svg)

> EntKit: Leveraging the Power of React, Refine, and AntDesign for Simplified UI Generation and Database Interaction

## Introduction

Efficient tools play a vital role in the world of software development, streamlining workflows, and enhancing productivity. EntKit is a powerful framework designed to automatically generate UI components, server environments, and TypeScript definitions based on your database schema, simplifying UI creation and database interaction. With its integration with React, Refine, AntDesign, and Keycloak, EntKit delivers an end-to-end solution for building and deploying data-driven applications effortlessly.

EntKit: A React-Based Framework for Streamlined UI Development and Database Interaction

EntKit is an innovative framework that simplifies UI development by automatically generating React-based UI components, server environments, and TypeScript definitions using your database schema. EntKit utilizes the Refine framework, AntDesign components, and supports GraphQL API, providing a comprehensive solution for developers to build and deploy data-driven applications with ease.

Key Features of EntKit

1. Auto-generation of UI Components and TypeScript Definitions
   EntKit's primary feature is the automatic generation of React-based UI components and TypeScript definitions based on a given database schema. The framework leverages the power of the Refine framework and AntDesign components, resulting in a functional and visually appealing user interface for your application.

2. Based on Ent Framework and GraphQL API Support
   EntKit is built on top of the Ent framework and supports GraphQL API, ensuring a seamless and efficient interaction between the frontend and backend of your application.

3. Authentication and Authorization with Keycloak
   EntKit provides robust authentication and authorization support by integrating with Keycloak. Support for other authentication providers like Casbin, Auth0, and more is expected to be added soon, offering developers more options for securing their applications.

4. Generated Server for Development and Production Environments
   EntKit goes beyond UI generation by also generating servers for development and production environments. This feature simplifies the deployment process and helps developers maintain a consistent server configuration across various stages of their projects.

5. Docker Image Generation for Applications
   EntKit supports generating Docker images for your applications, making it easier to manage and deploy your projects in containerized environments. This feature ensures consistent behavior across different platforms and allows for seamless scalability.

6. Powerful CLI for Easy Development and Deployment
   EntKit's powerful Command Line Interface (CLI) streamlines the development and deployment process, enabling developers to efficiently manage their projects from start to finish. The CLI offers various commands to generate UI components, manage servers, and deploy applications.

## Idea and target

EntKit is a groundbreaking framework that significantly simplifies UI development and database interaction by leveraging the power of React, Refine, AntDesign, and Keycloak. Its features, including the automatic generation of UI components, server environments, TypeScript definitions, and robust authentication support, provide developers with a comprehensive solution for building and deploying data-driven applications. By automating key aspects of the development process, EntKit allows developers to focus on more critical aspects of their projects, resulting in increased productivity and more efficient software development cycles.

## Roadmap

- [x] Generates CRUD operations based on Ent definitions
- [x] Customizable views for each CRUD operation
- [x] Customizable fields for lists, forms, and show views using annotations
- [x] Custom actions for items
    - [x] Actions on a list, show, or edit view that trigger a GraphQL mutation.
    - [x] Bulk actions on lists
- [x] Relational view with nested lists and edges
- [x] Smart search component to find records by every attribute with a custom operator
- [x] Uses only a Graphql API with a custom Refine data-provider
- [x] Generates TypeScript types from Ent definitions
- [x] Column filters with customizable operators
- [x] Edges diagram graph view
- [ ] Nested create/edit
    - [ ] Ability to create edges from form
    - [ ] Ability to edit edges from form
- [ ] I18n support
- [x] Keycloak Authentication
- [x] Keycloak Authorization
- [x] Generate server with CLI
- [x] Generate multiple UIs with different configurations
- [ ] Filter by edges
- [ ] Sort by edges
- [ ] Godoc: provide comprehensive documentation

## Contacts

**Linkedin**: https://www.linkedin.com/in/aaron-yor/

**Discord**: aaron․yordanyan#7556

**Phone**: +374 98 471111
