# typeboost.css

**Typeboost.css** is a set of CSS rules to ensure readable, scalable and responsive typography. REMs are used for font sizes, paddings, and margins. Can be used as typography normalizer. No dependencies. Wrap your HTML content with class **.col** and you are done.

[![npm](https://img.shields.io/npm/v/typeboost.css.svg)](https://www.npmjs.com/package/typeboost.css)
[![Codacy Badge](https://app.codacy.com/project/badge/Grade/87e126f1473345bca23d3fa108408142)](https://www.codacy.com/manual/englishextra/typeboost-css/dashboard?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=englishextra/typeboost.css&amp;utm_campaign=Badge_Grade)
[![CDNJS](https://img.shields.io/cdnjs/v/typeboost.css.svg)](https://cdnjs.com/libraries/typeboost.css)
[![jsdelivr](https://data.jsdelivr.com/v1/package/npm/typeboost.css/badge)](https://www.jsdelivr.com/package/npm/typeboost.css)

![typeboost.css](https://github.com/englishextra/typeboost.css/raw/master/img/typeboost.css-logo-1DB5FC-935x230.png)

## npm Install

`npm install typeboost.css`

## Usage

```html
<!DOCTYPE html>
<html class="no-js" lang="ru">
  <head>
    <meta charset="utf-8" />
    <meta name="HandheldFriendly" content="True" />
    <meta name="MobileOptimized" content="320" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title></title>
    <link rel="stylesheet" href="typeboost.min.css" />
  </head>
  <body>
    <div class="col">
      <h1>Heading&#160;1</h1>

      <p>
        Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis,
      </p>
    </div>
  </body>
</html>
```

## License

Available under [MIT license](https://opensource.org/licenses/MIT).
