// This file is part of css. It is subject to the license terms in the COPYRIGHT file found in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/css/master/COPYRIGHT. No part of predicator, including this file, may be copied, modified, propagated, or distributed except according to the terms contained in the COPYRIGHT file.
// Copyright © 2017 The developers of css. See the COPYRIGHT file in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/css/master/COPYRIGHT.

use {
    crate::CustomParseError,
    cssparser::{serialize_string, CowRcStr, ParseError, ToCss},
    std::fmt,
};

#[derive(Debug, Copy, Clone, Ord, PartialOrd, Eq, PartialEq, Hash)]
pub enum OpenTypeLanguageTag {
    ABA,
    ABK,
    ACH,
    ACR,
    ADY,
    AFK,
    AFR,
    AGW,
    AIO,
    AKA,
    ALS,
    ALT,
    AMH,
    ANG,
    ARA,
    ARG,
    ARI,
    ARK,
    ASM,
    AST,
    ATH,
    AVR,
    AWA,
    AYM,
    AZB,
    AZE,
    BAD,
    BAG,
    BAL,
    BAN,
    BAR,
    BAU,
    BBC,
    BBR,
    BCH,
    BCR,
    BDY,
    BEL,
    BEM,
    BEN,
    BGC,
    BGQ,
    BGR,
    BHI,
    BHO,
    BIK,
    BIL,
    BIS,
    BKF,
    BLI,
    BLK,
    BLN,
    BLT,
    BMB,
    BML,
    BOS,
    BPY,
    BRE,
    BRH,
    BRI,
    BRM,
    BRX,
    BSH,
    BSK,
    BTI,
    BTS,
    BUG,
    BYV,
    CAK,
    CAT,
    CBK,
    CHN,
    CEB,
    CHE,
    CHG,
    CHH,
    CHI,
    CHK,
    CHO,
    CHP,
    CHR,
    CHA,
    CHU,
    CHY,
    CGG,
    CJA,
    CJM,
    CMR,
    COP,
    COR,
    COS,
    CPP,
    CRE,
    CRR,
    CRT,
    CSB,
    CSL,
    CSY,
    CTG,
    CUK,
    DAN,
    DAR,
    DAX,
    DCR,
    DEU,
    DGO,
    DGR,
    DHG,
    DHV,
    DIQ,
    DIV,
    DJR,
    DNG,
    DNJ,
    DNK,
    DRI,
    DUJ,
    DUN,
    DZN,
    EBI,
    ECR,
    EDO,
    EFI,
    ELL,
    EMK,
    ENG,
    ERZ,
    ESP,
    ESU,
    ETI,
    EUQ,
    EVK,
    EVN,
    EWE,
    FAN,
    FAR,
    FAT,
    FIN,
    FJI,
    FLE,
    FMP,
    FNE,
    FON,
    FOS,
    FRA,
    FRC,
    FRI,
    FRL,
    FRP,
    FTA,
    FUL,
    FUV,
    GAD,
    GAE,
    GAG,
    GAL,
    GAR,
    GAW,
    GEZ,
    GIH,
    GIL,
    GKP,
    GLK,
    GMZ,
    GNN,
    GOG,
    GON,
    GRN,
    GRO,
    GUA,
    GUC,
    GUF,
    GUJ,
    GUZ,
    HAI,
    HAL,
    HAR,
    HAU,
    HAW,
    HAY,
    HAZ,
    HBN,
    HER,
    HIL,
    HIN,
    HMA,
    HMN,
    HMO,
    HND,
    HO,
    HRI,
    HRV,
    HUN,
    HYE,
    IBA,
    IBB,
    IBO,
    IJO,
    IDO,
    ILE,
    ILO,
    INA,
    IND,
    ING,
    INU,
    IPK,
    PPH,
    IRI,
    IRT,
    ISL,
    ISM,
    ITA,
    IWR,
    JAM,
    JAN,
    JAV,
    JBO,
    JCT,
    JII,
    JUD,
    JUL,
    KAB,
    KAC,
    KAL,
    KAN,
    KAR,
    KAT,
    KAZ,
    KDE,
    KEA,
    KEB,
    KEK,
    KGE,
    KHA,
    KHK,
    KHM,
    KHS,
    KHT,
    KHV,
    KHW,
    KIK,
    KIR,
    KIS,
    KIU,
    KJD,
    KJP,
    KKN,
    KLM,
    KMB,
    KMN,
    KMO,
    KMS,
    KMZ,
    KNR,
    KOD,
    KOH,
    KOK,
    KOM,
    KON,
    KOP,
    KOR,
    KOS,
    KOZ,
    KPL,
    KRI,
    KRK,
    KRL,
    KRM,
    KRN,
    KRT,
    KSH,
    KSI,
    KSM,
    KSW,
    KUA,
    KUI,
    KUL,
    KUM,
    KUR,
    KUU,
    KUY,
    KYK,
    KYU,
    LAD,
    LAH,
    LAK,
    LAM,
    LAO,
    LAT,
    LAZ,
    LCR,
    LDK,
    LEZ,
    LIJ,
    LIM,
    LIN,
    LIS,
    LJP,
    LKI,
    LMA,
    LMB,
    LMO,
    LMW,
    LOM,
    LRC,
    LSB,
    LSM,
    LTH,
    LTZ,
    LUA,
    LUB,
    LUG,
    LUH,
    LUO,
    LVI,
    MAD,
    MAG,
    MAH,
    MAJ,
    MAK,
    MAL,
    MAM,
    MAN,
    MAP,
    MAR,
    MAW,
    MBN,
    MBO,
    MCH,
    MCR,
    MDE,
    MDR,
    MEN,
    MER,
    MFE,
    MIN,
    MIZ,
    MKD,
    MKR,
    MKW,
    MLE,
    MLG,
    MLN,
    MLR,
    MLY,
    MND,
    MNG,
    MNI,
    MNK,
    MNX,
    MOH,
    MOK,
    MOL,
    MON,
    MOR,
    MOS,
    MRI,
    MTH,
    MTS,
    MUN,
    MUS,
    MWL,
    MWW,
    MYN,
    MZN,
    NAG,
    NAH,
    NAN,
    NAP,
    NAS,
    NAU,
    NAV,
    NCR,
    NDB,
    NDC,
    NDG,
    NDS,
    NEP,
    NEW,
    NGA,
    NGR,
    NHC,
    NIS,
    NIU,
    NKL,
    NKO,
    NLD,
    NOE,
    NOG,
    NOR,
    NOV,
    NSM,
    NSO,
    NTA,
    NTO,
    NYM,
    NYN,
    NZA,
    OCI,
    OCR,
    OJB,
    ORI,
    ORO,
    OSS,
    PAA,
    PAG,
    PAL,
    PAM,
    PAN,
    PAP,
    PAS,
    PAU,
    PCC,
    PCD,
    PDC,
    PGR,
    PHK,
    PIH,
    PIL,
    PLG,
    PLK,
    PMS,
    PNB,
    POH,
    PON,
    PRO,
    PTG,
    PWO,
    QIN,
    QUC,
    QUH,
    QUZ,
    QVI,
    QWH,
    RAJ,
    RAR,
    RBU,
    RCR,
    REJ,
    RIA,
    RIF,
    RIT,
    RKW,
    RMS,
    RMY,
    ROM,
    ROY,
    RSY,
    RTM,
    RUA,
    RUN,
    RUP,
    RUS,
    SAD,
    SAN,
    SAS,
    SAT,
    SAY,
    SCN,
    SCO,
    SEK,
    SEL,
    SGA,
    SGO,
    SGS,
    SHI,
    SHN,
    SIB,
    SID,
    SIG,
    SKS,
    SKY,
    SCS,
    SLA,
    SLV,
    SML,
    SMO,
    SNA,
    SND,
    SNH,
    SNK,
    SOG,
    SOP,
    SOT,
    SQI,
    SRB,
    SRD,
    SRK,
    SRR,
    SSL,
    SSM,
    STQ,
    SUK,
    SUN,
    SUR,
    SVA,
    SVE,
    SWA,
    SWK,
    SWZ,
    SXT,
    SXU,
    SYL,
    SYR,
    YRE,
    YRJ,
    YRN,
    SZL,
    TAB,
    TAJ,
    TAM,
    TAT,
    TCR,
    TDD,
    TEL,
    TET,
    TGL,
    TGN,
    TGR,
    TGY,
    THA,
    THT,
    TIB,
    TIV,
    TKM,
    TMH,
    TMN,
    TNA,
    TNE,
    TNG,
    TOD,
    TPI,
    TRK,
    TSG,
    TUA,
    TUM,
    TUL,
    TUV,
    TVL,
    TWI,
    TYZ,
    TZM,
    TZO,
    UDM,
    UKR,
    UMB,
    URD,
    USB,
    UYG,
    UZB,
    VEC,
    VEN,
    VIT,
    VOL,
    VRO,
    WA,
    WAG,
    WAR,
    WCR,
    WEL,
    WLN,
    WLF,
    WTM,
    XBD,
    XHS,
    XJB,
    XOG,
    XPE,
    YAK,
    YAO,
    YAP,
    YBA,
    YCR,
    YIC,
    YIM,
    ZEA,
    ZGH,
    ZHA,
    ZHH,
    ZHP,
    ZHS,
    ZHT,
    ZND,
    ZUL,
    ZZA,
}

impl ToCss for OpenTypeLanguageTag {
    fn to_css<W: fmt::Write>(&self, dest: &mut W) -> fmt::Result {
        use self::OpenTypeLanguageTag::*;

        match *self {
            ABA => serialize_string("ABA", dest),
            ABK => serialize_string("ABK", dest),
            ACH => serialize_string("ACH", dest),
            ACR => serialize_string("ACR", dest),
            ADY => serialize_string("ADY", dest),
            AFK => serialize_string("AFK", dest),
            AFR => serialize_string("AFR", dest),
            AGW => serialize_string("AGW", dest),
            AIO => serialize_string("AIO", dest),
            AKA => serialize_string("AKA", dest),
            ALS => serialize_string("ALS", dest),
            ALT => serialize_string("ALT", dest),
            AMH => serialize_string("AMH", dest),
            ANG => serialize_string("ANG", dest),
            ARA => serialize_string("ARA", dest),
            ARG => serialize_string("ARG", dest),
            ARI => serialize_string("ARI", dest),
            ARK => serialize_string("ARK", dest),
            ASM => serialize_string("ASM", dest),
            AST => serialize_string("AST", dest),
            ATH => serialize_string("ATH", dest),
            AVR => serialize_string("AVR", dest),
            AWA => serialize_string("AWA", dest),
            AYM => serialize_string("AYM", dest),
            AZB => serialize_string("AZB", dest),
            AZE => serialize_string("AZE", dest),
            BAD => serialize_string("BAD", dest),
            BAG => serialize_string("BAG", dest),
            BAL => serialize_string("BAL", dest),
            BAN => serialize_string("BAN", dest),
            BAR => serialize_string("BAR", dest),
            BAU => serialize_string("BAU", dest),
            BBC => serialize_string("BBC", dest),
            BBR => serialize_string("BBR", dest),
            BCH => serialize_string("BCH", dest),
            BCR => serialize_string("BCR", dest),
            BDY => serialize_string("BDY", dest),
            BEL => serialize_string("BEL", dest),
            BEM => serialize_string("BEM", dest),
            BEN => serialize_string("BEN", dest),
            BGC => serialize_string("BGC", dest),
            BGQ => serialize_string("BGQ", dest),
            BGR => serialize_string("BGR", dest),
            BHI => serialize_string("BHI", dest),
            BHO => serialize_string("BHO", dest),
            BIK => serialize_string("BIK", dest),
            BIL => serialize_string("BIL", dest),
            BIS => serialize_string("BIS", dest),
            BKF => serialize_string("BKF", dest),
            BLI => serialize_string("BLI", dest),
            BLK => serialize_string("BLK", dest),
            BLN => serialize_string("BLN", dest),
            BLT => serialize_string("BLT", dest),
            BMB => serialize_string("BMB", dest),
            BML => serialize_string("BML", dest),
            BOS => serialize_string("BOS", dest),
            BPY => serialize_string("BPY", dest),
            BRE => serialize_string("BRE", dest),
            BRH => serialize_string("BRH", dest),
            BRI => serialize_string("BRI", dest),
            BRM => serialize_string("BRM", dest),
            BRX => serialize_string("BRX", dest),
            BSH => serialize_string("BSH", dest),
            BSK => serialize_string("BSK", dest),
            BTI => serialize_string("BTI", dest),
            BTS => serialize_string("BTS", dest),
            BUG => serialize_string("BUG", dest),
            BYV => serialize_string("BYV", dest),
            CAK => serialize_string("CAK", dest),
            CAT => serialize_string("CAT", dest),
            CBK => serialize_string("CBK", dest),
            CHN => serialize_string("CHN", dest),
            CEB => serialize_string("CEB", dest),
            CHE => serialize_string("CHE", dest),
            CHG => serialize_string("CHG", dest),
            CHH => serialize_string("CHH", dest),
            CHI => serialize_string("CHI", dest),
            CHK => serialize_string("CHK", dest),
            CHO => serialize_string("CHO", dest),
            CHP => serialize_string("CHP", dest),
            CHR => serialize_string("CHR", dest),
            CHA => serialize_string("CHA", dest),
            CHU => serialize_string("CHU", dest),
            CHY => serialize_string("CHY", dest),
            CGG => serialize_string("CGG", dest),
            CJA => serialize_string("CJA", dest),
            CJM => serialize_string("CJM", dest),
            CMR => serialize_string("CMR", dest),
            COP => serialize_string("COP", dest),
            COR => serialize_string("COR", dest),
            COS => serialize_string("COS", dest),
            CPP => serialize_string("CPP", dest),
            CRE => serialize_string("CRE", dest),
            CRR => serialize_string("CRR", dest),
            CRT => serialize_string("CRT", dest),
            CSB => serialize_string("CSB", dest),
            CSL => serialize_string("CSL", dest),
            CSY => serialize_string("CSY", dest),
            CTG => serialize_string("CTG", dest),
            CUK => serialize_string("CUK", dest),
            DAN => serialize_string("DAN", dest),
            DAR => serialize_string("DAR", dest),
            DAX => serialize_string("DAX", dest),
            DCR => serialize_string("DCR", dest),
            DEU => serialize_string("DEU", dest),
            DGO => serialize_string("DGO", dest),
            DGR => serialize_string("DGR", dest),
            DHG => serialize_string("DHG", dest),
            DHV => serialize_string("DHV", dest),
            DIQ => serialize_string("DIQ", dest),
            DIV => serialize_string("DIV", dest),
            DJR => serialize_string("DJR", dest),
            DNG => serialize_string("DNG", dest),
            DNJ => serialize_string("DNJ", dest),
            DNK => serialize_string("DNK", dest),
            DRI => serialize_string("DRI", dest),
            DUJ => serialize_string("DUJ", dest),
            DUN => serialize_string("DUN", dest),
            DZN => serialize_string("DZN", dest),
            EBI => serialize_string("EBI", dest),
            ECR => serialize_string("ECR", dest),
            EDO => serialize_string("EDO", dest),
            EFI => serialize_string("EFI", dest),
            ELL => serialize_string("ELL", dest),
            EMK => serialize_string("EMK", dest),
            ENG => serialize_string("ENG", dest),
            ERZ => serialize_string("ERZ", dest),
            ESP => serialize_string("ESP", dest),
            ESU => serialize_string("ESU", dest),
            ETI => serialize_string("ETI", dest),
            EUQ => serialize_string("EUQ", dest),
            EVK => serialize_string("EVK", dest),
            EVN => serialize_string("EVN", dest),
            EWE => serialize_string("EWE", dest),
            FAN => serialize_string("FAN", dest),
            FAR => serialize_string("FAR", dest),
            FAT => serialize_string("FAT", dest),
            FIN => serialize_string("FIN", dest),
            FJI => serialize_string("FJI", dest),
            FLE => serialize_string("FLE", dest),
            FMP => serialize_string("FMP", dest),
            FNE => serialize_string("FNE", dest),
            FON => serialize_string("FON", dest),
            FOS => serialize_string("FOS", dest),
            FRA => serialize_string("FRA", dest),
            FRC => serialize_string("FRC", dest),
            FRI => serialize_string("FRI", dest),
            FRL => serialize_string("FRL", dest),
            FRP => serialize_string("FRP", dest),
            FTA => serialize_string("FTA", dest),
            FUL => serialize_string("FUL", dest),
            FUV => serialize_string("FUV", dest),
            GAD => serialize_string("GAD", dest),
            GAE => serialize_string("GAE", dest),
            GAG => serialize_string("GAG", dest),
            GAL => serialize_string("GAL", dest),
            GAR => serialize_string("GAR", dest),
            GAW => serialize_string("GAW", dest),
            GEZ => serialize_string("GEZ", dest),
            GIH => serialize_string("GIH", dest),
            GIL => serialize_string("GIL", dest),
            GKP => serialize_string("GKP", dest),
            GLK => serialize_string("GLK", dest),
            GMZ => serialize_string("GMZ", dest),
            GNN => serialize_string("GNN", dest),
            GOG => serialize_string("GOG", dest),
            GON => serialize_string("GON", dest),
            GRN => serialize_string("GRN", dest),
            GRO => serialize_string("GRO", dest),
            GUA => serialize_string("GUA", dest),
            GUC => serialize_string("GUC", dest),
            GUF => serialize_string("GUF", dest),
            GUJ => serialize_string("GUJ", dest),
            GUZ => serialize_string("GUZ", dest),
            HAI => serialize_string("HAI", dest),
            HAL => serialize_string("HAL", dest),
            HAR => serialize_string("HAR", dest),
            HAU => serialize_string("HAU", dest),
            HAW => serialize_string("HAW", dest),
            HAY => serialize_string("HAY", dest),
            HAZ => serialize_string("HAZ", dest),
            HBN => serialize_string("HBN", dest),
            HER => serialize_string("HER", dest),
            HIL => serialize_string("HIL", dest),
            HIN => serialize_string("HIN", dest),
            HMA => serialize_string("HMA", dest),
            HMN => serialize_string("HMN", dest),
            HMO => serialize_string("HMO", dest),
            HND => serialize_string("HND", dest),
            HO => serialize_string("HO", dest),
            HRI => serialize_string("HRI", dest),
            HRV => serialize_string("HRV", dest),
            HUN => serialize_string("HUN", dest),
            HYE => serialize_string("HYE", dest),
            IBA => serialize_string("IBA", dest),
            IBB => serialize_string("IBB", dest),
            IBO => serialize_string("IBO", dest),
            IJO => serialize_string("IJO", dest),
            IDO => serialize_string("IDO", dest),
            ILE => serialize_string("ILE", dest),
            ILO => serialize_string("ILO", dest),
            INA => serialize_string("INA", dest),
            IND => serialize_string("IND", dest),
            ING => serialize_string("ING", dest),
            INU => serialize_string("INU", dest),
            IPK => serialize_string("IPK", dest),
            PPH => serialize_string("PPH", dest),
            IRI => serialize_string("IRI", dest),
            IRT => serialize_string("IRT", dest),
            ISL => serialize_string("ISL", dest),
            ISM => serialize_string("ISM", dest),
            ITA => serialize_string("ITA", dest),
            IWR => serialize_string("IWR", dest),
            JAM => serialize_string("JAM", dest),
            JAN => serialize_string("JAN", dest),
            JAV => serialize_string("JAV", dest),
            JBO => serialize_string("JBO", dest),
            JCT => serialize_string("JCT", dest),
            JII => serialize_string("JII", dest),
            JUD => serialize_string("JUD", dest),
            JUL => serialize_string("JUL", dest),
            KAB => serialize_string("KAB", dest),
            KAC => serialize_string("KAC", dest),
            KAL => serialize_string("KAL", dest),
            KAN => serialize_string("KAN", dest),
            KAR => serialize_string("KAR", dest),
            KAT => serialize_string("KAT", dest),
            KAZ => serialize_string("KAZ", dest),
            KDE => serialize_string("KDE", dest),
            KEA => serialize_string("KEA", dest),
            KEB => serialize_string("KEB", dest),
            KEK => serialize_string("KEK", dest),
            KGE => serialize_string("KGE", dest),
            KHA => serialize_string("KHA", dest),
            KHK => serialize_string("KHK", dest),
            KHM => serialize_string("KHM", dest),
            KHS => serialize_string("KHS", dest),
            KHT => serialize_string("KHT", dest),
            KHV => serialize_string("KHV", dest),
            KHW => serialize_string("KHW", dest),
            KIK => serialize_string("KIK", dest),
            KIR => serialize_string("KIR", dest),
            KIS => serialize_string("KIS", dest),
            KIU => serialize_string("KIU", dest),
            KJD => serialize_string("KJD", dest),
            KJP => serialize_string("KJP", dest),
            KKN => serialize_string("KKN", dest),
            KLM => serialize_string("KLM", dest),
            KMB => serialize_string("KMB", dest),
            KMN => serialize_string("KMN", dest),
            KMO => serialize_string("KMO", dest),
            KMS => serialize_string("KMS", dest),
            KMZ => serialize_string("KMZ", dest),
            KNR => serialize_string("KNR", dest),
            KOD => serialize_string("KOD", dest),
            KOH => serialize_string("KOH", dest),
            KOK => serialize_string("KOK", dest),
            KOM => serialize_string("KOM", dest),
            KON => serialize_string("KON", dest),
            KOP => serialize_string("KOP", dest),
            KOR => serialize_string("KOR", dest),
            KOS => serialize_string("KOS", dest),
            KOZ => serialize_string("KOZ", dest),
            KPL => serialize_string("KPL", dest),
            KRI => serialize_string("KRI", dest),
            KRK => serialize_string("KRK", dest),
            KRL => serialize_string("KRL", dest),
            KRM => serialize_string("KRM", dest),
            KRN => serialize_string("KRN", dest),
            KRT => serialize_string("KRT", dest),
            KSH => serialize_string("KSH", dest),
            KSI => serialize_string("KSI", dest),
            KSM => serialize_string("KSM", dest),
            KSW => serialize_string("KSW", dest),
            KUA => serialize_string("KUA", dest),
            KUI => serialize_string("KUI", dest),
            KUL => serialize_string("KUL", dest),
            KUM => serialize_string("KUM", dest),
            KUR => serialize_string("KUR", dest),
            KUU => serialize_string("KUU", dest),
            KUY => serialize_string("KUY", dest),
            KYK => serialize_string("KYK", dest),
            KYU => serialize_string("KYU", dest),
            LAD => serialize_string("LAD", dest),
            LAH => serialize_string("LAH", dest),
            LAK => serialize_string("LAK", dest),
            LAM => serialize_string("LAM", dest),
            LAO => serialize_string("LAO", dest),
            LAT => serialize_string("LAT", dest),
            LAZ => serialize_string("LAZ", dest),
            LCR => serialize_string("LCR", dest),
            LDK => serialize_string("LDK", dest),
            LEZ => serialize_string("LEZ", dest),
            LIJ => serialize_string("LIJ", dest),
            LIM => serialize_string("LIM", dest),
            LIN => serialize_string("LIN", dest),
            LIS => serialize_string("LIS", dest),
            LJP => serialize_string("LJP", dest),
            LKI => serialize_string("LKI", dest),
            LMA => serialize_string("LMA", dest),
            LMB => serialize_string("LMB", dest),
            LMO => serialize_string("LMO", dest),
            LMW => serialize_string("LMW", dest),
            LOM => serialize_string("LOM", dest),
            LRC => serialize_string("LRC", dest),
            LSB => serialize_string("LSB", dest),
            LSM => serialize_string("LSM", dest),
            LTH => serialize_string("LTH", dest),
            LTZ => serialize_string("LTZ", dest),
            LUA => serialize_string("LUA", dest),
            LUB => serialize_string("LUB", dest),
            LUG => serialize_string("LUG", dest),
            LUH => serialize_string("LUH", dest),
            LUO => serialize_string("LUO", dest),
            LVI => serialize_string("LVI", dest),
            MAD => serialize_string("MAD", dest),
            MAG => serialize_string("MAG", dest),
            MAH => serialize_string("MAH", dest),
            MAJ => serialize_string("MAJ", dest),
            MAK => serialize_string("MAK", dest),
            MAL => serialize_string("MAL", dest),
            MAM => serialize_string("MAM", dest),
            MAN => serialize_string("MAN", dest),
            MAP => serialize_string("MAP", dest),
            MAR => serialize_string("MAR", dest),
            MAW => serialize_string("MAW", dest),
            MBN => serialize_string("MBN", dest),
            MBO => serialize_string("MBO", dest),
            MCH => serialize_string("MCH", dest),
            MCR => serialize_string("MCR", dest),
            MDE => serialize_string("MDE", dest),
            MDR => serialize_string("MDR", dest),
            MEN => serialize_string("MEN", dest),
            MER => serialize_string("MER", dest),
            MFE => serialize_string("MFE", dest),
            MIN => serialize_string("MIN", dest),
            MIZ => serialize_string("MIZ", dest),
            MKD => serialize_string("MKD", dest),
            MKR => serialize_string("MKR", dest),
            MKW => serialize_string("MKW", dest),
            MLE => serialize_string("MLE", dest),
            MLG => serialize_string("MLG", dest),
            MLN => serialize_string("MLN", dest),
            MLR => serialize_string("MLR", dest),
            MLY => serialize_string("MLY", dest),
            MND => serialize_string("MND", dest),
            MNG => serialize_string("MNG", dest),
            MNI => serialize_string("MNI", dest),
            MNK => serialize_string("MNK", dest),
            MNX => serialize_string("MNX", dest),
            MOH => serialize_string("MOH", dest),
            MOK => serialize_string("MOK", dest),
            MOL => serialize_string("MOL", dest),
            MON => serialize_string("MON", dest),
            MOR => serialize_string("MOR", dest),
            MOS => serialize_string("MOS", dest),
            MRI => serialize_string("MRI", dest),
            MTH => serialize_string("MTH", dest),
            MTS => serialize_string("MTS", dest),
            MUN => serialize_string("MUN", dest),
            MUS => serialize_string("MUS", dest),
            MWL => serialize_string("MWL", dest),
            MWW => serialize_string("MWW", dest),
            MYN => serialize_string("MYN", dest),
            MZN => serialize_string("MZN", dest),
            NAG => serialize_string("NAG", dest),
            NAH => serialize_string("NAH", dest),
            NAN => serialize_string("NAN", dest),
            NAP => serialize_string("NAP", dest),
            NAS => serialize_string("NAS", dest),
            NAU => serialize_string("NAU", dest),
            NAV => serialize_string("NAV", dest),
            NCR => serialize_string("NCR", dest),
            NDB => serialize_string("NDB", dest),
            NDC => serialize_string("NDC", dest),
            NDG => serialize_string("NDG", dest),
            NDS => serialize_string("NDS", dest),
            NEP => serialize_string("NEP", dest),
            NEW => serialize_string("NEW", dest),
            NGA => serialize_string("NGA", dest),
            NGR => serialize_string("NGR", dest),
            NHC => serialize_string("NHC", dest),
            NIS => serialize_string("NIS", dest),
            NIU => serialize_string("NIU", dest),
            NKL => serialize_string("NKL", dest),
            NKO => serialize_string("NKO", dest),
            NLD => serialize_string("NLD", dest),
            NOE => serialize_string("NOE", dest),
            NOG => serialize_string("NOG", dest),
            NOR => serialize_string("NOR", dest),
            NOV => serialize_string("NOV", dest),
            NSM => serialize_string("NSM", dest),
            NSO => serialize_string("NSO", dest),
            NTA => serialize_string("NTA", dest),
            NTO => serialize_string("NTO", dest),
            NYM => serialize_string("NYM", dest),
            NYN => serialize_string("NYN", dest),
            NZA => serialize_string("NZA", dest),
            OCI => serialize_string("OCI", dest),
            OCR => serialize_string("OCR", dest),
            OJB => serialize_string("OJB", dest),
            ORI => serialize_string("ORI", dest),
            ORO => serialize_string("ORO", dest),
            OSS => serialize_string("OSS", dest),
            PAA => serialize_string("PAA", dest),
            PAG => serialize_string("PAG", dest),
            PAL => serialize_string("PAL", dest),
            PAM => serialize_string("PAM", dest),
            PAN => serialize_string("PAN", dest),
            PAP => serialize_string("PAP", dest),
            PAS => serialize_string("PAS", dest),
            PAU => serialize_string("PAU", dest),
            PCC => serialize_string("PCC", dest),
            PCD => serialize_string("PCD", dest),
            PDC => serialize_string("PDC", dest),
            PGR => serialize_string("PGR", dest),
            PHK => serialize_string("PHK", dest),
            PIH => serialize_string("PIH", dest),
            PIL => serialize_string("PIL", dest),
            PLG => serialize_string("PLG", dest),
            PLK => serialize_string("PLK", dest),
            PMS => serialize_string("PMS", dest),
            PNB => serialize_string("PNB", dest),
            POH => serialize_string("POH", dest),
            PON => serialize_string("PON", dest),
            PRO => serialize_string("PRO", dest),
            PTG => serialize_string("PTG", dest),
            PWO => serialize_string("PWO", dest),
            QIN => serialize_string("QIN", dest),
            QUC => serialize_string("QUC", dest),
            QUH => serialize_string("QUH", dest),
            QUZ => serialize_string("QUZ", dest),
            QVI => serialize_string("QVI", dest),
            QWH => serialize_string("QWH", dest),
            RAJ => serialize_string("RAJ", dest),
            RAR => serialize_string("RAR", dest),
            RBU => serialize_string("RBU", dest),
            RCR => serialize_string("RCR", dest),
            REJ => serialize_string("REJ", dest),
            RIA => serialize_string("RIA", dest),
            RIF => serialize_string("RIF", dest),
            RIT => serialize_string("RIT", dest),
            RKW => serialize_string("RKW", dest),
            RMS => serialize_string("RMS", dest),
            RMY => serialize_string("RMY", dest),
            ROM => serialize_string("ROM", dest),
            ROY => serialize_string("ROY", dest),
            RSY => serialize_string("RSY", dest),
            RTM => serialize_string("RTM", dest),
            RUA => serialize_string("RUA", dest),
            RUN => serialize_string("RUN", dest),
            RUP => serialize_string("RUP", dest),
            RUS => serialize_string("RUS", dest),
            SAD => serialize_string("SAD", dest),
            SAN => serialize_string("SAN", dest),
            SAS => serialize_string("SAS", dest),
            SAT => serialize_string("SAT", dest),
            SAY => serialize_string("SAY", dest),
            SCN => serialize_string("SCN", dest),
            SCO => serialize_string("SCO", dest),
            SEK => serialize_string("SEK", dest),
            SEL => serialize_string("SEL", dest),
            SGA => serialize_string("SGA", dest),
            SGO => serialize_string("SGO", dest),
            SGS => serialize_string("SGS", dest),
            SHI => serialize_string("SHI", dest),
            SHN => serialize_string("SHN", dest),
            SIB => serialize_string("SIB", dest),
            SID => serialize_string("SID", dest),
            SIG => serialize_string("SIG", dest),
            SKS => serialize_string("SKS", dest),
            SKY => serialize_string("SKY", dest),
            SCS => serialize_string("SCS", dest),
            SLA => serialize_string("SLA", dest),
            SLV => serialize_string("SLV", dest),
            SML => serialize_string("SML", dest),
            SMO => serialize_string("SMO", dest),
            SNA => serialize_string("SNA", dest),
            SND => serialize_string("SND", dest),
            SNH => serialize_string("SNH", dest),
            SNK => serialize_string("SNK", dest),
            SOG => serialize_string("SOG", dest),
            SOP => serialize_string("SOP", dest),
            SOT => serialize_string("SOT", dest),
            SQI => serialize_string("SQI", dest),
            SRB => serialize_string("SRB", dest),
            SRD => serialize_string("SRD", dest),
            SRK => serialize_string("SRK", dest),
            SRR => serialize_string("SRR", dest),
            SSL => serialize_string("SSL", dest),
            SSM => serialize_string("SSM", dest),
            STQ => serialize_string("STQ", dest),
            SUK => serialize_string("SUK", dest),
            SUN => serialize_string("SUN", dest),
            SUR => serialize_string("SUR", dest),
            SVA => serialize_string("SVA", dest),
            SVE => serialize_string("SVE", dest),
            SWA => serialize_string("SWA", dest),
            SWK => serialize_string("SWK", dest),
            SWZ => serialize_string("SWZ", dest),
            SXT => serialize_string("SXT", dest),
            SXU => serialize_string("SXU", dest),
            SYL => serialize_string("SYL", dest),
            SYR => serialize_string("SYR", dest),
            YRE => serialize_string("YRE", dest),
            YRJ => serialize_string("YRJ", dest),
            YRN => serialize_string("YRN", dest),
            SZL => serialize_string("SZL", dest),
            TAB => serialize_string("TAB", dest),
            TAJ => serialize_string("TAJ", dest),
            TAM => serialize_string("TAM", dest),
            TAT => serialize_string("TAT", dest),
            TCR => serialize_string("TCR", dest),
            TDD => serialize_string("TDD", dest),
            TEL => serialize_string("TEL", dest),
            TET => serialize_string("TET", dest),
            TGL => serialize_string("TGL", dest),
            TGN => serialize_string("TGN", dest),
            TGR => serialize_string("TGR", dest),
            TGY => serialize_string("TGY", dest),
            THA => serialize_string("THA", dest),
            THT => serialize_string("THT", dest),
            TIB => serialize_string("TIB", dest),
            TIV => serialize_string("TIV", dest),
            TKM => serialize_string("TKM", dest),
            TMH => serialize_string("TMH", dest),
            TMN => serialize_string("TMN", dest),
            TNA => serialize_string("TNA", dest),
            TNE => serialize_string("TNE", dest),
            TNG => serialize_string("TNG", dest),
            TOD => serialize_string("TOD", dest),
            TPI => serialize_string("TPI", dest),
            TRK => serialize_string("TRK", dest),
            TSG => serialize_string("TSG", dest),
            TUA => serialize_string("TUA", dest),
            TUM => serialize_string("TUM", dest),
            TUL => serialize_string("TUL", dest),
            TUV => serialize_string("TUV", dest),
            TVL => serialize_string("TVL", dest),
            TWI => serialize_string("TWI", dest),
            TYZ => serialize_string("TYZ", dest),
            TZM => serialize_string("TZM", dest),
            TZO => serialize_string("TZO", dest),
            UDM => serialize_string("UDM", dest),
            UKR => serialize_string("UKR", dest),
            UMB => serialize_string("UMB", dest),
            URD => serialize_string("URD", dest),
            USB => serialize_string("USB", dest),
            UYG => serialize_string("UYG", dest),
            UZB => serialize_string("UZB", dest),
            VEC => serialize_string("VEC", dest),
            VEN => serialize_string("VEN", dest),
            VIT => serialize_string("VIT", dest),
            VOL => serialize_string("VOL", dest),
            VRO => serialize_string("VRO", dest),
            WA => serialize_string("WA", dest),
            WAG => serialize_string("WAG", dest),
            WAR => serialize_string("WAR", dest),
            WCR => serialize_string("WCR", dest),
            WEL => serialize_string("WEL", dest),
            WLN => serialize_string("WLN", dest),
            WLF => serialize_string("WLF", dest),
            WTM => serialize_string("WTM", dest),
            XBD => serialize_string("XBD", dest),
            XHS => serialize_string("XHS", dest),
            XJB => serialize_string("XJB", dest),
            XOG => serialize_string("XOG", dest),
            XPE => serialize_string("XPE", dest),
            YAK => serialize_string("YAK", dest),
            YAO => serialize_string("YAO", dest),
            YAP => serialize_string("YAP", dest),
            YBA => serialize_string("YBA", dest),
            YCR => serialize_string("YCR", dest),
            YIC => serialize_string("YIC", dest),
            YIM => serialize_string("YIM", dest),
            ZEA => serialize_string("ZEA", dest),
            ZGH => serialize_string("ZGH", dest),
            ZHA => serialize_string("ZHA", dest),
            ZHH => serialize_string("ZHH", dest),
            ZHP => serialize_string("ZHP", dest),
            ZHS => serialize_string("ZHS", dest),
            ZHT => serialize_string("ZHT", dest),
            ZND => serialize_string("ZND", dest),
            ZUL => serialize_string("ZUL", dest),
            ZZA => serialize_string("ZZA", dest),
        }
    }
}

impl OpenTypeLanguageTag {
    pub(crate) fn parse<'i>(
        tag: &'i CowRcStr,
    ) -> Result<Self, ParseError<'i, CustomParseError<'i>>> {
        use self::OpenTypeLanguageTag::*;

        match tag.as_ref() {
            "ABA" => Ok(ABA),
            "ABK" => Ok(ABK),
            "ACH" => Ok(ACH),
            "ACR" => Ok(ACR),
            "ADY" => Ok(ADY),
            "AFK" => Ok(AFK),
            "AFR" => Ok(AFR),
            "AGW" => Ok(AGW),
            "AIO" => Ok(AIO),
            "AKA" => Ok(AKA),
            "ALS" => Ok(ALS),
            "ALT" => Ok(ALT),
            "AMH" => Ok(AMH),
            "ANG" => Ok(ANG),
            "ARA" => Ok(ARA),
            "ARG" => Ok(ARG),
            "ARI" => Ok(ARI),
            "ARK" => Ok(ARK),
            "ASM" => Ok(ASM),
            "AST" => Ok(AST),
            "ATH" => Ok(ATH),
            "AVR" => Ok(AVR),
            "AWA" => Ok(AWA),
            "AYM" => Ok(AYM),
            "AZB" => Ok(AZB),
            "AZE" => Ok(AZE),
            "BAD" => Ok(BAD),
            "BAG" => Ok(BAG),
            "BAL" => Ok(BAL),
            "BAN" => Ok(BAN),
            "BAR" => Ok(BAR),
            "BAU" => Ok(BAU),
            "BBC" => Ok(BBC),
            "BBR" => Ok(BBR),
            "BCH" => Ok(BCH),
            "BCR" => Ok(BCR),
            "BDY" => Ok(BDY),
            "BEL" => Ok(BEL),
            "BEM" => Ok(BEM),
            "BEN" => Ok(BEN),
            "BGC" => Ok(BGC),
            "BGQ" => Ok(BGQ),
            "BGR" => Ok(BGR),
            "BHI" => Ok(BHI),
            "BHO" => Ok(BHO),
            "BIK" => Ok(BIK),
            "BIL" => Ok(BIL),
            "BIS" => Ok(BIS),
            "BKF" => Ok(BKF),
            "BLI" => Ok(BLI),
            "BLK" => Ok(BLK),
            "BLN" => Ok(BLN),
            "BLT" => Ok(BLT),
            "BMB" => Ok(BMB),
            "BML" => Ok(BML),
            "BOS" => Ok(BOS),
            "BPY" => Ok(BPY),
            "BRE" => Ok(BRE),
            "BRH" => Ok(BRH),
            "BRI" => Ok(BRI),
            "BRM" => Ok(BRM),
            "BRX" => Ok(BRX),
            "BSH" => Ok(BSH),
            "BSK" => Ok(BSK),
            "BTI" => Ok(BTI),
            "BTS" => Ok(BTS),
            "BUG" => Ok(BUG),
            "BYV" => Ok(BYV),
            "CAK" => Ok(CAK),
            "CAT" => Ok(CAT),
            "CBK" => Ok(CBK),
            "CHN" => Ok(CHN),
            "CEB" => Ok(CEB),
            "CHE" => Ok(CHE),
            "CHG" => Ok(CHG),
            "CHH" => Ok(CHH),
            "CHI" => Ok(CHI),
            "CHK" => Ok(CHK),
            "CHO" => Ok(CHO),
            "CHP" => Ok(CHP),
            "CHR" => Ok(CHR),
            "CHA" => Ok(CHA),
            "CHU" => Ok(CHU),
            "CHY" => Ok(CHY),
            "CGG" => Ok(CGG),
            "CJA" => Ok(CJA),
            "CJM" => Ok(CJM),
            "CMR" => Ok(CMR),
            "COP" => Ok(COP),
            "COR" => Ok(COR),
            "COS" => Ok(COS),
            "CPP" => Ok(CPP),
            "CRE" => Ok(CRE),
            "CRR" => Ok(CRR),
            "CRT" => Ok(CRT),
            "CSB" => Ok(CSB),
            "CSL" => Ok(CSL),
            "CSY" => Ok(CSY),
            "CTG" => Ok(CTG),
            "CUK" => Ok(CUK),
            "DAN" => Ok(DAN),
            "DAR" => Ok(DAR),
            "DAX" => Ok(DAX),
            "DCR" => Ok(DCR),
            "DEU" => Ok(DEU),
            "DGO" => Ok(DGO),
            "DGR" => Ok(DGR),
            "DHG" => Ok(DHG),
            "DHV" => Ok(DHV),
            "DIQ" => Ok(DIQ),
            "DIV" => Ok(DIV),
            "DJR" => Ok(DJR),
            "DNG" => Ok(DNG),
            "DNJ" => Ok(DNJ),
            "DNK" => Ok(DNK),
            "DRI" => Ok(DRI),
            "DUJ" => Ok(DUJ),
            "DUN" => Ok(DUN),
            "DZN" => Ok(DZN),
            "EBI" => Ok(EBI),
            "ECR" => Ok(ECR),
            "EDO" => Ok(EDO),
            "EFI" => Ok(EFI),
            "ELL" => Ok(ELL),
            "EMK" => Ok(EMK),
            "ENG" => Ok(ENG),
            "ERZ" => Ok(ERZ),
            "ESP" => Ok(ESP),
            "ESU" => Ok(ESU),
            "ETI" => Ok(ETI),
            "EUQ" => Ok(EUQ),
            "EVK" => Ok(EVK),
            "EVN" => Ok(EVN),
            "EWE" => Ok(EWE),
            "FAN" => Ok(FAN),
            "FAR" => Ok(FAR),
            "FAT" => Ok(FAT),
            "FIN" => Ok(FIN),
            "FJI" => Ok(FJI),
            "FLE" => Ok(FLE),
            "FMP" => Ok(FMP),
            "FNE" => Ok(FNE),
            "FON" => Ok(FON),
            "FOS" => Ok(FOS),
            "FRA" => Ok(FRA),
            "FRC" => Ok(FRC),
            "FRI" => Ok(FRI),
            "FRL" => Ok(FRL),
            "FRP" => Ok(FRP),
            "FTA" => Ok(FTA),
            "FUL" => Ok(FUL),
            "FUV" => Ok(FUV),
            "GAD" => Ok(GAD),
            "GAE" => Ok(GAE),
            "GAG" => Ok(GAG),
            "GAL" => Ok(GAL),
            "GAR" => Ok(GAR),
            "GAW" => Ok(GAW),
            "GEZ" => Ok(GEZ),
            "GIH" => Ok(GIH),
            "GIL" => Ok(GIL),
            "GKP" => Ok(GKP),
            "GLK" => Ok(GLK),
            "GMZ" => Ok(GMZ),
            "GNN" => Ok(GNN),
            "GOG" => Ok(GOG),
            "GON" => Ok(GON),
            "GRN" => Ok(GRN),
            "GRO" => Ok(GRO),
            "GUA" => Ok(GUA),
            "GUC" => Ok(GUC),
            "GUF" => Ok(GUF),
            "GUJ" => Ok(GUJ),
            "GUZ" => Ok(GUZ),
            "HAI" => Ok(HAI),
            "HAL" => Ok(HAL),
            "HAR" => Ok(HAR),
            "HAU" => Ok(HAU),
            "HAW" => Ok(HAW),
            "HAY" => Ok(HAY),
            "HAZ" => Ok(HAZ),
            "HBN" => Ok(HBN),
            "HER" => Ok(HER),
            "HIL" => Ok(HIL),
            "HIN" => Ok(HIN),
            "HMA" => Ok(HMA),
            "HMN" => Ok(HMN),
            "HMO" => Ok(HMO),
            "HND" => Ok(HND),
            "HO" => Ok(HO),
            "HRI" => Ok(HRI),
            "HRV" => Ok(HRV),
            "HUN" => Ok(HUN),
            "HYE" => Ok(HYE),
            "IBA" => Ok(IBA),
            "IBB" => Ok(IBB),
            "IBO" => Ok(IBO),
            "IJO" => Ok(IJO),
            "IDO" => Ok(IDO),
            "ILE" => Ok(ILE),
            "ILO" => Ok(ILO),
            "INA" => Ok(INA),
            "IND" => Ok(IND),
            "ING" => Ok(ING),
            "INU" => Ok(INU),
            "IPK" => Ok(IPK),
            "PPH" => Ok(PPH),
            "IRI" => Ok(IRI),
            "IRT" => Ok(IRT),
            "ISL" => Ok(ISL),
            "ISM" => Ok(ISM),
            "ITA" => Ok(ITA),
            "IWR" => Ok(IWR),
            "JAM" => Ok(JAM),
            "JAN" => Ok(JAN),
            "JAV" => Ok(JAV),
            "JBO" => Ok(JBO),
            "JCT" => Ok(JCT),
            "JII" => Ok(JII),
            "JUD" => Ok(JUD),
            "JUL" => Ok(JUL),
            "KAB" => Ok(KAB),
            "KAC" => Ok(KAC),
            "KAL" => Ok(KAL),
            "KAN" => Ok(KAN),
            "KAR" => Ok(KAR),
            "KAT" => Ok(KAT),
            "KAZ" => Ok(KAZ),
            "KDE" => Ok(KDE),
            "KEA" => Ok(KEA),
            "KEB" => Ok(KEB),
            "KEK" => Ok(KEK),
            "KGE" => Ok(KGE),
            "KHA" => Ok(KHA),
            "KHK" => Ok(KHK),
            "KHM" => Ok(KHM),
            "KHS" => Ok(KHS),
            "KHT" => Ok(KHT),
            "KHV" => Ok(KHV),
            "KHW" => Ok(KHW),
            "KIK" => Ok(KIK),
            "KIR" => Ok(KIR),
            "KIS" => Ok(KIS),
            "KIU" => Ok(KIU),
            "KJD" => Ok(KJD),
            "KJP" => Ok(KJP),
            "KKN" => Ok(KKN),
            "KLM" => Ok(KLM),
            "KMB" => Ok(KMB),
            "KMN" => Ok(KMN),
            "KMO" => Ok(KMO),
            "KMS" => Ok(KMS),
            "KMZ" => Ok(KMZ),
            "KNR" => Ok(KNR),
            "KOD" => Ok(KOD),
            "KOH" => Ok(KOH),
            "KOK" => Ok(KOK),
            "KOM" => Ok(KOM),
            "KON" => Ok(KON),
            "KOP" => Ok(KOP),
            "KOR" => Ok(KOR),
            "KOS" => Ok(KOS),
            "KOZ" => Ok(KOZ),
            "KPL" => Ok(KPL),
            "KRI" => Ok(KRI),
            "KRK" => Ok(KRK),
            "KRL" => Ok(KRL),
            "KRM" => Ok(KRM),
            "KRN" => Ok(KRN),
            "KRT" => Ok(KRT),
            "KSH" => Ok(KSH),
            "KSI" => Ok(KSI),
            "KSM" => Ok(KSM),
            "KSW" => Ok(KSW),
            "KUA" => Ok(KUA),
            "KUI" => Ok(KUI),
            "KUL" => Ok(KUL),
            "KUM" => Ok(KUM),
            "KUR" => Ok(KUR),
            "KUU" => Ok(KUU),
            "KUY" => Ok(KUY),
            "KYK" => Ok(KYK),
            "KYU" => Ok(KYU),
            "LAD" => Ok(LAD),
            "LAH" => Ok(LAH),
            "LAK" => Ok(LAK),
            "LAM" => Ok(LAM),
            "LAO" => Ok(LAO),
            "LAT" => Ok(LAT),
            "LAZ" => Ok(LAZ),
            "LCR" => Ok(LCR),
            "LDK" => Ok(LDK),
            "LEZ" => Ok(LEZ),
            "LIJ" => Ok(LIJ),
            "LIM" => Ok(LIM),
            "LIN" => Ok(LIN),
            "LIS" => Ok(LIS),
            "LJP" => Ok(LJP),
            "LKI" => Ok(LKI),
            "LMA" => Ok(LMA),
            "LMB" => Ok(LMB),
            "LMO" => Ok(LMO),
            "LMW" => Ok(LMW),
            "LOM" => Ok(LOM),
            "LRC" => Ok(LRC),
            "LSB" => Ok(LSB),
            "LSM" => Ok(LSM),
            "LTH" => Ok(LTH),
            "LTZ" => Ok(LTZ),
            "LUA" => Ok(LUA),
            "LUB" => Ok(LUB),
            "LUG" => Ok(LUG),
            "LUH" => Ok(LUH),
            "LUO" => Ok(LUO),
            "LVI" => Ok(LVI),
            "MAD" => Ok(MAD),
            "MAG" => Ok(MAG),
            "MAH" => Ok(MAH),
            "MAJ" => Ok(MAJ),
            "MAK" => Ok(MAK),
            "MAL" => Ok(MAL),
            "MAM" => Ok(MAM),
            "MAN" => Ok(MAN),
            "MAP" => Ok(MAP),
            "MAR" => Ok(MAR),
            "MAW" => Ok(MAW),
            "MBN" => Ok(MBN),
            "MBO" => Ok(MBO),
            "MCH" => Ok(MCH),
            "MCR" => Ok(MCR),
            "MDE" => Ok(MDE),
            "MDR" => Ok(MDR),
            "MEN" => Ok(MEN),
            "MER" => Ok(MER),
            "MFE" => Ok(MFE),
            "MIN" => Ok(MIN),
            "MIZ" => Ok(MIZ),
            "MKD" => Ok(MKD),
            "MKR" => Ok(MKR),
            "MKW" => Ok(MKW),
            "MLE" => Ok(MLE),
            "MLG" => Ok(MLG),
            "MLN" => Ok(MLN),
            "MLR" => Ok(MLR),
            "MLY" => Ok(MLY),
            "MND" => Ok(MND),
            "MNG" => Ok(MNG),
            "MNI" => Ok(MNI),
            "MNK" => Ok(MNK),
            "MNX" => Ok(MNX),
            "MOH" => Ok(MOH),
            "MOK" => Ok(MOK),
            "MOL" => Ok(MOL),
            "MON" => Ok(MON),
            "MOR" => Ok(MOR),
            "MOS" => Ok(MOS),
            "MRI" => Ok(MRI),
            "MTH" => Ok(MTH),
            "MTS" => Ok(MTS),
            "MUN" => Ok(MUN),
            "MUS" => Ok(MUS),
            "MWL" => Ok(MWL),
            "MWW" => Ok(MWW),
            "MYN" => Ok(MYN),
            "MZN" => Ok(MZN),
            "NAG" => Ok(NAG),
            "NAH" => Ok(NAH),
            "NAN" => Ok(NAN),
            "NAP" => Ok(NAP),
            "NAS" => Ok(NAS),
            "NAU" => Ok(NAU),
            "NAV" => Ok(NAV),
            "NCR" => Ok(NCR),
            "NDB" => Ok(NDB),
            "NDC" => Ok(NDC),
            "NDG" => Ok(NDG),
            "NDS" => Ok(NDS),
            "NEP" => Ok(NEP),
            "NEW" => Ok(NEW),
            "NGA" => Ok(NGA),
            "NGR" => Ok(NGR),
            "NHC" => Ok(NHC),
            "NIS" => Ok(NIS),
            "NIU" => Ok(NIU),
            "NKL" => Ok(NKL),
            "NKO" => Ok(NKO),
            "NLD" => Ok(NLD),
            "NOE" => Ok(NOE),
            "NOG" => Ok(NOG),
            "NOR" => Ok(NOR),
            "NOV" => Ok(NOV),
            "NSM" => Ok(NSM),
            "NSO" => Ok(NSO),
            "NTA" => Ok(NTA),
            "NTO" => Ok(NTO),
            "NYM" => Ok(NYM),
            "NYN" => Ok(NYN),
            "NZA" => Ok(NZA),
            "OCI" => Ok(OCI),
            "OCR" => Ok(OCR),
            "OJB" => Ok(OJB),
            "ORI" => Ok(ORI),
            "ORO" => Ok(ORO),
            "OSS" => Ok(OSS),
            "PAA" => Ok(PAA),
            "PAG" => Ok(PAG),
            "PAL" => Ok(PAL),
            "PAM" => Ok(PAM),
            "PAN" => Ok(PAN),
            "PAP" => Ok(PAP),
            "PAS" => Ok(PAS),
            "PAU" => Ok(PAU),
            "PCC" => Ok(PCC),
            "PCD" => Ok(PCD),
            "PDC" => Ok(PDC),
            "PGR" => Ok(PGR),
            "PHK" => Ok(PHK),
            "PIH" => Ok(PIH),
            "PIL" => Ok(PIL),
            "PLG" => Ok(PLG),
            "PLK" => Ok(PLK),
            "PMS" => Ok(PMS),
            "PNB" => Ok(PNB),
            "POH" => Ok(POH),
            "PON" => Ok(PON),
            "PRO" => Ok(PRO),
            "PTG" => Ok(PTG),
            "PWO" => Ok(PWO),
            "QIN" => Ok(QIN),
            "QUC" => Ok(QUC),
            "QUH" => Ok(QUH),
            "QUZ" => Ok(QUZ),
            "QVI" => Ok(QVI),
            "QWH" => Ok(QWH),
            "RAJ" => Ok(RAJ),
            "RAR" => Ok(RAR),
            "RBU" => Ok(RBU),
            "RCR" => Ok(RCR),
            "REJ" => Ok(REJ),
            "RIA" => Ok(RIA),
            "RIF" => Ok(RIF),
            "RIT" => Ok(RIT),
            "RKW" => Ok(RKW),
            "RMS" => Ok(RMS),
            "RMY" => Ok(RMY),
            "ROM" => Ok(ROM),
            "ROY" => Ok(ROY),
            "RSY" => Ok(RSY),
            "RTM" => Ok(RTM),
            "RUA" => Ok(RUA),
            "RUN" => Ok(RUN),
            "RUP" => Ok(RUP),
            "RUS" => Ok(RUS),
            "SAD" => Ok(SAD),
            "SAN" => Ok(SAN),
            "SAS" => Ok(SAS),
            "SAT" => Ok(SAT),
            "SAY" => Ok(SAY),
            "SCN" => Ok(SCN),
            "SCO" => Ok(SCO),
            "SEK" => Ok(SEK),
            "SEL" => Ok(SEL),
            "SGA" => Ok(SGA),
            "SGO" => Ok(SGO),
            "SGS" => Ok(SGS),
            "SHI" => Ok(SHI),
            "SHN" => Ok(SHN),
            "SIB" => Ok(SIB),
            "SID" => Ok(SID),
            "SIG" => Ok(SIG),
            "SKS" => Ok(SKS),
            "SKY" => Ok(SKY),
            "SCS" => Ok(SCS),
            "SLA" => Ok(SLA),
            "SLV" => Ok(SLV),
            "SML" => Ok(SML),
            "SMO" => Ok(SMO),
            "SNA" => Ok(SNA),
            "SND" => Ok(SND),
            "SNH" => Ok(SNH),
            "SNK" => Ok(SNK),
            "SOG" => Ok(SOG),
            "SOP" => Ok(SOP),
            "SOT" => Ok(SOT),
            "SQI" => Ok(SQI),
            "SRB" => Ok(SRB),
            "SRD" => Ok(SRD),
            "SRK" => Ok(SRK),
            "SRR" => Ok(SRR),
            "SSL" => Ok(SSL),
            "SSM" => Ok(SSM),
            "STQ" => Ok(STQ),
            "SUK" => Ok(SUK),
            "SUN" => Ok(SUN),
            "SUR" => Ok(SUR),
            "SVA" => Ok(SVA),
            "SVE" => Ok(SVE),
            "SWA" => Ok(SWA),
            "SWK" => Ok(SWK),
            "SWZ" => Ok(SWZ),
            "SXT" => Ok(SXT),
            "SXU" => Ok(SXU),
            "SYL" => Ok(SYL),
            "SYR" => Ok(SYR),
            "YRE" => Ok(YRE),
            "YRJ" => Ok(YRJ),
            "YRN" => Ok(YRN),
            "SZL" => Ok(SZL),
            "TAB" => Ok(TAB),
            "TAJ" => Ok(TAJ),
            "TAM" => Ok(TAM),
            "TAT" => Ok(TAT),
            "TCR" => Ok(TCR),
            "TDD" => Ok(TDD),
            "TEL" => Ok(TEL),
            "TET" => Ok(TET),
            "TGL" => Ok(TGL),
            "TGN" => Ok(TGN),
            "TGR" => Ok(TGR),
            "TGY" => Ok(TGY),
            "THA" => Ok(THA),
            "THT" => Ok(THT),
            "TIB" => Ok(TIB),
            "TIV" => Ok(TIV),
            "TKM" => Ok(TKM),
            "TMH" => Ok(TMH),
            "TMN" => Ok(TMN),
            "TNA" => Ok(TNA),
            "TNE" => Ok(TNE),
            "TNG" => Ok(TNG),
            "TOD" => Ok(TOD),
            "TPI" => Ok(TPI),
            "TRK" => Ok(TRK),
            "TSG" => Ok(TSG),
            "TUA" => Ok(TUA),
            "TUM" => Ok(TUM),
            "TUL" => Ok(TUL),
            "TUV" => Ok(TUV),
            "TVL" => Ok(TVL),
            "TWI" => Ok(TWI),
            "TYZ" => Ok(TYZ),
            "TZM" => Ok(TZM),
            "TZO" => Ok(TZO),
            "UDM" => Ok(UDM),
            "UKR" => Ok(UKR),
            "UMB" => Ok(UMB),
            "URD" => Ok(URD),
            "USB" => Ok(USB),
            "UYG" => Ok(UYG),
            "UZB" => Ok(UZB),
            "VEC" => Ok(VEC),
            "VEN" => Ok(VEN),
            "VIT" => Ok(VIT),
            "VOL" => Ok(VOL),
            "VRO" => Ok(VRO),
            "WA" => Ok(WA),
            "WAG" => Ok(WAG),
            "WAR" => Ok(WAR),
            "WCR" => Ok(WCR),
            "WEL" => Ok(WEL),
            "WLN" => Ok(WLN),
            "WLF" => Ok(WLF),
            "WTM" => Ok(WTM),
            "XBD" => Ok(XBD),
            "XHS" => Ok(XHS),
            "XJB" => Ok(XJB),
            "XOG" => Ok(XOG),
            "XPE" => Ok(XPE),
            "YAK" => Ok(YAK),
            "YAO" => Ok(YAO),
            "YAP" => Ok(YAP),
            "YBA" => Ok(YBA),
            "YCR" => Ok(YCR),
            "YIC" => Ok(YIC),
            "YIM" => Ok(YIM),
            "ZEA" => Ok(ZEA),
            "ZGH" => Ok(ZGH),
            "ZHA" => Ok(ZHA),
            "ZHH" => Ok(ZHH),
            "ZHP" => Ok(ZHP),
            "ZHS" => Ok(ZHS),
            "ZHT" => Ok(ZHT),
            "ZND" => Ok(ZND),
            "ZUL" => Ok(ZUL),
            "ZZA" => Ok(ZZA),

            _ => Err(ParseError::from(
                CustomParseError::InvalidFontLanguageOverrideOpenTypeLanguageTag(tag.clone()),
            )),
        }
    }
}
