import * as React from 'react';
import { ThemedComponentClass } from '@friendsofreactjs/react-css-themr';
import { Action } from '../Labelled';
import { IStateProps } from '../Picker/AutoSuggestText';
import { IAutoSuggestMethods } from '../Picker/Picker';
export declare type Type = 'text' | 'email' | 'number' | 'password' | 'search' | 'tel' | 'url' | 'date' | 'datetime-local' | 'month' | 'time' | 'week';
export declare type ComponentHeight = 'slim' | 'large';
export declare type PlaceholderAlign = 'left' | 'right';
export interface State {
    height?: number | null;
    focused?: boolean;
    value?: string | undefined;
    onHover?: boolean;
}
export interface Props {
    autoSuggest?: boolean;
    autoSuggestMethods?: IAutoSuggestMethods;
    stateProps?: IStateProps;
    alphanumeric?: boolean;
    autoComplete?: boolean;
    autoFocus?: boolean;
    backdropHidden?: boolean;
    capital?: boolean;
    componentClass?: string;
    componentId?: string;
    componentStyle?: React.CSSProperties;
    connectedRight?: React.ReactNode;
    connectedLeft?: React.ReactNode;
    disabled?: boolean;
    enableTextCounter?: boolean;
    errors?: [string] | null;
    getErrors?(errors: any, name?: string): void;
    hasValue?: boolean;
    helpText?: React.ReactNode;
    itemSelected?: boolean;
    isFocused?: boolean;
    label?: string;
    labelAction?: Action;
    labelHidden?: boolean;
    loading?: boolean;
    max?: number;
    maxLength?: number;
    min?: number;
    minLength?: number;
    multiline?: boolean | number;
    name?: string;
    onChange?(value: string, e?: React.FormEvent<HTMLElement>): void;
    onFocus?(e?: React.FormEvent<HTMLElement>): void;
    onKeyDown?(e: React.FormEvent<HTMLElement> | KeyboardEvent): void;
    onBlur?(e?: React.FormEvent<HTMLElement>): void;
    onInput?(e?: React.ChangeEvent<HTMLSelectElement>): void;
    onKeyUp?(e: React.FormEvent<HTMLElement> | KeyboardEvent): void;
    pattern?: string;
    placeholder?: string;
    placeholderAlign?: PlaceholderAlign;
    prefix?: React.ReactNode;
    required?: boolean;
    readOnly?: boolean;
    resizable?: boolean;
    showNumberIcon?: boolean;
    suffix?: React.ReactNode;
    step?: number;
    spellCheck?: boolean;
    theme?: any;
    type: Type;
    value?: string;
    rows?: number;
    componentHeight?: ComponentHeight;
    markIfRequired?: boolean;
    fullWidth?: boolean;
}
declare class TextField extends React.PureComponent<Props, State> {
    state: State;
    private input;
    private prefixRef;
    constructor(props: Props);
    get labelComponentStyle(): {
        marginLeft?: undefined;
    } | {
        marginLeft: any;
    };
    UNSAFE_componentWillReceiveProps(nextProps: Props): void;
    render(): React.JSX.Element;
    private setInput;
    private handleNumberChange;
    private onChange;
    private handleInputOnFocus;
    private handleInputOnKeyDown;
    private handleInputOnBlur;
    private handleInputOnKeyUp;
    private handleInputFocus;
}
export { TextField as UnthemedTextField };
declare const _default: ThemedComponentClass<Props, State>;
export default _default;
