import * as React from 'react';
import { ThemedComponentClass } from '@friendsofreactjs/react-css-themr';
import { Props as LabelProps, Action, labelID } from '../Label';
export { Action, labelID };
export declare type Error = string;
export declare type Type = 'text' | 'email' | 'number' | 'password' | 'search' | 'tel' | 'url' | 'date' | 'datetime-local' | 'month' | 'time' | 'week';
export interface Props {
    autoSuggest?: boolean;
    componentId: LabelProps['componentId'];
    label: string;
    errors?: [string] | Error | null;
    action: LabelProps['action'];
    helpText?: React.ReactNode;
    disabled?: boolean;
    children?: React.ReactNode;
    labelHidden?: boolean;
    required?: boolean;
    focused?: boolean;
    hasValue?: boolean;
    componentStyle?: React.CSSProperties;
    labelComponentStyle?: React.CSSProperties;
    componentClass?: string;
    theme?: any;
    onClick?: (event: React.FormEvent<any>) => void;
    readOnly?: boolean;
    markIfRequired?: boolean;
    onHover?: boolean;
    fullWidth?: boolean;
    type?: Type;
}
export declare function errorID(id: string): string;
export declare function helpTextID(id: string): string;
declare const _default: ThemedComponentClass<Props, {}>;
export default _default;
