---
name: Caption
category: Titles and text
keywords:
  - labels
  - text
  - microcopy
  - typographic
  - graph
  - timestamp
  - smaller text
  - smallest text
  - smaller than reading size text
  - time text
  - compact text
  - small text
---

# Caption

Caption text size is smaller than the recommended size for general reading. It should be used only in a graph or as a timestamp in a list.

---

## Purpose

Put the merchant first by identifying the problem they face and the component that helps them solve it.

### Problem

Merchants need to understand a complex graphic or arrangement of content in a small area.

### Solution

Use smaller text for short labels on graphs or lists where space is limited.

---

## Best practices

- Use for secondary labels in graphs and charts
- May be used for timestamps in lists of content
- Don’t use this component for other cases
- Don’t use this component for text longer than a few words
- Don’t use this component for aesthetic effect or to break from the standard text size

---

## Content guidelines

### Captions

Captions are primarily used in data visualizations. Stick to a few words and don’t use this component for complete sentences or longer content.

<!-- usagelist -->
#### Do
* Use caption for labelling data visualizations

* Received April 21, 2017

#### Don’t
* Order #1001 was received on April 21, 2017
* This is your recent activity


| Prop | Type | Description |
| ---- | ---- | ----------- |
| children | React.ReactNode | The content to use as a graph label or timestamp |
| style | React.CSSProperties | Set the style via css |
| theme | any | Theme to be injected via css-themr |

## Examples

### Default caption

Use to provide details in situations where content is compact and space is tight.

```jsx
<List>
  <Item>Order #1001 <Caption>Received April 21, 2017</Caption></Item>
  <Item>Order #1002 <Caption>Received April 22, 2017</Caption></Item>
</List>
```