'use strict';

const blueprintHelpers = require('ember-cli-blueprint-test-helpers/helpers');
const setupTestHooks = blueprintHelpers.setupTestHooks;
const emberNew = blueprintHelpers.emberNew;
const emberGenerateDestroy = blueprintHelpers.emberGenerateDestroy;
const setupTestEnvironment = require('../helpers/setup-test-environment');
const chai = require('ember-cli-blueprint-test-helpers/chai');
const expect = chai.expect;

const enableOctane = setupTestEnvironment.enableOctane;
describe('Blueprint: component-class-addon', function () {
  enableOctane();
  setupTestHooks(this);

  describe('in addon', function () {
    beforeEach(function () {
      return emberNew({ target: 'addon' });
    });

    it('component-addon foo', function () {
      return emberGenerateDestroy(['component-class-addon', 'foo'], (_file) => {
        expect(_file('app/components/foo.js')).to.contain(
          "export { default } from 'my-addon/components/foo';"
        );
      });
    });
    it('component-addon foo-bar', function () {
      return emberGenerateDestroy(['component-class-addon', 'foo-bar'], (_file) => {
        expect(_file('app/components/foo-bar.js')).to.contain(
          "export { default } from 'my-addon/components/foo-bar';"
        );
      });
    });
  });
});
