<p align="center">
  <a href="https://emberjs.com"><img width="300" src="https://raw.githubusercontent.com/emberjs/website/master/source/images/brand/ember_Ember-Light.png"></a>
</p>

<p align="center">
  <a href="https://www.npmjs.com/package/ember-source"><img src="https://img.shields.io/npm/v/ember-source.svg?style=flat" alt="npm version"></a>
  <a href="https://github.com/emberjs/ember.js/actions?query=workflow%3ACI"><img src="https://github.com/emberjs/ember.js/workflows/CI/badge.svg" alt="CI Status"></a>
  <a href="https://codeclimate.com/github/emberjs/ember.js"><img src="https://codeclimate.com/github/emberjs/ember.js.svg" alt="Code Climate"></a>
  <a href="https://discord.gg/zT3asNS"><img src="https://img.shields.io/discord/480462759797063690.svg?logo=discord" alt="Discord Community Server"></a>
  <a href="https://help-wanted.emberjs.com/"><img src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg" alt="PRs Welcome"></a>
  <a href="https://github.com/emberjs/ember.js/blob/main/LICENSE"><img src="https://img.shields.io/badge/license-MIT-blue.svg" alt="GitHub license"></a>

</p>

**Ember.js** is a JavaScript framework that greatly reduces the time, effort and resources needed to build any web application. It is focused on making you, the developer, as productive as possible by doing all the common, repetitive, yet essential, tasks involved in most web development projects.

With Ember, you get all of these things:

* [**A Welcoming Community**](https://emberjs.com/community/) - Get the help you need, when you need it.
* [**An Enduring Foundation for your Apps**](https://en.wikipedia.org/wiki/Ember.js) - There are apps that used the first version of Ember almost a decade ago, and successfully still use Ember today.
* [**Reliability & Security**](https://emberjs.com/releases/) - With regular LTS Releases and 30 weeks of security fixes, you can rely on Ember.js to care about the stability [and security](https://emberjs.com/security/) of your app.
* [**Modern JavaScript**](https://guides.emberjs.com/release/upgrading/current-edition/) - Use modern JavaScript features that you're already familiar with like classes, decorators and generators.
* [**Documentation**](https://guides.emberjs.com) - Rely on top-notch documentation for each Ember version and a team that is focused on the documentation and learning experience.
* [**HTML-first Components**](https://guides.emberjs.com/release/components/introducing-components/) - Start with valid, semantic HTML in your components, and layer in the functionality that you need, as you need it.
* [**Routing**](https://guides.emberjs.com/release/routing/) - Ember routes respect URLs while layering in extra functionality like rendering templates, loading data models, handling actions, and conditionally redirecting. 
* [**Data Layer**](https://guides.emberjs.com/release/models/) - Ember Data is a powerful data management tool that comes with Ember apps by default. Want to use something else? We support that, too!
* [**Flexibility**](https://guides.emberjs.com/release/models/customizing-adapters/) Use _**any**_ backend stack with your Ember apps, thanks to the flexibility of adapters and serializers.
* [**Autotracking**](https://guides.emberjs.com/release/in-depth-topics/autotracking-in-depth/) - Ember's reactivity model makes it easier to decide what to automatically update, and when. 
* [**Zero Config Apps**](https://guides.emberjs.com/release/configuring-ember/) - With strong defaults, you may never need to configure anything in your app, but the options are there if you need it!
* [**Quality Addon Ecosystem**](https://emberobserver.com/) - high-quality, rated addons with the ability to [search by source code](https://emberobserver.com/code-search?codeQuery=task). Many require no additional configuration, making it easier than ever to supercharge your apps.



Find out more: 

- [Website](https://emberjs.com)
- [Guides](https://guides.emberjs.com)
- [API](https://emberjs.com/api)
- [Community](https://emberjs.com/community)
- [Blog](https://emberjs.com/blog)
- [Builds](https://emberjs.com/builds)

## Contributions

See [CONTRIBUTING.md](https://github.com/emberjs/ember.js/blob/main/CONTRIBUTING.md)

---

Cross-browser testing provided by <a href="http://browserstack.com">Browserstack</a>.
