/*
 * Copyright © 2017 Embedded Artistry LLC.
 * License: MIT. See LICENSE file for details.
 */

#include "stdlib_tests.h"
#include <inttypes.h>

// Cmocka needs these
// clang-format off
#include <setjmp.h>
#include <stdarg.h>
#include <stddef.h>
#include <cmocka.h>
// clang-format on

#pragma mark - Private Functions -
static struct
{
	intmax_t x, y, div, mod;
} t[] = {

	{2, 1, 2, 0},
	{4, 2, 2, 0},
	{5, 3, 1, 2},
	{9, 2, 4, 1},
	{10, 3, 3, 1},
	{19, 2, 9, 1},
	{15, 12, 1, 3},
	{11, 56, 0, 11},
	{22, 5, 4, 2},
	{25, 15, 1, 10},
	{29, 55, 0, 29},
	{27, 7, 3, 6},
	{22, 5, 4, 2},
	{25, 15, 1, 10},
	{29, 55, 0, 29},
	{27, 7, 3, 6},
	{88, 7, 12, 4},
	{99, 74, 1, 25},
	{77, 44, 1, 33},
	{66, 44, 1, 22},
	//

	{1000, 45, 22, 10},
	{3000, 5000, 0, 3000},
	{9000, 700, 12, 600},
	{4000, 70, 57, 10},
	{10000, 45, 222, 10},
	{97000, 78, 1243, 46},
	{55000, 555, 99, 55},
	{60000, 44, 1363, 28},
	{177000, 890, 198, 780},
	{155000, 454, 341, 186},
	{185000, 300000, 0, 185000},
	{650000, 1, 650000, 0},
	{900000, 55, 16363, 35},
	{905500, 343255, 2, 218990},
	{540000, 44, 12272, 32},
	{340000, 490, 693, 430},
	{9000000, 55, 163636, 20},
	{9055000, 343255, 26, 130370},
	{5400000, 44, 122727, 12},
	{3400000, 490, 6938, 380},

	//

	{12000000, 480900, 24, 458400},
	{62000000, 900, 68888, 800},
	{55000000, 234234, 234, 189244},
	{31006000, 78678, 394, 6868},
	{99006000, 876876877, 0, 99006000},
	{66006000, 543453543, 0, 66006000},
	{33306000, 231231231, 0, 33306000},
	{73306000, 555656566, 0, 73306000},
	{53306000, 1, 53306000, 0},
	{78906000, 8, 9863250, 0},
	{12906000, 3, 4302000, 0},
	{19606000, 15, 1307066, 10},
	{59606000, 23606000, 2, 12394000},
	{83606000, 15606000, 5, 5576000},
	{63606000, 22606000, 2, 18394000},
	{99806000, 55606000, 1, 44200000},
	{4, 55606000, 0, 4},
	{6, 44606000, 0, 6},
	{9, 99606000, 0, 9},
	{13, 12606000, 0, 13},

	//

	{512606000, -12606000, -40, 8366000},
	{658606000, -76876876, -8, 43590992},
	{904606000, -43543524, -20, 33735520},
	{231606000, -234234235, -0, 231606000},
	{789606000, -465514355, -1, 324091645},
	{987606000, -835345345, -1, 152260655},
	{123606000, -345345345, 0, 123606000},
	{593606000, -1298243934, 0, 593606000},
	{2147483647, -345345345, -6, 75411577},
	{1147483647, -21321313, -53, 17454058},
	{2100000000, -423432, -4959, 200712},
	{2023456789, -999999999, -2, 23456791},
	{4, -2023456789, 0, 4},
	{6, -1023456789, 0, 6},
	{9, -1000456789, 0, 9},
	{13, -2000456700, 0, 13},
	{2023456789, -4, -505864197, 1},
	{1023456789, -6, -170576131, 3},
	{1000456789, -9, -111161865, 4},
	{2000456700, -13, -153881284, 8},
	//

	{0x47811fa5f00f74d, 0x3d98e7d3fcd5d5c5, 0x0, 0x47811fa5f00f74d},
	{0x51ffcc7cdc989d43, 0x36be8bd6746b70e4, 0x1, 0x1b4140a6682d2c5f},
	{0x57bf9128512fe829, 0x197b3858155d498d, 0x3, 0xb4de82011180b82},
	{0x4ed5264cf7092ec5, 0xde40d1e15ef3e74, 0x5, 0x960e4b6895cf681},
	{0x6b93ffce49f1a4b3, 0x3583d1f9702ee03, 0x20, 0x8c5bdb6993e453},
	{0x138aefcc98ce5d19, 0x117002fa7600b11, 0x11, 0x103eca27b6da0f8},
	{0x71c4b06e463912b5, 0x1c286ad9e8f5229, 0x40, 0x1230506a2648875},
	{0x1428f04bd490ea11, 0x9d97f29a897c93, 0x20, 0x75f1f8836157b1},
	{0x35256c76832705a7, 0xa962f1a447dcd7, 0x50, 0x3680f32cb20277},
	{0x2969e82bd9347f2d, 0x723d68574d4156, 0x5c, 0x5bd6ac79710445},
	{0x695b8d33ef342e09, 0x3ed1fe1a998fe3, 0x1ad, 0x15a6615bde0ea2},
	{0x46b4dd1e06367a5f, 0xa04e70622e4e8, 0x70e, 0x64750bc0b9daf},
	{0x1e59cc2ac508f85b, 0xeb15ae6d4d7f9, 0x210, 0xc00aeae0b86cb},
	{0x296f8d2c76a0901, 0xf65628b31b01, 0x2b0, 0xf14566117651},
	{0x7036f5ad7cbc5e17, 0xa09d3bfcf72cf, 0xb2d, 0x72236db564ab4},
	{0x27a2e280bcf990cf, 0x389aa0c0b0cc0, 0xb34, 0x9d71d12eb9cf},
	{0x1e032f04a5372e95, 0x63c2a1d58710, 0x4d04, 0x154ce4414255},
	{0x3a1a5659908495cb, 0x279dcd85418a, 0x17775, 0x132c6f9c7bb9},
	{0x269f4f4baaaf287, 0x1aed2ad9daf0, 0x16f3, 0x426550f80b7},
	{0x6700daeeb87a770d, 0xeca7ab1aa93, 0x6f6c5, 0x70d9466f1ee},
	{0x7a08fe1d98b4dae1, 0x6bced9c0c15, 0x121c89, 0x40c856617a4},
	{0x34435992a5c9c2f7, 0x4f4a94c109f, 0xa8bc9, 0x94c5d46120},
	{0x6fd0027468f1dcfd, 0x597186b0153, 0x140060, 0x16f26555ddd},
	{0x4fe37c1db1619a73, 0x47a0c30bd15, 0x11d861, 0x5964fb3d7e},
	{0x77aa77f86d07c8d9, 0x3a39cf03d65, 0x20e21c, 0x37f7fede7cd},
	{0x160e34cf590444ab, 0xe2388f12fe, 0x18f574, 0xc303329393},
	{0x2509ddea3a648dd1, 0xec762d81bc, 0x281955, 0xc0463d1e65},
	{0x1dd4fe261b4adeed, 0x2736e25406, 0xc2bfef, 0x1354c1f353},
	{0x480258f92fc38de3, 0x2599b52bb0, 0x1ea450c, 0x2879f11a3},
	{0x5a3257b1114109c9, 0x2978f9f1aa, 0x22cc30a, 0x1317311b25},
	{0x3c2c319ca8612a65, 0x73fc01ece, 0x84d0088, 0x3165accf5},
	{0x4f6034e74a16561b, 0x1f29d53707, 0x28c0daa, 0xd88e07075},
	{0x206665a7072f1cc1, 0xda87e7cea, 0x25f48c1, 0xd3ddb2057},
	{0x100c559d7db417d7, 0xb907ebbc2, 0x1634188, 0xa2eae16c7},
	{0x64c5f83691b47cdd, 0x5aced6ebb, 0x11c17fb7, 0x344109030},
	{0x32a812777eaf7d53, 0x1cb63fe4f, 0x1c3a9675, 0xb113f938},
	{0x67478d96865ca6b9, 0x142fa03a, 0x51dcb463d, 0x11359ce7},
	{0x71024e740deb428f, 0x142d3885, 0x599d9edd5, 0x13b1ae6},
	{0x52c78160b090b655, 0xd02101c6, 0x65d1b205, 0x1c0a0177},
	{0x16917d5f9fde38b, 0xfb1566c7, 0x17029e0, 0x1bbe166b},
	{0x74babc1be2ed9c47, 0x22eda9a6, 0x3578b1967, 0x189b247d},
	{0x7c5cbf2dfc1db6cd, 0x5f09c060, 0x14efd44d4, 0x5210e74d},
	{0x7c046071c1ac68c3, 0x3696c8e6, 0x24596d86b, 0x26060a1},
	{0x3f4c0514b0df5e45, 0xf2c3810, 0x42bf84d39, 0x3aa12b5},
	{0x23fb9839e8358cbd, 0x24deb54, 0xf9d714151, 0xb9c329},
	{0x2005d5de30015033, 0x47c06db, 0x7240bccba, 0x104d115},
	{0x67d59c29e076f499, 0x179f009, 0x465554ac22, 0x10b0767},
	{0x32d2dd34369c836f, 0x13d3fbf, 0x2902f2fb54, 0x7553c3},
	{0x3960c3c99fdc2235, 0x1b808ba, 0x21618743cd, 0x11e7743},
	{0x343bad5adfa9726b, 0xeef444, 0x37f58c51a6, 0x3d8a53},
	{0x7a4aadd7b4e5f191, 0x129c9, 0x6921bb5a2a53, 0x6b66},
	{0x1b285999316afead, 0x115477, 0x1912cf6611e, 0x801bb},
	{0x18e6a86b0473a589, 0x50a12, 0x4f0fabc67d4, 0x210a1},
	{0xffd2ad0e77b73db, 0x146f14, 0xc8500600a3, 0xba1f},
	{0x76743abdfb91f081, 0xd5888, 0x8e0303c479c, 0x245a1},
	{0x63cc9c23f0ed0c9d, 0x6c1e5, 0xec4d5841041, 0x38178},
	{0x7ad70f846e8f1313, 0x7fdf5, 0xf5ecec69bc9, 0x756b6},
	{0x60de3d71574eb279, 0x6ea3, 0xe02421997a61, 0x18b6},
	{0x227f92ef6daab68d, 0x15ec, 0x192dda5d5ed25, 0xf71},
	{0x2e588bdb751a66bf, 0x229c, 0x156d025c70d97, 0x10bb},
	{0x60ab67a4e5aeabb, 0x1bf7, 0x374f26f3e3ed, 0x210},
	{0x224f627be76a8261, 0x4f4, 0x6ed4d3882b567, 0x35},
	{0x300d1ab91bd0b677, 0xe9c, 0x34a002fb76e63, 0x823},
	{0x2a63d80e0c52fc7d, 0x32, 0xd90970ebc4383f, 0x2f},
	{0x2b5dc22562dbe059, 0x30a, 0xe45055015fff5, 0x1c7},
	{0x4a7fd1078807d52f, 0x18d, 0x300a32f60677d4, 0x16b},
	{0x41a01ee8ab0849f5, 0x13c, 0x352a3971f57e9d, 0x29},
	{0x723bacc76bd51551, 0x16, 0x53142091089af83, 0xf},
	{0x11593d6b3f54de6d, 0x63, 0x2cdc6b1a7f9078, 0x5},
	{0x756c82d6f7069963, 0x5c, 0x146bea3ba565525, 0x17},
	{0x6884fa0a8f0c99e5, 0x12, 0x5ce7fab40d6088c, 0xd},
	{0x5052a2953c528441, 0x7, 0xb7984f0bf79809b, 0x4},
	{0x58dd1583185ecb57, 0x9, 0x9dfad0e90ee1697, 0x8},
	{0x4b21d01617167e39, 0x2, 0x2590e80b0b8b3f1c, 0x1},

};
static void imaxdiv_test(void** state)
{
	intmax_t x, y, div, mod;
	size_t i;

	for(i = 0; i < (sizeof(t) / sizeof(*t)); i++)
	{
		x = t[i].x;
		y = t[i].y;
		div = x / y;
		mod = x % y;
		assert_true(div == t[i].div);
		assert_true(mod == t[i].mod);
	}
}

#pragma mark - Public Functions -

int imaxdiv_tests(void)
{
	const struct CMUnitTest imaxdiv_tests[] = {cmocka_unit_test(imaxdiv_test)};

	return cmocka_run_group_tests(imaxdiv_tests, NULL, NULL);
}
