/*
 * Copyright © 2017 Embedded Artistry LLC.
 * License: MIT. See LICENSE file for details.
 */

#include "stdlib_tests.h"
#include <stdlib.h>

// Cmocka needs these
// clang-format off
#include <setjmp.h>
#include <stdarg.h>
#include <stddef.h>
#include <cmocka.h>
// clang-format on

// TODO: div is not being properly tested

static struct
{
	int x, y, div, mod;
} t[] = {

	{2, 1, 2, 0},
	{4, 2, 2, 0},
	{5, 3, 1, 2},
	{9, 2, 4, 1},

	{10, 3, 3, 1},
	{19, 2, 9, 1},
	{15, 12, 1, 3},
	{11, 56, 0, 11},

	{22, 5, 4, 2},
	{25, 15, 1, 10},
	{29, 55, 0, 29},
	{27, 7, 3, 6},

	{22, 5, 4, 2},
	{25, 15, 1, 10},
	{29, 55, 0, 29},
	{27, 7, 3, 6},

	{88, 7, 12, 4},
	{99, 74, 1, 25},
	{77, 44, 1, 33},
	{66, 44, 1, 22},
	//

	{1000, 45, 22, 10},
	{3000, 5000, 0, 3000},
	{9000, 700, 12, 600},
	{4000, 70, 57, 10},

	{10000, 45, 222, 10},
	{97000, 78, 1243, 46},
	{55000, 555, 99, 55},
	{60000, 44, 1363, 28},

	{177000, 890, 198, 780},
	{155000, 454, 341, 186},
	{185000, 300000, 0, 185000},
	{650000, 1, 650000, 0},

	{900000, 55, 16363, 35},
	{905500, 343255, 2, 218990},
	{540000, 44, 12272, 32},
	{340000, 490, 693, 430},

	{9000000, 55, 163636, 20},
	{9055000, 343255, 26, 130370},
	{5400000, 44, 122727, 12},
	{3400000, 490, 6938, 380},

	//

	{12000000, 480900, 24, 458400},
	{62000000, 900, 68888, 800},
	{55000000, 234234, 234, 189244},
	{31006000, 78678, 394, 6868},

	{99006000, 876876877, 0, 99006000},
	{66006000, 543453543, 0, 66006000},
	{33306000, 231231231, 0, 33306000},
	{73306000, 555656566, 0, 73306000},

	{53306000, 1, 53306000, 0},
	{78906000, 8, 9863250, 0},
	{12906000, 3, 4302000, 0},
	{19606000, 15, 1307066, 10},

	{59606000, 23606000, 2, 12394000},
	{83606000, 15606000, 5, 5576000},
	{63606000, 22606000, 2, 18394000},
	{99806000, 55606000, 1, 44200000},

	{4, 55606000, 0, 4},
	{6, 44606000, 0, 6},
	{9, 99606000, 0, 9},
	{13, 12606000, 0, 13},

	//

	{512606000, -12606000, -40, 8366000},
	{658606000, -76876876, -8, 43590992},
	{904606000, -43543524, -20, 33735520},
	{231606000, -234234235, -0, 231606000},

	{789606000, -465514355, -1, 324091645},
	{987606000, -835345345, -1, 152260655},
	{123606000, -345345345, 0, 123606000},
	{593606000, -1298243934, 0, 593606000},

	{2147483647, -345345345, -6, 75411577},
	{1147483647, -21321313, -53, 17454058},
	{2100000000, -423432, -4959, 200712},
	{2023456789, -999999999, -2, 23456791},

	{4, -2023456789, 0, 4},
	{6, -1023456789, 0, 6},
	{9, -1000456789, 0, 9},
	{13, -2000456700, 0, 13},

	{2023456789, -4, -505864197, 1},
	{1023456789, -6, -170576131, 3},
	{1000456789, -9, -111161865, 4},
	{2000456700, -13, -153881284, 8},

};

#pragma mark - Private Functions -

static void div_test(void** __attribute__((unused)) state)
{
	int x, y, div, mod;
	size_t i;

	for(i = 0; i < (sizeof(t) / sizeof(*t)); i++)
	{
		x = t[i].x;
		y = t[i].y;
		div = x / y;
		mod = x % y;
		assert_true(div == t[i].div);
		assert_true(mod == t[i].mod);
	}
}

#pragma mark - Public Functions -

int div_tests(void)
{
	const struct CMUnitTest div_tests[] = {cmocka_unit_test(div_test)};

	return cmocka_run_group_tests(div_tests, NULL, NULL);
}
